// Compiled by ClojureScript 1.7.48 {}
goog.provide('schema.core');
goog.require('cljs.core');
goog.require('schema.spec.collection');
goog.require('schema.spec.core');
goog.require('schema.spec.variant');
goog.require('schema.spec.leaf');
goog.require('clojure.string');
goog.require('schema.utils');

schema.core.Schema = {};

/**
 * A spec is a record of some type that expresses the structure of this schema
 * in a declarative and/or imperative way.  See schema.spec.* for examples.
 */
schema.core.spec = (function schema$core$spec(this$){
if((!((this$ == null))) && (!((this$.schema$core$Schema$spec$arity$1 == null)))){
return this$.schema$core$Schema$spec$arity$1(this$);
} else {
var x__19125__auto__ = (((this$ == null))?null:this$);
var m__19126__auto__ = (schema.core.spec[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,this$);
} else {
var m__19126__auto____$1 = (schema.core.spec["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"Schema.spec",this$);
}
}
}
});

/**
 * Expand this schema to a human-readable format suitable for pprinting,
 * also expanding class schematas at the leaves.  Example:
 * 
 * user> (s/explain {:a s/Keyword :b [s/Int]} )
 * {:a Keyword, :b [Int]}
 */
schema.core.explain = (function schema$core$explain(this$){
if((!((this$ == null))) && (!((this$.schema$core$Schema$explain$arity$1 == null)))){
return this$.schema$core$Schema$explain$arity$1(this$);
} else {
var x__19125__auto__ = (((this$ == null))?null:this$);
var m__19126__auto__ = (schema.core.explain[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,this$);
} else {
var m__19126__auto____$1 = (schema.core.explain["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"Schema.explain",this$);
}
}
}
});

/**
 * Compile an efficient checker for schema, which returns nil for valid values and
 * error descriptions otherwise.
 */
schema.core.checker = (function schema$core$checker(schema__$1){
return cljs.core.comp.call(null,schema.utils.error_val,schema.spec.core.run_checker.call(null,(function (s,params){
return schema.spec.core.checker.call(null,schema.core.spec.call(null,s),params);
}),false,schema__$1));
});
/**
 * Return nil if x matches schema; otherwise, returns a value that looks like the
 * 'bad' parts of x with ValidationErrors at the leaves describing the failures.
 * 
 * If you will be checking many datums, it is much more efficient to create
 * a 'checker' once and call it on each of them.
 */
schema.core.check = (function schema$core$check(schema__$1,x){
return schema.core.checker.call(null,schema__$1).call(null,x);
});
/**
 * Compile an efficient validator for schema.
 */
schema.core.validator = (function schema$core$validator(schema__$1){
var c = schema.core.checker.call(null,schema__$1);
return ((function (c){
return (function (value){
var temp__4425__auto___55316 = c.call(null,value);
if(cljs.core.truth_(temp__4425__auto___55316)){
var error_55317 = temp__4425__auto___55316;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Value does not match schema: %s",cljs.core.pr_str.call(null,error_55317)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),schema__$1,new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"error","error",-978969032),error_55317], null));
} else {
}

return value;
});
;})(c))
});
/**
 * Throw an exception if value does not satisfy schema; otherwise, return value.
 * If you will be validating many datums, it is much more efficient to create
 * a 'validator' once and call it on each of them.
 */
schema.core.validate = (function schema$core$validate(schema__$1,value){
return schema.core.validator.call(null,schema__$1).call(null,value);
});
schema.core.instance_precondition = (function schema$core$instance_precondition(s,klass){
return schema.spec.core.precondition.call(null,s,(function (p1__55318_SHARP_){
var and__18477__auto__ = !((p1__55318_SHARP_ == null));
if(and__18477__auto__){
var or__18489__auto__ = (klass === p1__55318_SHARP_.constructor);
if(or__18489__auto__){
return or__18489__auto__;
} else {
return p1__55318_SHARP_ instanceof klass;
}
} else {
return and__18477__auto__;
}
}),(function (p1__55319_SHARP_){
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,p1__55319_SHARP_),klass),new cljs.core.Symbol(null,"instance?","instance?",1075939923,null));
}));
});
(schema.core.Schema["function"] = true);

(schema.core.spec["function"] = (function (this$){
var pre = schema.core.instance_precondition.call(null,this$,this$);
var temp__4423__auto__ = schema.utils.class_schema.call(null,this$);
if(cljs.core.truth_(temp__4423__auto__)){
var class_schema = temp__4423__auto__;
return schema.spec.variant.variant_spec.call(null,pre,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),class_schema], null)], null));
} else {
return schema.spec.leaf.leaf_spec.call(null,pre);
}
}));

(schema.core.explain["function"] = (function (this$){
var temp__4423__auto__ = schema.utils.class_schema.call(null,this$);
if(cljs.core.truth_(temp__4423__auto__)){
var more_schema = temp__4423__auto__;
return schema.core.explain.call(null,more_schema);
} else {
var pred__55320 = cljs.core._EQ_;
var expr__55321 = this$;
if(cljs.core.truth_(pred__55320.call(null,null,expr__55321))){
return new cljs.core.Symbol(null,"Str","Str",907970895,null);
} else {
if(cljs.core.truth_(pred__55320.call(null,Boolean,expr__55321))){
return new cljs.core.Symbol(null,"Bool","Bool",195910502,null);
} else {
if(cljs.core.truth_(pred__55320.call(null,Number,expr__55321))){
return new cljs.core.Symbol(null,"Num","Num",-2044934708,null);
} else {
if(cljs.core.truth_(pred__55320.call(null,null,expr__55321))){
return new cljs.core.Symbol(null,"Regex","Regex",205914413,null);
} else {
if(cljs.core.truth_(pred__55320.call(null,Date,expr__55321))){
return new cljs.core.Symbol(null,"Inst","Inst",292408622,null);
} else {
if(cljs.core.truth_(pred__55320.call(null,cljs.core.UUID,expr__55321))){
return new cljs.core.Symbol(null,"Uuid","Uuid",-1866694318,null);
} else {
return this$;
}
}
}
}
}
}
}
}));

/**
* @constructor
* @param {*} _
* @param {*} __meta
* @param {*} __extmap
* @param {*} __hash
* @param {*=} __meta 
* @param {*=} __extmap
* @param {number|null} __hash
*/
schema.core.AnythingSchema = (function (_,__meta,__extmap,__hash){
this._ = _;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.AnythingSchema.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__19084__auto__,k__19085__auto__){
var self__ = this;
var this__19084__auto____$1 = this;
return cljs.core._lookup.call(null,this__19084__auto____$1,k__19085__auto__,null);
});

schema.core.AnythingSchema.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__19086__auto__,k55324,else__19087__auto__){
var self__ = this;
var this__19086__auto____$1 = this;
var G__55326 = (((k55324 instanceof cljs.core.Keyword))?k55324.fqn:null);
switch (G__55326) {
case "_":
return self__._;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k55324,else__19087__auto__);

}
});

schema.core.AnythingSchema.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__19098__auto__,writer__19099__auto__,opts__19100__auto__){
var self__ = this;
var this__19098__auto____$1 = this;
var pr_pair__19101__auto__ = ((function (this__19098__auto____$1){
return (function (keyval__19102__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,cljs.core.pr_writer,""," ","",opts__19100__auto__,keyval__19102__auto__);
});})(this__19098__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,pr_pair__19101__auto__,"#schema.core.AnythingSchema{",", ","}",opts__19100__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"_","_",1453416199),self__._],null))], null),self__.__extmap));
});

schema.core.AnythingSchema.prototype.cljs$core$IIterable$ = true;

schema.core.AnythingSchema.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__55323){
var self__ = this;
var G__55323__$1 = this;
return (new cljs.core.RecordIter((0),G__55323__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"_","_",1453416199)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

schema.core.AnythingSchema.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__19082__auto__){
var self__ = this;
var this__19082__auto____$1 = this;
return self__.__meta;
});

schema.core.AnythingSchema.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__19078__auto__){
var self__ = this;
var this__19078__auto____$1 = this;
return (new schema.core.AnythingSchema(self__._,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.AnythingSchema.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__19088__auto__){
var self__ = this;
var this__19088__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.AnythingSchema.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__19079__auto__){
var self__ = this;
var this__19079__auto____$1 = this;
var h__18905__auto__ = self__.__hash;
if(!((h__18905__auto__ == null))){
return h__18905__auto__;
} else {
var h__18905__auto____$1 = cljs.core.hash_imap.call(null,this__19079__auto____$1);
self__.__hash = h__18905__auto____$1;

return h__18905__auto____$1;
}
});

schema.core.AnythingSchema.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__19080__auto__,other__19081__auto__){
var self__ = this;
var this__19080__auto____$1 = this;
if(cljs.core.truth_((function (){var and__18477__auto__ = other__19081__auto__;
if(cljs.core.truth_(and__18477__auto__)){
var and__18477__auto____$1 = (this__19080__auto____$1.constructor === other__19081__auto__.constructor);
if(and__18477__auto____$1){
return cljs.core.equiv_map.call(null,this__19080__auto____$1,other__19081__auto__);
} else {
return and__18477__auto____$1;
}
} else {
return and__18477__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.AnythingSchema.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__19093__auto__,k__19094__auto__){
var self__ = this;
var this__19093__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"_","_",1453416199),null], null), null),k__19094__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__19093__auto____$1),self__.__meta),k__19094__auto__);
} else {
return (new schema.core.AnythingSchema(self__._,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__19094__auto__)),null));
}
});

schema.core.AnythingSchema.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__19091__auto__,k__19092__auto__,G__55323){
var self__ = this;
var this__19091__auto____$1 = this;
var pred__55327 = cljs.core.keyword_identical_QMARK_;
var expr__55328 = k__19092__auto__;
if(cljs.core.truth_(pred__55327.call(null,new cljs.core.Keyword(null,"_","_",1453416199),expr__55328))){
return (new schema.core.AnythingSchema(G__55323,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.AnythingSchema(self__._,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__19092__auto__,G__55323),null));
}
});

schema.core.AnythingSchema.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__19096__auto__){
var self__ = this;
var this__19096__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"_","_",1453416199),self__._],null))], null),self__.__extmap));
});

schema.core.AnythingSchema.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__19083__auto__,G__55323){
var self__ = this;
var this__19083__auto____$1 = this;
return (new schema.core.AnythingSchema(self__._,G__55323,self__.__extmap,self__.__hash));
});

schema.core.AnythingSchema.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__19089__auto__,entry__19090__auto__){
var self__ = this;
var this__19089__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__19090__auto__)){
return cljs.core._assoc.call(null,this__19089__auto____$1,cljs.core._nth.call(null,entry__19090__auto__,(0)),cljs.core._nth.call(null,entry__19090__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__19089__auto____$1,entry__19090__auto__);
}
});

schema.core.AnythingSchema.prototype.schema$core$Schema$ = true;

schema.core.AnythingSchema.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.leaf.leaf_spec.call(null,schema.spec.core._PLUS_no_precondition_PLUS_);
});

schema.core.AnythingSchema.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.Symbol(null,"Any","Any",1277492269,null);
});

schema.core.AnythingSchema.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null)], null);
});

schema.core.AnythingSchema.cljs$lang$type = true;

schema.core.AnythingSchema.cljs$lang$ctorPrSeq = (function (this__19118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/AnythingSchema");
});

schema.core.AnythingSchema.cljs$lang$ctorPrWriter = (function (this__19118__auto__,writer__19119__auto__){
return cljs.core._write.call(null,writer__19119__auto__,"schema.core/AnythingSchema");
});

schema.core.__GT_AnythingSchema = (function schema$core$__GT_AnythingSchema(_){
return (new schema.core.AnythingSchema(_,null,null,null));
});

schema.core.map__GT_AnythingSchema = (function schema$core$map__GT_AnythingSchema(G__55325){
return (new schema.core.AnythingSchema(new cljs.core.Keyword(null,"_","_",1453416199).cljs$core$IFn$_invoke$arity$1(G__55325),null,cljs.core.dissoc.call(null,G__55325,new cljs.core.Keyword(null,"_","_",1453416199)),null));
});

/**
 * Any value, including nil.
 */
schema.core.Any = (new schema.core.AnythingSchema(null,null,null,null));

/**
* @constructor
* @param {*} v
* @param {*} __meta
* @param {*} __extmap
* @param {*} __hash
* @param {*=} __meta 
* @param {*=} __extmap
* @param {number|null} __hash
*/
schema.core.EqSchema = (function (v,__meta,__extmap,__hash){
this.v = v;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.EqSchema.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__19084__auto__,k__19085__auto__){
var self__ = this;
var this__19084__auto____$1 = this;
return cljs.core._lookup.call(null,this__19084__auto____$1,k__19085__auto__,null);
});

schema.core.EqSchema.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__19086__auto__,k55334,else__19087__auto__){
var self__ = this;
var this__19086__auto____$1 = this;
var G__55336 = (((k55334 instanceof cljs.core.Keyword))?k55334.fqn:null);
switch (G__55336) {
case "v":
return self__.v;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k55334,else__19087__auto__);

}
});

schema.core.EqSchema.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__19098__auto__,writer__19099__auto__,opts__19100__auto__){
var self__ = this;
var this__19098__auto____$1 = this;
var pr_pair__19101__auto__ = ((function (this__19098__auto____$1){
return (function (keyval__19102__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,cljs.core.pr_writer,""," ","",opts__19100__auto__,keyval__19102__auto__);
});})(this__19098__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,pr_pair__19101__auto__,"#schema.core.EqSchema{",", ","}",opts__19100__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"v","v",21465059),self__.v],null))], null),self__.__extmap));
});

schema.core.EqSchema.prototype.cljs$core$IIterable$ = true;

schema.core.EqSchema.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__55333){
var self__ = this;
var G__55333__$1 = this;
return (new cljs.core.RecordIter((0),G__55333__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"v","v",21465059)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

schema.core.EqSchema.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__19082__auto__){
var self__ = this;
var this__19082__auto____$1 = this;
return self__.__meta;
});

schema.core.EqSchema.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__19078__auto__){
var self__ = this;
var this__19078__auto____$1 = this;
return (new schema.core.EqSchema(self__.v,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.EqSchema.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__19088__auto__){
var self__ = this;
var this__19088__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.EqSchema.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__19079__auto__){
var self__ = this;
var this__19079__auto____$1 = this;
var h__18905__auto__ = self__.__hash;
if(!((h__18905__auto__ == null))){
return h__18905__auto__;
} else {
var h__18905__auto____$1 = cljs.core.hash_imap.call(null,this__19079__auto____$1);
self__.__hash = h__18905__auto____$1;

return h__18905__auto____$1;
}
});

schema.core.EqSchema.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__19080__auto__,other__19081__auto__){
var self__ = this;
var this__19080__auto____$1 = this;
if(cljs.core.truth_((function (){var and__18477__auto__ = other__19081__auto__;
if(cljs.core.truth_(and__18477__auto__)){
var and__18477__auto____$1 = (this__19080__auto____$1.constructor === other__19081__auto__.constructor);
if(and__18477__auto____$1){
return cljs.core.equiv_map.call(null,this__19080__auto____$1,other__19081__auto__);
} else {
return and__18477__auto____$1;
}
} else {
return and__18477__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.EqSchema.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__19093__auto__,k__19094__auto__){
var self__ = this;
var this__19093__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"v","v",21465059),null], null), null),k__19094__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__19093__auto____$1),self__.__meta),k__19094__auto__);
} else {
return (new schema.core.EqSchema(self__.v,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__19094__auto__)),null));
}
});

schema.core.EqSchema.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__19091__auto__,k__19092__auto__,G__55333){
var self__ = this;
var this__19091__auto____$1 = this;
var pred__55337 = cljs.core.keyword_identical_QMARK_;
var expr__55338 = k__19092__auto__;
if(cljs.core.truth_(pred__55337.call(null,new cljs.core.Keyword(null,"v","v",21465059),expr__55338))){
return (new schema.core.EqSchema(G__55333,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.EqSchema(self__.v,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__19092__auto__,G__55333),null));
}
});

schema.core.EqSchema.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__19096__auto__){
var self__ = this;
var this__19096__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"v","v",21465059),self__.v],null))], null),self__.__extmap));
});

schema.core.EqSchema.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__19083__auto__,G__55333){
var self__ = this;
var this__19083__auto____$1 = this;
return (new schema.core.EqSchema(self__.v,G__55333,self__.__extmap,self__.__hash));
});

schema.core.EqSchema.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__19089__auto__,entry__19090__auto__){
var self__ = this;
var this__19089__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__19090__auto__)){
return cljs.core._assoc.call(null,this__19089__auto____$1,cljs.core._nth.call(null,entry__19090__auto__,(0)),cljs.core._nth.call(null,entry__19090__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__19089__auto____$1,entry__19090__auto__);
}
});

schema.core.EqSchema.prototype.schema$core$Schema$ = true;

schema.core.EqSchema.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.leaf.leaf_spec.call(null,schema.spec.core.precondition.call(null,this$__$1,((function (this$__$1){
return (function (p1__55331_SHARP_){
return cljs.core._EQ_.call(null,self__.v,p1__55331_SHARP_);
});})(this$__$1))
,((function (this$__$1){
return (function (p1__55332_SHARP_){
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,p1__55332_SHARP_),self__.v),new cljs.core.Symbol(null,"=","=",-1501502141,null));
});})(this$__$1))
));
});

schema.core.EqSchema.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,self__.v),new cljs.core.Symbol(null,"eq","eq",1021992460,null));
});

schema.core.EqSchema.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null);
});

schema.core.EqSchema.cljs$lang$type = true;

schema.core.EqSchema.cljs$lang$ctorPrSeq = (function (this__19118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/EqSchema");
});

schema.core.EqSchema.cljs$lang$ctorPrWriter = (function (this__19118__auto__,writer__19119__auto__){
return cljs.core._write.call(null,writer__19119__auto__,"schema.core/EqSchema");
});

schema.core.__GT_EqSchema = (function schema$core$__GT_EqSchema(v){
return (new schema.core.EqSchema(v,null,null,null));
});

schema.core.map__GT_EqSchema = (function schema$core$map__GT_EqSchema(G__55335){
return (new schema.core.EqSchema(new cljs.core.Keyword(null,"v","v",21465059).cljs$core$IFn$_invoke$arity$1(G__55335),null,cljs.core.dissoc.call(null,G__55335,new cljs.core.Keyword(null,"v","v",21465059)),null));
});

/**
 * A value that must be (= v).
 */
schema.core.eq = (function schema$core$eq(v){
return (new schema.core.EqSchema(v,null,null,null));
});

/**
* @constructor
* @param {*} h
* @param {*} parent
* @param {*} __meta
* @param {*} __extmap
* @param {*} __hash
* @param {*=} __meta 
* @param {*=} __extmap
* @param {number|null} __hash
*/
schema.core.Isa = (function (h,parent,__meta,__extmap,__hash){
this.h = h;
this.parent = parent;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.Isa.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__19084__auto__,k__19085__auto__){
var self__ = this;
var this__19084__auto____$1 = this;
return cljs.core._lookup.call(null,this__19084__auto____$1,k__19085__auto__,null);
});

schema.core.Isa.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__19086__auto__,k55344,else__19087__auto__){
var self__ = this;
var this__19086__auto____$1 = this;
var G__55346 = (((k55344 instanceof cljs.core.Keyword))?k55344.fqn:null);
switch (G__55346) {
case "h":
return self__.h;

break;
case "parent":
return self__.parent;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k55344,else__19087__auto__);

}
});

schema.core.Isa.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__19098__auto__,writer__19099__auto__,opts__19100__auto__){
var self__ = this;
var this__19098__auto____$1 = this;
var pr_pair__19101__auto__ = ((function (this__19098__auto____$1){
return (function (keyval__19102__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,cljs.core.pr_writer,""," ","",opts__19100__auto__,keyval__19102__auto__);
});})(this__19098__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,pr_pair__19101__auto__,"#schema.core.Isa{",", ","}",opts__19100__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parent","parent",-878878779),self__.parent],null))], null),self__.__extmap));
});

schema.core.Isa.prototype.cljs$core$IIterable$ = true;

schema.core.Isa.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__55343){
var self__ = this;
var G__55343__$1 = this;
return (new cljs.core.RecordIter((0),G__55343__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h","h",1109658740),new cljs.core.Keyword(null,"parent","parent",-878878779)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

schema.core.Isa.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__19082__auto__){
var self__ = this;
var this__19082__auto____$1 = this;
return self__.__meta;
});

schema.core.Isa.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__19078__auto__){
var self__ = this;
var this__19078__auto____$1 = this;
return (new schema.core.Isa(self__.h,self__.parent,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.Isa.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__19088__auto__){
var self__ = this;
var this__19088__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.Isa.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__19079__auto__){
var self__ = this;
var this__19079__auto____$1 = this;
var h__18905__auto__ = self__.__hash;
if(!((h__18905__auto__ == null))){
return h__18905__auto__;
} else {
var h__18905__auto____$1 = cljs.core.hash_imap.call(null,this__19079__auto____$1);
self__.__hash = h__18905__auto____$1;

return h__18905__auto____$1;
}
});

schema.core.Isa.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__19080__auto__,other__19081__auto__){
var self__ = this;
var this__19080__auto____$1 = this;
if(cljs.core.truth_((function (){var and__18477__auto__ = other__19081__auto__;
if(cljs.core.truth_(and__18477__auto__)){
var and__18477__auto____$1 = (this__19080__auto____$1.constructor === other__19081__auto__.constructor);
if(and__18477__auto____$1){
return cljs.core.equiv_map.call(null,this__19080__auto____$1,other__19081__auto__);
} else {
return and__18477__auto____$1;
}
} else {
return and__18477__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.Isa.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__19093__auto__,k__19094__auto__){
var self__ = this;
var this__19093__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"parent","parent",-878878779),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__19094__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__19093__auto____$1),self__.__meta),k__19094__auto__);
} else {
return (new schema.core.Isa(self__.h,self__.parent,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__19094__auto__)),null));
}
});

schema.core.Isa.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__19091__auto__,k__19092__auto__,G__55343){
var self__ = this;
var this__19091__auto____$1 = this;
var pred__55347 = cljs.core.keyword_identical_QMARK_;
var expr__55348 = k__19092__auto__;
if(cljs.core.truth_(pred__55347.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__55348))){
return (new schema.core.Isa(G__55343,self__.parent,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__55347.call(null,new cljs.core.Keyword(null,"parent","parent",-878878779),expr__55348))){
return (new schema.core.Isa(self__.h,G__55343,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.Isa(self__.h,self__.parent,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__19092__auto__,G__55343),null));
}
}
});

schema.core.Isa.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__19096__auto__){
var self__ = this;
var this__19096__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parent","parent",-878878779),self__.parent],null))], null),self__.__extmap));
});

schema.core.Isa.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__19083__auto__,G__55343){
var self__ = this;
var this__19083__auto____$1 = this;
return (new schema.core.Isa(self__.h,self__.parent,G__55343,self__.__extmap,self__.__hash));
});

schema.core.Isa.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__19089__auto__,entry__19090__auto__){
var self__ = this;
var this__19089__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__19090__auto__)){
return cljs.core._assoc.call(null,this__19089__auto____$1,cljs.core._nth.call(null,entry__19090__auto__,(0)),cljs.core._nth.call(null,entry__19090__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__19089__auto____$1,entry__19090__auto__);
}
});

schema.core.Isa.prototype.schema$core$Schema$ = true;

schema.core.Isa.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.leaf.leaf_spec.call(null,schema.spec.core.precondition.call(null,this$__$1,((function (this$__$1){
return (function (p1__55341_SHARP_){
return cljs.core.isa_QMARK_.call(null,self__.h,p1__55341_SHARP_,self__.parent);
});})(this$__$1))
,((function (this$__$1){
return (function (p1__55342_SHARP_){
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,self__.parent),p1__55342_SHARP_),new cljs.core.Symbol(null,"isa?","isa?",1358492324,null));
});})(this$__$1))
));
});

schema.core.Isa.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,self__.parent),new cljs.core.Symbol(null,"isa?","isa?",1358492324,null));
});

schema.core.Isa.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"h","h",-1544777029,null),new cljs.core.Symbol(null,"parent","parent",761652748,null)], null);
});

schema.core.Isa.cljs$lang$type = true;

schema.core.Isa.cljs$lang$ctorPrSeq = (function (this__19118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/Isa");
});

schema.core.Isa.cljs$lang$ctorPrWriter = (function (this__19118__auto__,writer__19119__auto__){
return cljs.core._write.call(null,writer__19119__auto__,"schema.core/Isa");
});

schema.core.__GT_Isa = (function schema$core$__GT_Isa(h,parent){
return (new schema.core.Isa(h,parent,null,null,null));
});

schema.core.map__GT_Isa = (function schema$core$map__GT_Isa(G__55345){
return (new schema.core.Isa(new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__55345),new cljs.core.Keyword(null,"parent","parent",-878878779).cljs$core$IFn$_invoke$arity$1(G__55345),null,cljs.core.dissoc.call(null,G__55345,new cljs.core.Keyword(null,"h","h",1109658740),new cljs.core.Keyword(null,"parent","parent",-878878779)),null));
});

/**
 * A value that must be a child of parent.
 */
schema.core.isa = (function schema$core$isa(){
var args55351 = [];
var len__19528__auto___55354 = arguments.length;
var i__19529__auto___55355 = (0);
while(true){
if((i__19529__auto___55355 < len__19528__auto___55354)){
args55351.push((arguments[i__19529__auto___55355]));

var G__55356 = (i__19529__auto___55355 + (1));
i__19529__auto___55355 = G__55356;
continue;
} else {
}
break;
}

var G__55353 = args55351.length;
switch (G__55353) {
case 1:
return schema.core.isa.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return schema.core.isa.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args55351.length)].join('')));

}
});

schema.core.isa.cljs$core$IFn$_invoke$arity$1 = (function (parent){
return (new schema.core.Isa(null,parent,null,null,null));
});

schema.core.isa.cljs$core$IFn$_invoke$arity$2 = (function (h,parent){
return (new schema.core.Isa(h,parent,null,null,null));
});

schema.core.isa.cljs$lang$maxFixedArity = 2;

/**
* @constructor
* @param {*} vs
* @param {*} __meta
* @param {*} __extmap
* @param {*} __hash
* @param {*=} __meta 
* @param {*=} __extmap
* @param {number|null} __hash
*/
schema.core.EnumSchema = (function (vs,__meta,__extmap,__hash){
this.vs = vs;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.EnumSchema.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__19084__auto__,k__19085__auto__){
var self__ = this;
var this__19084__auto____$1 = this;
return cljs.core._lookup.call(null,this__19084__auto____$1,k__19085__auto__,null);
});

schema.core.EnumSchema.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__19086__auto__,k55361,else__19087__auto__){
var self__ = this;
var this__19086__auto____$1 = this;
var G__55363 = (((k55361 instanceof cljs.core.Keyword))?k55361.fqn:null);
switch (G__55363) {
case "vs":
return self__.vs;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k55361,else__19087__auto__);

}
});

schema.core.EnumSchema.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__19098__auto__,writer__19099__auto__,opts__19100__auto__){
var self__ = this;
var this__19098__auto____$1 = this;
var pr_pair__19101__auto__ = ((function (this__19098__auto____$1){
return (function (keyval__19102__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,cljs.core.pr_writer,""," ","",opts__19100__auto__,keyval__19102__auto__);
});})(this__19098__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,pr_pair__19101__auto__,"#schema.core.EnumSchema{",", ","}",opts__19100__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"vs","vs",-2022097090),self__.vs],null))], null),self__.__extmap));
});

schema.core.EnumSchema.prototype.cljs$core$IIterable$ = true;

schema.core.EnumSchema.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__55360){
var self__ = this;
var G__55360__$1 = this;
return (new cljs.core.RecordIter((0),G__55360__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"vs","vs",-2022097090)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

schema.core.EnumSchema.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__19082__auto__){
var self__ = this;
var this__19082__auto____$1 = this;
return self__.__meta;
});

schema.core.EnumSchema.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__19078__auto__){
var self__ = this;
var this__19078__auto____$1 = this;
return (new schema.core.EnumSchema(self__.vs,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.EnumSchema.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__19088__auto__){
var self__ = this;
var this__19088__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.EnumSchema.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__19079__auto__){
var self__ = this;
var this__19079__auto____$1 = this;
var h__18905__auto__ = self__.__hash;
if(!((h__18905__auto__ == null))){
return h__18905__auto__;
} else {
var h__18905__auto____$1 = cljs.core.hash_imap.call(null,this__19079__auto____$1);
self__.__hash = h__18905__auto____$1;

return h__18905__auto____$1;
}
});

schema.core.EnumSchema.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__19080__auto__,other__19081__auto__){
var self__ = this;
var this__19080__auto____$1 = this;
if(cljs.core.truth_((function (){var and__18477__auto__ = other__19081__auto__;
if(cljs.core.truth_(and__18477__auto__)){
var and__18477__auto____$1 = (this__19080__auto____$1.constructor === other__19081__auto__.constructor);
if(and__18477__auto____$1){
return cljs.core.equiv_map.call(null,this__19080__auto____$1,other__19081__auto__);
} else {
return and__18477__auto____$1;
}
} else {
return and__18477__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.EnumSchema.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__19093__auto__,k__19094__auto__){
var self__ = this;
var this__19093__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"vs","vs",-2022097090),null], null), null),k__19094__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__19093__auto____$1),self__.__meta),k__19094__auto__);
} else {
return (new schema.core.EnumSchema(self__.vs,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__19094__auto__)),null));
}
});

schema.core.EnumSchema.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__19091__auto__,k__19092__auto__,G__55360){
var self__ = this;
var this__19091__auto____$1 = this;
var pred__55364 = cljs.core.keyword_identical_QMARK_;
var expr__55365 = k__19092__auto__;
if(cljs.core.truth_(pred__55364.call(null,new cljs.core.Keyword(null,"vs","vs",-2022097090),expr__55365))){
return (new schema.core.EnumSchema(G__55360,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.EnumSchema(self__.vs,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__19092__auto__,G__55360),null));
}
});

schema.core.EnumSchema.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__19096__auto__){
var self__ = this;
var this__19096__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"vs","vs",-2022097090),self__.vs],null))], null),self__.__extmap));
});

schema.core.EnumSchema.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__19083__auto__,G__55360){
var self__ = this;
var this__19083__auto____$1 = this;
return (new schema.core.EnumSchema(self__.vs,G__55360,self__.__extmap,self__.__hash));
});

schema.core.EnumSchema.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__19089__auto__,entry__19090__auto__){
var self__ = this;
var this__19089__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__19090__auto__)){
return cljs.core._assoc.call(null,this__19089__auto____$1,cljs.core._nth.call(null,entry__19090__auto__,(0)),cljs.core._nth.call(null,entry__19090__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__19089__auto____$1,entry__19090__auto__);
}
});

schema.core.EnumSchema.prototype.schema$core$Schema$ = true;

schema.core.EnumSchema.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.leaf.leaf_spec.call(null,schema.spec.core.precondition.call(null,this$__$1,((function (this$__$1){
return (function (p1__55358_SHARP_){
return cljs.core.contains_QMARK_.call(null,self__.vs,p1__55358_SHARP_);
});})(this$__$1))
,((function (this$__$1){
return (function (p1__55359_SHARP_){
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,p1__55359_SHARP_),self__.vs);
});})(this$__$1))
));
});

schema.core.EnumSchema.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons.call(null,new cljs.core.Symbol(null,"enum","enum",-975417337,null),self__.vs);
});

schema.core.EnumSchema.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"vs","vs",-381565563,null)], null);
});

schema.core.EnumSchema.cljs$lang$type = true;

schema.core.EnumSchema.cljs$lang$ctorPrSeq = (function (this__19118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/EnumSchema");
});

schema.core.EnumSchema.cljs$lang$ctorPrWriter = (function (this__19118__auto__,writer__19119__auto__){
return cljs.core._write.call(null,writer__19119__auto__,"schema.core/EnumSchema");
});

schema.core.__GT_EnumSchema = (function schema$core$__GT_EnumSchema(vs){
return (new schema.core.EnumSchema(vs,null,null,null));
});

schema.core.map__GT_EnumSchema = (function schema$core$map__GT_EnumSchema(G__55362){
return (new schema.core.EnumSchema(new cljs.core.Keyword(null,"vs","vs",-2022097090).cljs$core$IFn$_invoke$arity$1(G__55362),null,cljs.core.dissoc.call(null,G__55362,new cljs.core.Keyword(null,"vs","vs",-2022097090)),null));
});

/**
 * A value that must be = to some element of vs.
 */
schema.core.enum$ = (function schema$core$enum(){
var args__19535__auto__ = [];
var len__19528__auto___55369 = arguments.length;
var i__19529__auto___55370 = (0);
while(true){
if((i__19529__auto___55370 < len__19528__auto___55369)){
args__19535__auto__.push((arguments[i__19529__auto___55370]));

var G__55371 = (i__19529__auto___55370 + (1));
i__19529__auto___55370 = G__55371;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((0) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((0)),(0))):null);
return schema.core.enum$.cljs$core$IFn$_invoke$arity$variadic(argseq__19536__auto__);
});

schema.core.enum$.cljs$core$IFn$_invoke$arity$variadic = (function (vs){
return (new schema.core.EnumSchema(cljs.core.set.call(null,vs),null,null,null));
});

schema.core.enum$.cljs$lang$maxFixedArity = (0);

schema.core.enum$.cljs$lang$applyTo = (function (seq55368){
return schema.core.enum$.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq55368));
});

/**
* @constructor
* @param {*} p_QMARK_
* @param {*} pred_name
* @param {*} __meta
* @param {*} __extmap
* @param {*} __hash
* @param {*=} __meta 
* @param {*=} __extmap
* @param {number|null} __hash
*/
schema.core.Predicate = (function (p_QMARK_,pred_name,__meta,__extmap,__hash){
this.p_QMARK_ = p_QMARK_;
this.pred_name = pred_name;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.Predicate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__19084__auto__,k__19085__auto__){
var self__ = this;
var this__19084__auto____$1 = this;
return cljs.core._lookup.call(null,this__19084__auto____$1,k__19085__auto__,null);
});

schema.core.Predicate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__19086__auto__,k55374,else__19087__auto__){
var self__ = this;
var this__19086__auto____$1 = this;
var G__55376 = (((k55374 instanceof cljs.core.Keyword))?k55374.fqn:null);
switch (G__55376) {
case "p?":
return self__.p_QMARK_;

break;
case "pred-name":
return self__.pred_name;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k55374,else__19087__auto__);

}
});

schema.core.Predicate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__19098__auto__,writer__19099__auto__,opts__19100__auto__){
var self__ = this;
var this__19098__auto____$1 = this;
var pr_pair__19101__auto__ = ((function (this__19098__auto____$1){
return (function (keyval__19102__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,cljs.core.pr_writer,""," ","",opts__19100__auto__,keyval__19102__auto__);
});})(this__19098__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,pr_pair__19101__auto__,"#schema.core.Predicate{",", ","}",opts__19100__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"p?","p?",-1172161701),self__.p_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pred-name","pred-name",-3677451),self__.pred_name],null))], null),self__.__extmap));
});

schema.core.Predicate.prototype.cljs$core$IIterable$ = true;

schema.core.Predicate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__55373){
var self__ = this;
var G__55373__$1 = this;
return (new cljs.core.RecordIter((0),G__55373__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p?","p?",-1172161701),new cljs.core.Keyword(null,"pred-name","pred-name",-3677451)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

schema.core.Predicate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__19082__auto__){
var self__ = this;
var this__19082__auto____$1 = this;
return self__.__meta;
});

schema.core.Predicate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__19078__auto__){
var self__ = this;
var this__19078__auto____$1 = this;
return (new schema.core.Predicate(self__.p_QMARK_,self__.pred_name,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.Predicate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__19088__auto__){
var self__ = this;
var this__19088__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.Predicate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__19079__auto__){
var self__ = this;
var this__19079__auto____$1 = this;
var h__18905__auto__ = self__.__hash;
if(!((h__18905__auto__ == null))){
return h__18905__auto__;
} else {
var h__18905__auto____$1 = cljs.core.hash_imap.call(null,this__19079__auto____$1);
self__.__hash = h__18905__auto____$1;

return h__18905__auto____$1;
}
});

schema.core.Predicate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__19080__auto__,other__19081__auto__){
var self__ = this;
var this__19080__auto____$1 = this;
if(cljs.core.truth_((function (){var and__18477__auto__ = other__19081__auto__;
if(cljs.core.truth_(and__18477__auto__)){
var and__18477__auto____$1 = (this__19080__auto____$1.constructor === other__19081__auto__.constructor);
if(and__18477__auto____$1){
return cljs.core.equiv_map.call(null,this__19080__auto____$1,other__19081__auto__);
} else {
return and__18477__auto____$1;
}
} else {
return and__18477__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.Predicate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__19093__auto__,k__19094__auto__){
var self__ = this;
var this__19093__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pred-name","pred-name",-3677451),null,new cljs.core.Keyword(null,"p?","p?",-1172161701),null], null), null),k__19094__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__19093__auto____$1),self__.__meta),k__19094__auto__);
} else {
return (new schema.core.Predicate(self__.p_QMARK_,self__.pred_name,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__19094__auto__)),null));
}
});

schema.core.Predicate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__19091__auto__,k__19092__auto__,G__55373){
var self__ = this;
var this__19091__auto____$1 = this;
var pred__55377 = cljs.core.keyword_identical_QMARK_;
var expr__55378 = k__19092__auto__;
if(cljs.core.truth_(pred__55377.call(null,new cljs.core.Keyword(null,"p?","p?",-1172161701),expr__55378))){
return (new schema.core.Predicate(G__55373,self__.pred_name,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__55377.call(null,new cljs.core.Keyword(null,"pred-name","pred-name",-3677451),expr__55378))){
return (new schema.core.Predicate(self__.p_QMARK_,G__55373,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.Predicate(self__.p_QMARK_,self__.pred_name,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__19092__auto__,G__55373),null));
}
}
});

schema.core.Predicate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__19096__auto__){
var self__ = this;
var this__19096__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"p?","p?",-1172161701),self__.p_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pred-name","pred-name",-3677451),self__.pred_name],null))], null),self__.__extmap));
});

schema.core.Predicate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__19083__auto__,G__55373){
var self__ = this;
var this__19083__auto____$1 = this;
return (new schema.core.Predicate(self__.p_QMARK_,self__.pred_name,G__55373,self__.__extmap,self__.__hash));
});

schema.core.Predicate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__19089__auto__,entry__19090__auto__){
var self__ = this;
var this__19089__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__19090__auto__)){
return cljs.core._assoc.call(null,this__19089__auto____$1,cljs.core._nth.call(null,entry__19090__auto__,(0)),cljs.core._nth.call(null,entry__19090__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__19089__auto____$1,entry__19090__auto__);
}
});

schema.core.Predicate.prototype.schema$core$Schema$ = true;

schema.core.Predicate.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.leaf.leaf_spec.call(null,schema.spec.core.precondition.call(null,this$__$1,self__.p_QMARK_,((function (this$__$1){
return (function (p1__55372_SHARP_){
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,p1__55372_SHARP_),self__.pred_name);
});})(this$__$1))
));
});

schema.core.Predicate.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.call(null,self__.p_QMARK_,cljs.core.integer_QMARK_)){
return new cljs.core.Symbol(null,"Int","Int",-2116888740,null);
} else {
if(cljs.core._EQ_.call(null,self__.p_QMARK_,cljs.core.keyword_QMARK_)){
return new cljs.core.Symbol(null,"Keyword","Keyword",-850065993,null);
} else {
if(cljs.core._EQ_.call(null,self__.p_QMARK_,cljs.core.symbol_QMARK_)){
return new cljs.core.Symbol(null,"Symbol","Symbol",716452869,null);
} else {
if(cljs.core._EQ_.call(null,self__.p_QMARK_,cljs.core.string_QMARK_)){
return new cljs.core.Symbol(null,"Str","Str",907970895,null);
} else {
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,self__.pred_name),new cljs.core.Symbol(null,"pred","pred",-727012372,null));

}
}
}
}
});

schema.core.Predicate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p?","p?",468369826,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null);
});

schema.core.Predicate.cljs$lang$type = true;

schema.core.Predicate.cljs$lang$ctorPrSeq = (function (this__19118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/Predicate");
});

schema.core.Predicate.cljs$lang$ctorPrWriter = (function (this__19118__auto__,writer__19119__auto__){
return cljs.core._write.call(null,writer__19119__auto__,"schema.core/Predicate");
});

schema.core.__GT_Predicate = (function schema$core$__GT_Predicate(p_QMARK_,pred_name){
return (new schema.core.Predicate(p_QMARK_,pred_name,null,null,null));
});

schema.core.map__GT_Predicate = (function schema$core$map__GT_Predicate(G__55375){
return (new schema.core.Predicate(new cljs.core.Keyword(null,"p?","p?",-1172161701).cljs$core$IFn$_invoke$arity$1(G__55375),new cljs.core.Keyword(null,"pred-name","pred-name",-3677451).cljs$core$IFn$_invoke$arity$1(G__55375),null,cljs.core.dissoc.call(null,G__55375,new cljs.core.Keyword(null,"p?","p?",-1172161701),new cljs.core.Keyword(null,"pred-name","pred-name",-3677451)),null));
});

/**
 * A value for which p? returns true (and does not throw).
 * Optional pred-name can be passed for nicer validation errors.
 */
schema.core.pred = (function schema$core$pred(){
var args55381 = [];
var len__19528__auto___55384 = arguments.length;
var i__19529__auto___55385 = (0);
while(true){
if((i__19529__auto___55385 < len__19528__auto___55384)){
args55381.push((arguments[i__19529__auto___55385]));

var G__55386 = (i__19529__auto___55385 + (1));
i__19529__auto___55385 = G__55386;
continue;
} else {
}
break;
}

var G__55383 = args55381.length;
switch (G__55383) {
case 1:
return schema.core.pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return schema.core.pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args55381.length)].join('')));

}
});

schema.core.pred.cljs$core$IFn$_invoke$arity$1 = (function (p_QMARK_){
return schema.core.pred.call(null,p_QMARK_,cljs.core.symbol.call(null,schema.utils.fn_name.call(null,p_QMARK_)));
});

schema.core.pred.cljs$core$IFn$_invoke$arity$2 = (function (p_QMARK_,pred_name){
if(cljs.core.ifn_QMARK_.call(null,p_QMARK_)){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Not a function: %s",p_QMARK_)));
}

return (new schema.core.Predicate(p_QMARK_,pred_name,null,null,null));
});

schema.core.pred.cljs$lang$maxFixedArity = 2;
schema.core.protocol_name = (function schema$core$protocol_name(protocol){
return new cljs.core.Keyword(null,"proto-sym","proto-sym",-886371734).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,protocol));
});

/**
* @constructor
* @param {*} p
* @param {*} __meta
* @param {*} __extmap
* @param {*} __hash
* @param {*=} __meta 
* @param {*=} __extmap
* @param {number|null} __hash
*/
schema.core.Protocol = (function (p,__meta,__extmap,__hash){
this.p = p;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.Protocol.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__19084__auto__,k__19085__auto__){
var self__ = this;
var this__19084__auto____$1 = this;
return cljs.core._lookup.call(null,this__19084__auto____$1,k__19085__auto__,null);
});

schema.core.Protocol.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__19086__auto__,k55391,else__19087__auto__){
var self__ = this;
var this__19086__auto____$1 = this;
var G__55393 = (((k55391 instanceof cljs.core.Keyword))?k55391.fqn:null);
switch (G__55393) {
case "p":
return self__.p;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k55391,else__19087__auto__);

}
});

schema.core.Protocol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__19098__auto__,writer__19099__auto__,opts__19100__auto__){
var self__ = this;
var this__19098__auto____$1 = this;
var pr_pair__19101__auto__ = ((function (this__19098__auto____$1){
return (function (keyval__19102__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,cljs.core.pr_writer,""," ","",opts__19100__auto__,keyval__19102__auto__);
});})(this__19098__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,pr_pair__19101__auto__,"#schema.core.Protocol{",", ","}",opts__19100__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"p","p",151049309),self__.p],null))], null),self__.__extmap));
});

schema.core.Protocol.prototype.cljs$core$IIterable$ = true;

schema.core.Protocol.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__55390){
var self__ = this;
var G__55390__$1 = this;
return (new cljs.core.RecordIter((0),G__55390__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

schema.core.Protocol.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__19082__auto__){
var self__ = this;
var this__19082__auto____$1 = this;
return self__.__meta;
});

schema.core.Protocol.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__19078__auto__){
var self__ = this;
var this__19078__auto____$1 = this;
return (new schema.core.Protocol(self__.p,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.Protocol.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__19088__auto__){
var self__ = this;
var this__19088__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.Protocol.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__19079__auto__){
var self__ = this;
var this__19079__auto____$1 = this;
var h__18905__auto__ = self__.__hash;
if(!((h__18905__auto__ == null))){
return h__18905__auto__;
} else {
var h__18905__auto____$1 = cljs.core.hash_imap.call(null,this__19079__auto____$1);
self__.__hash = h__18905__auto____$1;

return h__18905__auto____$1;
}
});

schema.core.Protocol.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__19080__auto__,other__19081__auto__){
var self__ = this;
var this__19080__auto____$1 = this;
if(cljs.core.truth_((function (){var and__18477__auto__ = other__19081__auto__;
if(cljs.core.truth_(and__18477__auto__)){
var and__18477__auto____$1 = (this__19080__auto____$1.constructor === other__19081__auto__.constructor);
if(and__18477__auto____$1){
return cljs.core.equiv_map.call(null,this__19080__auto____$1,other__19081__auto__);
} else {
return and__18477__auto____$1;
}
} else {
return and__18477__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.Protocol.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__19093__auto__,k__19094__auto__){
var self__ = this;
var this__19093__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"p","p",151049309),null], null), null),k__19094__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__19093__auto____$1),self__.__meta),k__19094__auto__);
} else {
return (new schema.core.Protocol(self__.p,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__19094__auto__)),null));
}
});

schema.core.Protocol.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__19091__auto__,k__19092__auto__,G__55390){
var self__ = this;
var this__19091__auto____$1 = this;
var pred__55394 = cljs.core.keyword_identical_QMARK_;
var expr__55395 = k__19092__auto__;
if(cljs.core.truth_(pred__55394.call(null,new cljs.core.Keyword(null,"p","p",151049309),expr__55395))){
return (new schema.core.Protocol(G__55390,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.Protocol(self__.p,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__19092__auto__,G__55390),null));
}
});

schema.core.Protocol.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__19096__auto__){
var self__ = this;
var this__19096__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"p","p",151049309),self__.p],null))], null),self__.__extmap));
});

schema.core.Protocol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__19083__auto__,G__55390){
var self__ = this;
var this__19083__auto____$1 = this;
return (new schema.core.Protocol(self__.p,G__55390,self__.__extmap,self__.__hash));
});

schema.core.Protocol.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__19089__auto__,entry__19090__auto__){
var self__ = this;
var this__19089__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__19090__auto__)){
return cljs.core._assoc.call(null,this__19089__auto____$1,cljs.core._nth.call(null,entry__19090__auto__,(0)),cljs.core._nth.call(null,entry__19090__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__19089__auto____$1,entry__19090__auto__);
}
});

schema.core.Protocol.prototype.schema$core$Schema$ = true;

schema.core.Protocol.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.leaf.leaf_spec.call(null,schema.spec.core.precondition.call(null,this$__$1,((function (this$__$1){
return (function (p1__55388_SHARP_){
return new cljs.core.Keyword(null,"proto-pred","proto-pred",1885698716).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,this$__$1)).call(null,p1__55388_SHARP_);
});})(this$__$1))
,((function (this$__$1){
return (function (p1__55389_SHARP_){
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,p1__55389_SHARP_),schema.core.protocol_name.call(null,this$__$1)),new cljs.core.Symbol(null,"satisfies?","satisfies?",-433227199,null));
});})(this$__$1))
));
});

schema.core.Protocol.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,schema.core.protocol_name.call(null,this$__$1)),new cljs.core.Symbol(null,"protocol","protocol",-2001965651,null));
});

schema.core.Protocol.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null)], null);
});

schema.core.Protocol.cljs$lang$type = true;

schema.core.Protocol.cljs$lang$ctorPrSeq = (function (this__19118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/Protocol");
});

schema.core.Protocol.cljs$lang$ctorPrWriter = (function (this__19118__auto__,writer__19119__auto__){
return cljs.core._write.call(null,writer__19119__auto__,"schema.core/Protocol");
});

schema.core.__GT_Protocol = (function schema$core$__GT_Protocol(p){
return (new schema.core.Protocol(p,null,null,null));
});

schema.core.map__GT_Protocol = (function schema$core$map__GT_Protocol(G__55392){
return (new schema.core.Protocol(new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(G__55392),null,cljs.core.dissoc.call(null,G__55392,new cljs.core.Keyword(null,"p","p",151049309)),null));
});

RegExp.prototype.schema$core$Schema$ = true;

RegExp.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var this$__$1 = this;
return schema.spec.leaf.leaf_spec.call(null,cljs.core.some_fn.call(null,schema.spec.core.precondition.call(null,this$__$1,cljs.core.string_QMARK_,((function (this$__$1){
return (function (p1__21322__21323__auto__){
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,p1__21322__21323__auto__),new cljs.core.Symbol(null,"string?","string?",-1129175764,null));
});})(this$__$1))
),schema.spec.core.precondition.call(null,this$__$1,((function (this$__$1){
return (function (p1__55398_SHARP_){
return cljs.core.re_find.call(null,this$__$1,p1__55398_SHARP_);
});})(this$__$1))
,((function (this$__$1){
return (function (p1__55399_SHARP_){
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,p1__55399_SHARP_),schema.core.explain.call(null,this$__$1)),new cljs.core.Symbol(null,"re-find","re-find",1143444147,null));
});})(this$__$1))
)));
});

RegExp.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.symbol.call(null,[cljs.core.str("#\""),cljs.core.str([cljs.core.str(this$__$1)].join('').slice((1),(-1))),cljs.core.str("\"")].join(''));
});
/**
 * Satisfied only by String.
 * Is (pred string?) and not js/String in cljs because of keywords.
 */
schema.core.Str = schema.core.pred.call(null,cljs.core.string_QMARK_);
/**
 * Boolean true or false
 */
schema.core.Bool = Boolean;
/**
 * Any number
 */
schema.core.Num = Number;
/**
 * Any integral number
 */
schema.core.Int = schema.core.pred.call(null,cljs.core.integer_QMARK_);
/**
 * A keyword
 */
schema.core.Keyword = schema.core.pred.call(null,cljs.core.keyword_QMARK_);
/**
 * A symbol
 */
schema.core.Symbol = schema.core.pred.call(null,cljs.core.symbol_QMARK_);
/**
 * A regular expression
 */
schema.core.Regex = (function (){
if(typeof schema.core.t55402 !== 'undefined'){
} else {

/**
* @constructor
*/
schema.core.t55402 = (function (meta55403){
this.meta55403 = meta55403;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
schema.core.t55402.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_55404,meta55403__$1){
var self__ = this;
var _55404__$1 = this;
return (new schema.core.t55402(meta55403__$1));
});

schema.core.t55402.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_55404){
var self__ = this;
var _55404__$1 = this;
return self__.meta55403;
});

schema.core.t55402.prototype.schema$core$Schema$ = true;

schema.core.t55402.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.leaf.leaf_spec.call(null,schema.spec.core.precondition.call(null,this$__$1,((function (this$__$1){
return (function (p1__55400_SHARP_){
return (p1__55400_SHARP_ instanceof RegExp);
});})(this$__$1))
,((function (this$__$1){
return (function (p1__55401_SHARP_){
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,p1__55401_SHARP_),new cljs.core.Symbol("js","RegExp","js/RegExp",1778210562,null)),new cljs.core.Symbol(null,"instance?","instance?",1075939923,null));
});})(this$__$1))
));
});

schema.core.t55402.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.Symbol(null,"Regex","Regex",205914413,null);
});

schema.core.t55402.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta55403","meta55403",796180316,null)], null);
});

schema.core.t55402.cljs$lang$type = true;

schema.core.t55402.cljs$lang$ctorStr = "schema.core/t55402";

schema.core.t55402.cljs$lang$ctorPrWriter = (function (this__19068__auto__,writer__19069__auto__,opt__19070__auto__){
return cljs.core._write.call(null,writer__19069__auto__,"schema.core/t55402");
});

schema.core.__GT_t55402 = (function schema$core$__GT_t55402(meta55403){
return (new schema.core.t55402(meta55403));
});

}

return (new schema.core.t55402(cljs.core.PersistentArrayMap.EMPTY));
})()
;
/**
 * The local representation of #inst ...
 */
schema.core.Inst = Date;
/**
 * The local representation of #uuid ...
 */
schema.core.Uuid = cljs.core.UUID;

/**
* @constructor
* @param {*} schema
* @param {*} __meta
* @param {*} __extmap
* @param {*} __hash
* @param {*=} __meta 
* @param {*=} __extmap
* @param {number|null} __hash
*/
schema.core.Maybe = (function (schema,__meta,__extmap,__hash){
this.schema = schema;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.Maybe.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__19084__auto__,k__19085__auto__){
var self__ = this;
var this__19084__auto____$1 = this;
return cljs.core._lookup.call(null,this__19084__auto____$1,k__19085__auto__,null);
});

schema.core.Maybe.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__19086__auto__,k55406,else__19087__auto__){
var self__ = this;
var this__19086__auto____$1 = this;
var G__55408 = (((k55406 instanceof cljs.core.Keyword))?k55406.fqn:null);
switch (G__55408) {
case "schema":
return self__.schema;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k55406,else__19087__auto__);

}
});

schema.core.Maybe.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__19098__auto__,writer__19099__auto__,opts__19100__auto__){
var self__ = this;
var this__19098__auto____$1 = this;
var pr_pair__19101__auto__ = ((function (this__19098__auto____$1){
return (function (keyval__19102__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,cljs.core.pr_writer,""," ","",opts__19100__auto__,keyval__19102__auto__);
});})(this__19098__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,pr_pair__19101__auto__,"#schema.core.Maybe{",", ","}",opts__19100__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null))], null),self__.__extmap));
});

schema.core.Maybe.prototype.cljs$core$IIterable$ = true;

schema.core.Maybe.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__55405){
var self__ = this;
var G__55405__$1 = this;
return (new cljs.core.RecordIter((0),G__55405__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

schema.core.Maybe.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__19082__auto__){
var self__ = this;
var this__19082__auto____$1 = this;
return self__.__meta;
});

schema.core.Maybe.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__19078__auto__){
var self__ = this;
var this__19078__auto____$1 = this;
return (new schema.core.Maybe(self__.schema,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.Maybe.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__19088__auto__){
var self__ = this;
var this__19088__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.Maybe.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__19079__auto__){
var self__ = this;
var this__19079__auto____$1 = this;
var h__18905__auto__ = self__.__hash;
if(!((h__18905__auto__ == null))){
return h__18905__auto__;
} else {
var h__18905__auto____$1 = cljs.core.hash_imap.call(null,this__19079__auto____$1);
self__.__hash = h__18905__auto____$1;

return h__18905__auto____$1;
}
});

schema.core.Maybe.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__19080__auto__,other__19081__auto__){
var self__ = this;
var this__19080__auto____$1 = this;
if(cljs.core.truth_((function (){var and__18477__auto__ = other__19081__auto__;
if(cljs.core.truth_(and__18477__auto__)){
var and__18477__auto____$1 = (this__19080__auto____$1.constructor === other__19081__auto__.constructor);
if(and__18477__auto____$1){
return cljs.core.equiv_map.call(null,this__19080__auto____$1,other__19081__auto__);
} else {
return and__18477__auto____$1;
}
} else {
return and__18477__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.Maybe.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__19093__auto__,k__19094__auto__){
var self__ = this;
var this__19093__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),null], null), null),k__19094__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__19093__auto____$1),self__.__meta),k__19094__auto__);
} else {
return (new schema.core.Maybe(self__.schema,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__19094__auto__)),null));
}
});

schema.core.Maybe.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__19091__auto__,k__19092__auto__,G__55405){
var self__ = this;
var this__19091__auto____$1 = this;
var pred__55409 = cljs.core.keyword_identical_QMARK_;
var expr__55410 = k__19092__auto__;
if(cljs.core.truth_(pred__55409.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__55410))){
return (new schema.core.Maybe(G__55405,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.Maybe(self__.schema,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__19092__auto__,G__55405),null));
}
});

schema.core.Maybe.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__19096__auto__){
var self__ = this;
var this__19096__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null))], null),self__.__extmap));
});

schema.core.Maybe.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__19083__auto__,G__55405){
var self__ = this;
var this__19083__auto____$1 = this;
return (new schema.core.Maybe(self__.schema,G__55405,self__.__extmap,self__.__hash));
});

schema.core.Maybe.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__19089__auto__,entry__19090__auto__){
var self__ = this;
var this__19089__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__19090__auto__)){
return cljs.core._assoc.call(null,this__19089__auto____$1,cljs.core._nth.call(null,entry__19090__auto__,(0)),cljs.core._nth.call(null,entry__19090__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__19089__auto____$1,entry__19090__auto__);
}
});

schema.core.Maybe.prototype.schema$core$Schema$ = true;

schema.core.Maybe.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.variant.variant_spec.call(null,schema.spec.core._PLUS_no_precondition_PLUS_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"guard","guard",-873147811),cljs.core.nil_QMARK_,new cljs.core.Keyword(null,"schema","schema",-1582001791),schema.core.eq.call(null,null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema], null)], null));
});

schema.core.Maybe.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,schema.core.explain.call(null,self__.schema)),new cljs.core.Symbol(null,"maybe","maybe",1326133967,null));
});

schema.core.Maybe.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"schema","schema",58529736,null)], null);
});

schema.core.Maybe.cljs$lang$type = true;

schema.core.Maybe.cljs$lang$ctorPrSeq = (function (this__19118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/Maybe");
});

schema.core.Maybe.cljs$lang$ctorPrWriter = (function (this__19118__auto__,writer__19119__auto__){
return cljs.core._write.call(null,writer__19119__auto__,"schema.core/Maybe");
});

schema.core.__GT_Maybe = (function schema$core$__GT_Maybe(schema__$1){
return (new schema.core.Maybe(schema__$1,null,null,null));
});

schema.core.map__GT_Maybe = (function schema$core$map__GT_Maybe(G__55407){
return (new schema.core.Maybe(new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__55407),null,cljs.core.dissoc.call(null,G__55407,new cljs.core.Keyword(null,"schema","schema",-1582001791)),null));
});

/**
 * A value that must either be nil or satisfy schema
 */
schema.core.maybe = (function schema$core$maybe(schema__$1){
return (new schema.core.Maybe(schema__$1,null,null,null));
});

/**
* @constructor
* @param {*} schema
* @param {*} name
* @param {*} __meta
* @param {*} __extmap
* @param {*} __hash
* @param {*=} __meta 
* @param {*=} __extmap
* @param {number|null} __hash
*/
schema.core.NamedSchema = (function (schema,name,__meta,__extmap,__hash){
this.schema = schema;
this.name = name;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.NamedSchema.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__19084__auto__,k__19085__auto__){
var self__ = this;
var this__19084__auto____$1 = this;
return cljs.core._lookup.call(null,this__19084__auto____$1,k__19085__auto__,null);
});

schema.core.NamedSchema.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__19086__auto__,k55415,else__19087__auto__){
var self__ = this;
var this__19086__auto____$1 = this;
var G__55417 = (((k55415 instanceof cljs.core.Keyword))?k55415.fqn:null);
switch (G__55417) {
case "schema":
return self__.schema;

break;
case "name":
return self__.name;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k55415,else__19087__auto__);

}
});

schema.core.NamedSchema.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__19098__auto__,writer__19099__auto__,opts__19100__auto__){
var self__ = this;
var this__19098__auto____$1 = this;
var pr_pair__19101__auto__ = ((function (this__19098__auto____$1){
return (function (keyval__19102__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,cljs.core.pr_writer,""," ","",opts__19100__auto__,keyval__19102__auto__);
});})(this__19098__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,pr_pair__19101__auto__,"#schema.core.NamedSchema{",", ","}",opts__19100__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"name","name",1843675177),self__.name],null))], null),self__.__extmap));
});

schema.core.NamedSchema.prototype.cljs$core$IIterable$ = true;

schema.core.NamedSchema.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__55414){
var self__ = this;
var G__55414__$1 = this;
return (new cljs.core.RecordIter((0),G__55414__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"name","name",1843675177)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

schema.core.NamedSchema.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__19082__auto__){
var self__ = this;
var this__19082__auto____$1 = this;
return self__.__meta;
});

schema.core.NamedSchema.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__19078__auto__){
var self__ = this;
var this__19078__auto____$1 = this;
return (new schema.core.NamedSchema(self__.schema,self__.name,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.NamedSchema.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__19088__auto__){
var self__ = this;
var this__19088__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.NamedSchema.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__19079__auto__){
var self__ = this;
var this__19079__auto____$1 = this;
var h__18905__auto__ = self__.__hash;
if(!((h__18905__auto__ == null))){
return h__18905__auto__;
} else {
var h__18905__auto____$1 = cljs.core.hash_imap.call(null,this__19079__auto____$1);
self__.__hash = h__18905__auto____$1;

return h__18905__auto____$1;
}
});

schema.core.NamedSchema.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__19080__auto__,other__19081__auto__){
var self__ = this;
var this__19080__auto____$1 = this;
if(cljs.core.truth_((function (){var and__18477__auto__ = other__19081__auto__;
if(cljs.core.truth_(and__18477__auto__)){
var and__18477__auto____$1 = (this__19080__auto____$1.constructor === other__19081__auto__.constructor);
if(and__18477__auto____$1){
return cljs.core.equiv_map.call(null,this__19080__auto____$1,other__19081__auto__);
} else {
return and__18477__auto____$1;
}
} else {
return and__18477__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.NamedSchema.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__19093__auto__,k__19094__auto__){
var self__ = this;
var this__19093__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"name","name",1843675177),null], null), null),k__19094__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__19093__auto____$1),self__.__meta),k__19094__auto__);
} else {
return (new schema.core.NamedSchema(self__.schema,self__.name,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__19094__auto__)),null));
}
});

schema.core.NamedSchema.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__19091__auto__,k__19092__auto__,G__55414){
var self__ = this;
var this__19091__auto____$1 = this;
var pred__55418 = cljs.core.keyword_identical_QMARK_;
var expr__55419 = k__19092__auto__;
if(cljs.core.truth_(pred__55418.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__55419))){
return (new schema.core.NamedSchema(G__55414,self__.name,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__55418.call(null,new cljs.core.Keyword(null,"name","name",1843675177),expr__55419))){
return (new schema.core.NamedSchema(self__.schema,G__55414,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.NamedSchema(self__.schema,self__.name,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__19092__auto__,G__55414),null));
}
}
});

schema.core.NamedSchema.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__19096__auto__){
var self__ = this;
var this__19096__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"name","name",1843675177),self__.name],null))], null),self__.__extmap));
});

schema.core.NamedSchema.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__19083__auto__,G__55414){
var self__ = this;
var this__19083__auto____$1 = this;
return (new schema.core.NamedSchema(self__.schema,self__.name,G__55414,self__.__extmap,self__.__hash));
});

schema.core.NamedSchema.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__19089__auto__,entry__19090__auto__){
var self__ = this;
var this__19089__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__19090__auto__)){
return cljs.core._assoc.call(null,this__19089__auto____$1,cljs.core._nth.call(null,entry__19090__auto__,(0)),cljs.core._nth.call(null,entry__19090__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__19089__auto____$1,entry__19090__auto__);
}
});

schema.core.NamedSchema.prototype.schema$core$Schema$ = true;

schema.core.NamedSchema.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.variant.variant_spec.call(null,schema.spec.core._PLUS_no_precondition_PLUS_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,new cljs.core.Keyword(null,"wrap-error","wrap-error",536732809),((function (this$__$1){
return (function (p1__55413_SHARP_){
return schema.utils.__GT_NamedError.call(null,self__.name,p1__55413_SHARP_);
});})(this$__$1))
], null)], null));
});

schema.core.NamedSchema.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,self__.name),schema.core.explain.call(null,self__.schema)),new cljs.core.Symbol(null,"named","named",1218138048,null));
});

schema.core.NamedSchema.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"name","name",-810760592,null)], null);
});

schema.core.NamedSchema.cljs$lang$type = true;

schema.core.NamedSchema.cljs$lang$ctorPrSeq = (function (this__19118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/NamedSchema");
});

schema.core.NamedSchema.cljs$lang$ctorPrWriter = (function (this__19118__auto__,writer__19119__auto__){
return cljs.core._write.call(null,writer__19119__auto__,"schema.core/NamedSchema");
});

schema.core.__GT_NamedSchema = (function schema$core$__GT_NamedSchema(schema__$1,name){
return (new schema.core.NamedSchema(schema__$1,name,null,null,null));
});

schema.core.map__GT_NamedSchema = (function schema$core$map__GT_NamedSchema(G__55416){
return (new schema.core.NamedSchema(new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__55416),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(G__55416),null,cljs.core.dissoc.call(null,G__55416,new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"name","name",1843675177)),null));
});

/**
 * A value that must satisfy schema, and has a name for documentation purposes.
 */
schema.core.named = (function schema$core$named(schema__$1,name){
return (new schema.core.NamedSchema(schema__$1,name,null,null,null));
});

/**
* @constructor
* @param {*} schemas
* @param {*} __meta
* @param {*} __extmap
* @param {*} __hash
* @param {*=} __meta 
* @param {*=} __extmap
* @param {number|null} __hash
*/
schema.core.Either = (function (schemas,__meta,__extmap,__hash){
this.schemas = schemas;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.Either.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__19084__auto__,k__19085__auto__){
var self__ = this;
var this__19084__auto____$1 = this;
return cljs.core._lookup.call(null,this__19084__auto____$1,k__19085__auto__,null);
});

schema.core.Either.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__19086__auto__,k55424,else__19087__auto__){
var self__ = this;
var this__19086__auto____$1 = this;
var G__55426 = (((k55424 instanceof cljs.core.Keyword))?k55424.fqn:null);
switch (G__55426) {
case "schemas":
return self__.schemas;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k55424,else__19087__auto__);

}
});

schema.core.Either.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__19098__auto__,writer__19099__auto__,opts__19100__auto__){
var self__ = this;
var this__19098__auto____$1 = this;
var pr_pair__19101__auto__ = ((function (this__19098__auto____$1){
return (function (keyval__19102__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,cljs.core.pr_writer,""," ","",opts__19100__auto__,keyval__19102__auto__);
});})(this__19098__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,pr_pair__19101__auto__,"#schema.core.Either{",", ","}",opts__19100__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schemas","schemas",575070579),self__.schemas],null))], null),self__.__extmap));
});

schema.core.Either.prototype.cljs$core$IIterable$ = true;

schema.core.Either.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__55423){
var self__ = this;
var G__55423__$1 = this;
return (new cljs.core.RecordIter((0),G__55423__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schemas","schemas",575070579)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

schema.core.Either.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__19082__auto__){
var self__ = this;
var this__19082__auto____$1 = this;
return self__.__meta;
});

schema.core.Either.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__19078__auto__){
var self__ = this;
var this__19078__auto____$1 = this;
return (new schema.core.Either(self__.schemas,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.Either.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__19088__auto__){
var self__ = this;
var this__19088__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.Either.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__19079__auto__){
var self__ = this;
var this__19079__auto____$1 = this;
var h__18905__auto__ = self__.__hash;
if(!((h__18905__auto__ == null))){
return h__18905__auto__;
} else {
var h__18905__auto____$1 = cljs.core.hash_imap.call(null,this__19079__auto____$1);
self__.__hash = h__18905__auto____$1;

return h__18905__auto____$1;
}
});

schema.core.Either.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__19080__auto__,other__19081__auto__){
var self__ = this;
var this__19080__auto____$1 = this;
if(cljs.core.truth_((function (){var and__18477__auto__ = other__19081__auto__;
if(cljs.core.truth_(and__18477__auto__)){
var and__18477__auto____$1 = (this__19080__auto____$1.constructor === other__19081__auto__.constructor);
if(and__18477__auto____$1){
return cljs.core.equiv_map.call(null,this__19080__auto____$1,other__19081__auto__);
} else {
return and__18477__auto____$1;
}
} else {
return and__18477__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.Either.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__19093__auto__,k__19094__auto__){
var self__ = this;
var this__19093__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schemas","schemas",575070579),null], null), null),k__19094__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__19093__auto____$1),self__.__meta),k__19094__auto__);
} else {
return (new schema.core.Either(self__.schemas,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__19094__auto__)),null));
}
});

schema.core.Either.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__19091__auto__,k__19092__auto__,G__55423){
var self__ = this;
var this__19091__auto____$1 = this;
var pred__55427 = cljs.core.keyword_identical_QMARK_;
var expr__55428 = k__19092__auto__;
if(cljs.core.truth_(pred__55427.call(null,new cljs.core.Keyword(null,"schemas","schemas",575070579),expr__55428))){
return (new schema.core.Either(G__55423,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.Either(self__.schemas,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__19092__auto__,G__55423),null));
}
});

schema.core.Either.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__19096__auto__){
var self__ = this;
var this__19096__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schemas","schemas",575070579),self__.schemas],null))], null),self__.__extmap));
});

schema.core.Either.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__19083__auto__,G__55423){
var self__ = this;
var this__19083__auto____$1 = this;
return (new schema.core.Either(self__.schemas,G__55423,self__.__extmap,self__.__hash));
});

schema.core.Either.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__19089__auto__,entry__19090__auto__){
var self__ = this;
var this__19089__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__19090__auto__)){
return cljs.core._assoc.call(null,this__19089__auto____$1,cljs.core._nth.call(null,entry__19090__auto__,(0)),cljs.core._nth.call(null,entry__19090__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__19089__auto____$1,entry__19090__auto__);
}
});

schema.core.Either.prototype.schema$core$Schema$ = true;

schema.core.Either.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.variant.variant_spec.call(null,schema.spec.core._PLUS_no_precondition_PLUS_,(function (){var iter__19242__auto__ = ((function (this$__$1){
return (function schema$core$iter__55430(s__55431){
return (new cljs.core.LazySeq(null,((function (this$__$1){
return (function (){
var s__55431__$1 = s__55431;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__55431__$1);
if(temp__4425__auto__){
var s__55431__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__55431__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__55431__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__55433 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__55432 = (0);
while(true){
if((i__55432 < size__19241__auto__)){
var s = cljs.core._nth.call(null,c__19240__auto__,i__55432);
cljs.core.chunk_append.call(null,b__55433,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"guard","guard",-873147811),cljs.core.complement.call(null,schema.core.checker.call(null,s)),new cljs.core.Keyword(null,"schema","schema",-1582001791),s], null));

var G__55435 = (i__55432 + (1));
i__55432 = G__55435;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55433),schema$core$iter__55430.call(null,cljs.core.chunk_rest.call(null,s__55431__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55433),null);
}
} else {
var s = cljs.core.first.call(null,s__55431__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"guard","guard",-873147811),cljs.core.complement.call(null,schema.core.checker.call(null,s)),new cljs.core.Keyword(null,"schema","schema",-1582001791),s], null),schema$core$iter__55430.call(null,cljs.core.rest.call(null,s__55431__$2)));
}
} else {
return null;
}
break;
}
});})(this$__$1))
,null,null));
});})(this$__$1))
;
return iter__19242__auto__.call(null,self__.schemas);
})(),((function (this$__$1){
return (function (p1__55422_SHARP_){
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,p1__55422_SHARP_),new cljs.core.Symbol(null,"some-matching-either-clause?","some-matching-either-clause?",-1443305015,null));
});})(this$__$1))
);
});

schema.core.Either.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons.call(null,new cljs.core.Symbol(null,"either","either",-2144373018,null),cljs.core.map.call(null,schema.core.explain,self__.schemas));
});

schema.core.Either.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"schemas","schemas",-2079365190,null)], null);
});

schema.core.Either.cljs$lang$type = true;

schema.core.Either.cljs$lang$ctorPrSeq = (function (this__19118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/Either");
});

schema.core.Either.cljs$lang$ctorPrWriter = (function (this__19118__auto__,writer__19119__auto__){
return cljs.core._write.call(null,writer__19119__auto__,"schema.core/Either");
});

schema.core.__GT_Either = (function schema$core$__GT_Either(schemas){
return (new schema.core.Either(schemas,null,null,null));
});

schema.core.map__GT_Either = (function schema$core$map__GT_Either(G__55425){
return (new schema.core.Either(new cljs.core.Keyword(null,"schemas","schemas",575070579).cljs$core$IFn$_invoke$arity$1(G__55425),null,cljs.core.dissoc.call(null,G__55425,new cljs.core.Keyword(null,"schemas","schemas",575070579)),null));
});

/**
 * A value that must satisfy at least one schema in schemas.
 * Note that `either` does not work properly with coercion
 * 
 * DEPRECATED: prefer `cond-pre`
 * 
 * WARNING: either does not work with coercion.  It is also slow and gives
 * bad error messages.  Please consider using `conditional` and friends
 * instead; they are more efficient, provide better error messages,
 * and work with coercion.
 */
schema.core.either = (function schema$core$either(){
var args__19535__auto__ = [];
var len__19528__auto___55437 = arguments.length;
var i__19529__auto___55438 = (0);
while(true){
if((i__19529__auto___55438 < len__19528__auto___55437)){
args__19535__auto__.push((arguments[i__19529__auto___55438]));

var G__55439 = (i__19529__auto___55438 + (1));
i__19529__auto___55438 = G__55439;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((0) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((0)),(0))):null);
return schema.core.either.cljs$core$IFn$_invoke$arity$variadic(argseq__19536__auto__);
});

schema.core.either.cljs$core$IFn$_invoke$arity$variadic = (function (schemas){
return (new schema.core.Either(schemas,null,null,null));
});

schema.core.either.cljs$lang$maxFixedArity = (0);

schema.core.either.cljs$lang$applyTo = (function (seq55436){
return schema.core.either.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq55436));
});

/**
* @constructor
* @param {*} preds_and_schemas
* @param {*} error_symbol
* @param {*} __meta
* @param {*} __extmap
* @param {*} __hash
* @param {*=} __meta 
* @param {*=} __extmap
* @param {number|null} __hash
*/
schema.core.ConditionalSchema = (function (preds_and_schemas,error_symbol,__meta,__extmap,__hash){
this.preds_and_schemas = preds_and_schemas;
this.error_symbol = error_symbol;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.ConditionalSchema.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__19084__auto__,k__19085__auto__){
var self__ = this;
var this__19084__auto____$1 = this;
return cljs.core._lookup.call(null,this__19084__auto____$1,k__19085__auto__,null);
});

schema.core.ConditionalSchema.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__19086__auto__,k55442,else__19087__auto__){
var self__ = this;
var this__19086__auto____$1 = this;
var G__55444 = (((k55442 instanceof cljs.core.Keyword))?k55442.fqn:null);
switch (G__55444) {
case "preds-and-schemas":
return self__.preds_and_schemas;

break;
case "error-symbol":
return self__.error_symbol;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k55442,else__19087__auto__);

}
});

schema.core.ConditionalSchema.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__19098__auto__,writer__19099__auto__,opts__19100__auto__){
var self__ = this;
var this__19098__auto____$1 = this;
var pr_pair__19101__auto__ = ((function (this__19098__auto____$1){
return (function (keyval__19102__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,cljs.core.pr_writer,""," ","",opts__19100__auto__,keyval__19102__auto__);
});})(this__19098__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,pr_pair__19101__auto__,"#schema.core.ConditionalSchema{",", ","}",opts__19100__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"preds-and-schemas","preds-and-schemas",-1306766355),self__.preds_and_schemas],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error-symbol","error-symbol",-823480428),self__.error_symbol],null))], null),self__.__extmap));
});

schema.core.ConditionalSchema.prototype.cljs$core$IIterable$ = true;

schema.core.ConditionalSchema.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__55441){
var self__ = this;
var G__55441__$1 = this;
return (new cljs.core.RecordIter((0),G__55441__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"preds-and-schemas","preds-and-schemas",-1306766355),new cljs.core.Keyword(null,"error-symbol","error-symbol",-823480428)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

schema.core.ConditionalSchema.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__19082__auto__){
var self__ = this;
var this__19082__auto____$1 = this;
return self__.__meta;
});

schema.core.ConditionalSchema.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__19078__auto__){
var self__ = this;
var this__19078__auto____$1 = this;
return (new schema.core.ConditionalSchema(self__.preds_and_schemas,self__.error_symbol,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.ConditionalSchema.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__19088__auto__){
var self__ = this;
var this__19088__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.ConditionalSchema.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__19079__auto__){
var self__ = this;
var this__19079__auto____$1 = this;
var h__18905__auto__ = self__.__hash;
if(!((h__18905__auto__ == null))){
return h__18905__auto__;
} else {
var h__18905__auto____$1 = cljs.core.hash_imap.call(null,this__19079__auto____$1);
self__.__hash = h__18905__auto____$1;

return h__18905__auto____$1;
}
});

schema.core.ConditionalSchema.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__19080__auto__,other__19081__auto__){
var self__ = this;
var this__19080__auto____$1 = this;
if(cljs.core.truth_((function (){var and__18477__auto__ = other__19081__auto__;
if(cljs.core.truth_(and__18477__auto__)){
var and__18477__auto____$1 = (this__19080__auto____$1.constructor === other__19081__auto__.constructor);
if(and__18477__auto____$1){
return cljs.core.equiv_map.call(null,this__19080__auto____$1,other__19081__auto__);
} else {
return and__18477__auto____$1;
}
} else {
return and__18477__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.ConditionalSchema.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__19093__auto__,k__19094__auto__){
var self__ = this;
var this__19093__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"preds-and-schemas","preds-and-schemas",-1306766355),null,new cljs.core.Keyword(null,"error-symbol","error-symbol",-823480428),null], null), null),k__19094__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__19093__auto____$1),self__.__meta),k__19094__auto__);
} else {
return (new schema.core.ConditionalSchema(self__.preds_and_schemas,self__.error_symbol,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__19094__auto__)),null));
}
});

schema.core.ConditionalSchema.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__19091__auto__,k__19092__auto__,G__55441){
var self__ = this;
var this__19091__auto____$1 = this;
var pred__55445 = cljs.core.keyword_identical_QMARK_;
var expr__55446 = k__19092__auto__;
if(cljs.core.truth_(pred__55445.call(null,new cljs.core.Keyword(null,"preds-and-schemas","preds-and-schemas",-1306766355),expr__55446))){
return (new schema.core.ConditionalSchema(G__55441,self__.error_symbol,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__55445.call(null,new cljs.core.Keyword(null,"error-symbol","error-symbol",-823480428),expr__55446))){
return (new schema.core.ConditionalSchema(self__.preds_and_schemas,G__55441,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.ConditionalSchema(self__.preds_and_schemas,self__.error_symbol,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__19092__auto__,G__55441),null));
}
}
});

schema.core.ConditionalSchema.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__19096__auto__){
var self__ = this;
var this__19096__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"preds-and-schemas","preds-and-schemas",-1306766355),self__.preds_and_schemas],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error-symbol","error-symbol",-823480428),self__.error_symbol],null))], null),self__.__extmap));
});

schema.core.ConditionalSchema.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__19083__auto__,G__55441){
var self__ = this;
var this__19083__auto____$1 = this;
return (new schema.core.ConditionalSchema(self__.preds_and_schemas,self__.error_symbol,G__55441,self__.__extmap,self__.__hash));
});

schema.core.ConditionalSchema.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__19089__auto__,entry__19090__auto__){
var self__ = this;
var this__19089__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__19090__auto__)){
return cljs.core._assoc.call(null,this__19089__auto____$1,cljs.core._nth.call(null,entry__19090__auto__,(0)),cljs.core._nth.call(null,entry__19090__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__19089__auto____$1,entry__19090__auto__);
}
});

schema.core.ConditionalSchema.prototype.schema$core$Schema$ = true;

schema.core.ConditionalSchema.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.variant.variant_spec.call(null,schema.spec.core._PLUS_no_precondition_PLUS_,(function (){var iter__19242__auto__ = ((function (this$__$1){
return (function schema$core$iter__55448(s__55449){
return (new cljs.core.LazySeq(null,((function (this$__$1){
return (function (){
var s__55449__$1 = s__55449;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__55449__$1);
if(temp__4425__auto__){
var s__55449__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__55449__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__55449__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__55451 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__55450 = (0);
while(true){
if((i__55450 < size__19241__auto__)){
var vec__55454 = cljs.core._nth.call(null,c__19240__auto__,i__55450);
var p = cljs.core.nth.call(null,vec__55454,(0),null);
var s = cljs.core.nth.call(null,vec__55454,(1),null);
cljs.core.chunk_append.call(null,b__55451,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"guard","guard",-873147811),p,new cljs.core.Keyword(null,"schema","schema",-1582001791),s], null));

var G__55459 = (i__55450 + (1));
i__55450 = G__55459;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55451),schema$core$iter__55448.call(null,cljs.core.chunk_rest.call(null,s__55449__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55451),null);
}
} else {
var vec__55455 = cljs.core.first.call(null,s__55449__$2);
var p = cljs.core.nth.call(null,vec__55455,(0),null);
var s = cljs.core.nth.call(null,vec__55455,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"guard","guard",-873147811),p,new cljs.core.Keyword(null,"schema","schema",-1582001791),s], null),schema$core$iter__55448.call(null,cljs.core.rest.call(null,s__55449__$2)));
}
} else {
return null;
}
break;
}
});})(this$__$1))
,null,null));
});})(this$__$1))
;
return iter__19242__auto__.call(null,self__.preds_and_schemas);
})(),((function (this$__$1){
return (function (p1__55440_SHARP_){
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,p1__55440_SHARP_),(function (){var or__18489__auto__ = self__.error_symbol;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,self__.preds_and_schemas))){
return cljs.core.symbol.call(null,schema.utils.fn_name.call(null,cljs.core.ffirst.call(null,self__.preds_and_schemas)));
} else {
return new cljs.core.Symbol(null,"some-matching-condition?","some-matching-condition?",1512398506,null);
}
}
})());
});})(this$__$1))
);
});

schema.core.ConditionalSchema.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons.call(null,new cljs.core.Symbol(null,"conditional","conditional",-1212542970,null),cljs.core.concat.call(null,cljs.core.mapcat.call(null,((function (this$__$1){
return (function (p__55456){
var vec__55457 = p__55456;
var pred = cljs.core.nth.call(null,vec__55457,(0),null);
var schema__$1 = cljs.core.nth.call(null,vec__55457,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,schema.utils.fn_name.call(null,pred)),schema.core.explain.call(null,schema__$1)], null);
});})(this$__$1))
,self__.preds_and_schemas),(cljs.core.truth_(self__.error_symbol)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.error_symbol], null):null)));
});

schema.core.ConditionalSchema.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"preds-and-schemas","preds-and-schemas",333765172,null),new cljs.core.Symbol(null,"error-symbol","error-symbol",817051099,null)], null);
});

schema.core.ConditionalSchema.cljs$lang$type = true;

schema.core.ConditionalSchema.cljs$lang$ctorPrSeq = (function (this__19118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/ConditionalSchema");
});

schema.core.ConditionalSchema.cljs$lang$ctorPrWriter = (function (this__19118__auto__,writer__19119__auto__){
return cljs.core._write.call(null,writer__19119__auto__,"schema.core/ConditionalSchema");
});

schema.core.__GT_ConditionalSchema = (function schema$core$__GT_ConditionalSchema(preds_and_schemas,error_symbol){
return (new schema.core.ConditionalSchema(preds_and_schemas,error_symbol,null,null,null));
});

schema.core.map__GT_ConditionalSchema = (function schema$core$map__GT_ConditionalSchema(G__55443){
return (new schema.core.ConditionalSchema(new cljs.core.Keyword(null,"preds-and-schemas","preds-and-schemas",-1306766355).cljs$core$IFn$_invoke$arity$1(G__55443),new cljs.core.Keyword(null,"error-symbol","error-symbol",-823480428).cljs$core$IFn$_invoke$arity$1(G__55443),null,cljs.core.dissoc.call(null,G__55443,new cljs.core.Keyword(null,"preds-and-schemas","preds-and-schemas",-1306766355),new cljs.core.Keyword(null,"error-symbol","error-symbol",-823480428)),null));
});

/**
 * Define a conditional schema.  Takes args like cond,
 * (conditional pred1 schema1 pred2 schema2 ...),
 * and checks the first schema where pred is true on the value.
 * Unlike cond, throws if the value does not match any condition.
 * :else may be used as a final condition in the place of (constantly true).
 * More efficient than either, since only one schema must be checked.
 * An optional final argument can be passed, a symbol to appear in
 * error messages when none of the conditions match.
 */
schema.core.conditional = (function schema$core$conditional(){
var args__19535__auto__ = [];
var len__19528__auto___55469 = arguments.length;
var i__19529__auto___55470 = (0);
while(true){
if((i__19529__auto___55470 < len__19528__auto___55469)){
args__19535__auto__.push((arguments[i__19529__auto___55470]));

var G__55471 = (i__19529__auto___55470 + (1));
i__19529__auto___55470 = G__55471;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((0) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((0)),(0))):null);
return schema.core.conditional.cljs$core$IFn$_invoke$arity$variadic(argseq__19536__auto__);
});

schema.core.conditional.cljs$core$IFn$_invoke$arity$variadic = (function (preds_and_schemas){
if((cljs.core.seq.call(null,preds_and_schemas)) && ((cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,preds_and_schemas))) || ((cljs.core.last.call(null,preds_and_schemas) instanceof cljs.core.Symbol)))){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Expected even, nonzero number of args (with optional trailing symbol); got %s",cljs.core.count.call(null,preds_and_schemas))));
}

return (new schema.core.ConditionalSchema((function (){var iter__19242__auto__ = (function schema$core$iter__55461(s__55462){
return (new cljs.core.LazySeq(null,(function (){
var s__55462__$1 = s__55462;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__55462__$1);
if(temp__4425__auto__){
var s__55462__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__55462__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__55462__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__55464 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__55463 = (0);
while(true){
if((i__55463 < size__19241__auto__)){
var vec__55467 = cljs.core._nth.call(null,c__19240__auto__,i__55463);
var pred = cljs.core.nth.call(null,vec__55467,(0),null);
var schema__$1 = cljs.core.nth.call(null,vec__55467,(1),null);
cljs.core.chunk_append.call(null,b__55464,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [((cljs.core._EQ_.call(null,pred,new cljs.core.Keyword(null,"else","else",-1508377146)))?cljs.core.constantly.call(null,true):pred),schema__$1], null));

var G__55472 = (i__55463 + (1));
i__55463 = G__55472;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55464),schema$core$iter__55461.call(null,cljs.core.chunk_rest.call(null,s__55462__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55464),null);
}
} else {
var vec__55468 = cljs.core.first.call(null,s__55462__$2);
var pred = cljs.core.nth.call(null,vec__55468,(0),null);
var schema__$1 = cljs.core.nth.call(null,vec__55468,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [((cljs.core._EQ_.call(null,pred,new cljs.core.Keyword(null,"else","else",-1508377146)))?cljs.core.constantly.call(null,true):pred),schema__$1], null),schema$core$iter__55461.call(null,cljs.core.rest.call(null,s__55462__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__19242__auto__.call(null,cljs.core.partition.call(null,(2),preds_and_schemas));
})(),((cljs.core.odd_QMARK_.call(null,cljs.core.count.call(null,preds_and_schemas)))?cljs.core.last.call(null,preds_and_schemas):null),null,null,null));
});

schema.core.conditional.cljs$lang$maxFixedArity = (0);

schema.core.conditional.cljs$lang$applyTo = (function (seq55460){
return schema.core.conditional.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq55460));
});

schema.core.HasPrecondition = {};

/**
 * Return a predicate representing the Precondition for this schema:
 * the predicate returns true if the precondition is satisfied.
 * (See spec.core for more details)
 */
schema.core.precondition = (function schema$core$precondition(this$){
if((!((this$ == null))) && (!((this$.schema$core$HasPrecondition$precondition$arity$1 == null)))){
return this$.schema$core$HasPrecondition$precondition$arity$1(this$);
} else {
var x__19125__auto__ = (((this$ == null))?null:this$);
var m__19126__auto__ = (schema.core.precondition[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,this$);
} else {
var m__19126__auto____$1 = (schema.core.precondition["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"HasPrecondition.precondition",this$);
}
}
}
});

schema.spec.leaf.LeafSpec.prototype.schema$core$HasPrecondition$ = true;

schema.spec.leaf.LeafSpec.prototype.schema$core$HasPrecondition$precondition$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.complement.call(null,this$__$1.pre);
});

schema.spec.variant.VariantSpec.prototype.schema$core$HasPrecondition$ = true;

schema.spec.variant.VariantSpec.prototype.schema$core$HasPrecondition$precondition$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.every_pred.call(null,cljs.core.complement.call(null,this$__$1.pre),cljs.core.apply.call(null,cljs.core.some_fn,(function (){var iter__19242__auto__ = ((function (this$__$1){
return (function schema$core$iter__55475(s__55476){
return (new cljs.core.LazySeq(null,((function (this$__$1){
return (function (){
var s__55476__$1 = s__55476;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__55476__$1);
if(temp__4425__auto__){
var s__55476__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__55476__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__55476__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__55478 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__55477 = (0);
while(true){
if((i__55477 < size__19241__auto__)){
var map__55483 = cljs.core._nth.call(null,c__19240__auto__,i__55477);
var map__55483__$1 = ((((!((map__55483 == null)))?((((map__55483.cljs$lang$protocol_mask$partition0$ & (64))) || (map__55483.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55483):map__55483);
var guard = cljs.core.get.call(null,map__55483__$1,new cljs.core.Keyword(null,"guard","guard",-873147811));
var schema__$1 = cljs.core.get.call(null,map__55483__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
cljs.core.chunk_append.call(null,b__55478,(cljs.core.truth_(guard)?cljs.core.every_pred.call(null,guard,schema.core.precondition.call(null,schema.core.spec.call(null,schema__$1))):schema.core.precondition.call(null,schema.core.spec.call(null,schema__$1))));

var G__55487 = (i__55477 + (1));
i__55477 = G__55487;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55478),schema$core$iter__55475.call(null,cljs.core.chunk_rest.call(null,s__55476__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55478),null);
}
} else {
var map__55485 = cljs.core.first.call(null,s__55476__$2);
var map__55485__$1 = ((((!((map__55485 == null)))?((((map__55485.cljs$lang$protocol_mask$partition0$ & (64))) || (map__55485.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55485):map__55485);
var guard = cljs.core.get.call(null,map__55485__$1,new cljs.core.Keyword(null,"guard","guard",-873147811));
var schema__$1 = cljs.core.get.call(null,map__55485__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
return cljs.core.cons.call(null,(cljs.core.truth_(guard)?cljs.core.every_pred.call(null,guard,schema.core.precondition.call(null,schema.core.spec.call(null,schema__$1))):schema.core.precondition.call(null,schema.core.spec.call(null,schema__$1))),schema$core$iter__55475.call(null,cljs.core.rest.call(null,s__55476__$2)));
}
} else {
return null;
}
break;
}
});})(this$__$1))
,null,null));
});})(this$__$1))
;
return iter__19242__auto__.call(null,this$__$1.options);
})()));
});

schema.spec.collection.CollectionSpec.prototype.schema$core$HasPrecondition$ = true;

schema.spec.collection.CollectionSpec.prototype.schema$core$HasPrecondition$precondition$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.complement.call(null,this$__$1.pre);
});

/**
* @constructor
* @param {*} schemas
* @param {*} __meta
* @param {*} __extmap
* @param {*} __hash
* @param {*=} __meta 
* @param {*=} __extmap
* @param {number|null} __hash
*/
schema.core.CondPre = (function (schemas,__meta,__extmap,__hash){
this.schemas = schemas;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.CondPre.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__19084__auto__,k__19085__auto__){
var self__ = this;
var this__19084__auto____$1 = this;
return cljs.core._lookup.call(null,this__19084__auto____$1,k__19085__auto__,null);
});

schema.core.CondPre.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__19086__auto__,k55490,else__19087__auto__){
var self__ = this;
var this__19086__auto____$1 = this;
var G__55492 = (((k55490 instanceof cljs.core.Keyword))?k55490.fqn:null);
switch (G__55492) {
case "schemas":
return self__.schemas;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k55490,else__19087__auto__);

}
});

schema.core.CondPre.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__19098__auto__,writer__19099__auto__,opts__19100__auto__){
var self__ = this;
var this__19098__auto____$1 = this;
var pr_pair__19101__auto__ = ((function (this__19098__auto____$1){
return (function (keyval__19102__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,cljs.core.pr_writer,""," ","",opts__19100__auto__,keyval__19102__auto__);
});})(this__19098__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,pr_pair__19101__auto__,"#schema.core.CondPre{",", ","}",opts__19100__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schemas","schemas",575070579),self__.schemas],null))], null),self__.__extmap));
});

schema.core.CondPre.prototype.cljs$core$IIterable$ = true;

schema.core.CondPre.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__55489){
var self__ = this;
var G__55489__$1 = this;
return (new cljs.core.RecordIter((0),G__55489__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schemas","schemas",575070579)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

schema.core.CondPre.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__19082__auto__){
var self__ = this;
var this__19082__auto____$1 = this;
return self__.__meta;
});

schema.core.CondPre.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__19078__auto__){
var self__ = this;
var this__19078__auto____$1 = this;
return (new schema.core.CondPre(self__.schemas,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.CondPre.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__19088__auto__){
var self__ = this;
var this__19088__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.CondPre.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__19079__auto__){
var self__ = this;
var this__19079__auto____$1 = this;
var h__18905__auto__ = self__.__hash;
if(!((h__18905__auto__ == null))){
return h__18905__auto__;
} else {
var h__18905__auto____$1 = cljs.core.hash_imap.call(null,this__19079__auto____$1);
self__.__hash = h__18905__auto____$1;

return h__18905__auto____$1;
}
});

schema.core.CondPre.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__19080__auto__,other__19081__auto__){
var self__ = this;
var this__19080__auto____$1 = this;
if(cljs.core.truth_((function (){var and__18477__auto__ = other__19081__auto__;
if(cljs.core.truth_(and__18477__auto__)){
var and__18477__auto____$1 = (this__19080__auto____$1.constructor === other__19081__auto__.constructor);
if(and__18477__auto____$1){
return cljs.core.equiv_map.call(null,this__19080__auto____$1,other__19081__auto__);
} else {
return and__18477__auto____$1;
}
} else {
return and__18477__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.CondPre.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__19093__auto__,k__19094__auto__){
var self__ = this;
var this__19093__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schemas","schemas",575070579),null], null), null),k__19094__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__19093__auto____$1),self__.__meta),k__19094__auto__);
} else {
return (new schema.core.CondPre(self__.schemas,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__19094__auto__)),null));
}
});

schema.core.CondPre.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__19091__auto__,k__19092__auto__,G__55489){
var self__ = this;
var this__19091__auto____$1 = this;
var pred__55493 = cljs.core.keyword_identical_QMARK_;
var expr__55494 = k__19092__auto__;
if(cljs.core.truth_(pred__55493.call(null,new cljs.core.Keyword(null,"schemas","schemas",575070579),expr__55494))){
return (new schema.core.CondPre(G__55489,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.CondPre(self__.schemas,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__19092__auto__,G__55489),null));
}
});

schema.core.CondPre.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__19096__auto__){
var self__ = this;
var this__19096__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schemas","schemas",575070579),self__.schemas],null))], null),self__.__extmap));
});

schema.core.CondPre.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__19083__auto__,G__55489){
var self__ = this;
var this__19083__auto____$1 = this;
return (new schema.core.CondPre(self__.schemas,G__55489,self__.__extmap,self__.__hash));
});

schema.core.CondPre.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__19089__auto__,entry__19090__auto__){
var self__ = this;
var this__19089__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__19090__auto__)){
return cljs.core._assoc.call(null,this__19089__auto____$1,cljs.core._nth.call(null,entry__19090__auto__,(0)),cljs.core._nth.call(null,entry__19090__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__19089__auto____$1,entry__19090__auto__);
}
});

schema.core.CondPre.prototype.schema$core$Schema$ = true;

schema.core.CondPre.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.variant.variant_spec.call(null,schema.spec.core._PLUS_no_precondition_PLUS_,(function (){var iter__19242__auto__ = ((function (this$__$1){
return (function schema$core$iter__55496(s__55497){
return (new cljs.core.LazySeq(null,((function (this$__$1){
return (function (){
var s__55497__$1 = s__55497;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__55497__$1);
if(temp__4425__auto__){
var s__55497__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__55497__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__55497__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__55499 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__55498 = (0);
while(true){
if((i__55498 < size__19241__auto__)){
var s = cljs.core._nth.call(null,c__19240__auto__,i__55498);
cljs.core.chunk_append.call(null,b__55499,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"guard","guard",-873147811),schema.core.precondition.call(null,schema.core.spec.call(null,s)),new cljs.core.Keyword(null,"schema","schema",-1582001791),s], null));

var G__55501 = (i__55498 + (1));
i__55498 = G__55501;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55499),schema$core$iter__55496.call(null,cljs.core.chunk_rest.call(null,s__55497__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55499),null);
}
} else {
var s = cljs.core.first.call(null,s__55497__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"guard","guard",-873147811),schema.core.precondition.call(null,schema.core.spec.call(null,s)),new cljs.core.Keyword(null,"schema","schema",-1582001791),s], null),schema$core$iter__55496.call(null,cljs.core.rest.call(null,s__55497__$2)));
}
} else {
return null;
}
break;
}
});})(this$__$1))
,null,null));
});})(this$__$1))
;
return iter__19242__auto__.call(null,self__.schemas);
})(),((function (this$__$1){
return (function (p1__55488_SHARP_){
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,p1__55488_SHARP_),new cljs.core.Symbol(null,"matches-some-precondition?","matches-some-precondition?",2123072832,null));
});})(this$__$1))
);
});

schema.core.CondPre.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons.call(null,new cljs.core.Symbol(null,"cond-pre","cond-pre",-923707731,null),cljs.core.map.call(null,schema.core.explain,self__.schemas));
});

schema.core.CondPre.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"schemas","schemas",-2079365190,null)], null);
});

schema.core.CondPre.cljs$lang$type = true;

schema.core.CondPre.cljs$lang$ctorPrSeq = (function (this__19118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/CondPre");
});

schema.core.CondPre.cljs$lang$ctorPrWriter = (function (this__19118__auto__,writer__19119__auto__){
return cljs.core._write.call(null,writer__19119__auto__,"schema.core/CondPre");
});

schema.core.__GT_CondPre = (function schema$core$__GT_CondPre(schemas){
return (new schema.core.CondPre(schemas,null,null,null));
});

schema.core.map__GT_CondPre = (function schema$core$map__GT_CondPre(G__55491){
return (new schema.core.CondPre(new cljs.core.Keyword(null,"schemas","schemas",575070579).cljs$core$IFn$_invoke$arity$1(G__55491),null,cljs.core.dissoc.call(null,G__55491,new cljs.core.Keyword(null,"schemas","schemas",575070579)),null));
});

/**
 * A replacement for `either` that constructs a conditional schema
 * based on the schema spec preconditions of the component schemas.
 * 
 * EXPERIMENTAL
 */
schema.core.cond_pre = (function schema$core$cond_pre(){
var args__19535__auto__ = [];
var len__19528__auto___55503 = arguments.length;
var i__19529__auto___55504 = (0);
while(true){
if((i__19529__auto___55504 < len__19528__auto___55503)){
args__19535__auto__.push((arguments[i__19529__auto___55504]));

var G__55505 = (i__19529__auto___55504 + (1));
i__19529__auto___55504 = G__55505;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((0) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((0)),(0))):null);
return schema.core.cond_pre.cljs$core$IFn$_invoke$arity$variadic(argseq__19536__auto__);
});

schema.core.cond_pre.cljs$core$IFn$_invoke$arity$variadic = (function (schemas){
return (new schema.core.CondPre(schemas,null,null,null));
});

schema.core.cond_pre.cljs$lang$maxFixedArity = (0);

schema.core.cond_pre.cljs$lang$applyTo = (function (seq55502){
return schema.core.cond_pre.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq55502));
});

/**
* @constructor
* @param {*} schemas
* @param {*} __meta
* @param {*} __extmap
* @param {*} __hash
* @param {*=} __meta 
* @param {*=} __extmap
* @param {number|null} __hash
*/
schema.core.Both = (function (schemas,__meta,__extmap,__hash){
this.schemas = schemas;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.Both.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__19084__auto__,k__19085__auto__){
var self__ = this;
var this__19084__auto____$1 = this;
return cljs.core._lookup.call(null,this__19084__auto____$1,k__19085__auto__,null);
});

schema.core.Both.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__19086__auto__,k55508,else__19087__auto__){
var self__ = this;
var this__19086__auto____$1 = this;
var G__55510 = (((k55508 instanceof cljs.core.Keyword))?k55508.fqn:null);
switch (G__55510) {
case "schemas":
return self__.schemas;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k55508,else__19087__auto__);

}
});

schema.core.Both.prototype.schema$spec$core$CoreSpec$ = true;

schema.core.Both.prototype.schema$spec$core$CoreSpec$subschemas$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.schemas;
});

schema.core.Both.prototype.schema$spec$core$CoreSpec$checker$arity$2 = (function (this$,params){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.call(null,((function (this$__$1){
return (function (f,t){
return ((function (this$__$1){
return (function (x){
var tx = t.call(null,x);
if(cljs.core.truth_(schema.utils.error_QMARK_.call(null,tx))){
return tx;
} else {
return f.call(null,(function (){var or__18489__auto__ = tx;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return x;
}
})());
}
});
;})(this$__$1))
});})(this$__$1))
,cljs.core.map.call(null,((function (this$__$1){
return (function (p1__55506_SHARP_){
return schema.spec.core.sub_checker.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),p1__55506_SHARP_], null),params);
});})(this$__$1))
,cljs.core.reverse.call(null,self__.schemas)));
});

schema.core.Both.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__19098__auto__,writer__19099__auto__,opts__19100__auto__){
var self__ = this;
var this__19098__auto____$1 = this;
var pr_pair__19101__auto__ = ((function (this__19098__auto____$1){
return (function (keyval__19102__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,cljs.core.pr_writer,""," ","",opts__19100__auto__,keyval__19102__auto__);
});})(this__19098__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,pr_pair__19101__auto__,"#schema.core.Both{",", ","}",opts__19100__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schemas","schemas",575070579),self__.schemas],null))], null),self__.__extmap));
});

schema.core.Both.prototype.cljs$core$IIterable$ = true;

schema.core.Both.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__55507){
var self__ = this;
var G__55507__$1 = this;
return (new cljs.core.RecordIter((0),G__55507__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schemas","schemas",575070579)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

schema.core.Both.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__19082__auto__){
var self__ = this;
var this__19082__auto____$1 = this;
return self__.__meta;
});

schema.core.Both.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__19078__auto__){
var self__ = this;
var this__19078__auto____$1 = this;
return (new schema.core.Both(self__.schemas,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.Both.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__19088__auto__){
var self__ = this;
var this__19088__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.Both.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__19079__auto__){
var self__ = this;
var this__19079__auto____$1 = this;
var h__18905__auto__ = self__.__hash;
if(!((h__18905__auto__ == null))){
return h__18905__auto__;
} else {
var h__18905__auto____$1 = cljs.core.hash_imap.call(null,this__19079__auto____$1);
self__.__hash = h__18905__auto____$1;

return h__18905__auto____$1;
}
});

schema.core.Both.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__19080__auto__,other__19081__auto__){
var self__ = this;
var this__19080__auto____$1 = this;
if(cljs.core.truth_((function (){var and__18477__auto__ = other__19081__auto__;
if(cljs.core.truth_(and__18477__auto__)){
var and__18477__auto____$1 = (this__19080__auto____$1.constructor === other__19081__auto__.constructor);
if(and__18477__auto____$1){
return cljs.core.equiv_map.call(null,this__19080__auto____$1,other__19081__auto__);
} else {
return and__18477__auto____$1;
}
} else {
return and__18477__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.Both.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__19093__auto__,k__19094__auto__){
var self__ = this;
var this__19093__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schemas","schemas",575070579),null], null), null),k__19094__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__19093__auto____$1),self__.__meta),k__19094__auto__);
} else {
return (new schema.core.Both(self__.schemas,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__19094__auto__)),null));
}
});

schema.core.Both.prototype.schema$core$HasPrecondition$ = true;

schema.core.Both.prototype.schema$core$HasPrecondition$precondition$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.apply.call(null,cljs.core.every_pred,cljs.core.map.call(null,cljs.core.comp.call(null,schema.core.precondition,schema.core.spec),self__.schemas));
});

schema.core.Both.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__19091__auto__,k__19092__auto__,G__55507){
var self__ = this;
var this__19091__auto____$1 = this;
var pred__55511 = cljs.core.keyword_identical_QMARK_;
var expr__55512 = k__19092__auto__;
if(cljs.core.truth_(pred__55511.call(null,new cljs.core.Keyword(null,"schemas","schemas",575070579),expr__55512))){
return (new schema.core.Both(G__55507,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.Both(self__.schemas,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__19092__auto__,G__55507),null));
}
});

schema.core.Both.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__19096__auto__){
var self__ = this;
var this__19096__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schemas","schemas",575070579),self__.schemas],null))], null),self__.__extmap));
});

schema.core.Both.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__19083__auto__,G__55507){
var self__ = this;
var this__19083__auto____$1 = this;
return (new schema.core.Both(self__.schemas,G__55507,self__.__extmap,self__.__hash));
});

schema.core.Both.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__19089__auto__,entry__19090__auto__){
var self__ = this;
var this__19089__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__19090__auto__)){
return cljs.core._assoc.call(null,this__19089__auto____$1,cljs.core._nth.call(null,entry__19090__auto__,(0)),cljs.core._nth.call(null,entry__19090__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__19089__auto____$1,entry__19090__auto__);
}
});

schema.core.Both.prototype.schema$core$Schema$ = true;

schema.core.Both.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

schema.core.Both.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons.call(null,new cljs.core.Symbol(null,"both","both",1246882687,null),cljs.core.map.call(null,schema.core.explain,self__.schemas));
});

schema.core.Both.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"schemas","schemas",-2079365190,null)], null);
});

schema.core.Both.cljs$lang$type = true;

schema.core.Both.cljs$lang$ctorPrSeq = (function (this__19118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/Both");
});

schema.core.Both.cljs$lang$ctorPrWriter = (function (this__19118__auto__,writer__19119__auto__){
return cljs.core._write.call(null,writer__19119__auto__,"schema.core/Both");
});

schema.core.__GT_Both = (function schema$core$__GT_Both(schemas){
return (new schema.core.Both(schemas,null,null,null));
});

schema.core.map__GT_Both = (function schema$core$map__GT_Both(G__55509){
return (new schema.core.Both(new cljs.core.Keyword(null,"schemas","schemas",575070579).cljs$core$IFn$_invoke$arity$1(G__55509),null,cljs.core.dissoc.call(null,G__55509,new cljs.core.Keyword(null,"schemas","schemas",575070579)),null));
});

/**
 * A value that must satisfy every schema in schemas.
 * 
 * DEPRECATED: prefer 'conditional' with a single condition
 * instead.
 * 
 * When used with coercion, coerces each schema in sequence.
 */
schema.core.both = (function schema$core$both(){
var args__19535__auto__ = [];
var len__19528__auto___55516 = arguments.length;
var i__19529__auto___55517 = (0);
while(true){
if((i__19529__auto___55517 < len__19528__auto___55516)){
args__19535__auto__.push((arguments[i__19529__auto___55517]));

var G__55518 = (i__19529__auto___55517 + (1));
i__19529__auto___55517 = G__55518;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((0) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((0)),(0))):null);
return schema.core.both.cljs$core$IFn$_invoke$arity$variadic(argseq__19536__auto__);
});

schema.core.both.cljs$core$IFn$_invoke$arity$variadic = (function (schemas){
return (new schema.core.Both(schemas,null,null,null));
});

schema.core.both.cljs$lang$maxFixedArity = (0);

schema.core.both.cljs$lang$applyTo = (function (seq55515){
return schema.core.both.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq55515));
});
/**
 * if the predicate returns truthy, use the if-schema, otherwise use the else-schema
 */
schema.core.if$ = (function schema$core$if(pred,if_schema,else_schema){
return schema.core.conditional.call(null,pred,if_schema,cljs.core.constantly.call(null,true),else_schema);
});
schema.core.var_name = (function schema$core$var_name(v){
var map__55521 = cljs.core.meta.call(null,v);
var map__55521__$1 = ((((!((map__55521 == null)))?((((map__55521.cljs$lang$protocol_mask$partition0$ & (64))) || (map__55521.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55521):map__55521);
var ns = cljs.core.get.call(null,map__55521__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var name = cljs.core.get.call(null,map__55521__$1,new cljs.core.Keyword(null,"name","name",1843675177));
return cljs.core.symbol.call(null,[cljs.core.str(ns),cljs.core.str("/"),cljs.core.str(name)].join(''));
});

/**
* @constructor
* @param {*} derefable
* @param {*} __meta
* @param {*} __extmap
* @param {*} __hash
* @param {*=} __meta 
* @param {*=} __extmap
* @param {number|null} __hash
*/
schema.core.Recursive = (function (derefable,__meta,__extmap,__hash){
this.derefable = derefable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.Recursive.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__19084__auto__,k__19085__auto__){
var self__ = this;
var this__19084__auto____$1 = this;
return cljs.core._lookup.call(null,this__19084__auto____$1,k__19085__auto__,null);
});

schema.core.Recursive.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__19086__auto__,k55524,else__19087__auto__){
var self__ = this;
var this__19086__auto____$1 = this;
var G__55526 = (((k55524 instanceof cljs.core.Keyword))?k55524.fqn:null);
switch (G__55526) {
case "derefable":
return self__.derefable;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k55524,else__19087__auto__);

}
});

schema.core.Recursive.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__19098__auto__,writer__19099__auto__,opts__19100__auto__){
var self__ = this;
var this__19098__auto____$1 = this;
var pr_pair__19101__auto__ = ((function (this__19098__auto____$1){
return (function (keyval__19102__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,cljs.core.pr_writer,""," ","",opts__19100__auto__,keyval__19102__auto__);
});})(this__19098__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,pr_pair__19101__auto__,"#schema.core.Recursive{",", ","}",opts__19100__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"derefable","derefable",377265868),self__.derefable],null))], null),self__.__extmap));
});

schema.core.Recursive.prototype.cljs$core$IIterable$ = true;

schema.core.Recursive.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__55523){
var self__ = this;
var G__55523__$1 = this;
return (new cljs.core.RecordIter((0),G__55523__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"derefable","derefable",377265868)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

schema.core.Recursive.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__19082__auto__){
var self__ = this;
var this__19082__auto____$1 = this;
return self__.__meta;
});

schema.core.Recursive.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__19078__auto__){
var self__ = this;
var this__19078__auto____$1 = this;
return (new schema.core.Recursive(self__.derefable,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.Recursive.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__19088__auto__){
var self__ = this;
var this__19088__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.Recursive.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__19079__auto__){
var self__ = this;
var this__19079__auto____$1 = this;
var h__18905__auto__ = self__.__hash;
if(!((h__18905__auto__ == null))){
return h__18905__auto__;
} else {
var h__18905__auto____$1 = cljs.core.hash_imap.call(null,this__19079__auto____$1);
self__.__hash = h__18905__auto____$1;

return h__18905__auto____$1;
}
});

schema.core.Recursive.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__19080__auto__,other__19081__auto__){
var self__ = this;
var this__19080__auto____$1 = this;
if(cljs.core.truth_((function (){var and__18477__auto__ = other__19081__auto__;
if(cljs.core.truth_(and__18477__auto__)){
var and__18477__auto____$1 = (this__19080__auto____$1.constructor === other__19081__auto__.constructor);
if(and__18477__auto____$1){
return cljs.core.equiv_map.call(null,this__19080__auto____$1,other__19081__auto__);
} else {
return and__18477__auto____$1;
}
} else {
return and__18477__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.Recursive.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__19093__auto__,k__19094__auto__){
var self__ = this;
var this__19093__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"derefable","derefable",377265868),null], null), null),k__19094__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__19093__auto____$1),self__.__meta),k__19094__auto__);
} else {
return (new schema.core.Recursive(self__.derefable,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__19094__auto__)),null));
}
});

schema.core.Recursive.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__19091__auto__,k__19092__auto__,G__55523){
var self__ = this;
var this__19091__auto____$1 = this;
var pred__55527 = cljs.core.keyword_identical_QMARK_;
var expr__55528 = k__19092__auto__;
if(cljs.core.truth_(pred__55527.call(null,new cljs.core.Keyword(null,"derefable","derefable",377265868),expr__55528))){
return (new schema.core.Recursive(G__55523,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.Recursive(self__.derefable,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__19092__auto__,G__55523),null));
}
});

schema.core.Recursive.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__19096__auto__){
var self__ = this;
var this__19096__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"derefable","derefable",377265868),self__.derefable],null))], null),self__.__extmap));
});

schema.core.Recursive.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__19083__auto__,G__55523){
var self__ = this;
var this__19083__auto____$1 = this;
return (new schema.core.Recursive(self__.derefable,G__55523,self__.__extmap,self__.__hash));
});

schema.core.Recursive.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__19089__auto__,entry__19090__auto__){
var self__ = this;
var this__19089__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__19090__auto__)){
return cljs.core._assoc.call(null,this__19089__auto____$1,cljs.core._nth.call(null,entry__19090__auto__,(0)),cljs.core._nth.call(null,entry__19090__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__19089__auto____$1,entry__19090__auto__);
}
});

schema.core.Recursive.prototype.schema$core$Schema$ = true;

schema.core.Recursive.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.variant.variant_spec.call(null,schema.spec.core._PLUS_no_precondition_PLUS_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.deref.call(null,self__.derefable)], null)], null));
});

schema.core.Recursive.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,(((self__.derefable instanceof cljs.core.Var))?cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,schema.core.var_name.call(null,self__.derefable)),new cljs.core.Symbol(null,"var","var",870848730,null)):new cljs.core.Symbol(null,"...","...",-1926939749,null))),new cljs.core.Symbol(null,"recursive","recursive",-1935549897,null));
});

schema.core.Recursive.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"derefable","derefable",2017797395,null)], null);
});

schema.core.Recursive.cljs$lang$type = true;

schema.core.Recursive.cljs$lang$ctorPrSeq = (function (this__19118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/Recursive");
});

schema.core.Recursive.cljs$lang$ctorPrWriter = (function (this__19118__auto__,writer__19119__auto__){
return cljs.core._write.call(null,writer__19119__auto__,"schema.core/Recursive");
});

schema.core.__GT_Recursive = (function schema$core$__GT_Recursive(derefable){
return (new schema.core.Recursive(derefable,null,null,null));
});

schema.core.map__GT_Recursive = (function schema$core$map__GT_Recursive(G__55525){
return (new schema.core.Recursive(new cljs.core.Keyword(null,"derefable","derefable",377265868).cljs$core$IFn$_invoke$arity$1(G__55525),null,cljs.core.dissoc.call(null,G__55525,new cljs.core.Keyword(null,"derefable","derefable",377265868)),null));
});

/**
 * Support for (mutually) recursive schemas by passing a var that points to a schema,
 * e.g (recursive #'ExampleRecursiveSchema).
 */
schema.core.recursive = (function schema$core$recursive(schema__$1){
if(((!((schema__$1 == null)))?((((schema__$1.cljs$lang$protocol_mask$partition0$ & (32768))) || (schema__$1.cljs$core$IDeref$))?true:(((!schema__$1.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IDeref,schema__$1):false)):cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IDeref,schema__$1))){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Not an IDeref: %s",schema__$1)));
}

return (new schema.core.Recursive(schema__$1,null,null,null));
});

/**
* @constructor
* @param {*} k
* @param {*} __meta
* @param {*} __extmap
* @param {*} __hash
* @param {*=} __meta 
* @param {*=} __extmap
* @param {number|null} __hash
*/
schema.core.RequiredKey = (function (k,__meta,__extmap,__hash){
this.k = k;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.RequiredKey.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__19084__auto__,k__19085__auto__){
var self__ = this;
var this__19084__auto____$1 = this;
return cljs.core._lookup.call(null,this__19084__auto____$1,k__19085__auto__,null);
});

schema.core.RequiredKey.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__19086__auto__,k55534,else__19087__auto__){
var self__ = this;
var this__19086__auto____$1 = this;
var G__55536 = (((k55534 instanceof cljs.core.Keyword))?k55534.fqn:null);
switch (G__55536) {
case "k":
return self__.k;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k55534,else__19087__auto__);

}
});

schema.core.RequiredKey.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__19098__auto__,writer__19099__auto__,opts__19100__auto__){
var self__ = this;
var this__19098__auto____$1 = this;
var pr_pair__19101__auto__ = ((function (this__19098__auto____$1){
return (function (keyval__19102__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,cljs.core.pr_writer,""," ","",opts__19100__auto__,keyval__19102__auto__);
});})(this__19098__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,pr_pair__19101__auto__,"#schema.core.RequiredKey{",", ","}",opts__19100__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"k","k",-2146297393),self__.k],null))], null),self__.__extmap));
});

schema.core.RequiredKey.prototype.cljs$core$IIterable$ = true;

schema.core.RequiredKey.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__55533){
var self__ = this;
var G__55533__$1 = this;
return (new cljs.core.RecordIter((0),G__55533__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"k","k",-2146297393)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

schema.core.RequiredKey.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__19082__auto__){
var self__ = this;
var this__19082__auto____$1 = this;
return self__.__meta;
});

schema.core.RequiredKey.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__19078__auto__){
var self__ = this;
var this__19078__auto____$1 = this;
return (new schema.core.RequiredKey(self__.k,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.RequiredKey.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__19088__auto__){
var self__ = this;
var this__19088__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.RequiredKey.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__19079__auto__){
var self__ = this;
var this__19079__auto____$1 = this;
var h__18905__auto__ = self__.__hash;
if(!((h__18905__auto__ == null))){
return h__18905__auto__;
} else {
var h__18905__auto____$1 = cljs.core.hash_imap.call(null,this__19079__auto____$1);
self__.__hash = h__18905__auto____$1;

return h__18905__auto____$1;
}
});

schema.core.RequiredKey.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__19080__auto__,other__19081__auto__){
var self__ = this;
var this__19080__auto____$1 = this;
if(cljs.core.truth_((function (){var and__18477__auto__ = other__19081__auto__;
if(cljs.core.truth_(and__18477__auto__)){
var and__18477__auto____$1 = (this__19080__auto____$1.constructor === other__19081__auto__.constructor);
if(and__18477__auto____$1){
return cljs.core.equiv_map.call(null,this__19080__auto____$1,other__19081__auto__);
} else {
return and__18477__auto____$1;
}
} else {
return and__18477__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.RequiredKey.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__19093__auto__,k__19094__auto__){
var self__ = this;
var this__19093__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"k","k",-2146297393),null], null), null),k__19094__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__19093__auto____$1),self__.__meta),k__19094__auto__);
} else {
return (new schema.core.RequiredKey(self__.k,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__19094__auto__)),null));
}
});

schema.core.RequiredKey.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__19091__auto__,k__19092__auto__,G__55533){
var self__ = this;
var this__19091__auto____$1 = this;
var pred__55537 = cljs.core.keyword_identical_QMARK_;
var expr__55538 = k__19092__auto__;
if(cljs.core.truth_(pred__55537.call(null,new cljs.core.Keyword(null,"k","k",-2146297393),expr__55538))){
return (new schema.core.RequiredKey(G__55533,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.RequiredKey(self__.k,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__19092__auto__,G__55533),null));
}
});

schema.core.RequiredKey.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__19096__auto__){
var self__ = this;
var this__19096__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"k","k",-2146297393),self__.k],null))], null),self__.__extmap));
});

schema.core.RequiredKey.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__19083__auto__,G__55533){
var self__ = this;
var this__19083__auto____$1 = this;
return (new schema.core.RequiredKey(self__.k,G__55533,self__.__extmap,self__.__hash));
});

schema.core.RequiredKey.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__19089__auto__,entry__19090__auto__){
var self__ = this;
var this__19089__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__19090__auto__)){
return cljs.core._assoc.call(null,this__19089__auto____$1,cljs.core._nth.call(null,entry__19090__auto__,(0)),cljs.core._nth.call(null,entry__19090__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__19089__auto____$1,entry__19090__auto__);
}
});

schema.core.RequiredKey.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"k","k",-505765866,null)], null);
});

schema.core.RequiredKey.cljs$lang$type = true;

schema.core.RequiredKey.cljs$lang$ctorPrSeq = (function (this__19118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/RequiredKey");
});

schema.core.RequiredKey.cljs$lang$ctorPrWriter = (function (this__19118__auto__,writer__19119__auto__){
return cljs.core._write.call(null,writer__19119__auto__,"schema.core/RequiredKey");
});

schema.core.__GT_RequiredKey = (function schema$core$__GT_RequiredKey(k){
return (new schema.core.RequiredKey(k,null,null,null));
});

schema.core.map__GT_RequiredKey = (function schema$core$map__GT_RequiredKey(G__55535){
return (new schema.core.RequiredKey(new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(G__55535),null,cljs.core.dissoc.call(null,G__55535,new cljs.core.Keyword(null,"k","k",-2146297393)),null));
});

/**
 * A required key in a map
 */
schema.core.required_key = (function schema$core$required_key(k){
if((k instanceof cljs.core.Keyword)){
return k;
} else {
return (new schema.core.RequiredKey(k,null,null,null));
}
});
schema.core.required_key_QMARK_ = (function schema$core$required_key_QMARK_(ks){
return ((ks instanceof cljs.core.Keyword)) || ((ks instanceof schema.core.RequiredKey));
});

/**
* @constructor
* @param {*} k
* @param {*} __meta
* @param {*} __extmap
* @param {*} __hash
* @param {*=} __meta 
* @param {*=} __extmap
* @param {number|null} __hash
*/
schema.core.OptionalKey = (function (k,__meta,__extmap,__hash){
this.k = k;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.OptionalKey.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__19084__auto__,k__19085__auto__){
var self__ = this;
var this__19084__auto____$1 = this;
return cljs.core._lookup.call(null,this__19084__auto____$1,k__19085__auto__,null);
});

schema.core.OptionalKey.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__19086__auto__,k55542,else__19087__auto__){
var self__ = this;
var this__19086__auto____$1 = this;
var G__55544 = (((k55542 instanceof cljs.core.Keyword))?k55542.fqn:null);
switch (G__55544) {
case "k":
return self__.k;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k55542,else__19087__auto__);

}
});

schema.core.OptionalKey.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__19098__auto__,writer__19099__auto__,opts__19100__auto__){
var self__ = this;
var this__19098__auto____$1 = this;
var pr_pair__19101__auto__ = ((function (this__19098__auto____$1){
return (function (keyval__19102__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,cljs.core.pr_writer,""," ","",opts__19100__auto__,keyval__19102__auto__);
});})(this__19098__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,pr_pair__19101__auto__,"#schema.core.OptionalKey{",", ","}",opts__19100__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"k","k",-2146297393),self__.k],null))], null),self__.__extmap));
});

schema.core.OptionalKey.prototype.cljs$core$IIterable$ = true;

schema.core.OptionalKey.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__55541){
var self__ = this;
var G__55541__$1 = this;
return (new cljs.core.RecordIter((0),G__55541__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"k","k",-2146297393)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

schema.core.OptionalKey.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__19082__auto__){
var self__ = this;
var this__19082__auto____$1 = this;
return self__.__meta;
});

schema.core.OptionalKey.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__19078__auto__){
var self__ = this;
var this__19078__auto____$1 = this;
return (new schema.core.OptionalKey(self__.k,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.OptionalKey.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__19088__auto__){
var self__ = this;
var this__19088__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.OptionalKey.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__19079__auto__){
var self__ = this;
var this__19079__auto____$1 = this;
var h__18905__auto__ = self__.__hash;
if(!((h__18905__auto__ == null))){
return h__18905__auto__;
} else {
var h__18905__auto____$1 = cljs.core.hash_imap.call(null,this__19079__auto____$1);
self__.__hash = h__18905__auto____$1;

return h__18905__auto____$1;
}
});

schema.core.OptionalKey.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__19080__auto__,other__19081__auto__){
var self__ = this;
var this__19080__auto____$1 = this;
if(cljs.core.truth_((function (){var and__18477__auto__ = other__19081__auto__;
if(cljs.core.truth_(and__18477__auto__)){
var and__18477__auto____$1 = (this__19080__auto____$1.constructor === other__19081__auto__.constructor);
if(and__18477__auto____$1){
return cljs.core.equiv_map.call(null,this__19080__auto____$1,other__19081__auto__);
} else {
return and__18477__auto____$1;
}
} else {
return and__18477__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.OptionalKey.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__19093__auto__,k__19094__auto__){
var self__ = this;
var this__19093__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"k","k",-2146297393),null], null), null),k__19094__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__19093__auto____$1),self__.__meta),k__19094__auto__);
} else {
return (new schema.core.OptionalKey(self__.k,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__19094__auto__)),null));
}
});

schema.core.OptionalKey.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__19091__auto__,k__19092__auto__,G__55541){
var self__ = this;
var this__19091__auto____$1 = this;
var pred__55545 = cljs.core.keyword_identical_QMARK_;
var expr__55546 = k__19092__auto__;
if(cljs.core.truth_(pred__55545.call(null,new cljs.core.Keyword(null,"k","k",-2146297393),expr__55546))){
return (new schema.core.OptionalKey(G__55541,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.OptionalKey(self__.k,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__19092__auto__,G__55541),null));
}
});

schema.core.OptionalKey.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__19096__auto__){
var self__ = this;
var this__19096__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"k","k",-2146297393),self__.k],null))], null),self__.__extmap));
});

schema.core.OptionalKey.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__19083__auto__,G__55541){
var self__ = this;
var this__19083__auto____$1 = this;
return (new schema.core.OptionalKey(self__.k,G__55541,self__.__extmap,self__.__hash));
});

schema.core.OptionalKey.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__19089__auto__,entry__19090__auto__){
var self__ = this;
var this__19089__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__19090__auto__)){
return cljs.core._assoc.call(null,this__19089__auto____$1,cljs.core._nth.call(null,entry__19090__auto__,(0)),cljs.core._nth.call(null,entry__19090__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__19089__auto____$1,entry__19090__auto__);
}
});

schema.core.OptionalKey.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"k","k",-505765866,null)], null);
});

schema.core.OptionalKey.cljs$lang$type = true;

schema.core.OptionalKey.cljs$lang$ctorPrSeq = (function (this__19118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/OptionalKey");
});

schema.core.OptionalKey.cljs$lang$ctorPrWriter = (function (this__19118__auto__,writer__19119__auto__){
return cljs.core._write.call(null,writer__19119__auto__,"schema.core/OptionalKey");
});

schema.core.__GT_OptionalKey = (function schema$core$__GT_OptionalKey(k){
return (new schema.core.OptionalKey(k,null,null,null));
});

schema.core.map__GT_OptionalKey = (function schema$core$map__GT_OptionalKey(G__55543){
return (new schema.core.OptionalKey(new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(G__55543),null,cljs.core.dissoc.call(null,G__55543,new cljs.core.Keyword(null,"k","k",-2146297393)),null));
});

/**
 * An optional key in a map
 */
schema.core.optional_key = (function schema$core$optional_key(k){
return (new schema.core.OptionalKey(k,null,null,null));
});
schema.core.optional_key_QMARK_ = (function schema$core$optional_key_QMARK_(ks){
return (ks instanceof schema.core.OptionalKey);
});
schema.core.explicit_schema_key = (function schema$core$explicit_schema_key(ks){
if((ks instanceof cljs.core.Keyword)){
return ks;
} else {
if((ks instanceof schema.core.RequiredKey)){
return ks.k;
} else {
if(cljs.core.truth_(schema.core.optional_key_QMARK_.call(null,ks))){
return ks.k;
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Bad explicit key: %s",ks)));

}
}
}
});
schema.core.specific_key_QMARK_ = (function schema$core$specific_key_QMARK_(ks){
var or__18489__auto__ = schema.core.required_key_QMARK_.call(null,ks);
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return schema.core.optional_key_QMARK_.call(null,ks);
}
});

/**
* @constructor
* @param {*} key_schema
* @param {*} val_schema
* @param {*} __meta
* @param {*} __extmap
* @param {*} __hash
* @param {*=} __meta 
* @param {*=} __extmap
* @param {number|null} __hash
*/
schema.core.MapEntry = (function (key_schema,val_schema,__meta,__extmap,__hash){
this.key_schema = key_schema;
this.val_schema = val_schema;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.MapEntry.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__19084__auto__,k__19085__auto__){
var self__ = this;
var this__19084__auto____$1 = this;
return cljs.core._lookup.call(null,this__19084__auto____$1,k__19085__auto__,null);
});

schema.core.MapEntry.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__19086__auto__,k55550,else__19087__auto__){
var self__ = this;
var this__19086__auto____$1 = this;
var G__55552 = (((k55550 instanceof cljs.core.Keyword))?k55550.fqn:null);
switch (G__55552) {
case "key-schema":
return self__.key_schema;

break;
case "val-schema":
return self__.val_schema;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k55550,else__19087__auto__);

}
});

schema.core.MapEntry.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__19098__auto__,writer__19099__auto__,opts__19100__auto__){
var self__ = this;
var this__19098__auto____$1 = this;
var pr_pair__19101__auto__ = ((function (this__19098__auto____$1){
return (function (keyval__19102__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,cljs.core.pr_writer,""," ","",opts__19100__auto__,keyval__19102__auto__);
});})(this__19098__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,pr_pair__19101__auto__,"#schema.core.MapEntry{",", ","}",opts__19100__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"key-schema","key-schema",-1096660726),self__.key_schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"val-schema","val-schema",-2014773619),self__.val_schema],null))], null),self__.__extmap));
});

schema.core.MapEntry.prototype.cljs$core$IIterable$ = true;

schema.core.MapEntry.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__55549){
var self__ = this;
var G__55549__$1 = this;
return (new cljs.core.RecordIter((0),G__55549__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"key-schema","key-schema",-1096660726),new cljs.core.Keyword(null,"val-schema","val-schema",-2014773619)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

schema.core.MapEntry.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__19082__auto__){
var self__ = this;
var this__19082__auto____$1 = this;
return self__.__meta;
});

schema.core.MapEntry.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__19078__auto__){
var self__ = this;
var this__19078__auto____$1 = this;
return (new schema.core.MapEntry(self__.key_schema,self__.val_schema,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.MapEntry.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__19088__auto__){
var self__ = this;
var this__19088__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.MapEntry.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__19079__auto__){
var self__ = this;
var this__19079__auto____$1 = this;
var h__18905__auto__ = self__.__hash;
if(!((h__18905__auto__ == null))){
return h__18905__auto__;
} else {
var h__18905__auto____$1 = cljs.core.hash_imap.call(null,this__19079__auto____$1);
self__.__hash = h__18905__auto____$1;

return h__18905__auto____$1;
}
});

schema.core.MapEntry.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__19080__auto__,other__19081__auto__){
var self__ = this;
var this__19080__auto____$1 = this;
if(cljs.core.truth_((function (){var and__18477__auto__ = other__19081__auto__;
if(cljs.core.truth_(and__18477__auto__)){
var and__18477__auto____$1 = (this__19080__auto____$1.constructor === other__19081__auto__.constructor);
if(and__18477__auto____$1){
return cljs.core.equiv_map.call(null,this__19080__auto____$1,other__19081__auto__);
} else {
return and__18477__auto____$1;
}
} else {
return and__18477__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.MapEntry.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__19093__auto__,k__19094__auto__){
var self__ = this;
var this__19093__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key-schema","key-schema",-1096660726),null,new cljs.core.Keyword(null,"val-schema","val-schema",-2014773619),null], null), null),k__19094__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__19093__auto____$1),self__.__meta),k__19094__auto__);
} else {
return (new schema.core.MapEntry(self__.key_schema,self__.val_schema,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__19094__auto__)),null));
}
});

schema.core.MapEntry.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__19091__auto__,k__19092__auto__,G__55549){
var self__ = this;
var this__19091__auto____$1 = this;
var pred__55553 = cljs.core.keyword_identical_QMARK_;
var expr__55554 = k__19092__auto__;
if(cljs.core.truth_(pred__55553.call(null,new cljs.core.Keyword(null,"key-schema","key-schema",-1096660726),expr__55554))){
return (new schema.core.MapEntry(G__55549,self__.val_schema,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__55553.call(null,new cljs.core.Keyword(null,"val-schema","val-schema",-2014773619),expr__55554))){
return (new schema.core.MapEntry(self__.key_schema,G__55549,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.MapEntry(self__.key_schema,self__.val_schema,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__19092__auto__,G__55549),null));
}
}
});

schema.core.MapEntry.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__19096__auto__){
var self__ = this;
var this__19096__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"key-schema","key-schema",-1096660726),self__.key_schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"val-schema","val-schema",-2014773619),self__.val_schema],null))], null),self__.__extmap));
});

schema.core.MapEntry.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__19083__auto__,G__55549){
var self__ = this;
var this__19083__auto____$1 = this;
return (new schema.core.MapEntry(self__.key_schema,self__.val_schema,G__55549,self__.__extmap,self__.__hash));
});

schema.core.MapEntry.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__19089__auto__,entry__19090__auto__){
var self__ = this;
var this__19089__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__19090__auto__)){
return cljs.core._assoc.call(null,this__19089__auto____$1,cljs.core._nth.call(null,entry__19090__auto__,(0)),cljs.core._nth.call(null,entry__19090__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__19089__auto____$1,entry__19090__auto__);
}
});

schema.core.MapEntry.prototype.schema$core$Schema$ = true;

schema.core.MapEntry.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.collection.collection_spec.call(null,schema.spec.core._PLUS_no_precondition_PLUS_,cljs.core.vec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.spec.collection.one_element.call(null,true,self__.key_schema,((function (this$__$1){
return (function (item_fn,e){
item_fn.call(null,cljs.core.key.call(null,e));

return e;
});})(this$__$1))
),schema.spec.collection.one_element.call(null,true,self__.val_schema,((function (this$__$1){
return (function (item_fn,e){
item_fn.call(null,cljs.core.val.call(null,e));

return null;
});})(this$__$1))
)], null),((function (this$__$1){
return (function (p__55556,p__55557,_){
var vec__55558 = p__55556;
var k = cljs.core.nth.call(null,vec__55558,(0),null);
var vec__55559 = p__55557;
var xk = cljs.core.nth.call(null,vec__55559,(0),null);
var xv = cljs.core.nth.call(null,vec__55559,(1),null);
var temp__4423__auto__ = schema.utils.error_val.call(null,xk);
if(cljs.core.truth_(temp__4423__auto__)){
var k_err = temp__4423__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_err,new cljs.core.Symbol(null,"invalid-key","invalid-key",-1461682245,null)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,schema.utils.error_val.call(null,xv)], null);
}
});})(this$__$1))
);
});

schema.core.MapEntry.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,schema.core.explain.call(null,self__.val_schema)),schema.core.explain.call(null,self__.key_schema)),new cljs.core.Symbol(null,"map-entry","map-entry",329617471,null));
});

schema.core.MapEntry.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key-schema","key-schema",543870801,null),new cljs.core.Symbol(null,"val-schema","val-schema",-374242092,null)], null);
});

schema.core.MapEntry.cljs$lang$type = true;

schema.core.MapEntry.cljs$lang$ctorPrSeq = (function (this__19118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/MapEntry");
});

schema.core.MapEntry.cljs$lang$ctorPrWriter = (function (this__19118__auto__,writer__19119__auto__){
return cljs.core._write.call(null,writer__19119__auto__,"schema.core/MapEntry");
});

schema.core.__GT_MapEntry = (function schema$core$__GT_MapEntry(key_schema,val_schema){
return (new schema.core.MapEntry(key_schema,val_schema,null,null,null));
});

schema.core.map__GT_MapEntry = (function schema$core$map__GT_MapEntry(G__55551){
return (new schema.core.MapEntry(new cljs.core.Keyword(null,"key-schema","key-schema",-1096660726).cljs$core$IFn$_invoke$arity$1(G__55551),new cljs.core.Keyword(null,"val-schema","val-schema",-2014773619).cljs$core$IFn$_invoke$arity$1(G__55551),null,cljs.core.dissoc.call(null,G__55551,new cljs.core.Keyword(null,"key-schema","key-schema",-1096660726),new cljs.core.Keyword(null,"val-schema","val-schema",-2014773619)),null));
});

schema.core.map_entry = (function schema$core$map_entry(key_schema,val_schema){
return (new schema.core.MapEntry(key_schema,val_schema,null,null,null));
});
schema.core.find_extra_keys_schema = (function schema$core$find_extra_keys_schema(map_schema){
var key_schemata = cljs.core.remove.call(null,schema.core.specific_key_QMARK_,cljs.core.keys.call(null,map_schema));
if((cljs.core.count.call(null,key_schemata) < (2))){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"More than one non-optional/required key schemata: %s",cljs.core.vec.call(null,key_schemata))));
}

return cljs.core.first.call(null,key_schemata);
});
schema.core.explain_kspec = (function schema$core$explain_kspec(kspec){
if(cljs.core.truth_(schema.core.specific_key_QMARK_.call(null,kspec))){
if((kspec instanceof cljs.core.Keyword)){
return kspec;
} else {
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,schema.core.explicit_schema_key.call(null,kspec)),(cljs.core.truth_(schema.core.required_key_QMARK_.call(null,kspec))?new cljs.core.Symbol(null,"required-key","required-key",1624616412,null):(cljs.core.truth_(schema.core.optional_key_QMARK_.call(null,kspec))?new cljs.core.Symbol(null,"optional-key","optional-key",988406145,null):null)));
}
} else {
return schema.core.explain.call(null,kspec);
}
});
schema.core.map_elements = (function schema$core$map_elements(this$){
var extra_keys_schema = schema.core.find_extra_keys_schema.call(null,this$);
var duplicate_keys_55578 = cljs.core.mapv.call(null,schema.core.explain_kspec,cljs.core.apply.call(null,cljs.core.concat,cljs.core.filter.call(null,((function (extra_keys_schema){
return (function (p1__55561_SHARP_){
return (cljs.core.count.call(null,p1__55561_SHARP_) > (1));
});})(extra_keys_schema))
,cljs.core.vals.call(null,cljs.core.group_by.call(null,schema.core.explicit_schema_key,cljs.core.keys.call(null,cljs.core.dissoc.call(null,this$,extra_keys_schema)))))));
if(cljs.core.empty_QMARK_.call(null,duplicate_keys_55578)){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Schema has multiple variants of the same explicit key: %s",duplicate_keys_55578)));
}

return cljs.core.concat.call(null,(function (){var iter__19242__auto__ = ((function (extra_keys_schema){
return (function schema$core$map_elements_$_iter__55570(s__55571){
return (new cljs.core.LazySeq(null,((function (extra_keys_schema){
return (function (){
var s__55571__$1 = s__55571;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__55571__$1);
if(temp__4425__auto__){
var s__55571__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__55571__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__55571__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__55573 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__55572 = (0);
while(true){
if((i__55572 < size__19241__auto__)){
var vec__55576 = cljs.core._nth.call(null,c__19240__auto__,i__55572);
var k = cljs.core.nth.call(null,vec__55576,(0),null);
var v = cljs.core.nth.call(null,vec__55576,(1),null);
cljs.core.chunk_append.call(null,b__55573,(function (){var rk = schema.core.explicit_schema_key.call(null,k);
var required_QMARK_ = schema.core.required_key_QMARK_.call(null,k);
return schema.spec.collection.one_element.call(null,required_QMARK_,schema.core.map_entry.call(null,schema.core.eq.call(null,rk),v),((function (i__55572,rk,required_QMARK_,vec__55576,k,v,c__19240__auto__,size__19241__auto__,b__55573,s__55571__$2,temp__4425__auto__,extra_keys_schema){
return (function (item_fn,m){
var e = cljs.core.find.call(null,m,rk);
if(cljs.core.truth_(e)){
item_fn.call(null,e);
} else {
if(cljs.core.truth_(required_QMARK_)){
item_fn.call(null,schema.utils.error.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rk,new cljs.core.Symbol(null,"missing-required-key","missing-required-key",709961446,null)], null)));
} else {
}
}

if(cljs.core.truth_(e)){
return cljs.core.dissoc.call(null,m,rk);
} else {
return m;
}
});})(i__55572,rk,required_QMARK_,vec__55576,k,v,c__19240__auto__,size__19241__auto__,b__55573,s__55571__$2,temp__4425__auto__,extra_keys_schema))
);
})());

var G__55579 = (i__55572 + (1));
i__55572 = G__55579;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55573),schema$core$map_elements_$_iter__55570.call(null,cljs.core.chunk_rest.call(null,s__55571__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55573),null);
}
} else {
var vec__55577 = cljs.core.first.call(null,s__55571__$2);
var k = cljs.core.nth.call(null,vec__55577,(0),null);
var v = cljs.core.nth.call(null,vec__55577,(1),null);
return cljs.core.cons.call(null,(function (){var rk = schema.core.explicit_schema_key.call(null,k);
var required_QMARK_ = schema.core.required_key_QMARK_.call(null,k);
return schema.spec.collection.one_element.call(null,required_QMARK_,schema.core.map_entry.call(null,schema.core.eq.call(null,rk),v),((function (rk,required_QMARK_,vec__55577,k,v,s__55571__$2,temp__4425__auto__,extra_keys_schema){
return (function (item_fn,m){
var e = cljs.core.find.call(null,m,rk);
if(cljs.core.truth_(e)){
item_fn.call(null,e);
} else {
if(cljs.core.truth_(required_QMARK_)){
item_fn.call(null,schema.utils.error.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rk,new cljs.core.Symbol(null,"missing-required-key","missing-required-key",709961446,null)], null)));
} else {
}
}

if(cljs.core.truth_(e)){
return cljs.core.dissoc.call(null,m,rk);
} else {
return m;
}
});})(rk,required_QMARK_,vec__55577,k,v,s__55571__$2,temp__4425__auto__,extra_keys_schema))
);
})(),schema$core$map_elements_$_iter__55570.call(null,cljs.core.rest.call(null,s__55571__$2)));
}
} else {
return null;
}
break;
}
});})(extra_keys_schema))
,null,null));
});})(extra_keys_schema))
;
return iter__19242__auto__.call(null,cljs.core.dissoc.call(null,this$,extra_keys_schema));
})(),(cljs.core.truth_(extra_keys_schema)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.spec.collection.all_elements.call(null,cljs.core.apply.call(null,schema.core.map_entry,cljs.core.find.call(null,this$,extra_keys_schema)))], null):null));
});
schema.core.map_error = (function schema$core$map_error(){
return (function (_,elts,extra){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.concat.call(null,cljs.core.keep.call(null,schema.utils.error_val,elts),(function (){var iter__19242__auto__ = (function schema$core$map_error_$_iter__55588(s__55589){
return (new cljs.core.LazySeq(null,(function (){
var s__55589__$1 = s__55589;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__55589__$1);
if(temp__4425__auto__){
var s__55589__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__55589__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__55589__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__55591 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__55590 = (0);
while(true){
if((i__55590 < size__19241__auto__)){
var vec__55594 = cljs.core._nth.call(null,c__19240__auto__,i__55590);
var k = cljs.core.nth.call(null,vec__55594,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__55594,(1),null);
cljs.core.chunk_append.call(null,b__55591,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,new cljs.core.Symbol(null,"disallowed-key","disallowed-key",-1877785633,null)], null));

var G__55596 = (i__55590 + (1));
i__55590 = G__55596;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55591),schema$core$map_error_$_iter__55588.call(null,cljs.core.chunk_rest.call(null,s__55589__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55591),null);
}
} else {
var vec__55595 = cljs.core.first.call(null,s__55589__$2);
var k = cljs.core.nth.call(null,vec__55595,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__55595,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,new cljs.core.Symbol(null,"disallowed-key","disallowed-key",-1877785633,null)], null),schema$core$map_error_$_iter__55588.call(null,cljs.core.rest.call(null,s__55589__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__19242__auto__.call(null,extra);
})()));
});
});
schema.core.map_spec = (function schema$core$map_spec(this$){
return schema.spec.collection.collection_spec.call(null,schema.spec.core.precondition.call(null,this$,cljs.core.map_QMARK_,(function (p1__21322__21323__auto__){
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,p1__21322__21323__auto__),new cljs.core.Symbol(null,"map?","map?",-1780568534,null));
})),(function (p1__55597_SHARP_){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,p1__55597_SHARP_);
}),schema.core.map_elements.call(null,this$),schema.core.map_error.call(null));
});
schema.core.map_explain = (function schema$core$map_explain(this$){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19242__auto__ = (function schema$core$map_explain_$_iter__55606(s__55607){
return (new cljs.core.LazySeq(null,(function (){
var s__55607__$1 = s__55607;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__55607__$1);
if(temp__4425__auto__){
var s__55607__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__55607__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__55607__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__55609 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__55608 = (0);
while(true){
if((i__55608 < size__19241__auto__)){
var vec__55612 = cljs.core._nth.call(null,c__19240__auto__,i__55608);
var k = cljs.core.nth.call(null,vec__55612,(0),null);
var v = cljs.core.nth.call(null,vec__55612,(1),null);
cljs.core.chunk_append.call(null,b__55609,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.explain_kspec.call(null,k),schema.core.explain.call(null,v)], null));

var G__55614 = (i__55608 + (1));
i__55608 = G__55614;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55609),schema$core$map_explain_$_iter__55606.call(null,cljs.core.chunk_rest.call(null,s__55607__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55609),null);
}
} else {
var vec__55613 = cljs.core.first.call(null,s__55607__$2);
var k = cljs.core.nth.call(null,vec__55613,(0),null);
var v = cljs.core.nth.call(null,vec__55613,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.explain_kspec.call(null,k),schema.core.explain.call(null,v)], null),schema$core$map_explain_$_iter__55606.call(null,cljs.core.rest.call(null,s__55607__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__19242__auto__.call(null,this$);
})());
});
cljs.core.PersistentArrayMap.prototype.schema$core$Schema$ = true;

cljs.core.PersistentArrayMap.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var this$__$1 = this;
return schema.core.map_spec.call(null,this$__$1);
});

cljs.core.PersistentArrayMap.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var this$__$1 = this;
return schema.core.map_explain.call(null,this$__$1);
});

cljs.core.PersistentHashMap.prototype.schema$core$Schema$ = true;

cljs.core.PersistentHashMap.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var this$__$1 = this;
return schema.core.map_spec.call(null,this$__$1);
});

cljs.core.PersistentHashMap.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var this$__$1 = this;
return schema.core.map_explain.call(null,this$__$1);
});
cljs.core.PersistentHashSet.prototype.schema$core$Schema$ = true;

cljs.core.PersistentHashSet.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var this$__$1 = this;
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,this$__$1),(1))){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Set schema must have exactly one element")));
}

return schema.spec.collection.collection_spec.call(null,schema.spec.core.precondition.call(null,this$__$1,cljs.core.set_QMARK_,((function (this$__$1){
return (function (p1__21322__21323__auto__){
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,p1__21322__21323__auto__),new cljs.core.Symbol(null,"set?","set?",1636014792,null));
});})(this$__$1))
),cljs.core.set,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.spec.collection.all_elements.call(null,cljs.core.first.call(null,this$__$1))], null),((function (this$__$1){
return (function (_,xs,___$1){
return cljs.core.set.call(null,cljs.core.keep.call(null,schema.utils.error_val,xs));
});})(this$__$1))
);
});

cljs.core.PersistentHashSet.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.explain.call(null,cljs.core.first.call(null,this$__$1))], null));
});
schema.core.queue_QMARK_ = (function schema$core$queue_QMARK_(x){
return (x instanceof cljs.core.PersistentQueue);
});
schema.core.as_queue = (function schema$core$as_queue(col){
return cljs.core.reduce.call(null,cljs.core.conj,cljs.core.PersistentQueue.EMPTY,col);
});

/**
* @constructor
* @param {*} schema
* @param {*} __meta
* @param {*} __extmap
* @param {*} __hash
* @param {*=} __meta 
* @param {*=} __extmap
* @param {number|null} __hash
*/
schema.core.Queue = (function (schema,__meta,__extmap,__hash){
this.schema = schema;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.Queue.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__19084__auto__,k__19085__auto__){
var self__ = this;
var this__19084__auto____$1 = this;
return cljs.core._lookup.call(null,this__19084__auto____$1,k__19085__auto__,null);
});

schema.core.Queue.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__19086__auto__,k55616,else__19087__auto__){
var self__ = this;
var this__19086__auto____$1 = this;
var G__55618 = (((k55616 instanceof cljs.core.Keyword))?k55616.fqn:null);
switch (G__55618) {
case "schema":
return self__.schema;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k55616,else__19087__auto__);

}
});

schema.core.Queue.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__19098__auto__,writer__19099__auto__,opts__19100__auto__){
var self__ = this;
var this__19098__auto____$1 = this;
var pr_pair__19101__auto__ = ((function (this__19098__auto____$1){
return (function (keyval__19102__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,cljs.core.pr_writer,""," ","",opts__19100__auto__,keyval__19102__auto__);
});})(this__19098__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,pr_pair__19101__auto__,"#schema.core.Queue{",", ","}",opts__19100__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null))], null),self__.__extmap));
});

schema.core.Queue.prototype.cljs$core$IIterable$ = true;

schema.core.Queue.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__55615){
var self__ = this;
var G__55615__$1 = this;
return (new cljs.core.RecordIter((0),G__55615__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

schema.core.Queue.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__19082__auto__){
var self__ = this;
var this__19082__auto____$1 = this;
return self__.__meta;
});

schema.core.Queue.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__19078__auto__){
var self__ = this;
var this__19078__auto____$1 = this;
return (new schema.core.Queue(self__.schema,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.Queue.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__19088__auto__){
var self__ = this;
var this__19088__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.Queue.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__19079__auto__){
var self__ = this;
var this__19079__auto____$1 = this;
var h__18905__auto__ = self__.__hash;
if(!((h__18905__auto__ == null))){
return h__18905__auto__;
} else {
var h__18905__auto____$1 = cljs.core.hash_imap.call(null,this__19079__auto____$1);
self__.__hash = h__18905__auto____$1;

return h__18905__auto____$1;
}
});

schema.core.Queue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__19080__auto__,other__19081__auto__){
var self__ = this;
var this__19080__auto____$1 = this;
if(cljs.core.truth_((function (){var and__18477__auto__ = other__19081__auto__;
if(cljs.core.truth_(and__18477__auto__)){
var and__18477__auto____$1 = (this__19080__auto____$1.constructor === other__19081__auto__.constructor);
if(and__18477__auto____$1){
return cljs.core.equiv_map.call(null,this__19080__auto____$1,other__19081__auto__);
} else {
return and__18477__auto____$1;
}
} else {
return and__18477__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.Queue.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__19093__auto__,k__19094__auto__){
var self__ = this;
var this__19093__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),null], null), null),k__19094__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__19093__auto____$1),self__.__meta),k__19094__auto__);
} else {
return (new schema.core.Queue(self__.schema,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__19094__auto__)),null));
}
});

schema.core.Queue.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__19091__auto__,k__19092__auto__,G__55615){
var self__ = this;
var this__19091__auto____$1 = this;
var pred__55619 = cljs.core.keyword_identical_QMARK_;
var expr__55620 = k__19092__auto__;
if(cljs.core.truth_(pred__55619.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__55620))){
return (new schema.core.Queue(G__55615,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.Queue(self__.schema,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__19092__auto__,G__55615),null));
}
});

schema.core.Queue.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__19096__auto__){
var self__ = this;
var this__19096__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null))], null),self__.__extmap));
});

schema.core.Queue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__19083__auto__,G__55615){
var self__ = this;
var this__19083__auto____$1 = this;
return (new schema.core.Queue(self__.schema,G__55615,self__.__extmap,self__.__hash));
});

schema.core.Queue.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__19089__auto__,entry__19090__auto__){
var self__ = this;
var this__19089__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__19090__auto__)){
return cljs.core._assoc.call(null,this__19089__auto____$1,cljs.core._nth.call(null,entry__19090__auto__,(0)),cljs.core._nth.call(null,entry__19090__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__19089__auto____$1,entry__19090__auto__);
}
});

schema.core.Queue.prototype.schema$core$Schema$ = true;

schema.core.Queue.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.collection.collection_spec.call(null,schema.spec.core.precondition.call(null,this$__$1,schema.core.queue_QMARK_,((function (this$__$1){
return (function (p1__21322__21323__auto__){
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,p1__21322__21323__auto__),new cljs.core.Symbol(null,"queue?","queue?",-880510795,null));
});})(this$__$1))
),schema.core.as_queue,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.spec.collection.all_elements.call(null,self__.schema)], null),((function (this$__$1){
return (function (_,xs,___$1){
return schema.core.as_queue.call(null,cljs.core.keep.call(null,schema.utils.error_val,xs));
});})(this$__$1))
);
});

schema.core.Queue.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,schema.core.explain.call(null,self__.schema)),new cljs.core.Symbol(null,"queue","queue",-1198599890,null));
});

schema.core.Queue.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"schema","schema",58529736,null)], null);
});

schema.core.Queue.cljs$lang$type = true;

schema.core.Queue.cljs$lang$ctorPrSeq = (function (this__19118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/Queue");
});

schema.core.Queue.cljs$lang$ctorPrWriter = (function (this__19118__auto__,writer__19119__auto__){
return cljs.core._write.call(null,writer__19119__auto__,"schema.core/Queue");
});

schema.core.__GT_Queue = (function schema$core$__GT_Queue(schema__$1){
return (new schema.core.Queue(schema__$1,null,null,null));
});

schema.core.map__GT_Queue = (function schema$core$map__GT_Queue(G__55617){
return (new schema.core.Queue(new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__55617),null,cljs.core.dissoc.call(null,G__55617,new cljs.core.Keyword(null,"schema","schema",-1582001791)),null));
});

/**
 * Defines a schema satisfied by instances of clojure.lang.PersistentQueue
 * (clj.core/PersistentQueue in ClojureScript) whose values satisfy x.
 */
schema.core.queue = (function schema$core$queue(x){
return (new schema.core.Queue(x,null,null,null));
});

/**
* @constructor
* @param {*} schema
* @param {*} optional_QMARK_
* @param {*} name
* @param {*} __meta
* @param {*} __extmap
* @param {*} __hash
* @param {*=} __meta 
* @param {*=} __extmap
* @param {number|null} __hash
*/
schema.core.One = (function (schema,optional_QMARK_,name,__meta,__extmap,__hash){
this.schema = schema;
this.optional_QMARK_ = optional_QMARK_;
this.name = name;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.One.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__19084__auto__,k__19085__auto__){
var self__ = this;
var this__19084__auto____$1 = this;
return cljs.core._lookup.call(null,this__19084__auto____$1,k__19085__auto__,null);
});

schema.core.One.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__19086__auto__,k55624,else__19087__auto__){
var self__ = this;
var this__19086__auto____$1 = this;
var G__55626 = (((k55624 instanceof cljs.core.Keyword))?k55624.fqn:null);
switch (G__55626) {
case "schema":
return self__.schema;

break;
case "optional?":
return self__.optional_QMARK_;

break;
case "name":
return self__.name;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k55624,else__19087__auto__);

}
});

schema.core.One.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__19098__auto__,writer__19099__auto__,opts__19100__auto__){
var self__ = this;
var this__19098__auto____$1 = this;
var pr_pair__19101__auto__ = ((function (this__19098__auto____$1){
return (function (keyval__19102__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,cljs.core.pr_writer,""," ","",opts__19100__auto__,keyval__19102__auto__);
});})(this__19098__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,pr_pair__19101__auto__,"#schema.core.One{",", ","}",opts__19100__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"optional?","optional?",1184638129),self__.optional_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"name","name",1843675177),self__.name],null))], null),self__.__extmap));
});

schema.core.One.prototype.cljs$core$IIterable$ = true;

schema.core.One.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__55623){
var self__ = this;
var G__55623__$1 = this;
return (new cljs.core.RecordIter((0),G__55623__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"optional?","optional?",1184638129),new cljs.core.Keyword(null,"name","name",1843675177)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

schema.core.One.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__19082__auto__){
var self__ = this;
var this__19082__auto____$1 = this;
return self__.__meta;
});

schema.core.One.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__19078__auto__){
var self__ = this;
var this__19078__auto____$1 = this;
return (new schema.core.One(self__.schema,self__.optional_QMARK_,self__.name,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.One.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__19088__auto__){
var self__ = this;
var this__19088__auto____$1 = this;
return (3 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.One.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__19079__auto__){
var self__ = this;
var this__19079__auto____$1 = this;
var h__18905__auto__ = self__.__hash;
if(!((h__18905__auto__ == null))){
return h__18905__auto__;
} else {
var h__18905__auto____$1 = cljs.core.hash_imap.call(null,this__19079__auto____$1);
self__.__hash = h__18905__auto____$1;

return h__18905__auto____$1;
}
});

schema.core.One.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__19080__auto__,other__19081__auto__){
var self__ = this;
var this__19080__auto____$1 = this;
if(cljs.core.truth_((function (){var and__18477__auto__ = other__19081__auto__;
if(cljs.core.truth_(and__18477__auto__)){
var and__18477__auto____$1 = (this__19080__auto____$1.constructor === other__19081__auto__.constructor);
if(and__18477__auto____$1){
return cljs.core.equiv_map.call(null,this__19080__auto____$1,other__19081__auto__);
} else {
return and__18477__auto____$1;
}
} else {
return and__18477__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.One.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__19093__auto__,k__19094__auto__){
var self__ = this;
var this__19093__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"optional?","optional?",1184638129),null], null), null),k__19094__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__19093__auto____$1),self__.__meta),k__19094__auto__);
} else {
return (new schema.core.One(self__.schema,self__.optional_QMARK_,self__.name,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__19094__auto__)),null));
}
});

schema.core.One.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__19091__auto__,k__19092__auto__,G__55623){
var self__ = this;
var this__19091__auto____$1 = this;
var pred__55627 = cljs.core.keyword_identical_QMARK_;
var expr__55628 = k__19092__auto__;
if(cljs.core.truth_(pred__55627.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__55628))){
return (new schema.core.One(G__55623,self__.optional_QMARK_,self__.name,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__55627.call(null,new cljs.core.Keyword(null,"optional?","optional?",1184638129),expr__55628))){
return (new schema.core.One(self__.schema,G__55623,self__.name,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__55627.call(null,new cljs.core.Keyword(null,"name","name",1843675177),expr__55628))){
return (new schema.core.One(self__.schema,self__.optional_QMARK_,G__55623,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.One(self__.schema,self__.optional_QMARK_,self__.name,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__19092__auto__,G__55623),null));
}
}
}
});

schema.core.One.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__19096__auto__){
var self__ = this;
var this__19096__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"optional?","optional?",1184638129),self__.optional_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"name","name",1843675177),self__.name],null))], null),self__.__extmap));
});

schema.core.One.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__19083__auto__,G__55623){
var self__ = this;
var this__19083__auto____$1 = this;
return (new schema.core.One(self__.schema,self__.optional_QMARK_,self__.name,G__55623,self__.__extmap,self__.__hash));
});

schema.core.One.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__19089__auto__,entry__19090__auto__){
var self__ = this;
var this__19089__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__19090__auto__)){
return cljs.core._assoc.call(null,this__19089__auto____$1,cljs.core._nth.call(null,entry__19090__auto__,(0)),cljs.core._nth.call(null,entry__19090__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__19089__auto____$1,entry__19090__auto__);
}
});

schema.core.One.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"optional?","optional?",-1469797640,null),new cljs.core.Symbol(null,"name","name",-810760592,null)], null);
});

schema.core.One.cljs$lang$type = true;

schema.core.One.cljs$lang$ctorPrSeq = (function (this__19118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/One");
});

schema.core.One.cljs$lang$ctorPrWriter = (function (this__19118__auto__,writer__19119__auto__){
return cljs.core._write.call(null,writer__19119__auto__,"schema.core/One");
});

schema.core.__GT_One = (function schema$core$__GT_One(schema__$1,optional_QMARK_,name){
return (new schema.core.One(schema__$1,optional_QMARK_,name,null,null,null));
});

schema.core.map__GT_One = (function schema$core$map__GT_One(G__55625){
return (new schema.core.One(new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__55625),new cljs.core.Keyword(null,"optional?","optional?",1184638129).cljs$core$IFn$_invoke$arity$1(G__55625),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(G__55625),null,cljs.core.dissoc.call(null,G__55625,new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"optional?","optional?",1184638129),new cljs.core.Keyword(null,"name","name",1843675177)),null));
});

/**
 * A single required element of a sequence (not repeated, the implicit default)
 */
schema.core.one = (function schema$core$one(schema__$1,name){
return (new schema.core.One(schema__$1,false,name,null,null,null));
});
/**
 * A single optional element of a sequence (not repeated, the implicit default)
 */
schema.core.optional = (function schema$core$optional(schema__$1,name){
return (new schema.core.One(schema__$1,true,name,null,null,null));
});
schema.core.parse_sequence_schema = (function schema$core$parse_sequence_schema(s){

var vec__55636 = cljs.core.split_with.call(null,(function (p1__55631_SHARP_){
return ((p1__55631_SHARP_ instanceof schema.core.One)) && (cljs.core.not.call(null,new cljs.core.Keyword(null,"optional?","optional?",1184638129).cljs$core$IFn$_invoke$arity$1(p1__55631_SHARP_)));
}),s);
var required = cljs.core.nth.call(null,vec__55636,(0),null);
var more = cljs.core.nth.call(null,vec__55636,(1),null);
var vec__55637 = cljs.core.split_with.call(null,((function (vec__55636,required,more){
return (function (p1__55632_SHARP_){
var and__18477__auto__ = (p1__55632_SHARP_ instanceof schema.core.One);
if(and__18477__auto__){
return new cljs.core.Keyword(null,"optional?","optional?",1184638129).cljs$core$IFn$_invoke$arity$1(p1__55632_SHARP_);
} else {
return and__18477__auto__;
}
});})(vec__55636,required,more))
,more);
var optional = cljs.core.nth.call(null,vec__55637,(0),null);
var more__$1 = cljs.core.nth.call(null,vec__55637,(1),null);
if(((cljs.core.count.call(null,more__$1) <= (1))) && (cljs.core.every_QMARK_.call(null,((function (vec__55636,required,more,vec__55637,optional,more__$1){
return (function (p1__55633_SHARP_){
return !((p1__55633_SHARP_ instanceof schema.core.One));
});})(vec__55636,required,more,vec__55637,optional,more__$1))
,more__$1))){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Sequence schema %s does not match [one* optional* rest-schema?]",s)));
}

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.call(null,required,optional),cljs.core.first.call(null,more__$1)], null);
});
cljs.core.PersistentVector.prototype.schema$core$Schema$ = true;

cljs.core.PersistentVector.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var this$__$1 = this;
return schema.spec.collection.collection_spec.call(null,schema.spec.core.precondition.call(null,this$__$1,((function (this$__$1){
return (function (x){
return ((x == null)) || (cljs.core.sequential_QMARK_.call(null,x));
});})(this$__$1))
,((function (this$__$1){
return (function (p1__55638_SHARP_){
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,p1__55638_SHARP_),new cljs.core.Symbol(null,"sequential?","sequential?",1102351463,null));
});})(this$__$1))
),cljs.core.vec,(function (){var vec__55639 = schema.core.parse_sequence_schema.call(null,this$__$1);
var singles = cljs.core.nth.call(null,vec__55639,(0),null);
var multi = cljs.core.nth.call(null,vec__55639,(1),null);
return cljs.core.concat.call(null,(function (){var iter__19242__auto__ = ((function (vec__55639,singles,multi,this$__$1){
return (function schema$core$iter__55640(s__55641){
return (new cljs.core.LazySeq(null,((function (vec__55639,singles,multi,this$__$1){
return (function (){
var s__55641__$1 = s__55641;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__55641__$1);
if(temp__4425__auto__){
var s__55641__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__55641__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__55641__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__55643 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__55642 = (0);
while(true){
if((i__55642 < size__19241__auto__)){
var s = cljs.core._nth.call(null,c__19240__auto__,i__55642);
cljs.core.chunk_append.call(null,b__55643,(function (){var required_QMARK_ = cljs.core.not.call(null,s.optional_QMARK_);
return schema.spec.collection.one_element.call(null,required_QMARK_,schema.core.named.call(null,s.schema,s.name),((function (i__55642,required_QMARK_,s,c__19240__auto__,size__19241__auto__,b__55643,s__55641__$2,temp__4425__auto__,vec__55639,singles,multi,this$__$1){
return (function (item_fn,x){
var temp__4423__auto__ = cljs.core.seq.call(null,x);
if(temp__4423__auto__){
var x__$1 = temp__4423__auto__;
item_fn.call(null,cljs.core.first.call(null,x__$1));

return cljs.core.rest.call(null,x__$1);
} else {
if(required_QMARK_){
item_fn.call(null,schema.utils.error.call(null,schema.utils.make_ValidationError.call(null,s.schema,new cljs.core.Keyword("schema.core","missing","schema.core/missing",1420181325),(new cljs.core.Delay(((function (i__55642,temp__4423__auto__,required_QMARK_,s,c__19240__auto__,size__19241__auto__,b__55643,s__55641__$2,temp__4425__auto__,vec__55639,singles,multi,this$__$1){
return (function (){
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,s.name),new cljs.core.Symbol(null,"present?","present?",-1810613791,null));
});})(i__55642,temp__4423__auto__,required_QMARK_,s,c__19240__auto__,size__19241__auto__,b__55643,s__55641__$2,temp__4425__auto__,vec__55639,singles,multi,this$__$1))
,null)),null)));
} else {
}

return null;
}
});})(i__55642,required_QMARK_,s,c__19240__auto__,size__19241__auto__,b__55643,s__55641__$2,temp__4425__auto__,vec__55639,singles,multi,this$__$1))
);
})());

var G__55649 = (i__55642 + (1));
i__55642 = G__55649;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55643),schema$core$iter__55640.call(null,cljs.core.chunk_rest.call(null,s__55641__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55643),null);
}
} else {
var s = cljs.core.first.call(null,s__55641__$2);
return cljs.core.cons.call(null,(function (){var required_QMARK_ = cljs.core.not.call(null,s.optional_QMARK_);
return schema.spec.collection.one_element.call(null,required_QMARK_,schema.core.named.call(null,s.schema,s.name),((function (required_QMARK_,s,s__55641__$2,temp__4425__auto__,vec__55639,singles,multi,this$__$1){
return (function (item_fn,x){
var temp__4423__auto__ = cljs.core.seq.call(null,x);
if(temp__4423__auto__){
var x__$1 = temp__4423__auto__;
item_fn.call(null,cljs.core.first.call(null,x__$1));

return cljs.core.rest.call(null,x__$1);
} else {
if(required_QMARK_){
item_fn.call(null,schema.utils.error.call(null,schema.utils.make_ValidationError.call(null,s.schema,new cljs.core.Keyword("schema.core","missing","schema.core/missing",1420181325),(new cljs.core.Delay(((function (temp__4423__auto__,required_QMARK_,s,s__55641__$2,temp__4425__auto__,vec__55639,singles,multi,this$__$1){
return (function (){
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,s.name),new cljs.core.Symbol(null,"present?","present?",-1810613791,null));
});})(temp__4423__auto__,required_QMARK_,s,s__55641__$2,temp__4425__auto__,vec__55639,singles,multi,this$__$1))
,null)),null)));
} else {
}

return null;
}
});})(required_QMARK_,s,s__55641__$2,temp__4425__auto__,vec__55639,singles,multi,this$__$1))
);
})(),schema$core$iter__55640.call(null,cljs.core.rest.call(null,s__55641__$2)));
}
} else {
return null;
}
break;
}
});})(vec__55639,singles,multi,this$__$1))
,null,null));
});})(vec__55639,singles,multi,this$__$1))
;
return iter__19242__auto__.call(null,singles);
})(),(cljs.core.truth_(multi)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.spec.collection.all_elements.call(null,multi)], null):null));
})(),((function (this$__$1){
return (function (_,elts,extra){
var head = cljs.core.mapv.call(null,schema.utils.error_val,elts);
if(cljs.core.seq.call(null,extra)){
return cljs.core.conj.call(null,head,schema.utils.error_val.call(null,schema.utils.error.call(null,schema.utils.make_ValidationError.call(null,null,extra,(new cljs.core.Delay(((function (head,this$__$1){
return (function (){
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.count.call(null,extra)),new cljs.core.Symbol(null,"has-extra-elts?","has-extra-elts?",-1376562869,null));
});})(head,this$__$1))
,null)),null))));
} else {
return head;
}
});})(this$__$1))
);
});

cljs.core.PersistentVector.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var this$__$1 = this;
var vec__55644 = schema.core.parse_sequence_schema.call(null,this$__$1);
var singles = cljs.core.nth.call(null,vec__55644,(0),null);
var multi = cljs.core.nth.call(null,vec__55644,(1),null);
return cljs.core.vec.call(null,cljs.core.concat.call(null,(function (){var iter__19242__auto__ = ((function (vec__55644,singles,multi,this$__$1){
return (function schema$core$iter__55645(s__55646){
return (new cljs.core.LazySeq(null,((function (vec__55644,singles,multi,this$__$1){
return (function (){
var s__55646__$1 = s__55646;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__55646__$1);
if(temp__4425__auto__){
var s__55646__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__55646__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__55646__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__55648 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__55647 = (0);
while(true){
if((i__55647 < size__19241__auto__)){
var s = cljs.core._nth.call(null,c__19240__auto__,i__55647);
cljs.core.chunk_append.call(null,b__55648,cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s)),schema.core.explain.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(s))),(cljs.core.truth_(s.optional_QMARK_)?new cljs.core.Symbol(null,"optional","optional",-600484260,null):new cljs.core.Symbol(null,"one","one",-1719427865,null))));

var G__55650 = (i__55647 + (1));
i__55647 = G__55650;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55648),schema$core$iter__55645.call(null,cljs.core.chunk_rest.call(null,s__55646__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__55648),null);
}
} else {
var s = cljs.core.first.call(null,s__55646__$2);
return cljs.core.cons.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s)),schema.core.explain.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(s))),(cljs.core.truth_(s.optional_QMARK_)?new cljs.core.Symbol(null,"optional","optional",-600484260,null):new cljs.core.Symbol(null,"one","one",-1719427865,null))),schema$core$iter__55645.call(null,cljs.core.rest.call(null,s__55646__$2)));
}
} else {
return null;
}
break;
}
});})(vec__55644,singles,multi,this$__$1))
,null,null));
});})(vec__55644,singles,multi,this$__$1))
;
return iter__19242__auto__.call(null,singles);
})(),(cljs.core.truth_(multi)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.explain.call(null,multi)], null):null)));
});
/**
 * A schema for a pair of schemas and their names
 */
schema.core.pair = (function schema$core$pair(first_schema,first_name,second_schema,second_name){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,first_schema,first_name),schema.core.one.call(null,second_schema,second_name)], null);
});

/**
* @constructor
* @param {*} klass
* @param {*} schema
* @param {*} __meta
* @param {*} __extmap
* @param {*} __hash
* @param {*=} __meta 
* @param {*=} __extmap
* @param {number|null} __hash
*/
schema.core.Record = (function (klass,schema,__meta,__extmap,__hash){
this.klass = klass;
this.schema = schema;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.Record.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__19084__auto__,k__19085__auto__){
var self__ = this;
var this__19084__auto____$1 = this;
return cljs.core._lookup.call(null,this__19084__auto____$1,k__19085__auto__,null);
});

schema.core.Record.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__19086__auto__,k55655,else__19087__auto__){
var self__ = this;
var this__19086__auto____$1 = this;
var G__55657 = (((k55655 instanceof cljs.core.Keyword))?k55655.fqn:null);
switch (G__55657) {
case "klass":
return self__.klass;

break;
case "schema":
return self__.schema;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k55655,else__19087__auto__);

}
});

schema.core.Record.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__19098__auto__,writer__19099__auto__,opts__19100__auto__){
var self__ = this;
var this__19098__auto____$1 = this;
var pr_pair__19101__auto__ = ((function (this__19098__auto____$1){
return (function (keyval__19102__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,cljs.core.pr_writer,""," ","",opts__19100__auto__,keyval__19102__auto__);
});})(this__19098__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,pr_pair__19101__auto__,"#schema.core.Record{",", ","}",opts__19100__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"klass","klass",-1386752349),self__.klass],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null))], null),self__.__extmap));
});

schema.core.Record.prototype.cljs$core$IIterable$ = true;

schema.core.Record.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__55654){
var self__ = this;
var G__55654__$1 = this;
return (new cljs.core.RecordIter((0),G__55654__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"klass","klass",-1386752349),new cljs.core.Keyword(null,"schema","schema",-1582001791)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

schema.core.Record.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__19082__auto__){
var self__ = this;
var this__19082__auto____$1 = this;
return self__.__meta;
});

schema.core.Record.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__19078__auto__){
var self__ = this;
var this__19078__auto____$1 = this;
return (new schema.core.Record(self__.klass,self__.schema,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.Record.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__19088__auto__){
var self__ = this;
var this__19088__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.Record.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__19079__auto__){
var self__ = this;
var this__19079__auto____$1 = this;
var h__18905__auto__ = self__.__hash;
if(!((h__18905__auto__ == null))){
return h__18905__auto__;
} else {
var h__18905__auto____$1 = cljs.core.hash_imap.call(null,this__19079__auto____$1);
self__.__hash = h__18905__auto____$1;

return h__18905__auto____$1;
}
});

schema.core.Record.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__19080__auto__,other__19081__auto__){
var self__ = this;
var this__19080__auto____$1 = this;
if(cljs.core.truth_((function (){var and__18477__auto__ = other__19081__auto__;
if(cljs.core.truth_(and__18477__auto__)){
var and__18477__auto____$1 = (this__19080__auto____$1.constructor === other__19081__auto__.constructor);
if(and__18477__auto____$1){
return cljs.core.equiv_map.call(null,this__19080__auto____$1,other__19081__auto__);
} else {
return and__18477__auto____$1;
}
} else {
return and__18477__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.Record.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__19093__auto__,k__19094__auto__){
var self__ = this;
var this__19093__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"klass","klass",-1386752349),null], null), null),k__19094__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__19093__auto____$1),self__.__meta),k__19094__auto__);
} else {
return (new schema.core.Record(self__.klass,self__.schema,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__19094__auto__)),null));
}
});

schema.core.Record.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__19091__auto__,k__19092__auto__,G__55654){
var self__ = this;
var this__19091__auto____$1 = this;
var pred__55658 = cljs.core.keyword_identical_QMARK_;
var expr__55659 = k__19092__auto__;
if(cljs.core.truth_(pred__55658.call(null,new cljs.core.Keyword(null,"klass","klass",-1386752349),expr__55659))){
return (new schema.core.Record(G__55654,self__.schema,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__55658.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__55659))){
return (new schema.core.Record(self__.klass,G__55654,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.Record(self__.klass,self__.schema,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__19092__auto__,G__55654),null));
}
}
});

schema.core.Record.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__19096__auto__){
var self__ = this;
var this__19096__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"klass","klass",-1386752349),self__.klass],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null))], null),self__.__extmap));
});

schema.core.Record.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__19083__auto__,G__55654){
var self__ = this;
var this__19083__auto____$1 = this;
return (new schema.core.Record(self__.klass,self__.schema,G__55654,self__.__extmap,self__.__hash));
});

schema.core.Record.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__19089__auto__,entry__19090__auto__){
var self__ = this;
var this__19089__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__19090__auto__)){
return cljs.core._assoc.call(null,this__19089__auto____$1,cljs.core._nth.call(null,entry__19090__auto__,(0)),cljs.core._nth.call(null,entry__19090__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__19089__auto____$1,entry__19090__auto__);
}
});

schema.core.Record.prototype.schema$core$Schema$ = true;

schema.core.Record.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.collection.collection_spec.call(null,(function (){var p = schema.spec.core.precondition.call(null,this$__$1,((function (this$__$1){
return (function (p1__55651_SHARP_){
return (p1__55651_SHARP_ instanceof self__.klass);
});})(this$__$1))
,((function (this$__$1){
return (function (p1__55652_SHARP_){
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,p1__55652_SHARP_),self__.klass),new cljs.core.Symbol(null,"instance?","instance?",1075939923,null));
});})(this$__$1))
);
var temp__4423__auto__ = new cljs.core.Keyword(null,"extra-validator-fn","extra-validator-fn",1562905865).cljs$core$IFn$_invoke$arity$1(this$__$1);
if(cljs.core.truth_(temp__4423__auto__)){
var evf = temp__4423__auto__;
return cljs.core.some_fn.call(null,p,schema.spec.core.precondition.call(null,this$__$1,evf,((function (evf,temp__4423__auto__,p,this$__$1){
return (function (p1__55653_SHARP_){
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,p1__55653_SHARP_),new cljs.core.Symbol(null,"passes-extra-validation?","passes-extra-validation?",-1964809231,null));
});})(evf,temp__4423__auto__,p,this$__$1))
));
} else {
return p;
}
})(),new cljs.core.Keyword(null,"constructor","constructor",-1953928811).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,this$__$1)),schema.core.map_elements.call(null,self__.schema),schema.core.map_error.call(null));
});

schema.core.Record.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,schema.core.explain.call(null,self__.schema)),cljs.core.symbol.call(null,cljs.core.pr_str.call(null,self__.klass))),new cljs.core.Symbol(null,"record","record",861424668,null));
});

schema.core.Record.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"klass","klass",253779178,null),new cljs.core.Symbol(null,"schema","schema",58529736,null)], null);
});

schema.core.Record.cljs$lang$type = true;

schema.core.Record.cljs$lang$ctorPrSeq = (function (this__19118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/Record");
});

schema.core.Record.cljs$lang$ctorPrWriter = (function (this__19118__auto__,writer__19119__auto__){
return cljs.core._write.call(null,writer__19119__auto__,"schema.core/Record");
});

schema.core.__GT_Record = (function schema$core$__GT_Record(klass,schema__$1){
return (new schema.core.Record(klass,schema__$1,null,null,null));
});

schema.core.map__GT_Record = (function schema$core$map__GT_Record(G__55656){
return (new schema.core.Record(new cljs.core.Keyword(null,"klass","klass",-1386752349).cljs$core$IFn$_invoke$arity$1(G__55656),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__55656),null,cljs.core.dissoc.call(null,G__55656,new cljs.core.Keyword(null,"klass","klass",-1386752349),new cljs.core.Keyword(null,"schema","schema",-1582001791)),null));
});

schema.core.record_STAR_ = (function schema$core$record_STAR_(klass,schema__$1,map_constructor){
if(cljs.core.map_QMARK_.call(null,schema__$1)){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Expected map, got %s",schema.utils.type_of.call(null,schema__$1))));
}

return cljs.core.with_meta.call(null,(new schema.core.Record(klass,schema__$1,null,null,null)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"constructor","constructor",-1953928811),map_constructor], null));
});
schema.core.explain_input_schema = (function schema$core$explain_input_schema(input_schema){
var vec__55665 = cljs.core.split_with.call(null,(function (p1__55662_SHARP_){
return (p1__55662_SHARP_ instanceof schema.core.One);
}),input_schema);
var required = cljs.core.nth.call(null,vec__55665,(0),null);
var more = cljs.core.nth.call(null,vec__55665,(1),null);
return cljs.core.concat.call(null,cljs.core.map.call(null,((function (vec__55665,required,more){
return (function (p1__55663_SHARP_){
return schema.core.explain.call(null,p1__55663_SHARP_.schema);
});})(vec__55665,required,more))
,required),((cljs.core.seq.call(null,more))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),cljs.core.mapv.call(null,schema.core.explain,more)], null):null));
});

/**
* @constructor
* @param {*} output_schema
* @param {*} input_schemas
* @param {*} __meta
* @param {*} __extmap
* @param {*} __hash
* @param {*=} __meta 
* @param {*=} __extmap
* @param {number|null} __hash
*/
schema.core.FnSchema = (function (output_schema,input_schemas,__meta,__extmap,__hash){
this.output_schema = output_schema;
this.input_schemas = input_schemas;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.FnSchema.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__19084__auto__,k__19085__auto__){
var self__ = this;
var this__19084__auto____$1 = this;
return cljs.core._lookup.call(null,this__19084__auto____$1,k__19085__auto__,null);
});

schema.core.FnSchema.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__19086__auto__,k55667,else__19087__auto__){
var self__ = this;
var this__19086__auto____$1 = this;
var G__55669 = (((k55667 instanceof cljs.core.Keyword))?k55667.fqn:null);
switch (G__55669) {
case "output-schema":
return self__.output_schema;

break;
case "input-schemas":
return self__.input_schemas;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k55667,else__19087__auto__);

}
});

schema.core.FnSchema.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__19098__auto__,writer__19099__auto__,opts__19100__auto__){
var self__ = this;
var this__19098__auto____$1 = this;
var pr_pair__19101__auto__ = ((function (this__19098__auto____$1){
return (function (keyval__19102__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,cljs.core.pr_writer,""," ","",opts__19100__auto__,keyval__19102__auto__);
});})(this__19098__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__19099__auto__,pr_pair__19101__auto__,"#schema.core.FnSchema{",", ","}",opts__19100__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"output-schema","output-schema",272504137),self__.output_schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"input-schemas","input-schemas",-982154805),self__.input_schemas],null))], null),self__.__extmap));
});

schema.core.FnSchema.prototype.cljs$core$IIterable$ = true;

schema.core.FnSchema.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__55666){
var self__ = this;
var G__55666__$1 = this;
return (new cljs.core.RecordIter((0),G__55666__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"output-schema","output-schema",272504137),new cljs.core.Keyword(null,"input-schemas","input-schemas",-982154805)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

schema.core.FnSchema.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__19082__auto__){
var self__ = this;
var this__19082__auto____$1 = this;
return self__.__meta;
});

schema.core.FnSchema.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__19078__auto__){
var self__ = this;
var this__19078__auto____$1 = this;
return (new schema.core.FnSchema(self__.output_schema,self__.input_schemas,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.FnSchema.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__19088__auto__){
var self__ = this;
var this__19088__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.FnSchema.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__19079__auto__){
var self__ = this;
var this__19079__auto____$1 = this;
var h__18905__auto__ = self__.__hash;
if(!((h__18905__auto__ == null))){
return h__18905__auto__;
} else {
var h__18905__auto____$1 = cljs.core.hash_imap.call(null,this__19079__auto____$1);
self__.__hash = h__18905__auto____$1;

return h__18905__auto____$1;
}
});

schema.core.FnSchema.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__19080__auto__,other__19081__auto__){
var self__ = this;
var this__19080__auto____$1 = this;
if(cljs.core.truth_((function (){var and__18477__auto__ = other__19081__auto__;
if(cljs.core.truth_(and__18477__auto__)){
var and__18477__auto____$1 = (this__19080__auto____$1.constructor === other__19081__auto__.constructor);
if(and__18477__auto____$1){
return cljs.core.equiv_map.call(null,this__19080__auto____$1,other__19081__auto__);
} else {
return and__18477__auto____$1;
}
} else {
return and__18477__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.FnSchema.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__19093__auto__,k__19094__auto__){
var self__ = this;
var this__19093__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"output-schema","output-schema",272504137),null,new cljs.core.Keyword(null,"input-schemas","input-schemas",-982154805),null], null), null),k__19094__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__19093__auto____$1),self__.__meta),k__19094__auto__);
} else {
return (new schema.core.FnSchema(self__.output_schema,self__.input_schemas,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__19094__auto__)),null));
}
});

schema.core.FnSchema.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__19091__auto__,k__19092__auto__,G__55666){
var self__ = this;
var this__19091__auto____$1 = this;
var pred__55670 = cljs.core.keyword_identical_QMARK_;
var expr__55671 = k__19092__auto__;
if(cljs.core.truth_(pred__55670.call(null,new cljs.core.Keyword(null,"output-schema","output-schema",272504137),expr__55671))){
return (new schema.core.FnSchema(G__55666,self__.input_schemas,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__55670.call(null,new cljs.core.Keyword(null,"input-schemas","input-schemas",-982154805),expr__55671))){
return (new schema.core.FnSchema(self__.output_schema,G__55666,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.FnSchema(self__.output_schema,self__.input_schemas,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__19092__auto__,G__55666),null));
}
}
});

schema.core.FnSchema.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__19096__auto__){
var self__ = this;
var this__19096__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"output-schema","output-schema",272504137),self__.output_schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"input-schemas","input-schemas",-982154805),self__.input_schemas],null))], null),self__.__extmap));
});

schema.core.FnSchema.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__19083__auto__,G__55666){
var self__ = this;
var this__19083__auto____$1 = this;
return (new schema.core.FnSchema(self__.output_schema,self__.input_schemas,G__55666,self__.__extmap,self__.__hash));
});

schema.core.FnSchema.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__19089__auto__,entry__19090__auto__){
var self__ = this;
var this__19089__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__19090__auto__)){
return cljs.core._assoc.call(null,this__19089__auto____$1,cljs.core._nth.call(null,entry__19090__auto__,(0)),cljs.core._nth.call(null,entry__19090__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__19089__auto____$1,entry__19090__auto__);
}
});

schema.core.FnSchema.prototype.schema$core$Schema$ = true;

schema.core.FnSchema.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.leaf.leaf_spec.call(null,schema.spec.core.precondition.call(null,this$__$1,cljs.core.ifn_QMARK_,((function (this$__$1){
return (function (p1__21322__21323__auto__){
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,p1__21322__21323__auto__),new cljs.core.Symbol(null,"ifn?","ifn?",-2106461064,null));
});})(this$__$1))
));
});

schema.core.FnSchema.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count.call(null,self__.input_schemas) > (1))){
return cljs.core.list_STAR_.call(null,new cljs.core.Symbol(null,"=>*","=>*",1909690043,null),schema.core.explain.call(null,self__.output_schema),cljs.core.map.call(null,schema.core.explain_input_schema,self__.input_schemas));
} else {
return cljs.core.list_STAR_.call(null,new cljs.core.Symbol(null,"=>","=>",-813269641,null),schema.core.explain.call(null,self__.output_schema),schema.core.explain_input_schema.call(null,cljs.core.first.call(null,self__.input_schemas)));
}
});

schema.core.FnSchema.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"output-schema","output-schema",1913035664,null),new cljs.core.Symbol(null,"input-schemas","input-schemas",658376722,null)], null);
});

schema.core.FnSchema.cljs$lang$type = true;

schema.core.FnSchema.cljs$lang$ctorPrSeq = (function (this__19118__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/FnSchema");
});

schema.core.FnSchema.cljs$lang$ctorPrWriter = (function (this__19118__auto__,writer__19119__auto__){
return cljs.core._write.call(null,writer__19119__auto__,"schema.core/FnSchema");
});

schema.core.__GT_FnSchema = (function schema$core$__GT_FnSchema(output_schema,input_schemas){
return (new schema.core.FnSchema(output_schema,input_schemas,null,null,null));
});

schema.core.map__GT_FnSchema = (function schema$core$map__GT_FnSchema(G__55668){
return (new schema.core.FnSchema(new cljs.core.Keyword(null,"output-schema","output-schema",272504137).cljs$core$IFn$_invoke$arity$1(G__55668),new cljs.core.Keyword(null,"input-schemas","input-schemas",-982154805).cljs$core$IFn$_invoke$arity$1(G__55668),null,cljs.core.dissoc.call(null,G__55668,new cljs.core.Keyword(null,"output-schema","output-schema",272504137),new cljs.core.Keyword(null,"input-schemas","input-schemas",-982154805)),null));
});

schema.core.arity = (function schema$core$arity(input_schema){
if(cljs.core.seq.call(null,input_schema)){
if((cljs.core.last.call(null,input_schema) instanceof schema.core.One)){
return cljs.core.count.call(null,input_schema);
} else {
return Number.MAX_VALUE;
}
} else {
return (0);
}
});
/**
 * A function outputting a value in output schema, whose argument vector must match one of
 * input-schemas, each of which should be a sequence schema.
 * Currently function schemas are purely descriptive; they validate against any function,
 * regardless of actual input and output types.
 */
schema.core.make_fn_schema = (function schema$core$make_fn_schema(output_schema,input_schemas){
if(cljs.core.seq.call(null,input_schemas)){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Function must have at least one input schema")));
}

if(cljs.core.every_QMARK_.call(null,cljs.core.vector_QMARK_,input_schemas)){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Each arity must be a vector.")));
}

if(cljs.core.truth_(cljs.core.apply.call(null,cljs.core.distinct_QMARK_,cljs.core.map.call(null,schema.core.arity,input_schemas)))){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Arities must be distinct")));
}

return (new schema.core.FnSchema(output_schema,cljs.core.sort_by.call(null,schema.core.arity,input_schemas),null,null,null));
});
/**
 * Records name in schema's metadata.
 */
schema.core.schema_with_name = (function schema$core$schema_with_name(schema__$1,name){
return cljs.core.vary_meta.call(null,schema__$1,cljs.core.assoc,new cljs.core.Keyword(null,"name","name",1843675177),name);
});
/**
 * Returns the name of a schema attached via schema-with-name (or defschema).
 */
schema.core.schema_name = (function schema$core$schema_name(schema__$1){
return new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,schema__$1));
});
/**
 * Returns the namespace of a schema attached via defschema.
 */
schema.core.schema_ns = (function schema$core$schema_ns(schema__$1){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,schema__$1));
});
/**
 * Get the current global schema validation setting.
 */
schema.core.fn_validation_QMARK_ = (function schema$core$fn_validation_QMARK_(){
return schema.utils.use_fn_validation.get_cell();
});
/**
 * Globally turn on (or off) schema validation for all s/fn and s/defn instances.
 */
schema.core.set_fn_validation_BANG_ = (function schema$core$set_fn_validation_BANG_(on_QMARK_){
return schema.utils.use_fn_validation.set_cell(on_QMARK_);
});
/**
 * Attach the schema to fn f at runtime, extractable by fn-schema.
 */
schema.core.schematize_fn = (function schema$core$schematize_fn(f,schema__$1){
return cljs.core.vary_meta.call(null,f,cljs.core.assoc,new cljs.core.Keyword(null,"schema","schema",-1582001791),schema__$1);
});
/**
 * Produce the schema for a function defined with s/fn or s/defn.
 */
schema.core.fn_schema = (function schema$core$fn_schema(f){
if(cljs.core.fn_QMARK_.call(null,f)){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Non-function %s",schema.utils.type_of.call(null,f))));
}

var or__18489__auto__ = schema.utils.class_schema.call(null,schema.utils.fn_schema_bearer.call(null,f));
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
var m__21083__auto__ = cljs.core.meta.call(null,f);
var k__21084__auto__ = new cljs.core.Keyword(null,"schema","schema",-1582001791);
var temp__4423__auto__ = cljs.core.find.call(null,m__21083__auto__,k__21084__auto__);
if(cljs.core.truth_(temp__4423__auto__)){
var pair__21085__auto__ = temp__4423__auto__;
return cljs.core.val.call(null,pair__21085__auto__);
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Key %s not found in %s",k__21084__auto__,m__21083__auto__)));
}
}
});
/**
 * Sets the maximum length of value to be output before it is contracted to a prettier name.
 */
schema.core.set_max_value_length_BANG_ = (function schema$core$set_max_value_length_BANG_(max_length){
return cljs.core.reset_BANG_.call(null,schema.utils.max_value_length,max_length);
});

//# sourceMappingURL=core.js.map