// Compiled by ClojureScript 1.7.48 {}
goog.provide('om_inputs.validation');
goog.require('cljs.core');
goog.require('schema.core');
goog.require('om_inputs.date_utils');
goog.require('jkkramer.verily');
goog.require('schema.coerce');
goog.require('clojure.set');
goog.require('om_inputs.extern');
goog.require('om_inputs.schemas');
goog.require('clojure.string');
/**
 * The validation error message keys for a field.
 * The key is not the rule key but the message key.
 */
om_inputs.validation.sch_errors_list = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.named.call(null,schema.core.Keyword,"message")], null);
/**
 * Describes the om-input's error data structure.
 * A field can have multiples errors.
 */
om_inputs.validation.sch_errors = new cljs.core.PersistentArrayMap.fromArray([om_inputs.schemas.sch_field,om_inputs.validation.sch_errors_list], true, false);
/**
 * Describes the Verily errors data structure.
 */
om_inputs.validation.sch_verily_errs = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [om_inputs.schemas.sch_field], null),new cljs.core.Keyword(null,"msg","msg",-1386103444),schema.core.Keyword], null)], null);
/**
 * Describes the Schema errors data structure
 */
om_inputs.validation.sch_schema_errs = new cljs.core.PersistentArrayMap.fromArray([om_inputs.schemas.sch_field,schema.core.Any], true, false);
/**
 * Do not validate an empty string as a valid s/Str
 */
om_inputs.validation.empty_string_coercer = (function om_inputs$validation$empty_string_coercer(s){
if(cljs.core.truth_(clojure.string.blank_QMARK_.call(null,s))){
return null;
} else {
return s;
}
});
/**
 * Coerce an input string to a date.
 * The default format is used.
 * A blank string is coerced to nil.
 */
om_inputs.validation.inst_coercer = (function om_inputs$validation$inst_coercer(s){
if(cljs.core.truth_(clojure.string.blank_QMARK_.call(null,s))){
return null;
} else {
return om_inputs.date_utils.parse.call(null,om_inputs.date_utils.fmt.call(null,om_inputs.date_utils.default_fmt,s));
}
});
/**
 * Schema coercers used for inputs that are sent as string.
 */
om_inputs.validation.validation_coercer = new cljs.core.PersistentArrayMap.fromArray([schema.core.Num,schema.coerce.safe.call(null,schema.coerce.edn_read_string),schema.core.Regex,om_inputs.validation.empty_string_coercer,schema.core.Str,om_inputs.validation.empty_string_coercer,schema.core.maybe.call(null,schema.core.Str),om_inputs.validation.empty_string_coercer,schema.core.Inst,om_inputs.validation.inst_coercer], true, false);
/**
 * Generic sequence of validation.
 * The first args can be partially applied to generate a custom validator.
 */
om_inputs.validation.validate = (function om_inputs$validation$validate(validation_fn,post,m){
return post.call(null,validation_fn.call(null,m));
});
var ufv___23279 = schema.utils.use_fn_validation;
var output_schema23258_23280 = om_inputs.validation.sch_errors;
var input_schema23259_23281 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_inputs.validation.sch_schema_errs,cljs.core.with_meta(new cljs.core.Symbol(null,"errs","errs",122908184,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-schema-errs","sch-schema-errs",1633294259,null)], null)))], null);
var input_checker23260_23282 = schema.core.checker.call(null,input_schema23259_23281);
var output_checker23261_23283 = schema.core.checker.call(null,output_schema23258_23280);
/**
 * Inputs: [errs :- sch-schema-errs]
 * Returns: sch-errors
 * 
 * Transforms the Schema's error data structure into the common error data structure.
 * For the moment Schema error are treated as missing field.
 */
om_inputs.validation.transform_schema_errors = ((function (ufv___23279,output_schema23258_23280,input_schema23259_23281,input_checker23260_23282,output_checker23261_23283){
return (function om_inputs$validation$transform_schema_errors(G__23262){
var validate__20884__auto__ = ufv___23279.get_cell();
if(cljs.core.truth_(validate__20884__auto__)){
var args__20885__auto___23284 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__23262], null);
var temp__4425__auto___23285 = input_checker23260_23282.call(null,args__20885__auto___23284);
if(cljs.core.truth_(temp__4425__auto___23285)){
var error__20886__auto___23286 = temp__4425__auto___23285;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"transform-schema-errors","transform-schema-errors",1319365661,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-errors","sch-errors",1963156247,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transforms the Schema's error data structure into the common error data structure.\n  For the moment Schema error are treated as missing field."], null)),cljs.core.pr_str.call(null,error__20886__auto___23286)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema23259_23281,new cljs.core.Keyword(null,"value","value",305978217),args__20885__auto___23284,new cljs.core.Keyword(null,"error","error",-978969032),error__20886__auto___23286], null));
} else {
}
} else {
}

var o__20887__auto__ = (function (){var errs = G__23262;
while(true){
var temp__4425__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(errs);
if(cljs.core.truth_(temp__4425__auto__)){
var errors = temp__4425__auto__;
return cljs.core.apply.call(null,cljs.core.merge_with,cljs.core.concat,(function (){var iter__19242__auto__ = ((function (errors,temp__4425__auto__,validate__20884__auto__,ufv___23279,output_schema23258_23280,input_schema23259_23281,input_checker23260_23282,output_checker23261_23283){
return (function om_inputs$validation$transform_schema_errors_$_iter__23271(s__23272){
return (new cljs.core.LazySeq(null,((function (errors,temp__4425__auto__,validate__20884__auto__,ufv___23279,output_schema23258_23280,input_schema23259_23281,input_checker23260_23282,output_checker23261_23283){
return (function (){
var s__23272__$1 = s__23272;
while(true){
var temp__4425__auto____$1 = cljs.core.seq.call(null,s__23272__$1);
if(temp__4425__auto____$1){
var s__23272__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23272__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__23272__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__23274 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__23273 = (0);
while(true){
if((i__23273 < size__19241__auto__)){
var vec__23277 = cljs.core._nth.call(null,c__19240__auto__,i__23273);
var k = cljs.core.nth.call(null,vec__23277,(0),null);
var _ = cljs.core.nth.call(null,vec__23277,(1),null);
cljs.core.chunk_append.call(null,b__23274,new cljs.core.PersistentArrayMap.fromArray([k,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mandatory","mandatory",542802336)], null)], true, false));

var G__23287 = (i__23273 + (1));
i__23273 = G__23287;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23274),om_inputs$validation$transform_schema_errors_$_iter__23271.call(null,cljs.core.chunk_rest.call(null,s__23272__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23274),null);
}
} else {
var vec__23278 = cljs.core.first.call(null,s__23272__$2);
var k = cljs.core.nth.call(null,vec__23278,(0),null);
var _ = cljs.core.nth.call(null,vec__23278,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([k,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mandatory","mandatory",542802336)], null)], true, false),om_inputs$validation$transform_schema_errors_$_iter__23271.call(null,cljs.core.rest.call(null,s__23272__$2)));
}
} else {
return null;
}
break;
}
});})(errors,temp__4425__auto__,validate__20884__auto__,ufv___23279,output_schema23258_23280,input_schema23259_23281,input_checker23260_23282,output_checker23261_23283))
,null,null));
});})(errors,temp__4425__auto__,validate__20884__auto__,ufv___23279,output_schema23258_23280,input_schema23259_23281,input_checker23260_23282,output_checker23261_23283))
;
return iter__19242__auto__.call(null,errors);
})());
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__20884__auto__)){
var temp__4425__auto___23288 = output_checker23261_23283.call(null,o__20887__auto__);
if(cljs.core.truth_(temp__4425__auto___23288)){
var error__20886__auto___23289 = temp__4425__auto___23288;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"transform-schema-errors","transform-schema-errors",1319365661,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-errors","sch-errors",1963156247,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transforms the Schema's error data structure into the common error data structure.\n  For the moment Schema error are treated as missing field."], null)),cljs.core.pr_str.call(null,error__20886__auto___23289)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema23258_23280,new cljs.core.Keyword(null,"value","value",305978217),o__20887__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20886__auto___23289], null));
} else {
}
} else {
}

return o__20887__auto__;
});})(ufv___23279,output_schema23258_23280,input_schema23259_23281,input_checker23260_23282,output_checker23261_23283))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_inputs.validation.transform_schema_errors),schema.core.make_fn_schema.call(null,output_schema23258_23280,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema23259_23281], null)));
var ufv___23315 = schema.utils.use_fn_validation;
var output_schema23290_23316 = om_inputs.validation.sch_errors;
var input_schema23291_23317 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_inputs.validation.sch_verily_errs,cljs.core.with_meta(new cljs.core.Symbol(null,"errs","errs",122908184,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-verily-errs","sch-verily-errs",-1962614795,null)], null)))], null);
var input_checker23292_23318 = schema.core.checker.call(null,input_schema23291_23317);
var output_checker23293_23319 = schema.core.checker.call(null,output_schema23290_23316);
/**
 * Inputs: [errs :- sch-verily-errs]
 * Returns: sch-errors
 * 
 * Transforms the Verily's error data structure into the common error data structure.
 */
om_inputs.validation.transform_verily_errors = ((function (ufv___23315,output_schema23290_23316,input_schema23291_23317,input_checker23292_23318,output_checker23293_23319){
return (function om_inputs$validation$transform_verily_errors(G__23294){
var validate__20884__auto__ = ufv___23315.get_cell();
if(cljs.core.truth_(validate__20884__auto__)){
var args__20885__auto___23320 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__23294], null);
var temp__4425__auto___23321 = input_checker23292_23318.call(null,args__20885__auto___23320);
if(cljs.core.truth_(temp__4425__auto___23321)){
var error__20886__auto___23322 = temp__4425__auto___23321;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"transform-verily-errors","transform-verily-errors",-197737448,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-errors","sch-errors",1963156247,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transforms the Verily's error data structure into the common error data structure."], null)),cljs.core.pr_str.call(null,error__20886__auto___23322)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema23291_23317,new cljs.core.Keyword(null,"value","value",305978217),args__20885__auto___23320,new cljs.core.Keyword(null,"error","error",-978969032),error__20886__auto___23322], null));
} else {
}
} else {
}

var o__20887__auto__ = (function (){var errs = G__23294;
while(true){
if(cljs.core.seq.call(null,errs)){
return cljs.core.apply.call(null,cljs.core.merge_with,cljs.core.concat,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19242__auto__ = ((function (validate__20884__auto__,ufv___23315,output_schema23290_23316,input_schema23291_23317,input_checker23292_23318,output_checker23293_23319){
return (function om_inputs$validation$transform_verily_errors_$_iter__23305(s__23306){
return (new cljs.core.LazySeq(null,((function (validate__20884__auto__,ufv___23315,output_schema23290_23316,input_schema23291_23317,input_checker23292_23318,output_checker23293_23319){
return (function (){
var s__23306__$1 = s__23306;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__23306__$1);
if(temp__4425__auto__){
var xs__4977__auto__ = temp__4425__auto__;
var map__23313 = cljs.core.first.call(null,xs__4977__auto__);
var map__23313__$1 = ((((!((map__23313 == null)))?((((map__23313.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23313.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23313):map__23313);
var keys = cljs.core.get.call(null,map__23313__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var msg = cljs.core.get.call(null,map__23313__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var iterys__19238__auto__ = ((function (s__23306__$1,map__23313,map__23313__$1,keys,msg,xs__4977__auto__,temp__4425__auto__,validate__20884__auto__,ufv___23315,output_schema23290_23316,input_schema23291_23317,input_checker23292_23318,output_checker23293_23319){
return (function om_inputs$validation$transform_verily_errors_$_iter__23305_$_iter__23307(s__23308){
return (new cljs.core.LazySeq(null,((function (s__23306__$1,map__23313,map__23313__$1,keys,msg,xs__4977__auto__,temp__4425__auto__,validate__20884__auto__,ufv___23315,output_schema23290_23316,input_schema23291_23317,input_checker23292_23318,output_checker23293_23319){
return (function (){
var s__23308__$1 = s__23308;
while(true){
var temp__4425__auto____$1 = cljs.core.seq.call(null,s__23308__$1);
if(temp__4425__auto____$1){
var s__23308__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23308__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__23308__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__23310 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__23309 = (0);
while(true){
if((i__23309 < size__19241__auto__)){
var k = cljs.core._nth.call(null,c__19240__auto__,i__23309);
cljs.core.chunk_append.call(null,b__23310,new cljs.core.PersistentArrayMap.fromArray([k,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg], null)], true, false));

var G__23323 = (i__23309 + (1));
i__23309 = G__23323;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23310),om_inputs$validation$transform_verily_errors_$_iter__23305_$_iter__23307.call(null,cljs.core.chunk_rest.call(null,s__23308__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23310),null);
}
} else {
var k = cljs.core.first.call(null,s__23308__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([k,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg], null)], true, false),om_inputs$validation$transform_verily_errors_$_iter__23305_$_iter__23307.call(null,cljs.core.rest.call(null,s__23308__$2)));
}
} else {
return null;
}
break;
}
});})(s__23306__$1,map__23313,map__23313__$1,keys,msg,xs__4977__auto__,temp__4425__auto__,validate__20884__auto__,ufv___23315,output_schema23290_23316,input_schema23291_23317,input_checker23292_23318,output_checker23293_23319))
,null,null));
});})(s__23306__$1,map__23313,map__23313__$1,keys,msg,xs__4977__auto__,temp__4425__auto__,validate__20884__auto__,ufv___23315,output_schema23290_23316,input_schema23291_23317,input_checker23292_23318,output_checker23293_23319))
;
var fs__19239__auto__ = cljs.core.seq.call(null,iterys__19238__auto__.call(null,keys));
if(fs__19239__auto__){
return cljs.core.concat.call(null,fs__19239__auto__,om_inputs$validation$transform_verily_errors_$_iter__23305.call(null,cljs.core.rest.call(null,s__23306__$1)));
} else {
var G__23324 = cljs.core.rest.call(null,s__23306__$1);
s__23306__$1 = G__23324;
continue;
}
} else {
return null;
}
break;
}
});})(validate__20884__auto__,ufv___23315,output_schema23290_23316,input_schema23291_23317,input_checker23292_23318,output_checker23293_23319))
,null,null));
});})(validate__20884__auto__,ufv___23315,output_schema23290_23316,input_schema23291_23317,input_checker23292_23318,output_checker23293_23319))
;
return iter__19242__auto__.call(null,errs);
})());
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__20884__auto__)){
var temp__4425__auto___23325 = output_checker23293_23319.call(null,o__20887__auto__);
if(cljs.core.truth_(temp__4425__auto___23325)){
var error__20886__auto___23326 = temp__4425__auto___23325;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"transform-verily-errors","transform-verily-errors",-197737448,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-errors","sch-errors",1963156247,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transforms the Verily's error data structure into the common error data structure."], null)),cljs.core.pr_str.call(null,error__20886__auto___23326)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema23290_23316,new cljs.core.Keyword(null,"value","value",305978217),o__20887__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20886__auto___23326], null));
} else {
}
} else {
}

return o__20887__auto__;
});})(ufv___23315,output_schema23290_23316,input_schema23291_23317,input_checker23292_23318,output_checker23293_23319))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_inputs.validation.transform_verily_errors),schema.core.make_fn_schema.call(null,output_schema23290_23316,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema23291_23317], null)));
om_inputs.validation.build_verily_validator = (function om_inputs$validation$build_verily_validator(rules){
return cljs.core.partial.call(null,om_inputs.validation.validate,jkkramer.verily.validations__GT_fn.call(null,rules),om_inputs.validation.transform_verily_errors);
});
om_inputs.validation.inter_fields_rules = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"lower-or-equal","lower-or-equal",-1150663190),null,new cljs.core.Keyword(null,"greater-or-equal","greater-or-equal",302221395),null,new cljs.core.Keyword(null,"lower","lower",1120320821),null,new cljs.core.Keyword(null,"greater","greater",1370260601),null,new cljs.core.Keyword(null,"equal","equal",-1921681350),null], null), null);
/**
 * Build the map error->rule
 */
om_inputs.validation.error__GT_rule = (function om_inputs$validation$error__GT_rule(rules){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19242__auto__ = (function om_inputs$validation$error__GT_rule_$_iter__23331(s__23332){
return (new cljs.core.LazySeq(null,(function (){
var s__23332__$1 = s__23332;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__23332__$1);
if(temp__4425__auto__){
var s__23332__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23332__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__23332__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__23334 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__23333 = (0);
while(true){
if((i__23333 < size__19241__auto__)){
var r = cljs.core._nth.call(null,c__19240__auto__,i__23333);
cljs.core.chunk_append.call(null,b__23334,cljs.core.juxt.call(null,cljs.core.last,cljs.core.first).call(null,r));

var G__23335 = (i__23333 + (1));
i__23333 = G__23335;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23334),om_inputs$validation$error__GT_rule_$_iter__23331.call(null,cljs.core.chunk_rest.call(null,s__23332__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23334),null);
}
} else {
var r = cljs.core.first.call(null,s__23332__$2);
return cljs.core.cons.call(null,cljs.core.juxt.call(null,cljs.core.last,cljs.core.first).call(null,r),om_inputs$validation$error__GT_rule_$_iter__23331.call(null,cljs.core.rest.call(null,s__23332__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__19242__auto__.call(null,rules);
})());
});
/**
 * Determines validation dependencies between fields
 */
om_inputs.validation.fields_dependencies = (function om_inputs$validation$fields_dependencies(){
var args23336 = [];
var len__19528__auto___23351 = arguments.length;
var i__19529__auto___23352 = (0);
while(true){
if((i__19529__auto___23352 < len__19528__auto___23351)){
args23336.push((arguments[i__19529__auto___23352]));

var G__23353 = (i__19529__auto___23352 + (1));
i__19529__auto___23352 = G__23353;
continue;
} else {
}
break;
}

var G__23338 = args23336.length;
switch (G__23338) {
case 1:
return om_inputs.validation.fields_dependencies.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return om_inputs.validation.fields_dependencies.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23336.length)].join('')));

}
});

om_inputs.validation.fields_dependencies.cljs$core$IFn$_invoke$arity$1 = (function (rules){
return om_inputs.validation.fields_dependencies.call(null,om_inputs.validation.inter_fields_rules,rules);
});

om_inputs.validation.fields_dependencies.cljs$core$IFn$_invoke$arity$2 = (function (rule_keys,rules){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19242__auto__ = (function om_inputs$validation$iter__23339(s__23340){
return (new cljs.core.LazySeq(null,(function (){
var s__23340__$1 = s__23340;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__23340__$1);
if(temp__4425__auto__){
var s__23340__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23340__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__23340__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__23342 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__23341 = (0);
while(true){
if((i__23341 < size__19241__auto__)){
var vec__23347 = cljs.core._nth.call(null,c__19240__auto__,i__23341);
var r = cljs.core.nth.call(null,vec__23347,(0),null);
var fs = cljs.core.nth.call(null,vec__23347,(1),null);
var m = cljs.core.nth.call(null,vec__23347,(2),null);
if(cljs.core.truth_(rule_keys.call(null,r))){
var vec__23348 = fs;
var f = cljs.core.nth.call(null,vec__23348,(0),null);
var deps = cljs.core.nthnext.call(null,vec__23348,(1));
cljs.core.chunk_append.call(null,b__23342,new cljs.core.PersistentArrayMap.fromArray([f,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"deps","deps",1883360319),deps,new cljs.core.Keyword(null,"mess","mess",530922968),m,new cljs.core.Keyword(null,"rule","rule",729973257),r], null)], true, false));

var G__23355 = (i__23341 + (1));
i__23341 = G__23355;
continue;
} else {
var G__23356 = (i__23341 + (1));
i__23341 = G__23356;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23342),om_inputs$validation$iter__23339.call(null,cljs.core.chunk_rest.call(null,s__23340__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23342),null);
}
} else {
var vec__23349 = cljs.core.first.call(null,s__23340__$2);
var r = cljs.core.nth.call(null,vec__23349,(0),null);
var fs = cljs.core.nth.call(null,vec__23349,(1),null);
var m = cljs.core.nth.call(null,vec__23349,(2),null);
if(cljs.core.truth_(rule_keys.call(null,r))){
var vec__23350 = fs;
var f = cljs.core.nth.call(null,vec__23350,(0),null);
var deps = cljs.core.nthnext.call(null,vec__23350,(1));
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([f,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"deps","deps",1883360319),deps,new cljs.core.Keyword(null,"mess","mess",530922968),m,new cljs.core.Keyword(null,"rule","rule",729973257),r], null)], true, false),om_inputs$validation$iter__23339.call(null,cljs.core.rest.call(null,s__23340__$2)));
} else {
var G__23357 = cljs.core.rest.call(null,s__23340__$2);
s__23340__$1 = G__23357;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__19242__auto__.call(null,rules);
})());
});

om_inputs.validation.fields_dependencies.cljs$lang$maxFixedArity = 2;
var ufv___23364 = schema.utils.use_fn_validation;
var output_schema23358_23365 = om_inputs.schemas.sch_business_state;
var input_schema23359_23366 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null))),schema.core.one.call(null,om_inputs.validation.sch_errors,cljs.core.with_meta(new cljs.core.Symbol(null,"errs","errs",122908184,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-errors","sch-errors",1963156247,null)], null)))], null);
var input_checker23360_23367 = schema.core.checker.call(null,input_schema23359_23366);
var output_checker23361_23368 = schema.core.checker.call(null,output_schema23358_23365);
/**
 * Inputs: [state :- sch-business-state errs :- sch-errors]
 * Returns: sch-business-state
 * 
 * Set valid to false for each key in errors, true if absent
 */
om_inputs.validation.handle_errors = ((function (ufv___23364,output_schema23358_23365,input_schema23359_23366,input_checker23360_23367,output_checker23361_23368){
return (function om_inputs$validation$handle_errors(G__23362,G__23363){
var validate__20884__auto__ = ufv___23364.get_cell();
if(cljs.core.truth_(validate__20884__auto__)){
var args__20885__auto___23369 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__23362,G__23363], null);
var temp__4425__auto___23370 = input_checker23360_23367.call(null,args__20885__auto___23369);
if(cljs.core.truth_(temp__4425__auto___23370)){
var error__20886__auto___23371 = temp__4425__auto___23370;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"handle-errors","handle-errors",1833858829,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Set valid to false for each key in errors, true if absent"], null)),cljs.core.pr_str.call(null,error__20886__auto___23371)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema23359_23366,new cljs.core.Keyword(null,"value","value",305978217),args__20885__auto___23369,new cljs.core.Keyword(null,"error","error",-978969032),error__20886__auto___23371], null));
} else {
}
} else {
}

var o__20887__auto__ = (function (){var state = G__23362;
var errs = G__23363;
while(true){
var err_ks = cljs.core.set.call(null,cljs.core.keys.call(null,errs));
var all_ks = cljs.core.set.call(null,cljs.core.keys.call(null,state));
var valid_ks = clojure.set.difference.call(null,all_ks,err_ks);
var state__$1 = cljs.core.reduce.call(null,((function (err_ks,all_ks,valid_ks,validate__20884__auto__,ufv___23364,output_schema23358_23365,input_schema23359_23366,input_checker23360_23367,output_checker23361_23368){
return (function (s,e){
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,s,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,new cljs.core.Keyword(null,"valid","valid",155614240)], null),false),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,new cljs.core.Keyword(null,"error","error",-978969032)], null),e.call(null,errs));
});})(err_ks,all_ks,valid_ks,validate__20884__auto__,ufv___23364,output_schema23358_23365,input_schema23359_23366,input_checker23360_23367,output_checker23361_23368))
,state,err_ks);
return cljs.core.reduce.call(null,((function (err_ks,all_ks,valid_ks,state__$1,validate__20884__auto__,ufv___23364,output_schema23358_23365,input_schema23359_23366,input_checker23360_23367,output_checker23361_23368){
return (function (s,e){
return cljs.core.update_in.call(null,cljs.core.assoc_in.call(null,s,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,new cljs.core.Keyword(null,"valid","valid",155614240)], null),true),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [e], null),cljs.core.dissoc,new cljs.core.Keyword(null,"error","error",-978969032));
});})(err_ks,all_ks,valid_ks,state__$1,validate__20884__auto__,ufv___23364,output_schema23358_23365,input_schema23359_23366,input_checker23360_23367,output_checker23361_23368))
,state__$1,valid_ks);
break;
}
})();
if(cljs.core.truth_(validate__20884__auto__)){
var temp__4425__auto___23372 = output_checker23361_23368.call(null,o__20887__auto__);
if(cljs.core.truth_(temp__4425__auto___23372)){
var error__20886__auto___23373 = temp__4425__auto___23372;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"handle-errors","handle-errors",1833858829,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Set valid to false for each key in errors, true if absent"], null)),cljs.core.pr_str.call(null,error__20886__auto___23373)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema23358_23365,new cljs.core.Keyword(null,"value","value",305978217),o__20887__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20886__auto___23373], null));
} else {
}
} else {
}

return o__20887__auto__;
});})(ufv___23364,output_schema23358_23365,input_schema23359_23366,input_checker23360_23367,output_checker23361_23368))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_inputs.validation.handle_errors),schema.core.make_fn_schema.call(null,output_schema23358_23365,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema23359_23366], null)));
var ufv___23395 = schema.utils.use_fn_validation;
var output_schema23374_23396 = om_inputs.schemas.sch_business_state;
var input_schema23375_23397 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"bs","bs",-906042210,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)))], null);
var input_checker23376_23398 = schema.core.checker.call(null,input_schema23375_23397);
var output_checker23377_23399 = schema.core.checker.call(null,output_schema23374_23396);
/**
 * Inputs: [bs :- sch-business-state]
 * Returns: sch-business-state
 */
om_inputs.validation.keep_fields_to_validate = ((function (ufv___23395,output_schema23374_23396,input_schema23375_23397,input_checker23376_23398,output_checker23377_23399){
return (function om_inputs$validation$keep_fields_to_validate(G__23378){
var validate__20884__auto__ = ufv___23395.get_cell();
if(cljs.core.truth_(validate__20884__auto__)){
var args__20885__auto___23400 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__23378], null);
var temp__4425__auto___23401 = input_checker23376_23398.call(null,args__20885__auto___23400);
if(cljs.core.truth_(temp__4425__auto___23401)){
var error__20886__auto___23402 = temp__4425__auto___23401;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"keep-fields-to-validate","keep-fields-to-validate",943659297,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)),cljs.core.pr_str.call(null,error__20886__auto___23402)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema23375_23397,new cljs.core.Keyword(null,"value","value",305978217),args__20885__auto___23400,new cljs.core.Keyword(null,"error","error",-978969032),error__20886__auto___23402], null));
} else {
}
} else {
}

var o__20887__auto__ = (function (){var bs = G__23378;
while(true){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19242__auto__ = ((function (validate__20884__auto__,ufv___23395,output_schema23374_23396,input_schema23375_23397,input_checker23376_23398,output_checker23377_23399){
return (function om_inputs$validation$keep_fields_to_validate_$_iter__23387(s__23388){
return (new cljs.core.LazySeq(null,((function (validate__20884__auto__,ufv___23395,output_schema23374_23396,input_schema23375_23397,input_checker23376_23398,output_checker23377_23399){
return (function (){
var s__23388__$1 = s__23388;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__23388__$1);
if(temp__4425__auto__){
var s__23388__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23388__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__23388__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__23390 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__23389 = (0);
while(true){
if((i__23389 < size__19241__auto__)){
var vec__23393 = cljs.core._nth.call(null,c__19240__auto__,i__23389);
var k = cljs.core.nth.call(null,vec__23393,(0),null);
var m = cljs.core.nth.call(null,vec__23393,(1),null);
var in$ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(m);
var req = new cljs.core.Keyword(null,"required","required",1807647006).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_((function (){var or__18489__auto__ = req;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,in$));
}
})())){
cljs.core.chunk_append.call(null,b__23390,new cljs.core.PersistentArrayMap.fromArray([k,m], true, false));

var G__23403 = (i__23389 + (1));
i__23389 = G__23403;
continue;
} else {
var G__23404 = (i__23389 + (1));
i__23389 = G__23404;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23390),om_inputs$validation$keep_fields_to_validate_$_iter__23387.call(null,cljs.core.chunk_rest.call(null,s__23388__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23390),null);
}
} else {
var vec__23394 = cljs.core.first.call(null,s__23388__$2);
var k = cljs.core.nth.call(null,vec__23394,(0),null);
var m = cljs.core.nth.call(null,vec__23394,(1),null);
var in$ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(m);
var req = new cljs.core.Keyword(null,"required","required",1807647006).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_((function (){var or__18489__auto__ = req;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,in$));
}
})())){
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([k,m], true, false),om_inputs$validation$keep_fields_to_validate_$_iter__23387.call(null,cljs.core.rest.call(null,s__23388__$2)));
} else {
var G__23405 = cljs.core.rest.call(null,s__23388__$2);
s__23388__$1 = G__23405;
continue;
}
}
} else {
return null;
}
break;
}
});})(validate__20884__auto__,ufv___23395,output_schema23374_23396,input_schema23375_23397,input_checker23376_23398,output_checker23377_23399))
,null,null));
});})(validate__20884__auto__,ufv___23395,output_schema23374_23396,input_schema23375_23397,input_checker23376_23398,output_checker23377_23399))
;
return iter__19242__auto__.call(null,bs);
})());
break;
}
})();
if(cljs.core.truth_(validate__20884__auto__)){
var temp__4425__auto___23406 = output_checker23377_23399.call(null,o__20887__auto__);
if(cljs.core.truth_(temp__4425__auto___23406)){
var error__20886__auto___23407 = temp__4425__auto___23406;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"keep-fields-to-validate","keep-fields-to-validate",943659297,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)),cljs.core.pr_str.call(null,error__20886__auto___23407)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema23374_23396,new cljs.core.Keyword(null,"value","value",305978217),o__20887__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20886__auto___23407], null));
} else {
}
} else {
}

return o__20887__auto__;
});})(ufv___23395,output_schema23374_23396,input_schema23375_23397,input_checker23376_23398,output_checker23377_23399))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_inputs.validation.keep_fields_to_validate),schema.core.make_fn_schema.call(null,output_schema23374_23396,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema23375_23397], null)));
var ufv___23414 = schema.utils.use_fn_validation;
var output_schema23408_23415 = new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Any], true, false);
var input_schema23409_23416 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"bs","bs",-906042210,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null))),schema.core.one.call(null,schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"fk","fk",2038974178,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)))], null);
var input_checker23410_23417 = schema.core.checker.call(null,input_schema23409_23416);
var output_checker23411_23418 = schema.core.checker.call(null,output_schema23408_23415);
/**
 * Inputs: [bs :- sch-business-state fk :- s/Keyword]
 * Returns: {s/Keyword s/Any}
 * 
 * Extract map fk->value for a single field.
 */
om_inputs.validation.bs__GT_unit_map = ((function (ufv___23414,output_schema23408_23415,input_schema23409_23416,input_checker23410_23417,output_checker23411_23418){
return (function om_inputs$validation$bs__GT_unit_map(G__23412,G__23413){
var validate__20884__auto__ = ufv___23414.get_cell();
if(cljs.core.truth_(validate__20884__auto__)){
var args__20885__auto___23419 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__23412,G__23413], null);
var temp__4425__auto___23420 = input_checker23410_23417.call(null,args__20885__auto___23419);
if(cljs.core.truth_(temp__4425__auto___23420)){
var error__20886__auto___23421 = temp__4425__auto___23420;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"bs->unit-map","bs->unit-map",827144882,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Extract map fk->value for a single field."], null)),cljs.core.pr_str.call(null,error__20886__auto___23421)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema23409_23416,new cljs.core.Keyword(null,"value","value",305978217),args__20885__auto___23419,new cljs.core.Keyword(null,"error","error",-978969032),error__20886__auto___23421], null));
} else {
}
} else {
}

var o__20887__auto__ = (function (){var bs = G__23412;
var fk = G__23413;
while(true){
var m = fk.call(null,bs);
return new cljs.core.PersistentArrayMap.fromArray([fk,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(m)], true, false);
break;
}
})();
if(cljs.core.truth_(validate__20884__auto__)){
var temp__4425__auto___23422 = output_checker23411_23418.call(null,o__20887__auto__);
if(cljs.core.truth_(temp__4425__auto___23422)){
var error__20886__auto___23423 = temp__4425__auto___23422;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"bs->unit-map","bs->unit-map",827144882,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Extract map fk->value for a single field."], null)),cljs.core.pr_str.call(null,error__20886__auto___23423)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema23408_23415,new cljs.core.Keyword(null,"value","value",305978217),o__20887__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20886__auto___23423], null));
} else {
}
} else {
}

return o__20887__auto__;
});})(ufv___23414,output_schema23408_23415,input_schema23409_23416,input_checker23410_23417,output_checker23411_23418))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_inputs.validation.bs__GT_unit_map),schema.core.make_fn_schema.call(null,output_schema23408_23415,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema23409_23416], null)));
var ufv___23445 = schema.utils.use_fn_validation;
var output_schema23424_23446 = new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Any], true, false);
var input_schema23425_23447 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"bs","bs",-906042210,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)))], null);
var input_checker23426_23448 = schema.core.checker.call(null,input_schema23425_23447);
var output_checker23427_23449 = schema.core.checker.call(null,output_schema23424_23446);
/**
 * Inputs: [bs :- sch-business-state]
 * Returns: {s/Keyword s/Any}
 * 
 * Transform the business local state into final map
 */
om_inputs.validation.business_state__GT_map = ((function (ufv___23445,output_schema23424_23446,input_schema23425_23447,input_checker23426_23448,output_checker23427_23449){
return (function om_inputs$validation$business_state__GT_map(G__23428){
var validate__20884__auto__ = ufv___23445.get_cell();
if(cljs.core.truth_(validate__20884__auto__)){
var args__20885__auto___23450 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__23428], null);
var temp__4425__auto___23451 = input_checker23426_23448.call(null,args__20885__auto___23450);
if(cljs.core.truth_(temp__4425__auto___23451)){
var error__20886__auto___23452 = temp__4425__auto___23451;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"business-state->map","business-state->map",1652123635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transform the business local state into final map"], null)),cljs.core.pr_str.call(null,error__20886__auto___23452)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema23425_23447,new cljs.core.Keyword(null,"value","value",305978217),args__20885__auto___23450,new cljs.core.Keyword(null,"error","error",-978969032),error__20886__auto___23452], null));
} else {
}
} else {
}

var o__20887__auto__ = (function (){var bs = G__23428;
while(true){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19242__auto__ = ((function (validate__20884__auto__,ufv___23445,output_schema23424_23446,input_schema23425_23447,input_checker23426_23448,output_checker23427_23449){
return (function om_inputs$validation$business_state__GT_map_$_iter__23437(s__23438){
return (new cljs.core.LazySeq(null,((function (validate__20884__auto__,ufv___23445,output_schema23424_23446,input_schema23425_23447,input_checker23426_23448,output_checker23427_23449){
return (function (){
var s__23438__$1 = s__23438;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__23438__$1);
if(temp__4425__auto__){
var s__23438__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23438__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__23438__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__23440 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__23439 = (0);
while(true){
if((i__23439 < size__19241__auto__)){
var vec__23443 = cljs.core._nth.call(null,c__19240__auto__,i__23439);
var k = cljs.core.nth.call(null,vec__23443,(0),null);
var _ = cljs.core.nth.call(null,vec__23443,(1),null);
cljs.core.chunk_append.call(null,b__23440,om_inputs.validation.bs__GT_unit_map.call(null,bs,k));

var G__23453 = (i__23439 + (1));
i__23439 = G__23453;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23440),om_inputs$validation$business_state__GT_map_$_iter__23437.call(null,cljs.core.chunk_rest.call(null,s__23438__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23440),null);
}
} else {
var vec__23444 = cljs.core.first.call(null,s__23438__$2);
var k = cljs.core.nth.call(null,vec__23444,(0),null);
var _ = cljs.core.nth.call(null,vec__23444,(1),null);
return cljs.core.cons.call(null,om_inputs.validation.bs__GT_unit_map.call(null,bs,k),om_inputs$validation$business_state__GT_map_$_iter__23437.call(null,cljs.core.rest.call(null,s__23438__$2)));
}
} else {
return null;
}
break;
}
});})(validate__20884__auto__,ufv___23445,output_schema23424_23446,input_schema23425_23447,input_checker23426_23448,output_checker23427_23449))
,null,null));
});})(validate__20884__auto__,ufv___23445,output_schema23424_23446,input_schema23425_23447,input_checker23426_23448,output_checker23427_23449))
;
return iter__19242__auto__.call(null,bs);
})());
break;
}
})();
if(cljs.core.truth_(validate__20884__auto__)){
var temp__4425__auto___23454 = output_checker23427_23449.call(null,o__20887__auto__);
if(cljs.core.truth_(temp__4425__auto___23454)){
var error__20886__auto___23455 = temp__4425__auto___23454;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"business-state->map","business-state->map",1652123635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transform the business local state into final map"], null)),cljs.core.pr_str.call(null,error__20886__auto___23455)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema23424_23446,new cljs.core.Keyword(null,"value","value",305978217),o__20887__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20886__auto___23455], null));
} else {
}
} else {
}

return o__20887__auto__;
});})(ufv___23445,output_schema23424_23446,input_schema23425_23447,input_checker23426_23448,output_checker23427_23449))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_inputs.validation.business_state__GT_map),schema.core.make_fn_schema.call(null,output_schema23424_23446,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema23425_23447], null)));
var ufv___23461 = schema.utils.use_fn_validation;
var output_schema23456_23462 = new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Any], true, false);
var input_schema23457_23463 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"bs","bs",-906042210,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)))], null);
var input_checker23458_23464 = schema.core.checker.call(null,input_schema23457_23463);
var output_checker23459_23465 = schema.core.checker.call(null,output_schema23456_23462);
/**
 * Inputs: [bs :- sch-business-state]
 * Returns: {s/Keyword s/Any}
 * 
 * Create the map that will be validated by the Schema :
 * Only keeps :
 * - required keys
 * - optional keys with non blank values
 */
om_inputs.validation.pre_validation = ((function (ufv___23461,output_schema23456_23462,input_schema23457_23463,input_checker23458_23464,output_checker23459_23465){
return (function om_inputs$validation$pre_validation(G__23460){
var validate__20884__auto__ = ufv___23461.get_cell();
if(cljs.core.truth_(validate__20884__auto__)){
var args__20885__auto___23466 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__23460], null);
var temp__4425__auto___23467 = input_checker23458_23464.call(null,args__20885__auto___23466);
if(cljs.core.truth_(temp__4425__auto___23467)){
var error__20886__auto___23468 = temp__4425__auto___23467;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"pre-validation","pre-validation",731230710,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Create the map that will be validated by the Schema :\n  Only keeps :\n  - required keys\n  - optional keys with non blank values"], null)),cljs.core.pr_str.call(null,error__20886__auto___23468)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema23457_23463,new cljs.core.Keyword(null,"value","value",305978217),args__20885__auto___23466,new cljs.core.Keyword(null,"error","error",-978969032),error__20886__auto___23468], null));
} else {
}
} else {
}

var o__20887__auto__ = (function (){var bs = G__23460;
while(true){
return om_inputs.validation.business_state__GT_map.call(null,om_inputs.validation.keep_fields_to_validate.call(null,bs));
break;
}
})();
if(cljs.core.truth_(validate__20884__auto__)){
var temp__4425__auto___23469 = output_checker23459_23465.call(null,o__20887__auto__);
if(cljs.core.truth_(temp__4425__auto___23469)){
var error__20886__auto___23470 = temp__4425__auto___23469;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"pre-validation","pre-validation",731230710,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Create the map that will be validated by the Schema :\n  Only keeps :\n  - required keys\n  - optional keys with non blank values"], null)),cljs.core.pr_str.call(null,error__20886__auto___23470)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema23456_23462,new cljs.core.Keyword(null,"value","value",305978217),o__20887__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20886__auto___23470], null));
} else {
}
} else {
}

return o__20887__auto__;
});})(ufv___23461,output_schema23456_23462,input_schema23457_23463,input_checker23458_23464,output_checker23459_23465))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_inputs.validation.pre_validation),schema.core.make_fn_schema.call(null,output_schema23456_23462,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema23457_23463], null)));
var ufv___23492 = schema.utils.use_fn_validation;
var output_schema23471_23493 = new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Any], true, false);
var input_schema23472_23494 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"sch","sch",763282093,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker23473_23495 = schema.core.checker.call(null,input_schema23472_23494);
var output_checker23474_23496 = schema.core.checker.call(null,output_schema23471_23493);
/**
 * Inputs: [sch]
 * Returns: {s/Keyword s/Any}
 * 
 * Transform a Schema into a map of key -> individual Schema
 */
om_inputs.validation.sch_glo__GT_unit = ((function (ufv___23492,output_schema23471_23493,input_schema23472_23494,input_checker23473_23495,output_checker23474_23496){
return (function om_inputs$validation$sch_glo__GT_unit(G__23475){
var validate__20884__auto__ = ufv___23492.get_cell();
if(cljs.core.truth_(validate__20884__auto__)){
var args__20885__auto___23497 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__23475], null);
var temp__4425__auto___23498 = input_checker23473_23495.call(null,args__20885__auto___23497);
if(cljs.core.truth_(temp__4425__auto___23498)){
var error__20886__auto___23499 = temp__4425__auto___23498;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"sch-glo->unit","sch-glo->unit",1717844533,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transform a Schema into a map of key -> individual Schema"], null)),cljs.core.pr_str.call(null,error__20886__auto___23499)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema23472_23494,new cljs.core.Keyword(null,"value","value",305978217),args__20885__auto___23497,new cljs.core.Keyword(null,"error","error",-978969032),error__20886__auto___23499], null));
} else {
}
} else {
}

var o__20887__auto__ = (function (){var sch = G__23475;
while(true){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19242__auto__ = ((function (validate__20884__auto__,ufv___23492,output_schema23471_23493,input_schema23472_23494,input_checker23473_23495,output_checker23474_23496){
return (function om_inputs$validation$sch_glo__GT_unit_$_iter__23484(s__23485){
return (new cljs.core.LazySeq(null,((function (validate__20884__auto__,ufv___23492,output_schema23471_23493,input_schema23472_23494,input_checker23473_23495,output_checker23474_23496){
return (function (){
var s__23485__$1 = s__23485;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__23485__$1);
if(temp__4425__auto__){
var s__23485__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23485__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__23485__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__23487 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__23486 = (0);
while(true){
if((i__23486 < size__19241__auto__)){
var vec__23490 = cljs.core._nth.call(null,c__19240__auto__,i__23486);
var k = cljs.core.nth.call(null,vec__23490,(0),null);
var t = cljs.core.nth.call(null,vec__23490,(1),null);
cljs.core.chunk_append.call(null,b__23487,new cljs.core.PersistentArrayMap.fromArray([cljs.core.get.call(null,k,new cljs.core.Keyword(null,"k","k",-2146297393),k),new cljs.core.PersistentArrayMap.fromArray([k,t], true, false)], true, false));

var G__23500 = (i__23486 + (1));
i__23486 = G__23500;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23487),om_inputs$validation$sch_glo__GT_unit_$_iter__23484.call(null,cljs.core.chunk_rest.call(null,s__23485__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23487),null);
}
} else {
var vec__23491 = cljs.core.first.call(null,s__23485__$2);
var k = cljs.core.nth.call(null,vec__23491,(0),null);
var t = cljs.core.nth.call(null,vec__23491,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([cljs.core.get.call(null,k,new cljs.core.Keyword(null,"k","k",-2146297393),k),new cljs.core.PersistentArrayMap.fromArray([k,t], true, false)], true, false),om_inputs$validation$sch_glo__GT_unit_$_iter__23484.call(null,cljs.core.rest.call(null,s__23485__$2)));
}
} else {
return null;
}
break;
}
});})(validate__20884__auto__,ufv___23492,output_schema23471_23493,input_schema23472_23494,input_checker23473_23495,output_checker23474_23496))
,null,null));
});})(validate__20884__auto__,ufv___23492,output_schema23471_23493,input_schema23472_23494,input_checker23473_23495,output_checker23474_23496))
;
return iter__19242__auto__.call(null,sch);
})());
break;
}
})();
if(cljs.core.truth_(validate__20884__auto__)){
var temp__4425__auto___23501 = output_checker23474_23496.call(null,o__20887__auto__);
if(cljs.core.truth_(temp__4425__auto___23501)){
var error__20886__auto___23502 = temp__4425__auto___23501;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"sch-glo->unit","sch-glo->unit",1717844533,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transform a Schema into a map of key -> individual Schema"], null)),cljs.core.pr_str.call(null,error__20886__auto___23502)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema23471_23493,new cljs.core.Keyword(null,"value","value",305978217),o__20887__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20886__auto___23502], null));
} else {
}
} else {
}

return o__20887__auto__;
});})(ufv___23492,output_schema23471_23493,input_schema23472_23494,input_checker23473_23495,output_checker23474_23496))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_inputs.validation.sch_glo__GT_unit),schema.core.make_fn_schema.call(null,output_schema23471_23493,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema23472_23494], null)));
/**
 * Build the map of field -> coercer
 */
om_inputs.validation.build_unit_coercers = (function om_inputs$validation$build_unit_coercers(sch){
return cljs.core.apply.call(null,cljs.core.merge,(function (){var iter__19242__auto__ = (function om_inputs$validation$build_unit_coercers_$_iter__23511(s__23512){
return (new cljs.core.LazySeq(null,(function (){
var s__23512__$1 = s__23512;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__23512__$1);
if(temp__4425__auto__){
var s__23512__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23512__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__23512__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__23514 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__23513 = (0);
while(true){
if((i__23513 < size__19241__auto__)){
var vec__23517 = cljs.core._nth.call(null,c__19240__auto__,i__23513);
var k = cljs.core.nth.call(null,vec__23517,(0),null);
var s = cljs.core.nth.call(null,vec__23517,(1),null);
cljs.core.chunk_append.call(null,b__23514,new cljs.core.PersistentArrayMap.fromArray([k,schema.coerce.coercer.call(null,s,om_inputs.validation.validation_coercer)], true, false));

var G__23519 = (i__23513 + (1));
i__23513 = G__23519;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23514),om_inputs$validation$build_unit_coercers_$_iter__23511.call(null,cljs.core.chunk_rest.call(null,s__23512__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23514),null);
}
} else {
var vec__23518 = cljs.core.first.call(null,s__23512__$2);
var k = cljs.core.nth.call(null,vec__23518,(0),null);
var s = cljs.core.nth.call(null,vec__23518,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([k,schema.coerce.coercer.call(null,s,om_inputs.validation.validation_coercer)], true, false),om_inputs$validation$build_unit_coercers_$_iter__23511.call(null,cljs.core.rest.call(null,s__23512__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__19242__auto__.call(null,om_inputs.validation.sch_glo__GT_unit.call(null,sch));
})());
});
var ufv___23541 = schema.utils.use_fn_validation;
var output_schema23520_23542 = new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Any], true, false);
var input_schema23521_23543 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Any], true, false),cljs.core.with_meta(new cljs.core.Symbol(null,"unit-coercers","unit-coercers",-228543947,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null)))], null);
var input_checker23522_23544 = schema.core.checker.call(null,input_schema23521_23543);
var output_checker23523_23545 = schema.core.checker.call(null,output_schema23520_23542);
/**
 * Inputs: [unit-coercers :- {s/Keyword s/Any}]
 * Returns: {s/Keyword s/Any}
 */
om_inputs.validation.unit_schema_validators = ((function (ufv___23541,output_schema23520_23542,input_schema23521_23543,input_checker23522_23544,output_checker23523_23545){
return (function om_inputs$validation$unit_schema_validators(G__23524){
var validate__20884__auto__ = true;
if(validate__20884__auto__){
var args__20885__auto___23546 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__23524], null);
var temp__4425__auto___23547 = input_checker23522_23544.call(null,args__20885__auto___23546);
if(cljs.core.truth_(temp__4425__auto___23547)){
var error__20886__auto___23548 = temp__4425__auto___23547;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"unit-schema-validators","unit-schema-validators",-690979832,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"always-validate","always-validate",1031872127),true,new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null)),cljs.core.pr_str.call(null,error__20886__auto___23548)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema23521_23543,new cljs.core.Keyword(null,"value","value",305978217),args__20885__auto___23546,new cljs.core.Keyword(null,"error","error",-978969032),error__20886__auto___23548], null));
} else {
}
} else {
}

var o__20887__auto__ = (function (){var unit_coercers = G__23524;
while(true){
return cljs.core.apply.call(null,cljs.core.merge,(function (){var iter__19242__auto__ = ((function (validate__20884__auto__,ufv___23541,output_schema23520_23542,input_schema23521_23543,input_checker23522_23544,output_checker23523_23545){
return (function om_inputs$validation$unit_schema_validators_$_iter__23533(s__23534){
return (new cljs.core.LazySeq(null,((function (validate__20884__auto__,ufv___23541,output_schema23520_23542,input_schema23521_23543,input_checker23522_23544,output_checker23523_23545){
return (function (){
var s__23534__$1 = s__23534;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__23534__$1);
if(temp__4425__auto__){
var s__23534__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23534__$2)){
var c__19240__auto__ = cljs.core.chunk_first.call(null,s__23534__$2);
var size__19241__auto__ = cljs.core.count.call(null,c__19240__auto__);
var b__23536 = cljs.core.chunk_buffer.call(null,size__19241__auto__);
if((function (){var i__23535 = (0);
while(true){
if((i__23535 < size__19241__auto__)){
var vec__23539 = cljs.core._nth.call(null,c__19240__auto__,i__23535);
var k = cljs.core.nth.call(null,vec__23539,(0),null);
var c = cljs.core.nth.call(null,vec__23539,(1),null);
cljs.core.chunk_append.call(null,b__23536,new cljs.core.PersistentArrayMap.fromArray([k,cljs.core.partial.call(null,om_inputs.validation.validate,c,om_inputs.validation.transform_schema_errors)], true, false));

var G__23549 = (i__23535 + (1));
i__23535 = G__23549;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23536),om_inputs$validation$unit_schema_validators_$_iter__23533.call(null,cljs.core.chunk_rest.call(null,s__23534__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23536),null);
}
} else {
var vec__23540 = cljs.core.first.call(null,s__23534__$2);
var k = cljs.core.nth.call(null,vec__23540,(0),null);
var c = cljs.core.nth.call(null,vec__23540,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([k,cljs.core.partial.call(null,om_inputs.validation.validate,c,om_inputs.validation.transform_schema_errors)], true, false),om_inputs$validation$unit_schema_validators_$_iter__23533.call(null,cljs.core.rest.call(null,s__23534__$2)));
}
} else {
return null;
}
break;
}
});})(validate__20884__auto__,ufv___23541,output_schema23520_23542,input_schema23521_23543,input_checker23522_23544,output_checker23523_23545))
,null,null));
});})(validate__20884__auto__,ufv___23541,output_schema23520_23542,input_schema23521_23543,input_checker23522_23544,output_checker23523_23545))
;
return iter__19242__auto__.call(null,unit_coercers);
})());
break;
}
})();
if(validate__20884__auto__){
var temp__4425__auto___23550 = output_checker23523_23545.call(null,o__20887__auto__);
if(cljs.core.truth_(temp__4425__auto___23550)){
var error__20886__auto___23551 = temp__4425__auto___23550;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"unit-schema-validators","unit-schema-validators",-690979832,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"always-validate","always-validate",1031872127),true,new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null)),cljs.core.pr_str.call(null,error__20886__auto___23551)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema23520_23542,new cljs.core.Keyword(null,"value","value",305978217),o__20887__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20886__auto___23551], null));
} else {
}
} else {
}

return o__20887__auto__;
});})(ufv___23541,output_schema23520_23542,input_schema23521_23543,input_checker23522_23544,output_checker23523_23545))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_inputs.validation.unit_schema_validators),schema.core.make_fn_schema.call(null,output_schema23520_23542,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema23521_23543], null)));
var ufv___23561 = schema.utils.use_fn_validation;
var output_schema23552_23562 = schema.core.Bool;
var input_schema23553_23563 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_inputs.schemas.sch_field_state,cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-field-state","sch-field-state",-361453047,null)], null)))], null);
var input_checker23554_23564 = schema.core.checker.call(null,input_schema23553_23563);
var output_checker23555_23565 = schema.core.checker.call(null,output_schema23552_23562);
/**
 * Inputs: [s :- sch-field-state]
 * Returns: s/Bool
 * 
 * Indicates if a field must be validated :
 * - required field
 * - optional field with non blank values
 */
om_inputs.validation.validate_QMARK_ = ((function (ufv___23561,output_schema23552_23562,input_schema23553_23563,input_checker23554_23564,output_checker23555_23565){
return (function om_inputs$validation$validate_QMARK_(G__23556){
var validate__20884__auto__ = ufv___23561.get_cell();
if(cljs.core.truth_(validate__20884__auto__)){
var args__20885__auto___23566 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__23556], null);
var temp__4425__auto___23567 = input_checker23554_23564.call(null,args__20885__auto___23566);
if(cljs.core.truth_(temp__4425__auto___23567)){
var error__20886__auto___23568 = temp__4425__auto___23567;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"validate?","validate?",1996759489,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Indicates if a field must be validated :\n  - required field\n  - optional field with non blank values"], null)),cljs.core.pr_str.call(null,error__20886__auto___23568)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema23553_23563,new cljs.core.Keyword(null,"value","value",305978217),args__20885__auto___23566,new cljs.core.Keyword(null,"error","error",-978969032),error__20886__auto___23568], null));
} else {
}
} else {
}

var o__20887__auto__ = (function (){var s = G__23556;
while(true){
var map__23559 = s;
var map__23559__$1 = ((((!((map__23559 == null)))?((((map__23559.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23559.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23559):map__23559);
var required = cljs.core.get.call(null,map__23559__$1,new cljs.core.Keyword(null,"required","required",1807647006));
var value = cljs.core.get.call(null,map__23559__$1,new cljs.core.Keyword(null,"value","value",305978217));
var or__18489__auto__ = required;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,value));
}
break;
}
})();
if(cljs.core.truth_(validate__20884__auto__)){
var temp__4425__auto___23569 = output_checker23555_23565.call(null,o__20887__auto__);
if(cljs.core.truth_(temp__4425__auto___23569)){
var error__20886__auto___23570 = temp__4425__auto___23569;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"validate?","validate?",1996759489,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Indicates if a field must be validated :\n  - required field\n  - optional field with non blank values"], null)),cljs.core.pr_str.call(null,error__20886__auto___23570)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema23552_23562,new cljs.core.Keyword(null,"value","value",305978217),o__20887__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20886__auto___23570], null));
} else {
}
} else {
}

return o__20887__auto__;
});})(ufv___23561,output_schema23552_23562,input_schema23553_23563,input_checker23554_23564,output_checker23555_23565))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_inputs.validation.validate_QMARK_),schema.core.make_fn_schema.call(null,output_schema23552_23562,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema23553_23563], null)));
var ufv___23577 = schema.utils.use_fn_validation;
var output_schema23571_23578 = om_inputs.schemas.sch_business_state;
var input_schema23572_23579 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null))),schema.core.one.call(null,om_inputs.validation.sch_errors,cljs.core.with_meta(new cljs.core.Symbol(null,"errs","errs",122908184,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-errors","sch-errors",1963156247,null)], null)))], null);
var input_checker23573_23580 = schema.core.checker.call(null,input_schema23572_23579);
var output_checker23574_23581 = schema.core.checker.call(null,output_schema23571_23578);
/**
 * Inputs: [state :- sch-business-state errs :- sch-errors]
 * Returns: sch-business-state
 * 
 * Handle errors for a single field
 */
om_inputs.validation.add_field_error = ((function (ufv___23577,output_schema23571_23578,input_schema23572_23579,input_checker23573_23580,output_checker23574_23581){
return (function om_inputs$validation$add_field_error(G__23575,G__23576){
var validate__20884__auto__ = ufv___23577.get_cell();
if(cljs.core.truth_(validate__20884__auto__)){
var args__20885__auto___23582 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__23575,G__23576], null);
var temp__4425__auto___23583 = input_checker23573_23580.call(null,args__20885__auto___23582);
if(cljs.core.truth_(temp__4425__auto___23583)){
var error__20886__auto___23584 = temp__4425__auto___23583;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"add-field-error","add-field-error",-1753092209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Handle errors for a single field"], null)),cljs.core.pr_str.call(null,error__20886__auto___23584)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema23572_23579,new cljs.core.Keyword(null,"value","value",305978217),args__20885__auto___23582,new cljs.core.Keyword(null,"error","error",-978969032),error__20886__auto___23584], null));
} else {
}
} else {
}

var o__20887__auto__ = (function (){var state = G__23575;
var errs = G__23576;
while(true){
return cljs.core.reduce.call(null,((function (validate__20884__auto__,ufv___23577,output_schema23571_23578,input_schema23572_23579,input_checker23573_23580,output_checker23574_23581){
return (function (s,e){
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,s,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,new cljs.core.Keyword(null,"valid","valid",155614240)], null),false),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,new cljs.core.Keyword(null,"error","error",-978969032)], null),e.call(null,errs));
});})(validate__20884__auto__,ufv___23577,output_schema23571_23578,input_schema23572_23579,input_checker23573_23580,output_checker23574_23581))
,state,cljs.core.keys.call(null,errs));
break;
}
})();
if(cljs.core.truth_(validate__20884__auto__)){
var temp__4425__auto___23585 = output_checker23574_23581.call(null,o__20887__auto__);
if(cljs.core.truth_(temp__4425__auto___23585)){
var error__20886__auto___23586 = temp__4425__auto___23585;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"add-field-error","add-field-error",-1753092209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Handle errors for a single field"], null)),cljs.core.pr_str.call(null,error__20886__auto___23586)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema23571_23578,new cljs.core.Keyword(null,"value","value",305978217),o__20887__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20886__auto___23586], null));
} else {
}
} else {
}

return o__20887__auto__;
});})(ufv___23577,output_schema23571_23578,input_schema23572_23579,input_checker23573_23580,output_checker23574_23581))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_inputs.validation.add_field_error),schema.core.make_fn_schema.call(null,output_schema23571_23578,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema23572_23579], null)));
var ufv___23593 = schema.utils.use_fn_validation;
var output_schema23587_23594 = om_inputs.schemas.sch_business_state;
var input_schema23588_23595 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null))),schema.core.one.call(null,schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)))], null);
var input_checker23589_23596 = schema.core.checker.call(null,input_schema23588_23595);
var output_checker23590_23597 = schema.core.checker.call(null,output_schema23587_23594);
/**
 * Inputs: [state :- sch-business-state k :- s/Keyword]
 * Returns: sch-business-state
 */
om_inputs.validation.remove_field_error = ((function (ufv___23593,output_schema23587_23594,input_schema23588_23595,input_checker23589_23596,output_checker23590_23597){
return (function om_inputs$validation$remove_field_error(G__23591,G__23592){
var validate__20884__auto__ = ufv___23593.get_cell();
if(cljs.core.truth_(validate__20884__auto__)){
var args__20885__auto___23598 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__23591,G__23592], null);
var temp__4425__auto___23599 = input_checker23589_23596.call(null,args__20885__auto___23598);
if(cljs.core.truth_(temp__4425__auto___23599)){
var error__20886__auto___23600 = temp__4425__auto___23599;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"remove-field-error","remove-field-error",-837789813,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)),cljs.core.pr_str.call(null,error__20886__auto___23600)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema23588_23595,new cljs.core.Keyword(null,"value","value",305978217),args__20885__auto___23598,new cljs.core.Keyword(null,"error","error",-978969032),error__20886__auto___23600], null));
} else {
}
} else {
}

var o__20887__auto__ = (function (){var state = G__23591;
var k = G__23592;
while(true){
return cljs.core.update_in.call(null,cljs.core.assoc_in.call(null,state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,new cljs.core.Keyword(null,"valid","valid",155614240)], null),true),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.dissoc,new cljs.core.Keyword(null,"error","error",-978969032));
break;
}
})();
if(cljs.core.truth_(validate__20884__auto__)){
var temp__4425__auto___23601 = output_checker23590_23597.call(null,o__20887__auto__);
if(cljs.core.truth_(temp__4425__auto___23601)){
var error__20886__auto___23602 = temp__4425__auto___23601;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"remove-field-error","remove-field-error",-837789813,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)),cljs.core.pr_str.call(null,error__20886__auto___23602)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema23587_23594,new cljs.core.Keyword(null,"value","value",305978217),o__20887__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20886__auto___23602], null));
} else {
}
} else {
}

return o__20887__auto__;
});})(ufv___23593,output_schema23587_23594,input_schema23588_23595,input_checker23589_23596,output_checker23590_23597))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_inputs.validation.remove_field_error),schema.core.make_fn_schema.call(null,output_schema23587_23594,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema23588_23595], null)));
var ufv___23610 = schema.utils.use_fn_validation;
var output_schema23603_23611 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null);
var input_schema23604_23612 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,cljs.core.PersistentHashSet.fromArray([schema.core.Keyword], true),cljs.core.with_meta(new cljs.core.Symbol(null,"cross-errs","cross-errs",-563013712,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),null], null), null)], null))),schema.core.one.call(null,new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Keyword], true, false),cljs.core.with_meta(new cljs.core.Symbol(null,"error-rule","error-rule",327326958,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null))),schema.core.one.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"errs","errs",122908184,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_checker23605_23613 = schema.core.checker.call(null,input_schema23604_23612);
var output_checker23606_23614 = schema.core.checker.call(null,output_schema23603_23611);
/**
 * Inputs: [cross-errs :- #{s/Keyword} error-rule :- {s/Keyword s/Keyword} errs :- [s/Keyword]]
 * Returns: [s/Keyword]
 * 
 * Remove the cross field errors keys from the validation errors.
 * This prevent errors from showing when inline validation occurs.
 */
om_inputs.validation.remove_dependant_errors = ((function (ufv___23610,output_schema23603_23611,input_schema23604_23612,input_checker23605_23613,output_checker23606_23614){
return (function om_inputs$validation$remove_dependant_errors(G__23607,G__23608,G__23609){
var validate__20884__auto__ = ufv___23610.get_cell();
if(cljs.core.truth_(validate__20884__auto__)){
var args__20885__auto___23615 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__23607,G__23608,G__23609], null);
var temp__4425__auto___23616 = input_checker23605_23613.call(null,args__20885__auto___23615);
if(cljs.core.truth_(temp__4425__auto___23616)){
var error__20886__auto___23617 = temp__4425__auto___23616;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"remove-dependant-errors","remove-dependant-errors",-830444485,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Remove the cross field errors keys from the validation errors.\n  This prevent errors from showing when inline validation occurs."], null)),cljs.core.pr_str.call(null,error__20886__auto___23617)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema23604_23612,new cljs.core.Keyword(null,"value","value",305978217),args__20885__auto___23615,new cljs.core.Keyword(null,"error","error",-978969032),error__20886__auto___23617], null));
} else {
}
} else {
}

var o__20887__auto__ = (function (){var cross_errs = G__23607;
var error_rule = G__23608;
var errs = G__23609;
while(true){
return cljs.core.seq.call(null,cljs.core.remove.call(null,((function (validate__20884__auto__,ufv___23610,output_schema23603_23611,input_schema23604_23612,input_checker23605_23613,output_checker23606_23614){
return (function (err){
return cross_errs.call(null,cljs.core.get.call(null,error_rule,err));
});})(validate__20884__auto__,ufv___23610,output_schema23603_23611,input_schema23604_23612,input_checker23605_23613,output_checker23606_23614))
,errs));
break;
}
})();
if(cljs.core.truth_(validate__20884__auto__)){
var temp__4425__auto___23618 = output_checker23606_23614.call(null,o__20887__auto__);
if(cljs.core.truth_(temp__4425__auto___23618)){
var error__20886__auto___23619 = temp__4425__auto___23618;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"remove-dependant-errors","remove-dependant-errors",-830444485,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Remove the cross field errors keys from the validation errors.\n  This prevent errors from showing when inline validation occurs."], null)),cljs.core.pr_str.call(null,error__20886__auto___23619)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema23603_23611,new cljs.core.Keyword(null,"value","value",305978217),o__20887__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20886__auto___23619], null));
} else {
}
} else {
}

return o__20887__auto__;
});})(ufv___23610,output_schema23603_23611,input_schema23604_23612,input_checker23605_23613,output_checker23606_23614))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_inputs.validation.remove_dependant_errors),schema.core.make_fn_schema.call(null,output_schema23603_23611,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema23604_23612], null)));
om_inputs.validation.build_error_remover = (function om_inputs$validation$build_error_remover(rules,cross_fields_rules){
return cljs.core.partial.call(null,om_inputs.validation.remove_dependant_errors,cross_fields_rules,om_inputs.validation.error__GT_rule.call(null,rules));
});
/**
 * validate a single field against verily rules.
 * If an other field depends on this one, then the errors linked to this validation won't show up.
 */
om_inputs.validation.unit_verily_validation = (function om_inputs$validation$unit_verily_validation(fk,unit,p__23620){
var map__23623 = p__23620;
var map__23623__$1 = ((((!((map__23623 == null)))?((((map__23623.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23623.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23623):map__23623);
var state = map__23623__$1;
var unit_coercers = cljs.core.get.call(null,map__23623__$1,new cljs.core.Keyword(null,"unit-coercers","unit-coercers",-1869075474));
var remove_errs_fn = cljs.core.get.call(null,map__23623__$1,new cljs.core.Keyword(null,"remove-errs-fn","remove-errs-fn",-1642608850));
var verily_validator = cljs.core.get.call(null,map__23623__$1,new cljs.core.Keyword(null,"verily-validator","verily-validator",-283552403));
var coerced = fk.call(null,unit_coercers).call(null,unit);
var errs = verily_validator.call(null,coerced);
if(cljs.core.contains_QMARK_.call(null,errs,fk)){
var errs_unit = cljs.core.update_in.call(null,errs,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fk], null),remove_errs_fn);
var res = cljs.core.select_keys.call(null,errs_unit,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fk], null));
if(cljs.core.truth_(fk.call(null,res))){
return res;
} else {
return null;
}
} else {
return null;
}
});
/**
 * Verily validation of a field that depend on other.
 * The confirm password is a typical example.
 */
om_inputs.validation.unit_dependant_verily_validation = (function om_inputs$validation$unit_dependant_verily_validation(fk,inputs,state){
var map__23627 = state;
var map__23627__$1 = ((((!((map__23627 == null)))?((((map__23627.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23627.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23627):map__23627);
var validation_deps = cljs.core.get.call(null,map__23627__$1,new cljs.core.Keyword(null,"validation-deps","validation-deps",1496827716));
var verily_validator = cljs.core.get.call(null,map__23627__$1,new cljs.core.Keyword(null,"verily-validator","verily-validator",-283552403));
var deps = fk.call(null,validation_deps);
var coerced = om_inputs.validation.business_state__GT_map.call(null,inputs);
var errs = verily_validator.call(null,coerced);
if(cljs.core.contains_QMARK_.call(null,errs,fk)){
return cljs.core.select_keys.call(null,errs,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fk], null));
} else {
return null;
}
});
/**
 * Verily validation of a single field
 */
om_inputs.validation.verily_validation = (function om_inputs$validation$verily_validation(fk,unit,bs,state){
var map__23631 = state;
var map__23631__$1 = ((((!((map__23631 == null)))?((((map__23631.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23631.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23631):map__23631);
var validation_deps = cljs.core.get.call(null,map__23631__$1,new cljs.core.Keyword(null,"validation-deps","validation-deps",1496827716));
if(cljs.core.truth_(fk.call(null,validation_deps))){
return om_inputs.validation.unit_dependant_verily_validation.call(null,fk,bs,state);
} else {
return om_inputs.validation.unit_verily_validation.call(null,fk,unit,state);
}
});
/**
 * Validation of a single field
 * TODO Refactoring
 */
om_inputs.validation.field_validation = (function om_inputs$validation$field_validation(fk,inputs,state){
var map__23635 = state;
var map__23635__$1 = ((((!((map__23635 == null)))?((((map__23635.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23635.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23635):map__23635);
var unit_validators = cljs.core.get.call(null,map__23635__$1,new cljs.core.Keyword(null,"unit-validators","unit-validators",-1302618433));
var unit = om_inputs.validation.bs__GT_unit_map.call(null,inputs,fk);
if(cljs.core.truth_(om_inputs.validation.validate_QMARK_.call(null,fk.call(null,inputs)))){
var temp__4423__auto__ = (function (){var or__18489__auto__ = fk.call(null,unit_validators).call(null,unit);
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return om_inputs.validation.verily_validation.call(null,fk,unit,inputs,state);
}
})();
if(cljs.core.truth_(temp__4423__auto__)){
var errs = temp__4423__auto__;
return om_inputs.validation.add_field_error.call(null,inputs,errs);
} else {
return om_inputs.validation.remove_field_error.call(null,inputs,fk);
}
} else {
return om_inputs.validation.remove_field_error.call(null,inputs,fk);
}
});
/**
 * Validate a single field of the local business state and update the local state.
 */
om_inputs.validation.field_validation_BANG_ = (function om_inputs$validation$field_validation_BANG_(owner,f){
var map__23639 = om_inputs.extern.get_state.call(null,owner);
var map__23639__$1 = ((((!((map__23639 == null)))?((((map__23639.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23639.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23639):map__23639);
var state = map__23639__$1;
var inputs = cljs.core.get.call(null,map__23639__$1,new cljs.core.Keyword(null,"inputs","inputs",865803858));
var new_business_state = om_inputs.validation.field_validation.call(null,f,inputs,state);
if(cljs.core.not_EQ_.call(null,inputs,new_business_state)){
return om_inputs.extern.set_state_BANG_.call(null,owner,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"inputs","inputs",865803858)], null),new_business_state);
} else {
return null;
}
});
om_inputs.validation.full_validation = (function om_inputs$validation$full_validation(inputs,state){
return cljs.core.reduce.call(null,(function (bs,f){
return om_inputs.validation.field_validation.call(null,f,bs,state);
}),inputs,cljs.core.keys.call(null,inputs));
});
var ufv___23650 = schema.utils.use_fn_validation;
var output_schema23641_23651 = schema.core.Bool;
var input_schema23642_23652 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"bs","bs",-906042210,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)))], null);
var input_checker23643_23653 = schema.core.checker.call(null,input_schema23642_23652);
var output_checker23644_23654 = schema.core.checker.call(null,output_schema23641_23651);
/**
 * Inputs: [bs :- sch-business-state]
 * Returns: s/Bool
 * 
 * Tells if there is at least one field in error.
 */
om_inputs.validation.no_error_QMARK_ = ((function (ufv___23650,output_schema23641_23651,input_schema23642_23652,input_checker23643_23653,output_checker23644_23654){
return (function om_inputs$validation$no_error_QMARK_(G__23645){
var validate__20884__auto__ = ufv___23650.get_cell();
if(cljs.core.truth_(validate__20884__auto__)){
var args__20885__auto___23655 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__23645], null);
var temp__4425__auto___23656 = input_checker23643_23653.call(null,args__20885__auto___23655);
if(cljs.core.truth_(temp__4425__auto___23656)){
var error__20886__auto___23657 = temp__4425__auto___23656;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"no-error?","no-error?",323642458,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tells if there is at least one field in error."], null)),cljs.core.pr_str.call(null,error__20886__auto___23657)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema23642_23652,new cljs.core.Keyword(null,"value","value",305978217),args__20885__auto___23655,new cljs.core.Keyword(null,"error","error",-978969032),error__20886__auto___23657], null));
} else {
}
} else {
}

var o__20887__auto__ = (function (){var bs = G__23645;
while(true){
return cljs.core.not_any_QMARK_.call(null,((function (validate__20884__auto__,ufv___23650,output_schema23641_23651,input_schema23642_23652,input_checker23643_23653,output_checker23644_23654){
return (function (p__23648){
var vec__23649 = p__23648;
var k = cljs.core.nth.call(null,vec__23649,(0),null);
var v = cljs.core.nth.call(null,vec__23649,(1),null);
return new cljs.core.Keyword(null,"valid","valid",155614240).cljs$core$IFn$_invoke$arity$1(v) === false;
});})(validate__20884__auto__,ufv___23650,output_schema23641_23651,input_schema23642_23652,input_checker23643_23653,output_checker23644_23654))
,bs);
break;
}
})();
if(cljs.core.truth_(validate__20884__auto__)){
var temp__4425__auto___23658 = output_checker23644_23654.call(null,o__20887__auto__);
if(cljs.core.truth_(temp__4425__auto___23658)){
var error__20886__auto___23659 = temp__4425__auto___23658;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"no-error?","no-error?",323642458,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tells if there is at least one field in error."], null)),cljs.core.pr_str.call(null,error__20886__auto___23659)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema23641_23651,new cljs.core.Keyword(null,"value","value",305978217),o__20887__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20886__auto___23659], null));
} else {
}
} else {
}

return o__20887__auto__;
});})(ufv___23650,output_schema23641_23651,input_schema23642_23652,input_checker23643_23653,output_checker23644_23654))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_inputs.validation.no_error_QMARK_),schema.core.make_fn_schema.call(null,output_schema23641_23651,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema23642_23652], null)));

//# sourceMappingURL=validation.js.map