// Compiled by ClojureScript 1.7.48 {}
goog.provide('om_inputs.typing_controls');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('schema.core');
goog.require('om_inputs.schema_utils');
goog.require('goog.string');
/**
 * Only authorize integer or empty string.
 * n is the new value
 * o is the old value
 * When the new value is valid returns it, else returns the previous one.
 */
om_inputs.typing_controls.only_integer = (function om_inputs$typing_controls$only_integer(n,o){
if(cljs.core.truth_(clojure.string.blank_QMARK_.call(null,n))){
return "";
} else {
var r = parseInt(n);
if(cljs.core.truth_(isNaN(r))){
return o;
} else {
return r;
}
}
});
/**
 * Validate a that an input of type s/Num contains a value that can be converted in a numeric.
 * If not the previous value is used.
 * An empty string is left as is.
 * n is the new value
 * o is the old value
 */
om_inputs.typing_controls.only_number = (function om_inputs$typing_controls$only_number(n,o){
if(cljs.core.truth_(clojure.string.blank_QMARK_.call(null,n))){
return "";
} else {
if(cljs.core.truth_(isNaN(n))){
return o;
} else {
return n;
}
}
});
om_inputs.typing_controls.typing_control_fns = new cljs.core.PersistentArrayMap.fromArray([cljs.core.integer_QMARK_,cljs.core.fnil.call(null,om_inputs.typing_controls.only_integer,"",""),Number,cljs.core.fnil.call(null,om_inputs.typing_controls.only_number,"","")], true, false);

om_inputs.typing_controls.ControlTyping = {};

om_inputs.typing_controls.control = (function om_inputs$typing_controls$control(r,n,o){
if((!((r == null))) && (!((r.om_inputs$typing_controls$ControlTyping$control$arity$3 == null)))){
return r.om_inputs$typing_controls$ControlTyping$control$arity$3(r,n,o);
} else {
var x__19125__auto__ = (((r == null))?null:r);
var m__19126__auto__ = (om_inputs.typing_controls.control[goog.typeOf(x__19125__auto__)]);
if(!((m__19126__auto__ == null))){
return m__19126__auto__.call(null,r,n,o);
} else {
var m__19126__auto____$1 = (om_inputs.typing_controls.control["_"]);
if(!((m__19126__auto____$1 == null))){
return m__19126__auto____$1.call(null,r,n,o);
} else {
throw cljs.core.missing_protocol.call(null,"ControlTyping.control",r);
}
}
}
});

RegExp.prototype.om_inputs$typing_controls$ControlTyping$ = true;

RegExp.prototype.om_inputs$typing_controls$ControlTyping$control$arity$3 = (function (f,n,o){
var f__$1 = this;
if(cljs.core.truth_(clojure.string.blank_QMARK_.call(null,n))){
return "";
} else {
if(cljs.core.truth_(cljs.core.re_matches.call(null,f__$1,n))){
return n;
} else {
return o;
}
}
});
om_inputs.typing_controls.get_typing_ctrl_fn = (function om_inputs$typing_controls$get_typing_ctrl_fn(s){
var temp__4423__auto__ = cljs.core.get.call(null,om_inputs.typing_controls.typing_control_fns,om_inputs.schema_utils.sch_type.call(null,s));
if(cljs.core.truth_(temp__4423__auto__)){
var cfn = temp__4423__auto__;
return cfn;
} else {
if(cljs.core._EQ_.call(null,cljs.core.type.call(null,s),RegExp)){
return cljs.core.fnil.call(null,cljs.core.partial.call(null,om_inputs.typing_controls.control,s),"","");
} else {
return null;
}
}
});
/**
 * Build the coercion map field->coercion-fn from all entries of the Schema
 */
om_inputs.typing_controls.build_typing_control = (function om_inputs$typing_controls$build_typing_control(sch){
return cljs.core.reduce.call(null,(function (acc,p__24409){
var vec__24410 = p__24409;
var k = cljs.core.nth.call(null,vec__24410,(0),null);
var s = cljs.core.nth.call(null,vec__24410,(1),null);
var temp__4423__auto__ = om_inputs.typing_controls.get_typing_ctrl_fn.call(null,s);
if(cljs.core.truth_(temp__4423__auto__)){
var cfn = temp__4423__auto__;
return cljs.core.assoc.call(null,acc,cljs.core.get.call(null,k,new cljs.core.Keyword(null,"k","k",-2146297393),k),cfn);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,sch);
});

//# sourceMappingURL=typing_controls.js.map