// Compiled by ClojureScript 1.7.48 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');

figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.all_QMARK_ = (function figwheel$client$file_reloading$all_QMARK_(pred,coll){
return cljs.core.reduce.call(null,(function (p1__27726_SHARP_,p2__27727_SHARP_){
var and__18477__auto__ = p1__27726_SHARP_;
if(cljs.core.truth_(and__18477__auto__)){
return p2__27727_SHARP_;
} else {
return and__18477__auto__;
}
}),true,cljs.core.map.call(null,pred,coll));
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__18489__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__18489__auto__){
return or__18489__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.ns_to_js_file = (function figwheel$client$file_reloading$ns_to_js_file(ns){

return [cljs.core.str(clojure.string.replace.call(null,ns,".","/")),cljs.core.str(".js")].join('');
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){

return [cljs.core.str(figwheel.client.utils.base_url_path.call(null)),cljs.core.str(figwheel.client.file_reloading.ns_to_js_file.call(null,ns))].join('');
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
goog.isProvided = (function (x){
return false;
});

if(((cljs.core._STAR_loaded_libs_STAR_ == null)) || (cljs.core.empty_QMARK_.call(null,cljs.core._STAR_loaded_libs_STAR_))){
cljs.core._STAR_loaded_libs_STAR_ = (function (){var gntp = goog.dependencies_.nameToPath;
return cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.filter.call(null,((function (gntp){
return (function (name){
return (goog.dependencies_.visited[(gntp[name])]);
});})(gntp))
,cljs.core.js_keys.call(null,gntp)));
})();
} else {
}

goog.require = (function (name,reload){
if(cljs.core.truth_((function (){var or__18489__auto__ = !(cljs.core.contains_QMARK_.call(null,cljs.core._STAR_loaded_libs_STAR_,name));
if(or__18489__auto__){
return or__18489__auto__;
} else {
return reload;
}
})())){
cljs.core._STAR_loaded_libs_STAR_ = cljs.core.conj.call(null,(function (){var or__18489__auto__ = cljs.core._STAR_loaded_libs_STAR_;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})(),name);

return figwheel.client.file_reloading.reload_file_STAR_.call(null,figwheel.client.file_reloading.resolve_ns.call(null,name));
} else {
return null;
}
});

goog.provide = goog.exportPath_;

return goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.reload_file_STAR_;
});
if(typeof figwheel.client.file_reloading.resolve_url !== 'undefined'){
} else {
figwheel.client.file_reloading.resolve_url = (function (){var method_table__19383__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__19384__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__19385__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__19386__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__19387__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"figwheel.client.file-reloading","resolve-url"),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__19387__auto__,method_table__19383__auto__,prefer_table__19384__auto__,method_cache__19385__auto__,cached_hierarchy__19386__auto__));
})();
}
cljs.core._add_method.call(null,figwheel.client.file_reloading.resolve_url,new cljs.core.Keyword(null,"default","default",-1987822328),(function (p__27728){
var map__27729 = p__27728;
var map__27729__$1 = ((((!((map__27729 == null)))?((((map__27729.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27729.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27729):map__27729);
var file = cljs.core.get.call(null,map__27729__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
return file;
}));
cljs.core._add_method.call(null,figwheel.client.file_reloading.resolve_url,new cljs.core.Keyword(null,"namespace","namespace",-377510372),(function (p__27731){
var map__27732 = p__27731;
var map__27732__$1 = ((((!((map__27732 == null)))?((((map__27732.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27732.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27732):map__27732);
var namespace = cljs.core.get.call(null,map__27732__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

return figwheel.client.file_reloading.resolve_ns.call(null,namespace);
}));
if(typeof figwheel.client.file_reloading.reload_base !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_base = (function (){var method_table__19383__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__19384__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__19385__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__19386__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__19387__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"figwheel.client.file-reloading","reload-base"),figwheel.client.utils.host_env_QMARK_,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__19387__auto__,method_table__19383__auto__,prefer_table__19384__auto__,method_cache__19385__auto__,cached_hierarchy__19386__auto__));
})();
}
cljs.core._add_method.call(null,figwheel.client.file_reloading.reload_base,new cljs.core.Keyword(null,"node","node",581201198),(function (request_url,callback){

var root = clojure.string.join.call(null,"/",cljs.core.reverse.call(null,cljs.core.drop.call(null,(2),cljs.core.reverse.call(null,clojure.string.split.call(null,__dirname,"/")))));
var path = [cljs.core.str(root),cljs.core.str("/"),cljs.core.str(request_url)].join('');
(require.cache[path] = null);

return callback.call(null,(function (){try{return require(path);
}catch (e27734){if((e27734 instanceof Error)){
var e = e27734;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e27734;

}
}})());
}));
cljs.core._add_method.call(null,figwheel.client.file_reloading.reload_base,new cljs.core.Keyword(null,"html","html",-998796897),(function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),{"cleanupWhenDone": true});
deferred.addCallback(((function (deferred){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred))
);

return deferred.addErrback(((function (deferred){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred))
);
}));
figwheel.client.file_reloading.reload_file_STAR_ = (function figwheel$client$file_reloading$reload_file_STAR_(){
var args27735 = [];
var len__19528__auto___27738 = arguments.length;
var i__19529__auto___27739 = (0);
while(true){
if((i__19529__auto___27739 < len__19528__auto___27738)){
args27735.push((arguments[i__19529__auto___27739]));

var G__27740 = (i__19529__auto___27739 + (1));
i__19529__auto___27739 = G__27740;
continue;
} else {
}
break;
}

var G__27737 = args27735.length;
switch (G__27737) {
case 2:
return figwheel.client.file_reloading.reload_file_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.file_reloading.reload_file_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27735.length)].join('')));

}
});

figwheel.client.file_reloading.reload_file_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (request_url,callback){
return figwheel.client.file_reloading.reload_base.call(null,request_url,callback);
});

figwheel.client.file_reloading.reload_file_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (request_url){
return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,cljs.core.identity);
});

figwheel.client.file_reloading.reload_file_STAR_.cljs$lang$maxFixedArity = 2;
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__27742,callback){
var map__27745 = p__27742;
var map__27745__$1 = ((((!((map__27745 == null)))?((((map__27745.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27745.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27745):map__27745);
var file_msg = map__27745__$1;
var request_url = cljs.core.get.call(null,map__27745__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__27745,map__27745__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfullly loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__27745,map__27745__$1,file_msg,request_url))
);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__27747){
var map__27750 = p__27747;
var map__27750__$1 = ((((!((map__27750 == null)))?((((map__27750.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27750.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27750):map__27750);
var file_msg = map__27750__$1;
var namespace = cljs.core.get.call(null,map__27750__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,map__27750__$1,new cljs.core.Keyword(null,"meta-data","meta-data",-1613399157));

var meta_data__$1 = (function (){var or__18489__auto__ = meta_data;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
var and__18477__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_data__$1));
if(and__18477__auto__){
var or__18489__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_data__$1);
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
var or__18489__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_data__$1);
if(cljs.core.truth_(or__18489__auto____$1)){
return or__18489__auto____$1;
} else {
var and__18477__auto____$1 = cljs.core.contains_QMARK_.call(null,cljs.core._STAR_loaded_libs_STAR_,namespace);
if(and__18477__auto____$1){
var or__18489__auto____$2 = !(cljs.core.contains_QMARK_.call(null,meta_data__$1,new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932)));
if(or__18489__auto____$2){
return or__18489__auto____$2;
} else {
return new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932).cljs$core$IFn$_invoke$arity$1(meta_data__$1);
}
} else {
return and__18477__auto____$1;
}
}
}
} else {
return and__18477__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__27752,callback){
var map__27755 = p__27752;
var map__27755__$1 = ((((!((map__27755 == null)))?((((map__27755.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27755.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27755):map__27755);
var file_msg = map__27755__$1;
var request_url = cljs.core.get.call(null,map__27755__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__27755__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.reload_file.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
setTimeout(((function (out){
return (function (){
return figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
figwheel.client.file_reloading.patch_goog_base.call(null);

cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);
});})(out))
,(0));

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__23428__auto___27843 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23428__auto___27843,out){
return (function (){
var f__23429__auto__ = (function (){var switch__23407__auto__ = ((function (c__23428__auto___27843,out){
return (function (state_27825){
var state_val_27826 = (state_27825[(1)]);
if((state_val_27826 === (1))){
var inst_27803 = cljs.core.nth.call(null,files,(0),null);
var inst_27804 = cljs.core.nthnext.call(null,files,(1));
var inst_27805 = files;
var state_27825__$1 = (function (){var statearr_27827 = state_27825;
(statearr_27827[(7)] = inst_27804);

(statearr_27827[(8)] = inst_27805);

(statearr_27827[(9)] = inst_27803);

return statearr_27827;
})();
var statearr_27828_27844 = state_27825__$1;
(statearr_27828_27844[(2)] = null);

(statearr_27828_27844[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27826 === (2))){
var inst_27805 = (state_27825[(8)]);
var inst_27808 = (state_27825[(10)]);
var inst_27808__$1 = cljs.core.nth.call(null,inst_27805,(0),null);
var inst_27809 = cljs.core.nthnext.call(null,inst_27805,(1));
var inst_27810 = (inst_27808__$1 == null);
var inst_27811 = cljs.core.not.call(null,inst_27810);
var state_27825__$1 = (function (){var statearr_27829 = state_27825;
(statearr_27829[(11)] = inst_27809);

(statearr_27829[(10)] = inst_27808__$1);

return statearr_27829;
})();
if(inst_27811){
var statearr_27830_27845 = state_27825__$1;
(statearr_27830_27845[(1)] = (4));

} else {
var statearr_27831_27846 = state_27825__$1;
(statearr_27831_27846[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27826 === (3))){
var inst_27823 = (state_27825[(2)]);
var state_27825__$1 = state_27825;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27825__$1,inst_27823);
} else {
if((state_val_27826 === (4))){
var inst_27808 = (state_27825[(10)]);
var inst_27813 = figwheel.client.file_reloading.reload_js_file.call(null,inst_27808);
var state_27825__$1 = state_27825;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27825__$1,(7),inst_27813);
} else {
if((state_val_27826 === (5))){
var inst_27819 = cljs.core.async.close_BANG_.call(null,out);
var state_27825__$1 = state_27825;
var statearr_27832_27847 = state_27825__$1;
(statearr_27832_27847[(2)] = inst_27819);

(statearr_27832_27847[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27826 === (6))){
var inst_27821 = (state_27825[(2)]);
var state_27825__$1 = state_27825;
var statearr_27833_27848 = state_27825__$1;
(statearr_27833_27848[(2)] = inst_27821);

(statearr_27833_27848[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27826 === (7))){
var inst_27809 = (state_27825[(11)]);
var inst_27815 = (state_27825[(2)]);
var inst_27816 = cljs.core.async.put_BANG_.call(null,out,inst_27815);
var inst_27805 = inst_27809;
var state_27825__$1 = (function (){var statearr_27834 = state_27825;
(statearr_27834[(8)] = inst_27805);

(statearr_27834[(12)] = inst_27816);

return statearr_27834;
})();
var statearr_27835_27849 = state_27825__$1;
(statearr_27835_27849[(2)] = null);

(statearr_27835_27849[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__23428__auto___27843,out))
;
return ((function (switch__23407__auto__,c__23428__auto___27843,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__23408__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__23408__auto____0 = (function (){
var statearr_27839 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27839[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__23408__auto__);

(statearr_27839[(1)] = (1));

return statearr_27839;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__23408__auto____1 = (function (state_27825){
while(true){
var ret_value__23409__auto__ = (function (){try{while(true){
var result__23410__auto__ = switch__23407__auto__.call(null,state_27825);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23410__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23410__auto__;
}
break;
}
}catch (e27840){if((e27840 instanceof Object)){
var ex__23411__auto__ = e27840;
var statearr_27841_27850 = state_27825;
(statearr_27841_27850[(5)] = ex__23411__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27825);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27840;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23409__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27851 = state_27825;
state_27825 = G__27851;
continue;
} else {
return ret_value__23409__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__23408__auto__ = function(state_27825){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__23408__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__23408__auto____1.call(this,state_27825);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__23408__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__23408__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__23408__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__23408__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__23408__auto__;
})()
;})(switch__23407__auto__,c__23428__auto___27843,out))
})();
var state__23430__auto__ = (function (){var statearr_27842 = f__23429__auto__.call(null);
(statearr_27842[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23428__auto___27843);

return statearr_27842;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23430__auto__);
});})(c__23428__auto___27843,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.add_request_url = (function figwheel$client$file_reloading$add_request_url(p__27852,p__27853){
var map__27858 = p__27852;
var map__27858__$1 = ((((!((map__27858 == null)))?((((map__27858.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27858.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27858):map__27858);
var opts = map__27858__$1;
var url_rewriter = cljs.core.get.call(null,map__27858__$1,new cljs.core.Keyword(null,"url-rewriter","url-rewriter",200543838));
var map__27859 = p__27853;
var map__27859__$1 = ((((!((map__27859 == null)))?((((map__27859.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27859.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27859):map__27859);
var file_msg = map__27859__$1;
var file = cljs.core.get.call(null,map__27859__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var resolved_path = figwheel.client.file_reloading.resolve_url.call(null,file_msg);
return cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"request-url","request-url",2100346596),(cljs.core.truth_(url_rewriter)?url_rewriter.call(null,resolved_path):resolved_path));
});
figwheel.client.file_reloading.add_request_urls = (function figwheel$client$file_reloading$add_request_urls(opts,files){
return cljs.core.map.call(null,cljs.core.partial.call(null,figwheel.client.file_reloading.add_request_url,opts),files);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__27862){
var map__27866 = p__27862;
var map__27866__$1 = ((((!((map__27866 == null)))?((((map__27866.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27866.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27866):map__27866);
var eval_body__$1 = cljs.core.get.call(null,map__27866__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__27866__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__18477__auto__ = eval_body__$1;
if(cljs.core.truth_(and__18477__auto__)){
return typeof eval_body__$1 === 'string';
} else {
return and__18477__auto__;
}
})())){
var code = eval_body__$1;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return eval(code);
}catch (e27868){var e = e27868;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__27873,p__27874){
var map__28102 = p__27873;
var map__28102__$1 = ((((!((map__28102 == null)))?((((map__28102.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28102.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28102):map__28102);
var opts = map__28102__$1;
var before_jsload = cljs.core.get.call(null,map__28102__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__28102__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var load_unchanged_files = cljs.core.get.call(null,map__28102__$1,new cljs.core.Keyword(null,"load-unchanged-files","load-unchanged-files",-1561468704));
var map__28103 = p__27874;
var map__28103__$1 = ((((!((map__28103 == null)))?((((map__28103.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28103.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28103):map__28103);
var msg = map__28103__$1;
var files = cljs.core.get.call(null,map__28103__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var c__23428__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23428__auto__,map__28102,map__28102__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__28103,map__28103__$1,msg,files){
return (function (){
var f__23429__auto__ = (function (){var switch__23407__auto__ = ((function (c__23428__auto__,map__28102,map__28102__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__28103,map__28103__$1,msg,files){
return (function (state_28244){
var state_val_28245 = (state_28244[(1)]);
if((state_val_28245 === (7))){
var inst_28120 = (state_28244[(7)]);
var inst_28118 = (state_28244[(8)]);
var inst_28119 = (state_28244[(9)]);
var inst_28117 = (state_28244[(10)]);
var inst_28125 = cljs.core._nth.call(null,inst_28118,inst_28120);
var inst_28126 = figwheel.client.file_reloading.eval_body.call(null,inst_28125);
var inst_28127 = (inst_28120 + (1));
var tmp28246 = inst_28118;
var tmp28247 = inst_28119;
var tmp28248 = inst_28117;
var inst_28117__$1 = tmp28248;
var inst_28118__$1 = tmp28246;
var inst_28119__$1 = tmp28247;
var inst_28120__$1 = inst_28127;
var state_28244__$1 = (function (){var statearr_28249 = state_28244;
(statearr_28249[(7)] = inst_28120__$1);

(statearr_28249[(8)] = inst_28118__$1);

(statearr_28249[(11)] = inst_28126);

(statearr_28249[(9)] = inst_28119__$1);

(statearr_28249[(10)] = inst_28117__$1);

return statearr_28249;
})();
var statearr_28250_28329 = state_28244__$1;
(statearr_28250_28329[(2)] = null);

(statearr_28250_28329[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (20))){
var inst_28166 = (state_28244[(12)]);
var inst_28163 = (state_28244[(13)]);
var inst_28167 = (state_28244[(14)]);
var inst_28169 = (state_28244[(15)]);
var inst_28162 = (state_28244[(16)]);
var inst_28172 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_28174 = (function (){var all_files = inst_28162;
var files_SINGLEQUOTE_ = inst_28163;
var res_SINGLEQUOTE_ = inst_28166;
var res = inst_28167;
var files_not_loaded = inst_28169;
return ((function (all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,files_not_loaded,inst_28166,inst_28163,inst_28167,inst_28169,inst_28162,inst_28172,state_val_28245,c__23428__auto__,map__28102,map__28102__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__28103,map__28103__$1,msg,files){
return (function (p__28173){
var map__28251 = p__28173;
var map__28251__$1 = ((((!((map__28251 == null)))?((((map__28251.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28251.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28251):map__28251);
var namespace = cljs.core.get.call(null,map__28251__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__28251__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.ns_to_js_file.call(null,namespace);
} else {
return file;
}
});
;})(all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,files_not_loaded,inst_28166,inst_28163,inst_28167,inst_28169,inst_28162,inst_28172,state_val_28245,c__23428__auto__,map__28102,map__28102__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__28103,map__28103__$1,msg,files))
})();
var inst_28175 = cljs.core.map.call(null,inst_28174,inst_28167);
var inst_28176 = cljs.core.pr_str.call(null,inst_28175);
var inst_28177 = figwheel.client.utils.log.call(null,inst_28176);
var inst_28178 = (function (){var all_files = inst_28162;
var files_SINGLEQUOTE_ = inst_28163;
var res_SINGLEQUOTE_ = inst_28166;
var res = inst_28167;
var files_not_loaded = inst_28169;
return ((function (all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,files_not_loaded,inst_28166,inst_28163,inst_28167,inst_28169,inst_28162,inst_28172,inst_28174,inst_28175,inst_28176,inst_28177,state_val_28245,c__23428__auto__,map__28102,map__28102__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__28103,map__28103__$1,msg,files){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,files_not_loaded,inst_28166,inst_28163,inst_28167,inst_28169,inst_28162,inst_28172,inst_28174,inst_28175,inst_28176,inst_28177,state_val_28245,c__23428__auto__,map__28102,map__28102__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__28103,map__28103__$1,msg,files))
})();
var inst_28179 = setTimeout(inst_28178,(10));
var state_28244__$1 = (function (){var statearr_28253 = state_28244;
(statearr_28253[(17)] = inst_28172);

(statearr_28253[(18)] = inst_28177);

return statearr_28253;
})();
var statearr_28254_28330 = state_28244__$1;
(statearr_28254_28330[(2)] = inst_28179);

(statearr_28254_28330[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (27))){
var state_28244__$1 = state_28244;
var statearr_28255_28331 = state_28244__$1;
(statearr_28255_28331[(2)] = false);

(statearr_28255_28331[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (1))){
var inst_28109 = (state_28244[(19)]);
var inst_28106 = before_jsload.call(null,files);
var inst_28107 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_28108 = (function (){return ((function (inst_28109,inst_28106,inst_28107,state_val_28245,c__23428__auto__,map__28102,map__28102__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__28103,map__28103__$1,msg,files){
return (function (p1__27869_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__27869_SHARP_);
});
;})(inst_28109,inst_28106,inst_28107,state_val_28245,c__23428__auto__,map__28102,map__28102__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__28103,map__28103__$1,msg,files))
})();
var inst_28109__$1 = cljs.core.filter.call(null,inst_28108,files);
var inst_28110 = cljs.core.not_empty.call(null,inst_28109__$1);
var state_28244__$1 = (function (){var statearr_28256 = state_28244;
(statearr_28256[(20)] = inst_28106);

(statearr_28256[(21)] = inst_28107);

(statearr_28256[(19)] = inst_28109__$1);

return statearr_28256;
})();
if(cljs.core.truth_(inst_28110)){
var statearr_28257_28332 = state_28244__$1;
(statearr_28257_28332[(1)] = (2));

} else {
var statearr_28258_28333 = state_28244__$1;
(statearr_28258_28333[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (24))){
var state_28244__$1 = state_28244;
var statearr_28259_28334 = state_28244__$1;
(statearr_28259_28334[(2)] = null);

(statearr_28259_28334[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (39))){
var state_28244__$1 = state_28244;
var statearr_28260_28335 = state_28244__$1;
(statearr_28260_28335[(2)] = null);

(statearr_28260_28335[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (4))){
var inst_28154 = (state_28244[(2)]);
var inst_28155 = (function (){return ((function (inst_28154,state_val_28245,c__23428__auto__,map__28102,map__28102__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__28103,map__28103__$1,msg,files){
return (function (p1__27870_SHARP_){
var and__18477__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__27870_SHARP_);
if(cljs.core.truth_(and__18477__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__27870_SHARP_));
} else {
return and__18477__auto__;
}
});
;})(inst_28154,state_val_28245,c__23428__auto__,map__28102,map__28102__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__28103,map__28103__$1,msg,files))
})();
var inst_28156 = cljs.core.filter.call(null,inst_28155,files);
var state_28244__$1 = (function (){var statearr_28261 = state_28244;
(statearr_28261[(22)] = inst_28154);

(statearr_28261[(23)] = inst_28156);

return statearr_28261;
})();
if(cljs.core.truth_(load_unchanged_files)){
var statearr_28262_28336 = state_28244__$1;
(statearr_28262_28336[(1)] = (16));

} else {
var statearr_28263_28337 = state_28244__$1;
(statearr_28263_28337[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (15))){
var inst_28144 = (state_28244[(2)]);
var state_28244__$1 = state_28244;
var statearr_28264_28338 = state_28244__$1;
(statearr_28264_28338[(2)] = inst_28144);

(statearr_28264_28338[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (21))){
var state_28244__$1 = state_28244;
var statearr_28265_28339 = state_28244__$1;
(statearr_28265_28339[(2)] = null);

(statearr_28265_28339[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (31))){
var inst_28201 = (state_28244[(2)]);
var state_28244__$1 = state_28244;
var statearr_28266_28340 = state_28244__$1;
(statearr_28266_28340[(2)] = inst_28201);

(statearr_28266_28340[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (32))){
var inst_28189 = (state_28244[(24)]);
var inst_28206 = cljs.core.apply.call(null,cljs.core.hash_map,inst_28189);
var state_28244__$1 = state_28244;
var statearr_28267_28341 = state_28244__$1;
(statearr_28267_28341[(2)] = inst_28206);

(statearr_28267_28341[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (40))){
var inst_28212 = (state_28244[(25)]);
var inst_28230 = (state_28244[(2)]);
var inst_28231 = cljs.core.not_empty.call(null,inst_28212);
var state_28244__$1 = (function (){var statearr_28268 = state_28244;
(statearr_28268[(26)] = inst_28230);

return statearr_28268;
})();
if(cljs.core.truth_(inst_28231)){
var statearr_28269_28342 = state_28244__$1;
(statearr_28269_28342[(1)] = (41));

} else {
var statearr_28270_28343 = state_28244__$1;
(statearr_28270_28343[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (33))){
var inst_28189 = (state_28244[(24)]);
var state_28244__$1 = state_28244;
var statearr_28271_28344 = state_28244__$1;
(statearr_28271_28344[(2)] = inst_28189);

(statearr_28271_28344[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (13))){
var inst_28130 = (state_28244[(27)]);
var inst_28134 = cljs.core.chunk_first.call(null,inst_28130);
var inst_28135 = cljs.core.chunk_rest.call(null,inst_28130);
var inst_28136 = cljs.core.count.call(null,inst_28134);
var inst_28117 = inst_28135;
var inst_28118 = inst_28134;
var inst_28119 = inst_28136;
var inst_28120 = (0);
var state_28244__$1 = (function (){var statearr_28272 = state_28244;
(statearr_28272[(7)] = inst_28120);

(statearr_28272[(8)] = inst_28118);

(statearr_28272[(9)] = inst_28119);

(statearr_28272[(10)] = inst_28117);

return statearr_28272;
})();
var statearr_28273_28345 = state_28244__$1;
(statearr_28273_28345[(2)] = null);

(statearr_28273_28345[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (22))){
var inst_28169 = (state_28244[(15)]);
var inst_28182 = (state_28244[(2)]);
var inst_28183 = cljs.core.not_empty.call(null,inst_28169);
var state_28244__$1 = (function (){var statearr_28274 = state_28244;
(statearr_28274[(28)] = inst_28182);

return statearr_28274;
})();
if(cljs.core.truth_(inst_28183)){
var statearr_28275_28346 = state_28244__$1;
(statearr_28275_28346[(1)] = (23));

} else {
var statearr_28276_28347 = state_28244__$1;
(statearr_28276_28347[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (36))){
var state_28244__$1 = state_28244;
var statearr_28277_28348 = state_28244__$1;
(statearr_28277_28348[(2)] = null);

(statearr_28277_28348[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (41))){
var inst_28212 = (state_28244[(25)]);
var inst_28233 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_28212);
var inst_28234 = cljs.core.pr_str.call(null,inst_28233);
var inst_28235 = [cljs.core.str("not required: "),cljs.core.str(inst_28234)].join('');
var inst_28236 = figwheel.client.utils.log.call(null,inst_28235);
var state_28244__$1 = state_28244;
var statearr_28278_28349 = state_28244__$1;
(statearr_28278_28349[(2)] = inst_28236);

(statearr_28278_28349[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (43))){
var inst_28239 = (state_28244[(2)]);
var state_28244__$1 = state_28244;
var statearr_28279_28350 = state_28244__$1;
(statearr_28279_28350[(2)] = inst_28239);

(statearr_28279_28350[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (29))){
var state_28244__$1 = state_28244;
var statearr_28280_28351 = state_28244__$1;
(statearr_28280_28351[(2)] = true);

(statearr_28280_28351[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (6))){
var inst_28151 = (state_28244[(2)]);
var state_28244__$1 = state_28244;
var statearr_28281_28352 = state_28244__$1;
(statearr_28281_28352[(2)] = inst_28151);

(statearr_28281_28352[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (28))){
var inst_28204 = (state_28244[(2)]);
var state_28244__$1 = state_28244;
if(cljs.core.truth_(inst_28204)){
var statearr_28282_28353 = state_28244__$1;
(statearr_28282_28353[(1)] = (32));

} else {
var statearr_28283_28354 = state_28244__$1;
(statearr_28283_28354[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (25))){
var inst_28242 = (state_28244[(2)]);
var state_28244__$1 = state_28244;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28244__$1,inst_28242);
} else {
if((state_val_28245 === (34))){
var inst_28210 = (state_28244[(29)]);
var inst_28209 = (state_28244[(2)]);
var inst_28210__$1 = cljs.core.get.call(null,inst_28209,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_28211 = cljs.core.get.call(null,inst_28209,new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932));
var inst_28212 = cljs.core.get.call(null,inst_28209,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_28213 = cljs.core.not_empty.call(null,inst_28210__$1);
var state_28244__$1 = (function (){var statearr_28284 = state_28244;
(statearr_28284[(25)] = inst_28212);

(statearr_28284[(30)] = inst_28211);

(statearr_28284[(29)] = inst_28210__$1);

return statearr_28284;
})();
if(cljs.core.truth_(inst_28213)){
var statearr_28285_28355 = state_28244__$1;
(statearr_28285_28355[(1)] = (35));

} else {
var statearr_28286_28356 = state_28244__$1;
(statearr_28286_28356[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (17))){
var inst_28156 = (state_28244[(23)]);
var state_28244__$1 = state_28244;
var statearr_28287_28357 = state_28244__$1;
(statearr_28287_28357[(2)] = inst_28156);

(statearr_28287_28357[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (3))){
var state_28244__$1 = state_28244;
var statearr_28288_28358 = state_28244__$1;
(statearr_28288_28358[(2)] = null);

(statearr_28288_28358[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (12))){
var inst_28147 = (state_28244[(2)]);
var state_28244__$1 = state_28244;
var statearr_28289_28359 = state_28244__$1;
(statearr_28289_28359[(2)] = inst_28147);

(statearr_28289_28359[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (2))){
var inst_28109 = (state_28244[(19)]);
var inst_28116 = cljs.core.seq.call(null,inst_28109);
var inst_28117 = inst_28116;
var inst_28118 = null;
var inst_28119 = (0);
var inst_28120 = (0);
var state_28244__$1 = (function (){var statearr_28290 = state_28244;
(statearr_28290[(7)] = inst_28120);

(statearr_28290[(8)] = inst_28118);

(statearr_28290[(9)] = inst_28119);

(statearr_28290[(10)] = inst_28117);

return statearr_28290;
})();
var statearr_28291_28360 = state_28244__$1;
(statearr_28291_28360[(2)] = null);

(statearr_28291_28360[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (23))){
var inst_28166 = (state_28244[(12)]);
var inst_28163 = (state_28244[(13)]);
var inst_28189 = (state_28244[(24)]);
var inst_28167 = (state_28244[(14)]);
var inst_28169 = (state_28244[(15)]);
var inst_28162 = (state_28244[(16)]);
var inst_28185 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_28188 = (function (){var all_files = inst_28162;
var files_SINGLEQUOTE_ = inst_28163;
var res_SINGLEQUOTE_ = inst_28166;
var res = inst_28167;
var files_not_loaded = inst_28169;
return ((function (all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,files_not_loaded,inst_28166,inst_28163,inst_28189,inst_28167,inst_28169,inst_28162,inst_28185,state_val_28245,c__23428__auto__,map__28102,map__28102__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__28103,map__28103__$1,msg,files){
return (function (p__28187){
var map__28292 = p__28187;
var map__28292__$1 = ((((!((map__28292 == null)))?((((map__28292.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28292.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28292):map__28292);
var meta_data = cljs.core.get.call(null,map__28292__$1,new cljs.core.Keyword(null,"meta-data","meta-data",-1613399157));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.contains_QMARK_.call(null,meta_data,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
if((cljs.core.contains_QMARK_.call(null,meta_data,new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932))) && (cljs.core.not.call(null,new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932).cljs$core$IFn$_invoke$arity$1(meta_data)))){
return new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
}
});
;})(all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,files_not_loaded,inst_28166,inst_28163,inst_28189,inst_28167,inst_28169,inst_28162,inst_28185,state_val_28245,c__23428__auto__,map__28102,map__28102__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__28103,map__28103__$1,msg,files))
})();
var inst_28189__$1 = cljs.core.group_by.call(null,inst_28188,inst_28169);
var inst_28191 = (inst_28189__$1 == null);
var inst_28192 = cljs.core.not.call(null,inst_28191);
var state_28244__$1 = (function (){var statearr_28294 = state_28244;
(statearr_28294[(31)] = inst_28185);

(statearr_28294[(24)] = inst_28189__$1);

return statearr_28294;
})();
if(inst_28192){
var statearr_28295_28361 = state_28244__$1;
(statearr_28295_28361[(1)] = (26));

} else {
var statearr_28296_28362 = state_28244__$1;
(statearr_28296_28362[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (35))){
var inst_28210 = (state_28244[(29)]);
var inst_28215 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_28210);
var inst_28216 = cljs.core.pr_str.call(null,inst_28215);
var inst_28217 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_28216)].join('');
var inst_28218 = figwheel.client.utils.log.call(null,inst_28217);
var state_28244__$1 = state_28244;
var statearr_28297_28363 = state_28244__$1;
(statearr_28297_28363[(2)] = inst_28218);

(statearr_28297_28363[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (19))){
var inst_28166 = (state_28244[(12)]);
var inst_28163 = (state_28244[(13)]);
var inst_28167 = (state_28244[(14)]);
var inst_28162 = (state_28244[(16)]);
var inst_28166__$1 = (state_28244[(2)]);
var inst_28167__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_28166__$1);
var inst_28168 = (function (){var all_files = inst_28162;
var files_SINGLEQUOTE_ = inst_28163;
var res_SINGLEQUOTE_ = inst_28166__$1;
var res = inst_28167__$1;
return ((function (all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,inst_28166,inst_28163,inst_28167,inst_28162,inst_28166__$1,inst_28167__$1,state_val_28245,c__23428__auto__,map__28102,map__28102__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__28103,map__28103__$1,msg,files){
return (function (p1__27872_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__27872_SHARP_));
});
;})(all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,inst_28166,inst_28163,inst_28167,inst_28162,inst_28166__$1,inst_28167__$1,state_val_28245,c__23428__auto__,map__28102,map__28102__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__28103,map__28103__$1,msg,files))
})();
var inst_28169 = cljs.core.filter.call(null,inst_28168,inst_28166__$1);
var inst_28170 = cljs.core.not_empty.call(null,inst_28167__$1);
var state_28244__$1 = (function (){var statearr_28298 = state_28244;
(statearr_28298[(12)] = inst_28166__$1);

(statearr_28298[(14)] = inst_28167__$1);

(statearr_28298[(15)] = inst_28169);

return statearr_28298;
})();
if(cljs.core.truth_(inst_28170)){
var statearr_28299_28364 = state_28244__$1;
(statearr_28299_28364[(1)] = (20));

} else {
var statearr_28300_28365 = state_28244__$1;
(statearr_28300_28365[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (11))){
var state_28244__$1 = state_28244;
var statearr_28301_28366 = state_28244__$1;
(statearr_28301_28366[(2)] = null);

(statearr_28301_28366[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (9))){
var inst_28149 = (state_28244[(2)]);
var state_28244__$1 = state_28244;
var statearr_28302_28367 = state_28244__$1;
(statearr_28302_28367[(2)] = inst_28149);

(statearr_28302_28367[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (5))){
var inst_28120 = (state_28244[(7)]);
var inst_28119 = (state_28244[(9)]);
var inst_28122 = (inst_28120 < inst_28119);
var inst_28123 = inst_28122;
var state_28244__$1 = state_28244;
if(cljs.core.truth_(inst_28123)){
var statearr_28303_28368 = state_28244__$1;
(statearr_28303_28368[(1)] = (7));

} else {
var statearr_28304_28369 = state_28244__$1;
(statearr_28304_28369[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (14))){
var inst_28130 = (state_28244[(27)]);
var inst_28139 = cljs.core.first.call(null,inst_28130);
var inst_28140 = figwheel.client.file_reloading.eval_body.call(null,inst_28139);
var inst_28141 = cljs.core.next.call(null,inst_28130);
var inst_28117 = inst_28141;
var inst_28118 = null;
var inst_28119 = (0);
var inst_28120 = (0);
var state_28244__$1 = (function (){var statearr_28305 = state_28244;
(statearr_28305[(7)] = inst_28120);

(statearr_28305[(8)] = inst_28118);

(statearr_28305[(9)] = inst_28119);

(statearr_28305[(32)] = inst_28140);

(statearr_28305[(10)] = inst_28117);

return statearr_28305;
})();
var statearr_28306_28370 = state_28244__$1;
(statearr_28306_28370[(2)] = null);

(statearr_28306_28370[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (26))){
var inst_28189 = (state_28244[(24)]);
var inst_28194 = inst_28189.cljs$lang$protocol_mask$partition0$;
var inst_28195 = (inst_28194 & (64));
var inst_28196 = inst_28189.cljs$core$ISeq$;
var inst_28197 = (inst_28195) || (inst_28196);
var state_28244__$1 = state_28244;
if(cljs.core.truth_(inst_28197)){
var statearr_28307_28371 = state_28244__$1;
(statearr_28307_28371[(1)] = (29));

} else {
var statearr_28308_28372 = state_28244__$1;
(statearr_28308_28372[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (16))){
var inst_28156 = (state_28244[(23)]);
var inst_28158 = (function (){var all_files = inst_28156;
return ((function (all_files,inst_28156,state_val_28245,c__23428__auto__,map__28102,map__28102__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__28103,map__28103__$1,msg,files){
return (function (p1__27871_SHARP_){
return cljs.core.update_in.call(null,p1__27871_SHARP_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"meta-data","meta-data",-1613399157)], null),cljs.core.dissoc,new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932));
});
;})(all_files,inst_28156,state_val_28245,c__23428__auto__,map__28102,map__28102__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__28103,map__28103__$1,msg,files))
})();
var inst_28159 = cljs.core.map.call(null,inst_28158,inst_28156);
var state_28244__$1 = state_28244;
var statearr_28309_28373 = state_28244__$1;
(statearr_28309_28373[(2)] = inst_28159);

(statearr_28309_28373[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (38))){
var inst_28211 = (state_28244[(30)]);
var inst_28224 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_28211);
var inst_28225 = cljs.core.pr_str.call(null,inst_28224);
var inst_28226 = [cljs.core.str("file didn't change: "),cljs.core.str(inst_28225)].join('');
var inst_28227 = figwheel.client.utils.log.call(null,inst_28226);
var state_28244__$1 = state_28244;
var statearr_28310_28374 = state_28244__$1;
(statearr_28310_28374[(2)] = inst_28227);

(statearr_28310_28374[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (30))){
var state_28244__$1 = state_28244;
var statearr_28311_28375 = state_28244__$1;
(statearr_28311_28375[(2)] = false);

(statearr_28311_28375[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (10))){
var inst_28130 = (state_28244[(27)]);
var inst_28132 = cljs.core.chunked_seq_QMARK_.call(null,inst_28130);
var state_28244__$1 = state_28244;
if(inst_28132){
var statearr_28312_28376 = state_28244__$1;
(statearr_28312_28376[(1)] = (13));

} else {
var statearr_28313_28377 = state_28244__$1;
(statearr_28313_28377[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (18))){
var inst_28163 = (state_28244[(13)]);
var inst_28162 = (state_28244[(16)]);
var inst_28162__$1 = (state_28244[(2)]);
var inst_28163__$1 = figwheel.client.file_reloading.add_request_urls.call(null,opts,inst_28162__$1);
var inst_28164 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_28163__$1);
var state_28244__$1 = (function (){var statearr_28314 = state_28244;
(statearr_28314[(13)] = inst_28163__$1);

(statearr_28314[(16)] = inst_28162__$1);

return statearr_28314;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28244__$1,(19),inst_28164);
} else {
if((state_val_28245 === (42))){
var state_28244__$1 = state_28244;
var statearr_28315_28378 = state_28244__$1;
(statearr_28315_28378[(2)] = null);

(statearr_28315_28378[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (37))){
var inst_28211 = (state_28244[(30)]);
var inst_28221 = (state_28244[(2)]);
var inst_28222 = cljs.core.not_empty.call(null,inst_28211);
var state_28244__$1 = (function (){var statearr_28316 = state_28244;
(statearr_28316[(33)] = inst_28221);

return statearr_28316;
})();
if(cljs.core.truth_(inst_28222)){
var statearr_28317_28379 = state_28244__$1;
(statearr_28317_28379[(1)] = (38));

} else {
var statearr_28318_28380 = state_28244__$1;
(statearr_28318_28380[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28245 === (8))){
var inst_28130 = (state_28244[(27)]);
var inst_28117 = (state_28244[(10)]);
var inst_28130__$1 = cljs.core.seq.call(null,inst_28117);
var state_28244__$1 = (function (){var statearr_28319 = state_28244;
(statearr_28319[(27)] = inst_28130__$1);

return statearr_28319;
})();
if(inst_28130__$1){
var statearr_28320_28381 = state_28244__$1;
(statearr_28320_28381[(1)] = (10));

} else {
var statearr_28321_28382 = state_28244__$1;
(statearr_28321_28382[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23428__auto__,map__28102,map__28102__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__28103,map__28103__$1,msg,files))
;
return ((function (switch__23407__auto__,c__23428__auto__,map__28102,map__28102__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__28103,map__28103__$1,msg,files){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__23408__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__23408__auto____0 = (function (){
var statearr_28325 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28325[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__23408__auto__);

(statearr_28325[(1)] = (1));

return statearr_28325;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__23408__auto____1 = (function (state_28244){
while(true){
var ret_value__23409__auto__ = (function (){try{while(true){
var result__23410__auto__ = switch__23407__auto__.call(null,state_28244);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23410__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23410__auto__;
}
break;
}
}catch (e28326){if((e28326 instanceof Object)){
var ex__23411__auto__ = e28326;
var statearr_28327_28383 = state_28244;
(statearr_28327_28383[(5)] = ex__23411__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28244);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28326;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23409__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28384 = state_28244;
state_28244 = G__28384;
continue;
} else {
return ret_value__23409__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__23408__auto__ = function(state_28244){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__23408__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__23408__auto____1.call(this,state_28244);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__23408__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__23408__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__23408__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__23408__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__23408__auto__;
})()
;})(switch__23407__auto__,c__23428__auto__,map__28102,map__28102__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__28103,map__28103__$1,msg,files))
})();
var state__23430__auto__ = (function (){var statearr_28328 = f__23429__auto__.call(null);
(statearr_28328[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23428__auto__);

return statearr_28328;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23430__auto__);
});})(c__23428__auto__,map__28102,map__28102__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__28103,map__28103__$1,msg,files))
);

return c__23428__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__28387,link){
var map__28390 = p__28387;
var map__28390__$1 = ((((!((map__28390 == null)))?((((map__28390.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28390.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28390):map__28390);
var file = cljs.core.get.call(null,map__28390__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4425__auto__ = link.href;
if(cljs.core.truth_(temp__4425__auto__)){
var link_href = temp__4425__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4425__auto__,map__28390,map__28390__$1,file){
return (function (p1__28385_SHARP_,p2__28386_SHARP_){
if(cljs.core._EQ_.call(null,p1__28385_SHARP_,p2__28386_SHARP_)){
return p1__28385_SHARP_;
} else {
return false;
}
});})(link_href,temp__4425__auto__,map__28390,map__28390__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4425__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__28396){
var map__28397 = p__28396;
var map__28397__$1 = ((((!((map__28397 == null)))?((((map__28397.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28397.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28397):map__28397);
var match_length = cljs.core.get.call(null,map__28397__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__28397__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__28392_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__28392_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4425__auto__)){
var res = temp__4425__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(){
var args28399 = [];
var len__19528__auto___28402 = arguments.length;
var i__19529__auto___28403 = (0);
while(true){
if((i__19529__auto___28403 < len__19528__auto___28402)){
args28399.push((arguments[i__19529__auto___28403]));

var G__28404 = (i__19529__auto___28403 + (1));
i__19529__auto___28403 = G__28404;
continue;
} else {
}
break;
}

var G__28401 = args28399.length;
switch (G__28401) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28399.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__28406){
var map__28409 = p__28406;
var map__28409__$1 = ((((!((map__28409 == null)))?((((map__28409.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28409.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28409):map__28409);
var f_data = map__28409__$1;
var file = cljs.core.get.call(null,map__28409__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var request_url = cljs.core.get.call(null,map__28409__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var temp__4423__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4423__auto__)){
var link = temp__4423__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return figwheel.client.file_reloading.add_link_to_doc.call(null,figwheel.client.file_reloading.create_link.call(null,(function (){var or__18489__auto__ = request_url;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
return file;
}
})()));
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__28411,files_msg){
var map__28434 = p__28411;
var map__28434__$1 = ((((!((map__28434 == null)))?((((map__28434.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28434.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28434):map__28434);
var opts = map__28434__$1;
var on_cssload = cljs.core.get.call(null,map__28434__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__28436_28456 = cljs.core.seq.call(null,figwheel.client.file_reloading.add_request_urls.call(null,opts,new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg)));
var chunk__28437_28457 = null;
var count__28438_28458 = (0);
var i__28439_28459 = (0);
while(true){
if((i__28439_28459 < count__28438_28458)){
var f_28460 = cljs.core._nth.call(null,chunk__28437_28457,i__28439_28459);
figwheel.client.file_reloading.reload_css_file.call(null,f_28460);

var G__28461 = seq__28436_28456;
var G__28462 = chunk__28437_28457;
var G__28463 = count__28438_28458;
var G__28464 = (i__28439_28459 + (1));
seq__28436_28456 = G__28461;
chunk__28437_28457 = G__28462;
count__28438_28458 = G__28463;
i__28439_28459 = G__28464;
continue;
} else {
var temp__4425__auto___28465 = cljs.core.seq.call(null,seq__28436_28456);
if(temp__4425__auto___28465){
var seq__28436_28466__$1 = temp__4425__auto___28465;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28436_28466__$1)){
var c__19273__auto___28467 = cljs.core.chunk_first.call(null,seq__28436_28466__$1);
var G__28468 = cljs.core.chunk_rest.call(null,seq__28436_28466__$1);
var G__28469 = c__19273__auto___28467;
var G__28470 = cljs.core.count.call(null,c__19273__auto___28467);
var G__28471 = (0);
seq__28436_28456 = G__28468;
chunk__28437_28457 = G__28469;
count__28438_28458 = G__28470;
i__28439_28459 = G__28471;
continue;
} else {
var f_28472 = cljs.core.first.call(null,seq__28436_28466__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_28472);

var G__28473 = cljs.core.next.call(null,seq__28436_28466__$1);
var G__28474 = null;
var G__28475 = (0);
var G__28476 = (0);
seq__28436_28456 = G__28473;
chunk__28437_28457 = G__28474;
count__28438_28458 = G__28475;
i__28439_28459 = G__28476;
continue;
}
} else {
}
}
break;
}

var c__23428__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23428__auto__,map__28434,map__28434__$1,opts,on_cssload){
return (function (){
var f__23429__auto__ = (function (){var switch__23407__auto__ = ((function (c__23428__auto__,map__28434,map__28434__$1,opts,on_cssload){
return (function (state_28446){
var state_val_28447 = (state_28446[(1)]);
if((state_val_28447 === (1))){
var inst_28440 = cljs.core.async.timeout.call(null,(100));
var state_28446__$1 = state_28446;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28446__$1,(2),inst_28440);
} else {
if((state_val_28447 === (2))){
var inst_28442 = (state_28446[(2)]);
var inst_28443 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg);
var inst_28444 = on_cssload.call(null,inst_28443);
var state_28446__$1 = (function (){var statearr_28448 = state_28446;
(statearr_28448[(7)] = inst_28442);

return statearr_28448;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28446__$1,inst_28444);
} else {
return null;
}
}
});})(c__23428__auto__,map__28434,map__28434__$1,opts,on_cssload))
;
return ((function (switch__23407__auto__,c__23428__auto__,map__28434,map__28434__$1,opts,on_cssload){
return (function() {
var figwheel$client$file_reloading$reload_css_files_$_state_machine__23408__auto__ = null;
var figwheel$client$file_reloading$reload_css_files_$_state_machine__23408__auto____0 = (function (){
var statearr_28452 = [null,null,null,null,null,null,null,null];
(statearr_28452[(0)] = figwheel$client$file_reloading$reload_css_files_$_state_machine__23408__auto__);

(statearr_28452[(1)] = (1));

return statearr_28452;
});
var figwheel$client$file_reloading$reload_css_files_$_state_machine__23408__auto____1 = (function (state_28446){
while(true){
var ret_value__23409__auto__ = (function (){try{while(true){
var result__23410__auto__ = switch__23407__auto__.call(null,state_28446);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23410__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23410__auto__;
}
break;
}
}catch (e28453){if((e28453 instanceof Object)){
var ex__23411__auto__ = e28453;
var statearr_28454_28477 = state_28446;
(statearr_28454_28477[(5)] = ex__23411__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28446);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28453;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23409__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28478 = state_28446;
state_28446 = G__28478;
continue;
} else {
return ret_value__23409__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_css_files_$_state_machine__23408__auto__ = function(state_28446){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_css_files_$_state_machine__23408__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_css_files_$_state_machine__23408__auto____1.call(this,state_28446);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_css_files_$_state_machine__23408__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_css_files_$_state_machine__23408__auto____0;
figwheel$client$file_reloading$reload_css_files_$_state_machine__23408__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_css_files_$_state_machine__23408__auto____1;
return figwheel$client$file_reloading$reload_css_files_$_state_machine__23408__auto__;
})()
;})(switch__23407__auto__,c__23428__auto__,map__28434,map__28434__$1,opts,on_cssload))
})();
var state__23430__auto__ = (function (){var statearr_28455 = f__23429__auto__.call(null);
(statearr_28455[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23428__auto__);

return statearr_28455;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23430__auto__);
});})(c__23428__auto__,map__28434,map__28434__$1,opts,on_cssload))
);

return c__23428__auto__;
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map