// Compiled by ClojureScript 1.7.48 {}
goog.provide('dragonmark.inputs.i18n');
goog.require('cljs.core');
goog.require('schema.core');
goog.require('clojure.string');
goog.require('dragonmark.inputs.extern');
goog.require('dragonmark.inputs.utils');
dragonmark.inputs.i18n.sch_i18n_field_labels = new cljs.core.PersistentArrayMap.fromArray([schema.core.optional_key.call(null,new cljs.core.Keyword(null,"label","label",1718410804)),schema.core.Str,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"desc","desc",2093485764)),schema.core.Str,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"ph","ph",-1483583977)),schema.core.Str,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"info","info",-317069002)),schema.core.Str,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"info-title","info-title",-1811346921)),schema.core.Str,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"html","html",-998796897)),schema.core.Any], true, false);
dragonmark.inputs.i18n.sch_i18n_enum_labels = new cljs.core.PersistentArrayMap.fromArray([schema.core.optional_key.call(null,new cljs.core.Keyword(null,"data","data",-232669377)),new cljs.core.PersistentArrayMap.fromArray([schema.core.Any,dragonmark.inputs.i18n.sch_i18n_field_labels], true, false)], true, false);
dragonmark.inputs.i18n.sch_i18n_field = cljs.core.merge.call(null,dragonmark.inputs.i18n.sch_i18n_enum_labels,dragonmark.inputs.i18n.sch_i18n_field_labels);
dragonmark.inputs.i18n.sch_i18n_errors = new cljs.core.PersistentArrayMap.fromArray([schema.core.optional_key.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718)),new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Str], true, false)], true, false);
/**
 * Build a specific i18n Schema with all possible keys.
 */
dragonmark.inputs.i18n.build_i18n_schema = (function dragonmark$inputs$i18n$build_i18n_schema(sch){
return cljs.core.reduce.call(null,(function (acc,p__29752){
var vec__29753 = p__29752;
var k = cljs.core.nth.call(null,vec__29753,(0),null);
var v = cljs.core.nth.call(null,vec__29753,(1),null);
return cljs.core.assoc.call(null,acc,schema.core.optional_key.call(null,cljs.core.get.call(null,k,new cljs.core.Keyword(null,"k","k",-2146297393),k)),dragonmark.inputs.i18n.sch_i18n_field);
}),new cljs.core.PersistentArrayMap.fromArray([schema.core.optional_key.call(null,new cljs.core.Keyword(null,"title","title",636505583)),schema.core.Str,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"action","action",-811238024)),dragonmark.inputs.i18n.sch_i18n_field_labels,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"clean","clean",41534079)),dragonmark.inputs.i18n.sch_i18n_field_labels], true, false),sch);
});
/**
 * Try to determine the language of the browser
 */
dragonmark.inputs.i18n.browser_lang = (function dragonmark$inputs$i18n$browser_lang(){
var temp__4425__auto__ = (function (){var or__18489__auto__ = navigator.userLanguage;
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
var or__18489__auto____$1 = navigator.browserLanguage;
if(cljs.core.truth_(or__18489__auto____$1)){
return or__18489__auto____$1;
} else {
return navigator.language;
}
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var b_lang = temp__4425__auto__;
return b_lang.substr((0),(2));
} else {
return null;
}
});
dragonmark.inputs.i18n.I18NSchema = new cljs.core.PersistentArrayMap.fromArray([schema.core.Str,cljs.core.merge.call(null,dragonmark.inputs.i18n.sch_i18n_errors,new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,dragonmark.inputs.i18n.sch_i18n_field], true, false),new cljs.core.PersistentArrayMap.fromArray([schema.core.optional_key.call(null,new cljs.core.Keyword(null,"title","title",636505583)),schema.core.Str,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"action","action",-811238024)),dragonmark.inputs.i18n.sch_i18n_field_labels,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"clean","clean",41534079)),dragonmark.inputs.i18n.sch_i18n_field_labels], true, false))], true, false))], true, false);
/**
 * If i18n is provided then determine the language in this order from
 * the state
 * the browser
 * the first language available
 */
dragonmark.inputs.i18n.i18n_comp_lang = (function dragonmark$inputs$i18n$i18n_comp_lang(sch,comp_name,lang,full_i18n,opts){
var langs = cljs.core.keys.call(null,full_i18n);
var language = (function (){var or__18489__auto__ = cljs.core.some.call(null,cljs.core.PersistentHashSet.fromArray([lang], true),langs);
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
var or__18489__auto____$1 = cljs.core.some.call(null,cljs.core.PersistentHashSet.fromArray([dragonmark.inputs.i18n.browser_lang.call(null)], true),langs);
if(cljs.core.truth_(or__18489__auto____$1)){
return or__18489__auto____$1;
} else {
return cljs.core.first.call(null,langs);
}
}
})();
if(cljs.core.not_EQ_.call(null,lang,language)){
cljs.core.prn.call(null,[cljs.core.str("Warning - Check your i18n language configuration; you set : "),cljs.core.str(lang),cljs.core.str(" but found no labels. Switching to : "),cljs.core.str(language)].join(''));
} else {
}

var labels = cljs.core.get_in.call(null,full_i18n,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [language,comp_name], null));
if(cljs.core.truth_(new cljs.core.Keyword(null,"validate-i18n-keys","validate-i18n-keys",-415632905).cljs$core$IFn$_invoke$arity$1(opts))){
return schema.core.validate.call(null,dragonmark.inputs.i18n.build_i18n_schema.call(null,sch),labels);
} else {
return labels;
}
});
/**
 * Optimisation and as a side effect the warning is printed only once
 */
dragonmark.inputs.i18n.i18n_comp_lang_memo = cljs.core.memoize.call(null,dragonmark.inputs.i18n.i18n_comp_lang);
/**
 * Get the specific i18n labels for the component and the language
 */
dragonmark.inputs.i18n.comp_i18n = (function dragonmark$inputs$i18n$comp_i18n(owner,comp_name,sch,opts){
var full_i18n = dragonmark.inputs.extern.get_i18n_info.call(null,owner,new cljs.core.Keyword(null,"i18n","i18n",-563422499));
var lang = dragonmark.inputs.extern.get_state.call(null,owner,new cljs.core.Keyword(null,"lang","lang",-1819677104));
if(cljs.core.truth_(full_i18n)){
if(cljs.core.truth_(new cljs.core.Keyword(null,"validate-i18n-keys","validate-i18n-keys",-415632905).cljs$core$IFn$_invoke$arity$1(opts))){
schema.core.validate.call(null,dragonmark.inputs.i18n.I18NSchema,full_i18n);
} else {
}

return dragonmark.inputs.i18n.i18n_comp_lang_memo.call(null,sch,comp_name,lang,full_i18n,opts);
} else {
return null;
}
});
dragonmark.inputs.i18n.label = (function dragonmark$inputs$i18n$label(){
var args29754 = [];
var len__19528__auto___29757 = arguments.length;
var i__19529__auto___29758 = (0);
while(true){
if((i__19529__auto___29758 < len__19528__auto___29757)){
args29754.push((arguments[i__19529__auto___29758]));

var G__29759 = (i__19529__auto___29758 + (1));
i__19529__auto___29758 = G__29759;
continue;
} else {
}
break;
}

var G__29756 = args29754.length;
switch (G__29756) {
case 1:
return dragonmark.inputs.i18n.label.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return dragonmark.inputs.i18n.label.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29754.length)].join('')));

}
});

dragonmark.inputs.i18n.label.cljs$core$IFn$_invoke$arity$1 = (function (opts){
return dragonmark.inputs.i18n.label.call(null,new cljs.core.Keyword(null,"i18n","i18n",-563422499).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(opts),opts);
});

dragonmark.inputs.i18n.label.cljs$core$IFn$_invoke$arity$3 = (function (i18n,k,opts){
var or__18489__auto__ = cljs.core.get_in.call(null,i18n,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804)], null));
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
var or__18489__auto____$1 = new cljs.core.Keyword(null,"label","label",1718410804).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__18489__auto____$1)){
return or__18489__auto____$1;
} else {
return clojure.string.capitalize.call(null,cljs.core.name.call(null,k));
}
}
});

dragonmark.inputs.i18n.label.cljs$lang$maxFixedArity = 3;
dragonmark.inputs.i18n.desc = (function dragonmark$inputs$i18n$desc(){
var args29761 = [];
var len__19528__auto___29764 = arguments.length;
var i__19529__auto___29765 = (0);
while(true){
if((i__19529__auto___29765 < len__19528__auto___29764)){
args29761.push((arguments[i__19529__auto___29765]));

var G__29766 = (i__19529__auto___29765 + (1));
i__19529__auto___29765 = G__29766;
continue;
} else {
}
break;
}

var G__29763 = args29761.length;
switch (G__29763) {
case 1:
return dragonmark.inputs.i18n.desc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dragonmark.inputs.i18n.desc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29761.length)].join('')));

}
});

dragonmark.inputs.i18n.desc.cljs$core$IFn$_invoke$arity$1 = (function (opts){
return cljs.core.get_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i18n","i18n",-563422499),new cljs.core.Keyword(null,"desc","desc",2093485764)], null));
});

dragonmark.inputs.i18n.desc.cljs$core$IFn$_invoke$arity$2 = (function (i18n,k){
return cljs.core.get_in.call(null,i18n,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,new cljs.core.Keyword(null,"desc","desc",2093485764)], null));
});

dragonmark.inputs.i18n.desc.cljs$lang$maxFixedArity = 2;
dragonmark.inputs.i18n.desc_QMARK_ = (function dragonmark$inputs$i18n$desc_QMARK_(i18n,k){
return !((dragonmark.inputs.i18n.desc.call(null,i18n,k) == null));
});
dragonmark.inputs.i18n.html_desc = (function dragonmark$inputs$i18n$html_desc(opts){
return cljs.core.get_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i18n","i18n",-563422499),new cljs.core.Keyword(null,"html","html",-998796897)], null));
});
dragonmark.inputs.i18n.html_desc_QMARK_ = (function dragonmark$inputs$i18n$html_desc_QMARK_(opts){
return !((dragonmark.inputs.i18n.html_desc.call(null,opts) == null));
});
dragonmark.inputs.i18n.data = (function dragonmark$inputs$i18n$data(i18n){
return cljs.core.get_in.call(null,i18n,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
});
dragonmark.inputs.i18n.enum_label = (function dragonmark$inputs$i18n$enum_label(data,code){
return cljs.core.get_in.call(null,data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [code,new cljs.core.Keyword(null,"label","label",1718410804)], null),(((code instanceof cljs.core.Keyword))?dragonmark.inputs.utils.full_name.call(null,code):code));
});
var ufv___29782 = schema.utils.use_fn_validation;
var output_schema29768_29783 = schema.core.Any;
var input_schema29769_29784 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.i18n.I18NSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"full-i18n","full-i18n",757551349,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"I18NSchema","I18NSchema",-1537766132,null)], null))),schema.core.one.call(null,schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.optional.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker29770_29785 = schema.core.checker.call(null,input_schema29769_29784);
var output_checker29771_29786 = schema.core.checker.call(null,output_schema29768_29783);
/**
 * Inputs: [full-i18n :- I18NSchema k :- s/Keyword & [opts]]
 */
dragonmark.inputs.i18n.error = ((function (ufv___29782,output_schema29768_29783,input_schema29769_29784,input_checker29770_29785,output_checker29771_29786){
return (function dragonmark$inputs$i18n$error(){
var args__19535__auto__ = [];
var len__19528__auto___29787 = arguments.length;
var i__19529__auto___29788 = (0);
while(true){
if((i__19529__auto___29788 < len__19528__auto___29787)){
args__19535__auto__.push((arguments[i__19529__auto___29788]));

var G__29789 = (i__19529__auto___29788 + (1));
i__19529__auto___29788 = G__29789;
continue;
} else {
}
break;
}

var argseq__19536__auto__ = ((((2) < args__19535__auto__.length))?(new cljs.core.IndexedSeq(args__19535__auto__.slice((2)),(0))):null);
return dragonmark.inputs.i18n.error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19536__auto__);
});})(ufv___29782,output_schema29768_29783,input_schema29769_29784,input_checker29770_29785,output_checker29771_29786))
;

dragonmark.inputs.i18n.error.cljs$core$IFn$_invoke$arity$variadic = ((function (ufv___29782,output_schema29768_29783,input_schema29769_29784,input_checker29770_29785,output_checker29771_29786){
return (function (G__29772,G__29773,rest29774){
var validate__20882__auto__ = ufv___29782.get_cell();
if(cljs.core.truth_(validate__20882__auto__)){
var args__20883__auto___29790 = cljs.core.list_STAR_.call(null,G__29772,G__29773,rest29774);
var temp__4425__auto___29791 = input_checker29770_29785.call(null,args__20883__auto___29790);
if(cljs.core.truth_(temp__4425__auto___29791)){
var error__20884__auto___29792 = temp__4425__auto___29791;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"error","error",661562495,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)),cljs.core.pr_str.call(null,error__20884__auto___29792)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema29769_29784,new cljs.core.Keyword(null,"value","value",305978217),args__20883__auto___29790,new cljs.core.Keyword(null,"error","error",-978969032),error__20884__auto___29792], null));
} else {
}
} else {
}

var o__20885__auto__ = (function (){var full_i18n = G__29772;
var k = G__29773;
var G__29779 = rest29774;
var vec__29780 = G__29779;
var opts = cljs.core.nth.call(null,vec__29780,(0),null);
var full_i18n__$1 = full_i18n;
var k__$1 = k;
var G__29779__$1 = G__29779;
while(true){
var full_i18n__$2 = full_i18n__$1;
var k__$2 = k__$1;
var vec__29781 = G__29779__$1;
var opts__$1 = cljs.core.nth.call(null,vec__29781,(0),null);
var or__18489__auto__ = cljs.core.get_in.call(null,full_i18n__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),k__$2], null));
if(cljs.core.truth_(or__18489__auto__)){
return or__18489__auto__;
} else {
var or__18489__auto____$1 = cljs.core.get_in.call(null,opts__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k__$2,new cljs.core.Keyword(null,"label","label",1718410804)], null));
if(cljs.core.truth_(or__18489__auto____$1)){
return or__18489__auto____$1;
} else {
return cljs.core.name.call(null,k__$2);
}
}
break;
}
})();
if(cljs.core.truth_(validate__20882__auto__)){
var temp__4425__auto___29793 = output_checker29771_29786.call(null,o__20885__auto__);
if(cljs.core.truth_(temp__4425__auto___29793)){
var error__20884__auto___29794 = temp__4425__auto___29793;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"error","error",661562495,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)),cljs.core.pr_str.call(null,error__20884__auto___29794)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema29768_29783,new cljs.core.Keyword(null,"value","value",305978217),o__20885__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20884__auto___29794], null));
} else {
}
} else {
}

return o__20885__auto__;
});})(ufv___29782,output_schema29768_29783,input_schema29769_29784,input_checker29770_29785,output_checker29771_29786))
;

dragonmark.inputs.i18n.error.cljs$lang$maxFixedArity = (2);

dragonmark.inputs.i18n.error.cljs$lang$applyTo = ((function (ufv___29782,output_schema29768_29783,input_schema29769_29784,input_checker29770_29785,output_checker29771_29786){
return (function (seq29775){
var G__29776 = cljs.core.first.call(null,seq29775);
var seq29775__$1 = cljs.core.next.call(null,seq29775);
var G__29777 = cljs.core.first.call(null,seq29775__$1);
var seq29775__$2 = cljs.core.next.call(null,seq29775__$1);
return dragonmark.inputs.i18n.error.cljs$core$IFn$_invoke$arity$variadic(G__29776,G__29777,seq29775__$2);
});})(ufv___29782,output_schema29768_29783,input_schema29769_29784,input_checker29770_29785,output_checker29771_29786))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.i18n.error),schema.core.make_fn_schema.call(null,output_schema29768_29783,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema29769_29784], null)));
dragonmark.inputs.i18n.ph = (function dragonmark$inputs$i18n$ph(i18n){
return cljs.core.get_in.call(null,i18n,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ph","ph",-1483583977)], null));
});
dragonmark.inputs.i18n.info = (function dragonmark$inputs$i18n$info(opts){
return cljs.core.get_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i18n","i18n",-563422499),new cljs.core.Keyword(null,"info","info",-317069002)], null));
});
dragonmark.inputs.i18n.info_title = (function dragonmark$inputs$i18n$info_title(opts){
return cljs.core.get_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i18n","i18n",-563422499),new cljs.core.Keyword(null,"info-title","info-title",-1811346921)], null));
});

//# sourceMappingURL=i18n.js.map