// Compiled by ClojureScript 1.7.48 {}
goog.provide('schema.coerce');
goog.require('cljs.core');
goog.require('schema.core');
goog.require('schema.spec.core');
goog.require('clojure.string');
goog.require('schema.utils');
goog.require('cljs.reader');
/**
 * A Schema for Schemas
 */
schema.coerce.Schema = cljs.core.with_meta.call(null,schema.core.__GT_Protocol.call(null,schema.core.Schema),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"proto-sym","proto-sym",-886371734),new cljs.core.Symbol("s","Schema","s/Schema",-1305723789,null),new cljs.core.Keyword(null,"proto-pred","proto-pred",1885698716),(function (p1__21688__21689__auto__){
if(!((p1__21688__21689__auto__ == null))){
if((false) || (p1__21688__21689__auto__.schema$core$Schema$)){
return true;
} else {
if((!p1__21688__21689__auto__.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,schema.core.Schema,p1__21688__21689__auto__);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,schema.core.Schema,p1__21688__21689__auto__);
}
})], null));
/**
 * A function from schema to coercion function, or nil if no special coercion is needed.
 * The returned function is applied to the corresponding data before validation (or walking/
 * coercion of its sub-schemas, if applicable)
 */
schema.coerce.CoercionMatcher = schema.core.make_fn_schema.call(null,schema.core.maybe.call(null,schema.core.make_fn_schema.call(null,schema.core.Any,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null))], null)], null))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.coerce.Schema,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null))], null)], null));
var ufv___34292 = schema.utils.use_fn_validation;
var output_schema34284_34293 = schema.core.Any;
var input_schema34285_34294 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one.call(null,schema.coerce.CoercionMatcher,cljs.core.with_meta(new cljs.core.Symbol(null,"coercion-matcher","coercion-matcher",-1929420453,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"CoercionMatcher","CoercionMatcher",1341105319,null)], null)))], null);
var input_checker34286_34295 = schema.core.checker.call(null,input_schema34285_34294);
var output_checker34287_34296 = schema.core.checker.call(null,output_schema34284_34293);
/**
 * Inputs: [schema coercion-matcher :- CoercionMatcher]
 * 
 * Produce a function that simultaneously coerces and validates a datum.
 */
schema.coerce.coercer = ((function (ufv___34292,output_schema34284_34293,input_schema34285_34294,input_checker34286_34295,output_checker34287_34296){
return (function schema$coerce$coercer(G__34288,G__34289){
var validate__20990__auto__ = ufv___34292.get_cell();
if(cljs.core.truth_(validate__20990__auto__)){
var args__20991__auto___34297 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__34288,G__34289], null);
var temp__4425__auto___34298 = input_checker34286_34295.call(null,args__20991__auto___34297);
if(cljs.core.truth_(temp__4425__auto___34298)){
var error__20992__auto___34299 = temp__4425__auto___34298;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"coercer","coercer",-783242414,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Produce a function that simultaneously coerces and validates a datum."], null)),cljs.core.pr_str.call(null,error__20992__auto___34299)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema34285_34294,new cljs.core.Keyword(null,"value","value",305978217),args__20991__auto___34297,new cljs.core.Keyword(null,"error","error",-978969032),error__20992__auto___34299], null));
} else {
}
} else {
}

var o__20993__auto__ = (function (){var schema__$1 = G__34288;
var coercion_matcher = G__34289;
while(true){
return schema.spec.core.run_checker.call(null,((function (validate__20990__auto__,ufv___34292,output_schema34284_34293,input_schema34285_34294,input_checker34286_34295,output_checker34287_34296){
return (function (s,params){
var c = schema.spec.core.checker.call(null,schema.core.spec.call(null,s),params);
var temp__4423__auto__ = coercion_matcher.call(null,s);
if(cljs.core.truth_(temp__4423__auto__)){
var coercer__$1 = temp__4423__auto__;
return ((function (coercer__$1,temp__4423__auto__,c,validate__20990__auto__,ufv___34292,output_schema34284_34293,input_schema34285_34294,input_checker34286_34295,output_checker34287_34296){
return (function (x){
try{var v = coercer__$1.call(null,x);
if(cljs.core.truth_(schema.utils.error_QMARK_.call(null,v))){
return v;
} else {
return c.call(null,v);
}
}catch (e34291){if((e34291 instanceof Object)){
var t = e34291;
return schema.utils.error.call(null,schema.utils.make_ValidationError.call(null,s,x,(new cljs.core.Delay(((function (t,coercer__$1,temp__4423__auto__,c,validate__20990__auto__,ufv___34292,output_schema34284_34293,input_schema34285_34294,input_checker34286_34295,output_checker34287_34296){
return (function (){
return t;
});})(t,coercer__$1,temp__4423__auto__,c,validate__20990__auto__,ufv___34292,output_schema34284_34293,input_schema34285_34294,input_checker34286_34295,output_checker34287_34296))
,null)),null));
} else {
throw e34291;

}
}});
;})(coercer__$1,temp__4423__auto__,c,validate__20990__auto__,ufv___34292,output_schema34284_34293,input_schema34285_34294,input_checker34286_34295,output_checker34287_34296))
} else {
return c;
}
});})(validate__20990__auto__,ufv___34292,output_schema34284_34293,input_schema34285_34294,input_checker34286_34295,output_checker34287_34296))
,true,schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__20990__auto__)){
var temp__4425__auto___34300 = output_checker34287_34296.call(null,o__20993__auto__);
if(cljs.core.truth_(temp__4425__auto___34300)){
var error__20992__auto___34301 = temp__4425__auto___34300;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"coercer","coercer",-783242414,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Produce a function that simultaneously coerces and validates a datum."], null)),cljs.core.pr_str.call(null,error__20992__auto___34301)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema34284_34293,new cljs.core.Keyword(null,"value","value",305978217),o__20993__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20992__auto___34301], null));
} else {
}
} else {
}

return o__20993__auto__;
});})(ufv___34292,output_schema34284_34293,input_schema34285_34294,input_checker34286_34295,output_checker34287_34296))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,schema.coerce.coercer),schema.core.make_fn_schema.call(null,output_schema34284_34293,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema34285_34294], null)));
var ufv___34308 = schema.utils.use_fn_validation;
var output_schema34303_34309 = schema.coerce.CoercionMatcher;
var input_schema34304_34310 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.coerce.CoercionMatcher], null),cljs.core.with_meta(new cljs.core.Symbol(null,"matchers","matchers",-39860883,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"CoercionMatcher","CoercionMatcher",1341105319,null)], null)], null)))], null);
var input_checker34305_34311 = schema.core.checker.call(null,input_schema34304_34310);
var output_checker34306_34312 = schema.core.checker.call(null,output_schema34303_34309);
/**
 * Inputs: [matchers :- [CoercionMatcher]]
 * Returns: CoercionMatcher
 * 
 * A matcher that takes the first match from matchers.
 */
schema.coerce.first_matcher = ((function (ufv___34308,output_schema34303_34309,input_schema34304_34310,input_checker34305_34311,output_checker34306_34312){
return (function schema$coerce$first_matcher(G__34307){
var validate__20990__auto__ = ufv___34308.get_cell();
if(cljs.core.truth_(validate__20990__auto__)){
var args__20991__auto___34313 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__34307], null);
var temp__4425__auto___34314 = input_checker34305_34311.call(null,args__20991__auto___34313);
if(cljs.core.truth_(temp__4425__auto___34314)){
var error__20992__auto___34315 = temp__4425__auto___34314;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"first-matcher","first-matcher",-2060940642,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"CoercionMatcher","CoercionMatcher",1341105319,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"A matcher that takes the first match from matchers."], null)),cljs.core.pr_str.call(null,error__20992__auto___34315)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema34304_34310,new cljs.core.Keyword(null,"value","value",305978217),args__20991__auto___34313,new cljs.core.Keyword(null,"error","error",-978969032),error__20992__auto___34315], null));
} else {
}
} else {
}

var o__20993__auto__ = (function (){var matchers = G__34307;
while(true){
return ((function (validate__20990__auto__,ufv___34308,output_schema34303_34309,input_schema34304_34310,input_checker34305_34311,output_checker34306_34312){
return (function (schema__$1){
return cljs.core.first.call(null,cljs.core.keep.call(null,((function (validate__20990__auto__,ufv___34308,output_schema34303_34309,input_schema34304_34310,input_checker34305_34311,output_checker34306_34312){
return (function (p1__34302_SHARP_){
return p1__34302_SHARP_.call(null,schema__$1);
});})(validate__20990__auto__,ufv___34308,output_schema34303_34309,input_schema34304_34310,input_checker34305_34311,output_checker34306_34312))
,matchers));
});
;})(validate__20990__auto__,ufv___34308,output_schema34303_34309,input_schema34304_34310,input_checker34305_34311,output_checker34306_34312))
break;
}
})();
if(cljs.core.truth_(validate__20990__auto__)){
var temp__4425__auto___34316 = output_checker34306_34312.call(null,o__20993__auto__);
if(cljs.core.truth_(temp__4425__auto___34316)){
var error__20992__auto___34317 = temp__4425__auto___34316;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"first-matcher","first-matcher",-2060940642,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"CoercionMatcher","CoercionMatcher",1341105319,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"A matcher that takes the first match from matchers."], null)),cljs.core.pr_str.call(null,error__20992__auto___34317)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema34303_34309,new cljs.core.Keyword(null,"value","value",305978217),o__20993__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20992__auto___34317], null));
} else {
}
} else {
}

return o__20993__auto__;
});})(ufv___34308,output_schema34303_34309,input_schema34304_34310,input_checker34305_34311,output_checker34306_34312))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,schema.coerce.first_matcher),schema.core.make_fn_schema.call(null,output_schema34303_34309,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema34304_34310], null)));
schema.coerce.string__GT_keyword = (function schema$coerce$string__GT_keyword(s){
if(typeof s === 'string'){
return cljs.core.keyword.call(null,s);
} else {
return s;
}
});
/**
 * returns true for strings that are equal, ignoring case, to the string 'true'
 * (following java.lang.Boolean/parseBoolean semantics)
 */
schema.coerce.string__GT_boolean = (function schema$coerce$string__GT_boolean(s){
if(typeof s === 'string'){
return cljs.core._EQ_.call(null,"true",clojure.string.lower_case.call(null,s));
} else {
return s;
}
});
schema.coerce.keyword_enum_matcher = (function schema$coerce$keyword_enum_matcher(schema__$1){
if(((schema__$1 instanceof schema.core.EnumSchema)) && (cljs.core.every_QMARK_.call(null,cljs.core.keyword_QMARK_,schema__$1.vs))){
return schema.coerce.string__GT_keyword;
} else {
return null;
}
});
schema.coerce.set_matcher = (function schema$coerce$set_matcher(schema__$1){
if((schema__$1 instanceof cljs.core.PersistentHashSet)){
return (function (x){
if(cljs.core.sequential_QMARK_.call(null,x)){
return cljs.core.set.call(null,x);
} else {
return x;
}
});
} else {
return null;
}
});
/**
 * Take a single-arg function f, and return a single-arg function that acts as identity
 * if f throws an exception, and like f otherwise.  Useful because coercers are not explicitly
 * guarded for exceptions, and failing to coerce will generally produce a more useful error
 * in this case.
 */
schema.coerce.safe = (function schema$coerce$safe(f){
return (function (x){
try{return f.call(null,x);
}catch (e34319){if((e34319 instanceof Object)){
var e = e34319;
return x;
} else {
throw e34319;

}
}});
});
/**
 * Returns instance of UUID if input is a string.
 * Note: in CLJS, this does not guarantee a specific UUID string representation,
 * similar to #uuid reader
 */
schema.coerce.string__GT_uuid = (function schema$coerce$string__GT_uuid(p1__34320_SHARP_){
if(typeof p1__34320_SHARP_ === 'string'){
return (new cljs.core.UUID(p1__34320_SHARP_));
} else {
return p1__34320_SHARP_;
}
});
schema.coerce._PLUS_json_coercions_PLUS_ = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.coerce.string__GT_keyword,schema.core.Bool,schema.coerce.string__GT_boolean,schema.core.Uuid,schema.coerce.string__GT_uuid], true, false));
/**
 * A matcher that coerces keywords and keyword enums from strings, and longs and doubles
 * from numbers on the JVM (without losing precision)
 */
schema.coerce.json_coercion_matcher = (function schema$coerce$json_coercion_matcher(schema__$1){
var or__18528__auto__ = schema.coerce._PLUS_json_coercions_PLUS_.call(null,schema__$1);
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
var or__18528__auto____$1 = schema.coerce.keyword_enum_matcher.call(null,schema__$1);
if(cljs.core.truth_(or__18528__auto____$1)){
return or__18528__auto____$1;
} else {
return schema.coerce.set_matcher.call(null,schema__$1);
}
}
});
/**
 * Reads one object from a string. Returns nil when string is nil or empty
 */
schema.coerce.edn_read_string = cljs.reader.read_string;
schema.coerce._PLUS_string_coercions_PLUS_ = cljs.core.merge.call(null,schema.coerce._PLUS_json_coercions_PLUS_,new cljs.core.PersistentArrayMap.fromArray([schema.core.Num,schema.coerce.safe.call(null,schema.coerce.edn_read_string),schema.core.Int,schema.coerce.safe.call(null,schema.coerce.edn_read_string)], true, false));
/**
 * A matcher that coerces keywords, keyword enums, s/Num and s/Int,
 * and long and doubles (JVM only) from strings.
 */
schema.coerce.string_coercion_matcher = (function schema$coerce$string_coercion_matcher(schema__$1){
var or__18528__auto__ = schema.coerce._PLUS_string_coercions_PLUS_.call(null,schema__$1);
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
var or__18528__auto____$1 = schema.coerce.keyword_enum_matcher.call(null,schema__$1);
if(cljs.core.truth_(or__18528__auto____$1)){
return or__18528__auto____$1;
} else {
return schema.coerce.set_matcher.call(null,schema__$1);
}
}
});

//# sourceMappingURL=coerce.js.map