// Compiled by ClojureScript 1.7.48 {}
goog.provide('jkkramer.verily');
goog.require('cljs.core');
goog.require('clojure.string');
jkkramer.verily.seqify = (function jkkramer$verily$seqify(x){
if(!(cljs.core.sequential_QMARK_.call(null,x))){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [x], null);
} else {
return x;
}
});
/**
 * Expands a name like "foo[bar][baz]" or :foo.bar.baz into [:foo :bar :baz]
 */
jkkramer.verily.expand_name = (function jkkramer$verily$expand_name(name){
if((typeof name === 'string') || ((name instanceof cljs.core.Keyword))){
var name_str = cljs.core.name.call(null,name);
var vec__31181 = cljs.core.re_matches.call(null,/^([^\[]+)((?:\[[^\]]+?\])*)$/,name_str);
var _ = cljs.core.nth.call(null,vec__31181,(0),null);
var name1 = cljs.core.nth.call(null,vec__31181,(1),null);
var more_names = cljs.core.nth.call(null,vec__31181,(2),null);
if(cljs.core.seq.call(null,more_names)){
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,name1)], null),cljs.core.map.call(null,cljs.core.comp.call(null,cljs.core.keyword,cljs.core.second),cljs.core.re_seq.call(null,/\[([^\]]+)\]/,more_names)));
} else {
var parts = clojure.string.split.call(null,name_str,/\./);
return cljs.core.mapv.call(null,cljs.core.keyword,parts);
}
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name], null);
}
});
jkkramer.verily.make_validator = (function jkkramer$verily$make_validator(keys,bad_pred,msg){
var bad_pred_STAR_ = (function (p1__31182_SHARP_){
try{return bad_pred.call(null,p1__31182_SHARP_);
}catch (e31185){if((e31185 instanceof Error)){
var _ = e31185;
return true;
} else {
throw e31185;

}
}});
return ((function (bad_pred_STAR_){
return (function (m){
var bad_keys = cljs.core.filter.call(null,((function (bad_pred_STAR_){
return (function (p1__31183_SHARP_){
return bad_pred_STAR_.call(null,cljs.core.get.call(null,m,p1__31183_SHARP_,cljs.core.get_in.call(null,m,jkkramer.verily.expand_name.call(null,p1__31183_SHARP_),new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708))));
});})(bad_pred_STAR_))
,jkkramer.verily.seqify.call(null,keys));
if(cljs.core.seq.call(null,bad_keys)){
if(cljs.core.map_QMARK_.call(null,msg)){
return msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),bad_keys,new cljs.core.Keyword(null,"msg","msg",-1386103444),msg], null);
}
} else {
return null;
}
});
;})(bad_pred_STAR_))
});
/**
 * The keys must be present in the map but may be blank.
 */
jkkramer.verily.contains = (function jkkramer$verily$contains(){
var args__19574__auto__ = [];
var len__19567__auto___31190 = arguments.length;
var i__19568__auto___31191 = (0);
while(true){
if((i__19568__auto___31191 < len__19567__auto___31190)){
args__19574__auto__.push((arguments[i__19568__auto___31191]));

var G__31192 = (i__19568__auto___31191 + (1));
i__19568__auto___31191 = G__31192;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((1) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((1)),(0))):null);
return jkkramer.verily.contains.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19575__auto__);
});

jkkramer.verily.contains.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__31188){
var vec__31189 = p__31188;
var msg = cljs.core.nth.call(null,vec__31189,(0),null);
return jkkramer.verily.make_validator.call(null,keys,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),null], null), null),(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return "must be present";
}
})());
});

jkkramer.verily.contains.cljs$lang$maxFixedArity = (1);

jkkramer.verily.contains.cljs$lang$applyTo = (function (seq31186){
var G__31187 = cljs.core.first.call(null,seq31186);
var seq31186__$1 = cljs.core.next.call(null,seq31186);
return jkkramer.verily.contains.cljs$core$IFn$_invoke$arity$variadic(G__31187,seq31186__$1);
});
/**
 * The keys must be present in the map AND not be blank.
 */
jkkramer.verily.required = (function jkkramer$verily$required(){
var args__19574__auto__ = [];
var len__19567__auto___31198 = arguments.length;
var i__19568__auto___31199 = (0);
while(true){
if((i__19568__auto___31199 < len__19567__auto___31198)){
args__19574__auto__.push((arguments[i__19568__auto___31199]));

var G__31200 = (i__19568__auto___31199 + (1));
i__19568__auto___31199 = G__31200;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((1) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((1)),(0))):null);
return jkkramer.verily.required.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19575__auto__);
});

jkkramer.verily.required.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__31196){
var vec__31197 = p__31196;
var msg = cljs.core.nth.call(null,vec__31197,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__31197,msg){
return (function (p1__31193_SHARP_){
var or__18528__auto__ = cljs.core._EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__31193_SHARP_);
if(or__18528__auto__){
return or__18528__auto__;
} else {
var or__18528__auto____$1 = (p1__31193_SHARP_ == null);
if(or__18528__auto____$1){
return or__18528__auto____$1;
} else {
var and__18516__auto__ = typeof p1__31193_SHARP_ === 'string';
if(and__18516__auto__){
return clojure.string.blank_QMARK_.call(null,p1__31193_SHARP_);
} else {
return and__18516__auto__;
}
}
}
});})(vec__31197,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return "must not be blank";
}
})());
});

jkkramer.verily.required.cljs$lang$maxFixedArity = (1);

jkkramer.verily.required.cljs$lang$applyTo = (function (seq31194){
var G__31195 = cljs.core.first.call(null,seq31194);
var seq31194__$1 = cljs.core.next.call(null,seq31194);
return jkkramer.verily.required.cljs$core$IFn$_invoke$arity$variadic(G__31195,seq31194__$1);
});
jkkramer.verily.complete = (function jkkramer$verily$complete(){
var args__19574__auto__ = [];
var len__19567__auto___31207 = arguments.length;
var i__19568__auto___31208 = (0);
while(true){
if((i__19568__auto___31208 < len__19567__auto___31207)){
args__19574__auto__.push((arguments[i__19568__auto___31208]));

var G__31209 = (i__19568__auto___31208 + (1));
i__19568__auto___31208 = G__31209;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((1) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((1)),(0))):null);
return jkkramer.verily.complete.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19575__auto__);
});

jkkramer.verily.complete.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__31205){
var vec__31206 = p__31205;
var msg = cljs.core.nth.call(null,vec__31206,(0),null);

var bad_QMARK_ = ((function (vec__31206,msg){
return (function (p1__31201_SHARP_){
var or__18528__auto__ = cljs.core._EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__31201_SHARP_);
if(or__18528__auto__){
return or__18528__auto__;
} else {
var or__18528__auto____$1 = (p1__31201_SHARP_ == null);
if(or__18528__auto____$1){
return or__18528__auto____$1;
} else {
var and__18516__auto__ = typeof p1__31201_SHARP_ === 'string';
if(and__18516__auto__){
return clojure.string.blank_QMARK_.call(null,p1__31201_SHARP_);
} else {
return and__18516__auto__;
}
}
}
});})(vec__31206,msg))
;
return jkkramer.verily.make_validator.call(null,keys,((function (bad_QMARK_,vec__31206,msg){
return (function (p1__31202_SHARP_){
var or__18528__auto__ = bad_QMARK_.call(null,p1__31202_SHARP_);
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
var or__18528__auto____$1 = !(cljs.core.coll_QMARK_.call(null,p1__31202_SHARP_));
if(or__18528__auto____$1){
return or__18528__auto____$1;
} else {
var or__18528__auto____$2 = (function (){var and__18516__auto__ = cljs.core.map_QMARK_.call(null,p1__31202_SHARP_);
if(and__18516__auto__){
return cljs.core.some.call(null,bad_QMARK_,cljs.core.vals.call(null,p1__31202_SHARP_));
} else {
return and__18516__auto__;
}
})();
if(cljs.core.truth_(or__18528__auto____$2)){
return or__18528__auto____$2;
} else {
var and__18516__auto__ = cljs.core.coll_QMARK_.call(null,p1__31202_SHARP_);
if(and__18516__auto__){
return cljs.core.some.call(null,bad_QMARK_,p1__31202_SHARP_);
} else {
return and__18516__auto__;
}
}
}
}
});})(bad_QMARK_,vec__31206,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return [cljs.core.str("must not be incomplete")].join('');
}
})());
});

jkkramer.verily.complete.cljs$lang$maxFixedArity = (1);

jkkramer.verily.complete.cljs$lang$applyTo = (function (seq31203){
var G__31204 = cljs.core.first.call(null,seq31203);
var seq31203__$1 = cljs.core.next.call(null,seq31203);
return jkkramer.verily.complete.cljs$core$IFn$_invoke$arity$variadic(G__31204,seq31203__$1);
});
/**
 * If present, the keys must not be blank.
 */
jkkramer.verily.not_blank = (function jkkramer$verily$not_blank(){
var args__19574__auto__ = [];
var len__19567__auto___31215 = arguments.length;
var i__19568__auto___31216 = (0);
while(true){
if((i__19568__auto___31216 < len__19567__auto___31215)){
args__19574__auto__.push((arguments[i__19568__auto___31216]));

var G__31217 = (i__19568__auto___31216 + (1));
i__19568__auto___31216 = G__31217;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((1) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((1)),(0))):null);
return jkkramer.verily.not_blank.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19575__auto__);
});

jkkramer.verily.not_blank.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__31213){
var vec__31214 = p__31213;
var msg = cljs.core.nth.call(null,vec__31214,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__31214,msg){
return (function (p1__31210_SHARP_){
var or__18528__auto__ = (p1__31210_SHARP_ == null);
if(or__18528__auto__){
return or__18528__auto__;
} else {
var and__18516__auto__ = typeof p1__31210_SHARP_ === 'string';
if(and__18516__auto__){
return clojure.string.blank_QMARK_.call(null,p1__31210_SHARP_);
} else {
return and__18516__auto__;
}
}
});})(vec__31214,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return "must not be blank";
}
})());
});

jkkramer.verily.not_blank.cljs$lang$maxFixedArity = (1);

jkkramer.verily.not_blank.cljs$lang$applyTo = (function (seq31211){
var G__31212 = cljs.core.first.call(null,seq31211);
var seq31211__$1 = cljs.core.next.call(null,seq31211);
return jkkramer.verily.not_blank.cljs$core$IFn$_invoke$arity$variadic(G__31212,seq31211__$1);
});
jkkramer.verily.exact = (function jkkramer$verily$exact(){
var args__19574__auto__ = [];
var len__19567__auto___31224 = arguments.length;
var i__19568__auto___31225 = (0);
while(true){
if((i__19568__auto___31225 < len__19567__auto___31224)){
args__19574__auto__.push((arguments[i__19568__auto___31225]));

var G__31226 = (i__19568__auto___31225 + (1));
i__19568__auto___31225 = G__31226;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((2) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((2)),(0))):null);
return jkkramer.verily.exact.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19575__auto__);
});

jkkramer.verily.exact.cljs$core$IFn$_invoke$arity$variadic = (function (val,keys,p__31222){
var vec__31223 = p__31222;
var msg = cljs.core.nth.call(null,vec__31223,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__31223,msg){
return (function (p1__31218_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__31218_SHARP_)) && (cljs.core.not_EQ_.call(null,val,p1__31218_SHARP_));
});})(vec__31223,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return "incorrect value";
}
})());
});

jkkramer.verily.exact.cljs$lang$maxFixedArity = (2);

jkkramer.verily.exact.cljs$lang$applyTo = (function (seq31219){
var G__31220 = cljs.core.first.call(null,seq31219);
var seq31219__$1 = cljs.core.next.call(null,seq31219);
var G__31221 = cljs.core.first.call(null,seq31219__$1);
var seq31219__$2 = cljs.core.next.call(null,seq31219__$1);
return jkkramer.verily.exact.cljs$core$IFn$_invoke$arity$variadic(G__31220,G__31221,seq31219__$2);
});
jkkramer.verily.equal = (function jkkramer$verily$equal(){
var args__19574__auto__ = [];
var len__19567__auto___31232 = arguments.length;
var i__19568__auto___31233 = (0);
while(true){
if((i__19568__auto___31233 < len__19567__auto___31232)){
args__19574__auto__.push((arguments[i__19568__auto___31233]));

var G__31234 = (i__19568__auto___31233 + (1));
i__19568__auto___31233 = G__31234;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((1) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((1)),(0))):null);
return jkkramer.verily.equal.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19575__auto__);
});

jkkramer.verily.equal.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__31230){
var vec__31231 = p__31230;
var msg = cljs.core.nth.call(null,vec__31231,(0),null);
var keys__$1 = jkkramer.verily.seqify.call(null,keys);
return ((function (keys__$1,vec__31231,msg){
return (function (m){
if(cljs.core.truth_(cljs.core.apply.call(null,cljs.core._EQ_,cljs.core.map.call(null,((function (keys__$1,vec__31231,msg){
return (function (p1__31227_SHARP_){
return cljs.core.get.call(null,m,p1__31227_SHARP_,cljs.core.get_in.call(null,m,jkkramer.verily.expand_name.call(null,p1__31227_SHARP_)));
});})(keys__$1,vec__31231,msg))
,keys__$1)))){
return null;
} else {
if(cljs.core.map_QMARK_.call(null,msg)){
return msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),keys__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444),(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return "must be equal";
}
})()], null);
}
}
});
;})(keys__$1,vec__31231,msg))
});

jkkramer.verily.equal.cljs$lang$maxFixedArity = (1);

jkkramer.verily.equal.cljs$lang$applyTo = (function (seq31228){
var G__31229 = cljs.core.first.call(null,seq31228);
var seq31228__$1 = cljs.core.next.call(null,seq31228);
return jkkramer.verily.equal.cljs$core$IFn$_invoke$arity$variadic(G__31229,seq31228__$1);
});
jkkramer.verily.matches = (function jkkramer$verily$matches(){
var args__19574__auto__ = [];
var len__19567__auto___31241 = arguments.length;
var i__19568__auto___31242 = (0);
while(true){
if((i__19568__auto___31242 < len__19567__auto___31241)){
args__19574__auto__.push((arguments[i__19568__auto___31242]));

var G__31243 = (i__19568__auto___31242 + (1));
i__19568__auto___31242 = G__31243;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((2) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((2)),(0))):null);
return jkkramer.verily.matches.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19575__auto__);
});

jkkramer.verily.matches.cljs$core$IFn$_invoke$arity$variadic = (function (re,keys,p__31239){
var vec__31240 = p__31239;
var msg = cljs.core.nth.call(null,vec__31240,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__31240,msg){
return (function (p1__31235_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__31235_SHARP_)) && (cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,p1__31235_SHARP_))) && (cljs.core.not.call(null,cljs.core.re_matches.call(null,re,p1__31235_SHARP_)));
});})(vec__31240,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return "incorrect format";
}
})());
});

jkkramer.verily.matches.cljs$lang$maxFixedArity = (2);

jkkramer.verily.matches.cljs$lang$applyTo = (function (seq31236){
var G__31237 = cljs.core.first.call(null,seq31236);
var seq31236__$1 = cljs.core.next.call(null,seq31236);
var G__31238 = cljs.core.first.call(null,seq31236__$1);
var seq31236__$2 = cljs.core.next.call(null,seq31236__$1);
return jkkramer.verily.matches.cljs$core$IFn$_invoke$arity$variadic(G__31237,G__31238,seq31236__$2);
});
jkkramer.verily.min_length = (function jkkramer$verily$min_length(){
var args__19574__auto__ = [];
var len__19567__auto___31250 = arguments.length;
var i__19568__auto___31251 = (0);
while(true){
if((i__19568__auto___31251 < len__19567__auto___31250)){
args__19574__auto__.push((arguments[i__19568__auto___31251]));

var G__31252 = (i__19568__auto___31251 + (1));
i__19568__auto___31251 = G__31252;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((2) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((2)),(0))):null);
return jkkramer.verily.min_length.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19575__auto__);
});

jkkramer.verily.min_length.cljs$core$IFn$_invoke$arity$variadic = (function (len,keys,p__31248){
var vec__31249 = p__31248;
var msg = cljs.core.nth.call(null,vec__31249,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__31249,msg){
return (function (p1__31244_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__31244_SHARP_)) && (!((p1__31244_SHARP_ == null))) && (!((len <= cljs.core.count.call(null,p1__31244_SHARP_))));
});})(vec__31249,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return [cljs.core.str("must be at least "),cljs.core.str(len),cljs.core.str(" characters")].join('');
}
})());
});

jkkramer.verily.min_length.cljs$lang$maxFixedArity = (2);

jkkramer.verily.min_length.cljs$lang$applyTo = (function (seq31245){
var G__31246 = cljs.core.first.call(null,seq31245);
var seq31245__$1 = cljs.core.next.call(null,seq31245);
var G__31247 = cljs.core.first.call(null,seq31245__$1);
var seq31245__$2 = cljs.core.next.call(null,seq31245__$1);
return jkkramer.verily.min_length.cljs$core$IFn$_invoke$arity$variadic(G__31246,G__31247,seq31245__$2);
});
jkkramer.verily.max_length = (function jkkramer$verily$max_length(){
var args__19574__auto__ = [];
var len__19567__auto___31259 = arguments.length;
var i__19568__auto___31260 = (0);
while(true){
if((i__19568__auto___31260 < len__19567__auto___31259)){
args__19574__auto__.push((arguments[i__19568__auto___31260]));

var G__31261 = (i__19568__auto___31260 + (1));
i__19568__auto___31260 = G__31261;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((2) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((2)),(0))):null);
return jkkramer.verily.max_length.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19575__auto__);
});

jkkramer.verily.max_length.cljs$core$IFn$_invoke$arity$variadic = (function (len,keys,p__31257){
var vec__31258 = p__31257;
var msg = cljs.core.nth.call(null,vec__31258,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__31258,msg){
return (function (p1__31253_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__31253_SHARP_)) && (!((p1__31253_SHARP_ == null))) && (!((len >= cljs.core.count.call(null,p1__31253_SHARP_))));
});})(vec__31258,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return [cljs.core.str("cannot exceed "),cljs.core.str(len),cljs.core.str(" characters")].join('');
}
})());
});

jkkramer.verily.max_length.cljs$lang$maxFixedArity = (2);

jkkramer.verily.max_length.cljs$lang$applyTo = (function (seq31254){
var G__31255 = cljs.core.first.call(null,seq31254);
var seq31254__$1 = cljs.core.next.call(null,seq31254);
var G__31256 = cljs.core.first.call(null,seq31254__$1);
var seq31254__$2 = cljs.core.next.call(null,seq31254__$1);
return jkkramer.verily.max_length.cljs$core$IFn$_invoke$arity$variadic(G__31255,G__31256,seq31254__$2);
});
jkkramer.verily.in$ = (function jkkramer$verily$in(){
var args__19574__auto__ = [];
var len__19567__auto___31268 = arguments.length;
var i__19568__auto___31269 = (0);
while(true){
if((i__19568__auto___31269 < len__19567__auto___31268)){
args__19574__auto__.push((arguments[i__19568__auto___31269]));

var G__31270 = (i__19568__auto___31269 + (1));
i__19568__auto___31269 = G__31270;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((2) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((2)),(0))):null);
return jkkramer.verily.in$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19575__auto__);
});

jkkramer.verily.in$.cljs$core$IFn$_invoke$arity$variadic = (function (coll,keys,p__31266){
var vec__31267 = p__31266;
var msg = cljs.core.nth.call(null,vec__31267,(0),null);
var coll_set = ((cljs.core.set_QMARK_.call(null,coll))?coll:cljs.core.set.call(null,coll));
return jkkramer.verily.make_validator.call(null,keys,((function (coll_set,vec__31267,msg){
return (function (p1__31262_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__31262_SHARP_)) && (!((p1__31262_SHARP_ == null))) && (!(cljs.core.contains_QMARK_.call(null,coll_set,p1__31262_SHARP_)));
});})(coll_set,vec__31267,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return [cljs.core.str("not an accepted value")].join('');
}
})());
});

jkkramer.verily.in$.cljs$lang$maxFixedArity = (2);

jkkramer.verily.in$.cljs$lang$applyTo = (function (seq31263){
var G__31264 = cljs.core.first.call(null,seq31263);
var seq31263__$1 = cljs.core.next.call(null,seq31263);
var G__31265 = cljs.core.first.call(null,seq31263__$1);
var seq31263__$2 = cljs.core.next.call(null,seq31263__$1);
return jkkramer.verily.in$.cljs$core$IFn$_invoke$arity$variadic(G__31264,G__31265,seq31263__$2);
});
jkkramer.verily.every_in = (function jkkramer$verily$every_in(){
var args__19574__auto__ = [];
var len__19567__auto___31277 = arguments.length;
var i__19568__auto___31278 = (0);
while(true){
if((i__19568__auto___31278 < len__19567__auto___31277)){
args__19574__auto__.push((arguments[i__19568__auto___31278]));

var G__31279 = (i__19568__auto___31278 + (1));
i__19568__auto___31278 = G__31279;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((2) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((2)),(0))):null);
return jkkramer.verily.every_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19575__auto__);
});

jkkramer.verily.every_in.cljs$core$IFn$_invoke$arity$variadic = (function (coll,keys,p__31275){
var vec__31276 = p__31275;
var msg = cljs.core.nth.call(null,vec__31276,(0),null);
var coll_set = ((cljs.core.set_QMARK_.call(null,coll))?coll:cljs.core.set.call(null,coll));
return jkkramer.verily.make_validator.call(null,keys,((function (coll_set,vec__31276,msg){
return (function (p1__31271_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__31271_SHARP_)) && (!((p1__31271_SHARP_ == null))) && (!(cljs.core.every_QMARK_.call(null,((function (coll_set,vec__31276,msg){
return (function (x){
return cljs.core.contains_QMARK_.call(null,coll_set,x);
});})(coll_set,vec__31276,msg))
,p1__31271_SHARP_)));
});})(coll_set,vec__31276,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return [cljs.core.str("not an accepted value")].join('');
}
})());
});

jkkramer.verily.every_in.cljs$lang$maxFixedArity = (2);

jkkramer.verily.every_in.cljs$lang$applyTo = (function (seq31272){
var G__31273 = cljs.core.first.call(null,seq31272);
var seq31272__$1 = cljs.core.next.call(null,seq31272);
var G__31274 = cljs.core.first.call(null,seq31272__$1);
var seq31272__$2 = cljs.core.next.call(null,seq31272__$1);
return jkkramer.verily.every_in.cljs$core$IFn$_invoke$arity$variadic(G__31273,G__31274,seq31272__$2);
});
jkkramer.verily.zip_regex = /^\d{5}(?:[-\s]\d{4})?$/;
jkkramer.verily.us_zip = (function jkkramer$verily$us_zip(){
var args__19574__auto__ = [];
var len__19567__auto___31285 = arguments.length;
var i__19568__auto___31286 = (0);
while(true){
if((i__19568__auto___31286 < len__19567__auto___31285)){
args__19574__auto__.push((arguments[i__19568__auto___31286]));

var G__31287 = (i__19568__auto___31286 + (1));
i__19568__auto___31286 = G__31287;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((1) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((1)),(0))):null);
return jkkramer.verily.us_zip.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19575__auto__);
});

jkkramer.verily.us_zip.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__31283){
var vec__31284 = p__31283;
var msg = cljs.core.nth.call(null,vec__31284,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__31284,msg){
return (function (p1__31280_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__31280_SHARP_)) && (cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,p1__31280_SHARP_))) && (cljs.core.not.call(null,cljs.core.re_matches.call(null,jkkramer.verily.zip_regex,p1__31280_SHARP_)));
});})(vec__31284,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return "must be a valid US zip code";
}
})());
});

jkkramer.verily.us_zip.cljs$lang$maxFixedArity = (1);

jkkramer.verily.us_zip.cljs$lang$applyTo = (function (seq31281){
var G__31282 = cljs.core.first.call(null,seq31281);
var seq31281__$1 = cljs.core.next.call(null,seq31281);
return jkkramer.verily.us_zip.cljs$core$IFn$_invoke$arity$variadic(G__31282,seq31281__$1);
});
jkkramer.verily.email = (function jkkramer$verily$email(){
var args__19574__auto__ = [];
var len__19567__auto___31293 = arguments.length;
var i__19568__auto___31294 = (0);
while(true){
if((i__19568__auto___31294 < len__19567__auto___31293)){
args__19574__auto__.push((arguments[i__19568__auto___31294]));

var G__31295 = (i__19568__auto___31294 + (1));
i__19568__auto___31294 = G__31295;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((1) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((1)),(0))):null);
return jkkramer.verily.email.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19575__auto__);
});

jkkramer.verily.email.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__31291){
var vec__31292 = p__31291;
var msg = cljs.core.nth.call(null,vec__31292,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__31292,msg){
return (function (p1__31288_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__31288_SHARP_)) && (cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,p1__31288_SHARP_))) && (cljs.core.not.call(null,cljs.core.re_matches.call(null,/[^^]+@[^$]+/,p1__31288_SHARP_)));
});})(vec__31292,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return "must be a valid email";
}
})());
});

jkkramer.verily.email.cljs$lang$maxFixedArity = (1);

jkkramer.verily.email.cljs$lang$applyTo = (function (seq31289){
var G__31290 = cljs.core.first.call(null,seq31289);
var seq31289__$1 = cljs.core.next.call(null,seq31289);
return jkkramer.verily.email.cljs$core$IFn$_invoke$arity$variadic(G__31290,seq31289__$1);
});
jkkramer.verily.web_url = (function jkkramer$verily$web_url(){
var args__19574__auto__ = [];
var len__19567__auto___31305 = arguments.length;
var i__19568__auto___31306 = (0);
while(true){
if((i__19568__auto___31306 < len__19567__auto___31305)){
args__19574__auto__.push((arguments[i__19568__auto___31306]));

var G__31307 = (i__19568__auto___31306 + (1));
i__19568__auto___31306 = G__31307;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((1) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((1)),(0))):null);
return jkkramer.verily.web_url.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19575__auto__);
});

jkkramer.verily.web_url.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__31299){
var vec__31300 = p__31299;
var msg = cljs.core.nth.call(null,vec__31300,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__31300,msg){
return (function (p1__31296_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__31296_SHARP_)) && (cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,p1__31296_SHARP_))) && ((cljs.core.not.call(null,(function (){try{return true;
}catch (e31304){if((e31304 instanceof Error)){
var _ = e31304;
return null;
} else {
throw e31304;

}
}})())) || (cljs.core.not.call(null,cljs.core.re_find.call(null,/^https?:\/\//,p1__31296_SHARP_))));
});})(vec__31300,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return "must be a valid website URL";
}
})());
});

jkkramer.verily.web_url.cljs$lang$maxFixedArity = (1);

jkkramer.verily.web_url.cljs$lang$applyTo = (function (seq31297){
var G__31298 = cljs.core.first.call(null,seq31297);
var seq31297__$1 = cljs.core.next.call(null,seq31297);
return jkkramer.verily.web_url.cljs$core$IFn$_invoke$arity$variadic(G__31298,seq31297__$1);
});
jkkramer.verily.url = (function jkkramer$verily$url(){
var args__19574__auto__ = [];
var len__19567__auto___31315 = arguments.length;
var i__19568__auto___31316 = (0);
while(true){
if((i__19568__auto___31316 < len__19567__auto___31315)){
args__19574__auto__.push((arguments[i__19568__auto___31316]));

var G__31317 = (i__19568__auto___31316 + (1));
i__19568__auto___31316 = G__31317;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((1) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((1)),(0))):null);
return jkkramer.verily.url.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19575__auto__);
});

jkkramer.verily.url.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__31311){
var vec__31312 = p__31311;
var msg = cljs.core.nth.call(null,vec__31312,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__31312,msg){
return (function (p1__31308_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__31308_SHARP_)) && (cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,p1__31308_SHARP_))) && (cljs.core.not.call(null,(function (){try{return cljs.core.re_find.call(null,/^[a-zA-Z]+:\/\//,p1__31308_SHARP_);
}catch (e31314){if((e31314 instanceof Error)){
var _ = e31314;
return null;
} else {
throw e31314;

}
}})()));
});})(vec__31312,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return "must be a valid URL";
}
})());
});

jkkramer.verily.url.cljs$lang$maxFixedArity = (1);

jkkramer.verily.url.cljs$lang$applyTo = (function (seq31309){
var G__31310 = cljs.core.first.call(null,seq31309);
var seq31309__$1 = cljs.core.next.call(null,seq31309);
return jkkramer.verily.url.cljs$core$IFn$_invoke$arity$variadic(G__31310,seq31309__$1);
});
jkkramer.verily.string = (function jkkramer$verily$string(){
var args__19574__auto__ = [];
var len__19567__auto___31323 = arguments.length;
var i__19568__auto___31324 = (0);
while(true){
if((i__19568__auto___31324 < len__19567__auto___31323)){
args__19574__auto__.push((arguments[i__19568__auto___31324]));

var G__31325 = (i__19568__auto___31324 + (1));
i__19568__auto___31324 = G__31325;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((1) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((1)),(0))):null);
return jkkramer.verily.string.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19575__auto__);
});

jkkramer.verily.string.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__31321){
var vec__31322 = p__31321;
var msg = cljs.core.nth.call(null,vec__31322,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__31322,msg){
return (function (p1__31318_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__31318_SHARP_)) && (!((p1__31318_SHARP_ == null))) && (!(typeof p1__31318_SHARP_ === 'string'));
});})(vec__31322,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return "must be a string";
}
})());
});

jkkramer.verily.string.cljs$lang$maxFixedArity = (1);

jkkramer.verily.string.cljs$lang$applyTo = (function (seq31319){
var G__31320 = cljs.core.first.call(null,seq31319);
var seq31319__$1 = cljs.core.next.call(null,seq31319);
return jkkramer.verily.string.cljs$core$IFn$_invoke$arity$variadic(G__31320,seq31319__$1);
});
jkkramer.verily.strings = (function jkkramer$verily$strings(){
var args__19574__auto__ = [];
var len__19567__auto___31331 = arguments.length;
var i__19568__auto___31332 = (0);
while(true){
if((i__19568__auto___31332 < len__19567__auto___31331)){
args__19574__auto__.push((arguments[i__19568__auto___31332]));

var G__31333 = (i__19568__auto___31332 + (1));
i__19568__auto___31332 = G__31333;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((1) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((1)),(0))):null);
return jkkramer.verily.strings.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19575__auto__);
});

jkkramer.verily.strings.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__31329){
var vec__31330 = p__31329;
var msg = cljs.core.nth.call(null,vec__31330,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__31330,msg){
return (function (v){
var and__18516__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),v);
if(and__18516__auto__){
var or__18528__auto__ = (!((v == null))) && (!(cljs.core.sequential_QMARK_.call(null,v)));
if(or__18528__auto__){
return or__18528__auto__;
} else {
return cljs.core.some.call(null,((function (or__18528__auto__,and__18516__auto__,vec__31330,msg){
return (function (p1__31326_SHARP_){
return !(typeof p1__31326_SHARP_ === 'string');
});})(or__18528__auto__,and__18516__auto__,vec__31330,msg))
,v);
}
} else {
return and__18516__auto__;
}
});})(vec__31330,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return "must be strings";
}
})());
});

jkkramer.verily.strings.cljs$lang$maxFixedArity = (1);

jkkramer.verily.strings.cljs$lang$applyTo = (function (seq31327){
var G__31328 = cljs.core.first.call(null,seq31327);
var seq31327__$1 = cljs.core.next.call(null,seq31327);
return jkkramer.verily.strings.cljs$core$IFn$_invoke$arity$variadic(G__31328,seq31327__$1);
});
jkkramer.verily.bool = (function jkkramer$verily$bool(){
var args__19574__auto__ = [];
var len__19567__auto___31339 = arguments.length;
var i__19568__auto___31340 = (0);
while(true){
if((i__19568__auto___31340 < len__19567__auto___31339)){
args__19574__auto__.push((arguments[i__19568__auto___31340]));

var G__31341 = (i__19568__auto___31340 + (1));
i__19568__auto___31340 = G__31341;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((1) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((1)),(0))):null);
return jkkramer.verily.bool.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19575__auto__);
});

jkkramer.verily.bool.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__31337){
var vec__31338 = p__31337;
var msg = cljs.core.nth.call(null,vec__31338,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__31338,msg){
return (function (p1__31334_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__31334_SHARP_)) && (!((p1__31334_SHARP_ == null))) && (!(p1__31334_SHARP_ === true)) && (!(p1__31334_SHARP_ === false));
});})(vec__31338,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return "must be true or false";
}
})());
});

jkkramer.verily.bool.cljs$lang$maxFixedArity = (1);

jkkramer.verily.bool.cljs$lang$applyTo = (function (seq31335){
var G__31336 = cljs.core.first.call(null,seq31335);
var seq31335__$1 = cljs.core.next.call(null,seq31335);
return jkkramer.verily.bool.cljs$core$IFn$_invoke$arity$variadic(G__31336,seq31335__$1);
});
jkkramer.verily.bools = (function jkkramer$verily$bools(){
var args__19574__auto__ = [];
var len__19567__auto___31347 = arguments.length;
var i__19568__auto___31348 = (0);
while(true){
if((i__19568__auto___31348 < len__19567__auto___31347)){
args__19574__auto__.push((arguments[i__19568__auto___31348]));

var G__31349 = (i__19568__auto___31348 + (1));
i__19568__auto___31348 = G__31349;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((1) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((1)),(0))):null);
return jkkramer.verily.bools.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19575__auto__);
});

jkkramer.verily.bools.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__31345){
var vec__31346 = p__31345;
var msg = cljs.core.nth.call(null,vec__31346,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__31346,msg){
return (function (v){
var and__18516__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),v);
if(and__18516__auto__){
var or__18528__auto__ = (!((v == null))) && (!(cljs.core.sequential_QMARK_.call(null,v)));
if(or__18528__auto__){
return or__18528__auto__;
} else {
return cljs.core.some.call(null,((function (or__18528__auto__,and__18516__auto__,vec__31346,msg){
return (function (p1__31342_SHARP_){
return (!(p1__31342_SHARP_ === true)) && (!(p1__31342_SHARP_ === false));
});})(or__18528__auto__,and__18516__auto__,vec__31346,msg))
,v);
}
} else {
return and__18516__auto__;
}
});})(vec__31346,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return "must be all true or false";
}
})());
});

jkkramer.verily.bools.cljs$lang$maxFixedArity = (1);

jkkramer.verily.bools.cljs$lang$applyTo = (function (seq31343){
var G__31344 = cljs.core.first.call(null,seq31343);
var seq31343__$1 = cljs.core.next.call(null,seq31343);
return jkkramer.verily.bools.cljs$core$IFn$_invoke$arity$variadic(G__31344,seq31343__$1);
});
jkkramer.verily.integer = (function jkkramer$verily$integer(){
var args__19574__auto__ = [];
var len__19567__auto___31355 = arguments.length;
var i__19568__auto___31356 = (0);
while(true){
if((i__19568__auto___31356 < len__19567__auto___31355)){
args__19574__auto__.push((arguments[i__19568__auto___31356]));

var G__31357 = (i__19568__auto___31356 + (1));
i__19568__auto___31356 = G__31357;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((1) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((1)),(0))):null);
return jkkramer.verily.integer.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19575__auto__);
});

jkkramer.verily.integer.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__31353){
var vec__31354 = p__31353;
var msg = cljs.core.nth.call(null,vec__31354,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__31354,msg){
return (function (p1__31350_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__31350_SHARP_)) && (!((p1__31350_SHARP_ == null))) && (!(cljs.core.integer_QMARK_.call(null,p1__31350_SHARP_)));
});})(vec__31354,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return "must be a number";
}
})());
});

jkkramer.verily.integer.cljs$lang$maxFixedArity = (1);

jkkramer.verily.integer.cljs$lang$applyTo = (function (seq31351){
var G__31352 = cljs.core.first.call(null,seq31351);
var seq31351__$1 = cljs.core.next.call(null,seq31351);
return jkkramer.verily.integer.cljs$core$IFn$_invoke$arity$variadic(G__31352,seq31351__$1);
});
jkkramer.verily.integers = (function jkkramer$verily$integers(){
var args__19574__auto__ = [];
var len__19567__auto___31363 = arguments.length;
var i__19568__auto___31364 = (0);
while(true){
if((i__19568__auto___31364 < len__19567__auto___31363)){
args__19574__auto__.push((arguments[i__19568__auto___31364]));

var G__31365 = (i__19568__auto___31364 + (1));
i__19568__auto___31364 = G__31365;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((1) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((1)),(0))):null);
return jkkramer.verily.integers.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19575__auto__);
});

jkkramer.verily.integers.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__31361){
var vec__31362 = p__31361;
var msg = cljs.core.nth.call(null,vec__31362,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__31362,msg){
return (function (v){
var and__18516__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),v);
if(and__18516__auto__){
var or__18528__auto__ = (!((v == null))) && (!(cljs.core.sequential_QMARK_.call(null,v)));
if(or__18528__auto__){
return or__18528__auto__;
} else {
return cljs.core.some.call(null,((function (or__18528__auto__,and__18516__auto__,vec__31362,msg){
return (function (p1__31358_SHARP_){
return !(cljs.core.integer_QMARK_.call(null,p1__31358_SHARP_));
});})(or__18528__auto__,and__18516__auto__,vec__31362,msg))
,v);
}
} else {
return and__18516__auto__;
}
});})(vec__31362,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return "must be numbers";
}
})());
});

jkkramer.verily.integers.cljs$lang$maxFixedArity = (1);

jkkramer.verily.integers.cljs$lang$applyTo = (function (seq31359){
var G__31360 = cljs.core.first.call(null,seq31359);
var seq31359__$1 = cljs.core.next.call(null,seq31359);
return jkkramer.verily.integers.cljs$core$IFn$_invoke$arity$variadic(G__31360,seq31359__$1);
});
jkkramer.verily.floating_point = (function jkkramer$verily$floating_point(){
var args__19574__auto__ = [];
var len__19567__auto___31371 = arguments.length;
var i__19568__auto___31372 = (0);
while(true){
if((i__19568__auto___31372 < len__19567__auto___31371)){
args__19574__auto__.push((arguments[i__19568__auto___31372]));

var G__31373 = (i__19568__auto___31372 + (1));
i__19568__auto___31372 = G__31373;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((1) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((1)),(0))):null);
return jkkramer.verily.floating_point.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19575__auto__);
});

jkkramer.verily.floating_point.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__31369){
var vec__31370 = p__31369;
var msg = cljs.core.nth.call(null,vec__31370,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__31370,msg){
return (function (p1__31366_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__31366_SHARP_)) && (!((p1__31366_SHARP_ == null))) && (!(typeof p1__31366_SHARP_ === 'number'));
});})(vec__31370,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return "must be a decimal number";
}
})());
});

jkkramer.verily.floating_point.cljs$lang$maxFixedArity = (1);

jkkramer.verily.floating_point.cljs$lang$applyTo = (function (seq31367){
var G__31368 = cljs.core.first.call(null,seq31367);
var seq31367__$1 = cljs.core.next.call(null,seq31367);
return jkkramer.verily.floating_point.cljs$core$IFn$_invoke$arity$variadic(G__31368,seq31367__$1);
});
jkkramer.verily.floating_points = (function jkkramer$verily$floating_points(){
var args__19574__auto__ = [];
var len__19567__auto___31379 = arguments.length;
var i__19568__auto___31380 = (0);
while(true){
if((i__19568__auto___31380 < len__19567__auto___31379)){
args__19574__auto__.push((arguments[i__19568__auto___31380]));

var G__31381 = (i__19568__auto___31380 + (1));
i__19568__auto___31380 = G__31381;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((1) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((1)),(0))):null);
return jkkramer.verily.floating_points.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19575__auto__);
});

jkkramer.verily.floating_points.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__31377){
var vec__31378 = p__31377;
var msg = cljs.core.nth.call(null,vec__31378,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__31378,msg){
return (function (v){
var and__18516__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),v);
if(and__18516__auto__){
var or__18528__auto__ = (!((v == null))) && (!(cljs.core.sequential_QMARK_.call(null,v)));
if(or__18528__auto__){
return or__18528__auto__;
} else {
return cljs.core.some.call(null,((function (or__18528__auto__,and__18516__auto__,vec__31378,msg){
return (function (p1__31374_SHARP_){
return !(typeof p1__31374_SHARP_ === 'number');
});})(or__18528__auto__,and__18516__auto__,vec__31378,msg))
,v);
}
} else {
return and__18516__auto__;
}
});})(vec__31378,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return "must be decimal numbers";
}
})());
});

jkkramer.verily.floating_points.cljs$lang$maxFixedArity = (1);

jkkramer.verily.floating_points.cljs$lang$applyTo = (function (seq31375){
var G__31376 = cljs.core.first.call(null,seq31375);
var seq31375__$1 = cljs.core.next.call(null,seq31375);
return jkkramer.verily.floating_points.cljs$core$IFn$_invoke$arity$variadic(G__31376,seq31375__$1);
});
jkkramer.verily.decimal_str_QMARK_ = (function jkkramer$verily$decimal_str_QMARK_(x){
var and__18516__auto__ = typeof x === 'string';
if(and__18516__auto__){
return cljs.core.re_matches.call(null,/[0-9\.]+/,x);
} else {
return and__18516__auto__;
}
});
jkkramer.verily.decimal = (function jkkramer$verily$decimal(){
var args__19574__auto__ = [];
var len__19567__auto___31387 = arguments.length;
var i__19568__auto___31388 = (0);
while(true){
if((i__19568__auto___31388 < len__19567__auto___31387)){
args__19574__auto__.push((arguments[i__19568__auto___31388]));

var G__31389 = (i__19568__auto___31388 + (1));
i__19568__auto___31388 = G__31389;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((1) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((1)),(0))):null);
return jkkramer.verily.decimal.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19575__auto__);
});

jkkramer.verily.decimal.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__31385){
var vec__31386 = p__31385;
var msg = cljs.core.nth.call(null,vec__31386,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__31386,msg){
return (function (p1__31382_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__31382_SHARP_)) && (!((p1__31382_SHARP_ == null))) && (cljs.core.not.call(null,jkkramer.verily.decimal_str_QMARK_.call(null,p1__31382_SHARP_)));
});})(vec__31386,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return "must be a decimal number";
}
})());
});

jkkramer.verily.decimal.cljs$lang$maxFixedArity = (1);

jkkramer.verily.decimal.cljs$lang$applyTo = (function (seq31383){
var G__31384 = cljs.core.first.call(null,seq31383);
var seq31383__$1 = cljs.core.next.call(null,seq31383);
return jkkramer.verily.decimal.cljs$core$IFn$_invoke$arity$variadic(G__31384,seq31383__$1);
});
jkkramer.verily.decimals = (function jkkramer$verily$decimals(){
var args__19574__auto__ = [];
var len__19567__auto___31395 = arguments.length;
var i__19568__auto___31396 = (0);
while(true){
if((i__19568__auto___31396 < len__19567__auto___31395)){
args__19574__auto__.push((arguments[i__19568__auto___31396]));

var G__31397 = (i__19568__auto___31396 + (1));
i__19568__auto___31396 = G__31397;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((1) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((1)),(0))):null);
return jkkramer.verily.decimals.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19575__auto__);
});

jkkramer.verily.decimals.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__31393){
var vec__31394 = p__31393;
var msg = cljs.core.nth.call(null,vec__31394,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__31394,msg){
return (function (v){
var and__18516__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),v);
if(and__18516__auto__){
var or__18528__auto__ = (!((v == null))) && (!(cljs.core.sequential_QMARK_.call(null,v)));
if(or__18528__auto__){
return or__18528__auto__;
} else {
return cljs.core.some.call(null,((function (or__18528__auto__,and__18516__auto__,vec__31394,msg){
return (function (p1__31390_SHARP_){
return cljs.core.not.call(null,jkkramer.verily.decimal_str_QMARK_.call(null,p1__31390_SHARP_));
});})(or__18528__auto__,and__18516__auto__,vec__31394,msg))
,v);
}
} else {
return and__18516__auto__;
}
});})(vec__31394,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return "must be decimal numbers";
}
})());
});

jkkramer.verily.decimals.cljs$lang$maxFixedArity = (1);

jkkramer.verily.decimals.cljs$lang$applyTo = (function (seq31391){
var G__31392 = cljs.core.first.call(null,seq31391);
var seq31391__$1 = cljs.core.next.call(null,seq31391);
return jkkramer.verily.decimals.cljs$core$IFn$_invoke$arity$variadic(G__31392,seq31391__$1);
});
jkkramer.verily.min_val = (function jkkramer$verily$min_val(){
var args__19574__auto__ = [];
var len__19567__auto___31404 = arguments.length;
var i__19568__auto___31405 = (0);
while(true){
if((i__19568__auto___31405 < len__19567__auto___31404)){
args__19574__auto__.push((arguments[i__19568__auto___31405]));

var G__31406 = (i__19568__auto___31405 + (1));
i__19568__auto___31405 = G__31406;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((2) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((2)),(0))):null);
return jkkramer.verily.min_val.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19575__auto__);
});

jkkramer.verily.min_val.cljs$core$IFn$_invoke$arity$variadic = (function (min,keys,p__31402){
var vec__31403 = p__31402;
var msg = cljs.core.nth.call(null,vec__31403,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__31403,msg){
return (function (p1__31398_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__31398_SHARP_)) && (!((p1__31398_SHARP_ == null))) && ((!(typeof p1__31398_SHARP_ === 'number')) || ((min > p1__31398_SHARP_)));
});})(vec__31403,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return [cljs.core.str("cannot be less than "),cljs.core.str(min)].join('');
}
})());
});

jkkramer.verily.min_val.cljs$lang$maxFixedArity = (2);

jkkramer.verily.min_val.cljs$lang$applyTo = (function (seq31399){
var G__31400 = cljs.core.first.call(null,seq31399);
var seq31399__$1 = cljs.core.next.call(null,seq31399);
var G__31401 = cljs.core.first.call(null,seq31399__$1);
var seq31399__$2 = cljs.core.next.call(null,seq31399__$1);
return jkkramer.verily.min_val.cljs$core$IFn$_invoke$arity$variadic(G__31400,G__31401,seq31399__$2);
});
jkkramer.verily.at_least = jkkramer.verily.min_val;
jkkramer.verily.max_val = (function jkkramer$verily$max_val(){
var args__19574__auto__ = [];
var len__19567__auto___31413 = arguments.length;
var i__19568__auto___31414 = (0);
while(true){
if((i__19568__auto___31414 < len__19567__auto___31413)){
args__19574__auto__.push((arguments[i__19568__auto___31414]));

var G__31415 = (i__19568__auto___31414 + (1));
i__19568__auto___31414 = G__31415;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((2) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((2)),(0))):null);
return jkkramer.verily.max_val.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19575__auto__);
});

jkkramer.verily.max_val.cljs$core$IFn$_invoke$arity$variadic = (function (max,keys,p__31411){
var vec__31412 = p__31411;
var msg = cljs.core.nth.call(null,vec__31412,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__31412,msg){
return (function (p1__31407_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__31407_SHARP_)) && (!((p1__31407_SHARP_ == null))) && ((!(typeof p1__31407_SHARP_ === 'number')) || ((max < p1__31407_SHARP_)));
});})(vec__31412,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return [cljs.core.str("cannot be more than "),cljs.core.str(max)].join('');
}
})());
});

jkkramer.verily.max_val.cljs$lang$maxFixedArity = (2);

jkkramer.verily.max_val.cljs$lang$applyTo = (function (seq31408){
var G__31409 = cljs.core.first.call(null,seq31408);
var seq31408__$1 = cljs.core.next.call(null,seq31408);
var G__31410 = cljs.core.first.call(null,seq31408__$1);
var seq31408__$2 = cljs.core.next.call(null,seq31408__$1);
return jkkramer.verily.max_val.cljs$core$IFn$_invoke$arity$variadic(G__31409,G__31410,seq31408__$2);
});
jkkramer.verily.at_most = jkkramer.verily.max_val;
jkkramer.verily.within = (function jkkramer$verily$within(){
var args__19574__auto__ = [];
var len__19567__auto___31423 = arguments.length;
var i__19568__auto___31424 = (0);
while(true){
if((i__19568__auto___31424 < len__19567__auto___31423)){
args__19574__auto__.push((arguments[i__19568__auto___31424]));

var G__31425 = (i__19568__auto___31424 + (1));
i__19568__auto___31424 = G__31425;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((3) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((3)),(0))):null);
return jkkramer.verily.within.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__19575__auto__);
});

jkkramer.verily.within.cljs$core$IFn$_invoke$arity$variadic = (function (min,max,keys,p__31421){
var vec__31422 = p__31421;
var msg = cljs.core.nth.call(null,vec__31422,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__31422,msg){
return (function (p1__31416_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__31416_SHARP_)) && (!((p1__31416_SHARP_ == null))) && ((!(typeof p1__31416_SHARP_ === 'number')) || (((min > p1__31416_SHARP_)) || ((max < p1__31416_SHARP_))));
});})(vec__31422,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return [cljs.core.str("must be within "),cljs.core.str(min),cljs.core.str(" and "),cljs.core.str(max)].join('');
}
})());
});

jkkramer.verily.within.cljs$lang$maxFixedArity = (3);

jkkramer.verily.within.cljs$lang$applyTo = (function (seq31417){
var G__31418 = cljs.core.first.call(null,seq31417);
var seq31417__$1 = cljs.core.next.call(null,seq31417);
var G__31419 = cljs.core.first.call(null,seq31417__$1);
var seq31417__$2 = cljs.core.next.call(null,seq31417__$1);
var G__31420 = cljs.core.first.call(null,seq31417__$2);
var seq31417__$3 = cljs.core.next.call(null,seq31417__$2);
return jkkramer.verily.within.cljs$core$IFn$_invoke$arity$variadic(G__31418,G__31419,G__31420,seq31417__$3);
});
jkkramer.verily.positive = (function jkkramer$verily$positive(){
var args__19574__auto__ = [];
var len__19567__auto___31431 = arguments.length;
var i__19568__auto___31432 = (0);
while(true){
if((i__19568__auto___31432 < len__19567__auto___31431)){
args__19574__auto__.push((arguments[i__19568__auto___31432]));

var G__31433 = (i__19568__auto___31432 + (1));
i__19568__auto___31432 = G__31433;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((1) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((1)),(0))):null);
return jkkramer.verily.positive.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19575__auto__);
});

jkkramer.verily.positive.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__31429){
var vec__31430 = p__31429;
var msg = cljs.core.nth.call(null,vec__31430,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__31430,msg){
return (function (p1__31426_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__31426_SHARP_)) && (!((p1__31426_SHARP_ == null))) && ((!(typeof p1__31426_SHARP_ === 'number')) || (!((p1__31426_SHARP_ > (0)))));
});})(vec__31430,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return "must be a positive number";
}
})());
});

jkkramer.verily.positive.cljs$lang$maxFixedArity = (1);

jkkramer.verily.positive.cljs$lang$applyTo = (function (seq31427){
var G__31428 = cljs.core.first.call(null,seq31427);
var seq31427__$1 = cljs.core.next.call(null,seq31427);
return jkkramer.verily.positive.cljs$core$IFn$_invoke$arity$variadic(G__31428,seq31427__$1);
});
jkkramer.verily.negative = (function jkkramer$verily$negative(){
var args__19574__auto__ = [];
var len__19567__auto___31439 = arguments.length;
var i__19568__auto___31440 = (0);
while(true){
if((i__19568__auto___31440 < len__19567__auto___31439)){
args__19574__auto__.push((arguments[i__19568__auto___31440]));

var G__31441 = (i__19568__auto___31440 + (1));
i__19568__auto___31440 = G__31441;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((1) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((1)),(0))):null);
return jkkramer.verily.negative.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19575__auto__);
});

jkkramer.verily.negative.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__31437){
var vec__31438 = p__31437;
var msg = cljs.core.nth.call(null,vec__31438,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__31438,msg){
return (function (p1__31434_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__31434_SHARP_)) && (!((p1__31434_SHARP_ == null))) && ((!(typeof p1__31434_SHARP_ === 'number')) || (!((p1__31434_SHARP_ < (0)))));
});})(vec__31438,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return "must be a negative number";
}
})());
});

jkkramer.verily.negative.cljs$lang$maxFixedArity = (1);

jkkramer.verily.negative.cljs$lang$applyTo = (function (seq31435){
var G__31436 = cljs.core.first.call(null,seq31435);
var seq31435__$1 = cljs.core.next.call(null,seq31435);
return jkkramer.verily.negative.cljs$core$IFn$_invoke$arity$variadic(G__31436,seq31435__$1);
});
jkkramer.verily.date = (function jkkramer$verily$date(){
var args__19574__auto__ = [];
var len__19567__auto___31447 = arguments.length;
var i__19568__auto___31448 = (0);
while(true){
if((i__19568__auto___31448 < len__19567__auto___31447)){
args__19574__auto__.push((arguments[i__19568__auto___31448]));

var G__31449 = (i__19568__auto___31448 + (1));
i__19568__auto___31448 = G__31449;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((1) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((1)),(0))):null);
return jkkramer.verily.date.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19575__auto__);
});

jkkramer.verily.date.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__31445){
var vec__31446 = p__31445;
var msg = cljs.core.nth.call(null,vec__31446,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__31446,msg){
return (function (p1__31442_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__31442_SHARP_)) && (!((p1__31442_SHARP_ == null))) && (!((p1__31442_SHARP_ instanceof Date)));
});})(vec__31446,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return "must be a date";
}
})());
});

jkkramer.verily.date.cljs$lang$maxFixedArity = (1);

jkkramer.verily.date.cljs$lang$applyTo = (function (seq31443){
var G__31444 = cljs.core.first.call(null,seq31443);
var seq31443__$1 = cljs.core.next.call(null,seq31443);
return jkkramer.verily.date.cljs$core$IFn$_invoke$arity$variadic(G__31444,seq31443__$1);
});
jkkramer.verily.dates = (function jkkramer$verily$dates(){
var args__19574__auto__ = [];
var len__19567__auto___31455 = arguments.length;
var i__19568__auto___31456 = (0);
while(true){
if((i__19568__auto___31456 < len__19567__auto___31455)){
args__19574__auto__.push((arguments[i__19568__auto___31456]));

var G__31457 = (i__19568__auto___31456 + (1));
i__19568__auto___31456 = G__31457;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((1) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((1)),(0))):null);
return jkkramer.verily.dates.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19575__auto__);
});

jkkramer.verily.dates.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__31453){
var vec__31454 = p__31453;
var msg = cljs.core.nth.call(null,vec__31454,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__31454,msg){
return (function (v){
var and__18516__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),v);
if(and__18516__auto__){
var or__18528__auto__ = (!((v == null))) && (!(cljs.core.sequential_QMARK_.call(null,v)));
if(or__18528__auto__){
return or__18528__auto__;
} else {
return cljs.core.some.call(null,((function (or__18528__auto__,and__18516__auto__,vec__31454,msg){
return (function (p1__31450_SHARP_){
return !((p1__31450_SHARP_ instanceof Date));
});})(or__18528__auto__,and__18516__auto__,vec__31454,msg))
,v);
}
} else {
return and__18516__auto__;
}
});})(vec__31454,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return "must be dates";
}
})());
});

jkkramer.verily.dates.cljs$lang$maxFixedArity = (1);

jkkramer.verily.dates.cljs$lang$applyTo = (function (seq31451){
var G__31452 = cljs.core.first.call(null,seq31451);
var seq31451__$1 = cljs.core.next.call(null,seq31451);
return jkkramer.verily.dates.cljs$core$IFn$_invoke$arity$variadic(G__31452,seq31451__$1);
});
jkkramer.verily.after_QMARK_ = (function jkkramer$verily$after_QMARK_(d1,d2){
return (d2 < d1);
});
jkkramer.verily.after = (function jkkramer$verily$after(){
var args__19574__auto__ = [];
var len__19567__auto___31464 = arguments.length;
var i__19568__auto___31465 = (0);
while(true){
if((i__19568__auto___31465 < len__19567__auto___31464)){
args__19574__auto__.push((arguments[i__19568__auto___31465]));

var G__31466 = (i__19568__auto___31465 + (1));
i__19568__auto___31465 = G__31466;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((2) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((2)),(0))):null);
return jkkramer.verily.after.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19575__auto__);
});

jkkramer.verily.after.cljs$core$IFn$_invoke$arity$variadic = (function (date,keys,p__31462){
var vec__31463 = p__31462;
var msg = cljs.core.nth.call(null,vec__31463,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__31463,msg){
return (function (p1__31458_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__31458_SHARP_)) && (!((p1__31458_SHARP_ == null))) && ((!((p1__31458_SHARP_ instanceof Date))) || (cljs.core.not.call(null,jkkramer.verily.after_QMARK_.call(null,p1__31458_SHARP_,date))));
});})(vec__31463,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return [cljs.core.str("must be after "),cljs.core.str(date)].join('');
}
})());
});

jkkramer.verily.after.cljs$lang$maxFixedArity = (2);

jkkramer.verily.after.cljs$lang$applyTo = (function (seq31459){
var G__31460 = cljs.core.first.call(null,seq31459);
var seq31459__$1 = cljs.core.next.call(null,seq31459);
var G__31461 = cljs.core.first.call(null,seq31459__$1);
var seq31459__$2 = cljs.core.next.call(null,seq31459__$1);
return jkkramer.verily.after.cljs$core$IFn$_invoke$arity$variadic(G__31460,G__31461,seq31459__$2);
});
jkkramer.verily.before_QMARK_ = (function jkkramer$verily$before_QMARK_(d1,d2){
return (d1 < d2);
});
jkkramer.verily.before = (function jkkramer$verily$before(){
var args__19574__auto__ = [];
var len__19567__auto___31473 = arguments.length;
var i__19568__auto___31474 = (0);
while(true){
if((i__19568__auto___31474 < len__19567__auto___31473)){
args__19574__auto__.push((arguments[i__19568__auto___31474]));

var G__31475 = (i__19568__auto___31474 + (1));
i__19568__auto___31474 = G__31475;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((2) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((2)),(0))):null);
return jkkramer.verily.before.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19575__auto__);
});

jkkramer.verily.before.cljs$core$IFn$_invoke$arity$variadic = (function (date,keys,p__31471){
var vec__31472 = p__31471;
var msg = cljs.core.nth.call(null,vec__31472,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__31472,msg){
return (function (p1__31467_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__31467_SHARP_)) && (!((p1__31467_SHARP_ == null))) && ((!((p1__31467_SHARP_ instanceof Date))) || (cljs.core.not.call(null,jkkramer.verily.before_QMARK_.call(null,p1__31467_SHARP_,date))));
});})(vec__31472,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return [cljs.core.str("must be before "),cljs.core.str(date)].join('');
}
})());
});

jkkramer.verily.before.cljs$lang$maxFixedArity = (2);

jkkramer.verily.before.cljs$lang$applyTo = (function (seq31468){
var G__31469 = cljs.core.first.call(null,seq31468);
var seq31468__$1 = cljs.core.next.call(null,seq31468);
var G__31470 = cljs.core.first.call(null,seq31468__$1);
var seq31468__$2 = cljs.core.next.call(null,seq31468__$1);
return jkkramer.verily.before.cljs$core$IFn$_invoke$arity$variadic(G__31469,G__31470,seq31468__$2);
});
jkkramer.verily.digits = (function jkkramer$verily$digits(n){
return cljs.core.map.call(null,(function (p1__31476_SHARP_){
return (p1__31476_SHARP_.charCodeAt((0)) - (48));
}),[cljs.core.str(n)].join(''));
});
jkkramer.verily.luhn_QMARK_ = (function jkkramer$verily$luhn_QMARK_(x){
var n = ((typeof x === 'string')?clojure.string.replace.call(null,x,/[^0-9]/,""):x);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,cljs.core.map.call(null,((function (n){
return (function (d,idx){
if(cljs.core.even_QMARK_.call(null,idx)){
return cljs.core.reduce.call(null,cljs.core._PLUS_,jkkramer.verily.digits.call(null,(d * (2))));
} else {
return d;
}
});})(n))
,cljs.core.reverse.call(null,jkkramer.verily.digits.call(null,n)),cljs.core.iterate.call(null,cljs.core.inc,(1))));
return (cljs.core.mod.call(null,sum,(10)) === (0));
});
jkkramer.verily.luhn = (function jkkramer$verily$luhn(){
var args__19574__auto__ = [];
var len__19567__auto___31482 = arguments.length;
var i__19568__auto___31483 = (0);
while(true){
if((i__19568__auto___31483 < len__19567__auto___31482)){
args__19574__auto__.push((arguments[i__19568__auto___31483]));

var G__31484 = (i__19568__auto___31483 + (1));
i__19568__auto___31483 = G__31484;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((1) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((1)),(0))):null);
return jkkramer.verily.luhn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19575__auto__);
});

jkkramer.verily.luhn.cljs$core$IFn$_invoke$arity$variadic = (function (keys,p__31480){
var vec__31481 = p__31480;
var msg = cljs.core.nth.call(null,vec__31481,(0),null);
return jkkramer.verily.make_validator.call(null,keys,((function (vec__31481,msg){
return (function (p1__31477_SHARP_){
return (cljs.core.not_EQ_.call(null,new cljs.core.Keyword("jkkramer.verily","absent","jkkramer.verily/absent",-222257708),p1__31477_SHARP_)) && (!((p1__31477_SHARP_ == null))) && (cljs.core.not.call(null,jkkramer.verily.luhn_QMARK_.call(null,p1__31477_SHARP_)));
});})(vec__31481,msg))
,(function (){var or__18528__auto__ = msg;
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return "number is not valid";
}
})());
});

jkkramer.verily.luhn.cljs$lang$maxFixedArity = (1);

jkkramer.verily.luhn.cljs$lang$applyTo = (function (seq31478){
var G__31479 = cljs.core.first.call(null,seq31478);
var seq31478__$1 = cljs.core.next.call(null,seq31478);
return jkkramer.verily.luhn.cljs$core$IFn$_invoke$arity$variadic(G__31479,seq31478__$1);
});
jkkramer.verily.combine = (function jkkramer$verily$combine(){
var args__19574__auto__ = [];
var len__19567__auto___31487 = arguments.length;
var i__19568__auto___31488 = (0);
while(true){
if((i__19568__auto___31488 < len__19567__auto___31487)){
args__19574__auto__.push((arguments[i__19568__auto___31488]));

var G__31489 = (i__19568__auto___31488 + (1));
i__19568__auto___31488 = G__31489;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((0) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((0)),(0))):null);
return jkkramer.verily.combine.cljs$core$IFn$_invoke$arity$variadic(argseq__19575__auto__);
});

jkkramer.verily.combine.cljs$core$IFn$_invoke$arity$variadic = (function (validators){
return (function (m){
return cljs.core.apply.call(null,cljs.core.concat,cljs.core.map.call(null,jkkramer.verily.seqify,cljs.core.keep.call(null,(function (p1__31485_SHARP_){
return p1__31485_SHARP_.call(null,m);
}),validators)));
});
});

jkkramer.verily.combine.cljs$lang$maxFixedArity = (0);

jkkramer.verily.combine.cljs$lang$applyTo = (function (seq31486){
return jkkramer.verily.combine.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq31486));
});
jkkramer.verily.validations_map = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"booleans","booleans",-883685439),new cljs.core.Keyword(null,"email","email",1415816706),new cljs.core.Keyword(null,"date","date",-1463434462),new cljs.core.Keyword(null,"max-length","max-length",-254826109),new cljs.core.Keyword(null,"decimals","decimals",1715096484),new cljs.core.Keyword(null,"contains","contains",676899812),new cljs.core.Keyword(null,"min-length","min-length",-325792315),new cljs.core.Keyword(null,"dates","dates",-1600154075),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"integers","integers",1109066438),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"us-zip","us-zip",99525255),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"strings","strings",-2055406807),new cljs.core.Keyword(null,"luhn","luhn",2107621225),new cljs.core.Keyword(null,"positive","positive",1112941866),new cljs.core.Keyword(null,"negative","negative",-1562068438),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"at-least","at-least",267196846),new cljs.core.Keyword(null,"matches","matches",635497998),new cljs.core.Keyword(null,"floating-points","floating-points",1367959567),new cljs.core.Keyword(null,"bigints","bigints",508771281),new cljs.core.Keyword(null,"floating-point","floating-point",164663314),new cljs.core.Keyword(null,"integer","integer",-604721710),new cljs.core.Keyword(null,"after","after",594996914),new cljs.core.Keyword(null,"str","str",1089608819),new cljs.core.Keyword(null,"exact","exact",1438022323),new cljs.core.Keyword(null,"bools","bools",1248415956),new cljs.core.Keyword(null,"decimal","decimal",-170212044),new cljs.core.Keyword(null,"ints","ints",893195924),new cljs.core.Keyword(null,"max-val","max-val",-1492247884),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"within","within",-76827465),new cljs.core.Keyword(null,"every-in","every-in",929753720),new cljs.core.Keyword(null,"complete","complete",-500388775),new cljs.core.Keyword(null,"bool","bool",1444635321),new cljs.core.Keyword(null,"equal","equal",-1921681350),new cljs.core.Keyword(null,"before","before",-1633692388),new cljs.core.Keyword(null,"web-url","web-url",601349660),new cljs.core.Keyword(null,"not-blank","not-blank",-661874020),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"at-most","at-most",34804861),new cljs.core.Keyword(null,"strs","strs",1175537277),new cljs.core.Keyword(null,"required","required",1807647006),new cljs.core.Keyword(null,"min-val","min-val",-243137826),new cljs.core.Keyword(null,"floats","floats",-1126940417),new cljs.core.Keyword(null,"in","in",-1531184865)],[jkkramer.verily.bools,jkkramer.verily.email,jkkramer.verily.date,jkkramer.verily.max_length,jkkramer.verily.decimals,jkkramer.verily.contains,jkkramer.verily.min_length,jkkramer.verily.dates,jkkramer.verily.integer,jkkramer.verily.integers,jkkramer.verily.decimal,jkkramer.verily.us_zip,jkkramer.verily.floating_point,jkkramer.verily.strings,jkkramer.verily.luhn,jkkramer.verily.positive,jkkramer.verily.negative,jkkramer.verily.string,jkkramer.verily.at_least,jkkramer.verily.matches,jkkramer.verily.floating_points,jkkramer.verily.decimals,jkkramer.verily.floating_point,jkkramer.verily.integer,jkkramer.verily.after,jkkramer.verily.string,jkkramer.verily.exact,jkkramer.verily.bools,jkkramer.verily.decimal,jkkramer.verily.integers,jkkramer.verily.max_val,jkkramer.verily.url,jkkramer.verily.within,jkkramer.verily.every_in,jkkramer.verily.complete,jkkramer.verily.bool,jkkramer.verily.equal,jkkramer.verily.before,jkkramer.verily.web_url,jkkramer.verily.not_blank,jkkramer.verily.bool,jkkramer.verily.at_most,jkkramer.verily.strings,jkkramer.verily.required,jkkramer.verily.min_val,jkkramer.verily.floating_points,jkkramer.verily.in$]);
if(typeof jkkramer.verily.validation__GT_fn !== 'undefined'){
} else {
jkkramer.verily.validation__GT_fn = (function (){var method_table__19422__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__19423__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__19424__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__19425__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__19426__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"jkkramer.verily","validation->fn"),((function (method_table__19422__auto__,prefer_table__19423__auto__,method_cache__19424__auto__,cached_hierarchy__19425__auto__,hierarchy__19426__auto__){
return (function (vspec){
return cljs.core.first.call(null,vspec);
});})(method_table__19422__auto__,prefer_table__19423__auto__,method_cache__19424__auto__,cached_hierarchy__19425__auto__,hierarchy__19426__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__19426__auto__,method_table__19422__auto__,prefer_table__19423__auto__,method_cache__19424__auto__,cached_hierarchy__19425__auto__));
})();
}
cljs.core._add_method.call(null,jkkramer.verily.validation__GT_fn,new cljs.core.Keyword(null,"default","default",-1987822328),(function (vspec){
var temp__4423__auto__ = cljs.core.get.call(null,jkkramer.verily.validations_map,cljs.core.first.call(null,vspec));
if(cljs.core.truth_(temp__4423__auto__)){
var vfn = temp__4423__auto__;
return cljs.core.apply.call(null,vfn,cljs.core.rest.call(null,vspec));
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str("Unknown validation "),cljs.core.str(cljs.core.first.call(null,vspec))].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"vspec","vspec",-1158741640),cljs.core.first.call(null,vspec)], null));
}
}));
jkkramer.verily.validations__GT_fn = (function jkkramer$verily$validations__GT_fn(validations){
return cljs.core.apply.call(null,jkkramer.verily.combine,cljs.core.map.call(null,jkkramer.verily.validation__GT_fn,validations));
});
jkkramer.verily.validate = (function jkkramer$verily$validate(values,validations){
return jkkramer.verily.validations__GT_fn.call(null,validations).call(null,values);
});

//# sourceMappingURL=verily.js.map