// Compiled by ClojureScript 1.7.48 {}
goog.provide('dragonmark.inputs.core');
goog.require('cljs.core');
goog.require('dragonmark.inputs.i18n');
goog.require('cljs.core.async.impl.channels');
goog.require('dragonmark.inputs.schemas');
goog.require('dragonmark.inputs.utils');
goog.require('schema.core');
goog.require('sablono.core');
goog.require('dragonmark.inputs.date_utils');
goog.require('jkkramer.verily');
goog.require('cljs.core.async');
goog.require('schema.coerce');
goog.require('dragonmark.inputs.validation');
goog.require('dragonmark.inputs.extern');
goog.require('dragonmark.inputs.schema_utils');
goog.require('clojure.string');
goog.require('dragonmark.inputs.typing_controls');
goog.require('goog.events');
cljs.core.enable_console_print_BANG_.call(null);
/**
 * Get value from an event
 */
dragonmark.inputs.core.e_value = (function dragonmark$inputs$core$e_value(e){
return e.target.value;
});
/**
 * Get the checked status of a checkbox.
 */
dragonmark.inputs.core.e_checked = (function dragonmark$inputs$core$e_checked(e){
return e.target.checked;
});
dragonmark.inputs.core.styles = (function dragonmark$inputs$core$styles(){
var args__19574__auto__ = [];
var len__19567__auto___26640 = arguments.length;
var i__19568__auto___26641 = (0);
while(true){
if((i__19568__auto___26641 < len__19567__auto___26640)){
args__19574__auto__.push((arguments[i__19568__auto___26641]));

var G__26642 = (i__19568__auto___26641 + (1));
i__19568__auto___26641 = G__26642;
continue;
} else {
}
break;
}

var argseq__19575__auto__ = ((((0) < args__19574__auto__.length))?(new cljs.core.IndexedSeq(args__19574__auto__.slice((0)),(0))):null);
return dragonmark.inputs.core.styles.cljs$core$IFn$_invoke$arity$variadic(argseq__19575__auto__);
});

dragonmark.inputs.core.styles.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return clojure.string.join.call(null," ",args);
});

dragonmark.inputs.core.styles.cljs$lang$maxFixedArity = (0);

dragonmark.inputs.core.styles.cljs$lang$applyTo = (function (seq26639){
return dragonmark.inputs.core.styles.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq26639));
});
if(typeof dragonmark.inputs.core.magic_input !== 'undefined'){
} else {
dragonmark.inputs.core.magic_input = (function (){var method_table__19422__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__19423__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__19424__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__19425__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__19426__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"dragonmark.inputs.core","magic-input"),((function (method_table__19422__auto__,prefer_table__19423__auto__,method_cache__19424__auto__,cached_hierarchy__19425__auto__,hierarchy__19426__auto__){
return (function (p__26643){
var map__26644 = p__26643;
var map__26644__$1 = ((((!((map__26644 == null)))?((((map__26644.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26644.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26644):map__26644);
var opts = cljs.core.get.call(null,map__26644__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
return cljs.core.get_in.call(null,opts,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"type","type",1174270348)], null),dragonmark.inputs.schema_utils.sch_type.call(null,new cljs.core.Keyword(null,"k-sch","k-sch",-193796815).cljs$core$IFn$_invoke$arity$1(opts)));
});})(method_table__19422__auto__,prefer_table__19423__auto__,method_cache__19424__auto__,cached_hierarchy__19425__auto__,hierarchy__19426__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__19426__auto__,method_table__19422__auto__,prefer_table__19423__auto__,method_cache__19424__auto__,cached_hierarchy__19425__auto__));
})();
}
/**
 * Display the i18n label of a select or radio group entry, fall backs to the code.
 */
dragonmark.inputs.core.enum_label = (function dragonmark$inputs$core$enum_label(i18n,code){
return cljs.core.get_in.call(null,i18n,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),code,new cljs.core.Keyword(null,"label","label",1718410804)], null),(((code instanceof cljs.core.Keyword))?dragonmark.inputs.utils.full_name.call(null,code):code));
});
/**
 * Choose if we iterate on the values of the schema enum or on the keys of the i18n data.
 */
dragonmark.inputs.core.choose_iterator = (function dragonmark$inputs$core$choose_iterator(p__26646){
var map__26649 = p__26646;
var map__26649__$1 = ((((!((map__26649 == null)))?((((map__26649.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26649.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26649):map__26649);
var i18n = cljs.core.get.call(null,map__26649__$1,new cljs.core.Keyword(null,"i18n","i18n",-563422499));
var k_sch = cljs.core.get.call(null,map__26649__$1,new cljs.core.Keyword(null,"k-sch","k-sch",-193796815));
var label_order = cljs.core.get.call(null,map__26649__$1,new cljs.core.Keyword(null,"label-order","label-order",113701622));
var temp__4423__auto__ = (function (){var and__18516__auto__ = label_order;
if(cljs.core.truth_(and__18516__auto__)){
return cljs.core.get_in.call(null,i18n,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
} else {
return and__18516__auto__;
}
})();
if(cljs.core.truth_(temp__4423__auto__)){
var data = temp__4423__auto__;
return cljs.core.keys.call(null,data);
} else {
return new cljs.core.Keyword(null,"vs","vs",-2022097090).cljs$core$IFn$_invoke$arity$1(k_sch);
}
});
cljs.core._add_method.call(null,dragonmark.inputs.core.magic_input,"enum",(function (p__26651){
var map__26652 = p__26651;
var map__26652__$1 = ((((!((map__26652 == null)))?((((map__26652.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26652.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26652):map__26652);
var map__26653 = cljs.core.get.call(null,map__26652__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var map__26653__$1 = ((((!((map__26653 == null)))?((((map__26653.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26653.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26653):map__26653);
var options = map__26653__$1;
var attrs = cljs.core.get.call(null,map__26653__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var i18n = cljs.core.get.call(null,map__26653__$1,new cljs.core.Keyword(null,"i18n","i18n",-563422499));
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),attrs,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),""], null),""], null)], null),cljs.core.map.call(null,((function (map__26652,map__26652__$1,map__26653,map__26653__$1,options,attrs,i18n){
return (function (code){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),code], null),dragonmark.inputs.core.enum_label.call(null,i18n,code)], null);
});})(map__26652,map__26652__$1,map__26653,map__26653__$1,options,attrs,i18n))
,dragonmark.inputs.core.choose_iterator.call(null,options)));
}));
dragonmark.inputs.core.radio_group = (function dragonmark$inputs$core$radio_group(style,p__26656){
var map__26661 = p__26656;
var map__26661__$1 = ((((!((map__26661 == null)))?((((map__26661.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26661.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26661):map__26661);
var map__26662 = cljs.core.get.call(null,map__26661__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var map__26662__$1 = ((((!((map__26662 == null)))?((((map__26662.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26662.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26662):map__26662);
var options = map__26662__$1;
var attrs = cljs.core.get.call(null,map__26662__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var k = cljs.core.get.call(null,map__26662__$1,new cljs.core.Keyword(null,"k","k",-2146297393));
var i18n = cljs.core.get.call(null,map__26662__$1,new cljs.core.Keyword(null,"i18n","i18n",-563422499));
var chan = cljs.core.get.call(null,map__26661__$1,new cljs.core.Keyword(null,"chan","chan",-2103021695));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"input-group"], null),cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.map.call(null,((function (map__26661,map__26661__$1,map__26662,map__26662__$1,options,attrs,k,i18n,chan){
return (function (code){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),style], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,attrs,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"checked","checked",-50955819),cljs.core._EQ_.call(null,code,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(attrs)),new cljs.core.Keyword(null,"className","className",-1983287057),"",new cljs.core.Keyword(null,"value","value",305978217),code,new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (map__26661,map__26661__$1,map__26662,map__26662__$1,options,attrs,k,i18n,chan){
return (function (){
cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,code], null));

return null;
});})(map__26661,map__26661__$1,map__26662,map__26662__$1,options,attrs,k,i18n,chan))
], null))], null),dragonmark.inputs.core.enum_label.call(null,i18n,code)], null)], null);
});})(map__26661,map__26661__$1,map__26662,map__26662__$1,options,attrs,k,i18n,chan))
,dragonmark.inputs.core.choose_iterator.call(null,options)))], null);
});
cljs.core._add_method.call(null,dragonmark.inputs.core.magic_input,"radio-group",(function (m){
return dragonmark.inputs.core.radio_group.call(null,"radio",m);
}));
cljs.core._add_method.call(null,dragonmark.inputs.core.magic_input,"radio-group-inline",(function (m){
return dragonmark.inputs.core.radio_group.call(null,"radio-inline",m);
}));
/**
 * HOF, generates a function,  that closes over the value, for segemented control
 */
dragonmark.inputs.core.make_segmented = (function dragonmark$inputs$core$make_segmented(type,k,value,i18n,chan){
return (function (code){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"active","active",1895962068),cljs.core._EQ_.call(null,code,value),new cljs.core.Keyword(null,"className","className",-1983287057),dragonmark.inputs.core.styles.call(null,"btn",((cljs.core._EQ_.call(null,code,value))?"btn-primary":"btn-default")),new cljs.core.Keyword(null,"key","key",-1516042587),[cljs.core.str(dragonmark.inputs.utils.full_name.call(null,k)),cljs.core.str("_"),cljs.core.str(code)].join(''),new cljs.core.Keyword(null,"id","id",-1388402092),[cljs.core.str(dragonmark.inputs.utils.full_name.call(null,k)),cljs.core.str("_"),cljs.core.str(code)].join(''),new cljs.core.Keyword(null,"value","value",305978217),code,new cljs.core.Keyword(null,"onChange","onChange",-312891301),(function (){
return null;
}),new cljs.core.Keyword(null,"onClick","onClick",-1991238530),(function (){
cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,code], null));

cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"validate","validate",-201300827),k], null));

return null;
})], null),dragonmark.inputs.core.enum_label.call(null,i18n,code)], null);
});
});
cljs.core._add_method.call(null,dragonmark.inputs.core.magic_input,"btn-group",(function (p__26665){
var map__26666 = p__26665;
var map__26666__$1 = ((((!((map__26666 == null)))?((((map__26666.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26666.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26666):map__26666);
var map__26667 = cljs.core.get.call(null,map__26666__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var map__26667__$1 = ((((!((map__26667 == null)))?((((map__26667.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26667.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26667):map__26667);
var options = map__26667__$1;
var attrs = cljs.core.get.call(null,map__26667__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var k = cljs.core.get.call(null,map__26667__$1,new cljs.core.Keyword(null,"k","k",-2146297393));
var i18n = cljs.core.get.call(null,map__26667__$1,new cljs.core.Keyword(null,"i18n","i18n",-563422499));
var chan = cljs.core.get.call(null,map__26666__$1,new cljs.core.Keyword(null,"chan","chan",-2103021695));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),cljs.core.merge.call(null,attrs,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"btn-group"], null)),cljs.core.map.call(null,dragonmark.inputs.core.make_segmented.call(null,"button",k,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(attrs),i18n,chan),dragonmark.inputs.core.choose_iterator.call(null,options))], null);
}));
cljs.core._add_method.call(null,dragonmark.inputs.core.magic_input,"range-btn-group",(function (p__26670){
var map__26671 = p__26670;
var map__26671__$1 = ((((!((map__26671 == null)))?((((map__26671.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26671.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26671):map__26671);
var map__26672 = cljs.core.get.call(null,map__26671__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var map__26672__$1 = ((((!((map__26672 == null)))?((((map__26672.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26672.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26672):map__26672);
var attrs = cljs.core.get.call(null,map__26672__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var i18n = cljs.core.get.call(null,map__26672__$1,new cljs.core.Keyword(null,"i18n","i18n",-563422499));
var k = cljs.core.get.call(null,map__26672__$1,new cljs.core.Keyword(null,"k","k",-2146297393));
var chan = cljs.core.get.call(null,map__26671__$1,new cljs.core.Keyword(null,"chan","chan",-2103021695));
var map__26675 = attrs;
var map__26675__$1 = ((((!((map__26675 == null)))?((((map__26675.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26675.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26675):map__26675);
var min = cljs.core.get.call(null,map__26675__$1,new cljs.core.Keyword(null,"min","min",444991522));
var max = cljs.core.get.call(null,map__26675__$1,new cljs.core.Keyword(null,"max","max",61366548));
var step = cljs.core.get.call(null,map__26675__$1,new cljs.core.Keyword(null,"step","step",1288888124),(1));
var value = cljs.core.get.call(null,map__26675__$1,new cljs.core.Keyword(null,"value","value",305978217));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),cljs.core.merge.call(null,attrs,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"btn-group"], null)),cljs.core.map.call(null,dragonmark.inputs.core.make_segmented.call(null,"button",k,value,i18n,chan),cljs.core.range.call(null,(min | (0)),((max | (0)) + (1)),step))], null);
}));
cljs.core._add_method.call(null,dragonmark.inputs.core.magic_input,"stepper",(function (p__26677){
var map__26678 = p__26677;
var map__26678__$1 = ((((!((map__26678 == null)))?((((map__26678.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26678.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26678):map__26678);
var map__26679 = cljs.core.get.call(null,map__26678__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var map__26679__$1 = ((((!((map__26679 == null)))?((((map__26679.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26679.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26679):map__26679);
var attrs = cljs.core.get.call(null,map__26679__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var k = cljs.core.get.call(null,map__26679__$1,new cljs.core.Keyword(null,"k","k",-2146297393));
var chan = cljs.core.get.call(null,map__26678__$1,new cljs.core.Keyword(null,"chan","chan",-2103021695));
var map__26682 = attrs;
var map__26682__$1 = ((((!((map__26682 == null)))?((((map__26682.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26682.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26682):map__26682);
var min = cljs.core.get.call(null,map__26682__$1,new cljs.core.Keyword(null,"min","min",444991522));
var max = cljs.core.get.call(null,map__26682__$1,new cljs.core.Keyword(null,"max","max",61366548));
var step = cljs.core.get.call(null,map__26682__$1,new cljs.core.Keyword(null,"step","step",1288888124));
var value = cljs.core.get.call(null,map__26682__$1,new cljs.core.Keyword(null,"value","value",305978217));
var size = cljs.core.get.call(null,map__26682__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var value__$1 = dragonmark.inputs.utils.__GT_int.call(null,value);
var min__$1 = dragonmark.inputs.utils.__GT_int.call(null,min);
var max__$1 = dragonmark.inputs.utils.__GT_int.call(null,max);
var step__$1 = dragonmark.inputs.utils.__GT_int.call(null,step);
var plus = (cljs.core.truth_(step__$1)?cljs.core.partial.call(null,cljs.core._PLUS_,cljs.core.long$.call(null,step__$1)):cljs.core.inc);
var minus = (cljs.core.truth_(step__$1)?cljs.core.partial.call(null,cljs.core._PLUS_,(- cljs.core.long$.call(null,step__$1))):cljs.core.dec);
var style = dragonmark.inputs.core.styles.call(null,"btn btn-default",(cljs.core.truth_(size)?[cljs.core.str("btn-"),cljs.core.str(size)].join(''):null));
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),cljs.core.merge.call(null,attrs,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"btn-group stepper"], null)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"button",new cljs.core.Keyword(null,"className","className",-1983287057),style,new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (map__26682,map__26682__$1,min,max,step,value,size,value__$1,min__$1,max__$1,step__$1,plus,minus,style,map__26678,map__26678__$1,map__26679,map__26679__$1,attrs,k,chan){
return (function (){
if(cljs.core.truth_((function (){var or__18528__auto__ = (min__$1 == null);
if(or__18528__auto__){
return or__18528__auto__;
} else {
var and__18516__auto__ = min__$1;
if(cljs.core.truth_(and__18516__auto__)){
return ((min__$1 | (0)) <= minus.call(null,value__$1));
} else {
return and__18516__auto__;
}
}
})())){
cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,[cljs.core.str(minus.call(null,value__$1))].join('')], null));

cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"validate","validate",-201300827),k], null));

return null;
} else {
return null;
}
});})(map__26682,map__26682__$1,min,max,step,value,size,value__$1,min__$1,max__$1,step__$1,plus,minus,style,map__26678,map__26678__$1,map__26679,map__26679__$1,attrs,k,chan))
], null),"-"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"className","className",-1983287057),"input-stepper",new cljs.core.Keyword(null,"size","size",1098693007),(cljs.core.truth_(clojure.string.blank_QMARK_.call(null,value__$1))?(1):cljs.core.count.call(null,[cljs.core.str(value__$1)].join(''))),new cljs.core.Keyword(null,"onChange","onChange",-312891301),((function (map__26682,map__26682__$1,min,max,step,value,size,value__$1,min__$1,max__$1,step__$1,plus,minus,style,map__26678,map__26678__$1,map__26679,map__26679__$1,attrs,k,chan){
return (function (){
return null;
});})(map__26682,map__26682__$1,min,max,step,value,size,value__$1,min__$1,max__$1,step__$1,plus,minus,style,map__26678,map__26678__$1,map__26679,map__26679__$1,attrs,k,chan))
,new cljs.core.Keyword(null,"value","value",305978217),value__$1], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"button",new cljs.core.Keyword(null,"className","className",-1983287057),style,new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (map__26682,map__26682__$1,min,max,step,value,size,value__$1,min__$1,max__$1,step__$1,plus,minus,style,map__26678,map__26678__$1,map__26679,map__26679__$1,attrs,k,chan){
return (function (){
if(cljs.core.truth_((function (){var or__18528__auto__ = (max__$1 == null);
if(or__18528__auto__){
return or__18528__auto__;
} else {
var and__18516__auto__ = max__$1;
if(cljs.core.truth_(and__18516__auto__)){
return (plus.call(null,value__$1) <= (max__$1 | (0)));
} else {
return and__18516__auto__;
}
}
})())){
cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,[cljs.core.str(plus.call(null,value__$1))].join('')], null));

cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"validate","validate",-201300827),k], null));

return null;
} else {
return null;
}
});})(map__26682,map__26682__$1,min,max,step,value,size,value__$1,min__$1,max__$1,step__$1,plus,minus,style,map__26678,map__26678__$1,map__26679,map__26679__$1,attrs,k,chan))
], null),"+"], null)], null);
}));
cljs.core._add_method.call(null,dragonmark.inputs.core.magic_input,schema.core.Inst,(function (p__26686){
var map__26687 = p__26686;
var map__26687__$1 = ((((!((map__26687 == null)))?((((map__26687.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26687.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26687):map__26687);
var map__26688 = cljs.core.get.call(null,map__26687__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var map__26688__$1 = ((((!((map__26688 == null)))?((((map__26688.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26688.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26688):map__26688);
var k = cljs.core.get.call(null,map__26688__$1,new cljs.core.Keyword(null,"k","k",-2146297393));
var attrs = cljs.core.get.call(null,map__26688__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var chan = cljs.core.get.call(null,map__26687__$1,new cljs.core.Keyword(null,"chan","chan",-2103021695));
var date = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(attrs);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,attrs,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),dragonmark.inputs.date_utils.default_fmt,new cljs.core.Keyword(null,"value","value",305978217),dragonmark.inputs.date_utils.display_date.call(null,date),new cljs.core.Keyword(null,"onChange","onChange",-312891301),((function (date,map__26687,map__26687__$1,map__26688,map__26688__$1,k,attrs,chan){
return (function (p1__26684_SHARP_){
cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,dragonmark.inputs.core.e_value.call(null,p1__26684_SHARP_)], null));

cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"validate","validate",-201300827),k], null));

return null;
});})(date,map__26687,map__26687__$1,map__26688,map__26688__$1,k,attrs,chan))
,new cljs.core.Keyword(null,"onBlur","onBlur",229342509),((function (date,map__26687,map__26687__$1,map__26688,map__26688__$1,k,attrs,chan){
return (function (p1__26685_SHARP_){
var v = dragonmark.inputs.core.e_value.call(null,p1__26685_SHARP_);
cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,(cljs.core.truth_(clojure.string.blank_QMARK_.call(null,v))?null:dragonmark.inputs.date_utils.parse.call(null,v))], null));

cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"focus","focus",234677911),k], null));

cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"validate","validate",-201300827),k], null));

return null;
});})(date,map__26687,map__26687__$1,map__26688,map__26688__$1,k,attrs,chan))
], null))], null);
}));
cljs.core._add_method.call(null,dragonmark.inputs.core.magic_input,"date",(function (p__26693){
var map__26694 = p__26693;
var map__26694__$1 = ((((!((map__26694 == null)))?((((map__26694.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26694.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26694):map__26694);
var map__26695 = cljs.core.get.call(null,map__26694__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var map__26695__$1 = ((((!((map__26695 == null)))?((((map__26695.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26695.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26695):map__26695);
var k = cljs.core.get.call(null,map__26695__$1,new cljs.core.Keyword(null,"k","k",-2146297393));
var attrs = cljs.core.get.call(null,map__26695__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var chan = cljs.core.get.call(null,map__26694__$1,new cljs.core.Keyword(null,"chan","chan",-2103021695));
var date = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(attrs);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,attrs,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),"date",new cljs.core.Keyword(null,"value","value",305978217),dragonmark.inputs.date_utils.display_date.call(null,"yyyy-MM-dd",date),new cljs.core.Keyword(null,"onChange","onChange",-312891301),((function (date,map__26694,map__26694__$1,map__26695,map__26695__$1,k,attrs,chan){
return (function (p1__26691_SHARP_){
cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,dragonmark.inputs.core.e_value.call(null,p1__26691_SHARP_)], null));

cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"validate","validate",-201300827),k], null));

return null;
});})(date,map__26694,map__26694__$1,map__26695,map__26695__$1,k,attrs,chan))
,new cljs.core.Keyword(null,"onBlur","onBlur",229342509),((function (date,map__26694,map__26694__$1,map__26695,map__26695__$1,k,attrs,chan){
return (function (p1__26692_SHARP_){
var v = dragonmark.inputs.core.e_value.call(null,p1__26692_SHARP_);
cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,(cljs.core.truth_(clojure.string.blank_QMARK_.call(null,v))?null:dragonmark.inputs.date_utils.parse.call(null,"yyyy-MM-dd",v))], null));

cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"focus","focus",234677911),k], null));

cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"validate","validate",-201300827),k], null));

return null;
});})(date,map__26694,map__26694__$1,map__26695,map__26695__$1,k,attrs,chan))
], null))], null);
}));
cljs.core._add_method.call(null,dragonmark.inputs.core.magic_input,schema.core.Bool,(function (p__26699){
var map__26700 = p__26699;
var map__26700__$1 = ((((!((map__26700 == null)))?((((map__26700.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26700.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26700):map__26700);
var map__26701 = cljs.core.get.call(null,map__26700__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var map__26701__$1 = ((((!((map__26701 == null)))?((((map__26701.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26701.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26701):map__26701);
var k = cljs.core.get.call(null,map__26701__$1,new cljs.core.Keyword(null,"k","k",-2146297393));
var attrs = cljs.core.get.call(null,map__26701__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var chan = cljs.core.get.call(null,map__26700__$1,new cljs.core.Keyword(null,"chan","chan",-2103021695));
var value = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(attrs);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,attrs,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"checked","checked",-50955819),Boolean(value),new cljs.core.Keyword(null,"onChange","onChange",-312891301),((function (value,map__26700,map__26700__$1,map__26701,map__26701__$1,k,attrs,chan){
return (function (p1__26698_SHARP_){
cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,p1__26698_SHARP_.target.checked], null));

cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"validate","validate",-201300827),k], null));

return null;
});})(value,map__26700,map__26700__$1,map__26701,map__26701__$1,k,attrs,chan))
,new cljs.core.Keyword(null,"type","type",1174270348),"checkbox"], null))], null);
}));
cljs.core._add_method.call(null,dragonmark.inputs.core.magic_input,"range",(function (p__26704){
var map__26705 = p__26704;
var map__26705__$1 = ((((!((map__26705 == null)))?((((map__26705.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26705.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26705):map__26705);
var map__26706 = cljs.core.get.call(null,map__26705__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var map__26706__$1 = ((((!((map__26706 == null)))?((((map__26706.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26706.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26706):map__26706);
var attrs = cljs.core.get.call(null,map__26706__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),"range"], null),attrs)], null);
}));
cljs.core._add_method.call(null,dragonmark.inputs.core.magic_input,"now",(function (p__26709){
var map__26710 = p__26709;
var map__26710__$1 = ((((!((map__26710 == null)))?((((map__26710.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26710.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26710):map__26710);
var map__26711 = cljs.core.get.call(null,map__26710__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var map__26711__$1 = ((((!((map__26711 == null)))?((((map__26711.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26711.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26711):map__26711);
var attrs = cljs.core.get.call(null,map__26711__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var k = cljs.core.get.call(null,map__26711__$1,new cljs.core.Keyword(null,"k","k",-2146297393));
var chan = cljs.core.get.call(null,map__26710__$1,new cljs.core.Keyword(null,"chan","chan",-2103021695));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,attrs,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),"button",new cljs.core.Keyword(null,"className","className",-1983287057),"btn",new cljs.core.Keyword(null,"preventDefault","preventDefault",-1714933772),true,new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (map__26710,map__26710__$1,map__26711,map__26711__$1,attrs,k,chan){
return (function (){
cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,(new Date())], null));

cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"validate","validate",-201300827),k], null));

return null;
});})(map__26710,map__26710__$1,map__26711,map__26711__$1,attrs,k,chan))
], null))], null);
}));
cljs.core._add_method.call(null,dragonmark.inputs.core.magic_input,"email",(function (p__26714){
var map__26715 = p__26714;
var map__26715__$1 = ((((!((map__26715 == null)))?((((map__26715.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26715.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26715):map__26715);
var map__26716 = cljs.core.get.call(null,map__26715__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var map__26716__$1 = ((((!((map__26716 == null)))?((((map__26716.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26716.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26716):map__26716);
var attrs = cljs.core.get.call(null,map__26716__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"email",new cljs.core.Keyword(null,"autoCapitalize","autoCapitalize",438011742),"off",new cljs.core.Keyword(null,"autoCorrect","autoCorrect",448626584),"off"], null),attrs)], null);
}));
cljs.core._add_method.call(null,dragonmark.inputs.core.magic_input,"password",(function (p__26719){
var map__26720 = p__26719;
var map__26720__$1 = ((((!((map__26720 == null)))?((((map__26720.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26720.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26720):map__26720);
var map__26721 = cljs.core.get.call(null,map__26720__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var map__26721__$1 = ((((!((map__26721 == null)))?((((map__26721.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26721.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26721):map__26721);
var attrs = cljs.core.get.call(null,map__26721__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),"password"], null),attrs)], null);
}));
cljs.core._add_method.call(null,dragonmark.inputs.core.magic_input,new cljs.core.Keyword(null,"default","default",-1987822328),(function (p__26724){
var map__26725 = p__26724;
var map__26725__$1 = ((((!((map__26725 == null)))?((((map__26725.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26725.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26725):map__26725);
var map__26726 = cljs.core.get.call(null,map__26725__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var map__26726__$1 = ((((!((map__26726 == null)))?((((map__26726.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26726.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26726):map__26726);
var attrs = cljs.core.get.call(null,map__26726__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),attrs], null);
}));

dragonmark.inputs.core.Required = {};

dragonmark.inputs.core.required_QMARK_ = (function dragonmark$inputs$core$required_QMARK_(this$){
if((!((this$ == null))) && (!((this$.dragonmark$inputs$core$Required$required_QMARK_$arity$1 == null)))){
return this$.dragonmark$inputs$core$Required$required_QMARK_$arity$1(this$);
} else {
var x__19164__auto__ = (((this$ == null))?null:this$);
var m__19165__auto__ = (dragonmark.inputs.core.required_QMARK_[goog.typeOf(x__19164__auto__)]);
if(!((m__19165__auto__ == null))){
return m__19165__auto__.call(null,this$);
} else {
var m__19165__auto____$1 = (dragonmark.inputs.core.required_QMARK_["_"]);
if(!((m__19165__auto____$1 == null))){
return m__19165__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"Required.required?",this$);
}
}
}
});

schema.core.OptionalKey.prototype.dragonmark$inputs$core$Required$ = true;

schema.core.OptionalKey.prototype.dragonmark$inputs$core$Required$required_QMARK_$arity$1 = (function (this$){
var this$__$1 = this;
return false;
});

schema.core.RequiredKey.prototype.dragonmark$inputs$core$Required$ = true;

schema.core.RequiredKey.prototype.dragonmark$inputs$core$Required$required_QMARK_$arity$1 = (function (this$){
var this$__$1 = this;
return true;
});

cljs.core.Keyword.prototype.dragonmark$inputs$core$Required$ = true;

cljs.core.Keyword.prototype.dragonmark$inputs$core$Required$required_QMARK_$arity$1 = (function (k){
var k__$1 = this;
return true;
});
/**
 * Choose the initial value.
 * s/Num fields must be represented as string because of the typing control.
 * If an initial value is provided for a s/Num it will be represented as a string in the
 * local state.
 */
dragonmark.inputs.core.init_state_value = (function dragonmark$inputs$core$init_state_value(v,t){
var pred__26734 = cljs.core._EQ_;
var expr__26735 = t;
if(cljs.core.truth_(pred__26734.call(null,schema.core.Num,expr__26735))){
return [cljs.core.str(v)].join('');
} else {
return v;
}
});
var ufv___26758 = schema.utils.use_fn_validation;
var output_schema26737_26759 = dragonmark.inputs.schemas.sch_business_state;
var input_schema26738_26760 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"sch","sch",763282093,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"init","init",-234949907,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_schema26743_26761 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"sch","sch",763282093,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker26739_26762 = schema.core.checker.call(null,input_schema26738_26760);
var output_checker26740_26763 = schema.core.checker.call(null,output_schema26737_26759);
var input_checker26744_26764 = schema.core.checker.call(null,input_schema26743_26761);
var output_checker26745_26765 = schema.core.checker.call(null,output_schema26737_26759);
/**
 * Inputs: ([sch init] [sch])
 * Returns: sch-business-state
 * 
 * Build the initial business local state backing the inputs in the form.
 * It accepts init values from the options
 * TODO validate that the value is correct
 */
dragonmark.inputs.core.build_init_state = ((function (ufv___26758,output_schema26737_26759,input_schema26738_26760,input_schema26743_26761,input_checker26739_26762,output_checker26740_26763,input_checker26744_26764,output_checker26745_26765){
return (function dragonmark$inputs$core$build_init_state(){
var args26747 = [];
var len__19567__auto___26766 = arguments.length;
var i__19568__auto___26767 = (0);
while(true){
if((i__19568__auto___26767 < len__19567__auto___26766)){
args26747.push((arguments[i__19568__auto___26767]));

var G__26768 = (i__19568__auto___26767 + (1));
i__19568__auto___26767 = G__26768;
continue;
} else {
}
break;
}

var G__26749 = args26747.length;
switch (G__26749) {
case 2:
return dragonmark.inputs.core.build_init_state.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dragonmark.inputs.core.build_init_state.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26747.length)].join('')));

}
});})(ufv___26758,output_schema26737_26759,input_schema26738_26760,input_schema26743_26761,input_checker26739_26762,output_checker26740_26763,input_checker26744_26764,output_checker26745_26765))
;

dragonmark.inputs.core.build_init_state.cljs$core$IFn$_invoke$arity$2 = ((function (ufv___26758,output_schema26737_26759,input_schema26738_26760,input_schema26743_26761,input_checker26739_26762,output_checker26740_26763,input_checker26744_26764,output_checker26745_26765){
return (function (G__26741,G__26742){
var validate__20921__auto__ = ufv___26758.get_cell();
if(cljs.core.truth_(validate__20921__auto__)){
var args__20922__auto___26770 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__26741,G__26742], null);
var temp__4425__auto___26771 = input_checker26739_26762.call(null,args__20922__auto___26770);
if(cljs.core.truth_(temp__4425__auto___26771)){
var error__20923__auto___26772 = temp__4425__auto___26771;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"build-init-state","build-init-state",980879982,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Build the initial business local state backing the inputs in the form.\n   It accepts init values from the options\n  TODO validate that the value is correct"], null)),cljs.core.pr_str.call(null,error__20923__auto___26772)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema26738_26760,new cljs.core.Keyword(null,"value","value",305978217),args__20922__auto___26770,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___26772], null));
} else {
}
} else {
}

var o__20924__auto__ = (function (){var sch = G__26741;
var init = G__26742;
while(true){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19281__auto__ = ((function (validate__20921__auto__,ufv___26758,output_schema26737_26759,input_schema26738_26760,input_schema26743_26761,input_checker26739_26762,output_checker26740_26763,input_checker26744_26764,output_checker26745_26765){
return (function dragonmark$inputs$core$iter__26750(s__26751){
return (new cljs.core.LazySeq(null,((function (validate__20921__auto__,ufv___26758,output_schema26737_26759,input_schema26738_26760,input_schema26743_26761,input_checker26739_26762,output_checker26740_26763,input_checker26744_26764,output_checker26745_26765){
return (function (){
var s__26751__$1 = s__26751;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__26751__$1);
if(temp__4425__auto__){
var s__26751__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__26751__$2)){
var c__19279__auto__ = cljs.core.chunk_first.call(null,s__26751__$2);
var size__19280__auto__ = cljs.core.count.call(null,c__19279__auto__);
var b__26753 = cljs.core.chunk_buffer.call(null,size__19280__auto__);
if((function (){var i__26752 = (0);
while(true){
if((i__26752 < size__19280__auto__)){
var vec__26756 = cljs.core._nth.call(null,c__19279__auto__,i__26752);
var k = cljs.core.nth.call(null,vec__26756,(0),null);
var t = cljs.core.nth.call(null,vec__26756,(1),null);
var fk = cljs.core.get.call(null,k,new cljs.core.Keyword(null,"k","k",-2146297393),k);
var t__$1 = dragonmark.inputs.schema_utils.sch_type.call(null,t);
var init_val = cljs.core.get.call(null,init,fk,"");
cljs.core.chunk_append.call(null,b__26753,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fk,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),dragonmark.inputs.core.init_state_value.call(null,init_val,t__$1),new cljs.core.Keyword(null,"required","required",1807647006),dragonmark.inputs.core.required_QMARK_.call(null,k),new cljs.core.Keyword(null,"type","type",1174270348),t__$1], null)], null));

var G__26773 = (i__26752 + (1));
i__26752 = G__26773;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__26753),dragonmark$inputs$core$iter__26750.call(null,cljs.core.chunk_rest.call(null,s__26751__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__26753),null);
}
} else {
var vec__26757 = cljs.core.first.call(null,s__26751__$2);
var k = cljs.core.nth.call(null,vec__26757,(0),null);
var t = cljs.core.nth.call(null,vec__26757,(1),null);
var fk = cljs.core.get.call(null,k,new cljs.core.Keyword(null,"k","k",-2146297393),k);
var t__$1 = dragonmark.inputs.schema_utils.sch_type.call(null,t);
var init_val = cljs.core.get.call(null,init,fk,"");
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fk,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),dragonmark.inputs.core.init_state_value.call(null,init_val,t__$1),new cljs.core.Keyword(null,"required","required",1807647006),dragonmark.inputs.core.required_QMARK_.call(null,k),new cljs.core.Keyword(null,"type","type",1174270348),t__$1], null)], null),dragonmark$inputs$core$iter__26750.call(null,cljs.core.rest.call(null,s__26751__$2)));
}
} else {
return null;
}
break;
}
});})(validate__20921__auto__,ufv___26758,output_schema26737_26759,input_schema26738_26760,input_schema26743_26761,input_checker26739_26762,output_checker26740_26763,input_checker26744_26764,output_checker26745_26765))
,null,null));
});})(validate__20921__auto__,ufv___26758,output_schema26737_26759,input_schema26738_26760,input_schema26743_26761,input_checker26739_26762,output_checker26740_26763,input_checker26744_26764,output_checker26745_26765))
;
return iter__19281__auto__.call(null,sch);
})());
break;
}
})();
if(cljs.core.truth_(validate__20921__auto__)){
var temp__4425__auto___26774 = output_checker26740_26763.call(null,o__20924__auto__);
if(cljs.core.truth_(temp__4425__auto___26774)){
var error__20923__auto___26775 = temp__4425__auto___26774;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"build-init-state","build-init-state",980879982,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Build the initial business local state backing the inputs in the form.\n   It accepts init values from the options\n  TODO validate that the value is correct"], null)),cljs.core.pr_str.call(null,error__20923__auto___26775)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema26737_26759,new cljs.core.Keyword(null,"value","value",305978217),o__20924__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___26775], null));
} else {
}
} else {
}

return o__20924__auto__;
});})(ufv___26758,output_schema26737_26759,input_schema26738_26760,input_schema26743_26761,input_checker26739_26762,output_checker26740_26763,input_checker26744_26764,output_checker26745_26765))
;

dragonmark.inputs.core.build_init_state.cljs$core$IFn$_invoke$arity$1 = ((function (ufv___26758,output_schema26737_26759,input_schema26738_26760,input_schema26743_26761,input_checker26739_26762,output_checker26740_26763,input_checker26744_26764,output_checker26745_26765){
return (function (G__26746){
var validate__20921__auto__ = ufv___26758.get_cell();
if(cljs.core.truth_(validate__20921__auto__)){
var args__20922__auto___26776 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__26746], null);
var temp__4425__auto___26777 = input_checker26744_26764.call(null,args__20922__auto___26776);
if(cljs.core.truth_(temp__4425__auto___26777)){
var error__20923__auto___26778 = temp__4425__auto___26777;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"build-init-state","build-init-state",980879982,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Build the initial business local state backing the inputs in the form.\n   It accepts init values from the options\n  TODO validate that the value is correct"], null)),cljs.core.pr_str.call(null,error__20923__auto___26778)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema26743_26761,new cljs.core.Keyword(null,"value","value",305978217),args__20922__auto___26776,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___26778], null));
} else {
}
} else {
}

var o__20924__auto__ = (function (){var sch = G__26746;
while(true){
return dragonmark.inputs.core.build_init_state.call(null,sch,cljs.core.PersistentArrayMap.EMPTY);
break;
}
})();
if(cljs.core.truth_(validate__20921__auto__)){
var temp__4425__auto___26779 = output_checker26745_26765.call(null,o__20924__auto__);
if(cljs.core.truth_(temp__4425__auto___26779)){
var error__20923__auto___26780 = temp__4425__auto___26779;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"build-init-state","build-init-state",980879982,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Build the initial business local state backing the inputs in the form.\n   It accepts init values from the options\n  TODO validate that the value is correct"], null)),cljs.core.pr_str.call(null,error__20923__auto___26780)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema26737_26759,new cljs.core.Keyword(null,"value","value",305978217),o__20924__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___26780], null));
} else {
}
} else {
}

return o__20924__auto__;
});})(ufv___26758,output_schema26737_26759,input_schema26738_26760,input_schema26743_26761,input_checker26739_26762,output_checker26740_26763,input_checker26744_26764,output_checker26745_26765))
;

dragonmark.inputs.core.build_init_state.cljs$lang$maxFixedArity = 2;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.core.build_init_state),schema.core.make_fn_schema.call(null,output_schema26737_26759,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema26738_26760,input_schema26743_26761], null)));
/**
 * Decorate an HTML node with google.ui.inputdatepicker
 */
dragonmark.inputs.core.add_date_picker_BANG_ = (function dragonmark$inputs$core$add_date_picker_BANG_(k,node,chan,f){
var dp = dragonmark.inputs.date_utils.date_picker.call(null,f);
dp.decorate(node);

return goog.events.listen(dp,goog.ui.DatePicker.Events.CHANGE,((function (dp){
return (function (p1__26781_SHARP_){
cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,dragonmark.inputs.date_utils.goog_date__GT_js_date.call(null,p1__26781_SHARP_.date)], null));

cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"validate","validate",-201300827),k], null));

return null;
});})(dp))
);
});
dragonmark.inputs.core.handle_date_fields_BANG_ = (function dragonmark$inputs$core$handle_date_fields_BANG_(owner,f,opts){
var chan = dragonmark.inputs.extern.get_state.call(null,owner,new cljs.core.Keyword(null,"chan","chan",-2103021695));
var state = dragonmark.inputs.extern.get_state.call(null,owner,new cljs.core.Keyword(null,"inputs","inputs",865803858));
var date_fieds = (function (){var iter__19281__auto__ = ((function (chan,state){
return (function dragonmark$inputs$core$handle_date_fields_BANG__$_iter__26802(s__26803){
return (new cljs.core.LazySeq(null,((function (chan,state){
return (function (){
var s__26803__$1 = s__26803;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__26803__$1);
if(temp__4425__auto__){
var s__26803__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__26803__$2)){
var c__19279__auto__ = cljs.core.chunk_first.call(null,s__26803__$2);
var size__19280__auto__ = cljs.core.count.call(null,c__19279__auto__);
var b__26805 = cljs.core.chunk_buffer.call(null,size__19280__auto__);
if((function (){var i__26804 = (0);
while(true){
if((i__26804 < size__19280__auto__)){
var vec__26812 = cljs.core._nth.call(null,c__19279__auto__,i__26804);
var k = cljs.core.nth.call(null,vec__26812,(0),null);
var map__26813 = cljs.core.nth.call(null,vec__26812,(1),null);
var map__26813__$1 = ((((!((map__26813 == null)))?((((map__26813.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26813.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26813):map__26813);
var type = cljs.core.get.call(null,map__26813__$1,new cljs.core.Keyword(null,"type","type",1174270348));
if((cljs.core._EQ_.call(null,schema.core.Inst,type)) && (cljs.core.not.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["date",null,"now",null], null), null).call(null,cljs.core.get_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,new cljs.core.Keyword(null,"type","type",1174270348)], null)))))){
cljs.core.chunk_append.call(null,b__26805,k);

var G__26822 = (i__26804 + (1));
i__26804 = G__26822;
continue;
} else {
var G__26823 = (i__26804 + (1));
i__26804 = G__26823;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__26805),dragonmark$inputs$core$handle_date_fields_BANG__$_iter__26802.call(null,cljs.core.chunk_rest.call(null,s__26803__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__26805),null);
}
} else {
var vec__26815 = cljs.core.first.call(null,s__26803__$2);
var k = cljs.core.nth.call(null,vec__26815,(0),null);
var map__26816 = cljs.core.nth.call(null,vec__26815,(1),null);
var map__26816__$1 = ((((!((map__26816 == null)))?((((map__26816.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26816.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26816):map__26816);
var type = cljs.core.get.call(null,map__26816__$1,new cljs.core.Keyword(null,"type","type",1174270348));
if((cljs.core._EQ_.call(null,schema.core.Inst,type)) && (cljs.core.not.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["date",null,"now",null], null), null).call(null,cljs.core.get_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,new cljs.core.Keyword(null,"type","type",1174270348)], null)))))){
return cljs.core.cons.call(null,k,dragonmark$inputs$core$handle_date_fields_BANG__$_iter__26802.call(null,cljs.core.rest.call(null,s__26803__$2)));
} else {
var G__26824 = cljs.core.rest.call(null,s__26803__$2);
s__26803__$1 = G__26824;
continue;
}
}
} else {
return null;
}
break;
}
});})(chan,state))
,null,null));
});})(chan,state))
;
return iter__19281__auto__.call(null,state);
})();
var seq__26818 = cljs.core.seq.call(null,date_fieds);
var chunk__26819 = null;
var count__26820 = (0);
var i__26821 = (0);
while(true){
if((i__26821 < count__26820)){
var k = cljs.core._nth.call(null,chunk__26819,i__26821);
dragonmark.inputs.core.add_date_picker_BANG_.call(null,k,dragonmark.inputs.extern.get_node.call(null,owner,dragonmark.inputs.utils.full_name.call(null,k)),chan,f);

var G__26825 = seq__26818;
var G__26826 = chunk__26819;
var G__26827 = count__26820;
var G__26828 = (i__26821 + (1));
seq__26818 = G__26825;
chunk__26819 = G__26826;
count__26820 = G__26827;
i__26821 = G__26828;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__26818);
if(temp__4425__auto__){
var seq__26818__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26818__$1)){
var c__19312__auto__ = cljs.core.chunk_first.call(null,seq__26818__$1);
var G__26829 = cljs.core.chunk_rest.call(null,seq__26818__$1);
var G__26830 = c__19312__auto__;
var G__26831 = cljs.core.count.call(null,c__19312__auto__);
var G__26832 = (0);
seq__26818 = G__26829;
chunk__26819 = G__26830;
count__26820 = G__26831;
i__26821 = G__26832;
continue;
} else {
var k = cljs.core.first.call(null,seq__26818__$1);
dragonmark.inputs.core.add_date_picker_BANG_.call(null,k,dragonmark.inputs.extern.get_node.call(null,owner,dragonmark.inputs.utils.full_name.call(null,k)),chan,f);

var G__26833 = cljs.core.next.call(null,seq__26818__$1);
var G__26834 = null;
var G__26835 = (0);
var G__26836 = (0);
seq__26818 = G__26833;
chunk__26819 = G__26834;
count__26820 = G__26835;
i__26821 = G__26836;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Display a tooltip next to the field to inform the user.
 * options :
 * :k the target field
 * :type serves to build the css class tooltip-type
 * :action attach a function when closing the tooltip
 */
dragonmark.inputs.core.tooltip = (function dragonmark$inputs$core$tooltip(app,owner,opts){
var the_id = [cljs.core.str(cljs.core.name.call(null,new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(opts))),cljs.core.str("-tooltip")].join('');
return dragonmark.inputs.extern.create_component.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"component-did-mount","component-did-mount",-1126910518),((function (the_id){
return (function (this$){
var tool = document.getElementById(the_id);
var elem = document.getElementById(dragonmark.inputs.utils.full_name.call(null,new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(opts)));
var rect_tool = tool.getBoundingClientRect();
var rect = elem.getBoundingClientRect();
var delta = (0.5 * (rect.height - rect_tool.height));
tool.style.left = [cljs.core.str(((5) + rect.width)),cljs.core.str("px")].join('');

return tool.style.top = [cljs.core.str(delta),cljs.core.str("px")].join('');
});})(the_id))
,new cljs.core.Keyword(null,"render","render",-1408033454),((function (the_id){
return (function (_){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"className","className",-1983287057),dragonmark.inputs.core.styles.call(null,"popover right",[cljs.core.str("popover-"),cljs.core.str(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(opts))].join('')),new cljs.core.Keyword(null,"role","role",-736691072),"alert",new cljs.core.Keyword(null,"id","id",-1388402092),the_id,new cljs.core.Keyword(null,"ref","ref",1289896967),[cljs.core.str(cljs.core.name.call(null,new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(opts))),cljs.core.str("-tooltip")].join('')], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"arrow"], null),""], null),(cljs.core.truth_(new cljs.core.Keyword(null,"title","title",636505583).cljs$core$IFn$_invoke$arity$1(app))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"popover-title"], null),new cljs.core.Keyword(null,"title","title",636505583).cljs$core$IFn$_invoke$arity$1(app)], null):null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"popover-content"], null),new cljs.core.Keyword(null,"mess","mess",530922968).cljs$core$IFn$_invoke$arity$1(app),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"button",new cljs.core.Keyword(null,"className","className",-1983287057),"close",new cljs.core.Keyword(null,"onClick","onClick",-1991238530),new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts)], null),"x"], null)], null)], null);
});})(the_id))
], null));
});
/**
 * Display a dismissable error message
 */
dragonmark.inputs.core.message = (function dragonmark$inputs$core$message(app,owner,m){
return dragonmark.inputs.extern.create_component.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"render","render",-1408033454),(function (this$){
var map__26839 = dragonmark.inputs.extern.get_state.call(null,this$);
var map__26839__$1 = ((((!((map__26839 == null)))?((((map__26839.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26839.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26839):map__26839);
var state = map__26839__$1;
var chan = cljs.core.get.call(null,map__26839__$1,new cljs.core.Keyword(null,"chan","chan",-2103021695));
var mess = cljs.core.get.call(null,map__26839__$1,new cljs.core.Keyword(null,"mess","mess",530922968));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"className","className",-1983287057),"alert alert-danger",new cljs.core.Keyword(null,"role","role",-736691072),"alert"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),"button",new cljs.core.Keyword(null,"className","className",-1983287057),"close",new cljs.core.Keyword(null,"data-dismiss","data-dismiss",-2004576016),"alert",new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (map__26839,map__26839__$1,state,chan,mess){
return (function (){
cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"kill-mess","kill-mess",723475912),new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(m)], null));

return null;
});})(map__26839,map__26839__$1,state,chan,mess))
], null),"x"], null),mess], null);
})], null));
});
/**
 * Display a small description under the label
 */
dragonmark.inputs.core.description = (function dragonmark$inputs$core$description(app,owner,m){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"description"], null),new cljs.core.Keyword(null,"desc","desc",2093485764).cljs$core$IFn$_invoke$arity$1(m)], null);
});
dragonmark.inputs.core.button_view = (function dragonmark$inputs$core$button_view(app,owner,p__26841){
var map__26844 = p__26841;
var map__26844__$1 = ((((!((map__26844 == null)))?((((map__26844.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26844.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26844):map__26844);
var opts = map__26844__$1;
var k = cljs.core.get.call(null,map__26844__$1,new cljs.core.Keyword(null,"k","k",-2146297393));
var labels = cljs.core.get.call(null,map__26844__$1,new cljs.core.Keyword(null,"labels","labels",-626734591));
var comp_name = cljs.core.get.call(null,map__26844__$1,new cljs.core.Keyword(null,"comp-name","comp-name",-474371587));
var attrs = cljs.core.get.call(null,map__26844__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
return dragonmark.inputs.extern.create_component.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"render","render",-1408033454),((function (map__26844,map__26844__$1,opts,k,labels,comp_name,attrs){
return (function (this$){
var state = dragonmark.inputs.extern.get_state.call(null,owner);
var chan_name = cljs.core.keyword.call(null,[cljs.core.str(cljs.core.name.call(null,k)),cljs.core.str("-chan")].join(''));
var chan = dragonmark.inputs.extern.get_state.call(null,owner,chan_name);
var button_state = cljs.core.get_in.call(null,state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"action-state","action-state",-1575944631),k], null));
var btn_style = (cljs.core.truth_(button_state)?cljs.core.name.call(null,button_state):null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),cljs.core.merge.call(null,attrs,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"button",new cljs.core.Keyword(null,"id","id",-1388402092),[cljs.core.str(dragonmark.inputs.utils.full_name.call(null,comp_name)),cljs.core.str("-"),cljs.core.str(cljs.core.name.call(null,k))].join(''),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),cljs.core.boolean$.call(null,btn_style),new cljs.core.Keyword(null,"className","className",-1983287057),dragonmark.inputs.core.styles.call(null,"btn btn-primary has-spinner has-error",btn_style),new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (state,chan_name,chan,button_state,btn_style,map__26844,map__26844__$1,opts,k,labels,comp_name,attrs){
return (function (){
cljs.core.async.put_BANG_.call(null,chan,k);

return null;
});})(state,chan_name,chan,button_state,btn_style,map__26844,map__26844__$1,opts,k,labels,comp_name,attrs))
], null)),dragonmark.inputs.i18n.label.call(null,labels,k,opts),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"error"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i","i",-1386841315),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"fa fa-ban text-danger"], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"spinner"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i","i",-1386841315),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"fa fa-spin fa-cog"], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"description"], null),new cljs.core.Keyword(null,"desc","desc",2093485764).cljs$core$IFn$_invoke$arity$1(labels)], null)], null);
});})(map__26844,map__26844__$1,opts,k,labels,comp_name,attrs))
], null));
});
var ufv___26853 = schema.utils.use_fn_validation;
var output_schema26846_26854 = schema.core.Any;
var input_schema26847_26855 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"m","m",-1021758608,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null))),schema.core.one.call(null,schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one.call(null,schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)))], null);
var input_checker26848_26856 = schema.core.checker.call(null,input_schema26847_26855);
var output_checker26849_26857 = schema.core.checker.call(null,output_schema26846_26854);
/**
 * Inputs: [m :- sch-business-state f :- s/Keyword k :- s/Keyword]
 */
dragonmark.inputs.core.get_in_bs = ((function (ufv___26853,output_schema26846_26854,input_schema26847_26855,input_checker26848_26856,output_checker26849_26857){
return (function dragonmark$inputs$core$get_in_bs(G__26850,G__26851,G__26852){
var validate__20921__auto__ = ufv___26853.get_cell();
if(cljs.core.truth_(validate__20921__auto__)){
var args__20922__auto___26858 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__26850,G__26851,G__26852], null);
var temp__4425__auto___26859 = input_checker26848_26856.call(null,args__20922__auto___26858);
if(cljs.core.truth_(temp__4425__auto___26859)){
var error__20923__auto___26860 = temp__4425__auto___26859;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"get-in-bs","get-in-bs",-1499000109,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)),cljs.core.pr_str.call(null,error__20923__auto___26860)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema26847_26855,new cljs.core.Keyword(null,"value","value",305978217),args__20922__auto___26858,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___26860], null));
} else {
}
} else {
}

var o__20924__auto__ = (function (){var m = G__26850;
var f = G__26851;
var k = G__26852;
while(true){
return cljs.core.get_in.call(null,m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,k], null));
break;
}
})();
if(cljs.core.truth_(validate__20921__auto__)){
var temp__4425__auto___26861 = output_checker26849_26857.call(null,o__20924__auto__);
if(cljs.core.truth_(temp__4425__auto___26861)){
var error__20923__auto___26862 = temp__4425__auto___26861;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"get-in-bs","get-in-bs",-1499000109,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)),cljs.core.pr_str.call(null,error__20923__auto___26862)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema26846_26854,new cljs.core.Keyword(null,"value","value",305978217),o__20924__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___26862], null));
} else {
}
} else {
}

return o__20924__auto__;
});})(ufv___26853,output_schema26846_26854,input_schema26847_26855,input_checker26848_26856,output_checker26849_26857))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.core.get_in_bs),schema.core.make_fn_schema.call(null,output_schema26846_26854,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema26847_26855], null)));
var ufv___26869 = schema.utils.use_fn_validation;
var output_schema26863_26870 = schema.core.Any;
var input_schema26864_26871 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"m","m",-1021758608,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker26865_26872 = schema.core.checker.call(null,input_schema26864_26871);
var output_checker26866_26873 = schema.core.checker.call(null,output_schema26863_26870);
/**
 * Inputs: [m k]
 * Returns: s/Any
 */
dragonmark.inputs.core.fvalue = ((function (ufv___26869,output_schema26863_26870,input_schema26864_26871,input_checker26865_26872,output_checker26866_26873){
return (function dragonmark$inputs$core$fvalue(G__26867,G__26868){
var validate__20921__auto__ = ufv___26869.get_cell();
if(cljs.core.truth_(validate__20921__auto__)){
var args__20922__auto___26874 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__26867,G__26868], null);
var temp__4425__auto___26875 = input_checker26865_26872.call(null,args__20922__auto___26874);
if(cljs.core.truth_(temp__4425__auto___26875)){
var error__20923__auto___26876 = temp__4425__auto___26875;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"fvalue","fvalue",-1480770053,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)),cljs.core.pr_str.call(null,error__20923__auto___26876)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema26864_26871,new cljs.core.Keyword(null,"value","value",305978217),args__20922__auto___26874,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___26876], null));
} else {
}
} else {
}

var o__20924__auto__ = (function (){var m = G__26867;
var k = G__26868;
while(true){
return dragonmark.inputs.core.get_in_bs.call(null,m,k,new cljs.core.Keyword(null,"value","value",305978217));
break;
}
})();
if(cljs.core.truth_(validate__20921__auto__)){
var temp__4425__auto___26877 = output_checker26866_26873.call(null,o__20924__auto__);
if(cljs.core.truth_(temp__4425__auto___26877)){
var error__20923__auto___26878 = temp__4425__auto___26877;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"fvalue","fvalue",-1480770053,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)),cljs.core.pr_str.call(null,error__20923__auto___26878)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema26863_26870,new cljs.core.Keyword(null,"value","value",305978217),o__20924__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___26878], null));
} else {
}
} else {
}

return o__20924__auto__;
});})(ufv___26869,output_schema26863_26870,input_schema26864_26871,input_checker26865_26872,output_checker26866_26873))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.core.fvalue),schema.core.make_fn_schema.call(null,output_schema26863_26870,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema26864_26871], null)));
var ufv___26885 = schema.utils.use_fn_validation;
var output_schema26879_26886 = schema.core.maybe.call(null,schema.core.Bool);
var input_schema26880_26887 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"m","m",-1021758608,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker26881_26888 = schema.core.checker.call(null,input_schema26880_26887);
var output_checker26882_26889 = schema.core.checker.call(null,output_schema26879_26886);
/**
 * Inputs: [m k]
 * Returns: (s/maybe s/Bool)
 */
dragonmark.inputs.core.fvalid = ((function (ufv___26885,output_schema26879_26886,input_schema26880_26887,input_checker26881_26888,output_checker26882_26889){
return (function dragonmark$inputs$core$fvalid(G__26883,G__26884){
var validate__20921__auto__ = ufv___26885.get_cell();
if(cljs.core.truth_(validate__20921__auto__)){
var args__20922__auto___26890 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__26883,G__26884], null);
var temp__4425__auto___26891 = input_checker26881_26888.call(null,args__20922__auto___26890);
if(cljs.core.truth_(temp__4425__auto___26891)){
var error__20923__auto___26892 = temp__4425__auto___26891;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"fvalid","fvalid",-323473304,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null))], null)),cljs.core.pr_str.call(null,error__20923__auto___26892)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema26880_26887,new cljs.core.Keyword(null,"value","value",305978217),args__20922__auto___26890,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___26892], null));
} else {
}
} else {
}

var o__20924__auto__ = (function (){var m = G__26883;
var k = G__26884;
while(true){
return dragonmark.inputs.core.get_in_bs.call(null,m,k,new cljs.core.Keyword(null,"valid","valid",155614240));
break;
}
})();
if(cljs.core.truth_(validate__20921__auto__)){
var temp__4425__auto___26893 = output_checker26882_26889.call(null,o__20924__auto__);
if(cljs.core.truth_(temp__4425__auto___26893)){
var error__20923__auto___26894 = temp__4425__auto___26893;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"fvalid","fvalid",-323473304,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null))], null)),cljs.core.pr_str.call(null,error__20923__auto___26894)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema26879_26886,new cljs.core.Keyword(null,"value","value",305978217),o__20924__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___26894], null));
} else {
}
} else {
}

return o__20924__auto__;
});})(ufv___26885,output_schema26879_26886,input_schema26880_26887,input_checker26881_26888,output_checker26882_26889))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.core.fvalid),schema.core.make_fn_schema.call(null,output_schema26879_26886,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema26880_26887], null)));
var ufv___26901 = schema.utils.use_fn_validation;
var output_schema26895_26902 = schema.core.Bool;
var input_schema26896_26903 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"m","m",-1021758608,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker26897_26904 = schema.core.checker.call(null,input_schema26896_26903);
var output_checker26898_26905 = schema.core.checker.call(null,output_schema26895_26902);
/**
 * Inputs: [m k]
 * Returns: s/Bool
 */
dragonmark.inputs.core.frequired = ((function (ufv___26901,output_schema26895_26902,input_schema26896_26903,input_checker26897_26904,output_checker26898_26905){
return (function dragonmark$inputs$core$frequired(G__26899,G__26900){
var validate__20921__auto__ = ufv___26901.get_cell();
if(cljs.core.truth_(validate__20921__auto__)){
var args__20922__auto___26906 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__26899,G__26900], null);
var temp__4425__auto___26907 = input_checker26897_26904.call(null,args__20922__auto___26906);
if(cljs.core.truth_(temp__4425__auto___26907)){
var error__20923__auto___26908 = temp__4425__auto___26907;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"frequired","frequired",-1936208580,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null)], null)),cljs.core.pr_str.call(null,error__20923__auto___26908)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema26896_26903,new cljs.core.Keyword(null,"value","value",305978217),args__20922__auto___26906,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___26908], null));
} else {
}
} else {
}

var o__20924__auto__ = (function (){var m = G__26899;
var k = G__26900;
while(true){
return dragonmark.inputs.core.get_in_bs.call(null,m,k,new cljs.core.Keyword(null,"required","required",1807647006));
break;
}
})();
if(cljs.core.truth_(validate__20921__auto__)){
var temp__4425__auto___26909 = output_checker26898_26905.call(null,o__20924__auto__);
if(cljs.core.truth_(temp__4425__auto___26909)){
var error__20923__auto___26910 = temp__4425__auto___26909;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"frequired","frequired",-1936208580,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null)], null)),cljs.core.pr_str.call(null,error__20923__auto___26910)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema26895_26902,new cljs.core.Keyword(null,"value","value",305978217),o__20924__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___26910], null));
} else {
}
} else {
}

return o__20924__auto__;
});})(ufv___26901,output_schema26895_26902,input_schema26896_26903,input_checker26897_26904,output_checker26898_26905))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.core.frequired),schema.core.make_fn_schema.call(null,output_schema26895_26902,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema26896_26903], null)));
var ufv___26917 = schema.utils.use_fn_validation;
var output_schema26911_26918 = dragonmark.inputs.validation.sch_errors_list;
var input_schema26912_26919 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"m","m",-1021758608,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker26913_26920 = schema.core.checker.call(null,input_schema26912_26919);
var output_checker26914_26921 = schema.core.checker.call(null,output_schema26911_26918);
/**
 * Inputs: [m k]
 * Returns: va/sch-errors-list
 */
dragonmark.inputs.core.ferrors = ((function (ufv___26917,output_schema26911_26918,input_schema26912_26919,input_checker26913_26920,output_checker26914_26921){
return (function dragonmark$inputs$core$ferrors(G__26915,G__26916){
var validate__20921__auto__ = ufv___26917.get_cell();
if(cljs.core.truth_(validate__20921__auto__)){
var args__20922__auto___26922 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__26915,G__26916], null);
var temp__4425__auto___26923 = input_checker26913_26920.call(null,args__20922__auto___26922);
if(cljs.core.truth_(temp__4425__auto___26923)){
var error__20923__auto___26924 = temp__4425__auto___26923;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"ferrors","ferrors",257894416,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("va","sch-errors-list","va/sch-errors-list",-338989951,null)], null)),cljs.core.pr_str.call(null,error__20923__auto___26924)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema26912_26919,new cljs.core.Keyword(null,"value","value",305978217),args__20922__auto___26922,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___26924], null));
} else {
}
} else {
}

var o__20924__auto__ = (function (){var m = G__26915;
var k = G__26916;
while(true){
return dragonmark.inputs.core.get_in_bs.call(null,m,k,new cljs.core.Keyword(null,"error","error",-978969032));
break;
}
})();
if(cljs.core.truth_(validate__20921__auto__)){
var temp__4425__auto___26925 = output_checker26914_26921.call(null,o__20924__auto__);
if(cljs.core.truth_(temp__4425__auto___26925)){
var error__20923__auto___26926 = temp__4425__auto___26925;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"ferrors","ferrors",257894416,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("va","sch-errors-list","va/sch-errors-list",-338989951,null)], null)),cljs.core.pr_str.call(null,error__20923__auto___26926)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema26911_26918,new cljs.core.Keyword(null,"value","value",305978217),o__20924__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___26926], null));
} else {
}
} else {
}

return o__20924__auto__;
});})(ufv___26917,output_schema26911_26918,input_schema26912_26919,input_checker26913_26920,output_checker26914_26921))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.core.ferrors),schema.core.make_fn_schema.call(null,output_schema26911_26918,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema26912_26919], null)));
var ufv___26933 = schema.utils.use_fn_validation;
var output_schema26927_26934 = schema.core.maybe.call(null,schema.core.Bool);
var input_schema26928_26935 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"m","m",-1021758608,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker26929_26936 = schema.core.checker.call(null,input_schema26928_26935);
var output_checker26930_26937 = schema.core.checker.call(null,output_schema26927_26934);
/**
 * Inputs: [m k]
 * Returns: (s/maybe s/Bool)
 */
dragonmark.inputs.core.fdisabled = ((function (ufv___26933,output_schema26927_26934,input_schema26928_26935,input_checker26929_26936,output_checker26930_26937){
return (function dragonmark$inputs$core$fdisabled(G__26931,G__26932){
var validate__20921__auto__ = ufv___26933.get_cell();
if(cljs.core.truth_(validate__20921__auto__)){
var args__20922__auto___26938 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__26931,G__26932], null);
var temp__4425__auto___26939 = input_checker26929_26936.call(null,args__20922__auto___26938);
if(cljs.core.truth_(temp__4425__auto___26939)){
var error__20923__auto___26940 = temp__4425__auto___26939;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"fdisabled","fdisabled",-1063898034,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null))], null)),cljs.core.pr_str.call(null,error__20923__auto___26940)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema26928_26935,new cljs.core.Keyword(null,"value","value",305978217),args__20922__auto___26938,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___26940], null));
} else {
}
} else {
}

var o__20924__auto__ = (function (){var m = G__26931;
var k = G__26932;
while(true){
return dragonmark.inputs.core.get_in_bs.call(null,m,k,new cljs.core.Keyword(null,"disabled","disabled",-1529784218));
break;
}
})();
if(cljs.core.truth_(validate__20921__auto__)){
var temp__4425__auto___26941 = output_checker26930_26937.call(null,o__20924__auto__);
if(cljs.core.truth_(temp__4425__auto___26941)){
var error__20923__auto___26942 = temp__4425__auto___26941;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"fdisabled","fdisabled",-1063898034,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null))], null)),cljs.core.pr_str.call(null,error__20923__auto___26942)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema26927_26934,new cljs.core.Keyword(null,"value","value",305978217),o__20924__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___26942], null));
} else {
}
} else {
}

return o__20924__auto__;
});})(ufv___26933,output_schema26927_26934,input_schema26928_26935,input_checker26929_26936,output_checker26930_26937))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.core.fdisabled),schema.core.make_fn_schema.call(null,output_schema26927_26934,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema26928_26935], null)));
dragonmark.inputs.core.ffocus = (function dragonmark$inputs$core$ffocus(m,k){
return dragonmark.inputs.core.get_in_bs.call(null,m,k,new cljs.core.Keyword(null,"focus","focus",234677911));
});
var ufv___26966 = schema.utils.use_fn_validation;
var output_schema26943_26967 = dragonmark.inputs.schemas.sch_business_state;
var input_schema26944_26968 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,dragonmark.inputs.schemas.sch_business_state,cljs.core.with_meta(new cljs.core.Symbol(null,"bs","bs",-906042210,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null))),schema.core.one.call(null,schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker26945_26969 = schema.core.checker.call(null,input_schema26944_26968);
var output_checker26946_26970 = schema.core.checker.call(null,output_schema26943_26967);
/**
 * Inputs: [bs :- sch-business-state k :- s/Keyword v :- s/Any]
 * Returns: sch-business-state
 */
dragonmark.inputs.core.assoc_in_all = ((function (ufv___26966,output_schema26943_26967,input_schema26944_26968,input_checker26945_26969,output_checker26946_26970){
return (function dragonmark$inputs$core$assoc_in_all(G__26947,G__26948,G__26949){
var validate__20921__auto__ = ufv___26966.get_cell();
if(cljs.core.truth_(validate__20921__auto__)){
var args__20922__auto___26971 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__26947,G__26948,G__26949], null);
var temp__4425__auto___26972 = input_checker26945_26969.call(null,args__20922__auto___26971);
if(cljs.core.truth_(temp__4425__auto___26972)){
var error__20923__auto___26973 = temp__4425__auto___26972;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"assoc-in-all","assoc-in-all",-807712230,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)),cljs.core.pr_str.call(null,error__20923__auto___26973)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema26944_26968,new cljs.core.Keyword(null,"value","value",305978217),args__20922__auto___26971,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___26973], null));
} else {
}
} else {
}

var o__20924__auto__ = (function (){var bs = G__26947;
var k = G__26948;
var v = G__26949;
while(true){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__19281__auto__ = ((function (validate__20921__auto__,ufv___26966,output_schema26943_26967,input_schema26944_26968,input_checker26945_26969,output_checker26946_26970){
return (function dragonmark$inputs$core$assoc_in_all_$_iter__26958(s__26959){
return (new cljs.core.LazySeq(null,((function (validate__20921__auto__,ufv___26966,output_schema26943_26967,input_schema26944_26968,input_checker26945_26969,output_checker26946_26970){
return (function (){
var s__26959__$1 = s__26959;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__26959__$1);
if(temp__4425__auto__){
var s__26959__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__26959__$2)){
var c__19279__auto__ = cljs.core.chunk_first.call(null,s__26959__$2);
var size__19280__auto__ = cljs.core.count.call(null,c__19279__auto__);
var b__26961 = cljs.core.chunk_buffer.call(null,size__19280__auto__);
if((function (){var i__26960 = (0);
while(true){
if((i__26960 < size__19280__auto__)){
var vec__26964 = cljs.core._nth.call(null,c__19279__auto__,i__26960);
var fk = cljs.core.nth.call(null,vec__26964,(0),null);
var s = cljs.core.nth.call(null,vec__26964,(1),null);
cljs.core.chunk_append.call(null,b__26961,new cljs.core.PersistentArrayMap.fromArray([fk,cljs.core.assoc.call(null,s,k,v)], true, false));

var G__26974 = (i__26960 + (1));
i__26960 = G__26974;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__26961),dragonmark$inputs$core$assoc_in_all_$_iter__26958.call(null,cljs.core.chunk_rest.call(null,s__26959__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__26961),null);
}
} else {
var vec__26965 = cljs.core.first.call(null,s__26959__$2);
var fk = cljs.core.nth.call(null,vec__26965,(0),null);
var s = cljs.core.nth.call(null,vec__26965,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap.fromArray([fk,cljs.core.assoc.call(null,s,k,v)], true, false),dragonmark$inputs$core$assoc_in_all_$_iter__26958.call(null,cljs.core.rest.call(null,s__26959__$2)));
}
} else {
return null;
}
break;
}
});})(validate__20921__auto__,ufv___26966,output_schema26943_26967,input_schema26944_26968,input_checker26945_26969,output_checker26946_26970))
,null,null));
});})(validate__20921__auto__,ufv___26966,output_schema26943_26967,input_schema26944_26968,input_checker26945_26969,output_checker26946_26970))
;
return iter__19281__auto__.call(null,bs);
})());
break;
}
})();
if(cljs.core.truth_(validate__20921__auto__)){
var temp__4425__auto___26975 = output_checker26946_26970.call(null,o__20924__auto__);
if(cljs.core.truth_(temp__4425__auto___26975)){
var error__20923__auto___26976 = temp__4425__auto___26975;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"assoc-in-all","assoc-in-all",-807712230,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"sch-business-state","sch-business-state",399353660,null)], null)),cljs.core.pr_str.call(null,error__20923__auto___26976)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema26943_26967,new cljs.core.Keyword(null,"value","value",305978217),o__20924__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___26976], null));
} else {
}
} else {
}

return o__20924__auto__;
});})(ufv___26966,output_schema26943_26967,input_schema26944_26968,input_checker26945_26969,output_checker26946_26970))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.core.assoc_in_all),schema.core.make_fn_schema.call(null,output_schema26943_26967,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema26944_26968], null)));
/**
 * Disable all inputs after successful validation.
 */
dragonmark.inputs.core.disable_all = (function dragonmark$inputs$core$disable_all(bs){
return dragonmark.inputs.core.assoc_in_all.call(null,bs,new cljs.core.Keyword(null,"disabled","disabled",-1529784218),true);
});
/**
 * Disable all inputs after successful validation.
 */
dragonmark.inputs.core.enable_all = (function dragonmark$inputs$core$enable_all(bs){
return dragonmark.inputs.core.assoc_in_all.call(null,bs,new cljs.core.Keyword(null,"disabled","disabled",-1529784218),false);
});
/**
 * Finds the i18n message for the first error on a field.
 */
dragonmark.inputs.core.error_mess = (function dragonmark$inputs$core$error_mess(owner,kbs,lang,opts){
var full_i18n = dragonmark.inputs.extern.get_i18n_info.call(null,owner,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i18n","i18n",-563422499),lang], null));
var temp__4425__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(kbs);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__26978 = temp__4425__auto__;
var err_k = cljs.core.nth.call(null,vec__26978,(0),null);
var errs = cljs.core.nthnext.call(null,vec__26978,(1));
return dragonmark.inputs.i18n.error.call(null,full_i18n,err_k,opts);
} else {
return null;
}
});
dragonmark.inputs.core.validation_style = (function dragonmark$inputs$core$validation_style(p__26979){
var map__26982 = p__26979;
var map__26982__$1 = ((((!((map__26982 == null)))?((((map__26982.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26982.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26982):map__26982);
var valid = cljs.core.get.call(null,map__26982__$1,new cljs.core.Keyword(null,"valid","valid",155614240));
var invalid = cljs.core.get.call(null,map__26982__$1,new cljs.core.Keyword(null,"invalid","invalid",412869516));
if(cljs.core.truth_(valid)){
return "has-success";
} else {
if(cljs.core.truth_(invalid)){
return "has-error has-feedback";
} else {
return "";

}
}
});
dragonmark.inputs.core.required_style = (function dragonmark$inputs$core$required_style(kbs){
if(cljs.core.truth_(new cljs.core.Keyword(null,"required","required",1807647006).cljs$core$IFn$_invoke$arity$1(kbs))){
return "required";
} else {
return "optional";
}
});
if(typeof dragonmark.inputs.core.layout_input !== 'undefined'){
} else {
dragonmark.inputs.core.layout_input = (function (){var method_table__19422__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__19423__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__19424__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__19425__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__19426__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"dragonmark.inputs.core","layout-input"),((function (method_table__19422__auto__,prefer_table__19423__auto__,method_cache__19424__auto__,cached_hierarchy__19425__auto__,hierarchy__19426__auto__){
return (function (_,p__26984,___$1,___$2){
var map__26985 = p__26984;
var map__26985__$1 = ((((!((map__26985 == null)))?((((map__26985.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26985.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26985):map__26985);
var layout = cljs.core.get.call(null,map__26985__$1,new cljs.core.Keyword(null,"layout","layout",-2120940921));
return layout;
});})(method_table__19422__auto__,prefer_table__19423__auto__,method_cache__19424__auto__,cached_hierarchy__19425__auto__,hierarchy__19426__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__19426__auto__,method_table__19422__auto__,prefer_table__19423__auto__,method_cache__19424__auto__,cached_hierarchy__19425__auto__));
})();
}
cljs.core._add_method.call(null,dragonmark.inputs.core.layout_input,new cljs.core.Keyword(null,"default","default",-1987822328),(function (owner,opts,kbs,p__26987){
var map__26988 = p__26987;
var map__26988__$1 = ((((!((map__26988 == null)))?((((map__26988.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26988.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26988):map__26988);
var val_states = map__26988__$1;
var invalid = cljs.core.get.call(null,map__26988__$1,new cljs.core.Keyword(null,"invalid","invalid",412869516));
var map__26990 = dragonmark.inputs.extern.get_state.call(null,owner);
var map__26990__$1 = ((((!((map__26990 == null)))?((((map__26990.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26990.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26990):map__26990);
var chan = cljs.core.get.call(null,map__26990__$1,new cljs.core.Keyword(null,"chan","chan",-2103021695));
var lang = cljs.core.get.call(null,map__26990__$1,new cljs.core.Keyword(null,"lang","lang",-1819677104));
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),dragonmark.inputs.core.styles.call(null,"form-group",dragonmark.inputs.core.validation_style.call(null,val_states))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),dragonmark.inputs.utils.full_name.call(null,new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(opts)),new cljs.core.Keyword(null,"className","className",-1983287057),dragonmark.inputs.core.styles.call(null,"control-label",dragonmark.inputs.core.required_style.call(null,kbs))], null),dragonmark.inputs.i18n.label.call(null,opts)], null),(cljs.core.truth_(new cljs.core.Keyword(null,"labeled","labeled",1871152938).cljs$core$IFn$_invoke$arity$1(opts))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"badge"], null),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(kbs)], null):null),(cljs.core.truth_(dragonmark.inputs.i18n.desc.call(null,opts))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"description"], null),dragonmark.inputs.i18n.desc.call(null,opts)], null):null),(cljs.core.truth_(dragonmark.inputs.i18n.html_desc.call(null,opts))?sablono.interpreter.interpret.call(null,dragonmark.inputs.i18n.html_desc.call(null,opts)):null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"input-container"], null),(function (){var opts__$1 = cljs.core.assoc_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"attrs","attrs",-2090668713),new cljs.core.Keyword(null,"className","className",-1983287057)], null),"form-control");
return dragonmark.inputs.core.magic_input.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"chan","chan",-2103021695),chan,new cljs.core.Keyword(null,"opts","opts",155075701),opts__$1], null));
})(),(cljs.core.truth_((function (){var and__18516__auto__ = dragonmark.inputs.i18n.info.call(null,opts);
if(cljs.core.truth_(and__18516__auto__)){
return new cljs.core.Keyword(null,"focus","focus",234677911).cljs$core$IFn$_invoke$arity$1(kbs);
} else {
return and__18516__auto__;
}
})())?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [dragonmark.inputs.extern.build_component.call(null,dragonmark.inputs.core.tooltip,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"mess","mess",530922968),dragonmark.inputs.i18n.info.call(null,opts),new cljs.core.Keyword(null,"title","title",636505583),dragonmark.inputs.i18n.info_title.call(null,opts)], null),owner,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"k","k",-2146297393),new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"type","type",1174270348),"info"], null)], null))], null):null),(function (){var mess = dragonmark.inputs.core.error_mess.call(null,owner,kbs,lang,opts);
if(cljs.core.truth_((function (){var and__18516__auto__ = invalid;
if(cljs.core.truth_(and__18516__auto__)){
return mess;
} else {
return and__18516__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [dragonmark.inputs.extern.build_component.call(null,dragonmark.inputs.core.tooltip,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mess","mess",530922968),mess], null),owner,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mess","mess",530922968),mess], null),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"k","k",-2146297393),new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"type","type",1174270348),"error",new cljs.core.Keyword(null,"action","action",-811238024),((function (mess,map__26990,map__26990__$1,chan,lang,map__26988,map__26988__$1,val_states,invalid){
return (function (){
cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"kill-mess","kill-mess",723475912),new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(opts)], null));

return null;
});})(mess,map__26990,map__26990__$1,chan,lang,map__26988,map__26988__$1,val_states,invalid))
], null)], null))], null);
} else {
return null;
}
})()], null)], null);
}));
cljs.core._add_method.call(null,dragonmark.inputs.core.layout_input,"in-line",(function (owner,opts,kbs,p__26992){
var map__26993 = p__26992;
var map__26993__$1 = ((((!((map__26993 == null)))?((((map__26993.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26993.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26993):map__26993);
var val_states = map__26993__$1;
var invalid = cljs.core.get.call(null,map__26993__$1,new cljs.core.Keyword(null,"invalid","invalid",412869516));
var map__26995 = dragonmark.inputs.extern.get_state.call(null,owner);
var map__26995__$1 = ((((!((map__26995 == null)))?((((map__26995.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26995.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26995):map__26995);
var chan = cljs.core.get.call(null,map__26995__$1,new cljs.core.Keyword(null,"chan","chan",-2103021695));
var lang = cljs.core.get.call(null,map__26995__$1,new cljs.core.Keyword(null,"lang","lang",-1819677104));
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),dragonmark.inputs.core.validation_style.call(null,val_states)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),dragonmark.inputs.core.styles.call(null,"checkbox",dragonmark.inputs.core.required_style.call(null,kbs))], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),dragonmark.inputs.utils.full_name.call(null,new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(opts))], null),(cljs.core.truth_(new cljs.core.Keyword(null,"labeled","labeled",1871152938).cljs$core$IFn$_invoke$arity$1(opts))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"badge"], null),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(kbs)], null):null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"input-container"], null),dragonmark.inputs.core.magic_input.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"chan","chan",-2103021695),chan,new cljs.core.Keyword(null,"opts","opts",155075701),opts], null)),(cljs.core.truth_((function (){var and__18516__auto__ = dragonmark.inputs.i18n.info.call(null,opts);
if(cljs.core.truth_(and__18516__auto__)){
return new cljs.core.Keyword(null,"focus","focus",234677911).cljs$core$IFn$_invoke$arity$1(opts);
} else {
return and__18516__auto__;
}
})())?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [dragonmark.inputs.extern.build_component.call(null,dragonmark.inputs.core.tooltip,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"mess","mess",530922968),dragonmark.inputs.i18n.info.call(null,opts),new cljs.core.Keyword(null,"title","title",636505583),dragonmark.inputs.i18n.info_title.call(null,opts)], null),owner,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"mess","mess",530922968),dragonmark.inputs.i18n.info.call(null,opts),new cljs.core.Keyword(null,"title","title",636505583),dragonmark.inputs.i18n.info_title.call(null,opts)], null),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"k","k",-2146297393),new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"type","type",1174270348),"info"], null)], null))], null):null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),dragonmark.inputs.i18n.label.call(null,opts)], null)], null),(function (){var mess = dragonmark.inputs.core.error_mess.call(null,owner,kbs,lang,opts);
if(cljs.core.truth_((function (){var and__18516__auto__ = invalid;
if(cljs.core.truth_(and__18516__auto__)){
return mess;
} else {
return and__18516__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [dragonmark.inputs.extern.build_component.call(null,dragonmark.inputs.core.tooltip,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mess","mess",530922968),mess], null),owner,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mess","mess",530922968),mess], null),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"k","k",-2146297393),new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"type","type",1174270348),"error",new cljs.core.Keyword(null,"action","action",-811238024),((function (mess,map__26995,map__26995__$1,chan,lang,map__26993,map__26993__$1,val_states,invalid){
return (function (){
cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"kill-mess","kill-mess",723475912),new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(opts)], null));

return null;
});})(mess,map__26995,map__26995__$1,chan,lang,map__26993,map__26993__$1,val_states,invalid))
], null)], null))], null);
} else {
return null;
}
})()], null),(cljs.core.truth_(dragonmark.inputs.i18n.desc.call(null,opts))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"description"], null),dragonmark.inputs.i18n.desc.call(null,opts)], null):null),(cljs.core.truth_(dragonmark.inputs.i18n.html_desc.call(null,opts))?sablono.interpreter.interpret.call(null,dragonmark.inputs.i18n.html_desc.call(null,opts)):null)], null);
}));
dragonmark.inputs.core.build_input = (function dragonmark$inputs$core$build_input(owner,p__26999){
var map__27004 = p__26999;
var map__27004__$1 = ((((!((map__27004 == null)))?((((map__27004.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27004.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27004):map__27004);
var opts = map__27004__$1;
var k = cljs.core.get.call(null,map__27004__$1,new cljs.core.Keyword(null,"k","k",-2146297393));
var map__27006 = dragonmark.inputs.extern.get_state.call(null,owner);
var map__27006__$1 = ((((!((map__27006 == null)))?((((map__27006.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27006.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27006):map__27006);
var chan = cljs.core.get.call(null,map__27006__$1,new cljs.core.Keyword(null,"chan","chan",-2103021695));
var inputs = cljs.core.get.call(null,map__27006__$1,new cljs.core.Keyword(null,"inputs","inputs",865803858));
var kbs = k.call(null,inputs);
var valid = new cljs.core.Keyword(null,"valid","valid",155614240).cljs$core$IFn$_invoke$arity$1(kbs);
var controled = !((valid == null));
var invalid = (controled) && (cljs.core.not.call(null,valid));
var val_states = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"valid","valid",155614240),valid,new cljs.core.Keyword(null,"invalid","invalid",412869516),invalid,new cljs.core.Keyword(null,"controled","controled",1088856164),controled], null);
var k_attrs = new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"id","id",-1388402092),dragonmark.inputs.utils.full_name.call(null,k),new cljs.core.Keyword(null,"key","key",-1516042587),dragonmark.inputs.utils.full_name.call(null,k),new cljs.core.Keyword(null,"ref","ref",1289896967),dragonmark.inputs.utils.full_name.call(null,k),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(kbs),new cljs.core.Keyword(null,"onFocus","onFocus",1152444958),((function (map__27006,map__27006__$1,chan,inputs,kbs,valid,controled,invalid,val_states,map__27004,map__27004__$1,opts,k){
return (function (_){
cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"focus","focus",234677911),k], null));

return null;
});})(map__27006,map__27006__$1,chan,inputs,kbs,valid,controled,invalid,val_states,map__27004,map__27004__$1,opts,k))
,new cljs.core.Keyword(null,"onChange","onChange",-312891301),((function (map__27006,map__27006__$1,chan,inputs,kbs,valid,controled,invalid,val_states,map__27004,map__27004__$1,opts,k){
return (function (p1__26997_SHARP_){
cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,dragonmark.inputs.core.e_value.call(null,p1__26997_SHARP_)], null));

cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"validate","validate",-201300827),k], null));

return null;
});})(map__27006,map__27006__$1,chan,inputs,kbs,valid,controled,invalid,val_states,map__27004,map__27004__$1,opts,k))
,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),cljs.core.get_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i18n","i18n",-563422499),new cljs.core.Keyword(null,"ph","ph",-1483583977)], null)),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),new cljs.core.Keyword(null,"disabled","disabled",-1529784218).cljs$core$IFn$_invoke$arity$1(kbs)], null);
var opts__$1 = cljs.core.update_in.call(null,opts,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"attrs","attrs",-2090668713)], null),((function (map__27006,map__27006__$1,chan,inputs,kbs,valid,controled,invalid,val_states,k_attrs,map__27004,map__27004__$1,opts,k){
return (function (p1__26998_SHARP_){
return cljs.core.merge.call(null,k_attrs,p1__26998_SHARP_);
});})(map__27006,map__27006__$1,chan,inputs,kbs,valid,controled,invalid,val_states,k_attrs,map__27004,map__27004__$1,opts,k))
);
return dragonmark.inputs.core.layout_input.call(null,owner,opts__$1,kbs,val_states);
});
dragonmark.inputs.core.action_states = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"init","init",-1875481434),new cljs.core.Keyword(null,"active","active",1895962068),new cljs.core.Keyword(null,"in-error","in-error",-1865680681),new cljs.core.Keyword(null,"active","active",1895962068),new cljs.core.Keyword(null,"active","active",1895962068),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),new cljs.core.Keyword(null,"init","init",-1875481434)], null);
dragonmark.inputs.core.error_flow = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"init","init",-1875481434),new cljs.core.Keyword(null,"in-error","in-error",-1865680681),new cljs.core.Keyword(null,"active","active",1895962068),new cljs.core.Keyword(null,"in-error","in-error",-1865680681),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),new cljs.core.Keyword(null,"in-error","in-error",-1865680681),new cljs.core.Keyword(null,"in-error","in-error",-1865680681)], null);
var ufv___27346 = schema.utils.use_fn_validation;
var output_schema27011_27347 = schema.core.Any;
var input_schema27012_27348 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null))], null);
var input_schema27016_27349 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"comp-name","comp-name",1166159940,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"action","action",829293503,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_schema27022_27350 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"comp-name","comp-name",1166159940,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"action","action",829293503,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_schema27029_27351 = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"comp-name","comp-name",1166159940,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"action","action",829293503,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"clean","clean",1682065606,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one.call(null,dragonmark.inputs.schemas.SchOptions,cljs.core.with_meta(new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"SchOptions","SchOptions",995391861,null)], null)))], null);
var input_checker27013_27352 = schema.core.checker.call(null,input_schema27012_27348);
var output_checker27014_27353 = schema.core.checker.call(null,output_schema27011_27347);
var input_checker27017_27354 = schema.core.checker.call(null,input_schema27016_27349);
var output_checker27018_27355 = schema.core.checker.call(null,output_schema27011_27347);
var input_checker27023_27356 = schema.core.checker.call(null,input_schema27022_27350);
var output_checker27024_27357 = schema.core.checker.call(null,output_schema27011_27347);
var input_checker27030_27358 = schema.core.checker.call(null,input_schema27029_27351);
var output_checker27031_27359 = schema.core.checker.call(null,output_schema27011_27347);
/**
 * Inputs: ([{:keys [name schema action clean opts], :or {opts {}}, :as spec}] [comp-name :- s/Keyword schema action] [comp-name :- s/Keyword schema action opts] [comp-name :- s/Keyword schema action clean opts :- SchOptions])
 * 
 * Build an input form Om component based on a prismatic/Schema
 */
dragonmark.inputs.core.make_input_comp = ((function (ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function dragonmark$inputs$core$make_input_comp(){
var args27037 = [];
var len__19567__auto___27360 = arguments.length;
var i__19568__auto___27361 = (0);
while(true){
if((i__19568__auto___27361 < len__19567__auto___27360)){
args27037.push((arguments[i__19568__auto___27361]));

var G__27362 = (i__19568__auto___27361 + (1));
i__19568__auto___27361 = G__27362;
continue;
} else {
}
break;
}

var G__27039 = args27037.length;
switch (G__27039) {
case 1:
return dragonmark.inputs.core.make_input_comp.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return dragonmark.inputs.core.make_input_comp.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return dragonmark.inputs.core.make_input_comp.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return dragonmark.inputs.core.make_input_comp.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27037.length)].join('')));

}
});})(ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
;

dragonmark.inputs.core.make_input_comp.cljs$core$IFn$_invoke$arity$1 = ((function (ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function (G__27015){
var validate__20921__auto__ = ufv___27346.get_cell();
if(cljs.core.truth_(validate__20921__auto__)){
var args__20922__auto___27364 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__27015], null);
var temp__4425__auto___27365 = input_checker27013_27352.call(null,args__20922__auto___27364);
if(cljs.core.truth_(temp__4425__auto___27365)){
var error__20923__auto___27366 = temp__4425__auto___27365;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"make-input-comp","make-input-comp",1804483332,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Build an input form Om component based on a prismatic/Schema"], null)),cljs.core.pr_str.call(null,error__20923__auto___27366)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema27012_27348,new cljs.core.Keyword(null,"value","value",305978217),args__20922__auto___27364,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27366], null));
} else {
}
} else {
}

var o__20924__auto__ = (function (){var G__27041 = G__27015;
var map__27042 = G__27041;
var map__27042__$1 = ((((!((map__27042 == null)))?((((map__27042.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27042.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27042):map__27042);
var spec = map__27042__$1;
var name = cljs.core.get.call(null,map__27042__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var schema__$1 = cljs.core.get.call(null,map__27042__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
var action = cljs.core.get.call(null,map__27042__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var clean = cljs.core.get.call(null,map__27042__$1,new cljs.core.Keyword(null,"clean","clean",41534079));
var opts = cljs.core.get.call(null,map__27042__$1,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY);
var G__27041__$1 = G__27041;
while(true){
var map__27044 = G__27041__$1;
var map__27044__$1 = ((((!((map__27044 == null)))?((((map__27044.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27044.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27044):map__27044);
var spec__$1 = map__27044__$1;
var name__$1 = cljs.core.get.call(null,map__27044__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var schema__$2 = cljs.core.get.call(null,map__27044__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
var action__$1 = cljs.core.get.call(null,map__27044__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var clean__$1 = cljs.core.get.call(null,map__27044__$1,new cljs.core.Keyword(null,"clean","clean",41534079));
var opts__$1 = cljs.core.get.call(null,map__27044__$1,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY);
return dragonmark.inputs.core.make_input_comp.call(null,name__$1,schema__$2,action__$1,clean__$1,opts__$1);
break;
}
})();
if(cljs.core.truth_(validate__20921__auto__)){
var temp__4425__auto___27367 = output_checker27014_27353.call(null,o__20924__auto__);
if(cljs.core.truth_(temp__4425__auto___27367)){
var error__20923__auto___27368 = temp__4425__auto___27367;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"make-input-comp","make-input-comp",1804483332,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Build an input form Om component based on a prismatic/Schema"], null)),cljs.core.pr_str.call(null,error__20923__auto___27368)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema27011_27347,new cljs.core.Keyword(null,"value","value",305978217),o__20924__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27368], null));
} else {
}
} else {
}

return o__20924__auto__;
});})(ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
;

dragonmark.inputs.core.make_input_comp.cljs$core$IFn$_invoke$arity$3 = ((function (ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function (G__27019,G__27020,G__27021){
var validate__20921__auto__ = ufv___27346.get_cell();
if(cljs.core.truth_(validate__20921__auto__)){
var args__20922__auto___27369 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__27019,G__27020,G__27021], null);
var temp__4425__auto___27370 = input_checker27017_27354.call(null,args__20922__auto___27369);
if(cljs.core.truth_(temp__4425__auto___27370)){
var error__20923__auto___27371 = temp__4425__auto___27370;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"make-input-comp","make-input-comp",1804483332,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Build an input form Om component based on a prismatic/Schema"], null)),cljs.core.pr_str.call(null,error__20923__auto___27371)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema27016_27349,new cljs.core.Keyword(null,"value","value",305978217),args__20922__auto___27369,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27371], null));
} else {
}
} else {
}

var o__20924__auto__ = (function (){var comp_name = G__27019;
var schema__$1 = G__27020;
var action = G__27021;
while(true){
return dragonmark.inputs.core.make_input_comp.call(null,comp_name,schema__$1,action,null,cljs.core.PersistentArrayMap.EMPTY);
break;
}
})();
if(cljs.core.truth_(validate__20921__auto__)){
var temp__4425__auto___27372 = output_checker27018_27355.call(null,o__20924__auto__);
if(cljs.core.truth_(temp__4425__auto___27372)){
var error__20923__auto___27373 = temp__4425__auto___27372;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"make-input-comp","make-input-comp",1804483332,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Build an input form Om component based on a prismatic/Schema"], null)),cljs.core.pr_str.call(null,error__20923__auto___27373)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema27011_27347,new cljs.core.Keyword(null,"value","value",305978217),o__20924__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27373], null));
} else {
}
} else {
}

return o__20924__auto__;
});})(ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
;

dragonmark.inputs.core.make_input_comp.cljs$core$IFn$_invoke$arity$4 = ((function (ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function (G__27025,G__27026,G__27027,G__27028){
var validate__20921__auto__ = ufv___27346.get_cell();
if(cljs.core.truth_(validate__20921__auto__)){
var args__20922__auto___27374 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__27025,G__27026,G__27027,G__27028], null);
var temp__4425__auto___27375 = input_checker27023_27356.call(null,args__20922__auto___27374);
if(cljs.core.truth_(temp__4425__auto___27375)){
var error__20923__auto___27376 = temp__4425__auto___27375;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"make-input-comp","make-input-comp",1804483332,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Build an input form Om component based on a prismatic/Schema"], null)),cljs.core.pr_str.call(null,error__20923__auto___27376)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema27022_27350,new cljs.core.Keyword(null,"value","value",305978217),args__20922__auto___27374,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27376], null));
} else {
}
} else {
}

var o__20924__auto__ = (function (){var comp_name = G__27025;
var schema__$1 = G__27026;
var action = G__27027;
var opts = G__27028;
while(true){
return dragonmark.inputs.core.make_input_comp.call(null,comp_name,schema__$1,action,null,opts);
break;
}
})();
if(cljs.core.truth_(validate__20921__auto__)){
var temp__4425__auto___27377 = output_checker27024_27357.call(null,o__20924__auto__);
if(cljs.core.truth_(temp__4425__auto___27377)){
var error__20923__auto___27378 = temp__4425__auto___27377;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"make-input-comp","make-input-comp",1804483332,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Build an input form Om component based on a prismatic/Schema"], null)),cljs.core.pr_str.call(null,error__20923__auto___27378)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema27011_27347,new cljs.core.Keyword(null,"value","value",305978217),o__20924__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27378], null));
} else {
}
} else {
}

return o__20924__auto__;
});})(ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
;

dragonmark.inputs.core.make_input_comp.cljs$core$IFn$_invoke$arity$5 = ((function (ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function (G__27032,G__27033,G__27034,G__27035,G__27036){
var validate__20921__auto__ = ufv___27346.get_cell();
if(cljs.core.truth_(validate__20921__auto__)){
var args__20922__auto___27379 = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__27032,G__27033,G__27034,G__27035,G__27036], null);
var temp__4425__auto___27380 = input_checker27030_27358.call(null,args__20922__auto___27379);
if(cljs.core.truth_(temp__4425__auto___27380)){
var error__20923__auto___27381 = temp__4425__auto___27380;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"make-input-comp","make-input-comp",1804483332,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Build an input form Om component based on a prismatic/Schema"], null)),cljs.core.pr_str.call(null,error__20923__auto___27381)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema27029_27351,new cljs.core.Keyword(null,"value","value",305978217),args__20922__auto___27379,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27381], null));
} else {
}
} else {
}

var o__20924__auto__ = (function (){var comp_name = G__27032;
var schema__$1 = G__27033;
var action = G__27034;
var clean = G__27035;
var opts = G__27036;
while(true){
var order = new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(opts);
var verily_rules = new cljs.core.Keyword(null,"validations","validations",1347149461).cljs$core$IFn$_invoke$arity$1(opts);
var schema_coercer = schema.coerce.coercer.call(null,schema__$1,dragonmark.inputs.validation.validation_coercer);
var validation = dragonmark.inputs.validation.build_verily_validator.call(null,verily_rules);
var checker = cljs.core.partial.call(null,dragonmark.inputs.validation.validate,schema_coercer,dragonmark.inputs.validation.transform_schema_errors);
var unit_coercers = dragonmark.inputs.validation.build_unit_coercers.call(null,schema__$1);
var unit_validators = dragonmark.inputs.validation.unit_schema_validators.call(null,unit_coercers);
var remove_errs_fn = dragonmark.inputs.validation.build_error_remover.call(null,verily_rules,dragonmark.inputs.validation.inter_fields_rules);
var typing_controls = dragonmark.inputs.typing_controls.build_typing_control.call(null,schema__$1);
var initial_bs = dragonmark.inputs.core.build_init_state.call(null,schema__$1,new cljs.core.Keyword(null,"init","init",-1875481434).cljs$core$IFn$_invoke$arity$1(opts));
var initial_action_state = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"action","action",-811238024),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),new cljs.core.Keyword(null,"clean","clean",41534079),new cljs.core.Keyword(null,"disabled","disabled",-1529784218)], null);
var close_channels = ((function (order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function (this$){
var map__27046 = dragonmark.inputs.extern.get_state.call(null,this$);
var map__27046__$1 = ((((!((map__27046 == null)))?((((map__27046.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27046.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27046):map__27046);
var chan = cljs.core.get.call(null,map__27046__$1,new cljs.core.Keyword(null,"chan","chan",-2103021695));
var action_chan = cljs.core.get.call(null,map__27046__$1,new cljs.core.Keyword(null,"action-chan","action-chan",1941883997));
var created_chan = cljs.core.get.call(null,map__27046__$1,new cljs.core.Keyword(null,"created-chan","created-chan",645924718));
var clean_chan = cljs.core.get.call(null,map__27046__$1,new cljs.core.Keyword(null,"clean-chan","clean-chan",-1416649986));
cljs.core.async.close_BANG_.call(null,chan);

cljs.core.async.close_BANG_.call(null,action_chan);

cljs.core.async.close_BANG_.call(null,created_chan);

return cljs.core.async.close_BANG_.call(null,clean_chan);
});})(order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
;
return ((function (order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function (app){
return dragonmark.inputs.extern.create_component.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"get-initial-state","get-initial-state",-4494070),((function (order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function (_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"chan","chan",-2103021695),new cljs.core.Keyword(null,"validation-deps","validation-deps",1496827716),new cljs.core.Keyword(null,"action-state","action-state",-1575944631),new cljs.core.Keyword(null,"verily-validator","verily-validator",-283552403),new cljs.core.Keyword(null,"remove-errs-fn","remove-errs-fn",-1642608850),new cljs.core.Keyword(null,"created-chan","created-chan",645924718),new cljs.core.Keyword(null,"unit-coercers","unit-coercers",-1869075474),new cljs.core.Keyword(null,"inputs","inputs",865803858),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"action-chan","action-chan",1941883997),new cljs.core.Keyword(null,"clean-chan","clean-chan",-1416649986),new cljs.core.Keyword(null,"unit-validators","unit-validators",-1302618433)],[cljs.core.async.chan.call(null,(10)),dragonmark.inputs.validation.fields_dependencies.call(null,verily_rules),initial_action_state,validation,remove_errs_fn,cljs.core.async.chan.call(null,(10)),unit_coercers,initial_bs,opts,cljs.core.async.chan.call(null,(10)),cljs.core.async.chan.call(null,(10)),unit_validators]);
});})(order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
,new cljs.core.Keyword(null,"component-will-mount","component-will-mount",209708855),((function (order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function (this$){
var map__27048 = dragonmark.inputs.extern.get_state.call(null,this$);
var map__27048__$1 = ((((!((map__27048 == null)))?((((map__27048.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27048.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27048):map__27048);
var chan = cljs.core.get.call(null,map__27048__$1,new cljs.core.Keyword(null,"chan","chan",-2103021695));
var action_chan = cljs.core.get.call(null,map__27048__$1,new cljs.core.Keyword(null,"action-chan","action-chan",1941883997));
var created_chan = cljs.core.get.call(null,map__27048__$1,new cljs.core.Keyword(null,"created-chan","created-chan",645924718));
var clean_chan = cljs.core.get.call(null,map__27048__$1,new cljs.core.Keyword(null,"clean-chan","clean-chan",-1416649986));
var do_validation = ((function (map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function (){
var map__27050 = dragonmark.inputs.extern.get_state.call(null,this$);
var map__27050__$1 = ((((!((map__27050 == null)))?((((map__27050.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27050.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27050):map__27050);
var state = map__27050__$1;
var inputs = cljs.core.get.call(null,map__27050__$1,new cljs.core.Keyword(null,"inputs","inputs",865803858));
var new_bs = dragonmark.inputs.validation.full_validation.call(null,inputs,state);
var no_error = dragonmark.inputs.validation.no_error_QMARK_.call(null,new_bs);
if(cljs.core.truth_(no_error)){
dragonmark.inputs.extern.set_state_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"action-state","action-state",-1575944631),new cljs.core.Keyword(null,"action","action",-811238024)], null),null);
} else {
dragonmark.inputs.extern.set_state_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"action-state","action-state",-1575944631),new cljs.core.Keyword(null,"action","action",-811238024)], null),new cljs.core.Keyword(null,"in-error","in-error",-1865680681));
}

dragonmark.inputs.extern.set_state_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"inputs","inputs",865803858)], null),new_bs);

return no_error;
});})(map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
;
if(cljs.core.truth_(cljs.core.get_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"action","action",-811238024),new cljs.core.Keyword(null,"no-reset","no-reset",-1147706932)], null)))){
} else {
dragonmark.inputs.extern.set_state_BANG_.call(null,this$,new cljs.core.Keyword(null,"inputs","inputs",865803858),initial_bs);
}

dragonmark.inputs.extern.set_state_BANG_.call(null,this$,new cljs.core.Keyword(null,"action-state","action-state",-1575944631),initial_action_state);

do_validation.call(null);

var c__23323__auto___27382 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23323__auto___27382,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function (){
var f__23324__auto__ = (function (){var switch__23302__auto__ = ((function (c__23323__auto___27382,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function (state_27070){
var state_val_27071 = (state_27070[(1)]);
if((state_val_27071 === (1))){
var state_27070__$1 = state_27070;
var statearr_27072_27383 = state_27070__$1;
(statearr_27072_27383[(2)] = null);

(statearr_27072_27383[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27071 === (2))){
var state_27070__$1 = state_27070;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27070__$1,(4),clean_chan);
} else {
if((state_val_27071 === (3))){
var inst_27068 = (state_27070[(2)]);
var state_27070__$1 = state_27070;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27070__$1,inst_27068);
} else {
if((state_val_27071 === (4))){
var inst_27054 = (state_27070[(2)]);
var state_27070__$1 = state_27070;
if(cljs.core.truth_(inst_27054)){
var statearr_27073_27384 = state_27070__$1;
(statearr_27073_27384[(1)] = (5));

} else {
var statearr_27074_27385 = state_27070__$1;
(statearr_27074_27385[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27071 === (5))){
var inst_27056 = clean.call(null,app,this$);
var inst_27057 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27058 = [new cljs.core.Keyword(null,"action-state","action-state",-1575944631),new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_27059 = (new cljs.core.PersistentVector(null,2,(5),inst_27057,inst_27058,null));
var inst_27060 = dragonmark.inputs.extern.update_state_BANG_.call(null,this$,inst_27059,dragonmark.inputs.core.action_states);
var inst_27061 = (function (){return ((function (inst_27056,inst_27057,inst_27058,inst_27059,inst_27060,state_val_27071,c__23323__auto___27382,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function (p1__27008_SHARP_){
return dragonmark.inputs.core.enable_all.call(null,p1__27008_SHARP_);
});
;})(inst_27056,inst_27057,inst_27058,inst_27059,inst_27060,state_val_27071,c__23323__auto___27382,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
})();
var inst_27062 = dragonmark.inputs.extern.update_state_BANG_.call(null,this$,new cljs.core.Keyword(null,"inputs","inputs",865803858),inst_27061);
var state_27070__$1 = (function (){var statearr_27075 = state_27070;
(statearr_27075[(7)] = inst_27062);

(statearr_27075[(8)] = inst_27060);

(statearr_27075[(9)] = inst_27056);

return statearr_27075;
})();
var statearr_27076_27386 = state_27070__$1;
(statearr_27076_27386[(2)] = null);

(statearr_27076_27386[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27071 === (6))){
var state_27070__$1 = state_27070;
var statearr_27077_27387 = state_27070__$1;
(statearr_27077_27387[(2)] = null);

(statearr_27077_27387[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27071 === (7))){
var inst_27066 = (state_27070[(2)]);
var state_27070__$1 = state_27070;
var statearr_27078_27388 = state_27070__$1;
(statearr_27078_27388[(2)] = inst_27066);

(statearr_27078_27388[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__23323__auto___27382,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
;
return ((function (switch__23302__auto__,c__23323__auto___27382,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function() {
var dragonmark$inputs$core$state_machine__23303__auto__ = null;
var dragonmark$inputs$core$state_machine__23303__auto____0 = (function (){
var statearr_27082 = [null,null,null,null,null,null,null,null,null,null];
(statearr_27082[(0)] = dragonmark$inputs$core$state_machine__23303__auto__);

(statearr_27082[(1)] = (1));

return statearr_27082;
});
var dragonmark$inputs$core$state_machine__23303__auto____1 = (function (state_27070){
while(true){
var ret_value__23304__auto__ = (function (){try{while(true){
var result__23305__auto__ = switch__23302__auto__.call(null,state_27070);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23305__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23305__auto__;
}
break;
}
}catch (e27083){if((e27083 instanceof Object)){
var ex__23306__auto__ = e27083;
var statearr_27084_27389 = state_27070;
(statearr_27084_27389[(5)] = ex__23306__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27070);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27083;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23304__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27390 = state_27070;
state_27070 = G__27390;
continue;
} else {
return ret_value__23304__auto__;
}
break;
}
});
dragonmark$inputs$core$state_machine__23303__auto__ = function(state_27070){
switch(arguments.length){
case 0:
return dragonmark$inputs$core$state_machine__23303__auto____0.call(this);
case 1:
return dragonmark$inputs$core$state_machine__23303__auto____1.call(this,state_27070);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
dragonmark$inputs$core$state_machine__23303__auto__.cljs$core$IFn$_invoke$arity$0 = dragonmark$inputs$core$state_machine__23303__auto____0;
dragonmark$inputs$core$state_machine__23303__auto__.cljs$core$IFn$_invoke$arity$1 = dragonmark$inputs$core$state_machine__23303__auto____1;
return dragonmark$inputs$core$state_machine__23303__auto__;
})()
;})(switch__23302__auto__,c__23323__auto___27382,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
})();
var state__23325__auto__ = (function (){var statearr_27085 = f__23324__auto__.call(null);
(statearr_27085[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23323__auto___27382);

return statearr_27085;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23325__auto__);
});})(c__23323__auto___27382,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
);


var c__23323__auto___27391 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23323__auto___27391,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function (){
var f__23324__auto__ = (function (){var switch__23302__auto__ = ((function (c__23323__auto___27391,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function (state_27126){
var state_val_27127 = (state_27126[(1)]);
if((state_val_27127 === (7))){
var inst_27122 = (state_27126[(2)]);
var state_27126__$1 = state_27126;
var statearr_27128_27392 = state_27126__$1;
(statearr_27128_27392[(2)] = inst_27122);

(statearr_27128_27392[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27127 === (1))){
var state_27126__$1 = state_27126;
var statearr_27129_27393 = state_27126__$1;
(statearr_27129_27393[(2)] = null);

(statearr_27129_27393[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27127 === (4))){
var inst_27088 = (state_27126[(7)]);
var inst_27088__$1 = (state_27126[(2)]);
var state_27126__$1 = (function (){var statearr_27130 = state_27126;
(statearr_27130[(7)] = inst_27088__$1);

return statearr_27130;
})();
if(cljs.core.truth_(inst_27088__$1)){
var statearr_27131_27394 = state_27126__$1;
(statearr_27131_27394[(1)] = (5));

} else {
var statearr_27132_27395 = state_27126__$1;
(statearr_27132_27395[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27127 === (13))){
var inst_27116 = (state_27126[(2)]);
var state_27126__$1 = state_27126;
var statearr_27133_27396 = state_27126__$1;
(statearr_27133_27396[(2)] = inst_27116);

(statearr_27133_27396[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27127 === (6))){
var state_27126__$1 = state_27126;
var statearr_27134_27397 = state_27126__$1;
(statearr_27134_27397[(2)] = null);

(statearr_27134_27397[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27127 === (3))){
var inst_27124 = (state_27126[(2)]);
var state_27126__$1 = state_27126;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27126__$1,inst_27124);
} else {
if((state_val_27127 === (12))){
var state_27126__$1 = state_27126;
var statearr_27135_27398 = state_27126__$1;
(statearr_27135_27398[(2)] = null);

(statearr_27135_27398[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27127 === (2))){
var state_27126__$1 = state_27126;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27126__$1,(4),created_chan);
} else {
if((state_val_27127 === (11))){
var inst_27088 = (state_27126[(7)]);
var inst_27092 = (state_27126[(8)]);
var inst_27091 = (state_27126[(9)]);
var inst_27104 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27105 = [new cljs.core.Keyword(null,"action-state","action-state",-1575944631),new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_27106 = (new cljs.core.PersistentVector(null,2,(5),inst_27104,inst_27105,null));
var inst_27107 = dragonmark.inputs.extern.update_state_BANG_.call(null,this$,inst_27106,dragonmark.inputs.core.action_states);
var inst_27108 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27109 = [new cljs.core.Keyword(null,"action-state","action-state",-1575944631),new cljs.core.Keyword(null,"clean","clean",41534079)];
var inst_27110 = (new cljs.core.PersistentVector(null,2,(5),inst_27108,inst_27109,null));
var inst_27111 = dragonmark.inputs.extern.update_state_BANG_.call(null,this$,inst_27110,dragonmark.inputs.core.action_states);
var inst_27112 = (function (){var temp__4425__auto__ = inst_27088;
var vec__27090 = inst_27088;
var v = inst_27091;
var m = inst_27092;
return ((function (temp__4425__auto__,vec__27090,v,m,inst_27088,inst_27092,inst_27091,inst_27104,inst_27105,inst_27106,inst_27107,inst_27108,inst_27109,inst_27110,inst_27111,state_val_27127,c__23323__auto___27391,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function (p1__27009_SHARP_){
return dragonmark.inputs.core.disable_all.call(null,p1__27009_SHARP_);
});
;})(temp__4425__auto__,vec__27090,v,m,inst_27088,inst_27092,inst_27091,inst_27104,inst_27105,inst_27106,inst_27107,inst_27108,inst_27109,inst_27110,inst_27111,state_val_27127,c__23323__auto___27391,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
})();
var inst_27113 = dragonmark.inputs.extern.update_state_BANG_.call(null,this$,new cljs.core.Keyword(null,"inputs","inputs",865803858),inst_27112);
var state_27126__$1 = (function (){var statearr_27136 = state_27126;
(statearr_27136[(10)] = inst_27107);

(statearr_27136[(11)] = inst_27111);

return statearr_27136;
})();
var statearr_27137_27399 = state_27126__$1;
(statearr_27137_27399[(2)] = inst_27113);

(statearr_27137_27399[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27127 === (9))){
var inst_27099 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27100 = [new cljs.core.Keyword(null,"action","action",-811238024),new cljs.core.Keyword(null,"one-shot","one-shot",-2139661191)];
var inst_27101 = (new cljs.core.PersistentVector(null,2,(5),inst_27099,inst_27100,null));
var inst_27102 = cljs.core.get_in.call(null,opts,inst_27101);
var state_27126__$1 = state_27126;
if(cljs.core.truth_(inst_27102)){
var statearr_27138_27400 = state_27126__$1;
(statearr_27138_27400[(1)] = (11));

} else {
var statearr_27139_27401 = state_27126__$1;
(statearr_27139_27401[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27127 === (5))){
var inst_27088 = (state_27126[(7)]);
var inst_27091 = (state_27126[(9)]);
var inst_27091__$1 = cljs.core.nth.call(null,inst_27088,(0),null);
var inst_27092 = cljs.core.nth.call(null,inst_27088,(1),null);
var inst_27093 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"ko","ko",-626263540),inst_27091__$1);
var state_27126__$1 = (function (){var statearr_27140 = state_27126;
(statearr_27140[(8)] = inst_27092);

(statearr_27140[(9)] = inst_27091__$1);

return statearr_27140;
})();
if(inst_27093){
var statearr_27141_27402 = state_27126__$1;
(statearr_27141_27402[(1)] = (8));

} else {
var statearr_27142_27403 = state_27126__$1;
(statearr_27142_27403[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27127 === (10))){
var inst_27118 = (state_27126[(2)]);
var state_27126__$1 = (function (){var statearr_27143 = state_27126;
(statearr_27143[(12)] = inst_27118);

return statearr_27143;
})();
var statearr_27144_27404 = state_27126__$1;
(statearr_27144_27404[(2)] = null);

(statearr_27144_27404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27127 === (8))){
var inst_27092 = (state_27126[(8)]);
var inst_27095 = [cljs.core.str("An error has occured during action : "),cljs.core.str(inst_27092)].join('');
var inst_27096 = cljs.core.prn.call(null,inst_27095);
var state_27126__$1 = (function (){var statearr_27145 = state_27126;
(statearr_27145[(13)] = inst_27096);

return statearr_27145;
})();
var statearr_27146_27405 = state_27126__$1;
(statearr_27146_27405[(2)] = null);

(statearr_27146_27405[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23323__auto___27391,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
;
return ((function (switch__23302__auto__,c__23323__auto___27391,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function() {
var dragonmark$inputs$core$state_machine__23303__auto__ = null;
var dragonmark$inputs$core$state_machine__23303__auto____0 = (function (){
var statearr_27150 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27150[(0)] = dragonmark$inputs$core$state_machine__23303__auto__);

(statearr_27150[(1)] = (1));

return statearr_27150;
});
var dragonmark$inputs$core$state_machine__23303__auto____1 = (function (state_27126){
while(true){
var ret_value__23304__auto__ = (function (){try{while(true){
var result__23305__auto__ = switch__23302__auto__.call(null,state_27126);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23305__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23305__auto__;
}
break;
}
}catch (e27151){if((e27151 instanceof Object)){
var ex__23306__auto__ = e27151;
var statearr_27152_27406 = state_27126;
(statearr_27152_27406[(5)] = ex__23306__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27126);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27151;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23304__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27407 = state_27126;
state_27126 = G__27407;
continue;
} else {
return ret_value__23304__auto__;
}
break;
}
});
dragonmark$inputs$core$state_machine__23303__auto__ = function(state_27126){
switch(arguments.length){
case 0:
return dragonmark$inputs$core$state_machine__23303__auto____0.call(this);
case 1:
return dragonmark$inputs$core$state_machine__23303__auto____1.call(this,state_27126);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
dragonmark$inputs$core$state_machine__23303__auto__.cljs$core$IFn$_invoke$arity$0 = dragonmark$inputs$core$state_machine__23303__auto____0;
dragonmark$inputs$core$state_machine__23303__auto__.cljs$core$IFn$_invoke$arity$1 = dragonmark$inputs$core$state_machine__23303__auto____1;
return dragonmark$inputs$core$state_machine__23303__auto__;
})()
;})(switch__23302__auto__,c__23323__auto___27391,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
})();
var state__23325__auto__ = (function (){var statearr_27153 = f__23324__auto__.call(null);
(statearr_27153[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23323__auto___27391);

return statearr_27153;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23325__auto__);
});})(c__23323__auto___27391,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
);


var c__23323__auto___27408 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23323__auto___27408,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function (){
var f__23324__auto__ = (function (){var switch__23302__auto__ = ((function (c__23323__auto___27408,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function (state_27212){
var state_val_27213 = (state_27212[(1)]);
if((state_val_27213 === (7))){
var inst_27208 = (state_27212[(2)]);
var state_27212__$1 = state_27212;
var statearr_27214_27409 = state_27212__$1;
(statearr_27214_27409[(2)] = inst_27208);

(statearr_27214_27409[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27213 === (20))){
var inst_27179 = cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.channels.ManyToManyChannel,action);
var state_27212__$1 = state_27212;
var statearr_27215_27410 = state_27212__$1;
(statearr_27215_27410[(2)] = inst_27179);

(statearr_27215_27410[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27213 === (1))){
var state_27212__$1 = state_27212;
var statearr_27216_27411 = state_27212__$1;
(statearr_27216_27411[(2)] = null);

(statearr_27216_27411[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27213 === (24))){
var inst_27164 = (state_27212[(7)]);
var inst_27158 = (state_27212[(8)]);
var inst_27166 = (state_27212[(9)]);
var inst_27165 = (state_27212[(10)]);
var inst_27195 = (function (){var okay = inst_27158;
var v = inst_27164;
var raw = inst_27165;
var coerced = inst_27166;
var temp__4425__auto__ = action;
var to_do = action;
return ((function (okay,v,raw,coerced,temp__4425__auto__,to_do,inst_27164,inst_27158,inst_27166,inst_27165,state_val_27213,c__23323__auto___27408,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function (){
return to_do.call(null,coerced,app,this$);
});
;})(okay,v,raw,coerced,temp__4425__auto__,to_do,inst_27164,inst_27158,inst_27166,inst_27165,state_val_27213,c__23323__auto___27408,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
})();
var inst_27196 = setTimeout(inst_27195,(10));
var state_27212__$1 = state_27212;
var statearr_27217_27412 = state_27212__$1;
(statearr_27217_27412[(2)] = inst_27196);

(statearr_27217_27412[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27213 === (4))){
var inst_27156 = (state_27212[(2)]);
var state_27212__$1 = state_27212;
if(cljs.core.truth_(inst_27156)){
var statearr_27218_27413 = state_27212__$1;
(statearr_27218_27413[(1)] = (5));

} else {
var statearr_27219_27414 = state_27212__$1;
(statearr_27219_27414[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27213 === (15))){
var inst_27186 = cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.channels.ManyToManyChannel,action);
var state_27212__$1 = state_27212;
var statearr_27220_27415 = state_27212__$1;
(statearr_27220_27415[(2)] = inst_27186);

(statearr_27220_27415[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27213 === (21))){
var state_27212__$1 = state_27212;
var statearr_27221_27416 = state_27212__$1;
(statearr_27221_27416[(2)] = false);

(statearr_27221_27416[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27213 === (13))){
var inst_27201 = (state_27212[(2)]);
var inst_27202 = close_channels.call(null,this$);
var state_27212__$1 = (function (){var statearr_27222 = state_27212;
(statearr_27222[(11)] = inst_27201);

return statearr_27222;
})();
var statearr_27223_27417 = state_27212__$1;
(statearr_27223_27417[(2)] = inst_27202);

(statearr_27223_27417[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27213 === (22))){
var inst_27182 = (state_27212[(2)]);
var state_27212__$1 = state_27212;
var statearr_27224_27418 = state_27212__$1;
(statearr_27224_27418[(2)] = inst_27182);

(statearr_27224_27418[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27213 === (6))){
var state_27212__$1 = state_27212;
var statearr_27225_27419 = state_27212__$1;
(statearr_27225_27419[(2)] = null);

(statearr_27225_27419[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27213 === (25))){
var inst_27198 = (state_27212[(2)]);
var state_27212__$1 = state_27212;
var statearr_27226_27420 = state_27212__$1;
(statearr_27226_27420[(2)] = inst_27198);

(statearr_27226_27420[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27213 === (17))){
var state_27212__$1 = state_27212;
var statearr_27227_27421 = state_27212__$1;
(statearr_27227_27421[(2)] = true);

(statearr_27227_27421[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27213 === (3))){
var inst_27210 = (state_27212[(2)]);
var state_27212__$1 = state_27212;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27212__$1,inst_27210);
} else {
if((state_val_27213 === (12))){
var state_27212__$1 = state_27212;
var statearr_27228_27422 = state_27212__$1;
(statearr_27228_27422[(2)] = null);

(statearr_27228_27422[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27213 === (2))){
var state_27212__$1 = state_27212;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27212__$1,(4),action_chan);
} else {
if((state_val_27213 === (23))){
var inst_27166 = (state_27212[(9)]);
var inst_27190 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27191 = [inst_27166,app,this$];
var inst_27192 = (new cljs.core.PersistentVector(null,3,(5),inst_27190,inst_27191,null));
var inst_27193 = cljs.core.async.put_BANG_.call(null,action,inst_27192);
var state_27212__$1 = state_27212;
var statearr_27229_27423 = state_27212__$1;
(statearr_27229_27423[(2)] = inst_27193);

(statearr_27229_27423[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27213 === (19))){
var inst_27184 = (state_27212[(2)]);
var state_27212__$1 = state_27212;
var statearr_27230_27424 = state_27212__$1;
(statearr_27230_27424[(2)] = inst_27184);

(statearr_27230_27424[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27213 === (11))){
var inst_27169 = (action == null);
var inst_27170 = cljs.core.not.call(null,inst_27169);
var state_27212__$1 = state_27212;
if(inst_27170){
var statearr_27231_27425 = state_27212__$1;
(statearr_27231_27425[(1)] = (14));

} else {
var statearr_27232_27426 = state_27212__$1;
(statearr_27232_27426[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27213 === (9))){
var state_27212__$1 = state_27212;
var statearr_27233_27427 = state_27212__$1;
(statearr_27233_27427[(2)] = null);

(statearr_27233_27427[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27213 === (5))){
var inst_27158 = (state_27212[(8)]);
var inst_27158__$1 = do_validation.call(null);
var state_27212__$1 = (function (){var statearr_27234 = state_27212;
(statearr_27234[(8)] = inst_27158__$1);

return statearr_27234;
})();
if(cljs.core.truth_(inst_27158__$1)){
var statearr_27235_27428 = state_27212__$1;
(statearr_27235_27428[(1)] = (8));

} else {
var statearr_27236_27429 = state_27212__$1;
(statearr_27236_27429[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27213 === (14))){
var inst_27172 = action.cljs$core$async$impl$channels$ManyToManyChannel$;
var inst_27173 = (false) || (inst_27172);
var state_27212__$1 = state_27212;
if(cljs.core.truth_(inst_27173)){
var statearr_27237_27430 = state_27212__$1;
(statearr_27237_27430[(1)] = (17));

} else {
var statearr_27238_27431 = state_27212__$1;
(statearr_27238_27431[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27213 === (16))){
var inst_27188 = (state_27212[(2)]);
var state_27212__$1 = state_27212;
if(cljs.core.truth_(inst_27188)){
var statearr_27239_27432 = state_27212__$1;
(statearr_27239_27432[(1)] = (23));

} else {
var statearr_27240_27433 = state_27212__$1;
(statearr_27240_27433[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27213 === (10))){
var inst_27205 = (state_27212[(2)]);
var state_27212__$1 = state_27212;
var statearr_27241_27434 = state_27212__$1;
(statearr_27241_27434[(2)] = inst_27205);

(statearr_27241_27434[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27213 === (18))){
var inst_27176 = action.cljs$lang$protocol_mask$partition$;
var inst_27177 = (!inst_27176);
var state_27212__$1 = state_27212;
if(cljs.core.truth_(inst_27177)){
var statearr_27242_27435 = state_27212__$1;
(statearr_27242_27435[(1)] = (20));

} else {
var statearr_27243_27436 = state_27212__$1;
(statearr_27243_27436[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27213 === (8))){
var inst_27164 = (state_27212[(7)]);
var inst_27165 = (state_27212[(10)]);
var inst_27160 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27161 = [new cljs.core.Keyword(null,"action-state","action-state",-1575944631),new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_27162 = (new cljs.core.PersistentVector(null,2,(5),inst_27160,inst_27161,null));
var inst_27163 = dragonmark.inputs.extern.set_state_BANG_.call(null,this$,inst_27162,new cljs.core.Keyword(null,"active","active",1895962068));
var inst_27164__$1 = dragonmark.inputs.extern.get_state.call(null,this$,new cljs.core.Keyword(null,"inputs","inputs",865803858));
var inst_27165__$1 = dragonmark.inputs.validation.pre_validation.call(null,inst_27164__$1);
var inst_27166 = schema_coercer.call(null,inst_27165__$1);
var state_27212__$1 = (function (){var statearr_27244 = state_27212;
(statearr_27244[(7)] = inst_27164__$1);

(statearr_27244[(12)] = inst_27163);

(statearr_27244[(9)] = inst_27166);

(statearr_27244[(10)] = inst_27165__$1);

return statearr_27244;
})();
if(cljs.core.truth_(action)){
var statearr_27245_27437 = state_27212__$1;
(statearr_27245_27437[(1)] = (11));

} else {
var statearr_27246_27438 = state_27212__$1;
(statearr_27246_27438[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23323__auto___27408,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
;
return ((function (switch__23302__auto__,c__23323__auto___27408,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function() {
var dragonmark$inputs$core$state_machine__23303__auto__ = null;
var dragonmark$inputs$core$state_machine__23303__auto____0 = (function (){
var statearr_27250 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27250[(0)] = dragonmark$inputs$core$state_machine__23303__auto__);

(statearr_27250[(1)] = (1));

return statearr_27250;
});
var dragonmark$inputs$core$state_machine__23303__auto____1 = (function (state_27212){
while(true){
var ret_value__23304__auto__ = (function (){try{while(true){
var result__23305__auto__ = switch__23302__auto__.call(null,state_27212);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23305__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23305__auto__;
}
break;
}
}catch (e27251){if((e27251 instanceof Object)){
var ex__23306__auto__ = e27251;
var statearr_27252_27439 = state_27212;
(statearr_27252_27439[(5)] = ex__23306__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27212);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27251;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23304__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27440 = state_27212;
state_27212 = G__27440;
continue;
} else {
return ret_value__23304__auto__;
}
break;
}
});
dragonmark$inputs$core$state_machine__23303__auto__ = function(state_27212){
switch(arguments.length){
case 0:
return dragonmark$inputs$core$state_machine__23303__auto____0.call(this);
case 1:
return dragonmark$inputs$core$state_machine__23303__auto____1.call(this,state_27212);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
dragonmark$inputs$core$state_machine__23303__auto__.cljs$core$IFn$_invoke$arity$0 = dragonmark$inputs$core$state_machine__23303__auto____0;
dragonmark$inputs$core$state_machine__23303__auto__.cljs$core$IFn$_invoke$arity$1 = dragonmark$inputs$core$state_machine__23303__auto____1;
return dragonmark$inputs$core$state_machine__23303__auto__;
})()
;})(switch__23302__auto__,c__23323__auto___27408,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
})();
var state__23325__auto__ = (function (){var statearr_27253 = f__23324__auto__.call(null);
(statearr_27253[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23323__auto___27408);

return statearr_27253;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23325__auto__);
});})(c__23323__auto___27408,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
);


var c__23323__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23323__auto__,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function (){
var f__23324__auto__ = (function (){var switch__23302__auto__ = ((function (c__23323__auto__,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function (state_27312){
var state_val_27313 = (state_27312[(1)]);
if((state_val_27313 === (7))){
var inst_27308 = (state_27312[(2)]);
var state_27312__$1 = state_27312;
var statearr_27314_27441 = state_27312__$1;
(statearr_27314_27441[(2)] = inst_27308);

(statearr_27314_27441[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27313 === (1))){
var state_27312__$1 = state_27312;
var statearr_27315_27442 = state_27312__$1;
(statearr_27315_27442[(2)] = null);

(statearr_27315_27442[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27313 === (4))){
var inst_27256 = (state_27312[(7)]);
var inst_27256__$1 = (state_27312[(2)]);
var state_27312__$1 = (function (){var statearr_27316 = state_27312;
(statearr_27316[(7)] = inst_27256__$1);

return statearr_27316;
})();
if(cljs.core.truth_(inst_27256__$1)){
var statearr_27317_27443 = state_27312__$1;
(statearr_27317_27443[(1)] = (5));

} else {
var statearr_27318_27444 = state_27312__$1;
(statearr_27318_27444[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27313 === (15))){
var inst_27259 = (state_27312[(8)]);
var inst_27260 = (state_27312[(9)]);
var inst_27256 = (state_27312[(7)]);
var inst_27283 = (function (){var temp__4425__auto__ = inst_27256;
var vec__27258 = inst_27256;
var k = inst_27259;
var v = inst_27260;
var pred__27261 = cljs.core._EQ_;
var expr__27262 = inst_27259;
return ((function (temp__4425__auto__,vec__27258,k,v,pred__27261,expr__27262,inst_27259,inst_27260,inst_27256,state_val_27313,c__23323__auto__,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function (n,_){
return n;
});
;})(temp__4425__auto__,vec__27258,k,v,pred__27261,expr__27262,inst_27259,inst_27260,inst_27256,state_val_27313,c__23323__auto__,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
})();
var inst_27284 = cljs.core.get.call(null,typing_controls,inst_27259,inst_27283);
var inst_27285 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27286 = [inst_27259,new cljs.core.Keyword(null,"post-typing","post-typing",129196416)];
var inst_27287 = (new cljs.core.PersistentVector(null,2,(5),inst_27285,inst_27286,null));
var inst_27288 = cljs.core.get_in.call(null,opts,inst_27287,cljs.core.identity);
var inst_27289 = inst_27288.call(null,inst_27260);
var inst_27290 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27291 = [new cljs.core.Keyword(null,"inputs","inputs",865803858),inst_27259,new cljs.core.Keyword(null,"value","value",305978217)];
var inst_27292 = (new cljs.core.PersistentVector(null,3,(5),inst_27290,inst_27291,null));
var inst_27293 = dragonmark.inputs.extern.get_state.call(null,this$,inst_27292);
var inst_27294 = inst_27284.call(null,inst_27289,inst_27293);
var inst_27295 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27296 = [new cljs.core.Keyword(null,"inputs","inputs",865803858),inst_27259,new cljs.core.Keyword(null,"value","value",305978217)];
var inst_27297 = (new cljs.core.PersistentVector(null,3,(5),inst_27295,inst_27296,null));
var inst_27298 = dragonmark.inputs.extern.set_state_BANG_.call(null,this$,inst_27297,inst_27294);
var state_27312__$1 = state_27312;
var statearr_27319_27445 = state_27312__$1;
(statearr_27319_27445[(2)] = inst_27298);

(statearr_27319_27445[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27313 === (13))){
var inst_27302 = (state_27312[(2)]);
var state_27312__$1 = state_27312;
var statearr_27320_27446 = state_27312__$1;
(statearr_27320_27446[(2)] = inst_27302);

(statearr_27320_27446[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27313 === (6))){
var state_27312__$1 = state_27312;
var statearr_27321_27447 = state_27312__$1;
(statearr_27321_27447[(2)] = null);

(statearr_27321_27447[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27313 === (3))){
var inst_27310 = (state_27312[(2)]);
var state_27312__$1 = state_27312;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27312__$1,inst_27310);
} else {
if((state_val_27313 === (12))){
var inst_27259 = (state_27312[(8)]);
var inst_27279 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"validate","validate",-201300827),inst_27259);
var state_27312__$1 = state_27312;
if(inst_27279){
var statearr_27322_27448 = state_27312__$1;
(statearr_27322_27448[(1)] = (14));

} else {
var statearr_27323_27449 = state_27312__$1;
(statearr_27323_27449[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27313 === (2))){
var state_27312__$1 = state_27312;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27312__$1,(4),chan);
} else {
if((state_val_27313 === (11))){
var inst_27259 = (state_27312[(8)]);
var inst_27260 = (state_27312[(9)]);
var inst_27256 = (state_27312[(7)]);
var inst_27273 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27274 = [new cljs.core.Keyword(null,"inputs","inputs",865803858),inst_27260];
var inst_27275 = (new cljs.core.PersistentVector(null,2,(5),inst_27273,inst_27274,null));
var inst_27276 = (function (){var temp__4425__auto__ = inst_27256;
var vec__27258 = inst_27256;
var k = inst_27259;
var v = inst_27260;
var pred__27261 = cljs.core._EQ_;
var expr__27262 = inst_27259;
return ((function (temp__4425__auto__,vec__27258,k,v,pred__27261,expr__27262,inst_27259,inst_27260,inst_27256,inst_27273,inst_27274,inst_27275,state_val_27313,c__23323__auto__,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function (p1__27010_SHARP_){
return cljs.core.dissoc.call(null,p1__27010_SHARP_,new cljs.core.Keyword(null,"error","error",-978969032));
});
;})(temp__4425__auto__,vec__27258,k,v,pred__27261,expr__27262,inst_27259,inst_27260,inst_27256,inst_27273,inst_27274,inst_27275,state_val_27313,c__23323__auto__,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
})();
var inst_27277 = dragonmark.inputs.extern.update_state_BANG_.call(null,this$,inst_27275,inst_27276);
var state_27312__$1 = state_27312;
var statearr_27324_27450 = state_27312__$1;
(statearr_27324_27450[(2)] = inst_27277);

(statearr_27324_27450[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27313 === (9))){
var inst_27259 = (state_27312[(8)]);
var inst_27271 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"kill-mess","kill-mess",723475912),inst_27259);
var state_27312__$1 = state_27312;
if(inst_27271){
var statearr_27325_27451 = state_27312__$1;
(statearr_27325_27451[(1)] = (11));

} else {
var statearr_27326_27452 = state_27312__$1;
(statearr_27326_27452[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27313 === (5))){
var inst_27259 = (state_27312[(8)]);
var inst_27256 = (state_27312[(7)]);
var inst_27259__$1 = cljs.core.nth.call(null,inst_27256,(0),null);
var inst_27260 = cljs.core.nth.call(null,inst_27256,(1),null);
var inst_27264 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"focus","focus",234677911),inst_27259__$1);
var state_27312__$1 = (function (){var statearr_27327 = state_27312;
(statearr_27327[(8)] = inst_27259__$1);

(statearr_27327[(9)] = inst_27260);

return statearr_27327;
})();
if(inst_27264){
var statearr_27328_27453 = state_27312__$1;
(statearr_27328_27453[(1)] = (8));

} else {
var statearr_27329_27454 = state_27312__$1;
(statearr_27329_27454[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27313 === (14))){
var inst_27281 = do_validation.call(null);
var state_27312__$1 = state_27312;
var statearr_27330_27455 = state_27312__$1;
(statearr_27330_27455[(2)] = inst_27281);

(statearr_27330_27455[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27313 === (16))){
var inst_27300 = (state_27312[(2)]);
var state_27312__$1 = state_27312;
var statearr_27331_27456 = state_27312__$1;
(statearr_27331_27456[(2)] = inst_27300);

(statearr_27331_27456[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27313 === (10))){
var inst_27304 = (state_27312[(2)]);
var state_27312__$1 = (function (){var statearr_27332 = state_27312;
(statearr_27332[(10)] = inst_27304);

return statearr_27332;
})();
var statearr_27333_27457 = state_27312__$1;
(statearr_27333_27457[(2)] = null);

(statearr_27333_27457[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27313 === (8))){
var inst_27260 = (state_27312[(9)]);
var inst_27266 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27267 = [new cljs.core.Keyword(null,"inputs","inputs",865803858),inst_27260,new cljs.core.Keyword(null,"focus","focus",234677911)];
var inst_27268 = (new cljs.core.PersistentVector(null,3,(5),inst_27266,inst_27267,null));
var inst_27269 = dragonmark.inputs.extern.update_state_BANG_.call(null,this$,inst_27268,cljs.core.not);
var state_27312__$1 = state_27312;
var statearr_27334_27458 = state_27312__$1;
(statearr_27334_27458[(2)] = inst_27269);

(statearr_27334_27458[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23323__auto__,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
;
return ((function (switch__23302__auto__,c__23323__auto__,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function() {
var dragonmark$inputs$core$state_machine__23303__auto__ = null;
var dragonmark$inputs$core$state_machine__23303__auto____0 = (function (){
var statearr_27338 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27338[(0)] = dragonmark$inputs$core$state_machine__23303__auto__);

(statearr_27338[(1)] = (1));

return statearr_27338;
});
var dragonmark$inputs$core$state_machine__23303__auto____1 = (function (state_27312){
while(true){
var ret_value__23304__auto__ = (function (){try{while(true){
var result__23305__auto__ = switch__23302__auto__.call(null,state_27312);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23305__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23305__auto__;
}
break;
}
}catch (e27339){if((e27339 instanceof Object)){
var ex__23306__auto__ = e27339;
var statearr_27340_27459 = state_27312;
(statearr_27340_27459[(5)] = ex__23306__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27312);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27339;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23304__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27460 = state_27312;
state_27312 = G__27460;
continue;
} else {
return ret_value__23304__auto__;
}
break;
}
});
dragonmark$inputs$core$state_machine__23303__auto__ = function(state_27312){
switch(arguments.length){
case 0:
return dragonmark$inputs$core$state_machine__23303__auto____0.call(this);
case 1:
return dragonmark$inputs$core$state_machine__23303__auto____1.call(this,state_27312);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
dragonmark$inputs$core$state_machine__23303__auto__.cljs$core$IFn$_invoke$arity$0 = dragonmark$inputs$core$state_machine__23303__auto____0;
dragonmark$inputs$core$state_machine__23303__auto__.cljs$core$IFn$_invoke$arity$1 = dragonmark$inputs$core$state_machine__23303__auto____1;
return dragonmark$inputs$core$state_machine__23303__auto__;
})()
;})(switch__23302__auto__,c__23323__auto__,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
})();
var state__23325__auto__ = (function (){var statearr_27341 = f__23324__auto__.call(null);
(statearr_27341[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23323__auto__);

return statearr_27341;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23325__auto__);
});})(c__23323__auto__,map__27048,map__27048__$1,chan,action_chan,created_chan,clean_chan,do_validation,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
);

return c__23323__auto__;
});})(order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
,new cljs.core.Keyword(null,"component-did-mount","component-did-mount",-1126910518),((function (order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function (this$){
return dragonmark.inputs.core.handle_date_fields_BANG_.call(null,this$,dragonmark.inputs.date_utils.default_fmt,opts);
});})(order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
,new cljs.core.Keyword(null,"component-will-unmount","component-will-unmount",-2058314698),((function (order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function (this$){
return close_channels.call(null,this$);
});})(order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
,new cljs.core.Keyword(null,"component-will-update","component-will-update",335247566),((function (order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function (this$,next_props,next_state){
return null;
});})(order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
,new cljs.core.Keyword(null,"render","render",-1408033454),((function (order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function (this$){
var map__27342 = dragonmark.inputs.extern.get_state.call(null,this$);
var map__27342__$1 = ((((!((map__27342 == null)))?((((map__27342.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27342.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27342):map__27342);
var state = map__27342__$1;
var chan = cljs.core.get.call(null,map__27342__$1,new cljs.core.Keyword(null,"chan","chan",-2103021695));
var inputs = cljs.core.get.call(null,map__27342__$1,new cljs.core.Keyword(null,"inputs","inputs",865803858));
var action_state = cljs.core.get.call(null,map__27342__$1,new cljs.core.Keyword(null,"action-state","action-state",-1575944631));
var dyn_opts = cljs.core.get.call(null,map__27342__$1,new cljs.core.Keyword(null,"dyn-opts","dyn-opts",-1763725899));
var labels = dragonmark.inputs.i18n.comp_i18n.call(null,this$,comp_name,schema__$1,opts);
var title = cljs.core.get_in.call(null,labels,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"title","title",636505583)], null));
var opts__$1 = cljs.core.merge_with.call(null,cljs.core.merge,opts,dyn_opts);
var comp_class = cljs.core.get_in.call(null,opts__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [comp_name,new cljs.core.Keyword(null,"className","className",-1983287057)], null));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"className","className",-1983287057),dragonmark.inputs.core.styles.call(null,"panel panel-default",comp_class),new cljs.core.Keyword(null,"key","key",-1516042587),dragonmark.inputs.utils.full_name.call(null,comp_name),new cljs.core.Keyword(null,"ref","ref",1289896967),dragonmark.inputs.utils.full_name.call(null,comp_name),new cljs.core.Keyword(null,"id","id",-1388402092),dragonmark.inputs.utils.full_name.call(null,comp_name)], null),(cljs.core.truth_(title)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"panel-heading"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h3","h3",2067611163),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"panel-title"], null),title], null)], null):null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"className","className",-1983287057),"panel-body",new cljs.core.Keyword(null,"role","role",-736691072),"form"], null),cljs.core.into.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"inputs-group"], null)], null),(cljs.core.truth_(order)?cljs.core.map.call(null,((function (labels,title,opts__$1,comp_class,map__27342,map__27342__$1,state,chan,inputs,action_state,dyn_opts,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function (k){
return dragonmark.inputs.core.build_input.call(null,this$,cljs.core.assoc.call(null,k.call(null,opts__$1),new cljs.core.Keyword(null,"k","k",-2146297393),k,new cljs.core.Keyword(null,"k-sch","k-sch",-193796815),dragonmark.inputs.schema_utils.get_sch.call(null,schema__$1,k),new cljs.core.Keyword(null,"i18n","i18n",-563422499),k.call(null,labels)));
});})(labels,title,opts__$1,comp_class,map__27342,map__27342__$1,state,chan,inputs,action_state,dyn_opts,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
,order):cljs.core.map.call(null,((function (labels,title,opts__$1,comp_class,map__27342,map__27342__$1,state,chan,inputs,action_state,dyn_opts,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359){
return (function (p__27344){
var vec__27345 = p__27344;
var k = cljs.core.nth.call(null,vec__27345,(0),null);
var t = cljs.core.nth.call(null,vec__27345,(1),null);
var k__$1 = (((k instanceof cljs.core.Keyword))?k:new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(k));
return dragonmark.inputs.core.build_input.call(null,this$,cljs.core.assoc.call(null,k__$1.call(null,opts__$1),new cljs.core.Keyword(null,"k","k",-2146297393),k__$1,new cljs.core.Keyword(null,"k-sch","k-sch",-193796815),t,new cljs.core.Keyword(null,"i18n","i18n",-563422499),k__$1.call(null,labels)));
});})(labels,title,opts__$1,comp_class,map__27342,map__27342__$1,state,chan,inputs,action_state,dyn_opts,order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
,schema__$1))),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"panel-button"], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [dragonmark.inputs.extern.build_component.call(null,dragonmark.inputs.core.button_view,state,this$,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"state","state",-1988618099),state,new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"k","k",-2146297393),new cljs.core.Keyword(null,"action","action",-811238024),new cljs.core.Keyword(null,"labels","labels",-626734591),(function (){var or__18528__auto__ = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(labels);
if(cljs.core.truth_(or__18528__auto__)){
return or__18528__auto__;
} else {
return "Submit";
}
})(),new cljs.core.Keyword(null,"comp-name","comp-name",-474371587),comp_name,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),cljs.core.get_in.call(null,opts__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"action","action",-811238024),new cljs.core.Keyword(null,"attrs","attrs",-2090668713)], null))], null)], null))], null)], null)], null)], null);
});})(order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
], null));
});
;})(order,verily_rules,schema_coercer,validation,checker,unit_coercers,unit_validators,remove_errs_fn,typing_controls,initial_bs,initial_action_state,close_channels,validate__20921__auto__,ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
break;
}
})();
if(cljs.core.truth_(validate__20921__auto__)){
var temp__4425__auto___27461 = output_checker27031_27359.call(null,o__20924__auto__);
if(cljs.core.truth_(temp__4425__auto___27461)){
var error__20923__auto___27462 = temp__4425__auto___27461;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"make-input-comp","make-input-comp",1804483332,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Build an input form Om component based on a prismatic/Schema"], null)),cljs.core.pr_str.call(null,error__20923__auto___27462)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema27011_27347,new cljs.core.Keyword(null,"value","value",305978217),o__20924__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__20923__auto___27462], null));
} else {
}
} else {
}

return o__20924__auto__;
});})(ufv___27346,output_schema27011_27347,input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351,input_checker27013_27352,output_checker27014_27353,input_checker27017_27354,output_checker27018_27355,input_checker27023_27356,output_checker27024_27357,input_checker27030_27358,output_checker27031_27359))
;

dragonmark.inputs.core.make_input_comp.cljs$lang$maxFixedArity = 5;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,dragonmark.inputs.core.make_input_comp),schema.core.make_fn_schema.call(null,output_schema27011_27347,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema27012_27348,input_schema27016_27349,input_schema27022_27350,input_schema27029_27351], null)));

//# sourceMappingURL=core.js.map