// Compiled by ClojureScript 1.10.520 {}
goog.provide('threeagent.impl.scene');
goog.require('cljs.core');
goog.require('threeagent.impl.virtual_scene');
goog.require('threeagent.impl.util');
goog.require('threeagent.impl.threejs');
goog.require('threeagent.impl.component');
goog.require('module$C_$dev$threeagent$node_modules$three$build$three_module');
goog.require('cljs.core');
threeagent.impl.scene.create_object = (function threeagent$impl$scene$create_object(node_data){
var comp_config = new cljs.core.Keyword(null,"component-config","component-config",2000790546).cljs$core$IFn$_invoke$arity$1(node_data);
var obj = threeagent.impl.component.render_component.call(null,new cljs.core.Keyword(null,"component-key","component-key",1189239034).cljs$core$IFn$_invoke$arity$1(node_data),comp_config);
threeagent.impl.threejs.set_position_BANG_.call(null,obj,new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$1(node_data));

threeagent.impl.threejs.set_rotation_BANG_.call(null,obj,new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$1(node_data));

threeagent.impl.threejs.set_scale_BANG_.call(null,obj,new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$1(node_data));

return obj;
});
threeagent.impl.scene.set_node_object = (function threeagent$impl$scene$set_node_object(context,node,node_data,obj){
node.threejs = obj;

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"camera","camera",-1190348585),new cljs.core.Keyword(null,"component-key","component-key",1189239034).cljs$core$IFn$_invoke$arity$1(node_data))){
return context.camera = obj;
} else {
return null;
}
});
threeagent.impl.scene.add_node = (function threeagent$impl$scene$add_node(context,parent_object,node){
try{var node_data = node.data;
var comp_config = new cljs.core.Keyword(null,"component-config","component-config",2000790546).cljs$core$IFn$_invoke$arity$1(node_data);
var obj = threeagent.impl.scene.create_object.call(null,node_data);
threeagent.impl.scene.set_node_object.call(null,context,node,node_data,obj);

parent_object.add(obj);

node.for_each_child(cljs.core.partial.call(null,threeagent.impl.scene.add_node,context,obj));

var temp__5457__auto___2637 = new cljs.core.Keyword(null,"on-added","on-added",-54041858).cljs$core$IFn$_invoke$arity$1(node.meta);
if(cljs.core.truth_(temp__5457__auto___2637)){
var callback_2638 = temp__5457__auto___2637;
callback_2638.call(null,obj);
} else {
}

return obj;
}catch (e2636){var e = e2636;
threeagent.impl.util.log.call(null,"Failed to add node");

threeagent.impl.util.log.call(null,e);

return cljs.core.println.call(null,node);
}});
threeagent.impl.scene.remove_node_BANG_ = (function threeagent$impl$scene$remove_node_BANG_(node){
var obj = node.threejs;
var parent_obj = node.parent.threejs;
var temp__5457__auto___2639 = new cljs.core.Keyword(null,"on-removed","on-removed",-1308728142).cljs$core$IFn$_invoke$arity$1(node.meta);
if(cljs.core.truth_(temp__5457__auto___2639)){
var callback_2640 = temp__5457__auto___2639;
callback_2640.call(null,obj);
} else {
}

parent_obj.remove(obj);

return node.for_each_child(threeagent.impl.scene.remove_node_BANG_);
});
threeagent.impl.scene.init_scene = (function threeagent$impl$scene$init_scene(context,virtual_scene,scene_root){
return threeagent.impl.scene.add_node.call(null,context,scene_root,virtual_scene.root);
});
threeagent.impl.scene.diff_data = (function threeagent$impl$scene$diff_data(o,n){
var this$ = ((((cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"component-config","component-config",2000790546).cljs$core$IFn$_invoke$arity$1(o),new cljs.core.Keyword(null,"component-config","component-config",2000790546).cljs$core$IFn$_invoke$arity$1(n))) || (cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"component-key","component-key",1189239034).cljs$core$IFn$_invoke$arity$1(o),new cljs.core.Keyword(null,"component-key","component-key",1189239034).cljs$core$IFn$_invoke$arity$1(n)))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [o,n], null):null);
var position = ((cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$1(o),new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$1(n)))?new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$1(n):null);
var rotation = ((cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$1(o),new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$1(n)))?new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$1(n):null);
var scale = ((cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$1(o),new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$1(n)))?new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$1(n):null);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"this","this",-611633625),this$,new cljs.core.Keyword(null,"scale","scale",-230427353),scale,new cljs.core.Keyword(null,"position","position",-2011731912),position,new cljs.core.Keyword(null,"rotation","rotation",-1728051644),rotation], null);
});
threeagent.impl.scene.update_node_BANG_ = (function threeagent$impl$scene$update_node_BANG_(context,node,old_data,new_data){
var diff = threeagent.impl.scene.diff_data.call(null,old_data,new_data);
var old_obj = node.threejs;
var metadata = node.meta;
var this$ = new cljs.core.Keyword(null,"this","this",-611633625).cljs$core$IFn$_invoke$arity$1(diff);
if(cljs.core.truth_(this$)){
try{var vec__2642 = this$;
var o = cljs.core.nth.call(null,vec__2642,(0),null);
var n = cljs.core.nth.call(null,vec__2642,(1),null);
var parent_obj = old_obj.parent;
var children = old_obj.children;
var new_obj = threeagent.impl.scene.create_object.call(null,new_data);
var temp__5457__auto___2649 = new cljs.core.Keyword(null,"on-removed","on-removed",-1308728142).cljs$core$IFn$_invoke$arity$1(metadata);
if(cljs.core.truth_(temp__5457__auto___2649)){
var callback_2650 = temp__5457__auto___2649;
callback_2650.call(null,old_obj);
} else {
}

threeagent.impl.scene.set_node_object.call(null,context,node,new_data,new_obj);

parent_obj.remove(old_obj);

parent_obj.add(new_obj);

var seq__2645_2651 = cljs.core.seq.call(null,children);
var chunk__2646_2652 = null;
var count__2647_2653 = (0);
var i__2648_2654 = (0);
while(true){
if((i__2648_2654 < count__2647_2653)){
var child_2655 = cljs.core._nth.call(null,chunk__2646_2652,i__2648_2654);
new_obj.add(child_2655);


var G__2656 = seq__2645_2651;
var G__2657 = chunk__2646_2652;
var G__2658 = count__2647_2653;
var G__2659 = (i__2648_2654 + (1));
seq__2645_2651 = G__2656;
chunk__2646_2652 = G__2657;
count__2647_2653 = G__2658;
i__2648_2654 = G__2659;
continue;
} else {
var temp__5457__auto___2660 = cljs.core.seq.call(null,seq__2645_2651);
if(temp__5457__auto___2660){
var seq__2645_2661__$1 = temp__5457__auto___2660;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__2645_2661__$1)){
var c__4550__auto___2662 = cljs.core.chunk_first.call(null,seq__2645_2661__$1);
var G__2663 = cljs.core.chunk_rest.call(null,seq__2645_2661__$1);
var G__2664 = c__4550__auto___2662;
var G__2665 = cljs.core.count.call(null,c__4550__auto___2662);
var G__2666 = (0);
seq__2645_2651 = G__2663;
chunk__2646_2652 = G__2664;
count__2647_2653 = G__2665;
i__2648_2654 = G__2666;
continue;
} else {
var child_2667 = cljs.core.first.call(null,seq__2645_2661__$1);
new_obj.add(child_2667);


var G__2668 = cljs.core.next.call(null,seq__2645_2661__$1);
var G__2669 = null;
var G__2670 = (0);
var G__2671 = (0);
seq__2645_2651 = G__2668;
chunk__2646_2652 = G__2669;
count__2647_2653 = G__2670;
i__2648_2654 = G__2671;
continue;
}
} else {
}
}
break;
}

var temp__5457__auto__ = new cljs.core.Keyword(null,"on-added","on-added",-54041858).cljs$core$IFn$_invoke$arity$1(metadata);
if(cljs.core.truth_(temp__5457__auto__)){
var callback = temp__5457__auto__;
return callback.call(null,new_obj);
} else {
return null;
}
}catch (e2641){var ex = e2641;
threeagent.impl.util.log.call(null,"Failed to update node due to error");

threeagent.impl.util.log.call(null,ex);

cljs.core.println.call(null,node);

cljs.core.println.call(null,new_data);

cljs.core.println.call(null,old_data);

return threeagent.impl.util.log.call(null,node);
}} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$1(diff))){
threeagent.impl.threejs.set_position_BANG_.call(null,old_obj,new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$1(diff));
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$1(diff))){
threeagent.impl.threejs.set_rotation_BANG_.call(null,old_obj,new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$1(diff));
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$1(diff))){
return threeagent.impl.threejs.set_scale_BANG_.call(null,old_obj,new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$1(diff));
} else {
return null;
}
}
});
threeagent.impl.scene.apply_change_BANG_ = (function threeagent$impl$scene$apply_change_BANG_(context,p__2672){
var vec__2673 = p__2672;
var node = cljs.core.nth.call(null,vec__2673,(0),null);
var action = cljs.core.nth.call(null,vec__2673,(1),null);
var old = cljs.core.nth.call(null,vec__2673,(2),null);
var new$ = cljs.core.nth.call(null,vec__2673,(3),null);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"add","add",235287739),action)){
return threeagent.impl.scene.add_node.call(null,context,node.parent.threejs,node);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"remove","remove",-131428414),action)){
return threeagent.impl.scene.remove_node_BANG_.call(null,node);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"update","update",1045576396),action)){
return threeagent.impl.scene.update_node_BANG_.call(null,context,node,old,new$);
} else {
return null;
}
}
}
});
threeagent.impl.scene.apply_virtual_scene_changes_BANG_ = (function threeagent$impl$scene$apply_virtual_scene_changes_BANG_(context,changelog){
var seq__2676 = cljs.core.seq.call(null,changelog);
var chunk__2677 = null;
var count__2678 = (0);
var i__2679 = (0);
while(true){
if((i__2679 < count__2678)){
var change = cljs.core._nth.call(null,chunk__2677,i__2679);
threeagent.impl.scene.apply_change_BANG_.call(null,context,change);


var G__2680 = seq__2676;
var G__2681 = chunk__2677;
var G__2682 = count__2678;
var G__2683 = (i__2679 + (1));
seq__2676 = G__2680;
chunk__2677 = G__2681;
count__2678 = G__2682;
i__2679 = G__2683;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__2676);
if(temp__5457__auto__){
var seq__2676__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__2676__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__2676__$1);
var G__2684 = cljs.core.chunk_rest.call(null,seq__2676__$1);
var G__2685 = c__4550__auto__;
var G__2686 = cljs.core.count.call(null,c__4550__auto__);
var G__2687 = (0);
seq__2676 = G__2684;
chunk__2677 = G__2685;
count__2678 = G__2686;
i__2679 = G__2687;
continue;
} else {
var change = cljs.core.first.call(null,seq__2676__$1);
threeagent.impl.scene.apply_change_BANG_.call(null,context,change);


var G__2688 = cljs.core.next.call(null,seq__2676__$1);
var G__2689 = null;
var G__2690 = (0);
var G__2691 = (0);
seq__2676 = G__2688;
chunk__2677 = G__2689;
count__2678 = G__2690;
i__2679 = G__2691;
continue;
}
} else {
return null;
}
}
break;
}
});
threeagent.impl.scene.animate = (function threeagent$impl$scene$animate(context){
var stats = context.stats;
var clock = context.clock;
var virtual_scene = context.virtualScene;
var renderer = context.renderer;
var composer = context.composer;
var camera = context.camera;
var scene_root = context.sceneRoot;
var before_render_cb = context.beforeRenderCb;
if(cljs.core.truth_(stats)){
stats.begin();
} else {
}

var delta_time_2692 = clock.getDelta();
var changelog_2693 = [];
if(cljs.core.truth_(before_render_cb)){
before_render_cb.call(null,delta_time_2692);
} else {
}

threeagent.impl.virtual_scene.render_BANG_.call(null,virtual_scene,changelog_2693);

threeagent.impl.scene.apply_virtual_scene_changes_BANG_.call(null,context,changelog_2693);

if(cljs.core.truth_(composer)){
composer.render(delta_time_2692);
} else {
renderer.render(scene_root,camera);
}

if(cljs.core.truth_(stats)){
return stats.end();
} else {
return null;
}
});
threeagent.impl.scene.get_canvas = (function threeagent$impl$scene$get_canvas(dom_root){
if(cljs.core._EQ_.call(null,"canvas",clojure.string.lower_case.call(null,dom_root.tagName))){
return dom_root;
} else {
var c = document.createElement("canvas");
return dom_root.appendChild(c);
}
});
threeagent.impl.scene.create_camera = (function threeagent$impl$scene$create_camera(width,height,ortho_QMARK_){
if(cljs.core.truth_(ortho_QMARK_)){
return (new module$C_$dev$threeagent$node_modules$three$build$three_module.OrthographicCamera((width / -2.0),(width / 2.0),(height / 2.0),(height / -2.0),0.1,(1000)));
} else {
return (new module$C_$dev$threeagent$node_modules$three$build$three_module.PerspectiveCamera((75),(width / height),0.1,(1000)));
}
});
threeagent.impl.scene.create_context = (function threeagent$impl$scene$create_context(root_fn,dom_root,on_before_render_cb,ortho_camera_QMARK_,renderer_opts){
var canvas = threeagent.impl.scene.get_canvas.call(null,dom_root);
var width = canvas.offsetWidth;
var height = canvas.offsetHeight;
var virtual_scene = threeagent.impl.virtual_scene.create.call(null,root_fn);
var renderer = (new module$C_$dev$threeagent$node_modules$three$build$three_module.WebGLRenderer(cljs.core.clj__GT_js.call(null,cljs.core.merge.call(null,renderer_opts,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"canvas","canvas",-1798817489),canvas], null)))));
var camera = threeagent.impl.scene.create_camera.call(null,width,height,ortho_camera_QMARK_);
var scene_root = (new module$C_$dev$threeagent$node_modules$three$build$three_module.Scene());
var composer = (((typeof POSTPROCESSING !== 'undefined'))?(new POSTPROCESSING.EffectComposer(renderer)):null);
var render_pass = (((typeof POSTPROCESSING !== 'undefined'))?(new POSTPROCESSING.RenderPass(scene_root,camera)):null);
renderer.setSize(width,height);

if(cljs.core.truth_(composer)){
render_pass.renderToScreen = true;

composer.addPass(render_pass);
} else {
}

var context = cljs.core.clj__GT_js.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"beforeRenderCb","beforeRenderCb",-527064825),new cljs.core.Keyword(null,"virtualScene","virtualScene",-647541401),new cljs.core.Keyword(null,"sceneRoot","sceneRoot",-607114514),new cljs.core.Keyword(null,"canvas","canvas",-1798817489),new cljs.core.Keyword(null,"renderer","renderer",336841071),new cljs.core.Keyword(null,"composer","composer",-1616081356),new cljs.core.Keyword(null,"camera","camera",-1190348585),new cljs.core.Keyword(null,"clock","clock",-894301127),new cljs.core.Keyword(null,"stats","stats",-85643011)],[on_before_render_cb,virtual_scene,scene_root,canvas,renderer,composer,camera,(new module$C_$dev$threeagent$node_modules$three$build$three_module.Clock()),(((typeof Stats !== 'undefined'))?(new Stats()):null)]));
threeagent.impl.scene.init_scene.call(null,context,virtual_scene,scene_root);

if(cljs.core.truth_(context.stats)){
context.stats.showPanel((1));

document.body.appendChild(context.stats.dom);
} else {
}

context.animateFn = ((function (context,canvas,width,height,virtual_scene,renderer,camera,scene_root,composer,render_pass){
return (function (){
return threeagent.impl.scene.animate.call(null,context);
});})(context,canvas,width,height,virtual_scene,renderer,camera,scene_root,composer,render_pass))
;

return context;
});
threeagent.impl.scene.remove_all_children_BANG_ = (function threeagent$impl$scene$remove_all_children_BANG_(vscene_root){
return vscene_root.for_each_child(threeagent.impl.scene.remove_node_BANG_);
});
threeagent.impl.scene.reset_scene_BANG_ = (function threeagent$impl$scene$reset_scene_BANG_(scene,root_fn,p__2694){
var map__2695 = p__2694;
var map__2695__$1 = (((((!((map__2695 == null))))?(((((map__2695.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2695.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2695):map__2695);
var on_before_render = cljs.core.get.call(null,map__2695__$1,new cljs.core.Keyword(null,"on-before-render","on-before-render",601463713));
var root = scene.sceneRoot;
var virtual_scene = scene.virtualScene;
var new_virtual_scene = threeagent.impl.virtual_scene.create.call(null,root_fn);
threeagent.impl.scene.remove_all_children_BANG_.call(null,virtual_scene.root);

threeagent.impl.virtual_scene.destroy_BANG_.call(null,virtual_scene);

threeagent.impl.scene.init_scene.call(null,scene,new_virtual_scene,root);

scene.virtualScene = new_virtual_scene;

scene.beforeRenderCb = on_before_render;

return scene;
});
threeagent.impl.scene.render = (function threeagent$impl$scene$render(root_fn,dom_root,p__2697){
var map__2698 = p__2697;
var map__2698__$1 = (((((!((map__2698 == null))))?(((((map__2698.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2698.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2698):map__2698);
var on_before_render = cljs.core.get.call(null,map__2698__$1,new cljs.core.Keyword(null,"on-before-render","on-before-render",601463713));
var ortho_camera_QMARK_ = cljs.core.get.call(null,map__2698__$1,new cljs.core.Keyword(null,"ortho-camera?","ortho-camera?",-1828964318));
var renderer_opts = cljs.core.get.call(null,map__2698__$1,new cljs.core.Keyword(null,"renderer-opts","renderer-opts",650523720));
var context = threeagent.impl.scene.create_context.call(null,root_fn,dom_root,on_before_render,ortho_camera_QMARK_,renderer_opts);
var renderer = context.renderer;
renderer.setAnimationLoop(context.animateFn);

return context;
});

//# sourceMappingURL=scene.js.map
