// Compiled by ClojureScript 1.10.520 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.18";
figwheel.client.js_stringify = (((((typeof JSON !== 'undefined')) && ((!((JSON.stringify == null))))))?(function (x){
return ["#js ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(JSON.stringify(x,null," "))].join('');
}):(function (x){
try{return cljs.core.str.cljs$core$IFn$_invoke$arity$1(x);
}catch (e33417){if((e33417 instanceof Error)){
var e = e33417;
return "Error: Unable to stringify";
} else {
throw e33417;

}
}}));
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var G__33420 = arguments.length;
switch (G__33420) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.mapv.call(null,(function (p1__33418_SHARP_){
if(typeof p1__33418_SHARP_ === 'string'){
return p1__33418_SHARP_;
} else {
return figwheel.client.js_stringify.call(null,p1__33418_SHARP_);
}
}),args)], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__4736__auto__ = [];
var len__4730__auto___33423 = arguments.length;
var i__4731__auto___33424 = (0);
while(true){
if((i__4731__auto___33424 < len__4730__auto___33423)){
args__4736__auto__.push((arguments[i__4731__auto___33424]));

var G__33425 = (i__4731__auto___33424 + (1));
i__4731__auto___33424 = G__33425;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq33422){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq33422));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__4736__auto__ = [];
var len__4730__auto___33427 = arguments.length;
var i__4731__auto___33428 = (0);
while(true){
if((i__4731__auto___33428 < len__4730__auto___33427)){
args__4736__auto__.push((arguments[i__4731__auto___33428]));

var G__33429 = (i__4731__auto___33428 + (1));
i__4731__auto___33428 = G__33429;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq33426){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq33426));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),"Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Figwheel autoloading ",(cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF")].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method.
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if(((b === true) || (b === false))){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 * 
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if(((b === true) || (b === false))){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__33430){
var map__33431 = p__33430;
var map__33431__$1 = (((((!((map__33431 == null))))?(((((map__33431.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33431.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33431):map__33431);
var message = cljs.core.get.call(null,map__33431__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__33431__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)," : ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__4131__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__4120__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__4120__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__4120__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return ((cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts))));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__25572__auto___33510 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25572__auto___33510,ch){
return (function (){
var f__25573__auto__ = (function (){var switch__25405__auto__ = ((function (c__25572__auto___33510,ch){
return (function (state_33482){
var state_val_33483 = (state_33482[(1)]);
if((state_val_33483 === (7))){
var inst_33478 = (state_33482[(2)]);
var state_33482__$1 = state_33482;
var statearr_33484_33511 = state_33482__$1;
(statearr_33484_33511[(2)] = inst_33478);

(statearr_33484_33511[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33483 === (1))){
var state_33482__$1 = state_33482;
var statearr_33485_33512 = state_33482__$1;
(statearr_33485_33512[(2)] = null);

(statearr_33485_33512[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33483 === (4))){
var inst_33435 = (state_33482[(7)]);
var inst_33435__$1 = (state_33482[(2)]);
var state_33482__$1 = (function (){var statearr_33486 = state_33482;
(statearr_33486[(7)] = inst_33435__$1);

return statearr_33486;
})();
if(cljs.core.truth_(inst_33435__$1)){
var statearr_33487_33513 = state_33482__$1;
(statearr_33487_33513[(1)] = (5));

} else {
var statearr_33488_33514 = state_33482__$1;
(statearr_33488_33514[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33483 === (15))){
var inst_33442 = (state_33482[(8)]);
var inst_33457 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_33442);
var inst_33458 = cljs.core.first.call(null,inst_33457);
var inst_33459 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_33458);
var inst_33460 = ["Figwheel: Not loading code with warnings - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_33459)].join('');
var inst_33461 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_33460);
var state_33482__$1 = state_33482;
var statearr_33489_33515 = state_33482__$1;
(statearr_33489_33515[(2)] = inst_33461);

(statearr_33489_33515[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33483 === (13))){
var inst_33466 = (state_33482[(2)]);
var state_33482__$1 = state_33482;
var statearr_33490_33516 = state_33482__$1;
(statearr_33490_33516[(2)] = inst_33466);

(statearr_33490_33516[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33483 === (6))){
var state_33482__$1 = state_33482;
var statearr_33491_33517 = state_33482__$1;
(statearr_33491_33517[(2)] = null);

(statearr_33491_33517[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33483 === (17))){
var inst_33464 = (state_33482[(2)]);
var state_33482__$1 = state_33482;
var statearr_33492_33518 = state_33482__$1;
(statearr_33492_33518[(2)] = inst_33464);

(statearr_33492_33518[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33483 === (3))){
var inst_33480 = (state_33482[(2)]);
var state_33482__$1 = state_33482;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33482__$1,inst_33480);
} else {
if((state_val_33483 === (12))){
var inst_33441 = (state_33482[(9)]);
var inst_33455 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_33441,opts);
var state_33482__$1 = state_33482;
if(inst_33455){
var statearr_33493_33519 = state_33482__$1;
(statearr_33493_33519[(1)] = (15));

} else {
var statearr_33494_33520 = state_33482__$1;
(statearr_33494_33520[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33483 === (2))){
var state_33482__$1 = state_33482;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33482__$1,(4),ch);
} else {
if((state_val_33483 === (11))){
var inst_33442 = (state_33482[(8)]);
var inst_33447 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33448 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_33442);
var inst_33449 = cljs.core.async.timeout.call(null,(1000));
var inst_33450 = [inst_33448,inst_33449];
var inst_33451 = (new cljs.core.PersistentVector(null,2,(5),inst_33447,inst_33450,null));
var state_33482__$1 = state_33482;
return cljs.core.async.ioc_alts_BANG_.call(null,state_33482__$1,(14),inst_33451);
} else {
if((state_val_33483 === (9))){
var inst_33442 = (state_33482[(8)]);
var inst_33468 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_33469 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_33442);
var inst_33470 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_33469);
var inst_33471 = ["Not loading: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_33470)].join('');
var inst_33472 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_33471);
var state_33482__$1 = (function (){var statearr_33495 = state_33482;
(statearr_33495[(10)] = inst_33468);

return statearr_33495;
})();
var statearr_33496_33521 = state_33482__$1;
(statearr_33496_33521[(2)] = inst_33472);

(statearr_33496_33521[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33483 === (5))){
var inst_33435 = (state_33482[(7)]);
var inst_33437 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_33438 = (new cljs.core.PersistentArrayMap(null,2,inst_33437,null));
var inst_33439 = (new cljs.core.PersistentHashSet(null,inst_33438,null));
var inst_33440 = figwheel.client.focus_msgs.call(null,inst_33439,inst_33435);
var inst_33441 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_33440);
var inst_33442 = cljs.core.first.call(null,inst_33440);
var inst_33443 = figwheel.client.autoload_QMARK_.call(null);
var state_33482__$1 = (function (){var statearr_33497 = state_33482;
(statearr_33497[(8)] = inst_33442);

(statearr_33497[(9)] = inst_33441);

return statearr_33497;
})();
if(cljs.core.truth_(inst_33443)){
var statearr_33498_33522 = state_33482__$1;
(statearr_33498_33522[(1)] = (8));

} else {
var statearr_33499_33523 = state_33482__$1;
(statearr_33499_33523[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33483 === (14))){
var inst_33453 = (state_33482[(2)]);
var state_33482__$1 = state_33482;
var statearr_33500_33524 = state_33482__$1;
(statearr_33500_33524[(2)] = inst_33453);

(statearr_33500_33524[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33483 === (16))){
var state_33482__$1 = state_33482;
var statearr_33501_33525 = state_33482__$1;
(statearr_33501_33525[(2)] = null);

(statearr_33501_33525[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33483 === (10))){
var inst_33474 = (state_33482[(2)]);
var state_33482__$1 = (function (){var statearr_33502 = state_33482;
(statearr_33502[(11)] = inst_33474);

return statearr_33502;
})();
var statearr_33503_33526 = state_33482__$1;
(statearr_33503_33526[(2)] = null);

(statearr_33503_33526[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33483 === (8))){
var inst_33441 = (state_33482[(9)]);
var inst_33445 = figwheel.client.reload_file_state_QMARK_.call(null,inst_33441,opts);
var state_33482__$1 = state_33482;
if(cljs.core.truth_(inst_33445)){
var statearr_33504_33527 = state_33482__$1;
(statearr_33504_33527[(1)] = (11));

} else {
var statearr_33505_33528 = state_33482__$1;
(statearr_33505_33528[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25572__auto___33510,ch))
;
return ((function (switch__25405__auto__,c__25572__auto___33510,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__25406__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__25406__auto____0 = (function (){
var statearr_33506 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33506[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__25406__auto__);

(statearr_33506[(1)] = (1));

return statearr_33506;
});
var figwheel$client$file_reloader_plugin_$_state_machine__25406__auto____1 = (function (state_33482){
while(true){
var ret_value__25407__auto__ = (function (){try{while(true){
var result__25408__auto__ = switch__25405__auto__.call(null,state_33482);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25408__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25408__auto__;
}
break;
}
}catch (e33507){if((e33507 instanceof Object)){
var ex__25409__auto__ = e33507;
var statearr_33508_33529 = state_33482;
(statearr_33508_33529[(5)] = ex__25409__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33482);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33507;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25407__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33530 = state_33482;
state_33482 = G__33530;
continue;
} else {
return ret_value__25407__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__25406__auto__ = function(state_33482){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__25406__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__25406__auto____1.call(this,state_33482);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloader_plugin_$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__25406__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__25406__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__25406__auto__;
})()
;})(switch__25405__auto__,c__25572__auto___33510,ch))
})();
var state__25574__auto__ = (function (){var statearr_33509 = f__25573__auto__.call(null);
(statearr_33509[(6)] = c__25572__auto___33510);

return statearr_33509;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25574__auto__);
});})(c__25572__auto___33510,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__33531_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__33531_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(figwheel.client.utils.node_env_QMARK_.call(null)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_33537 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_33537){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{var sb = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__33533 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__33534 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__33535 = true;
var _STAR_print_fn_STAR__temp_val__33536 = ((function (_STAR_print_newline_STAR__orig_val__33533,_STAR_print_fn_STAR__orig_val__33534,_STAR_print_newline_STAR__temp_val__33535,sb,base_path_33537){
return (function (x){
return sb.append(x);
});})(_STAR_print_newline_STAR__orig_val__33533,_STAR_print_fn_STAR__orig_val__33534,_STAR_print_newline_STAR__temp_val__33535,sb,base_path_33537))
;
cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__33535;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__33536;

try{var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
var result_value__$1 = (((!(typeof result_value === 'string')))?cljs.core.pr_str.call(null,result_value):result_value);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"out","out",-910545517),cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value__$1], null));
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__33534;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__33533;
}}catch (e33532){if((e33532 instanceof Error)){
var e = e33532;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_33537], null));
} else {
var e = e33532;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}});})(base_path_33537))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__33538){
var map__33539 = p__33538;
var map__33539__$1 = (((((!((map__33539 == null))))?(((((map__33539.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33539.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33539):map__33539);
var opts = map__33539__$1;
var build_id = cljs.core.get.call(null,map__33539__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__33539,map__33539__$1,opts,build_id){
return (function (p__33541){
var vec__33542 = p__33541;
var seq__33543 = cljs.core.seq.call(null,vec__33542);
var first__33544 = cljs.core.first.call(null,seq__33543);
var seq__33543__$1 = cljs.core.next.call(null,seq__33543);
var map__33545 = first__33544;
var map__33545__$1 = (((((!((map__33545 == null))))?(((((map__33545.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33545.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33545):map__33545);
var msg = map__33545__$1;
var msg_name = cljs.core.get.call(null,map__33545__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__33543__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__33542,seq__33543,first__33544,seq__33543__$1,map__33545,map__33545__$1,msg,msg_name,_,map__33539,map__33539__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__33542,seq__33543,first__33544,seq__33543__$1,map__33545,map__33545__$1,msg,msg_name,_,map__33539,map__33539__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__33539,map__33539__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__33547){
var vec__33548 = p__33547;
var seq__33549 = cljs.core.seq.call(null,vec__33548);
var first__33550 = cljs.core.first.call(null,seq__33549);
var seq__33549__$1 = cljs.core.next.call(null,seq__33549);
var map__33551 = first__33550;
var map__33551__$1 = (((((!((map__33551 == null))))?(((((map__33551.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33551.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33551):map__33551);
var msg = map__33551__$1;
var msg_name = cljs.core.get.call(null,map__33551__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__33549__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__33553){
var map__33554 = p__33553;
var map__33554__$1 = (((((!((map__33554 == null))))?(((((map__33554.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33554.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33554):map__33554);
var on_compile_warning = cljs.core.get.call(null,map__33554__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__33554__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__33554,map__33554__$1,on_compile_warning,on_compile_fail){
return (function (p__33556){
var vec__33557 = p__33556;
var seq__33558 = cljs.core.seq.call(null,vec__33557);
var first__33559 = cljs.core.first.call(null,seq__33558);
var seq__33558__$1 = cljs.core.next.call(null,seq__33558);
var map__33560 = first__33559;
var map__33560__$1 = (((((!((map__33560 == null))))?(((((map__33560.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33560.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33560):map__33560);
var msg = map__33560__$1;
var msg_name = cljs.core.get.call(null,map__33560__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__33558__$1;
var pred__33562 = cljs.core._EQ_;
var expr__33563 = msg_name;
if(cljs.core.truth_(pred__33562.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__33563))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__33562.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__33563))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__33554,map__33554__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__25572__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25572__auto__,msg_hist,msg_names,msg){
return (function (){
var f__25573__auto__ = (function (){var switch__25405__auto__ = ((function (c__25572__auto__,msg_hist,msg_names,msg){
return (function (state_33652){
var state_val_33653 = (state_33652[(1)]);
if((state_val_33653 === (7))){
var inst_33572 = (state_33652[(2)]);
var state_33652__$1 = state_33652;
if(cljs.core.truth_(inst_33572)){
var statearr_33654_33701 = state_33652__$1;
(statearr_33654_33701[(1)] = (8));

} else {
var statearr_33655_33702 = state_33652__$1;
(statearr_33655_33702[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33653 === (20))){
var inst_33646 = (state_33652[(2)]);
var state_33652__$1 = state_33652;
var statearr_33656_33703 = state_33652__$1;
(statearr_33656_33703[(2)] = inst_33646);

(statearr_33656_33703[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33653 === (27))){
var inst_33642 = (state_33652[(2)]);
var state_33652__$1 = state_33652;
var statearr_33657_33704 = state_33652__$1;
(statearr_33657_33704[(2)] = inst_33642);

(statearr_33657_33704[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33653 === (1))){
var inst_33565 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_33652__$1 = state_33652;
if(cljs.core.truth_(inst_33565)){
var statearr_33658_33705 = state_33652__$1;
(statearr_33658_33705[(1)] = (2));

} else {
var statearr_33659_33706 = state_33652__$1;
(statearr_33659_33706[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33653 === (24))){
var inst_33644 = (state_33652[(2)]);
var state_33652__$1 = state_33652;
var statearr_33660_33707 = state_33652__$1;
(statearr_33660_33707[(2)] = inst_33644);

(statearr_33660_33707[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33653 === (4))){
var inst_33650 = (state_33652[(2)]);
var state_33652__$1 = state_33652;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33652__$1,inst_33650);
} else {
if((state_val_33653 === (15))){
var inst_33648 = (state_33652[(2)]);
var state_33652__$1 = state_33652;
var statearr_33661_33708 = state_33652__$1;
(statearr_33661_33708[(2)] = inst_33648);

(statearr_33661_33708[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33653 === (21))){
var inst_33601 = (state_33652[(2)]);
var inst_33602 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_33603 = figwheel.client.auto_jump_to_error.call(null,opts,inst_33602);
var state_33652__$1 = (function (){var statearr_33662 = state_33652;
(statearr_33662[(7)] = inst_33601);

return statearr_33662;
})();
var statearr_33663_33709 = state_33652__$1;
(statearr_33663_33709[(2)] = inst_33603);

(statearr_33663_33709[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33653 === (31))){
var inst_33631 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_33652__$1 = state_33652;
if(inst_33631){
var statearr_33664_33710 = state_33652__$1;
(statearr_33664_33710[(1)] = (34));

} else {
var statearr_33665_33711 = state_33652__$1;
(statearr_33665_33711[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33653 === (32))){
var inst_33640 = (state_33652[(2)]);
var state_33652__$1 = state_33652;
var statearr_33666_33712 = state_33652__$1;
(statearr_33666_33712[(2)] = inst_33640);

(statearr_33666_33712[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33653 === (33))){
var inst_33627 = (state_33652[(2)]);
var inst_33628 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_33629 = figwheel.client.auto_jump_to_error.call(null,opts,inst_33628);
var state_33652__$1 = (function (){var statearr_33667 = state_33652;
(statearr_33667[(8)] = inst_33627);

return statearr_33667;
})();
var statearr_33668_33713 = state_33652__$1;
(statearr_33668_33713[(2)] = inst_33629);

(statearr_33668_33713[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33653 === (13))){
var inst_33586 = figwheel.client.heads_up.clear.call(null);
var state_33652__$1 = state_33652;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33652__$1,(16),inst_33586);
} else {
if((state_val_33653 === (22))){
var inst_33607 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_33608 = figwheel.client.heads_up.append_warning_message.call(null,inst_33607);
var state_33652__$1 = state_33652;
var statearr_33669_33714 = state_33652__$1;
(statearr_33669_33714[(2)] = inst_33608);

(statearr_33669_33714[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33653 === (36))){
var inst_33638 = (state_33652[(2)]);
var state_33652__$1 = state_33652;
var statearr_33670_33715 = state_33652__$1;
(statearr_33670_33715[(2)] = inst_33638);

(statearr_33670_33715[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33653 === (29))){
var inst_33618 = (state_33652[(2)]);
var inst_33619 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_33620 = figwheel.client.auto_jump_to_error.call(null,opts,inst_33619);
var state_33652__$1 = (function (){var statearr_33671 = state_33652;
(statearr_33671[(9)] = inst_33618);

return statearr_33671;
})();
var statearr_33672_33716 = state_33652__$1;
(statearr_33672_33716[(2)] = inst_33620);

(statearr_33672_33716[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33653 === (6))){
var inst_33567 = (state_33652[(10)]);
var state_33652__$1 = state_33652;
var statearr_33673_33717 = state_33652__$1;
(statearr_33673_33717[(2)] = inst_33567);

(statearr_33673_33717[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33653 === (28))){
var inst_33614 = (state_33652[(2)]);
var inst_33615 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_33616 = figwheel.client.heads_up.display_warning.call(null,inst_33615);
var state_33652__$1 = (function (){var statearr_33674 = state_33652;
(statearr_33674[(11)] = inst_33614);

return statearr_33674;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33652__$1,(29),inst_33616);
} else {
if((state_val_33653 === (25))){
var inst_33612 = figwheel.client.heads_up.clear.call(null);
var state_33652__$1 = state_33652;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33652__$1,(28),inst_33612);
} else {
if((state_val_33653 === (34))){
var inst_33633 = figwheel.client.heads_up.flash_loaded.call(null);
var state_33652__$1 = state_33652;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33652__$1,(37),inst_33633);
} else {
if((state_val_33653 === (17))){
var inst_33592 = (state_33652[(2)]);
var inst_33593 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_33594 = figwheel.client.auto_jump_to_error.call(null,opts,inst_33593);
var state_33652__$1 = (function (){var statearr_33675 = state_33652;
(statearr_33675[(12)] = inst_33592);

return statearr_33675;
})();
var statearr_33676_33718 = state_33652__$1;
(statearr_33676_33718[(2)] = inst_33594);

(statearr_33676_33718[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33653 === (3))){
var inst_33584 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_33652__$1 = state_33652;
if(inst_33584){
var statearr_33677_33719 = state_33652__$1;
(statearr_33677_33719[(1)] = (13));

} else {
var statearr_33678_33720 = state_33652__$1;
(statearr_33678_33720[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33653 === (12))){
var inst_33580 = (state_33652[(2)]);
var state_33652__$1 = state_33652;
var statearr_33679_33721 = state_33652__$1;
(statearr_33679_33721[(2)] = inst_33580);

(statearr_33679_33721[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33653 === (2))){
var inst_33567 = (state_33652[(10)]);
var inst_33567__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_33652__$1 = (function (){var statearr_33680 = state_33652;
(statearr_33680[(10)] = inst_33567__$1);

return statearr_33680;
})();
if(cljs.core.truth_(inst_33567__$1)){
var statearr_33681_33722 = state_33652__$1;
(statearr_33681_33722[(1)] = (5));

} else {
var statearr_33682_33723 = state_33652__$1;
(statearr_33682_33723[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33653 === (23))){
var inst_33610 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_33652__$1 = state_33652;
if(inst_33610){
var statearr_33683_33724 = state_33652__$1;
(statearr_33683_33724[(1)] = (25));

} else {
var statearr_33684_33725 = state_33652__$1;
(statearr_33684_33725[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33653 === (35))){
var state_33652__$1 = state_33652;
var statearr_33685_33726 = state_33652__$1;
(statearr_33685_33726[(2)] = null);

(statearr_33685_33726[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33653 === (19))){
var inst_33605 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_33652__$1 = state_33652;
if(inst_33605){
var statearr_33686_33727 = state_33652__$1;
(statearr_33686_33727[(1)] = (22));

} else {
var statearr_33687_33728 = state_33652__$1;
(statearr_33687_33728[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33653 === (11))){
var inst_33576 = (state_33652[(2)]);
var state_33652__$1 = state_33652;
var statearr_33688_33729 = state_33652__$1;
(statearr_33688_33729[(2)] = inst_33576);

(statearr_33688_33729[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33653 === (9))){
var inst_33578 = figwheel.client.heads_up.clear.call(null);
var state_33652__$1 = state_33652;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33652__$1,(12),inst_33578);
} else {
if((state_val_33653 === (5))){
var inst_33569 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_33652__$1 = state_33652;
var statearr_33689_33730 = state_33652__$1;
(statearr_33689_33730[(2)] = inst_33569);

(statearr_33689_33730[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33653 === (14))){
var inst_33596 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_33652__$1 = state_33652;
if(inst_33596){
var statearr_33690_33731 = state_33652__$1;
(statearr_33690_33731[(1)] = (18));

} else {
var statearr_33691_33732 = state_33652__$1;
(statearr_33691_33732[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33653 === (26))){
var inst_33622 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_33652__$1 = state_33652;
if(inst_33622){
var statearr_33692_33733 = state_33652__$1;
(statearr_33692_33733[(1)] = (30));

} else {
var statearr_33693_33734 = state_33652__$1;
(statearr_33693_33734[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33653 === (16))){
var inst_33588 = (state_33652[(2)]);
var inst_33589 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_33590 = figwheel.client.heads_up.display_exception.call(null,inst_33589);
var state_33652__$1 = (function (){var statearr_33694 = state_33652;
(statearr_33694[(13)] = inst_33588);

return statearr_33694;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33652__$1,(17),inst_33590);
} else {
if((state_val_33653 === (30))){
var inst_33624 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_33625 = figwheel.client.heads_up.display_warning.call(null,inst_33624);
var state_33652__$1 = state_33652;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33652__$1,(33),inst_33625);
} else {
if((state_val_33653 === (10))){
var inst_33582 = (state_33652[(2)]);
var state_33652__$1 = state_33652;
var statearr_33695_33735 = state_33652__$1;
(statearr_33695_33735[(2)] = inst_33582);

(statearr_33695_33735[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33653 === (18))){
var inst_33598 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_33599 = figwheel.client.heads_up.display_exception.call(null,inst_33598);
var state_33652__$1 = state_33652;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33652__$1,(21),inst_33599);
} else {
if((state_val_33653 === (37))){
var inst_33635 = (state_33652[(2)]);
var state_33652__$1 = state_33652;
var statearr_33696_33736 = state_33652__$1;
(statearr_33696_33736[(2)] = inst_33635);

(statearr_33696_33736[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33653 === (8))){
var inst_33574 = figwheel.client.heads_up.flash_loaded.call(null);
var state_33652__$1 = state_33652;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33652__$1,(11),inst_33574);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25572__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__25405__auto__,c__25572__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25406__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25406__auto____0 = (function (){
var statearr_33697 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33697[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25406__auto__);

(statearr_33697[(1)] = (1));

return statearr_33697;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25406__auto____1 = (function (state_33652){
while(true){
var ret_value__25407__auto__ = (function (){try{while(true){
var result__25408__auto__ = switch__25405__auto__.call(null,state_33652);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25408__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25408__auto__;
}
break;
}
}catch (e33698){if((e33698 instanceof Object)){
var ex__25409__auto__ = e33698;
var statearr_33699_33737 = state_33652;
(statearr_33699_33737[(5)] = ex__25409__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33652);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33698;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25407__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33738 = state_33652;
state_33652 = G__33738;
continue;
} else {
return ret_value__25407__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25406__auto__ = function(state_33652){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25406__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25406__auto____1.call(this,state_33652);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25406__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25406__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25406__auto__;
})()
;})(switch__25405__auto__,c__25572__auto__,msg_hist,msg_names,msg))
})();
var state__25574__auto__ = (function (){var statearr_33700 = f__25573__auto__.call(null);
(statearr_33700[(6)] = c__25572__auto__);

return statearr_33700;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25574__auto__);
});})(c__25572__auto__,msg_hist,msg_names,msg))
);

return c__25572__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__25572__auto___33767 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25572__auto___33767,ch){
return (function (){
var f__25573__auto__ = (function (){var switch__25405__auto__ = ((function (c__25572__auto___33767,ch){
return (function (state_33753){
var state_val_33754 = (state_33753[(1)]);
if((state_val_33754 === (1))){
var state_33753__$1 = state_33753;
var statearr_33755_33768 = state_33753__$1;
(statearr_33755_33768[(2)] = null);

(statearr_33755_33768[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33754 === (2))){
var state_33753__$1 = state_33753;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33753__$1,(4),ch);
} else {
if((state_val_33754 === (3))){
var inst_33751 = (state_33753[(2)]);
var state_33753__$1 = state_33753;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33753__$1,inst_33751);
} else {
if((state_val_33754 === (4))){
var inst_33741 = (state_33753[(7)]);
var inst_33741__$1 = (state_33753[(2)]);
var state_33753__$1 = (function (){var statearr_33756 = state_33753;
(statearr_33756[(7)] = inst_33741__$1);

return statearr_33756;
})();
if(cljs.core.truth_(inst_33741__$1)){
var statearr_33757_33769 = state_33753__$1;
(statearr_33757_33769[(1)] = (5));

} else {
var statearr_33758_33770 = state_33753__$1;
(statearr_33758_33770[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33754 === (5))){
var inst_33741 = (state_33753[(7)]);
var inst_33743 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_33741);
var state_33753__$1 = state_33753;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33753__$1,(8),inst_33743);
} else {
if((state_val_33754 === (6))){
var state_33753__$1 = state_33753;
var statearr_33759_33771 = state_33753__$1;
(statearr_33759_33771[(2)] = null);

(statearr_33759_33771[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33754 === (7))){
var inst_33749 = (state_33753[(2)]);
var state_33753__$1 = state_33753;
var statearr_33760_33772 = state_33753__$1;
(statearr_33760_33772[(2)] = inst_33749);

(statearr_33760_33772[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33754 === (8))){
var inst_33745 = (state_33753[(2)]);
var state_33753__$1 = (function (){var statearr_33761 = state_33753;
(statearr_33761[(8)] = inst_33745);

return statearr_33761;
})();
var statearr_33762_33773 = state_33753__$1;
(statearr_33762_33773[(2)] = null);

(statearr_33762_33773[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__25572__auto___33767,ch))
;
return ((function (switch__25405__auto__,c__25572__auto___33767,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__25406__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__25406__auto____0 = (function (){
var statearr_33763 = [null,null,null,null,null,null,null,null,null];
(statearr_33763[(0)] = figwheel$client$heads_up_plugin_$_state_machine__25406__auto__);

(statearr_33763[(1)] = (1));

return statearr_33763;
});
var figwheel$client$heads_up_plugin_$_state_machine__25406__auto____1 = (function (state_33753){
while(true){
var ret_value__25407__auto__ = (function (){try{while(true){
var result__25408__auto__ = switch__25405__auto__.call(null,state_33753);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25408__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25408__auto__;
}
break;
}
}catch (e33764){if((e33764 instanceof Object)){
var ex__25409__auto__ = e33764;
var statearr_33765_33774 = state_33753;
(statearr_33765_33774[(5)] = ex__25409__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33753);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33764;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25407__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33775 = state_33753;
state_33753 = G__33775;
continue;
} else {
return ret_value__25407__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__25406__auto__ = function(state_33753){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__25406__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__25406__auto____1.call(this,state_33753);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__25406__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__25406__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__25406__auto__;
})()
;})(switch__25405__auto__,c__25572__auto___33767,ch))
})();
var state__25574__auto__ = (function (){var statearr_33766 = f__25573__auto__.call(null);
(statearr_33766[(6)] = c__25572__auto___33767);

return statearr_33766;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25574__auto__);
});})(c__25572__auto___33767,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__25572__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25572__auto__){
return (function (){
var f__25573__auto__ = (function (){var switch__25405__auto__ = ((function (c__25572__auto__){
return (function (state_33781){
var state_val_33782 = (state_33781[(1)]);
if((state_val_33782 === (1))){
var inst_33776 = cljs.core.async.timeout.call(null,(3000));
var state_33781__$1 = state_33781;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33781__$1,(2),inst_33776);
} else {
if((state_val_33782 === (2))){
var inst_33778 = (state_33781[(2)]);
var inst_33779 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_33781__$1 = (function (){var statearr_33783 = state_33781;
(statearr_33783[(7)] = inst_33778);

return statearr_33783;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33781__$1,inst_33779);
} else {
return null;
}
}
});})(c__25572__auto__))
;
return ((function (switch__25405__auto__,c__25572__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__25406__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__25406__auto____0 = (function (){
var statearr_33784 = [null,null,null,null,null,null,null,null];
(statearr_33784[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__25406__auto__);

(statearr_33784[(1)] = (1));

return statearr_33784;
});
var figwheel$client$enforce_project_plugin_$_state_machine__25406__auto____1 = (function (state_33781){
while(true){
var ret_value__25407__auto__ = (function (){try{while(true){
var result__25408__auto__ = switch__25405__auto__.call(null,state_33781);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25408__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25408__auto__;
}
break;
}
}catch (e33785){if((e33785 instanceof Object)){
var ex__25409__auto__ = e33785;
var statearr_33786_33788 = state_33781;
(statearr_33786_33788[(5)] = ex__25409__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33781);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33785;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25407__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33789 = state_33781;
state_33781 = G__33789;
continue;
} else {
return ret_value__25407__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__25406__auto__ = function(state_33781){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__25406__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__25406__auto____1.call(this,state_33781);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_project_plugin_$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__25406__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__25406__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__25406__auto__;
})()
;})(switch__25405__auto__,c__25572__auto__))
})();
var state__25574__auto__ = (function (){var statearr_33787 = f__25573__auto__.call(null);
(statearr_33787[(6)] = c__25572__auto__);

return statearr_33787;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25574__auto__);
});})(c__25572__auto__))
);

return c__25572__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__5457__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__5457__auto__)){
var figwheel_version = temp__5457__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__25572__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25572__auto__,figwheel_version,temp__5457__auto__){
return (function (){
var f__25573__auto__ = (function (){var switch__25405__auto__ = ((function (c__25572__auto__,figwheel_version,temp__5457__auto__){
return (function (state_33796){
var state_val_33797 = (state_33796[(1)]);
if((state_val_33797 === (1))){
var inst_33790 = cljs.core.async.timeout.call(null,(2000));
var state_33796__$1 = state_33796;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33796__$1,(2),inst_33790);
} else {
if((state_val_33797 === (2))){
var inst_33792 = (state_33796[(2)]);
var inst_33793 = ["Figwheel Client Version <strong>",figwheel.client._figwheel_version_,"</strong> is not equal to ","Figwheel Sidecar Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),"</strong>",".  Shutting down Websocket Connection!","<h4>To fix try:</h4>","<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>","<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>","<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>"].join('');
var inst_33794 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_33793);
var state_33796__$1 = (function (){var statearr_33798 = state_33796;
(statearr_33798[(7)] = inst_33792);

return statearr_33798;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33796__$1,inst_33794);
} else {
return null;
}
}
});})(c__25572__auto__,figwheel_version,temp__5457__auto__))
;
return ((function (switch__25405__auto__,c__25572__auto__,figwheel_version,temp__5457__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25406__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25406__auto____0 = (function (){
var statearr_33799 = [null,null,null,null,null,null,null,null];
(statearr_33799[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25406__auto__);

(statearr_33799[(1)] = (1));

return statearr_33799;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25406__auto____1 = (function (state_33796){
while(true){
var ret_value__25407__auto__ = (function (){try{while(true){
var result__25408__auto__ = switch__25405__auto__.call(null,state_33796);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25408__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25408__auto__;
}
break;
}
}catch (e33800){if((e33800 instanceof Object)){
var ex__25409__auto__ = e33800;
var statearr_33801_33803 = state_33796;
(statearr_33801_33803[(5)] = ex__25409__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33796);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33800;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25407__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33804 = state_33796;
state_33796 = G__33804;
continue;
} else {
return ret_value__25407__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25406__auto__ = function(state_33796){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25406__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25406__auto____1.call(this,state_33796);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25406__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25406__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25406__auto__;
})()
;})(switch__25405__auto__,c__25572__auto__,figwheel_version,temp__5457__auto__))
})();
var state__25574__auto__ = (function (){var statearr_33802 = f__25573__auto__.call(null);
(statearr_33802[(6)] = c__25572__auto__);

return statearr_33802;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25574__auto__);
});})(c__25572__auto__,figwheel_version,temp__5457__auto__))
);

return c__25572__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__33805){
var map__33806 = p__33805;
var map__33806__$1 = (((((!((map__33806 == null))))?(((((map__33806.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33806.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33806):map__33806);
var file = cljs.core.get.call(null,map__33806__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__33806__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__33806__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__33808 = "";
var G__33808__$1 = (cljs.core.truth_(file)?[G__33808,"file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__33808);
var G__33808__$2 = (cljs.core.truth_(line)?[G__33808__$1," at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__33808__$1);
if(cljs.core.truth_((function (){var and__4120__auto__ = line;
if(cljs.core.truth_(and__4120__auto__)){
return column;
} else {
return and__4120__auto__;
}
})())){
return [G__33808__$2,", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__33808__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__33809){
var map__33810 = p__33809;
var map__33810__$1 = (((((!((map__33810 == null))))?(((((map__33810.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33810.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33810):map__33810);
var ed = map__33810__$1;
var exception_data = cljs.core.get.call(null,map__33810__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__33810__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
var message_33813 = (function (){var G__33812 = cljs.core.apply.call(null,cljs.core.str,"Figwheel: Compile Exception ",figwheel.client.format_messages.call(null,exception_data));
if(cljs.core.truth_(new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(exception_data))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__33812)," Error on ",figwheel.client.file_line_column.call(null,exception_data)].join('');
} else {
return G__33812;
}
})();
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),message_33813);

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__33814){
var map__33815 = p__33814;
var map__33815__$1 = (((((!((map__33815 == null))))?(((((map__33815.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33815.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33815):map__33815);
var w = map__33815__$1;
var message = cljs.core.get.call(null,map__33815__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),["Figwheel: Compile Warning - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message))," in ",figwheel.client.file_line_column.call(null,message)].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.config_defaults !== 'undefined')){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources\\public\\js\\out\\figwheel\\client.cljs",33,1,362,362,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources\\public\\js\\out\\figwheel\\client.cljs",30,1,355,355,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,["ws://",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),"/figwheel-ws"].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(figwheel.client.utils.html_env_QMARK_.call(null)){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = (((!(figwheel.client.utils.html_env_QMARK_.call(null))))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__4120__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__4120__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__4120__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_json_message_watch = (function figwheel$client$add_json_message_watch(key,callback){
return figwheel.client.add_message_watch.call(null,key,cljs.core.comp.call(null,callback,cljs.core.clj__GT_js));
});
goog.exportSymbol('figwheel.client.add_json_message_watch', figwheel.client.add_json_message_watch);
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__33817 = cljs.core.seq.call(null,plugins);
var chunk__33818 = null;
var count__33819 = (0);
var i__33820 = (0);
while(true){
if((i__33820 < count__33819)){
var vec__33827 = cljs.core._nth.call(null,chunk__33818,i__33820);
var k = cljs.core.nth.call(null,vec__33827,(0),null);
var plugin = cljs.core.nth.call(null,vec__33827,(1),null);
if(cljs.core.truth_(plugin)){
var pl_33833 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__33817,chunk__33818,count__33819,i__33820,pl_33833,vec__33827,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_33833.call(null,msg_hist);
});})(seq__33817,chunk__33818,count__33819,i__33820,pl_33833,vec__33827,k,plugin))
);
} else {
}


var G__33834 = seq__33817;
var G__33835 = chunk__33818;
var G__33836 = count__33819;
var G__33837 = (i__33820 + (1));
seq__33817 = G__33834;
chunk__33818 = G__33835;
count__33819 = G__33836;
i__33820 = G__33837;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__33817);
if(temp__5457__auto__){
var seq__33817__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33817__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__33817__$1);
var G__33838 = cljs.core.chunk_rest.call(null,seq__33817__$1);
var G__33839 = c__4550__auto__;
var G__33840 = cljs.core.count.call(null,c__4550__auto__);
var G__33841 = (0);
seq__33817 = G__33838;
chunk__33818 = G__33839;
count__33819 = G__33840;
i__33820 = G__33841;
continue;
} else {
var vec__33830 = cljs.core.first.call(null,seq__33817__$1);
var k = cljs.core.nth.call(null,vec__33830,(0),null);
var plugin = cljs.core.nth.call(null,vec__33830,(1),null);
if(cljs.core.truth_(plugin)){
var pl_33842 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__33817,chunk__33818,count__33819,i__33820,pl_33842,vec__33830,k,plugin,seq__33817__$1,temp__5457__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_33842.call(null,msg_hist);
});})(seq__33817,chunk__33818,count__33819,i__33820,pl_33842,vec__33830,k,plugin,seq__33817__$1,temp__5457__auto__))
);
} else {
}


var G__33843 = cljs.core.next.call(null,seq__33817__$1);
var G__33844 = null;
var G__33845 = (0);
var G__33846 = (0);
seq__33817 = G__33843;
chunk__33818 = G__33844;
count__33819 = G__33845;
i__33820 = G__33846;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var G__33848 = arguments.length;
switch (G__33848) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.__figwheel_start_once__ !== 'undefined')){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__33849_33854 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__33850_33855 = null;
var count__33851_33856 = (0);
var i__33852_33857 = (0);
while(true){
if((i__33852_33857 < count__33851_33856)){
var msg_33858 = cljs.core._nth.call(null,chunk__33850_33855,i__33852_33857);
figwheel.client.socket.handle_incoming_message.call(null,msg_33858);


var G__33859 = seq__33849_33854;
var G__33860 = chunk__33850_33855;
var G__33861 = count__33851_33856;
var G__33862 = (i__33852_33857 + (1));
seq__33849_33854 = G__33859;
chunk__33850_33855 = G__33860;
count__33851_33856 = G__33861;
i__33852_33857 = G__33862;
continue;
} else {
var temp__5457__auto___33863 = cljs.core.seq.call(null,seq__33849_33854);
if(temp__5457__auto___33863){
var seq__33849_33864__$1 = temp__5457__auto___33863;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33849_33864__$1)){
var c__4550__auto___33865 = cljs.core.chunk_first.call(null,seq__33849_33864__$1);
var G__33866 = cljs.core.chunk_rest.call(null,seq__33849_33864__$1);
var G__33867 = c__4550__auto___33865;
var G__33868 = cljs.core.count.call(null,c__4550__auto___33865);
var G__33869 = (0);
seq__33849_33854 = G__33866;
chunk__33850_33855 = G__33867;
count__33851_33856 = G__33868;
i__33852_33857 = G__33869;
continue;
} else {
var msg_33870 = cljs.core.first.call(null,seq__33849_33864__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_33870);


var G__33871 = cljs.core.next.call(null,seq__33849_33864__$1);
var G__33872 = null;
var G__33873 = (0);
var G__33874 = (0);
seq__33849_33854 = G__33871;
chunk__33850_33855 = G__33872;
count__33851_33856 = G__33873;
i__33852_33857 = G__33874;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__4736__auto__ = [];
var len__4730__auto___33879 = arguments.length;
var i__4731__auto___33880 = (0);
while(true){
if((i__4731__auto___33880 < len__4730__auto___33879)){
args__4736__auto__.push((arguments[i__4731__auto___33880]));

var G__33881 = (i__4731__auto___33880 + (1));
i__4731__auto___33880 = G__33881;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__33876){
var map__33877 = p__33876;
var map__33877__$1 = (((((!((map__33877 == null))))?(((((map__33877.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33877.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33877):map__33877);
var opts = map__33877__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq33875){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq33875));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e33882){if((e33882 instanceof Error)){
var e = e33882;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e33882;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__33883){
var map__33884 = p__33883;
var map__33884__$1 = (((((!((map__33884 == null))))?(((((map__33884.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33884.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33884):map__33884);
var msg_name = cljs.core.get.call(null,map__33884__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1552158902344
