// Compiled by ClojureScript 1.10.520 {}
goog.provide('threeagent.impl.component');
goog.require('cljs.core');
goog.require('threeagent.impl.threejs');
goog.require('module$C_$dev$threeagent$node_modules$three$build$three_module');
threeagent.impl.component.component_registry = cljs.core.PersistentArrayMap.EMPTY;
threeagent.impl.component.register_component_renderer_BANG_ = (function threeagent$impl$component$register_component_renderer_BANG_(key,render_fn){
return threeagent.impl.component.component_registry = cljs.core.assoc.call(null,threeagent.impl.component.component_registry,key,render_fn);
});
threeagent.impl.component.render_component = (function threeagent$impl$component$render_component(key,config){
var renderer = cljs.core.get.call(null,threeagent.impl.component.component_registry,key);
if(cljs.core.truth_(renderer)){
return renderer.call(null,config);
} else {
return cljs.core.println.call(null,"Missing renderer for object type",key);
}
});
threeagent.impl.component.__GT_material = (function threeagent$impl$component$__GT_material(config){
if((config instanceof module$C_$dev$threeagent$node_modules$three$build$three_module.Material)){
return config;
} else {
return threeagent.impl.threejs.mesh_phong_material.call(null,config);
}
});
threeagent.impl.component.to_mesh = (function threeagent$impl$component$to_mesh(geo,material_config){
var mat = threeagent.impl.component.__GT_material.call(null,material_config);
return threeagent.impl.threejs.mesh.call(null,geo,mat);
});
threeagent.impl.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"object","object",1474613949),(function (c){
return threeagent.impl.threejs.object.call(null);
}));
threeagent.impl.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"group","group",582596132),(function (c){
return threeagent.impl.threejs.group.call(null);
}));
threeagent.impl.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"camera","camera",-1190348585),(function (p__2598){
var map__2599 = p__2598;
var map__2599__$1 = (((((!((map__2599 == null))))?(((((map__2599.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2599.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2599):map__2599);
var fov = cljs.core.get.call(null,map__2599__$1,new cljs.core.Keyword(null,"fov","fov",-12463282));
var aspectRatio = cljs.core.get.call(null,map__2599__$1,new cljs.core.Keyword(null,"aspectRatio","aspectRatio",-218867702));
var near = cljs.core.get.call(null,map__2599__$1,new cljs.core.Keyword(null,"near","near",-1077668328));
var far = cljs.core.get.call(null,map__2599__$1,new cljs.core.Keyword(null,"far","far",85807546));
return threeagent.impl.threejs.perspective_camera.call(null,fov,aspectRatio,near,far);
}));
threeagent.impl.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"instance","instance",-2121349050),(function (p__2601){
var map__2602 = p__2601;
var map__2602__$1 = (((((!((map__2602 == null))))?(((((map__2602.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2602.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2602):map__2602);
var object = cljs.core.get.call(null,map__2602__$1,new cljs.core.Keyword(null,"object","object",1474613949));
return object;
}));
threeagent.impl.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"plane","plane",-223595224),(function (p__2604){
var map__2605 = p__2604;
var map__2605__$1 = (((((!((map__2605 == null))))?(((((map__2605.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2605.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2605):map__2605);
var dims = cljs.core.get.call(null,map__2605__$1,new cljs.core.Keyword(null,"dims","dims",-466522889));
var segment_dims = cljs.core.get.call(null,map__2605__$1,new cljs.core.Keyword(null,"segment-dims","segment-dims",1394305588));
var material = cljs.core.get.call(null,map__2605__$1,new cljs.core.Keyword(null,"material","material",460118677));
var vec__2607 = dims;
var w = cljs.core.nth.call(null,vec__2607,(0),null);
var h = cljs.core.nth.call(null,vec__2607,(1),null);
var vec__2610 = segment_dims;
var sw = cljs.core.nth.call(null,vec__2610,(0),null);
var sh = cljs.core.nth.call(null,vec__2610,(1),null);
var geo = threeagent.impl.threejs.plane_geometry.call(null,w,h,sw,sh);
return threeagent.impl.component.to_mesh.call(null,geo,material);
}));
threeagent.impl.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"box","box",1530920394),(function (p__2613){
var map__2614 = p__2613;
var map__2614__$1 = (((((!((map__2614 == null))))?(((((map__2614.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2614.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2614):map__2614);
var dims = cljs.core.get.call(null,map__2614__$1,new cljs.core.Keyword(null,"dims","dims",-466522889));
var material = cljs.core.get.call(null,map__2614__$1,new cljs.core.Keyword(null,"material","material",460118677));
var vec__2616 = dims;
var x = cljs.core.nth.call(null,vec__2616,(0),null);
var y = cljs.core.nth.call(null,vec__2616,(1),null);
var z = cljs.core.nth.call(null,vec__2616,(2),null);
var geo = threeagent.impl.threejs.box_geometry.call(null,x,y,z);
return threeagent.impl.component.to_mesh.call(null,geo,material);
}));
threeagent.impl.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"sphere","sphere",384337120),(function (p__2619){
var map__2620 = p__2619;
var map__2620__$1 = (((((!((map__2620 == null))))?(((((map__2620.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2620.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2620):map__2620);
var radius = cljs.core.get.call(null,map__2620__$1,new cljs.core.Keyword(null,"radius","radius",-2073122258));
var width_segments = cljs.core.get.call(null,map__2620__$1,new cljs.core.Keyword(null,"width-segments","width-segments",25187827));
var height_segments = cljs.core.get.call(null,map__2620__$1,new cljs.core.Keyword(null,"height-segments","height-segments",1831894149));
var material = cljs.core.get.call(null,map__2620__$1,new cljs.core.Keyword(null,"material","material",460118677));
var geo = threeagent.impl.threejs.sphere_geometry.call(null,radius,(function (){var or__4131__auto__ = width_segments;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (12);
}
})(),(function (){var or__4131__auto__ = height_segments;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (12);
}
})());
return threeagent.impl.component.to_mesh.call(null,geo,material);
}));
threeagent.impl.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"point-light","point-light",669926690),(function (p__2622){
var map__2623 = p__2622;
var map__2623__$1 = (((((!((map__2623 == null))))?(((((map__2623.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2623.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2623):map__2623);
var color = cljs.core.get.call(null,map__2623__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var intensity = cljs.core.get.call(null,map__2623__$1,new cljs.core.Keyword(null,"intensity","intensity",1142770863));
var distance = cljs.core.get.call(null,map__2623__$1,new cljs.core.Keyword(null,"distance","distance",-1671893894));
return threeagent.impl.threejs.point_light.call(null,color,intensity,distance);
}));
threeagent.impl.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"hemisphere-light","hemisphere-light",-1569111131),(function (p__2625){
var map__2626 = p__2625;
var map__2626__$1 = (((((!((map__2626 == null))))?(((((map__2626.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2626.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2626):map__2626);
var sky_color = cljs.core.get.call(null,map__2626__$1,new cljs.core.Keyword(null,"sky-color","sky-color",1803548607));
var ground_color = cljs.core.get.call(null,map__2626__$1,new cljs.core.Keyword(null,"ground-color","ground-color",-1832095873));
var intensity = cljs.core.get.call(null,map__2626__$1,new cljs.core.Keyword(null,"intensity","intensity",1142770863));
return threeagent.impl.threejs.hemisphere_light.call(null,sky_color,ground_color,intensity);
}));
threeagent.impl.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"directional-light","directional-light",1424371138),(function (p__2628){
var map__2629 = p__2628;
var map__2629__$1 = (((((!((map__2629 == null))))?(((((map__2629.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2629.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2629):map__2629);
var color = cljs.core.get.call(null,map__2629__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var intensity = cljs.core.get.call(null,map__2629__$1,new cljs.core.Keyword(null,"intensity","intensity",1142770863));
return threeagent.impl.threejs.directional_light.call(null,color,intensity);
}));
threeagent.impl.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"text","text",-1790561697),(function (p__2631){
var map__2632 = p__2631;
var map__2632__$1 = (((((!((map__2632 == null))))?(((((map__2632.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2632.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2632):map__2632);
var cfg = map__2632__$1;
var text = cljs.core.get.call(null,map__2632__$1,new cljs.core.Keyword(null,"text","text",-1790561697));
var material = cljs.core.get.call(null,map__2632__$1,new cljs.core.Keyword(null,"material","material",460118677));
var geo = threeagent.impl.threejs.text_geometry.call(null,text,cfg);
return threeagent.impl.component.to_mesh.call(null,geo,material);
}));

//# sourceMappingURL=component.js.map
