// Compiled by ClojureScript 1.10.520 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('goog.html.legacyconversions');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
goog.require('goog.async.Deferred');
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined')){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__4131__auto__ = ((cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && ((((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string'))) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372))));
if(or__4131__auto__){
return or__4131__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return goog.object.get(goog.dependencies_.nameToPath,ns);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return goog.object.get(goog.dependencies_.written,figwheel.client.file_reloading.name__GT_path.call(null,ns));
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__4131__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["cljs.nodejs",null,"goog",null,"cljs.core",null], null), null).call(null,name);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = goog.string.startsWith("clojure.",name);
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return goog.string.startsWith("goog.",name);
}
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__30099_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__30099_SHARP_));
}),goog.object.getKeys(goog.object.get(goog.dependencies_.requires,figwheel.client.file_reloading.name__GT_path.call(null,ns)))));
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.dependency_data !== 'undefined')){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name]));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns]));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__30100 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__30101 = null;
var count__30102 = (0);
var i__30103 = (0);
while(true){
if((i__30103 < count__30102)){
var n = cljs.core._nth.call(null,chunk__30101,i__30103);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);


var G__30104 = seq__30100;
var G__30105 = chunk__30101;
var G__30106 = count__30102;
var G__30107 = (i__30103 + (1));
seq__30100 = G__30104;
chunk__30101 = G__30105;
count__30102 = G__30106;
i__30103 = G__30107;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__30100);
if(temp__5457__auto__){
var seq__30100__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30100__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__30100__$1);
var G__30108 = cljs.core.chunk_rest.call(null,seq__30100__$1);
var G__30109 = c__4550__auto__;
var G__30110 = cljs.core.count.call(null,c__4550__auto__);
var G__30111 = (0);
seq__30100 = G__30108;
chunk__30101 = G__30109;
count__30102 = G__30110;
i__30103 = G__30111;
continue;
} else {
var n = cljs.core.first.call(null,seq__30100__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);


var G__30112 = cljs.core.next.call(null,seq__30100__$1);
var G__30113 = null;
var G__30114 = (0);
var G__30115 = (0);
seq__30100 = G__30112;
chunk__30101 = G__30113;
count__30102 = G__30114;
i__30103 = G__30115;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.in_upper_level_QMARK_ = (function figwheel$client$file_reloading$in_upper_level_QMARK_(topo_state,current_depth,dep){
return cljs.core.some.call(null,(function (p__30116){
var vec__30117 = p__30116;
var _ = cljs.core.nth.call(null,vec__30117,(0),null);
var v = cljs.core.nth.call(null,vec__30117,(1),null);
var and__4120__auto__ = v;
if(cljs.core.truth_(and__4120__auto__)){
return v.call(null,dep);
} else {
return and__4120__auto__;
}
}),cljs.core.filter.call(null,(function (p__30120){
var vec__30121 = p__30120;
var k = cljs.core.nth.call(null,vec__30121,(0),null);
var v = cljs.core.nth.call(null,vec__30121,(1),null);
return (k > current_depth);
}),topo_state));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__30133_30141 = cljs.core.seq.call(null,deps);
var chunk__30134_30142 = null;
var count__30135_30143 = (0);
var i__30136_30144 = (0);
while(true){
if((i__30136_30144 < count__30135_30143)){
var dep_30145 = cljs.core._nth.call(null,chunk__30134_30142,i__30136_30144);
if(cljs.core.truth_((function (){var and__4120__auto__ = dep_30145;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.not.call(null,figwheel.client.file_reloading.in_upper_level_QMARK_.call(null,cljs.core.deref.call(null,state),depth,dep_30145));
} else {
return and__4120__auto__;
}
})())){
topo_sort_helper_STAR_.call(null,dep_30145,(depth + (1)),state);
} else {
}


var G__30146 = seq__30133_30141;
var G__30147 = chunk__30134_30142;
var G__30148 = count__30135_30143;
var G__30149 = (i__30136_30144 + (1));
seq__30133_30141 = G__30146;
chunk__30134_30142 = G__30147;
count__30135_30143 = G__30148;
i__30136_30144 = G__30149;
continue;
} else {
var temp__5457__auto___30150 = cljs.core.seq.call(null,seq__30133_30141);
if(temp__5457__auto___30150){
var seq__30133_30151__$1 = temp__5457__auto___30150;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30133_30151__$1)){
var c__4550__auto___30152 = cljs.core.chunk_first.call(null,seq__30133_30151__$1);
var G__30153 = cljs.core.chunk_rest.call(null,seq__30133_30151__$1);
var G__30154 = c__4550__auto___30152;
var G__30155 = cljs.core.count.call(null,c__4550__auto___30152);
var G__30156 = (0);
seq__30133_30141 = G__30153;
chunk__30134_30142 = G__30154;
count__30135_30143 = G__30155;
i__30136_30144 = G__30156;
continue;
} else {
var dep_30157 = cljs.core.first.call(null,seq__30133_30151__$1);
if(cljs.core.truth_((function (){var and__4120__auto__ = dep_30157;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.not.call(null,figwheel.client.file_reloading.in_upper_level_QMARK_.call(null,cljs.core.deref.call(null,state),depth,dep_30157));
} else {
return and__4120__auto__;
}
})())){
topo_sort_helper_STAR_.call(null,dep_30157,(depth + (1)),state);
} else {
}


var G__30158 = cljs.core.next.call(null,seq__30133_30151__$1);
var G__30159 = null;
var G__30160 = (0);
var G__30161 = (0);
seq__30133_30141 = G__30158;
chunk__30134_30142 = G__30159;
count__30135_30143 = G__30160;
i__30136_30144 = G__30161;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__30137){
var vec__30138 = p__30137;
var seq__30139 = cljs.core.seq.call(null,vec__30138);
var first__30140 = cljs.core.first.call(null,seq__30139);
var seq__30139__$1 = cljs.core.next.call(null,seq__30139);
var x = first__30140;
var xs = seq__30139__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__30138,seq__30139,first__30140,seq__30139__$1,x,xs,get_deps__$1){
return (function (p1__30124_SHARP_){
return clojure.set.difference.call(null,p1__30124_SHARP_,x);
});})(vec__30138,seq__30139,first__30140,seq__30139__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,figwheel.client.file_reloading.immutable_ns_QMARK_),cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss)))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__30162 = cljs.core.seq.call(null,provides);
var chunk__30163 = null;
var count__30164 = (0);
var i__30165 = (0);
while(true){
if((i__30165 < count__30164)){
var prov = cljs.core._nth.call(null,chunk__30163,i__30165);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__30174_30182 = cljs.core.seq.call(null,requires);
var chunk__30175_30183 = null;
var count__30176_30184 = (0);
var i__30177_30185 = (0);
while(true){
if((i__30177_30185 < count__30176_30184)){
var req_30186 = cljs.core._nth.call(null,chunk__30175_30183,i__30177_30185);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_30186,prov);


var G__30187 = seq__30174_30182;
var G__30188 = chunk__30175_30183;
var G__30189 = count__30176_30184;
var G__30190 = (i__30177_30185 + (1));
seq__30174_30182 = G__30187;
chunk__30175_30183 = G__30188;
count__30176_30184 = G__30189;
i__30177_30185 = G__30190;
continue;
} else {
var temp__5457__auto___30191 = cljs.core.seq.call(null,seq__30174_30182);
if(temp__5457__auto___30191){
var seq__30174_30192__$1 = temp__5457__auto___30191;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30174_30192__$1)){
var c__4550__auto___30193 = cljs.core.chunk_first.call(null,seq__30174_30192__$1);
var G__30194 = cljs.core.chunk_rest.call(null,seq__30174_30192__$1);
var G__30195 = c__4550__auto___30193;
var G__30196 = cljs.core.count.call(null,c__4550__auto___30193);
var G__30197 = (0);
seq__30174_30182 = G__30194;
chunk__30175_30183 = G__30195;
count__30176_30184 = G__30196;
i__30177_30185 = G__30197;
continue;
} else {
var req_30198 = cljs.core.first.call(null,seq__30174_30192__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_30198,prov);


var G__30199 = cljs.core.next.call(null,seq__30174_30192__$1);
var G__30200 = null;
var G__30201 = (0);
var G__30202 = (0);
seq__30174_30182 = G__30199;
chunk__30175_30183 = G__30200;
count__30176_30184 = G__30201;
i__30177_30185 = G__30202;
continue;
}
} else {
}
}
break;
}


var G__30203 = seq__30162;
var G__30204 = chunk__30163;
var G__30205 = count__30164;
var G__30206 = (i__30165 + (1));
seq__30162 = G__30203;
chunk__30163 = G__30204;
count__30164 = G__30205;
i__30165 = G__30206;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__30162);
if(temp__5457__auto__){
var seq__30162__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30162__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__30162__$1);
var G__30207 = cljs.core.chunk_rest.call(null,seq__30162__$1);
var G__30208 = c__4550__auto__;
var G__30209 = cljs.core.count.call(null,c__4550__auto__);
var G__30210 = (0);
seq__30162 = G__30207;
chunk__30163 = G__30208;
count__30164 = G__30209;
i__30165 = G__30210;
continue;
} else {
var prov = cljs.core.first.call(null,seq__30162__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__30178_30211 = cljs.core.seq.call(null,requires);
var chunk__30179_30212 = null;
var count__30180_30213 = (0);
var i__30181_30214 = (0);
while(true){
if((i__30181_30214 < count__30180_30213)){
var req_30215 = cljs.core._nth.call(null,chunk__30179_30212,i__30181_30214);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_30215,prov);


var G__30216 = seq__30178_30211;
var G__30217 = chunk__30179_30212;
var G__30218 = count__30180_30213;
var G__30219 = (i__30181_30214 + (1));
seq__30178_30211 = G__30216;
chunk__30179_30212 = G__30217;
count__30180_30213 = G__30218;
i__30181_30214 = G__30219;
continue;
} else {
var temp__5457__auto___30220__$1 = cljs.core.seq.call(null,seq__30178_30211);
if(temp__5457__auto___30220__$1){
var seq__30178_30221__$1 = temp__5457__auto___30220__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30178_30221__$1)){
var c__4550__auto___30222 = cljs.core.chunk_first.call(null,seq__30178_30221__$1);
var G__30223 = cljs.core.chunk_rest.call(null,seq__30178_30221__$1);
var G__30224 = c__4550__auto___30222;
var G__30225 = cljs.core.count.call(null,c__4550__auto___30222);
var G__30226 = (0);
seq__30178_30211 = G__30223;
chunk__30179_30212 = G__30224;
count__30180_30213 = G__30225;
i__30181_30214 = G__30226;
continue;
} else {
var req_30227 = cljs.core.first.call(null,seq__30178_30221__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_30227,prov);


var G__30228 = cljs.core.next.call(null,seq__30178_30221__$1);
var G__30229 = null;
var G__30230 = (0);
var G__30231 = (0);
seq__30178_30211 = G__30228;
chunk__30179_30212 = G__30229;
count__30180_30213 = G__30230;
i__30181_30214 = G__30231;
continue;
}
} else {
}
}
break;
}


var G__30232 = cljs.core.next.call(null,seq__30162__$1);
var G__30233 = null;
var G__30234 = (0);
var G__30235 = (0);
seq__30162 = G__30232;
chunk__30163 = G__30233;
count__30164 = G__30234;
i__30165 = G__30235;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__30236_30240 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__30237_30241 = null;
var count__30238_30242 = (0);
var i__30239_30243 = (0);
while(true){
if((i__30239_30243 < count__30238_30242)){
var ns_30244 = cljs.core._nth.call(null,chunk__30237_30241,i__30239_30243);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_30244);


var G__30245 = seq__30236_30240;
var G__30246 = chunk__30237_30241;
var G__30247 = count__30238_30242;
var G__30248 = (i__30239_30243 + (1));
seq__30236_30240 = G__30245;
chunk__30237_30241 = G__30246;
count__30238_30242 = G__30247;
i__30239_30243 = G__30248;
continue;
} else {
var temp__5457__auto___30249 = cljs.core.seq.call(null,seq__30236_30240);
if(temp__5457__auto___30249){
var seq__30236_30250__$1 = temp__5457__auto___30249;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30236_30250__$1)){
var c__4550__auto___30251 = cljs.core.chunk_first.call(null,seq__30236_30250__$1);
var G__30252 = cljs.core.chunk_rest.call(null,seq__30236_30250__$1);
var G__30253 = c__4550__auto___30251;
var G__30254 = cljs.core.count.call(null,c__4550__auto___30251);
var G__30255 = (0);
seq__30236_30240 = G__30252;
chunk__30237_30241 = G__30253;
count__30238_30242 = G__30254;
i__30239_30243 = G__30255;
continue;
} else {
var ns_30256 = cljs.core.first.call(null,seq__30236_30250__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_30256);


var G__30257 = cljs.core.next.call(null,seq__30236_30250__$1);
var G__30258 = null;
var G__30259 = (0);
var G__30260 = (0);
seq__30236_30240 = G__30257;
chunk__30237_30241 = G__30258;
count__30238_30242 = G__30259;
i__30239_30243 = G__30260;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__4131__auto__ = goog.require__;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__30261__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__30261 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__30262__i = 0, G__30262__a = new Array(arguments.length -  0);
while (G__30262__i < G__30262__a.length) {G__30262__a[G__30262__i] = arguments[G__30262__i + 0]; ++G__30262__i;}
  args = new cljs.core.IndexedSeq(G__30262__a,0,null);
} 
return G__30261__delegate.call(this,args);};
G__30261.cljs$lang$maxFixedArity = 0;
G__30261.cljs$lang$applyTo = (function (arglist__30263){
var args = cljs.core.seq(arglist__30263);
return G__30261__delegate(args);
});
G__30261.cljs$core$IFn$_invoke$arity$variadic = G__30261__delegate;
return G__30261;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined')){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.gloader = (((typeof goog !== 'undefined') && (typeof goog.net !== 'undefined') && (typeof goog.net.jsloader !== 'undefined') && (typeof goog.net.jsloader.safeLoad !== 'undefined'))?(function (p1__30264_SHARP_,p2__30265_SHARP_){
return goog.net.jsloader.safeLoad(goog.html.legacyconversions.trustedResourceUrlFromString(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__30264_SHARP_)),p2__30265_SHARP_);
}):(((typeof goog !== 'undefined') && (typeof goog.net !== 'undefined') && (typeof goog.net.jsloader !== 'undefined') && (typeof goog.net.jsloader.load !== 'undefined'))?(function (p1__30266_SHARP_,p2__30267_SHARP_){
return goog.net.jsloader.load(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__30266_SHARP_),p2__30267_SHARP_);
}):(function(){throw cljs.core.ex_info.call(null,"No remote script loading function found.",cljs.core.PersistentArrayMap.EMPTY)})()
));
figwheel.client.file_reloading.reload_file_in_html_env = (function figwheel$client$file_reloading$reload_file_in_html_env(request_url,callback){

var G__30268 = figwheel.client.file_reloading.gloader.call(null,figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
G__30268.addCallback(((function (G__30268){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(G__30268))
);

G__30268.addErrback(((function (G__30268){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(G__30268))
);

return G__30268;
});
figwheel.client.file_reloading.write_script_tag_import = figwheel.client.file_reloading.reload_file_in_html_env;
goog.exportSymbol('figwheel.client.file_reloading.write_script_tag_import', figwheel.client.file_reloading.write_script_tag_import);
figwheel.client.file_reloading.worker_import_script = (function figwheel$client$file_reloading$worker_import_script(request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e30269){if((e30269 instanceof Error)){
var e = e30269;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e30269;

}
}})());
});
goog.exportSymbol('figwheel.client.file_reloading.worker_import_script', figwheel.client.file_reloading.worker_import_script);
figwheel.client.file_reloading.create_node_script_import_fn = (function figwheel$client$file_reloading$create_node_script_import_fn(){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e30270){if((e30270 instanceof Error)){
var e = e30270;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e30270;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path))
});
goog.exportSymbol('figwheel.client.file_reloading.create_node_script_import_fn', figwheel.client.file_reloading.create_node_script_import_fn);
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__30271 = cljs.core._EQ_;
var expr__30272 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__30271.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__30272))){
return figwheel.client.file_reloading.create_node_script_import_fn.call(null);
} else {
if(cljs.core.truth_(pred__30271.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__30272))){
return figwheel.client.file_reloading.write_script_tag_import;
} else {
if(cljs.core.truth_(pred__30271.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__30272))){
return figwheel.client.file_reloading.worker_import_script;
} else {
return ((function (pred__30271,expr__30272){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__30271,expr__30272))
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__30274,callback){
var map__30275 = p__30274;
var map__30275__$1 = (((((!((map__30275 == null))))?(((((map__30275.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30275.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30275):map__30275);
var file_msg = map__30275__$1;
var request_url = cljs.core.get.call(null,map__30275__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,["FigWheel: Attempting to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return (function (){var or__4131__auto__ = goog.object.get(goog.global,"FIGWHEEL_IMPORT_SCRIPT");
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return figwheel.client.file_reloading.reload_file_STAR_;
}
})().call(null,request_url,((function (map__30275,map__30275__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,["FigWheel: Successfully loaded ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__30275,map__30275__$1,file_msg,request_url))
);
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.reload_chan !== 'undefined')){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined')){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined')){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.reloader_loop !== 'undefined')){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__25572__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25572__auto__){
return (function (){
var f__25573__auto__ = (function (){var switch__25405__auto__ = ((function (c__25572__auto__){
return (function (state_30313){
var state_val_30314 = (state_30313[(1)]);
if((state_val_30314 === (7))){
var inst_30309 = (state_30313[(2)]);
var state_30313__$1 = state_30313;
var statearr_30315_30341 = state_30313__$1;
(statearr_30315_30341[(2)] = inst_30309);

(statearr_30315_30341[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30314 === (1))){
var state_30313__$1 = state_30313;
var statearr_30316_30342 = state_30313__$1;
(statearr_30316_30342[(2)] = null);

(statearr_30316_30342[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30314 === (4))){
var inst_30279 = (state_30313[(7)]);
var inst_30279__$1 = (state_30313[(2)]);
var state_30313__$1 = (function (){var statearr_30317 = state_30313;
(statearr_30317[(7)] = inst_30279__$1);

return statearr_30317;
})();
if(cljs.core.truth_(inst_30279__$1)){
var statearr_30318_30343 = state_30313__$1;
(statearr_30318_30343[(1)] = (5));

} else {
var statearr_30319_30344 = state_30313__$1;
(statearr_30319_30344[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30314 === (15))){
var inst_30294 = (state_30313[(8)]);
var inst_30292 = (state_30313[(9)]);
var inst_30296 = inst_30294.call(null,inst_30292);
var state_30313__$1 = state_30313;
var statearr_30320_30345 = state_30313__$1;
(statearr_30320_30345[(2)] = inst_30296);

(statearr_30320_30345[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30314 === (13))){
var inst_30303 = (state_30313[(2)]);
var state_30313__$1 = state_30313;
var statearr_30321_30346 = state_30313__$1;
(statearr_30321_30346[(2)] = inst_30303);

(statearr_30321_30346[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30314 === (6))){
var state_30313__$1 = state_30313;
var statearr_30322_30347 = state_30313__$1;
(statearr_30322_30347[(2)] = null);

(statearr_30322_30347[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30314 === (17))){
var inst_30300 = (state_30313[(2)]);
var state_30313__$1 = state_30313;
var statearr_30323_30348 = state_30313__$1;
(statearr_30323_30348[(2)] = inst_30300);

(statearr_30323_30348[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30314 === (3))){
var inst_30311 = (state_30313[(2)]);
var state_30313__$1 = state_30313;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30313__$1,inst_30311);
} else {
if((state_val_30314 === (12))){
var state_30313__$1 = state_30313;
var statearr_30324_30349 = state_30313__$1;
(statearr_30324_30349[(2)] = null);

(statearr_30324_30349[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30314 === (2))){
var state_30313__$1 = state_30313;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30313__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_30314 === (11))){
var inst_30284 = (state_30313[(10)]);
var inst_30290 = figwheel.client.file_reloading.blocking_load.call(null,inst_30284);
var state_30313__$1 = state_30313;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30313__$1,(14),inst_30290);
} else {
if((state_val_30314 === (9))){
var inst_30284 = (state_30313[(10)]);
var state_30313__$1 = state_30313;
if(cljs.core.truth_(inst_30284)){
var statearr_30325_30350 = state_30313__$1;
(statearr_30325_30350[(1)] = (11));

} else {
var statearr_30326_30351 = state_30313__$1;
(statearr_30326_30351[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30314 === (5))){
var inst_30285 = (state_30313[(11)]);
var inst_30279 = (state_30313[(7)]);
var inst_30284 = cljs.core.nth.call(null,inst_30279,(0),null);
var inst_30285__$1 = cljs.core.nth.call(null,inst_30279,(1),null);
var state_30313__$1 = (function (){var statearr_30327 = state_30313;
(statearr_30327[(11)] = inst_30285__$1);

(statearr_30327[(10)] = inst_30284);

return statearr_30327;
})();
if(cljs.core.truth_(inst_30285__$1)){
var statearr_30328_30352 = state_30313__$1;
(statearr_30328_30352[(1)] = (8));

} else {
var statearr_30329_30353 = state_30313__$1;
(statearr_30329_30353[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30314 === (14))){
var inst_30294 = (state_30313[(8)]);
var inst_30284 = (state_30313[(10)]);
var inst_30292 = (state_30313[(2)]);
var inst_30293 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_30294__$1 = cljs.core.get.call(null,inst_30293,inst_30284);
var state_30313__$1 = (function (){var statearr_30330 = state_30313;
(statearr_30330[(8)] = inst_30294__$1);

(statearr_30330[(9)] = inst_30292);

return statearr_30330;
})();
if(cljs.core.truth_(inst_30294__$1)){
var statearr_30331_30354 = state_30313__$1;
(statearr_30331_30354[(1)] = (15));

} else {
var statearr_30332_30355 = state_30313__$1;
(statearr_30332_30355[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30314 === (16))){
var inst_30292 = (state_30313[(9)]);
var inst_30298 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_30292);
var state_30313__$1 = state_30313;
var statearr_30333_30356 = state_30313__$1;
(statearr_30333_30356[(2)] = inst_30298);

(statearr_30333_30356[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30314 === (10))){
var inst_30305 = (state_30313[(2)]);
var state_30313__$1 = (function (){var statearr_30334 = state_30313;
(statearr_30334[(12)] = inst_30305);

return statearr_30334;
})();
var statearr_30335_30357 = state_30313__$1;
(statearr_30335_30357[(2)] = null);

(statearr_30335_30357[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30314 === (8))){
var inst_30285 = (state_30313[(11)]);
var inst_30287 = eval(inst_30285);
var state_30313__$1 = state_30313;
var statearr_30336_30358 = state_30313__$1;
(statearr_30336_30358[(2)] = inst_30287);

(statearr_30336_30358[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25572__auto__))
;
return ((function (switch__25405__auto__,c__25572__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__25406__auto__ = null;
var figwheel$client$file_reloading$state_machine__25406__auto____0 = (function (){
var statearr_30337 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30337[(0)] = figwheel$client$file_reloading$state_machine__25406__auto__);

(statearr_30337[(1)] = (1));

return statearr_30337;
});
var figwheel$client$file_reloading$state_machine__25406__auto____1 = (function (state_30313){
while(true){
var ret_value__25407__auto__ = (function (){try{while(true){
var result__25408__auto__ = switch__25405__auto__.call(null,state_30313);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25408__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25408__auto__;
}
break;
}
}catch (e30338){if((e30338 instanceof Object)){
var ex__25409__auto__ = e30338;
var statearr_30339_30359 = state_30313;
(statearr_30339_30359[(5)] = ex__25409__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30313);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30338;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25407__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30360 = state_30313;
state_30313 = G__30360;
continue;
} else {
return ret_value__25407__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__25406__auto__ = function(state_30313){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__25406__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__25406__auto____1.call(this,state_30313);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__25406__auto____0;
figwheel$client$file_reloading$state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__25406__auto____1;
return figwheel$client$file_reloading$state_machine__25406__auto__;
})()
;})(switch__25405__auto__,c__25572__auto__))
})();
var state__25574__auto__ = (function (){var statearr_30340 = f__25573__auto__.call(null);
(statearr_30340[(6)] = c__25572__auto__);

return statearr_30340;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25574__auto__);
});})(c__25572__auto__))
);

return c__25572__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(var_args){
var G__30362 = arguments.length;
switch (G__30362) {
case 1:
return figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$1 = (function (url){
return figwheel.client.file_reloading.queued_file_reload.call(null,url,null);
});

figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$2 = (function (url,opt_source_text){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,opt_source_text], null));
});

figwheel.client.file_reloading.queued_file_reload.cljs$lang$maxFixedArity = 2;

figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__30364,callback){
var map__30365 = p__30364;
var map__30365__$1 = (((((!((map__30365 == null))))?(((((map__30365.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30365.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30365):map__30365);
var file_msg = map__30365__$1;
var namespace = cljs.core.get.call(null,map__30365__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__30365,map__30365__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__30365,map__30365__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__30367){
var map__30368 = p__30367;
var map__30368__$1 = (((((!((map__30368 == null))))?(((((map__30368.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30368.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30368):map__30368);
var file_msg = map__30368__$1;
var namespace = cljs.core.get.call(null,map__30368__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.ns_exists_QMARK_ = (function figwheel$client$file_reloading$ns_exists_QMARK_(namespace){
return (!((cljs.core.reduce.call(null,cljs.core.fnil.call(null,goog.object.get,({})),goog.global,clojure.string.split.call(null,cljs.core.name.call(null,namespace),".")) == null)));
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__30370){
var map__30371 = p__30370;
var map__30371__$1 = (((((!((map__30371 == null))))?(((((map__30371.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30371.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30371):map__30371);
var file_msg = map__30371__$1;
var namespace = cljs.core.get.call(null,map__30371__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__4120__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__4120__auto__){
var or__4131__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
var or__4131__auto____$2 = figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
if(cljs.core.truth_(or__4131__auto____$2)){
return or__4131__auto____$2;
} else {
return figwheel.client.file_reloading.ns_exists_QMARK_.call(null,namespace);
}
}
}
} else {
return and__4120__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__30373,callback){
var map__30374 = p__30373;
var map__30374__$1 = (((((!((map__30374 == null))))?(((((map__30374.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30374.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30374):map__30374);
var file_msg = map__30374__$1;
var request_url = cljs.core.get.call(null,map__30374__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__30374__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,["Figwheel: Not trying to load file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__25572__auto___30424 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25572__auto___30424,out){
return (function (){
var f__25573__auto__ = (function (){var switch__25405__auto__ = ((function (c__25572__auto___30424,out){
return (function (state_30409){
var state_val_30410 = (state_30409[(1)]);
if((state_val_30410 === (1))){
var inst_30383 = cljs.core.seq.call(null,files);
var inst_30384 = cljs.core.first.call(null,inst_30383);
var inst_30385 = cljs.core.next.call(null,inst_30383);
var inst_30386 = files;
var state_30409__$1 = (function (){var statearr_30411 = state_30409;
(statearr_30411[(7)] = inst_30384);

(statearr_30411[(8)] = inst_30385);

(statearr_30411[(9)] = inst_30386);

return statearr_30411;
})();
var statearr_30412_30425 = state_30409__$1;
(statearr_30412_30425[(2)] = null);

(statearr_30412_30425[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30410 === (2))){
var inst_30392 = (state_30409[(10)]);
var inst_30386 = (state_30409[(9)]);
var inst_30391 = cljs.core.seq.call(null,inst_30386);
var inst_30392__$1 = cljs.core.first.call(null,inst_30391);
var inst_30393 = cljs.core.next.call(null,inst_30391);
var inst_30394 = (inst_30392__$1 == null);
var inst_30395 = cljs.core.not.call(null,inst_30394);
var state_30409__$1 = (function (){var statearr_30413 = state_30409;
(statearr_30413[(10)] = inst_30392__$1);

(statearr_30413[(11)] = inst_30393);

return statearr_30413;
})();
if(inst_30395){
var statearr_30414_30426 = state_30409__$1;
(statearr_30414_30426[(1)] = (4));

} else {
var statearr_30415_30427 = state_30409__$1;
(statearr_30415_30427[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30410 === (3))){
var inst_30407 = (state_30409[(2)]);
var state_30409__$1 = state_30409;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30409__$1,inst_30407);
} else {
if((state_val_30410 === (4))){
var inst_30392 = (state_30409[(10)]);
var inst_30397 = figwheel.client.file_reloading.reload_js_file.call(null,inst_30392);
var state_30409__$1 = state_30409;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30409__$1,(7),inst_30397);
} else {
if((state_val_30410 === (5))){
var inst_30403 = cljs.core.async.close_BANG_.call(null,out);
var state_30409__$1 = state_30409;
var statearr_30416_30428 = state_30409__$1;
(statearr_30416_30428[(2)] = inst_30403);

(statearr_30416_30428[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30410 === (6))){
var inst_30405 = (state_30409[(2)]);
var state_30409__$1 = state_30409;
var statearr_30417_30429 = state_30409__$1;
(statearr_30417_30429[(2)] = inst_30405);

(statearr_30417_30429[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30410 === (7))){
var inst_30393 = (state_30409[(11)]);
var inst_30399 = (state_30409[(2)]);
var inst_30400 = cljs.core.async.put_BANG_.call(null,out,inst_30399);
var inst_30386 = inst_30393;
var state_30409__$1 = (function (){var statearr_30418 = state_30409;
(statearr_30418[(12)] = inst_30400);

(statearr_30418[(9)] = inst_30386);

return statearr_30418;
})();
var statearr_30419_30430 = state_30409__$1;
(statearr_30419_30430[(2)] = null);

(statearr_30419_30430[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__25572__auto___30424,out))
;
return ((function (switch__25405__auto__,c__25572__auto___30424,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__25406__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__25406__auto____0 = (function (){
var statearr_30420 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30420[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__25406__auto__);

(statearr_30420[(1)] = (1));

return statearr_30420;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__25406__auto____1 = (function (state_30409){
while(true){
var ret_value__25407__auto__ = (function (){try{while(true){
var result__25408__auto__ = switch__25405__auto__.call(null,state_30409);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25408__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25408__auto__;
}
break;
}
}catch (e30421){if((e30421 instanceof Object)){
var ex__25409__auto__ = e30421;
var statearr_30422_30431 = state_30409;
(statearr_30422_30431[(5)] = ex__25409__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30409);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30421;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25407__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30432 = state_30409;
state_30409 = G__30432;
continue;
} else {
return ret_value__25407__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__25406__auto__ = function(state_30409){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__25406__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__25406__auto____1.call(this,state_30409);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__25406__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__25406__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__25406__auto__;
})()
;})(switch__25405__auto__,c__25572__auto___30424,out))
})();
var state__25574__auto__ = (function (){var statearr_30423 = f__25573__auto__.call(null);
(statearr_30423[(6)] = c__25572__auto___30424);

return statearr_30423;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25574__auto__);
});})(c__25572__auto___30424,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__30433,opts){
var map__30434 = p__30433;
var map__30434__$1 = (((((!((map__30434 == null))))?(((((map__30434.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30434.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30434):map__30434);
var eval_body = cljs.core.get.call(null,map__30434__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__30434__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__4120__auto__ = eval_body;
if(cljs.core.truth_(and__4120__auto__)){
return typeof eval_body === 'string';
} else {
return and__4120__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,["Evaling file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e30436){var e = e30436;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Unable to evaluate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__5455__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__30437_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__30437_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__5455__auto__)){
var file_msg = temp__5455__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__30438){
var vec__30439 = p__30438;
var k = cljs.core.nth.call(null,vec__30439,(0),null);
var v = cljs.core.nth.call(null,vec__30439,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__30442){
var vec__30443 = p__30442;
var k = cljs.core.nth.call(null,vec__30443,(0),null);
var v = cljs.core.nth.call(null,vec__30443,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__30449,p__30450){
var map__30451 = p__30449;
var map__30451__$1 = (((((!((map__30451 == null))))?(((((map__30451.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30451.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30451):map__30451);
var opts = map__30451__$1;
var before_jsload = cljs.core.get.call(null,map__30451__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__30451__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__30451__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__30452 = p__30450;
var map__30452__$1 = (((((!((map__30452 == null))))?(((((map__30452.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30452.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30452):map__30452);
var msg = map__30452__$1;
var files = cljs.core.get.call(null,map__30452__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__30452__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__30452__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__25572__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25572__auto__,map__30451,map__30451__$1,opts,before_jsload,on_jsload,reload_dependents,map__30452,map__30452__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__25573__auto__ = (function (){var switch__25405__auto__ = ((function (c__25572__auto__,map__30451,map__30451__$1,opts,before_jsload,on_jsload,reload_dependents,map__30452,map__30452__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_30606){
var state_val_30607 = (state_30606[(1)]);
if((state_val_30607 === (7))){
var inst_30467 = (state_30606[(7)]);
var inst_30466 = (state_30606[(8)]);
var inst_30468 = (state_30606[(9)]);
var inst_30469 = (state_30606[(10)]);
var inst_30474 = cljs.core._nth.call(null,inst_30467,inst_30469);
var inst_30475 = figwheel.client.file_reloading.eval_body.call(null,inst_30474,opts);
var inst_30476 = (inst_30469 + (1));
var tmp30608 = inst_30467;
var tmp30609 = inst_30466;
var tmp30610 = inst_30468;
var inst_30466__$1 = tmp30609;
var inst_30467__$1 = tmp30608;
var inst_30468__$1 = tmp30610;
var inst_30469__$1 = inst_30476;
var state_30606__$1 = (function (){var statearr_30611 = state_30606;
(statearr_30611[(7)] = inst_30467__$1);

(statearr_30611[(11)] = inst_30475);

(statearr_30611[(8)] = inst_30466__$1);

(statearr_30611[(9)] = inst_30468__$1);

(statearr_30611[(10)] = inst_30469__$1);

return statearr_30611;
})();
var statearr_30612_30695 = state_30606__$1;
(statearr_30612_30695[(2)] = null);

(statearr_30612_30695[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (20))){
var inst_30509 = (state_30606[(12)]);
var inst_30517 = figwheel.client.file_reloading.sort_files.call(null,inst_30509);
var state_30606__$1 = state_30606;
var statearr_30613_30696 = state_30606__$1;
(statearr_30613_30696[(2)] = inst_30517);

(statearr_30613_30696[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (27))){
var state_30606__$1 = state_30606;
var statearr_30614_30697 = state_30606__$1;
(statearr_30614_30697[(2)] = null);

(statearr_30614_30697[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (1))){
var inst_30458 = (state_30606[(13)]);
var inst_30455 = before_jsload.call(null,files);
var inst_30456 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_30457 = (function (){return ((function (inst_30458,inst_30455,inst_30456,state_val_30607,c__25572__auto__,map__30451,map__30451__$1,opts,before_jsload,on_jsload,reload_dependents,map__30452,map__30452__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__30446_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__30446_SHARP_);
});
;})(inst_30458,inst_30455,inst_30456,state_val_30607,c__25572__auto__,map__30451,map__30451__$1,opts,before_jsload,on_jsload,reload_dependents,map__30452,map__30452__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_30458__$1 = cljs.core.filter.call(null,inst_30457,files);
var inst_30459 = cljs.core.not_empty.call(null,inst_30458__$1);
var state_30606__$1 = (function (){var statearr_30615 = state_30606;
(statearr_30615[(13)] = inst_30458__$1);

(statearr_30615[(14)] = inst_30455);

(statearr_30615[(15)] = inst_30456);

return statearr_30615;
})();
if(cljs.core.truth_(inst_30459)){
var statearr_30616_30698 = state_30606__$1;
(statearr_30616_30698[(1)] = (2));

} else {
var statearr_30617_30699 = state_30606__$1;
(statearr_30617_30699[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (24))){
var state_30606__$1 = state_30606;
var statearr_30618_30700 = state_30606__$1;
(statearr_30618_30700[(2)] = null);

(statearr_30618_30700[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (39))){
var inst_30559 = (state_30606[(16)]);
var state_30606__$1 = state_30606;
var statearr_30619_30701 = state_30606__$1;
(statearr_30619_30701[(2)] = inst_30559);

(statearr_30619_30701[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (46))){
var inst_30601 = (state_30606[(2)]);
var state_30606__$1 = state_30606;
var statearr_30620_30702 = state_30606__$1;
(statearr_30620_30702[(2)] = inst_30601);

(statearr_30620_30702[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (4))){
var inst_30503 = (state_30606[(2)]);
var inst_30504 = cljs.core.List.EMPTY;
var inst_30505 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_30504);
var inst_30506 = (function (){return ((function (inst_30503,inst_30504,inst_30505,state_val_30607,c__25572__auto__,map__30451,map__30451__$1,opts,before_jsload,on_jsload,reload_dependents,map__30452,map__30452__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__30447_SHARP_){
var and__4120__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__30447_SHARP_);
if(cljs.core.truth_(and__4120__auto__)){
return ((cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__30447_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__30447_SHARP_))));
} else {
return and__4120__auto__;
}
});
;})(inst_30503,inst_30504,inst_30505,state_val_30607,c__25572__auto__,map__30451,map__30451__$1,opts,before_jsload,on_jsload,reload_dependents,map__30452,map__30452__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_30507 = cljs.core.filter.call(null,inst_30506,files);
var inst_30508 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_30509 = cljs.core.concat.call(null,inst_30507,inst_30508);
var state_30606__$1 = (function (){var statearr_30621 = state_30606;
(statearr_30621[(17)] = inst_30503);

(statearr_30621[(18)] = inst_30505);

(statearr_30621[(12)] = inst_30509);

return statearr_30621;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_30622_30703 = state_30606__$1;
(statearr_30622_30703[(1)] = (16));

} else {
var statearr_30623_30704 = state_30606__$1;
(statearr_30623_30704[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (15))){
var inst_30493 = (state_30606[(2)]);
var state_30606__$1 = state_30606;
var statearr_30624_30705 = state_30606__$1;
(statearr_30624_30705[(2)] = inst_30493);

(statearr_30624_30705[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (21))){
var inst_30519 = (state_30606[(19)]);
var inst_30519__$1 = (state_30606[(2)]);
var inst_30520 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_30519__$1);
var state_30606__$1 = (function (){var statearr_30625 = state_30606;
(statearr_30625[(19)] = inst_30519__$1);

return statearr_30625;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30606__$1,(22),inst_30520);
} else {
if((state_val_30607 === (31))){
var inst_30604 = (state_30606[(2)]);
var state_30606__$1 = state_30606;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30606__$1,inst_30604);
} else {
if((state_val_30607 === (32))){
var inst_30559 = (state_30606[(16)]);
var inst_30564 = inst_30559.cljs$lang$protocol_mask$partition0$;
var inst_30565 = (inst_30564 & (64));
var inst_30566 = inst_30559.cljs$core$ISeq$;
var inst_30567 = (cljs.core.PROTOCOL_SENTINEL === inst_30566);
var inst_30568 = ((inst_30565) || (inst_30567));
var state_30606__$1 = state_30606;
if(cljs.core.truth_(inst_30568)){
var statearr_30626_30706 = state_30606__$1;
(statearr_30626_30706[(1)] = (35));

} else {
var statearr_30627_30707 = state_30606__$1;
(statearr_30627_30707[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (40))){
var inst_30581 = (state_30606[(20)]);
var inst_30580 = (state_30606[(2)]);
var inst_30581__$1 = cljs.core.get.call(null,inst_30580,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_30582 = cljs.core.get.call(null,inst_30580,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_30583 = cljs.core.not_empty.call(null,inst_30581__$1);
var state_30606__$1 = (function (){var statearr_30628 = state_30606;
(statearr_30628[(21)] = inst_30582);

(statearr_30628[(20)] = inst_30581__$1);

return statearr_30628;
})();
if(cljs.core.truth_(inst_30583)){
var statearr_30629_30708 = state_30606__$1;
(statearr_30629_30708[(1)] = (41));

} else {
var statearr_30630_30709 = state_30606__$1;
(statearr_30630_30709[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (33))){
var state_30606__$1 = state_30606;
var statearr_30631_30710 = state_30606__$1;
(statearr_30631_30710[(2)] = false);

(statearr_30631_30710[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (13))){
var inst_30479 = (state_30606[(22)]);
var inst_30483 = cljs.core.chunk_first.call(null,inst_30479);
var inst_30484 = cljs.core.chunk_rest.call(null,inst_30479);
var inst_30485 = cljs.core.count.call(null,inst_30483);
var inst_30466 = inst_30484;
var inst_30467 = inst_30483;
var inst_30468 = inst_30485;
var inst_30469 = (0);
var state_30606__$1 = (function (){var statearr_30632 = state_30606;
(statearr_30632[(7)] = inst_30467);

(statearr_30632[(8)] = inst_30466);

(statearr_30632[(9)] = inst_30468);

(statearr_30632[(10)] = inst_30469);

return statearr_30632;
})();
var statearr_30633_30711 = state_30606__$1;
(statearr_30633_30711[(2)] = null);

(statearr_30633_30711[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (22))){
var inst_30527 = (state_30606[(23)]);
var inst_30522 = (state_30606[(24)]);
var inst_30519 = (state_30606[(19)]);
var inst_30523 = (state_30606[(25)]);
var inst_30522__$1 = (state_30606[(2)]);
var inst_30523__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_30522__$1);
var inst_30524 = (function (){var all_files = inst_30519;
var res_SINGLEQUOTE_ = inst_30522__$1;
var res = inst_30523__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_30527,inst_30522,inst_30519,inst_30523,inst_30522__$1,inst_30523__$1,state_val_30607,c__25572__auto__,map__30451,map__30451__$1,opts,before_jsload,on_jsload,reload_dependents,map__30452,map__30452__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__30448_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__30448_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_30527,inst_30522,inst_30519,inst_30523,inst_30522__$1,inst_30523__$1,state_val_30607,c__25572__auto__,map__30451,map__30451__$1,opts,before_jsload,on_jsload,reload_dependents,map__30452,map__30452__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_30525 = cljs.core.filter.call(null,inst_30524,inst_30522__$1);
var inst_30526 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_30527__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_30526);
var inst_30528 = cljs.core.not_empty.call(null,inst_30527__$1);
var state_30606__$1 = (function (){var statearr_30634 = state_30606;
(statearr_30634[(23)] = inst_30527__$1);

(statearr_30634[(24)] = inst_30522__$1);

(statearr_30634[(25)] = inst_30523__$1);

(statearr_30634[(26)] = inst_30525);

return statearr_30634;
})();
if(cljs.core.truth_(inst_30528)){
var statearr_30635_30712 = state_30606__$1;
(statearr_30635_30712[(1)] = (23));

} else {
var statearr_30636_30713 = state_30606__$1;
(statearr_30636_30713[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (36))){
var state_30606__$1 = state_30606;
var statearr_30637_30714 = state_30606__$1;
(statearr_30637_30714[(2)] = false);

(statearr_30637_30714[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (41))){
var inst_30581 = (state_30606[(20)]);
var inst_30585 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_30586 = cljs.core.map.call(null,inst_30585,inst_30581);
var inst_30587 = cljs.core.pr_str.call(null,inst_30586);
var inst_30588 = ["figwheel-no-load meta-data: ",inst_30587].join('');
var inst_30589 = figwheel.client.utils.log.call(null,inst_30588);
var state_30606__$1 = state_30606;
var statearr_30638_30715 = state_30606__$1;
(statearr_30638_30715[(2)] = inst_30589);

(statearr_30638_30715[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (43))){
var inst_30582 = (state_30606[(21)]);
var inst_30592 = (state_30606[(2)]);
var inst_30593 = cljs.core.not_empty.call(null,inst_30582);
var state_30606__$1 = (function (){var statearr_30639 = state_30606;
(statearr_30639[(27)] = inst_30592);

return statearr_30639;
})();
if(cljs.core.truth_(inst_30593)){
var statearr_30640_30716 = state_30606__$1;
(statearr_30640_30716[(1)] = (44));

} else {
var statearr_30641_30717 = state_30606__$1;
(statearr_30641_30717[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (29))){
var inst_30527 = (state_30606[(23)]);
var inst_30522 = (state_30606[(24)]);
var inst_30519 = (state_30606[(19)]);
var inst_30523 = (state_30606[(25)]);
var inst_30559 = (state_30606[(16)]);
var inst_30525 = (state_30606[(26)]);
var inst_30555 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_30558 = (function (){var all_files = inst_30519;
var res_SINGLEQUOTE_ = inst_30522;
var res = inst_30523;
var files_not_loaded = inst_30525;
var dependencies_that_loaded = inst_30527;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_30527,inst_30522,inst_30519,inst_30523,inst_30559,inst_30525,inst_30555,state_val_30607,c__25572__auto__,map__30451,map__30451__$1,opts,before_jsload,on_jsload,reload_dependents,map__30452,map__30452__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__30557){
var map__30642 = p__30557;
var map__30642__$1 = (((((!((map__30642 == null))))?(((((map__30642.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30642.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30642):map__30642);
var namespace = cljs.core.get.call(null,map__30642__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_30527,inst_30522,inst_30519,inst_30523,inst_30559,inst_30525,inst_30555,state_val_30607,c__25572__auto__,map__30451,map__30451__$1,opts,before_jsload,on_jsload,reload_dependents,map__30452,map__30452__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_30559__$1 = cljs.core.group_by.call(null,inst_30558,inst_30525);
var inst_30561 = (inst_30559__$1 == null);
var inst_30562 = cljs.core.not.call(null,inst_30561);
var state_30606__$1 = (function (){var statearr_30644 = state_30606;
(statearr_30644[(28)] = inst_30555);

(statearr_30644[(16)] = inst_30559__$1);

return statearr_30644;
})();
if(inst_30562){
var statearr_30645_30718 = state_30606__$1;
(statearr_30645_30718[(1)] = (32));

} else {
var statearr_30646_30719 = state_30606__$1;
(statearr_30646_30719[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (44))){
var inst_30582 = (state_30606[(21)]);
var inst_30595 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_30582);
var inst_30596 = cljs.core.pr_str.call(null,inst_30595);
var inst_30597 = ["not required: ",inst_30596].join('');
var inst_30598 = figwheel.client.utils.log.call(null,inst_30597);
var state_30606__$1 = state_30606;
var statearr_30647_30720 = state_30606__$1;
(statearr_30647_30720[(2)] = inst_30598);

(statearr_30647_30720[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (6))){
var inst_30500 = (state_30606[(2)]);
var state_30606__$1 = state_30606;
var statearr_30648_30721 = state_30606__$1;
(statearr_30648_30721[(2)] = inst_30500);

(statearr_30648_30721[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (28))){
var inst_30525 = (state_30606[(26)]);
var inst_30552 = (state_30606[(2)]);
var inst_30553 = cljs.core.not_empty.call(null,inst_30525);
var state_30606__$1 = (function (){var statearr_30649 = state_30606;
(statearr_30649[(29)] = inst_30552);

return statearr_30649;
})();
if(cljs.core.truth_(inst_30553)){
var statearr_30650_30722 = state_30606__$1;
(statearr_30650_30722[(1)] = (29));

} else {
var statearr_30651_30723 = state_30606__$1;
(statearr_30651_30723[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (25))){
var inst_30523 = (state_30606[(25)]);
var inst_30539 = (state_30606[(2)]);
var inst_30540 = cljs.core.not_empty.call(null,inst_30523);
var state_30606__$1 = (function (){var statearr_30652 = state_30606;
(statearr_30652[(30)] = inst_30539);

return statearr_30652;
})();
if(cljs.core.truth_(inst_30540)){
var statearr_30653_30724 = state_30606__$1;
(statearr_30653_30724[(1)] = (26));

} else {
var statearr_30654_30725 = state_30606__$1;
(statearr_30654_30725[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (34))){
var inst_30575 = (state_30606[(2)]);
var state_30606__$1 = state_30606;
if(cljs.core.truth_(inst_30575)){
var statearr_30655_30726 = state_30606__$1;
(statearr_30655_30726[(1)] = (38));

} else {
var statearr_30656_30727 = state_30606__$1;
(statearr_30656_30727[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (17))){
var state_30606__$1 = state_30606;
var statearr_30657_30728 = state_30606__$1;
(statearr_30657_30728[(2)] = recompile_dependents);

(statearr_30657_30728[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (3))){
var state_30606__$1 = state_30606;
var statearr_30658_30729 = state_30606__$1;
(statearr_30658_30729[(2)] = null);

(statearr_30658_30729[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (12))){
var inst_30496 = (state_30606[(2)]);
var state_30606__$1 = state_30606;
var statearr_30659_30730 = state_30606__$1;
(statearr_30659_30730[(2)] = inst_30496);

(statearr_30659_30730[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (2))){
var inst_30458 = (state_30606[(13)]);
var inst_30465 = cljs.core.seq.call(null,inst_30458);
var inst_30466 = inst_30465;
var inst_30467 = null;
var inst_30468 = (0);
var inst_30469 = (0);
var state_30606__$1 = (function (){var statearr_30660 = state_30606;
(statearr_30660[(7)] = inst_30467);

(statearr_30660[(8)] = inst_30466);

(statearr_30660[(9)] = inst_30468);

(statearr_30660[(10)] = inst_30469);

return statearr_30660;
})();
var statearr_30661_30731 = state_30606__$1;
(statearr_30661_30731[(2)] = null);

(statearr_30661_30731[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (23))){
var inst_30527 = (state_30606[(23)]);
var inst_30522 = (state_30606[(24)]);
var inst_30519 = (state_30606[(19)]);
var inst_30523 = (state_30606[(25)]);
var inst_30525 = (state_30606[(26)]);
var inst_30530 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_30532 = (function (){var all_files = inst_30519;
var res_SINGLEQUOTE_ = inst_30522;
var res = inst_30523;
var files_not_loaded = inst_30525;
var dependencies_that_loaded = inst_30527;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_30527,inst_30522,inst_30519,inst_30523,inst_30525,inst_30530,state_val_30607,c__25572__auto__,map__30451,map__30451__$1,opts,before_jsload,on_jsload,reload_dependents,map__30452,map__30452__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__30531){
var map__30662 = p__30531;
var map__30662__$1 = (((((!((map__30662 == null))))?(((((map__30662.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30662.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30662):map__30662);
var request_url = cljs.core.get.call(null,map__30662__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_30527,inst_30522,inst_30519,inst_30523,inst_30525,inst_30530,state_val_30607,c__25572__auto__,map__30451,map__30451__$1,opts,before_jsload,on_jsload,reload_dependents,map__30452,map__30452__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_30533 = cljs.core.reverse.call(null,inst_30527);
var inst_30534 = cljs.core.map.call(null,inst_30532,inst_30533);
var inst_30535 = cljs.core.pr_str.call(null,inst_30534);
var inst_30536 = figwheel.client.utils.log.call(null,inst_30535);
var state_30606__$1 = (function (){var statearr_30664 = state_30606;
(statearr_30664[(31)] = inst_30530);

return statearr_30664;
})();
var statearr_30665_30732 = state_30606__$1;
(statearr_30665_30732[(2)] = inst_30536);

(statearr_30665_30732[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (35))){
var state_30606__$1 = state_30606;
var statearr_30666_30733 = state_30606__$1;
(statearr_30666_30733[(2)] = true);

(statearr_30666_30733[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (19))){
var inst_30509 = (state_30606[(12)]);
var inst_30515 = figwheel.client.file_reloading.expand_files.call(null,inst_30509);
var state_30606__$1 = state_30606;
var statearr_30667_30734 = state_30606__$1;
(statearr_30667_30734[(2)] = inst_30515);

(statearr_30667_30734[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (11))){
var state_30606__$1 = state_30606;
var statearr_30668_30735 = state_30606__$1;
(statearr_30668_30735[(2)] = null);

(statearr_30668_30735[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (9))){
var inst_30498 = (state_30606[(2)]);
var state_30606__$1 = state_30606;
var statearr_30669_30736 = state_30606__$1;
(statearr_30669_30736[(2)] = inst_30498);

(statearr_30669_30736[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (5))){
var inst_30468 = (state_30606[(9)]);
var inst_30469 = (state_30606[(10)]);
var inst_30471 = (inst_30469 < inst_30468);
var inst_30472 = inst_30471;
var state_30606__$1 = state_30606;
if(cljs.core.truth_(inst_30472)){
var statearr_30670_30737 = state_30606__$1;
(statearr_30670_30737[(1)] = (7));

} else {
var statearr_30671_30738 = state_30606__$1;
(statearr_30671_30738[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (14))){
var inst_30479 = (state_30606[(22)]);
var inst_30488 = cljs.core.first.call(null,inst_30479);
var inst_30489 = figwheel.client.file_reloading.eval_body.call(null,inst_30488,opts);
var inst_30490 = cljs.core.next.call(null,inst_30479);
var inst_30466 = inst_30490;
var inst_30467 = null;
var inst_30468 = (0);
var inst_30469 = (0);
var state_30606__$1 = (function (){var statearr_30672 = state_30606;
(statearr_30672[(7)] = inst_30467);

(statearr_30672[(32)] = inst_30489);

(statearr_30672[(8)] = inst_30466);

(statearr_30672[(9)] = inst_30468);

(statearr_30672[(10)] = inst_30469);

return statearr_30672;
})();
var statearr_30673_30739 = state_30606__$1;
(statearr_30673_30739[(2)] = null);

(statearr_30673_30739[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (45))){
var state_30606__$1 = state_30606;
var statearr_30674_30740 = state_30606__$1;
(statearr_30674_30740[(2)] = null);

(statearr_30674_30740[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (26))){
var inst_30527 = (state_30606[(23)]);
var inst_30522 = (state_30606[(24)]);
var inst_30519 = (state_30606[(19)]);
var inst_30523 = (state_30606[(25)]);
var inst_30525 = (state_30606[(26)]);
var inst_30542 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_30544 = (function (){var all_files = inst_30519;
var res_SINGLEQUOTE_ = inst_30522;
var res = inst_30523;
var files_not_loaded = inst_30525;
var dependencies_that_loaded = inst_30527;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_30527,inst_30522,inst_30519,inst_30523,inst_30525,inst_30542,state_val_30607,c__25572__auto__,map__30451,map__30451__$1,opts,before_jsload,on_jsload,reload_dependents,map__30452,map__30452__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__30543){
var map__30675 = p__30543;
var map__30675__$1 = (((((!((map__30675 == null))))?(((((map__30675.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30675.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30675):map__30675);
var namespace = cljs.core.get.call(null,map__30675__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__30675__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_30527,inst_30522,inst_30519,inst_30523,inst_30525,inst_30542,state_val_30607,c__25572__auto__,map__30451,map__30451__$1,opts,before_jsload,on_jsload,reload_dependents,map__30452,map__30452__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_30545 = cljs.core.map.call(null,inst_30544,inst_30523);
var inst_30546 = cljs.core.pr_str.call(null,inst_30545);
var inst_30547 = figwheel.client.utils.log.call(null,inst_30546);
var inst_30548 = (function (){var all_files = inst_30519;
var res_SINGLEQUOTE_ = inst_30522;
var res = inst_30523;
var files_not_loaded = inst_30525;
var dependencies_that_loaded = inst_30527;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_30527,inst_30522,inst_30519,inst_30523,inst_30525,inst_30542,inst_30544,inst_30545,inst_30546,inst_30547,state_val_30607,c__25572__auto__,map__30451,map__30451__$1,opts,before_jsload,on_jsload,reload_dependents,map__30452,map__30452__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_30527,inst_30522,inst_30519,inst_30523,inst_30525,inst_30542,inst_30544,inst_30545,inst_30546,inst_30547,state_val_30607,c__25572__auto__,map__30451,map__30451__$1,opts,before_jsload,on_jsload,reload_dependents,map__30452,map__30452__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_30549 = setTimeout(inst_30548,(10));
var state_30606__$1 = (function (){var statearr_30677 = state_30606;
(statearr_30677[(33)] = inst_30547);

(statearr_30677[(34)] = inst_30542);

return statearr_30677;
})();
var statearr_30678_30741 = state_30606__$1;
(statearr_30678_30741[(2)] = inst_30549);

(statearr_30678_30741[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (16))){
var state_30606__$1 = state_30606;
var statearr_30679_30742 = state_30606__$1;
(statearr_30679_30742[(2)] = reload_dependents);

(statearr_30679_30742[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (38))){
var inst_30559 = (state_30606[(16)]);
var inst_30577 = cljs.core.apply.call(null,cljs.core.hash_map,inst_30559);
var state_30606__$1 = state_30606;
var statearr_30680_30743 = state_30606__$1;
(statearr_30680_30743[(2)] = inst_30577);

(statearr_30680_30743[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (30))){
var state_30606__$1 = state_30606;
var statearr_30681_30744 = state_30606__$1;
(statearr_30681_30744[(2)] = null);

(statearr_30681_30744[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (10))){
var inst_30479 = (state_30606[(22)]);
var inst_30481 = cljs.core.chunked_seq_QMARK_.call(null,inst_30479);
var state_30606__$1 = state_30606;
if(inst_30481){
var statearr_30682_30745 = state_30606__$1;
(statearr_30682_30745[(1)] = (13));

} else {
var statearr_30683_30746 = state_30606__$1;
(statearr_30683_30746[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (18))){
var inst_30513 = (state_30606[(2)]);
var state_30606__$1 = state_30606;
if(cljs.core.truth_(inst_30513)){
var statearr_30684_30747 = state_30606__$1;
(statearr_30684_30747[(1)] = (19));

} else {
var statearr_30685_30748 = state_30606__$1;
(statearr_30685_30748[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (42))){
var state_30606__$1 = state_30606;
var statearr_30686_30749 = state_30606__$1;
(statearr_30686_30749[(2)] = null);

(statearr_30686_30749[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (37))){
var inst_30572 = (state_30606[(2)]);
var state_30606__$1 = state_30606;
var statearr_30687_30750 = state_30606__$1;
(statearr_30687_30750[(2)] = inst_30572);

(statearr_30687_30750[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30607 === (8))){
var inst_30479 = (state_30606[(22)]);
var inst_30466 = (state_30606[(8)]);
var inst_30479__$1 = cljs.core.seq.call(null,inst_30466);
var state_30606__$1 = (function (){var statearr_30688 = state_30606;
(statearr_30688[(22)] = inst_30479__$1);

return statearr_30688;
})();
if(inst_30479__$1){
var statearr_30689_30751 = state_30606__$1;
(statearr_30689_30751[(1)] = (10));

} else {
var statearr_30690_30752 = state_30606__$1;
(statearr_30690_30752[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25572__auto__,map__30451,map__30451__$1,opts,before_jsload,on_jsload,reload_dependents,map__30452,map__30452__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__25405__auto__,c__25572__auto__,map__30451,map__30451__$1,opts,before_jsload,on_jsload,reload_dependents,map__30452,map__30452__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__25406__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__25406__auto____0 = (function (){
var statearr_30691 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30691[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__25406__auto__);

(statearr_30691[(1)] = (1));

return statearr_30691;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__25406__auto____1 = (function (state_30606){
while(true){
var ret_value__25407__auto__ = (function (){try{while(true){
var result__25408__auto__ = switch__25405__auto__.call(null,state_30606);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25408__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25408__auto__;
}
break;
}
}catch (e30692){if((e30692 instanceof Object)){
var ex__25409__auto__ = e30692;
var statearr_30693_30753 = state_30606;
(statearr_30693_30753[(5)] = ex__25409__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30606);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30692;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25407__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30754 = state_30606;
state_30606 = G__30754;
continue;
} else {
return ret_value__25407__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__25406__auto__ = function(state_30606){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__25406__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__25406__auto____1.call(this,state_30606);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__25406__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__25406__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__25406__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__25406__auto__;
})()
;})(switch__25405__auto__,c__25572__auto__,map__30451,map__30451__$1,opts,before_jsload,on_jsload,reload_dependents,map__30452,map__30452__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__25574__auto__ = (function (){var statearr_30694 = f__25573__auto__.call(null);
(statearr_30694[(6)] = c__25572__auto__);

return statearr_30694;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25574__auto__);
});})(c__25572__auto__,map__30451,map__30451__$1,opts,before_jsload,on_jsload,reload_dependents,map__30452,map__30452__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__25572__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),"//"].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__30757,link){
var map__30758 = p__30757;
var map__30758__$1 = (((((!((map__30758 == null))))?(((((map__30758.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30758.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30758):map__30758);
var file = cljs.core.get.call(null,map__30758__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__5457__auto__ = link.href;
if(cljs.core.truth_(temp__5457__auto__)){
var link_href = temp__5457__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__5457__auto__,map__30758,map__30758__$1,file){
return (function (p1__30755_SHARP_,p2__30756_SHARP_){
if(cljs.core._EQ_.call(null,p1__30755_SHARP_,p2__30756_SHARP_)){
return p1__30755_SHARP_;
} else {
return false;
}
});})(link_href,temp__5457__auto__,map__30758,map__30758__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__5457__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__30761){
var map__30762 = p__30761;
var map__30762__$1 = (((((!((map__30762 == null))))?(((((map__30762.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30762.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30762):map__30762);
var match_length = cljs.core.get.call(null,map__30762__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__30762__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__30760_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__30760_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__5457__auto__)){
var res = temp__5457__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__30764_SHARP_,p2__30765_SHARP_){
return cljs.core.assoc.call(null,p1__30764_SHARP_,cljs.core.get.call(null,p2__30765_SHARP_,key),p2__30765_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined')){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__5455__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__5455__auto__)){
var link = temp__5455__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__5455__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
});})(link,temp__5455__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_30766 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_30766);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_30766);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__30767,p__30768){
var map__30769 = p__30767;
var map__30769__$1 = (((((!((map__30769 == null))))?(((((map__30769.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30769.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30769):map__30769);
var on_cssload = cljs.core.get.call(null,map__30769__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__30770 = p__30768;
var map__30770__$1 = (((((!((map__30770 == null))))?(((((map__30770.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30770.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30770):map__30770);
var files_msg = map__30770__$1;
var files = cljs.core.get.call(null,map__30770__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(figwheel.client.utils.html_env_QMARK_.call(null)){
var temp__5457__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__5457__auto__)){
var f_datas = temp__5457__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1552158900601
