// Compiled by ClojureScript 1.10.439 {}
goog.provide('threeagent.scene');
goog.require('cljs.core');
goog.require('threeagent.virtual_scene');
goog.require('threeagent.util');
goog.require('threeagent.threejs');
goog.require('threeagent.component');
goog.require('cljs.core');
threeagent.scene.create_object = (function threeagent$scene$create_object(node_data){
var comp_config = new cljs.core.Keyword(null,"component-config","component-config",2000790546).cljs$core$IFn$_invoke$arity$1(node_data);
var obj = threeagent.component.render_component.call(null,new cljs.core.Keyword(null,"component-key","component-key",1189239034).cljs$core$IFn$_invoke$arity$1(node_data),comp_config);
threeagent.threejs.set_position_BANG_.call(null,obj,new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$1(node_data));

threeagent.threejs.set_rotation_BANG_.call(null,obj,new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$1(node_data));

threeagent.threejs.set_scale_BANG_.call(null,obj,new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$1(node_data));

return obj;
});
threeagent.scene.set_node_object = (function threeagent$scene$set_node_object(context,node,node_data,obj){
threeagent.util.$_BANG_.call(null,node,"threejs",obj);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"camera","camera",-1190348585),new cljs.core.Keyword(null,"component-key","component-key",1189239034).cljs$core$IFn$_invoke$arity$1(node_data))){
return threeagent.util.$_BANG_.call(null,context,"camera",obj);
} else {
return null;
}
});
threeagent.scene.add_node = (function threeagent$scene$add_node(context,parent_object,node){
var node_data = threeagent.util.$.call(null,node,"data");
var comp_config = new cljs.core.Keyword(null,"component-config","component-config",2000790546).cljs$core$IFn$_invoke$arity$1(node_data);
var obj = threeagent.scene.create_object.call(null,node_data);
threeagent.scene.set_node_object.call(null,context,node,node_data,obj);

parent_object.add(obj);

node.for_each_child(cljs.core.partial.call(null,threeagent.scene.add_node,context,obj));

var temp__5457__auto___35746 = new cljs.core.Keyword(null,"on-added","on-added",-54041858).cljs$core$IFn$_invoke$arity$1(threeagent.util.$.call(null,node,"meta"));
if(cljs.core.truth_(temp__5457__auto___35746)){
var callback_35747 = temp__5457__auto___35746;
callback_35747.call(null,obj);
} else {
}

return obj;
});
threeagent.scene.remove_node_BANG_ = (function threeagent$scene$remove_node_BANG_(node){
var obj = threeagent.util.$.call(null,node,"threejs");
var parent_obj = threeagent.util.$.call(null,threeagent.util.$.call(null,node,"parent"),"threejs");
var temp__5457__auto___35748 = new cljs.core.Keyword(null,"on-removed","on-removed",-1308728142).cljs$core$IFn$_invoke$arity$1(threeagent.util.$.call(null,node,"meta"));
if(cljs.core.truth_(temp__5457__auto___35748)){
var callback_35749 = temp__5457__auto___35748;
callback_35749.call(null,obj);
} else {
}

parent_obj.remove(obj);

return node.for_each_child(threeagent.scene.remove_node_BANG_);
});
threeagent.scene.init_scene = (function threeagent$scene$init_scene(context,virtual_scene,scene_root){
return threeagent.scene.add_node.call(null,context,scene_root,threeagent.util.$.call(null,virtual_scene,"root"));
});
threeagent.scene.diff_data = (function threeagent$scene$diff_data(o,n){
var this$ = ((((cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"component-config","component-config",2000790546).cljs$core$IFn$_invoke$arity$1(o),new cljs.core.Keyword(null,"component-config","component-config",2000790546).cljs$core$IFn$_invoke$arity$1(n))) || (cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"component-key","component-key",1189239034).cljs$core$IFn$_invoke$arity$1(o),new cljs.core.Keyword(null,"component-key","component-key",1189239034).cljs$core$IFn$_invoke$arity$1(n)))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [o,n], null):null);
var position = ((cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$1(o),new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$1(n)))?new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$1(n):null);
var rotation = ((cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$1(o),new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$1(n)))?new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$1(n):null);
var scale = ((cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$1(o),new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$1(n)))?new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$1(n):null);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"this","this",-611633625),this$,new cljs.core.Keyword(null,"scale","scale",-230427353),scale,new cljs.core.Keyword(null,"position","position",-2011731912),position,new cljs.core.Keyword(null,"rotation","rotation",-1728051644),rotation], null);
});
threeagent.scene.update_node_BANG_ = (function threeagent$scene$update_node_BANG_(context,node,old_data,new_data){
var diff = threeagent.scene.diff_data.call(null,old_data,new_data);
var old_obj = threeagent.util.$.call(null,node,"threejs");
var metadata = threeagent.util.$.call(null,node,"meta");
var this$ = new cljs.core.Keyword(null,"this","this",-611633625).cljs$core$IFn$_invoke$arity$1(diff);
if(cljs.core.truth_(this$)){
var vec__35750 = this$;
var o = cljs.core.nth.call(null,vec__35750,(0),null);
var n = cljs.core.nth.call(null,vec__35750,(1),null);
var parent_obj = threeagent.util.$.call(null,old_obj,"parent");
var children = threeagent.util.$.call(null,old_obj,"children");
var new_obj = threeagent.scene.create_object.call(null,new_data);
var temp__5457__auto___35757 = new cljs.core.Keyword(null,"on-removed","on-removed",-1308728142).cljs$core$IFn$_invoke$arity$1(metadata);
if(cljs.core.truth_(temp__5457__auto___35757)){
var callback_35758 = temp__5457__auto___35757;
callback_35758.call(null,old_obj);
} else {
}

threeagent.scene.set_node_object.call(null,context,node,new_data,new_obj);

parent_obj.remove(old_obj);

parent_obj.add(new_obj);

var seq__35753_35759 = cljs.core.seq.call(null,children);
var chunk__35754_35760 = null;
var count__35755_35761 = (0);
var i__35756_35762 = (0);
while(true){
if((i__35756_35762 < count__35755_35761)){
var child_35763 = cljs.core._nth.call(null,chunk__35754_35760,i__35756_35762);
new_obj.add(child_35763);


var G__35764 = seq__35753_35759;
var G__35765 = chunk__35754_35760;
var G__35766 = count__35755_35761;
var G__35767 = (i__35756_35762 + (1));
seq__35753_35759 = G__35764;
chunk__35754_35760 = G__35765;
count__35755_35761 = G__35766;
i__35756_35762 = G__35767;
continue;
} else {
var temp__5457__auto___35768 = cljs.core.seq.call(null,seq__35753_35759);
if(temp__5457__auto___35768){
var seq__35753_35769__$1 = temp__5457__auto___35768;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35753_35769__$1)){
var c__4461__auto___35770 = cljs.core.chunk_first.call(null,seq__35753_35769__$1);
var G__35771 = cljs.core.chunk_rest.call(null,seq__35753_35769__$1);
var G__35772 = c__4461__auto___35770;
var G__35773 = cljs.core.count.call(null,c__4461__auto___35770);
var G__35774 = (0);
seq__35753_35759 = G__35771;
chunk__35754_35760 = G__35772;
count__35755_35761 = G__35773;
i__35756_35762 = G__35774;
continue;
} else {
var child_35775 = cljs.core.first.call(null,seq__35753_35769__$1);
new_obj.add(child_35775);


var G__35776 = cljs.core.next.call(null,seq__35753_35769__$1);
var G__35777 = null;
var G__35778 = (0);
var G__35779 = (0);
seq__35753_35759 = G__35776;
chunk__35754_35760 = G__35777;
count__35755_35761 = G__35778;
i__35756_35762 = G__35779;
continue;
}
} else {
}
}
break;
}

var temp__5457__auto__ = new cljs.core.Keyword(null,"on-added","on-added",-54041858).cljs$core$IFn$_invoke$arity$1(metadata);
if(cljs.core.truth_(temp__5457__auto__)){
var callback = temp__5457__auto__;
return callback.call(null,new_obj);
} else {
return null;
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$1(diff))){
threeagent.threejs.set_position_BANG_.call(null,old_obj,new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$1(diff));
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$1(diff))){
threeagent.threejs.set_rotation_BANG_.call(null,old_obj,new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$1(diff));
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$1(diff))){
return threeagent.threejs.set_scale_BANG_.call(null,old_obj,new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$1(diff));
} else {
return null;
}
}
});
threeagent.scene.apply_change_BANG_ = (function threeagent$scene$apply_change_BANG_(context,p__35780){
var vec__35781 = p__35780;
var node = cljs.core.nth.call(null,vec__35781,(0),null);
var action = cljs.core.nth.call(null,vec__35781,(1),null);
var old = cljs.core.nth.call(null,vec__35781,(2),null);
var new$ = cljs.core.nth.call(null,vec__35781,(3),null);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"add","add",235287739),action)){
return threeagent.scene.add_node.call(null,context,threeagent.util.$.call(null,threeagent.util.$.call(null,node,"parent"),"threejs"),node);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"remove","remove",-131428414),action)){
return threeagent.scene.remove_node_BANG_.call(null,node);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"update","update",1045576396),action)){
return threeagent.scene.update_node_BANG_.call(null,context,node,old,new$);
} else {
return null;
}
}
}
});
threeagent.scene.apply_virtual_scene_changes_BANG_ = (function threeagent$scene$apply_virtual_scene_changes_BANG_(context,changelog){
var seq__35784 = cljs.core.seq.call(null,changelog);
var chunk__35785 = null;
var count__35786 = (0);
var i__35787 = (0);
while(true){
if((i__35787 < count__35786)){
var change = cljs.core._nth.call(null,chunk__35785,i__35787);
threeagent.scene.apply_change_BANG_.call(null,context,change);


var G__35788 = seq__35784;
var G__35789 = chunk__35785;
var G__35790 = count__35786;
var G__35791 = (i__35787 + (1));
seq__35784 = G__35788;
chunk__35785 = G__35789;
count__35786 = G__35790;
i__35787 = G__35791;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__35784);
if(temp__5457__auto__){
var seq__35784__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35784__$1)){
var c__4461__auto__ = cljs.core.chunk_first.call(null,seq__35784__$1);
var G__35792 = cljs.core.chunk_rest.call(null,seq__35784__$1);
var G__35793 = c__4461__auto__;
var G__35794 = cljs.core.count.call(null,c__4461__auto__);
var G__35795 = (0);
seq__35784 = G__35792;
chunk__35785 = G__35793;
count__35786 = G__35794;
i__35787 = G__35795;
continue;
} else {
var change = cljs.core.first.call(null,seq__35784__$1);
threeagent.scene.apply_change_BANG_.call(null,context,change);


var G__35796 = cljs.core.next.call(null,seq__35784__$1);
var G__35797 = null;
var G__35798 = (0);
var G__35799 = (0);
seq__35784 = G__35796;
chunk__35785 = G__35797;
count__35786 = G__35798;
i__35787 = G__35799;
continue;
}
} else {
return null;
}
}
break;
}
});
threeagent.scene.animate = (function threeagent$scene$animate(context){
var stats = threeagent.util.$.call(null,context,"stats");
var clock = threeagent.util.$.call(null,context,"clock");
var virtual_scene = threeagent.util.$.call(null,context,"virtual-scene");
var renderer = threeagent.util.$.call(null,context,"renderer");
var composer = threeagent.util.$.call(null,context,"composer");
var camera = threeagent.util.$.call(null,context,"camera");
var scene_root = threeagent.util.$.call(null,context,"scene-root");
var before_render_cb = threeagent.util.$.call(null,context,"before-render-cb");
if(cljs.core.truth_(stats)){
stats.begin();
} else {
}

var delta_time_35800 = clock.getDelta();
var changelog_35801 = [];
if(cljs.core.truth_(before_render_cb)){
before_render_cb.call(null,delta_time_35800);
} else {
}

threeagent.virtual_scene.render_BANG_.call(null,virtual_scene,changelog_35801);

threeagent.scene.apply_virtual_scene_changes_BANG_.call(null,context,changelog_35801);

if(cljs.core.truth_(composer)){
composer.render(delta_time_35800);
} else {
renderer.render(scene_root,camera);
}

if(cljs.core.truth_(stats)){
return stats.end();
} else {
return null;
}
});
threeagent.scene.create_context = (function threeagent$scene$create_context(root_fn,dom_root,on_before_render_cb){
var virtual_scene = threeagent.virtual_scene.create.call(null,root_fn);
var renderer = (new THREE.WebGLRenderer());
var camera = (new THREE.PerspectiveCamera((75),(window.innerWidth / window.innerHeight),0.1,(1000)));
var scene_root = (new THREE.Scene());
var composer = (((typeof POSTPROCESSING !== 'undefined'))?(new POSTPROCESSING.EffectComposer(renderer)):null);
var render_pass = (((typeof POSTPROCESSING !== 'undefined'))?(new POSTPROCESSING.RenderPass(scene_root,camera)):null);
renderer.setSize(window.innerWidth,window.innerHeight);

if(cljs.core.truth_(composer)){
threeagent.util.$_BANG_.call(null,render_pass,"renderToScreen",true);

composer.addPass(render_pass);
} else {
}

dom_root.appendChild(renderer.domElement);

var context = cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"scene-root","scene-root",-2114916885),scene_root,new cljs.core.Keyword(null,"camera","camera",-1190348585),camera,new cljs.core.Keyword(null,"before-render-cb","before-render-cb",229389916),on_before_render_cb,new cljs.core.Keyword(null,"stats","stats",-85643011),(((typeof Stats !== 'undefined'))?(new Stats()):null),new cljs.core.Keyword(null,"clock","clock",-894301127),(new THREE.Clock()),new cljs.core.Keyword(null,"renderer","renderer",336841071),renderer,new cljs.core.Keyword(null,"composer","composer",-1616081356),composer,new cljs.core.Keyword(null,"virtual-scene","virtual-scene",43369577),virtual_scene], null));
threeagent.scene.init_scene.call(null,context,virtual_scene,scene_root);

if(cljs.core.truth_(context.stats)){
context.stats.showPanel((1));

document.body.appendChild(context.stats.dom);
} else {
}

threeagent.util.$_BANG_.call(null,context,"animate-fn",((function (context,virtual_scene,renderer,camera,scene_root,composer,render_pass){
return (function (){
return threeagent.scene.animate.call(null,context);
});})(context,virtual_scene,renderer,camera,scene_root,composer,render_pass))
);

return context;
});
threeagent.scene.remove_all_children_BANG_ = (function threeagent$scene$remove_all_children_BANG_(obj){
var seq__35802 = cljs.core.seq.call(null,threeagent.util.$.call(null,obj,"children"));
var chunk__35803 = null;
var count__35804 = (0);
var i__35805 = (0);
while(true){
if((i__35805 < count__35804)){
var child = cljs.core._nth.call(null,chunk__35803,i__35805);
obj.remove(child);


var G__35806 = seq__35802;
var G__35807 = chunk__35803;
var G__35808 = count__35804;
var G__35809 = (i__35805 + (1));
seq__35802 = G__35806;
chunk__35803 = G__35807;
count__35804 = G__35808;
i__35805 = G__35809;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__35802);
if(temp__5457__auto__){
var seq__35802__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35802__$1)){
var c__4461__auto__ = cljs.core.chunk_first.call(null,seq__35802__$1);
var G__35810 = cljs.core.chunk_rest.call(null,seq__35802__$1);
var G__35811 = c__4461__auto__;
var G__35812 = cljs.core.count.call(null,c__4461__auto__);
var G__35813 = (0);
seq__35802 = G__35810;
chunk__35803 = G__35811;
count__35804 = G__35812;
i__35805 = G__35813;
continue;
} else {
var child = cljs.core.first.call(null,seq__35802__$1);
obj.remove(child);


var G__35814 = cljs.core.next.call(null,seq__35802__$1);
var G__35815 = null;
var G__35816 = (0);
var G__35817 = (0);
seq__35802 = G__35814;
chunk__35803 = G__35815;
count__35804 = G__35816;
i__35805 = G__35817;
continue;
}
} else {
return null;
}
}
break;
}
});
threeagent.scene.reset_scene_BANG_ = (function threeagent$scene$reset_scene_BANG_(scene,root_fn,p__35818){
var map__35819 = p__35818;
var map__35819__$1 = (((((!((map__35819 == null))))?(((((map__35819.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35819.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35819):map__35819);
var on_before_render = cljs.core.get.call(null,map__35819__$1,new cljs.core.Keyword(null,"on-before-render","on-before-render",601463713));
var root = threeagent.util.$.call(null,scene,"scene-root");
var virtual_scene = threeagent.util.$.call(null,scene,"virtual-scene");
var new_virtual_scene = threeagent.virtual_scene.create.call(null,root_fn);
threeagent.scene.remove_all_children_BANG_.call(null,root);

threeagent.virtual_scene.destroy_BANG_.call(null,virtual_scene);

threeagent.scene.init_scene.call(null,scene,new_virtual_scene,root);

threeagent.util.$_BANG_.call(null,scene,"virtual-scene",new_virtual_scene);

threeagent.util.$_BANG_.call(null,scene,"before-render-cb",on_before_render);

return scene;
});
threeagent.scene.render = (function threeagent$scene$render(root_fn,dom_root,p__35821){
var map__35822 = p__35821;
var map__35822__$1 = (((((!((map__35822 == null))))?(((((map__35822.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35822.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35822):map__35822);
var on_before_render = cljs.core.get.call(null,map__35822__$1,new cljs.core.Keyword(null,"on-before-render","on-before-render",601463713));
var context = threeagent.scene.create_context.call(null,root_fn,dom_root,on_before_render);
var renderer = threeagent.util.$.call(null,context,"renderer");
renderer.setAnimationLoop(threeagent.util.$.call(null,context,"animate-fn"));

return context;
});

//# sourceMappingURL=scene.js.map?rel=1547411152379
