// Compiled by ClojureScript 1.10.439 {}
goog.provide('threeagent.virtual_scene');
goog.require('cljs.core');
goog.require('threeagent.util');
goog.require('medley.core');
goog.require('reagent.ratom');
goog.require('goog.structs.PriorityQueue');
if((typeof threeagent !== 'undefined') && (typeof threeagent.virtual_scene !== 'undefined') && (typeof threeagent.virtual_scene.non_component_keys !== 'undefined')){
} else {
threeagent.virtual_scene.non_component_keys = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"rotation","rotation",-1728051644),null,new cljs.core.Keyword(null,"scale","scale",-230427353),null,new cljs.core.Keyword(null,"position","position",-2011731912),null], null), null);
}
threeagent.virtual_scene.print_tree = (function threeagent$virtual_scene$print_tree(var_args){
var G__34686 = arguments.length;
switch (G__34686) {
case 1:
return threeagent.virtual_scene.print_tree.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return threeagent.virtual_scene.print_tree.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

threeagent.virtual_scene.print_tree.cljs$core$IFn$_invoke$arity$1 = (function (node){
return threeagent.virtual_scene.print_tree.call(null,node,"");
});

threeagent.virtual_scene.print_tree.cljs$core$IFn$_invoke$arity$2 = (function (node,p){
var is_reactive = (!((threeagent.util.$.call(null,node,"reaction") == null)));
cljs.core.println.call(null,p,"|-",threeagent.util.$.call(null,node,"key"),["dirty:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(threeagent.util.$.call(null,node,"dirty"))].join(''),["reactive:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(is_reactive)].join(''),threeagent.util.$.call(null,node,"render"));

var seq__34687 = cljs.core.seq.call(null,cljs.core.es6_iterator_seq.call(null,threeagent.util.$.call(null,node,"children").values()));
var chunk__34688 = null;
var count__34689 = (0);
var i__34690 = (0);
while(true){
if((i__34690 < count__34689)){
var child = cljs.core._nth.call(null,chunk__34688,i__34690);
threeagent.virtual_scene.print_tree.call(null,child,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p),"\t"].join(''));


var G__34692 = seq__34687;
var G__34693 = chunk__34688;
var G__34694 = count__34689;
var G__34695 = (i__34690 + (1));
seq__34687 = G__34692;
chunk__34688 = G__34693;
count__34689 = G__34694;
i__34690 = G__34695;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__34687);
if(temp__5457__auto__){
var seq__34687__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34687__$1)){
var c__4461__auto__ = cljs.core.chunk_first.call(null,seq__34687__$1);
var G__34696 = cljs.core.chunk_rest.call(null,seq__34687__$1);
var G__34697 = c__4461__auto__;
var G__34698 = cljs.core.count.call(null,c__4461__auto__);
var G__34699 = (0);
seq__34687 = G__34696;
chunk__34688 = G__34697;
count__34689 = G__34698;
i__34690 = G__34699;
continue;
} else {
var child = cljs.core.first.call(null,seq__34687__$1);
threeagent.virtual_scene.print_tree.call(null,child,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p),"\t"].join(''));


var G__34700 = cljs.core.next.call(null,seq__34687__$1);
var G__34701 = null;
var G__34702 = (0);
var G__34703 = (0);
seq__34687 = G__34700;
chunk__34688 = G__34701;
count__34689 = G__34702;
i__34690 = G__34703;
continue;
}
} else {
return null;
}
}
break;
}
});

threeagent.virtual_scene.print_tree.cljs$lang$maxFixedArity = 2;

threeagent.virtual_scene.node__GT_path = (function threeagent$virtual_scene$node__GT_path(var_args){
var G__34705 = arguments.length;
switch (G__34705) {
case 1:
return threeagent.virtual_scene.node__GT_path.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return threeagent.virtual_scene.node__GT_path.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

threeagent.virtual_scene.node__GT_path.cljs$core$IFn$_invoke$arity$1 = (function (node){
return threeagent.virtual_scene.node__GT_path.call(null,cljs.core.PersistentVector.EMPTY,node);
});

threeagent.virtual_scene.node__GT_path.cljs$core$IFn$_invoke$arity$2 = (function (path,node){
while(true){
if(cljs.core.truth_(node)){
var G__34707 = cljs.core.conj.call(null,path,threeagent.util.$.call(null,node,"key"));
var G__34708 = threeagent.util.$.call(null,node,"parent");
path = G__34707;
node = G__34708;
continue;
} else {
return cljs.core.reverse.call(null,path);
}
break;
}
});

threeagent.virtual_scene.node__GT_path.cljs$lang$maxFixedArity = 2;

threeagent.virtual_scene.get_in_node = (function threeagent$virtual_scene$get_in_node(node,path){
while(true){
if(cljs.core.empty_QMARK_.call(null,path)){
return node;
} else {
var G__34709 = threeagent.util.$.call(null,node,"children").get(cljs.core.first.call(null,path));
var G__34710 = cljs.core.rest.call(null,path);
node = G__34709;
path = G__34710;
continue;
}
break;
}
});
threeagent.virtual_scene.get_key = (function threeagent$virtual_scene$get_key(key,meta){
new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(meta);

return key;
});

/**
* @constructor
 * @implements {threeagent.virtual_scene.Object}
*/
threeagent.virtual_scene.Node = (function (parent,depth,key,meta,data,dirty,render,reaction,children){
this.parent = parent;
this.depth = depth;
this.key = key;
this.meta = meta;
this.data = data;
this.dirty = dirty;
this.render = render;
this.reaction = reaction;
this.children = children;
});
threeagent.virtual_scene.Node.prototype.for_each_child = (function (f){
var self__ = this;
var this$ = this;
var seq__34711 = cljs.core.seq.call(null,cljs.core.es6_iterator_seq.call(null,self__.children.values()));
var chunk__34712 = null;
var count__34713 = (0);
var i__34714 = (0);
while(true){
if((i__34714 < count__34713)){
var child = cljs.core._nth.call(null,chunk__34712,i__34714);
f.call(null,child);


var G__34715 = seq__34711;
var G__34716 = chunk__34712;
var G__34717 = count__34713;
var G__34718 = (i__34714 + (1));
seq__34711 = G__34715;
chunk__34712 = G__34716;
count__34713 = G__34717;
i__34714 = G__34718;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__34711);
if(temp__5457__auto__){
var seq__34711__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34711__$1)){
var c__4461__auto__ = cljs.core.chunk_first.call(null,seq__34711__$1);
var G__34719 = cljs.core.chunk_rest.call(null,seq__34711__$1);
var G__34720 = c__4461__auto__;
var G__34721 = cljs.core.count.call(null,c__4461__auto__);
var G__34722 = (0);
seq__34711 = G__34719;
chunk__34712 = G__34720;
count__34713 = G__34721;
i__34714 = G__34722;
continue;
} else {
var child = cljs.core.first.call(null,seq__34711__$1);
f.call(null,child);


var G__34723 = cljs.core.next.call(null,seq__34711__$1);
var G__34724 = null;
var G__34725 = (0);
var G__34726 = (0);
seq__34711 = G__34723;
chunk__34712 = G__34724;
count__34713 = G__34725;
i__34714 = G__34726;
continue;
}
} else {
return null;
}
}
break;
}
});

threeagent.virtual_scene.Node.getBasis = (function (){
return new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"parent","parent",761652748,null),new cljs.core.Symbol(null,"depth","depth",-885772129,null),new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.Symbol(null,"dirty","dirty",-1924882488,null),new cljs.core.Symbol(null,"render","render",232498073,null),new cljs.core.Symbol(null,"reaction","reaction",2131401315,null),new cljs.core.Symbol(null,"children","children",699969545,null)], null);
});

threeagent.virtual_scene.Node.cljs$lang$type = true;

threeagent.virtual_scene.Node.cljs$lang$ctorStr = "threeagent.virtual-scene/Node";

threeagent.virtual_scene.Node.cljs$lang$ctorPrWriter = (function (this__4290__auto__,writer__4291__auto__,opt__4292__auto__){
return cljs.core._write.call(null,writer__4291__auto__,"threeagent.virtual-scene/Node");
});

/**
 * Positional factory function for threeagent.virtual-scene/Node.
 */
threeagent.virtual_scene.__GT_Node = (function threeagent$virtual_scene$__GT_Node(parent,depth,key,meta,data,dirty,render,reaction,children){
return (new threeagent.virtual_scene.Node(parent,depth,key,meta,data,dirty,render,reaction,children));
});


/**
* @constructor
 * @implements {threeagent.virtual_scene.Object}
*/
threeagent.virtual_scene.Scene = (function (root,render_queue){
this.root = root;
this.render_queue = render_queue;
});
threeagent.virtual_scene.Scene.prototype.enqueue_for_render = (function (node){
var self__ = this;
var this$ = this;
threeagent.util.$_BANG_.call(null,node,"dirty",true);

return self__.render_queue.enqueue(threeagent.util.$.call(null,node,"depth"),node);
});

threeagent.virtual_scene.Scene.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.Symbol(null,"render-queue","render-queue",-1084920245,null)], null);
});

threeagent.virtual_scene.Scene.cljs$lang$type = true;

threeagent.virtual_scene.Scene.cljs$lang$ctorStr = "threeagent.virtual-scene/Scene";

threeagent.virtual_scene.Scene.cljs$lang$ctorPrWriter = (function (this__4290__auto__,writer__4291__auto__,opt__4292__auto__){
return cljs.core._write.call(null,writer__4291__auto__,"threeagent.virtual-scene/Scene");
});

/**
 * Positional factory function for threeagent.virtual-scene/Scene.
 */
threeagent.virtual_scene.__GT_Scene = (function threeagent$virtual_scene$__GT_Scene(root,render_queue){
return (new threeagent.virtual_scene.Scene(root,render_queue));
});

threeagent.virtual_scene.eval_fn = (function threeagent$virtual_scene$eval_fn(f,args){
while(true){
var result = cljs.core.apply.call(null,f,args);
if(cljs.core.fn_QMARK_.call(null,result)){
var G__34727 = result;
var G__34728 = args;
f = G__34727;
args = G__34728;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,result], null);
}
break;
}
});
threeagent.virtual_scene.on_react_BANG_ = (function threeagent$virtual_scene$on_react_BANG_(ctx){
var node = threeagent.util.$.call(null,ctx,"node");
var scene = threeagent.util.$.call(null,ctx,"scene");
return scene.enqueue_for_render(node);
});
threeagent.virtual_scene.extract_comp_config = (function threeagent$virtual_scene$extract_comp_config(config){
var c = cljs.core.transient$.call(null,config);
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,((function (c){
return (function (p1__34729_SHARP_,p2__34730_SHARP_){
return cljs.core.dissoc_BANG_.call(null,p1__34729_SHARP_,p2__34730_SHARP_);
});})(c))
,c,threeagent.virtual_scene.non_component_keys));
});
threeagent.virtual_scene.node_data = (function threeagent$virtual_scene$node_data(comp_key,comp_config){
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"position","position",-2011731912),new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$2(comp_config,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0)], null)),new cljs.core.Keyword(null,"rotation","rotation",-1728051644),new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$2(comp_config,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0)], null)),new cljs.core.Keyword(null,"scale","scale",-230427353),new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$2(comp_config,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [1.0,1.0,1.0], null)),new cljs.core.Keyword(null,"component-key","component-key",1189239034),comp_key,new cljs.core.Keyword(null,"component-config","component-config",2000790546),threeagent.virtual_scene.extract_comp_config.call(null,comp_config)], null);
});
if((typeof threeagent !== 'undefined') && (typeof threeagent.virtual_scene !== 'undefined') && (typeof threeagent.virtual_scene.__GT_node !== 'undefined')){
} else {
threeagent.virtual_scene.__GT_node = (function (){var method_table__4524__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4525__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4526__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4527__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4528__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"threeagent.virtual-scene","->node"),((function (method_table__4524__auto__,prefer_table__4525__auto__,method_cache__4526__auto__,cached_hierarchy__4527__auto__,hierarchy__4528__auto__){
return (function (scene,parent,key,p__34731){
var vec__34732 = p__34731;
var seq__34733 = cljs.core.seq.call(null,vec__34732);
var first__34734 = cljs.core.first.call(null,seq__34733);
var seq__34733__$1 = cljs.core.next.call(null,seq__34733);
var l = first__34734;
var r = seq__34733__$1;
if((l instanceof cljs.core.Keyword)){
return new cljs.core.Keyword(null,"keyword","keyword",811389747);
} else {
if(cljs.core.fn_QMARK_.call(null,l)){
return new cljs.core.Keyword(null,"fn","fn",-1175266204);
} else {
if(cljs.core.sequential_QMARK_.call(null,l)){
return new cljs.core.Keyword(null,"seq","seq",-1817803783);
} else {
if((((l == null)) && ((r == null)))){
return new cljs.core.Keyword(null,"empty-list","empty-list",-1865196089);
} else {
return null;

}
}
}
}
});})(method_table__4524__auto__,prefer_table__4525__auto__,method_cache__4526__auto__,cached_hierarchy__4527__auto__,hierarchy__4528__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4528__auto__,method_table__4524__auto__,prefer_table__4525__auto__,method_cache__4526__auto__,cached_hierarchy__4527__auto__));
})();
}
cljs.core._add_method.call(null,threeagent.virtual_scene.__GT_node,new cljs.core.Keyword(null,"default","default",-1987822328),(function (scene,parent,key,form){
return cljs.core.println.call(null,"Invalid object form:",form);
}));
cljs.core._add_method.call(null,threeagent.virtual_scene.__GT_node,new cljs.core.Keyword(null,"empty-list","empty-list",-1865196089),(function (scene,parent,key,form){
return null;
}));
cljs.core._add_method.call(null,threeagent.virtual_scene.__GT_node,new cljs.core.Keyword(null,"seq","seq",-1817803783),(function (scene,parent,key,form){
return threeagent.virtual_scene.__GT_node.call(null,scene,parent,key,cljs.core.with_meta.call(null,cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"object","object",1474613949)], null),form),cljs.core.meta.call(null,form)));
}));
cljs.core._add_method.call(null,threeagent.virtual_scene.__GT_node,new cljs.core.Keyword(null,"keyword","keyword",811389747),(function (scene,parent,key,form){
var vec__34735 = form;
var seq__34736 = cljs.core.seq.call(null,vec__34735);
var first__34737 = cljs.core.first.call(null,seq__34736);
var seq__34736__$1 = cljs.core.next.call(null,seq__34736);
var comp_key = first__34737;
var rs = seq__34736__$1;
var first_child = cljs.core.first.call(null,rs);
var metadata = cljs.core.meta.call(null,form);
var key__$1 = (function (){var or__4047__auto__ = new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(metadata);
if(cljs.core.truth_(or__4047__auto__)){
return or__4047__auto__;
} else {
return key;
}
})();
var comp_config = ((cljs.core.map_QMARK_.call(null,first_child))?first_child:cljs.core.PersistentArrayMap.EMPTY);
var children = cljs.core.filter.call(null,cljs.core.some_QMARK_,((cljs.core.map_QMARK_.call(null,first_child))?cljs.core.rest.call(null,rs):rs));
var children_map = (new Map());
var data = threeagent.virtual_scene.node_data.call(null,comp_key,comp_config);
var depth = (cljs.core.truth_(parent)?(threeagent.util.$.call(null,parent,"depth") + (1)):(0));
var node = (new threeagent.virtual_scene.Node(parent,depth,key__$1,metadata,data,false,null,null,children_map));
var seq__34738_34748 = cljs.core.seq.call(null,medley.core.indexed.call(null,children));
var chunk__34739_34749 = null;
var count__34740_34750 = (0);
var i__34741_34751 = (0);
while(true){
if((i__34741_34751 < count__34740_34750)){
var vec__34742_34752 = cljs.core._nth.call(null,chunk__34739_34749,i__34741_34751);
var idx_34753 = cljs.core.nth.call(null,vec__34742_34752,(0),null);
var child_34754 = cljs.core.nth.call(null,vec__34742_34752,(1),null);
var temp__5457__auto___34755 = threeagent.virtual_scene.__GT_node.call(null,scene,node,idx_34753,child_34754);
if(cljs.core.truth_(temp__5457__auto___34755)){
var child_node_34756 = temp__5457__auto___34755;
children_map.set(threeagent.util.$.call(null,child_node_34756,"key"),child_node_34756);
} else {
}


var G__34757 = seq__34738_34748;
var G__34758 = chunk__34739_34749;
var G__34759 = count__34740_34750;
var G__34760 = (i__34741_34751 + (1));
seq__34738_34748 = G__34757;
chunk__34739_34749 = G__34758;
count__34740_34750 = G__34759;
i__34741_34751 = G__34760;
continue;
} else {
var temp__5457__auto___34761 = cljs.core.seq.call(null,seq__34738_34748);
if(temp__5457__auto___34761){
var seq__34738_34762__$1 = temp__5457__auto___34761;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34738_34762__$1)){
var c__4461__auto___34763 = cljs.core.chunk_first.call(null,seq__34738_34762__$1);
var G__34764 = cljs.core.chunk_rest.call(null,seq__34738_34762__$1);
var G__34765 = c__4461__auto___34763;
var G__34766 = cljs.core.count.call(null,c__4461__auto___34763);
var G__34767 = (0);
seq__34738_34748 = G__34764;
chunk__34739_34749 = G__34765;
count__34740_34750 = G__34766;
i__34741_34751 = G__34767;
continue;
} else {
var vec__34745_34768 = cljs.core.first.call(null,seq__34738_34762__$1);
var idx_34769 = cljs.core.nth.call(null,vec__34745_34768,(0),null);
var child_34770 = cljs.core.nth.call(null,vec__34745_34768,(1),null);
var temp__5457__auto___34771__$1 = threeagent.virtual_scene.__GT_node.call(null,scene,node,idx_34769,child_34770);
if(cljs.core.truth_(temp__5457__auto___34771__$1)){
var child_node_34772 = temp__5457__auto___34771__$1;
children_map.set(threeagent.util.$.call(null,child_node_34772,"key"),child_node_34772);
} else {
}


var G__34773 = cljs.core.next.call(null,seq__34738_34762__$1);
var G__34774 = null;
var G__34775 = (0);
var G__34776 = (0);
seq__34738_34748 = G__34773;
chunk__34739_34749 = G__34774;
count__34740_34750 = G__34775;
i__34741_34751 = G__34776;
continue;
}
} else {
}
}
break;
}

return node;
}));
cljs.core._add_method.call(null,threeagent.virtual_scene.__GT_node,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (scene,parent,key,form){
var key__$1 = (function (){var or__4047__auto__ = new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,form));
if(cljs.core.truth_(or__4047__auto__)){
return or__4047__auto__;
} else {
return key;
}
})();
var vec__34777 = form;
var seq__34778 = cljs.core.seq.call(null,vec__34777);
var first__34779 = cljs.core.first.call(null,seq__34778);
var seq__34778__$1 = cljs.core.next.call(null,seq__34778);
var f = first__34779;
var args = seq__34778__$1;
var reaction_ctx = cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"node","node",581201198),null,new cljs.core.Keyword(null,"reaction","reaction",490869788),null], null));
var vec__34780 = reagent.ratom.run_in_reaction.call(null,((function (key__$1,vec__34777,seq__34778,first__34779,seq__34778__$1,f,args,reaction_ctx){
return (function (){
return threeagent.virtual_scene.eval_fn.call(null,f,args);
});})(key__$1,vec__34777,seq__34778,first__34779,seq__34778__$1,f,args,reaction_ctx))
,reaction_ctx,"reaction",threeagent.virtual_scene.on_react_BANG_,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"no-cache","no-cache",1588056370),true], null));
var final_fn = cljs.core.nth.call(null,vec__34780,(0),null);
var result = cljs.core.nth.call(null,vec__34780,(1),null);
var node = threeagent.virtual_scene.__GT_node.call(null,scene,parent,key__$1,result);
threeagent.util.$_BANG_.call(null,node,"render",final_fn);

threeagent.util.$_BANG_.call(null,node,"form",form);

threeagent.util.$_BANG_.call(null,node,"rendered-form",result);

var temp__5457__auto___34783 = threeagent.util.$.call(null,reaction_ctx,"reaction");
if(cljs.core.truth_(temp__5457__auto___34783)){
var reaction_34784 = temp__5457__auto___34783;
threeagent.util.$_BANG_.call(null,reaction_ctx,"scene",scene);

threeagent.util.$_BANG_.call(null,reaction_ctx,"node",node);

threeagent.util.$_BANG_.call(null,node,"reaction",reaction_34784);
} else {
}

return node;
}));
if((typeof threeagent !== 'undefined') && (typeof threeagent.virtual_scene !== 'undefined') && (typeof threeagent.virtual_scene.__GT_node_shallow !== 'undefined')){
} else {
threeagent.virtual_scene.__GT_node_shallow = (function (){var method_table__4524__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4525__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4526__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4527__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4528__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"threeagent.virtual-scene","->node-shallow"),((function (method_table__4524__auto__,prefer_table__4525__auto__,method_cache__4526__auto__,cached_hierarchy__4527__auto__,hierarchy__4528__auto__){
return (function (key,p__34785){
var vec__34786 = p__34785;
var seq__34787 = cljs.core.seq.call(null,vec__34786);
var first__34788 = cljs.core.first.call(null,seq__34787);
var seq__34787__$1 = cljs.core.next.call(null,seq__34787);
var l = first__34788;
var r = seq__34787__$1;
if(cljs.core.fn_QMARK_.call(null,l)){
return new cljs.core.Keyword(null,"fn","fn",-1175266204);
} else {
if((l instanceof cljs.core.Keyword)){
return new cljs.core.Keyword(null,"keyword","keyword",811389747);
} else {
if(cljs.core.sequential_QMARK_.call(null,l)){
return new cljs.core.Keyword(null,"seq","seq",-1817803783);
} else {
if((((l == null)) && ((r == null)))){
return new cljs.core.Keyword(null,"empty-list","empty-list",-1865196089);
} else {
return null;

}
}
}
}
});})(method_table__4524__auto__,prefer_table__4525__auto__,method_cache__4526__auto__,cached_hierarchy__4527__auto__,hierarchy__4528__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4528__auto__,method_table__4524__auto__,prefer_table__4525__auto__,method_cache__4526__auto__,cached_hierarchy__4527__auto__));
})();
}
cljs.core._add_method.call(null,threeagent.virtual_scene.__GT_node_shallow,new cljs.core.Keyword(null,"empty-list","empty-list",-1865196089),(function (key,form){
return null;
}));
cljs.core._add_method.call(null,threeagent.virtual_scene.__GT_node_shallow,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (key,form){
return null;
}));
cljs.core._add_method.call(null,threeagent.virtual_scene.__GT_node_shallow,new cljs.core.Keyword(null,"seq","seq",-1817803783),(function (key,form){
if(cljs.core.empty_QMARK_.call(null,form)){
return null;
} else {
var m = cljs.core.meta.call(null,form);
return threeagent.virtual_scene.__GT_node_shallow.call(null,threeagent.virtual_scene.get_key.call(null,key,m),cljs.core.with_meta.call(null,cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"object","object",1474613949)], null),form),m));
}
}));
cljs.core._add_method.call(null,threeagent.virtual_scene.__GT_node_shallow,new cljs.core.Keyword(null,"keyword","keyword",811389747),(function (key,form){
var vec__34792 = form;
var seq__34793 = cljs.core.seq.call(null,vec__34792);
var first__34794 = cljs.core.first.call(null,seq__34793);
var seq__34793__$1 = cljs.core.next.call(null,seq__34793);
var comp_key = first__34794;
var rs = seq__34793__$1;
var first_child = cljs.core.first.call(null,rs);
var comp_config = ((cljs.core.map_QMARK_.call(null,first_child))?first_child:cljs.core.PersistentArrayMap.EMPTY);
var children = cljs.core.filter.call(null,((function (vec__34792,seq__34793,first__34794,seq__34793__$1,comp_key,rs,first_child,comp_config){
return (function (p1__34789_SHARP_){
return (((!((p1__34789_SHARP_ == null)))) && ((!(cljs.core.empty_QMARK_.call(null,p1__34789_SHARP_)))));
});})(vec__34792,seq__34793,first__34794,seq__34793__$1,comp_key,rs,first_child,comp_config))
,((cljs.core.map_QMARK_.call(null,first_child))?cljs.core.rest.call(null,rs):rs));
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"key","key",-1516042587),key,new cljs.core.Keyword(null,"data","data",-232669377),threeagent.virtual_scene.node_data.call(null,comp_key,comp_config),new cljs.core.Keyword(null,"form","form",-1624062471),form,new cljs.core.Keyword(null,"children-keys","children-keys",-1531120807),cljs.core.map_indexed.call(null,((function (vec__34792,seq__34793,first__34794,seq__34793__$1,comp_key,rs,first_child,comp_config,children){
return (function (p1__34791_SHARP_,p2__34790_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var or__4047__auto__ = new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,p2__34790_SHARP_));
if(cljs.core.truth_(or__4047__auto__)){
return or__4047__auto__;
} else {
return p1__34791_SHARP_;
}
})(),p2__34790_SHARP_],null));
});})(vec__34792,seq__34793,first__34794,seq__34793__$1,comp_key,rs,first_child,comp_config,children))
,children)], null);
}));
threeagent.virtual_scene.dispose_node_BANG_ = (function threeagent$virtual_scene$dispose_node_BANG_(node){
threeagent.util.$_BANG_.call(null,node,"disposed",true);

var temp__5457__auto___34795 = threeagent.util.$.call(null,node,"reaction");
if(cljs.core.truth_(temp__5457__auto___34795)){
var reaction_34796 = temp__5457__auto___34795;
reagent.ratom.dispose_BANG_.call(null,reaction_34796);
} else {
}

return node.for_each_child(threeagent.virtual_scene.dispose_node_BANG_);
});
threeagent.virtual_scene.add_node_BANG_ = (function threeagent$virtual_scene$add_node_BANG_(scene,parent_node,key,form,changelog){
var temp__5457__auto__ = threeagent.virtual_scene.__GT_node.call(null,scene,parent_node,key,form);
if(cljs.core.truth_(temp__5457__auto__)){
var node = temp__5457__auto__;
changelog.push(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [node,new cljs.core.Keyword(null,"add","add",235287739),null,threeagent.util.$.call(null,node,"data")], null));

return node;
} else {
return null;
}
});
threeagent.virtual_scene.remove_node_BANG_ = (function threeagent$virtual_scene$remove_node_BANG_(node,changelog){
changelog.push(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [node,new cljs.core.Keyword(null,"remove","remove",-131428414),threeagent.util.$.call(null,node,"data"),null], null));

threeagent.util.$_BANG_.call(null,node,"data",null);

threeagent.util.$_BANG_.call(null,node,"dirty",false);

return threeagent.virtual_scene.dispose_node_BANG_.call(null,node);
});
threeagent.virtual_scene.update_node_BANG_ = (function threeagent$virtual_scene$update_node_BANG_(scene,node,new_form,changelog){
threeagent.util.$_BANG_.call(null,node,"dirty",false);

var render_fn = threeagent.util.$.call(null,node,"render");
var rendered_form = (cljs.core.truth_(render_fn)?cljs.core.apply.call(null,render_fn,cljs.core.rest.call(null,new_form)):new_form);
var old_form = threeagent.util.$.call(null,node,"rendered-form");
if(cljs.core.not_EQ_.call(null,rendered_form,old_form)){
var key = threeagent.util.$.call(null,node,"key");
var children = threeagent.util.$.call(null,node,"children");
var old_data = threeagent.util.$.call(null,node,"data");
var shallow_node = threeagent.virtual_scene.__GT_node_shallow.call(null,key,rendered_form);
var new_data = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(shallow_node);
var current_keys = cljs.core.set.call(null,cljs.core.es6_iterator_seq.call(null,children.keys()));
var new_keys = cljs.core.set.call(null,cljs.core.map.call(null,cljs.core.first,new cljs.core.Keyword(null,"children-keys","children-keys",-1531120807).cljs$core$IFn$_invoke$arity$1(shallow_node)));
var dropped_keys = clojure.set.difference.call(null,current_keys,new_keys);
threeagent.util.$_BANG_.call(null,node,"data",new_data);

if(cljs.core.truth_(render_fn)){
threeagent.util.$_BANG_.call(null,node,"form",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [render_fn], null),cljs.core.rest.call(null,new_form)));
} else {
}

threeagent.util.$_BANG_.call(null,node,"rendered-form",new_form);

changelog.push(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [node,new cljs.core.Keyword(null,"update","update",1045576396),old_data,new_data], null));

var seq__34797_34811 = cljs.core.seq.call(null,dropped_keys);
var chunk__34798_34812 = null;
var count__34799_34813 = (0);
var i__34800_34814 = (0);
while(true){
if((i__34800_34814 < count__34799_34813)){
var child_key_34815 = cljs.core._nth.call(null,chunk__34798_34812,i__34800_34814);
var child_node_34816 = children.get(child_key_34815);
threeagent.virtual_scene.remove_node_BANG_.call(null,child_node_34816,changelog);

children.delete(child_key_34815);


var G__34817 = seq__34797_34811;
var G__34818 = chunk__34798_34812;
var G__34819 = count__34799_34813;
var G__34820 = (i__34800_34814 + (1));
seq__34797_34811 = G__34817;
chunk__34798_34812 = G__34818;
count__34799_34813 = G__34819;
i__34800_34814 = G__34820;
continue;
} else {
var temp__5457__auto___34821 = cljs.core.seq.call(null,seq__34797_34811);
if(temp__5457__auto___34821){
var seq__34797_34822__$1 = temp__5457__auto___34821;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34797_34822__$1)){
var c__4461__auto___34823 = cljs.core.chunk_first.call(null,seq__34797_34822__$1);
var G__34824 = cljs.core.chunk_rest.call(null,seq__34797_34822__$1);
var G__34825 = c__4461__auto___34823;
var G__34826 = cljs.core.count.call(null,c__4461__auto___34823);
var G__34827 = (0);
seq__34797_34811 = G__34824;
chunk__34798_34812 = G__34825;
count__34799_34813 = G__34826;
i__34800_34814 = G__34827;
continue;
} else {
var child_key_34828 = cljs.core.first.call(null,seq__34797_34822__$1);
var child_node_34829 = children.get(child_key_34828);
threeagent.virtual_scene.remove_node_BANG_.call(null,child_node_34829,changelog);

children.delete(child_key_34828);


var G__34830 = cljs.core.next.call(null,seq__34797_34822__$1);
var G__34831 = null;
var G__34832 = (0);
var G__34833 = (0);
seq__34797_34811 = G__34830;
chunk__34798_34812 = G__34831;
count__34799_34813 = G__34832;
i__34800_34814 = G__34833;
continue;
}
} else {
}
}
break;
}

var seq__34801 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"children-keys","children-keys",-1531120807).cljs$core$IFn$_invoke$arity$1(shallow_node));
var chunk__34802 = null;
var count__34803 = (0);
var i__34804 = (0);
while(true){
if((i__34804 < count__34803)){
var vec__34805 = cljs.core._nth.call(null,chunk__34802,i__34804);
var child_key = cljs.core.nth.call(null,vec__34805,(0),null);
var child_form = cljs.core.nth.call(null,vec__34805,(1),null);
var temp__5455__auto___34834 = children.get(child_key);
if(cljs.core.truth_(temp__5455__auto___34834)){
var child_34835 = temp__5455__auto___34834;
threeagent.virtual_scene.update_node_BANG_.call(null,scene,child_34835,child_form,changelog);
} else {
var temp__5457__auto___34836 = threeagent.virtual_scene.add_node_BANG_.call(null,scene,node,child_key,child_form,changelog);
if(cljs.core.truth_(temp__5457__auto___34836)){
var child_node_34837 = temp__5457__auto___34836;
children.set(child_key,child_node_34837);
} else {
}
}


var G__34838 = seq__34801;
var G__34839 = chunk__34802;
var G__34840 = count__34803;
var G__34841 = (i__34804 + (1));
seq__34801 = G__34838;
chunk__34802 = G__34839;
count__34803 = G__34840;
i__34804 = G__34841;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__34801);
if(temp__5457__auto__){
var seq__34801__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34801__$1)){
var c__4461__auto__ = cljs.core.chunk_first.call(null,seq__34801__$1);
var G__34842 = cljs.core.chunk_rest.call(null,seq__34801__$1);
var G__34843 = c__4461__auto__;
var G__34844 = cljs.core.count.call(null,c__4461__auto__);
var G__34845 = (0);
seq__34801 = G__34842;
chunk__34802 = G__34843;
count__34803 = G__34844;
i__34804 = G__34845;
continue;
} else {
var vec__34808 = cljs.core.first.call(null,seq__34801__$1);
var child_key = cljs.core.nth.call(null,vec__34808,(0),null);
var child_form = cljs.core.nth.call(null,vec__34808,(1),null);
var temp__5455__auto___34846 = children.get(child_key);
if(cljs.core.truth_(temp__5455__auto___34846)){
var child_34847 = temp__5455__auto___34846;
threeagent.virtual_scene.update_node_BANG_.call(null,scene,child_34847,child_form,changelog);
} else {
var temp__5457__auto___34848__$1 = threeagent.virtual_scene.add_node_BANG_.call(null,scene,node,child_key,child_form,changelog);
if(cljs.core.truth_(temp__5457__auto___34848__$1)){
var child_node_34849 = temp__5457__auto___34848__$1;
children.set(child_key,child_node_34849);
} else {
}
}


var G__34850 = cljs.core.next.call(null,seq__34801__$1);
var G__34851 = null;
var G__34852 = (0);
var G__34853 = (0);
seq__34801 = G__34850;
chunk__34802 = G__34851;
count__34803 = G__34852;
i__34804 = G__34853;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
threeagent.virtual_scene.render_node_BANG_ = (function threeagent$virtual_scene$render_node_BANG_(scene,node,changelog){
var form = threeagent.util.$.call(null,node,"form");
return threeagent.virtual_scene.update_node_BANG_.call(null,scene,node,form,changelog);
});
threeagent.virtual_scene.render_BANG_ = (function threeagent$virtual_scene$render_BANG_(scene,changelog){
reagent.ratom.flush_BANG_.call(null);

var queue = threeagent.util.$.call(null,scene,"render_queue");
var node = queue.dequeue();
while(true){
if(cljs.core.truth_(node)){
if(cljs.core.truth_(threeagent.util.$.call(null,node,"dirty"))){
threeagent.virtual_scene.render_node_BANG_.call(null,scene,node,changelog);
} else {
}

var G__34854 = queue.dequeue();
node = G__34854;
continue;
} else {
return null;
}
break;
}
});
threeagent.virtual_scene.destroy_BANG_ = (function threeagent$virtual_scene$destroy_BANG_(scene){
return threeagent.virtual_scene.dispose_node_BANG_.call(null,threeagent.util.$.call(null,scene,"root"));
});
threeagent.virtual_scene.create = (function threeagent$virtual_scene$create(root_fn){
var scene = (new threeagent.virtual_scene.Scene(null,(new goog.structs.PriorityQueue())));
var root_node = threeagent.virtual_scene.__GT_node.call(null,scene,null,(0),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [root_fn], null));
threeagent.util.$_BANG_.call(null,scene,"root",root_node);

return scene;
});

//# sourceMappingURL=virtual_scene.js.map?rel=1547410271481
