// Compiled by ClojureScript 1.10.439 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.18";
figwheel.client.js_stringify = (((((typeof JSON !== 'undefined')) && ((!((JSON.stringify == null))))))?(function (x){
return ["#js ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(JSON.stringify(x,null," "))].join('');
}):(function (x){
try{return cljs.core.str.cljs$core$IFn$_invoke$arity$1(x);
}catch (e29979){if((e29979 instanceof Error)){
var e = e29979;
return "Error: Unable to stringify";
} else {
throw e29979;

}
}}));
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var G__29982 = arguments.length;
switch (G__29982) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.mapv.call(null,(function (p1__29980_SHARP_){
if(typeof p1__29980_SHARP_ === 'string'){
return p1__29980_SHARP_;
} else {
return figwheel.client.js_stringify.call(null,p1__29980_SHARP_);
}
}),args)], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__4647__auto__ = [];
var len__4641__auto___29985 = arguments.length;
var i__4642__auto___29986 = (0);
while(true){
if((i__4642__auto___29986 < len__4641__auto___29985)){
args__4647__auto__.push((arguments[i__4642__auto___29986]));

var G__29987 = (i__4642__auto___29986 + (1));
i__4642__auto___29986 = G__29987;
continue;
} else {
}
break;
}

var argseq__4648__auto__ = ((((0) < args__4647__auto__.length))?(new cljs.core.IndexedSeq(args__4647__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__4648__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq29984){
var self__4629__auto__ = this;
return self__4629__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29984));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__4647__auto__ = [];
var len__4641__auto___29989 = arguments.length;
var i__4642__auto___29990 = (0);
while(true){
if((i__4642__auto___29990 < len__4641__auto___29989)){
args__4647__auto__.push((arguments[i__4642__auto___29990]));

var G__29991 = (i__4642__auto___29990 + (1));
i__4642__auto___29990 = G__29991;
continue;
} else {
}
break;
}

var argseq__4648__auto__ = ((((0) < args__4647__auto__.length))?(new cljs.core.IndexedSeq(args__4647__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__4648__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq29988){
var self__4629__auto__ = this;
return self__4629__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29988));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),"Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Figwheel autoloading ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method.
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if(((b === true) || (b === false))){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 * 
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if(((b === true) || (b === false))){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__29992){
var map__29993 = p__29992;
var map__29993__$1 = (((((!((map__29993 == null))))?(((((map__29993.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29993.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__29993):map__29993);
var message = cljs.core.get.call(null,map__29993__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__29993__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)," : ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__4047__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4047__auto__)){
return or__4047__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__4036__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__4036__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__4036__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return ((cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts))));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__26280__auto___30072 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26280__auto___30072,ch){
return (function (){
var f__26281__auto__ = (function (){var switch__26185__auto__ = ((function (c__26280__auto___30072,ch){
return (function (state_30044){
var state_val_30045 = (state_30044[(1)]);
if((state_val_30045 === (7))){
var inst_30040 = (state_30044[(2)]);
var state_30044__$1 = state_30044;
var statearr_30046_30073 = state_30044__$1;
(statearr_30046_30073[(2)] = inst_30040);

(statearr_30046_30073[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30045 === (1))){
var state_30044__$1 = state_30044;
var statearr_30047_30074 = state_30044__$1;
(statearr_30047_30074[(2)] = null);

(statearr_30047_30074[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30045 === (4))){
var inst_29997 = (state_30044[(7)]);
var inst_29997__$1 = (state_30044[(2)]);
var state_30044__$1 = (function (){var statearr_30048 = state_30044;
(statearr_30048[(7)] = inst_29997__$1);

return statearr_30048;
})();
if(cljs.core.truth_(inst_29997__$1)){
var statearr_30049_30075 = state_30044__$1;
(statearr_30049_30075[(1)] = (5));

} else {
var statearr_30050_30076 = state_30044__$1;
(statearr_30050_30076[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30045 === (15))){
var inst_30004 = (state_30044[(8)]);
var inst_30019 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_30004);
var inst_30020 = cljs.core.first.call(null,inst_30019);
var inst_30021 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_30020);
var inst_30022 = ["Figwheel: Not loading code with warnings - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_30021)].join('');
var inst_30023 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_30022);
var state_30044__$1 = state_30044;
var statearr_30051_30077 = state_30044__$1;
(statearr_30051_30077[(2)] = inst_30023);

(statearr_30051_30077[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30045 === (13))){
var inst_30028 = (state_30044[(2)]);
var state_30044__$1 = state_30044;
var statearr_30052_30078 = state_30044__$1;
(statearr_30052_30078[(2)] = inst_30028);

(statearr_30052_30078[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30045 === (6))){
var state_30044__$1 = state_30044;
var statearr_30053_30079 = state_30044__$1;
(statearr_30053_30079[(2)] = null);

(statearr_30053_30079[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30045 === (17))){
var inst_30026 = (state_30044[(2)]);
var state_30044__$1 = state_30044;
var statearr_30054_30080 = state_30044__$1;
(statearr_30054_30080[(2)] = inst_30026);

(statearr_30054_30080[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30045 === (3))){
var inst_30042 = (state_30044[(2)]);
var state_30044__$1 = state_30044;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30044__$1,inst_30042);
} else {
if((state_val_30045 === (12))){
var inst_30003 = (state_30044[(9)]);
var inst_30017 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_30003,opts);
var state_30044__$1 = state_30044;
if(inst_30017){
var statearr_30055_30081 = state_30044__$1;
(statearr_30055_30081[(1)] = (15));

} else {
var statearr_30056_30082 = state_30044__$1;
(statearr_30056_30082[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30045 === (2))){
var state_30044__$1 = state_30044;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30044__$1,(4),ch);
} else {
if((state_val_30045 === (11))){
var inst_30004 = (state_30044[(8)]);
var inst_30009 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30010 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_30004);
var inst_30011 = cljs.core.async.timeout.call(null,(1000));
var inst_30012 = [inst_30010,inst_30011];
var inst_30013 = (new cljs.core.PersistentVector(null,2,(5),inst_30009,inst_30012,null));
var state_30044__$1 = state_30044;
return cljs.core.async.ioc_alts_BANG_.call(null,state_30044__$1,(14),inst_30013);
} else {
if((state_val_30045 === (9))){
var inst_30004 = (state_30044[(8)]);
var inst_30030 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_30031 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_30004);
var inst_30032 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_30031);
var inst_30033 = ["Not loading: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_30032)].join('');
var inst_30034 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_30033);
var state_30044__$1 = (function (){var statearr_30057 = state_30044;
(statearr_30057[(10)] = inst_30030);

return statearr_30057;
})();
var statearr_30058_30083 = state_30044__$1;
(statearr_30058_30083[(2)] = inst_30034);

(statearr_30058_30083[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30045 === (5))){
var inst_29997 = (state_30044[(7)]);
var inst_29999 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_30000 = (new cljs.core.PersistentArrayMap(null,2,inst_29999,null));
var inst_30001 = (new cljs.core.PersistentHashSet(null,inst_30000,null));
var inst_30002 = figwheel.client.focus_msgs.call(null,inst_30001,inst_29997);
var inst_30003 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_30002);
var inst_30004 = cljs.core.first.call(null,inst_30002);
var inst_30005 = figwheel.client.autoload_QMARK_.call(null);
var state_30044__$1 = (function (){var statearr_30059 = state_30044;
(statearr_30059[(8)] = inst_30004);

(statearr_30059[(9)] = inst_30003);

return statearr_30059;
})();
if(cljs.core.truth_(inst_30005)){
var statearr_30060_30084 = state_30044__$1;
(statearr_30060_30084[(1)] = (8));

} else {
var statearr_30061_30085 = state_30044__$1;
(statearr_30061_30085[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30045 === (14))){
var inst_30015 = (state_30044[(2)]);
var state_30044__$1 = state_30044;
var statearr_30062_30086 = state_30044__$1;
(statearr_30062_30086[(2)] = inst_30015);

(statearr_30062_30086[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30045 === (16))){
var state_30044__$1 = state_30044;
var statearr_30063_30087 = state_30044__$1;
(statearr_30063_30087[(2)] = null);

(statearr_30063_30087[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30045 === (10))){
var inst_30036 = (state_30044[(2)]);
var state_30044__$1 = (function (){var statearr_30064 = state_30044;
(statearr_30064[(11)] = inst_30036);

return statearr_30064;
})();
var statearr_30065_30088 = state_30044__$1;
(statearr_30065_30088[(2)] = null);

(statearr_30065_30088[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30045 === (8))){
var inst_30003 = (state_30044[(9)]);
var inst_30007 = figwheel.client.reload_file_state_QMARK_.call(null,inst_30003,opts);
var state_30044__$1 = state_30044;
if(cljs.core.truth_(inst_30007)){
var statearr_30066_30089 = state_30044__$1;
(statearr_30066_30089[(1)] = (11));

} else {
var statearr_30067_30090 = state_30044__$1;
(statearr_30067_30090[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26280__auto___30072,ch))
;
return ((function (switch__26185__auto__,c__26280__auto___30072,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__26186__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__26186__auto____0 = (function (){
var statearr_30068 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30068[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__26186__auto__);

(statearr_30068[(1)] = (1));

return statearr_30068;
});
var figwheel$client$file_reloader_plugin_$_state_machine__26186__auto____1 = (function (state_30044){
while(true){
var ret_value__26187__auto__ = (function (){try{while(true){
var result__26188__auto__ = switch__26185__auto__.call(null,state_30044);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26188__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26188__auto__;
}
break;
}
}catch (e30069){if((e30069 instanceof Object)){
var ex__26189__auto__ = e30069;
var statearr_30070_30091 = state_30044;
(statearr_30070_30091[(5)] = ex__26189__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30044);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30069;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26187__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30092 = state_30044;
state_30044 = G__30092;
continue;
} else {
return ret_value__26187__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__26186__auto__ = function(state_30044){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__26186__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__26186__auto____1.call(this,state_30044);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloader_plugin_$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__26186__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__26186__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__26186__auto__;
})()
;})(switch__26185__auto__,c__26280__auto___30072,ch))
})();
var state__26282__auto__ = (function (){var statearr_30071 = f__26281__auto__.call(null);
(statearr_30071[(6)] = c__26280__auto___30072);

return statearr_30071;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26282__auto__);
});})(c__26280__auto___30072,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__30093_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__30093_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(figwheel.client.utils.node_env_QMARK_.call(null)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_30099 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_30099){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{var sb = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__30095 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__30096 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__30097 = true;
var _STAR_print_fn_STAR__temp_val__30098 = ((function (_STAR_print_newline_STAR__orig_val__30095,_STAR_print_fn_STAR__orig_val__30096,_STAR_print_newline_STAR__temp_val__30097,sb,base_path_30099){
return (function (x){
return sb.append(x);
});})(_STAR_print_newline_STAR__orig_val__30095,_STAR_print_fn_STAR__orig_val__30096,_STAR_print_newline_STAR__temp_val__30097,sb,base_path_30099))
;
cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__30097;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__30098;

try{var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
var result_value__$1 = (((!(typeof result_value === 'string')))?cljs.core.pr_str.call(null,result_value):result_value);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"out","out",-910545517),cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value__$1], null));
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__30096;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__30095;
}}catch (e30094){if((e30094 instanceof Error)){
var e = e30094;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_30099], null));
} else {
var e = e30094;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}});})(base_path_30099))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__30100){
var map__30101 = p__30100;
var map__30101__$1 = (((((!((map__30101 == null))))?(((((map__30101.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30101.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30101):map__30101);
var opts = map__30101__$1;
var build_id = cljs.core.get.call(null,map__30101__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__30101,map__30101__$1,opts,build_id){
return (function (p__30103){
var vec__30104 = p__30103;
var seq__30105 = cljs.core.seq.call(null,vec__30104);
var first__30106 = cljs.core.first.call(null,seq__30105);
var seq__30105__$1 = cljs.core.next.call(null,seq__30105);
var map__30107 = first__30106;
var map__30107__$1 = (((((!((map__30107 == null))))?(((((map__30107.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30107.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30107):map__30107);
var msg = map__30107__$1;
var msg_name = cljs.core.get.call(null,map__30107__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__30105__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__30104,seq__30105,first__30106,seq__30105__$1,map__30107,map__30107__$1,msg,msg_name,_,map__30101,map__30101__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__30104,seq__30105,first__30106,seq__30105__$1,map__30107,map__30107__$1,msg,msg_name,_,map__30101,map__30101__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__30101,map__30101__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__30109){
var vec__30110 = p__30109;
var seq__30111 = cljs.core.seq.call(null,vec__30110);
var first__30112 = cljs.core.first.call(null,seq__30111);
var seq__30111__$1 = cljs.core.next.call(null,seq__30111);
var map__30113 = first__30112;
var map__30113__$1 = (((((!((map__30113 == null))))?(((((map__30113.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30113.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30113):map__30113);
var msg = map__30113__$1;
var msg_name = cljs.core.get.call(null,map__30113__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__30111__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__30115){
var map__30116 = p__30115;
var map__30116__$1 = (((((!((map__30116 == null))))?(((((map__30116.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30116.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30116):map__30116);
var on_compile_warning = cljs.core.get.call(null,map__30116__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__30116__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__30116,map__30116__$1,on_compile_warning,on_compile_fail){
return (function (p__30118){
var vec__30119 = p__30118;
var seq__30120 = cljs.core.seq.call(null,vec__30119);
var first__30121 = cljs.core.first.call(null,seq__30120);
var seq__30120__$1 = cljs.core.next.call(null,seq__30120);
var map__30122 = first__30121;
var map__30122__$1 = (((((!((map__30122 == null))))?(((((map__30122.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30122.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30122):map__30122);
var msg = map__30122__$1;
var msg_name = cljs.core.get.call(null,map__30122__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__30120__$1;
var pred__30124 = cljs.core._EQ_;
var expr__30125 = msg_name;
if(cljs.core.truth_(pred__30124.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__30125))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__30124.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__30125))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__30116,map__30116__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__26280__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26280__auto__,msg_hist,msg_names,msg){
return (function (){
var f__26281__auto__ = (function (){var switch__26185__auto__ = ((function (c__26280__auto__,msg_hist,msg_names,msg){
return (function (state_30214){
var state_val_30215 = (state_30214[(1)]);
if((state_val_30215 === (7))){
var inst_30134 = (state_30214[(2)]);
var state_30214__$1 = state_30214;
if(cljs.core.truth_(inst_30134)){
var statearr_30216_30263 = state_30214__$1;
(statearr_30216_30263[(1)] = (8));

} else {
var statearr_30217_30264 = state_30214__$1;
(statearr_30217_30264[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30215 === (20))){
var inst_30208 = (state_30214[(2)]);
var state_30214__$1 = state_30214;
var statearr_30218_30265 = state_30214__$1;
(statearr_30218_30265[(2)] = inst_30208);

(statearr_30218_30265[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30215 === (27))){
var inst_30204 = (state_30214[(2)]);
var state_30214__$1 = state_30214;
var statearr_30219_30266 = state_30214__$1;
(statearr_30219_30266[(2)] = inst_30204);

(statearr_30219_30266[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30215 === (1))){
var inst_30127 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_30214__$1 = state_30214;
if(cljs.core.truth_(inst_30127)){
var statearr_30220_30267 = state_30214__$1;
(statearr_30220_30267[(1)] = (2));

} else {
var statearr_30221_30268 = state_30214__$1;
(statearr_30221_30268[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30215 === (24))){
var inst_30206 = (state_30214[(2)]);
var state_30214__$1 = state_30214;
var statearr_30222_30269 = state_30214__$1;
(statearr_30222_30269[(2)] = inst_30206);

(statearr_30222_30269[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30215 === (4))){
var inst_30212 = (state_30214[(2)]);
var state_30214__$1 = state_30214;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30214__$1,inst_30212);
} else {
if((state_val_30215 === (15))){
var inst_30210 = (state_30214[(2)]);
var state_30214__$1 = state_30214;
var statearr_30223_30270 = state_30214__$1;
(statearr_30223_30270[(2)] = inst_30210);

(statearr_30223_30270[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30215 === (21))){
var inst_30163 = (state_30214[(2)]);
var inst_30164 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_30165 = figwheel.client.auto_jump_to_error.call(null,opts,inst_30164);
var state_30214__$1 = (function (){var statearr_30224 = state_30214;
(statearr_30224[(7)] = inst_30163);

return statearr_30224;
})();
var statearr_30225_30271 = state_30214__$1;
(statearr_30225_30271[(2)] = inst_30165);

(statearr_30225_30271[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30215 === (31))){
var inst_30193 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_30214__$1 = state_30214;
if(inst_30193){
var statearr_30226_30272 = state_30214__$1;
(statearr_30226_30272[(1)] = (34));

} else {
var statearr_30227_30273 = state_30214__$1;
(statearr_30227_30273[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30215 === (32))){
var inst_30202 = (state_30214[(2)]);
var state_30214__$1 = state_30214;
var statearr_30228_30274 = state_30214__$1;
(statearr_30228_30274[(2)] = inst_30202);

(statearr_30228_30274[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30215 === (33))){
var inst_30189 = (state_30214[(2)]);
var inst_30190 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_30191 = figwheel.client.auto_jump_to_error.call(null,opts,inst_30190);
var state_30214__$1 = (function (){var statearr_30229 = state_30214;
(statearr_30229[(8)] = inst_30189);

return statearr_30229;
})();
var statearr_30230_30275 = state_30214__$1;
(statearr_30230_30275[(2)] = inst_30191);

(statearr_30230_30275[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30215 === (13))){
var inst_30148 = figwheel.client.heads_up.clear.call(null);
var state_30214__$1 = state_30214;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30214__$1,(16),inst_30148);
} else {
if((state_val_30215 === (22))){
var inst_30169 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_30170 = figwheel.client.heads_up.append_warning_message.call(null,inst_30169);
var state_30214__$1 = state_30214;
var statearr_30231_30276 = state_30214__$1;
(statearr_30231_30276[(2)] = inst_30170);

(statearr_30231_30276[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30215 === (36))){
var inst_30200 = (state_30214[(2)]);
var state_30214__$1 = state_30214;
var statearr_30232_30277 = state_30214__$1;
(statearr_30232_30277[(2)] = inst_30200);

(statearr_30232_30277[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30215 === (29))){
var inst_30180 = (state_30214[(2)]);
var inst_30181 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_30182 = figwheel.client.auto_jump_to_error.call(null,opts,inst_30181);
var state_30214__$1 = (function (){var statearr_30233 = state_30214;
(statearr_30233[(9)] = inst_30180);

return statearr_30233;
})();
var statearr_30234_30278 = state_30214__$1;
(statearr_30234_30278[(2)] = inst_30182);

(statearr_30234_30278[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30215 === (6))){
var inst_30129 = (state_30214[(10)]);
var state_30214__$1 = state_30214;
var statearr_30235_30279 = state_30214__$1;
(statearr_30235_30279[(2)] = inst_30129);

(statearr_30235_30279[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30215 === (28))){
var inst_30176 = (state_30214[(2)]);
var inst_30177 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_30178 = figwheel.client.heads_up.display_warning.call(null,inst_30177);
var state_30214__$1 = (function (){var statearr_30236 = state_30214;
(statearr_30236[(11)] = inst_30176);

return statearr_30236;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30214__$1,(29),inst_30178);
} else {
if((state_val_30215 === (25))){
var inst_30174 = figwheel.client.heads_up.clear.call(null);
var state_30214__$1 = state_30214;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30214__$1,(28),inst_30174);
} else {
if((state_val_30215 === (34))){
var inst_30195 = figwheel.client.heads_up.flash_loaded.call(null);
var state_30214__$1 = state_30214;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30214__$1,(37),inst_30195);
} else {
if((state_val_30215 === (17))){
var inst_30154 = (state_30214[(2)]);
var inst_30155 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_30156 = figwheel.client.auto_jump_to_error.call(null,opts,inst_30155);
var state_30214__$1 = (function (){var statearr_30237 = state_30214;
(statearr_30237[(12)] = inst_30154);

return statearr_30237;
})();
var statearr_30238_30280 = state_30214__$1;
(statearr_30238_30280[(2)] = inst_30156);

(statearr_30238_30280[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30215 === (3))){
var inst_30146 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_30214__$1 = state_30214;
if(inst_30146){
var statearr_30239_30281 = state_30214__$1;
(statearr_30239_30281[(1)] = (13));

} else {
var statearr_30240_30282 = state_30214__$1;
(statearr_30240_30282[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30215 === (12))){
var inst_30142 = (state_30214[(2)]);
var state_30214__$1 = state_30214;
var statearr_30241_30283 = state_30214__$1;
(statearr_30241_30283[(2)] = inst_30142);

(statearr_30241_30283[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30215 === (2))){
var inst_30129 = (state_30214[(10)]);
var inst_30129__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_30214__$1 = (function (){var statearr_30242 = state_30214;
(statearr_30242[(10)] = inst_30129__$1);

return statearr_30242;
})();
if(cljs.core.truth_(inst_30129__$1)){
var statearr_30243_30284 = state_30214__$1;
(statearr_30243_30284[(1)] = (5));

} else {
var statearr_30244_30285 = state_30214__$1;
(statearr_30244_30285[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30215 === (23))){
var inst_30172 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_30214__$1 = state_30214;
if(inst_30172){
var statearr_30245_30286 = state_30214__$1;
(statearr_30245_30286[(1)] = (25));

} else {
var statearr_30246_30287 = state_30214__$1;
(statearr_30246_30287[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30215 === (35))){
var state_30214__$1 = state_30214;
var statearr_30247_30288 = state_30214__$1;
(statearr_30247_30288[(2)] = null);

(statearr_30247_30288[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30215 === (19))){
var inst_30167 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_30214__$1 = state_30214;
if(inst_30167){
var statearr_30248_30289 = state_30214__$1;
(statearr_30248_30289[(1)] = (22));

} else {
var statearr_30249_30290 = state_30214__$1;
(statearr_30249_30290[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30215 === (11))){
var inst_30138 = (state_30214[(2)]);
var state_30214__$1 = state_30214;
var statearr_30250_30291 = state_30214__$1;
(statearr_30250_30291[(2)] = inst_30138);

(statearr_30250_30291[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30215 === (9))){
var inst_30140 = figwheel.client.heads_up.clear.call(null);
var state_30214__$1 = state_30214;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30214__$1,(12),inst_30140);
} else {
if((state_val_30215 === (5))){
var inst_30131 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_30214__$1 = state_30214;
var statearr_30251_30292 = state_30214__$1;
(statearr_30251_30292[(2)] = inst_30131);

(statearr_30251_30292[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30215 === (14))){
var inst_30158 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_30214__$1 = state_30214;
if(inst_30158){
var statearr_30252_30293 = state_30214__$1;
(statearr_30252_30293[(1)] = (18));

} else {
var statearr_30253_30294 = state_30214__$1;
(statearr_30253_30294[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30215 === (26))){
var inst_30184 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_30214__$1 = state_30214;
if(inst_30184){
var statearr_30254_30295 = state_30214__$1;
(statearr_30254_30295[(1)] = (30));

} else {
var statearr_30255_30296 = state_30214__$1;
(statearr_30255_30296[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30215 === (16))){
var inst_30150 = (state_30214[(2)]);
var inst_30151 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_30152 = figwheel.client.heads_up.display_exception.call(null,inst_30151);
var state_30214__$1 = (function (){var statearr_30256 = state_30214;
(statearr_30256[(13)] = inst_30150);

return statearr_30256;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30214__$1,(17),inst_30152);
} else {
if((state_val_30215 === (30))){
var inst_30186 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_30187 = figwheel.client.heads_up.display_warning.call(null,inst_30186);
var state_30214__$1 = state_30214;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30214__$1,(33),inst_30187);
} else {
if((state_val_30215 === (10))){
var inst_30144 = (state_30214[(2)]);
var state_30214__$1 = state_30214;
var statearr_30257_30297 = state_30214__$1;
(statearr_30257_30297[(2)] = inst_30144);

(statearr_30257_30297[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30215 === (18))){
var inst_30160 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_30161 = figwheel.client.heads_up.display_exception.call(null,inst_30160);
var state_30214__$1 = state_30214;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30214__$1,(21),inst_30161);
} else {
if((state_val_30215 === (37))){
var inst_30197 = (state_30214[(2)]);
var state_30214__$1 = state_30214;
var statearr_30258_30298 = state_30214__$1;
(statearr_30258_30298[(2)] = inst_30197);

(statearr_30258_30298[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30215 === (8))){
var inst_30136 = figwheel.client.heads_up.flash_loaded.call(null);
var state_30214__$1 = state_30214;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30214__$1,(11),inst_30136);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26280__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__26185__auto__,c__26280__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__26186__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__26186__auto____0 = (function (){
var statearr_30259 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30259[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__26186__auto__);

(statearr_30259[(1)] = (1));

return statearr_30259;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__26186__auto____1 = (function (state_30214){
while(true){
var ret_value__26187__auto__ = (function (){try{while(true){
var result__26188__auto__ = switch__26185__auto__.call(null,state_30214);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26188__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26188__auto__;
}
break;
}
}catch (e30260){if((e30260 instanceof Object)){
var ex__26189__auto__ = e30260;
var statearr_30261_30299 = state_30214;
(statearr_30261_30299[(5)] = ex__26189__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30214);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30260;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26187__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30300 = state_30214;
state_30214 = G__30300;
continue;
} else {
return ret_value__26187__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__26186__auto__ = function(state_30214){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__26186__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__26186__auto____1.call(this,state_30214);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__26186__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__26186__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__26186__auto__;
})()
;})(switch__26185__auto__,c__26280__auto__,msg_hist,msg_names,msg))
})();
var state__26282__auto__ = (function (){var statearr_30262 = f__26281__auto__.call(null);
(statearr_30262[(6)] = c__26280__auto__);

return statearr_30262;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26282__auto__);
});})(c__26280__auto__,msg_hist,msg_names,msg))
);

return c__26280__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__26280__auto___30329 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26280__auto___30329,ch){
return (function (){
var f__26281__auto__ = (function (){var switch__26185__auto__ = ((function (c__26280__auto___30329,ch){
return (function (state_30315){
var state_val_30316 = (state_30315[(1)]);
if((state_val_30316 === (1))){
var state_30315__$1 = state_30315;
var statearr_30317_30330 = state_30315__$1;
(statearr_30317_30330[(2)] = null);

(statearr_30317_30330[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30316 === (2))){
var state_30315__$1 = state_30315;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30315__$1,(4),ch);
} else {
if((state_val_30316 === (3))){
var inst_30313 = (state_30315[(2)]);
var state_30315__$1 = state_30315;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30315__$1,inst_30313);
} else {
if((state_val_30316 === (4))){
var inst_30303 = (state_30315[(7)]);
var inst_30303__$1 = (state_30315[(2)]);
var state_30315__$1 = (function (){var statearr_30318 = state_30315;
(statearr_30318[(7)] = inst_30303__$1);

return statearr_30318;
})();
if(cljs.core.truth_(inst_30303__$1)){
var statearr_30319_30331 = state_30315__$1;
(statearr_30319_30331[(1)] = (5));

} else {
var statearr_30320_30332 = state_30315__$1;
(statearr_30320_30332[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30316 === (5))){
var inst_30303 = (state_30315[(7)]);
var inst_30305 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_30303);
var state_30315__$1 = state_30315;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30315__$1,(8),inst_30305);
} else {
if((state_val_30316 === (6))){
var state_30315__$1 = state_30315;
var statearr_30321_30333 = state_30315__$1;
(statearr_30321_30333[(2)] = null);

(statearr_30321_30333[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30316 === (7))){
var inst_30311 = (state_30315[(2)]);
var state_30315__$1 = state_30315;
var statearr_30322_30334 = state_30315__$1;
(statearr_30322_30334[(2)] = inst_30311);

(statearr_30322_30334[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30316 === (8))){
var inst_30307 = (state_30315[(2)]);
var state_30315__$1 = (function (){var statearr_30323 = state_30315;
(statearr_30323[(8)] = inst_30307);

return statearr_30323;
})();
var statearr_30324_30335 = state_30315__$1;
(statearr_30324_30335[(2)] = null);

(statearr_30324_30335[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__26280__auto___30329,ch))
;
return ((function (switch__26185__auto__,c__26280__auto___30329,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__26186__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__26186__auto____0 = (function (){
var statearr_30325 = [null,null,null,null,null,null,null,null,null];
(statearr_30325[(0)] = figwheel$client$heads_up_plugin_$_state_machine__26186__auto__);

(statearr_30325[(1)] = (1));

return statearr_30325;
});
var figwheel$client$heads_up_plugin_$_state_machine__26186__auto____1 = (function (state_30315){
while(true){
var ret_value__26187__auto__ = (function (){try{while(true){
var result__26188__auto__ = switch__26185__auto__.call(null,state_30315);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26188__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26188__auto__;
}
break;
}
}catch (e30326){if((e30326 instanceof Object)){
var ex__26189__auto__ = e30326;
var statearr_30327_30336 = state_30315;
(statearr_30327_30336[(5)] = ex__26189__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30315);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30326;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26187__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30337 = state_30315;
state_30315 = G__30337;
continue;
} else {
return ret_value__26187__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__26186__auto__ = function(state_30315){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__26186__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__26186__auto____1.call(this,state_30315);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__26186__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__26186__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__26186__auto__;
})()
;})(switch__26185__auto__,c__26280__auto___30329,ch))
})();
var state__26282__auto__ = (function (){var statearr_30328 = f__26281__auto__.call(null);
(statearr_30328[(6)] = c__26280__auto___30329);

return statearr_30328;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26282__auto__);
});})(c__26280__auto___30329,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__26280__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26280__auto__){
return (function (){
var f__26281__auto__ = (function (){var switch__26185__auto__ = ((function (c__26280__auto__){
return (function (state_30343){
var state_val_30344 = (state_30343[(1)]);
if((state_val_30344 === (1))){
var inst_30338 = cljs.core.async.timeout.call(null,(3000));
var state_30343__$1 = state_30343;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30343__$1,(2),inst_30338);
} else {
if((state_val_30344 === (2))){
var inst_30340 = (state_30343[(2)]);
var inst_30341 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_30343__$1 = (function (){var statearr_30345 = state_30343;
(statearr_30345[(7)] = inst_30340);

return statearr_30345;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30343__$1,inst_30341);
} else {
return null;
}
}
});})(c__26280__auto__))
;
return ((function (switch__26185__auto__,c__26280__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__26186__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__26186__auto____0 = (function (){
var statearr_30346 = [null,null,null,null,null,null,null,null];
(statearr_30346[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__26186__auto__);

(statearr_30346[(1)] = (1));

return statearr_30346;
});
var figwheel$client$enforce_project_plugin_$_state_machine__26186__auto____1 = (function (state_30343){
while(true){
var ret_value__26187__auto__ = (function (){try{while(true){
var result__26188__auto__ = switch__26185__auto__.call(null,state_30343);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26188__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26188__auto__;
}
break;
}
}catch (e30347){if((e30347 instanceof Object)){
var ex__26189__auto__ = e30347;
var statearr_30348_30350 = state_30343;
(statearr_30348_30350[(5)] = ex__26189__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30343);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30347;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26187__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30351 = state_30343;
state_30343 = G__30351;
continue;
} else {
return ret_value__26187__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__26186__auto__ = function(state_30343){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__26186__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__26186__auto____1.call(this,state_30343);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_project_plugin_$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__26186__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__26186__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__26186__auto__;
})()
;})(switch__26185__auto__,c__26280__auto__))
})();
var state__26282__auto__ = (function (){var statearr_30349 = f__26281__auto__.call(null);
(statearr_30349[(6)] = c__26280__auto__);

return statearr_30349;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26282__auto__);
});})(c__26280__auto__))
);

return c__26280__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__5457__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__5457__auto__)){
var figwheel_version = temp__5457__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__26280__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26280__auto__,figwheel_version,temp__5457__auto__){
return (function (){
var f__26281__auto__ = (function (){var switch__26185__auto__ = ((function (c__26280__auto__,figwheel_version,temp__5457__auto__){
return (function (state_30358){
var state_val_30359 = (state_30358[(1)]);
if((state_val_30359 === (1))){
var inst_30352 = cljs.core.async.timeout.call(null,(2000));
var state_30358__$1 = state_30358;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30358__$1,(2),inst_30352);
} else {
if((state_val_30359 === (2))){
var inst_30354 = (state_30358[(2)]);
var inst_30355 = ["Figwheel Client Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client._figwheel_version_),"</strong> is not equal to ","Figwheel Sidecar Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),"</strong>",".  Shutting down Websocket Connection!","<h4>To fix try:</h4>","<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>","<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>","<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>"].join('');
var inst_30356 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_30355);
var state_30358__$1 = (function (){var statearr_30360 = state_30358;
(statearr_30360[(7)] = inst_30354);

return statearr_30360;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30358__$1,inst_30356);
} else {
return null;
}
}
});})(c__26280__auto__,figwheel_version,temp__5457__auto__))
;
return ((function (switch__26185__auto__,c__26280__auto__,figwheel_version,temp__5457__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__26186__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__26186__auto____0 = (function (){
var statearr_30361 = [null,null,null,null,null,null,null,null];
(statearr_30361[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__26186__auto__);

(statearr_30361[(1)] = (1));

return statearr_30361;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__26186__auto____1 = (function (state_30358){
while(true){
var ret_value__26187__auto__ = (function (){try{while(true){
var result__26188__auto__ = switch__26185__auto__.call(null,state_30358);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26188__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26188__auto__;
}
break;
}
}catch (e30362){if((e30362 instanceof Object)){
var ex__26189__auto__ = e30362;
var statearr_30363_30365 = state_30358;
(statearr_30363_30365[(5)] = ex__26189__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30358);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30362;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26187__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30366 = state_30358;
state_30358 = G__30366;
continue;
} else {
return ret_value__26187__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__26186__auto__ = function(state_30358){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__26186__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__26186__auto____1.call(this,state_30358);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__26186__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__26186__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__26186__auto__;
})()
;})(switch__26185__auto__,c__26280__auto__,figwheel_version,temp__5457__auto__))
})();
var state__26282__auto__ = (function (){var statearr_30364 = f__26281__auto__.call(null);
(statearr_30364[(6)] = c__26280__auto__);

return statearr_30364;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26282__auto__);
});})(c__26280__auto__,figwheel_version,temp__5457__auto__))
);

return c__26280__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__30367){
var map__30368 = p__30367;
var map__30368__$1 = (((((!((map__30368 == null))))?(((((map__30368.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30368.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30368):map__30368);
var file = cljs.core.get.call(null,map__30368__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__30368__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__30368__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__30370 = "";
var G__30370__$1 = (cljs.core.truth_(file)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__30370),"file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__30370);
var G__30370__$2 = (cljs.core.truth_(line)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__30370__$1)," at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__30370__$1);
if(cljs.core.truth_((function (){var and__4036__auto__ = line;
if(cljs.core.truth_(and__4036__auto__)){
return column;
} else {
return and__4036__auto__;
}
})())){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__30370__$2),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__30370__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__30371){
var map__30372 = p__30371;
var map__30372__$1 = (((((!((map__30372 == null))))?(((((map__30372.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30372.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30372):map__30372);
var ed = map__30372__$1;
var exception_data = cljs.core.get.call(null,map__30372__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__30372__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
var message_30375 = (function (){var G__30374 = cljs.core.apply.call(null,cljs.core.str,"Figwheel: Compile Exception ",figwheel.client.format_messages.call(null,exception_data));
if(cljs.core.truth_(new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(exception_data))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__30374)," Error on ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,exception_data))].join('');
} else {
return G__30374;
}
})();
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),message_30375);

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__30376){
var map__30377 = p__30376;
var map__30377__$1 = (((((!((map__30377 == null))))?(((((map__30377.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30377.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30377):map__30377);
var w = map__30377__$1;
var message = cljs.core.get.call(null,map__30377__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),["Figwheel: Compile Warning - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message))," in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,message))].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.config_defaults !== 'undefined')){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources\\public\\js\\out\\figwheel\\client.cljs",33,1,362,362,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources\\public\\js\\out\\figwheel\\client.cljs",30,1,355,355,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,["ws://",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),"/figwheel-ws"].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(figwheel.client.utils.html_env_QMARK_.call(null)){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = (((!(figwheel.client.utils.html_env_QMARK_.call(null))))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__4036__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__4036__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__4036__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_json_message_watch = (function figwheel$client$add_json_message_watch(key,callback){
return figwheel.client.add_message_watch.call(null,key,cljs.core.comp.call(null,callback,cljs.core.clj__GT_js));
});
goog.exportSymbol('figwheel.client.add_json_message_watch', figwheel.client.add_json_message_watch);
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__30379 = cljs.core.seq.call(null,plugins);
var chunk__30380 = null;
var count__30381 = (0);
var i__30382 = (0);
while(true){
if((i__30382 < count__30381)){
var vec__30383 = cljs.core._nth.call(null,chunk__30380,i__30382);
var k = cljs.core.nth.call(null,vec__30383,(0),null);
var plugin = cljs.core.nth.call(null,vec__30383,(1),null);
if(cljs.core.truth_(plugin)){
var pl_30389 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__30379,chunk__30380,count__30381,i__30382,pl_30389,vec__30383,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_30389.call(null,msg_hist);
});})(seq__30379,chunk__30380,count__30381,i__30382,pl_30389,vec__30383,k,plugin))
);
} else {
}


var G__30390 = seq__30379;
var G__30391 = chunk__30380;
var G__30392 = count__30381;
var G__30393 = (i__30382 + (1));
seq__30379 = G__30390;
chunk__30380 = G__30391;
count__30381 = G__30392;
i__30382 = G__30393;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__30379);
if(temp__5457__auto__){
var seq__30379__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30379__$1)){
var c__4461__auto__ = cljs.core.chunk_first.call(null,seq__30379__$1);
var G__30394 = cljs.core.chunk_rest.call(null,seq__30379__$1);
var G__30395 = c__4461__auto__;
var G__30396 = cljs.core.count.call(null,c__4461__auto__);
var G__30397 = (0);
seq__30379 = G__30394;
chunk__30380 = G__30395;
count__30381 = G__30396;
i__30382 = G__30397;
continue;
} else {
var vec__30386 = cljs.core.first.call(null,seq__30379__$1);
var k = cljs.core.nth.call(null,vec__30386,(0),null);
var plugin = cljs.core.nth.call(null,vec__30386,(1),null);
if(cljs.core.truth_(plugin)){
var pl_30398 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__30379,chunk__30380,count__30381,i__30382,pl_30398,vec__30386,k,plugin,seq__30379__$1,temp__5457__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_30398.call(null,msg_hist);
});})(seq__30379,chunk__30380,count__30381,i__30382,pl_30398,vec__30386,k,plugin,seq__30379__$1,temp__5457__auto__))
);
} else {
}


var G__30399 = cljs.core.next.call(null,seq__30379__$1);
var G__30400 = null;
var G__30401 = (0);
var G__30402 = (0);
seq__30379 = G__30399;
chunk__30380 = G__30400;
count__30381 = G__30401;
i__30382 = G__30402;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var G__30404 = arguments.length;
switch (G__30404) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.__figwheel_start_once__ !== 'undefined')){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__30405_30410 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__30406_30411 = null;
var count__30407_30412 = (0);
var i__30408_30413 = (0);
while(true){
if((i__30408_30413 < count__30407_30412)){
var msg_30414 = cljs.core._nth.call(null,chunk__30406_30411,i__30408_30413);
figwheel.client.socket.handle_incoming_message.call(null,msg_30414);


var G__30415 = seq__30405_30410;
var G__30416 = chunk__30406_30411;
var G__30417 = count__30407_30412;
var G__30418 = (i__30408_30413 + (1));
seq__30405_30410 = G__30415;
chunk__30406_30411 = G__30416;
count__30407_30412 = G__30417;
i__30408_30413 = G__30418;
continue;
} else {
var temp__5457__auto___30419 = cljs.core.seq.call(null,seq__30405_30410);
if(temp__5457__auto___30419){
var seq__30405_30420__$1 = temp__5457__auto___30419;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30405_30420__$1)){
var c__4461__auto___30421 = cljs.core.chunk_first.call(null,seq__30405_30420__$1);
var G__30422 = cljs.core.chunk_rest.call(null,seq__30405_30420__$1);
var G__30423 = c__4461__auto___30421;
var G__30424 = cljs.core.count.call(null,c__4461__auto___30421);
var G__30425 = (0);
seq__30405_30410 = G__30422;
chunk__30406_30411 = G__30423;
count__30407_30412 = G__30424;
i__30408_30413 = G__30425;
continue;
} else {
var msg_30426 = cljs.core.first.call(null,seq__30405_30420__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_30426);


var G__30427 = cljs.core.next.call(null,seq__30405_30420__$1);
var G__30428 = null;
var G__30429 = (0);
var G__30430 = (0);
seq__30405_30410 = G__30427;
chunk__30406_30411 = G__30428;
count__30407_30412 = G__30429;
i__30408_30413 = G__30430;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__4647__auto__ = [];
var len__4641__auto___30435 = arguments.length;
var i__4642__auto___30436 = (0);
while(true){
if((i__4642__auto___30436 < len__4641__auto___30435)){
args__4647__auto__.push((arguments[i__4642__auto___30436]));

var G__30437 = (i__4642__auto___30436 + (1));
i__4642__auto___30436 = G__30437;
continue;
} else {
}
break;
}

var argseq__4648__auto__ = ((((0) < args__4647__auto__.length))?(new cljs.core.IndexedSeq(args__4647__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__4648__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__30432){
var map__30433 = p__30432;
var map__30433__$1 = (((((!((map__30433 == null))))?(((((map__30433.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30433.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30433):map__30433);
var opts = map__30433__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq30431){
var self__4629__auto__ = this;
return self__4629__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq30431));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e30438){if((e30438 instanceof Error)){
var e = e30438;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e30438;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__30439){
var map__30440 = p__30439;
var map__30440__$1 = (((((!((map__30440 == null))))?(((((map__30440.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30440.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30440):map__30440);
var msg_name = cljs.core.get.call(null,map__30440__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1547336865501
