// Compiled by ClojureScript 1.10.439 {}
goog.provide('threeagent.threejs');
goog.require('cljs.core');
goog.require('threeagent.impl.util');
threeagent.threejs.perspective_camera = (function threeagent$threejs$perspective_camera(fov,aspect,near,far){
return (new THREE.PerspectiveCamera(fov,aspect,near,far));
});
threeagent.threejs.point_light = (function threeagent$threejs$point_light(c,i,d){
return (new THREE.PointLight(c,i,d));
});
threeagent.threejs.hemisphere_light = (function threeagent$threejs$hemisphere_light(sky_color,ground_color,intensity){
return (new THREE.HemisphereLight(sky_color,ground_color,intensity));
});
threeagent.threejs.box_geometry = (function threeagent$threejs$box_geometry(x,y,z){
return (new THREE.BoxGeometry(x,y,z));
});
threeagent.threejs.plane_geometry = (function threeagent$threejs$plane_geometry(width,height,segments_width,segments_height){
return (new THREE.PlaneGeometry(width,height,segments_width,segments_height));
});
threeagent.threejs.sphere_geometry = (function threeagent$threejs$sphere_geometry(radius,width_seg,height_seg){
return (new THREE.SphereGeometry(radius,width_seg,height_seg));
});
threeagent.threejs.text_geometry = (function threeagent$threejs$text_geometry(text,cfg){
return (new THREE.TextGeometry(text,cljs.core.clj__GT_js.call(null,cfg)));
});
threeagent.threejs.mesh_basic_material = (function threeagent$threejs$mesh_basic_material(c){
return (new THREE.MeshBasicMaterial(cljs.core.clj__GT_js.call(null,c)));
});
threeagent.threejs.mesh_phong_material = (function threeagent$threejs$mesh_phong_material(c){
return (new THREE.MeshPhongMaterial(cljs.core.clj__GT_js.call(null,c)));
});
threeagent.threejs.mesh = (function threeagent$threejs$mesh(geo,mat){
return (new THREE.Mesh(geo,mat));
});
threeagent.threejs.object = (function threeagent$threejs$object(){
return (new THREE.Object3D());
});
threeagent.threejs.group = (function threeagent$threejs$group(){
return (new THREE.Group());
});
threeagent.threejs.vec3 = (function threeagent$threejs$vec3(var_args){
var G__23844 = arguments.length;
switch (G__23844) {
case 1:
return threeagent.threejs.vec3.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return threeagent.threejs.vec3.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 0:
return threeagent.threejs.vec3.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

threeagent.threejs.vec3.cljs$core$IFn$_invoke$arity$1 = (function (p__23845){
var vec__23846 = p__23845;
var x = cljs.core.nth.call(null,vec__23846,(0),null);
var y = cljs.core.nth.call(null,vec__23846,(1),null);
var z = cljs.core.nth.call(null,vec__23846,(2),null);
return (new THREE.Vector3(x,y,z));
});

threeagent.threejs.vec3.cljs$core$IFn$_invoke$arity$3 = (function (x,y,z){
return (new THREE.Vector3(x,y,z));
});

threeagent.threejs.vec3.cljs$core$IFn$_invoke$arity$0 = (function (){
return (new THREE.Vector3());
});

threeagent.threejs.vec3.cljs$lang$maxFixedArity = 3;

threeagent.threejs.arrow_helper = (function threeagent$threejs$arrow_helper(dir,origin,length){
return (new THREE.ArrowHelper(threeagent.threejs.vec3.call(null,dir),threeagent.threejs.vec3.call(null,origin),length));
});
threeagent.threejs.vec3__GT_vector = (function threeagent$threejs$vec3__GT_vector(v){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [v.x,v.y,v.z], null);
});
threeagent.threejs.euler = (function threeagent$threejs$euler(x,y,z){
return (new THREE.Euler(x,y,z,"XYZ"));
});
threeagent.threejs.euler__GT_vector = (function threeagent$threejs$euler__GT_vector(e){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [e.x,e.y,e.z], null);
});
threeagent.threejs.color = (function threeagent$threejs$color(var_args){
var G__23851 = arguments.length;
switch (G__23851) {
case 1:
return threeagent.threejs.color.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return threeagent.threejs.color.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

threeagent.threejs.color.cljs$core$IFn$_invoke$arity$1 = (function (s){
return (new THREE.Color(s));
});

threeagent.threejs.color.cljs$core$IFn$_invoke$arity$3 = (function (r,g,b){
return (new THREE.Color(r,g,b));
});

threeagent.threejs.color.cljs$lang$maxFixedArity = 3;

threeagent.threejs.raycaster = (function threeagent$threejs$raycaster(origin,dir,near,far){
return (new THREE.Raycaster(origin,dir,near,far));
});
threeagent.threejs.world_position = (function threeagent$threejs$world_position(obj){
if(cljs.core.truth_(obj)){
var v = threeagent.threejs.vec3.call(null);
obj.getWorldPosition(v);

return v;
} else {
return null;
}
});
threeagent.threejs.rotation__GT_direction = (function threeagent$threejs$rotation__GT_direction(obj){
var quat = (new THREE.Quaternion()).setFromRotationMatrix(obj.matrixWorld);
var vector = threeagent.threejs.vec3.call(null,(0),(1),(0));
vector.applyQuaternion(quat);

vector.normalize();

return vector;
});
threeagent.threejs.set_position_BANG_ = (function threeagent$threejs$set_position_BANG_(obj,p__23853){
var vec__23854 = p__23853;
var x = cljs.core.nth.call(null,vec__23854,(0),null);
var y = cljs.core.nth.call(null,vec__23854,(1),null);
var z = cljs.core.nth.call(null,vec__23854,(2),null);
obj.position.set(x,y,z);

return obj;
});
threeagent.threejs.set_rotation_BANG_ = (function threeagent$threejs$set_rotation_BANG_(obj,p__23857){
var vec__23858 = p__23857;
var x = cljs.core.nth.call(null,vec__23858,(0),null);
var y = cljs.core.nth.call(null,vec__23858,(1),null);
var z = cljs.core.nth.call(null,vec__23858,(2),null);
obj.setRotationFromEuler(threeagent.threejs.euler.call(null,x,y,z));

return obj;
});
threeagent.threejs.set_scale_BANG_ = (function threeagent$threejs$set_scale_BANG_(obj,p__23861){
var vec__23862 = p__23861;
var x = cljs.core.nth.call(null,vec__23862,(0),null);
var y = cljs.core.nth.call(null,vec__23862,(1),null);
var z = cljs.core.nth.call(null,vec__23862,(2),null);
obj.scale.set(x,y,z);

return obj;
});
threeagent.threejs.add_child_BANG_ = (function threeagent$threejs$add_child_BANG_(parent,child){
return parent.add(child);
});
threeagent.threejs.remove_child_BANG_ = (function threeagent$threejs$remove_child_BANG_(parent,child){
return parent.remove(child);
});
threeagent.threejs.remove_all_children_BANG_ = (function threeagent$threejs$remove_all_children_BANG_(parent){
var iter__4434__auto___23869 = (function threeagent$threejs$remove_all_children_BANG__$_iter__23865(s__23866){
return (new cljs.core.LazySeq(null,(function (){
var s__23866__$1 = s__23866;
while(true){
var temp__5457__auto__ = cljs.core.seq.call(null,s__23866__$1);
if(temp__5457__auto__){
var s__23866__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23866__$2)){
var c__4432__auto__ = cljs.core.chunk_first.call(null,s__23866__$2);
var size__4433__auto__ = cljs.core.count.call(null,c__4432__auto__);
var b__23868 = cljs.core.chunk_buffer.call(null,size__4433__auto__);
if((function (){var i__23867 = (0);
while(true){
if((i__23867 < size__4433__auto__)){
var c = cljs.core._nth.call(null,c__4432__auto__,i__23867);
cljs.core.chunk_append.call(null,b__23868,threeagent.threejs.remove_child_BANG_.call(null,parent,c));

var G__23870 = (i__23867 + (1));
i__23867 = G__23870;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23868),threeagent$threejs$remove_all_children_BANG__$_iter__23865.call(null,cljs.core.chunk_rest.call(null,s__23866__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23868),null);
}
} else {
var c = cljs.core.first.call(null,s__23866__$2);
return cljs.core.cons.call(null,threeagent.threejs.remove_child_BANG_.call(null,parent,c),threeagent$threejs$remove_all_children_BANG__$_iter__23865.call(null,cljs.core.rest.call(null,s__23866__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
iter__4434__auto___23869.call(null,parent.children);

return parent;
});

//# sourceMappingURL=threejs.js.map?rel=1547522515342
