// Compiled by ClojureScript 1.10.439 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__26340 = arguments.length;
switch (G__26340) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async26341 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26341 = (function (f,blockable,meta26342){
this.f = f;
this.blockable = blockable;
this.meta26342 = meta26342;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async26341.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26343,meta26342__$1){
var self__ = this;
var _26343__$1 = this;
return (new cljs.core.async.t_cljs$core$async26341(self__.f,self__.blockable,meta26342__$1));
});

cljs.core.async.t_cljs$core$async26341.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26343){
var self__ = this;
var _26343__$1 = this;
return self__.meta26342;
});

cljs.core.async.t_cljs$core$async26341.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26341.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async26341.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async26341.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async26341.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta26342","meta26342",-671182709,null)], null);
});

cljs.core.async.t_cljs$core$async26341.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26341.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26341";

cljs.core.async.t_cljs$core$async26341.cljs$lang$ctorPrWriter = (function (this__4290__auto__,writer__4291__auto__,opt__4292__auto__){
return cljs.core._write.call(null,writer__4291__auto__,"cljs.core.async/t_cljs$core$async26341");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async26341.
 */
cljs.core.async.__GT_t_cljs$core$async26341 = (function cljs$core$async$__GT_t_cljs$core$async26341(f__$1,blockable__$1,meta26342){
return (new cljs.core.async.t_cljs$core$async26341(f__$1,blockable__$1,meta26342));
});

}

return (new cljs.core.async.t_cljs$core$async26341(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__26347 = arguments.length;
switch (G__26347) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__26350 = arguments.length;
switch (G__26350) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__26353 = arguments.length;
switch (G__26353) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_26355 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_26355);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_26355,ret){
return (function (){
return fn1.call(null,val_26355);
});})(val_26355,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__26357 = arguments.length;
switch (G__26357) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5455__auto__)){
var ret = temp__5455__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5455__auto__)){
var retb = temp__5455__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__5455__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__5455__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4518__auto___26359 = n;
var x_26360 = (0);
while(true){
if((x_26360 < n__4518__auto___26359)){
(a[x_26360] = (0));

var G__26361 = (x_26360 + (1));
x_26360 = G__26361;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__26362 = (i + (1));
i = G__26362;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async26363 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26363 = (function (flag,meta26364){
this.flag = flag;
this.meta26364 = meta26364;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async26363.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_26365,meta26364__$1){
var self__ = this;
var _26365__$1 = this;
return (new cljs.core.async.t_cljs$core$async26363(self__.flag,meta26364__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async26363.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_26365){
var self__ = this;
var _26365__$1 = this;
return self__.meta26364;
});})(flag))
;

cljs.core.async.t_cljs$core$async26363.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26363.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async26363.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async26363.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async26363.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta26364","meta26364",-446941834,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async26363.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26363.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26363";

cljs.core.async.t_cljs$core$async26363.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4290__auto__,writer__4291__auto__,opt__4292__auto__){
return cljs.core._write.call(null,writer__4291__auto__,"cljs.core.async/t_cljs$core$async26363");
});})(flag))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async26363.
 */
cljs.core.async.__GT_t_cljs$core$async26363 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async26363(flag__$1,meta26364){
return (new cljs.core.async.t_cljs$core$async26363(flag__$1,meta26364));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async26363(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async26366 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26366 = (function (flag,cb,meta26367){
this.flag = flag;
this.cb = cb;
this.meta26367 = meta26367;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async26366.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26368,meta26367__$1){
var self__ = this;
var _26368__$1 = this;
return (new cljs.core.async.t_cljs$core$async26366(self__.flag,self__.cb,meta26367__$1));
});

cljs.core.async.t_cljs$core$async26366.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26368){
var self__ = this;
var _26368__$1 = this;
return self__.meta26367;
});

cljs.core.async.t_cljs$core$async26366.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26366.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async26366.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async26366.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async26366.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta26367","meta26367",-1380903031,null)], null);
});

cljs.core.async.t_cljs$core$async26366.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26366.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26366";

cljs.core.async.t_cljs$core$async26366.cljs$lang$ctorPrWriter = (function (this__4290__auto__,writer__4291__auto__,opt__4292__auto__){
return cljs.core._write.call(null,writer__4291__auto__,"cljs.core.async/t_cljs$core$async26366");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async26366.
 */
cljs.core.async.__GT_t_cljs$core$async26366 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async26366(flag__$1,cb__$1,meta26367){
return (new cljs.core.async.t_cljs$core$async26366(flag__$1,cb__$1,meta26367));
});

}

return (new cljs.core.async.t_cljs$core$async26366(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__26369_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__26369_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__26370_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__26370_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4047__auto__ = wport;
if(cljs.core.truth_(or__4047__auto__)){
return or__4047__auto__;
} else {
return port;
}
})()], null));
} else {
var G__26371 = (i + (1));
i = G__26371;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4047__auto__ = ret;
if(cljs.core.truth_(or__4047__auto__)){
return or__4047__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5457__auto__ = (function (){var and__4036__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4036__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4036__auto__;
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var got = temp__5457__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4647__auto__ = [];
var len__4641__auto___26377 = arguments.length;
var i__4642__auto___26378 = (0);
while(true){
if((i__4642__auto___26378 < len__4641__auto___26377)){
args__4647__auto__.push((arguments[i__4642__auto___26378]));

var G__26379 = (i__4642__auto___26378 + (1));
i__4642__auto___26378 = G__26379;
continue;
} else {
}
break;
}

var argseq__4648__auto__ = ((((1) < args__4647__auto__.length))?(new cljs.core.IndexedSeq(args__4647__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4648__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__26374){
var map__26375 = p__26374;
var map__26375__$1 = (((((!((map__26375 == null))))?(((((map__26375.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26375.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26375):map__26375);
var opts = map__26375__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq26372){
var G__26373 = cljs.core.first.call(null,seq26372);
var seq26372__$1 = cljs.core.next.call(null,seq26372);
var self__4628__auto__ = this;
return self__4628__auto__.cljs$core$IFn$_invoke$arity$variadic(G__26373,seq26372__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__26381 = arguments.length;
switch (G__26381) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__26280__auto___26427 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26280__auto___26427){
return (function (){
var f__26281__auto__ = (function (){var switch__26185__auto__ = ((function (c__26280__auto___26427){
return (function (state_26405){
var state_val_26406 = (state_26405[(1)]);
if((state_val_26406 === (7))){
var inst_26401 = (state_26405[(2)]);
var state_26405__$1 = state_26405;
var statearr_26407_26428 = state_26405__$1;
(statearr_26407_26428[(2)] = inst_26401);

(statearr_26407_26428[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26406 === (1))){
var state_26405__$1 = state_26405;
var statearr_26408_26429 = state_26405__$1;
(statearr_26408_26429[(2)] = null);

(statearr_26408_26429[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26406 === (4))){
var inst_26384 = (state_26405[(7)]);
var inst_26384__$1 = (state_26405[(2)]);
var inst_26385 = (inst_26384__$1 == null);
var state_26405__$1 = (function (){var statearr_26409 = state_26405;
(statearr_26409[(7)] = inst_26384__$1);

return statearr_26409;
})();
if(cljs.core.truth_(inst_26385)){
var statearr_26410_26430 = state_26405__$1;
(statearr_26410_26430[(1)] = (5));

} else {
var statearr_26411_26431 = state_26405__$1;
(statearr_26411_26431[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26406 === (13))){
var state_26405__$1 = state_26405;
var statearr_26412_26432 = state_26405__$1;
(statearr_26412_26432[(2)] = null);

(statearr_26412_26432[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26406 === (6))){
var inst_26384 = (state_26405[(7)]);
var state_26405__$1 = state_26405;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26405__$1,(11),to,inst_26384);
} else {
if((state_val_26406 === (3))){
var inst_26403 = (state_26405[(2)]);
var state_26405__$1 = state_26405;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26405__$1,inst_26403);
} else {
if((state_val_26406 === (12))){
var state_26405__$1 = state_26405;
var statearr_26413_26433 = state_26405__$1;
(statearr_26413_26433[(2)] = null);

(statearr_26413_26433[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26406 === (2))){
var state_26405__$1 = state_26405;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26405__$1,(4),from);
} else {
if((state_val_26406 === (11))){
var inst_26394 = (state_26405[(2)]);
var state_26405__$1 = state_26405;
if(cljs.core.truth_(inst_26394)){
var statearr_26414_26434 = state_26405__$1;
(statearr_26414_26434[(1)] = (12));

} else {
var statearr_26415_26435 = state_26405__$1;
(statearr_26415_26435[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26406 === (9))){
var state_26405__$1 = state_26405;
var statearr_26416_26436 = state_26405__$1;
(statearr_26416_26436[(2)] = null);

(statearr_26416_26436[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26406 === (5))){
var state_26405__$1 = state_26405;
if(cljs.core.truth_(close_QMARK_)){
var statearr_26417_26437 = state_26405__$1;
(statearr_26417_26437[(1)] = (8));

} else {
var statearr_26418_26438 = state_26405__$1;
(statearr_26418_26438[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26406 === (14))){
var inst_26399 = (state_26405[(2)]);
var state_26405__$1 = state_26405;
var statearr_26419_26439 = state_26405__$1;
(statearr_26419_26439[(2)] = inst_26399);

(statearr_26419_26439[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26406 === (10))){
var inst_26391 = (state_26405[(2)]);
var state_26405__$1 = state_26405;
var statearr_26420_26440 = state_26405__$1;
(statearr_26420_26440[(2)] = inst_26391);

(statearr_26420_26440[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26406 === (8))){
var inst_26388 = cljs.core.async.close_BANG_.call(null,to);
var state_26405__$1 = state_26405;
var statearr_26421_26441 = state_26405__$1;
(statearr_26421_26441[(2)] = inst_26388);

(statearr_26421_26441[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26280__auto___26427))
;
return ((function (switch__26185__auto__,c__26280__auto___26427){
return (function() {
var cljs$core$async$state_machine__26186__auto__ = null;
var cljs$core$async$state_machine__26186__auto____0 = (function (){
var statearr_26422 = [null,null,null,null,null,null,null,null];
(statearr_26422[(0)] = cljs$core$async$state_machine__26186__auto__);

(statearr_26422[(1)] = (1));

return statearr_26422;
});
var cljs$core$async$state_machine__26186__auto____1 = (function (state_26405){
while(true){
var ret_value__26187__auto__ = (function (){try{while(true){
var result__26188__auto__ = switch__26185__auto__.call(null,state_26405);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26188__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26188__auto__;
}
break;
}
}catch (e26423){if((e26423 instanceof Object)){
var ex__26189__auto__ = e26423;
var statearr_26424_26442 = state_26405;
(statearr_26424_26442[(5)] = ex__26189__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26405);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26423;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26187__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26443 = state_26405;
state_26405 = G__26443;
continue;
} else {
return ret_value__26187__auto__;
}
break;
}
});
cljs$core$async$state_machine__26186__auto__ = function(state_26405){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26186__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26186__auto____1.call(this,state_26405);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26186__auto____0;
cljs$core$async$state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26186__auto____1;
return cljs$core$async$state_machine__26186__auto__;
})()
;})(switch__26185__auto__,c__26280__auto___26427))
})();
var state__26282__auto__ = (function (){var statearr_26425 = f__26281__auto__.call(null);
(statearr_26425[(6)] = c__26280__auto___26427);

return statearr_26425;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26282__auto__);
});})(c__26280__auto___26427))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__26444){
var vec__26445 = p__26444;
var v = cljs.core.nth.call(null,vec__26445,(0),null);
var p = cljs.core.nth.call(null,vec__26445,(1),null);
var job = vec__26445;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__26280__auto___26616 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26280__auto___26616,res,vec__26445,v,p,job,jobs,results){
return (function (){
var f__26281__auto__ = (function (){var switch__26185__auto__ = ((function (c__26280__auto___26616,res,vec__26445,v,p,job,jobs,results){
return (function (state_26452){
var state_val_26453 = (state_26452[(1)]);
if((state_val_26453 === (1))){
var state_26452__$1 = state_26452;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26452__$1,(2),res,v);
} else {
if((state_val_26453 === (2))){
var inst_26449 = (state_26452[(2)]);
var inst_26450 = cljs.core.async.close_BANG_.call(null,res);
var state_26452__$1 = (function (){var statearr_26454 = state_26452;
(statearr_26454[(7)] = inst_26449);

return statearr_26454;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26452__$1,inst_26450);
} else {
return null;
}
}
});})(c__26280__auto___26616,res,vec__26445,v,p,job,jobs,results))
;
return ((function (switch__26185__auto__,c__26280__auto___26616,res,vec__26445,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__26186__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__26186__auto____0 = (function (){
var statearr_26455 = [null,null,null,null,null,null,null,null];
(statearr_26455[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__26186__auto__);

(statearr_26455[(1)] = (1));

return statearr_26455;
});
var cljs$core$async$pipeline_STAR__$_state_machine__26186__auto____1 = (function (state_26452){
while(true){
var ret_value__26187__auto__ = (function (){try{while(true){
var result__26188__auto__ = switch__26185__auto__.call(null,state_26452);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26188__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26188__auto__;
}
break;
}
}catch (e26456){if((e26456 instanceof Object)){
var ex__26189__auto__ = e26456;
var statearr_26457_26617 = state_26452;
(statearr_26457_26617[(5)] = ex__26189__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26452);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26456;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26187__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26618 = state_26452;
state_26452 = G__26618;
continue;
} else {
return ret_value__26187__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__26186__auto__ = function(state_26452){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__26186__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__26186__auto____1.call(this,state_26452);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__26186__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__26186__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__26186__auto__;
})()
;})(switch__26185__auto__,c__26280__auto___26616,res,vec__26445,v,p,job,jobs,results))
})();
var state__26282__auto__ = (function (){var statearr_26458 = f__26281__auto__.call(null);
(statearr_26458[(6)] = c__26280__auto___26616);

return statearr_26458;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26282__auto__);
});})(c__26280__auto___26616,res,vec__26445,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__26459){
var vec__26460 = p__26459;
var v = cljs.core.nth.call(null,vec__26460,(0),null);
var p = cljs.core.nth.call(null,vec__26460,(1),null);
var job = vec__26460;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__4518__auto___26619 = n;
var __26620 = (0);
while(true){
if((__26620 < n__4518__auto___26619)){
var G__26463_26621 = type;
var G__26463_26622__$1 = (((G__26463_26621 instanceof cljs.core.Keyword))?G__26463_26621.fqn:null);
switch (G__26463_26622__$1) {
case "compute":
var c__26280__auto___26624 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__26620,c__26280__auto___26624,G__26463_26621,G__26463_26622__$1,n__4518__auto___26619,jobs,results,process,async){
return (function (){
var f__26281__auto__ = (function (){var switch__26185__auto__ = ((function (__26620,c__26280__auto___26624,G__26463_26621,G__26463_26622__$1,n__4518__auto___26619,jobs,results,process,async){
return (function (state_26476){
var state_val_26477 = (state_26476[(1)]);
if((state_val_26477 === (1))){
var state_26476__$1 = state_26476;
var statearr_26478_26625 = state_26476__$1;
(statearr_26478_26625[(2)] = null);

(statearr_26478_26625[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26477 === (2))){
var state_26476__$1 = state_26476;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26476__$1,(4),jobs);
} else {
if((state_val_26477 === (3))){
var inst_26474 = (state_26476[(2)]);
var state_26476__$1 = state_26476;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26476__$1,inst_26474);
} else {
if((state_val_26477 === (4))){
var inst_26466 = (state_26476[(2)]);
var inst_26467 = process.call(null,inst_26466);
var state_26476__$1 = state_26476;
if(cljs.core.truth_(inst_26467)){
var statearr_26479_26626 = state_26476__$1;
(statearr_26479_26626[(1)] = (5));

} else {
var statearr_26480_26627 = state_26476__$1;
(statearr_26480_26627[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26477 === (5))){
var state_26476__$1 = state_26476;
var statearr_26481_26628 = state_26476__$1;
(statearr_26481_26628[(2)] = null);

(statearr_26481_26628[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26477 === (6))){
var state_26476__$1 = state_26476;
var statearr_26482_26629 = state_26476__$1;
(statearr_26482_26629[(2)] = null);

(statearr_26482_26629[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26477 === (7))){
var inst_26472 = (state_26476[(2)]);
var state_26476__$1 = state_26476;
var statearr_26483_26630 = state_26476__$1;
(statearr_26483_26630[(2)] = inst_26472);

(statearr_26483_26630[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__26620,c__26280__auto___26624,G__26463_26621,G__26463_26622__$1,n__4518__auto___26619,jobs,results,process,async))
;
return ((function (__26620,switch__26185__auto__,c__26280__auto___26624,G__26463_26621,G__26463_26622__$1,n__4518__auto___26619,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__26186__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__26186__auto____0 = (function (){
var statearr_26484 = [null,null,null,null,null,null,null];
(statearr_26484[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__26186__auto__);

(statearr_26484[(1)] = (1));

return statearr_26484;
});
var cljs$core$async$pipeline_STAR__$_state_machine__26186__auto____1 = (function (state_26476){
while(true){
var ret_value__26187__auto__ = (function (){try{while(true){
var result__26188__auto__ = switch__26185__auto__.call(null,state_26476);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26188__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26188__auto__;
}
break;
}
}catch (e26485){if((e26485 instanceof Object)){
var ex__26189__auto__ = e26485;
var statearr_26486_26631 = state_26476;
(statearr_26486_26631[(5)] = ex__26189__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26476);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26485;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26187__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26632 = state_26476;
state_26476 = G__26632;
continue;
} else {
return ret_value__26187__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__26186__auto__ = function(state_26476){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__26186__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__26186__auto____1.call(this,state_26476);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__26186__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__26186__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__26186__auto__;
})()
;})(__26620,switch__26185__auto__,c__26280__auto___26624,G__26463_26621,G__26463_26622__$1,n__4518__auto___26619,jobs,results,process,async))
})();
var state__26282__auto__ = (function (){var statearr_26487 = f__26281__auto__.call(null);
(statearr_26487[(6)] = c__26280__auto___26624);

return statearr_26487;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26282__auto__);
});})(__26620,c__26280__auto___26624,G__26463_26621,G__26463_26622__$1,n__4518__auto___26619,jobs,results,process,async))
);


break;
case "async":
var c__26280__auto___26633 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__26620,c__26280__auto___26633,G__26463_26621,G__26463_26622__$1,n__4518__auto___26619,jobs,results,process,async){
return (function (){
var f__26281__auto__ = (function (){var switch__26185__auto__ = ((function (__26620,c__26280__auto___26633,G__26463_26621,G__26463_26622__$1,n__4518__auto___26619,jobs,results,process,async){
return (function (state_26500){
var state_val_26501 = (state_26500[(1)]);
if((state_val_26501 === (1))){
var state_26500__$1 = state_26500;
var statearr_26502_26634 = state_26500__$1;
(statearr_26502_26634[(2)] = null);

(statearr_26502_26634[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26501 === (2))){
var state_26500__$1 = state_26500;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26500__$1,(4),jobs);
} else {
if((state_val_26501 === (3))){
var inst_26498 = (state_26500[(2)]);
var state_26500__$1 = state_26500;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26500__$1,inst_26498);
} else {
if((state_val_26501 === (4))){
var inst_26490 = (state_26500[(2)]);
var inst_26491 = async.call(null,inst_26490);
var state_26500__$1 = state_26500;
if(cljs.core.truth_(inst_26491)){
var statearr_26503_26635 = state_26500__$1;
(statearr_26503_26635[(1)] = (5));

} else {
var statearr_26504_26636 = state_26500__$1;
(statearr_26504_26636[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26501 === (5))){
var state_26500__$1 = state_26500;
var statearr_26505_26637 = state_26500__$1;
(statearr_26505_26637[(2)] = null);

(statearr_26505_26637[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26501 === (6))){
var state_26500__$1 = state_26500;
var statearr_26506_26638 = state_26500__$1;
(statearr_26506_26638[(2)] = null);

(statearr_26506_26638[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26501 === (7))){
var inst_26496 = (state_26500[(2)]);
var state_26500__$1 = state_26500;
var statearr_26507_26639 = state_26500__$1;
(statearr_26507_26639[(2)] = inst_26496);

(statearr_26507_26639[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__26620,c__26280__auto___26633,G__26463_26621,G__26463_26622__$1,n__4518__auto___26619,jobs,results,process,async))
;
return ((function (__26620,switch__26185__auto__,c__26280__auto___26633,G__26463_26621,G__26463_26622__$1,n__4518__auto___26619,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__26186__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__26186__auto____0 = (function (){
var statearr_26508 = [null,null,null,null,null,null,null];
(statearr_26508[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__26186__auto__);

(statearr_26508[(1)] = (1));

return statearr_26508;
});
var cljs$core$async$pipeline_STAR__$_state_machine__26186__auto____1 = (function (state_26500){
while(true){
var ret_value__26187__auto__ = (function (){try{while(true){
var result__26188__auto__ = switch__26185__auto__.call(null,state_26500);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26188__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26188__auto__;
}
break;
}
}catch (e26509){if((e26509 instanceof Object)){
var ex__26189__auto__ = e26509;
var statearr_26510_26640 = state_26500;
(statearr_26510_26640[(5)] = ex__26189__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26500);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26509;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26187__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26641 = state_26500;
state_26500 = G__26641;
continue;
} else {
return ret_value__26187__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__26186__auto__ = function(state_26500){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__26186__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__26186__auto____1.call(this,state_26500);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__26186__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__26186__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__26186__auto__;
})()
;})(__26620,switch__26185__auto__,c__26280__auto___26633,G__26463_26621,G__26463_26622__$1,n__4518__auto___26619,jobs,results,process,async))
})();
var state__26282__auto__ = (function (){var statearr_26511 = f__26281__auto__.call(null);
(statearr_26511[(6)] = c__26280__auto___26633);

return statearr_26511;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26282__auto__);
});})(__26620,c__26280__auto___26633,G__26463_26621,G__26463_26622__$1,n__4518__auto___26619,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__26463_26622__$1)].join('')));

}

var G__26642 = (__26620 + (1));
__26620 = G__26642;
continue;
} else {
}
break;
}

var c__26280__auto___26643 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26280__auto___26643,jobs,results,process,async){
return (function (){
var f__26281__auto__ = (function (){var switch__26185__auto__ = ((function (c__26280__auto___26643,jobs,results,process,async){
return (function (state_26533){
var state_val_26534 = (state_26533[(1)]);
if((state_val_26534 === (1))){
var state_26533__$1 = state_26533;
var statearr_26535_26644 = state_26533__$1;
(statearr_26535_26644[(2)] = null);

(statearr_26535_26644[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26534 === (2))){
var state_26533__$1 = state_26533;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26533__$1,(4),from);
} else {
if((state_val_26534 === (3))){
var inst_26531 = (state_26533[(2)]);
var state_26533__$1 = state_26533;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26533__$1,inst_26531);
} else {
if((state_val_26534 === (4))){
var inst_26514 = (state_26533[(7)]);
var inst_26514__$1 = (state_26533[(2)]);
var inst_26515 = (inst_26514__$1 == null);
var state_26533__$1 = (function (){var statearr_26536 = state_26533;
(statearr_26536[(7)] = inst_26514__$1);

return statearr_26536;
})();
if(cljs.core.truth_(inst_26515)){
var statearr_26537_26645 = state_26533__$1;
(statearr_26537_26645[(1)] = (5));

} else {
var statearr_26538_26646 = state_26533__$1;
(statearr_26538_26646[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26534 === (5))){
var inst_26517 = cljs.core.async.close_BANG_.call(null,jobs);
var state_26533__$1 = state_26533;
var statearr_26539_26647 = state_26533__$1;
(statearr_26539_26647[(2)] = inst_26517);

(statearr_26539_26647[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26534 === (6))){
var inst_26514 = (state_26533[(7)]);
var inst_26519 = (state_26533[(8)]);
var inst_26519__$1 = cljs.core.async.chan.call(null,(1));
var inst_26520 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26521 = [inst_26514,inst_26519__$1];
var inst_26522 = (new cljs.core.PersistentVector(null,2,(5),inst_26520,inst_26521,null));
var state_26533__$1 = (function (){var statearr_26540 = state_26533;
(statearr_26540[(8)] = inst_26519__$1);

return statearr_26540;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26533__$1,(8),jobs,inst_26522);
} else {
if((state_val_26534 === (7))){
var inst_26529 = (state_26533[(2)]);
var state_26533__$1 = state_26533;
var statearr_26541_26648 = state_26533__$1;
(statearr_26541_26648[(2)] = inst_26529);

(statearr_26541_26648[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26534 === (8))){
var inst_26519 = (state_26533[(8)]);
var inst_26524 = (state_26533[(2)]);
var state_26533__$1 = (function (){var statearr_26542 = state_26533;
(statearr_26542[(9)] = inst_26524);

return statearr_26542;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26533__$1,(9),results,inst_26519);
} else {
if((state_val_26534 === (9))){
var inst_26526 = (state_26533[(2)]);
var state_26533__$1 = (function (){var statearr_26543 = state_26533;
(statearr_26543[(10)] = inst_26526);

return statearr_26543;
})();
var statearr_26544_26649 = state_26533__$1;
(statearr_26544_26649[(2)] = null);

(statearr_26544_26649[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__26280__auto___26643,jobs,results,process,async))
;
return ((function (switch__26185__auto__,c__26280__auto___26643,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__26186__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__26186__auto____0 = (function (){
var statearr_26545 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_26545[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__26186__auto__);

(statearr_26545[(1)] = (1));

return statearr_26545;
});
var cljs$core$async$pipeline_STAR__$_state_machine__26186__auto____1 = (function (state_26533){
while(true){
var ret_value__26187__auto__ = (function (){try{while(true){
var result__26188__auto__ = switch__26185__auto__.call(null,state_26533);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26188__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26188__auto__;
}
break;
}
}catch (e26546){if((e26546 instanceof Object)){
var ex__26189__auto__ = e26546;
var statearr_26547_26650 = state_26533;
(statearr_26547_26650[(5)] = ex__26189__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26533);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26546;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26187__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26651 = state_26533;
state_26533 = G__26651;
continue;
} else {
return ret_value__26187__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__26186__auto__ = function(state_26533){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__26186__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__26186__auto____1.call(this,state_26533);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__26186__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__26186__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__26186__auto__;
})()
;})(switch__26185__auto__,c__26280__auto___26643,jobs,results,process,async))
})();
var state__26282__auto__ = (function (){var statearr_26548 = f__26281__auto__.call(null);
(statearr_26548[(6)] = c__26280__auto___26643);

return statearr_26548;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26282__auto__);
});})(c__26280__auto___26643,jobs,results,process,async))
);


var c__26280__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26280__auto__,jobs,results,process,async){
return (function (){
var f__26281__auto__ = (function (){var switch__26185__auto__ = ((function (c__26280__auto__,jobs,results,process,async){
return (function (state_26586){
var state_val_26587 = (state_26586[(1)]);
if((state_val_26587 === (7))){
var inst_26582 = (state_26586[(2)]);
var state_26586__$1 = state_26586;
var statearr_26588_26652 = state_26586__$1;
(statearr_26588_26652[(2)] = inst_26582);

(statearr_26588_26652[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26587 === (20))){
var state_26586__$1 = state_26586;
var statearr_26589_26653 = state_26586__$1;
(statearr_26589_26653[(2)] = null);

(statearr_26589_26653[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26587 === (1))){
var state_26586__$1 = state_26586;
var statearr_26590_26654 = state_26586__$1;
(statearr_26590_26654[(2)] = null);

(statearr_26590_26654[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26587 === (4))){
var inst_26551 = (state_26586[(7)]);
var inst_26551__$1 = (state_26586[(2)]);
var inst_26552 = (inst_26551__$1 == null);
var state_26586__$1 = (function (){var statearr_26591 = state_26586;
(statearr_26591[(7)] = inst_26551__$1);

return statearr_26591;
})();
if(cljs.core.truth_(inst_26552)){
var statearr_26592_26655 = state_26586__$1;
(statearr_26592_26655[(1)] = (5));

} else {
var statearr_26593_26656 = state_26586__$1;
(statearr_26593_26656[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26587 === (15))){
var inst_26564 = (state_26586[(8)]);
var state_26586__$1 = state_26586;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26586__$1,(18),to,inst_26564);
} else {
if((state_val_26587 === (21))){
var inst_26577 = (state_26586[(2)]);
var state_26586__$1 = state_26586;
var statearr_26594_26657 = state_26586__$1;
(statearr_26594_26657[(2)] = inst_26577);

(statearr_26594_26657[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26587 === (13))){
var inst_26579 = (state_26586[(2)]);
var state_26586__$1 = (function (){var statearr_26595 = state_26586;
(statearr_26595[(9)] = inst_26579);

return statearr_26595;
})();
var statearr_26596_26658 = state_26586__$1;
(statearr_26596_26658[(2)] = null);

(statearr_26596_26658[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26587 === (6))){
var inst_26551 = (state_26586[(7)]);
var state_26586__$1 = state_26586;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26586__$1,(11),inst_26551);
} else {
if((state_val_26587 === (17))){
var inst_26572 = (state_26586[(2)]);
var state_26586__$1 = state_26586;
if(cljs.core.truth_(inst_26572)){
var statearr_26597_26659 = state_26586__$1;
(statearr_26597_26659[(1)] = (19));

} else {
var statearr_26598_26660 = state_26586__$1;
(statearr_26598_26660[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26587 === (3))){
var inst_26584 = (state_26586[(2)]);
var state_26586__$1 = state_26586;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26586__$1,inst_26584);
} else {
if((state_val_26587 === (12))){
var inst_26561 = (state_26586[(10)]);
var state_26586__$1 = state_26586;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26586__$1,(14),inst_26561);
} else {
if((state_val_26587 === (2))){
var state_26586__$1 = state_26586;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26586__$1,(4),results);
} else {
if((state_val_26587 === (19))){
var state_26586__$1 = state_26586;
var statearr_26599_26661 = state_26586__$1;
(statearr_26599_26661[(2)] = null);

(statearr_26599_26661[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26587 === (11))){
var inst_26561 = (state_26586[(2)]);
var state_26586__$1 = (function (){var statearr_26600 = state_26586;
(statearr_26600[(10)] = inst_26561);

return statearr_26600;
})();
var statearr_26601_26662 = state_26586__$1;
(statearr_26601_26662[(2)] = null);

(statearr_26601_26662[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26587 === (9))){
var state_26586__$1 = state_26586;
var statearr_26602_26663 = state_26586__$1;
(statearr_26602_26663[(2)] = null);

(statearr_26602_26663[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26587 === (5))){
var state_26586__$1 = state_26586;
if(cljs.core.truth_(close_QMARK_)){
var statearr_26603_26664 = state_26586__$1;
(statearr_26603_26664[(1)] = (8));

} else {
var statearr_26604_26665 = state_26586__$1;
(statearr_26604_26665[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26587 === (14))){
var inst_26564 = (state_26586[(8)]);
var inst_26566 = (state_26586[(11)]);
var inst_26564__$1 = (state_26586[(2)]);
var inst_26565 = (inst_26564__$1 == null);
var inst_26566__$1 = cljs.core.not.call(null,inst_26565);
var state_26586__$1 = (function (){var statearr_26605 = state_26586;
(statearr_26605[(8)] = inst_26564__$1);

(statearr_26605[(11)] = inst_26566__$1);

return statearr_26605;
})();
if(inst_26566__$1){
var statearr_26606_26666 = state_26586__$1;
(statearr_26606_26666[(1)] = (15));

} else {
var statearr_26607_26667 = state_26586__$1;
(statearr_26607_26667[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26587 === (16))){
var inst_26566 = (state_26586[(11)]);
var state_26586__$1 = state_26586;
var statearr_26608_26668 = state_26586__$1;
(statearr_26608_26668[(2)] = inst_26566);

(statearr_26608_26668[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26587 === (10))){
var inst_26558 = (state_26586[(2)]);
var state_26586__$1 = state_26586;
var statearr_26609_26669 = state_26586__$1;
(statearr_26609_26669[(2)] = inst_26558);

(statearr_26609_26669[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26587 === (18))){
var inst_26569 = (state_26586[(2)]);
var state_26586__$1 = state_26586;
var statearr_26610_26670 = state_26586__$1;
(statearr_26610_26670[(2)] = inst_26569);

(statearr_26610_26670[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26587 === (8))){
var inst_26555 = cljs.core.async.close_BANG_.call(null,to);
var state_26586__$1 = state_26586;
var statearr_26611_26671 = state_26586__$1;
(statearr_26611_26671[(2)] = inst_26555);

(statearr_26611_26671[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26280__auto__,jobs,results,process,async))
;
return ((function (switch__26185__auto__,c__26280__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__26186__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__26186__auto____0 = (function (){
var statearr_26612 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26612[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__26186__auto__);

(statearr_26612[(1)] = (1));

return statearr_26612;
});
var cljs$core$async$pipeline_STAR__$_state_machine__26186__auto____1 = (function (state_26586){
while(true){
var ret_value__26187__auto__ = (function (){try{while(true){
var result__26188__auto__ = switch__26185__auto__.call(null,state_26586);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26188__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26188__auto__;
}
break;
}
}catch (e26613){if((e26613 instanceof Object)){
var ex__26189__auto__ = e26613;
var statearr_26614_26672 = state_26586;
(statearr_26614_26672[(5)] = ex__26189__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26586);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26613;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26187__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26673 = state_26586;
state_26586 = G__26673;
continue;
} else {
return ret_value__26187__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__26186__auto__ = function(state_26586){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__26186__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__26186__auto____1.call(this,state_26586);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__26186__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__26186__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__26186__auto__;
})()
;})(switch__26185__auto__,c__26280__auto__,jobs,results,process,async))
})();
var state__26282__auto__ = (function (){var statearr_26615 = f__26281__auto__.call(null);
(statearr_26615[(6)] = c__26280__auto__);

return statearr_26615;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26282__auto__);
});})(c__26280__auto__,jobs,results,process,async))
);

return c__26280__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__26675 = arguments.length;
switch (G__26675) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__26678 = arguments.length;
switch (G__26678) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__26681 = arguments.length;
switch (G__26681) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__26280__auto___26730 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26280__auto___26730,tc,fc){
return (function (){
var f__26281__auto__ = (function (){var switch__26185__auto__ = ((function (c__26280__auto___26730,tc,fc){
return (function (state_26707){
var state_val_26708 = (state_26707[(1)]);
if((state_val_26708 === (7))){
var inst_26703 = (state_26707[(2)]);
var state_26707__$1 = state_26707;
var statearr_26709_26731 = state_26707__$1;
(statearr_26709_26731[(2)] = inst_26703);

(statearr_26709_26731[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26708 === (1))){
var state_26707__$1 = state_26707;
var statearr_26710_26732 = state_26707__$1;
(statearr_26710_26732[(2)] = null);

(statearr_26710_26732[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26708 === (4))){
var inst_26684 = (state_26707[(7)]);
var inst_26684__$1 = (state_26707[(2)]);
var inst_26685 = (inst_26684__$1 == null);
var state_26707__$1 = (function (){var statearr_26711 = state_26707;
(statearr_26711[(7)] = inst_26684__$1);

return statearr_26711;
})();
if(cljs.core.truth_(inst_26685)){
var statearr_26712_26733 = state_26707__$1;
(statearr_26712_26733[(1)] = (5));

} else {
var statearr_26713_26734 = state_26707__$1;
(statearr_26713_26734[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26708 === (13))){
var state_26707__$1 = state_26707;
var statearr_26714_26735 = state_26707__$1;
(statearr_26714_26735[(2)] = null);

(statearr_26714_26735[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26708 === (6))){
var inst_26684 = (state_26707[(7)]);
var inst_26690 = p.call(null,inst_26684);
var state_26707__$1 = state_26707;
if(cljs.core.truth_(inst_26690)){
var statearr_26715_26736 = state_26707__$1;
(statearr_26715_26736[(1)] = (9));

} else {
var statearr_26716_26737 = state_26707__$1;
(statearr_26716_26737[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26708 === (3))){
var inst_26705 = (state_26707[(2)]);
var state_26707__$1 = state_26707;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26707__$1,inst_26705);
} else {
if((state_val_26708 === (12))){
var state_26707__$1 = state_26707;
var statearr_26717_26738 = state_26707__$1;
(statearr_26717_26738[(2)] = null);

(statearr_26717_26738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26708 === (2))){
var state_26707__$1 = state_26707;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26707__$1,(4),ch);
} else {
if((state_val_26708 === (11))){
var inst_26684 = (state_26707[(7)]);
var inst_26694 = (state_26707[(2)]);
var state_26707__$1 = state_26707;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26707__$1,(8),inst_26694,inst_26684);
} else {
if((state_val_26708 === (9))){
var state_26707__$1 = state_26707;
var statearr_26718_26739 = state_26707__$1;
(statearr_26718_26739[(2)] = tc);

(statearr_26718_26739[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26708 === (5))){
var inst_26687 = cljs.core.async.close_BANG_.call(null,tc);
var inst_26688 = cljs.core.async.close_BANG_.call(null,fc);
var state_26707__$1 = (function (){var statearr_26719 = state_26707;
(statearr_26719[(8)] = inst_26687);

return statearr_26719;
})();
var statearr_26720_26740 = state_26707__$1;
(statearr_26720_26740[(2)] = inst_26688);

(statearr_26720_26740[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26708 === (14))){
var inst_26701 = (state_26707[(2)]);
var state_26707__$1 = state_26707;
var statearr_26721_26741 = state_26707__$1;
(statearr_26721_26741[(2)] = inst_26701);

(statearr_26721_26741[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26708 === (10))){
var state_26707__$1 = state_26707;
var statearr_26722_26742 = state_26707__$1;
(statearr_26722_26742[(2)] = fc);

(statearr_26722_26742[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26708 === (8))){
var inst_26696 = (state_26707[(2)]);
var state_26707__$1 = state_26707;
if(cljs.core.truth_(inst_26696)){
var statearr_26723_26743 = state_26707__$1;
(statearr_26723_26743[(1)] = (12));

} else {
var statearr_26724_26744 = state_26707__$1;
(statearr_26724_26744[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26280__auto___26730,tc,fc))
;
return ((function (switch__26185__auto__,c__26280__auto___26730,tc,fc){
return (function() {
var cljs$core$async$state_machine__26186__auto__ = null;
var cljs$core$async$state_machine__26186__auto____0 = (function (){
var statearr_26725 = [null,null,null,null,null,null,null,null,null];
(statearr_26725[(0)] = cljs$core$async$state_machine__26186__auto__);

(statearr_26725[(1)] = (1));

return statearr_26725;
});
var cljs$core$async$state_machine__26186__auto____1 = (function (state_26707){
while(true){
var ret_value__26187__auto__ = (function (){try{while(true){
var result__26188__auto__ = switch__26185__auto__.call(null,state_26707);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26188__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26188__auto__;
}
break;
}
}catch (e26726){if((e26726 instanceof Object)){
var ex__26189__auto__ = e26726;
var statearr_26727_26745 = state_26707;
(statearr_26727_26745[(5)] = ex__26189__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26707);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26726;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26187__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26746 = state_26707;
state_26707 = G__26746;
continue;
} else {
return ret_value__26187__auto__;
}
break;
}
});
cljs$core$async$state_machine__26186__auto__ = function(state_26707){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26186__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26186__auto____1.call(this,state_26707);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26186__auto____0;
cljs$core$async$state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26186__auto____1;
return cljs$core$async$state_machine__26186__auto__;
})()
;})(switch__26185__auto__,c__26280__auto___26730,tc,fc))
})();
var state__26282__auto__ = (function (){var statearr_26728 = f__26281__auto__.call(null);
(statearr_26728[(6)] = c__26280__auto___26730);

return statearr_26728;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26282__auto__);
});})(c__26280__auto___26730,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__26280__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26280__auto__){
return (function (){
var f__26281__auto__ = (function (){var switch__26185__auto__ = ((function (c__26280__auto__){
return (function (state_26767){
var state_val_26768 = (state_26767[(1)]);
if((state_val_26768 === (7))){
var inst_26763 = (state_26767[(2)]);
var state_26767__$1 = state_26767;
var statearr_26769_26787 = state_26767__$1;
(statearr_26769_26787[(2)] = inst_26763);

(statearr_26769_26787[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26768 === (1))){
var inst_26747 = init;
var state_26767__$1 = (function (){var statearr_26770 = state_26767;
(statearr_26770[(7)] = inst_26747);

return statearr_26770;
})();
var statearr_26771_26788 = state_26767__$1;
(statearr_26771_26788[(2)] = null);

(statearr_26771_26788[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26768 === (4))){
var inst_26750 = (state_26767[(8)]);
var inst_26750__$1 = (state_26767[(2)]);
var inst_26751 = (inst_26750__$1 == null);
var state_26767__$1 = (function (){var statearr_26772 = state_26767;
(statearr_26772[(8)] = inst_26750__$1);

return statearr_26772;
})();
if(cljs.core.truth_(inst_26751)){
var statearr_26773_26789 = state_26767__$1;
(statearr_26773_26789[(1)] = (5));

} else {
var statearr_26774_26790 = state_26767__$1;
(statearr_26774_26790[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26768 === (6))){
var inst_26750 = (state_26767[(8)]);
var inst_26754 = (state_26767[(9)]);
var inst_26747 = (state_26767[(7)]);
var inst_26754__$1 = f.call(null,inst_26747,inst_26750);
var inst_26755 = cljs.core.reduced_QMARK_.call(null,inst_26754__$1);
var state_26767__$1 = (function (){var statearr_26775 = state_26767;
(statearr_26775[(9)] = inst_26754__$1);

return statearr_26775;
})();
if(inst_26755){
var statearr_26776_26791 = state_26767__$1;
(statearr_26776_26791[(1)] = (8));

} else {
var statearr_26777_26792 = state_26767__$1;
(statearr_26777_26792[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26768 === (3))){
var inst_26765 = (state_26767[(2)]);
var state_26767__$1 = state_26767;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26767__$1,inst_26765);
} else {
if((state_val_26768 === (2))){
var state_26767__$1 = state_26767;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26767__$1,(4),ch);
} else {
if((state_val_26768 === (9))){
var inst_26754 = (state_26767[(9)]);
var inst_26747 = inst_26754;
var state_26767__$1 = (function (){var statearr_26778 = state_26767;
(statearr_26778[(7)] = inst_26747);

return statearr_26778;
})();
var statearr_26779_26793 = state_26767__$1;
(statearr_26779_26793[(2)] = null);

(statearr_26779_26793[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26768 === (5))){
var inst_26747 = (state_26767[(7)]);
var state_26767__$1 = state_26767;
var statearr_26780_26794 = state_26767__$1;
(statearr_26780_26794[(2)] = inst_26747);

(statearr_26780_26794[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26768 === (10))){
var inst_26761 = (state_26767[(2)]);
var state_26767__$1 = state_26767;
var statearr_26781_26795 = state_26767__$1;
(statearr_26781_26795[(2)] = inst_26761);

(statearr_26781_26795[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26768 === (8))){
var inst_26754 = (state_26767[(9)]);
var inst_26757 = cljs.core.deref.call(null,inst_26754);
var state_26767__$1 = state_26767;
var statearr_26782_26796 = state_26767__$1;
(statearr_26782_26796[(2)] = inst_26757);

(statearr_26782_26796[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__26280__auto__))
;
return ((function (switch__26185__auto__,c__26280__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__26186__auto__ = null;
var cljs$core$async$reduce_$_state_machine__26186__auto____0 = (function (){
var statearr_26783 = [null,null,null,null,null,null,null,null,null,null];
(statearr_26783[(0)] = cljs$core$async$reduce_$_state_machine__26186__auto__);

(statearr_26783[(1)] = (1));

return statearr_26783;
});
var cljs$core$async$reduce_$_state_machine__26186__auto____1 = (function (state_26767){
while(true){
var ret_value__26187__auto__ = (function (){try{while(true){
var result__26188__auto__ = switch__26185__auto__.call(null,state_26767);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26188__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26188__auto__;
}
break;
}
}catch (e26784){if((e26784 instanceof Object)){
var ex__26189__auto__ = e26784;
var statearr_26785_26797 = state_26767;
(statearr_26785_26797[(5)] = ex__26189__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26767);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26784;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26187__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26798 = state_26767;
state_26767 = G__26798;
continue;
} else {
return ret_value__26187__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__26186__auto__ = function(state_26767){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__26186__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__26186__auto____1.call(this,state_26767);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__26186__auto____0;
cljs$core$async$reduce_$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__26186__auto____1;
return cljs$core$async$reduce_$_state_machine__26186__auto__;
})()
;})(switch__26185__auto__,c__26280__auto__))
})();
var state__26282__auto__ = (function (){var statearr_26786 = f__26281__auto__.call(null);
(statearr_26786[(6)] = c__26280__auto__);

return statearr_26786;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26282__auto__);
});})(c__26280__auto__))
);

return c__26280__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__26280__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26280__auto__,f__$1){
return (function (){
var f__26281__auto__ = (function (){var switch__26185__auto__ = ((function (c__26280__auto__,f__$1){
return (function (state_26804){
var state_val_26805 = (state_26804[(1)]);
if((state_val_26805 === (1))){
var inst_26799 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_26804__$1 = state_26804;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26804__$1,(2),inst_26799);
} else {
if((state_val_26805 === (2))){
var inst_26801 = (state_26804[(2)]);
var inst_26802 = f__$1.call(null,inst_26801);
var state_26804__$1 = state_26804;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26804__$1,inst_26802);
} else {
return null;
}
}
});})(c__26280__auto__,f__$1))
;
return ((function (switch__26185__auto__,c__26280__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__26186__auto__ = null;
var cljs$core$async$transduce_$_state_machine__26186__auto____0 = (function (){
var statearr_26806 = [null,null,null,null,null,null,null];
(statearr_26806[(0)] = cljs$core$async$transduce_$_state_machine__26186__auto__);

(statearr_26806[(1)] = (1));

return statearr_26806;
});
var cljs$core$async$transduce_$_state_machine__26186__auto____1 = (function (state_26804){
while(true){
var ret_value__26187__auto__ = (function (){try{while(true){
var result__26188__auto__ = switch__26185__auto__.call(null,state_26804);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26188__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26188__auto__;
}
break;
}
}catch (e26807){if((e26807 instanceof Object)){
var ex__26189__auto__ = e26807;
var statearr_26808_26810 = state_26804;
(statearr_26808_26810[(5)] = ex__26189__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26804);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26807;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26187__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26811 = state_26804;
state_26804 = G__26811;
continue;
} else {
return ret_value__26187__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__26186__auto__ = function(state_26804){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__26186__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__26186__auto____1.call(this,state_26804);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__26186__auto____0;
cljs$core$async$transduce_$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__26186__auto____1;
return cljs$core$async$transduce_$_state_machine__26186__auto__;
})()
;})(switch__26185__auto__,c__26280__auto__,f__$1))
})();
var state__26282__auto__ = (function (){var statearr_26809 = f__26281__auto__.call(null);
(statearr_26809[(6)] = c__26280__auto__);

return statearr_26809;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26282__auto__);
});})(c__26280__auto__,f__$1))
);

return c__26280__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__26813 = arguments.length;
switch (G__26813) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__26280__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26280__auto__){
return (function (){
var f__26281__auto__ = (function (){var switch__26185__auto__ = ((function (c__26280__auto__){
return (function (state_26838){
var state_val_26839 = (state_26838[(1)]);
if((state_val_26839 === (7))){
var inst_26820 = (state_26838[(2)]);
var state_26838__$1 = state_26838;
var statearr_26840_26861 = state_26838__$1;
(statearr_26840_26861[(2)] = inst_26820);

(statearr_26840_26861[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (1))){
var inst_26814 = cljs.core.seq.call(null,coll);
var inst_26815 = inst_26814;
var state_26838__$1 = (function (){var statearr_26841 = state_26838;
(statearr_26841[(7)] = inst_26815);

return statearr_26841;
})();
var statearr_26842_26862 = state_26838__$1;
(statearr_26842_26862[(2)] = null);

(statearr_26842_26862[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (4))){
var inst_26815 = (state_26838[(7)]);
var inst_26818 = cljs.core.first.call(null,inst_26815);
var state_26838__$1 = state_26838;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26838__$1,(7),ch,inst_26818);
} else {
if((state_val_26839 === (13))){
var inst_26832 = (state_26838[(2)]);
var state_26838__$1 = state_26838;
var statearr_26843_26863 = state_26838__$1;
(statearr_26843_26863[(2)] = inst_26832);

(statearr_26843_26863[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (6))){
var inst_26823 = (state_26838[(2)]);
var state_26838__$1 = state_26838;
if(cljs.core.truth_(inst_26823)){
var statearr_26844_26864 = state_26838__$1;
(statearr_26844_26864[(1)] = (8));

} else {
var statearr_26845_26865 = state_26838__$1;
(statearr_26845_26865[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (3))){
var inst_26836 = (state_26838[(2)]);
var state_26838__$1 = state_26838;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26838__$1,inst_26836);
} else {
if((state_val_26839 === (12))){
var state_26838__$1 = state_26838;
var statearr_26846_26866 = state_26838__$1;
(statearr_26846_26866[(2)] = null);

(statearr_26846_26866[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (2))){
var inst_26815 = (state_26838[(7)]);
var state_26838__$1 = state_26838;
if(cljs.core.truth_(inst_26815)){
var statearr_26847_26867 = state_26838__$1;
(statearr_26847_26867[(1)] = (4));

} else {
var statearr_26848_26868 = state_26838__$1;
(statearr_26848_26868[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (11))){
var inst_26829 = cljs.core.async.close_BANG_.call(null,ch);
var state_26838__$1 = state_26838;
var statearr_26849_26869 = state_26838__$1;
(statearr_26849_26869[(2)] = inst_26829);

(statearr_26849_26869[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (9))){
var state_26838__$1 = state_26838;
if(cljs.core.truth_(close_QMARK_)){
var statearr_26850_26870 = state_26838__$1;
(statearr_26850_26870[(1)] = (11));

} else {
var statearr_26851_26871 = state_26838__$1;
(statearr_26851_26871[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (5))){
var inst_26815 = (state_26838[(7)]);
var state_26838__$1 = state_26838;
var statearr_26852_26872 = state_26838__$1;
(statearr_26852_26872[(2)] = inst_26815);

(statearr_26852_26872[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (10))){
var inst_26834 = (state_26838[(2)]);
var state_26838__$1 = state_26838;
var statearr_26853_26873 = state_26838__$1;
(statearr_26853_26873[(2)] = inst_26834);

(statearr_26853_26873[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (8))){
var inst_26815 = (state_26838[(7)]);
var inst_26825 = cljs.core.next.call(null,inst_26815);
var inst_26815__$1 = inst_26825;
var state_26838__$1 = (function (){var statearr_26854 = state_26838;
(statearr_26854[(7)] = inst_26815__$1);

return statearr_26854;
})();
var statearr_26855_26874 = state_26838__$1;
(statearr_26855_26874[(2)] = null);

(statearr_26855_26874[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26280__auto__))
;
return ((function (switch__26185__auto__,c__26280__auto__){
return (function() {
var cljs$core$async$state_machine__26186__auto__ = null;
var cljs$core$async$state_machine__26186__auto____0 = (function (){
var statearr_26856 = [null,null,null,null,null,null,null,null];
(statearr_26856[(0)] = cljs$core$async$state_machine__26186__auto__);

(statearr_26856[(1)] = (1));

return statearr_26856;
});
var cljs$core$async$state_machine__26186__auto____1 = (function (state_26838){
while(true){
var ret_value__26187__auto__ = (function (){try{while(true){
var result__26188__auto__ = switch__26185__auto__.call(null,state_26838);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26188__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26188__auto__;
}
break;
}
}catch (e26857){if((e26857 instanceof Object)){
var ex__26189__auto__ = e26857;
var statearr_26858_26875 = state_26838;
(statearr_26858_26875[(5)] = ex__26189__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26838);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26857;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26187__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26876 = state_26838;
state_26838 = G__26876;
continue;
} else {
return ret_value__26187__auto__;
}
break;
}
});
cljs$core$async$state_machine__26186__auto__ = function(state_26838){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26186__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26186__auto____1.call(this,state_26838);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26186__auto____0;
cljs$core$async$state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26186__auto____1;
return cljs$core$async$state_machine__26186__auto__;
})()
;})(switch__26185__auto__,c__26280__auto__))
})();
var state__26282__auto__ = (function (){var statearr_26859 = f__26281__auto__.call(null);
(statearr_26859[(6)] = c__26280__auto__);

return statearr_26859;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26282__auto__);
});})(c__26280__auto__))
);

return c__26280__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4347__auto__ = (((_ == null))?null:_);
var m__4348__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4347__auto__)]);
if((!((m__4348__auto__ == null)))){
return m__4348__auto__.call(null,_);
} else {
var m__4348__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4348__auto____$1 == null)))){
return m__4348__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4347__auto__ = (((m == null))?null:m);
var m__4348__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4347__auto__)]);
if((!((m__4348__auto__ == null)))){
return m__4348__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4348__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4348__auto____$1 == null)))){
return m__4348__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4347__auto__ = (((m == null))?null:m);
var m__4348__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4347__auto__)]);
if((!((m__4348__auto__ == null)))){
return m__4348__auto__.call(null,m,ch);
} else {
var m__4348__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4348__auto____$1 == null)))){
return m__4348__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4347__auto__ = (((m == null))?null:m);
var m__4348__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4347__auto__)]);
if((!((m__4348__auto__ == null)))){
return m__4348__auto__.call(null,m);
} else {
var m__4348__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4348__auto____$1 == null)))){
return m__4348__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async26877 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26877 = (function (ch,cs,meta26878){
this.ch = ch;
this.cs = cs;
this.meta26878 = meta26878;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async26877.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_26879,meta26878__$1){
var self__ = this;
var _26879__$1 = this;
return (new cljs.core.async.t_cljs$core$async26877(self__.ch,self__.cs,meta26878__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async26877.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_26879){
var self__ = this;
var _26879__$1 = this;
return self__.meta26878;
});})(cs))
;

cljs.core.async.t_cljs$core$async26877.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26877.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async26877.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26877.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async26877.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async26877.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async26877.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta26878","meta26878",-1249997111,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async26877.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26877.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26877";

cljs.core.async.t_cljs$core$async26877.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4290__auto__,writer__4291__auto__,opt__4292__auto__){
return cljs.core._write.call(null,writer__4291__auto__,"cljs.core.async/t_cljs$core$async26877");
});})(cs))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async26877.
 */
cljs.core.async.__GT_t_cljs$core$async26877 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async26877(ch__$1,cs__$1,meta26878){
return (new cljs.core.async.t_cljs$core$async26877(ch__$1,cs__$1,meta26878));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async26877(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__26280__auto___27099 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26280__auto___27099,cs,m,dchan,dctr,done){
return (function (){
var f__26281__auto__ = (function (){var switch__26185__auto__ = ((function (c__26280__auto___27099,cs,m,dchan,dctr,done){
return (function (state_27014){
var state_val_27015 = (state_27014[(1)]);
if((state_val_27015 === (7))){
var inst_27010 = (state_27014[(2)]);
var state_27014__$1 = state_27014;
var statearr_27016_27100 = state_27014__$1;
(statearr_27016_27100[(2)] = inst_27010);

(statearr_27016_27100[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (20))){
var inst_26913 = (state_27014[(7)]);
var inst_26925 = cljs.core.first.call(null,inst_26913);
var inst_26926 = cljs.core.nth.call(null,inst_26925,(0),null);
var inst_26927 = cljs.core.nth.call(null,inst_26925,(1),null);
var state_27014__$1 = (function (){var statearr_27017 = state_27014;
(statearr_27017[(8)] = inst_26926);

return statearr_27017;
})();
if(cljs.core.truth_(inst_26927)){
var statearr_27018_27101 = state_27014__$1;
(statearr_27018_27101[(1)] = (22));

} else {
var statearr_27019_27102 = state_27014__$1;
(statearr_27019_27102[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (27))){
var inst_26962 = (state_27014[(9)]);
var inst_26882 = (state_27014[(10)]);
var inst_26955 = (state_27014[(11)]);
var inst_26957 = (state_27014[(12)]);
var inst_26962__$1 = cljs.core._nth.call(null,inst_26955,inst_26957);
var inst_26963 = cljs.core.async.put_BANG_.call(null,inst_26962__$1,inst_26882,done);
var state_27014__$1 = (function (){var statearr_27020 = state_27014;
(statearr_27020[(9)] = inst_26962__$1);

return statearr_27020;
})();
if(cljs.core.truth_(inst_26963)){
var statearr_27021_27103 = state_27014__$1;
(statearr_27021_27103[(1)] = (30));

} else {
var statearr_27022_27104 = state_27014__$1;
(statearr_27022_27104[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (1))){
var state_27014__$1 = state_27014;
var statearr_27023_27105 = state_27014__$1;
(statearr_27023_27105[(2)] = null);

(statearr_27023_27105[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (24))){
var inst_26913 = (state_27014[(7)]);
var inst_26932 = (state_27014[(2)]);
var inst_26933 = cljs.core.next.call(null,inst_26913);
var inst_26891 = inst_26933;
var inst_26892 = null;
var inst_26893 = (0);
var inst_26894 = (0);
var state_27014__$1 = (function (){var statearr_27024 = state_27014;
(statearr_27024[(13)] = inst_26892);

(statearr_27024[(14)] = inst_26891);

(statearr_27024[(15)] = inst_26894);

(statearr_27024[(16)] = inst_26893);

(statearr_27024[(17)] = inst_26932);

return statearr_27024;
})();
var statearr_27025_27106 = state_27014__$1;
(statearr_27025_27106[(2)] = null);

(statearr_27025_27106[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (39))){
var state_27014__$1 = state_27014;
var statearr_27029_27107 = state_27014__$1;
(statearr_27029_27107[(2)] = null);

(statearr_27029_27107[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (4))){
var inst_26882 = (state_27014[(10)]);
var inst_26882__$1 = (state_27014[(2)]);
var inst_26883 = (inst_26882__$1 == null);
var state_27014__$1 = (function (){var statearr_27030 = state_27014;
(statearr_27030[(10)] = inst_26882__$1);

return statearr_27030;
})();
if(cljs.core.truth_(inst_26883)){
var statearr_27031_27108 = state_27014__$1;
(statearr_27031_27108[(1)] = (5));

} else {
var statearr_27032_27109 = state_27014__$1;
(statearr_27032_27109[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (15))){
var inst_26892 = (state_27014[(13)]);
var inst_26891 = (state_27014[(14)]);
var inst_26894 = (state_27014[(15)]);
var inst_26893 = (state_27014[(16)]);
var inst_26909 = (state_27014[(2)]);
var inst_26910 = (inst_26894 + (1));
var tmp27026 = inst_26892;
var tmp27027 = inst_26891;
var tmp27028 = inst_26893;
var inst_26891__$1 = tmp27027;
var inst_26892__$1 = tmp27026;
var inst_26893__$1 = tmp27028;
var inst_26894__$1 = inst_26910;
var state_27014__$1 = (function (){var statearr_27033 = state_27014;
(statearr_27033[(13)] = inst_26892__$1);

(statearr_27033[(14)] = inst_26891__$1);

(statearr_27033[(15)] = inst_26894__$1);

(statearr_27033[(16)] = inst_26893__$1);

(statearr_27033[(18)] = inst_26909);

return statearr_27033;
})();
var statearr_27034_27110 = state_27014__$1;
(statearr_27034_27110[(2)] = null);

(statearr_27034_27110[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (21))){
var inst_26936 = (state_27014[(2)]);
var state_27014__$1 = state_27014;
var statearr_27038_27111 = state_27014__$1;
(statearr_27038_27111[(2)] = inst_26936);

(statearr_27038_27111[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (31))){
var inst_26962 = (state_27014[(9)]);
var inst_26966 = done.call(null,null);
var inst_26967 = cljs.core.async.untap_STAR_.call(null,m,inst_26962);
var state_27014__$1 = (function (){var statearr_27039 = state_27014;
(statearr_27039[(19)] = inst_26966);

return statearr_27039;
})();
var statearr_27040_27112 = state_27014__$1;
(statearr_27040_27112[(2)] = inst_26967);

(statearr_27040_27112[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (32))){
var inst_26954 = (state_27014[(20)]);
var inst_26956 = (state_27014[(21)]);
var inst_26955 = (state_27014[(11)]);
var inst_26957 = (state_27014[(12)]);
var inst_26969 = (state_27014[(2)]);
var inst_26970 = (inst_26957 + (1));
var tmp27035 = inst_26954;
var tmp27036 = inst_26956;
var tmp27037 = inst_26955;
var inst_26954__$1 = tmp27035;
var inst_26955__$1 = tmp27037;
var inst_26956__$1 = tmp27036;
var inst_26957__$1 = inst_26970;
var state_27014__$1 = (function (){var statearr_27041 = state_27014;
(statearr_27041[(20)] = inst_26954__$1);

(statearr_27041[(21)] = inst_26956__$1);

(statearr_27041[(11)] = inst_26955__$1);

(statearr_27041[(12)] = inst_26957__$1);

(statearr_27041[(22)] = inst_26969);

return statearr_27041;
})();
var statearr_27042_27113 = state_27014__$1;
(statearr_27042_27113[(2)] = null);

(statearr_27042_27113[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (40))){
var inst_26982 = (state_27014[(23)]);
var inst_26986 = done.call(null,null);
var inst_26987 = cljs.core.async.untap_STAR_.call(null,m,inst_26982);
var state_27014__$1 = (function (){var statearr_27043 = state_27014;
(statearr_27043[(24)] = inst_26986);

return statearr_27043;
})();
var statearr_27044_27114 = state_27014__$1;
(statearr_27044_27114[(2)] = inst_26987);

(statearr_27044_27114[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (33))){
var inst_26973 = (state_27014[(25)]);
var inst_26975 = cljs.core.chunked_seq_QMARK_.call(null,inst_26973);
var state_27014__$1 = state_27014;
if(inst_26975){
var statearr_27045_27115 = state_27014__$1;
(statearr_27045_27115[(1)] = (36));

} else {
var statearr_27046_27116 = state_27014__$1;
(statearr_27046_27116[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (13))){
var inst_26903 = (state_27014[(26)]);
var inst_26906 = cljs.core.async.close_BANG_.call(null,inst_26903);
var state_27014__$1 = state_27014;
var statearr_27047_27117 = state_27014__$1;
(statearr_27047_27117[(2)] = inst_26906);

(statearr_27047_27117[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (22))){
var inst_26926 = (state_27014[(8)]);
var inst_26929 = cljs.core.async.close_BANG_.call(null,inst_26926);
var state_27014__$1 = state_27014;
var statearr_27048_27118 = state_27014__$1;
(statearr_27048_27118[(2)] = inst_26929);

(statearr_27048_27118[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (36))){
var inst_26973 = (state_27014[(25)]);
var inst_26977 = cljs.core.chunk_first.call(null,inst_26973);
var inst_26978 = cljs.core.chunk_rest.call(null,inst_26973);
var inst_26979 = cljs.core.count.call(null,inst_26977);
var inst_26954 = inst_26978;
var inst_26955 = inst_26977;
var inst_26956 = inst_26979;
var inst_26957 = (0);
var state_27014__$1 = (function (){var statearr_27049 = state_27014;
(statearr_27049[(20)] = inst_26954);

(statearr_27049[(21)] = inst_26956);

(statearr_27049[(11)] = inst_26955);

(statearr_27049[(12)] = inst_26957);

return statearr_27049;
})();
var statearr_27050_27119 = state_27014__$1;
(statearr_27050_27119[(2)] = null);

(statearr_27050_27119[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (41))){
var inst_26973 = (state_27014[(25)]);
var inst_26989 = (state_27014[(2)]);
var inst_26990 = cljs.core.next.call(null,inst_26973);
var inst_26954 = inst_26990;
var inst_26955 = null;
var inst_26956 = (0);
var inst_26957 = (0);
var state_27014__$1 = (function (){var statearr_27051 = state_27014;
(statearr_27051[(20)] = inst_26954);

(statearr_27051[(21)] = inst_26956);

(statearr_27051[(27)] = inst_26989);

(statearr_27051[(11)] = inst_26955);

(statearr_27051[(12)] = inst_26957);

return statearr_27051;
})();
var statearr_27052_27120 = state_27014__$1;
(statearr_27052_27120[(2)] = null);

(statearr_27052_27120[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (43))){
var state_27014__$1 = state_27014;
var statearr_27053_27121 = state_27014__$1;
(statearr_27053_27121[(2)] = null);

(statearr_27053_27121[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (29))){
var inst_26998 = (state_27014[(2)]);
var state_27014__$1 = state_27014;
var statearr_27054_27122 = state_27014__$1;
(statearr_27054_27122[(2)] = inst_26998);

(statearr_27054_27122[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (44))){
var inst_27007 = (state_27014[(2)]);
var state_27014__$1 = (function (){var statearr_27055 = state_27014;
(statearr_27055[(28)] = inst_27007);

return statearr_27055;
})();
var statearr_27056_27123 = state_27014__$1;
(statearr_27056_27123[(2)] = null);

(statearr_27056_27123[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (6))){
var inst_26946 = (state_27014[(29)]);
var inst_26945 = cljs.core.deref.call(null,cs);
var inst_26946__$1 = cljs.core.keys.call(null,inst_26945);
var inst_26947 = cljs.core.count.call(null,inst_26946__$1);
var inst_26948 = cljs.core.reset_BANG_.call(null,dctr,inst_26947);
var inst_26953 = cljs.core.seq.call(null,inst_26946__$1);
var inst_26954 = inst_26953;
var inst_26955 = null;
var inst_26956 = (0);
var inst_26957 = (0);
var state_27014__$1 = (function (){var statearr_27057 = state_27014;
(statearr_27057[(20)] = inst_26954);

(statearr_27057[(21)] = inst_26956);

(statearr_27057[(11)] = inst_26955);

(statearr_27057[(29)] = inst_26946__$1);

(statearr_27057[(12)] = inst_26957);

(statearr_27057[(30)] = inst_26948);

return statearr_27057;
})();
var statearr_27058_27124 = state_27014__$1;
(statearr_27058_27124[(2)] = null);

(statearr_27058_27124[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (28))){
var inst_26954 = (state_27014[(20)]);
var inst_26973 = (state_27014[(25)]);
var inst_26973__$1 = cljs.core.seq.call(null,inst_26954);
var state_27014__$1 = (function (){var statearr_27059 = state_27014;
(statearr_27059[(25)] = inst_26973__$1);

return statearr_27059;
})();
if(inst_26973__$1){
var statearr_27060_27125 = state_27014__$1;
(statearr_27060_27125[(1)] = (33));

} else {
var statearr_27061_27126 = state_27014__$1;
(statearr_27061_27126[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (25))){
var inst_26956 = (state_27014[(21)]);
var inst_26957 = (state_27014[(12)]);
var inst_26959 = (inst_26957 < inst_26956);
var inst_26960 = inst_26959;
var state_27014__$1 = state_27014;
if(cljs.core.truth_(inst_26960)){
var statearr_27062_27127 = state_27014__$1;
(statearr_27062_27127[(1)] = (27));

} else {
var statearr_27063_27128 = state_27014__$1;
(statearr_27063_27128[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (34))){
var state_27014__$1 = state_27014;
var statearr_27064_27129 = state_27014__$1;
(statearr_27064_27129[(2)] = null);

(statearr_27064_27129[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (17))){
var state_27014__$1 = state_27014;
var statearr_27065_27130 = state_27014__$1;
(statearr_27065_27130[(2)] = null);

(statearr_27065_27130[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (3))){
var inst_27012 = (state_27014[(2)]);
var state_27014__$1 = state_27014;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27014__$1,inst_27012);
} else {
if((state_val_27015 === (12))){
var inst_26941 = (state_27014[(2)]);
var state_27014__$1 = state_27014;
var statearr_27066_27131 = state_27014__$1;
(statearr_27066_27131[(2)] = inst_26941);

(statearr_27066_27131[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (2))){
var state_27014__$1 = state_27014;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27014__$1,(4),ch);
} else {
if((state_val_27015 === (23))){
var state_27014__$1 = state_27014;
var statearr_27067_27132 = state_27014__$1;
(statearr_27067_27132[(2)] = null);

(statearr_27067_27132[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (35))){
var inst_26996 = (state_27014[(2)]);
var state_27014__$1 = state_27014;
var statearr_27068_27133 = state_27014__$1;
(statearr_27068_27133[(2)] = inst_26996);

(statearr_27068_27133[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (19))){
var inst_26913 = (state_27014[(7)]);
var inst_26917 = cljs.core.chunk_first.call(null,inst_26913);
var inst_26918 = cljs.core.chunk_rest.call(null,inst_26913);
var inst_26919 = cljs.core.count.call(null,inst_26917);
var inst_26891 = inst_26918;
var inst_26892 = inst_26917;
var inst_26893 = inst_26919;
var inst_26894 = (0);
var state_27014__$1 = (function (){var statearr_27069 = state_27014;
(statearr_27069[(13)] = inst_26892);

(statearr_27069[(14)] = inst_26891);

(statearr_27069[(15)] = inst_26894);

(statearr_27069[(16)] = inst_26893);

return statearr_27069;
})();
var statearr_27070_27134 = state_27014__$1;
(statearr_27070_27134[(2)] = null);

(statearr_27070_27134[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (11))){
var inst_26891 = (state_27014[(14)]);
var inst_26913 = (state_27014[(7)]);
var inst_26913__$1 = cljs.core.seq.call(null,inst_26891);
var state_27014__$1 = (function (){var statearr_27071 = state_27014;
(statearr_27071[(7)] = inst_26913__$1);

return statearr_27071;
})();
if(inst_26913__$1){
var statearr_27072_27135 = state_27014__$1;
(statearr_27072_27135[(1)] = (16));

} else {
var statearr_27073_27136 = state_27014__$1;
(statearr_27073_27136[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (9))){
var inst_26943 = (state_27014[(2)]);
var state_27014__$1 = state_27014;
var statearr_27074_27137 = state_27014__$1;
(statearr_27074_27137[(2)] = inst_26943);

(statearr_27074_27137[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (5))){
var inst_26889 = cljs.core.deref.call(null,cs);
var inst_26890 = cljs.core.seq.call(null,inst_26889);
var inst_26891 = inst_26890;
var inst_26892 = null;
var inst_26893 = (0);
var inst_26894 = (0);
var state_27014__$1 = (function (){var statearr_27075 = state_27014;
(statearr_27075[(13)] = inst_26892);

(statearr_27075[(14)] = inst_26891);

(statearr_27075[(15)] = inst_26894);

(statearr_27075[(16)] = inst_26893);

return statearr_27075;
})();
var statearr_27076_27138 = state_27014__$1;
(statearr_27076_27138[(2)] = null);

(statearr_27076_27138[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (14))){
var state_27014__$1 = state_27014;
var statearr_27077_27139 = state_27014__$1;
(statearr_27077_27139[(2)] = null);

(statearr_27077_27139[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (45))){
var inst_27004 = (state_27014[(2)]);
var state_27014__$1 = state_27014;
var statearr_27078_27140 = state_27014__$1;
(statearr_27078_27140[(2)] = inst_27004);

(statearr_27078_27140[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (26))){
var inst_26946 = (state_27014[(29)]);
var inst_27000 = (state_27014[(2)]);
var inst_27001 = cljs.core.seq.call(null,inst_26946);
var state_27014__$1 = (function (){var statearr_27079 = state_27014;
(statearr_27079[(31)] = inst_27000);

return statearr_27079;
})();
if(inst_27001){
var statearr_27080_27141 = state_27014__$1;
(statearr_27080_27141[(1)] = (42));

} else {
var statearr_27081_27142 = state_27014__$1;
(statearr_27081_27142[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (16))){
var inst_26913 = (state_27014[(7)]);
var inst_26915 = cljs.core.chunked_seq_QMARK_.call(null,inst_26913);
var state_27014__$1 = state_27014;
if(inst_26915){
var statearr_27082_27143 = state_27014__$1;
(statearr_27082_27143[(1)] = (19));

} else {
var statearr_27083_27144 = state_27014__$1;
(statearr_27083_27144[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (38))){
var inst_26993 = (state_27014[(2)]);
var state_27014__$1 = state_27014;
var statearr_27084_27145 = state_27014__$1;
(statearr_27084_27145[(2)] = inst_26993);

(statearr_27084_27145[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (30))){
var state_27014__$1 = state_27014;
var statearr_27085_27146 = state_27014__$1;
(statearr_27085_27146[(2)] = null);

(statearr_27085_27146[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (10))){
var inst_26892 = (state_27014[(13)]);
var inst_26894 = (state_27014[(15)]);
var inst_26902 = cljs.core._nth.call(null,inst_26892,inst_26894);
var inst_26903 = cljs.core.nth.call(null,inst_26902,(0),null);
var inst_26904 = cljs.core.nth.call(null,inst_26902,(1),null);
var state_27014__$1 = (function (){var statearr_27086 = state_27014;
(statearr_27086[(26)] = inst_26903);

return statearr_27086;
})();
if(cljs.core.truth_(inst_26904)){
var statearr_27087_27147 = state_27014__$1;
(statearr_27087_27147[(1)] = (13));

} else {
var statearr_27088_27148 = state_27014__$1;
(statearr_27088_27148[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (18))){
var inst_26939 = (state_27014[(2)]);
var state_27014__$1 = state_27014;
var statearr_27089_27149 = state_27014__$1;
(statearr_27089_27149[(2)] = inst_26939);

(statearr_27089_27149[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (42))){
var state_27014__$1 = state_27014;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27014__$1,(45),dchan);
} else {
if((state_val_27015 === (37))){
var inst_26982 = (state_27014[(23)]);
var inst_26882 = (state_27014[(10)]);
var inst_26973 = (state_27014[(25)]);
var inst_26982__$1 = cljs.core.first.call(null,inst_26973);
var inst_26983 = cljs.core.async.put_BANG_.call(null,inst_26982__$1,inst_26882,done);
var state_27014__$1 = (function (){var statearr_27090 = state_27014;
(statearr_27090[(23)] = inst_26982__$1);

return statearr_27090;
})();
if(cljs.core.truth_(inst_26983)){
var statearr_27091_27150 = state_27014__$1;
(statearr_27091_27150[(1)] = (39));

} else {
var statearr_27092_27151 = state_27014__$1;
(statearr_27092_27151[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27015 === (8))){
var inst_26894 = (state_27014[(15)]);
var inst_26893 = (state_27014[(16)]);
var inst_26896 = (inst_26894 < inst_26893);
var inst_26897 = inst_26896;
var state_27014__$1 = state_27014;
if(cljs.core.truth_(inst_26897)){
var statearr_27093_27152 = state_27014__$1;
(statearr_27093_27152[(1)] = (10));

} else {
var statearr_27094_27153 = state_27014__$1;
(statearr_27094_27153[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26280__auto___27099,cs,m,dchan,dctr,done))
;
return ((function (switch__26185__auto__,c__26280__auto___27099,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__26186__auto__ = null;
var cljs$core$async$mult_$_state_machine__26186__auto____0 = (function (){
var statearr_27095 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27095[(0)] = cljs$core$async$mult_$_state_machine__26186__auto__);

(statearr_27095[(1)] = (1));

return statearr_27095;
});
var cljs$core$async$mult_$_state_machine__26186__auto____1 = (function (state_27014){
while(true){
var ret_value__26187__auto__ = (function (){try{while(true){
var result__26188__auto__ = switch__26185__auto__.call(null,state_27014);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26188__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26188__auto__;
}
break;
}
}catch (e27096){if((e27096 instanceof Object)){
var ex__26189__auto__ = e27096;
var statearr_27097_27154 = state_27014;
(statearr_27097_27154[(5)] = ex__26189__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27014);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27096;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26187__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27155 = state_27014;
state_27014 = G__27155;
continue;
} else {
return ret_value__26187__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__26186__auto__ = function(state_27014){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__26186__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__26186__auto____1.call(this,state_27014);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__26186__auto____0;
cljs$core$async$mult_$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__26186__auto____1;
return cljs$core$async$mult_$_state_machine__26186__auto__;
})()
;})(switch__26185__auto__,c__26280__auto___27099,cs,m,dchan,dctr,done))
})();
var state__26282__auto__ = (function (){var statearr_27098 = f__26281__auto__.call(null);
(statearr_27098[(6)] = c__26280__auto___27099);

return statearr_27098;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26282__auto__);
});})(c__26280__auto___27099,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__27157 = arguments.length;
switch (G__27157) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4347__auto__ = (((m == null))?null:m);
var m__4348__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4347__auto__)]);
if((!((m__4348__auto__ == null)))){
return m__4348__auto__.call(null,m,ch);
} else {
var m__4348__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4348__auto____$1 == null)))){
return m__4348__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4347__auto__ = (((m == null))?null:m);
var m__4348__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4347__auto__)]);
if((!((m__4348__auto__ == null)))){
return m__4348__auto__.call(null,m,ch);
} else {
var m__4348__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4348__auto____$1 == null)))){
return m__4348__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4347__auto__ = (((m == null))?null:m);
var m__4348__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4347__auto__)]);
if((!((m__4348__auto__ == null)))){
return m__4348__auto__.call(null,m);
} else {
var m__4348__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4348__auto____$1 == null)))){
return m__4348__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4347__auto__ = (((m == null))?null:m);
var m__4348__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4347__auto__)]);
if((!((m__4348__auto__ == null)))){
return m__4348__auto__.call(null,m,state_map);
} else {
var m__4348__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4348__auto____$1 == null)))){
return m__4348__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4347__auto__ = (((m == null))?null:m);
var m__4348__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4347__auto__)]);
if((!((m__4348__auto__ == null)))){
return m__4348__auto__.call(null,m,mode);
} else {
var m__4348__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4348__auto____$1 == null)))){
return m__4348__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4647__auto__ = [];
var len__4641__auto___27169 = arguments.length;
var i__4642__auto___27170 = (0);
while(true){
if((i__4642__auto___27170 < len__4641__auto___27169)){
args__4647__auto__.push((arguments[i__4642__auto___27170]));

var G__27171 = (i__4642__auto___27170 + (1));
i__4642__auto___27170 = G__27171;
continue;
} else {
}
break;
}

var argseq__4648__auto__ = ((((3) < args__4647__auto__.length))?(new cljs.core.IndexedSeq(args__4647__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4648__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__27163){
var map__27164 = p__27163;
var map__27164__$1 = (((((!((map__27164 == null))))?(((((map__27164.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27164.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27164):map__27164);
var opts = map__27164__$1;
var statearr_27166_27172 = state;
(statearr_27166_27172[(1)] = cont_block);


var temp__5457__auto__ = cljs.core.async.do_alts.call(null,((function (map__27164,map__27164__$1,opts){
return (function (val){
var statearr_27167_27173 = state;
(statearr_27167_27173[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__27164,map__27164__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5457__auto__)){
var cb = temp__5457__auto__;
var statearr_27168_27174 = state;
(statearr_27168_27174[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq27159){
var G__27160 = cljs.core.first.call(null,seq27159);
var seq27159__$1 = cljs.core.next.call(null,seq27159);
var G__27161 = cljs.core.first.call(null,seq27159__$1);
var seq27159__$2 = cljs.core.next.call(null,seq27159__$1);
var G__27162 = cljs.core.first.call(null,seq27159__$2);
var seq27159__$3 = cljs.core.next.call(null,seq27159__$2);
var self__4628__auto__ = this;
return self__4628__auto__.cljs$core$IFn$_invoke$arity$variadic(G__27160,G__27161,G__27162,seq27159__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_.call(null,solos))))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async27175 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27175 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta27176){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta27176 = meta27176;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async27175.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_27177,meta27176__$1){
var self__ = this;
var _27177__$1 = this;
return (new cljs.core.async.t_cljs$core$async27175(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta27176__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async27175.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_27177){
var self__ = this;
var _27177__$1 = this;
return self__.meta27176;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async27175.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27175.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async27175.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27175.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async27175.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async27175.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async27175.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async27175.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async27175.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta27176","meta27176",-1725826133,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async27175.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async27175.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27175";

cljs.core.async.t_cljs$core$async27175.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4290__auto__,writer__4291__auto__,opt__4292__auto__){
return cljs.core._write.call(null,writer__4291__auto__,"cljs.core.async/t_cljs$core$async27175");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async27175.
 */
cljs.core.async.__GT_t_cljs$core$async27175 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async27175(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta27176){
return (new cljs.core.async.t_cljs$core$async27175(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta27176));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async27175(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__26280__auto___27339 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26280__auto___27339,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__26281__auto__ = (function (){var switch__26185__auto__ = ((function (c__26280__auto___27339,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_27279){
var state_val_27280 = (state_27279[(1)]);
if((state_val_27280 === (7))){
var inst_27194 = (state_27279[(2)]);
var state_27279__$1 = state_27279;
var statearr_27281_27340 = state_27279__$1;
(statearr_27281_27340[(2)] = inst_27194);

(statearr_27281_27340[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (20))){
var inst_27206 = (state_27279[(7)]);
var state_27279__$1 = state_27279;
var statearr_27282_27341 = state_27279__$1;
(statearr_27282_27341[(2)] = inst_27206);

(statearr_27282_27341[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (27))){
var state_27279__$1 = state_27279;
var statearr_27283_27342 = state_27279__$1;
(statearr_27283_27342[(2)] = null);

(statearr_27283_27342[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (1))){
var inst_27181 = (state_27279[(8)]);
var inst_27181__$1 = calc_state.call(null);
var inst_27183 = (inst_27181__$1 == null);
var inst_27184 = cljs.core.not.call(null,inst_27183);
var state_27279__$1 = (function (){var statearr_27284 = state_27279;
(statearr_27284[(8)] = inst_27181__$1);

return statearr_27284;
})();
if(inst_27184){
var statearr_27285_27343 = state_27279__$1;
(statearr_27285_27343[(1)] = (2));

} else {
var statearr_27286_27344 = state_27279__$1;
(statearr_27286_27344[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (24))){
var inst_27253 = (state_27279[(9)]);
var inst_27230 = (state_27279[(10)]);
var inst_27239 = (state_27279[(11)]);
var inst_27253__$1 = inst_27230.call(null,inst_27239);
var state_27279__$1 = (function (){var statearr_27287 = state_27279;
(statearr_27287[(9)] = inst_27253__$1);

return statearr_27287;
})();
if(cljs.core.truth_(inst_27253__$1)){
var statearr_27288_27345 = state_27279__$1;
(statearr_27288_27345[(1)] = (29));

} else {
var statearr_27289_27346 = state_27279__$1;
(statearr_27289_27346[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (4))){
var inst_27197 = (state_27279[(2)]);
var state_27279__$1 = state_27279;
if(cljs.core.truth_(inst_27197)){
var statearr_27290_27347 = state_27279__$1;
(statearr_27290_27347[(1)] = (8));

} else {
var statearr_27291_27348 = state_27279__$1;
(statearr_27291_27348[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (15))){
var inst_27224 = (state_27279[(2)]);
var state_27279__$1 = state_27279;
if(cljs.core.truth_(inst_27224)){
var statearr_27292_27349 = state_27279__$1;
(statearr_27292_27349[(1)] = (19));

} else {
var statearr_27293_27350 = state_27279__$1;
(statearr_27293_27350[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (21))){
var inst_27229 = (state_27279[(12)]);
var inst_27229__$1 = (state_27279[(2)]);
var inst_27230 = cljs.core.get.call(null,inst_27229__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_27231 = cljs.core.get.call(null,inst_27229__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_27232 = cljs.core.get.call(null,inst_27229__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_27279__$1 = (function (){var statearr_27294 = state_27279;
(statearr_27294[(13)] = inst_27231);

(statearr_27294[(12)] = inst_27229__$1);

(statearr_27294[(10)] = inst_27230);

return statearr_27294;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_27279__$1,(22),inst_27232);
} else {
if((state_val_27280 === (31))){
var inst_27261 = (state_27279[(2)]);
var state_27279__$1 = state_27279;
if(cljs.core.truth_(inst_27261)){
var statearr_27295_27351 = state_27279__$1;
(statearr_27295_27351[(1)] = (32));

} else {
var statearr_27296_27352 = state_27279__$1;
(statearr_27296_27352[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (32))){
var inst_27238 = (state_27279[(14)]);
var state_27279__$1 = state_27279;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27279__$1,(35),out,inst_27238);
} else {
if((state_val_27280 === (33))){
var inst_27229 = (state_27279[(12)]);
var inst_27206 = inst_27229;
var state_27279__$1 = (function (){var statearr_27297 = state_27279;
(statearr_27297[(7)] = inst_27206);

return statearr_27297;
})();
var statearr_27298_27353 = state_27279__$1;
(statearr_27298_27353[(2)] = null);

(statearr_27298_27353[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (13))){
var inst_27206 = (state_27279[(7)]);
var inst_27213 = inst_27206.cljs$lang$protocol_mask$partition0$;
var inst_27214 = (inst_27213 & (64));
var inst_27215 = inst_27206.cljs$core$ISeq$;
var inst_27216 = (cljs.core.PROTOCOL_SENTINEL === inst_27215);
var inst_27217 = ((inst_27214) || (inst_27216));
var state_27279__$1 = state_27279;
if(cljs.core.truth_(inst_27217)){
var statearr_27299_27354 = state_27279__$1;
(statearr_27299_27354[(1)] = (16));

} else {
var statearr_27300_27355 = state_27279__$1;
(statearr_27300_27355[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (22))){
var inst_27238 = (state_27279[(14)]);
var inst_27239 = (state_27279[(11)]);
var inst_27237 = (state_27279[(2)]);
var inst_27238__$1 = cljs.core.nth.call(null,inst_27237,(0),null);
var inst_27239__$1 = cljs.core.nth.call(null,inst_27237,(1),null);
var inst_27240 = (inst_27238__$1 == null);
var inst_27241 = cljs.core._EQ_.call(null,inst_27239__$1,change);
var inst_27242 = ((inst_27240) || (inst_27241));
var state_27279__$1 = (function (){var statearr_27301 = state_27279;
(statearr_27301[(14)] = inst_27238__$1);

(statearr_27301[(11)] = inst_27239__$1);

return statearr_27301;
})();
if(cljs.core.truth_(inst_27242)){
var statearr_27302_27356 = state_27279__$1;
(statearr_27302_27356[(1)] = (23));

} else {
var statearr_27303_27357 = state_27279__$1;
(statearr_27303_27357[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (36))){
var inst_27229 = (state_27279[(12)]);
var inst_27206 = inst_27229;
var state_27279__$1 = (function (){var statearr_27304 = state_27279;
(statearr_27304[(7)] = inst_27206);

return statearr_27304;
})();
var statearr_27305_27358 = state_27279__$1;
(statearr_27305_27358[(2)] = null);

(statearr_27305_27358[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (29))){
var inst_27253 = (state_27279[(9)]);
var state_27279__$1 = state_27279;
var statearr_27306_27359 = state_27279__$1;
(statearr_27306_27359[(2)] = inst_27253);

(statearr_27306_27359[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (6))){
var state_27279__$1 = state_27279;
var statearr_27307_27360 = state_27279__$1;
(statearr_27307_27360[(2)] = false);

(statearr_27307_27360[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (28))){
var inst_27249 = (state_27279[(2)]);
var inst_27250 = calc_state.call(null);
var inst_27206 = inst_27250;
var state_27279__$1 = (function (){var statearr_27308 = state_27279;
(statearr_27308[(15)] = inst_27249);

(statearr_27308[(7)] = inst_27206);

return statearr_27308;
})();
var statearr_27309_27361 = state_27279__$1;
(statearr_27309_27361[(2)] = null);

(statearr_27309_27361[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (25))){
var inst_27275 = (state_27279[(2)]);
var state_27279__$1 = state_27279;
var statearr_27310_27362 = state_27279__$1;
(statearr_27310_27362[(2)] = inst_27275);

(statearr_27310_27362[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (34))){
var inst_27273 = (state_27279[(2)]);
var state_27279__$1 = state_27279;
var statearr_27311_27363 = state_27279__$1;
(statearr_27311_27363[(2)] = inst_27273);

(statearr_27311_27363[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (17))){
var state_27279__$1 = state_27279;
var statearr_27312_27364 = state_27279__$1;
(statearr_27312_27364[(2)] = false);

(statearr_27312_27364[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (3))){
var state_27279__$1 = state_27279;
var statearr_27313_27365 = state_27279__$1;
(statearr_27313_27365[(2)] = false);

(statearr_27313_27365[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (12))){
var inst_27277 = (state_27279[(2)]);
var state_27279__$1 = state_27279;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27279__$1,inst_27277);
} else {
if((state_val_27280 === (2))){
var inst_27181 = (state_27279[(8)]);
var inst_27186 = inst_27181.cljs$lang$protocol_mask$partition0$;
var inst_27187 = (inst_27186 & (64));
var inst_27188 = inst_27181.cljs$core$ISeq$;
var inst_27189 = (cljs.core.PROTOCOL_SENTINEL === inst_27188);
var inst_27190 = ((inst_27187) || (inst_27189));
var state_27279__$1 = state_27279;
if(cljs.core.truth_(inst_27190)){
var statearr_27314_27366 = state_27279__$1;
(statearr_27314_27366[(1)] = (5));

} else {
var statearr_27315_27367 = state_27279__$1;
(statearr_27315_27367[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (23))){
var inst_27238 = (state_27279[(14)]);
var inst_27244 = (inst_27238 == null);
var state_27279__$1 = state_27279;
if(cljs.core.truth_(inst_27244)){
var statearr_27316_27368 = state_27279__$1;
(statearr_27316_27368[(1)] = (26));

} else {
var statearr_27317_27369 = state_27279__$1;
(statearr_27317_27369[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (35))){
var inst_27264 = (state_27279[(2)]);
var state_27279__$1 = state_27279;
if(cljs.core.truth_(inst_27264)){
var statearr_27318_27370 = state_27279__$1;
(statearr_27318_27370[(1)] = (36));

} else {
var statearr_27319_27371 = state_27279__$1;
(statearr_27319_27371[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (19))){
var inst_27206 = (state_27279[(7)]);
var inst_27226 = cljs.core.apply.call(null,cljs.core.hash_map,inst_27206);
var state_27279__$1 = state_27279;
var statearr_27320_27372 = state_27279__$1;
(statearr_27320_27372[(2)] = inst_27226);

(statearr_27320_27372[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (11))){
var inst_27206 = (state_27279[(7)]);
var inst_27210 = (inst_27206 == null);
var inst_27211 = cljs.core.not.call(null,inst_27210);
var state_27279__$1 = state_27279;
if(inst_27211){
var statearr_27321_27373 = state_27279__$1;
(statearr_27321_27373[(1)] = (13));

} else {
var statearr_27322_27374 = state_27279__$1;
(statearr_27322_27374[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (9))){
var inst_27181 = (state_27279[(8)]);
var state_27279__$1 = state_27279;
var statearr_27323_27375 = state_27279__$1;
(statearr_27323_27375[(2)] = inst_27181);

(statearr_27323_27375[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (5))){
var state_27279__$1 = state_27279;
var statearr_27324_27376 = state_27279__$1;
(statearr_27324_27376[(2)] = true);

(statearr_27324_27376[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (14))){
var state_27279__$1 = state_27279;
var statearr_27325_27377 = state_27279__$1;
(statearr_27325_27377[(2)] = false);

(statearr_27325_27377[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (26))){
var inst_27239 = (state_27279[(11)]);
var inst_27246 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_27239);
var state_27279__$1 = state_27279;
var statearr_27326_27378 = state_27279__$1;
(statearr_27326_27378[(2)] = inst_27246);

(statearr_27326_27378[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (16))){
var state_27279__$1 = state_27279;
var statearr_27327_27379 = state_27279__$1;
(statearr_27327_27379[(2)] = true);

(statearr_27327_27379[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (38))){
var inst_27269 = (state_27279[(2)]);
var state_27279__$1 = state_27279;
var statearr_27328_27380 = state_27279__$1;
(statearr_27328_27380[(2)] = inst_27269);

(statearr_27328_27380[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (30))){
var inst_27231 = (state_27279[(13)]);
var inst_27230 = (state_27279[(10)]);
var inst_27239 = (state_27279[(11)]);
var inst_27256 = cljs.core.empty_QMARK_.call(null,inst_27230);
var inst_27257 = inst_27231.call(null,inst_27239);
var inst_27258 = cljs.core.not.call(null,inst_27257);
var inst_27259 = ((inst_27256) && (inst_27258));
var state_27279__$1 = state_27279;
var statearr_27329_27381 = state_27279__$1;
(statearr_27329_27381[(2)] = inst_27259);

(statearr_27329_27381[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (10))){
var inst_27181 = (state_27279[(8)]);
var inst_27202 = (state_27279[(2)]);
var inst_27203 = cljs.core.get.call(null,inst_27202,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_27204 = cljs.core.get.call(null,inst_27202,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_27205 = cljs.core.get.call(null,inst_27202,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_27206 = inst_27181;
var state_27279__$1 = (function (){var statearr_27330 = state_27279;
(statearr_27330[(16)] = inst_27203);

(statearr_27330[(17)] = inst_27204);

(statearr_27330[(7)] = inst_27206);

(statearr_27330[(18)] = inst_27205);

return statearr_27330;
})();
var statearr_27331_27382 = state_27279__$1;
(statearr_27331_27382[(2)] = null);

(statearr_27331_27382[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (18))){
var inst_27221 = (state_27279[(2)]);
var state_27279__$1 = state_27279;
var statearr_27332_27383 = state_27279__$1;
(statearr_27332_27383[(2)] = inst_27221);

(statearr_27332_27383[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (37))){
var state_27279__$1 = state_27279;
var statearr_27333_27384 = state_27279__$1;
(statearr_27333_27384[(2)] = null);

(statearr_27333_27384[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27280 === (8))){
var inst_27181 = (state_27279[(8)]);
var inst_27199 = cljs.core.apply.call(null,cljs.core.hash_map,inst_27181);
var state_27279__$1 = state_27279;
var statearr_27334_27385 = state_27279__$1;
(statearr_27334_27385[(2)] = inst_27199);

(statearr_27334_27385[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26280__auto___27339,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__26185__auto__,c__26280__auto___27339,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__26186__auto__ = null;
var cljs$core$async$mix_$_state_machine__26186__auto____0 = (function (){
var statearr_27335 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27335[(0)] = cljs$core$async$mix_$_state_machine__26186__auto__);

(statearr_27335[(1)] = (1));

return statearr_27335;
});
var cljs$core$async$mix_$_state_machine__26186__auto____1 = (function (state_27279){
while(true){
var ret_value__26187__auto__ = (function (){try{while(true){
var result__26188__auto__ = switch__26185__auto__.call(null,state_27279);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26188__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26188__auto__;
}
break;
}
}catch (e27336){if((e27336 instanceof Object)){
var ex__26189__auto__ = e27336;
var statearr_27337_27386 = state_27279;
(statearr_27337_27386[(5)] = ex__26189__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27279);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27336;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26187__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27387 = state_27279;
state_27279 = G__27387;
continue;
} else {
return ret_value__26187__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__26186__auto__ = function(state_27279){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__26186__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__26186__auto____1.call(this,state_27279);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__26186__auto____0;
cljs$core$async$mix_$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__26186__auto____1;
return cljs$core$async$mix_$_state_machine__26186__auto__;
})()
;})(switch__26185__auto__,c__26280__auto___27339,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__26282__auto__ = (function (){var statearr_27338 = f__26281__auto__.call(null);
(statearr_27338[(6)] = c__26280__auto___27339);

return statearr_27338;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26282__auto__);
});})(c__26280__auto___27339,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4347__auto__ = (((p == null))?null:p);
var m__4348__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4347__auto__)]);
if((!((m__4348__auto__ == null)))){
return m__4348__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4348__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4348__auto____$1 == null)))){
return m__4348__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4347__auto__ = (((p == null))?null:p);
var m__4348__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4347__auto__)]);
if((!((m__4348__auto__ == null)))){
return m__4348__auto__.call(null,p,v,ch);
} else {
var m__4348__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4348__auto____$1 == null)))){
return m__4348__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__27389 = arguments.length;
switch (G__27389) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4347__auto__ = (((p == null))?null:p);
var m__4348__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4347__auto__)]);
if((!((m__4348__auto__ == null)))){
return m__4348__auto__.call(null,p);
} else {
var m__4348__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4348__auto____$1 == null)))){
return m__4348__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4347__auto__ = (((p == null))?null:p);
var m__4348__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4347__auto__)]);
if((!((m__4348__auto__ == null)))){
return m__4348__auto__.call(null,p,v);
} else {
var m__4348__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4348__auto____$1 == null)))){
return m__4348__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__27393 = arguments.length;
switch (G__27393) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4047__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4047__auto__)){
return or__4047__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4047__auto__,mults){
return (function (p1__27391_SHARP_){
if(cljs.core.truth_(p1__27391_SHARP_.call(null,topic))){
return p1__27391_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__27391_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4047__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async27394 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27394 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta27395){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta27395 = meta27395;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async27394.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_27396,meta27395__$1){
var self__ = this;
var _27396__$1 = this;
return (new cljs.core.async.t_cljs$core$async27394(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta27395__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async27394.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_27396){
var self__ = this;
var _27396__$1 = this;
return self__.meta27395;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async27394.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27394.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async27394.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27394.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async27394.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5457__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5457__auto__)){
var m = temp__5457__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async27394.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async27394.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async27394.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta27395","meta27395",-688411056,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async27394.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async27394.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27394";

cljs.core.async.t_cljs$core$async27394.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4290__auto__,writer__4291__auto__,opt__4292__auto__){
return cljs.core._write.call(null,writer__4291__auto__,"cljs.core.async/t_cljs$core$async27394");
});})(mults,ensure_mult))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async27394.
 */
cljs.core.async.__GT_t_cljs$core$async27394 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async27394(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta27395){
return (new cljs.core.async.t_cljs$core$async27394(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta27395));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async27394(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__26280__auto___27514 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26280__auto___27514,mults,ensure_mult,p){
return (function (){
var f__26281__auto__ = (function (){var switch__26185__auto__ = ((function (c__26280__auto___27514,mults,ensure_mult,p){
return (function (state_27468){
var state_val_27469 = (state_27468[(1)]);
if((state_val_27469 === (7))){
var inst_27464 = (state_27468[(2)]);
var state_27468__$1 = state_27468;
var statearr_27470_27515 = state_27468__$1;
(statearr_27470_27515[(2)] = inst_27464);

(statearr_27470_27515[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27469 === (20))){
var state_27468__$1 = state_27468;
var statearr_27471_27516 = state_27468__$1;
(statearr_27471_27516[(2)] = null);

(statearr_27471_27516[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27469 === (1))){
var state_27468__$1 = state_27468;
var statearr_27472_27517 = state_27468__$1;
(statearr_27472_27517[(2)] = null);

(statearr_27472_27517[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27469 === (24))){
var inst_27447 = (state_27468[(7)]);
var inst_27456 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_27447);
var state_27468__$1 = state_27468;
var statearr_27473_27518 = state_27468__$1;
(statearr_27473_27518[(2)] = inst_27456);

(statearr_27473_27518[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27469 === (4))){
var inst_27399 = (state_27468[(8)]);
var inst_27399__$1 = (state_27468[(2)]);
var inst_27400 = (inst_27399__$1 == null);
var state_27468__$1 = (function (){var statearr_27474 = state_27468;
(statearr_27474[(8)] = inst_27399__$1);

return statearr_27474;
})();
if(cljs.core.truth_(inst_27400)){
var statearr_27475_27519 = state_27468__$1;
(statearr_27475_27519[(1)] = (5));

} else {
var statearr_27476_27520 = state_27468__$1;
(statearr_27476_27520[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27469 === (15))){
var inst_27441 = (state_27468[(2)]);
var state_27468__$1 = state_27468;
var statearr_27477_27521 = state_27468__$1;
(statearr_27477_27521[(2)] = inst_27441);

(statearr_27477_27521[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27469 === (21))){
var inst_27461 = (state_27468[(2)]);
var state_27468__$1 = (function (){var statearr_27478 = state_27468;
(statearr_27478[(9)] = inst_27461);

return statearr_27478;
})();
var statearr_27479_27522 = state_27468__$1;
(statearr_27479_27522[(2)] = null);

(statearr_27479_27522[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27469 === (13))){
var inst_27423 = (state_27468[(10)]);
var inst_27425 = cljs.core.chunked_seq_QMARK_.call(null,inst_27423);
var state_27468__$1 = state_27468;
if(inst_27425){
var statearr_27480_27523 = state_27468__$1;
(statearr_27480_27523[(1)] = (16));

} else {
var statearr_27481_27524 = state_27468__$1;
(statearr_27481_27524[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27469 === (22))){
var inst_27453 = (state_27468[(2)]);
var state_27468__$1 = state_27468;
if(cljs.core.truth_(inst_27453)){
var statearr_27482_27525 = state_27468__$1;
(statearr_27482_27525[(1)] = (23));

} else {
var statearr_27483_27526 = state_27468__$1;
(statearr_27483_27526[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27469 === (6))){
var inst_27449 = (state_27468[(11)]);
var inst_27399 = (state_27468[(8)]);
var inst_27447 = (state_27468[(7)]);
var inst_27447__$1 = topic_fn.call(null,inst_27399);
var inst_27448 = cljs.core.deref.call(null,mults);
var inst_27449__$1 = cljs.core.get.call(null,inst_27448,inst_27447__$1);
var state_27468__$1 = (function (){var statearr_27484 = state_27468;
(statearr_27484[(11)] = inst_27449__$1);

(statearr_27484[(7)] = inst_27447__$1);

return statearr_27484;
})();
if(cljs.core.truth_(inst_27449__$1)){
var statearr_27485_27527 = state_27468__$1;
(statearr_27485_27527[(1)] = (19));

} else {
var statearr_27486_27528 = state_27468__$1;
(statearr_27486_27528[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27469 === (25))){
var inst_27458 = (state_27468[(2)]);
var state_27468__$1 = state_27468;
var statearr_27487_27529 = state_27468__$1;
(statearr_27487_27529[(2)] = inst_27458);

(statearr_27487_27529[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27469 === (17))){
var inst_27423 = (state_27468[(10)]);
var inst_27432 = cljs.core.first.call(null,inst_27423);
var inst_27433 = cljs.core.async.muxch_STAR_.call(null,inst_27432);
var inst_27434 = cljs.core.async.close_BANG_.call(null,inst_27433);
var inst_27435 = cljs.core.next.call(null,inst_27423);
var inst_27409 = inst_27435;
var inst_27410 = null;
var inst_27411 = (0);
var inst_27412 = (0);
var state_27468__$1 = (function (){var statearr_27488 = state_27468;
(statearr_27488[(12)] = inst_27411);

(statearr_27488[(13)] = inst_27410);

(statearr_27488[(14)] = inst_27434);

(statearr_27488[(15)] = inst_27409);

(statearr_27488[(16)] = inst_27412);

return statearr_27488;
})();
var statearr_27489_27530 = state_27468__$1;
(statearr_27489_27530[(2)] = null);

(statearr_27489_27530[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27469 === (3))){
var inst_27466 = (state_27468[(2)]);
var state_27468__$1 = state_27468;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27468__$1,inst_27466);
} else {
if((state_val_27469 === (12))){
var inst_27443 = (state_27468[(2)]);
var state_27468__$1 = state_27468;
var statearr_27490_27531 = state_27468__$1;
(statearr_27490_27531[(2)] = inst_27443);

(statearr_27490_27531[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27469 === (2))){
var state_27468__$1 = state_27468;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27468__$1,(4),ch);
} else {
if((state_val_27469 === (23))){
var state_27468__$1 = state_27468;
var statearr_27491_27532 = state_27468__$1;
(statearr_27491_27532[(2)] = null);

(statearr_27491_27532[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27469 === (19))){
var inst_27449 = (state_27468[(11)]);
var inst_27399 = (state_27468[(8)]);
var inst_27451 = cljs.core.async.muxch_STAR_.call(null,inst_27449);
var state_27468__$1 = state_27468;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27468__$1,(22),inst_27451,inst_27399);
} else {
if((state_val_27469 === (11))){
var inst_27423 = (state_27468[(10)]);
var inst_27409 = (state_27468[(15)]);
var inst_27423__$1 = cljs.core.seq.call(null,inst_27409);
var state_27468__$1 = (function (){var statearr_27492 = state_27468;
(statearr_27492[(10)] = inst_27423__$1);

return statearr_27492;
})();
if(inst_27423__$1){
var statearr_27493_27533 = state_27468__$1;
(statearr_27493_27533[(1)] = (13));

} else {
var statearr_27494_27534 = state_27468__$1;
(statearr_27494_27534[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27469 === (9))){
var inst_27445 = (state_27468[(2)]);
var state_27468__$1 = state_27468;
var statearr_27495_27535 = state_27468__$1;
(statearr_27495_27535[(2)] = inst_27445);

(statearr_27495_27535[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27469 === (5))){
var inst_27406 = cljs.core.deref.call(null,mults);
var inst_27407 = cljs.core.vals.call(null,inst_27406);
var inst_27408 = cljs.core.seq.call(null,inst_27407);
var inst_27409 = inst_27408;
var inst_27410 = null;
var inst_27411 = (0);
var inst_27412 = (0);
var state_27468__$1 = (function (){var statearr_27496 = state_27468;
(statearr_27496[(12)] = inst_27411);

(statearr_27496[(13)] = inst_27410);

(statearr_27496[(15)] = inst_27409);

(statearr_27496[(16)] = inst_27412);

return statearr_27496;
})();
var statearr_27497_27536 = state_27468__$1;
(statearr_27497_27536[(2)] = null);

(statearr_27497_27536[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27469 === (14))){
var state_27468__$1 = state_27468;
var statearr_27501_27537 = state_27468__$1;
(statearr_27501_27537[(2)] = null);

(statearr_27501_27537[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27469 === (16))){
var inst_27423 = (state_27468[(10)]);
var inst_27427 = cljs.core.chunk_first.call(null,inst_27423);
var inst_27428 = cljs.core.chunk_rest.call(null,inst_27423);
var inst_27429 = cljs.core.count.call(null,inst_27427);
var inst_27409 = inst_27428;
var inst_27410 = inst_27427;
var inst_27411 = inst_27429;
var inst_27412 = (0);
var state_27468__$1 = (function (){var statearr_27502 = state_27468;
(statearr_27502[(12)] = inst_27411);

(statearr_27502[(13)] = inst_27410);

(statearr_27502[(15)] = inst_27409);

(statearr_27502[(16)] = inst_27412);

return statearr_27502;
})();
var statearr_27503_27538 = state_27468__$1;
(statearr_27503_27538[(2)] = null);

(statearr_27503_27538[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27469 === (10))){
var inst_27411 = (state_27468[(12)]);
var inst_27410 = (state_27468[(13)]);
var inst_27409 = (state_27468[(15)]);
var inst_27412 = (state_27468[(16)]);
var inst_27417 = cljs.core._nth.call(null,inst_27410,inst_27412);
var inst_27418 = cljs.core.async.muxch_STAR_.call(null,inst_27417);
var inst_27419 = cljs.core.async.close_BANG_.call(null,inst_27418);
var inst_27420 = (inst_27412 + (1));
var tmp27498 = inst_27411;
var tmp27499 = inst_27410;
var tmp27500 = inst_27409;
var inst_27409__$1 = tmp27500;
var inst_27410__$1 = tmp27499;
var inst_27411__$1 = tmp27498;
var inst_27412__$1 = inst_27420;
var state_27468__$1 = (function (){var statearr_27504 = state_27468;
(statearr_27504[(12)] = inst_27411__$1);

(statearr_27504[(13)] = inst_27410__$1);

(statearr_27504[(15)] = inst_27409__$1);

(statearr_27504[(16)] = inst_27412__$1);

(statearr_27504[(17)] = inst_27419);

return statearr_27504;
})();
var statearr_27505_27539 = state_27468__$1;
(statearr_27505_27539[(2)] = null);

(statearr_27505_27539[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27469 === (18))){
var inst_27438 = (state_27468[(2)]);
var state_27468__$1 = state_27468;
var statearr_27506_27540 = state_27468__$1;
(statearr_27506_27540[(2)] = inst_27438);

(statearr_27506_27540[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27469 === (8))){
var inst_27411 = (state_27468[(12)]);
var inst_27412 = (state_27468[(16)]);
var inst_27414 = (inst_27412 < inst_27411);
var inst_27415 = inst_27414;
var state_27468__$1 = state_27468;
if(cljs.core.truth_(inst_27415)){
var statearr_27507_27541 = state_27468__$1;
(statearr_27507_27541[(1)] = (10));

} else {
var statearr_27508_27542 = state_27468__$1;
(statearr_27508_27542[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26280__auto___27514,mults,ensure_mult,p))
;
return ((function (switch__26185__auto__,c__26280__auto___27514,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__26186__auto__ = null;
var cljs$core$async$state_machine__26186__auto____0 = (function (){
var statearr_27509 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27509[(0)] = cljs$core$async$state_machine__26186__auto__);

(statearr_27509[(1)] = (1));

return statearr_27509;
});
var cljs$core$async$state_machine__26186__auto____1 = (function (state_27468){
while(true){
var ret_value__26187__auto__ = (function (){try{while(true){
var result__26188__auto__ = switch__26185__auto__.call(null,state_27468);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26188__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26188__auto__;
}
break;
}
}catch (e27510){if((e27510 instanceof Object)){
var ex__26189__auto__ = e27510;
var statearr_27511_27543 = state_27468;
(statearr_27511_27543[(5)] = ex__26189__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27468);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27510;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26187__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27544 = state_27468;
state_27468 = G__27544;
continue;
} else {
return ret_value__26187__auto__;
}
break;
}
});
cljs$core$async$state_machine__26186__auto__ = function(state_27468){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26186__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26186__auto____1.call(this,state_27468);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26186__auto____0;
cljs$core$async$state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26186__auto____1;
return cljs$core$async$state_machine__26186__auto__;
})()
;})(switch__26185__auto__,c__26280__auto___27514,mults,ensure_mult,p))
})();
var state__26282__auto__ = (function (){var statearr_27512 = f__26281__auto__.call(null);
(statearr_27512[(6)] = c__26280__auto___27514);

return statearr_27512;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26282__auto__);
});})(c__26280__auto___27514,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__27546 = arguments.length;
switch (G__27546) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__27549 = arguments.length;
switch (G__27549) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__27552 = arguments.length;
switch (G__27552) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__26280__auto___27619 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26280__auto___27619,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__26281__auto__ = (function (){var switch__26185__auto__ = ((function (c__26280__auto___27619,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_27591){
var state_val_27592 = (state_27591[(1)]);
if((state_val_27592 === (7))){
var state_27591__$1 = state_27591;
var statearr_27593_27620 = state_27591__$1;
(statearr_27593_27620[(2)] = null);

(statearr_27593_27620[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27592 === (1))){
var state_27591__$1 = state_27591;
var statearr_27594_27621 = state_27591__$1;
(statearr_27594_27621[(2)] = null);

(statearr_27594_27621[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27592 === (4))){
var inst_27555 = (state_27591[(7)]);
var inst_27557 = (inst_27555 < cnt);
var state_27591__$1 = state_27591;
if(cljs.core.truth_(inst_27557)){
var statearr_27595_27622 = state_27591__$1;
(statearr_27595_27622[(1)] = (6));

} else {
var statearr_27596_27623 = state_27591__$1;
(statearr_27596_27623[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27592 === (15))){
var inst_27587 = (state_27591[(2)]);
var state_27591__$1 = state_27591;
var statearr_27597_27624 = state_27591__$1;
(statearr_27597_27624[(2)] = inst_27587);

(statearr_27597_27624[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27592 === (13))){
var inst_27580 = cljs.core.async.close_BANG_.call(null,out);
var state_27591__$1 = state_27591;
var statearr_27598_27625 = state_27591__$1;
(statearr_27598_27625[(2)] = inst_27580);

(statearr_27598_27625[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27592 === (6))){
var state_27591__$1 = state_27591;
var statearr_27599_27626 = state_27591__$1;
(statearr_27599_27626[(2)] = null);

(statearr_27599_27626[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27592 === (3))){
var inst_27589 = (state_27591[(2)]);
var state_27591__$1 = state_27591;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27591__$1,inst_27589);
} else {
if((state_val_27592 === (12))){
var inst_27577 = (state_27591[(8)]);
var inst_27577__$1 = (state_27591[(2)]);
var inst_27578 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_27577__$1);
var state_27591__$1 = (function (){var statearr_27600 = state_27591;
(statearr_27600[(8)] = inst_27577__$1);

return statearr_27600;
})();
if(cljs.core.truth_(inst_27578)){
var statearr_27601_27627 = state_27591__$1;
(statearr_27601_27627[(1)] = (13));

} else {
var statearr_27602_27628 = state_27591__$1;
(statearr_27602_27628[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27592 === (2))){
var inst_27554 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_27555 = (0);
var state_27591__$1 = (function (){var statearr_27603 = state_27591;
(statearr_27603[(7)] = inst_27555);

(statearr_27603[(9)] = inst_27554);

return statearr_27603;
})();
var statearr_27604_27629 = state_27591__$1;
(statearr_27604_27629[(2)] = null);

(statearr_27604_27629[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27592 === (11))){
var inst_27555 = (state_27591[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_27591,(10),Object,null,(9));
var inst_27564 = chs__$1.call(null,inst_27555);
var inst_27565 = done.call(null,inst_27555);
var inst_27566 = cljs.core.async.take_BANG_.call(null,inst_27564,inst_27565);
var state_27591__$1 = state_27591;
var statearr_27605_27630 = state_27591__$1;
(statearr_27605_27630[(2)] = inst_27566);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27591__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27592 === (9))){
var inst_27555 = (state_27591[(7)]);
var inst_27568 = (state_27591[(2)]);
var inst_27569 = (inst_27555 + (1));
var inst_27555__$1 = inst_27569;
var state_27591__$1 = (function (){var statearr_27606 = state_27591;
(statearr_27606[(7)] = inst_27555__$1);

(statearr_27606[(10)] = inst_27568);

return statearr_27606;
})();
var statearr_27607_27631 = state_27591__$1;
(statearr_27607_27631[(2)] = null);

(statearr_27607_27631[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27592 === (5))){
var inst_27575 = (state_27591[(2)]);
var state_27591__$1 = (function (){var statearr_27608 = state_27591;
(statearr_27608[(11)] = inst_27575);

return statearr_27608;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27591__$1,(12),dchan);
} else {
if((state_val_27592 === (14))){
var inst_27577 = (state_27591[(8)]);
var inst_27582 = cljs.core.apply.call(null,f,inst_27577);
var state_27591__$1 = state_27591;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27591__$1,(16),out,inst_27582);
} else {
if((state_val_27592 === (16))){
var inst_27584 = (state_27591[(2)]);
var state_27591__$1 = (function (){var statearr_27609 = state_27591;
(statearr_27609[(12)] = inst_27584);

return statearr_27609;
})();
var statearr_27610_27632 = state_27591__$1;
(statearr_27610_27632[(2)] = null);

(statearr_27610_27632[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27592 === (10))){
var inst_27559 = (state_27591[(2)]);
var inst_27560 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_27591__$1 = (function (){var statearr_27611 = state_27591;
(statearr_27611[(13)] = inst_27559);

return statearr_27611;
})();
var statearr_27612_27633 = state_27591__$1;
(statearr_27612_27633[(2)] = inst_27560);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27591__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27592 === (8))){
var inst_27573 = (state_27591[(2)]);
var state_27591__$1 = state_27591;
var statearr_27613_27634 = state_27591__$1;
(statearr_27613_27634[(2)] = inst_27573);

(statearr_27613_27634[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26280__auto___27619,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__26185__auto__,c__26280__auto___27619,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__26186__auto__ = null;
var cljs$core$async$state_machine__26186__auto____0 = (function (){
var statearr_27614 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27614[(0)] = cljs$core$async$state_machine__26186__auto__);

(statearr_27614[(1)] = (1));

return statearr_27614;
});
var cljs$core$async$state_machine__26186__auto____1 = (function (state_27591){
while(true){
var ret_value__26187__auto__ = (function (){try{while(true){
var result__26188__auto__ = switch__26185__auto__.call(null,state_27591);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26188__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26188__auto__;
}
break;
}
}catch (e27615){if((e27615 instanceof Object)){
var ex__26189__auto__ = e27615;
var statearr_27616_27635 = state_27591;
(statearr_27616_27635[(5)] = ex__26189__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27591);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27615;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26187__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27636 = state_27591;
state_27591 = G__27636;
continue;
} else {
return ret_value__26187__auto__;
}
break;
}
});
cljs$core$async$state_machine__26186__auto__ = function(state_27591){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26186__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26186__auto____1.call(this,state_27591);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26186__auto____0;
cljs$core$async$state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26186__auto____1;
return cljs$core$async$state_machine__26186__auto__;
})()
;})(switch__26185__auto__,c__26280__auto___27619,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__26282__auto__ = (function (){var statearr_27617 = f__26281__auto__.call(null);
(statearr_27617[(6)] = c__26280__auto___27619);

return statearr_27617;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26282__auto__);
});})(c__26280__auto___27619,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__27639 = arguments.length;
switch (G__27639) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__26280__auto___27693 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26280__auto___27693,out){
return (function (){
var f__26281__auto__ = (function (){var switch__26185__auto__ = ((function (c__26280__auto___27693,out){
return (function (state_27671){
var state_val_27672 = (state_27671[(1)]);
if((state_val_27672 === (7))){
var inst_27651 = (state_27671[(7)]);
var inst_27650 = (state_27671[(8)]);
var inst_27650__$1 = (state_27671[(2)]);
var inst_27651__$1 = cljs.core.nth.call(null,inst_27650__$1,(0),null);
var inst_27652 = cljs.core.nth.call(null,inst_27650__$1,(1),null);
var inst_27653 = (inst_27651__$1 == null);
var state_27671__$1 = (function (){var statearr_27673 = state_27671;
(statearr_27673[(7)] = inst_27651__$1);

(statearr_27673[(9)] = inst_27652);

(statearr_27673[(8)] = inst_27650__$1);

return statearr_27673;
})();
if(cljs.core.truth_(inst_27653)){
var statearr_27674_27694 = state_27671__$1;
(statearr_27674_27694[(1)] = (8));

} else {
var statearr_27675_27695 = state_27671__$1;
(statearr_27675_27695[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27672 === (1))){
var inst_27640 = cljs.core.vec.call(null,chs);
var inst_27641 = inst_27640;
var state_27671__$1 = (function (){var statearr_27676 = state_27671;
(statearr_27676[(10)] = inst_27641);

return statearr_27676;
})();
var statearr_27677_27696 = state_27671__$1;
(statearr_27677_27696[(2)] = null);

(statearr_27677_27696[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27672 === (4))){
var inst_27641 = (state_27671[(10)]);
var state_27671__$1 = state_27671;
return cljs.core.async.ioc_alts_BANG_.call(null,state_27671__$1,(7),inst_27641);
} else {
if((state_val_27672 === (6))){
var inst_27667 = (state_27671[(2)]);
var state_27671__$1 = state_27671;
var statearr_27678_27697 = state_27671__$1;
(statearr_27678_27697[(2)] = inst_27667);

(statearr_27678_27697[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27672 === (3))){
var inst_27669 = (state_27671[(2)]);
var state_27671__$1 = state_27671;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27671__$1,inst_27669);
} else {
if((state_val_27672 === (2))){
var inst_27641 = (state_27671[(10)]);
var inst_27643 = cljs.core.count.call(null,inst_27641);
var inst_27644 = (inst_27643 > (0));
var state_27671__$1 = state_27671;
if(cljs.core.truth_(inst_27644)){
var statearr_27680_27698 = state_27671__$1;
(statearr_27680_27698[(1)] = (4));

} else {
var statearr_27681_27699 = state_27671__$1;
(statearr_27681_27699[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27672 === (11))){
var inst_27641 = (state_27671[(10)]);
var inst_27660 = (state_27671[(2)]);
var tmp27679 = inst_27641;
var inst_27641__$1 = tmp27679;
var state_27671__$1 = (function (){var statearr_27682 = state_27671;
(statearr_27682[(10)] = inst_27641__$1);

(statearr_27682[(11)] = inst_27660);

return statearr_27682;
})();
var statearr_27683_27700 = state_27671__$1;
(statearr_27683_27700[(2)] = null);

(statearr_27683_27700[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27672 === (9))){
var inst_27651 = (state_27671[(7)]);
var state_27671__$1 = state_27671;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27671__$1,(11),out,inst_27651);
} else {
if((state_val_27672 === (5))){
var inst_27665 = cljs.core.async.close_BANG_.call(null,out);
var state_27671__$1 = state_27671;
var statearr_27684_27701 = state_27671__$1;
(statearr_27684_27701[(2)] = inst_27665);

(statearr_27684_27701[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27672 === (10))){
var inst_27663 = (state_27671[(2)]);
var state_27671__$1 = state_27671;
var statearr_27685_27702 = state_27671__$1;
(statearr_27685_27702[(2)] = inst_27663);

(statearr_27685_27702[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27672 === (8))){
var inst_27651 = (state_27671[(7)]);
var inst_27652 = (state_27671[(9)]);
var inst_27650 = (state_27671[(8)]);
var inst_27641 = (state_27671[(10)]);
var inst_27655 = (function (){var cs = inst_27641;
var vec__27646 = inst_27650;
var v = inst_27651;
var c = inst_27652;
return ((function (cs,vec__27646,v,c,inst_27651,inst_27652,inst_27650,inst_27641,state_val_27672,c__26280__auto___27693,out){
return (function (p1__27637_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__27637_SHARP_);
});
;})(cs,vec__27646,v,c,inst_27651,inst_27652,inst_27650,inst_27641,state_val_27672,c__26280__auto___27693,out))
})();
var inst_27656 = cljs.core.filterv.call(null,inst_27655,inst_27641);
var inst_27641__$1 = inst_27656;
var state_27671__$1 = (function (){var statearr_27686 = state_27671;
(statearr_27686[(10)] = inst_27641__$1);

return statearr_27686;
})();
var statearr_27687_27703 = state_27671__$1;
(statearr_27687_27703[(2)] = null);

(statearr_27687_27703[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__26280__auto___27693,out))
;
return ((function (switch__26185__auto__,c__26280__auto___27693,out){
return (function() {
var cljs$core$async$state_machine__26186__auto__ = null;
var cljs$core$async$state_machine__26186__auto____0 = (function (){
var statearr_27688 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27688[(0)] = cljs$core$async$state_machine__26186__auto__);

(statearr_27688[(1)] = (1));

return statearr_27688;
});
var cljs$core$async$state_machine__26186__auto____1 = (function (state_27671){
while(true){
var ret_value__26187__auto__ = (function (){try{while(true){
var result__26188__auto__ = switch__26185__auto__.call(null,state_27671);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26188__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26188__auto__;
}
break;
}
}catch (e27689){if((e27689 instanceof Object)){
var ex__26189__auto__ = e27689;
var statearr_27690_27704 = state_27671;
(statearr_27690_27704[(5)] = ex__26189__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27671);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27689;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26187__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27705 = state_27671;
state_27671 = G__27705;
continue;
} else {
return ret_value__26187__auto__;
}
break;
}
});
cljs$core$async$state_machine__26186__auto__ = function(state_27671){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26186__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26186__auto____1.call(this,state_27671);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26186__auto____0;
cljs$core$async$state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26186__auto____1;
return cljs$core$async$state_machine__26186__auto__;
})()
;})(switch__26185__auto__,c__26280__auto___27693,out))
})();
var state__26282__auto__ = (function (){var statearr_27691 = f__26281__auto__.call(null);
(statearr_27691[(6)] = c__26280__auto___27693);

return statearr_27691;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26282__auto__);
});})(c__26280__auto___27693,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__27707 = arguments.length;
switch (G__27707) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__26280__auto___27752 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26280__auto___27752,out){
return (function (){
var f__26281__auto__ = (function (){var switch__26185__auto__ = ((function (c__26280__auto___27752,out){
return (function (state_27731){
var state_val_27732 = (state_27731[(1)]);
if((state_val_27732 === (7))){
var inst_27713 = (state_27731[(7)]);
var inst_27713__$1 = (state_27731[(2)]);
var inst_27714 = (inst_27713__$1 == null);
var inst_27715 = cljs.core.not.call(null,inst_27714);
var state_27731__$1 = (function (){var statearr_27733 = state_27731;
(statearr_27733[(7)] = inst_27713__$1);

return statearr_27733;
})();
if(inst_27715){
var statearr_27734_27753 = state_27731__$1;
(statearr_27734_27753[(1)] = (8));

} else {
var statearr_27735_27754 = state_27731__$1;
(statearr_27735_27754[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27732 === (1))){
var inst_27708 = (0);
var state_27731__$1 = (function (){var statearr_27736 = state_27731;
(statearr_27736[(8)] = inst_27708);

return statearr_27736;
})();
var statearr_27737_27755 = state_27731__$1;
(statearr_27737_27755[(2)] = null);

(statearr_27737_27755[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27732 === (4))){
var state_27731__$1 = state_27731;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27731__$1,(7),ch);
} else {
if((state_val_27732 === (6))){
var inst_27726 = (state_27731[(2)]);
var state_27731__$1 = state_27731;
var statearr_27738_27756 = state_27731__$1;
(statearr_27738_27756[(2)] = inst_27726);

(statearr_27738_27756[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27732 === (3))){
var inst_27728 = (state_27731[(2)]);
var inst_27729 = cljs.core.async.close_BANG_.call(null,out);
var state_27731__$1 = (function (){var statearr_27739 = state_27731;
(statearr_27739[(9)] = inst_27728);

return statearr_27739;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27731__$1,inst_27729);
} else {
if((state_val_27732 === (2))){
var inst_27708 = (state_27731[(8)]);
var inst_27710 = (inst_27708 < n);
var state_27731__$1 = state_27731;
if(cljs.core.truth_(inst_27710)){
var statearr_27740_27757 = state_27731__$1;
(statearr_27740_27757[(1)] = (4));

} else {
var statearr_27741_27758 = state_27731__$1;
(statearr_27741_27758[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27732 === (11))){
var inst_27708 = (state_27731[(8)]);
var inst_27718 = (state_27731[(2)]);
var inst_27719 = (inst_27708 + (1));
var inst_27708__$1 = inst_27719;
var state_27731__$1 = (function (){var statearr_27742 = state_27731;
(statearr_27742[(8)] = inst_27708__$1);

(statearr_27742[(10)] = inst_27718);

return statearr_27742;
})();
var statearr_27743_27759 = state_27731__$1;
(statearr_27743_27759[(2)] = null);

(statearr_27743_27759[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27732 === (9))){
var state_27731__$1 = state_27731;
var statearr_27744_27760 = state_27731__$1;
(statearr_27744_27760[(2)] = null);

(statearr_27744_27760[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27732 === (5))){
var state_27731__$1 = state_27731;
var statearr_27745_27761 = state_27731__$1;
(statearr_27745_27761[(2)] = null);

(statearr_27745_27761[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27732 === (10))){
var inst_27723 = (state_27731[(2)]);
var state_27731__$1 = state_27731;
var statearr_27746_27762 = state_27731__$1;
(statearr_27746_27762[(2)] = inst_27723);

(statearr_27746_27762[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27732 === (8))){
var inst_27713 = (state_27731[(7)]);
var state_27731__$1 = state_27731;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27731__$1,(11),out,inst_27713);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__26280__auto___27752,out))
;
return ((function (switch__26185__auto__,c__26280__auto___27752,out){
return (function() {
var cljs$core$async$state_machine__26186__auto__ = null;
var cljs$core$async$state_machine__26186__auto____0 = (function (){
var statearr_27747 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27747[(0)] = cljs$core$async$state_machine__26186__auto__);

(statearr_27747[(1)] = (1));

return statearr_27747;
});
var cljs$core$async$state_machine__26186__auto____1 = (function (state_27731){
while(true){
var ret_value__26187__auto__ = (function (){try{while(true){
var result__26188__auto__ = switch__26185__auto__.call(null,state_27731);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26188__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26188__auto__;
}
break;
}
}catch (e27748){if((e27748 instanceof Object)){
var ex__26189__auto__ = e27748;
var statearr_27749_27763 = state_27731;
(statearr_27749_27763[(5)] = ex__26189__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27731);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27748;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26187__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27764 = state_27731;
state_27731 = G__27764;
continue;
} else {
return ret_value__26187__auto__;
}
break;
}
});
cljs$core$async$state_machine__26186__auto__ = function(state_27731){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26186__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26186__auto____1.call(this,state_27731);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26186__auto____0;
cljs$core$async$state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26186__auto____1;
return cljs$core$async$state_machine__26186__auto__;
})()
;})(switch__26185__auto__,c__26280__auto___27752,out))
})();
var state__26282__auto__ = (function (){var statearr_27750 = f__26281__auto__.call(null);
(statearr_27750[(6)] = c__26280__auto___27752);

return statearr_27750;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26282__auto__);
});})(c__26280__auto___27752,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async27766 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27766 = (function (f,ch,meta27767){
this.f = f;
this.ch = ch;
this.meta27767 = meta27767;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async27766.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_27768,meta27767__$1){
var self__ = this;
var _27768__$1 = this;
return (new cljs.core.async.t_cljs$core$async27766(self__.f,self__.ch,meta27767__$1));
});

cljs.core.async.t_cljs$core$async27766.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_27768){
var self__ = this;
var _27768__$1 = this;
return self__.meta27767;
});

cljs.core.async.t_cljs$core$async27766.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27766.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async27766.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async27766.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27766.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async27769 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27769 = (function (f,ch,meta27767,_,fn1,meta27770){
this.f = f;
this.ch = ch;
this.meta27767 = meta27767;
this._ = _;
this.fn1 = fn1;
this.meta27770 = meta27770;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async27769.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_27771,meta27770__$1){
var self__ = this;
var _27771__$1 = this;
return (new cljs.core.async.t_cljs$core$async27769(self__.f,self__.ch,self__.meta27767,self__._,self__.fn1,meta27770__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async27769.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_27771){
var self__ = this;
var _27771__$1 = this;
return self__.meta27770;
});})(___$1))
;

cljs.core.async.t_cljs$core$async27769.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27769.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async27769.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async27769.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__27765_SHARP_){
return f1.call(null,(((p1__27765_SHARP_ == null))?null:self__.f.call(null,p1__27765_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async27769.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta27767","meta27767",-588235611,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async27766","cljs.core.async/t_cljs$core$async27766",-1803607580,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta27770","meta27770",-818889738,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async27769.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async27769.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27769";

cljs.core.async.t_cljs$core$async27769.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4290__auto__,writer__4291__auto__,opt__4292__auto__){
return cljs.core._write.call(null,writer__4291__auto__,"cljs.core.async/t_cljs$core$async27769");
});})(___$1))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async27769.
 */
cljs.core.async.__GT_t_cljs$core$async27769 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async27769(f__$1,ch__$1,meta27767__$1,___$2,fn1__$1,meta27770){
return (new cljs.core.async.t_cljs$core$async27769(f__$1,ch__$1,meta27767__$1,___$2,fn1__$1,meta27770));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async27769(self__.f,self__.ch,self__.meta27767,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4036__auto__ = ret;
if(cljs.core.truth_(and__4036__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__4036__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async27766.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27766.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async27766.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta27767","meta27767",-588235611,null)], null);
});

cljs.core.async.t_cljs$core$async27766.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async27766.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27766";

cljs.core.async.t_cljs$core$async27766.cljs$lang$ctorPrWriter = (function (this__4290__auto__,writer__4291__auto__,opt__4292__auto__){
return cljs.core._write.call(null,writer__4291__auto__,"cljs.core.async/t_cljs$core$async27766");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async27766.
 */
cljs.core.async.__GT_t_cljs$core$async27766 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async27766(f__$1,ch__$1,meta27767){
return (new cljs.core.async.t_cljs$core$async27766(f__$1,ch__$1,meta27767));
});

}

return (new cljs.core.async.t_cljs$core$async27766(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async27772 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27772 = (function (f,ch,meta27773){
this.f = f;
this.ch = ch;
this.meta27773 = meta27773;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async27772.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_27774,meta27773__$1){
var self__ = this;
var _27774__$1 = this;
return (new cljs.core.async.t_cljs$core$async27772(self__.f,self__.ch,meta27773__$1));
});

cljs.core.async.t_cljs$core$async27772.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_27774){
var self__ = this;
var _27774__$1 = this;
return self__.meta27773;
});

cljs.core.async.t_cljs$core$async27772.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27772.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async27772.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27772.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async27772.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27772.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async27772.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta27773","meta27773",2042291929,null)], null);
});

cljs.core.async.t_cljs$core$async27772.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async27772.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27772";

cljs.core.async.t_cljs$core$async27772.cljs$lang$ctorPrWriter = (function (this__4290__auto__,writer__4291__auto__,opt__4292__auto__){
return cljs.core._write.call(null,writer__4291__auto__,"cljs.core.async/t_cljs$core$async27772");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async27772.
 */
cljs.core.async.__GT_t_cljs$core$async27772 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async27772(f__$1,ch__$1,meta27773){
return (new cljs.core.async.t_cljs$core$async27772(f__$1,ch__$1,meta27773));
});

}

return (new cljs.core.async.t_cljs$core$async27772(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async27775 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27775 = (function (p,ch,meta27776){
this.p = p;
this.ch = ch;
this.meta27776 = meta27776;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async27775.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_27777,meta27776__$1){
var self__ = this;
var _27777__$1 = this;
return (new cljs.core.async.t_cljs$core$async27775(self__.p,self__.ch,meta27776__$1));
});

cljs.core.async.t_cljs$core$async27775.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_27777){
var self__ = this;
var _27777__$1 = this;
return self__.meta27776;
});

cljs.core.async.t_cljs$core$async27775.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27775.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async27775.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async27775.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27775.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async27775.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27775.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async27775.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta27776","meta27776",-1547748407,null)], null);
});

cljs.core.async.t_cljs$core$async27775.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async27775.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27775";

cljs.core.async.t_cljs$core$async27775.cljs$lang$ctorPrWriter = (function (this__4290__auto__,writer__4291__auto__,opt__4292__auto__){
return cljs.core._write.call(null,writer__4291__auto__,"cljs.core.async/t_cljs$core$async27775");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async27775.
 */
cljs.core.async.__GT_t_cljs$core$async27775 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async27775(p__$1,ch__$1,meta27776){
return (new cljs.core.async.t_cljs$core$async27775(p__$1,ch__$1,meta27776));
});

}

return (new cljs.core.async.t_cljs$core$async27775(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__27779 = arguments.length;
switch (G__27779) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__26280__auto___27819 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26280__auto___27819,out){
return (function (){
var f__26281__auto__ = (function (){var switch__26185__auto__ = ((function (c__26280__auto___27819,out){
return (function (state_27800){
var state_val_27801 = (state_27800[(1)]);
if((state_val_27801 === (7))){
var inst_27796 = (state_27800[(2)]);
var state_27800__$1 = state_27800;
var statearr_27802_27820 = state_27800__$1;
(statearr_27802_27820[(2)] = inst_27796);

(statearr_27802_27820[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27801 === (1))){
var state_27800__$1 = state_27800;
var statearr_27803_27821 = state_27800__$1;
(statearr_27803_27821[(2)] = null);

(statearr_27803_27821[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27801 === (4))){
var inst_27782 = (state_27800[(7)]);
var inst_27782__$1 = (state_27800[(2)]);
var inst_27783 = (inst_27782__$1 == null);
var state_27800__$1 = (function (){var statearr_27804 = state_27800;
(statearr_27804[(7)] = inst_27782__$1);

return statearr_27804;
})();
if(cljs.core.truth_(inst_27783)){
var statearr_27805_27822 = state_27800__$1;
(statearr_27805_27822[(1)] = (5));

} else {
var statearr_27806_27823 = state_27800__$1;
(statearr_27806_27823[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27801 === (6))){
var inst_27782 = (state_27800[(7)]);
var inst_27787 = p.call(null,inst_27782);
var state_27800__$1 = state_27800;
if(cljs.core.truth_(inst_27787)){
var statearr_27807_27824 = state_27800__$1;
(statearr_27807_27824[(1)] = (8));

} else {
var statearr_27808_27825 = state_27800__$1;
(statearr_27808_27825[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27801 === (3))){
var inst_27798 = (state_27800[(2)]);
var state_27800__$1 = state_27800;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27800__$1,inst_27798);
} else {
if((state_val_27801 === (2))){
var state_27800__$1 = state_27800;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27800__$1,(4),ch);
} else {
if((state_val_27801 === (11))){
var inst_27790 = (state_27800[(2)]);
var state_27800__$1 = state_27800;
var statearr_27809_27826 = state_27800__$1;
(statearr_27809_27826[(2)] = inst_27790);

(statearr_27809_27826[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27801 === (9))){
var state_27800__$1 = state_27800;
var statearr_27810_27827 = state_27800__$1;
(statearr_27810_27827[(2)] = null);

(statearr_27810_27827[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27801 === (5))){
var inst_27785 = cljs.core.async.close_BANG_.call(null,out);
var state_27800__$1 = state_27800;
var statearr_27811_27828 = state_27800__$1;
(statearr_27811_27828[(2)] = inst_27785);

(statearr_27811_27828[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27801 === (10))){
var inst_27793 = (state_27800[(2)]);
var state_27800__$1 = (function (){var statearr_27812 = state_27800;
(statearr_27812[(8)] = inst_27793);

return statearr_27812;
})();
var statearr_27813_27829 = state_27800__$1;
(statearr_27813_27829[(2)] = null);

(statearr_27813_27829[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27801 === (8))){
var inst_27782 = (state_27800[(7)]);
var state_27800__$1 = state_27800;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27800__$1,(11),out,inst_27782);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__26280__auto___27819,out))
;
return ((function (switch__26185__auto__,c__26280__auto___27819,out){
return (function() {
var cljs$core$async$state_machine__26186__auto__ = null;
var cljs$core$async$state_machine__26186__auto____0 = (function (){
var statearr_27814 = [null,null,null,null,null,null,null,null,null];
(statearr_27814[(0)] = cljs$core$async$state_machine__26186__auto__);

(statearr_27814[(1)] = (1));

return statearr_27814;
});
var cljs$core$async$state_machine__26186__auto____1 = (function (state_27800){
while(true){
var ret_value__26187__auto__ = (function (){try{while(true){
var result__26188__auto__ = switch__26185__auto__.call(null,state_27800);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26188__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26188__auto__;
}
break;
}
}catch (e27815){if((e27815 instanceof Object)){
var ex__26189__auto__ = e27815;
var statearr_27816_27830 = state_27800;
(statearr_27816_27830[(5)] = ex__26189__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27800);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27815;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26187__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27831 = state_27800;
state_27800 = G__27831;
continue;
} else {
return ret_value__26187__auto__;
}
break;
}
});
cljs$core$async$state_machine__26186__auto__ = function(state_27800){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26186__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26186__auto____1.call(this,state_27800);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26186__auto____0;
cljs$core$async$state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26186__auto____1;
return cljs$core$async$state_machine__26186__auto__;
})()
;})(switch__26185__auto__,c__26280__auto___27819,out))
})();
var state__26282__auto__ = (function (){var statearr_27817 = f__26281__auto__.call(null);
(statearr_27817[(6)] = c__26280__auto___27819);

return statearr_27817;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26282__auto__);
});})(c__26280__auto___27819,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__27833 = arguments.length;
switch (G__27833) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__26280__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26280__auto__){
return (function (){
var f__26281__auto__ = (function (){var switch__26185__auto__ = ((function (c__26280__auto__){
return (function (state_27896){
var state_val_27897 = (state_27896[(1)]);
if((state_val_27897 === (7))){
var inst_27892 = (state_27896[(2)]);
var state_27896__$1 = state_27896;
var statearr_27898_27936 = state_27896__$1;
(statearr_27898_27936[(2)] = inst_27892);

(statearr_27898_27936[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27897 === (20))){
var inst_27862 = (state_27896[(7)]);
var inst_27873 = (state_27896[(2)]);
var inst_27874 = cljs.core.next.call(null,inst_27862);
var inst_27848 = inst_27874;
var inst_27849 = null;
var inst_27850 = (0);
var inst_27851 = (0);
var state_27896__$1 = (function (){var statearr_27899 = state_27896;
(statearr_27899[(8)] = inst_27849);

(statearr_27899[(9)] = inst_27851);

(statearr_27899[(10)] = inst_27850);

(statearr_27899[(11)] = inst_27848);

(statearr_27899[(12)] = inst_27873);

return statearr_27899;
})();
var statearr_27900_27937 = state_27896__$1;
(statearr_27900_27937[(2)] = null);

(statearr_27900_27937[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27897 === (1))){
var state_27896__$1 = state_27896;
var statearr_27901_27938 = state_27896__$1;
(statearr_27901_27938[(2)] = null);

(statearr_27901_27938[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27897 === (4))){
var inst_27837 = (state_27896[(13)]);
var inst_27837__$1 = (state_27896[(2)]);
var inst_27838 = (inst_27837__$1 == null);
var state_27896__$1 = (function (){var statearr_27902 = state_27896;
(statearr_27902[(13)] = inst_27837__$1);

return statearr_27902;
})();
if(cljs.core.truth_(inst_27838)){
var statearr_27903_27939 = state_27896__$1;
(statearr_27903_27939[(1)] = (5));

} else {
var statearr_27904_27940 = state_27896__$1;
(statearr_27904_27940[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27897 === (15))){
var state_27896__$1 = state_27896;
var statearr_27908_27941 = state_27896__$1;
(statearr_27908_27941[(2)] = null);

(statearr_27908_27941[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27897 === (21))){
var state_27896__$1 = state_27896;
var statearr_27909_27942 = state_27896__$1;
(statearr_27909_27942[(2)] = null);

(statearr_27909_27942[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27897 === (13))){
var inst_27849 = (state_27896[(8)]);
var inst_27851 = (state_27896[(9)]);
var inst_27850 = (state_27896[(10)]);
var inst_27848 = (state_27896[(11)]);
var inst_27858 = (state_27896[(2)]);
var inst_27859 = (inst_27851 + (1));
var tmp27905 = inst_27849;
var tmp27906 = inst_27850;
var tmp27907 = inst_27848;
var inst_27848__$1 = tmp27907;
var inst_27849__$1 = tmp27905;
var inst_27850__$1 = tmp27906;
var inst_27851__$1 = inst_27859;
var state_27896__$1 = (function (){var statearr_27910 = state_27896;
(statearr_27910[(8)] = inst_27849__$1);

(statearr_27910[(9)] = inst_27851__$1);

(statearr_27910[(10)] = inst_27850__$1);

(statearr_27910[(14)] = inst_27858);

(statearr_27910[(11)] = inst_27848__$1);

return statearr_27910;
})();
var statearr_27911_27943 = state_27896__$1;
(statearr_27911_27943[(2)] = null);

(statearr_27911_27943[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27897 === (22))){
var state_27896__$1 = state_27896;
var statearr_27912_27944 = state_27896__$1;
(statearr_27912_27944[(2)] = null);

(statearr_27912_27944[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27897 === (6))){
var inst_27837 = (state_27896[(13)]);
var inst_27846 = f.call(null,inst_27837);
var inst_27847 = cljs.core.seq.call(null,inst_27846);
var inst_27848 = inst_27847;
var inst_27849 = null;
var inst_27850 = (0);
var inst_27851 = (0);
var state_27896__$1 = (function (){var statearr_27913 = state_27896;
(statearr_27913[(8)] = inst_27849);

(statearr_27913[(9)] = inst_27851);

(statearr_27913[(10)] = inst_27850);

(statearr_27913[(11)] = inst_27848);

return statearr_27913;
})();
var statearr_27914_27945 = state_27896__$1;
(statearr_27914_27945[(2)] = null);

(statearr_27914_27945[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27897 === (17))){
var inst_27862 = (state_27896[(7)]);
var inst_27866 = cljs.core.chunk_first.call(null,inst_27862);
var inst_27867 = cljs.core.chunk_rest.call(null,inst_27862);
var inst_27868 = cljs.core.count.call(null,inst_27866);
var inst_27848 = inst_27867;
var inst_27849 = inst_27866;
var inst_27850 = inst_27868;
var inst_27851 = (0);
var state_27896__$1 = (function (){var statearr_27915 = state_27896;
(statearr_27915[(8)] = inst_27849);

(statearr_27915[(9)] = inst_27851);

(statearr_27915[(10)] = inst_27850);

(statearr_27915[(11)] = inst_27848);

return statearr_27915;
})();
var statearr_27916_27946 = state_27896__$1;
(statearr_27916_27946[(2)] = null);

(statearr_27916_27946[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27897 === (3))){
var inst_27894 = (state_27896[(2)]);
var state_27896__$1 = state_27896;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27896__$1,inst_27894);
} else {
if((state_val_27897 === (12))){
var inst_27882 = (state_27896[(2)]);
var state_27896__$1 = state_27896;
var statearr_27917_27947 = state_27896__$1;
(statearr_27917_27947[(2)] = inst_27882);

(statearr_27917_27947[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27897 === (2))){
var state_27896__$1 = state_27896;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27896__$1,(4),in$);
} else {
if((state_val_27897 === (23))){
var inst_27890 = (state_27896[(2)]);
var state_27896__$1 = state_27896;
var statearr_27918_27948 = state_27896__$1;
(statearr_27918_27948[(2)] = inst_27890);

(statearr_27918_27948[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27897 === (19))){
var inst_27877 = (state_27896[(2)]);
var state_27896__$1 = state_27896;
var statearr_27919_27949 = state_27896__$1;
(statearr_27919_27949[(2)] = inst_27877);

(statearr_27919_27949[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27897 === (11))){
var inst_27848 = (state_27896[(11)]);
var inst_27862 = (state_27896[(7)]);
var inst_27862__$1 = cljs.core.seq.call(null,inst_27848);
var state_27896__$1 = (function (){var statearr_27920 = state_27896;
(statearr_27920[(7)] = inst_27862__$1);

return statearr_27920;
})();
if(inst_27862__$1){
var statearr_27921_27950 = state_27896__$1;
(statearr_27921_27950[(1)] = (14));

} else {
var statearr_27922_27951 = state_27896__$1;
(statearr_27922_27951[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27897 === (9))){
var inst_27884 = (state_27896[(2)]);
var inst_27885 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_27896__$1 = (function (){var statearr_27923 = state_27896;
(statearr_27923[(15)] = inst_27884);

return statearr_27923;
})();
if(cljs.core.truth_(inst_27885)){
var statearr_27924_27952 = state_27896__$1;
(statearr_27924_27952[(1)] = (21));

} else {
var statearr_27925_27953 = state_27896__$1;
(statearr_27925_27953[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27897 === (5))){
var inst_27840 = cljs.core.async.close_BANG_.call(null,out);
var state_27896__$1 = state_27896;
var statearr_27926_27954 = state_27896__$1;
(statearr_27926_27954[(2)] = inst_27840);

(statearr_27926_27954[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27897 === (14))){
var inst_27862 = (state_27896[(7)]);
var inst_27864 = cljs.core.chunked_seq_QMARK_.call(null,inst_27862);
var state_27896__$1 = state_27896;
if(inst_27864){
var statearr_27927_27955 = state_27896__$1;
(statearr_27927_27955[(1)] = (17));

} else {
var statearr_27928_27956 = state_27896__$1;
(statearr_27928_27956[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27897 === (16))){
var inst_27880 = (state_27896[(2)]);
var state_27896__$1 = state_27896;
var statearr_27929_27957 = state_27896__$1;
(statearr_27929_27957[(2)] = inst_27880);

(statearr_27929_27957[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27897 === (10))){
var inst_27849 = (state_27896[(8)]);
var inst_27851 = (state_27896[(9)]);
var inst_27856 = cljs.core._nth.call(null,inst_27849,inst_27851);
var state_27896__$1 = state_27896;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27896__$1,(13),out,inst_27856);
} else {
if((state_val_27897 === (18))){
var inst_27862 = (state_27896[(7)]);
var inst_27871 = cljs.core.first.call(null,inst_27862);
var state_27896__$1 = state_27896;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27896__$1,(20),out,inst_27871);
} else {
if((state_val_27897 === (8))){
var inst_27851 = (state_27896[(9)]);
var inst_27850 = (state_27896[(10)]);
var inst_27853 = (inst_27851 < inst_27850);
var inst_27854 = inst_27853;
var state_27896__$1 = state_27896;
if(cljs.core.truth_(inst_27854)){
var statearr_27930_27958 = state_27896__$1;
(statearr_27930_27958[(1)] = (10));

} else {
var statearr_27931_27959 = state_27896__$1;
(statearr_27931_27959[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26280__auto__))
;
return ((function (switch__26185__auto__,c__26280__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__26186__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__26186__auto____0 = (function (){
var statearr_27932 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27932[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__26186__auto__);

(statearr_27932[(1)] = (1));

return statearr_27932;
});
var cljs$core$async$mapcat_STAR__$_state_machine__26186__auto____1 = (function (state_27896){
while(true){
var ret_value__26187__auto__ = (function (){try{while(true){
var result__26188__auto__ = switch__26185__auto__.call(null,state_27896);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26188__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26188__auto__;
}
break;
}
}catch (e27933){if((e27933 instanceof Object)){
var ex__26189__auto__ = e27933;
var statearr_27934_27960 = state_27896;
(statearr_27934_27960[(5)] = ex__26189__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27896);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27933;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26187__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27961 = state_27896;
state_27896 = G__27961;
continue;
} else {
return ret_value__26187__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__26186__auto__ = function(state_27896){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__26186__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__26186__auto____1.call(this,state_27896);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__26186__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__26186__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__26186__auto__;
})()
;})(switch__26185__auto__,c__26280__auto__))
})();
var state__26282__auto__ = (function (){var statearr_27935 = f__26281__auto__.call(null);
(statearr_27935[(6)] = c__26280__auto__);

return statearr_27935;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26282__auto__);
});})(c__26280__auto__))
);

return c__26280__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__27963 = arguments.length;
switch (G__27963) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__27966 = arguments.length;
switch (G__27966) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__27969 = arguments.length;
switch (G__27969) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__26280__auto___28016 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26280__auto___28016,out){
return (function (){
var f__26281__auto__ = (function (){var switch__26185__auto__ = ((function (c__26280__auto___28016,out){
return (function (state_27993){
var state_val_27994 = (state_27993[(1)]);
if((state_val_27994 === (7))){
var inst_27988 = (state_27993[(2)]);
var state_27993__$1 = state_27993;
var statearr_27995_28017 = state_27993__$1;
(statearr_27995_28017[(2)] = inst_27988);

(statearr_27995_28017[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27994 === (1))){
var inst_27970 = null;
var state_27993__$1 = (function (){var statearr_27996 = state_27993;
(statearr_27996[(7)] = inst_27970);

return statearr_27996;
})();
var statearr_27997_28018 = state_27993__$1;
(statearr_27997_28018[(2)] = null);

(statearr_27997_28018[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27994 === (4))){
var inst_27973 = (state_27993[(8)]);
var inst_27973__$1 = (state_27993[(2)]);
var inst_27974 = (inst_27973__$1 == null);
var inst_27975 = cljs.core.not.call(null,inst_27974);
var state_27993__$1 = (function (){var statearr_27998 = state_27993;
(statearr_27998[(8)] = inst_27973__$1);

return statearr_27998;
})();
if(inst_27975){
var statearr_27999_28019 = state_27993__$1;
(statearr_27999_28019[(1)] = (5));

} else {
var statearr_28000_28020 = state_27993__$1;
(statearr_28000_28020[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27994 === (6))){
var state_27993__$1 = state_27993;
var statearr_28001_28021 = state_27993__$1;
(statearr_28001_28021[(2)] = null);

(statearr_28001_28021[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27994 === (3))){
var inst_27990 = (state_27993[(2)]);
var inst_27991 = cljs.core.async.close_BANG_.call(null,out);
var state_27993__$1 = (function (){var statearr_28002 = state_27993;
(statearr_28002[(9)] = inst_27990);

return statearr_28002;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27993__$1,inst_27991);
} else {
if((state_val_27994 === (2))){
var state_27993__$1 = state_27993;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27993__$1,(4),ch);
} else {
if((state_val_27994 === (11))){
var inst_27973 = (state_27993[(8)]);
var inst_27982 = (state_27993[(2)]);
var inst_27970 = inst_27973;
var state_27993__$1 = (function (){var statearr_28003 = state_27993;
(statearr_28003[(10)] = inst_27982);

(statearr_28003[(7)] = inst_27970);

return statearr_28003;
})();
var statearr_28004_28022 = state_27993__$1;
(statearr_28004_28022[(2)] = null);

(statearr_28004_28022[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27994 === (9))){
var inst_27973 = (state_27993[(8)]);
var state_27993__$1 = state_27993;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27993__$1,(11),out,inst_27973);
} else {
if((state_val_27994 === (5))){
var inst_27973 = (state_27993[(8)]);
var inst_27970 = (state_27993[(7)]);
var inst_27977 = cljs.core._EQ_.call(null,inst_27973,inst_27970);
var state_27993__$1 = state_27993;
if(inst_27977){
var statearr_28006_28023 = state_27993__$1;
(statearr_28006_28023[(1)] = (8));

} else {
var statearr_28007_28024 = state_27993__$1;
(statearr_28007_28024[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27994 === (10))){
var inst_27985 = (state_27993[(2)]);
var state_27993__$1 = state_27993;
var statearr_28008_28025 = state_27993__$1;
(statearr_28008_28025[(2)] = inst_27985);

(statearr_28008_28025[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27994 === (8))){
var inst_27970 = (state_27993[(7)]);
var tmp28005 = inst_27970;
var inst_27970__$1 = tmp28005;
var state_27993__$1 = (function (){var statearr_28009 = state_27993;
(statearr_28009[(7)] = inst_27970__$1);

return statearr_28009;
})();
var statearr_28010_28026 = state_27993__$1;
(statearr_28010_28026[(2)] = null);

(statearr_28010_28026[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__26280__auto___28016,out))
;
return ((function (switch__26185__auto__,c__26280__auto___28016,out){
return (function() {
var cljs$core$async$state_machine__26186__auto__ = null;
var cljs$core$async$state_machine__26186__auto____0 = (function (){
var statearr_28011 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28011[(0)] = cljs$core$async$state_machine__26186__auto__);

(statearr_28011[(1)] = (1));

return statearr_28011;
});
var cljs$core$async$state_machine__26186__auto____1 = (function (state_27993){
while(true){
var ret_value__26187__auto__ = (function (){try{while(true){
var result__26188__auto__ = switch__26185__auto__.call(null,state_27993);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26188__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26188__auto__;
}
break;
}
}catch (e28012){if((e28012 instanceof Object)){
var ex__26189__auto__ = e28012;
var statearr_28013_28027 = state_27993;
(statearr_28013_28027[(5)] = ex__26189__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27993);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28012;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26187__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28028 = state_27993;
state_27993 = G__28028;
continue;
} else {
return ret_value__26187__auto__;
}
break;
}
});
cljs$core$async$state_machine__26186__auto__ = function(state_27993){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26186__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26186__auto____1.call(this,state_27993);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26186__auto____0;
cljs$core$async$state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26186__auto____1;
return cljs$core$async$state_machine__26186__auto__;
})()
;})(switch__26185__auto__,c__26280__auto___28016,out))
})();
var state__26282__auto__ = (function (){var statearr_28014 = f__26281__auto__.call(null);
(statearr_28014[(6)] = c__26280__auto___28016);

return statearr_28014;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26282__auto__);
});})(c__26280__auto___28016,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__28030 = arguments.length;
switch (G__28030) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__26280__auto___28096 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26280__auto___28096,out){
return (function (){
var f__26281__auto__ = (function (){var switch__26185__auto__ = ((function (c__26280__auto___28096,out){
return (function (state_28068){
var state_val_28069 = (state_28068[(1)]);
if((state_val_28069 === (7))){
var inst_28064 = (state_28068[(2)]);
var state_28068__$1 = state_28068;
var statearr_28070_28097 = state_28068__$1;
(statearr_28070_28097[(2)] = inst_28064);

(statearr_28070_28097[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28069 === (1))){
var inst_28031 = (new Array(n));
var inst_28032 = inst_28031;
var inst_28033 = (0);
var state_28068__$1 = (function (){var statearr_28071 = state_28068;
(statearr_28071[(7)] = inst_28033);

(statearr_28071[(8)] = inst_28032);

return statearr_28071;
})();
var statearr_28072_28098 = state_28068__$1;
(statearr_28072_28098[(2)] = null);

(statearr_28072_28098[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28069 === (4))){
var inst_28036 = (state_28068[(9)]);
var inst_28036__$1 = (state_28068[(2)]);
var inst_28037 = (inst_28036__$1 == null);
var inst_28038 = cljs.core.not.call(null,inst_28037);
var state_28068__$1 = (function (){var statearr_28073 = state_28068;
(statearr_28073[(9)] = inst_28036__$1);

return statearr_28073;
})();
if(inst_28038){
var statearr_28074_28099 = state_28068__$1;
(statearr_28074_28099[(1)] = (5));

} else {
var statearr_28075_28100 = state_28068__$1;
(statearr_28075_28100[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28069 === (15))){
var inst_28058 = (state_28068[(2)]);
var state_28068__$1 = state_28068;
var statearr_28076_28101 = state_28068__$1;
(statearr_28076_28101[(2)] = inst_28058);

(statearr_28076_28101[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28069 === (13))){
var state_28068__$1 = state_28068;
var statearr_28077_28102 = state_28068__$1;
(statearr_28077_28102[(2)] = null);

(statearr_28077_28102[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28069 === (6))){
var inst_28033 = (state_28068[(7)]);
var inst_28054 = (inst_28033 > (0));
var state_28068__$1 = state_28068;
if(cljs.core.truth_(inst_28054)){
var statearr_28078_28103 = state_28068__$1;
(statearr_28078_28103[(1)] = (12));

} else {
var statearr_28079_28104 = state_28068__$1;
(statearr_28079_28104[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28069 === (3))){
var inst_28066 = (state_28068[(2)]);
var state_28068__$1 = state_28068;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28068__$1,inst_28066);
} else {
if((state_val_28069 === (12))){
var inst_28032 = (state_28068[(8)]);
var inst_28056 = cljs.core.vec.call(null,inst_28032);
var state_28068__$1 = state_28068;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28068__$1,(15),out,inst_28056);
} else {
if((state_val_28069 === (2))){
var state_28068__$1 = state_28068;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28068__$1,(4),ch);
} else {
if((state_val_28069 === (11))){
var inst_28048 = (state_28068[(2)]);
var inst_28049 = (new Array(n));
var inst_28032 = inst_28049;
var inst_28033 = (0);
var state_28068__$1 = (function (){var statearr_28080 = state_28068;
(statearr_28080[(7)] = inst_28033);

(statearr_28080[(8)] = inst_28032);

(statearr_28080[(10)] = inst_28048);

return statearr_28080;
})();
var statearr_28081_28105 = state_28068__$1;
(statearr_28081_28105[(2)] = null);

(statearr_28081_28105[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28069 === (9))){
var inst_28032 = (state_28068[(8)]);
var inst_28046 = cljs.core.vec.call(null,inst_28032);
var state_28068__$1 = state_28068;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28068__$1,(11),out,inst_28046);
} else {
if((state_val_28069 === (5))){
var inst_28041 = (state_28068[(11)]);
var inst_28033 = (state_28068[(7)]);
var inst_28036 = (state_28068[(9)]);
var inst_28032 = (state_28068[(8)]);
var inst_28040 = (inst_28032[inst_28033] = inst_28036);
var inst_28041__$1 = (inst_28033 + (1));
var inst_28042 = (inst_28041__$1 < n);
var state_28068__$1 = (function (){var statearr_28082 = state_28068;
(statearr_28082[(11)] = inst_28041__$1);

(statearr_28082[(12)] = inst_28040);

return statearr_28082;
})();
if(cljs.core.truth_(inst_28042)){
var statearr_28083_28106 = state_28068__$1;
(statearr_28083_28106[(1)] = (8));

} else {
var statearr_28084_28107 = state_28068__$1;
(statearr_28084_28107[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28069 === (14))){
var inst_28061 = (state_28068[(2)]);
var inst_28062 = cljs.core.async.close_BANG_.call(null,out);
var state_28068__$1 = (function (){var statearr_28086 = state_28068;
(statearr_28086[(13)] = inst_28061);

return statearr_28086;
})();
var statearr_28087_28108 = state_28068__$1;
(statearr_28087_28108[(2)] = inst_28062);

(statearr_28087_28108[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28069 === (10))){
var inst_28052 = (state_28068[(2)]);
var state_28068__$1 = state_28068;
var statearr_28088_28109 = state_28068__$1;
(statearr_28088_28109[(2)] = inst_28052);

(statearr_28088_28109[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28069 === (8))){
var inst_28041 = (state_28068[(11)]);
var inst_28032 = (state_28068[(8)]);
var tmp28085 = inst_28032;
var inst_28032__$1 = tmp28085;
var inst_28033 = inst_28041;
var state_28068__$1 = (function (){var statearr_28089 = state_28068;
(statearr_28089[(7)] = inst_28033);

(statearr_28089[(8)] = inst_28032__$1);

return statearr_28089;
})();
var statearr_28090_28110 = state_28068__$1;
(statearr_28090_28110[(2)] = null);

(statearr_28090_28110[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26280__auto___28096,out))
;
return ((function (switch__26185__auto__,c__26280__auto___28096,out){
return (function() {
var cljs$core$async$state_machine__26186__auto__ = null;
var cljs$core$async$state_machine__26186__auto____0 = (function (){
var statearr_28091 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28091[(0)] = cljs$core$async$state_machine__26186__auto__);

(statearr_28091[(1)] = (1));

return statearr_28091;
});
var cljs$core$async$state_machine__26186__auto____1 = (function (state_28068){
while(true){
var ret_value__26187__auto__ = (function (){try{while(true){
var result__26188__auto__ = switch__26185__auto__.call(null,state_28068);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26188__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26188__auto__;
}
break;
}
}catch (e28092){if((e28092 instanceof Object)){
var ex__26189__auto__ = e28092;
var statearr_28093_28111 = state_28068;
(statearr_28093_28111[(5)] = ex__26189__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28068);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28092;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26187__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28112 = state_28068;
state_28068 = G__28112;
continue;
} else {
return ret_value__26187__auto__;
}
break;
}
});
cljs$core$async$state_machine__26186__auto__ = function(state_28068){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26186__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26186__auto____1.call(this,state_28068);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26186__auto____0;
cljs$core$async$state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26186__auto____1;
return cljs$core$async$state_machine__26186__auto__;
})()
;})(switch__26185__auto__,c__26280__auto___28096,out))
})();
var state__26282__auto__ = (function (){var statearr_28094 = f__26281__auto__.call(null);
(statearr_28094[(6)] = c__26280__auto___28096);

return statearr_28094;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26282__auto__);
});})(c__26280__auto___28096,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__28114 = arguments.length;
switch (G__28114) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__26280__auto___28184 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26280__auto___28184,out){
return (function (){
var f__26281__auto__ = (function (){var switch__26185__auto__ = ((function (c__26280__auto___28184,out){
return (function (state_28156){
var state_val_28157 = (state_28156[(1)]);
if((state_val_28157 === (7))){
var inst_28152 = (state_28156[(2)]);
var state_28156__$1 = state_28156;
var statearr_28158_28185 = state_28156__$1;
(statearr_28158_28185[(2)] = inst_28152);

(statearr_28158_28185[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28157 === (1))){
var inst_28115 = [];
var inst_28116 = inst_28115;
var inst_28117 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_28156__$1 = (function (){var statearr_28159 = state_28156;
(statearr_28159[(7)] = inst_28117);

(statearr_28159[(8)] = inst_28116);

return statearr_28159;
})();
var statearr_28160_28186 = state_28156__$1;
(statearr_28160_28186[(2)] = null);

(statearr_28160_28186[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28157 === (4))){
var inst_28120 = (state_28156[(9)]);
var inst_28120__$1 = (state_28156[(2)]);
var inst_28121 = (inst_28120__$1 == null);
var inst_28122 = cljs.core.not.call(null,inst_28121);
var state_28156__$1 = (function (){var statearr_28161 = state_28156;
(statearr_28161[(9)] = inst_28120__$1);

return statearr_28161;
})();
if(inst_28122){
var statearr_28162_28187 = state_28156__$1;
(statearr_28162_28187[(1)] = (5));

} else {
var statearr_28163_28188 = state_28156__$1;
(statearr_28163_28188[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28157 === (15))){
var inst_28146 = (state_28156[(2)]);
var state_28156__$1 = state_28156;
var statearr_28164_28189 = state_28156__$1;
(statearr_28164_28189[(2)] = inst_28146);

(statearr_28164_28189[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28157 === (13))){
var state_28156__$1 = state_28156;
var statearr_28165_28190 = state_28156__$1;
(statearr_28165_28190[(2)] = null);

(statearr_28165_28190[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28157 === (6))){
var inst_28116 = (state_28156[(8)]);
var inst_28141 = inst_28116.length;
var inst_28142 = (inst_28141 > (0));
var state_28156__$1 = state_28156;
if(cljs.core.truth_(inst_28142)){
var statearr_28166_28191 = state_28156__$1;
(statearr_28166_28191[(1)] = (12));

} else {
var statearr_28167_28192 = state_28156__$1;
(statearr_28167_28192[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28157 === (3))){
var inst_28154 = (state_28156[(2)]);
var state_28156__$1 = state_28156;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28156__$1,inst_28154);
} else {
if((state_val_28157 === (12))){
var inst_28116 = (state_28156[(8)]);
var inst_28144 = cljs.core.vec.call(null,inst_28116);
var state_28156__$1 = state_28156;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28156__$1,(15),out,inst_28144);
} else {
if((state_val_28157 === (2))){
var state_28156__$1 = state_28156;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28156__$1,(4),ch);
} else {
if((state_val_28157 === (11))){
var inst_28120 = (state_28156[(9)]);
var inst_28124 = (state_28156[(10)]);
var inst_28134 = (state_28156[(2)]);
var inst_28135 = [];
var inst_28136 = inst_28135.push(inst_28120);
var inst_28116 = inst_28135;
var inst_28117 = inst_28124;
var state_28156__$1 = (function (){var statearr_28168 = state_28156;
(statearr_28168[(11)] = inst_28136);

(statearr_28168[(12)] = inst_28134);

(statearr_28168[(7)] = inst_28117);

(statearr_28168[(8)] = inst_28116);

return statearr_28168;
})();
var statearr_28169_28193 = state_28156__$1;
(statearr_28169_28193[(2)] = null);

(statearr_28169_28193[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28157 === (9))){
var inst_28116 = (state_28156[(8)]);
var inst_28132 = cljs.core.vec.call(null,inst_28116);
var state_28156__$1 = state_28156;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28156__$1,(11),out,inst_28132);
} else {
if((state_val_28157 === (5))){
var inst_28120 = (state_28156[(9)]);
var inst_28124 = (state_28156[(10)]);
var inst_28117 = (state_28156[(7)]);
var inst_28124__$1 = f.call(null,inst_28120);
var inst_28125 = cljs.core._EQ_.call(null,inst_28124__$1,inst_28117);
var inst_28126 = cljs.core.keyword_identical_QMARK_.call(null,inst_28117,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_28127 = ((inst_28125) || (inst_28126));
var state_28156__$1 = (function (){var statearr_28170 = state_28156;
(statearr_28170[(10)] = inst_28124__$1);

return statearr_28170;
})();
if(cljs.core.truth_(inst_28127)){
var statearr_28171_28194 = state_28156__$1;
(statearr_28171_28194[(1)] = (8));

} else {
var statearr_28172_28195 = state_28156__$1;
(statearr_28172_28195[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28157 === (14))){
var inst_28149 = (state_28156[(2)]);
var inst_28150 = cljs.core.async.close_BANG_.call(null,out);
var state_28156__$1 = (function (){var statearr_28174 = state_28156;
(statearr_28174[(13)] = inst_28149);

return statearr_28174;
})();
var statearr_28175_28196 = state_28156__$1;
(statearr_28175_28196[(2)] = inst_28150);

(statearr_28175_28196[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28157 === (10))){
var inst_28139 = (state_28156[(2)]);
var state_28156__$1 = state_28156;
var statearr_28176_28197 = state_28156__$1;
(statearr_28176_28197[(2)] = inst_28139);

(statearr_28176_28197[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28157 === (8))){
var inst_28120 = (state_28156[(9)]);
var inst_28124 = (state_28156[(10)]);
var inst_28116 = (state_28156[(8)]);
var inst_28129 = inst_28116.push(inst_28120);
var tmp28173 = inst_28116;
var inst_28116__$1 = tmp28173;
var inst_28117 = inst_28124;
var state_28156__$1 = (function (){var statearr_28177 = state_28156;
(statearr_28177[(14)] = inst_28129);

(statearr_28177[(7)] = inst_28117);

(statearr_28177[(8)] = inst_28116__$1);

return statearr_28177;
})();
var statearr_28178_28198 = state_28156__$1;
(statearr_28178_28198[(2)] = null);

(statearr_28178_28198[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26280__auto___28184,out))
;
return ((function (switch__26185__auto__,c__26280__auto___28184,out){
return (function() {
var cljs$core$async$state_machine__26186__auto__ = null;
var cljs$core$async$state_machine__26186__auto____0 = (function (){
var statearr_28179 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28179[(0)] = cljs$core$async$state_machine__26186__auto__);

(statearr_28179[(1)] = (1));

return statearr_28179;
});
var cljs$core$async$state_machine__26186__auto____1 = (function (state_28156){
while(true){
var ret_value__26187__auto__ = (function (){try{while(true){
var result__26188__auto__ = switch__26185__auto__.call(null,state_28156);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26188__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26188__auto__;
}
break;
}
}catch (e28180){if((e28180 instanceof Object)){
var ex__26189__auto__ = e28180;
var statearr_28181_28199 = state_28156;
(statearr_28181_28199[(5)] = ex__26189__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28156);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28180;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26187__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28200 = state_28156;
state_28156 = G__28200;
continue;
} else {
return ret_value__26187__auto__;
}
break;
}
});
cljs$core$async$state_machine__26186__auto__ = function(state_28156){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26186__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26186__auto____1.call(this,state_28156);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26186__auto____0;
cljs$core$async$state_machine__26186__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26186__auto____1;
return cljs$core$async$state_machine__26186__auto__;
})()
;})(switch__26185__auto__,c__26280__auto___28184,out))
})();
var state__26282__auto__ = (function (){var statearr_28182 = f__26281__auto__.call(null);
(statearr_28182[(6)] = c__26280__auto___28184);

return statearr_28182;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26282__auto__);
});})(c__26280__auto___28184,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1547336864409
