// Compiled by ClojureScript 1.10.439 {}
goog.provide('threeagent.impl.scene');
goog.require('cljs.core');
goog.require('threeagent.impl.virtual_scene');
goog.require('threeagent.impl.util');
goog.require('threeagent.impl.threejs');
goog.require('threeagent.impl.component');
goog.require('cljs.core');
threeagent.impl.scene.create_object = (function threeagent$impl$scene$create_object(node_data){
var comp_config = new cljs.core.Keyword(null,"component-config","component-config",2000790546).cljs$core$IFn$_invoke$arity$1(node_data);
var obj = threeagent.impl.component.render_component.call(null,new cljs.core.Keyword(null,"component-key","component-key",1189239034).cljs$core$IFn$_invoke$arity$1(node_data),comp_config);
threeagent.impl.threejs.set_position_BANG_(obj,new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$1(node_data));

threeagent.impl.threejs.set_rotation_BANG_(obj,new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$1(node_data));

threeagent.impl.threejs.set_scale_BANG_(obj,new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$1(node_data));

return obj;
});
threeagent.impl.scene.set_node_object = (function threeagent$impl$scene$set_node_object(context,node,node_data,obj){
threeagent.impl.util.$_BANG_.call(null,node,"threejs",obj);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"camera","camera",-1190348585),new cljs.core.Keyword(null,"component-key","component-key",1189239034).cljs$core$IFn$_invoke$arity$1(node_data))){
return threeagent.impl.util.$_BANG_.call(null,context,"camera",obj);
} else {
return null;
}
});
threeagent.impl.scene.add_node = (function threeagent$impl$scene$add_node(context,parent_object,node){
var node_data = threeagent.impl.util.$.call(null,node,"data");
var comp_config = new cljs.core.Keyword(null,"component-config","component-config",2000790546).cljs$core$IFn$_invoke$arity$1(node_data);
var obj = threeagent.impl.scene.create_object.call(null,node_data);
threeagent.impl.scene.set_node_object.call(null,context,node,node_data,obj);

parent_object.add(obj);

node.for_each_child(cljs.core.partial.call(null,threeagent.impl.scene.add_node,context,obj));

var temp__5457__auto___23640 = new cljs.core.Keyword(null,"on-added","on-added",-54041858).cljs$core$IFn$_invoke$arity$1(threeagent.impl.util.$.call(null,node,"meta"));
if(cljs.core.truth_(temp__5457__auto___23640)){
var callback_23641 = temp__5457__auto___23640;
callback_23641.call(null,obj);
} else {
}

return obj;
});
threeagent.impl.scene.remove_node_BANG_ = (function threeagent$impl$scene$remove_node_BANG_(node){
var obj = threeagent.impl.util.$.call(null,node,"threejs");
var parent_obj = threeagent.impl.util.$.call(null,threeagent.impl.util.$.call(null,node,"parent"),"threejs");
var temp__5457__auto___23642 = new cljs.core.Keyword(null,"on-removed","on-removed",-1308728142).cljs$core$IFn$_invoke$arity$1(threeagent.impl.util.$.call(null,node,"meta"));
if(cljs.core.truth_(temp__5457__auto___23642)){
var callback_23643 = temp__5457__auto___23642;
callback_23643.call(null,obj);
} else {
}

parent_obj.remove(obj);

return node.for_each_child(threeagent.impl.scene.remove_node_BANG_);
});
threeagent.impl.scene.init_scene = (function threeagent$impl$scene$init_scene(context,virtual_scene,scene_root){
return threeagent.impl.scene.add_node.call(null,context,scene_root,threeagent.impl.util.$.call(null,virtual_scene,"root"));
});
threeagent.impl.scene.diff_data = (function threeagent$impl$scene$diff_data(o,n){
var this$ = ((((cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"component-config","component-config",2000790546).cljs$core$IFn$_invoke$arity$1(o),new cljs.core.Keyword(null,"component-config","component-config",2000790546).cljs$core$IFn$_invoke$arity$1(n))) || (cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"component-key","component-key",1189239034).cljs$core$IFn$_invoke$arity$1(o),new cljs.core.Keyword(null,"component-key","component-key",1189239034).cljs$core$IFn$_invoke$arity$1(n)))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [o,n], null):null);
var position = ((cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$1(o),new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$1(n)))?new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$1(n):null);
var rotation = ((cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$1(o),new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$1(n)))?new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$1(n):null);
var scale = ((cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$1(o),new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$1(n)))?new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$1(n):null);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"this","this",-611633625),this$,new cljs.core.Keyword(null,"scale","scale",-230427353),scale,new cljs.core.Keyword(null,"position","position",-2011731912),position,new cljs.core.Keyword(null,"rotation","rotation",-1728051644),rotation], null);
});
threeagent.impl.scene.update_node_BANG_ = (function threeagent$impl$scene$update_node_BANG_(context,node,old_data,new_data){
var diff = threeagent.impl.scene.diff_data.call(null,old_data,new_data);
var old_obj = threeagent.impl.util.$.call(null,node,"threejs");
var metadata = threeagent.impl.util.$.call(null,node,"meta");
var this$ = new cljs.core.Keyword(null,"this","this",-611633625).cljs$core$IFn$_invoke$arity$1(diff);
if(cljs.core.truth_(this$)){
var vec__23644 = this$;
var o = cljs.core.nth.call(null,vec__23644,(0),null);
var n = cljs.core.nth.call(null,vec__23644,(1),null);
var parent_obj = threeagent.impl.util.$.call(null,old_obj,"parent");
var children = threeagent.impl.util.$.call(null,old_obj,"children");
var new_obj = threeagent.impl.scene.create_object.call(null,new_data);
var temp__5457__auto___23651 = new cljs.core.Keyword(null,"on-removed","on-removed",-1308728142).cljs$core$IFn$_invoke$arity$1(metadata);
if(cljs.core.truth_(temp__5457__auto___23651)){
var callback_23652 = temp__5457__auto___23651;
callback_23652.call(null,old_obj);
} else {
}

threeagent.impl.scene.set_node_object.call(null,context,node,new_data,new_obj);

parent_obj.remove(old_obj);

parent_obj.add(new_obj);

var seq__23647_23653 = cljs.core.seq.call(null,children);
var chunk__23648_23654 = null;
var count__23649_23655 = (0);
var i__23650_23656 = (0);
while(true){
if((i__23650_23656 < count__23649_23655)){
var child_23657 = cljs.core._nth.call(null,chunk__23648_23654,i__23650_23656);
new_obj.add(child_23657);


var G__23658 = seq__23647_23653;
var G__23659 = chunk__23648_23654;
var G__23660 = count__23649_23655;
var G__23661 = (i__23650_23656 + (1));
seq__23647_23653 = G__23658;
chunk__23648_23654 = G__23659;
count__23649_23655 = G__23660;
i__23650_23656 = G__23661;
continue;
} else {
var temp__5457__auto___23662 = cljs.core.seq.call(null,seq__23647_23653);
if(temp__5457__auto___23662){
var seq__23647_23663__$1 = temp__5457__auto___23662;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23647_23663__$1)){
var c__4461__auto___23664 = cljs.core.chunk_first.call(null,seq__23647_23663__$1);
var G__23665 = cljs.core.chunk_rest.call(null,seq__23647_23663__$1);
var G__23666 = c__4461__auto___23664;
var G__23667 = cljs.core.count.call(null,c__4461__auto___23664);
var G__23668 = (0);
seq__23647_23653 = G__23665;
chunk__23648_23654 = G__23666;
count__23649_23655 = G__23667;
i__23650_23656 = G__23668;
continue;
} else {
var child_23669 = cljs.core.first.call(null,seq__23647_23663__$1);
new_obj.add(child_23669);


var G__23670 = cljs.core.next.call(null,seq__23647_23663__$1);
var G__23671 = null;
var G__23672 = (0);
var G__23673 = (0);
seq__23647_23653 = G__23670;
chunk__23648_23654 = G__23671;
count__23649_23655 = G__23672;
i__23650_23656 = G__23673;
continue;
}
} else {
}
}
break;
}

var temp__5457__auto__ = new cljs.core.Keyword(null,"on-added","on-added",-54041858).cljs$core$IFn$_invoke$arity$1(metadata);
if(cljs.core.truth_(temp__5457__auto__)){
var callback = temp__5457__auto__;
return callback.call(null,new_obj);
} else {
return null;
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$1(diff))){
threeagent.impl.threejs.set_position_BANG_(old_obj,new cljs.core.Keyword(null,"position","position",-2011731912).cljs$core$IFn$_invoke$arity$1(diff));
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$1(diff))){
threeagent.impl.threejs.set_rotation_BANG_(old_obj,new cljs.core.Keyword(null,"rotation","rotation",-1728051644).cljs$core$IFn$_invoke$arity$1(diff));
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$1(diff))){
return threeagent.impl.threejs.set_scale_BANG_(old_obj,new cljs.core.Keyword(null,"scale","scale",-230427353).cljs$core$IFn$_invoke$arity$1(diff));
} else {
return null;
}
}
});
threeagent.impl.scene.apply_change_BANG_ = (function threeagent$impl$scene$apply_change_BANG_(context,p__23674){
var vec__23675 = p__23674;
var node = cljs.core.nth.call(null,vec__23675,(0),null);
var action = cljs.core.nth.call(null,vec__23675,(1),null);
var old = cljs.core.nth.call(null,vec__23675,(2),null);
var new$ = cljs.core.nth.call(null,vec__23675,(3),null);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"add","add",235287739),action)){
return threeagent.impl.scene.add_node.call(null,context,threeagent.impl.util.$.call(null,threeagent.impl.util.$.call(null,node,"parent"),"threejs"),node);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"remove","remove",-131428414),action)){
return threeagent.impl.scene.remove_node_BANG_.call(null,node);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"update","update",1045576396),action)){
return threeagent.impl.scene.update_node_BANG_.call(null,context,node,old,new$);
} else {
return null;
}
}
}
});
threeagent.impl.scene.apply_virtual_scene_changes_BANG_ = (function threeagent$impl$scene$apply_virtual_scene_changes_BANG_(context,changelog){
var seq__23678 = cljs.core.seq.call(null,changelog);
var chunk__23679 = null;
var count__23680 = (0);
var i__23681 = (0);
while(true){
if((i__23681 < count__23680)){
var change = cljs.core._nth.call(null,chunk__23679,i__23681);
threeagent.impl.scene.apply_change_BANG_.call(null,context,change);


var G__23682 = seq__23678;
var G__23683 = chunk__23679;
var G__23684 = count__23680;
var G__23685 = (i__23681 + (1));
seq__23678 = G__23682;
chunk__23679 = G__23683;
count__23680 = G__23684;
i__23681 = G__23685;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__23678);
if(temp__5457__auto__){
var seq__23678__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23678__$1)){
var c__4461__auto__ = cljs.core.chunk_first.call(null,seq__23678__$1);
var G__23686 = cljs.core.chunk_rest.call(null,seq__23678__$1);
var G__23687 = c__4461__auto__;
var G__23688 = cljs.core.count.call(null,c__4461__auto__);
var G__23689 = (0);
seq__23678 = G__23686;
chunk__23679 = G__23687;
count__23680 = G__23688;
i__23681 = G__23689;
continue;
} else {
var change = cljs.core.first.call(null,seq__23678__$1);
threeagent.impl.scene.apply_change_BANG_.call(null,context,change);


var G__23690 = cljs.core.next.call(null,seq__23678__$1);
var G__23691 = null;
var G__23692 = (0);
var G__23693 = (0);
seq__23678 = G__23690;
chunk__23679 = G__23691;
count__23680 = G__23692;
i__23681 = G__23693;
continue;
}
} else {
return null;
}
}
break;
}
});
threeagent.impl.scene.animate = (function threeagent$impl$scene$animate(context){
var stats = threeagent.impl.util.$.call(null,context,"stats");
var clock = threeagent.impl.util.$.call(null,context,"clock");
var virtual_scene = threeagent.impl.util.$.call(null,context,"virtual-scene");
var renderer = threeagent.impl.util.$.call(null,context,"renderer");
var composer = threeagent.impl.util.$.call(null,context,"composer");
var camera = threeagent.impl.util.$.call(null,context,"camera");
var scene_root = threeagent.impl.util.$.call(null,context,"scene-root");
var before_render_cb = threeagent.impl.util.$.call(null,context,"before-render-cb");
if(cljs.core.truth_(stats)){
stats.begin();
} else {
}

var delta_time_23694 = clock.getDelta();
var changelog_23695 = [];
if(cljs.core.truth_(before_render_cb)){
before_render_cb.call(null,delta_time_23694);
} else {
}

threeagent.impl.virtual_scene.render_BANG_.call(null,virtual_scene,changelog_23695);

threeagent.impl.scene.apply_virtual_scene_changes_BANG_.call(null,context,changelog_23695);

if(cljs.core.truth_(composer)){
composer.render(delta_time_23694);
} else {
renderer.render(scene_root,camera);
}

if(cljs.core.truth_(stats)){
return stats.end();
} else {
return null;
}
});
threeagent.impl.scene.create_context = (function threeagent$impl$scene$create_context(root_fn,dom_root,on_before_render_cb){
var virtual_scene = threeagent.impl.virtual_scene.create.call(null,root_fn);
var renderer = (new THREE.WebGLRenderer());
var camera = (new THREE.PerspectiveCamera((75),(window.innerWidth / window.innerHeight),0.1,(1000)));
var scene_root = (new THREE.Scene());
var composer = (((typeof POSTPROCESSING !== 'undefined'))?(new POSTPROCESSING.EffectComposer(renderer)):null);
var render_pass = (((typeof POSTPROCESSING !== 'undefined'))?(new POSTPROCESSING.RenderPass(scene_root,camera)):null);
renderer.setSize(window.innerWidth,window.innerHeight);

if(cljs.core.truth_(composer)){
threeagent.impl.util.$_BANG_.call(null,render_pass,"renderToScreen",true);

composer.addPass(render_pass);
} else {
}

dom_root.appendChild(renderer.domElement);

var context = cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"scene-root","scene-root",-2114916885),scene_root,new cljs.core.Keyword(null,"camera","camera",-1190348585),camera,new cljs.core.Keyword(null,"before-render-cb","before-render-cb",229389916),on_before_render_cb,new cljs.core.Keyword(null,"stats","stats",-85643011),(((typeof Stats !== 'undefined'))?(new Stats()):null),new cljs.core.Keyword(null,"clock","clock",-894301127),(new THREE.Clock()),new cljs.core.Keyword(null,"renderer","renderer",336841071),renderer,new cljs.core.Keyword(null,"composer","composer",-1616081356),composer,new cljs.core.Keyword(null,"virtual-scene","virtual-scene",43369577),virtual_scene], null));
threeagent.impl.scene.init_scene.call(null,context,virtual_scene,scene_root);

if(cljs.core.truth_(context.stats)){
context.stats.showPanel((1));

document.body.appendChild(context.stats.dom);
} else {
}

threeagent.impl.util.$_BANG_.call(null,context,"animate-fn",((function (context,virtual_scene,renderer,camera,scene_root,composer,render_pass){
return (function (){
return threeagent.impl.scene.animate.call(null,context);
});})(context,virtual_scene,renderer,camera,scene_root,composer,render_pass))
);

return context;
});
threeagent.impl.scene.remove_all_children_BANG_ = (function threeagent$impl$scene$remove_all_children_BANG_(obj){
var seq__23696 = cljs.core.seq.call(null,threeagent.impl.util.$.call(null,obj,"children"));
var chunk__23697 = null;
var count__23698 = (0);
var i__23699 = (0);
while(true){
if((i__23699 < count__23698)){
var child = cljs.core._nth.call(null,chunk__23697,i__23699);
obj.remove(child);


var G__23700 = seq__23696;
var G__23701 = chunk__23697;
var G__23702 = count__23698;
var G__23703 = (i__23699 + (1));
seq__23696 = G__23700;
chunk__23697 = G__23701;
count__23698 = G__23702;
i__23699 = G__23703;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__23696);
if(temp__5457__auto__){
var seq__23696__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23696__$1)){
var c__4461__auto__ = cljs.core.chunk_first.call(null,seq__23696__$1);
var G__23704 = cljs.core.chunk_rest.call(null,seq__23696__$1);
var G__23705 = c__4461__auto__;
var G__23706 = cljs.core.count.call(null,c__4461__auto__);
var G__23707 = (0);
seq__23696 = G__23704;
chunk__23697 = G__23705;
count__23698 = G__23706;
i__23699 = G__23707;
continue;
} else {
var child = cljs.core.first.call(null,seq__23696__$1);
obj.remove(child);


var G__23708 = cljs.core.next.call(null,seq__23696__$1);
var G__23709 = null;
var G__23710 = (0);
var G__23711 = (0);
seq__23696 = G__23708;
chunk__23697 = G__23709;
count__23698 = G__23710;
i__23699 = G__23711;
continue;
}
} else {
return null;
}
}
break;
}
});
threeagent.impl.scene.reset_scene_BANG_ = (function threeagent$impl$scene$reset_scene_BANG_(scene,root_fn,p__23712){
var map__23713 = p__23712;
var map__23713__$1 = (((((!((map__23713 == null))))?(((((map__23713.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23713.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23713):map__23713);
var on_before_render = cljs.core.get.call(null,map__23713__$1,new cljs.core.Keyword(null,"on-before-render","on-before-render",601463713));
var root = threeagent.impl.util.$.call(null,scene,"scene-root");
var virtual_scene = threeagent.impl.util.$.call(null,scene,"virtual-scene");
var new_virtual_scene = threeagent.impl.virtual_scene.create.call(null,root_fn);
threeagent.impl.scene.remove_all_children_BANG_.call(null,root);

threeagent.impl.virtual_scene.destroy_BANG_.call(null,virtual_scene);

threeagent.impl.scene.init_scene.call(null,scene,new_virtual_scene,root);

threeagent.impl.util.$_BANG_.call(null,scene,"virtual-scene",new_virtual_scene);

threeagent.impl.util.$_BANG_.call(null,scene,"before-render-cb",on_before_render);

return scene;
});
threeagent.impl.scene.render = (function threeagent$impl$scene$render(root_fn,dom_root,p__23715){
var map__23716 = p__23715;
var map__23716__$1 = (((((!((map__23716 == null))))?(((((map__23716.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23716.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23716):map__23716);
var on_before_render = cljs.core.get.call(null,map__23716__$1,new cljs.core.Keyword(null,"on-before-render","on-before-render",601463713));
var context = threeagent.impl.scene.create_context.call(null,root_fn,dom_root,on_before_render);
var renderer = threeagent.impl.util.$.call(null,context,"renderer");
renderer.setAnimationLoop(threeagent.impl.util.$.call(null,context,"animate-fn"));

return context;
});

//# sourceMappingURL=scene.js.map?rel=1547522515155
