// Compiled by ClojureScript 1.10.439 {}
goog.provide('threeagent.impl.component');
goog.require('cljs.core');
goog.require('threeagent.impl.threejs');
threeagent.impl.component.component_registry = cljs.core.PersistentArrayMap.EMPTY;
threeagent.impl.component.register_component_renderer_BANG_ = (function threeagent$impl$component$register_component_renderer_BANG_(key,render_fn){
return threeagent.impl.component.component_registry = cljs.core.assoc.call(null,threeagent.impl.component.component_registry,key,render_fn);
});
threeagent.impl.component.render_component = (function threeagent$impl$component$render_component(key,config){
var renderer = cljs.core.get.call(null,threeagent.impl.component.component_registry,key);
if(cljs.core.truth_(renderer)){
return renderer.call(null,config);
} else {
return cljs.core.println.call(null,"Missing renderer for object type",key);
}
});
threeagent.impl.component.__GT_material = (function threeagent$impl$component$__GT_material(config){
if((config instanceof THREE.Material)){
return config;
} else {
return threeagent.impl.threejs.mesh_phong_material(config);
}
});
threeagent.impl.component.to_mesh = (function threeagent$impl$component$to_mesh(geo,material_config){
var mat = threeagent.impl.component.__GT_material.call(null,material_config);
return threeagent.impl.threejs.mesh(geo,mat);
});
threeagent.impl.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"object","object",1474613949),(function (c){
return threeagent.impl.threejs.object();
}));
threeagent.impl.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"group","group",582596132),(function (c){
return threeagent.impl.threejs.group();
}));
threeagent.impl.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"camera","camera",-1190348585),(function (p__23605){
var map__23606 = p__23605;
var map__23606__$1 = (((((!((map__23606 == null))))?(((((map__23606.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23606.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23606):map__23606);
var fov = cljs.core.get.call(null,map__23606__$1,new cljs.core.Keyword(null,"fov","fov",-12463282));
var aspectRatio = cljs.core.get.call(null,map__23606__$1,new cljs.core.Keyword(null,"aspectRatio","aspectRatio",-218867702));
var near = cljs.core.get.call(null,map__23606__$1,new cljs.core.Keyword(null,"near","near",-1077668328));
var far = cljs.core.get.call(null,map__23606__$1,new cljs.core.Keyword(null,"far","far",85807546));
return threeagent.impl.threejs.perspective_camera(fov,aspectRatio,near,far);
}));
threeagent.impl.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"instance","instance",-2121349050),(function (p__23608){
var map__23609 = p__23608;
var map__23609__$1 = (((((!((map__23609 == null))))?(((((map__23609.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23609.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23609):map__23609);
var object = cljs.core.get.call(null,map__23609__$1,new cljs.core.Keyword(null,"object","object",1474613949));
return object;
}));
threeagent.impl.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"plane","plane",-223595224),(function (p__23611){
var map__23612 = p__23611;
var map__23612__$1 = (((((!((map__23612 == null))))?(((((map__23612.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23612.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23612):map__23612);
var dims = cljs.core.get.call(null,map__23612__$1,new cljs.core.Keyword(null,"dims","dims",-466522889));
var segment_dims = cljs.core.get.call(null,map__23612__$1,new cljs.core.Keyword(null,"segment-dims","segment-dims",1394305588));
var material = cljs.core.get.call(null,map__23612__$1,new cljs.core.Keyword(null,"material","material",460118677));
var vec__23614 = dims;
var w = cljs.core.nth.call(null,vec__23614,(0),null);
var h = cljs.core.nth.call(null,vec__23614,(1),null);
var vec__23617 = segment_dims;
var sw = cljs.core.nth.call(null,vec__23617,(0),null);
var sh = cljs.core.nth.call(null,vec__23617,(1),null);
var geo = threeagent.impl.threejs.plane_geometry(w,h,sw,sh);
return threeagent.impl.component.to_mesh.call(null,geo,material);
}));
threeagent.impl.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"box","box",1530920394),(function (p__23620){
var map__23621 = p__23620;
var map__23621__$1 = (((((!((map__23621 == null))))?(((((map__23621.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23621.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23621):map__23621);
var dims = cljs.core.get.call(null,map__23621__$1,new cljs.core.Keyword(null,"dims","dims",-466522889));
var material = cljs.core.get.call(null,map__23621__$1,new cljs.core.Keyword(null,"material","material",460118677));
var vec__23623 = dims;
var x = cljs.core.nth.call(null,vec__23623,(0),null);
var y = cljs.core.nth.call(null,vec__23623,(1),null);
var z = cljs.core.nth.call(null,vec__23623,(2),null);
var geo = threeagent.impl.threejs.box_geometry(x,y,z);
return threeagent.impl.component.to_mesh.call(null,geo,material);
}));
threeagent.impl.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"sphere","sphere",384337120),(function (p__23626){
var map__23627 = p__23626;
var map__23627__$1 = (((((!((map__23627 == null))))?(((((map__23627.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23627.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23627):map__23627);
var radius = cljs.core.get.call(null,map__23627__$1,new cljs.core.Keyword(null,"radius","radius",-2073122258));
var width_segments = cljs.core.get.call(null,map__23627__$1,new cljs.core.Keyword(null,"width-segments","width-segments",25187827));
var height_segments = cljs.core.get.call(null,map__23627__$1,new cljs.core.Keyword(null,"height-segments","height-segments",1831894149));
var material = cljs.core.get.call(null,map__23627__$1,new cljs.core.Keyword(null,"material","material",460118677));
var geo = threeagent.impl.threejs.sphere_geometry(radius,(function (){var or__4047__auto__ = width_segments;
if(cljs.core.truth_(or__4047__auto__)){
return or__4047__auto__;
} else {
return (12);
}
})(),(function (){var or__4047__auto__ = height_segments;
if(cljs.core.truth_(or__4047__auto__)){
return or__4047__auto__;
} else {
return (12);
}
})());
return threeagent.impl.component.to_mesh.call(null,geo,material);
}));
threeagent.impl.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"point-light","point-light",669926690),(function (p__23629){
var map__23630 = p__23629;
var map__23630__$1 = (((((!((map__23630 == null))))?(((((map__23630.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23630.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23630):map__23630);
var color = cljs.core.get.call(null,map__23630__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var intensity = cljs.core.get.call(null,map__23630__$1,new cljs.core.Keyword(null,"intensity","intensity",1142770863));
var distance = cljs.core.get.call(null,map__23630__$1,new cljs.core.Keyword(null,"distance","distance",-1671893894));
return threeagent.impl.threejs.point_light(color,intensity,distance);
}));
threeagent.impl.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"hemisphere-light","hemisphere-light",-1569111131),(function (p__23632){
var map__23633 = p__23632;
var map__23633__$1 = (((((!((map__23633 == null))))?(((((map__23633.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23633.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23633):map__23633);
var sky_color = cljs.core.get.call(null,map__23633__$1,new cljs.core.Keyword(null,"sky-color","sky-color",1803548607));
var ground_color = cljs.core.get.call(null,map__23633__$1,new cljs.core.Keyword(null,"ground-color","ground-color",-1832095873));
var intensity = cljs.core.get.call(null,map__23633__$1,new cljs.core.Keyword(null,"intensity","intensity",1142770863));
return threeagent.impl.threejs.hemisphere_light(sky_color,ground_color,intensity);
}));
threeagent.impl.component.register_component_renderer_BANG_.call(null,new cljs.core.Keyword(null,"text","text",-1790561697),(function (p__23635){
var map__23636 = p__23635;
var map__23636__$1 = (((((!((map__23636 == null))))?(((((map__23636.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23636.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23636):map__23636);
var cfg = map__23636__$1;
var text = cljs.core.get.call(null,map__23636__$1,new cljs.core.Keyword(null,"text","text",-1790561697));
var material = cljs.core.get.call(null,map__23636__$1,new cljs.core.Keyword(null,"material","material",460118677));
var geo = threeagent.impl.threejs.text_geometry(text,cfg);
return threeagent.impl.component.to_mesh.call(null,geo,material);
}));

//# sourceMappingURL=component.js.map?rel=1547522515113
