(ns dosql.ring.util
  (:require [dosql.clj.common :as c]
            [clojure.walk :as w]
            [dosql.clj.walk :as dw]
            [clojure.pprint :as pprint]))



(defn filter-nil-value
  [m]
  (->> m
       (filter (comp not nil? val))
       (into {})))


(defn as-str [v]
  (cond
    (string? v) v
    (keyword? v) (name v)
    (float? v) v
    (int? v) v
    (integer? v) v
    (double? v) v
    (number? v) (str v)
    :else v))



(defn replace-keyword-colon [str-v]
  (keyword (clojure.string/replace-first str-v #":" "")))


(defn format-param
  [param-in]
  (cond
    (map? param-in)
    (mapv replace-keyword-colon (vals param-in))
    (sequential? param-in)
    (c/as-keyword-batch
      (mapv replace-keyword-colon param-in))
    (string? param-in)
    (replace-keyword-colon param-in)
    :else
    param-in))


(def rename-key-m {:n       :dosql.core/name
                   :g       :dosql.core/group
                   :param       :dosql.core/param
                   :ds      :dosql.core/ds
                   :oformat :dosql.core/output-format
                   :pformat :dosql.core/param-format})


(defn process-params [{:keys [params]}]
  ;(log/info "Prams ---" params)
  (when (or params
            (not-empty params))
    (-> params
        (w/keywordize-keys)
        (update-in [:n] format-param)
        (update-in [:g] format-param)
        (filter-nil-value)
        (clojure.set/rename-keys rename-key-m)
        (select-keys [:dosql.core/name
                      :dosql.core/ds
                      :dosql.core/param
                      :dosql.core/group
                      :dosql.core/output-format
                      :dosql.core/param-format]))))



(defn format-response
  [{:keys [content-type headers]} output]
  (let [content-type (or content-type
                         (get headers "accept"))]
    (if (and content-type
             (or (clojure.string/includes? content-type "transit")
                 (clojure.string/includes? content-type "json")))
      output
      (->> output
           (dw/postwalk-replace-value-with as-str)
           (dw/postwalk-replace-key-with dw/keyword->str)))))



(defn pformat [& args]
  (with-out-str
    (apply pprint/pprint args)))





(comment


  (-> (clojure.string/split "/tie/pull" #"/")

      )

  )

