(ns dosql.impl.param-spec-genarator
  (:require [clojure.spec :as s]
            [spec-model.core :as sg]))

(defn filename-as-keyword [file-name-str]
  (-> (clojure.string/split file-name-str #"\/")
      (last)
      (clojure.string/split #"\.")
      (first)
      (keyword)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defn as-merge-spec [spec-coll]
  (if (or (nil? spec-coll)
          (empty? spec-coll))
    nil
    (->> spec-coll
         (remove nil?)
         (cons 'clojure.spec/merge))))



(defn group-spec [tms]
  (->> tms
       (vals)
       (filter :dosql.core/group)
       (filter :dosql.core/param-spec)
       (mapv (juxt :dosql.core/group :dosql.core/param-spec))
       (reduce (fn [acc [k v]]
                 (update-in acc [k] (fn [w] (merge-with merge w v)))
                 ) {})))


(defn gen-query-spec [tms]
  (when (nil? (get-in tms [:_global_ :dosql.core/file-name]))
    (throw (ex-info "Filename is missing" {})))

  (let [ns-identifier (filename-as-keyword (get-in tms [:_global_ :dosql.core/file-name]))
        r (->> (vals tms)
               (filter :dosql.core/param-spec)
               (filter (fn [m] (not= (:dosql.core/dml m)
                                     :dosql.core/dml-insert)))
               (into {} (map (juxt :dosql.core/name :dosql.core/param-spec))))
        query-m (merge r (group-spec tms))
        ]
    (if (empty? query-m)
      (list)
      (sg/gen-spec ns-identifier query-m
                   {:spec-model.core/gen-type   #{:spec-model.core/ex
                                                  :spec-model.core/un-qualified}
                    :spec-model.core/gen-list?  false
                    :spec-model.core/gen-etype? false})
      )
    ))


(defn gen-model-spec [tms]
  (when (nil? (get-in tms [:_global_ :dosql.core/file-name]))
    (throw (ex-info "Filename is missing" {})))
  (let [ns-identifier (filename-as-keyword (get-in tms [:_global_ :dosql.core/file-name]))
        r (->> (vals tms)
               (filter :dosql.core/param-spec)
               (filter (fn [m] (= (:dosql.core/dml m)
                                  :dosql.core/dml-insert)))
               (group-by :dosql.core/model)
               (map (fn [[k v]] {k (apply merge (mapv :dosql.core/param-spec v))}))
               (into {}))
        kset (into #{} (keys r))
        j (->> (get-in tms [:_global_ :spec-model.core/join])
               (remove (fn [[s _ _ d _]]
                         (not (and (contains? kset s)
                                   (contains? kset d))))))]
    (if (empty? r)
      (list)
      (sg/gen-spec ns-identifier r
                   {:spec-model.core/gen-type   #{:spec-model.core/ex
                                                  :spec-model.core/un-qualified}
                    :spec-model.core/gen-list?  false
                    :spec-model.core/join       j
                    :spec-model.core/gen-etype? true}))))


(defn gen-spec [tms]
  (let [q-spec (gen-query-spec tms)
        m-spec (gen-model-spec tms)]
    (into m-spec (reverse q-spec))))



(defn assosc-spec-to-m [f-k m]
  (if (contains? m :dosql.core/param-spec)
    (if (= (:dosql.core/dml m)
           :dosql.core/dml-insert)
      (let [w (keyword (str "ex." (name f-k) "/" (name (:dosql.core/model m))))]
        (assoc m :dosql.core/spec w))
      (let [w (keyword (str "ex." (name f-k) "/" (name (:dosql.core/name m))))]
        (assoc m :dosql.core/spec w)))
    m))




#_(defn get-spec [tm-coll req-m]
  (condp = (:dosql.core/op req-m)
    :dosql.core/push-entity-relational
    (-> (map :dosql.core/spec tm-coll)
        (first))
    (let [s (->> (map :dosql.core/spec tm-coll)
                 (remove nil?)
                 (doall)
                 (as-merge-spec))]
      (if (not-empty s)
        (eval s)
        nil))))


(defn validate-spec [tm]
  (let [[_ param] (:dosql.core/param tm)
        spec (:dosql.core/spec tm)]
    (if (or (nil? spec)
            (s/valid? (eval spec) param))
      tm
      (throw (ex-info "Spec not valid " (s/explain-data (eval spec) param))))))



(defn validate-spec2 [tm]
  (let [[t param] (:dosql.core/param tm)
        spec (:dosql.core/spec tm)]
    (if (= t :one)
      (if (or (nil? spec)
              (s/valid? (eval spec) param))
        tm
        (throw (ex-info "Spec not valid " (s/explain-data (eval spec) param))))
      tm
      )

    ))
