(ns dosql.impl.param-impl
  (:require [clojure.walk :as w]))


(defn temp-generator [_]
  -1)


(defn assoc-temp-gen [w gen]
  (->> (partition 2 w)
       (mapv (fn [[k f]] [k (f gen)]))
       (flatten)))


(defn assoc-generator [gen m]
  (if (:dosql.core/default-param m)
    (update-in m [:dosql.core/default-param] assoc-temp-gen gen)
    m))


(defn merge-default-param-rf [input param-list]
  (->> param-list
       (remove nil?)
       (partition 2)
       (reduce (fn [acc [k kfn]]
                 (if (get acc k)
                   acc
                   (assoc acc k (kfn acc))))
               input)))


(defn merge-default-param [tm]
  (let [[t v] (:dosql.core/param tm) ]
    (if (= t :coll)
      (->> (mapv #(merge-default-param-rf % (:dosql.core/default-param tm)) v )
           (vector t)
           (assoc tm :dosql.core/param))

      (->> (merge-default-param-rf v (:dosql.core/default-param tm))
           (vector t)
           (assoc tm :dosql.core/param))
      )
    )

 )

;(vector 1 2)



(comment


  (let [coll [{:dosql.core/default-param (list :transaction_id (fn [w] (:id w))),
               :dosql.core/model         :employee}
              {:dosql.core/default-param (list :transaction_id (fn [w] (:id w))),
               :dosql.core/model         :employee}]
        input {:id 2}


        r-call-fn (param-exec-callback coll)

        ]
    (r-call-fn :employee input)

    )







  )



;;;;;;;;;;;;;;;;;




;;;;;;;;;;;;;;;;;;;;;;;;;;, Reader util ;;;;;;;;;

(defmulti map-param-fn (fn [v] (type v)))

(defmethod map-param-fn
  :default
  [w]
  (fn [_]
    (fn [_]
      w)))



(defn apply-user-fn [f v]
  (try
    (f v)
    (catch Exception e
      (throw e)
      #_(f/fail (format "Failed to for %s %s " (str f) (str v)))

      )
    )

  )


(defmethod map-param-fn
  clojure.lang.PersistentList
  [v]
  (let [w1 (->> v
                (w/postwalk (fn [w]
                              (if (keyword? w)
                                (list 'get-in 'm [w])
                                w)))
                (list 'fn ['m])
                (eval))]
    (fn [_]
      (fn [m]
        (apply-user-fn w1 m)))))



(defmethod map-param-fn
  clojure.lang.Keyword
  [w]
  (fn [caller-fn]
    (fn [_]
      (caller-fn {:dosql.core/user-request {:dosql.core/name [:one w]} }))))


;(keyword? :As)
;(type :keyword)
;(type (fn [t]))


(defn convert-param-t [w]
  (->> (partition 2 w)
       (mapv (fn [[k v]]
               [k (map-param-fn v)]))
       (flatten)))



(comment

  (let [{a true b false}
        (group-by (fn [[k v]] (keyword? v)) {:id inc :a :b})]
    b)

  (clojure.pprint/pprint
    (convert-param-t [:a '(constantly 3) :b :a])
    )


  (let [p {:b 1}
        fn1 (fn [r] (do
                      (println "--form in pout " r)
                      3))
        w (-> (convert-param-t [:a '(constantly 3) :b :a])
              (assoc-temp-gen fn1))]

    (reduce (fn [acc [k f]]
              (assoc acc k (f acc))
              ) p (partition 2 w))

    )

  )


