(ns dosql.impl.common-impl
  (:require
    [dosql.clj.fail :as f]))


(defn do-result
  [tm]
  (if-not (or (= (:dosql.core/dml tm) :dosql.core/dml-select)
              (= (:dosql.core/dml tm) :dosql.core/dml-call))
    tm
    (let [result (:dosql.core/result tm)
          output (:dosql.core/output tm)]
      (cond
        (nil? result)
        tm
        (f/failed? output)
        tm
        (and (empty? output)
             (contains? result :dosql.core/result-single))
        (assoc tm :dosql.core/output {})
        (and (contains? result :dosql.core/result-array)
             (contains? result :dosql.core/result-single))
        (assoc tm :dosql.core/output [(first output) (second output)])
        (contains? result :dosql.core/result-single)
        (assoc tm :dosql.core/output (first output))
        :else tm))))


(defn do-column
  [tm]
  (if-not (or (= (:dosql.core/dml tm) :dosql.core/dml-call)
              (= (:dosql.core/dml tm) :dosql.core/dml-select))
    tm
    (let [column (:clojure.core/column tm)
          output (:dosql.core/output tm)]
      (cond
        (or (nil? column)
            (f/failed? tm)
            (f/failed? output)
            (not (map? (first output))))
        tm
        :else
        (->> (repeat column)
             (map clojure.set/rename-keys output)
             (into [])
             (assoc tm :dosql.core/output))))))


