(ns dosql.file-reader
  (:require [clojure.java.io :as io]
            [clojure.walk :as w]
            [clojure.spec :as s]
            [dosql.impl.param-impl :as pl]
            [clojure.tools.reader.edn :as edn]))


(def ^:dynamic *alais-map* {:doc          :dosql.core/doc
                            :timeout      :dosql.core/timeout
                            :reserve-name :dosql.core/reserve-name
                            :file-reload  :dosql.core/file-reload
                            :tx-prop      :dosql.core/tx-prop

                            :join         :spec-model.core/join
                            :1-1          :spec-model.core/rel-1-1
                            :1-n          :spec-model.core/rel-1-n
                            :n-1          :spec-model.core/rel-n-1
                            :n-n          :spec-model.core/rel-n-n

                            :name         :dosql.core/name
                            :model        :dosql.core/model
                            :group        :dosql.core/group
                            :column       :dosql.core/column
                            :sql          :dosql.core/sql

                            :result       :dosql.core/result
                            :array        :dosql.core/result-array
                            :single       :dosql.core/result-single

                            :commit       :dosql.core/commit
                            :all          :dosql.core/commit-all
                            :any          :dosql.core/commit-any
                            :none         :dosql.core/commit-none

                            :dml-type     :dosql.core/dml
                            :index        :dosql.core/index

                            :skip         :dosql.core/skip
                            :param        :dosql.core/default-param
                            :param-spec   :dosql.core/param-spec

                            :extend       :dosql.core/extend
                            :spec-file    :dosql.core/spec-file})


(defn key->nskey
  [m mk]
  (w/postwalk (fn [x]
                (if-let [v (get mk x)]
                  v
                  x)) m))


(defn- tie-file-reader
  [file-name]
  (let [fs (-> file-name
               (io/resource)
               (slurp)
               (clojure.string/replace #"\n" " "))]
    (for [ms (clojure.string/split fs #"/\*")
          :when (not (clojure.string/blank? ms))
          m (clojure.string/split ms #"\*/")
          :when (not (clojure.string/blank? m))]
      (if (.startsWith (clojure.string/triml m) "{")
        (do
          (edn/read-string
            (clojure.string/lower-case m)))
        m))))


(defn map-sql-tag
  [w]
  (reduce (fn [acc v]
            (let [[f & r] acc]
              (cond
                (nil? f) (conj acc v)
                (string? v) (if (:sql f)
                              acc
                              (->> (clojure.string/split (clojure.string/trim v) #";")
                                   (mapv clojure.string/trim)
                                   (assoc f :sql)
                                   (conj r)))
                :else (conj acc v)))
            ) (list) w))


(defn compiler-resolve [coll]
  (w/postwalk (fn [v]
                (if (symbol? v)
                  (resolve v)
                  v)
                ) coll))




(defn compiler-param-resolve [coll]
  (w/postwalk (fn [m]
                (if (and (map? m)
                         (:param m))
                  (update-in m [:param] pl/convert-param-t)
                  m
                  )
                ) coll))




;;Do we need to unquote again here
(defn read-file
  [file-name]
  (-> file-name
      (tie-file-reader)
      (map-sql-tag)
      (reverse)
      (compiler-resolve)
      (compiler-param-resolve)
      (key->nskey *alais-map*)))



(comment


  (partition-by (fn [[k v]]
                  (keyword? v)
                  )
                {:a :b :t (fn [t] t)})

  ;(var? [int?])

  ;(var? :a)

  ;(var? #'clojure.spec/coll-of)

  ;(coll? {1 2})

  (->> (read-file "tie2.edn.sql")
       (s/conform :dosql.core/compiler-spec)
       (clojure.pprint/pprint))



  (->
    (read-file "tie3.edn.sql")
    (clojure.pprint/pprint))

  ;(require '[tie_edn])



  (load "./tie_edn.clj")

  )