(ns dosql.compiler.spec
  (:require [clojure.spec :as s]))


(s/def :dosql.core/common
  (s/merge
    (s/keys :opt [:dosql.core/timeout
                  :dosql.core/column
                  :dosql.core/result
                  :dosql.core/default-param
                  :dosql.core/param-spec])))



(s/def :dosql.core/extend
  (s/every-kv keyword? (s/merge (s/keys :opt [:dosql.core/model]) :dosql.core/common)))



(comment

  (s/exercise :dosql.core/common)

  (clojure.pprint/pprint
    (s/exercise :dosql.core/extend 1))

  )



(s/def :dosql.core/module (s/merge
                              :dosql.core/common
                              (s/keys :req [:dosql.core/name :dosql.core/sql]
                                      :opt [:dosql.core/model :dosql.core/skip :dosql.core/group :dosql.core/commit :dosql.core/extend])))


(s/def :dosql.core/spec-file symbol?)

(s/def :dosql.core/global (s/keys :req [:dosql.core/name]
                                    :opt [:dosql.core/timeout :dosql.core/read-only? :dosql.core/tx-prop :dosql.core/file-reload :dosql.core/reserve-name :dosql.core/join :dosql.core/spec-file]))


(s/def :dosql.core/compiler-spec
  (clojure.spec/cat
    :global (s/? :dosql.core/global)
    :module (s/* :dosql.core/module)))




(defn validate-input-spec! [coll]
  (let [w (s/conform :dosql.core/compiler-spec coll)]
    (if (= w :clojure.spec/invalid)
      (do
        (println (s/explain-str :dosql.core/compiler-spec coll))
        (throw (ex-info "Compile failed " (s/explain-data :dosql.core/compiler-spec coll)))))))







