(ns dosql.re-frame
  (:require-macros [reagent.ratom :refer [reaction]])
  (:require [re-frame.core :as r]))


(def error-path-key :dosql/error-path)
(def store-path-key :dosql/store)

;; Clear all value from here
(r/register-handler
  :dosql/clear-store
  (fn [db [_ v]]
    (if v
      (update-in db [store-path-key] dissoc v)
      (assoc-in db [store-path-key] nil))))


;;Store all value here
(r/register-handler
  store-path-key
  (fn [db [p [cp v]]]
    (assoc-in db [p cp] v)))


(r/register-sub
  store-path-key
  (fn [db path] (do (reaction (get-in @db path)))))


(defn error-dispatch [s-key res]
  (do
    (.log js/console (pr-str res) )
    (r/dispatch [store-path-key [:dosql/error-path {s-key res}]])
    )
  )

(defn dispatch [s-key res]
  (let [[v e] res]
    (if v
      (do
        (r/dispatch [:dosql/clear-store error-path-key])
        (r/dispatch [store-path-key [s-key v]]))
      (r/dispatch [store-path-key [:dosql/error-path {s-key e}]]))))



(defn ok-mutate [s-key v]
  (dispatch s-key [v nil]))


(defn subscribe [path]
  (r/subscribe (into [store-path-key] path)))


(defn clear-store [path]
  (r/dispatch (into [:dosql/clear-store] path)))


