(defproject dosql/cljs-client "0.1.0-SNAPSHOT"
  :description "dosql http tools "
  :url "https://github.com/Mamun/dosql/tree/master/module/dosql-http"
  :license {:name "Eclipse Public License"
            :url  "http://www.eclipse.org/legal/epl-v10.html"}
  :dependencies [[org.clojure/clojure "1.9.0-alpha14" :scope "provided"]
                 [org.clojure/clojurescript "1.9.229" :scope "provided"]
                 [cljs-ajax "0.5.8"]
                 [reagent "0.6.0"]
                 [re-frame "0.7.0-alpha-3"]]

  :plugins [[lein-cljsbuild "1.1.4"]
            [lein-figwheel "0.5.8"]
            [lein-doo "0.1.6"]]

  :min-lein-version "2.5.3"

  ;:test-paths ["test/clj"]
  :clean-targets ^{:protect false} [:target-path :compile-path "dev-resources/public/js"]

  :figwheel {:server-port    3001                           ;; default
             :css-dirs       ["dev-resources/public/css"]   ;; watch and update CSS
             :ring-handler   dosql.boot/http-handler
             :server-logfile "target/figwheel.log"}

  :cljsbuild {:builds
              {:app
               {:source-paths ["src" "dev"]
                :figwheel     {:devcards true}
                :compiler     {:main                 app.core
                               :asset-path           "js/compiled/out"
                               :output-dir           "dev-resources/public/js/compiled/out"
                               :output-to            "dev-resources/public/js/compiled/app.js"
                               :source-map-timestamp true}}}}

  :profiles {:dev {:repl-options   {:port 4555
                                    :nrepl-middleware [cemerick.piggieback/wrap-cljs-repl]}
                   :source-paths   [ "dev"]
                   :resource-paths ["../core/dev-resources" "../boot/dev-resources" "dev-resources"]
                   :dependencies   [[dosql/boot "0.1.0-SNAPSHOT"]
                                    [ring/ring-devel "1.5.0"]
                                    [ring/ring-mock "0.3.0"]
                                    [devcards "0.2.1-5" ]
                                    [figwheel "0.5.0-6"]
                                    [figwheel-sidecar "0.5.0-6"]
                                    [com.cemerick/piggieback "0.2.1"]
                                    [org.clojure/tools.nrepl "0.2.12"]]}})

