(defproject dosql/boot "0.1.0-SNAPSHOT"
  :description "dosql http tools "
  :url "https://github.com/Mamun/dosql/tree/master/module/dosql-http"
  :license {:name "Eclipse Public License"
            :url  "http://www.eclipse.org/legal/epl-v10.html"}

  :dependencies [[org.clojure/clojure "1.9.0-alpha14"]
                 [org.clojure/tools.reader "1.0.0-beta4"]
                 [ring/ring-core "1.5.0"]
                 [ring/ring-defaults "0.2.1"]
                 [compojure "1.1.6"]
                 [org.immutant/web "2.1.3"                  ;; default Web server
                  :exclusions [ch.qos.logback/logback-core
                               org.slf4j/slf4j-api]]
                 [ch.qos.logback/logback-classic "1.1.3"]
                 [c3p0/c3p0 "0.9.1.2"]
                 [dosql/core "0.1.0-alpha-SNAPSHOT"]
                 [dosql/http-service "0.1.0-SNAPSHOT"]

                 [io.pedestal/pedestal.service       "0.5.2"]
                 [io.pedestal/pedestal.jetty         "0.5.2"]
                 [io.pedestal/pedestal.log         "0.5.2"]]

  :uberjar-name "dosql-boot.jar"

  :profiles {:dev     {:repl-options   {:port 4555}
                       :resource-paths ["dev-resources" "../dosql-core/dev-resources"]
                       :dependencies   [[com.h2database/h2 "1.3.154"]
                                        [io.pedestal/pedestal.service-tools "0.5.2"]
                                      ;  [ring/ring-devel "1.5.0"]
                                        [org.clojure/tools.nrepl "0.2.12"]]}
             :uberjar {:manifest    {"Class-Path" "lib"}
                       :omit-source true
                       :aot         :all}})

