(ns hello.service
  (:require [io.pedestal.http :as http]
            [io.pedestal.log :as log]
            [io.pedestal.http.route :as route]
            [io.pedestal.http.body-params :as body-params]
            ;[dosql.ring.service :as t]
            ;[dosql.boot-state :as s]
            [io.pedestal.http.route.definition :refer [defroutes]]))



(defn hello-world
  [request]
  (do
    (log/info :hello "Calling hellow world ")
    (log/histogram :callHello 1)
    ;(println "Request##########")
    ;(println request)
    ;(println "#################")
    (let [name (get-in request [:params :name] "World")]
      {:status 200 :body (str "Hello " name "!\n")})))


(def check-intercepter
  {:name ::hello
   :enter (fn [context]
            (do
              (println "######################")
              (println context)
              (println "######################")
              context
              )
            )
   :leave (fn [context]
            (println "Leaving ")
            context
            )})


(def routes
  (route/expand-routes                                   ;; <1>
    #{["/hello" :get hello-world :route-name :hello]})) ;; <2>

#_(defroutes routes
           [[["/"
              ["/pull" ^:interceptors [check-intercepter]
               {:get hello-world}]]]])


(def service {:env                 :prod
              ::http/routes        routes
              ::http/resource-path "/public"
              ::http/type          :jetty
              ::http/port          8080})