(ns dosql.boot-state
  (:require [clojure.tools.reader.edn :as edn]
            [clojure.java.io :as io]
            [dosql.ring.service :as t]
            [clojure.tools.logging :as log])
  (:import
    [com.mchange.v2.c3p0 ComboPooledDataSource]))


(defonce ds-m-atom (atom nil))
(defonce dosql-m-atom (atom nil))
(defonce boot-config-atom (atom nil))



(defn init-data-source [{:keys [c3p0]}]
  (if (nil? c3p0)
    (do
      (log/info "Loading c3p0 default ")
      {"default" {:datasource (ComboPooledDataSource.)}})
    (->> c3p0
         (map (fn [n] {:datasource (ComboPooledDataSource. n)}))
         (zipmap c3p0))))



(defn init-state []
  (when (nil? @boot-config-atom)
    (log/info "Loading init file ")
    (reset! boot-config-atom (edn/read-string (slurp (io/file (io/resource "dosql_boot.edn"))))))
  (when (nil? @ds-m-atom)
    (log/info "Creating database connection ")
    (reset! ds-m-atom (init-data-source @boot-config-atom)))
  (->> (:dosql @boot-config-atom)
       (t/load-module-batch @ds-m-atom)
       (reset! dosql-m-atom)))


(comment
  (init-state)
  )
