(ns dosql.boot
  (:use compojure.core)
  (:require [ring.util.response :as resp]
            [ring.middleware.defaults :refer :all]
            [compojure.route :as route]
            [immutant.web :as im]
            [clojure.tools.logging :as log]
            [dosql.ring.service :as t]
            [dosql.boot-state :as s])
  (:gen-class))


(defroutes app-routes
   (GET "/" _ (resp/resource-response "index.html" {:root "public"}))
   (route/resources "/")
   (route/not-found {:status 200 :body "Not found"}))


(defn warp-log [handler]
  (fn [req]
    (try
      (log/info "Http request  " req)
      (handler req)
      (catch Exception e
        (do
          (log/error "Exception in server " e)
          {:status 500 :body "Exception in server"}
          #_(log/info "Execption in server " (.getMessage e)))))))


(def http-handler
  (-> app-routes
      (t/warp-dosql s/ds-m-atom s/dosql-m-atom)
      (warp-log)))


(defn run
  ([handler]
   (do
     (s/init-state)
     (im/run handler (:immutant @s/boot-config-atom))
     (log/info "Starting server at  " (:immutant @s/boot-config-atom))))
  ([] (run http-handler) ))


(defn -main
  [& args]
  (run http-handler))


(comment

  (run)

  )