
(ns dobby.tool.render.clj-deps
  (:require [clojure.edn     :as edn]
            [clojure.java.io :as io]
            [clojure.pprint  :as pprint]
            [clojure.walk    :as walk]
            [familiar.core   :as f :refer [fmtstr]]
            [dobby.tool.core :as core]))

(defn render
  [dir depspecs]
  (letfn [(dobby-verspec->mvn-version [verspec]
            (if-let [semver-spec (:dobby.package/version verspec)]
              {:mvn/version (fmtstr "~{~a~^.~}" ((juxt :major :minor :build) semver-spec))}
              verspec))
          (render-clj-deps-versions [depspec]
            (walk/prewalk dobby-verspec->mvn-version depspec))]
    (with-open [w (io/writer (io/file dir "deps.edn"))]
      (pprint/pprint (reduce (fn [m [k v]]
                               (update-in m
                                          [:aliases k :extra-deps]
                                          (comp render-clj-deps-versions merge)
                                          (get depspecs k)))
                             (update-in (edn/read-string (slurp (io/file dir "deps-template.edn")))
                                        [:deps]
                                        (comp render-clj-deps-versions merge)
                                        (get depspecs ::core/root))
                             (seq (dissoc depspecs ::core/root)))
                     w))))
