(defproject dn/test-helpers "0.1.0-SNAPSHOT"
  :description "Helper functions for unit tests"
  :url "https://www.d-n.be"
  :license {:name "Commercial license"
            :url "https://www.d-n.be"}
  :dependencies [[org.clojure/clojure "1.10.0"]
                 [midje "1.9.9"]]
  :repl-options {:init-ns test-helpers.core}
  :profiles {:dev {:dependencies [[dn/midje-junit-formatter "0.1.1"]]
                   :plugins [[lein-midje "3.2.1"]]}}
  :aliases {"autotest" ["midje" ":autotest"]}
  :repositories [["snapshots" {:url "https://nexus.d-n.be/repository/dn-snapshots/"
                               :username [:gpg :env/nexus_user]
                               :password [:gpg :env/nexus_pass]}]
                 ["releases"  {:url "https://nexus.d-n.be/repository/dn-releases/"
                               :username [:gpg :env/nexus_user]
                               :password [:gpg :env/nexus_pass]}]]
  ;; Deploy to Clojars
  )
