# Service Detection for Clojure

A Clojure library that provides utility functions for detecting services when
running in a cloud environment.  The most well-known environment is a Kubernetes
cluster.  Services are exposed to pods using environment variables.  These
variables follow a certain naming convention.  This library allows to detect
those services and use them in your applications.

Another situation where this may be useful is in CI/CD environments, where you
need to test against dynamically started services (e.g. a database server).
Usually the CI/CD environment will expose those services using environment
variables.  In your tests, you can then read those variables to access the
service.

## Usage

First add the library to your project:

```clojure
[dn/clj-service-detect "0.1.0-SNAPSHOT"]
```

Detect any services using the environment, assuming it is passed in via
a map (e.g. using the [Yogthos Config library](https://github.com/yogthos/config)).

```clojure
(require '[dn.service-detect.core :as sd])

;; Assuming `env` contains a map of environment variables and values
(def detected (sd/env->services env))
;; => will return a list containing the detected service properties
```

The resulting list will contain maps, where each map will look something like this:

```clojure
{:environment :kubernetes
 :host "10.96.132.86"           ; Host can be an ip address or a hostname
 :port 3306                     ; Port numbers are automatically parsed
 :service-name "my-mysql-svc"   ; The name of the service
 :port-name "mysql"             ; The name of the service port (if it's named)
 :tcp "tcp://10.96.132.86:3306"}
```

The code will try to extract as much information as possible from the environment
variables.  Because the functions try to "guess" the environment, it's possible
that a single service will be mapped to multiple environments (e.g. the result
could contain an entry for both Kubernetes and Gitlab environments).

## License

Copyright © 2020 by Debreuck Neirynck NV

This program and the accompanying materials are made available under the
terms of the Eclipse Public License 2.0 which is available at
http://www.eclipse.org/legal/epl-2.0.

This Source Code may also be made available under the following Secondary
Licenses when the conditions for such availability set forth in the Eclipse
Public License, v. 2.0 are satisfied: GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or (at your
option) any later version, with the GNU Classpath Exception which is available
at https://www.gnu.org/software/classpath/license.html.
