(ns dn.service-detect.gitlab
  "Gitlab service detection functions"
  (:require [dn.service-detect.utils :as u]))

(defn- env->service [env [key s port proto]]
  (let [val (get env (keyword key))
        uri (java.net.URI. val)]
    {:environment :gitlab
     :tcp val
     :protocol proto
     :port port
     :service-name s
     :host (.getHost uri)}))

(defn detect-gitlab-services [env]
  (->> (keys env)
       (map (comp (partial re-matches #"^(.*)-port-(\d+)-(tcp|udp)$") name))
       (filter some?)
       (map (partial env->service env))))
