// Compiled by ClojureScript 1.9.946 {:static-fns true, :optimize-constants true}
goog.provide('re_frame.trace');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('re_frame.interop');
goog.require('re_frame.loggers');
goog.require('goog.functions');
re_frame.trace.id = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
re_frame.trace._STAR_current_trace_STAR_ = null;
re_frame.trace.reset_tracing_BANG_ = (function re_frame$trace$reset_tracing_BANG_(){
return cljs.core.reset_BANG_(re_frame.trace.id,(0));
});

/** @define {boolean} */
goog.define("re_frame.trace.trace_enabled_QMARK_",false);
/**
 * See https://groups.google.com/d/msg/clojurescript/jk43kmYiMhA/IHglVr_TPdgJ for more details
 */
re_frame.trace.is_trace_enabled_QMARK_ = (function re_frame$trace$is_trace_enabled_QMARK_(){
return re_frame.trace.trace_enabled_QMARK_;
});
re_frame.trace.trace_cbs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
if(typeof re_frame.trace.traces !== 'undefined'){
} else {
re_frame.trace.traces = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
}
if(typeof re_frame.trace.next_delivery !== 'undefined'){
} else {
re_frame.trace.next_delivery = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
}
/**
 * Registers a tracing callback function which will receive a collection of one or more traces.
 *   Will replace an existing callback function if it shares the same key.
 */
re_frame.trace.register_trace_cb = (function re_frame$trace$register_trace_cb(key,f){
if(cljs.core.truth_(re_frame.trace.trace_enabled_QMARK_)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(re_frame.trace.trace_cbs,cljs.core.assoc,key,f);
} else {
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$warn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Tracing is not enabled. Please set {\"re_frame.trace.trace_enabled_QMARK_\" true} in :closure-defines. See: https://github.com/Day8/re-frame-trace#installation."], 0));
}
});
re_frame.trace.remove_trace_cb = (function re_frame$trace$remove_trace_cb(key){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.trace_cbs,cljs.core.dissoc,key);

return null;
});
re_frame.trace.next_id = (function re_frame$trace$next_id(){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(re_frame.trace.id,cljs.core.inc);
});
re_frame.trace.start_trace = (function re_frame$trace$start_trace(p__15670){
var map__15671 = p__15670;
var map__15671__$1 = ((((!((map__15671 == null)))?((((map__15671.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15671.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15671):map__15671);
var operation = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15671__$1,cljs.core.cst$kw$operation);
var op_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15671__$1,cljs.core.cst$kw$op_DASH_type);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15671__$1,cljs.core.cst$kw$tags);
var child_of = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15671__$1,cljs.core.cst$kw$child_DASH_of);
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$id,re_frame.trace.next_id(),cljs.core.cst$kw$operation,operation,cljs.core.cst$kw$op_DASH_type,op_type,cljs.core.cst$kw$tags,tags,cljs.core.cst$kw$child_DASH_of,(function (){var or__8806__auto__ = child_of;
if(cljs.core.truth_(or__8806__auto__)){
return or__8806__auto__;
} else {
return cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_);
}
})(),cljs.core.cst$kw$start,re_frame.interop.now()], null);
});
re_frame.trace.debounce_time = (50);
re_frame.trace.debounce = (function re_frame$trace$debounce(f,interval){
return goog.functions.debounce(f,interval);
});
re_frame.trace.schedule_debounce = re_frame.trace.debounce((function re_frame$trace$tracing_cb_debounced(){
var seq__15673_15687 = cljs.core.seq(cljs.core.deref(re_frame.trace.trace_cbs));
var chunk__15674_15688 = null;
var count__15675_15689 = (0);
var i__15676_15690 = (0);
while(true){
if((i__15676_15690 < count__15675_15689)){
var vec__15677_15691 = chunk__15674_15688.cljs$core$IIndexed$_nth$arity$2(null,i__15676_15690);
var k_15692 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15677_15691,(0),null);
var cb_15693 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15677_15691,(1),null);
try{var G__15681_15694 = cljs.core.deref(re_frame.trace.traces);
(cb_15693.cljs$core$IFn$_invoke$arity$1 ? cb_15693.cljs$core$IFn$_invoke$arity$1(G__15681_15694) : cb_15693.call(null,G__15681_15694));
}catch (e15680){var e_15695 = e15680;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_15692,"while storing",cljs.core.deref(re_frame.trace.traces),e_15695], 0));
}
var G__15696 = seq__15673_15687;
var G__15697 = chunk__15674_15688;
var G__15698 = count__15675_15689;
var G__15699 = (i__15676_15690 + (1));
seq__15673_15687 = G__15696;
chunk__15674_15688 = G__15697;
count__15675_15689 = G__15698;
i__15676_15690 = G__15699;
continue;
} else {
var temp__5457__auto___15700 = cljs.core.seq(seq__15673_15687);
if(temp__5457__auto___15700){
var seq__15673_15701__$1 = temp__5457__auto___15700;
if(cljs.core.chunked_seq_QMARK_(seq__15673_15701__$1)){
var c__9737__auto___15702 = cljs.core.chunk_first(seq__15673_15701__$1);
var G__15703 = cljs.core.chunk_rest(seq__15673_15701__$1);
var G__15704 = c__9737__auto___15702;
var G__15705 = cljs.core.count(c__9737__auto___15702);
var G__15706 = (0);
seq__15673_15687 = G__15703;
chunk__15674_15688 = G__15704;
count__15675_15689 = G__15705;
i__15676_15690 = G__15706;
continue;
} else {
var vec__15682_15707 = cljs.core.first(seq__15673_15701__$1);
var k_15708 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15682_15707,(0),null);
var cb_15709 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15682_15707,(1),null);
try{var G__15686_15710 = cljs.core.deref(re_frame.trace.traces);
(cb_15709.cljs$core$IFn$_invoke$arity$1 ? cb_15709.cljs$core$IFn$_invoke$arity$1(G__15686_15710) : cb_15709.call(null,G__15686_15710));
}catch (e15685){var e_15711 = e15685;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_15708,"while storing",cljs.core.deref(re_frame.trace.traces),e_15711], 0));
}
var G__15712 = cljs.core.next(seq__15673_15701__$1);
var G__15713 = null;
var G__15714 = (0);
var G__15715 = (0);
seq__15673_15687 = G__15712;
chunk__15674_15688 = G__15713;
count__15675_15689 = G__15714;
i__15676_15690 = G__15715;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_(re_frame.trace.traces,cljs.core.PersistentVector.EMPTY);
}),re_frame.trace.debounce_time);
re_frame.trace.run_tracing_callbacks_BANG_ = (function re_frame$trace$run_tracing_callbacks_BANG_(now){
if(((cljs.core.deref(re_frame.trace.next_delivery) - (10)) < now)){
(re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0 ? re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0() : re_frame.trace.schedule_debounce.call(null));

return cljs.core.reset_BANG_(re_frame.trace.next_delivery,(now + re_frame.trace.debounce_time));
} else {
return null;
}
});
