// Compiled by ClojureScript 1.9.946 {:static-fns true, :optimize-constants true}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.trace');
re_frame.fx.kind = cljs.core.cst$kw$fx;
if(cljs.core.truth_((re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1 ? re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1(re_frame.fx.kind) : re_frame.registrar.kinds.call(null,re_frame.fx.kind)))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler(re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$id,cljs.core.cst$kw$do_DASH_fx,cljs.core.cst$kw$after,(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR_20295 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$op_DASH_type,cljs.core.cst$kw$event_SLASH_do_DASH_fx], null));

try{try{var seq__20296 = cljs.core.seq(cljs.core.cst$kw$effects.cljs$core$IFn$_invoke$arity$1(context));
var chunk__20297 = null;
var count__20298 = (0);
var i__20299 = (0);
while(true){
if((i__20299 < count__20298)){
var vec__20300 = chunk__20297.cljs$core$IIndexed$_nth$arity$2(null,i__20299);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20300,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20300,(1),null);
var temp__5455__auto___20316 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___20316)){
var effect_fn_20317 = temp__5455__auto___20316;
(effect_fn_20317.cljs$core$IFn$_invoke$arity$1 ? effect_fn_20317.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_20317.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}

var G__20318 = seq__20296;
var G__20319 = chunk__20297;
var G__20320 = count__20298;
var G__20321 = (i__20299 + (1));
seq__20296 = G__20318;
chunk__20297 = G__20319;
count__20298 = G__20320;
i__20299 = G__20321;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__20296);
if(temp__5457__auto__){
var seq__20296__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__20296__$1)){
var c__9737__auto__ = cljs.core.chunk_first(seq__20296__$1);
var G__20322 = cljs.core.chunk_rest(seq__20296__$1);
var G__20323 = c__9737__auto__;
var G__20324 = cljs.core.count(c__9737__auto__);
var G__20325 = (0);
seq__20296 = G__20322;
chunk__20297 = G__20323;
count__20298 = G__20324;
i__20299 = G__20325;
continue;
} else {
var vec__20303 = cljs.core.first(seq__20296__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20303,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20303,(1),null);
var temp__5455__auto___20326 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___20326)){
var effect_fn_20327 = temp__5455__auto___20326;
(effect_fn_20327.cljs$core$IFn$_invoke$arity$1 ? effect_fn_20327.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_20327.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}

var G__20328 = cljs.core.next(seq__20296__$1);
var G__20329 = null;
var G__20330 = (0);
var G__20331 = (0);
seq__20296 = G__20328;
chunk__20297 = G__20329;
count__20298 = G__20330;
i__20299 = G__20331;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__15648__auto___20332 = re_frame.interop.now();
var duration__15649__auto___20333 = (end__15648__auto___20332 - cljs.core.cst$kw$start.cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$duration,duration__15649__auto___20333,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$end,re_frame.interop.now()], 0)));

re_frame.trace.run_tracing_callbacks_BANG_(end__15648__auto___20332);
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_20295;
}} else {
var seq__20306 = cljs.core.seq(cljs.core.cst$kw$effects.cljs$core$IFn$_invoke$arity$1(context));
var chunk__20307 = null;
var count__20308 = (0);
var i__20309 = (0);
while(true){
if((i__20309 < count__20308)){
var vec__20310 = chunk__20307.cljs$core$IIndexed$_nth$arity$2(null,i__20309);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20310,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20310,(1),null);
var temp__5455__auto___20334 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___20334)){
var effect_fn_20335 = temp__5455__auto___20334;
(effect_fn_20335.cljs$core$IFn$_invoke$arity$1 ? effect_fn_20335.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_20335.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}

var G__20336 = seq__20306;
var G__20337 = chunk__20307;
var G__20338 = count__20308;
var G__20339 = (i__20309 + (1));
seq__20306 = G__20336;
chunk__20307 = G__20337;
count__20308 = G__20338;
i__20309 = G__20339;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__20306);
if(temp__5457__auto__){
var seq__20306__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__20306__$1)){
var c__9737__auto__ = cljs.core.chunk_first(seq__20306__$1);
var G__20340 = cljs.core.chunk_rest(seq__20306__$1);
var G__20341 = c__9737__auto__;
var G__20342 = cljs.core.count(c__9737__auto__);
var G__20343 = (0);
seq__20306 = G__20340;
chunk__20307 = G__20341;
count__20308 = G__20342;
i__20309 = G__20343;
continue;
} else {
var vec__20313 = cljs.core.first(seq__20306__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20313,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20313,(1),null);
var temp__5455__auto___20344 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___20344)){
var effect_fn_20345 = temp__5455__auto___20344;
(effect_fn_20345.cljs$core$IFn$_invoke$arity$1 ? effect_fn_20345.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_20345.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}

var G__20346 = cljs.core.next(seq__20306__$1);
var G__20347 = null;
var G__20348 = (0);
var G__20349 = (0);
seq__20306 = G__20346;
chunk__20307 = G__20347;
count__20308 = G__20348;
i__20309 = G__20349;
continue;
}
} else {
return null;
}
}
break;
}
}
})], 0));
re_frame.fx.reg_fx(cljs.core.cst$kw$dispatch_DASH_later,(function (value){
var seq__20350 = cljs.core.seq(value);
var chunk__20351 = null;
var count__20352 = (0);
var i__20353 = (0);
while(true){
if((i__20353 < count__20352)){
var map__20354 = chunk__20351.cljs$core$IIndexed$_nth$arity$2(null,i__20353);
var map__20354__$1 = ((((!((map__20354 == null)))?((((map__20354.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20354.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20354):map__20354);
var effect = map__20354__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20354__$1,cljs.core.cst$kw$ms);
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20354__$1,cljs.core.cst$kw$dispatch);
if((cljs.core.empty_QMARK_(dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__20350,chunk__20351,count__20352,i__20353,map__20354,map__20354__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__20350,chunk__20351,count__20352,i__20353,map__20354,map__20354__$1,effect,ms,dispatch))
,ms);
}

var G__20358 = seq__20350;
var G__20359 = chunk__20351;
var G__20360 = count__20352;
var G__20361 = (i__20353 + (1));
seq__20350 = G__20358;
chunk__20351 = G__20359;
count__20352 = G__20360;
i__20353 = G__20361;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__20350);
if(temp__5457__auto__){
var seq__20350__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__20350__$1)){
var c__9737__auto__ = cljs.core.chunk_first(seq__20350__$1);
var G__20362 = cljs.core.chunk_rest(seq__20350__$1);
var G__20363 = c__9737__auto__;
var G__20364 = cljs.core.count(c__9737__auto__);
var G__20365 = (0);
seq__20350 = G__20362;
chunk__20351 = G__20363;
count__20352 = G__20364;
i__20353 = G__20365;
continue;
} else {
var map__20356 = cljs.core.first(seq__20350__$1);
var map__20356__$1 = ((((!((map__20356 == null)))?((((map__20356.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20356.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20356):map__20356);
var effect = map__20356__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20356__$1,cljs.core.cst$kw$ms);
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20356__$1,cljs.core.cst$kw$dispatch);
if((cljs.core.empty_QMARK_(dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__20350,chunk__20351,count__20352,i__20353,map__20356,map__20356__$1,effect,ms,dispatch,seq__20350__$1,temp__5457__auto__){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__20350,chunk__20351,count__20352,i__20353,map__20356,map__20356__$1,effect,ms,dispatch,seq__20350__$1,temp__5457__auto__))
,ms);
}

var G__20366 = cljs.core.next(seq__20350__$1);
var G__20367 = null;
var G__20368 = (0);
var G__20369 = (0);
seq__20350 = G__20366;
chunk__20351 = G__20367;
count__20352 = G__20368;
i__20353 = G__20369;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$dispatch,(function (value){
if(!(cljs.core.vector_QMARK_(value))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value], 0));
} else {
return re_frame.router.dispatch(value);
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$dispatch_DASH_n,(function (value){
if(!(cljs.core.sequential_QMARK_(value))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-n value. Expected a collection, got got:",value], 0));
} else {
var seq__20370 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__20371 = null;
var count__20372 = (0);
var i__20373 = (0);
while(true){
if((i__20373 < count__20372)){
var event = chunk__20371.cljs$core$IIndexed$_nth$arity$2(null,i__20373);
re_frame.router.dispatch(event);

var G__20374 = seq__20370;
var G__20375 = chunk__20371;
var G__20376 = count__20372;
var G__20377 = (i__20373 + (1));
seq__20370 = G__20374;
chunk__20371 = G__20375;
count__20372 = G__20376;
i__20373 = G__20377;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__20370);
if(temp__5457__auto__){
var seq__20370__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__20370__$1)){
var c__9737__auto__ = cljs.core.chunk_first(seq__20370__$1);
var G__20378 = cljs.core.chunk_rest(seq__20370__$1);
var G__20379 = c__9737__auto__;
var G__20380 = cljs.core.count(c__9737__auto__);
var G__20381 = (0);
seq__20370 = G__20378;
chunk__20371 = G__20379;
count__20372 = G__20380;
i__20373 = G__20381;
continue;
} else {
var event = cljs.core.first(seq__20370__$1);
re_frame.router.dispatch(event);

var G__20382 = cljs.core.next(seq__20370__$1);
var G__20383 = null;
var G__20384 = (0);
var G__20385 = (0);
seq__20370 = G__20382;
chunk__20371 = G__20383;
count__20372 = G__20384;
i__20373 = G__20385;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$deregister_DASH_event_DASH_handler,(function (value){
var clear_event = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_(value)){
var seq__20386 = cljs.core.seq(value);
var chunk__20387 = null;
var count__20388 = (0);
var i__20389 = (0);
while(true){
if((i__20389 < count__20388)){
var event = chunk__20387.cljs$core$IIndexed$_nth$arity$2(null,i__20389);
(clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(event) : clear_event.call(null,event));

var G__20390 = seq__20386;
var G__20391 = chunk__20387;
var G__20392 = count__20388;
var G__20393 = (i__20389 + (1));
seq__20386 = G__20390;
chunk__20387 = G__20391;
count__20388 = G__20392;
i__20389 = G__20393;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__20386);
if(temp__5457__auto__){
var seq__20386__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__20386__$1)){
var c__9737__auto__ = cljs.core.chunk_first(seq__20386__$1);
var G__20394 = cljs.core.chunk_rest(seq__20386__$1);
var G__20395 = c__9737__auto__;
var G__20396 = cljs.core.count(c__9737__auto__);
var G__20397 = (0);
seq__20386 = G__20394;
chunk__20387 = G__20395;
count__20388 = G__20396;
i__20389 = G__20397;
continue;
} else {
var event = cljs.core.first(seq__20386__$1);
(clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(event) : clear_event.call(null,event));

var G__20398 = cljs.core.next(seq__20386__$1);
var G__20399 = null;
var G__20400 = (0);
var G__20401 = (0);
seq__20386 = G__20398;
chunk__20387 = G__20399;
count__20388 = G__20400;
i__20389 = G__20401;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return (clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(value) : clear_event.call(null,value));
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$db,(function (value){
if(!((cljs.core.deref(re_frame.db.app_db) === value))){
return cljs.core.reset_BANG_(re_frame.db.app_db,value);
} else {
return null;
}
}));
