// Compiled by ClojureScript 1.9.946 {:static-fns true, :optimize-constants true}
goog.provide('clojure.data');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.set');
/**
 * Internal helper for diff.
 */
clojure.data.atom_diff = (function clojure$data$atom_diff(a,b){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a,b)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,a], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,null], null);
}
});
/**
 * Convert an associative-by-numeric-index collection into
 * an equivalent vector, with nil for any missing keys
 */
clojure.data.vectorize = (function clojure$data$vectorize(m){
if(cljs.core.seq(m)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (result,p__26365){
var vec__26366 = p__26365;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26366,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26366,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,k,v);
}),cljs.core.vec(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.keys(m)),null)),m);
} else {
return null;
}
});
/**
 * Diff associative things a and b, comparing only the key k.
 */
clojure.data.diff_associative_key = (function clojure$data$diff_associative_key(a,b,k){
var va = cljs.core.get.cljs$core$IFn$_invoke$arity$2(a,k);
var vb = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b,k);
var vec__26369 = (clojure.data.diff.cljs$core$IFn$_invoke$arity$2 ? clojure.data.diff.cljs$core$IFn$_invoke$arity$2(va,vb) : clojure.data.diff.call(null,va,vb));
var a_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26369,(0),null);
var b_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26369,(1),null);
var ab = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26369,(2),null);
var in_a = cljs.core.contains_QMARK_(a,k);
var in_b = cljs.core.contains_QMARK_(b,k);
var same = (in_a) && (in_b) && ((!((ab == null))) || (((va == null)) && ((vb == null))));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(((in_a) && ((!((a_STAR_ == null))) || (!(same))))?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,a_STAR_]):null),(((in_b) && ((!((b_STAR_ == null))) || (!(same))))?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,b_STAR_]):null),((same)?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,ab]):null)], null);
});
/**
 * Diff associative things a and b, comparing only keys in ks (if supplied).
 */
clojure.data.diff_associative = (function clojure$data$diff_associative(var_args){
var G__26373 = arguments.length;
switch (G__26373) {
case 2:
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3(a,b,clojure.set.union.cljs$core$IFn$_invoke$arity$2(cljs.core.keys(a),cljs.core.keys(b)));
});

clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3 = (function (a,b,ks){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (diff1,diff2){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.merge,diff1,diff2));
}),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,null], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(clojure.data.diff_associative_key,a,b),ks));
});

clojure.data.diff_associative.cljs$lang$maxFixedArity = 3;

clojure.data.diff_sequential = (function clojure$data$diff_sequential(a,b){
return cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.data.vectorize,clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3(((cljs.core.vector_QMARK_(a))?a:cljs.core.vec(a)),((cljs.core.vector_QMARK_(b))?b:cljs.core.vec(b)),cljs.core.range.cljs$core$IFn$_invoke$arity$1((function (){var x__9158__auto__ = cljs.core.count(a);
var y__9159__auto__ = cljs.core.count(b);
return ((x__9158__auto__ > y__9159__auto__) ? x__9158__auto__ : y__9159__auto__);
})()))));
});
clojure.data.diff_set = (function clojure$data$diff_set(a,b){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.not_empty(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(a,b)),cljs.core.not_empty(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(b,a)),cljs.core.not_empty(clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(a,b))], null);
});

/**
 * Implementation detail. Subject to change.
 * @interface
 */
clojure.data.EqualityPartition = function(){};

/**
 * Implementation detail. Subject to change.
 */
clojure.data.equality_partition = (function clojure$data$equality_partition(x){
if((!((x == null))) && (!((x.clojure$data$EqualityPartition$equality_partition$arity$1 == null)))){
return x.clojure$data$EqualityPartition$equality_partition$arity$1(x);
} else {
var x__9539__auto__ = (((x == null))?null:x);
var m__9540__auto__ = (clojure.data.equality_partition[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__9540__auto__.call(null,x));
} else {
var m__9540__auto____$1 = (clojure.data.equality_partition["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__9540__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("EqualityPartition.equality-partition",x);
}
}
}
});


/**
 * Implementation detail. Subject to change.
 * @interface
 */
clojure.data.Diff = function(){};

/**
 * Implementation detail. Subject to change.
 */
clojure.data.diff_similar = (function clojure$data$diff_similar(a,b){
if((!((a == null))) && (!((a.clojure$data$Diff$diff_similar$arity$2 == null)))){
return a.clojure$data$Diff$diff_similar$arity$2(a,b);
} else {
var x__9539__auto__ = (((a == null))?null:a);
var m__9540__auto__ = (clojure.data.diff_similar[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$2(a,b) : m__9540__auto__.call(null,a,b));
} else {
var m__9540__auto____$1 = (clojure.data.diff_similar["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2(a,b) : m__9540__auto____$1.call(null,a,b));
} else {
throw cljs.core.missing_protocol("Diff.diff-similar",a);
}
}
}
});

goog.object.set(clojure.data.EqualityPartition,"null",true);

var G__26375_26399 = clojure.data.equality_partition;
var G__26376_26400 = "null";
var G__26377_26401 = ((function (G__26375_26399,G__26376_26400){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__26375_26399,G__26376_26400))
;
goog.object.set(G__26375_26399,G__26376_26400,G__26377_26401);

goog.object.set(clojure.data.EqualityPartition,"string",true);

var G__26378_26402 = clojure.data.equality_partition;
var G__26379_26403 = "string";
var G__26380_26404 = ((function (G__26378_26402,G__26379_26403){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__26378_26402,G__26379_26403))
;
goog.object.set(G__26378_26402,G__26379_26403,G__26380_26404);

goog.object.set(clojure.data.EqualityPartition,"number",true);

var G__26381_26405 = clojure.data.equality_partition;
var G__26382_26406 = "number";
var G__26383_26407 = ((function (G__26381_26405,G__26382_26406){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__26381_26405,G__26382_26406))
;
goog.object.set(G__26381_26405,G__26382_26406,G__26383_26407);

goog.object.set(clojure.data.EqualityPartition,"array",true);

var G__26384_26408 = clojure.data.equality_partition;
var G__26385_26409 = "array";
var G__26386_26410 = ((function (G__26384_26408,G__26385_26409){
return (function (x){
return cljs.core.cst$kw$sequential;
});})(G__26384_26408,G__26385_26409))
;
goog.object.set(G__26384_26408,G__26385_26409,G__26386_26410);

goog.object.set(clojure.data.EqualityPartition,"function",true);

var G__26387_26411 = clojure.data.equality_partition;
var G__26388_26412 = "function";
var G__26389_26413 = ((function (G__26387_26411,G__26388_26412){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__26387_26411,G__26388_26412))
;
goog.object.set(G__26387_26411,G__26388_26412,G__26389_26413);

goog.object.set(clojure.data.EqualityPartition,"boolean",true);

var G__26390_26414 = clojure.data.equality_partition;
var G__26391_26415 = "boolean";
var G__26392_26416 = ((function (G__26390_26414,G__26391_26415){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__26390_26414,G__26391_26415))
;
goog.object.set(G__26390_26414,G__26391_26415,G__26392_26416);

goog.object.set(clojure.data.EqualityPartition,"_",true);

var G__26393_26417 = clojure.data.equality_partition;
var G__26394_26418 = "_";
var G__26395_26419 = ((function (G__26393_26417,G__26394_26418){
return (function (x){
if(((!((x == null)))?((((x.cljs$lang$protocol_mask$partition0$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMap$)))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x))){
return cljs.core.cst$kw$map;
} else {
if(((!((x == null)))?((((x.cljs$lang$protocol_mask$partition0$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISet$)))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x))){
return cljs.core.cst$kw$set;
} else {
if(((!((x == null)))?((((x.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISequential$)))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x))){
return cljs.core.cst$kw$sequential;
} else {
return cljs.core.cst$kw$atom;

}
}
}
});})(G__26393_26417,G__26394_26418))
;
goog.object.set(G__26393_26417,G__26394_26418,G__26395_26419);
goog.object.set(clojure.data.Diff,"null",true);

var G__26420_26444 = clojure.data.diff_similar;
var G__26421_26445 = "null";
var G__26422_26446 = ((function (G__26420_26444,G__26421_26445){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__26420_26444,G__26421_26445))
;
goog.object.set(G__26420_26444,G__26421_26445,G__26422_26446);

goog.object.set(clojure.data.Diff,"string",true);

var G__26423_26447 = clojure.data.diff_similar;
var G__26424_26448 = "string";
var G__26425_26449 = ((function (G__26423_26447,G__26424_26448){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__26423_26447,G__26424_26448))
;
goog.object.set(G__26423_26447,G__26424_26448,G__26425_26449);

goog.object.set(clojure.data.Diff,"number",true);

var G__26426_26450 = clojure.data.diff_similar;
var G__26427_26451 = "number";
var G__26428_26452 = ((function (G__26426_26450,G__26427_26451){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__26426_26450,G__26427_26451))
;
goog.object.set(G__26426_26450,G__26427_26451,G__26428_26452);

goog.object.set(clojure.data.Diff,"array",true);

var G__26429_26453 = clojure.data.diff_similar;
var G__26430_26454 = "array";
var G__26431_26455 = ((function (G__26429_26453,G__26430_26454){
return (function (a,b){
return clojure.data.diff_sequential(a,b);
});})(G__26429_26453,G__26430_26454))
;
goog.object.set(G__26429_26453,G__26430_26454,G__26431_26455);

goog.object.set(clojure.data.Diff,"function",true);

var G__26432_26456 = clojure.data.diff_similar;
var G__26433_26457 = "function";
var G__26434_26458 = ((function (G__26432_26456,G__26433_26457){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__26432_26456,G__26433_26457))
;
goog.object.set(G__26432_26456,G__26433_26457,G__26434_26458);

goog.object.set(clojure.data.Diff,"boolean",true);

var G__26435_26459 = clojure.data.diff_similar;
var G__26436_26460 = "boolean";
var G__26437_26461 = ((function (G__26435_26459,G__26436_26460){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__26435_26459,G__26436_26460))
;
goog.object.set(G__26435_26459,G__26436_26460,G__26437_26461);

goog.object.set(clojure.data.Diff,"_",true);

var G__26438_26462 = clojure.data.diff_similar;
var G__26439_26463 = "_";
var G__26440_26464 = ((function (G__26438_26462,G__26439_26463){
return (function (a,b){
var fexpr__26442 = (function (){var G__26443 = clojure.data.equality_partition(a);
var G__26443__$1 = (((G__26443 instanceof cljs.core.Keyword))?G__26443.fqn:null);
switch (G__26443__$1) {
case "atom":
return clojure.data.atom_diff;

break;
case "set":
return clojure.data.diff_set;

break;
case "sequential":
return clojure.data.diff_sequential;

break;
case "map":
return clojure.data.diff_associative;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__26443__$1)].join('')));

}
})();
return (fexpr__26442.cljs$core$IFn$_invoke$arity$2 ? fexpr__26442.cljs$core$IFn$_invoke$arity$2(a,b) : fexpr__26442.call(null,a,b));
});})(G__26438_26462,G__26439_26463))
;
goog.object.set(G__26438_26462,G__26439_26463,G__26440_26464);
/**
 * Recursively compares a and b, returning a tuple of
 *   [things-only-in-a things-only-in-b things-in-both].
 *   Comparison rules:
 * 
 *   * For equal a and b, return [nil nil a].
 *   * Maps are subdiffed where keys match and values differ.
 *   * Sets are never subdiffed.
 *   * All sequential things are treated as associative collections
 *  by their indexes, with results returned as vectors.
 *   * Everything else (including strings!) is treated as
 *  an atom and compared for equality.
 */
clojure.data.diff = (function clojure$data$diff(a,b){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a,b)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,a], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(clojure.data.equality_partition(a),clojure.data.equality_partition(b))){
return clojure.data.diff_similar(a,b);
} else {
return clojure.data.atom_diff(a,b);
}
}
});
