// Compiled by ClojureScript 1.9.946 {:static-fns true, :optimize-constants true}
goog.provide('cljs_ipfs_api.utils');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('camel_snake_kebab.core');
goog.require('camel_snake_kebab.extras');
goog.require('cljs.core.async');
goog.require('cljs_http.client');
goog.require('taoensso.timbre');
goog.require('clojure.string');
cljs_ipfs_api.utils.safe_case = (function cljs_ipfs_api$utils$safe_case(case_f){
return (function (x){
var G__26261 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.name(x),(1));
var G__26261__$1 = clojure.string.replace(G__26261,"_","*")
;
var G__26261__$2 = (case_f.cljs$core$IFn$_invoke$arity$1 ? case_f.cljs$core$IFn$_invoke$arity$1(G__26261__$1) : case_f.call(null,G__26261__$1))
;
var G__26261__$3 = clojure.string.replace(G__26261__$2,"*","_")
;
var G__26261__$4 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.name(x))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__26261__$3)].join('')
;
if((x instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(G__26261__$4);
} else {
return G__26261__$4;
}
});
});
cljs_ipfs_api.utils.camel_case = cljs_ipfs_api.utils.safe_case(camel_snake_kebab.core.__GT_camelCase);
cljs_ipfs_api.utils.kebab_case = cljs_ipfs_api.utils.safe_case(camel_snake_kebab.core.__GT_kebab_case);
cljs_ipfs_api.utils.js__GT_cljk = (function cljs_ipfs_api$utils$js__GT_cljk(p1__26262_SHARP_){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(p1__26262_SHARP_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
/**
 * From JavaScript to Clojure with kekab-cased keywords.
 */
cljs_ipfs_api.utils.js__GT_cljkk = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(camel_snake_kebab.extras.transform_keys,cljs_ipfs_api.utils.kebab_case),cljs_ipfs_api.utils.js__GT_cljk);
/**
 * From Clojure with kebab-cased keywords to JavaScript.
 */
cljs_ipfs_api.utils.cljkk__GT_js = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.clj__GT_js,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(camel_snake_kebab.extras.transform_keys,cljs_ipfs_api.utils.camel_case));
cljs_ipfs_api.utils.callback_js__GT_clj = (function cljs_ipfs_api$utils$callback_js__GT_clj(x){
if(cljs.core.fn_QMARK_(x)){
return (function (err,res){
if(cljs.core.truth_((function (){var and__8794__auto__ = res;
if(cljs.core.truth_(and__8794__auto__)){
return (res["v"]);
} else {
return and__8794__auto__;
}
})())){
(res["v"] = (res["v"]));
} else {
}

var G__26263 = err;
var G__26264 = (cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1 ? cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1(res) : cljs_ipfs_api.utils.js__GT_cljkk.call(null,res));
return (x.cljs$core$IFn$_invoke$arity$2 ? x.cljs$core$IFn$_invoke$arity$2(G__26263,G__26264) : x.call(null,G__26263,G__26264));
});
} else {
return x;
}
});
cljs_ipfs_api.utils.args_cljkk__GT_js = (function cljs_ipfs_api$utils$args_cljkk__GT_js(args){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs_ipfs_api.utils.cljkk__GT_js,cljs_ipfs_api.utils.callback_js__GT_clj),args);
});
cljs_ipfs_api.utils.js_apply = (function cljs_ipfs_api$utils$js_apply(var_args){
var G__26266 = arguments.length;
switch (G__26266) {
case 2:
return cljs_ipfs_api.utils.js_apply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs_ipfs_api.utils.js_apply.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs_ipfs_api.utils.js_apply.cljs$core$IFn$_invoke$arity$2 = (function (this$,method_name){
return cljs_ipfs_api.utils.js_apply.cljs$core$IFn$_invoke$arity$3(this$,method_name,null);
});

cljs_ipfs_api.utils.js_apply.cljs$core$IFn$_invoke$arity$3 = (function (this$,method_name,args){
if(cljs.core.truth_((this$[method_name]))){
var G__26267 = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.js_invoke,this$,method_name,cljs_ipfs_api.utils.args_cljkk__GT_js(args));
return (cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1 ? cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1(G__26267) : cljs_ipfs_api.utils.js__GT_cljkk.call(null,G__26267));
} else {
throw ["Method: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(method_name)," was not found in object."].join('');
}
});

cljs_ipfs_api.utils.js_apply.cljs$lang$maxFixedArity = 3;

cljs_ipfs_api.utils.js_prototype_apply = (function cljs_ipfs_api$utils$js_prototype_apply(js_obj,method_name,args){
return cljs_ipfs_api.utils.js_apply.cljs$core$IFn$_invoke$arity$3((js_obj["prototype"]),method_name,args);
});
cljs_ipfs_api.utils.wrap_callback = (function cljs_ipfs_api$utils$wrap_callback(f_n){
var callback = (function cljs_ipfs_api$utils$wrap_callback_$_callback(err,res){
if((f_n instanceof cljs.core.async.impl.channels.ManyToManyChannel)){
var c__18045__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18045__auto__){
return (function (){
var f__18046__auto__ = (function (){var switch__17943__auto__ = ((function (c__18045__auto__){
return (function (state_26277){
var state_val_26278 = (state_26277[(1)]);
if((state_val_26278 === (1))){
var inst_26269 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26270 = (cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1 ? cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1(err) : cljs_ipfs_api.utils.js__GT_cljkk.call(null,err));
var inst_26271 = (cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1 ? cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1(res) : cljs_ipfs_api.utils.js__GT_cljkk.call(null,res));
var inst_26272 = [inst_26270,inst_26271];
var inst_26273 = (new cljs.core.PersistentVector(null,2,(5),inst_26269,inst_26272,null));
var state_26277__$1 = state_26277;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_26277__$1,(2),f_n,inst_26273);
} else {
if((state_val_26278 === (2))){
var inst_26275 = (state_26277[(2)]);
var state_26277__$1 = state_26277;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26277__$1,inst_26275);
} else {
return null;
}
}
});})(c__18045__auto__))
;
return ((function (switch__17943__auto__,c__18045__auto__){
return (function() {
var cljs_ipfs_api$utils$wrap_callback_$_callback_$_state_machine__17944__auto__ = null;
var cljs_ipfs_api$utils$wrap_callback_$_callback_$_state_machine__17944__auto____0 = (function (){
var statearr_26279 = [null,null,null,null,null,null,null];
(statearr_26279[(0)] = cljs_ipfs_api$utils$wrap_callback_$_callback_$_state_machine__17944__auto__);

(statearr_26279[(1)] = (1));

return statearr_26279;
});
var cljs_ipfs_api$utils$wrap_callback_$_callback_$_state_machine__17944__auto____1 = (function (state_26277){
while(true){
var ret_value__17945__auto__ = (function (){try{while(true){
var result__17946__auto__ = switch__17943__auto__(state_26277);
if(cljs.core.keyword_identical_QMARK_(result__17946__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17946__auto__;
}
break;
}
}catch (e26280){if((e26280 instanceof Object)){
var ex__17947__auto__ = e26280;
var statearr_26281_26285 = state_26277;
(statearr_26281_26285[(5)] = ex__17947__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_26277);

return cljs.core.cst$kw$recur;
} else {
throw e26280;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17945__auto__,cljs.core.cst$kw$recur)){
var G__26286 = state_26277;
state_26277 = G__26286;
continue;
} else {
return ret_value__17945__auto__;
}
break;
}
});
cljs_ipfs_api$utils$wrap_callback_$_callback_$_state_machine__17944__auto__ = function(state_26277){
switch(arguments.length){
case 0:
return cljs_ipfs_api$utils$wrap_callback_$_callback_$_state_machine__17944__auto____0.call(this);
case 1:
return cljs_ipfs_api$utils$wrap_callback_$_callback_$_state_machine__17944__auto____1.call(this,state_26277);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs_ipfs_api$utils$wrap_callback_$_callback_$_state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_ipfs_api$utils$wrap_callback_$_callback_$_state_machine__17944__auto____0;
cljs_ipfs_api$utils$wrap_callback_$_callback_$_state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_ipfs_api$utils$wrap_callback_$_callback_$_state_machine__17944__auto____1;
return cljs_ipfs_api$utils$wrap_callback_$_callback_$_state_machine__17944__auto__;
})()
;})(switch__17943__auto__,c__18045__auto__))
})();
var state__18047__auto__ = (function (){var statearr_26282 = (f__18046__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18046__auto__.cljs$core$IFn$_invoke$arity$0() : f__18046__auto__.call(null));
(statearr_26282[(6)] = c__18045__auto__);

return statearr_26282;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18047__auto__);
});})(c__18045__auto__))
);

return c__18045__auto__;
} else {
if(cljs.core.fn_QMARK_(f_n)){
var G__26283 = (cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1 ? cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1(err) : cljs_ipfs_api.utils.js__GT_cljkk.call(null,err));
var G__26284 = (cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1 ? cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1(res) : cljs_ipfs_api.utils.js__GT_cljkk.call(null,res));
return (f_n.cljs$core$IFn$_invoke$arity$2 ? f_n.cljs$core$IFn$_invoke$arity$2(G__26283,G__26284) : f_n.call(null,G__26283,G__26284));
} else {
return f_n;
}
}
});
return callback;
});
cljs_ipfs_api.utils.is_blob_QMARK_ = (function cljs_ipfs_api$utils$is_blob_QMARK_(x){
return !(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(String,cljs.core.type(x)));
});
cljs_ipfs_api.utils.web_http_call = (function cljs_ipfs_api$utils$web_http_call(url,args,params){
var temp__5455__auto__ = cljs.core.cst$kw$callback.cljs$core$IFn$_invoke$arity$1(params);
if(cljs.core.truth_(temp__5455__auto__)){
var cb = temp__5455__auto__;
var c__18045__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18045__auto__,cb,temp__5455__auto__){
return (function (){
var f__18046__auto__ = (function (){var switch__17943__auto__ = ((function (c__18045__auto__,cb,temp__5455__auto__){
return (function (state_26324){
var state_val_26325 = (state_26324[(1)]);
if((state_val_26325 === (1))){
var inst_26296 = (state_26324[(7)]);
var inst_26287 = [cljs.core.cst$kw$query_DASH_params,cljs.core.cst$kw$with_DASH_credentials_QMARK_];
var inst_26288 = ["arg"];
var inst_26289 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs_ipfs_api.utils.is_blob_QMARK_,args);
var inst_26290 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",inst_26289);
var inst_26291 = [inst_26290];
var inst_26292 = cljs.core.PersistentHashMap.fromArrays(inst_26288,inst_26291);
var inst_26293 = [inst_26292,false];
var inst_26294 = cljs.core.PersistentHashMap.fromArrays(inst_26287,inst_26293);
var inst_26295 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs_ipfs_api.utils.is_blob_QMARK_,args);
var inst_26296__$1 = cljs.core.first(inst_26295);
var state_26324__$1 = (function (){var statearr_26326 = state_26324;
(statearr_26326[(7)] = inst_26296__$1);

(statearr_26326[(8)] = inst_26294);

return statearr_26326;
})();
if(cljs.core.truth_(inst_26296__$1)){
var statearr_26327_26340 = state_26324__$1;
(statearr_26327_26340[(1)] = (3));

} else {
var statearr_26328_26341 = state_26324__$1;
(statearr_26328_26341[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26325 === (2))){
var inst_26313 = (state_26324[(9)]);
var inst_26313__$1 = (state_26324[(2)]);
var inst_26314 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_26313__$1);
var inst_26315 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_26314,(200));
var state_26324__$1 = (function (){var statearr_26329 = state_26324;
(statearr_26329[(9)] = inst_26313__$1);

return statearr_26329;
})();
if(inst_26315){
var statearr_26330_26342 = state_26324__$1;
(statearr_26330_26342[(1)] = (6));

} else {
var statearr_26331_26343 = state_26324__$1;
(statearr_26331_26343[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26325 === (3))){
var inst_26296 = (state_26324[(7)]);
var inst_26298 = [cljs.core.cst$kw$multipart_DASH_params];
var inst_26299 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26300 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26301 = ["file",inst_26296];
var inst_26302 = (new cljs.core.PersistentVector(null,2,(5),inst_26300,inst_26301,null));
var inst_26303 = [inst_26302];
var inst_26304 = (new cljs.core.PersistentVector(null,1,(5),inst_26299,inst_26303,null));
var inst_26305 = [inst_26304];
var inst_26306 = cljs.core.PersistentHashMap.fromArrays(inst_26298,inst_26305);
var state_26324__$1 = state_26324;
var statearr_26332_26344 = state_26324__$1;
(statearr_26332_26344[(2)] = inst_26306);

(statearr_26332_26344[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26325 === (4))){
var state_26324__$1 = state_26324;
var statearr_26333_26345 = state_26324__$1;
(statearr_26333_26345[(2)] = null);

(statearr_26333_26345[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26325 === (5))){
var inst_26294 = (state_26324[(8)]);
var inst_26309 = (state_26324[(2)]);
var inst_26310 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_26294,inst_26309], 0));
var inst_26311 = cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic(url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_26310], 0));
var state_26324__$1 = state_26324;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26324__$1,(2),inst_26311);
} else {
if((state_val_26325 === (6))){
var inst_26313 = (state_26324[(9)]);
var inst_26317 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_26313);
var inst_26318 = (cb.cljs$core$IFn$_invoke$arity$2 ? cb.cljs$core$IFn$_invoke$arity$2(null,inst_26317) : cb.call(null,null,inst_26317));
var state_26324__$1 = state_26324;
var statearr_26334_26346 = state_26324__$1;
(statearr_26334_26346[(2)] = inst_26318);

(statearr_26334_26346[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26325 === (7))){
var inst_26313 = (state_26324[(9)]);
var inst_26320 = (cb.cljs$core$IFn$_invoke$arity$2 ? cb.cljs$core$IFn$_invoke$arity$2(inst_26313,null) : cb.call(null,inst_26313,null));
var state_26324__$1 = state_26324;
var statearr_26335_26347 = state_26324__$1;
(statearr_26335_26347[(2)] = inst_26320);

(statearr_26335_26347[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26325 === (8))){
var inst_26322 = (state_26324[(2)]);
var state_26324__$1 = state_26324;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26324__$1,inst_26322);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__18045__auto__,cb,temp__5455__auto__))
;
return ((function (switch__17943__auto__,c__18045__auto__,cb,temp__5455__auto__){
return (function() {
var cljs_ipfs_api$utils$web_http_call_$_state_machine__17944__auto__ = null;
var cljs_ipfs_api$utils$web_http_call_$_state_machine__17944__auto____0 = (function (){
var statearr_26336 = [null,null,null,null,null,null,null,null,null,null];
(statearr_26336[(0)] = cljs_ipfs_api$utils$web_http_call_$_state_machine__17944__auto__);

(statearr_26336[(1)] = (1));

return statearr_26336;
});
var cljs_ipfs_api$utils$web_http_call_$_state_machine__17944__auto____1 = (function (state_26324){
while(true){
var ret_value__17945__auto__ = (function (){try{while(true){
var result__17946__auto__ = switch__17943__auto__(state_26324);
if(cljs.core.keyword_identical_QMARK_(result__17946__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17946__auto__;
}
break;
}
}catch (e26337){if((e26337 instanceof Object)){
var ex__17947__auto__ = e26337;
var statearr_26338_26348 = state_26324;
(statearr_26338_26348[(5)] = ex__17947__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_26324);

return cljs.core.cst$kw$recur;
} else {
throw e26337;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17945__auto__,cljs.core.cst$kw$recur)){
var G__26349 = state_26324;
state_26324 = G__26349;
continue;
} else {
return ret_value__17945__auto__;
}
break;
}
});
cljs_ipfs_api$utils$web_http_call_$_state_machine__17944__auto__ = function(state_26324){
switch(arguments.length){
case 0:
return cljs_ipfs_api$utils$web_http_call_$_state_machine__17944__auto____0.call(this);
case 1:
return cljs_ipfs_api$utils$web_http_call_$_state_machine__17944__auto____1.call(this,state_26324);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs_ipfs_api$utils$web_http_call_$_state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_ipfs_api$utils$web_http_call_$_state_machine__17944__auto____0;
cljs_ipfs_api$utils$web_http_call_$_state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_ipfs_api$utils$web_http_call_$_state_machine__17944__auto____1;
return cljs_ipfs_api$utils$web_http_call_$_state_machine__17944__auto__;
})()
;})(switch__17943__auto__,c__18045__auto__,cb,temp__5455__auto__))
})();
var state__18047__auto__ = (function (){var statearr_26339 = (f__18046__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18046__auto__.cljs$core$IFn$_invoke$arity$0() : f__18046__auto__.call(null));
(statearr_26339[(6)] = c__18045__auto__);

return statearr_26339;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18047__auto__);
});})(c__18045__auto__,cb,temp__5455__auto__))
);

return c__18045__auto__;
} else {
return null;
}
});
cljs_ipfs_api.utils.node_http_call = (function cljs_ipfs_api$utils$node_http_call(url,args,params){
var temp__5455__auto__ = cljs.core.cst$kw$callback.cljs$core$IFn$_invoke$arity$1(params);
if(cljs.core.truth_(temp__5455__auto__)){
var cb = temp__5455__auto__;
var rm = require("request");
var fs = require("fs");
var on_done = ((function (rm,fs,cb,temp__5455__auto__){
return (function (err,oresp,obody){
var err__$1 = (cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1 ? cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1(err) : cljs_ipfs_api.utils.js__GT_cljkk.call(null,err));
var resp = (cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1 ? cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1(oresp) : cljs_ipfs_api.utils.js__GT_cljkk.call(null,oresp));
var body = (cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1 ? cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1(obody) : cljs_ipfs_api.utils.js__GT_cljkk.call(null,obody));
if(cljs.core.truth_(err__$1)){
return (cb.cljs$core$IFn$_invoke$arity$2 ? cb.cljs$core$IFn$_invoke$arity$2(err__$1,null) : cb.call(null,err__$1,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(resp.statusCode,(200))){
var G__26350 = null;
var G__26351 = (function (){try{return JSON.parse(body);
}catch (e26352){if((e26352 instanceof SyntaxError)){
var e = e26352;
return body;
} else {
throw e26352;

}
}})();
return (cb.cljs$core$IFn$_invoke$arity$2 ? cb.cljs$core$IFn$_invoke$arity$2(G__26350,G__26351) : cb.call(null,G__26350,G__26351));
} else {
var G__26353 = resp.statusMessage;
var G__26354 = null;
return (cb.cljs$core$IFn$_invoke$arity$2 ? cb.cljs$core$IFn$_invoke$arity$2(G__26353,G__26354) : cb.call(null,G__26353,G__26354));

}
}
});})(rm,fs,cb,temp__5455__auto__))
;
var form = (function (){var temp__5457__auto__ = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs_ipfs_api.utils.is_blob_QMARK_,args));
if(cljs.core.truth_(temp__5457__auto__)){
var b = temp__5457__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$formData,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$file,b], null)], null);
} else {
return null;
}
})();
var req = rm.post(cljs.core.clj__GT_js(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$qs,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arg,clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs_ipfs_api.utils.is_blob_QMARK_,args))], null),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$req_DASH_opts], null))], 0))], null),form], 0))),on_done);
var temp__5457__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$pipe_DASH_to], null));
if(cljs.core.truth_(temp__5457__auto__)){
var out = temp__5457__auto__;
return req.pipe(out);
} else {
return null;
}
} else {
return null;
}
});
cljs_ipfs_api.utils.http_call = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_target_STAR_,"nodejs"))?cljs_ipfs_api.utils.node_http_call:cljs_ipfs_api.utils.web_http_call);
cljs_ipfs_api.utils.api_call = (function cljs_ipfs_api$utils$api_call(inst,ac,args,params){
var G__26355 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$host.cljs$core$IFn$_invoke$arity$1(inst)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$endpoint.cljs$core$IFn$_invoke$arity$1(inst)),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ac)].join('');
var G__26356 = args;
var G__26357 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$opts,cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(params),cljs.core.cst$kw$callback,cljs.core.cst$kw$callback.cljs$core$IFn$_invoke$arity$1(params)], null)], 0));
return (cljs_ipfs_api.utils.http_call.cljs$core$IFn$_invoke$arity$3 ? cljs_ipfs_api.utils.http_call.cljs$core$IFn$_invoke$arity$3(G__26355,G__26356,G__26357) : cljs_ipfs_api.utils.http_call.call(null,G__26355,G__26356,G__26357));
});
