// Compiled by ClojureScript 1.9.946 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__18105 = arguments.length;
switch (G__18105) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async18106 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18106 = (function (f,blockable,meta18107){
this.f = f;
this.blockable = blockable;
this.meta18107 = meta18107;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18106.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18108,meta18107__$1){
var self__ = this;
var _18108__$1 = this;
return (new cljs.core.async.t_cljs$core$async18106(self__.f,self__.blockable,meta18107__$1));
});

cljs.core.async.t_cljs$core$async18106.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18108){
var self__ = this;
var _18108__$1 = this;
return self__.meta18107;
});

cljs.core.async.t_cljs$core$async18106.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18106.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async18106.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async18106.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async18106.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta18107], null);
});

cljs.core.async.t_cljs$core$async18106.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18106.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18106";

cljs.core.async.t_cljs$core$async18106.cljs$lang$ctorPrWriter = (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async18106");
});

cljs.core.async.__GT_t_cljs$core$async18106 = (function cljs$core$async$__GT_t_cljs$core$async18106(f__$1,blockable__$1,meta18107){
return (new cljs.core.async.t_cljs$core$async18106(f__$1,blockable__$1,meta18107));
});

}

return (new cljs.core.async.t_cljs$core$async18106(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__18112 = arguments.length;
switch (G__18112) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__18115 = arguments.length;
switch (G__18115) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__18118 = arguments.length;
switch (G__18118) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_18120 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_18120) : fn1.call(null,val_18120));
} else {
cljs.core.async.impl.dispatch.run(((function (val_18120,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_18120) : fn1.call(null,val_18120));
});})(val_18120,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__18122 = arguments.length;
switch (G__18122) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5455__auto__)){
var ret = temp__5455__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5455__auto__)){
var retb = temp__5455__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__5455__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__5455__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__9851__auto___18124 = n;
var x_18125 = (0);
while(true){
if((x_18125 < n__9851__auto___18124)){
(a[x_18125] = (0));

var G__18126 = (x_18125 + (1));
x_18125 = G__18126;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__18127 = (i + (1));
i = G__18127;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if(typeof cljs.core.async.t_cljs$core$async18128 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18128 = (function (flag,meta18129){
this.flag = flag;
this.meta18129 = meta18129;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18128.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_18130,meta18129__$1){
var self__ = this;
var _18130__$1 = this;
return (new cljs.core.async.t_cljs$core$async18128(self__.flag,meta18129__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async18128.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_18130){
var self__ = this;
var _18130__$1 = this;
return self__.meta18129;
});})(flag))
;

cljs.core.async.t_cljs$core$async18128.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18128.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async18128.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async18128.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async18128.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta18129], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async18128.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18128.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18128";

cljs.core.async.t_cljs$core$async18128.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async18128");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async18128 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async18128(flag__$1,meta18129){
return (new cljs.core.async.t_cljs$core$async18128(flag__$1,meta18129));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async18128(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async18131 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18131 = (function (flag,cb,meta18132){
this.flag = flag;
this.cb = cb;
this.meta18132 = meta18132;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18131.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18133,meta18132__$1){
var self__ = this;
var _18133__$1 = this;
return (new cljs.core.async.t_cljs$core$async18131(self__.flag,self__.cb,meta18132__$1));
});

cljs.core.async.t_cljs$core$async18131.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18133){
var self__ = this;
var _18133__$1 = this;
return self__.meta18132;
});

cljs.core.async.t_cljs$core$async18131.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18131.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async18131.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async18131.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async18131.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta18132], null);
});

cljs.core.async.t_cljs$core$async18131.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18131.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18131";

cljs.core.async.t_cljs$core$async18131.cljs$lang$ctorPrWriter = (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async18131");
});

cljs.core.async.__GT_t_cljs$core$async18131 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async18131(flag__$1,cb__$1,meta18132){
return (new cljs.core.async.t_cljs$core$async18131(flag__$1,cb__$1,meta18132));
});

}

return (new cljs.core.async.t_cljs$core$async18131(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__18134_SHARP_){
var G__18136 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__18134_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__18136) : fret.call(null,G__18136));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__18135_SHARP_){
var G__18137 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__18135_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__18137) : fret.call(null,G__18137));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__8806__auto__ = wport;
if(cljs.core.truth_(or__8806__auto__)){
return or__8806__auto__;
} else {
return port;
}
})()], null));
} else {
var G__18138 = (i + (1));
i = G__18138;
continue;
}
} else {
return null;
}
break;
}
})();
var or__8806__auto__ = ret;
if(cljs.core.truth_(or__8806__auto__)){
return or__8806__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__5457__auto__ = (function (){var and__8794__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__8794__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__8794__auto__;
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var got = temp__5457__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__10092__auto__ = [];
var len__10085__auto___18144 = arguments.length;
var i__10086__auto___18145 = (0);
while(true){
if((i__10086__auto___18145 < len__10085__auto___18144)){
args__10092__auto__.push((arguments[i__10086__auto___18145]));

var G__18146 = (i__10086__auto___18145 + (1));
i__10086__auto___18145 = G__18146;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((1) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10093__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__18141){
var map__18142 = p__18141;
var map__18142__$1 = ((((!((map__18142 == null)))?((((map__18142.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18142.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18142):map__18142);
var opts = map__18142__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq18139){
var G__18140 = cljs.core.first(seq18139);
var seq18139__$1 = cljs.core.next(seq18139);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__18140,seq18139__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__18148 = arguments.length;
switch (G__18148) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__18045__auto___18194 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18045__auto___18194){
return (function (){
var f__18046__auto__ = (function (){var switch__17943__auto__ = ((function (c__18045__auto___18194){
return (function (state_18172){
var state_val_18173 = (state_18172[(1)]);
if((state_val_18173 === (7))){
var inst_18168 = (state_18172[(2)]);
var state_18172__$1 = state_18172;
var statearr_18174_18195 = state_18172__$1;
(statearr_18174_18195[(2)] = inst_18168);

(statearr_18174_18195[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18173 === (1))){
var state_18172__$1 = state_18172;
var statearr_18175_18196 = state_18172__$1;
(statearr_18175_18196[(2)] = null);

(statearr_18175_18196[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18173 === (4))){
var inst_18151 = (state_18172[(7)]);
var inst_18151__$1 = (state_18172[(2)]);
var inst_18152 = (inst_18151__$1 == null);
var state_18172__$1 = (function (){var statearr_18176 = state_18172;
(statearr_18176[(7)] = inst_18151__$1);

return statearr_18176;
})();
if(cljs.core.truth_(inst_18152)){
var statearr_18177_18197 = state_18172__$1;
(statearr_18177_18197[(1)] = (5));

} else {
var statearr_18178_18198 = state_18172__$1;
(statearr_18178_18198[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18173 === (13))){
var state_18172__$1 = state_18172;
var statearr_18179_18199 = state_18172__$1;
(statearr_18179_18199[(2)] = null);

(statearr_18179_18199[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18173 === (6))){
var inst_18151 = (state_18172[(7)]);
var state_18172__$1 = state_18172;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18172__$1,(11),to,inst_18151);
} else {
if((state_val_18173 === (3))){
var inst_18170 = (state_18172[(2)]);
var state_18172__$1 = state_18172;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18172__$1,inst_18170);
} else {
if((state_val_18173 === (12))){
var state_18172__$1 = state_18172;
var statearr_18180_18200 = state_18172__$1;
(statearr_18180_18200[(2)] = null);

(statearr_18180_18200[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18173 === (2))){
var state_18172__$1 = state_18172;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18172__$1,(4),from);
} else {
if((state_val_18173 === (11))){
var inst_18161 = (state_18172[(2)]);
var state_18172__$1 = state_18172;
if(cljs.core.truth_(inst_18161)){
var statearr_18181_18201 = state_18172__$1;
(statearr_18181_18201[(1)] = (12));

} else {
var statearr_18182_18202 = state_18172__$1;
(statearr_18182_18202[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18173 === (9))){
var state_18172__$1 = state_18172;
var statearr_18183_18203 = state_18172__$1;
(statearr_18183_18203[(2)] = null);

(statearr_18183_18203[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18173 === (5))){
var state_18172__$1 = state_18172;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18184_18204 = state_18172__$1;
(statearr_18184_18204[(1)] = (8));

} else {
var statearr_18185_18205 = state_18172__$1;
(statearr_18185_18205[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18173 === (14))){
var inst_18166 = (state_18172[(2)]);
var state_18172__$1 = state_18172;
var statearr_18186_18206 = state_18172__$1;
(statearr_18186_18206[(2)] = inst_18166);

(statearr_18186_18206[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18173 === (10))){
var inst_18158 = (state_18172[(2)]);
var state_18172__$1 = state_18172;
var statearr_18187_18207 = state_18172__$1;
(statearr_18187_18207[(2)] = inst_18158);

(statearr_18187_18207[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18173 === (8))){
var inst_18155 = cljs.core.async.close_BANG_(to);
var state_18172__$1 = state_18172;
var statearr_18188_18208 = state_18172__$1;
(statearr_18188_18208[(2)] = inst_18155);

(statearr_18188_18208[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18045__auto___18194))
;
return ((function (switch__17943__auto__,c__18045__auto___18194){
return (function() {
var cljs$core$async$state_machine__17944__auto__ = null;
var cljs$core$async$state_machine__17944__auto____0 = (function (){
var statearr_18189 = [null,null,null,null,null,null,null,null];
(statearr_18189[(0)] = cljs$core$async$state_machine__17944__auto__);

(statearr_18189[(1)] = (1));

return statearr_18189;
});
var cljs$core$async$state_machine__17944__auto____1 = (function (state_18172){
while(true){
var ret_value__17945__auto__ = (function (){try{while(true){
var result__17946__auto__ = switch__17943__auto__(state_18172);
if(cljs.core.keyword_identical_QMARK_(result__17946__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17946__auto__;
}
break;
}
}catch (e18190){if((e18190 instanceof Object)){
var ex__17947__auto__ = e18190;
var statearr_18191_18209 = state_18172;
(statearr_18191_18209[(5)] = ex__17947__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18172);

return cljs.core.cst$kw$recur;
} else {
throw e18190;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17945__auto__,cljs.core.cst$kw$recur)){
var G__18210 = state_18172;
state_18172 = G__18210;
continue;
} else {
return ret_value__17945__auto__;
}
break;
}
});
cljs$core$async$state_machine__17944__auto__ = function(state_18172){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17944__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17944__auto____1.call(this,state_18172);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17944__auto____0;
cljs$core$async$state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17944__auto____1;
return cljs$core$async$state_machine__17944__auto__;
})()
;})(switch__17943__auto__,c__18045__auto___18194))
})();
var state__18047__auto__ = (function (){var statearr_18192 = (f__18046__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18046__auto__.cljs$core$IFn$_invoke$arity$0() : f__18046__auto__.call(null));
(statearr_18192[(6)] = c__18045__auto___18194);

return statearr_18192;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18047__auto__);
});})(c__18045__auto___18194))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__18211){
var vec__18212 = p__18211;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18212,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18212,(1),null);
var job = vec__18212;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__18045__auto___18383 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18045__auto___18383,res,vec__18212,v,p,job,jobs,results){
return (function (){
var f__18046__auto__ = (function (){var switch__17943__auto__ = ((function (c__18045__auto___18383,res,vec__18212,v,p,job,jobs,results){
return (function (state_18219){
var state_val_18220 = (state_18219[(1)]);
if((state_val_18220 === (1))){
var state_18219__$1 = state_18219;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18219__$1,(2),res,v);
} else {
if((state_val_18220 === (2))){
var inst_18216 = (state_18219[(2)]);
var inst_18217 = cljs.core.async.close_BANG_(res);
var state_18219__$1 = (function (){var statearr_18221 = state_18219;
(statearr_18221[(7)] = inst_18216);

return statearr_18221;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_18219__$1,inst_18217);
} else {
return null;
}
}
});})(c__18045__auto___18383,res,vec__18212,v,p,job,jobs,results))
;
return ((function (switch__17943__auto__,c__18045__auto___18383,res,vec__18212,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17944__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17944__auto____0 = (function (){
var statearr_18222 = [null,null,null,null,null,null,null,null];
(statearr_18222[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17944__auto__);

(statearr_18222[(1)] = (1));

return statearr_18222;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17944__auto____1 = (function (state_18219){
while(true){
var ret_value__17945__auto__ = (function (){try{while(true){
var result__17946__auto__ = switch__17943__auto__(state_18219);
if(cljs.core.keyword_identical_QMARK_(result__17946__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17946__auto__;
}
break;
}
}catch (e18223){if((e18223 instanceof Object)){
var ex__17947__auto__ = e18223;
var statearr_18224_18384 = state_18219;
(statearr_18224_18384[(5)] = ex__17947__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18219);

return cljs.core.cst$kw$recur;
} else {
throw e18223;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17945__auto__,cljs.core.cst$kw$recur)){
var G__18385 = state_18219;
state_18219 = G__18385;
continue;
} else {
return ret_value__17945__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17944__auto__ = function(state_18219){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17944__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17944__auto____1.call(this,state_18219);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17944__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17944__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17944__auto__;
})()
;})(switch__17943__auto__,c__18045__auto___18383,res,vec__18212,v,p,job,jobs,results))
})();
var state__18047__auto__ = (function (){var statearr_18225 = (f__18046__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18046__auto__.cljs$core$IFn$_invoke$arity$0() : f__18046__auto__.call(null));
(statearr_18225[(6)] = c__18045__auto___18383);

return statearr_18225;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18047__auto__);
});})(c__18045__auto___18383,res,vec__18212,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__18226){
var vec__18227 = p__18226;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18227,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18227,(1),null);
var job = vec__18227;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__9851__auto___18386 = n;
var __18387 = (0);
while(true){
if((__18387 < n__9851__auto___18386)){
var G__18230_18388 = type;
var G__18230_18389__$1 = (((G__18230_18388 instanceof cljs.core.Keyword))?G__18230_18388.fqn:null);
switch (G__18230_18389__$1) {
case "compute":
var c__18045__auto___18391 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__18387,c__18045__auto___18391,G__18230_18388,G__18230_18389__$1,n__9851__auto___18386,jobs,results,process,async){
return (function (){
var f__18046__auto__ = (function (){var switch__17943__auto__ = ((function (__18387,c__18045__auto___18391,G__18230_18388,G__18230_18389__$1,n__9851__auto___18386,jobs,results,process,async){
return (function (state_18243){
var state_val_18244 = (state_18243[(1)]);
if((state_val_18244 === (1))){
var state_18243__$1 = state_18243;
var statearr_18245_18392 = state_18243__$1;
(statearr_18245_18392[(2)] = null);

(statearr_18245_18392[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18244 === (2))){
var state_18243__$1 = state_18243;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18243__$1,(4),jobs);
} else {
if((state_val_18244 === (3))){
var inst_18241 = (state_18243[(2)]);
var state_18243__$1 = state_18243;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18243__$1,inst_18241);
} else {
if((state_val_18244 === (4))){
var inst_18233 = (state_18243[(2)]);
var inst_18234 = process(inst_18233);
var state_18243__$1 = state_18243;
if(cljs.core.truth_(inst_18234)){
var statearr_18246_18393 = state_18243__$1;
(statearr_18246_18393[(1)] = (5));

} else {
var statearr_18247_18394 = state_18243__$1;
(statearr_18247_18394[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18244 === (5))){
var state_18243__$1 = state_18243;
var statearr_18248_18395 = state_18243__$1;
(statearr_18248_18395[(2)] = null);

(statearr_18248_18395[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18244 === (6))){
var state_18243__$1 = state_18243;
var statearr_18249_18396 = state_18243__$1;
(statearr_18249_18396[(2)] = null);

(statearr_18249_18396[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18244 === (7))){
var inst_18239 = (state_18243[(2)]);
var state_18243__$1 = state_18243;
var statearr_18250_18397 = state_18243__$1;
(statearr_18250_18397[(2)] = inst_18239);

(statearr_18250_18397[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__18387,c__18045__auto___18391,G__18230_18388,G__18230_18389__$1,n__9851__auto___18386,jobs,results,process,async))
;
return ((function (__18387,switch__17943__auto__,c__18045__auto___18391,G__18230_18388,G__18230_18389__$1,n__9851__auto___18386,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17944__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17944__auto____0 = (function (){
var statearr_18251 = [null,null,null,null,null,null,null];
(statearr_18251[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17944__auto__);

(statearr_18251[(1)] = (1));

return statearr_18251;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17944__auto____1 = (function (state_18243){
while(true){
var ret_value__17945__auto__ = (function (){try{while(true){
var result__17946__auto__ = switch__17943__auto__(state_18243);
if(cljs.core.keyword_identical_QMARK_(result__17946__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17946__auto__;
}
break;
}
}catch (e18252){if((e18252 instanceof Object)){
var ex__17947__auto__ = e18252;
var statearr_18253_18398 = state_18243;
(statearr_18253_18398[(5)] = ex__17947__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18243);

return cljs.core.cst$kw$recur;
} else {
throw e18252;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17945__auto__,cljs.core.cst$kw$recur)){
var G__18399 = state_18243;
state_18243 = G__18399;
continue;
} else {
return ret_value__17945__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17944__auto__ = function(state_18243){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17944__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17944__auto____1.call(this,state_18243);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17944__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17944__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17944__auto__;
})()
;})(__18387,switch__17943__auto__,c__18045__auto___18391,G__18230_18388,G__18230_18389__$1,n__9851__auto___18386,jobs,results,process,async))
})();
var state__18047__auto__ = (function (){var statearr_18254 = (f__18046__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18046__auto__.cljs$core$IFn$_invoke$arity$0() : f__18046__auto__.call(null));
(statearr_18254[(6)] = c__18045__auto___18391);

return statearr_18254;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18047__auto__);
});})(__18387,c__18045__auto___18391,G__18230_18388,G__18230_18389__$1,n__9851__auto___18386,jobs,results,process,async))
);


break;
case "async":
var c__18045__auto___18400 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__18387,c__18045__auto___18400,G__18230_18388,G__18230_18389__$1,n__9851__auto___18386,jobs,results,process,async){
return (function (){
var f__18046__auto__ = (function (){var switch__17943__auto__ = ((function (__18387,c__18045__auto___18400,G__18230_18388,G__18230_18389__$1,n__9851__auto___18386,jobs,results,process,async){
return (function (state_18267){
var state_val_18268 = (state_18267[(1)]);
if((state_val_18268 === (1))){
var state_18267__$1 = state_18267;
var statearr_18269_18401 = state_18267__$1;
(statearr_18269_18401[(2)] = null);

(statearr_18269_18401[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18268 === (2))){
var state_18267__$1 = state_18267;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18267__$1,(4),jobs);
} else {
if((state_val_18268 === (3))){
var inst_18265 = (state_18267[(2)]);
var state_18267__$1 = state_18267;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18267__$1,inst_18265);
} else {
if((state_val_18268 === (4))){
var inst_18257 = (state_18267[(2)]);
var inst_18258 = async(inst_18257);
var state_18267__$1 = state_18267;
if(cljs.core.truth_(inst_18258)){
var statearr_18270_18402 = state_18267__$1;
(statearr_18270_18402[(1)] = (5));

} else {
var statearr_18271_18403 = state_18267__$1;
(statearr_18271_18403[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18268 === (5))){
var state_18267__$1 = state_18267;
var statearr_18272_18404 = state_18267__$1;
(statearr_18272_18404[(2)] = null);

(statearr_18272_18404[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18268 === (6))){
var state_18267__$1 = state_18267;
var statearr_18273_18405 = state_18267__$1;
(statearr_18273_18405[(2)] = null);

(statearr_18273_18405[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18268 === (7))){
var inst_18263 = (state_18267[(2)]);
var state_18267__$1 = state_18267;
var statearr_18274_18406 = state_18267__$1;
(statearr_18274_18406[(2)] = inst_18263);

(statearr_18274_18406[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__18387,c__18045__auto___18400,G__18230_18388,G__18230_18389__$1,n__9851__auto___18386,jobs,results,process,async))
;
return ((function (__18387,switch__17943__auto__,c__18045__auto___18400,G__18230_18388,G__18230_18389__$1,n__9851__auto___18386,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17944__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17944__auto____0 = (function (){
var statearr_18275 = [null,null,null,null,null,null,null];
(statearr_18275[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17944__auto__);

(statearr_18275[(1)] = (1));

return statearr_18275;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17944__auto____1 = (function (state_18267){
while(true){
var ret_value__17945__auto__ = (function (){try{while(true){
var result__17946__auto__ = switch__17943__auto__(state_18267);
if(cljs.core.keyword_identical_QMARK_(result__17946__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17946__auto__;
}
break;
}
}catch (e18276){if((e18276 instanceof Object)){
var ex__17947__auto__ = e18276;
var statearr_18277_18407 = state_18267;
(statearr_18277_18407[(5)] = ex__17947__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18267);

return cljs.core.cst$kw$recur;
} else {
throw e18276;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17945__auto__,cljs.core.cst$kw$recur)){
var G__18408 = state_18267;
state_18267 = G__18408;
continue;
} else {
return ret_value__17945__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17944__auto__ = function(state_18267){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17944__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17944__auto____1.call(this,state_18267);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17944__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17944__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17944__auto__;
})()
;})(__18387,switch__17943__auto__,c__18045__auto___18400,G__18230_18388,G__18230_18389__$1,n__9851__auto___18386,jobs,results,process,async))
})();
var state__18047__auto__ = (function (){var statearr_18278 = (f__18046__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18046__auto__.cljs$core$IFn$_invoke$arity$0() : f__18046__auto__.call(null));
(statearr_18278[(6)] = c__18045__auto___18400);

return statearr_18278;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18047__auto__);
});})(__18387,c__18045__auto___18400,G__18230_18388,G__18230_18389__$1,n__9851__auto___18386,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__18230_18389__$1)].join('')));

}

var G__18409 = (__18387 + (1));
__18387 = G__18409;
continue;
} else {
}
break;
}

var c__18045__auto___18410 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18045__auto___18410,jobs,results,process,async){
return (function (){
var f__18046__auto__ = (function (){var switch__17943__auto__ = ((function (c__18045__auto___18410,jobs,results,process,async){
return (function (state_18300){
var state_val_18301 = (state_18300[(1)]);
if((state_val_18301 === (1))){
var state_18300__$1 = state_18300;
var statearr_18302_18411 = state_18300__$1;
(statearr_18302_18411[(2)] = null);

(statearr_18302_18411[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18301 === (2))){
var state_18300__$1 = state_18300;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18300__$1,(4),from);
} else {
if((state_val_18301 === (3))){
var inst_18298 = (state_18300[(2)]);
var state_18300__$1 = state_18300;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18300__$1,inst_18298);
} else {
if((state_val_18301 === (4))){
var inst_18281 = (state_18300[(7)]);
var inst_18281__$1 = (state_18300[(2)]);
var inst_18282 = (inst_18281__$1 == null);
var state_18300__$1 = (function (){var statearr_18303 = state_18300;
(statearr_18303[(7)] = inst_18281__$1);

return statearr_18303;
})();
if(cljs.core.truth_(inst_18282)){
var statearr_18304_18412 = state_18300__$1;
(statearr_18304_18412[(1)] = (5));

} else {
var statearr_18305_18413 = state_18300__$1;
(statearr_18305_18413[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18301 === (5))){
var inst_18284 = cljs.core.async.close_BANG_(jobs);
var state_18300__$1 = state_18300;
var statearr_18306_18414 = state_18300__$1;
(statearr_18306_18414[(2)] = inst_18284);

(statearr_18306_18414[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18301 === (6))){
var inst_18286 = (state_18300[(8)]);
var inst_18281 = (state_18300[(7)]);
var inst_18286__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_18287 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18288 = [inst_18281,inst_18286__$1];
var inst_18289 = (new cljs.core.PersistentVector(null,2,(5),inst_18287,inst_18288,null));
var state_18300__$1 = (function (){var statearr_18307 = state_18300;
(statearr_18307[(8)] = inst_18286__$1);

return statearr_18307;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18300__$1,(8),jobs,inst_18289);
} else {
if((state_val_18301 === (7))){
var inst_18296 = (state_18300[(2)]);
var state_18300__$1 = state_18300;
var statearr_18308_18415 = state_18300__$1;
(statearr_18308_18415[(2)] = inst_18296);

(statearr_18308_18415[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18301 === (8))){
var inst_18286 = (state_18300[(8)]);
var inst_18291 = (state_18300[(2)]);
var state_18300__$1 = (function (){var statearr_18309 = state_18300;
(statearr_18309[(9)] = inst_18291);

return statearr_18309;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18300__$1,(9),results,inst_18286);
} else {
if((state_val_18301 === (9))){
var inst_18293 = (state_18300[(2)]);
var state_18300__$1 = (function (){var statearr_18310 = state_18300;
(statearr_18310[(10)] = inst_18293);

return statearr_18310;
})();
var statearr_18311_18416 = state_18300__$1;
(statearr_18311_18416[(2)] = null);

(statearr_18311_18416[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__18045__auto___18410,jobs,results,process,async))
;
return ((function (switch__17943__auto__,c__18045__auto___18410,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17944__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17944__auto____0 = (function (){
var statearr_18312 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18312[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17944__auto__);

(statearr_18312[(1)] = (1));

return statearr_18312;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17944__auto____1 = (function (state_18300){
while(true){
var ret_value__17945__auto__ = (function (){try{while(true){
var result__17946__auto__ = switch__17943__auto__(state_18300);
if(cljs.core.keyword_identical_QMARK_(result__17946__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17946__auto__;
}
break;
}
}catch (e18313){if((e18313 instanceof Object)){
var ex__17947__auto__ = e18313;
var statearr_18314_18417 = state_18300;
(statearr_18314_18417[(5)] = ex__17947__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18300);

return cljs.core.cst$kw$recur;
} else {
throw e18313;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17945__auto__,cljs.core.cst$kw$recur)){
var G__18418 = state_18300;
state_18300 = G__18418;
continue;
} else {
return ret_value__17945__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17944__auto__ = function(state_18300){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17944__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17944__auto____1.call(this,state_18300);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17944__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17944__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17944__auto__;
})()
;})(switch__17943__auto__,c__18045__auto___18410,jobs,results,process,async))
})();
var state__18047__auto__ = (function (){var statearr_18315 = (f__18046__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18046__auto__.cljs$core$IFn$_invoke$arity$0() : f__18046__auto__.call(null));
(statearr_18315[(6)] = c__18045__auto___18410);

return statearr_18315;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18047__auto__);
});})(c__18045__auto___18410,jobs,results,process,async))
);


var c__18045__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18045__auto__,jobs,results,process,async){
return (function (){
var f__18046__auto__ = (function (){var switch__17943__auto__ = ((function (c__18045__auto__,jobs,results,process,async){
return (function (state_18353){
var state_val_18354 = (state_18353[(1)]);
if((state_val_18354 === (7))){
var inst_18349 = (state_18353[(2)]);
var state_18353__$1 = state_18353;
var statearr_18355_18419 = state_18353__$1;
(statearr_18355_18419[(2)] = inst_18349);

(statearr_18355_18419[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18354 === (20))){
var state_18353__$1 = state_18353;
var statearr_18356_18420 = state_18353__$1;
(statearr_18356_18420[(2)] = null);

(statearr_18356_18420[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18354 === (1))){
var state_18353__$1 = state_18353;
var statearr_18357_18421 = state_18353__$1;
(statearr_18357_18421[(2)] = null);

(statearr_18357_18421[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18354 === (4))){
var inst_18318 = (state_18353[(7)]);
var inst_18318__$1 = (state_18353[(2)]);
var inst_18319 = (inst_18318__$1 == null);
var state_18353__$1 = (function (){var statearr_18358 = state_18353;
(statearr_18358[(7)] = inst_18318__$1);

return statearr_18358;
})();
if(cljs.core.truth_(inst_18319)){
var statearr_18359_18422 = state_18353__$1;
(statearr_18359_18422[(1)] = (5));

} else {
var statearr_18360_18423 = state_18353__$1;
(statearr_18360_18423[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18354 === (15))){
var inst_18331 = (state_18353[(8)]);
var state_18353__$1 = state_18353;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18353__$1,(18),to,inst_18331);
} else {
if((state_val_18354 === (21))){
var inst_18344 = (state_18353[(2)]);
var state_18353__$1 = state_18353;
var statearr_18361_18424 = state_18353__$1;
(statearr_18361_18424[(2)] = inst_18344);

(statearr_18361_18424[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18354 === (13))){
var inst_18346 = (state_18353[(2)]);
var state_18353__$1 = (function (){var statearr_18362 = state_18353;
(statearr_18362[(9)] = inst_18346);

return statearr_18362;
})();
var statearr_18363_18425 = state_18353__$1;
(statearr_18363_18425[(2)] = null);

(statearr_18363_18425[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18354 === (6))){
var inst_18318 = (state_18353[(7)]);
var state_18353__$1 = state_18353;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18353__$1,(11),inst_18318);
} else {
if((state_val_18354 === (17))){
var inst_18339 = (state_18353[(2)]);
var state_18353__$1 = state_18353;
if(cljs.core.truth_(inst_18339)){
var statearr_18364_18426 = state_18353__$1;
(statearr_18364_18426[(1)] = (19));

} else {
var statearr_18365_18427 = state_18353__$1;
(statearr_18365_18427[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18354 === (3))){
var inst_18351 = (state_18353[(2)]);
var state_18353__$1 = state_18353;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18353__$1,inst_18351);
} else {
if((state_val_18354 === (12))){
var inst_18328 = (state_18353[(10)]);
var state_18353__$1 = state_18353;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18353__$1,(14),inst_18328);
} else {
if((state_val_18354 === (2))){
var state_18353__$1 = state_18353;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18353__$1,(4),results);
} else {
if((state_val_18354 === (19))){
var state_18353__$1 = state_18353;
var statearr_18366_18428 = state_18353__$1;
(statearr_18366_18428[(2)] = null);

(statearr_18366_18428[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18354 === (11))){
var inst_18328 = (state_18353[(2)]);
var state_18353__$1 = (function (){var statearr_18367 = state_18353;
(statearr_18367[(10)] = inst_18328);

return statearr_18367;
})();
var statearr_18368_18429 = state_18353__$1;
(statearr_18368_18429[(2)] = null);

(statearr_18368_18429[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18354 === (9))){
var state_18353__$1 = state_18353;
var statearr_18369_18430 = state_18353__$1;
(statearr_18369_18430[(2)] = null);

(statearr_18369_18430[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18354 === (5))){
var state_18353__$1 = state_18353;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18370_18431 = state_18353__$1;
(statearr_18370_18431[(1)] = (8));

} else {
var statearr_18371_18432 = state_18353__$1;
(statearr_18371_18432[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18354 === (14))){
var inst_18333 = (state_18353[(11)]);
var inst_18331 = (state_18353[(8)]);
var inst_18331__$1 = (state_18353[(2)]);
var inst_18332 = (inst_18331__$1 == null);
var inst_18333__$1 = cljs.core.not(inst_18332);
var state_18353__$1 = (function (){var statearr_18372 = state_18353;
(statearr_18372[(11)] = inst_18333__$1);

(statearr_18372[(8)] = inst_18331__$1);

return statearr_18372;
})();
if(inst_18333__$1){
var statearr_18373_18433 = state_18353__$1;
(statearr_18373_18433[(1)] = (15));

} else {
var statearr_18374_18434 = state_18353__$1;
(statearr_18374_18434[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18354 === (16))){
var inst_18333 = (state_18353[(11)]);
var state_18353__$1 = state_18353;
var statearr_18375_18435 = state_18353__$1;
(statearr_18375_18435[(2)] = inst_18333);

(statearr_18375_18435[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18354 === (10))){
var inst_18325 = (state_18353[(2)]);
var state_18353__$1 = state_18353;
var statearr_18376_18436 = state_18353__$1;
(statearr_18376_18436[(2)] = inst_18325);

(statearr_18376_18436[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18354 === (18))){
var inst_18336 = (state_18353[(2)]);
var state_18353__$1 = state_18353;
var statearr_18377_18437 = state_18353__$1;
(statearr_18377_18437[(2)] = inst_18336);

(statearr_18377_18437[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18354 === (8))){
var inst_18322 = cljs.core.async.close_BANG_(to);
var state_18353__$1 = state_18353;
var statearr_18378_18438 = state_18353__$1;
(statearr_18378_18438[(2)] = inst_18322);

(statearr_18378_18438[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18045__auto__,jobs,results,process,async))
;
return ((function (switch__17943__auto__,c__18045__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17944__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17944__auto____0 = (function (){
var statearr_18379 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18379[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17944__auto__);

(statearr_18379[(1)] = (1));

return statearr_18379;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17944__auto____1 = (function (state_18353){
while(true){
var ret_value__17945__auto__ = (function (){try{while(true){
var result__17946__auto__ = switch__17943__auto__(state_18353);
if(cljs.core.keyword_identical_QMARK_(result__17946__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17946__auto__;
}
break;
}
}catch (e18380){if((e18380 instanceof Object)){
var ex__17947__auto__ = e18380;
var statearr_18381_18439 = state_18353;
(statearr_18381_18439[(5)] = ex__17947__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18353);

return cljs.core.cst$kw$recur;
} else {
throw e18380;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17945__auto__,cljs.core.cst$kw$recur)){
var G__18440 = state_18353;
state_18353 = G__18440;
continue;
} else {
return ret_value__17945__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17944__auto__ = function(state_18353){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17944__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17944__auto____1.call(this,state_18353);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17944__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17944__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17944__auto__;
})()
;})(switch__17943__auto__,c__18045__auto__,jobs,results,process,async))
})();
var state__18047__auto__ = (function (){var statearr_18382 = (f__18046__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18046__auto__.cljs$core$IFn$_invoke$arity$0() : f__18046__auto__.call(null));
(statearr_18382[(6)] = c__18045__auto__);

return statearr_18382;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18047__auto__);
});})(c__18045__auto__,jobs,results,process,async))
);

return c__18045__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__18442 = arguments.length;
switch (G__18442) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__18445 = arguments.length;
switch (G__18445) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__18448 = arguments.length;
switch (G__18448) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__18045__auto___18497 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18045__auto___18497,tc,fc){
return (function (){
var f__18046__auto__ = (function (){var switch__17943__auto__ = ((function (c__18045__auto___18497,tc,fc){
return (function (state_18474){
var state_val_18475 = (state_18474[(1)]);
if((state_val_18475 === (7))){
var inst_18470 = (state_18474[(2)]);
var state_18474__$1 = state_18474;
var statearr_18476_18498 = state_18474__$1;
(statearr_18476_18498[(2)] = inst_18470);

(statearr_18476_18498[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18475 === (1))){
var state_18474__$1 = state_18474;
var statearr_18477_18499 = state_18474__$1;
(statearr_18477_18499[(2)] = null);

(statearr_18477_18499[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18475 === (4))){
var inst_18451 = (state_18474[(7)]);
var inst_18451__$1 = (state_18474[(2)]);
var inst_18452 = (inst_18451__$1 == null);
var state_18474__$1 = (function (){var statearr_18478 = state_18474;
(statearr_18478[(7)] = inst_18451__$1);

return statearr_18478;
})();
if(cljs.core.truth_(inst_18452)){
var statearr_18479_18500 = state_18474__$1;
(statearr_18479_18500[(1)] = (5));

} else {
var statearr_18480_18501 = state_18474__$1;
(statearr_18480_18501[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18475 === (13))){
var state_18474__$1 = state_18474;
var statearr_18481_18502 = state_18474__$1;
(statearr_18481_18502[(2)] = null);

(statearr_18481_18502[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18475 === (6))){
var inst_18451 = (state_18474[(7)]);
var inst_18457 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_18451) : p.call(null,inst_18451));
var state_18474__$1 = state_18474;
if(cljs.core.truth_(inst_18457)){
var statearr_18482_18503 = state_18474__$1;
(statearr_18482_18503[(1)] = (9));

} else {
var statearr_18483_18504 = state_18474__$1;
(statearr_18483_18504[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18475 === (3))){
var inst_18472 = (state_18474[(2)]);
var state_18474__$1 = state_18474;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18474__$1,inst_18472);
} else {
if((state_val_18475 === (12))){
var state_18474__$1 = state_18474;
var statearr_18484_18505 = state_18474__$1;
(statearr_18484_18505[(2)] = null);

(statearr_18484_18505[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18475 === (2))){
var state_18474__$1 = state_18474;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18474__$1,(4),ch);
} else {
if((state_val_18475 === (11))){
var inst_18451 = (state_18474[(7)]);
var inst_18461 = (state_18474[(2)]);
var state_18474__$1 = state_18474;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18474__$1,(8),inst_18461,inst_18451);
} else {
if((state_val_18475 === (9))){
var state_18474__$1 = state_18474;
var statearr_18485_18506 = state_18474__$1;
(statearr_18485_18506[(2)] = tc);

(statearr_18485_18506[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18475 === (5))){
var inst_18454 = cljs.core.async.close_BANG_(tc);
var inst_18455 = cljs.core.async.close_BANG_(fc);
var state_18474__$1 = (function (){var statearr_18486 = state_18474;
(statearr_18486[(8)] = inst_18454);

return statearr_18486;
})();
var statearr_18487_18507 = state_18474__$1;
(statearr_18487_18507[(2)] = inst_18455);

(statearr_18487_18507[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18475 === (14))){
var inst_18468 = (state_18474[(2)]);
var state_18474__$1 = state_18474;
var statearr_18488_18508 = state_18474__$1;
(statearr_18488_18508[(2)] = inst_18468);

(statearr_18488_18508[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18475 === (10))){
var state_18474__$1 = state_18474;
var statearr_18489_18509 = state_18474__$1;
(statearr_18489_18509[(2)] = fc);

(statearr_18489_18509[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18475 === (8))){
var inst_18463 = (state_18474[(2)]);
var state_18474__$1 = state_18474;
if(cljs.core.truth_(inst_18463)){
var statearr_18490_18510 = state_18474__$1;
(statearr_18490_18510[(1)] = (12));

} else {
var statearr_18491_18511 = state_18474__$1;
(statearr_18491_18511[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18045__auto___18497,tc,fc))
;
return ((function (switch__17943__auto__,c__18045__auto___18497,tc,fc){
return (function() {
var cljs$core$async$state_machine__17944__auto__ = null;
var cljs$core$async$state_machine__17944__auto____0 = (function (){
var statearr_18492 = [null,null,null,null,null,null,null,null,null];
(statearr_18492[(0)] = cljs$core$async$state_machine__17944__auto__);

(statearr_18492[(1)] = (1));

return statearr_18492;
});
var cljs$core$async$state_machine__17944__auto____1 = (function (state_18474){
while(true){
var ret_value__17945__auto__ = (function (){try{while(true){
var result__17946__auto__ = switch__17943__auto__(state_18474);
if(cljs.core.keyword_identical_QMARK_(result__17946__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17946__auto__;
}
break;
}
}catch (e18493){if((e18493 instanceof Object)){
var ex__17947__auto__ = e18493;
var statearr_18494_18512 = state_18474;
(statearr_18494_18512[(5)] = ex__17947__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18474);

return cljs.core.cst$kw$recur;
} else {
throw e18493;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17945__auto__,cljs.core.cst$kw$recur)){
var G__18513 = state_18474;
state_18474 = G__18513;
continue;
} else {
return ret_value__17945__auto__;
}
break;
}
});
cljs$core$async$state_machine__17944__auto__ = function(state_18474){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17944__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17944__auto____1.call(this,state_18474);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17944__auto____0;
cljs$core$async$state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17944__auto____1;
return cljs$core$async$state_machine__17944__auto__;
})()
;})(switch__17943__auto__,c__18045__auto___18497,tc,fc))
})();
var state__18047__auto__ = (function (){var statearr_18495 = (f__18046__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18046__auto__.cljs$core$IFn$_invoke$arity$0() : f__18046__auto__.call(null));
(statearr_18495[(6)] = c__18045__auto___18497);

return statearr_18495;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18047__auto__);
});})(c__18045__auto___18497,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__18045__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18045__auto__){
return (function (){
var f__18046__auto__ = (function (){var switch__17943__auto__ = ((function (c__18045__auto__){
return (function (state_18534){
var state_val_18535 = (state_18534[(1)]);
if((state_val_18535 === (7))){
var inst_18530 = (state_18534[(2)]);
var state_18534__$1 = state_18534;
var statearr_18536_18554 = state_18534__$1;
(statearr_18536_18554[(2)] = inst_18530);

(statearr_18536_18554[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18535 === (1))){
var inst_18514 = init;
var state_18534__$1 = (function (){var statearr_18537 = state_18534;
(statearr_18537[(7)] = inst_18514);

return statearr_18537;
})();
var statearr_18538_18555 = state_18534__$1;
(statearr_18538_18555[(2)] = null);

(statearr_18538_18555[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18535 === (4))){
var inst_18517 = (state_18534[(8)]);
var inst_18517__$1 = (state_18534[(2)]);
var inst_18518 = (inst_18517__$1 == null);
var state_18534__$1 = (function (){var statearr_18539 = state_18534;
(statearr_18539[(8)] = inst_18517__$1);

return statearr_18539;
})();
if(cljs.core.truth_(inst_18518)){
var statearr_18540_18556 = state_18534__$1;
(statearr_18540_18556[(1)] = (5));

} else {
var statearr_18541_18557 = state_18534__$1;
(statearr_18541_18557[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18535 === (6))){
var inst_18521 = (state_18534[(9)]);
var inst_18514 = (state_18534[(7)]);
var inst_18517 = (state_18534[(8)]);
var inst_18521__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_18514,inst_18517) : f.call(null,inst_18514,inst_18517));
var inst_18522 = cljs.core.reduced_QMARK_(inst_18521__$1);
var state_18534__$1 = (function (){var statearr_18542 = state_18534;
(statearr_18542[(9)] = inst_18521__$1);

return statearr_18542;
})();
if(inst_18522){
var statearr_18543_18558 = state_18534__$1;
(statearr_18543_18558[(1)] = (8));

} else {
var statearr_18544_18559 = state_18534__$1;
(statearr_18544_18559[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18535 === (3))){
var inst_18532 = (state_18534[(2)]);
var state_18534__$1 = state_18534;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18534__$1,inst_18532);
} else {
if((state_val_18535 === (2))){
var state_18534__$1 = state_18534;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18534__$1,(4),ch);
} else {
if((state_val_18535 === (9))){
var inst_18521 = (state_18534[(9)]);
var inst_18514 = inst_18521;
var state_18534__$1 = (function (){var statearr_18545 = state_18534;
(statearr_18545[(7)] = inst_18514);

return statearr_18545;
})();
var statearr_18546_18560 = state_18534__$1;
(statearr_18546_18560[(2)] = null);

(statearr_18546_18560[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18535 === (5))){
var inst_18514 = (state_18534[(7)]);
var state_18534__$1 = state_18534;
var statearr_18547_18561 = state_18534__$1;
(statearr_18547_18561[(2)] = inst_18514);

(statearr_18547_18561[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18535 === (10))){
var inst_18528 = (state_18534[(2)]);
var state_18534__$1 = state_18534;
var statearr_18548_18562 = state_18534__$1;
(statearr_18548_18562[(2)] = inst_18528);

(statearr_18548_18562[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18535 === (8))){
var inst_18521 = (state_18534[(9)]);
var inst_18524 = cljs.core.deref(inst_18521);
var state_18534__$1 = state_18534;
var statearr_18549_18563 = state_18534__$1;
(statearr_18549_18563[(2)] = inst_18524);

(statearr_18549_18563[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__18045__auto__))
;
return ((function (switch__17943__auto__,c__18045__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__17944__auto__ = null;
var cljs$core$async$reduce_$_state_machine__17944__auto____0 = (function (){
var statearr_18550 = [null,null,null,null,null,null,null,null,null,null];
(statearr_18550[(0)] = cljs$core$async$reduce_$_state_machine__17944__auto__);

(statearr_18550[(1)] = (1));

return statearr_18550;
});
var cljs$core$async$reduce_$_state_machine__17944__auto____1 = (function (state_18534){
while(true){
var ret_value__17945__auto__ = (function (){try{while(true){
var result__17946__auto__ = switch__17943__auto__(state_18534);
if(cljs.core.keyword_identical_QMARK_(result__17946__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17946__auto__;
}
break;
}
}catch (e18551){if((e18551 instanceof Object)){
var ex__17947__auto__ = e18551;
var statearr_18552_18564 = state_18534;
(statearr_18552_18564[(5)] = ex__17947__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18534);

return cljs.core.cst$kw$recur;
} else {
throw e18551;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17945__auto__,cljs.core.cst$kw$recur)){
var G__18565 = state_18534;
state_18534 = G__18565;
continue;
} else {
return ret_value__17945__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__17944__auto__ = function(state_18534){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__17944__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__17944__auto____1.call(this,state_18534);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__17944__auto____0;
cljs$core$async$reduce_$_state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__17944__auto____1;
return cljs$core$async$reduce_$_state_machine__17944__auto__;
})()
;})(switch__17943__auto__,c__18045__auto__))
})();
var state__18047__auto__ = (function (){var statearr_18553 = (f__18046__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18046__auto__.cljs$core$IFn$_invoke$arity$0() : f__18046__auto__.call(null));
(statearr_18553[(6)] = c__18045__auto__);

return statearr_18553;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18047__auto__);
});})(c__18045__auto__))
);

return c__18045__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__18045__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18045__auto__,f__$1){
return (function (){
var f__18046__auto__ = (function (){var switch__17943__auto__ = ((function (c__18045__auto__,f__$1){
return (function (state_18571){
var state_val_18572 = (state_18571[(1)]);
if((state_val_18572 === (1))){
var inst_18566 = cljs.core.async.reduce(f__$1,init,ch);
var state_18571__$1 = state_18571;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18571__$1,(2),inst_18566);
} else {
if((state_val_18572 === (2))){
var inst_18568 = (state_18571[(2)]);
var inst_18569 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_18568) : f__$1.call(null,inst_18568));
var state_18571__$1 = state_18571;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18571__$1,inst_18569);
} else {
return null;
}
}
});})(c__18045__auto__,f__$1))
;
return ((function (switch__17943__auto__,c__18045__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__17944__auto__ = null;
var cljs$core$async$transduce_$_state_machine__17944__auto____0 = (function (){
var statearr_18573 = [null,null,null,null,null,null,null];
(statearr_18573[(0)] = cljs$core$async$transduce_$_state_machine__17944__auto__);

(statearr_18573[(1)] = (1));

return statearr_18573;
});
var cljs$core$async$transduce_$_state_machine__17944__auto____1 = (function (state_18571){
while(true){
var ret_value__17945__auto__ = (function (){try{while(true){
var result__17946__auto__ = switch__17943__auto__(state_18571);
if(cljs.core.keyword_identical_QMARK_(result__17946__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17946__auto__;
}
break;
}
}catch (e18574){if((e18574 instanceof Object)){
var ex__17947__auto__ = e18574;
var statearr_18575_18577 = state_18571;
(statearr_18575_18577[(5)] = ex__17947__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18571);

return cljs.core.cst$kw$recur;
} else {
throw e18574;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17945__auto__,cljs.core.cst$kw$recur)){
var G__18578 = state_18571;
state_18571 = G__18578;
continue;
} else {
return ret_value__17945__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__17944__auto__ = function(state_18571){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__17944__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__17944__auto____1.call(this,state_18571);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__17944__auto____0;
cljs$core$async$transduce_$_state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__17944__auto____1;
return cljs$core$async$transduce_$_state_machine__17944__auto__;
})()
;})(switch__17943__auto__,c__18045__auto__,f__$1))
})();
var state__18047__auto__ = (function (){var statearr_18576 = (f__18046__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18046__auto__.cljs$core$IFn$_invoke$arity$0() : f__18046__auto__.call(null));
(statearr_18576[(6)] = c__18045__auto__);

return statearr_18576;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18047__auto__);
});})(c__18045__auto__,f__$1))
);

return c__18045__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__18580 = arguments.length;
switch (G__18580) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__18045__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18045__auto__){
return (function (){
var f__18046__auto__ = (function (){var switch__17943__auto__ = ((function (c__18045__auto__){
return (function (state_18605){
var state_val_18606 = (state_18605[(1)]);
if((state_val_18606 === (7))){
var inst_18587 = (state_18605[(2)]);
var state_18605__$1 = state_18605;
var statearr_18607_18628 = state_18605__$1;
(statearr_18607_18628[(2)] = inst_18587);

(statearr_18607_18628[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18606 === (1))){
var inst_18581 = cljs.core.seq(coll);
var inst_18582 = inst_18581;
var state_18605__$1 = (function (){var statearr_18608 = state_18605;
(statearr_18608[(7)] = inst_18582);

return statearr_18608;
})();
var statearr_18609_18629 = state_18605__$1;
(statearr_18609_18629[(2)] = null);

(statearr_18609_18629[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18606 === (4))){
var inst_18582 = (state_18605[(7)]);
var inst_18585 = cljs.core.first(inst_18582);
var state_18605__$1 = state_18605;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18605__$1,(7),ch,inst_18585);
} else {
if((state_val_18606 === (13))){
var inst_18599 = (state_18605[(2)]);
var state_18605__$1 = state_18605;
var statearr_18610_18630 = state_18605__$1;
(statearr_18610_18630[(2)] = inst_18599);

(statearr_18610_18630[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18606 === (6))){
var inst_18590 = (state_18605[(2)]);
var state_18605__$1 = state_18605;
if(cljs.core.truth_(inst_18590)){
var statearr_18611_18631 = state_18605__$1;
(statearr_18611_18631[(1)] = (8));

} else {
var statearr_18612_18632 = state_18605__$1;
(statearr_18612_18632[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18606 === (3))){
var inst_18603 = (state_18605[(2)]);
var state_18605__$1 = state_18605;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18605__$1,inst_18603);
} else {
if((state_val_18606 === (12))){
var state_18605__$1 = state_18605;
var statearr_18613_18633 = state_18605__$1;
(statearr_18613_18633[(2)] = null);

(statearr_18613_18633[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18606 === (2))){
var inst_18582 = (state_18605[(7)]);
var state_18605__$1 = state_18605;
if(cljs.core.truth_(inst_18582)){
var statearr_18614_18634 = state_18605__$1;
(statearr_18614_18634[(1)] = (4));

} else {
var statearr_18615_18635 = state_18605__$1;
(statearr_18615_18635[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18606 === (11))){
var inst_18596 = cljs.core.async.close_BANG_(ch);
var state_18605__$1 = state_18605;
var statearr_18616_18636 = state_18605__$1;
(statearr_18616_18636[(2)] = inst_18596);

(statearr_18616_18636[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18606 === (9))){
var state_18605__$1 = state_18605;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18617_18637 = state_18605__$1;
(statearr_18617_18637[(1)] = (11));

} else {
var statearr_18618_18638 = state_18605__$1;
(statearr_18618_18638[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18606 === (5))){
var inst_18582 = (state_18605[(7)]);
var state_18605__$1 = state_18605;
var statearr_18619_18639 = state_18605__$1;
(statearr_18619_18639[(2)] = inst_18582);

(statearr_18619_18639[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18606 === (10))){
var inst_18601 = (state_18605[(2)]);
var state_18605__$1 = state_18605;
var statearr_18620_18640 = state_18605__$1;
(statearr_18620_18640[(2)] = inst_18601);

(statearr_18620_18640[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18606 === (8))){
var inst_18582 = (state_18605[(7)]);
var inst_18592 = cljs.core.next(inst_18582);
var inst_18582__$1 = inst_18592;
var state_18605__$1 = (function (){var statearr_18621 = state_18605;
(statearr_18621[(7)] = inst_18582__$1);

return statearr_18621;
})();
var statearr_18622_18641 = state_18605__$1;
(statearr_18622_18641[(2)] = null);

(statearr_18622_18641[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18045__auto__))
;
return ((function (switch__17943__auto__,c__18045__auto__){
return (function() {
var cljs$core$async$state_machine__17944__auto__ = null;
var cljs$core$async$state_machine__17944__auto____0 = (function (){
var statearr_18623 = [null,null,null,null,null,null,null,null];
(statearr_18623[(0)] = cljs$core$async$state_machine__17944__auto__);

(statearr_18623[(1)] = (1));

return statearr_18623;
});
var cljs$core$async$state_machine__17944__auto____1 = (function (state_18605){
while(true){
var ret_value__17945__auto__ = (function (){try{while(true){
var result__17946__auto__ = switch__17943__auto__(state_18605);
if(cljs.core.keyword_identical_QMARK_(result__17946__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17946__auto__;
}
break;
}
}catch (e18624){if((e18624 instanceof Object)){
var ex__17947__auto__ = e18624;
var statearr_18625_18642 = state_18605;
(statearr_18625_18642[(5)] = ex__17947__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18605);

return cljs.core.cst$kw$recur;
} else {
throw e18624;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17945__auto__,cljs.core.cst$kw$recur)){
var G__18643 = state_18605;
state_18605 = G__18643;
continue;
} else {
return ret_value__17945__auto__;
}
break;
}
});
cljs$core$async$state_machine__17944__auto__ = function(state_18605){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17944__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17944__auto____1.call(this,state_18605);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17944__auto____0;
cljs$core$async$state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17944__auto____1;
return cljs$core$async$state_machine__17944__auto__;
})()
;})(switch__17943__auto__,c__18045__auto__))
})();
var state__18047__auto__ = (function (){var statearr_18626 = (f__18046__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18046__auto__.cljs$core$IFn$_invoke$arity$0() : f__18046__auto__.call(null));
(statearr_18626[(6)] = c__18045__auto__);

return statearr_18626;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18047__auto__);
});})(c__18045__auto__))
);

return c__18045__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__9539__auto__ = (((_ == null))?null:_);
var m__9540__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__9540__auto__.call(null,_));
} else {
var m__9540__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__9540__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__9540__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__9540__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__9540__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9540__auto__.call(null,m,ch));
} else {
var m__9540__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9540__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__9540__auto__.call(null,m));
} else {
var m__9540__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__9540__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18644 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18644 = (function (ch,cs,meta18645){
this.ch = ch;
this.cs = cs;
this.meta18645 = meta18645;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18644.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_18646,meta18645__$1){
var self__ = this;
var _18646__$1 = this;
return (new cljs.core.async.t_cljs$core$async18644(self__.ch,self__.cs,meta18645__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async18644.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_18646){
var self__ = this;
var _18646__$1 = this;
return self__.meta18645;
});})(cs))
;

cljs.core.async.t_cljs$core$async18644.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18644.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async18644.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18644.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18644.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18644.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18644.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta18645], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async18644.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18644.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18644";

cljs.core.async.t_cljs$core$async18644.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async18644");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async18644 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async18644(ch__$1,cs__$1,meta18645){
return (new cljs.core.async.t_cljs$core$async18644(ch__$1,cs__$1,meta18645));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async18644(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__18045__auto___18866 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18045__auto___18866,cs,m,dchan,dctr,done){
return (function (){
var f__18046__auto__ = (function (){var switch__17943__auto__ = ((function (c__18045__auto___18866,cs,m,dchan,dctr,done){
return (function (state_18781){
var state_val_18782 = (state_18781[(1)]);
if((state_val_18782 === (7))){
var inst_18777 = (state_18781[(2)]);
var state_18781__$1 = state_18781;
var statearr_18783_18867 = state_18781__$1;
(statearr_18783_18867[(2)] = inst_18777);

(statearr_18783_18867[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (20))){
var inst_18680 = (state_18781[(7)]);
var inst_18692 = cljs.core.first(inst_18680);
var inst_18693 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18692,(0),null);
var inst_18694 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18692,(1),null);
var state_18781__$1 = (function (){var statearr_18784 = state_18781;
(statearr_18784[(8)] = inst_18693);

return statearr_18784;
})();
if(cljs.core.truth_(inst_18694)){
var statearr_18785_18868 = state_18781__$1;
(statearr_18785_18868[(1)] = (22));

} else {
var statearr_18786_18869 = state_18781__$1;
(statearr_18786_18869[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (27))){
var inst_18649 = (state_18781[(9)]);
var inst_18722 = (state_18781[(10)]);
var inst_18729 = (state_18781[(11)]);
var inst_18724 = (state_18781[(12)]);
var inst_18729__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_18722,inst_18724);
var inst_18730 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_18729__$1,inst_18649,done);
var state_18781__$1 = (function (){var statearr_18787 = state_18781;
(statearr_18787[(11)] = inst_18729__$1);

return statearr_18787;
})();
if(cljs.core.truth_(inst_18730)){
var statearr_18788_18870 = state_18781__$1;
(statearr_18788_18870[(1)] = (30));

} else {
var statearr_18789_18871 = state_18781__$1;
(statearr_18789_18871[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (1))){
var state_18781__$1 = state_18781;
var statearr_18790_18872 = state_18781__$1;
(statearr_18790_18872[(2)] = null);

(statearr_18790_18872[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (24))){
var inst_18680 = (state_18781[(7)]);
var inst_18699 = (state_18781[(2)]);
var inst_18700 = cljs.core.next(inst_18680);
var inst_18658 = inst_18700;
var inst_18659 = null;
var inst_18660 = (0);
var inst_18661 = (0);
var state_18781__$1 = (function (){var statearr_18791 = state_18781;
(statearr_18791[(13)] = inst_18658);

(statearr_18791[(14)] = inst_18660);

(statearr_18791[(15)] = inst_18661);

(statearr_18791[(16)] = inst_18659);

(statearr_18791[(17)] = inst_18699);

return statearr_18791;
})();
var statearr_18792_18873 = state_18781__$1;
(statearr_18792_18873[(2)] = null);

(statearr_18792_18873[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (39))){
var state_18781__$1 = state_18781;
var statearr_18796_18874 = state_18781__$1;
(statearr_18796_18874[(2)] = null);

(statearr_18796_18874[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (4))){
var inst_18649 = (state_18781[(9)]);
var inst_18649__$1 = (state_18781[(2)]);
var inst_18650 = (inst_18649__$1 == null);
var state_18781__$1 = (function (){var statearr_18797 = state_18781;
(statearr_18797[(9)] = inst_18649__$1);

return statearr_18797;
})();
if(cljs.core.truth_(inst_18650)){
var statearr_18798_18875 = state_18781__$1;
(statearr_18798_18875[(1)] = (5));

} else {
var statearr_18799_18876 = state_18781__$1;
(statearr_18799_18876[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (15))){
var inst_18658 = (state_18781[(13)]);
var inst_18660 = (state_18781[(14)]);
var inst_18661 = (state_18781[(15)]);
var inst_18659 = (state_18781[(16)]);
var inst_18676 = (state_18781[(2)]);
var inst_18677 = (inst_18661 + (1));
var tmp18793 = inst_18658;
var tmp18794 = inst_18660;
var tmp18795 = inst_18659;
var inst_18658__$1 = tmp18793;
var inst_18659__$1 = tmp18795;
var inst_18660__$1 = tmp18794;
var inst_18661__$1 = inst_18677;
var state_18781__$1 = (function (){var statearr_18800 = state_18781;
(statearr_18800[(13)] = inst_18658__$1);

(statearr_18800[(14)] = inst_18660__$1);

(statearr_18800[(15)] = inst_18661__$1);

(statearr_18800[(16)] = inst_18659__$1);

(statearr_18800[(18)] = inst_18676);

return statearr_18800;
})();
var statearr_18801_18877 = state_18781__$1;
(statearr_18801_18877[(2)] = null);

(statearr_18801_18877[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (21))){
var inst_18703 = (state_18781[(2)]);
var state_18781__$1 = state_18781;
var statearr_18805_18878 = state_18781__$1;
(statearr_18805_18878[(2)] = inst_18703);

(statearr_18805_18878[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (31))){
var inst_18729 = (state_18781[(11)]);
var inst_18733 = done(null);
var inst_18734 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_18729);
var state_18781__$1 = (function (){var statearr_18806 = state_18781;
(statearr_18806[(19)] = inst_18733);

return statearr_18806;
})();
var statearr_18807_18879 = state_18781__$1;
(statearr_18807_18879[(2)] = inst_18734);

(statearr_18807_18879[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (32))){
var inst_18722 = (state_18781[(10)]);
var inst_18721 = (state_18781[(20)]);
var inst_18723 = (state_18781[(21)]);
var inst_18724 = (state_18781[(12)]);
var inst_18736 = (state_18781[(2)]);
var inst_18737 = (inst_18724 + (1));
var tmp18802 = inst_18722;
var tmp18803 = inst_18721;
var tmp18804 = inst_18723;
var inst_18721__$1 = tmp18803;
var inst_18722__$1 = tmp18802;
var inst_18723__$1 = tmp18804;
var inst_18724__$1 = inst_18737;
var state_18781__$1 = (function (){var statearr_18808 = state_18781;
(statearr_18808[(10)] = inst_18722__$1);

(statearr_18808[(20)] = inst_18721__$1);

(statearr_18808[(21)] = inst_18723__$1);

(statearr_18808[(12)] = inst_18724__$1);

(statearr_18808[(22)] = inst_18736);

return statearr_18808;
})();
var statearr_18809_18880 = state_18781__$1;
(statearr_18809_18880[(2)] = null);

(statearr_18809_18880[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (40))){
var inst_18749 = (state_18781[(23)]);
var inst_18753 = done(null);
var inst_18754 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_18749);
var state_18781__$1 = (function (){var statearr_18810 = state_18781;
(statearr_18810[(24)] = inst_18753);

return statearr_18810;
})();
var statearr_18811_18881 = state_18781__$1;
(statearr_18811_18881[(2)] = inst_18754);

(statearr_18811_18881[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (33))){
var inst_18740 = (state_18781[(25)]);
var inst_18742 = cljs.core.chunked_seq_QMARK_(inst_18740);
var state_18781__$1 = state_18781;
if(inst_18742){
var statearr_18812_18882 = state_18781__$1;
(statearr_18812_18882[(1)] = (36));

} else {
var statearr_18813_18883 = state_18781__$1;
(statearr_18813_18883[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (13))){
var inst_18670 = (state_18781[(26)]);
var inst_18673 = cljs.core.async.close_BANG_(inst_18670);
var state_18781__$1 = state_18781;
var statearr_18814_18884 = state_18781__$1;
(statearr_18814_18884[(2)] = inst_18673);

(statearr_18814_18884[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (22))){
var inst_18693 = (state_18781[(8)]);
var inst_18696 = cljs.core.async.close_BANG_(inst_18693);
var state_18781__$1 = state_18781;
var statearr_18815_18885 = state_18781__$1;
(statearr_18815_18885[(2)] = inst_18696);

(statearr_18815_18885[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (36))){
var inst_18740 = (state_18781[(25)]);
var inst_18744 = cljs.core.chunk_first(inst_18740);
var inst_18745 = cljs.core.chunk_rest(inst_18740);
var inst_18746 = cljs.core.count(inst_18744);
var inst_18721 = inst_18745;
var inst_18722 = inst_18744;
var inst_18723 = inst_18746;
var inst_18724 = (0);
var state_18781__$1 = (function (){var statearr_18816 = state_18781;
(statearr_18816[(10)] = inst_18722);

(statearr_18816[(20)] = inst_18721);

(statearr_18816[(21)] = inst_18723);

(statearr_18816[(12)] = inst_18724);

return statearr_18816;
})();
var statearr_18817_18886 = state_18781__$1;
(statearr_18817_18886[(2)] = null);

(statearr_18817_18886[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (41))){
var inst_18740 = (state_18781[(25)]);
var inst_18756 = (state_18781[(2)]);
var inst_18757 = cljs.core.next(inst_18740);
var inst_18721 = inst_18757;
var inst_18722 = null;
var inst_18723 = (0);
var inst_18724 = (0);
var state_18781__$1 = (function (){var statearr_18818 = state_18781;
(statearr_18818[(10)] = inst_18722);

(statearr_18818[(20)] = inst_18721);

(statearr_18818[(21)] = inst_18723);

(statearr_18818[(27)] = inst_18756);

(statearr_18818[(12)] = inst_18724);

return statearr_18818;
})();
var statearr_18819_18887 = state_18781__$1;
(statearr_18819_18887[(2)] = null);

(statearr_18819_18887[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (43))){
var state_18781__$1 = state_18781;
var statearr_18820_18888 = state_18781__$1;
(statearr_18820_18888[(2)] = null);

(statearr_18820_18888[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (29))){
var inst_18765 = (state_18781[(2)]);
var state_18781__$1 = state_18781;
var statearr_18821_18889 = state_18781__$1;
(statearr_18821_18889[(2)] = inst_18765);

(statearr_18821_18889[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (44))){
var inst_18774 = (state_18781[(2)]);
var state_18781__$1 = (function (){var statearr_18822 = state_18781;
(statearr_18822[(28)] = inst_18774);

return statearr_18822;
})();
var statearr_18823_18890 = state_18781__$1;
(statearr_18823_18890[(2)] = null);

(statearr_18823_18890[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (6))){
var inst_18713 = (state_18781[(29)]);
var inst_18712 = cljs.core.deref(cs);
var inst_18713__$1 = cljs.core.keys(inst_18712);
var inst_18714 = cljs.core.count(inst_18713__$1);
var inst_18715 = cljs.core.reset_BANG_(dctr,inst_18714);
var inst_18720 = cljs.core.seq(inst_18713__$1);
var inst_18721 = inst_18720;
var inst_18722 = null;
var inst_18723 = (0);
var inst_18724 = (0);
var state_18781__$1 = (function (){var statearr_18824 = state_18781;
(statearr_18824[(10)] = inst_18722);

(statearr_18824[(29)] = inst_18713__$1);

(statearr_18824[(20)] = inst_18721);

(statearr_18824[(21)] = inst_18723);

(statearr_18824[(30)] = inst_18715);

(statearr_18824[(12)] = inst_18724);

return statearr_18824;
})();
var statearr_18825_18891 = state_18781__$1;
(statearr_18825_18891[(2)] = null);

(statearr_18825_18891[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (28))){
var inst_18721 = (state_18781[(20)]);
var inst_18740 = (state_18781[(25)]);
var inst_18740__$1 = cljs.core.seq(inst_18721);
var state_18781__$1 = (function (){var statearr_18826 = state_18781;
(statearr_18826[(25)] = inst_18740__$1);

return statearr_18826;
})();
if(inst_18740__$1){
var statearr_18827_18892 = state_18781__$1;
(statearr_18827_18892[(1)] = (33));

} else {
var statearr_18828_18893 = state_18781__$1;
(statearr_18828_18893[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (25))){
var inst_18723 = (state_18781[(21)]);
var inst_18724 = (state_18781[(12)]);
var inst_18726 = (inst_18724 < inst_18723);
var inst_18727 = inst_18726;
var state_18781__$1 = state_18781;
if(cljs.core.truth_(inst_18727)){
var statearr_18829_18894 = state_18781__$1;
(statearr_18829_18894[(1)] = (27));

} else {
var statearr_18830_18895 = state_18781__$1;
(statearr_18830_18895[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (34))){
var state_18781__$1 = state_18781;
var statearr_18831_18896 = state_18781__$1;
(statearr_18831_18896[(2)] = null);

(statearr_18831_18896[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (17))){
var state_18781__$1 = state_18781;
var statearr_18832_18897 = state_18781__$1;
(statearr_18832_18897[(2)] = null);

(statearr_18832_18897[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (3))){
var inst_18779 = (state_18781[(2)]);
var state_18781__$1 = state_18781;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18781__$1,inst_18779);
} else {
if((state_val_18782 === (12))){
var inst_18708 = (state_18781[(2)]);
var state_18781__$1 = state_18781;
var statearr_18833_18898 = state_18781__$1;
(statearr_18833_18898[(2)] = inst_18708);

(statearr_18833_18898[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (2))){
var state_18781__$1 = state_18781;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18781__$1,(4),ch);
} else {
if((state_val_18782 === (23))){
var state_18781__$1 = state_18781;
var statearr_18834_18899 = state_18781__$1;
(statearr_18834_18899[(2)] = null);

(statearr_18834_18899[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (35))){
var inst_18763 = (state_18781[(2)]);
var state_18781__$1 = state_18781;
var statearr_18835_18900 = state_18781__$1;
(statearr_18835_18900[(2)] = inst_18763);

(statearr_18835_18900[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (19))){
var inst_18680 = (state_18781[(7)]);
var inst_18684 = cljs.core.chunk_first(inst_18680);
var inst_18685 = cljs.core.chunk_rest(inst_18680);
var inst_18686 = cljs.core.count(inst_18684);
var inst_18658 = inst_18685;
var inst_18659 = inst_18684;
var inst_18660 = inst_18686;
var inst_18661 = (0);
var state_18781__$1 = (function (){var statearr_18836 = state_18781;
(statearr_18836[(13)] = inst_18658);

(statearr_18836[(14)] = inst_18660);

(statearr_18836[(15)] = inst_18661);

(statearr_18836[(16)] = inst_18659);

return statearr_18836;
})();
var statearr_18837_18901 = state_18781__$1;
(statearr_18837_18901[(2)] = null);

(statearr_18837_18901[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (11))){
var inst_18658 = (state_18781[(13)]);
var inst_18680 = (state_18781[(7)]);
var inst_18680__$1 = cljs.core.seq(inst_18658);
var state_18781__$1 = (function (){var statearr_18838 = state_18781;
(statearr_18838[(7)] = inst_18680__$1);

return statearr_18838;
})();
if(inst_18680__$1){
var statearr_18839_18902 = state_18781__$1;
(statearr_18839_18902[(1)] = (16));

} else {
var statearr_18840_18903 = state_18781__$1;
(statearr_18840_18903[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (9))){
var inst_18710 = (state_18781[(2)]);
var state_18781__$1 = state_18781;
var statearr_18841_18904 = state_18781__$1;
(statearr_18841_18904[(2)] = inst_18710);

(statearr_18841_18904[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (5))){
var inst_18656 = cljs.core.deref(cs);
var inst_18657 = cljs.core.seq(inst_18656);
var inst_18658 = inst_18657;
var inst_18659 = null;
var inst_18660 = (0);
var inst_18661 = (0);
var state_18781__$1 = (function (){var statearr_18842 = state_18781;
(statearr_18842[(13)] = inst_18658);

(statearr_18842[(14)] = inst_18660);

(statearr_18842[(15)] = inst_18661);

(statearr_18842[(16)] = inst_18659);

return statearr_18842;
})();
var statearr_18843_18905 = state_18781__$1;
(statearr_18843_18905[(2)] = null);

(statearr_18843_18905[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (14))){
var state_18781__$1 = state_18781;
var statearr_18844_18906 = state_18781__$1;
(statearr_18844_18906[(2)] = null);

(statearr_18844_18906[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (45))){
var inst_18771 = (state_18781[(2)]);
var state_18781__$1 = state_18781;
var statearr_18845_18907 = state_18781__$1;
(statearr_18845_18907[(2)] = inst_18771);

(statearr_18845_18907[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (26))){
var inst_18713 = (state_18781[(29)]);
var inst_18767 = (state_18781[(2)]);
var inst_18768 = cljs.core.seq(inst_18713);
var state_18781__$1 = (function (){var statearr_18846 = state_18781;
(statearr_18846[(31)] = inst_18767);

return statearr_18846;
})();
if(inst_18768){
var statearr_18847_18908 = state_18781__$1;
(statearr_18847_18908[(1)] = (42));

} else {
var statearr_18848_18909 = state_18781__$1;
(statearr_18848_18909[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (16))){
var inst_18680 = (state_18781[(7)]);
var inst_18682 = cljs.core.chunked_seq_QMARK_(inst_18680);
var state_18781__$1 = state_18781;
if(inst_18682){
var statearr_18849_18910 = state_18781__$1;
(statearr_18849_18910[(1)] = (19));

} else {
var statearr_18850_18911 = state_18781__$1;
(statearr_18850_18911[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (38))){
var inst_18760 = (state_18781[(2)]);
var state_18781__$1 = state_18781;
var statearr_18851_18912 = state_18781__$1;
(statearr_18851_18912[(2)] = inst_18760);

(statearr_18851_18912[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (30))){
var state_18781__$1 = state_18781;
var statearr_18852_18913 = state_18781__$1;
(statearr_18852_18913[(2)] = null);

(statearr_18852_18913[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (10))){
var inst_18661 = (state_18781[(15)]);
var inst_18659 = (state_18781[(16)]);
var inst_18669 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_18659,inst_18661);
var inst_18670 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18669,(0),null);
var inst_18671 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18669,(1),null);
var state_18781__$1 = (function (){var statearr_18853 = state_18781;
(statearr_18853[(26)] = inst_18670);

return statearr_18853;
})();
if(cljs.core.truth_(inst_18671)){
var statearr_18854_18914 = state_18781__$1;
(statearr_18854_18914[(1)] = (13));

} else {
var statearr_18855_18915 = state_18781__$1;
(statearr_18855_18915[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (18))){
var inst_18706 = (state_18781[(2)]);
var state_18781__$1 = state_18781;
var statearr_18856_18916 = state_18781__$1;
(statearr_18856_18916[(2)] = inst_18706);

(statearr_18856_18916[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (42))){
var state_18781__$1 = state_18781;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18781__$1,(45),dchan);
} else {
if((state_val_18782 === (37))){
var inst_18649 = (state_18781[(9)]);
var inst_18749 = (state_18781[(23)]);
var inst_18740 = (state_18781[(25)]);
var inst_18749__$1 = cljs.core.first(inst_18740);
var inst_18750 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_18749__$1,inst_18649,done);
var state_18781__$1 = (function (){var statearr_18857 = state_18781;
(statearr_18857[(23)] = inst_18749__$1);

return statearr_18857;
})();
if(cljs.core.truth_(inst_18750)){
var statearr_18858_18917 = state_18781__$1;
(statearr_18858_18917[(1)] = (39));

} else {
var statearr_18859_18918 = state_18781__$1;
(statearr_18859_18918[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (8))){
var inst_18660 = (state_18781[(14)]);
var inst_18661 = (state_18781[(15)]);
var inst_18663 = (inst_18661 < inst_18660);
var inst_18664 = inst_18663;
var state_18781__$1 = state_18781;
if(cljs.core.truth_(inst_18664)){
var statearr_18860_18919 = state_18781__$1;
(statearr_18860_18919[(1)] = (10));

} else {
var statearr_18861_18920 = state_18781__$1;
(statearr_18861_18920[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18045__auto___18866,cs,m,dchan,dctr,done))
;
return ((function (switch__17943__auto__,c__18045__auto___18866,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__17944__auto__ = null;
var cljs$core$async$mult_$_state_machine__17944__auto____0 = (function (){
var statearr_18862 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18862[(0)] = cljs$core$async$mult_$_state_machine__17944__auto__);

(statearr_18862[(1)] = (1));

return statearr_18862;
});
var cljs$core$async$mult_$_state_machine__17944__auto____1 = (function (state_18781){
while(true){
var ret_value__17945__auto__ = (function (){try{while(true){
var result__17946__auto__ = switch__17943__auto__(state_18781);
if(cljs.core.keyword_identical_QMARK_(result__17946__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17946__auto__;
}
break;
}
}catch (e18863){if((e18863 instanceof Object)){
var ex__17947__auto__ = e18863;
var statearr_18864_18921 = state_18781;
(statearr_18864_18921[(5)] = ex__17947__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18781);

return cljs.core.cst$kw$recur;
} else {
throw e18863;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17945__auto__,cljs.core.cst$kw$recur)){
var G__18922 = state_18781;
state_18781 = G__18922;
continue;
} else {
return ret_value__17945__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__17944__auto__ = function(state_18781){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__17944__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__17944__auto____1.call(this,state_18781);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__17944__auto____0;
cljs$core$async$mult_$_state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__17944__auto____1;
return cljs$core$async$mult_$_state_machine__17944__auto__;
})()
;})(switch__17943__auto__,c__18045__auto___18866,cs,m,dchan,dctr,done))
})();
var state__18047__auto__ = (function (){var statearr_18865 = (f__18046__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18046__auto__.cljs$core$IFn$_invoke$arity$0() : f__18046__auto__.call(null));
(statearr_18865[(6)] = c__18045__auto___18866);

return statearr_18865;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18047__auto__);
});})(c__18045__auto___18866,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__18924 = arguments.length;
switch (G__18924) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9540__auto__.call(null,m,ch));
} else {
var m__9540__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9540__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9540__auto__.call(null,m,ch));
} else {
var m__9540__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9540__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__9540__auto__.call(null,m));
} else {
var m__9540__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__9540__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__9540__auto__.call(null,m,state_map));
} else {
var m__9540__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__9540__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__9540__auto__.call(null,m,mode));
} else {
var m__9540__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__9540__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__10092__auto__ = [];
var len__10085__auto___18936 = arguments.length;
var i__10086__auto___18937 = (0);
while(true){
if((i__10086__auto___18937 < len__10085__auto___18936)){
args__10092__auto__.push((arguments[i__10086__auto___18937]));

var G__18938 = (i__10086__auto___18937 + (1));
i__10086__auto___18937 = G__18938;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((3) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10093__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__18930){
var map__18931 = p__18930;
var map__18931__$1 = ((((!((map__18931 == null)))?((((map__18931.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18931.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18931):map__18931);
var opts = map__18931__$1;
var statearr_18933_18939 = state;
(statearr_18933_18939[(1)] = cont_block);


var temp__5457__auto__ = cljs.core.async.do_alts(((function (map__18931,map__18931__$1,opts){
return (function (val){
var statearr_18934_18940 = state;
(statearr_18934_18940[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__18931,map__18931__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5457__auto__)){
var cb = temp__5457__auto__;
var statearr_18935_18941 = state;
(statearr_18935_18941[(2)] = cljs.core.deref(cb));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq18926){
var G__18927 = cljs.core.first(seq18926);
var seq18926__$1 = cljs.core.next(seq18926);
var G__18928 = cljs.core.first(seq18926__$1);
var seq18926__$2 = cljs.core.next(seq18926__$1);
var G__18929 = cljs.core.first(seq18926__$2);
var seq18926__$3 = cljs.core.next(seq18926__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__18927,G__18928,G__18929,seq18926__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute);
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18942 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18942 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta18943){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta18943 = meta18943;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18942.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18944,meta18943__$1){
var self__ = this;
var _18944__$1 = this;
return (new cljs.core.async.t_cljs$core$async18942(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta18943__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18942.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18944){
var self__ = this;
var _18944__$1 = this;
return self__.meta18943;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18942.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18942.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18942.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18942.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18942.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18942.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18942.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18942.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18942.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out,cljs.core.cst$sym$cs,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$change,cljs.core.cst$sym$changed,cljs.core.cst$sym$pick,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$meta18943], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18942.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18942.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18942";

cljs.core.async.t_cljs$core$async18942.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async18942");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async18942 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async18942(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta18943){
return (new cljs.core.async.t_cljs$core$async18942(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta18943));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async18942(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__18045__auto___19106 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18045__auto___19106,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__18046__auto__ = (function (){var switch__17943__auto__ = ((function (c__18045__auto___19106,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_19046){
var state_val_19047 = (state_19046[(1)]);
if((state_val_19047 === (7))){
var inst_18961 = (state_19046[(2)]);
var state_19046__$1 = state_19046;
var statearr_19048_19107 = state_19046__$1;
(statearr_19048_19107[(2)] = inst_18961);

(statearr_19048_19107[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (20))){
var inst_18973 = (state_19046[(7)]);
var state_19046__$1 = state_19046;
var statearr_19049_19108 = state_19046__$1;
(statearr_19049_19108[(2)] = inst_18973);

(statearr_19049_19108[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (27))){
var state_19046__$1 = state_19046;
var statearr_19050_19109 = state_19046__$1;
(statearr_19050_19109[(2)] = null);

(statearr_19050_19109[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (1))){
var inst_18948 = (state_19046[(8)]);
var inst_18948__$1 = calc_state();
var inst_18950 = (inst_18948__$1 == null);
var inst_18951 = cljs.core.not(inst_18950);
var state_19046__$1 = (function (){var statearr_19051 = state_19046;
(statearr_19051[(8)] = inst_18948__$1);

return statearr_19051;
})();
if(inst_18951){
var statearr_19052_19110 = state_19046__$1;
(statearr_19052_19110[(1)] = (2));

} else {
var statearr_19053_19111 = state_19046__$1;
(statearr_19053_19111[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (24))){
var inst_18997 = (state_19046[(9)]);
var inst_19020 = (state_19046[(10)]);
var inst_19006 = (state_19046[(11)]);
var inst_19020__$1 = (inst_18997.cljs$core$IFn$_invoke$arity$1 ? inst_18997.cljs$core$IFn$_invoke$arity$1(inst_19006) : inst_18997.call(null,inst_19006));
var state_19046__$1 = (function (){var statearr_19054 = state_19046;
(statearr_19054[(10)] = inst_19020__$1);

return statearr_19054;
})();
if(cljs.core.truth_(inst_19020__$1)){
var statearr_19055_19112 = state_19046__$1;
(statearr_19055_19112[(1)] = (29));

} else {
var statearr_19056_19113 = state_19046__$1;
(statearr_19056_19113[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (4))){
var inst_18964 = (state_19046[(2)]);
var state_19046__$1 = state_19046;
if(cljs.core.truth_(inst_18964)){
var statearr_19057_19114 = state_19046__$1;
(statearr_19057_19114[(1)] = (8));

} else {
var statearr_19058_19115 = state_19046__$1;
(statearr_19058_19115[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (15))){
var inst_18991 = (state_19046[(2)]);
var state_19046__$1 = state_19046;
if(cljs.core.truth_(inst_18991)){
var statearr_19059_19116 = state_19046__$1;
(statearr_19059_19116[(1)] = (19));

} else {
var statearr_19060_19117 = state_19046__$1;
(statearr_19060_19117[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (21))){
var inst_18996 = (state_19046[(12)]);
var inst_18996__$1 = (state_19046[(2)]);
var inst_18997 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18996__$1,cljs.core.cst$kw$solos);
var inst_18998 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18996__$1,cljs.core.cst$kw$mutes);
var inst_18999 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18996__$1,cljs.core.cst$kw$reads);
var state_19046__$1 = (function (){var statearr_19061 = state_19046;
(statearr_19061[(12)] = inst_18996__$1);

(statearr_19061[(9)] = inst_18997);

(statearr_19061[(13)] = inst_18998);

return statearr_19061;
})();
return cljs.core.async.ioc_alts_BANG_(state_19046__$1,(22),inst_18999);
} else {
if((state_val_19047 === (31))){
var inst_19028 = (state_19046[(2)]);
var state_19046__$1 = state_19046;
if(cljs.core.truth_(inst_19028)){
var statearr_19062_19118 = state_19046__$1;
(statearr_19062_19118[(1)] = (32));

} else {
var statearr_19063_19119 = state_19046__$1;
(statearr_19063_19119[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (32))){
var inst_19005 = (state_19046[(14)]);
var state_19046__$1 = state_19046;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19046__$1,(35),out,inst_19005);
} else {
if((state_val_19047 === (33))){
var inst_18996 = (state_19046[(12)]);
var inst_18973 = inst_18996;
var state_19046__$1 = (function (){var statearr_19064 = state_19046;
(statearr_19064[(7)] = inst_18973);

return statearr_19064;
})();
var statearr_19065_19120 = state_19046__$1;
(statearr_19065_19120[(2)] = null);

(statearr_19065_19120[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (13))){
var inst_18973 = (state_19046[(7)]);
var inst_18980 = inst_18973.cljs$lang$protocol_mask$partition0$;
var inst_18981 = (inst_18980 & (64));
var inst_18982 = inst_18973.cljs$core$ISeq$;
var inst_18983 = (cljs.core.PROTOCOL_SENTINEL === inst_18982);
var inst_18984 = (inst_18981) || (inst_18983);
var state_19046__$1 = state_19046;
if(cljs.core.truth_(inst_18984)){
var statearr_19066_19121 = state_19046__$1;
(statearr_19066_19121[(1)] = (16));

} else {
var statearr_19067_19122 = state_19046__$1;
(statearr_19067_19122[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (22))){
var inst_19005 = (state_19046[(14)]);
var inst_19006 = (state_19046[(11)]);
var inst_19004 = (state_19046[(2)]);
var inst_19005__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19004,(0),null);
var inst_19006__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19004,(1),null);
var inst_19007 = (inst_19005__$1 == null);
var inst_19008 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_19006__$1,change);
var inst_19009 = (inst_19007) || (inst_19008);
var state_19046__$1 = (function (){var statearr_19068 = state_19046;
(statearr_19068[(14)] = inst_19005__$1);

(statearr_19068[(11)] = inst_19006__$1);

return statearr_19068;
})();
if(cljs.core.truth_(inst_19009)){
var statearr_19069_19123 = state_19046__$1;
(statearr_19069_19123[(1)] = (23));

} else {
var statearr_19070_19124 = state_19046__$1;
(statearr_19070_19124[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (36))){
var inst_18996 = (state_19046[(12)]);
var inst_18973 = inst_18996;
var state_19046__$1 = (function (){var statearr_19071 = state_19046;
(statearr_19071[(7)] = inst_18973);

return statearr_19071;
})();
var statearr_19072_19125 = state_19046__$1;
(statearr_19072_19125[(2)] = null);

(statearr_19072_19125[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (29))){
var inst_19020 = (state_19046[(10)]);
var state_19046__$1 = state_19046;
var statearr_19073_19126 = state_19046__$1;
(statearr_19073_19126[(2)] = inst_19020);

(statearr_19073_19126[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (6))){
var state_19046__$1 = state_19046;
var statearr_19074_19127 = state_19046__$1;
(statearr_19074_19127[(2)] = false);

(statearr_19074_19127[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (28))){
var inst_19016 = (state_19046[(2)]);
var inst_19017 = calc_state();
var inst_18973 = inst_19017;
var state_19046__$1 = (function (){var statearr_19075 = state_19046;
(statearr_19075[(15)] = inst_19016);

(statearr_19075[(7)] = inst_18973);

return statearr_19075;
})();
var statearr_19076_19128 = state_19046__$1;
(statearr_19076_19128[(2)] = null);

(statearr_19076_19128[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (25))){
var inst_19042 = (state_19046[(2)]);
var state_19046__$1 = state_19046;
var statearr_19077_19129 = state_19046__$1;
(statearr_19077_19129[(2)] = inst_19042);

(statearr_19077_19129[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (34))){
var inst_19040 = (state_19046[(2)]);
var state_19046__$1 = state_19046;
var statearr_19078_19130 = state_19046__$1;
(statearr_19078_19130[(2)] = inst_19040);

(statearr_19078_19130[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (17))){
var state_19046__$1 = state_19046;
var statearr_19079_19131 = state_19046__$1;
(statearr_19079_19131[(2)] = false);

(statearr_19079_19131[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (3))){
var state_19046__$1 = state_19046;
var statearr_19080_19132 = state_19046__$1;
(statearr_19080_19132[(2)] = false);

(statearr_19080_19132[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (12))){
var inst_19044 = (state_19046[(2)]);
var state_19046__$1 = state_19046;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19046__$1,inst_19044);
} else {
if((state_val_19047 === (2))){
var inst_18948 = (state_19046[(8)]);
var inst_18953 = inst_18948.cljs$lang$protocol_mask$partition0$;
var inst_18954 = (inst_18953 & (64));
var inst_18955 = inst_18948.cljs$core$ISeq$;
var inst_18956 = (cljs.core.PROTOCOL_SENTINEL === inst_18955);
var inst_18957 = (inst_18954) || (inst_18956);
var state_19046__$1 = state_19046;
if(cljs.core.truth_(inst_18957)){
var statearr_19081_19133 = state_19046__$1;
(statearr_19081_19133[(1)] = (5));

} else {
var statearr_19082_19134 = state_19046__$1;
(statearr_19082_19134[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (23))){
var inst_19005 = (state_19046[(14)]);
var inst_19011 = (inst_19005 == null);
var state_19046__$1 = state_19046;
if(cljs.core.truth_(inst_19011)){
var statearr_19083_19135 = state_19046__$1;
(statearr_19083_19135[(1)] = (26));

} else {
var statearr_19084_19136 = state_19046__$1;
(statearr_19084_19136[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (35))){
var inst_19031 = (state_19046[(2)]);
var state_19046__$1 = state_19046;
if(cljs.core.truth_(inst_19031)){
var statearr_19085_19137 = state_19046__$1;
(statearr_19085_19137[(1)] = (36));

} else {
var statearr_19086_19138 = state_19046__$1;
(statearr_19086_19138[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (19))){
var inst_18973 = (state_19046[(7)]);
var inst_18993 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_18973);
var state_19046__$1 = state_19046;
var statearr_19087_19139 = state_19046__$1;
(statearr_19087_19139[(2)] = inst_18993);

(statearr_19087_19139[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (11))){
var inst_18973 = (state_19046[(7)]);
var inst_18977 = (inst_18973 == null);
var inst_18978 = cljs.core.not(inst_18977);
var state_19046__$1 = state_19046;
if(inst_18978){
var statearr_19088_19140 = state_19046__$1;
(statearr_19088_19140[(1)] = (13));

} else {
var statearr_19089_19141 = state_19046__$1;
(statearr_19089_19141[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (9))){
var inst_18948 = (state_19046[(8)]);
var state_19046__$1 = state_19046;
var statearr_19090_19142 = state_19046__$1;
(statearr_19090_19142[(2)] = inst_18948);

(statearr_19090_19142[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (5))){
var state_19046__$1 = state_19046;
var statearr_19091_19143 = state_19046__$1;
(statearr_19091_19143[(2)] = true);

(statearr_19091_19143[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (14))){
var state_19046__$1 = state_19046;
var statearr_19092_19144 = state_19046__$1;
(statearr_19092_19144[(2)] = false);

(statearr_19092_19144[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (26))){
var inst_19006 = (state_19046[(11)]);
var inst_19013 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_19006);
var state_19046__$1 = state_19046;
var statearr_19093_19145 = state_19046__$1;
(statearr_19093_19145[(2)] = inst_19013);

(statearr_19093_19145[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (16))){
var state_19046__$1 = state_19046;
var statearr_19094_19146 = state_19046__$1;
(statearr_19094_19146[(2)] = true);

(statearr_19094_19146[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (38))){
var inst_19036 = (state_19046[(2)]);
var state_19046__$1 = state_19046;
var statearr_19095_19147 = state_19046__$1;
(statearr_19095_19147[(2)] = inst_19036);

(statearr_19095_19147[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (30))){
var inst_18997 = (state_19046[(9)]);
var inst_19006 = (state_19046[(11)]);
var inst_18998 = (state_19046[(13)]);
var inst_19023 = cljs.core.empty_QMARK_(inst_18997);
var inst_19024 = (inst_18998.cljs$core$IFn$_invoke$arity$1 ? inst_18998.cljs$core$IFn$_invoke$arity$1(inst_19006) : inst_18998.call(null,inst_19006));
var inst_19025 = cljs.core.not(inst_19024);
var inst_19026 = (inst_19023) && (inst_19025);
var state_19046__$1 = state_19046;
var statearr_19096_19148 = state_19046__$1;
(statearr_19096_19148[(2)] = inst_19026);

(statearr_19096_19148[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (10))){
var inst_18948 = (state_19046[(8)]);
var inst_18969 = (state_19046[(2)]);
var inst_18970 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18969,cljs.core.cst$kw$solos);
var inst_18971 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18969,cljs.core.cst$kw$mutes);
var inst_18972 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18969,cljs.core.cst$kw$reads);
var inst_18973 = inst_18948;
var state_19046__$1 = (function (){var statearr_19097 = state_19046;
(statearr_19097[(16)] = inst_18972);

(statearr_19097[(17)] = inst_18970);

(statearr_19097[(18)] = inst_18971);

(statearr_19097[(7)] = inst_18973);

return statearr_19097;
})();
var statearr_19098_19149 = state_19046__$1;
(statearr_19098_19149[(2)] = null);

(statearr_19098_19149[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (18))){
var inst_18988 = (state_19046[(2)]);
var state_19046__$1 = state_19046;
var statearr_19099_19150 = state_19046__$1;
(statearr_19099_19150[(2)] = inst_18988);

(statearr_19099_19150[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (37))){
var state_19046__$1 = state_19046;
var statearr_19100_19151 = state_19046__$1;
(statearr_19100_19151[(2)] = null);

(statearr_19100_19151[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19047 === (8))){
var inst_18948 = (state_19046[(8)]);
var inst_18966 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_18948);
var state_19046__$1 = state_19046;
var statearr_19101_19152 = state_19046__$1;
(statearr_19101_19152[(2)] = inst_18966);

(statearr_19101_19152[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18045__auto___19106,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__17943__auto__,c__18045__auto___19106,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__17944__auto__ = null;
var cljs$core$async$mix_$_state_machine__17944__auto____0 = (function (){
var statearr_19102 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19102[(0)] = cljs$core$async$mix_$_state_machine__17944__auto__);

(statearr_19102[(1)] = (1));

return statearr_19102;
});
var cljs$core$async$mix_$_state_machine__17944__auto____1 = (function (state_19046){
while(true){
var ret_value__17945__auto__ = (function (){try{while(true){
var result__17946__auto__ = switch__17943__auto__(state_19046);
if(cljs.core.keyword_identical_QMARK_(result__17946__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17946__auto__;
}
break;
}
}catch (e19103){if((e19103 instanceof Object)){
var ex__17947__auto__ = e19103;
var statearr_19104_19153 = state_19046;
(statearr_19104_19153[(5)] = ex__17947__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19046);

return cljs.core.cst$kw$recur;
} else {
throw e19103;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17945__auto__,cljs.core.cst$kw$recur)){
var G__19154 = state_19046;
state_19046 = G__19154;
continue;
} else {
return ret_value__17945__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__17944__auto__ = function(state_19046){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__17944__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__17944__auto____1.call(this,state_19046);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__17944__auto____0;
cljs$core$async$mix_$_state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__17944__auto____1;
return cljs$core$async$mix_$_state_machine__17944__auto__;
})()
;})(switch__17943__auto__,c__18045__auto___19106,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__18047__auto__ = (function (){var statearr_19105 = (f__18046__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18046__auto__.cljs$core$IFn$_invoke$arity$0() : f__18046__auto__.call(null));
(statearr_19105[(6)] = c__18045__auto___19106);

return statearr_19105;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18047__auto__);
});})(c__18045__auto___19106,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__9539__auto__ = (((p == null))?null:p);
var m__9540__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$4 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__9540__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__9540__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__9540__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__9539__auto__ = (((p == null))?null:p);
var m__9540__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__9540__auto__.call(null,p,v,ch));
} else {
var m__9540__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__9540__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__19156 = arguments.length;
switch (G__19156) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__9539__auto__ = (((p == null))?null:p);
var m__9540__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__9540__auto__.call(null,p));
} else {
var m__9540__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__9540__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__9539__auto__ = (((p == null))?null:p);
var m__9540__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__9540__auto__.call(null,p,v));
} else {
var m__9540__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__9540__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__19160 = arguments.length;
switch (G__19160) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__8806__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__8806__auto__)){
return or__8806__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__8806__auto__,mults){
return (function (p1__19158_SHARP_){
if(cljs.core.truth_((p1__19158_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__19158_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__19158_SHARP_.call(null,topic)))){
return p1__19158_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__19158_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__8806__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async19161 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19161 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta19162){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta19162 = meta19162;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async19161.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_19163,meta19162__$1){
var self__ = this;
var _19163__$1 = this;
return (new cljs.core.async.t_cljs$core$async19161(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta19162__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19161.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_19163){
var self__ = this;
var _19163__$1 = this;
return self__.meta19162;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19161.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19161.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19161.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19161.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19161.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5457__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5457__auto__)){
var m = temp__5457__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19161.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19161.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19161.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta19162], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19161.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19161.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19161";

cljs.core.async.t_cljs$core$async19161.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async19161");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async19161 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async19161(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19162){
return (new cljs.core.async.t_cljs$core$async19161(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19162));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async19161(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__18045__auto___19281 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18045__auto___19281,mults,ensure_mult,p){
return (function (){
var f__18046__auto__ = (function (){var switch__17943__auto__ = ((function (c__18045__auto___19281,mults,ensure_mult,p){
return (function (state_19235){
var state_val_19236 = (state_19235[(1)]);
if((state_val_19236 === (7))){
var inst_19231 = (state_19235[(2)]);
var state_19235__$1 = state_19235;
var statearr_19237_19282 = state_19235__$1;
(statearr_19237_19282[(2)] = inst_19231);

(statearr_19237_19282[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19236 === (20))){
var state_19235__$1 = state_19235;
var statearr_19238_19283 = state_19235__$1;
(statearr_19238_19283[(2)] = null);

(statearr_19238_19283[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19236 === (1))){
var state_19235__$1 = state_19235;
var statearr_19239_19284 = state_19235__$1;
(statearr_19239_19284[(2)] = null);

(statearr_19239_19284[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19236 === (24))){
var inst_19214 = (state_19235[(7)]);
var inst_19223 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_19214);
var state_19235__$1 = state_19235;
var statearr_19240_19285 = state_19235__$1;
(statearr_19240_19285[(2)] = inst_19223);

(statearr_19240_19285[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19236 === (4))){
var inst_19166 = (state_19235[(8)]);
var inst_19166__$1 = (state_19235[(2)]);
var inst_19167 = (inst_19166__$1 == null);
var state_19235__$1 = (function (){var statearr_19241 = state_19235;
(statearr_19241[(8)] = inst_19166__$1);

return statearr_19241;
})();
if(cljs.core.truth_(inst_19167)){
var statearr_19242_19286 = state_19235__$1;
(statearr_19242_19286[(1)] = (5));

} else {
var statearr_19243_19287 = state_19235__$1;
(statearr_19243_19287[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19236 === (15))){
var inst_19208 = (state_19235[(2)]);
var state_19235__$1 = state_19235;
var statearr_19244_19288 = state_19235__$1;
(statearr_19244_19288[(2)] = inst_19208);

(statearr_19244_19288[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19236 === (21))){
var inst_19228 = (state_19235[(2)]);
var state_19235__$1 = (function (){var statearr_19245 = state_19235;
(statearr_19245[(9)] = inst_19228);

return statearr_19245;
})();
var statearr_19246_19289 = state_19235__$1;
(statearr_19246_19289[(2)] = null);

(statearr_19246_19289[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19236 === (13))){
var inst_19190 = (state_19235[(10)]);
var inst_19192 = cljs.core.chunked_seq_QMARK_(inst_19190);
var state_19235__$1 = state_19235;
if(inst_19192){
var statearr_19247_19290 = state_19235__$1;
(statearr_19247_19290[(1)] = (16));

} else {
var statearr_19248_19291 = state_19235__$1;
(statearr_19248_19291[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19236 === (22))){
var inst_19220 = (state_19235[(2)]);
var state_19235__$1 = state_19235;
if(cljs.core.truth_(inst_19220)){
var statearr_19249_19292 = state_19235__$1;
(statearr_19249_19292[(1)] = (23));

} else {
var statearr_19250_19293 = state_19235__$1;
(statearr_19250_19293[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19236 === (6))){
var inst_19214 = (state_19235[(7)]);
var inst_19216 = (state_19235[(11)]);
var inst_19166 = (state_19235[(8)]);
var inst_19214__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_19166) : topic_fn.call(null,inst_19166));
var inst_19215 = cljs.core.deref(mults);
var inst_19216__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19215,inst_19214__$1);
var state_19235__$1 = (function (){var statearr_19251 = state_19235;
(statearr_19251[(7)] = inst_19214__$1);

(statearr_19251[(11)] = inst_19216__$1);

return statearr_19251;
})();
if(cljs.core.truth_(inst_19216__$1)){
var statearr_19252_19294 = state_19235__$1;
(statearr_19252_19294[(1)] = (19));

} else {
var statearr_19253_19295 = state_19235__$1;
(statearr_19253_19295[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19236 === (25))){
var inst_19225 = (state_19235[(2)]);
var state_19235__$1 = state_19235;
var statearr_19254_19296 = state_19235__$1;
(statearr_19254_19296[(2)] = inst_19225);

(statearr_19254_19296[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19236 === (17))){
var inst_19190 = (state_19235[(10)]);
var inst_19199 = cljs.core.first(inst_19190);
var inst_19200 = cljs.core.async.muxch_STAR_(inst_19199);
var inst_19201 = cljs.core.async.close_BANG_(inst_19200);
var inst_19202 = cljs.core.next(inst_19190);
var inst_19176 = inst_19202;
var inst_19177 = null;
var inst_19178 = (0);
var inst_19179 = (0);
var state_19235__$1 = (function (){var statearr_19255 = state_19235;
(statearr_19255[(12)] = inst_19201);

(statearr_19255[(13)] = inst_19177);

(statearr_19255[(14)] = inst_19179);

(statearr_19255[(15)] = inst_19178);

(statearr_19255[(16)] = inst_19176);

return statearr_19255;
})();
var statearr_19256_19297 = state_19235__$1;
(statearr_19256_19297[(2)] = null);

(statearr_19256_19297[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19236 === (3))){
var inst_19233 = (state_19235[(2)]);
var state_19235__$1 = state_19235;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19235__$1,inst_19233);
} else {
if((state_val_19236 === (12))){
var inst_19210 = (state_19235[(2)]);
var state_19235__$1 = state_19235;
var statearr_19257_19298 = state_19235__$1;
(statearr_19257_19298[(2)] = inst_19210);

(statearr_19257_19298[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19236 === (2))){
var state_19235__$1 = state_19235;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19235__$1,(4),ch);
} else {
if((state_val_19236 === (23))){
var state_19235__$1 = state_19235;
var statearr_19258_19299 = state_19235__$1;
(statearr_19258_19299[(2)] = null);

(statearr_19258_19299[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19236 === (19))){
var inst_19216 = (state_19235[(11)]);
var inst_19166 = (state_19235[(8)]);
var inst_19218 = cljs.core.async.muxch_STAR_(inst_19216);
var state_19235__$1 = state_19235;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19235__$1,(22),inst_19218,inst_19166);
} else {
if((state_val_19236 === (11))){
var inst_19190 = (state_19235[(10)]);
var inst_19176 = (state_19235[(16)]);
var inst_19190__$1 = cljs.core.seq(inst_19176);
var state_19235__$1 = (function (){var statearr_19259 = state_19235;
(statearr_19259[(10)] = inst_19190__$1);

return statearr_19259;
})();
if(inst_19190__$1){
var statearr_19260_19300 = state_19235__$1;
(statearr_19260_19300[(1)] = (13));

} else {
var statearr_19261_19301 = state_19235__$1;
(statearr_19261_19301[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19236 === (9))){
var inst_19212 = (state_19235[(2)]);
var state_19235__$1 = state_19235;
var statearr_19262_19302 = state_19235__$1;
(statearr_19262_19302[(2)] = inst_19212);

(statearr_19262_19302[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19236 === (5))){
var inst_19173 = cljs.core.deref(mults);
var inst_19174 = cljs.core.vals(inst_19173);
var inst_19175 = cljs.core.seq(inst_19174);
var inst_19176 = inst_19175;
var inst_19177 = null;
var inst_19178 = (0);
var inst_19179 = (0);
var state_19235__$1 = (function (){var statearr_19263 = state_19235;
(statearr_19263[(13)] = inst_19177);

(statearr_19263[(14)] = inst_19179);

(statearr_19263[(15)] = inst_19178);

(statearr_19263[(16)] = inst_19176);

return statearr_19263;
})();
var statearr_19264_19303 = state_19235__$1;
(statearr_19264_19303[(2)] = null);

(statearr_19264_19303[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19236 === (14))){
var state_19235__$1 = state_19235;
var statearr_19268_19304 = state_19235__$1;
(statearr_19268_19304[(2)] = null);

(statearr_19268_19304[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19236 === (16))){
var inst_19190 = (state_19235[(10)]);
var inst_19194 = cljs.core.chunk_first(inst_19190);
var inst_19195 = cljs.core.chunk_rest(inst_19190);
var inst_19196 = cljs.core.count(inst_19194);
var inst_19176 = inst_19195;
var inst_19177 = inst_19194;
var inst_19178 = inst_19196;
var inst_19179 = (0);
var state_19235__$1 = (function (){var statearr_19269 = state_19235;
(statearr_19269[(13)] = inst_19177);

(statearr_19269[(14)] = inst_19179);

(statearr_19269[(15)] = inst_19178);

(statearr_19269[(16)] = inst_19176);

return statearr_19269;
})();
var statearr_19270_19305 = state_19235__$1;
(statearr_19270_19305[(2)] = null);

(statearr_19270_19305[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19236 === (10))){
var inst_19177 = (state_19235[(13)]);
var inst_19179 = (state_19235[(14)]);
var inst_19178 = (state_19235[(15)]);
var inst_19176 = (state_19235[(16)]);
var inst_19184 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_19177,inst_19179);
var inst_19185 = cljs.core.async.muxch_STAR_(inst_19184);
var inst_19186 = cljs.core.async.close_BANG_(inst_19185);
var inst_19187 = (inst_19179 + (1));
var tmp19265 = inst_19177;
var tmp19266 = inst_19178;
var tmp19267 = inst_19176;
var inst_19176__$1 = tmp19267;
var inst_19177__$1 = tmp19265;
var inst_19178__$1 = tmp19266;
var inst_19179__$1 = inst_19187;
var state_19235__$1 = (function (){var statearr_19271 = state_19235;
(statearr_19271[(17)] = inst_19186);

(statearr_19271[(13)] = inst_19177__$1);

(statearr_19271[(14)] = inst_19179__$1);

(statearr_19271[(15)] = inst_19178__$1);

(statearr_19271[(16)] = inst_19176__$1);

return statearr_19271;
})();
var statearr_19272_19306 = state_19235__$1;
(statearr_19272_19306[(2)] = null);

(statearr_19272_19306[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19236 === (18))){
var inst_19205 = (state_19235[(2)]);
var state_19235__$1 = state_19235;
var statearr_19273_19307 = state_19235__$1;
(statearr_19273_19307[(2)] = inst_19205);

(statearr_19273_19307[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19236 === (8))){
var inst_19179 = (state_19235[(14)]);
var inst_19178 = (state_19235[(15)]);
var inst_19181 = (inst_19179 < inst_19178);
var inst_19182 = inst_19181;
var state_19235__$1 = state_19235;
if(cljs.core.truth_(inst_19182)){
var statearr_19274_19308 = state_19235__$1;
(statearr_19274_19308[(1)] = (10));

} else {
var statearr_19275_19309 = state_19235__$1;
(statearr_19275_19309[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18045__auto___19281,mults,ensure_mult,p))
;
return ((function (switch__17943__auto__,c__18045__auto___19281,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__17944__auto__ = null;
var cljs$core$async$state_machine__17944__auto____0 = (function (){
var statearr_19276 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19276[(0)] = cljs$core$async$state_machine__17944__auto__);

(statearr_19276[(1)] = (1));

return statearr_19276;
});
var cljs$core$async$state_machine__17944__auto____1 = (function (state_19235){
while(true){
var ret_value__17945__auto__ = (function (){try{while(true){
var result__17946__auto__ = switch__17943__auto__(state_19235);
if(cljs.core.keyword_identical_QMARK_(result__17946__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17946__auto__;
}
break;
}
}catch (e19277){if((e19277 instanceof Object)){
var ex__17947__auto__ = e19277;
var statearr_19278_19310 = state_19235;
(statearr_19278_19310[(5)] = ex__17947__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19235);

return cljs.core.cst$kw$recur;
} else {
throw e19277;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17945__auto__,cljs.core.cst$kw$recur)){
var G__19311 = state_19235;
state_19235 = G__19311;
continue;
} else {
return ret_value__17945__auto__;
}
break;
}
});
cljs$core$async$state_machine__17944__auto__ = function(state_19235){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17944__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17944__auto____1.call(this,state_19235);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17944__auto____0;
cljs$core$async$state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17944__auto____1;
return cljs$core$async$state_machine__17944__auto__;
})()
;})(switch__17943__auto__,c__18045__auto___19281,mults,ensure_mult,p))
})();
var state__18047__auto__ = (function (){var statearr_19279 = (f__18046__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18046__auto__.cljs$core$IFn$_invoke$arity$0() : f__18046__auto__.call(null));
(statearr_19279[(6)] = c__18045__auto___19281);

return statearr_19279;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18047__auto__);
});})(c__18045__auto___19281,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__19313 = arguments.length;
switch (G__19313) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__19316 = arguments.length;
switch (G__19316) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__19319 = arguments.length;
switch (G__19319) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__18045__auto___19386 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18045__auto___19386,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__18046__auto__ = (function (){var switch__17943__auto__ = ((function (c__18045__auto___19386,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_19358){
var state_val_19359 = (state_19358[(1)]);
if((state_val_19359 === (7))){
var state_19358__$1 = state_19358;
var statearr_19360_19387 = state_19358__$1;
(statearr_19360_19387[(2)] = null);

(statearr_19360_19387[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19359 === (1))){
var state_19358__$1 = state_19358;
var statearr_19361_19388 = state_19358__$1;
(statearr_19361_19388[(2)] = null);

(statearr_19361_19388[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19359 === (4))){
var inst_19322 = (state_19358[(7)]);
var inst_19324 = (inst_19322 < cnt);
var state_19358__$1 = state_19358;
if(cljs.core.truth_(inst_19324)){
var statearr_19362_19389 = state_19358__$1;
(statearr_19362_19389[(1)] = (6));

} else {
var statearr_19363_19390 = state_19358__$1;
(statearr_19363_19390[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19359 === (15))){
var inst_19354 = (state_19358[(2)]);
var state_19358__$1 = state_19358;
var statearr_19364_19391 = state_19358__$1;
(statearr_19364_19391[(2)] = inst_19354);

(statearr_19364_19391[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19359 === (13))){
var inst_19347 = cljs.core.async.close_BANG_(out);
var state_19358__$1 = state_19358;
var statearr_19365_19392 = state_19358__$1;
(statearr_19365_19392[(2)] = inst_19347);

(statearr_19365_19392[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19359 === (6))){
var state_19358__$1 = state_19358;
var statearr_19366_19393 = state_19358__$1;
(statearr_19366_19393[(2)] = null);

(statearr_19366_19393[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19359 === (3))){
var inst_19356 = (state_19358[(2)]);
var state_19358__$1 = state_19358;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19358__$1,inst_19356);
} else {
if((state_val_19359 === (12))){
var inst_19344 = (state_19358[(8)]);
var inst_19344__$1 = (state_19358[(2)]);
var inst_19345 = cljs.core.some(cljs.core.nil_QMARK_,inst_19344__$1);
var state_19358__$1 = (function (){var statearr_19367 = state_19358;
(statearr_19367[(8)] = inst_19344__$1);

return statearr_19367;
})();
if(cljs.core.truth_(inst_19345)){
var statearr_19368_19394 = state_19358__$1;
(statearr_19368_19394[(1)] = (13));

} else {
var statearr_19369_19395 = state_19358__$1;
(statearr_19369_19395[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19359 === (2))){
var inst_19321 = cljs.core.reset_BANG_(dctr,cnt);
var inst_19322 = (0);
var state_19358__$1 = (function (){var statearr_19370 = state_19358;
(statearr_19370[(9)] = inst_19321);

(statearr_19370[(7)] = inst_19322);

return statearr_19370;
})();
var statearr_19371_19396 = state_19358__$1;
(statearr_19371_19396[(2)] = null);

(statearr_19371_19396[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19359 === (11))){
var inst_19322 = (state_19358[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_19358,(10),Object,null,(9));
var inst_19331 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_19322) : chs__$1.call(null,inst_19322));
var inst_19332 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_19322) : done.call(null,inst_19322));
var inst_19333 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_19331,inst_19332);
var state_19358__$1 = state_19358;
var statearr_19372_19397 = state_19358__$1;
(statearr_19372_19397[(2)] = inst_19333);


cljs.core.async.impl.ioc_helpers.process_exception(state_19358__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_19359 === (9))){
var inst_19322 = (state_19358[(7)]);
var inst_19335 = (state_19358[(2)]);
var inst_19336 = (inst_19322 + (1));
var inst_19322__$1 = inst_19336;
var state_19358__$1 = (function (){var statearr_19373 = state_19358;
(statearr_19373[(7)] = inst_19322__$1);

(statearr_19373[(10)] = inst_19335);

return statearr_19373;
})();
var statearr_19374_19398 = state_19358__$1;
(statearr_19374_19398[(2)] = null);

(statearr_19374_19398[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19359 === (5))){
var inst_19342 = (state_19358[(2)]);
var state_19358__$1 = (function (){var statearr_19375 = state_19358;
(statearr_19375[(11)] = inst_19342);

return statearr_19375;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19358__$1,(12),dchan);
} else {
if((state_val_19359 === (14))){
var inst_19344 = (state_19358[(8)]);
var inst_19349 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_19344);
var state_19358__$1 = state_19358;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19358__$1,(16),out,inst_19349);
} else {
if((state_val_19359 === (16))){
var inst_19351 = (state_19358[(2)]);
var state_19358__$1 = (function (){var statearr_19376 = state_19358;
(statearr_19376[(12)] = inst_19351);

return statearr_19376;
})();
var statearr_19377_19399 = state_19358__$1;
(statearr_19377_19399[(2)] = null);

(statearr_19377_19399[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19359 === (10))){
var inst_19326 = (state_19358[(2)]);
var inst_19327 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_19358__$1 = (function (){var statearr_19378 = state_19358;
(statearr_19378[(13)] = inst_19326);

return statearr_19378;
})();
var statearr_19379_19400 = state_19358__$1;
(statearr_19379_19400[(2)] = inst_19327);


cljs.core.async.impl.ioc_helpers.process_exception(state_19358__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_19359 === (8))){
var inst_19340 = (state_19358[(2)]);
var state_19358__$1 = state_19358;
var statearr_19380_19401 = state_19358__$1;
(statearr_19380_19401[(2)] = inst_19340);

(statearr_19380_19401[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18045__auto___19386,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__17943__auto__,c__18045__auto___19386,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__17944__auto__ = null;
var cljs$core$async$state_machine__17944__auto____0 = (function (){
var statearr_19381 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19381[(0)] = cljs$core$async$state_machine__17944__auto__);

(statearr_19381[(1)] = (1));

return statearr_19381;
});
var cljs$core$async$state_machine__17944__auto____1 = (function (state_19358){
while(true){
var ret_value__17945__auto__ = (function (){try{while(true){
var result__17946__auto__ = switch__17943__auto__(state_19358);
if(cljs.core.keyword_identical_QMARK_(result__17946__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17946__auto__;
}
break;
}
}catch (e19382){if((e19382 instanceof Object)){
var ex__17947__auto__ = e19382;
var statearr_19383_19402 = state_19358;
(statearr_19383_19402[(5)] = ex__17947__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19358);

return cljs.core.cst$kw$recur;
} else {
throw e19382;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17945__auto__,cljs.core.cst$kw$recur)){
var G__19403 = state_19358;
state_19358 = G__19403;
continue;
} else {
return ret_value__17945__auto__;
}
break;
}
});
cljs$core$async$state_machine__17944__auto__ = function(state_19358){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17944__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17944__auto____1.call(this,state_19358);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17944__auto____0;
cljs$core$async$state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17944__auto____1;
return cljs$core$async$state_machine__17944__auto__;
})()
;})(switch__17943__auto__,c__18045__auto___19386,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__18047__auto__ = (function (){var statearr_19384 = (f__18046__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18046__auto__.cljs$core$IFn$_invoke$arity$0() : f__18046__auto__.call(null));
(statearr_19384[(6)] = c__18045__auto___19386);

return statearr_19384;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18047__auto__);
});})(c__18045__auto___19386,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__19406 = arguments.length;
switch (G__19406) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__18045__auto___19460 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18045__auto___19460,out){
return (function (){
var f__18046__auto__ = (function (){var switch__17943__auto__ = ((function (c__18045__auto___19460,out){
return (function (state_19438){
var state_val_19439 = (state_19438[(1)]);
if((state_val_19439 === (7))){
var inst_19417 = (state_19438[(7)]);
var inst_19418 = (state_19438[(8)]);
var inst_19417__$1 = (state_19438[(2)]);
var inst_19418__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19417__$1,(0),null);
var inst_19419 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19417__$1,(1),null);
var inst_19420 = (inst_19418__$1 == null);
var state_19438__$1 = (function (){var statearr_19440 = state_19438;
(statearr_19440[(9)] = inst_19419);

(statearr_19440[(7)] = inst_19417__$1);

(statearr_19440[(8)] = inst_19418__$1);

return statearr_19440;
})();
if(cljs.core.truth_(inst_19420)){
var statearr_19441_19461 = state_19438__$1;
(statearr_19441_19461[(1)] = (8));

} else {
var statearr_19442_19462 = state_19438__$1;
(statearr_19442_19462[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19439 === (1))){
var inst_19407 = cljs.core.vec(chs);
var inst_19408 = inst_19407;
var state_19438__$1 = (function (){var statearr_19443 = state_19438;
(statearr_19443[(10)] = inst_19408);

return statearr_19443;
})();
var statearr_19444_19463 = state_19438__$1;
(statearr_19444_19463[(2)] = null);

(statearr_19444_19463[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19439 === (4))){
var inst_19408 = (state_19438[(10)]);
var state_19438__$1 = state_19438;
return cljs.core.async.ioc_alts_BANG_(state_19438__$1,(7),inst_19408);
} else {
if((state_val_19439 === (6))){
var inst_19434 = (state_19438[(2)]);
var state_19438__$1 = state_19438;
var statearr_19445_19464 = state_19438__$1;
(statearr_19445_19464[(2)] = inst_19434);

(statearr_19445_19464[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19439 === (3))){
var inst_19436 = (state_19438[(2)]);
var state_19438__$1 = state_19438;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19438__$1,inst_19436);
} else {
if((state_val_19439 === (2))){
var inst_19408 = (state_19438[(10)]);
var inst_19410 = cljs.core.count(inst_19408);
var inst_19411 = (inst_19410 > (0));
var state_19438__$1 = state_19438;
if(cljs.core.truth_(inst_19411)){
var statearr_19447_19465 = state_19438__$1;
(statearr_19447_19465[(1)] = (4));

} else {
var statearr_19448_19466 = state_19438__$1;
(statearr_19448_19466[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19439 === (11))){
var inst_19408 = (state_19438[(10)]);
var inst_19427 = (state_19438[(2)]);
var tmp19446 = inst_19408;
var inst_19408__$1 = tmp19446;
var state_19438__$1 = (function (){var statearr_19449 = state_19438;
(statearr_19449[(10)] = inst_19408__$1);

(statearr_19449[(11)] = inst_19427);

return statearr_19449;
})();
var statearr_19450_19467 = state_19438__$1;
(statearr_19450_19467[(2)] = null);

(statearr_19450_19467[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19439 === (9))){
var inst_19418 = (state_19438[(8)]);
var state_19438__$1 = state_19438;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19438__$1,(11),out,inst_19418);
} else {
if((state_val_19439 === (5))){
var inst_19432 = cljs.core.async.close_BANG_(out);
var state_19438__$1 = state_19438;
var statearr_19451_19468 = state_19438__$1;
(statearr_19451_19468[(2)] = inst_19432);

(statearr_19451_19468[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19439 === (10))){
var inst_19430 = (state_19438[(2)]);
var state_19438__$1 = state_19438;
var statearr_19452_19469 = state_19438__$1;
(statearr_19452_19469[(2)] = inst_19430);

(statearr_19452_19469[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19439 === (8))){
var inst_19419 = (state_19438[(9)]);
var inst_19417 = (state_19438[(7)]);
var inst_19408 = (state_19438[(10)]);
var inst_19418 = (state_19438[(8)]);
var inst_19422 = (function (){var cs = inst_19408;
var vec__19413 = inst_19417;
var v = inst_19418;
var c = inst_19419;
return ((function (cs,vec__19413,v,c,inst_19419,inst_19417,inst_19408,inst_19418,state_val_19439,c__18045__auto___19460,out){
return (function (p1__19404_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__19404_SHARP_);
});
;})(cs,vec__19413,v,c,inst_19419,inst_19417,inst_19408,inst_19418,state_val_19439,c__18045__auto___19460,out))
})();
var inst_19423 = cljs.core.filterv(inst_19422,inst_19408);
var inst_19408__$1 = inst_19423;
var state_19438__$1 = (function (){var statearr_19453 = state_19438;
(statearr_19453[(10)] = inst_19408__$1);

return statearr_19453;
})();
var statearr_19454_19470 = state_19438__$1;
(statearr_19454_19470[(2)] = null);

(statearr_19454_19470[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__18045__auto___19460,out))
;
return ((function (switch__17943__auto__,c__18045__auto___19460,out){
return (function() {
var cljs$core$async$state_machine__17944__auto__ = null;
var cljs$core$async$state_machine__17944__auto____0 = (function (){
var statearr_19455 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19455[(0)] = cljs$core$async$state_machine__17944__auto__);

(statearr_19455[(1)] = (1));

return statearr_19455;
});
var cljs$core$async$state_machine__17944__auto____1 = (function (state_19438){
while(true){
var ret_value__17945__auto__ = (function (){try{while(true){
var result__17946__auto__ = switch__17943__auto__(state_19438);
if(cljs.core.keyword_identical_QMARK_(result__17946__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17946__auto__;
}
break;
}
}catch (e19456){if((e19456 instanceof Object)){
var ex__17947__auto__ = e19456;
var statearr_19457_19471 = state_19438;
(statearr_19457_19471[(5)] = ex__17947__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19438);

return cljs.core.cst$kw$recur;
} else {
throw e19456;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17945__auto__,cljs.core.cst$kw$recur)){
var G__19472 = state_19438;
state_19438 = G__19472;
continue;
} else {
return ret_value__17945__auto__;
}
break;
}
});
cljs$core$async$state_machine__17944__auto__ = function(state_19438){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17944__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17944__auto____1.call(this,state_19438);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17944__auto____0;
cljs$core$async$state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17944__auto____1;
return cljs$core$async$state_machine__17944__auto__;
})()
;})(switch__17943__auto__,c__18045__auto___19460,out))
})();
var state__18047__auto__ = (function (){var statearr_19458 = (f__18046__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18046__auto__.cljs$core$IFn$_invoke$arity$0() : f__18046__auto__.call(null));
(statearr_19458[(6)] = c__18045__auto___19460);

return statearr_19458;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18047__auto__);
});})(c__18045__auto___19460,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__19474 = arguments.length;
switch (G__19474) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__18045__auto___19519 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18045__auto___19519,out){
return (function (){
var f__18046__auto__ = (function (){var switch__17943__auto__ = ((function (c__18045__auto___19519,out){
return (function (state_19498){
var state_val_19499 = (state_19498[(1)]);
if((state_val_19499 === (7))){
var inst_19480 = (state_19498[(7)]);
var inst_19480__$1 = (state_19498[(2)]);
var inst_19481 = (inst_19480__$1 == null);
var inst_19482 = cljs.core.not(inst_19481);
var state_19498__$1 = (function (){var statearr_19500 = state_19498;
(statearr_19500[(7)] = inst_19480__$1);

return statearr_19500;
})();
if(inst_19482){
var statearr_19501_19520 = state_19498__$1;
(statearr_19501_19520[(1)] = (8));

} else {
var statearr_19502_19521 = state_19498__$1;
(statearr_19502_19521[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19499 === (1))){
var inst_19475 = (0);
var state_19498__$1 = (function (){var statearr_19503 = state_19498;
(statearr_19503[(8)] = inst_19475);

return statearr_19503;
})();
var statearr_19504_19522 = state_19498__$1;
(statearr_19504_19522[(2)] = null);

(statearr_19504_19522[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19499 === (4))){
var state_19498__$1 = state_19498;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19498__$1,(7),ch);
} else {
if((state_val_19499 === (6))){
var inst_19493 = (state_19498[(2)]);
var state_19498__$1 = state_19498;
var statearr_19505_19523 = state_19498__$1;
(statearr_19505_19523[(2)] = inst_19493);

(statearr_19505_19523[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19499 === (3))){
var inst_19495 = (state_19498[(2)]);
var inst_19496 = cljs.core.async.close_BANG_(out);
var state_19498__$1 = (function (){var statearr_19506 = state_19498;
(statearr_19506[(9)] = inst_19495);

return statearr_19506;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_19498__$1,inst_19496);
} else {
if((state_val_19499 === (2))){
var inst_19475 = (state_19498[(8)]);
var inst_19477 = (inst_19475 < n);
var state_19498__$1 = state_19498;
if(cljs.core.truth_(inst_19477)){
var statearr_19507_19524 = state_19498__$1;
(statearr_19507_19524[(1)] = (4));

} else {
var statearr_19508_19525 = state_19498__$1;
(statearr_19508_19525[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19499 === (11))){
var inst_19475 = (state_19498[(8)]);
var inst_19485 = (state_19498[(2)]);
var inst_19486 = (inst_19475 + (1));
var inst_19475__$1 = inst_19486;
var state_19498__$1 = (function (){var statearr_19509 = state_19498;
(statearr_19509[(10)] = inst_19485);

(statearr_19509[(8)] = inst_19475__$1);

return statearr_19509;
})();
var statearr_19510_19526 = state_19498__$1;
(statearr_19510_19526[(2)] = null);

(statearr_19510_19526[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19499 === (9))){
var state_19498__$1 = state_19498;
var statearr_19511_19527 = state_19498__$1;
(statearr_19511_19527[(2)] = null);

(statearr_19511_19527[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19499 === (5))){
var state_19498__$1 = state_19498;
var statearr_19512_19528 = state_19498__$1;
(statearr_19512_19528[(2)] = null);

(statearr_19512_19528[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19499 === (10))){
var inst_19490 = (state_19498[(2)]);
var state_19498__$1 = state_19498;
var statearr_19513_19529 = state_19498__$1;
(statearr_19513_19529[(2)] = inst_19490);

(statearr_19513_19529[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19499 === (8))){
var inst_19480 = (state_19498[(7)]);
var state_19498__$1 = state_19498;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19498__$1,(11),out,inst_19480);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__18045__auto___19519,out))
;
return ((function (switch__17943__auto__,c__18045__auto___19519,out){
return (function() {
var cljs$core$async$state_machine__17944__auto__ = null;
var cljs$core$async$state_machine__17944__auto____0 = (function (){
var statearr_19514 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19514[(0)] = cljs$core$async$state_machine__17944__auto__);

(statearr_19514[(1)] = (1));

return statearr_19514;
});
var cljs$core$async$state_machine__17944__auto____1 = (function (state_19498){
while(true){
var ret_value__17945__auto__ = (function (){try{while(true){
var result__17946__auto__ = switch__17943__auto__(state_19498);
if(cljs.core.keyword_identical_QMARK_(result__17946__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17946__auto__;
}
break;
}
}catch (e19515){if((e19515 instanceof Object)){
var ex__17947__auto__ = e19515;
var statearr_19516_19530 = state_19498;
(statearr_19516_19530[(5)] = ex__17947__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19498);

return cljs.core.cst$kw$recur;
} else {
throw e19515;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17945__auto__,cljs.core.cst$kw$recur)){
var G__19531 = state_19498;
state_19498 = G__19531;
continue;
} else {
return ret_value__17945__auto__;
}
break;
}
});
cljs$core$async$state_machine__17944__auto__ = function(state_19498){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17944__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17944__auto____1.call(this,state_19498);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17944__auto____0;
cljs$core$async$state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17944__auto____1;
return cljs$core$async$state_machine__17944__auto__;
})()
;})(switch__17943__auto__,c__18045__auto___19519,out))
})();
var state__18047__auto__ = (function (){var statearr_19517 = (f__18046__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18046__auto__.cljs$core$IFn$_invoke$arity$0() : f__18046__auto__.call(null));
(statearr_19517[(6)] = c__18045__auto___19519);

return statearr_19517;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18047__auto__);
});})(c__18045__auto___19519,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19533 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19533 = (function (f,ch,meta19534){
this.f = f;
this.ch = ch;
this.meta19534 = meta19534;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async19533.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19535,meta19534__$1){
var self__ = this;
var _19535__$1 = this;
return (new cljs.core.async.t_cljs$core$async19533(self__.f,self__.ch,meta19534__$1));
});

cljs.core.async.t_cljs$core$async19533.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19535){
var self__ = this;
var _19535__$1 = this;
return self__.meta19534;
});

cljs.core.async.t_cljs$core$async19533.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19533.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async19533.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async19533.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19533.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async19536 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19536 = (function (f,ch,meta19534,_,fn1,meta19537){
this.f = f;
this.ch = ch;
this.meta19534 = meta19534;
this._ = _;
this.fn1 = fn1;
this.meta19537 = meta19537;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async19536.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_19538,meta19537__$1){
var self__ = this;
var _19538__$1 = this;
return (new cljs.core.async.t_cljs$core$async19536(self__.f,self__.ch,self__.meta19534,self__._,self__.fn1,meta19537__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async19536.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_19538){
var self__ = this;
var _19538__$1 = this;
return self__.meta19537;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19536.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19536.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19536.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19536.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__19532_SHARP_){
var G__19539 = (((p1__19532_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__19532_SHARP_) : self__.f.call(null,p1__19532_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__19539) : f1.call(null,G__19539));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async19536.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta19534,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async19533], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta19537], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19536.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19536.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19536";

cljs.core.async.t_cljs$core$async19536.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async19536");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async19536 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19536(f__$1,ch__$1,meta19534__$1,___$2,fn1__$1,meta19537){
return (new cljs.core.async.t_cljs$core$async19536(f__$1,ch__$1,meta19534__$1,___$2,fn1__$1,meta19537));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async19536(self__.f,self__.ch,self__.meta19534,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__8794__auto__ = ret;
if(cljs.core.truth_(and__8794__auto__)){
return !((cljs.core.deref(ret) == null));
} else {
return and__8794__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__19540 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__19540) : self__.f.call(null,G__19540));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async19533.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19533.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async19533.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta19534], null);
});

cljs.core.async.t_cljs$core$async19533.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19533.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19533";

cljs.core.async.t_cljs$core$async19533.cljs$lang$ctorPrWriter = (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async19533");
});

cljs.core.async.__GT_t_cljs$core$async19533 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19533(f__$1,ch__$1,meta19534){
return (new cljs.core.async.t_cljs$core$async19533(f__$1,ch__$1,meta19534));
});

}

return (new cljs.core.async.t_cljs$core$async19533(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19541 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19541 = (function (f,ch,meta19542){
this.f = f;
this.ch = ch;
this.meta19542 = meta19542;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async19541.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19543,meta19542__$1){
var self__ = this;
var _19543__$1 = this;
return (new cljs.core.async.t_cljs$core$async19541(self__.f,self__.ch,meta19542__$1));
});

cljs.core.async.t_cljs$core$async19541.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19543){
var self__ = this;
var _19543__$1 = this;
return self__.meta19542;
});

cljs.core.async.t_cljs$core$async19541.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19541.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async19541.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19541.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19541.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19541.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async19541.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta19542], null);
});

cljs.core.async.t_cljs$core$async19541.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19541.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19541";

cljs.core.async.t_cljs$core$async19541.cljs$lang$ctorPrWriter = (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async19541");
});

cljs.core.async.__GT_t_cljs$core$async19541 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async19541(f__$1,ch__$1,meta19542){
return (new cljs.core.async.t_cljs$core$async19541(f__$1,ch__$1,meta19542));
});

}

return (new cljs.core.async.t_cljs$core$async19541(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async19544 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19544 = (function (p,ch,meta19545){
this.p = p;
this.ch = ch;
this.meta19545 = meta19545;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async19544.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19546,meta19545__$1){
var self__ = this;
var _19546__$1 = this;
return (new cljs.core.async.t_cljs$core$async19544(self__.p,self__.ch,meta19545__$1));
});

cljs.core.async.t_cljs$core$async19544.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19546){
var self__ = this;
var _19546__$1 = this;
return self__.meta19545;
});

cljs.core.async.t_cljs$core$async19544.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19544.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async19544.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async19544.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19544.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19544.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19544.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async19544.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta19545], null);
});

cljs.core.async.t_cljs$core$async19544.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19544.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19544";

cljs.core.async.t_cljs$core$async19544.cljs$lang$ctorPrWriter = (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async19544");
});

cljs.core.async.__GT_t_cljs$core$async19544 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async19544(p__$1,ch__$1,meta19545){
return (new cljs.core.async.t_cljs$core$async19544(p__$1,ch__$1,meta19545));
});

}

return (new cljs.core.async.t_cljs$core$async19544(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__19548 = arguments.length;
switch (G__19548) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__18045__auto___19588 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18045__auto___19588,out){
return (function (){
var f__18046__auto__ = (function (){var switch__17943__auto__ = ((function (c__18045__auto___19588,out){
return (function (state_19569){
var state_val_19570 = (state_19569[(1)]);
if((state_val_19570 === (7))){
var inst_19565 = (state_19569[(2)]);
var state_19569__$1 = state_19569;
var statearr_19571_19589 = state_19569__$1;
(statearr_19571_19589[(2)] = inst_19565);

(statearr_19571_19589[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19570 === (1))){
var state_19569__$1 = state_19569;
var statearr_19572_19590 = state_19569__$1;
(statearr_19572_19590[(2)] = null);

(statearr_19572_19590[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19570 === (4))){
var inst_19551 = (state_19569[(7)]);
var inst_19551__$1 = (state_19569[(2)]);
var inst_19552 = (inst_19551__$1 == null);
var state_19569__$1 = (function (){var statearr_19573 = state_19569;
(statearr_19573[(7)] = inst_19551__$1);

return statearr_19573;
})();
if(cljs.core.truth_(inst_19552)){
var statearr_19574_19591 = state_19569__$1;
(statearr_19574_19591[(1)] = (5));

} else {
var statearr_19575_19592 = state_19569__$1;
(statearr_19575_19592[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19570 === (6))){
var inst_19551 = (state_19569[(7)]);
var inst_19556 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_19551) : p.call(null,inst_19551));
var state_19569__$1 = state_19569;
if(cljs.core.truth_(inst_19556)){
var statearr_19576_19593 = state_19569__$1;
(statearr_19576_19593[(1)] = (8));

} else {
var statearr_19577_19594 = state_19569__$1;
(statearr_19577_19594[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19570 === (3))){
var inst_19567 = (state_19569[(2)]);
var state_19569__$1 = state_19569;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19569__$1,inst_19567);
} else {
if((state_val_19570 === (2))){
var state_19569__$1 = state_19569;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19569__$1,(4),ch);
} else {
if((state_val_19570 === (11))){
var inst_19559 = (state_19569[(2)]);
var state_19569__$1 = state_19569;
var statearr_19578_19595 = state_19569__$1;
(statearr_19578_19595[(2)] = inst_19559);

(statearr_19578_19595[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19570 === (9))){
var state_19569__$1 = state_19569;
var statearr_19579_19596 = state_19569__$1;
(statearr_19579_19596[(2)] = null);

(statearr_19579_19596[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19570 === (5))){
var inst_19554 = cljs.core.async.close_BANG_(out);
var state_19569__$1 = state_19569;
var statearr_19580_19597 = state_19569__$1;
(statearr_19580_19597[(2)] = inst_19554);

(statearr_19580_19597[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19570 === (10))){
var inst_19562 = (state_19569[(2)]);
var state_19569__$1 = (function (){var statearr_19581 = state_19569;
(statearr_19581[(8)] = inst_19562);

return statearr_19581;
})();
var statearr_19582_19598 = state_19569__$1;
(statearr_19582_19598[(2)] = null);

(statearr_19582_19598[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19570 === (8))){
var inst_19551 = (state_19569[(7)]);
var state_19569__$1 = state_19569;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19569__$1,(11),out,inst_19551);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__18045__auto___19588,out))
;
return ((function (switch__17943__auto__,c__18045__auto___19588,out){
return (function() {
var cljs$core$async$state_machine__17944__auto__ = null;
var cljs$core$async$state_machine__17944__auto____0 = (function (){
var statearr_19583 = [null,null,null,null,null,null,null,null,null];
(statearr_19583[(0)] = cljs$core$async$state_machine__17944__auto__);

(statearr_19583[(1)] = (1));

return statearr_19583;
});
var cljs$core$async$state_machine__17944__auto____1 = (function (state_19569){
while(true){
var ret_value__17945__auto__ = (function (){try{while(true){
var result__17946__auto__ = switch__17943__auto__(state_19569);
if(cljs.core.keyword_identical_QMARK_(result__17946__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17946__auto__;
}
break;
}
}catch (e19584){if((e19584 instanceof Object)){
var ex__17947__auto__ = e19584;
var statearr_19585_19599 = state_19569;
(statearr_19585_19599[(5)] = ex__17947__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19569);

return cljs.core.cst$kw$recur;
} else {
throw e19584;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17945__auto__,cljs.core.cst$kw$recur)){
var G__19600 = state_19569;
state_19569 = G__19600;
continue;
} else {
return ret_value__17945__auto__;
}
break;
}
});
cljs$core$async$state_machine__17944__auto__ = function(state_19569){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17944__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17944__auto____1.call(this,state_19569);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17944__auto____0;
cljs$core$async$state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17944__auto____1;
return cljs$core$async$state_machine__17944__auto__;
})()
;})(switch__17943__auto__,c__18045__auto___19588,out))
})();
var state__18047__auto__ = (function (){var statearr_19586 = (f__18046__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18046__auto__.cljs$core$IFn$_invoke$arity$0() : f__18046__auto__.call(null));
(statearr_19586[(6)] = c__18045__auto___19588);

return statearr_19586;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18047__auto__);
});})(c__18045__auto___19588,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__19602 = arguments.length;
switch (G__19602) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__18045__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18045__auto__){
return (function (){
var f__18046__auto__ = (function (){var switch__17943__auto__ = ((function (c__18045__auto__){
return (function (state_19665){
var state_val_19666 = (state_19665[(1)]);
if((state_val_19666 === (7))){
var inst_19661 = (state_19665[(2)]);
var state_19665__$1 = state_19665;
var statearr_19667_19705 = state_19665__$1;
(statearr_19667_19705[(2)] = inst_19661);

(statearr_19667_19705[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19666 === (20))){
var inst_19631 = (state_19665[(7)]);
var inst_19642 = (state_19665[(2)]);
var inst_19643 = cljs.core.next(inst_19631);
var inst_19617 = inst_19643;
var inst_19618 = null;
var inst_19619 = (0);
var inst_19620 = (0);
var state_19665__$1 = (function (){var statearr_19668 = state_19665;
(statearr_19668[(8)] = inst_19620);

(statearr_19668[(9)] = inst_19619);

(statearr_19668[(10)] = inst_19642);

(statearr_19668[(11)] = inst_19617);

(statearr_19668[(12)] = inst_19618);

return statearr_19668;
})();
var statearr_19669_19706 = state_19665__$1;
(statearr_19669_19706[(2)] = null);

(statearr_19669_19706[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19666 === (1))){
var state_19665__$1 = state_19665;
var statearr_19670_19707 = state_19665__$1;
(statearr_19670_19707[(2)] = null);

(statearr_19670_19707[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19666 === (4))){
var inst_19606 = (state_19665[(13)]);
var inst_19606__$1 = (state_19665[(2)]);
var inst_19607 = (inst_19606__$1 == null);
var state_19665__$1 = (function (){var statearr_19671 = state_19665;
(statearr_19671[(13)] = inst_19606__$1);

return statearr_19671;
})();
if(cljs.core.truth_(inst_19607)){
var statearr_19672_19708 = state_19665__$1;
(statearr_19672_19708[(1)] = (5));

} else {
var statearr_19673_19709 = state_19665__$1;
(statearr_19673_19709[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19666 === (15))){
var state_19665__$1 = state_19665;
var statearr_19677_19710 = state_19665__$1;
(statearr_19677_19710[(2)] = null);

(statearr_19677_19710[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19666 === (21))){
var state_19665__$1 = state_19665;
var statearr_19678_19711 = state_19665__$1;
(statearr_19678_19711[(2)] = null);

(statearr_19678_19711[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19666 === (13))){
var inst_19620 = (state_19665[(8)]);
var inst_19619 = (state_19665[(9)]);
var inst_19617 = (state_19665[(11)]);
var inst_19618 = (state_19665[(12)]);
var inst_19627 = (state_19665[(2)]);
var inst_19628 = (inst_19620 + (1));
var tmp19674 = inst_19619;
var tmp19675 = inst_19617;
var tmp19676 = inst_19618;
var inst_19617__$1 = tmp19675;
var inst_19618__$1 = tmp19676;
var inst_19619__$1 = tmp19674;
var inst_19620__$1 = inst_19628;
var state_19665__$1 = (function (){var statearr_19679 = state_19665;
(statearr_19679[(8)] = inst_19620__$1);

(statearr_19679[(9)] = inst_19619__$1);

(statearr_19679[(14)] = inst_19627);

(statearr_19679[(11)] = inst_19617__$1);

(statearr_19679[(12)] = inst_19618__$1);

return statearr_19679;
})();
var statearr_19680_19712 = state_19665__$1;
(statearr_19680_19712[(2)] = null);

(statearr_19680_19712[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19666 === (22))){
var state_19665__$1 = state_19665;
var statearr_19681_19713 = state_19665__$1;
(statearr_19681_19713[(2)] = null);

(statearr_19681_19713[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19666 === (6))){
var inst_19606 = (state_19665[(13)]);
var inst_19615 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_19606) : f.call(null,inst_19606));
var inst_19616 = cljs.core.seq(inst_19615);
var inst_19617 = inst_19616;
var inst_19618 = null;
var inst_19619 = (0);
var inst_19620 = (0);
var state_19665__$1 = (function (){var statearr_19682 = state_19665;
(statearr_19682[(8)] = inst_19620);

(statearr_19682[(9)] = inst_19619);

(statearr_19682[(11)] = inst_19617);

(statearr_19682[(12)] = inst_19618);

return statearr_19682;
})();
var statearr_19683_19714 = state_19665__$1;
(statearr_19683_19714[(2)] = null);

(statearr_19683_19714[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19666 === (17))){
var inst_19631 = (state_19665[(7)]);
var inst_19635 = cljs.core.chunk_first(inst_19631);
var inst_19636 = cljs.core.chunk_rest(inst_19631);
var inst_19637 = cljs.core.count(inst_19635);
var inst_19617 = inst_19636;
var inst_19618 = inst_19635;
var inst_19619 = inst_19637;
var inst_19620 = (0);
var state_19665__$1 = (function (){var statearr_19684 = state_19665;
(statearr_19684[(8)] = inst_19620);

(statearr_19684[(9)] = inst_19619);

(statearr_19684[(11)] = inst_19617);

(statearr_19684[(12)] = inst_19618);

return statearr_19684;
})();
var statearr_19685_19715 = state_19665__$1;
(statearr_19685_19715[(2)] = null);

(statearr_19685_19715[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19666 === (3))){
var inst_19663 = (state_19665[(2)]);
var state_19665__$1 = state_19665;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19665__$1,inst_19663);
} else {
if((state_val_19666 === (12))){
var inst_19651 = (state_19665[(2)]);
var state_19665__$1 = state_19665;
var statearr_19686_19716 = state_19665__$1;
(statearr_19686_19716[(2)] = inst_19651);

(statearr_19686_19716[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19666 === (2))){
var state_19665__$1 = state_19665;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19665__$1,(4),in$);
} else {
if((state_val_19666 === (23))){
var inst_19659 = (state_19665[(2)]);
var state_19665__$1 = state_19665;
var statearr_19687_19717 = state_19665__$1;
(statearr_19687_19717[(2)] = inst_19659);

(statearr_19687_19717[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19666 === (19))){
var inst_19646 = (state_19665[(2)]);
var state_19665__$1 = state_19665;
var statearr_19688_19718 = state_19665__$1;
(statearr_19688_19718[(2)] = inst_19646);

(statearr_19688_19718[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19666 === (11))){
var inst_19631 = (state_19665[(7)]);
var inst_19617 = (state_19665[(11)]);
var inst_19631__$1 = cljs.core.seq(inst_19617);
var state_19665__$1 = (function (){var statearr_19689 = state_19665;
(statearr_19689[(7)] = inst_19631__$1);

return statearr_19689;
})();
if(inst_19631__$1){
var statearr_19690_19719 = state_19665__$1;
(statearr_19690_19719[(1)] = (14));

} else {
var statearr_19691_19720 = state_19665__$1;
(statearr_19691_19720[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19666 === (9))){
var inst_19653 = (state_19665[(2)]);
var inst_19654 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_19665__$1 = (function (){var statearr_19692 = state_19665;
(statearr_19692[(15)] = inst_19653);

return statearr_19692;
})();
if(cljs.core.truth_(inst_19654)){
var statearr_19693_19721 = state_19665__$1;
(statearr_19693_19721[(1)] = (21));

} else {
var statearr_19694_19722 = state_19665__$1;
(statearr_19694_19722[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19666 === (5))){
var inst_19609 = cljs.core.async.close_BANG_(out);
var state_19665__$1 = state_19665;
var statearr_19695_19723 = state_19665__$1;
(statearr_19695_19723[(2)] = inst_19609);

(statearr_19695_19723[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19666 === (14))){
var inst_19631 = (state_19665[(7)]);
var inst_19633 = cljs.core.chunked_seq_QMARK_(inst_19631);
var state_19665__$1 = state_19665;
if(inst_19633){
var statearr_19696_19724 = state_19665__$1;
(statearr_19696_19724[(1)] = (17));

} else {
var statearr_19697_19725 = state_19665__$1;
(statearr_19697_19725[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19666 === (16))){
var inst_19649 = (state_19665[(2)]);
var state_19665__$1 = state_19665;
var statearr_19698_19726 = state_19665__$1;
(statearr_19698_19726[(2)] = inst_19649);

(statearr_19698_19726[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19666 === (10))){
var inst_19620 = (state_19665[(8)]);
var inst_19618 = (state_19665[(12)]);
var inst_19625 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_19618,inst_19620);
var state_19665__$1 = state_19665;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19665__$1,(13),out,inst_19625);
} else {
if((state_val_19666 === (18))){
var inst_19631 = (state_19665[(7)]);
var inst_19640 = cljs.core.first(inst_19631);
var state_19665__$1 = state_19665;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19665__$1,(20),out,inst_19640);
} else {
if((state_val_19666 === (8))){
var inst_19620 = (state_19665[(8)]);
var inst_19619 = (state_19665[(9)]);
var inst_19622 = (inst_19620 < inst_19619);
var inst_19623 = inst_19622;
var state_19665__$1 = state_19665;
if(cljs.core.truth_(inst_19623)){
var statearr_19699_19727 = state_19665__$1;
(statearr_19699_19727[(1)] = (10));

} else {
var statearr_19700_19728 = state_19665__$1;
(statearr_19700_19728[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18045__auto__))
;
return ((function (switch__17943__auto__,c__18045__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__17944__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__17944__auto____0 = (function (){
var statearr_19701 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19701[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__17944__auto__);

(statearr_19701[(1)] = (1));

return statearr_19701;
});
var cljs$core$async$mapcat_STAR__$_state_machine__17944__auto____1 = (function (state_19665){
while(true){
var ret_value__17945__auto__ = (function (){try{while(true){
var result__17946__auto__ = switch__17943__auto__(state_19665);
if(cljs.core.keyword_identical_QMARK_(result__17946__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17946__auto__;
}
break;
}
}catch (e19702){if((e19702 instanceof Object)){
var ex__17947__auto__ = e19702;
var statearr_19703_19729 = state_19665;
(statearr_19703_19729[(5)] = ex__17947__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19665);

return cljs.core.cst$kw$recur;
} else {
throw e19702;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17945__auto__,cljs.core.cst$kw$recur)){
var G__19730 = state_19665;
state_19665 = G__19730;
continue;
} else {
return ret_value__17945__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__17944__auto__ = function(state_19665){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__17944__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__17944__auto____1.call(this,state_19665);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__17944__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__17944__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__17944__auto__;
})()
;})(switch__17943__auto__,c__18045__auto__))
})();
var state__18047__auto__ = (function (){var statearr_19704 = (f__18046__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18046__auto__.cljs$core$IFn$_invoke$arity$0() : f__18046__auto__.call(null));
(statearr_19704[(6)] = c__18045__auto__);

return statearr_19704;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18047__auto__);
});})(c__18045__auto__))
);

return c__18045__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__19732 = arguments.length;
switch (G__19732) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__19735 = arguments.length;
switch (G__19735) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__19738 = arguments.length;
switch (G__19738) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__18045__auto___19785 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18045__auto___19785,out){
return (function (){
var f__18046__auto__ = (function (){var switch__17943__auto__ = ((function (c__18045__auto___19785,out){
return (function (state_19762){
var state_val_19763 = (state_19762[(1)]);
if((state_val_19763 === (7))){
var inst_19757 = (state_19762[(2)]);
var state_19762__$1 = state_19762;
var statearr_19764_19786 = state_19762__$1;
(statearr_19764_19786[(2)] = inst_19757);

(statearr_19764_19786[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19763 === (1))){
var inst_19739 = null;
var state_19762__$1 = (function (){var statearr_19765 = state_19762;
(statearr_19765[(7)] = inst_19739);

return statearr_19765;
})();
var statearr_19766_19787 = state_19762__$1;
(statearr_19766_19787[(2)] = null);

(statearr_19766_19787[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19763 === (4))){
var inst_19742 = (state_19762[(8)]);
var inst_19742__$1 = (state_19762[(2)]);
var inst_19743 = (inst_19742__$1 == null);
var inst_19744 = cljs.core.not(inst_19743);
var state_19762__$1 = (function (){var statearr_19767 = state_19762;
(statearr_19767[(8)] = inst_19742__$1);

return statearr_19767;
})();
if(inst_19744){
var statearr_19768_19788 = state_19762__$1;
(statearr_19768_19788[(1)] = (5));

} else {
var statearr_19769_19789 = state_19762__$1;
(statearr_19769_19789[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19763 === (6))){
var state_19762__$1 = state_19762;
var statearr_19770_19790 = state_19762__$1;
(statearr_19770_19790[(2)] = null);

(statearr_19770_19790[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19763 === (3))){
var inst_19759 = (state_19762[(2)]);
var inst_19760 = cljs.core.async.close_BANG_(out);
var state_19762__$1 = (function (){var statearr_19771 = state_19762;
(statearr_19771[(9)] = inst_19759);

return statearr_19771;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_19762__$1,inst_19760);
} else {
if((state_val_19763 === (2))){
var state_19762__$1 = state_19762;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19762__$1,(4),ch);
} else {
if((state_val_19763 === (11))){
var inst_19742 = (state_19762[(8)]);
var inst_19751 = (state_19762[(2)]);
var inst_19739 = inst_19742;
var state_19762__$1 = (function (){var statearr_19772 = state_19762;
(statearr_19772[(7)] = inst_19739);

(statearr_19772[(10)] = inst_19751);

return statearr_19772;
})();
var statearr_19773_19791 = state_19762__$1;
(statearr_19773_19791[(2)] = null);

(statearr_19773_19791[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19763 === (9))){
var inst_19742 = (state_19762[(8)]);
var state_19762__$1 = state_19762;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19762__$1,(11),out,inst_19742);
} else {
if((state_val_19763 === (5))){
var inst_19739 = (state_19762[(7)]);
var inst_19742 = (state_19762[(8)]);
var inst_19746 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_19742,inst_19739);
var state_19762__$1 = state_19762;
if(inst_19746){
var statearr_19775_19792 = state_19762__$1;
(statearr_19775_19792[(1)] = (8));

} else {
var statearr_19776_19793 = state_19762__$1;
(statearr_19776_19793[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19763 === (10))){
var inst_19754 = (state_19762[(2)]);
var state_19762__$1 = state_19762;
var statearr_19777_19794 = state_19762__$1;
(statearr_19777_19794[(2)] = inst_19754);

(statearr_19777_19794[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19763 === (8))){
var inst_19739 = (state_19762[(7)]);
var tmp19774 = inst_19739;
var inst_19739__$1 = tmp19774;
var state_19762__$1 = (function (){var statearr_19778 = state_19762;
(statearr_19778[(7)] = inst_19739__$1);

return statearr_19778;
})();
var statearr_19779_19795 = state_19762__$1;
(statearr_19779_19795[(2)] = null);

(statearr_19779_19795[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__18045__auto___19785,out))
;
return ((function (switch__17943__auto__,c__18045__auto___19785,out){
return (function() {
var cljs$core$async$state_machine__17944__auto__ = null;
var cljs$core$async$state_machine__17944__auto____0 = (function (){
var statearr_19780 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19780[(0)] = cljs$core$async$state_machine__17944__auto__);

(statearr_19780[(1)] = (1));

return statearr_19780;
});
var cljs$core$async$state_machine__17944__auto____1 = (function (state_19762){
while(true){
var ret_value__17945__auto__ = (function (){try{while(true){
var result__17946__auto__ = switch__17943__auto__(state_19762);
if(cljs.core.keyword_identical_QMARK_(result__17946__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17946__auto__;
}
break;
}
}catch (e19781){if((e19781 instanceof Object)){
var ex__17947__auto__ = e19781;
var statearr_19782_19796 = state_19762;
(statearr_19782_19796[(5)] = ex__17947__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19762);

return cljs.core.cst$kw$recur;
} else {
throw e19781;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17945__auto__,cljs.core.cst$kw$recur)){
var G__19797 = state_19762;
state_19762 = G__19797;
continue;
} else {
return ret_value__17945__auto__;
}
break;
}
});
cljs$core$async$state_machine__17944__auto__ = function(state_19762){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17944__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17944__auto____1.call(this,state_19762);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17944__auto____0;
cljs$core$async$state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17944__auto____1;
return cljs$core$async$state_machine__17944__auto__;
})()
;})(switch__17943__auto__,c__18045__auto___19785,out))
})();
var state__18047__auto__ = (function (){var statearr_19783 = (f__18046__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18046__auto__.cljs$core$IFn$_invoke$arity$0() : f__18046__auto__.call(null));
(statearr_19783[(6)] = c__18045__auto___19785);

return statearr_19783;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18047__auto__);
});})(c__18045__auto___19785,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__19799 = arguments.length;
switch (G__19799) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__18045__auto___19865 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18045__auto___19865,out){
return (function (){
var f__18046__auto__ = (function (){var switch__17943__auto__ = ((function (c__18045__auto___19865,out){
return (function (state_19837){
var state_val_19838 = (state_19837[(1)]);
if((state_val_19838 === (7))){
var inst_19833 = (state_19837[(2)]);
var state_19837__$1 = state_19837;
var statearr_19839_19866 = state_19837__$1;
(statearr_19839_19866[(2)] = inst_19833);

(statearr_19839_19866[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19838 === (1))){
var inst_19800 = (new Array(n));
var inst_19801 = inst_19800;
var inst_19802 = (0);
var state_19837__$1 = (function (){var statearr_19840 = state_19837;
(statearr_19840[(7)] = inst_19802);

(statearr_19840[(8)] = inst_19801);

return statearr_19840;
})();
var statearr_19841_19867 = state_19837__$1;
(statearr_19841_19867[(2)] = null);

(statearr_19841_19867[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19838 === (4))){
var inst_19805 = (state_19837[(9)]);
var inst_19805__$1 = (state_19837[(2)]);
var inst_19806 = (inst_19805__$1 == null);
var inst_19807 = cljs.core.not(inst_19806);
var state_19837__$1 = (function (){var statearr_19842 = state_19837;
(statearr_19842[(9)] = inst_19805__$1);

return statearr_19842;
})();
if(inst_19807){
var statearr_19843_19868 = state_19837__$1;
(statearr_19843_19868[(1)] = (5));

} else {
var statearr_19844_19869 = state_19837__$1;
(statearr_19844_19869[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19838 === (15))){
var inst_19827 = (state_19837[(2)]);
var state_19837__$1 = state_19837;
var statearr_19845_19870 = state_19837__$1;
(statearr_19845_19870[(2)] = inst_19827);

(statearr_19845_19870[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19838 === (13))){
var state_19837__$1 = state_19837;
var statearr_19846_19871 = state_19837__$1;
(statearr_19846_19871[(2)] = null);

(statearr_19846_19871[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19838 === (6))){
var inst_19802 = (state_19837[(7)]);
var inst_19823 = (inst_19802 > (0));
var state_19837__$1 = state_19837;
if(cljs.core.truth_(inst_19823)){
var statearr_19847_19872 = state_19837__$1;
(statearr_19847_19872[(1)] = (12));

} else {
var statearr_19848_19873 = state_19837__$1;
(statearr_19848_19873[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19838 === (3))){
var inst_19835 = (state_19837[(2)]);
var state_19837__$1 = state_19837;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19837__$1,inst_19835);
} else {
if((state_val_19838 === (12))){
var inst_19801 = (state_19837[(8)]);
var inst_19825 = cljs.core.vec(inst_19801);
var state_19837__$1 = state_19837;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19837__$1,(15),out,inst_19825);
} else {
if((state_val_19838 === (2))){
var state_19837__$1 = state_19837;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19837__$1,(4),ch);
} else {
if((state_val_19838 === (11))){
var inst_19817 = (state_19837[(2)]);
var inst_19818 = (new Array(n));
var inst_19801 = inst_19818;
var inst_19802 = (0);
var state_19837__$1 = (function (){var statearr_19849 = state_19837;
(statearr_19849[(7)] = inst_19802);

(statearr_19849[(8)] = inst_19801);

(statearr_19849[(10)] = inst_19817);

return statearr_19849;
})();
var statearr_19850_19874 = state_19837__$1;
(statearr_19850_19874[(2)] = null);

(statearr_19850_19874[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19838 === (9))){
var inst_19801 = (state_19837[(8)]);
var inst_19815 = cljs.core.vec(inst_19801);
var state_19837__$1 = state_19837;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19837__$1,(11),out,inst_19815);
} else {
if((state_val_19838 === (5))){
var inst_19802 = (state_19837[(7)]);
var inst_19805 = (state_19837[(9)]);
var inst_19810 = (state_19837[(11)]);
var inst_19801 = (state_19837[(8)]);
var inst_19809 = (inst_19801[inst_19802] = inst_19805);
var inst_19810__$1 = (inst_19802 + (1));
var inst_19811 = (inst_19810__$1 < n);
var state_19837__$1 = (function (){var statearr_19851 = state_19837;
(statearr_19851[(11)] = inst_19810__$1);

(statearr_19851[(12)] = inst_19809);

return statearr_19851;
})();
if(cljs.core.truth_(inst_19811)){
var statearr_19852_19875 = state_19837__$1;
(statearr_19852_19875[(1)] = (8));

} else {
var statearr_19853_19876 = state_19837__$1;
(statearr_19853_19876[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19838 === (14))){
var inst_19830 = (state_19837[(2)]);
var inst_19831 = cljs.core.async.close_BANG_(out);
var state_19837__$1 = (function (){var statearr_19855 = state_19837;
(statearr_19855[(13)] = inst_19830);

return statearr_19855;
})();
var statearr_19856_19877 = state_19837__$1;
(statearr_19856_19877[(2)] = inst_19831);

(statearr_19856_19877[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19838 === (10))){
var inst_19821 = (state_19837[(2)]);
var state_19837__$1 = state_19837;
var statearr_19857_19878 = state_19837__$1;
(statearr_19857_19878[(2)] = inst_19821);

(statearr_19857_19878[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19838 === (8))){
var inst_19810 = (state_19837[(11)]);
var inst_19801 = (state_19837[(8)]);
var tmp19854 = inst_19801;
var inst_19801__$1 = tmp19854;
var inst_19802 = inst_19810;
var state_19837__$1 = (function (){var statearr_19858 = state_19837;
(statearr_19858[(7)] = inst_19802);

(statearr_19858[(8)] = inst_19801__$1);

return statearr_19858;
})();
var statearr_19859_19879 = state_19837__$1;
(statearr_19859_19879[(2)] = null);

(statearr_19859_19879[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18045__auto___19865,out))
;
return ((function (switch__17943__auto__,c__18045__auto___19865,out){
return (function() {
var cljs$core$async$state_machine__17944__auto__ = null;
var cljs$core$async$state_machine__17944__auto____0 = (function (){
var statearr_19860 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19860[(0)] = cljs$core$async$state_machine__17944__auto__);

(statearr_19860[(1)] = (1));

return statearr_19860;
});
var cljs$core$async$state_machine__17944__auto____1 = (function (state_19837){
while(true){
var ret_value__17945__auto__ = (function (){try{while(true){
var result__17946__auto__ = switch__17943__auto__(state_19837);
if(cljs.core.keyword_identical_QMARK_(result__17946__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17946__auto__;
}
break;
}
}catch (e19861){if((e19861 instanceof Object)){
var ex__17947__auto__ = e19861;
var statearr_19862_19880 = state_19837;
(statearr_19862_19880[(5)] = ex__17947__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19837);

return cljs.core.cst$kw$recur;
} else {
throw e19861;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17945__auto__,cljs.core.cst$kw$recur)){
var G__19881 = state_19837;
state_19837 = G__19881;
continue;
} else {
return ret_value__17945__auto__;
}
break;
}
});
cljs$core$async$state_machine__17944__auto__ = function(state_19837){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17944__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17944__auto____1.call(this,state_19837);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17944__auto____0;
cljs$core$async$state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17944__auto____1;
return cljs$core$async$state_machine__17944__auto__;
})()
;})(switch__17943__auto__,c__18045__auto___19865,out))
})();
var state__18047__auto__ = (function (){var statearr_19863 = (f__18046__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18046__auto__.cljs$core$IFn$_invoke$arity$0() : f__18046__auto__.call(null));
(statearr_19863[(6)] = c__18045__auto___19865);

return statearr_19863;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18047__auto__);
});})(c__18045__auto___19865,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__19883 = arguments.length;
switch (G__19883) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__18045__auto___19953 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18045__auto___19953,out){
return (function (){
var f__18046__auto__ = (function (){var switch__17943__auto__ = ((function (c__18045__auto___19953,out){
return (function (state_19925){
var state_val_19926 = (state_19925[(1)]);
if((state_val_19926 === (7))){
var inst_19921 = (state_19925[(2)]);
var state_19925__$1 = state_19925;
var statearr_19927_19954 = state_19925__$1;
(statearr_19927_19954[(2)] = inst_19921);

(statearr_19927_19954[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19926 === (1))){
var inst_19884 = [];
var inst_19885 = inst_19884;
var inst_19886 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_19925__$1 = (function (){var statearr_19928 = state_19925;
(statearr_19928[(7)] = inst_19886);

(statearr_19928[(8)] = inst_19885);

return statearr_19928;
})();
var statearr_19929_19955 = state_19925__$1;
(statearr_19929_19955[(2)] = null);

(statearr_19929_19955[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19926 === (4))){
var inst_19889 = (state_19925[(9)]);
var inst_19889__$1 = (state_19925[(2)]);
var inst_19890 = (inst_19889__$1 == null);
var inst_19891 = cljs.core.not(inst_19890);
var state_19925__$1 = (function (){var statearr_19930 = state_19925;
(statearr_19930[(9)] = inst_19889__$1);

return statearr_19930;
})();
if(inst_19891){
var statearr_19931_19956 = state_19925__$1;
(statearr_19931_19956[(1)] = (5));

} else {
var statearr_19932_19957 = state_19925__$1;
(statearr_19932_19957[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19926 === (15))){
var inst_19915 = (state_19925[(2)]);
var state_19925__$1 = state_19925;
var statearr_19933_19958 = state_19925__$1;
(statearr_19933_19958[(2)] = inst_19915);

(statearr_19933_19958[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19926 === (13))){
var state_19925__$1 = state_19925;
var statearr_19934_19959 = state_19925__$1;
(statearr_19934_19959[(2)] = null);

(statearr_19934_19959[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19926 === (6))){
var inst_19885 = (state_19925[(8)]);
var inst_19910 = inst_19885.length;
var inst_19911 = (inst_19910 > (0));
var state_19925__$1 = state_19925;
if(cljs.core.truth_(inst_19911)){
var statearr_19935_19960 = state_19925__$1;
(statearr_19935_19960[(1)] = (12));

} else {
var statearr_19936_19961 = state_19925__$1;
(statearr_19936_19961[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19926 === (3))){
var inst_19923 = (state_19925[(2)]);
var state_19925__$1 = state_19925;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19925__$1,inst_19923);
} else {
if((state_val_19926 === (12))){
var inst_19885 = (state_19925[(8)]);
var inst_19913 = cljs.core.vec(inst_19885);
var state_19925__$1 = state_19925;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19925__$1,(15),out,inst_19913);
} else {
if((state_val_19926 === (2))){
var state_19925__$1 = state_19925;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19925__$1,(4),ch);
} else {
if((state_val_19926 === (11))){
var inst_19889 = (state_19925[(9)]);
var inst_19893 = (state_19925[(10)]);
var inst_19903 = (state_19925[(2)]);
var inst_19904 = [];
var inst_19905 = inst_19904.push(inst_19889);
var inst_19885 = inst_19904;
var inst_19886 = inst_19893;
var state_19925__$1 = (function (){var statearr_19937 = state_19925;
(statearr_19937[(11)] = inst_19903);

(statearr_19937[(7)] = inst_19886);

(statearr_19937[(8)] = inst_19885);

(statearr_19937[(12)] = inst_19905);

return statearr_19937;
})();
var statearr_19938_19962 = state_19925__$1;
(statearr_19938_19962[(2)] = null);

(statearr_19938_19962[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19926 === (9))){
var inst_19885 = (state_19925[(8)]);
var inst_19901 = cljs.core.vec(inst_19885);
var state_19925__$1 = state_19925;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19925__$1,(11),out,inst_19901);
} else {
if((state_val_19926 === (5))){
var inst_19889 = (state_19925[(9)]);
var inst_19886 = (state_19925[(7)]);
var inst_19893 = (state_19925[(10)]);
var inst_19893__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_19889) : f.call(null,inst_19889));
var inst_19894 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_19893__$1,inst_19886);
var inst_19895 = cljs.core.keyword_identical_QMARK_(inst_19886,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_19896 = (inst_19894) || (inst_19895);
var state_19925__$1 = (function (){var statearr_19939 = state_19925;
(statearr_19939[(10)] = inst_19893__$1);

return statearr_19939;
})();
if(cljs.core.truth_(inst_19896)){
var statearr_19940_19963 = state_19925__$1;
(statearr_19940_19963[(1)] = (8));

} else {
var statearr_19941_19964 = state_19925__$1;
(statearr_19941_19964[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19926 === (14))){
var inst_19918 = (state_19925[(2)]);
var inst_19919 = cljs.core.async.close_BANG_(out);
var state_19925__$1 = (function (){var statearr_19943 = state_19925;
(statearr_19943[(13)] = inst_19918);

return statearr_19943;
})();
var statearr_19944_19965 = state_19925__$1;
(statearr_19944_19965[(2)] = inst_19919);

(statearr_19944_19965[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19926 === (10))){
var inst_19908 = (state_19925[(2)]);
var state_19925__$1 = state_19925;
var statearr_19945_19966 = state_19925__$1;
(statearr_19945_19966[(2)] = inst_19908);

(statearr_19945_19966[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19926 === (8))){
var inst_19889 = (state_19925[(9)]);
var inst_19885 = (state_19925[(8)]);
var inst_19893 = (state_19925[(10)]);
var inst_19898 = inst_19885.push(inst_19889);
var tmp19942 = inst_19885;
var inst_19885__$1 = tmp19942;
var inst_19886 = inst_19893;
var state_19925__$1 = (function (){var statearr_19946 = state_19925;
(statearr_19946[(14)] = inst_19898);

(statearr_19946[(7)] = inst_19886);

(statearr_19946[(8)] = inst_19885__$1);

return statearr_19946;
})();
var statearr_19947_19967 = state_19925__$1;
(statearr_19947_19967[(2)] = null);

(statearr_19947_19967[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18045__auto___19953,out))
;
return ((function (switch__17943__auto__,c__18045__auto___19953,out){
return (function() {
var cljs$core$async$state_machine__17944__auto__ = null;
var cljs$core$async$state_machine__17944__auto____0 = (function (){
var statearr_19948 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19948[(0)] = cljs$core$async$state_machine__17944__auto__);

(statearr_19948[(1)] = (1));

return statearr_19948;
});
var cljs$core$async$state_machine__17944__auto____1 = (function (state_19925){
while(true){
var ret_value__17945__auto__ = (function (){try{while(true){
var result__17946__auto__ = switch__17943__auto__(state_19925);
if(cljs.core.keyword_identical_QMARK_(result__17946__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17946__auto__;
}
break;
}
}catch (e19949){if((e19949 instanceof Object)){
var ex__17947__auto__ = e19949;
var statearr_19950_19968 = state_19925;
(statearr_19950_19968[(5)] = ex__17947__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19925);

return cljs.core.cst$kw$recur;
} else {
throw e19949;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17945__auto__,cljs.core.cst$kw$recur)){
var G__19969 = state_19925;
state_19925 = G__19969;
continue;
} else {
return ret_value__17945__auto__;
}
break;
}
});
cljs$core$async$state_machine__17944__auto__ = function(state_19925){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17944__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17944__auto____1.call(this,state_19925);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17944__auto____0;
cljs$core$async$state_machine__17944__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17944__auto____1;
return cljs$core$async$state_machine__17944__auto__;
})()
;})(switch__17943__auto__,c__18045__auto___19953,out))
})();
var state__18047__auto__ = (function (){var statearr_19951 = (f__18046__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18046__auto__.cljs$core$IFn$_invoke$arity$0() : f__18046__auto__.call(null));
(statearr_19951[(6)] = c__18045__auto___19953);

return statearr_19951;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18047__auto__);
});})(c__18045__auto___19953,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

