// Compiled by ClojureScript 1.9.946 {:static-fns true, :optimize-constants true}
goog.provide('re_frame.trace');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('re_frame.interop');
goog.require('re_frame.loggers');
goog.require('goog.functions');
re_frame.trace.id = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
re_frame.trace._STAR_current_trace_STAR_ = null;
re_frame.trace.reset_tracing_BANG_ = (function re_frame$trace$reset_tracing_BANG_(){
return cljs.core.reset_BANG_(re_frame.trace.id,(0));
});

/** @define {boolean} */
goog.define("re_frame.trace.trace_enabled_QMARK_",false);
/**
 * See https://groups.google.com/d/msg/clojurescript/jk43kmYiMhA/IHglVr_TPdgJ for more details
 */
re_frame.trace.is_trace_enabled_QMARK_ = (function re_frame$trace$is_trace_enabled_QMARK_(){
return re_frame.trace.trace_enabled_QMARK_;
});
re_frame.trace.trace_cbs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
if(typeof re_frame.trace.traces !== 'undefined'){
} else {
re_frame.trace.traces = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
}
if(typeof re_frame.trace.next_delivery !== 'undefined'){
} else {
re_frame.trace.next_delivery = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
}
/**
 * Registers a tracing callback function which will receive a collection of one or more traces.
 *   Will replace an existing callback function if it shares the same key.
 */
re_frame.trace.register_trace_cb = (function re_frame$trace$register_trace_cb(key,f){
if(cljs.core.truth_(re_frame.trace.trace_enabled_QMARK_)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(re_frame.trace.trace_cbs,cljs.core.assoc,key,f);
} else {
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$warn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Tracing is not enabled. Please set {\"re_frame.trace.trace_enabled_QMARK_\" true} in :closure-defines. See: https://github.com/Day8/re-frame-trace#installation."], 0));
}
});
re_frame.trace.remove_trace_cb = (function re_frame$trace$remove_trace_cb(key){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.trace_cbs,cljs.core.dissoc,key);

return null;
});
re_frame.trace.next_id = (function re_frame$trace$next_id(){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(re_frame.trace.id,cljs.core.inc);
});
re_frame.trace.start_trace = (function re_frame$trace$start_trace(p__26140){
var map__26141 = p__26140;
var map__26141__$1 = ((((!((map__26141 == null)))?((((map__26141.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26141.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26141):map__26141);
var operation = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26141__$1,cljs.core.cst$kw$operation);
var op_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26141__$1,cljs.core.cst$kw$op_DASH_type);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26141__$1,cljs.core.cst$kw$tags);
var child_of = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26141__$1,cljs.core.cst$kw$child_DASH_of);
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$id,re_frame.trace.next_id(),cljs.core.cst$kw$operation,operation,cljs.core.cst$kw$op_DASH_type,op_type,cljs.core.cst$kw$tags,tags,cljs.core.cst$kw$child_DASH_of,(function (){var or__8808__auto__ = child_of;
if(cljs.core.truth_(or__8808__auto__)){
return or__8808__auto__;
} else {
return cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_);
}
})(),cljs.core.cst$kw$start,re_frame.interop.now()], null);
});
re_frame.trace.debounce_time = (50);
re_frame.trace.debounce = (function re_frame$trace$debounce(f,interval){
return goog.functions.debounce(f,interval);
});
re_frame.trace.schedule_debounce = re_frame.trace.debounce((function re_frame$trace$tracing_cb_debounced(){
var seq__26143_26157 = cljs.core.seq(cljs.core.deref(re_frame.trace.trace_cbs));
var chunk__26144_26158 = null;
var count__26145_26159 = (0);
var i__26146_26160 = (0);
while(true){
if((i__26146_26160 < count__26145_26159)){
var vec__26147_26161 = chunk__26144_26158.cljs$core$IIndexed$_nth$arity$2(null,i__26146_26160);
var k_26162 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26147_26161,(0),null);
var cb_26163 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26147_26161,(1),null);
try{var G__26151_26164 = cljs.core.deref(re_frame.trace.traces);
(cb_26163.cljs$core$IFn$_invoke$arity$1 ? cb_26163.cljs$core$IFn$_invoke$arity$1(G__26151_26164) : cb_26163.call(null,G__26151_26164));
}catch (e26150){var e_26165 = e26150;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_26162,"while storing",cljs.core.deref(re_frame.trace.traces),e_26165], 0));
}
var G__26166 = seq__26143_26157;
var G__26167 = chunk__26144_26158;
var G__26168 = count__26145_26159;
var G__26169 = (i__26146_26160 + (1));
seq__26143_26157 = G__26166;
chunk__26144_26158 = G__26167;
count__26145_26159 = G__26168;
i__26146_26160 = G__26169;
continue;
} else {
var temp__5457__auto___26170 = cljs.core.seq(seq__26143_26157);
if(temp__5457__auto___26170){
var seq__26143_26171__$1 = temp__5457__auto___26170;
if(cljs.core.chunked_seq_QMARK_(seq__26143_26171__$1)){
var c__9739__auto___26172 = cljs.core.chunk_first(seq__26143_26171__$1);
var G__26173 = cljs.core.chunk_rest(seq__26143_26171__$1);
var G__26174 = c__9739__auto___26172;
var G__26175 = cljs.core.count(c__9739__auto___26172);
var G__26176 = (0);
seq__26143_26157 = G__26173;
chunk__26144_26158 = G__26174;
count__26145_26159 = G__26175;
i__26146_26160 = G__26176;
continue;
} else {
var vec__26152_26177 = cljs.core.first(seq__26143_26171__$1);
var k_26178 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26152_26177,(0),null);
var cb_26179 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26152_26177,(1),null);
try{var G__26156_26180 = cljs.core.deref(re_frame.trace.traces);
(cb_26179.cljs$core$IFn$_invoke$arity$1 ? cb_26179.cljs$core$IFn$_invoke$arity$1(G__26156_26180) : cb_26179.call(null,G__26156_26180));
}catch (e26155){var e_26181 = e26155;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_26178,"while storing",cljs.core.deref(re_frame.trace.traces),e_26181], 0));
}
var G__26182 = cljs.core.next(seq__26143_26171__$1);
var G__26183 = null;
var G__26184 = (0);
var G__26185 = (0);
seq__26143_26157 = G__26182;
chunk__26144_26158 = G__26183;
count__26145_26159 = G__26184;
i__26146_26160 = G__26185;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_(re_frame.trace.traces,cljs.core.PersistentVector.EMPTY);
}),re_frame.trace.debounce_time);
re_frame.trace.run_tracing_callbacks_BANG_ = (function re_frame$trace$run_tracing_callbacks_BANG_(now){
if(((cljs.core.deref(re_frame.trace.next_delivery) - (10)) < now)){
(re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0 ? re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0() : re_frame.trace.schedule_debounce.call(null));

return cljs.core.reset_BANG_(re_frame.trace.next_delivery,(now + re_frame.trace.debounce_time));
} else {
return null;
}
});
