// Compiled by ClojureScript 1.9.946 {:static-fns true, :optimize-constants true}
goog.provide('clojure.data');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.set');
/**
 * Internal helper for diff.
 */
clojure.data.atom_diff = (function clojure$data$atom_diff(a,b){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a,b)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,a], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,null], null);
}
});
/**
 * Convert an associative-by-numeric-index collection into
 * an equivalent vector, with nil for any missing keys
 */
clojure.data.vectorize = (function clojure$data$vectorize(m){
if(cljs.core.seq(m)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (result,p__26399){
var vec__26400 = p__26399;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26400,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26400,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,k,v);
}),cljs.core.vec(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.keys(m)),null)),m);
} else {
return null;
}
});
/**
 * Diff associative things a and b, comparing only the key k.
 */
clojure.data.diff_associative_key = (function clojure$data$diff_associative_key(a,b,k){
var va = cljs.core.get.cljs$core$IFn$_invoke$arity$2(a,k);
var vb = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b,k);
var vec__26403 = (clojure.data.diff.cljs$core$IFn$_invoke$arity$2 ? clojure.data.diff.cljs$core$IFn$_invoke$arity$2(va,vb) : clojure.data.diff.call(null,va,vb));
var a_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26403,(0),null);
var b_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26403,(1),null);
var ab = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26403,(2),null);
var in_a = cljs.core.contains_QMARK_(a,k);
var in_b = cljs.core.contains_QMARK_(b,k);
var same = (in_a) && (in_b) && ((!((ab == null))) || (((va == null)) && ((vb == null))));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(((in_a) && ((!((a_STAR_ == null))) || (!(same))))?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,a_STAR_]):null),(((in_b) && ((!((b_STAR_ == null))) || (!(same))))?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,b_STAR_]):null),((same)?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,ab]):null)], null);
});
/**
 * Diff associative things a and b, comparing only keys in ks (if supplied).
 */
clojure.data.diff_associative = (function clojure$data$diff_associative(var_args){
var G__26407 = arguments.length;
switch (G__26407) {
case 2:
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3(a,b,clojure.set.union.cljs$core$IFn$_invoke$arity$2(cljs.core.keys(a),cljs.core.keys(b)));
});

clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3 = (function (a,b,ks){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (diff1,diff2){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.merge,diff1,diff2));
}),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,null], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(clojure.data.diff_associative_key,a,b),ks));
});

clojure.data.diff_associative.cljs$lang$maxFixedArity = 3;

clojure.data.diff_sequential = (function clojure$data$diff_sequential(a,b){
return cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.data.vectorize,clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3(((cljs.core.vector_QMARK_(a))?a:cljs.core.vec(a)),((cljs.core.vector_QMARK_(b))?b:cljs.core.vec(b)),cljs.core.range.cljs$core$IFn$_invoke$arity$1((function (){var x__9160__auto__ = cljs.core.count(a);
var y__9161__auto__ = cljs.core.count(b);
return ((x__9160__auto__ > y__9161__auto__) ? x__9160__auto__ : y__9161__auto__);
})()))));
});
clojure.data.diff_set = (function clojure$data$diff_set(a,b){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.not_empty(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(a,b)),cljs.core.not_empty(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(b,a)),cljs.core.not_empty(clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(a,b))], null);
});

/**
 * Implementation detail. Subject to change.
 * @interface
 */
clojure.data.EqualityPartition = function(){};

/**
 * Implementation detail. Subject to change.
 */
clojure.data.equality_partition = (function clojure$data$equality_partition(x){
if((!((x == null))) && (!((x.clojure$data$EqualityPartition$equality_partition$arity$1 == null)))){
return x.clojure$data$EqualityPartition$equality_partition$arity$1(x);
} else {
var x__9541__auto__ = (((x == null))?null:x);
var m__9542__auto__ = (clojure.data.equality_partition[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__9542__auto__.call(null,x));
} else {
var m__9542__auto____$1 = (clojure.data.equality_partition["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__9542__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("EqualityPartition.equality-partition",x);
}
}
}
});


/**
 * Implementation detail. Subject to change.
 * @interface
 */
clojure.data.Diff = function(){};

/**
 * Implementation detail. Subject to change.
 */
clojure.data.diff_similar = (function clojure$data$diff_similar(a,b){
if((!((a == null))) && (!((a.clojure$data$Diff$diff_similar$arity$2 == null)))){
return a.clojure$data$Diff$diff_similar$arity$2(a,b);
} else {
var x__9541__auto__ = (((a == null))?null:a);
var m__9542__auto__ = (clojure.data.diff_similar[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$2(a,b) : m__9542__auto__.call(null,a,b));
} else {
var m__9542__auto____$1 = (clojure.data.diff_similar["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2(a,b) : m__9542__auto____$1.call(null,a,b));
} else {
throw cljs.core.missing_protocol("Diff.diff-similar",a);
}
}
}
});

goog.object.set(clojure.data.EqualityPartition,"null",true);

var G__26409_26433 = clojure.data.equality_partition;
var G__26410_26434 = "null";
var G__26411_26435 = ((function (G__26409_26433,G__26410_26434){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__26409_26433,G__26410_26434))
;
goog.object.set(G__26409_26433,G__26410_26434,G__26411_26435);

goog.object.set(clojure.data.EqualityPartition,"string",true);

var G__26412_26436 = clojure.data.equality_partition;
var G__26413_26437 = "string";
var G__26414_26438 = ((function (G__26412_26436,G__26413_26437){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__26412_26436,G__26413_26437))
;
goog.object.set(G__26412_26436,G__26413_26437,G__26414_26438);

goog.object.set(clojure.data.EqualityPartition,"number",true);

var G__26415_26439 = clojure.data.equality_partition;
var G__26416_26440 = "number";
var G__26417_26441 = ((function (G__26415_26439,G__26416_26440){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__26415_26439,G__26416_26440))
;
goog.object.set(G__26415_26439,G__26416_26440,G__26417_26441);

goog.object.set(clojure.data.EqualityPartition,"array",true);

var G__26418_26442 = clojure.data.equality_partition;
var G__26419_26443 = "array";
var G__26420_26444 = ((function (G__26418_26442,G__26419_26443){
return (function (x){
return cljs.core.cst$kw$sequential;
});})(G__26418_26442,G__26419_26443))
;
goog.object.set(G__26418_26442,G__26419_26443,G__26420_26444);

goog.object.set(clojure.data.EqualityPartition,"function",true);

var G__26421_26445 = clojure.data.equality_partition;
var G__26422_26446 = "function";
var G__26423_26447 = ((function (G__26421_26445,G__26422_26446){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__26421_26445,G__26422_26446))
;
goog.object.set(G__26421_26445,G__26422_26446,G__26423_26447);

goog.object.set(clojure.data.EqualityPartition,"boolean",true);

var G__26424_26448 = clojure.data.equality_partition;
var G__26425_26449 = "boolean";
var G__26426_26450 = ((function (G__26424_26448,G__26425_26449){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__26424_26448,G__26425_26449))
;
goog.object.set(G__26424_26448,G__26425_26449,G__26426_26450);

goog.object.set(clojure.data.EqualityPartition,"_",true);

var G__26427_26451 = clojure.data.equality_partition;
var G__26428_26452 = "_";
var G__26429_26453 = ((function (G__26427_26451,G__26428_26452){
return (function (x){
if(((!((x == null)))?((((x.cljs$lang$protocol_mask$partition0$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMap$)))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x))){
return cljs.core.cst$kw$map;
} else {
if(((!((x == null)))?((((x.cljs$lang$protocol_mask$partition0$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISet$)))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x))){
return cljs.core.cst$kw$set;
} else {
if(((!((x == null)))?((((x.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISequential$)))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x))){
return cljs.core.cst$kw$sequential;
} else {
return cljs.core.cst$kw$atom;

}
}
}
});})(G__26427_26451,G__26428_26452))
;
goog.object.set(G__26427_26451,G__26428_26452,G__26429_26453);
goog.object.set(clojure.data.Diff,"null",true);

var G__26454_26478 = clojure.data.diff_similar;
var G__26455_26479 = "null";
var G__26456_26480 = ((function (G__26454_26478,G__26455_26479){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__26454_26478,G__26455_26479))
;
goog.object.set(G__26454_26478,G__26455_26479,G__26456_26480);

goog.object.set(clojure.data.Diff,"string",true);

var G__26457_26481 = clojure.data.diff_similar;
var G__26458_26482 = "string";
var G__26459_26483 = ((function (G__26457_26481,G__26458_26482){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__26457_26481,G__26458_26482))
;
goog.object.set(G__26457_26481,G__26458_26482,G__26459_26483);

goog.object.set(clojure.data.Diff,"number",true);

var G__26460_26484 = clojure.data.diff_similar;
var G__26461_26485 = "number";
var G__26462_26486 = ((function (G__26460_26484,G__26461_26485){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__26460_26484,G__26461_26485))
;
goog.object.set(G__26460_26484,G__26461_26485,G__26462_26486);

goog.object.set(clojure.data.Diff,"array",true);

var G__26463_26487 = clojure.data.diff_similar;
var G__26464_26488 = "array";
var G__26465_26489 = ((function (G__26463_26487,G__26464_26488){
return (function (a,b){
return clojure.data.diff_sequential(a,b);
});})(G__26463_26487,G__26464_26488))
;
goog.object.set(G__26463_26487,G__26464_26488,G__26465_26489);

goog.object.set(clojure.data.Diff,"function",true);

var G__26466_26490 = clojure.data.diff_similar;
var G__26467_26491 = "function";
var G__26468_26492 = ((function (G__26466_26490,G__26467_26491){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__26466_26490,G__26467_26491))
;
goog.object.set(G__26466_26490,G__26467_26491,G__26468_26492);

goog.object.set(clojure.data.Diff,"boolean",true);

var G__26469_26493 = clojure.data.diff_similar;
var G__26470_26494 = "boolean";
var G__26471_26495 = ((function (G__26469_26493,G__26470_26494){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__26469_26493,G__26470_26494))
;
goog.object.set(G__26469_26493,G__26470_26494,G__26471_26495);

goog.object.set(clojure.data.Diff,"_",true);

var G__26472_26496 = clojure.data.diff_similar;
var G__26473_26497 = "_";
var G__26474_26498 = ((function (G__26472_26496,G__26473_26497){
return (function (a,b){
var fexpr__26476 = (function (){var G__26477 = clojure.data.equality_partition(a);
var G__26477__$1 = (((G__26477 instanceof cljs.core.Keyword))?G__26477.fqn:null);
switch (G__26477__$1) {
case "atom":
return clojure.data.atom_diff;

break;
case "set":
return clojure.data.diff_set;

break;
case "sequential":
return clojure.data.diff_sequential;

break;
case "map":
return clojure.data.diff_associative;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__26477__$1)].join('')));

}
})();
return (fexpr__26476.cljs$core$IFn$_invoke$arity$2 ? fexpr__26476.cljs$core$IFn$_invoke$arity$2(a,b) : fexpr__26476.call(null,a,b));
});})(G__26472_26496,G__26473_26497))
;
goog.object.set(G__26472_26496,G__26473_26497,G__26474_26498);
/**
 * Recursively compares a and b, returning a tuple of
 *   [things-only-in-a things-only-in-b things-in-both].
 *   Comparison rules:
 * 
 *   * For equal a and b, return [nil nil a].
 *   * Maps are subdiffed where keys match and values differ.
 *   * Sets are never subdiffed.
 *   * All sequential things are treated as associative collections
 *  by their indexes, with results returned as vectors.
 *   * Everything else (including strings!) is treated as
 *  an atom and compared for equality.
 */
clojure.data.diff = (function clojure$data$diff(a,b){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a,b)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,a], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(clojure.data.equality_partition(a),clojure.data.equality_partition(b))){
return clojure.data.diff_similar(a,b);
} else {
return clojure.data.atom_diff(a,b);
}
}
});
