// Compiled by ClojureScript 1.9.946 {:static-fns true, :optimize-constants true}
goog.provide('cljs_http.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.net.EventType');
goog.require('goog.net.ErrorCode');
goog.require('goog.net.XhrIo');
goog.require('goog.net.Jsonp');
goog.require('cljs_http.util');
goog.require('cljs.core.async');
goog.require('clojure.string');
cljs_http.core.pending_requests = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
/**
 * Attempt to close the given channel and abort the pending HTTP request
 *   with which it is associated.
 */
cljs_http.core.abort_BANG_ = (function cljs_http$core$abort_BANG_(channel){
var temp__5457__auto__ = (function (){var fexpr__19443 = cljs.core.deref(cljs_http.core.pending_requests);
return (fexpr__19443.cljs$core$IFn$_invoke$arity$1 ? fexpr__19443.cljs$core$IFn$_invoke$arity$1(channel) : fexpr__19443.call(null,channel));
})();
if(cljs.core.truth_(temp__5457__auto__)){
var req = temp__5457__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

cljs.core.async.close_BANG_(channel);

if(cljs.core.truth_(req.hasOwnProperty("abort"))){
return req.abort();
} else {
return cljs.core.cst$kw$jsonp.cljs$core$IFn$_invoke$arity$1(req).cancel(cljs.core.cst$kw$request.cljs$core$IFn$_invoke$arity$1(req));
}
} else {
return null;
}
});
cljs_http.core.aborted_QMARK_ = (function cljs_http$core$aborted_QMARK_(xhr){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(xhr.getLastErrorCode(),goog.net.ErrorCode.ABORT);
});
/**
 * Takes an XhrIo object and applies the default-headers to it.
 */
cljs_http.core.apply_default_headers_BANG_ = (function cljs_http$core$apply_default_headers_BANG_(xhr,headers){
var formatted_h = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.util.camelize,cljs.core.keys(headers)),cljs.core.vals(headers));
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (formatted_h){
return (function (p__19444){
var vec__19445 = p__19444;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19445,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19445,(1),null);
return xhr.headers.set(k,v);
});})(formatted_h))
,formatted_h));
});
/**
 * Takes an XhrIo object and sets response-type if not nil.
 */
cljs_http.core.apply_response_type_BANG_ = (function cljs_http$core$apply_response_type_BANG_(xhr,response_type){
return xhr.setResponseType((function (){var G__19448 = response_type;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$array_DASH_buffer,G__19448)){
return goog.net.XhrIo.ResponseType.ARRAY_BUFFER;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$blob,G__19448)){
return goog.net.XhrIo.ResponseType.BLOB;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$document,G__19448)){
return goog.net.XhrIo.ResponseType.DOCUMENT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$text,G__19448)){
return goog.net.XhrIo.ResponseType.TEXT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$default,G__19448)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,G__19448)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__19448)].join('')));

}
}
}
}
}
}
})());
});
/**
 * Builds an XhrIo object from the request parameters.
 */
cljs_http.core.build_xhr = (function cljs_http$core$build_xhr(p__19449){
var map__19450 = p__19449;
var map__19450__$1 = ((((!((map__19450 == null)))?((((map__19450.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19450.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19450):map__19450);
var request = map__19450__$1;
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19450__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var default_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19450__$1,cljs.core.cst$kw$default_DASH_headers);
var response_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19450__$1,cljs.core.cst$kw$response_DASH_type);
var timeout = (function (){var or__8808__auto__ = cljs.core.cst$kw$timeout.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__8808__auto__)){
return or__8808__auto__;
} else {
return (0);
}
})();
var send_credentials = (((with_credentials_QMARK_ == null))?true:with_credentials_QMARK_);
var G__19452 = (new goog.net.XhrIo());
cljs_http.core.apply_default_headers_BANG_(G__19452,default_headers);

cljs_http.core.apply_response_type_BANG_(G__19452,response_type);

G__19452.setTimeoutInterval(timeout);

G__19452.setWithCredentials(send_credentials);

return G__19452;
});
cljs_http.core.error_kw = cljs.core.PersistentHashMap.fromArrays([(0),(7),(1),(4),(6),(3),(2),(9),(5),(8)],[cljs.core.cst$kw$no_DASH_error,cljs.core.cst$kw$abort,cljs.core.cst$kw$access_DASH_denied,cljs.core.cst$kw$custom_DASH_error,cljs.core.cst$kw$http_DASH_error,cljs.core.cst$kw$ff_DASH_silent_DASH_error,cljs.core.cst$kw$file_DASH_not_DASH_found,cljs.core.cst$kw$offline,cljs.core.cst$kw$exception,cljs.core.cst$kw$timeout]);
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.xhr = (function cljs_http$core$xhr(p__19453){
var map__19454 = p__19453;
var map__19454__$1 = ((((!((map__19454 == null)))?((((map__19454.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19454.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19454):map__19454);
var request = map__19454__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19454__$1,cljs.core.cst$kw$request_DASH_method);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19454__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19454__$1,cljs.core.cst$kw$body);
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19454__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19454__$1,cljs.core.cst$kw$cancel);
var progress = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19454__$1,cljs.core.cst$kw$progress);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var request_url = cljs_http.util.build_url(request);
var method = cljs.core.name((function (){var or__8808__auto__ = request_method;
if(cljs.core.truth_(or__8808__auto__)){
return or__8808__auto__;
} else {
return cljs.core.cst$kw$get;
}
})());
var headers__$1 = cljs_http.util.build_headers(headers);
var xhr = cljs_http.core.build_xhr(request);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,xhr);

xhr.listen(goog.net.EventType.COMPLETE,((function (channel,request_url,method,headers__$1,xhr,map__19454,map__19454__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (evt){
var target = evt.target;
var response = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$status,target.getStatus(),cljs.core.cst$kw$success,target.isSuccess(),cljs.core.cst$kw$body,target.getResponse(),cljs.core.cst$kw$headers,cljs_http.util.parse_headers(target.getAllResponseHeaders()),cljs.core.cst$kw$trace_DASH_redirects,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_url,target.getLastUri()], null),cljs.core.cst$kw$error_DASH_code,(function (){var G__19456 = target.getLastErrorCode();
return (cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1 ? cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1(G__19456) : cljs_http.core.error_kw.call(null,G__19456));
})(),cljs.core.cst$kw$error_DASH_text,target.getLastError()], null);
if(cljs.core.not(cljs_http.core.aborted_QMARK_(xhr))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,request_url,method,headers__$1,xhr,map__19454,map__19454__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
);

if(cljs.core.truth_(progress)){
var listener_19479 = ((function (channel,request_url,method,headers__$1,xhr,map__19454,map__19454__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (direction,evt){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(progress,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$direction,direction,cljs.core.cst$kw$loaded,evt.loaded], null),(cljs.core.truth_(evt.lengthComputable)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$total,evt.total], null):null)], 0)));
});})(channel,request_url,method,headers__$1,xhr,map__19454,map__19454__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
;
var G__19457_19480 = xhr;
G__19457_19480.setProgressEventsEnabled(true);

G__19457_19480.listen(goog.net.EventType.UPLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_19479,cljs.core.cst$kw$upload));

G__19457_19480.listen(goog.net.EventType.DOWNLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_19479,cljs.core.cst$kw$download));

} else {
}

xhr.send(request_url,method,body,headers__$1);

if(cljs.core.truth_(cancel)){
var c__17516__auto___19481 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17516__auto___19481,channel,request_url,method,headers__$1,xhr,map__19454,map__19454__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (){
var f__17517__auto__ = (function (){var switch__17414__auto__ = ((function (c__17516__auto___19481,channel,request_url,method,headers__$1,xhr,map__19454,map__19454__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (state_19468){
var state_val_19469 = (state_19468[(1)]);
if((state_val_19469 === (1))){
var state_19468__$1 = state_19468;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19468__$1,(2),cancel);
} else {
if((state_val_19469 === (2))){
var inst_19459 = (state_19468[(2)]);
var inst_19460 = xhr.isComplete();
var inst_19461 = cljs.core.not(inst_19460);
var state_19468__$1 = (function (){var statearr_19470 = state_19468;
(statearr_19470[(7)] = inst_19459);

return statearr_19470;
})();
if(inst_19461){
var statearr_19471_19482 = state_19468__$1;
(statearr_19471_19482[(1)] = (3));

} else {
var statearr_19472_19483 = state_19468__$1;
(statearr_19472_19483[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19469 === (3))){
var inst_19463 = xhr.abort();
var state_19468__$1 = state_19468;
var statearr_19473_19484 = state_19468__$1;
(statearr_19473_19484[(2)] = inst_19463);

(statearr_19473_19484[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19469 === (4))){
var state_19468__$1 = state_19468;
var statearr_19474_19485 = state_19468__$1;
(statearr_19474_19485[(2)] = null);

(statearr_19474_19485[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19469 === (5))){
var inst_19466 = (state_19468[(2)]);
var state_19468__$1 = state_19468;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19468__$1,inst_19466);
} else {
return null;
}
}
}
}
}
});})(c__17516__auto___19481,channel,request_url,method,headers__$1,xhr,map__19454,map__19454__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
;
return ((function (switch__17414__auto__,c__17516__auto___19481,channel,request_url,method,headers__$1,xhr,map__19454,map__19454__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function() {
var cljs_http$core$xhr_$_state_machine__17415__auto__ = null;
var cljs_http$core$xhr_$_state_machine__17415__auto____0 = (function (){
var statearr_19475 = [null,null,null,null,null,null,null,null];
(statearr_19475[(0)] = cljs_http$core$xhr_$_state_machine__17415__auto__);

(statearr_19475[(1)] = (1));

return statearr_19475;
});
var cljs_http$core$xhr_$_state_machine__17415__auto____1 = (function (state_19468){
while(true){
var ret_value__17416__auto__ = (function (){try{while(true){
var result__17417__auto__ = switch__17414__auto__(state_19468);
if(cljs.core.keyword_identical_QMARK_(result__17417__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17417__auto__;
}
break;
}
}catch (e19476){if((e19476 instanceof Object)){
var ex__17418__auto__ = e19476;
var statearr_19477_19486 = state_19468;
(statearr_19477_19486[(5)] = ex__17418__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19468);

return cljs.core.cst$kw$recur;
} else {
throw e19476;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17416__auto__,cljs.core.cst$kw$recur)){
var G__19487 = state_19468;
state_19468 = G__19487;
continue;
} else {
return ret_value__17416__auto__;
}
break;
}
});
cljs_http$core$xhr_$_state_machine__17415__auto__ = function(state_19468){
switch(arguments.length){
case 0:
return cljs_http$core$xhr_$_state_machine__17415__auto____0.call(this);
case 1:
return cljs_http$core$xhr_$_state_machine__17415__auto____1.call(this,state_19468);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs_http$core$xhr_$_state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$xhr_$_state_machine__17415__auto____0;
cljs_http$core$xhr_$_state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$xhr_$_state_machine__17415__auto____1;
return cljs_http$core$xhr_$_state_machine__17415__auto__;
})()
;})(switch__17414__auto__,c__17516__auto___19481,channel,request_url,method,headers__$1,xhr,map__19454,map__19454__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
})();
var state__17518__auto__ = (function (){var statearr_19478 = (f__17517__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17517__auto__.cljs$core$IFn$_invoke$arity$0() : f__17517__auto__.call(null));
(statearr_19478[(6)] = c__17516__auto___19481);

return statearr_19478;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17518__auto__);
});})(c__17516__auto___19481,channel,request_url,method,headers__$1,xhr,map__19454,map__19454__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
);

} else {
}

return channel;
});
/**
 * Execute the JSONP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.jsonp = (function cljs_http$core$jsonp(p__19488){
var map__19489 = p__19488;
var map__19489__$1 = ((((!((map__19489 == null)))?((((map__19489.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19489.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19489):map__19489);
var request = map__19489__$1;
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19489__$1,cljs.core.cst$kw$timeout);
var callback_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19489__$1,cljs.core.cst$kw$callback_DASH_name);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19489__$1,cljs.core.cst$kw$cancel);
var keywordize_keys_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__19489__$1,cljs.core.cst$kw$keywordize_DASH_keys_QMARK_,true);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var jsonp = (new goog.net.Jsonp(cljs_http.util.build_url(request),callback_name));
jsonp.setRequestTimeout(timeout);

var req_19502 = jsonp.send(null,((function (channel,jsonp,map__19489,map__19489__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function cljs_http$core$jsonp_$_success_callback(data){
var response = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(200),cljs.core.cst$kw$success,true,cljs.core.cst$kw$body,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,keywordize_keys_QMARK_], 0))], null);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp,map__19489,map__19489__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
,((function (channel,jsonp,map__19489,map__19489__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function cljs_http$core$jsonp_$_error_callback(){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp,map__19489,map__19489__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$jsonp,jsonp,cljs.core.cst$kw$request,req_19502], null));

if(cljs.core.truth_(cancel)){
var c__17516__auto___19503 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17516__auto___19503,req_19502,channel,jsonp,map__19489,map__19489__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function (){
var f__17517__auto__ = (function (){var switch__17414__auto__ = ((function (c__17516__auto___19503,req_19502,channel,jsonp,map__19489,map__19489__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function (state_19495){
var state_val_19496 = (state_19495[(1)]);
if((state_val_19496 === (1))){
var state_19495__$1 = state_19495;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19495__$1,(2),cancel);
} else {
if((state_val_19496 === (2))){
var inst_19492 = (state_19495[(2)]);
var inst_19493 = jsonp.cancel(req_19502);
var state_19495__$1 = (function (){var statearr_19497 = state_19495;
(statearr_19497[(7)] = inst_19492);

return statearr_19497;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_19495__$1,inst_19493);
} else {
return null;
}
}
});})(c__17516__auto___19503,req_19502,channel,jsonp,map__19489,map__19489__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
;
return ((function (switch__17414__auto__,c__17516__auto___19503,req_19502,channel,jsonp,map__19489,map__19489__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function() {
var cljs_http$core$jsonp_$_state_machine__17415__auto__ = null;
var cljs_http$core$jsonp_$_state_machine__17415__auto____0 = (function (){
var statearr_19498 = [null,null,null,null,null,null,null,null];
(statearr_19498[(0)] = cljs_http$core$jsonp_$_state_machine__17415__auto__);

(statearr_19498[(1)] = (1));

return statearr_19498;
});
var cljs_http$core$jsonp_$_state_machine__17415__auto____1 = (function (state_19495){
while(true){
var ret_value__17416__auto__ = (function (){try{while(true){
var result__17417__auto__ = switch__17414__auto__(state_19495);
if(cljs.core.keyword_identical_QMARK_(result__17417__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17417__auto__;
}
break;
}
}catch (e19499){if((e19499 instanceof Object)){
var ex__17418__auto__ = e19499;
var statearr_19500_19504 = state_19495;
(statearr_19500_19504[(5)] = ex__17418__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19495);

return cljs.core.cst$kw$recur;
} else {
throw e19499;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17416__auto__,cljs.core.cst$kw$recur)){
var G__19505 = state_19495;
state_19495 = G__19505;
continue;
} else {
return ret_value__17416__auto__;
}
break;
}
});
cljs_http$core$jsonp_$_state_machine__17415__auto__ = function(state_19495){
switch(arguments.length){
case 0:
return cljs_http$core$jsonp_$_state_machine__17415__auto____0.call(this);
case 1:
return cljs_http$core$jsonp_$_state_machine__17415__auto____1.call(this,state_19495);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs_http$core$jsonp_$_state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$jsonp_$_state_machine__17415__auto____0;
cljs_http$core$jsonp_$_state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$jsonp_$_state_machine__17415__auto____1;
return cljs_http$core$jsonp_$_state_machine__17415__auto__;
})()
;})(switch__17414__auto__,c__17516__auto___19503,req_19502,channel,jsonp,map__19489,map__19489__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
})();
var state__17518__auto__ = (function (){var statearr_19501 = (f__17517__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17517__auto__.cljs$core$IFn$_invoke$arity$0() : f__17517__auto__.call(null));
(statearr_19501[(6)] = c__17516__auto___19503);

return statearr_19501;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17518__auto__);
});})(c__17516__auto___19503,req_19502,channel,jsonp,map__19489,map__19489__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
);

} else {
}

return channel;
});
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.request = (function cljs_http$core$request(p__19506){
var map__19507 = p__19506;
var map__19507__$1 = ((((!((map__19507 == null)))?((((map__19507.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19507.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19507):map__19507);
var request = map__19507__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19507__$1,cljs.core.cst$kw$request_DASH_method);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(request_method,cljs.core.cst$kw$jsonp)){
return cljs_http.core.jsonp(request);
} else {
return cljs_http.core.xhr(request);
}
});
