// Compiled by ClojureScript 1.9.946 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__17576 = arguments.length;
switch (G__17576) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async17577 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17577 = (function (f,blockable,meta17578){
this.f = f;
this.blockable = blockable;
this.meta17578 = meta17578;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17577.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17579,meta17578__$1){
var self__ = this;
var _17579__$1 = this;
return (new cljs.core.async.t_cljs$core$async17577(self__.f,self__.blockable,meta17578__$1));
});

cljs.core.async.t_cljs$core$async17577.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17579){
var self__ = this;
var _17579__$1 = this;
return self__.meta17578;
});

cljs.core.async.t_cljs$core$async17577.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17577.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17577.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async17577.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async17577.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta17578], null);
});

cljs.core.async.t_cljs$core$async17577.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17577.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17577";

cljs.core.async.t_cljs$core$async17577.cljs$lang$ctorPrWriter = (function (this__9479__auto__,writer__9480__auto__,opt__9481__auto__){
return cljs.core._write(writer__9480__auto__,"cljs.core.async/t_cljs$core$async17577");
});

cljs.core.async.__GT_t_cljs$core$async17577 = (function cljs$core$async$__GT_t_cljs$core$async17577(f__$1,blockable__$1,meta17578){
return (new cljs.core.async.t_cljs$core$async17577(f__$1,blockable__$1,meta17578));
});

}

return (new cljs.core.async.t_cljs$core$async17577(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__17583 = arguments.length;
switch (G__17583) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__17586 = arguments.length;
switch (G__17586) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__17589 = arguments.length;
switch (G__17589) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_17591 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_17591) : fn1.call(null,val_17591));
} else {
cljs.core.async.impl.dispatch.run(((function (val_17591,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_17591) : fn1.call(null,val_17591));
});})(val_17591,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__17593 = arguments.length;
switch (G__17593) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5455__auto__)){
var ret = temp__5455__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5455__auto__)){
var retb = temp__5455__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__5455__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__5455__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__9853__auto___17595 = n;
var x_17596 = (0);
while(true){
if((x_17596 < n__9853__auto___17595)){
(a[x_17596] = (0));

var G__17597 = (x_17596 + (1));
x_17596 = G__17597;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__17598 = (i + (1));
i = G__17598;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if(typeof cljs.core.async.t_cljs$core$async17599 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17599 = (function (flag,meta17600){
this.flag = flag;
this.meta17600 = meta17600;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17599.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_17601,meta17600__$1){
var self__ = this;
var _17601__$1 = this;
return (new cljs.core.async.t_cljs$core$async17599(self__.flag,meta17600__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async17599.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_17601){
var self__ = this;
var _17601__$1 = this;
return self__.meta17600;
});})(flag))
;

cljs.core.async.t_cljs$core$async17599.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17599.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async17599.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17599.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17599.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta17600], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async17599.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17599.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17599";

cljs.core.async.t_cljs$core$async17599.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__9479__auto__,writer__9480__auto__,opt__9481__auto__){
return cljs.core._write(writer__9480__auto__,"cljs.core.async/t_cljs$core$async17599");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async17599 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async17599(flag__$1,meta17600){
return (new cljs.core.async.t_cljs$core$async17599(flag__$1,meta17600));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async17599(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async17602 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17602 = (function (flag,cb,meta17603){
this.flag = flag;
this.cb = cb;
this.meta17603 = meta17603;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17602.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17604,meta17603__$1){
var self__ = this;
var _17604__$1 = this;
return (new cljs.core.async.t_cljs$core$async17602(self__.flag,self__.cb,meta17603__$1));
});

cljs.core.async.t_cljs$core$async17602.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17604){
var self__ = this;
var _17604__$1 = this;
return self__.meta17603;
});

cljs.core.async.t_cljs$core$async17602.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17602.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async17602.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17602.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async17602.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta17603], null);
});

cljs.core.async.t_cljs$core$async17602.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17602.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17602";

cljs.core.async.t_cljs$core$async17602.cljs$lang$ctorPrWriter = (function (this__9479__auto__,writer__9480__auto__,opt__9481__auto__){
return cljs.core._write(writer__9480__auto__,"cljs.core.async/t_cljs$core$async17602");
});

cljs.core.async.__GT_t_cljs$core$async17602 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async17602(flag__$1,cb__$1,meta17603){
return (new cljs.core.async.t_cljs$core$async17602(flag__$1,cb__$1,meta17603));
});

}

return (new cljs.core.async.t_cljs$core$async17602(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17605_SHARP_){
var G__17607 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17605_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__17607) : fret.call(null,G__17607));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17606_SHARP_){
var G__17608 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17606_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__17608) : fret.call(null,G__17608));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__8808__auto__ = wport;
if(cljs.core.truth_(or__8808__auto__)){
return or__8808__auto__;
} else {
return port;
}
})()], null));
} else {
var G__17609 = (i + (1));
i = G__17609;
continue;
}
} else {
return null;
}
break;
}
})();
var or__8808__auto__ = ret;
if(cljs.core.truth_(or__8808__auto__)){
return or__8808__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__5457__auto__ = (function (){var and__8796__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__8796__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__8796__auto__;
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var got = temp__5457__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__10094__auto__ = [];
var len__10087__auto___17615 = arguments.length;
var i__10088__auto___17616 = (0);
while(true){
if((i__10088__auto___17616 < len__10087__auto___17615)){
args__10094__auto__.push((arguments[i__10088__auto___17616]));

var G__17617 = (i__10088__auto___17616 + (1));
i__10088__auto___17616 = G__17617;
continue;
} else {
}
break;
}

var argseq__10095__auto__ = ((((1) < args__10094__auto__.length))?(new cljs.core.IndexedSeq(args__10094__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10095__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__17612){
var map__17613 = p__17612;
var map__17613__$1 = ((((!((map__17613 == null)))?((((map__17613.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17613.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17613):map__17613);
var opts = map__17613__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq17610){
var G__17611 = cljs.core.first(seq17610);
var seq17610__$1 = cljs.core.next(seq17610);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17611,seq17610__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__17619 = arguments.length;
switch (G__17619) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__17516__auto___17665 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17516__auto___17665){
return (function (){
var f__17517__auto__ = (function (){var switch__17414__auto__ = ((function (c__17516__auto___17665){
return (function (state_17643){
var state_val_17644 = (state_17643[(1)]);
if((state_val_17644 === (7))){
var inst_17639 = (state_17643[(2)]);
var state_17643__$1 = state_17643;
var statearr_17645_17666 = state_17643__$1;
(statearr_17645_17666[(2)] = inst_17639);

(statearr_17645_17666[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17644 === (1))){
var state_17643__$1 = state_17643;
var statearr_17646_17667 = state_17643__$1;
(statearr_17646_17667[(2)] = null);

(statearr_17646_17667[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17644 === (4))){
var inst_17622 = (state_17643[(7)]);
var inst_17622__$1 = (state_17643[(2)]);
var inst_17623 = (inst_17622__$1 == null);
var state_17643__$1 = (function (){var statearr_17647 = state_17643;
(statearr_17647[(7)] = inst_17622__$1);

return statearr_17647;
})();
if(cljs.core.truth_(inst_17623)){
var statearr_17648_17668 = state_17643__$1;
(statearr_17648_17668[(1)] = (5));

} else {
var statearr_17649_17669 = state_17643__$1;
(statearr_17649_17669[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17644 === (13))){
var state_17643__$1 = state_17643;
var statearr_17650_17670 = state_17643__$1;
(statearr_17650_17670[(2)] = null);

(statearr_17650_17670[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17644 === (6))){
var inst_17622 = (state_17643[(7)]);
var state_17643__$1 = state_17643;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17643__$1,(11),to,inst_17622);
} else {
if((state_val_17644 === (3))){
var inst_17641 = (state_17643[(2)]);
var state_17643__$1 = state_17643;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17643__$1,inst_17641);
} else {
if((state_val_17644 === (12))){
var state_17643__$1 = state_17643;
var statearr_17651_17671 = state_17643__$1;
(statearr_17651_17671[(2)] = null);

(statearr_17651_17671[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17644 === (2))){
var state_17643__$1 = state_17643;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17643__$1,(4),from);
} else {
if((state_val_17644 === (11))){
var inst_17632 = (state_17643[(2)]);
var state_17643__$1 = state_17643;
if(cljs.core.truth_(inst_17632)){
var statearr_17652_17672 = state_17643__$1;
(statearr_17652_17672[(1)] = (12));

} else {
var statearr_17653_17673 = state_17643__$1;
(statearr_17653_17673[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17644 === (9))){
var state_17643__$1 = state_17643;
var statearr_17654_17674 = state_17643__$1;
(statearr_17654_17674[(2)] = null);

(statearr_17654_17674[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17644 === (5))){
var state_17643__$1 = state_17643;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17655_17675 = state_17643__$1;
(statearr_17655_17675[(1)] = (8));

} else {
var statearr_17656_17676 = state_17643__$1;
(statearr_17656_17676[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17644 === (14))){
var inst_17637 = (state_17643[(2)]);
var state_17643__$1 = state_17643;
var statearr_17657_17677 = state_17643__$1;
(statearr_17657_17677[(2)] = inst_17637);

(statearr_17657_17677[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17644 === (10))){
var inst_17629 = (state_17643[(2)]);
var state_17643__$1 = state_17643;
var statearr_17658_17678 = state_17643__$1;
(statearr_17658_17678[(2)] = inst_17629);

(statearr_17658_17678[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17644 === (8))){
var inst_17626 = cljs.core.async.close_BANG_(to);
var state_17643__$1 = state_17643;
var statearr_17659_17679 = state_17643__$1;
(statearr_17659_17679[(2)] = inst_17626);

(statearr_17659_17679[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17516__auto___17665))
;
return ((function (switch__17414__auto__,c__17516__auto___17665){
return (function() {
var cljs$core$async$state_machine__17415__auto__ = null;
var cljs$core$async$state_machine__17415__auto____0 = (function (){
var statearr_17660 = [null,null,null,null,null,null,null,null];
(statearr_17660[(0)] = cljs$core$async$state_machine__17415__auto__);

(statearr_17660[(1)] = (1));

return statearr_17660;
});
var cljs$core$async$state_machine__17415__auto____1 = (function (state_17643){
while(true){
var ret_value__17416__auto__ = (function (){try{while(true){
var result__17417__auto__ = switch__17414__auto__(state_17643);
if(cljs.core.keyword_identical_QMARK_(result__17417__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17417__auto__;
}
break;
}
}catch (e17661){if((e17661 instanceof Object)){
var ex__17418__auto__ = e17661;
var statearr_17662_17680 = state_17643;
(statearr_17662_17680[(5)] = ex__17418__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17643);

return cljs.core.cst$kw$recur;
} else {
throw e17661;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17416__auto__,cljs.core.cst$kw$recur)){
var G__17681 = state_17643;
state_17643 = G__17681;
continue;
} else {
return ret_value__17416__auto__;
}
break;
}
});
cljs$core$async$state_machine__17415__auto__ = function(state_17643){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17415__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17415__auto____1.call(this,state_17643);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17415__auto____0;
cljs$core$async$state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17415__auto____1;
return cljs$core$async$state_machine__17415__auto__;
})()
;})(switch__17414__auto__,c__17516__auto___17665))
})();
var state__17518__auto__ = (function (){var statearr_17663 = (f__17517__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17517__auto__.cljs$core$IFn$_invoke$arity$0() : f__17517__auto__.call(null));
(statearr_17663[(6)] = c__17516__auto___17665);

return statearr_17663;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17518__auto__);
});})(c__17516__auto___17665))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__17682){
var vec__17683 = p__17682;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17683,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17683,(1),null);
var job = vec__17683;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__17516__auto___17854 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17516__auto___17854,res,vec__17683,v,p,job,jobs,results){
return (function (){
var f__17517__auto__ = (function (){var switch__17414__auto__ = ((function (c__17516__auto___17854,res,vec__17683,v,p,job,jobs,results){
return (function (state_17690){
var state_val_17691 = (state_17690[(1)]);
if((state_val_17691 === (1))){
var state_17690__$1 = state_17690;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17690__$1,(2),res,v);
} else {
if((state_val_17691 === (2))){
var inst_17687 = (state_17690[(2)]);
var inst_17688 = cljs.core.async.close_BANG_(res);
var state_17690__$1 = (function (){var statearr_17692 = state_17690;
(statearr_17692[(7)] = inst_17687);

return statearr_17692;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_17690__$1,inst_17688);
} else {
return null;
}
}
});})(c__17516__auto___17854,res,vec__17683,v,p,job,jobs,results))
;
return ((function (switch__17414__auto__,c__17516__auto___17854,res,vec__17683,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17415__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17415__auto____0 = (function (){
var statearr_17693 = [null,null,null,null,null,null,null,null];
(statearr_17693[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17415__auto__);

(statearr_17693[(1)] = (1));

return statearr_17693;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17415__auto____1 = (function (state_17690){
while(true){
var ret_value__17416__auto__ = (function (){try{while(true){
var result__17417__auto__ = switch__17414__auto__(state_17690);
if(cljs.core.keyword_identical_QMARK_(result__17417__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17417__auto__;
}
break;
}
}catch (e17694){if((e17694 instanceof Object)){
var ex__17418__auto__ = e17694;
var statearr_17695_17855 = state_17690;
(statearr_17695_17855[(5)] = ex__17418__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17690);

return cljs.core.cst$kw$recur;
} else {
throw e17694;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17416__auto__,cljs.core.cst$kw$recur)){
var G__17856 = state_17690;
state_17690 = G__17856;
continue;
} else {
return ret_value__17416__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17415__auto__ = function(state_17690){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17415__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17415__auto____1.call(this,state_17690);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17415__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17415__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17415__auto__;
})()
;})(switch__17414__auto__,c__17516__auto___17854,res,vec__17683,v,p,job,jobs,results))
})();
var state__17518__auto__ = (function (){var statearr_17696 = (f__17517__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17517__auto__.cljs$core$IFn$_invoke$arity$0() : f__17517__auto__.call(null));
(statearr_17696[(6)] = c__17516__auto___17854);

return statearr_17696;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17518__auto__);
});})(c__17516__auto___17854,res,vec__17683,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__17697){
var vec__17698 = p__17697;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17698,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17698,(1),null);
var job = vec__17698;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__9853__auto___17857 = n;
var __17858 = (0);
while(true){
if((__17858 < n__9853__auto___17857)){
var G__17701_17859 = type;
var G__17701_17860__$1 = (((G__17701_17859 instanceof cljs.core.Keyword))?G__17701_17859.fqn:null);
switch (G__17701_17860__$1) {
case "compute":
var c__17516__auto___17862 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__17858,c__17516__auto___17862,G__17701_17859,G__17701_17860__$1,n__9853__auto___17857,jobs,results,process,async){
return (function (){
var f__17517__auto__ = (function (){var switch__17414__auto__ = ((function (__17858,c__17516__auto___17862,G__17701_17859,G__17701_17860__$1,n__9853__auto___17857,jobs,results,process,async){
return (function (state_17714){
var state_val_17715 = (state_17714[(1)]);
if((state_val_17715 === (1))){
var state_17714__$1 = state_17714;
var statearr_17716_17863 = state_17714__$1;
(statearr_17716_17863[(2)] = null);

(statearr_17716_17863[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17715 === (2))){
var state_17714__$1 = state_17714;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17714__$1,(4),jobs);
} else {
if((state_val_17715 === (3))){
var inst_17712 = (state_17714[(2)]);
var state_17714__$1 = state_17714;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17714__$1,inst_17712);
} else {
if((state_val_17715 === (4))){
var inst_17704 = (state_17714[(2)]);
var inst_17705 = process(inst_17704);
var state_17714__$1 = state_17714;
if(cljs.core.truth_(inst_17705)){
var statearr_17717_17864 = state_17714__$1;
(statearr_17717_17864[(1)] = (5));

} else {
var statearr_17718_17865 = state_17714__$1;
(statearr_17718_17865[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17715 === (5))){
var state_17714__$1 = state_17714;
var statearr_17719_17866 = state_17714__$1;
(statearr_17719_17866[(2)] = null);

(statearr_17719_17866[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17715 === (6))){
var state_17714__$1 = state_17714;
var statearr_17720_17867 = state_17714__$1;
(statearr_17720_17867[(2)] = null);

(statearr_17720_17867[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17715 === (7))){
var inst_17710 = (state_17714[(2)]);
var state_17714__$1 = state_17714;
var statearr_17721_17868 = state_17714__$1;
(statearr_17721_17868[(2)] = inst_17710);

(statearr_17721_17868[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__17858,c__17516__auto___17862,G__17701_17859,G__17701_17860__$1,n__9853__auto___17857,jobs,results,process,async))
;
return ((function (__17858,switch__17414__auto__,c__17516__auto___17862,G__17701_17859,G__17701_17860__$1,n__9853__auto___17857,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17415__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17415__auto____0 = (function (){
var statearr_17722 = [null,null,null,null,null,null,null];
(statearr_17722[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17415__auto__);

(statearr_17722[(1)] = (1));

return statearr_17722;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17415__auto____1 = (function (state_17714){
while(true){
var ret_value__17416__auto__ = (function (){try{while(true){
var result__17417__auto__ = switch__17414__auto__(state_17714);
if(cljs.core.keyword_identical_QMARK_(result__17417__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17417__auto__;
}
break;
}
}catch (e17723){if((e17723 instanceof Object)){
var ex__17418__auto__ = e17723;
var statearr_17724_17869 = state_17714;
(statearr_17724_17869[(5)] = ex__17418__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17714);

return cljs.core.cst$kw$recur;
} else {
throw e17723;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17416__auto__,cljs.core.cst$kw$recur)){
var G__17870 = state_17714;
state_17714 = G__17870;
continue;
} else {
return ret_value__17416__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17415__auto__ = function(state_17714){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17415__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17415__auto____1.call(this,state_17714);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17415__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17415__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17415__auto__;
})()
;})(__17858,switch__17414__auto__,c__17516__auto___17862,G__17701_17859,G__17701_17860__$1,n__9853__auto___17857,jobs,results,process,async))
})();
var state__17518__auto__ = (function (){var statearr_17725 = (f__17517__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17517__auto__.cljs$core$IFn$_invoke$arity$0() : f__17517__auto__.call(null));
(statearr_17725[(6)] = c__17516__auto___17862);

return statearr_17725;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17518__auto__);
});})(__17858,c__17516__auto___17862,G__17701_17859,G__17701_17860__$1,n__9853__auto___17857,jobs,results,process,async))
);


break;
case "async":
var c__17516__auto___17871 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__17858,c__17516__auto___17871,G__17701_17859,G__17701_17860__$1,n__9853__auto___17857,jobs,results,process,async){
return (function (){
var f__17517__auto__ = (function (){var switch__17414__auto__ = ((function (__17858,c__17516__auto___17871,G__17701_17859,G__17701_17860__$1,n__9853__auto___17857,jobs,results,process,async){
return (function (state_17738){
var state_val_17739 = (state_17738[(1)]);
if((state_val_17739 === (1))){
var state_17738__$1 = state_17738;
var statearr_17740_17872 = state_17738__$1;
(statearr_17740_17872[(2)] = null);

(statearr_17740_17872[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17739 === (2))){
var state_17738__$1 = state_17738;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17738__$1,(4),jobs);
} else {
if((state_val_17739 === (3))){
var inst_17736 = (state_17738[(2)]);
var state_17738__$1 = state_17738;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17738__$1,inst_17736);
} else {
if((state_val_17739 === (4))){
var inst_17728 = (state_17738[(2)]);
var inst_17729 = async(inst_17728);
var state_17738__$1 = state_17738;
if(cljs.core.truth_(inst_17729)){
var statearr_17741_17873 = state_17738__$1;
(statearr_17741_17873[(1)] = (5));

} else {
var statearr_17742_17874 = state_17738__$1;
(statearr_17742_17874[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17739 === (5))){
var state_17738__$1 = state_17738;
var statearr_17743_17875 = state_17738__$1;
(statearr_17743_17875[(2)] = null);

(statearr_17743_17875[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17739 === (6))){
var state_17738__$1 = state_17738;
var statearr_17744_17876 = state_17738__$1;
(statearr_17744_17876[(2)] = null);

(statearr_17744_17876[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17739 === (7))){
var inst_17734 = (state_17738[(2)]);
var state_17738__$1 = state_17738;
var statearr_17745_17877 = state_17738__$1;
(statearr_17745_17877[(2)] = inst_17734);

(statearr_17745_17877[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__17858,c__17516__auto___17871,G__17701_17859,G__17701_17860__$1,n__9853__auto___17857,jobs,results,process,async))
;
return ((function (__17858,switch__17414__auto__,c__17516__auto___17871,G__17701_17859,G__17701_17860__$1,n__9853__auto___17857,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17415__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17415__auto____0 = (function (){
var statearr_17746 = [null,null,null,null,null,null,null];
(statearr_17746[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17415__auto__);

(statearr_17746[(1)] = (1));

return statearr_17746;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17415__auto____1 = (function (state_17738){
while(true){
var ret_value__17416__auto__ = (function (){try{while(true){
var result__17417__auto__ = switch__17414__auto__(state_17738);
if(cljs.core.keyword_identical_QMARK_(result__17417__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17417__auto__;
}
break;
}
}catch (e17747){if((e17747 instanceof Object)){
var ex__17418__auto__ = e17747;
var statearr_17748_17878 = state_17738;
(statearr_17748_17878[(5)] = ex__17418__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17738);

return cljs.core.cst$kw$recur;
} else {
throw e17747;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17416__auto__,cljs.core.cst$kw$recur)){
var G__17879 = state_17738;
state_17738 = G__17879;
continue;
} else {
return ret_value__17416__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17415__auto__ = function(state_17738){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17415__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17415__auto____1.call(this,state_17738);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17415__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17415__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17415__auto__;
})()
;})(__17858,switch__17414__auto__,c__17516__auto___17871,G__17701_17859,G__17701_17860__$1,n__9853__auto___17857,jobs,results,process,async))
})();
var state__17518__auto__ = (function (){var statearr_17749 = (f__17517__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17517__auto__.cljs$core$IFn$_invoke$arity$0() : f__17517__auto__.call(null));
(statearr_17749[(6)] = c__17516__auto___17871);

return statearr_17749;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17518__auto__);
});})(__17858,c__17516__auto___17871,G__17701_17859,G__17701_17860__$1,n__9853__auto___17857,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__17701_17860__$1)].join('')));

}

var G__17880 = (__17858 + (1));
__17858 = G__17880;
continue;
} else {
}
break;
}

var c__17516__auto___17881 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17516__auto___17881,jobs,results,process,async){
return (function (){
var f__17517__auto__ = (function (){var switch__17414__auto__ = ((function (c__17516__auto___17881,jobs,results,process,async){
return (function (state_17771){
var state_val_17772 = (state_17771[(1)]);
if((state_val_17772 === (1))){
var state_17771__$1 = state_17771;
var statearr_17773_17882 = state_17771__$1;
(statearr_17773_17882[(2)] = null);

(statearr_17773_17882[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17772 === (2))){
var state_17771__$1 = state_17771;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17771__$1,(4),from);
} else {
if((state_val_17772 === (3))){
var inst_17769 = (state_17771[(2)]);
var state_17771__$1 = state_17771;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17771__$1,inst_17769);
} else {
if((state_val_17772 === (4))){
var inst_17752 = (state_17771[(7)]);
var inst_17752__$1 = (state_17771[(2)]);
var inst_17753 = (inst_17752__$1 == null);
var state_17771__$1 = (function (){var statearr_17774 = state_17771;
(statearr_17774[(7)] = inst_17752__$1);

return statearr_17774;
})();
if(cljs.core.truth_(inst_17753)){
var statearr_17775_17883 = state_17771__$1;
(statearr_17775_17883[(1)] = (5));

} else {
var statearr_17776_17884 = state_17771__$1;
(statearr_17776_17884[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17772 === (5))){
var inst_17755 = cljs.core.async.close_BANG_(jobs);
var state_17771__$1 = state_17771;
var statearr_17777_17885 = state_17771__$1;
(statearr_17777_17885[(2)] = inst_17755);

(statearr_17777_17885[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17772 === (6))){
var inst_17752 = (state_17771[(7)]);
var inst_17757 = (state_17771[(8)]);
var inst_17757__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_17758 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17759 = [inst_17752,inst_17757__$1];
var inst_17760 = (new cljs.core.PersistentVector(null,2,(5),inst_17758,inst_17759,null));
var state_17771__$1 = (function (){var statearr_17778 = state_17771;
(statearr_17778[(8)] = inst_17757__$1);

return statearr_17778;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17771__$1,(8),jobs,inst_17760);
} else {
if((state_val_17772 === (7))){
var inst_17767 = (state_17771[(2)]);
var state_17771__$1 = state_17771;
var statearr_17779_17886 = state_17771__$1;
(statearr_17779_17886[(2)] = inst_17767);

(statearr_17779_17886[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17772 === (8))){
var inst_17757 = (state_17771[(8)]);
var inst_17762 = (state_17771[(2)]);
var state_17771__$1 = (function (){var statearr_17780 = state_17771;
(statearr_17780[(9)] = inst_17762);

return statearr_17780;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17771__$1,(9),results,inst_17757);
} else {
if((state_val_17772 === (9))){
var inst_17764 = (state_17771[(2)]);
var state_17771__$1 = (function (){var statearr_17781 = state_17771;
(statearr_17781[(10)] = inst_17764);

return statearr_17781;
})();
var statearr_17782_17887 = state_17771__$1;
(statearr_17782_17887[(2)] = null);

(statearr_17782_17887[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__17516__auto___17881,jobs,results,process,async))
;
return ((function (switch__17414__auto__,c__17516__auto___17881,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17415__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17415__auto____0 = (function (){
var statearr_17783 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17783[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17415__auto__);

(statearr_17783[(1)] = (1));

return statearr_17783;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17415__auto____1 = (function (state_17771){
while(true){
var ret_value__17416__auto__ = (function (){try{while(true){
var result__17417__auto__ = switch__17414__auto__(state_17771);
if(cljs.core.keyword_identical_QMARK_(result__17417__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17417__auto__;
}
break;
}
}catch (e17784){if((e17784 instanceof Object)){
var ex__17418__auto__ = e17784;
var statearr_17785_17888 = state_17771;
(statearr_17785_17888[(5)] = ex__17418__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17771);

return cljs.core.cst$kw$recur;
} else {
throw e17784;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17416__auto__,cljs.core.cst$kw$recur)){
var G__17889 = state_17771;
state_17771 = G__17889;
continue;
} else {
return ret_value__17416__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17415__auto__ = function(state_17771){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17415__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17415__auto____1.call(this,state_17771);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17415__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17415__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17415__auto__;
})()
;})(switch__17414__auto__,c__17516__auto___17881,jobs,results,process,async))
})();
var state__17518__auto__ = (function (){var statearr_17786 = (f__17517__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17517__auto__.cljs$core$IFn$_invoke$arity$0() : f__17517__auto__.call(null));
(statearr_17786[(6)] = c__17516__auto___17881);

return statearr_17786;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17518__auto__);
});})(c__17516__auto___17881,jobs,results,process,async))
);


var c__17516__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17516__auto__,jobs,results,process,async){
return (function (){
var f__17517__auto__ = (function (){var switch__17414__auto__ = ((function (c__17516__auto__,jobs,results,process,async){
return (function (state_17824){
var state_val_17825 = (state_17824[(1)]);
if((state_val_17825 === (7))){
var inst_17820 = (state_17824[(2)]);
var state_17824__$1 = state_17824;
var statearr_17826_17890 = state_17824__$1;
(statearr_17826_17890[(2)] = inst_17820);

(statearr_17826_17890[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17825 === (20))){
var state_17824__$1 = state_17824;
var statearr_17827_17891 = state_17824__$1;
(statearr_17827_17891[(2)] = null);

(statearr_17827_17891[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17825 === (1))){
var state_17824__$1 = state_17824;
var statearr_17828_17892 = state_17824__$1;
(statearr_17828_17892[(2)] = null);

(statearr_17828_17892[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17825 === (4))){
var inst_17789 = (state_17824[(7)]);
var inst_17789__$1 = (state_17824[(2)]);
var inst_17790 = (inst_17789__$1 == null);
var state_17824__$1 = (function (){var statearr_17829 = state_17824;
(statearr_17829[(7)] = inst_17789__$1);

return statearr_17829;
})();
if(cljs.core.truth_(inst_17790)){
var statearr_17830_17893 = state_17824__$1;
(statearr_17830_17893[(1)] = (5));

} else {
var statearr_17831_17894 = state_17824__$1;
(statearr_17831_17894[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17825 === (15))){
var inst_17802 = (state_17824[(8)]);
var state_17824__$1 = state_17824;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17824__$1,(18),to,inst_17802);
} else {
if((state_val_17825 === (21))){
var inst_17815 = (state_17824[(2)]);
var state_17824__$1 = state_17824;
var statearr_17832_17895 = state_17824__$1;
(statearr_17832_17895[(2)] = inst_17815);

(statearr_17832_17895[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17825 === (13))){
var inst_17817 = (state_17824[(2)]);
var state_17824__$1 = (function (){var statearr_17833 = state_17824;
(statearr_17833[(9)] = inst_17817);

return statearr_17833;
})();
var statearr_17834_17896 = state_17824__$1;
(statearr_17834_17896[(2)] = null);

(statearr_17834_17896[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17825 === (6))){
var inst_17789 = (state_17824[(7)]);
var state_17824__$1 = state_17824;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17824__$1,(11),inst_17789);
} else {
if((state_val_17825 === (17))){
var inst_17810 = (state_17824[(2)]);
var state_17824__$1 = state_17824;
if(cljs.core.truth_(inst_17810)){
var statearr_17835_17897 = state_17824__$1;
(statearr_17835_17897[(1)] = (19));

} else {
var statearr_17836_17898 = state_17824__$1;
(statearr_17836_17898[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17825 === (3))){
var inst_17822 = (state_17824[(2)]);
var state_17824__$1 = state_17824;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17824__$1,inst_17822);
} else {
if((state_val_17825 === (12))){
var inst_17799 = (state_17824[(10)]);
var state_17824__$1 = state_17824;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17824__$1,(14),inst_17799);
} else {
if((state_val_17825 === (2))){
var state_17824__$1 = state_17824;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17824__$1,(4),results);
} else {
if((state_val_17825 === (19))){
var state_17824__$1 = state_17824;
var statearr_17837_17899 = state_17824__$1;
(statearr_17837_17899[(2)] = null);

(statearr_17837_17899[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17825 === (11))){
var inst_17799 = (state_17824[(2)]);
var state_17824__$1 = (function (){var statearr_17838 = state_17824;
(statearr_17838[(10)] = inst_17799);

return statearr_17838;
})();
var statearr_17839_17900 = state_17824__$1;
(statearr_17839_17900[(2)] = null);

(statearr_17839_17900[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17825 === (9))){
var state_17824__$1 = state_17824;
var statearr_17840_17901 = state_17824__$1;
(statearr_17840_17901[(2)] = null);

(statearr_17840_17901[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17825 === (5))){
var state_17824__$1 = state_17824;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17841_17902 = state_17824__$1;
(statearr_17841_17902[(1)] = (8));

} else {
var statearr_17842_17903 = state_17824__$1;
(statearr_17842_17903[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17825 === (14))){
var inst_17804 = (state_17824[(11)]);
var inst_17802 = (state_17824[(8)]);
var inst_17802__$1 = (state_17824[(2)]);
var inst_17803 = (inst_17802__$1 == null);
var inst_17804__$1 = cljs.core.not(inst_17803);
var state_17824__$1 = (function (){var statearr_17843 = state_17824;
(statearr_17843[(11)] = inst_17804__$1);

(statearr_17843[(8)] = inst_17802__$1);

return statearr_17843;
})();
if(inst_17804__$1){
var statearr_17844_17904 = state_17824__$1;
(statearr_17844_17904[(1)] = (15));

} else {
var statearr_17845_17905 = state_17824__$1;
(statearr_17845_17905[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17825 === (16))){
var inst_17804 = (state_17824[(11)]);
var state_17824__$1 = state_17824;
var statearr_17846_17906 = state_17824__$1;
(statearr_17846_17906[(2)] = inst_17804);

(statearr_17846_17906[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17825 === (10))){
var inst_17796 = (state_17824[(2)]);
var state_17824__$1 = state_17824;
var statearr_17847_17907 = state_17824__$1;
(statearr_17847_17907[(2)] = inst_17796);

(statearr_17847_17907[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17825 === (18))){
var inst_17807 = (state_17824[(2)]);
var state_17824__$1 = state_17824;
var statearr_17848_17908 = state_17824__$1;
(statearr_17848_17908[(2)] = inst_17807);

(statearr_17848_17908[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17825 === (8))){
var inst_17793 = cljs.core.async.close_BANG_(to);
var state_17824__$1 = state_17824;
var statearr_17849_17909 = state_17824__$1;
(statearr_17849_17909[(2)] = inst_17793);

(statearr_17849_17909[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17516__auto__,jobs,results,process,async))
;
return ((function (switch__17414__auto__,c__17516__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17415__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17415__auto____0 = (function (){
var statearr_17850 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17850[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17415__auto__);

(statearr_17850[(1)] = (1));

return statearr_17850;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17415__auto____1 = (function (state_17824){
while(true){
var ret_value__17416__auto__ = (function (){try{while(true){
var result__17417__auto__ = switch__17414__auto__(state_17824);
if(cljs.core.keyword_identical_QMARK_(result__17417__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17417__auto__;
}
break;
}
}catch (e17851){if((e17851 instanceof Object)){
var ex__17418__auto__ = e17851;
var statearr_17852_17910 = state_17824;
(statearr_17852_17910[(5)] = ex__17418__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17824);

return cljs.core.cst$kw$recur;
} else {
throw e17851;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17416__auto__,cljs.core.cst$kw$recur)){
var G__17911 = state_17824;
state_17824 = G__17911;
continue;
} else {
return ret_value__17416__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17415__auto__ = function(state_17824){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17415__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17415__auto____1.call(this,state_17824);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17415__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17415__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17415__auto__;
})()
;})(switch__17414__auto__,c__17516__auto__,jobs,results,process,async))
})();
var state__17518__auto__ = (function (){var statearr_17853 = (f__17517__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17517__auto__.cljs$core$IFn$_invoke$arity$0() : f__17517__auto__.call(null));
(statearr_17853[(6)] = c__17516__auto__);

return statearr_17853;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17518__auto__);
});})(c__17516__auto__,jobs,results,process,async))
);

return c__17516__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__17913 = arguments.length;
switch (G__17913) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__17916 = arguments.length;
switch (G__17916) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__17919 = arguments.length;
switch (G__17919) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__17516__auto___17968 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17516__auto___17968,tc,fc){
return (function (){
var f__17517__auto__ = (function (){var switch__17414__auto__ = ((function (c__17516__auto___17968,tc,fc){
return (function (state_17945){
var state_val_17946 = (state_17945[(1)]);
if((state_val_17946 === (7))){
var inst_17941 = (state_17945[(2)]);
var state_17945__$1 = state_17945;
var statearr_17947_17969 = state_17945__$1;
(statearr_17947_17969[(2)] = inst_17941);

(statearr_17947_17969[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17946 === (1))){
var state_17945__$1 = state_17945;
var statearr_17948_17970 = state_17945__$1;
(statearr_17948_17970[(2)] = null);

(statearr_17948_17970[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17946 === (4))){
var inst_17922 = (state_17945[(7)]);
var inst_17922__$1 = (state_17945[(2)]);
var inst_17923 = (inst_17922__$1 == null);
var state_17945__$1 = (function (){var statearr_17949 = state_17945;
(statearr_17949[(7)] = inst_17922__$1);

return statearr_17949;
})();
if(cljs.core.truth_(inst_17923)){
var statearr_17950_17971 = state_17945__$1;
(statearr_17950_17971[(1)] = (5));

} else {
var statearr_17951_17972 = state_17945__$1;
(statearr_17951_17972[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17946 === (13))){
var state_17945__$1 = state_17945;
var statearr_17952_17973 = state_17945__$1;
(statearr_17952_17973[(2)] = null);

(statearr_17952_17973[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17946 === (6))){
var inst_17922 = (state_17945[(7)]);
var inst_17928 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_17922) : p.call(null,inst_17922));
var state_17945__$1 = state_17945;
if(cljs.core.truth_(inst_17928)){
var statearr_17953_17974 = state_17945__$1;
(statearr_17953_17974[(1)] = (9));

} else {
var statearr_17954_17975 = state_17945__$1;
(statearr_17954_17975[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17946 === (3))){
var inst_17943 = (state_17945[(2)]);
var state_17945__$1 = state_17945;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17945__$1,inst_17943);
} else {
if((state_val_17946 === (12))){
var state_17945__$1 = state_17945;
var statearr_17955_17976 = state_17945__$1;
(statearr_17955_17976[(2)] = null);

(statearr_17955_17976[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17946 === (2))){
var state_17945__$1 = state_17945;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17945__$1,(4),ch);
} else {
if((state_val_17946 === (11))){
var inst_17922 = (state_17945[(7)]);
var inst_17932 = (state_17945[(2)]);
var state_17945__$1 = state_17945;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17945__$1,(8),inst_17932,inst_17922);
} else {
if((state_val_17946 === (9))){
var state_17945__$1 = state_17945;
var statearr_17956_17977 = state_17945__$1;
(statearr_17956_17977[(2)] = tc);

(statearr_17956_17977[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17946 === (5))){
var inst_17925 = cljs.core.async.close_BANG_(tc);
var inst_17926 = cljs.core.async.close_BANG_(fc);
var state_17945__$1 = (function (){var statearr_17957 = state_17945;
(statearr_17957[(8)] = inst_17925);

return statearr_17957;
})();
var statearr_17958_17978 = state_17945__$1;
(statearr_17958_17978[(2)] = inst_17926);

(statearr_17958_17978[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17946 === (14))){
var inst_17939 = (state_17945[(2)]);
var state_17945__$1 = state_17945;
var statearr_17959_17979 = state_17945__$1;
(statearr_17959_17979[(2)] = inst_17939);

(statearr_17959_17979[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17946 === (10))){
var state_17945__$1 = state_17945;
var statearr_17960_17980 = state_17945__$1;
(statearr_17960_17980[(2)] = fc);

(statearr_17960_17980[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17946 === (8))){
var inst_17934 = (state_17945[(2)]);
var state_17945__$1 = state_17945;
if(cljs.core.truth_(inst_17934)){
var statearr_17961_17981 = state_17945__$1;
(statearr_17961_17981[(1)] = (12));

} else {
var statearr_17962_17982 = state_17945__$1;
(statearr_17962_17982[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17516__auto___17968,tc,fc))
;
return ((function (switch__17414__auto__,c__17516__auto___17968,tc,fc){
return (function() {
var cljs$core$async$state_machine__17415__auto__ = null;
var cljs$core$async$state_machine__17415__auto____0 = (function (){
var statearr_17963 = [null,null,null,null,null,null,null,null,null];
(statearr_17963[(0)] = cljs$core$async$state_machine__17415__auto__);

(statearr_17963[(1)] = (1));

return statearr_17963;
});
var cljs$core$async$state_machine__17415__auto____1 = (function (state_17945){
while(true){
var ret_value__17416__auto__ = (function (){try{while(true){
var result__17417__auto__ = switch__17414__auto__(state_17945);
if(cljs.core.keyword_identical_QMARK_(result__17417__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17417__auto__;
}
break;
}
}catch (e17964){if((e17964 instanceof Object)){
var ex__17418__auto__ = e17964;
var statearr_17965_17983 = state_17945;
(statearr_17965_17983[(5)] = ex__17418__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17945);

return cljs.core.cst$kw$recur;
} else {
throw e17964;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17416__auto__,cljs.core.cst$kw$recur)){
var G__17984 = state_17945;
state_17945 = G__17984;
continue;
} else {
return ret_value__17416__auto__;
}
break;
}
});
cljs$core$async$state_machine__17415__auto__ = function(state_17945){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17415__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17415__auto____1.call(this,state_17945);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17415__auto____0;
cljs$core$async$state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17415__auto____1;
return cljs$core$async$state_machine__17415__auto__;
})()
;})(switch__17414__auto__,c__17516__auto___17968,tc,fc))
})();
var state__17518__auto__ = (function (){var statearr_17966 = (f__17517__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17517__auto__.cljs$core$IFn$_invoke$arity$0() : f__17517__auto__.call(null));
(statearr_17966[(6)] = c__17516__auto___17968);

return statearr_17966;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17518__auto__);
});})(c__17516__auto___17968,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__17516__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17516__auto__){
return (function (){
var f__17517__auto__ = (function (){var switch__17414__auto__ = ((function (c__17516__auto__){
return (function (state_18005){
var state_val_18006 = (state_18005[(1)]);
if((state_val_18006 === (7))){
var inst_18001 = (state_18005[(2)]);
var state_18005__$1 = state_18005;
var statearr_18007_18025 = state_18005__$1;
(statearr_18007_18025[(2)] = inst_18001);

(statearr_18007_18025[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18006 === (1))){
var inst_17985 = init;
var state_18005__$1 = (function (){var statearr_18008 = state_18005;
(statearr_18008[(7)] = inst_17985);

return statearr_18008;
})();
var statearr_18009_18026 = state_18005__$1;
(statearr_18009_18026[(2)] = null);

(statearr_18009_18026[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18006 === (4))){
var inst_17988 = (state_18005[(8)]);
var inst_17988__$1 = (state_18005[(2)]);
var inst_17989 = (inst_17988__$1 == null);
var state_18005__$1 = (function (){var statearr_18010 = state_18005;
(statearr_18010[(8)] = inst_17988__$1);

return statearr_18010;
})();
if(cljs.core.truth_(inst_17989)){
var statearr_18011_18027 = state_18005__$1;
(statearr_18011_18027[(1)] = (5));

} else {
var statearr_18012_18028 = state_18005__$1;
(statearr_18012_18028[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18006 === (6))){
var inst_17992 = (state_18005[(9)]);
var inst_17985 = (state_18005[(7)]);
var inst_17988 = (state_18005[(8)]);
var inst_17992__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_17985,inst_17988) : f.call(null,inst_17985,inst_17988));
var inst_17993 = cljs.core.reduced_QMARK_(inst_17992__$1);
var state_18005__$1 = (function (){var statearr_18013 = state_18005;
(statearr_18013[(9)] = inst_17992__$1);

return statearr_18013;
})();
if(inst_17993){
var statearr_18014_18029 = state_18005__$1;
(statearr_18014_18029[(1)] = (8));

} else {
var statearr_18015_18030 = state_18005__$1;
(statearr_18015_18030[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18006 === (3))){
var inst_18003 = (state_18005[(2)]);
var state_18005__$1 = state_18005;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18005__$1,inst_18003);
} else {
if((state_val_18006 === (2))){
var state_18005__$1 = state_18005;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18005__$1,(4),ch);
} else {
if((state_val_18006 === (9))){
var inst_17992 = (state_18005[(9)]);
var inst_17985 = inst_17992;
var state_18005__$1 = (function (){var statearr_18016 = state_18005;
(statearr_18016[(7)] = inst_17985);

return statearr_18016;
})();
var statearr_18017_18031 = state_18005__$1;
(statearr_18017_18031[(2)] = null);

(statearr_18017_18031[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18006 === (5))){
var inst_17985 = (state_18005[(7)]);
var state_18005__$1 = state_18005;
var statearr_18018_18032 = state_18005__$1;
(statearr_18018_18032[(2)] = inst_17985);

(statearr_18018_18032[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18006 === (10))){
var inst_17999 = (state_18005[(2)]);
var state_18005__$1 = state_18005;
var statearr_18019_18033 = state_18005__$1;
(statearr_18019_18033[(2)] = inst_17999);

(statearr_18019_18033[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18006 === (8))){
var inst_17992 = (state_18005[(9)]);
var inst_17995 = cljs.core.deref(inst_17992);
var state_18005__$1 = state_18005;
var statearr_18020_18034 = state_18005__$1;
(statearr_18020_18034[(2)] = inst_17995);

(statearr_18020_18034[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__17516__auto__))
;
return ((function (switch__17414__auto__,c__17516__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__17415__auto__ = null;
var cljs$core$async$reduce_$_state_machine__17415__auto____0 = (function (){
var statearr_18021 = [null,null,null,null,null,null,null,null,null,null];
(statearr_18021[(0)] = cljs$core$async$reduce_$_state_machine__17415__auto__);

(statearr_18021[(1)] = (1));

return statearr_18021;
});
var cljs$core$async$reduce_$_state_machine__17415__auto____1 = (function (state_18005){
while(true){
var ret_value__17416__auto__ = (function (){try{while(true){
var result__17417__auto__ = switch__17414__auto__(state_18005);
if(cljs.core.keyword_identical_QMARK_(result__17417__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17417__auto__;
}
break;
}
}catch (e18022){if((e18022 instanceof Object)){
var ex__17418__auto__ = e18022;
var statearr_18023_18035 = state_18005;
(statearr_18023_18035[(5)] = ex__17418__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18005);

return cljs.core.cst$kw$recur;
} else {
throw e18022;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17416__auto__,cljs.core.cst$kw$recur)){
var G__18036 = state_18005;
state_18005 = G__18036;
continue;
} else {
return ret_value__17416__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__17415__auto__ = function(state_18005){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__17415__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__17415__auto____1.call(this,state_18005);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__17415__auto____0;
cljs$core$async$reduce_$_state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__17415__auto____1;
return cljs$core$async$reduce_$_state_machine__17415__auto__;
})()
;})(switch__17414__auto__,c__17516__auto__))
})();
var state__17518__auto__ = (function (){var statearr_18024 = (f__17517__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17517__auto__.cljs$core$IFn$_invoke$arity$0() : f__17517__auto__.call(null));
(statearr_18024[(6)] = c__17516__auto__);

return statearr_18024;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17518__auto__);
});})(c__17516__auto__))
);

return c__17516__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__17516__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17516__auto__,f__$1){
return (function (){
var f__17517__auto__ = (function (){var switch__17414__auto__ = ((function (c__17516__auto__,f__$1){
return (function (state_18042){
var state_val_18043 = (state_18042[(1)]);
if((state_val_18043 === (1))){
var inst_18037 = cljs.core.async.reduce(f__$1,init,ch);
var state_18042__$1 = state_18042;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18042__$1,(2),inst_18037);
} else {
if((state_val_18043 === (2))){
var inst_18039 = (state_18042[(2)]);
var inst_18040 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_18039) : f__$1.call(null,inst_18039));
var state_18042__$1 = state_18042;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18042__$1,inst_18040);
} else {
return null;
}
}
});})(c__17516__auto__,f__$1))
;
return ((function (switch__17414__auto__,c__17516__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__17415__auto__ = null;
var cljs$core$async$transduce_$_state_machine__17415__auto____0 = (function (){
var statearr_18044 = [null,null,null,null,null,null,null];
(statearr_18044[(0)] = cljs$core$async$transduce_$_state_machine__17415__auto__);

(statearr_18044[(1)] = (1));

return statearr_18044;
});
var cljs$core$async$transduce_$_state_machine__17415__auto____1 = (function (state_18042){
while(true){
var ret_value__17416__auto__ = (function (){try{while(true){
var result__17417__auto__ = switch__17414__auto__(state_18042);
if(cljs.core.keyword_identical_QMARK_(result__17417__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17417__auto__;
}
break;
}
}catch (e18045){if((e18045 instanceof Object)){
var ex__17418__auto__ = e18045;
var statearr_18046_18048 = state_18042;
(statearr_18046_18048[(5)] = ex__17418__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18042);

return cljs.core.cst$kw$recur;
} else {
throw e18045;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17416__auto__,cljs.core.cst$kw$recur)){
var G__18049 = state_18042;
state_18042 = G__18049;
continue;
} else {
return ret_value__17416__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__17415__auto__ = function(state_18042){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__17415__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__17415__auto____1.call(this,state_18042);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__17415__auto____0;
cljs$core$async$transduce_$_state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__17415__auto____1;
return cljs$core$async$transduce_$_state_machine__17415__auto__;
})()
;})(switch__17414__auto__,c__17516__auto__,f__$1))
})();
var state__17518__auto__ = (function (){var statearr_18047 = (f__17517__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17517__auto__.cljs$core$IFn$_invoke$arity$0() : f__17517__auto__.call(null));
(statearr_18047[(6)] = c__17516__auto__);

return statearr_18047;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17518__auto__);
});})(c__17516__auto__,f__$1))
);

return c__17516__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__18051 = arguments.length;
switch (G__18051) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__17516__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17516__auto__){
return (function (){
var f__17517__auto__ = (function (){var switch__17414__auto__ = ((function (c__17516__auto__){
return (function (state_18076){
var state_val_18077 = (state_18076[(1)]);
if((state_val_18077 === (7))){
var inst_18058 = (state_18076[(2)]);
var state_18076__$1 = state_18076;
var statearr_18078_18099 = state_18076__$1;
(statearr_18078_18099[(2)] = inst_18058);

(statearr_18078_18099[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18077 === (1))){
var inst_18052 = cljs.core.seq(coll);
var inst_18053 = inst_18052;
var state_18076__$1 = (function (){var statearr_18079 = state_18076;
(statearr_18079[(7)] = inst_18053);

return statearr_18079;
})();
var statearr_18080_18100 = state_18076__$1;
(statearr_18080_18100[(2)] = null);

(statearr_18080_18100[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18077 === (4))){
var inst_18053 = (state_18076[(7)]);
var inst_18056 = cljs.core.first(inst_18053);
var state_18076__$1 = state_18076;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18076__$1,(7),ch,inst_18056);
} else {
if((state_val_18077 === (13))){
var inst_18070 = (state_18076[(2)]);
var state_18076__$1 = state_18076;
var statearr_18081_18101 = state_18076__$1;
(statearr_18081_18101[(2)] = inst_18070);

(statearr_18081_18101[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18077 === (6))){
var inst_18061 = (state_18076[(2)]);
var state_18076__$1 = state_18076;
if(cljs.core.truth_(inst_18061)){
var statearr_18082_18102 = state_18076__$1;
(statearr_18082_18102[(1)] = (8));

} else {
var statearr_18083_18103 = state_18076__$1;
(statearr_18083_18103[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18077 === (3))){
var inst_18074 = (state_18076[(2)]);
var state_18076__$1 = state_18076;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18076__$1,inst_18074);
} else {
if((state_val_18077 === (12))){
var state_18076__$1 = state_18076;
var statearr_18084_18104 = state_18076__$1;
(statearr_18084_18104[(2)] = null);

(statearr_18084_18104[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18077 === (2))){
var inst_18053 = (state_18076[(7)]);
var state_18076__$1 = state_18076;
if(cljs.core.truth_(inst_18053)){
var statearr_18085_18105 = state_18076__$1;
(statearr_18085_18105[(1)] = (4));

} else {
var statearr_18086_18106 = state_18076__$1;
(statearr_18086_18106[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18077 === (11))){
var inst_18067 = cljs.core.async.close_BANG_(ch);
var state_18076__$1 = state_18076;
var statearr_18087_18107 = state_18076__$1;
(statearr_18087_18107[(2)] = inst_18067);

(statearr_18087_18107[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18077 === (9))){
var state_18076__$1 = state_18076;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18088_18108 = state_18076__$1;
(statearr_18088_18108[(1)] = (11));

} else {
var statearr_18089_18109 = state_18076__$1;
(statearr_18089_18109[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18077 === (5))){
var inst_18053 = (state_18076[(7)]);
var state_18076__$1 = state_18076;
var statearr_18090_18110 = state_18076__$1;
(statearr_18090_18110[(2)] = inst_18053);

(statearr_18090_18110[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18077 === (10))){
var inst_18072 = (state_18076[(2)]);
var state_18076__$1 = state_18076;
var statearr_18091_18111 = state_18076__$1;
(statearr_18091_18111[(2)] = inst_18072);

(statearr_18091_18111[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18077 === (8))){
var inst_18053 = (state_18076[(7)]);
var inst_18063 = cljs.core.next(inst_18053);
var inst_18053__$1 = inst_18063;
var state_18076__$1 = (function (){var statearr_18092 = state_18076;
(statearr_18092[(7)] = inst_18053__$1);

return statearr_18092;
})();
var statearr_18093_18112 = state_18076__$1;
(statearr_18093_18112[(2)] = null);

(statearr_18093_18112[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17516__auto__))
;
return ((function (switch__17414__auto__,c__17516__auto__){
return (function() {
var cljs$core$async$state_machine__17415__auto__ = null;
var cljs$core$async$state_machine__17415__auto____0 = (function (){
var statearr_18094 = [null,null,null,null,null,null,null,null];
(statearr_18094[(0)] = cljs$core$async$state_machine__17415__auto__);

(statearr_18094[(1)] = (1));

return statearr_18094;
});
var cljs$core$async$state_machine__17415__auto____1 = (function (state_18076){
while(true){
var ret_value__17416__auto__ = (function (){try{while(true){
var result__17417__auto__ = switch__17414__auto__(state_18076);
if(cljs.core.keyword_identical_QMARK_(result__17417__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17417__auto__;
}
break;
}
}catch (e18095){if((e18095 instanceof Object)){
var ex__17418__auto__ = e18095;
var statearr_18096_18113 = state_18076;
(statearr_18096_18113[(5)] = ex__17418__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18076);

return cljs.core.cst$kw$recur;
} else {
throw e18095;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17416__auto__,cljs.core.cst$kw$recur)){
var G__18114 = state_18076;
state_18076 = G__18114;
continue;
} else {
return ret_value__17416__auto__;
}
break;
}
});
cljs$core$async$state_machine__17415__auto__ = function(state_18076){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17415__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17415__auto____1.call(this,state_18076);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17415__auto____0;
cljs$core$async$state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17415__auto____1;
return cljs$core$async$state_machine__17415__auto__;
})()
;})(switch__17414__auto__,c__17516__auto__))
})();
var state__17518__auto__ = (function (){var statearr_18097 = (f__17517__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17517__auto__.cljs$core$IFn$_invoke$arity$0() : f__17517__auto__.call(null));
(statearr_18097[(6)] = c__17516__auto__);

return statearr_18097;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17518__auto__);
});})(c__17516__auto__))
);

return c__17516__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__9541__auto__ = (((_ == null))?null:_);
var m__9542__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__9542__auto__.call(null,_));
} else {
var m__9542__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__9542__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__9541__auto__ = (((m == null))?null:m);
var m__9542__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__9542__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__9542__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__9542__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__9541__auto__ = (((m == null))?null:m);
var m__9542__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9542__auto__.call(null,m,ch));
} else {
var m__9542__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9542__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__9541__auto__ = (((m == null))?null:m);
var m__9542__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__9542__auto__.call(null,m));
} else {
var m__9542__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__9542__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18115 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18115 = (function (ch,cs,meta18116){
this.ch = ch;
this.cs = cs;
this.meta18116 = meta18116;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18115.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_18117,meta18116__$1){
var self__ = this;
var _18117__$1 = this;
return (new cljs.core.async.t_cljs$core$async18115(self__.ch,self__.cs,meta18116__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async18115.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_18117){
var self__ = this;
var _18117__$1 = this;
return self__.meta18116;
});})(cs))
;

cljs.core.async.t_cljs$core$async18115.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18115.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async18115.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18115.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18115.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18115.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18115.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta18116], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async18115.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18115.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18115";

cljs.core.async.t_cljs$core$async18115.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__9479__auto__,writer__9480__auto__,opt__9481__auto__){
return cljs.core._write(writer__9480__auto__,"cljs.core.async/t_cljs$core$async18115");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async18115 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async18115(ch__$1,cs__$1,meta18116){
return (new cljs.core.async.t_cljs$core$async18115(ch__$1,cs__$1,meta18116));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async18115(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__17516__auto___18337 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17516__auto___18337,cs,m,dchan,dctr,done){
return (function (){
var f__17517__auto__ = (function (){var switch__17414__auto__ = ((function (c__17516__auto___18337,cs,m,dchan,dctr,done){
return (function (state_18252){
var state_val_18253 = (state_18252[(1)]);
if((state_val_18253 === (7))){
var inst_18248 = (state_18252[(2)]);
var state_18252__$1 = state_18252;
var statearr_18254_18338 = state_18252__$1;
(statearr_18254_18338[(2)] = inst_18248);

(statearr_18254_18338[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (20))){
var inst_18151 = (state_18252[(7)]);
var inst_18163 = cljs.core.first(inst_18151);
var inst_18164 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18163,(0),null);
var inst_18165 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18163,(1),null);
var state_18252__$1 = (function (){var statearr_18255 = state_18252;
(statearr_18255[(8)] = inst_18164);

return statearr_18255;
})();
if(cljs.core.truth_(inst_18165)){
var statearr_18256_18339 = state_18252__$1;
(statearr_18256_18339[(1)] = (22));

} else {
var statearr_18257_18340 = state_18252__$1;
(statearr_18257_18340[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (27))){
var inst_18120 = (state_18252[(9)]);
var inst_18193 = (state_18252[(10)]);
var inst_18200 = (state_18252[(11)]);
var inst_18195 = (state_18252[(12)]);
var inst_18200__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_18193,inst_18195);
var inst_18201 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_18200__$1,inst_18120,done);
var state_18252__$1 = (function (){var statearr_18258 = state_18252;
(statearr_18258[(11)] = inst_18200__$1);

return statearr_18258;
})();
if(cljs.core.truth_(inst_18201)){
var statearr_18259_18341 = state_18252__$1;
(statearr_18259_18341[(1)] = (30));

} else {
var statearr_18260_18342 = state_18252__$1;
(statearr_18260_18342[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (1))){
var state_18252__$1 = state_18252;
var statearr_18261_18343 = state_18252__$1;
(statearr_18261_18343[(2)] = null);

(statearr_18261_18343[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (24))){
var inst_18151 = (state_18252[(7)]);
var inst_18170 = (state_18252[(2)]);
var inst_18171 = cljs.core.next(inst_18151);
var inst_18129 = inst_18171;
var inst_18130 = null;
var inst_18131 = (0);
var inst_18132 = (0);
var state_18252__$1 = (function (){var statearr_18262 = state_18252;
(statearr_18262[(13)] = inst_18131);

(statearr_18262[(14)] = inst_18132);

(statearr_18262[(15)] = inst_18130);

(statearr_18262[(16)] = inst_18129);

(statearr_18262[(17)] = inst_18170);

return statearr_18262;
})();
var statearr_18263_18344 = state_18252__$1;
(statearr_18263_18344[(2)] = null);

(statearr_18263_18344[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (39))){
var state_18252__$1 = state_18252;
var statearr_18267_18345 = state_18252__$1;
(statearr_18267_18345[(2)] = null);

(statearr_18267_18345[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (4))){
var inst_18120 = (state_18252[(9)]);
var inst_18120__$1 = (state_18252[(2)]);
var inst_18121 = (inst_18120__$1 == null);
var state_18252__$1 = (function (){var statearr_18268 = state_18252;
(statearr_18268[(9)] = inst_18120__$1);

return statearr_18268;
})();
if(cljs.core.truth_(inst_18121)){
var statearr_18269_18346 = state_18252__$1;
(statearr_18269_18346[(1)] = (5));

} else {
var statearr_18270_18347 = state_18252__$1;
(statearr_18270_18347[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (15))){
var inst_18131 = (state_18252[(13)]);
var inst_18132 = (state_18252[(14)]);
var inst_18130 = (state_18252[(15)]);
var inst_18129 = (state_18252[(16)]);
var inst_18147 = (state_18252[(2)]);
var inst_18148 = (inst_18132 + (1));
var tmp18264 = inst_18131;
var tmp18265 = inst_18130;
var tmp18266 = inst_18129;
var inst_18129__$1 = tmp18266;
var inst_18130__$1 = tmp18265;
var inst_18131__$1 = tmp18264;
var inst_18132__$1 = inst_18148;
var state_18252__$1 = (function (){var statearr_18271 = state_18252;
(statearr_18271[(13)] = inst_18131__$1);

(statearr_18271[(14)] = inst_18132__$1);

(statearr_18271[(15)] = inst_18130__$1);

(statearr_18271[(16)] = inst_18129__$1);

(statearr_18271[(18)] = inst_18147);

return statearr_18271;
})();
var statearr_18272_18348 = state_18252__$1;
(statearr_18272_18348[(2)] = null);

(statearr_18272_18348[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (21))){
var inst_18174 = (state_18252[(2)]);
var state_18252__$1 = state_18252;
var statearr_18276_18349 = state_18252__$1;
(statearr_18276_18349[(2)] = inst_18174);

(statearr_18276_18349[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (31))){
var inst_18200 = (state_18252[(11)]);
var inst_18204 = done(null);
var inst_18205 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_18200);
var state_18252__$1 = (function (){var statearr_18277 = state_18252;
(statearr_18277[(19)] = inst_18204);

return statearr_18277;
})();
var statearr_18278_18350 = state_18252__$1;
(statearr_18278_18350[(2)] = inst_18205);

(statearr_18278_18350[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (32))){
var inst_18194 = (state_18252[(20)]);
var inst_18192 = (state_18252[(21)]);
var inst_18193 = (state_18252[(10)]);
var inst_18195 = (state_18252[(12)]);
var inst_18207 = (state_18252[(2)]);
var inst_18208 = (inst_18195 + (1));
var tmp18273 = inst_18194;
var tmp18274 = inst_18192;
var tmp18275 = inst_18193;
var inst_18192__$1 = tmp18274;
var inst_18193__$1 = tmp18275;
var inst_18194__$1 = tmp18273;
var inst_18195__$1 = inst_18208;
var state_18252__$1 = (function (){var statearr_18279 = state_18252;
(statearr_18279[(20)] = inst_18194__$1);

(statearr_18279[(22)] = inst_18207);

(statearr_18279[(21)] = inst_18192__$1);

(statearr_18279[(10)] = inst_18193__$1);

(statearr_18279[(12)] = inst_18195__$1);

return statearr_18279;
})();
var statearr_18280_18351 = state_18252__$1;
(statearr_18280_18351[(2)] = null);

(statearr_18280_18351[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (40))){
var inst_18220 = (state_18252[(23)]);
var inst_18224 = done(null);
var inst_18225 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_18220);
var state_18252__$1 = (function (){var statearr_18281 = state_18252;
(statearr_18281[(24)] = inst_18224);

return statearr_18281;
})();
var statearr_18282_18352 = state_18252__$1;
(statearr_18282_18352[(2)] = inst_18225);

(statearr_18282_18352[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (33))){
var inst_18211 = (state_18252[(25)]);
var inst_18213 = cljs.core.chunked_seq_QMARK_(inst_18211);
var state_18252__$1 = state_18252;
if(inst_18213){
var statearr_18283_18353 = state_18252__$1;
(statearr_18283_18353[(1)] = (36));

} else {
var statearr_18284_18354 = state_18252__$1;
(statearr_18284_18354[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (13))){
var inst_18141 = (state_18252[(26)]);
var inst_18144 = cljs.core.async.close_BANG_(inst_18141);
var state_18252__$1 = state_18252;
var statearr_18285_18355 = state_18252__$1;
(statearr_18285_18355[(2)] = inst_18144);

(statearr_18285_18355[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (22))){
var inst_18164 = (state_18252[(8)]);
var inst_18167 = cljs.core.async.close_BANG_(inst_18164);
var state_18252__$1 = state_18252;
var statearr_18286_18356 = state_18252__$1;
(statearr_18286_18356[(2)] = inst_18167);

(statearr_18286_18356[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (36))){
var inst_18211 = (state_18252[(25)]);
var inst_18215 = cljs.core.chunk_first(inst_18211);
var inst_18216 = cljs.core.chunk_rest(inst_18211);
var inst_18217 = cljs.core.count(inst_18215);
var inst_18192 = inst_18216;
var inst_18193 = inst_18215;
var inst_18194 = inst_18217;
var inst_18195 = (0);
var state_18252__$1 = (function (){var statearr_18287 = state_18252;
(statearr_18287[(20)] = inst_18194);

(statearr_18287[(21)] = inst_18192);

(statearr_18287[(10)] = inst_18193);

(statearr_18287[(12)] = inst_18195);

return statearr_18287;
})();
var statearr_18288_18357 = state_18252__$1;
(statearr_18288_18357[(2)] = null);

(statearr_18288_18357[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (41))){
var inst_18211 = (state_18252[(25)]);
var inst_18227 = (state_18252[(2)]);
var inst_18228 = cljs.core.next(inst_18211);
var inst_18192 = inst_18228;
var inst_18193 = null;
var inst_18194 = (0);
var inst_18195 = (0);
var state_18252__$1 = (function (){var statearr_18289 = state_18252;
(statearr_18289[(20)] = inst_18194);

(statearr_18289[(21)] = inst_18192);

(statearr_18289[(10)] = inst_18193);

(statearr_18289[(12)] = inst_18195);

(statearr_18289[(27)] = inst_18227);

return statearr_18289;
})();
var statearr_18290_18358 = state_18252__$1;
(statearr_18290_18358[(2)] = null);

(statearr_18290_18358[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (43))){
var state_18252__$1 = state_18252;
var statearr_18291_18359 = state_18252__$1;
(statearr_18291_18359[(2)] = null);

(statearr_18291_18359[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (29))){
var inst_18236 = (state_18252[(2)]);
var state_18252__$1 = state_18252;
var statearr_18292_18360 = state_18252__$1;
(statearr_18292_18360[(2)] = inst_18236);

(statearr_18292_18360[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (44))){
var inst_18245 = (state_18252[(2)]);
var state_18252__$1 = (function (){var statearr_18293 = state_18252;
(statearr_18293[(28)] = inst_18245);

return statearr_18293;
})();
var statearr_18294_18361 = state_18252__$1;
(statearr_18294_18361[(2)] = null);

(statearr_18294_18361[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (6))){
var inst_18184 = (state_18252[(29)]);
var inst_18183 = cljs.core.deref(cs);
var inst_18184__$1 = cljs.core.keys(inst_18183);
var inst_18185 = cljs.core.count(inst_18184__$1);
var inst_18186 = cljs.core.reset_BANG_(dctr,inst_18185);
var inst_18191 = cljs.core.seq(inst_18184__$1);
var inst_18192 = inst_18191;
var inst_18193 = null;
var inst_18194 = (0);
var inst_18195 = (0);
var state_18252__$1 = (function (){var statearr_18295 = state_18252;
(statearr_18295[(20)] = inst_18194);

(statearr_18295[(30)] = inst_18186);

(statearr_18295[(21)] = inst_18192);

(statearr_18295[(10)] = inst_18193);

(statearr_18295[(29)] = inst_18184__$1);

(statearr_18295[(12)] = inst_18195);

return statearr_18295;
})();
var statearr_18296_18362 = state_18252__$1;
(statearr_18296_18362[(2)] = null);

(statearr_18296_18362[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (28))){
var inst_18211 = (state_18252[(25)]);
var inst_18192 = (state_18252[(21)]);
var inst_18211__$1 = cljs.core.seq(inst_18192);
var state_18252__$1 = (function (){var statearr_18297 = state_18252;
(statearr_18297[(25)] = inst_18211__$1);

return statearr_18297;
})();
if(inst_18211__$1){
var statearr_18298_18363 = state_18252__$1;
(statearr_18298_18363[(1)] = (33));

} else {
var statearr_18299_18364 = state_18252__$1;
(statearr_18299_18364[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (25))){
var inst_18194 = (state_18252[(20)]);
var inst_18195 = (state_18252[(12)]);
var inst_18197 = (inst_18195 < inst_18194);
var inst_18198 = inst_18197;
var state_18252__$1 = state_18252;
if(cljs.core.truth_(inst_18198)){
var statearr_18300_18365 = state_18252__$1;
(statearr_18300_18365[(1)] = (27));

} else {
var statearr_18301_18366 = state_18252__$1;
(statearr_18301_18366[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (34))){
var state_18252__$1 = state_18252;
var statearr_18302_18367 = state_18252__$1;
(statearr_18302_18367[(2)] = null);

(statearr_18302_18367[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (17))){
var state_18252__$1 = state_18252;
var statearr_18303_18368 = state_18252__$1;
(statearr_18303_18368[(2)] = null);

(statearr_18303_18368[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (3))){
var inst_18250 = (state_18252[(2)]);
var state_18252__$1 = state_18252;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18252__$1,inst_18250);
} else {
if((state_val_18253 === (12))){
var inst_18179 = (state_18252[(2)]);
var state_18252__$1 = state_18252;
var statearr_18304_18369 = state_18252__$1;
(statearr_18304_18369[(2)] = inst_18179);

(statearr_18304_18369[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (2))){
var state_18252__$1 = state_18252;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18252__$1,(4),ch);
} else {
if((state_val_18253 === (23))){
var state_18252__$1 = state_18252;
var statearr_18305_18370 = state_18252__$1;
(statearr_18305_18370[(2)] = null);

(statearr_18305_18370[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (35))){
var inst_18234 = (state_18252[(2)]);
var state_18252__$1 = state_18252;
var statearr_18306_18371 = state_18252__$1;
(statearr_18306_18371[(2)] = inst_18234);

(statearr_18306_18371[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (19))){
var inst_18151 = (state_18252[(7)]);
var inst_18155 = cljs.core.chunk_first(inst_18151);
var inst_18156 = cljs.core.chunk_rest(inst_18151);
var inst_18157 = cljs.core.count(inst_18155);
var inst_18129 = inst_18156;
var inst_18130 = inst_18155;
var inst_18131 = inst_18157;
var inst_18132 = (0);
var state_18252__$1 = (function (){var statearr_18307 = state_18252;
(statearr_18307[(13)] = inst_18131);

(statearr_18307[(14)] = inst_18132);

(statearr_18307[(15)] = inst_18130);

(statearr_18307[(16)] = inst_18129);

return statearr_18307;
})();
var statearr_18308_18372 = state_18252__$1;
(statearr_18308_18372[(2)] = null);

(statearr_18308_18372[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (11))){
var inst_18151 = (state_18252[(7)]);
var inst_18129 = (state_18252[(16)]);
var inst_18151__$1 = cljs.core.seq(inst_18129);
var state_18252__$1 = (function (){var statearr_18309 = state_18252;
(statearr_18309[(7)] = inst_18151__$1);

return statearr_18309;
})();
if(inst_18151__$1){
var statearr_18310_18373 = state_18252__$1;
(statearr_18310_18373[(1)] = (16));

} else {
var statearr_18311_18374 = state_18252__$1;
(statearr_18311_18374[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (9))){
var inst_18181 = (state_18252[(2)]);
var state_18252__$1 = state_18252;
var statearr_18312_18375 = state_18252__$1;
(statearr_18312_18375[(2)] = inst_18181);

(statearr_18312_18375[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (5))){
var inst_18127 = cljs.core.deref(cs);
var inst_18128 = cljs.core.seq(inst_18127);
var inst_18129 = inst_18128;
var inst_18130 = null;
var inst_18131 = (0);
var inst_18132 = (0);
var state_18252__$1 = (function (){var statearr_18313 = state_18252;
(statearr_18313[(13)] = inst_18131);

(statearr_18313[(14)] = inst_18132);

(statearr_18313[(15)] = inst_18130);

(statearr_18313[(16)] = inst_18129);

return statearr_18313;
})();
var statearr_18314_18376 = state_18252__$1;
(statearr_18314_18376[(2)] = null);

(statearr_18314_18376[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (14))){
var state_18252__$1 = state_18252;
var statearr_18315_18377 = state_18252__$1;
(statearr_18315_18377[(2)] = null);

(statearr_18315_18377[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (45))){
var inst_18242 = (state_18252[(2)]);
var state_18252__$1 = state_18252;
var statearr_18316_18378 = state_18252__$1;
(statearr_18316_18378[(2)] = inst_18242);

(statearr_18316_18378[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (26))){
var inst_18184 = (state_18252[(29)]);
var inst_18238 = (state_18252[(2)]);
var inst_18239 = cljs.core.seq(inst_18184);
var state_18252__$1 = (function (){var statearr_18317 = state_18252;
(statearr_18317[(31)] = inst_18238);

return statearr_18317;
})();
if(inst_18239){
var statearr_18318_18379 = state_18252__$1;
(statearr_18318_18379[(1)] = (42));

} else {
var statearr_18319_18380 = state_18252__$1;
(statearr_18319_18380[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (16))){
var inst_18151 = (state_18252[(7)]);
var inst_18153 = cljs.core.chunked_seq_QMARK_(inst_18151);
var state_18252__$1 = state_18252;
if(inst_18153){
var statearr_18320_18381 = state_18252__$1;
(statearr_18320_18381[(1)] = (19));

} else {
var statearr_18321_18382 = state_18252__$1;
(statearr_18321_18382[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (38))){
var inst_18231 = (state_18252[(2)]);
var state_18252__$1 = state_18252;
var statearr_18322_18383 = state_18252__$1;
(statearr_18322_18383[(2)] = inst_18231);

(statearr_18322_18383[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (30))){
var state_18252__$1 = state_18252;
var statearr_18323_18384 = state_18252__$1;
(statearr_18323_18384[(2)] = null);

(statearr_18323_18384[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (10))){
var inst_18132 = (state_18252[(14)]);
var inst_18130 = (state_18252[(15)]);
var inst_18140 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_18130,inst_18132);
var inst_18141 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18140,(0),null);
var inst_18142 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18140,(1),null);
var state_18252__$1 = (function (){var statearr_18324 = state_18252;
(statearr_18324[(26)] = inst_18141);

return statearr_18324;
})();
if(cljs.core.truth_(inst_18142)){
var statearr_18325_18385 = state_18252__$1;
(statearr_18325_18385[(1)] = (13));

} else {
var statearr_18326_18386 = state_18252__$1;
(statearr_18326_18386[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (18))){
var inst_18177 = (state_18252[(2)]);
var state_18252__$1 = state_18252;
var statearr_18327_18387 = state_18252__$1;
(statearr_18327_18387[(2)] = inst_18177);

(statearr_18327_18387[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (42))){
var state_18252__$1 = state_18252;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18252__$1,(45),dchan);
} else {
if((state_val_18253 === (37))){
var inst_18220 = (state_18252[(23)]);
var inst_18211 = (state_18252[(25)]);
var inst_18120 = (state_18252[(9)]);
var inst_18220__$1 = cljs.core.first(inst_18211);
var inst_18221 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_18220__$1,inst_18120,done);
var state_18252__$1 = (function (){var statearr_18328 = state_18252;
(statearr_18328[(23)] = inst_18220__$1);

return statearr_18328;
})();
if(cljs.core.truth_(inst_18221)){
var statearr_18329_18388 = state_18252__$1;
(statearr_18329_18388[(1)] = (39));

} else {
var statearr_18330_18389 = state_18252__$1;
(statearr_18330_18389[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18253 === (8))){
var inst_18131 = (state_18252[(13)]);
var inst_18132 = (state_18252[(14)]);
var inst_18134 = (inst_18132 < inst_18131);
var inst_18135 = inst_18134;
var state_18252__$1 = state_18252;
if(cljs.core.truth_(inst_18135)){
var statearr_18331_18390 = state_18252__$1;
(statearr_18331_18390[(1)] = (10));

} else {
var statearr_18332_18391 = state_18252__$1;
(statearr_18332_18391[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17516__auto___18337,cs,m,dchan,dctr,done))
;
return ((function (switch__17414__auto__,c__17516__auto___18337,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__17415__auto__ = null;
var cljs$core$async$mult_$_state_machine__17415__auto____0 = (function (){
var statearr_18333 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18333[(0)] = cljs$core$async$mult_$_state_machine__17415__auto__);

(statearr_18333[(1)] = (1));

return statearr_18333;
});
var cljs$core$async$mult_$_state_machine__17415__auto____1 = (function (state_18252){
while(true){
var ret_value__17416__auto__ = (function (){try{while(true){
var result__17417__auto__ = switch__17414__auto__(state_18252);
if(cljs.core.keyword_identical_QMARK_(result__17417__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17417__auto__;
}
break;
}
}catch (e18334){if((e18334 instanceof Object)){
var ex__17418__auto__ = e18334;
var statearr_18335_18392 = state_18252;
(statearr_18335_18392[(5)] = ex__17418__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18252);

return cljs.core.cst$kw$recur;
} else {
throw e18334;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17416__auto__,cljs.core.cst$kw$recur)){
var G__18393 = state_18252;
state_18252 = G__18393;
continue;
} else {
return ret_value__17416__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__17415__auto__ = function(state_18252){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__17415__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__17415__auto____1.call(this,state_18252);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__17415__auto____0;
cljs$core$async$mult_$_state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__17415__auto____1;
return cljs$core$async$mult_$_state_machine__17415__auto__;
})()
;})(switch__17414__auto__,c__17516__auto___18337,cs,m,dchan,dctr,done))
})();
var state__17518__auto__ = (function (){var statearr_18336 = (f__17517__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17517__auto__.cljs$core$IFn$_invoke$arity$0() : f__17517__auto__.call(null));
(statearr_18336[(6)] = c__17516__auto___18337);

return statearr_18336;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17518__auto__);
});})(c__17516__auto___18337,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__18395 = arguments.length;
switch (G__18395) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__9541__auto__ = (((m == null))?null:m);
var m__9542__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9542__auto__.call(null,m,ch));
} else {
var m__9542__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9542__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__9541__auto__ = (((m == null))?null:m);
var m__9542__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9542__auto__.call(null,m,ch));
} else {
var m__9542__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9542__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__9541__auto__ = (((m == null))?null:m);
var m__9542__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__9542__auto__.call(null,m));
} else {
var m__9542__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__9542__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__9541__auto__ = (((m == null))?null:m);
var m__9542__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__9542__auto__.call(null,m,state_map));
} else {
var m__9542__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__9542__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__9541__auto__ = (((m == null))?null:m);
var m__9542__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__9542__auto__.call(null,m,mode));
} else {
var m__9542__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__9542__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__10094__auto__ = [];
var len__10087__auto___18407 = arguments.length;
var i__10088__auto___18408 = (0);
while(true){
if((i__10088__auto___18408 < len__10087__auto___18407)){
args__10094__auto__.push((arguments[i__10088__auto___18408]));

var G__18409 = (i__10088__auto___18408 + (1));
i__10088__auto___18408 = G__18409;
continue;
} else {
}
break;
}

var argseq__10095__auto__ = ((((3) < args__10094__auto__.length))?(new cljs.core.IndexedSeq(args__10094__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10095__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__18401){
var map__18402 = p__18401;
var map__18402__$1 = ((((!((map__18402 == null)))?((((map__18402.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18402.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18402):map__18402);
var opts = map__18402__$1;
var statearr_18404_18410 = state;
(statearr_18404_18410[(1)] = cont_block);


var temp__5457__auto__ = cljs.core.async.do_alts(((function (map__18402,map__18402__$1,opts){
return (function (val){
var statearr_18405_18411 = state;
(statearr_18405_18411[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__18402,map__18402__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5457__auto__)){
var cb = temp__5457__auto__;
var statearr_18406_18412 = state;
(statearr_18406_18412[(2)] = cljs.core.deref(cb));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq18397){
var G__18398 = cljs.core.first(seq18397);
var seq18397__$1 = cljs.core.next(seq18397);
var G__18399 = cljs.core.first(seq18397__$1);
var seq18397__$2 = cljs.core.next(seq18397__$1);
var G__18400 = cljs.core.first(seq18397__$2);
var seq18397__$3 = cljs.core.next(seq18397__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__18398,G__18399,G__18400,seq18397__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute);
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18413 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18413 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta18414){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta18414 = meta18414;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18413.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18415,meta18414__$1){
var self__ = this;
var _18415__$1 = this;
return (new cljs.core.async.t_cljs$core$async18413(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta18414__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18413.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18415){
var self__ = this;
var _18415__$1 = this;
return self__.meta18414;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18413.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18413.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18413.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18413.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18413.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18413.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18413.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18413.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18413.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out,cljs.core.cst$sym$cs,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$change,cljs.core.cst$sym$changed,cljs.core.cst$sym$pick,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$meta18414], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18413.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18413.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18413";

cljs.core.async.t_cljs$core$async18413.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__9479__auto__,writer__9480__auto__,opt__9481__auto__){
return cljs.core._write(writer__9480__auto__,"cljs.core.async/t_cljs$core$async18413");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async18413 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async18413(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta18414){
return (new cljs.core.async.t_cljs$core$async18413(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta18414));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async18413(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__17516__auto___18577 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17516__auto___18577,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__17517__auto__ = (function (){var switch__17414__auto__ = ((function (c__17516__auto___18577,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_18517){
var state_val_18518 = (state_18517[(1)]);
if((state_val_18518 === (7))){
var inst_18432 = (state_18517[(2)]);
var state_18517__$1 = state_18517;
var statearr_18519_18578 = state_18517__$1;
(statearr_18519_18578[(2)] = inst_18432);

(statearr_18519_18578[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (20))){
var inst_18444 = (state_18517[(7)]);
var state_18517__$1 = state_18517;
var statearr_18520_18579 = state_18517__$1;
(statearr_18520_18579[(2)] = inst_18444);

(statearr_18520_18579[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (27))){
var state_18517__$1 = state_18517;
var statearr_18521_18580 = state_18517__$1;
(statearr_18521_18580[(2)] = null);

(statearr_18521_18580[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (1))){
var inst_18419 = (state_18517[(8)]);
var inst_18419__$1 = calc_state();
var inst_18421 = (inst_18419__$1 == null);
var inst_18422 = cljs.core.not(inst_18421);
var state_18517__$1 = (function (){var statearr_18522 = state_18517;
(statearr_18522[(8)] = inst_18419__$1);

return statearr_18522;
})();
if(inst_18422){
var statearr_18523_18581 = state_18517__$1;
(statearr_18523_18581[(1)] = (2));

} else {
var statearr_18524_18582 = state_18517__$1;
(statearr_18524_18582[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (24))){
var inst_18491 = (state_18517[(9)]);
var inst_18477 = (state_18517[(10)]);
var inst_18468 = (state_18517[(11)]);
var inst_18491__$1 = (inst_18468.cljs$core$IFn$_invoke$arity$1 ? inst_18468.cljs$core$IFn$_invoke$arity$1(inst_18477) : inst_18468.call(null,inst_18477));
var state_18517__$1 = (function (){var statearr_18525 = state_18517;
(statearr_18525[(9)] = inst_18491__$1);

return statearr_18525;
})();
if(cljs.core.truth_(inst_18491__$1)){
var statearr_18526_18583 = state_18517__$1;
(statearr_18526_18583[(1)] = (29));

} else {
var statearr_18527_18584 = state_18517__$1;
(statearr_18527_18584[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (4))){
var inst_18435 = (state_18517[(2)]);
var state_18517__$1 = state_18517;
if(cljs.core.truth_(inst_18435)){
var statearr_18528_18585 = state_18517__$1;
(statearr_18528_18585[(1)] = (8));

} else {
var statearr_18529_18586 = state_18517__$1;
(statearr_18529_18586[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (15))){
var inst_18462 = (state_18517[(2)]);
var state_18517__$1 = state_18517;
if(cljs.core.truth_(inst_18462)){
var statearr_18530_18587 = state_18517__$1;
(statearr_18530_18587[(1)] = (19));

} else {
var statearr_18531_18588 = state_18517__$1;
(statearr_18531_18588[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (21))){
var inst_18467 = (state_18517[(12)]);
var inst_18467__$1 = (state_18517[(2)]);
var inst_18468 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18467__$1,cljs.core.cst$kw$solos);
var inst_18469 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18467__$1,cljs.core.cst$kw$mutes);
var inst_18470 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18467__$1,cljs.core.cst$kw$reads);
var state_18517__$1 = (function (){var statearr_18532 = state_18517;
(statearr_18532[(13)] = inst_18469);

(statearr_18532[(11)] = inst_18468);

(statearr_18532[(12)] = inst_18467__$1);

return statearr_18532;
})();
return cljs.core.async.ioc_alts_BANG_(state_18517__$1,(22),inst_18470);
} else {
if((state_val_18518 === (31))){
var inst_18499 = (state_18517[(2)]);
var state_18517__$1 = state_18517;
if(cljs.core.truth_(inst_18499)){
var statearr_18533_18589 = state_18517__$1;
(statearr_18533_18589[(1)] = (32));

} else {
var statearr_18534_18590 = state_18517__$1;
(statearr_18534_18590[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (32))){
var inst_18476 = (state_18517[(14)]);
var state_18517__$1 = state_18517;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18517__$1,(35),out,inst_18476);
} else {
if((state_val_18518 === (33))){
var inst_18467 = (state_18517[(12)]);
var inst_18444 = inst_18467;
var state_18517__$1 = (function (){var statearr_18535 = state_18517;
(statearr_18535[(7)] = inst_18444);

return statearr_18535;
})();
var statearr_18536_18591 = state_18517__$1;
(statearr_18536_18591[(2)] = null);

(statearr_18536_18591[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (13))){
var inst_18444 = (state_18517[(7)]);
var inst_18451 = inst_18444.cljs$lang$protocol_mask$partition0$;
var inst_18452 = (inst_18451 & (64));
var inst_18453 = inst_18444.cljs$core$ISeq$;
var inst_18454 = (cljs.core.PROTOCOL_SENTINEL === inst_18453);
var inst_18455 = (inst_18452) || (inst_18454);
var state_18517__$1 = state_18517;
if(cljs.core.truth_(inst_18455)){
var statearr_18537_18592 = state_18517__$1;
(statearr_18537_18592[(1)] = (16));

} else {
var statearr_18538_18593 = state_18517__$1;
(statearr_18538_18593[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (22))){
var inst_18477 = (state_18517[(10)]);
var inst_18476 = (state_18517[(14)]);
var inst_18475 = (state_18517[(2)]);
var inst_18476__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18475,(0),null);
var inst_18477__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18475,(1),null);
var inst_18478 = (inst_18476__$1 == null);
var inst_18479 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_18477__$1,change);
var inst_18480 = (inst_18478) || (inst_18479);
var state_18517__$1 = (function (){var statearr_18539 = state_18517;
(statearr_18539[(10)] = inst_18477__$1);

(statearr_18539[(14)] = inst_18476__$1);

return statearr_18539;
})();
if(cljs.core.truth_(inst_18480)){
var statearr_18540_18594 = state_18517__$1;
(statearr_18540_18594[(1)] = (23));

} else {
var statearr_18541_18595 = state_18517__$1;
(statearr_18541_18595[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (36))){
var inst_18467 = (state_18517[(12)]);
var inst_18444 = inst_18467;
var state_18517__$1 = (function (){var statearr_18542 = state_18517;
(statearr_18542[(7)] = inst_18444);

return statearr_18542;
})();
var statearr_18543_18596 = state_18517__$1;
(statearr_18543_18596[(2)] = null);

(statearr_18543_18596[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (29))){
var inst_18491 = (state_18517[(9)]);
var state_18517__$1 = state_18517;
var statearr_18544_18597 = state_18517__$1;
(statearr_18544_18597[(2)] = inst_18491);

(statearr_18544_18597[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (6))){
var state_18517__$1 = state_18517;
var statearr_18545_18598 = state_18517__$1;
(statearr_18545_18598[(2)] = false);

(statearr_18545_18598[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (28))){
var inst_18487 = (state_18517[(2)]);
var inst_18488 = calc_state();
var inst_18444 = inst_18488;
var state_18517__$1 = (function (){var statearr_18546 = state_18517;
(statearr_18546[(15)] = inst_18487);

(statearr_18546[(7)] = inst_18444);

return statearr_18546;
})();
var statearr_18547_18599 = state_18517__$1;
(statearr_18547_18599[(2)] = null);

(statearr_18547_18599[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (25))){
var inst_18513 = (state_18517[(2)]);
var state_18517__$1 = state_18517;
var statearr_18548_18600 = state_18517__$1;
(statearr_18548_18600[(2)] = inst_18513);

(statearr_18548_18600[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (34))){
var inst_18511 = (state_18517[(2)]);
var state_18517__$1 = state_18517;
var statearr_18549_18601 = state_18517__$1;
(statearr_18549_18601[(2)] = inst_18511);

(statearr_18549_18601[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (17))){
var state_18517__$1 = state_18517;
var statearr_18550_18602 = state_18517__$1;
(statearr_18550_18602[(2)] = false);

(statearr_18550_18602[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (3))){
var state_18517__$1 = state_18517;
var statearr_18551_18603 = state_18517__$1;
(statearr_18551_18603[(2)] = false);

(statearr_18551_18603[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (12))){
var inst_18515 = (state_18517[(2)]);
var state_18517__$1 = state_18517;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18517__$1,inst_18515);
} else {
if((state_val_18518 === (2))){
var inst_18419 = (state_18517[(8)]);
var inst_18424 = inst_18419.cljs$lang$protocol_mask$partition0$;
var inst_18425 = (inst_18424 & (64));
var inst_18426 = inst_18419.cljs$core$ISeq$;
var inst_18427 = (cljs.core.PROTOCOL_SENTINEL === inst_18426);
var inst_18428 = (inst_18425) || (inst_18427);
var state_18517__$1 = state_18517;
if(cljs.core.truth_(inst_18428)){
var statearr_18552_18604 = state_18517__$1;
(statearr_18552_18604[(1)] = (5));

} else {
var statearr_18553_18605 = state_18517__$1;
(statearr_18553_18605[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (23))){
var inst_18476 = (state_18517[(14)]);
var inst_18482 = (inst_18476 == null);
var state_18517__$1 = state_18517;
if(cljs.core.truth_(inst_18482)){
var statearr_18554_18606 = state_18517__$1;
(statearr_18554_18606[(1)] = (26));

} else {
var statearr_18555_18607 = state_18517__$1;
(statearr_18555_18607[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (35))){
var inst_18502 = (state_18517[(2)]);
var state_18517__$1 = state_18517;
if(cljs.core.truth_(inst_18502)){
var statearr_18556_18608 = state_18517__$1;
(statearr_18556_18608[(1)] = (36));

} else {
var statearr_18557_18609 = state_18517__$1;
(statearr_18557_18609[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (19))){
var inst_18444 = (state_18517[(7)]);
var inst_18464 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_18444);
var state_18517__$1 = state_18517;
var statearr_18558_18610 = state_18517__$1;
(statearr_18558_18610[(2)] = inst_18464);

(statearr_18558_18610[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (11))){
var inst_18444 = (state_18517[(7)]);
var inst_18448 = (inst_18444 == null);
var inst_18449 = cljs.core.not(inst_18448);
var state_18517__$1 = state_18517;
if(inst_18449){
var statearr_18559_18611 = state_18517__$1;
(statearr_18559_18611[(1)] = (13));

} else {
var statearr_18560_18612 = state_18517__$1;
(statearr_18560_18612[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (9))){
var inst_18419 = (state_18517[(8)]);
var state_18517__$1 = state_18517;
var statearr_18561_18613 = state_18517__$1;
(statearr_18561_18613[(2)] = inst_18419);

(statearr_18561_18613[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (5))){
var state_18517__$1 = state_18517;
var statearr_18562_18614 = state_18517__$1;
(statearr_18562_18614[(2)] = true);

(statearr_18562_18614[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (14))){
var state_18517__$1 = state_18517;
var statearr_18563_18615 = state_18517__$1;
(statearr_18563_18615[(2)] = false);

(statearr_18563_18615[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (26))){
var inst_18477 = (state_18517[(10)]);
var inst_18484 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_18477);
var state_18517__$1 = state_18517;
var statearr_18564_18616 = state_18517__$1;
(statearr_18564_18616[(2)] = inst_18484);

(statearr_18564_18616[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (16))){
var state_18517__$1 = state_18517;
var statearr_18565_18617 = state_18517__$1;
(statearr_18565_18617[(2)] = true);

(statearr_18565_18617[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (38))){
var inst_18507 = (state_18517[(2)]);
var state_18517__$1 = state_18517;
var statearr_18566_18618 = state_18517__$1;
(statearr_18566_18618[(2)] = inst_18507);

(statearr_18566_18618[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (30))){
var inst_18477 = (state_18517[(10)]);
var inst_18469 = (state_18517[(13)]);
var inst_18468 = (state_18517[(11)]);
var inst_18494 = cljs.core.empty_QMARK_(inst_18468);
var inst_18495 = (inst_18469.cljs$core$IFn$_invoke$arity$1 ? inst_18469.cljs$core$IFn$_invoke$arity$1(inst_18477) : inst_18469.call(null,inst_18477));
var inst_18496 = cljs.core.not(inst_18495);
var inst_18497 = (inst_18494) && (inst_18496);
var state_18517__$1 = state_18517;
var statearr_18567_18619 = state_18517__$1;
(statearr_18567_18619[(2)] = inst_18497);

(statearr_18567_18619[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (10))){
var inst_18419 = (state_18517[(8)]);
var inst_18440 = (state_18517[(2)]);
var inst_18441 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18440,cljs.core.cst$kw$solos);
var inst_18442 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18440,cljs.core.cst$kw$mutes);
var inst_18443 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18440,cljs.core.cst$kw$reads);
var inst_18444 = inst_18419;
var state_18517__$1 = (function (){var statearr_18568 = state_18517;
(statearr_18568[(16)] = inst_18443);

(statearr_18568[(17)] = inst_18441);

(statearr_18568[(7)] = inst_18444);

(statearr_18568[(18)] = inst_18442);

return statearr_18568;
})();
var statearr_18569_18620 = state_18517__$1;
(statearr_18569_18620[(2)] = null);

(statearr_18569_18620[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (18))){
var inst_18459 = (state_18517[(2)]);
var state_18517__$1 = state_18517;
var statearr_18570_18621 = state_18517__$1;
(statearr_18570_18621[(2)] = inst_18459);

(statearr_18570_18621[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (37))){
var state_18517__$1 = state_18517;
var statearr_18571_18622 = state_18517__$1;
(statearr_18571_18622[(2)] = null);

(statearr_18571_18622[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18518 === (8))){
var inst_18419 = (state_18517[(8)]);
var inst_18437 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_18419);
var state_18517__$1 = state_18517;
var statearr_18572_18623 = state_18517__$1;
(statearr_18572_18623[(2)] = inst_18437);

(statearr_18572_18623[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17516__auto___18577,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__17414__auto__,c__17516__auto___18577,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__17415__auto__ = null;
var cljs$core$async$mix_$_state_machine__17415__auto____0 = (function (){
var statearr_18573 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18573[(0)] = cljs$core$async$mix_$_state_machine__17415__auto__);

(statearr_18573[(1)] = (1));

return statearr_18573;
});
var cljs$core$async$mix_$_state_machine__17415__auto____1 = (function (state_18517){
while(true){
var ret_value__17416__auto__ = (function (){try{while(true){
var result__17417__auto__ = switch__17414__auto__(state_18517);
if(cljs.core.keyword_identical_QMARK_(result__17417__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17417__auto__;
}
break;
}
}catch (e18574){if((e18574 instanceof Object)){
var ex__17418__auto__ = e18574;
var statearr_18575_18624 = state_18517;
(statearr_18575_18624[(5)] = ex__17418__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18517);

return cljs.core.cst$kw$recur;
} else {
throw e18574;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17416__auto__,cljs.core.cst$kw$recur)){
var G__18625 = state_18517;
state_18517 = G__18625;
continue;
} else {
return ret_value__17416__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__17415__auto__ = function(state_18517){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__17415__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__17415__auto____1.call(this,state_18517);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__17415__auto____0;
cljs$core$async$mix_$_state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__17415__auto____1;
return cljs$core$async$mix_$_state_machine__17415__auto__;
})()
;})(switch__17414__auto__,c__17516__auto___18577,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__17518__auto__ = (function (){var statearr_18576 = (f__17517__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17517__auto__.cljs$core$IFn$_invoke$arity$0() : f__17517__auto__.call(null));
(statearr_18576[(6)] = c__17516__auto___18577);

return statearr_18576;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17518__auto__);
});})(c__17516__auto___18577,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__9541__auto__ = (((p == null))?null:p);
var m__9542__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$4 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__9542__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__9542__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__9542__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__9541__auto__ = (((p == null))?null:p);
var m__9542__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__9542__auto__.call(null,p,v,ch));
} else {
var m__9542__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__9542__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__18627 = arguments.length;
switch (G__18627) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__9541__auto__ = (((p == null))?null:p);
var m__9542__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__9542__auto__.call(null,p));
} else {
var m__9542__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__9542__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__9541__auto__ = (((p == null))?null:p);
var m__9542__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__9542__auto__.call(null,p,v));
} else {
var m__9542__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__9542__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__18631 = arguments.length;
switch (G__18631) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__8808__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__8808__auto__)){
return or__8808__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__8808__auto__,mults){
return (function (p1__18629_SHARP_){
if(cljs.core.truth_((p1__18629_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__18629_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__18629_SHARP_.call(null,topic)))){
return p1__18629_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__18629_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__8808__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async18632 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18632 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta18633){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta18633 = meta18633;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18632.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_18634,meta18633__$1){
var self__ = this;
var _18634__$1 = this;
return (new cljs.core.async.t_cljs$core$async18632(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta18633__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18632.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_18634){
var self__ = this;
var _18634__$1 = this;
return self__.meta18633;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18632.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18632.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18632.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18632.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18632.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5457__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5457__auto__)){
var m = temp__5457__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18632.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18632.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18632.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta18633], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18632.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18632.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18632";

cljs.core.async.t_cljs$core$async18632.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__9479__auto__,writer__9480__auto__,opt__9481__auto__){
return cljs.core._write(writer__9480__auto__,"cljs.core.async/t_cljs$core$async18632");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async18632 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async18632(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta18633){
return (new cljs.core.async.t_cljs$core$async18632(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta18633));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async18632(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__17516__auto___18752 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17516__auto___18752,mults,ensure_mult,p){
return (function (){
var f__17517__auto__ = (function (){var switch__17414__auto__ = ((function (c__17516__auto___18752,mults,ensure_mult,p){
return (function (state_18706){
var state_val_18707 = (state_18706[(1)]);
if((state_val_18707 === (7))){
var inst_18702 = (state_18706[(2)]);
var state_18706__$1 = state_18706;
var statearr_18708_18753 = state_18706__$1;
(statearr_18708_18753[(2)] = inst_18702);

(statearr_18708_18753[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18707 === (20))){
var state_18706__$1 = state_18706;
var statearr_18709_18754 = state_18706__$1;
(statearr_18709_18754[(2)] = null);

(statearr_18709_18754[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18707 === (1))){
var state_18706__$1 = state_18706;
var statearr_18710_18755 = state_18706__$1;
(statearr_18710_18755[(2)] = null);

(statearr_18710_18755[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18707 === (24))){
var inst_18685 = (state_18706[(7)]);
var inst_18694 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_18685);
var state_18706__$1 = state_18706;
var statearr_18711_18756 = state_18706__$1;
(statearr_18711_18756[(2)] = inst_18694);

(statearr_18711_18756[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18707 === (4))){
var inst_18637 = (state_18706[(8)]);
var inst_18637__$1 = (state_18706[(2)]);
var inst_18638 = (inst_18637__$1 == null);
var state_18706__$1 = (function (){var statearr_18712 = state_18706;
(statearr_18712[(8)] = inst_18637__$1);

return statearr_18712;
})();
if(cljs.core.truth_(inst_18638)){
var statearr_18713_18757 = state_18706__$1;
(statearr_18713_18757[(1)] = (5));

} else {
var statearr_18714_18758 = state_18706__$1;
(statearr_18714_18758[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18707 === (15))){
var inst_18679 = (state_18706[(2)]);
var state_18706__$1 = state_18706;
var statearr_18715_18759 = state_18706__$1;
(statearr_18715_18759[(2)] = inst_18679);

(statearr_18715_18759[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18707 === (21))){
var inst_18699 = (state_18706[(2)]);
var state_18706__$1 = (function (){var statearr_18716 = state_18706;
(statearr_18716[(9)] = inst_18699);

return statearr_18716;
})();
var statearr_18717_18760 = state_18706__$1;
(statearr_18717_18760[(2)] = null);

(statearr_18717_18760[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18707 === (13))){
var inst_18661 = (state_18706[(10)]);
var inst_18663 = cljs.core.chunked_seq_QMARK_(inst_18661);
var state_18706__$1 = state_18706;
if(inst_18663){
var statearr_18718_18761 = state_18706__$1;
(statearr_18718_18761[(1)] = (16));

} else {
var statearr_18719_18762 = state_18706__$1;
(statearr_18719_18762[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18707 === (22))){
var inst_18691 = (state_18706[(2)]);
var state_18706__$1 = state_18706;
if(cljs.core.truth_(inst_18691)){
var statearr_18720_18763 = state_18706__$1;
(statearr_18720_18763[(1)] = (23));

} else {
var statearr_18721_18764 = state_18706__$1;
(statearr_18721_18764[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18707 === (6))){
var inst_18685 = (state_18706[(7)]);
var inst_18637 = (state_18706[(8)]);
var inst_18687 = (state_18706[(11)]);
var inst_18685__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_18637) : topic_fn.call(null,inst_18637));
var inst_18686 = cljs.core.deref(mults);
var inst_18687__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18686,inst_18685__$1);
var state_18706__$1 = (function (){var statearr_18722 = state_18706;
(statearr_18722[(7)] = inst_18685__$1);

(statearr_18722[(11)] = inst_18687__$1);

return statearr_18722;
})();
if(cljs.core.truth_(inst_18687__$1)){
var statearr_18723_18765 = state_18706__$1;
(statearr_18723_18765[(1)] = (19));

} else {
var statearr_18724_18766 = state_18706__$1;
(statearr_18724_18766[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18707 === (25))){
var inst_18696 = (state_18706[(2)]);
var state_18706__$1 = state_18706;
var statearr_18725_18767 = state_18706__$1;
(statearr_18725_18767[(2)] = inst_18696);

(statearr_18725_18767[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18707 === (17))){
var inst_18661 = (state_18706[(10)]);
var inst_18670 = cljs.core.first(inst_18661);
var inst_18671 = cljs.core.async.muxch_STAR_(inst_18670);
var inst_18672 = cljs.core.async.close_BANG_(inst_18671);
var inst_18673 = cljs.core.next(inst_18661);
var inst_18647 = inst_18673;
var inst_18648 = null;
var inst_18649 = (0);
var inst_18650 = (0);
var state_18706__$1 = (function (){var statearr_18726 = state_18706;
(statearr_18726[(12)] = inst_18649);

(statearr_18726[(13)] = inst_18672);

(statearr_18726[(14)] = inst_18648);

(statearr_18726[(15)] = inst_18647);

(statearr_18726[(16)] = inst_18650);

return statearr_18726;
})();
var statearr_18727_18768 = state_18706__$1;
(statearr_18727_18768[(2)] = null);

(statearr_18727_18768[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18707 === (3))){
var inst_18704 = (state_18706[(2)]);
var state_18706__$1 = state_18706;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18706__$1,inst_18704);
} else {
if((state_val_18707 === (12))){
var inst_18681 = (state_18706[(2)]);
var state_18706__$1 = state_18706;
var statearr_18728_18769 = state_18706__$1;
(statearr_18728_18769[(2)] = inst_18681);

(statearr_18728_18769[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18707 === (2))){
var state_18706__$1 = state_18706;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18706__$1,(4),ch);
} else {
if((state_val_18707 === (23))){
var state_18706__$1 = state_18706;
var statearr_18729_18770 = state_18706__$1;
(statearr_18729_18770[(2)] = null);

(statearr_18729_18770[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18707 === (19))){
var inst_18637 = (state_18706[(8)]);
var inst_18687 = (state_18706[(11)]);
var inst_18689 = cljs.core.async.muxch_STAR_(inst_18687);
var state_18706__$1 = state_18706;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18706__$1,(22),inst_18689,inst_18637);
} else {
if((state_val_18707 === (11))){
var inst_18661 = (state_18706[(10)]);
var inst_18647 = (state_18706[(15)]);
var inst_18661__$1 = cljs.core.seq(inst_18647);
var state_18706__$1 = (function (){var statearr_18730 = state_18706;
(statearr_18730[(10)] = inst_18661__$1);

return statearr_18730;
})();
if(inst_18661__$1){
var statearr_18731_18771 = state_18706__$1;
(statearr_18731_18771[(1)] = (13));

} else {
var statearr_18732_18772 = state_18706__$1;
(statearr_18732_18772[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18707 === (9))){
var inst_18683 = (state_18706[(2)]);
var state_18706__$1 = state_18706;
var statearr_18733_18773 = state_18706__$1;
(statearr_18733_18773[(2)] = inst_18683);

(statearr_18733_18773[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18707 === (5))){
var inst_18644 = cljs.core.deref(mults);
var inst_18645 = cljs.core.vals(inst_18644);
var inst_18646 = cljs.core.seq(inst_18645);
var inst_18647 = inst_18646;
var inst_18648 = null;
var inst_18649 = (0);
var inst_18650 = (0);
var state_18706__$1 = (function (){var statearr_18734 = state_18706;
(statearr_18734[(12)] = inst_18649);

(statearr_18734[(14)] = inst_18648);

(statearr_18734[(15)] = inst_18647);

(statearr_18734[(16)] = inst_18650);

return statearr_18734;
})();
var statearr_18735_18774 = state_18706__$1;
(statearr_18735_18774[(2)] = null);

(statearr_18735_18774[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18707 === (14))){
var state_18706__$1 = state_18706;
var statearr_18739_18775 = state_18706__$1;
(statearr_18739_18775[(2)] = null);

(statearr_18739_18775[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18707 === (16))){
var inst_18661 = (state_18706[(10)]);
var inst_18665 = cljs.core.chunk_first(inst_18661);
var inst_18666 = cljs.core.chunk_rest(inst_18661);
var inst_18667 = cljs.core.count(inst_18665);
var inst_18647 = inst_18666;
var inst_18648 = inst_18665;
var inst_18649 = inst_18667;
var inst_18650 = (0);
var state_18706__$1 = (function (){var statearr_18740 = state_18706;
(statearr_18740[(12)] = inst_18649);

(statearr_18740[(14)] = inst_18648);

(statearr_18740[(15)] = inst_18647);

(statearr_18740[(16)] = inst_18650);

return statearr_18740;
})();
var statearr_18741_18776 = state_18706__$1;
(statearr_18741_18776[(2)] = null);

(statearr_18741_18776[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18707 === (10))){
var inst_18649 = (state_18706[(12)]);
var inst_18648 = (state_18706[(14)]);
var inst_18647 = (state_18706[(15)]);
var inst_18650 = (state_18706[(16)]);
var inst_18655 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_18648,inst_18650);
var inst_18656 = cljs.core.async.muxch_STAR_(inst_18655);
var inst_18657 = cljs.core.async.close_BANG_(inst_18656);
var inst_18658 = (inst_18650 + (1));
var tmp18736 = inst_18649;
var tmp18737 = inst_18648;
var tmp18738 = inst_18647;
var inst_18647__$1 = tmp18738;
var inst_18648__$1 = tmp18737;
var inst_18649__$1 = tmp18736;
var inst_18650__$1 = inst_18658;
var state_18706__$1 = (function (){var statearr_18742 = state_18706;
(statearr_18742[(12)] = inst_18649__$1);

(statearr_18742[(17)] = inst_18657);

(statearr_18742[(14)] = inst_18648__$1);

(statearr_18742[(15)] = inst_18647__$1);

(statearr_18742[(16)] = inst_18650__$1);

return statearr_18742;
})();
var statearr_18743_18777 = state_18706__$1;
(statearr_18743_18777[(2)] = null);

(statearr_18743_18777[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18707 === (18))){
var inst_18676 = (state_18706[(2)]);
var state_18706__$1 = state_18706;
var statearr_18744_18778 = state_18706__$1;
(statearr_18744_18778[(2)] = inst_18676);

(statearr_18744_18778[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18707 === (8))){
var inst_18649 = (state_18706[(12)]);
var inst_18650 = (state_18706[(16)]);
var inst_18652 = (inst_18650 < inst_18649);
var inst_18653 = inst_18652;
var state_18706__$1 = state_18706;
if(cljs.core.truth_(inst_18653)){
var statearr_18745_18779 = state_18706__$1;
(statearr_18745_18779[(1)] = (10));

} else {
var statearr_18746_18780 = state_18706__$1;
(statearr_18746_18780[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17516__auto___18752,mults,ensure_mult,p))
;
return ((function (switch__17414__auto__,c__17516__auto___18752,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__17415__auto__ = null;
var cljs$core$async$state_machine__17415__auto____0 = (function (){
var statearr_18747 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18747[(0)] = cljs$core$async$state_machine__17415__auto__);

(statearr_18747[(1)] = (1));

return statearr_18747;
});
var cljs$core$async$state_machine__17415__auto____1 = (function (state_18706){
while(true){
var ret_value__17416__auto__ = (function (){try{while(true){
var result__17417__auto__ = switch__17414__auto__(state_18706);
if(cljs.core.keyword_identical_QMARK_(result__17417__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17417__auto__;
}
break;
}
}catch (e18748){if((e18748 instanceof Object)){
var ex__17418__auto__ = e18748;
var statearr_18749_18781 = state_18706;
(statearr_18749_18781[(5)] = ex__17418__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18706);

return cljs.core.cst$kw$recur;
} else {
throw e18748;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17416__auto__,cljs.core.cst$kw$recur)){
var G__18782 = state_18706;
state_18706 = G__18782;
continue;
} else {
return ret_value__17416__auto__;
}
break;
}
});
cljs$core$async$state_machine__17415__auto__ = function(state_18706){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17415__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17415__auto____1.call(this,state_18706);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17415__auto____0;
cljs$core$async$state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17415__auto____1;
return cljs$core$async$state_machine__17415__auto__;
})()
;})(switch__17414__auto__,c__17516__auto___18752,mults,ensure_mult,p))
})();
var state__17518__auto__ = (function (){var statearr_18750 = (f__17517__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17517__auto__.cljs$core$IFn$_invoke$arity$0() : f__17517__auto__.call(null));
(statearr_18750[(6)] = c__17516__auto___18752);

return statearr_18750;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17518__auto__);
});})(c__17516__auto___18752,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__18784 = arguments.length;
switch (G__18784) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__18787 = arguments.length;
switch (G__18787) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__18790 = arguments.length;
switch (G__18790) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__17516__auto___18857 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17516__auto___18857,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__17517__auto__ = (function (){var switch__17414__auto__ = ((function (c__17516__auto___18857,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_18829){
var state_val_18830 = (state_18829[(1)]);
if((state_val_18830 === (7))){
var state_18829__$1 = state_18829;
var statearr_18831_18858 = state_18829__$1;
(statearr_18831_18858[(2)] = null);

(statearr_18831_18858[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18830 === (1))){
var state_18829__$1 = state_18829;
var statearr_18832_18859 = state_18829__$1;
(statearr_18832_18859[(2)] = null);

(statearr_18832_18859[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18830 === (4))){
var inst_18793 = (state_18829[(7)]);
var inst_18795 = (inst_18793 < cnt);
var state_18829__$1 = state_18829;
if(cljs.core.truth_(inst_18795)){
var statearr_18833_18860 = state_18829__$1;
(statearr_18833_18860[(1)] = (6));

} else {
var statearr_18834_18861 = state_18829__$1;
(statearr_18834_18861[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18830 === (15))){
var inst_18825 = (state_18829[(2)]);
var state_18829__$1 = state_18829;
var statearr_18835_18862 = state_18829__$1;
(statearr_18835_18862[(2)] = inst_18825);

(statearr_18835_18862[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18830 === (13))){
var inst_18818 = cljs.core.async.close_BANG_(out);
var state_18829__$1 = state_18829;
var statearr_18836_18863 = state_18829__$1;
(statearr_18836_18863[(2)] = inst_18818);

(statearr_18836_18863[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18830 === (6))){
var state_18829__$1 = state_18829;
var statearr_18837_18864 = state_18829__$1;
(statearr_18837_18864[(2)] = null);

(statearr_18837_18864[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18830 === (3))){
var inst_18827 = (state_18829[(2)]);
var state_18829__$1 = state_18829;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18829__$1,inst_18827);
} else {
if((state_val_18830 === (12))){
var inst_18815 = (state_18829[(8)]);
var inst_18815__$1 = (state_18829[(2)]);
var inst_18816 = cljs.core.some(cljs.core.nil_QMARK_,inst_18815__$1);
var state_18829__$1 = (function (){var statearr_18838 = state_18829;
(statearr_18838[(8)] = inst_18815__$1);

return statearr_18838;
})();
if(cljs.core.truth_(inst_18816)){
var statearr_18839_18865 = state_18829__$1;
(statearr_18839_18865[(1)] = (13));

} else {
var statearr_18840_18866 = state_18829__$1;
(statearr_18840_18866[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18830 === (2))){
var inst_18792 = cljs.core.reset_BANG_(dctr,cnt);
var inst_18793 = (0);
var state_18829__$1 = (function (){var statearr_18841 = state_18829;
(statearr_18841[(7)] = inst_18793);

(statearr_18841[(9)] = inst_18792);

return statearr_18841;
})();
var statearr_18842_18867 = state_18829__$1;
(statearr_18842_18867[(2)] = null);

(statearr_18842_18867[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18830 === (11))){
var inst_18793 = (state_18829[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_18829,(10),Object,null,(9));
var inst_18802 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_18793) : chs__$1.call(null,inst_18793));
var inst_18803 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_18793) : done.call(null,inst_18793));
var inst_18804 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_18802,inst_18803);
var state_18829__$1 = state_18829;
var statearr_18843_18868 = state_18829__$1;
(statearr_18843_18868[(2)] = inst_18804);


cljs.core.async.impl.ioc_helpers.process_exception(state_18829__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_18830 === (9))){
var inst_18793 = (state_18829[(7)]);
var inst_18806 = (state_18829[(2)]);
var inst_18807 = (inst_18793 + (1));
var inst_18793__$1 = inst_18807;
var state_18829__$1 = (function (){var statearr_18844 = state_18829;
(statearr_18844[(7)] = inst_18793__$1);

(statearr_18844[(10)] = inst_18806);

return statearr_18844;
})();
var statearr_18845_18869 = state_18829__$1;
(statearr_18845_18869[(2)] = null);

(statearr_18845_18869[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18830 === (5))){
var inst_18813 = (state_18829[(2)]);
var state_18829__$1 = (function (){var statearr_18846 = state_18829;
(statearr_18846[(11)] = inst_18813);

return statearr_18846;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18829__$1,(12),dchan);
} else {
if((state_val_18830 === (14))){
var inst_18815 = (state_18829[(8)]);
var inst_18820 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_18815);
var state_18829__$1 = state_18829;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18829__$1,(16),out,inst_18820);
} else {
if((state_val_18830 === (16))){
var inst_18822 = (state_18829[(2)]);
var state_18829__$1 = (function (){var statearr_18847 = state_18829;
(statearr_18847[(12)] = inst_18822);

return statearr_18847;
})();
var statearr_18848_18870 = state_18829__$1;
(statearr_18848_18870[(2)] = null);

(statearr_18848_18870[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18830 === (10))){
var inst_18797 = (state_18829[(2)]);
var inst_18798 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_18829__$1 = (function (){var statearr_18849 = state_18829;
(statearr_18849[(13)] = inst_18797);

return statearr_18849;
})();
var statearr_18850_18871 = state_18829__$1;
(statearr_18850_18871[(2)] = inst_18798);


cljs.core.async.impl.ioc_helpers.process_exception(state_18829__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_18830 === (8))){
var inst_18811 = (state_18829[(2)]);
var state_18829__$1 = state_18829;
var statearr_18851_18872 = state_18829__$1;
(statearr_18851_18872[(2)] = inst_18811);

(statearr_18851_18872[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17516__auto___18857,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__17414__auto__,c__17516__auto___18857,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__17415__auto__ = null;
var cljs$core$async$state_machine__17415__auto____0 = (function (){
var statearr_18852 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18852[(0)] = cljs$core$async$state_machine__17415__auto__);

(statearr_18852[(1)] = (1));

return statearr_18852;
});
var cljs$core$async$state_machine__17415__auto____1 = (function (state_18829){
while(true){
var ret_value__17416__auto__ = (function (){try{while(true){
var result__17417__auto__ = switch__17414__auto__(state_18829);
if(cljs.core.keyword_identical_QMARK_(result__17417__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17417__auto__;
}
break;
}
}catch (e18853){if((e18853 instanceof Object)){
var ex__17418__auto__ = e18853;
var statearr_18854_18873 = state_18829;
(statearr_18854_18873[(5)] = ex__17418__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18829);

return cljs.core.cst$kw$recur;
} else {
throw e18853;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17416__auto__,cljs.core.cst$kw$recur)){
var G__18874 = state_18829;
state_18829 = G__18874;
continue;
} else {
return ret_value__17416__auto__;
}
break;
}
});
cljs$core$async$state_machine__17415__auto__ = function(state_18829){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17415__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17415__auto____1.call(this,state_18829);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17415__auto____0;
cljs$core$async$state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17415__auto____1;
return cljs$core$async$state_machine__17415__auto__;
})()
;})(switch__17414__auto__,c__17516__auto___18857,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__17518__auto__ = (function (){var statearr_18855 = (f__17517__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17517__auto__.cljs$core$IFn$_invoke$arity$0() : f__17517__auto__.call(null));
(statearr_18855[(6)] = c__17516__auto___18857);

return statearr_18855;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17518__auto__);
});})(c__17516__auto___18857,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__18877 = arguments.length;
switch (G__18877) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17516__auto___18931 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17516__auto___18931,out){
return (function (){
var f__17517__auto__ = (function (){var switch__17414__auto__ = ((function (c__17516__auto___18931,out){
return (function (state_18909){
var state_val_18910 = (state_18909[(1)]);
if((state_val_18910 === (7))){
var inst_18888 = (state_18909[(7)]);
var inst_18889 = (state_18909[(8)]);
var inst_18888__$1 = (state_18909[(2)]);
var inst_18889__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18888__$1,(0),null);
var inst_18890 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18888__$1,(1),null);
var inst_18891 = (inst_18889__$1 == null);
var state_18909__$1 = (function (){var statearr_18911 = state_18909;
(statearr_18911[(9)] = inst_18890);

(statearr_18911[(7)] = inst_18888__$1);

(statearr_18911[(8)] = inst_18889__$1);

return statearr_18911;
})();
if(cljs.core.truth_(inst_18891)){
var statearr_18912_18932 = state_18909__$1;
(statearr_18912_18932[(1)] = (8));

} else {
var statearr_18913_18933 = state_18909__$1;
(statearr_18913_18933[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18910 === (1))){
var inst_18878 = cljs.core.vec(chs);
var inst_18879 = inst_18878;
var state_18909__$1 = (function (){var statearr_18914 = state_18909;
(statearr_18914[(10)] = inst_18879);

return statearr_18914;
})();
var statearr_18915_18934 = state_18909__$1;
(statearr_18915_18934[(2)] = null);

(statearr_18915_18934[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18910 === (4))){
var inst_18879 = (state_18909[(10)]);
var state_18909__$1 = state_18909;
return cljs.core.async.ioc_alts_BANG_(state_18909__$1,(7),inst_18879);
} else {
if((state_val_18910 === (6))){
var inst_18905 = (state_18909[(2)]);
var state_18909__$1 = state_18909;
var statearr_18916_18935 = state_18909__$1;
(statearr_18916_18935[(2)] = inst_18905);

(statearr_18916_18935[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18910 === (3))){
var inst_18907 = (state_18909[(2)]);
var state_18909__$1 = state_18909;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18909__$1,inst_18907);
} else {
if((state_val_18910 === (2))){
var inst_18879 = (state_18909[(10)]);
var inst_18881 = cljs.core.count(inst_18879);
var inst_18882 = (inst_18881 > (0));
var state_18909__$1 = state_18909;
if(cljs.core.truth_(inst_18882)){
var statearr_18918_18936 = state_18909__$1;
(statearr_18918_18936[(1)] = (4));

} else {
var statearr_18919_18937 = state_18909__$1;
(statearr_18919_18937[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18910 === (11))){
var inst_18879 = (state_18909[(10)]);
var inst_18898 = (state_18909[(2)]);
var tmp18917 = inst_18879;
var inst_18879__$1 = tmp18917;
var state_18909__$1 = (function (){var statearr_18920 = state_18909;
(statearr_18920[(11)] = inst_18898);

(statearr_18920[(10)] = inst_18879__$1);

return statearr_18920;
})();
var statearr_18921_18938 = state_18909__$1;
(statearr_18921_18938[(2)] = null);

(statearr_18921_18938[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18910 === (9))){
var inst_18889 = (state_18909[(8)]);
var state_18909__$1 = state_18909;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18909__$1,(11),out,inst_18889);
} else {
if((state_val_18910 === (5))){
var inst_18903 = cljs.core.async.close_BANG_(out);
var state_18909__$1 = state_18909;
var statearr_18922_18939 = state_18909__$1;
(statearr_18922_18939[(2)] = inst_18903);

(statearr_18922_18939[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18910 === (10))){
var inst_18901 = (state_18909[(2)]);
var state_18909__$1 = state_18909;
var statearr_18923_18940 = state_18909__$1;
(statearr_18923_18940[(2)] = inst_18901);

(statearr_18923_18940[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18910 === (8))){
var inst_18890 = (state_18909[(9)]);
var inst_18888 = (state_18909[(7)]);
var inst_18879 = (state_18909[(10)]);
var inst_18889 = (state_18909[(8)]);
var inst_18893 = (function (){var cs = inst_18879;
var vec__18884 = inst_18888;
var v = inst_18889;
var c = inst_18890;
return ((function (cs,vec__18884,v,c,inst_18890,inst_18888,inst_18879,inst_18889,state_val_18910,c__17516__auto___18931,out){
return (function (p1__18875_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__18875_SHARP_);
});
;})(cs,vec__18884,v,c,inst_18890,inst_18888,inst_18879,inst_18889,state_val_18910,c__17516__auto___18931,out))
})();
var inst_18894 = cljs.core.filterv(inst_18893,inst_18879);
var inst_18879__$1 = inst_18894;
var state_18909__$1 = (function (){var statearr_18924 = state_18909;
(statearr_18924[(10)] = inst_18879__$1);

return statearr_18924;
})();
var statearr_18925_18941 = state_18909__$1;
(statearr_18925_18941[(2)] = null);

(statearr_18925_18941[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__17516__auto___18931,out))
;
return ((function (switch__17414__auto__,c__17516__auto___18931,out){
return (function() {
var cljs$core$async$state_machine__17415__auto__ = null;
var cljs$core$async$state_machine__17415__auto____0 = (function (){
var statearr_18926 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18926[(0)] = cljs$core$async$state_machine__17415__auto__);

(statearr_18926[(1)] = (1));

return statearr_18926;
});
var cljs$core$async$state_machine__17415__auto____1 = (function (state_18909){
while(true){
var ret_value__17416__auto__ = (function (){try{while(true){
var result__17417__auto__ = switch__17414__auto__(state_18909);
if(cljs.core.keyword_identical_QMARK_(result__17417__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17417__auto__;
}
break;
}
}catch (e18927){if((e18927 instanceof Object)){
var ex__17418__auto__ = e18927;
var statearr_18928_18942 = state_18909;
(statearr_18928_18942[(5)] = ex__17418__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18909);

return cljs.core.cst$kw$recur;
} else {
throw e18927;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17416__auto__,cljs.core.cst$kw$recur)){
var G__18943 = state_18909;
state_18909 = G__18943;
continue;
} else {
return ret_value__17416__auto__;
}
break;
}
});
cljs$core$async$state_machine__17415__auto__ = function(state_18909){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17415__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17415__auto____1.call(this,state_18909);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17415__auto____0;
cljs$core$async$state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17415__auto____1;
return cljs$core$async$state_machine__17415__auto__;
})()
;})(switch__17414__auto__,c__17516__auto___18931,out))
})();
var state__17518__auto__ = (function (){var statearr_18929 = (f__17517__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17517__auto__.cljs$core$IFn$_invoke$arity$0() : f__17517__auto__.call(null));
(statearr_18929[(6)] = c__17516__auto___18931);

return statearr_18929;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17518__auto__);
});})(c__17516__auto___18931,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__18945 = arguments.length;
switch (G__18945) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17516__auto___18990 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17516__auto___18990,out){
return (function (){
var f__17517__auto__ = (function (){var switch__17414__auto__ = ((function (c__17516__auto___18990,out){
return (function (state_18969){
var state_val_18970 = (state_18969[(1)]);
if((state_val_18970 === (7))){
var inst_18951 = (state_18969[(7)]);
var inst_18951__$1 = (state_18969[(2)]);
var inst_18952 = (inst_18951__$1 == null);
var inst_18953 = cljs.core.not(inst_18952);
var state_18969__$1 = (function (){var statearr_18971 = state_18969;
(statearr_18971[(7)] = inst_18951__$1);

return statearr_18971;
})();
if(inst_18953){
var statearr_18972_18991 = state_18969__$1;
(statearr_18972_18991[(1)] = (8));

} else {
var statearr_18973_18992 = state_18969__$1;
(statearr_18973_18992[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18970 === (1))){
var inst_18946 = (0);
var state_18969__$1 = (function (){var statearr_18974 = state_18969;
(statearr_18974[(8)] = inst_18946);

return statearr_18974;
})();
var statearr_18975_18993 = state_18969__$1;
(statearr_18975_18993[(2)] = null);

(statearr_18975_18993[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18970 === (4))){
var state_18969__$1 = state_18969;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18969__$1,(7),ch);
} else {
if((state_val_18970 === (6))){
var inst_18964 = (state_18969[(2)]);
var state_18969__$1 = state_18969;
var statearr_18976_18994 = state_18969__$1;
(statearr_18976_18994[(2)] = inst_18964);

(statearr_18976_18994[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18970 === (3))){
var inst_18966 = (state_18969[(2)]);
var inst_18967 = cljs.core.async.close_BANG_(out);
var state_18969__$1 = (function (){var statearr_18977 = state_18969;
(statearr_18977[(9)] = inst_18966);

return statearr_18977;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_18969__$1,inst_18967);
} else {
if((state_val_18970 === (2))){
var inst_18946 = (state_18969[(8)]);
var inst_18948 = (inst_18946 < n);
var state_18969__$1 = state_18969;
if(cljs.core.truth_(inst_18948)){
var statearr_18978_18995 = state_18969__$1;
(statearr_18978_18995[(1)] = (4));

} else {
var statearr_18979_18996 = state_18969__$1;
(statearr_18979_18996[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18970 === (11))){
var inst_18946 = (state_18969[(8)]);
var inst_18956 = (state_18969[(2)]);
var inst_18957 = (inst_18946 + (1));
var inst_18946__$1 = inst_18957;
var state_18969__$1 = (function (){var statearr_18980 = state_18969;
(statearr_18980[(8)] = inst_18946__$1);

(statearr_18980[(10)] = inst_18956);

return statearr_18980;
})();
var statearr_18981_18997 = state_18969__$1;
(statearr_18981_18997[(2)] = null);

(statearr_18981_18997[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18970 === (9))){
var state_18969__$1 = state_18969;
var statearr_18982_18998 = state_18969__$1;
(statearr_18982_18998[(2)] = null);

(statearr_18982_18998[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18970 === (5))){
var state_18969__$1 = state_18969;
var statearr_18983_18999 = state_18969__$1;
(statearr_18983_18999[(2)] = null);

(statearr_18983_18999[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18970 === (10))){
var inst_18961 = (state_18969[(2)]);
var state_18969__$1 = state_18969;
var statearr_18984_19000 = state_18969__$1;
(statearr_18984_19000[(2)] = inst_18961);

(statearr_18984_19000[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18970 === (8))){
var inst_18951 = (state_18969[(7)]);
var state_18969__$1 = state_18969;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18969__$1,(11),out,inst_18951);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__17516__auto___18990,out))
;
return ((function (switch__17414__auto__,c__17516__auto___18990,out){
return (function() {
var cljs$core$async$state_machine__17415__auto__ = null;
var cljs$core$async$state_machine__17415__auto____0 = (function (){
var statearr_18985 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18985[(0)] = cljs$core$async$state_machine__17415__auto__);

(statearr_18985[(1)] = (1));

return statearr_18985;
});
var cljs$core$async$state_machine__17415__auto____1 = (function (state_18969){
while(true){
var ret_value__17416__auto__ = (function (){try{while(true){
var result__17417__auto__ = switch__17414__auto__(state_18969);
if(cljs.core.keyword_identical_QMARK_(result__17417__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17417__auto__;
}
break;
}
}catch (e18986){if((e18986 instanceof Object)){
var ex__17418__auto__ = e18986;
var statearr_18987_19001 = state_18969;
(statearr_18987_19001[(5)] = ex__17418__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18969);

return cljs.core.cst$kw$recur;
} else {
throw e18986;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17416__auto__,cljs.core.cst$kw$recur)){
var G__19002 = state_18969;
state_18969 = G__19002;
continue;
} else {
return ret_value__17416__auto__;
}
break;
}
});
cljs$core$async$state_machine__17415__auto__ = function(state_18969){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17415__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17415__auto____1.call(this,state_18969);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17415__auto____0;
cljs$core$async$state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17415__auto____1;
return cljs$core$async$state_machine__17415__auto__;
})()
;})(switch__17414__auto__,c__17516__auto___18990,out))
})();
var state__17518__auto__ = (function (){var statearr_18988 = (f__17517__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17517__auto__.cljs$core$IFn$_invoke$arity$0() : f__17517__auto__.call(null));
(statearr_18988[(6)] = c__17516__auto___18990);

return statearr_18988;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17518__auto__);
});})(c__17516__auto___18990,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19004 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19004 = (function (f,ch,meta19005){
this.f = f;
this.ch = ch;
this.meta19005 = meta19005;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async19004.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19006,meta19005__$1){
var self__ = this;
var _19006__$1 = this;
return (new cljs.core.async.t_cljs$core$async19004(self__.f,self__.ch,meta19005__$1));
});

cljs.core.async.t_cljs$core$async19004.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19006){
var self__ = this;
var _19006__$1 = this;
return self__.meta19005;
});

cljs.core.async.t_cljs$core$async19004.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19004.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async19004.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async19004.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19004.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async19007 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19007 = (function (f,ch,meta19005,_,fn1,meta19008){
this.f = f;
this.ch = ch;
this.meta19005 = meta19005;
this._ = _;
this.fn1 = fn1;
this.meta19008 = meta19008;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async19007.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_19009,meta19008__$1){
var self__ = this;
var _19009__$1 = this;
return (new cljs.core.async.t_cljs$core$async19007(self__.f,self__.ch,self__.meta19005,self__._,self__.fn1,meta19008__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async19007.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_19009){
var self__ = this;
var _19009__$1 = this;
return self__.meta19008;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19007.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19007.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19007.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19007.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__19003_SHARP_){
var G__19010 = (((p1__19003_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__19003_SHARP_) : self__.f.call(null,p1__19003_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__19010) : f1.call(null,G__19010));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async19007.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta19005,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async19004], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta19008], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19007.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19007.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19007";

cljs.core.async.t_cljs$core$async19007.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__9479__auto__,writer__9480__auto__,opt__9481__auto__){
return cljs.core._write(writer__9480__auto__,"cljs.core.async/t_cljs$core$async19007");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async19007 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19007(f__$1,ch__$1,meta19005__$1,___$2,fn1__$1,meta19008){
return (new cljs.core.async.t_cljs$core$async19007(f__$1,ch__$1,meta19005__$1,___$2,fn1__$1,meta19008));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async19007(self__.f,self__.ch,self__.meta19005,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__8796__auto__ = ret;
if(cljs.core.truth_(and__8796__auto__)){
return !((cljs.core.deref(ret) == null));
} else {
return and__8796__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__19011 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__19011) : self__.f.call(null,G__19011));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async19004.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19004.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async19004.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta19005], null);
});

cljs.core.async.t_cljs$core$async19004.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19004.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19004";

cljs.core.async.t_cljs$core$async19004.cljs$lang$ctorPrWriter = (function (this__9479__auto__,writer__9480__auto__,opt__9481__auto__){
return cljs.core._write(writer__9480__auto__,"cljs.core.async/t_cljs$core$async19004");
});

cljs.core.async.__GT_t_cljs$core$async19004 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19004(f__$1,ch__$1,meta19005){
return (new cljs.core.async.t_cljs$core$async19004(f__$1,ch__$1,meta19005));
});

}

return (new cljs.core.async.t_cljs$core$async19004(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19012 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19012 = (function (f,ch,meta19013){
this.f = f;
this.ch = ch;
this.meta19013 = meta19013;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async19012.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19014,meta19013__$1){
var self__ = this;
var _19014__$1 = this;
return (new cljs.core.async.t_cljs$core$async19012(self__.f,self__.ch,meta19013__$1));
});

cljs.core.async.t_cljs$core$async19012.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19014){
var self__ = this;
var _19014__$1 = this;
return self__.meta19013;
});

cljs.core.async.t_cljs$core$async19012.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19012.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async19012.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19012.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19012.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19012.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async19012.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta19013], null);
});

cljs.core.async.t_cljs$core$async19012.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19012.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19012";

cljs.core.async.t_cljs$core$async19012.cljs$lang$ctorPrWriter = (function (this__9479__auto__,writer__9480__auto__,opt__9481__auto__){
return cljs.core._write(writer__9480__auto__,"cljs.core.async/t_cljs$core$async19012");
});

cljs.core.async.__GT_t_cljs$core$async19012 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async19012(f__$1,ch__$1,meta19013){
return (new cljs.core.async.t_cljs$core$async19012(f__$1,ch__$1,meta19013));
});

}

return (new cljs.core.async.t_cljs$core$async19012(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async19015 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19015 = (function (p,ch,meta19016){
this.p = p;
this.ch = ch;
this.meta19016 = meta19016;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async19015.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19017,meta19016__$1){
var self__ = this;
var _19017__$1 = this;
return (new cljs.core.async.t_cljs$core$async19015(self__.p,self__.ch,meta19016__$1));
});

cljs.core.async.t_cljs$core$async19015.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19017){
var self__ = this;
var _19017__$1 = this;
return self__.meta19016;
});

cljs.core.async.t_cljs$core$async19015.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19015.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async19015.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async19015.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19015.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19015.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19015.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async19015.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta19016], null);
});

cljs.core.async.t_cljs$core$async19015.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19015.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19015";

cljs.core.async.t_cljs$core$async19015.cljs$lang$ctorPrWriter = (function (this__9479__auto__,writer__9480__auto__,opt__9481__auto__){
return cljs.core._write(writer__9480__auto__,"cljs.core.async/t_cljs$core$async19015");
});

cljs.core.async.__GT_t_cljs$core$async19015 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async19015(p__$1,ch__$1,meta19016){
return (new cljs.core.async.t_cljs$core$async19015(p__$1,ch__$1,meta19016));
});

}

return (new cljs.core.async.t_cljs$core$async19015(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__19019 = arguments.length;
switch (G__19019) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17516__auto___19059 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17516__auto___19059,out){
return (function (){
var f__17517__auto__ = (function (){var switch__17414__auto__ = ((function (c__17516__auto___19059,out){
return (function (state_19040){
var state_val_19041 = (state_19040[(1)]);
if((state_val_19041 === (7))){
var inst_19036 = (state_19040[(2)]);
var state_19040__$1 = state_19040;
var statearr_19042_19060 = state_19040__$1;
(statearr_19042_19060[(2)] = inst_19036);

(statearr_19042_19060[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19041 === (1))){
var state_19040__$1 = state_19040;
var statearr_19043_19061 = state_19040__$1;
(statearr_19043_19061[(2)] = null);

(statearr_19043_19061[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19041 === (4))){
var inst_19022 = (state_19040[(7)]);
var inst_19022__$1 = (state_19040[(2)]);
var inst_19023 = (inst_19022__$1 == null);
var state_19040__$1 = (function (){var statearr_19044 = state_19040;
(statearr_19044[(7)] = inst_19022__$1);

return statearr_19044;
})();
if(cljs.core.truth_(inst_19023)){
var statearr_19045_19062 = state_19040__$1;
(statearr_19045_19062[(1)] = (5));

} else {
var statearr_19046_19063 = state_19040__$1;
(statearr_19046_19063[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19041 === (6))){
var inst_19022 = (state_19040[(7)]);
var inst_19027 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_19022) : p.call(null,inst_19022));
var state_19040__$1 = state_19040;
if(cljs.core.truth_(inst_19027)){
var statearr_19047_19064 = state_19040__$1;
(statearr_19047_19064[(1)] = (8));

} else {
var statearr_19048_19065 = state_19040__$1;
(statearr_19048_19065[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19041 === (3))){
var inst_19038 = (state_19040[(2)]);
var state_19040__$1 = state_19040;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19040__$1,inst_19038);
} else {
if((state_val_19041 === (2))){
var state_19040__$1 = state_19040;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19040__$1,(4),ch);
} else {
if((state_val_19041 === (11))){
var inst_19030 = (state_19040[(2)]);
var state_19040__$1 = state_19040;
var statearr_19049_19066 = state_19040__$1;
(statearr_19049_19066[(2)] = inst_19030);

(statearr_19049_19066[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19041 === (9))){
var state_19040__$1 = state_19040;
var statearr_19050_19067 = state_19040__$1;
(statearr_19050_19067[(2)] = null);

(statearr_19050_19067[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19041 === (5))){
var inst_19025 = cljs.core.async.close_BANG_(out);
var state_19040__$1 = state_19040;
var statearr_19051_19068 = state_19040__$1;
(statearr_19051_19068[(2)] = inst_19025);

(statearr_19051_19068[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19041 === (10))){
var inst_19033 = (state_19040[(2)]);
var state_19040__$1 = (function (){var statearr_19052 = state_19040;
(statearr_19052[(8)] = inst_19033);

return statearr_19052;
})();
var statearr_19053_19069 = state_19040__$1;
(statearr_19053_19069[(2)] = null);

(statearr_19053_19069[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19041 === (8))){
var inst_19022 = (state_19040[(7)]);
var state_19040__$1 = state_19040;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19040__$1,(11),out,inst_19022);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__17516__auto___19059,out))
;
return ((function (switch__17414__auto__,c__17516__auto___19059,out){
return (function() {
var cljs$core$async$state_machine__17415__auto__ = null;
var cljs$core$async$state_machine__17415__auto____0 = (function (){
var statearr_19054 = [null,null,null,null,null,null,null,null,null];
(statearr_19054[(0)] = cljs$core$async$state_machine__17415__auto__);

(statearr_19054[(1)] = (1));

return statearr_19054;
});
var cljs$core$async$state_machine__17415__auto____1 = (function (state_19040){
while(true){
var ret_value__17416__auto__ = (function (){try{while(true){
var result__17417__auto__ = switch__17414__auto__(state_19040);
if(cljs.core.keyword_identical_QMARK_(result__17417__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17417__auto__;
}
break;
}
}catch (e19055){if((e19055 instanceof Object)){
var ex__17418__auto__ = e19055;
var statearr_19056_19070 = state_19040;
(statearr_19056_19070[(5)] = ex__17418__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19040);

return cljs.core.cst$kw$recur;
} else {
throw e19055;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17416__auto__,cljs.core.cst$kw$recur)){
var G__19071 = state_19040;
state_19040 = G__19071;
continue;
} else {
return ret_value__17416__auto__;
}
break;
}
});
cljs$core$async$state_machine__17415__auto__ = function(state_19040){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17415__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17415__auto____1.call(this,state_19040);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17415__auto____0;
cljs$core$async$state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17415__auto____1;
return cljs$core$async$state_machine__17415__auto__;
})()
;})(switch__17414__auto__,c__17516__auto___19059,out))
})();
var state__17518__auto__ = (function (){var statearr_19057 = (f__17517__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17517__auto__.cljs$core$IFn$_invoke$arity$0() : f__17517__auto__.call(null));
(statearr_19057[(6)] = c__17516__auto___19059);

return statearr_19057;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17518__auto__);
});})(c__17516__auto___19059,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__19073 = arguments.length;
switch (G__19073) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__17516__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17516__auto__){
return (function (){
var f__17517__auto__ = (function (){var switch__17414__auto__ = ((function (c__17516__auto__){
return (function (state_19136){
var state_val_19137 = (state_19136[(1)]);
if((state_val_19137 === (7))){
var inst_19132 = (state_19136[(2)]);
var state_19136__$1 = state_19136;
var statearr_19138_19176 = state_19136__$1;
(statearr_19138_19176[(2)] = inst_19132);

(statearr_19138_19176[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19137 === (20))){
var inst_19102 = (state_19136[(7)]);
var inst_19113 = (state_19136[(2)]);
var inst_19114 = cljs.core.next(inst_19102);
var inst_19088 = inst_19114;
var inst_19089 = null;
var inst_19090 = (0);
var inst_19091 = (0);
var state_19136__$1 = (function (){var statearr_19139 = state_19136;
(statearr_19139[(8)] = inst_19091);

(statearr_19139[(9)] = inst_19113);

(statearr_19139[(10)] = inst_19090);

(statearr_19139[(11)] = inst_19088);

(statearr_19139[(12)] = inst_19089);

return statearr_19139;
})();
var statearr_19140_19177 = state_19136__$1;
(statearr_19140_19177[(2)] = null);

(statearr_19140_19177[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19137 === (1))){
var state_19136__$1 = state_19136;
var statearr_19141_19178 = state_19136__$1;
(statearr_19141_19178[(2)] = null);

(statearr_19141_19178[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19137 === (4))){
var inst_19077 = (state_19136[(13)]);
var inst_19077__$1 = (state_19136[(2)]);
var inst_19078 = (inst_19077__$1 == null);
var state_19136__$1 = (function (){var statearr_19142 = state_19136;
(statearr_19142[(13)] = inst_19077__$1);

return statearr_19142;
})();
if(cljs.core.truth_(inst_19078)){
var statearr_19143_19179 = state_19136__$1;
(statearr_19143_19179[(1)] = (5));

} else {
var statearr_19144_19180 = state_19136__$1;
(statearr_19144_19180[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19137 === (15))){
var state_19136__$1 = state_19136;
var statearr_19148_19181 = state_19136__$1;
(statearr_19148_19181[(2)] = null);

(statearr_19148_19181[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19137 === (21))){
var state_19136__$1 = state_19136;
var statearr_19149_19182 = state_19136__$1;
(statearr_19149_19182[(2)] = null);

(statearr_19149_19182[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19137 === (13))){
var inst_19091 = (state_19136[(8)]);
var inst_19090 = (state_19136[(10)]);
var inst_19088 = (state_19136[(11)]);
var inst_19089 = (state_19136[(12)]);
var inst_19098 = (state_19136[(2)]);
var inst_19099 = (inst_19091 + (1));
var tmp19145 = inst_19090;
var tmp19146 = inst_19088;
var tmp19147 = inst_19089;
var inst_19088__$1 = tmp19146;
var inst_19089__$1 = tmp19147;
var inst_19090__$1 = tmp19145;
var inst_19091__$1 = inst_19099;
var state_19136__$1 = (function (){var statearr_19150 = state_19136;
(statearr_19150[(14)] = inst_19098);

(statearr_19150[(8)] = inst_19091__$1);

(statearr_19150[(10)] = inst_19090__$1);

(statearr_19150[(11)] = inst_19088__$1);

(statearr_19150[(12)] = inst_19089__$1);

return statearr_19150;
})();
var statearr_19151_19183 = state_19136__$1;
(statearr_19151_19183[(2)] = null);

(statearr_19151_19183[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19137 === (22))){
var state_19136__$1 = state_19136;
var statearr_19152_19184 = state_19136__$1;
(statearr_19152_19184[(2)] = null);

(statearr_19152_19184[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19137 === (6))){
var inst_19077 = (state_19136[(13)]);
var inst_19086 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_19077) : f.call(null,inst_19077));
var inst_19087 = cljs.core.seq(inst_19086);
var inst_19088 = inst_19087;
var inst_19089 = null;
var inst_19090 = (0);
var inst_19091 = (0);
var state_19136__$1 = (function (){var statearr_19153 = state_19136;
(statearr_19153[(8)] = inst_19091);

(statearr_19153[(10)] = inst_19090);

(statearr_19153[(11)] = inst_19088);

(statearr_19153[(12)] = inst_19089);

return statearr_19153;
})();
var statearr_19154_19185 = state_19136__$1;
(statearr_19154_19185[(2)] = null);

(statearr_19154_19185[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19137 === (17))){
var inst_19102 = (state_19136[(7)]);
var inst_19106 = cljs.core.chunk_first(inst_19102);
var inst_19107 = cljs.core.chunk_rest(inst_19102);
var inst_19108 = cljs.core.count(inst_19106);
var inst_19088 = inst_19107;
var inst_19089 = inst_19106;
var inst_19090 = inst_19108;
var inst_19091 = (0);
var state_19136__$1 = (function (){var statearr_19155 = state_19136;
(statearr_19155[(8)] = inst_19091);

(statearr_19155[(10)] = inst_19090);

(statearr_19155[(11)] = inst_19088);

(statearr_19155[(12)] = inst_19089);

return statearr_19155;
})();
var statearr_19156_19186 = state_19136__$1;
(statearr_19156_19186[(2)] = null);

(statearr_19156_19186[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19137 === (3))){
var inst_19134 = (state_19136[(2)]);
var state_19136__$1 = state_19136;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19136__$1,inst_19134);
} else {
if((state_val_19137 === (12))){
var inst_19122 = (state_19136[(2)]);
var state_19136__$1 = state_19136;
var statearr_19157_19187 = state_19136__$1;
(statearr_19157_19187[(2)] = inst_19122);

(statearr_19157_19187[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19137 === (2))){
var state_19136__$1 = state_19136;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19136__$1,(4),in$);
} else {
if((state_val_19137 === (23))){
var inst_19130 = (state_19136[(2)]);
var state_19136__$1 = state_19136;
var statearr_19158_19188 = state_19136__$1;
(statearr_19158_19188[(2)] = inst_19130);

(statearr_19158_19188[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19137 === (19))){
var inst_19117 = (state_19136[(2)]);
var state_19136__$1 = state_19136;
var statearr_19159_19189 = state_19136__$1;
(statearr_19159_19189[(2)] = inst_19117);

(statearr_19159_19189[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19137 === (11))){
var inst_19102 = (state_19136[(7)]);
var inst_19088 = (state_19136[(11)]);
var inst_19102__$1 = cljs.core.seq(inst_19088);
var state_19136__$1 = (function (){var statearr_19160 = state_19136;
(statearr_19160[(7)] = inst_19102__$1);

return statearr_19160;
})();
if(inst_19102__$1){
var statearr_19161_19190 = state_19136__$1;
(statearr_19161_19190[(1)] = (14));

} else {
var statearr_19162_19191 = state_19136__$1;
(statearr_19162_19191[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19137 === (9))){
var inst_19124 = (state_19136[(2)]);
var inst_19125 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_19136__$1 = (function (){var statearr_19163 = state_19136;
(statearr_19163[(15)] = inst_19124);

return statearr_19163;
})();
if(cljs.core.truth_(inst_19125)){
var statearr_19164_19192 = state_19136__$1;
(statearr_19164_19192[(1)] = (21));

} else {
var statearr_19165_19193 = state_19136__$1;
(statearr_19165_19193[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19137 === (5))){
var inst_19080 = cljs.core.async.close_BANG_(out);
var state_19136__$1 = state_19136;
var statearr_19166_19194 = state_19136__$1;
(statearr_19166_19194[(2)] = inst_19080);

(statearr_19166_19194[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19137 === (14))){
var inst_19102 = (state_19136[(7)]);
var inst_19104 = cljs.core.chunked_seq_QMARK_(inst_19102);
var state_19136__$1 = state_19136;
if(inst_19104){
var statearr_19167_19195 = state_19136__$1;
(statearr_19167_19195[(1)] = (17));

} else {
var statearr_19168_19196 = state_19136__$1;
(statearr_19168_19196[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19137 === (16))){
var inst_19120 = (state_19136[(2)]);
var state_19136__$1 = state_19136;
var statearr_19169_19197 = state_19136__$1;
(statearr_19169_19197[(2)] = inst_19120);

(statearr_19169_19197[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19137 === (10))){
var inst_19091 = (state_19136[(8)]);
var inst_19089 = (state_19136[(12)]);
var inst_19096 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_19089,inst_19091);
var state_19136__$1 = state_19136;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19136__$1,(13),out,inst_19096);
} else {
if((state_val_19137 === (18))){
var inst_19102 = (state_19136[(7)]);
var inst_19111 = cljs.core.first(inst_19102);
var state_19136__$1 = state_19136;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19136__$1,(20),out,inst_19111);
} else {
if((state_val_19137 === (8))){
var inst_19091 = (state_19136[(8)]);
var inst_19090 = (state_19136[(10)]);
var inst_19093 = (inst_19091 < inst_19090);
var inst_19094 = inst_19093;
var state_19136__$1 = state_19136;
if(cljs.core.truth_(inst_19094)){
var statearr_19170_19198 = state_19136__$1;
(statearr_19170_19198[(1)] = (10));

} else {
var statearr_19171_19199 = state_19136__$1;
(statearr_19171_19199[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17516__auto__))
;
return ((function (switch__17414__auto__,c__17516__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__17415__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__17415__auto____0 = (function (){
var statearr_19172 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19172[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__17415__auto__);

(statearr_19172[(1)] = (1));

return statearr_19172;
});
var cljs$core$async$mapcat_STAR__$_state_machine__17415__auto____1 = (function (state_19136){
while(true){
var ret_value__17416__auto__ = (function (){try{while(true){
var result__17417__auto__ = switch__17414__auto__(state_19136);
if(cljs.core.keyword_identical_QMARK_(result__17417__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17417__auto__;
}
break;
}
}catch (e19173){if((e19173 instanceof Object)){
var ex__17418__auto__ = e19173;
var statearr_19174_19200 = state_19136;
(statearr_19174_19200[(5)] = ex__17418__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19136);

return cljs.core.cst$kw$recur;
} else {
throw e19173;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17416__auto__,cljs.core.cst$kw$recur)){
var G__19201 = state_19136;
state_19136 = G__19201;
continue;
} else {
return ret_value__17416__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__17415__auto__ = function(state_19136){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__17415__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__17415__auto____1.call(this,state_19136);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__17415__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__17415__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__17415__auto__;
})()
;})(switch__17414__auto__,c__17516__auto__))
})();
var state__17518__auto__ = (function (){var statearr_19175 = (f__17517__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17517__auto__.cljs$core$IFn$_invoke$arity$0() : f__17517__auto__.call(null));
(statearr_19175[(6)] = c__17516__auto__);

return statearr_19175;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17518__auto__);
});})(c__17516__auto__))
);

return c__17516__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__19203 = arguments.length;
switch (G__19203) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__19206 = arguments.length;
switch (G__19206) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__19209 = arguments.length;
switch (G__19209) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17516__auto___19256 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17516__auto___19256,out){
return (function (){
var f__17517__auto__ = (function (){var switch__17414__auto__ = ((function (c__17516__auto___19256,out){
return (function (state_19233){
var state_val_19234 = (state_19233[(1)]);
if((state_val_19234 === (7))){
var inst_19228 = (state_19233[(2)]);
var state_19233__$1 = state_19233;
var statearr_19235_19257 = state_19233__$1;
(statearr_19235_19257[(2)] = inst_19228);

(statearr_19235_19257[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19234 === (1))){
var inst_19210 = null;
var state_19233__$1 = (function (){var statearr_19236 = state_19233;
(statearr_19236[(7)] = inst_19210);

return statearr_19236;
})();
var statearr_19237_19258 = state_19233__$1;
(statearr_19237_19258[(2)] = null);

(statearr_19237_19258[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19234 === (4))){
var inst_19213 = (state_19233[(8)]);
var inst_19213__$1 = (state_19233[(2)]);
var inst_19214 = (inst_19213__$1 == null);
var inst_19215 = cljs.core.not(inst_19214);
var state_19233__$1 = (function (){var statearr_19238 = state_19233;
(statearr_19238[(8)] = inst_19213__$1);

return statearr_19238;
})();
if(inst_19215){
var statearr_19239_19259 = state_19233__$1;
(statearr_19239_19259[(1)] = (5));

} else {
var statearr_19240_19260 = state_19233__$1;
(statearr_19240_19260[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19234 === (6))){
var state_19233__$1 = state_19233;
var statearr_19241_19261 = state_19233__$1;
(statearr_19241_19261[(2)] = null);

(statearr_19241_19261[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19234 === (3))){
var inst_19230 = (state_19233[(2)]);
var inst_19231 = cljs.core.async.close_BANG_(out);
var state_19233__$1 = (function (){var statearr_19242 = state_19233;
(statearr_19242[(9)] = inst_19230);

return statearr_19242;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_19233__$1,inst_19231);
} else {
if((state_val_19234 === (2))){
var state_19233__$1 = state_19233;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19233__$1,(4),ch);
} else {
if((state_val_19234 === (11))){
var inst_19213 = (state_19233[(8)]);
var inst_19222 = (state_19233[(2)]);
var inst_19210 = inst_19213;
var state_19233__$1 = (function (){var statearr_19243 = state_19233;
(statearr_19243[(7)] = inst_19210);

(statearr_19243[(10)] = inst_19222);

return statearr_19243;
})();
var statearr_19244_19262 = state_19233__$1;
(statearr_19244_19262[(2)] = null);

(statearr_19244_19262[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19234 === (9))){
var inst_19213 = (state_19233[(8)]);
var state_19233__$1 = state_19233;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19233__$1,(11),out,inst_19213);
} else {
if((state_val_19234 === (5))){
var inst_19213 = (state_19233[(8)]);
var inst_19210 = (state_19233[(7)]);
var inst_19217 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_19213,inst_19210);
var state_19233__$1 = state_19233;
if(inst_19217){
var statearr_19246_19263 = state_19233__$1;
(statearr_19246_19263[(1)] = (8));

} else {
var statearr_19247_19264 = state_19233__$1;
(statearr_19247_19264[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19234 === (10))){
var inst_19225 = (state_19233[(2)]);
var state_19233__$1 = state_19233;
var statearr_19248_19265 = state_19233__$1;
(statearr_19248_19265[(2)] = inst_19225);

(statearr_19248_19265[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19234 === (8))){
var inst_19210 = (state_19233[(7)]);
var tmp19245 = inst_19210;
var inst_19210__$1 = tmp19245;
var state_19233__$1 = (function (){var statearr_19249 = state_19233;
(statearr_19249[(7)] = inst_19210__$1);

return statearr_19249;
})();
var statearr_19250_19266 = state_19233__$1;
(statearr_19250_19266[(2)] = null);

(statearr_19250_19266[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__17516__auto___19256,out))
;
return ((function (switch__17414__auto__,c__17516__auto___19256,out){
return (function() {
var cljs$core$async$state_machine__17415__auto__ = null;
var cljs$core$async$state_machine__17415__auto____0 = (function (){
var statearr_19251 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19251[(0)] = cljs$core$async$state_machine__17415__auto__);

(statearr_19251[(1)] = (1));

return statearr_19251;
});
var cljs$core$async$state_machine__17415__auto____1 = (function (state_19233){
while(true){
var ret_value__17416__auto__ = (function (){try{while(true){
var result__17417__auto__ = switch__17414__auto__(state_19233);
if(cljs.core.keyword_identical_QMARK_(result__17417__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17417__auto__;
}
break;
}
}catch (e19252){if((e19252 instanceof Object)){
var ex__17418__auto__ = e19252;
var statearr_19253_19267 = state_19233;
(statearr_19253_19267[(5)] = ex__17418__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19233);

return cljs.core.cst$kw$recur;
} else {
throw e19252;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17416__auto__,cljs.core.cst$kw$recur)){
var G__19268 = state_19233;
state_19233 = G__19268;
continue;
} else {
return ret_value__17416__auto__;
}
break;
}
});
cljs$core$async$state_machine__17415__auto__ = function(state_19233){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17415__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17415__auto____1.call(this,state_19233);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17415__auto____0;
cljs$core$async$state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17415__auto____1;
return cljs$core$async$state_machine__17415__auto__;
})()
;})(switch__17414__auto__,c__17516__auto___19256,out))
})();
var state__17518__auto__ = (function (){var statearr_19254 = (f__17517__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17517__auto__.cljs$core$IFn$_invoke$arity$0() : f__17517__auto__.call(null));
(statearr_19254[(6)] = c__17516__auto___19256);

return statearr_19254;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17518__auto__);
});})(c__17516__auto___19256,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__19270 = arguments.length;
switch (G__19270) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17516__auto___19336 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17516__auto___19336,out){
return (function (){
var f__17517__auto__ = (function (){var switch__17414__auto__ = ((function (c__17516__auto___19336,out){
return (function (state_19308){
var state_val_19309 = (state_19308[(1)]);
if((state_val_19309 === (7))){
var inst_19304 = (state_19308[(2)]);
var state_19308__$1 = state_19308;
var statearr_19310_19337 = state_19308__$1;
(statearr_19310_19337[(2)] = inst_19304);

(statearr_19310_19337[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19309 === (1))){
var inst_19271 = (new Array(n));
var inst_19272 = inst_19271;
var inst_19273 = (0);
var state_19308__$1 = (function (){var statearr_19311 = state_19308;
(statearr_19311[(7)] = inst_19273);

(statearr_19311[(8)] = inst_19272);

return statearr_19311;
})();
var statearr_19312_19338 = state_19308__$1;
(statearr_19312_19338[(2)] = null);

(statearr_19312_19338[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19309 === (4))){
var inst_19276 = (state_19308[(9)]);
var inst_19276__$1 = (state_19308[(2)]);
var inst_19277 = (inst_19276__$1 == null);
var inst_19278 = cljs.core.not(inst_19277);
var state_19308__$1 = (function (){var statearr_19313 = state_19308;
(statearr_19313[(9)] = inst_19276__$1);

return statearr_19313;
})();
if(inst_19278){
var statearr_19314_19339 = state_19308__$1;
(statearr_19314_19339[(1)] = (5));

} else {
var statearr_19315_19340 = state_19308__$1;
(statearr_19315_19340[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19309 === (15))){
var inst_19298 = (state_19308[(2)]);
var state_19308__$1 = state_19308;
var statearr_19316_19341 = state_19308__$1;
(statearr_19316_19341[(2)] = inst_19298);

(statearr_19316_19341[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19309 === (13))){
var state_19308__$1 = state_19308;
var statearr_19317_19342 = state_19308__$1;
(statearr_19317_19342[(2)] = null);

(statearr_19317_19342[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19309 === (6))){
var inst_19273 = (state_19308[(7)]);
var inst_19294 = (inst_19273 > (0));
var state_19308__$1 = state_19308;
if(cljs.core.truth_(inst_19294)){
var statearr_19318_19343 = state_19308__$1;
(statearr_19318_19343[(1)] = (12));

} else {
var statearr_19319_19344 = state_19308__$1;
(statearr_19319_19344[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19309 === (3))){
var inst_19306 = (state_19308[(2)]);
var state_19308__$1 = state_19308;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19308__$1,inst_19306);
} else {
if((state_val_19309 === (12))){
var inst_19272 = (state_19308[(8)]);
var inst_19296 = cljs.core.vec(inst_19272);
var state_19308__$1 = state_19308;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19308__$1,(15),out,inst_19296);
} else {
if((state_val_19309 === (2))){
var state_19308__$1 = state_19308;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19308__$1,(4),ch);
} else {
if((state_val_19309 === (11))){
var inst_19288 = (state_19308[(2)]);
var inst_19289 = (new Array(n));
var inst_19272 = inst_19289;
var inst_19273 = (0);
var state_19308__$1 = (function (){var statearr_19320 = state_19308;
(statearr_19320[(7)] = inst_19273);

(statearr_19320[(10)] = inst_19288);

(statearr_19320[(8)] = inst_19272);

return statearr_19320;
})();
var statearr_19321_19345 = state_19308__$1;
(statearr_19321_19345[(2)] = null);

(statearr_19321_19345[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19309 === (9))){
var inst_19272 = (state_19308[(8)]);
var inst_19286 = cljs.core.vec(inst_19272);
var state_19308__$1 = state_19308;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19308__$1,(11),out,inst_19286);
} else {
if((state_val_19309 === (5))){
var inst_19276 = (state_19308[(9)]);
var inst_19273 = (state_19308[(7)]);
var inst_19281 = (state_19308[(11)]);
var inst_19272 = (state_19308[(8)]);
var inst_19280 = (inst_19272[inst_19273] = inst_19276);
var inst_19281__$1 = (inst_19273 + (1));
var inst_19282 = (inst_19281__$1 < n);
var state_19308__$1 = (function (){var statearr_19322 = state_19308;
(statearr_19322[(12)] = inst_19280);

(statearr_19322[(11)] = inst_19281__$1);

return statearr_19322;
})();
if(cljs.core.truth_(inst_19282)){
var statearr_19323_19346 = state_19308__$1;
(statearr_19323_19346[(1)] = (8));

} else {
var statearr_19324_19347 = state_19308__$1;
(statearr_19324_19347[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19309 === (14))){
var inst_19301 = (state_19308[(2)]);
var inst_19302 = cljs.core.async.close_BANG_(out);
var state_19308__$1 = (function (){var statearr_19326 = state_19308;
(statearr_19326[(13)] = inst_19301);

return statearr_19326;
})();
var statearr_19327_19348 = state_19308__$1;
(statearr_19327_19348[(2)] = inst_19302);

(statearr_19327_19348[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19309 === (10))){
var inst_19292 = (state_19308[(2)]);
var state_19308__$1 = state_19308;
var statearr_19328_19349 = state_19308__$1;
(statearr_19328_19349[(2)] = inst_19292);

(statearr_19328_19349[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19309 === (8))){
var inst_19281 = (state_19308[(11)]);
var inst_19272 = (state_19308[(8)]);
var tmp19325 = inst_19272;
var inst_19272__$1 = tmp19325;
var inst_19273 = inst_19281;
var state_19308__$1 = (function (){var statearr_19329 = state_19308;
(statearr_19329[(7)] = inst_19273);

(statearr_19329[(8)] = inst_19272__$1);

return statearr_19329;
})();
var statearr_19330_19350 = state_19308__$1;
(statearr_19330_19350[(2)] = null);

(statearr_19330_19350[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17516__auto___19336,out))
;
return ((function (switch__17414__auto__,c__17516__auto___19336,out){
return (function() {
var cljs$core$async$state_machine__17415__auto__ = null;
var cljs$core$async$state_machine__17415__auto____0 = (function (){
var statearr_19331 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19331[(0)] = cljs$core$async$state_machine__17415__auto__);

(statearr_19331[(1)] = (1));

return statearr_19331;
});
var cljs$core$async$state_machine__17415__auto____1 = (function (state_19308){
while(true){
var ret_value__17416__auto__ = (function (){try{while(true){
var result__17417__auto__ = switch__17414__auto__(state_19308);
if(cljs.core.keyword_identical_QMARK_(result__17417__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17417__auto__;
}
break;
}
}catch (e19332){if((e19332 instanceof Object)){
var ex__17418__auto__ = e19332;
var statearr_19333_19351 = state_19308;
(statearr_19333_19351[(5)] = ex__17418__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19308);

return cljs.core.cst$kw$recur;
} else {
throw e19332;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17416__auto__,cljs.core.cst$kw$recur)){
var G__19352 = state_19308;
state_19308 = G__19352;
continue;
} else {
return ret_value__17416__auto__;
}
break;
}
});
cljs$core$async$state_machine__17415__auto__ = function(state_19308){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17415__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17415__auto____1.call(this,state_19308);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17415__auto____0;
cljs$core$async$state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17415__auto____1;
return cljs$core$async$state_machine__17415__auto__;
})()
;})(switch__17414__auto__,c__17516__auto___19336,out))
})();
var state__17518__auto__ = (function (){var statearr_19334 = (f__17517__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17517__auto__.cljs$core$IFn$_invoke$arity$0() : f__17517__auto__.call(null));
(statearr_19334[(6)] = c__17516__auto___19336);

return statearr_19334;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17518__auto__);
});})(c__17516__auto___19336,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__19354 = arguments.length;
switch (G__19354) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17516__auto___19424 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17516__auto___19424,out){
return (function (){
var f__17517__auto__ = (function (){var switch__17414__auto__ = ((function (c__17516__auto___19424,out){
return (function (state_19396){
var state_val_19397 = (state_19396[(1)]);
if((state_val_19397 === (7))){
var inst_19392 = (state_19396[(2)]);
var state_19396__$1 = state_19396;
var statearr_19398_19425 = state_19396__$1;
(statearr_19398_19425[(2)] = inst_19392);

(statearr_19398_19425[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19397 === (1))){
var inst_19355 = [];
var inst_19356 = inst_19355;
var inst_19357 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_19396__$1 = (function (){var statearr_19399 = state_19396;
(statearr_19399[(7)] = inst_19356);

(statearr_19399[(8)] = inst_19357);

return statearr_19399;
})();
var statearr_19400_19426 = state_19396__$1;
(statearr_19400_19426[(2)] = null);

(statearr_19400_19426[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19397 === (4))){
var inst_19360 = (state_19396[(9)]);
var inst_19360__$1 = (state_19396[(2)]);
var inst_19361 = (inst_19360__$1 == null);
var inst_19362 = cljs.core.not(inst_19361);
var state_19396__$1 = (function (){var statearr_19401 = state_19396;
(statearr_19401[(9)] = inst_19360__$1);

return statearr_19401;
})();
if(inst_19362){
var statearr_19402_19427 = state_19396__$1;
(statearr_19402_19427[(1)] = (5));

} else {
var statearr_19403_19428 = state_19396__$1;
(statearr_19403_19428[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19397 === (15))){
var inst_19386 = (state_19396[(2)]);
var state_19396__$1 = state_19396;
var statearr_19404_19429 = state_19396__$1;
(statearr_19404_19429[(2)] = inst_19386);

(statearr_19404_19429[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19397 === (13))){
var state_19396__$1 = state_19396;
var statearr_19405_19430 = state_19396__$1;
(statearr_19405_19430[(2)] = null);

(statearr_19405_19430[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19397 === (6))){
var inst_19356 = (state_19396[(7)]);
var inst_19381 = inst_19356.length;
var inst_19382 = (inst_19381 > (0));
var state_19396__$1 = state_19396;
if(cljs.core.truth_(inst_19382)){
var statearr_19406_19431 = state_19396__$1;
(statearr_19406_19431[(1)] = (12));

} else {
var statearr_19407_19432 = state_19396__$1;
(statearr_19407_19432[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19397 === (3))){
var inst_19394 = (state_19396[(2)]);
var state_19396__$1 = state_19396;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19396__$1,inst_19394);
} else {
if((state_val_19397 === (12))){
var inst_19356 = (state_19396[(7)]);
var inst_19384 = cljs.core.vec(inst_19356);
var state_19396__$1 = state_19396;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19396__$1,(15),out,inst_19384);
} else {
if((state_val_19397 === (2))){
var state_19396__$1 = state_19396;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19396__$1,(4),ch);
} else {
if((state_val_19397 === (11))){
var inst_19364 = (state_19396[(10)]);
var inst_19360 = (state_19396[(9)]);
var inst_19374 = (state_19396[(2)]);
var inst_19375 = [];
var inst_19376 = inst_19375.push(inst_19360);
var inst_19356 = inst_19375;
var inst_19357 = inst_19364;
var state_19396__$1 = (function (){var statearr_19408 = state_19396;
(statearr_19408[(11)] = inst_19376);

(statearr_19408[(12)] = inst_19374);

(statearr_19408[(7)] = inst_19356);

(statearr_19408[(8)] = inst_19357);

return statearr_19408;
})();
var statearr_19409_19433 = state_19396__$1;
(statearr_19409_19433[(2)] = null);

(statearr_19409_19433[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19397 === (9))){
var inst_19356 = (state_19396[(7)]);
var inst_19372 = cljs.core.vec(inst_19356);
var state_19396__$1 = state_19396;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19396__$1,(11),out,inst_19372);
} else {
if((state_val_19397 === (5))){
var inst_19364 = (state_19396[(10)]);
var inst_19360 = (state_19396[(9)]);
var inst_19357 = (state_19396[(8)]);
var inst_19364__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_19360) : f.call(null,inst_19360));
var inst_19365 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_19364__$1,inst_19357);
var inst_19366 = cljs.core.keyword_identical_QMARK_(inst_19357,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_19367 = (inst_19365) || (inst_19366);
var state_19396__$1 = (function (){var statearr_19410 = state_19396;
(statearr_19410[(10)] = inst_19364__$1);

return statearr_19410;
})();
if(cljs.core.truth_(inst_19367)){
var statearr_19411_19434 = state_19396__$1;
(statearr_19411_19434[(1)] = (8));

} else {
var statearr_19412_19435 = state_19396__$1;
(statearr_19412_19435[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19397 === (14))){
var inst_19389 = (state_19396[(2)]);
var inst_19390 = cljs.core.async.close_BANG_(out);
var state_19396__$1 = (function (){var statearr_19414 = state_19396;
(statearr_19414[(13)] = inst_19389);

return statearr_19414;
})();
var statearr_19415_19436 = state_19396__$1;
(statearr_19415_19436[(2)] = inst_19390);

(statearr_19415_19436[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19397 === (10))){
var inst_19379 = (state_19396[(2)]);
var state_19396__$1 = state_19396;
var statearr_19416_19437 = state_19396__$1;
(statearr_19416_19437[(2)] = inst_19379);

(statearr_19416_19437[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19397 === (8))){
var inst_19364 = (state_19396[(10)]);
var inst_19356 = (state_19396[(7)]);
var inst_19360 = (state_19396[(9)]);
var inst_19369 = inst_19356.push(inst_19360);
var tmp19413 = inst_19356;
var inst_19356__$1 = tmp19413;
var inst_19357 = inst_19364;
var state_19396__$1 = (function (){var statearr_19417 = state_19396;
(statearr_19417[(7)] = inst_19356__$1);

(statearr_19417[(8)] = inst_19357);

(statearr_19417[(14)] = inst_19369);

return statearr_19417;
})();
var statearr_19418_19438 = state_19396__$1;
(statearr_19418_19438[(2)] = null);

(statearr_19418_19438[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17516__auto___19424,out))
;
return ((function (switch__17414__auto__,c__17516__auto___19424,out){
return (function() {
var cljs$core$async$state_machine__17415__auto__ = null;
var cljs$core$async$state_machine__17415__auto____0 = (function (){
var statearr_19419 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19419[(0)] = cljs$core$async$state_machine__17415__auto__);

(statearr_19419[(1)] = (1));

return statearr_19419;
});
var cljs$core$async$state_machine__17415__auto____1 = (function (state_19396){
while(true){
var ret_value__17416__auto__ = (function (){try{while(true){
var result__17417__auto__ = switch__17414__auto__(state_19396);
if(cljs.core.keyword_identical_QMARK_(result__17417__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17417__auto__;
}
break;
}
}catch (e19420){if((e19420 instanceof Object)){
var ex__17418__auto__ = e19420;
var statearr_19421_19439 = state_19396;
(statearr_19421_19439[(5)] = ex__17418__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19396);

return cljs.core.cst$kw$recur;
} else {
throw e19420;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17416__auto__,cljs.core.cst$kw$recur)){
var G__19440 = state_19396;
state_19396 = G__19440;
continue;
} else {
return ret_value__17416__auto__;
}
break;
}
});
cljs$core$async$state_machine__17415__auto__ = function(state_19396){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17415__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17415__auto____1.call(this,state_19396);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17415__auto____0;
cljs$core$async$state_machine__17415__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17415__auto____1;
return cljs$core$async$state_machine__17415__auto__;
})()
;})(switch__17414__auto__,c__17516__auto___19424,out))
})();
var state__17518__auto__ = (function (){var statearr_19422 = (f__17517__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17517__auto__.cljs$core$IFn$_invoke$arity$0() : f__17517__auto__.call(null));
(statearr_19422[(6)] = c__17516__auto___19424);

return statearr_19422;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17518__auto__);
});})(c__17516__auto___19424,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

