// Compiled by ClojureScript 1.9.946 {:static-fns true, :optimize-constants true}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.trace');
re_frame.fx.kind = cljs.core.cst$kw$fx;
if(cljs.core.truth_((re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1 ? re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1(re_frame.fx.kind) : re_frame.registrar.kinds.call(null,re_frame.fx.kind)))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler(re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$id,cljs.core.cst$kw$do_DASH_fx,cljs.core.cst$kw$after,(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR_26285 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$op_DASH_type,cljs.core.cst$kw$event_SLASH_do_DASH_fx], null));

try{try{var seq__26286 = cljs.core.seq(cljs.core.cst$kw$effects.cljs$core$IFn$_invoke$arity$1(context));
var chunk__26287 = null;
var count__26288 = (0);
var i__26289 = (0);
while(true){
if((i__26289 < count__26288)){
var vec__26290 = chunk__26287.cljs$core$IIndexed$_nth$arity$2(null,i__26289);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26290,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26290,(1),null);
var temp__5455__auto___26306 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___26306)){
var effect_fn_26307 = temp__5455__auto___26306;
(effect_fn_26307.cljs$core$IFn$_invoke$arity$1 ? effect_fn_26307.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_26307.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}

var G__26308 = seq__26286;
var G__26309 = chunk__26287;
var G__26310 = count__26288;
var G__26311 = (i__26289 + (1));
seq__26286 = G__26308;
chunk__26287 = G__26309;
count__26288 = G__26310;
i__26289 = G__26311;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__26286);
if(temp__5457__auto__){
var seq__26286__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__26286__$1)){
var c__9739__auto__ = cljs.core.chunk_first(seq__26286__$1);
var G__26312 = cljs.core.chunk_rest(seq__26286__$1);
var G__26313 = c__9739__auto__;
var G__26314 = cljs.core.count(c__9739__auto__);
var G__26315 = (0);
seq__26286 = G__26312;
chunk__26287 = G__26313;
count__26288 = G__26314;
i__26289 = G__26315;
continue;
} else {
var vec__26293 = cljs.core.first(seq__26286__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26293,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26293,(1),null);
var temp__5455__auto___26316 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___26316)){
var effect_fn_26317 = temp__5455__auto___26316;
(effect_fn_26317.cljs$core$IFn$_invoke$arity$1 ? effect_fn_26317.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_26317.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}

var G__26318 = cljs.core.next(seq__26286__$1);
var G__26319 = null;
var G__26320 = (0);
var G__26321 = (0);
seq__26286 = G__26318;
chunk__26287 = G__26319;
count__26288 = G__26320;
i__26289 = G__26321;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__26118__auto___26322 = re_frame.interop.now();
var duration__26119__auto___26323 = (end__26118__auto___26322 - cljs.core.cst$kw$start.cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$duration,duration__26119__auto___26323,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$end,re_frame.interop.now()], 0)));

re_frame.trace.run_tracing_callbacks_BANG_(end__26118__auto___26322);
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_26285;
}} else {
var seq__26296 = cljs.core.seq(cljs.core.cst$kw$effects.cljs$core$IFn$_invoke$arity$1(context));
var chunk__26297 = null;
var count__26298 = (0);
var i__26299 = (0);
while(true){
if((i__26299 < count__26298)){
var vec__26300 = chunk__26297.cljs$core$IIndexed$_nth$arity$2(null,i__26299);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26300,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26300,(1),null);
var temp__5455__auto___26324 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___26324)){
var effect_fn_26325 = temp__5455__auto___26324;
(effect_fn_26325.cljs$core$IFn$_invoke$arity$1 ? effect_fn_26325.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_26325.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}

var G__26326 = seq__26296;
var G__26327 = chunk__26297;
var G__26328 = count__26298;
var G__26329 = (i__26299 + (1));
seq__26296 = G__26326;
chunk__26297 = G__26327;
count__26298 = G__26328;
i__26299 = G__26329;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__26296);
if(temp__5457__auto__){
var seq__26296__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__26296__$1)){
var c__9739__auto__ = cljs.core.chunk_first(seq__26296__$1);
var G__26330 = cljs.core.chunk_rest(seq__26296__$1);
var G__26331 = c__9739__auto__;
var G__26332 = cljs.core.count(c__9739__auto__);
var G__26333 = (0);
seq__26296 = G__26330;
chunk__26297 = G__26331;
count__26298 = G__26332;
i__26299 = G__26333;
continue;
} else {
var vec__26303 = cljs.core.first(seq__26296__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26303,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26303,(1),null);
var temp__5455__auto___26334 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___26334)){
var effect_fn_26335 = temp__5455__auto___26334;
(effect_fn_26335.cljs$core$IFn$_invoke$arity$1 ? effect_fn_26335.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_26335.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}

var G__26336 = cljs.core.next(seq__26296__$1);
var G__26337 = null;
var G__26338 = (0);
var G__26339 = (0);
seq__26296 = G__26336;
chunk__26297 = G__26337;
count__26298 = G__26338;
i__26299 = G__26339;
continue;
}
} else {
return null;
}
}
break;
}
}
})], 0));
re_frame.fx.reg_fx(cljs.core.cst$kw$dispatch_DASH_later,(function (value){
var seq__26340 = cljs.core.seq(value);
var chunk__26341 = null;
var count__26342 = (0);
var i__26343 = (0);
while(true){
if((i__26343 < count__26342)){
var map__26344 = chunk__26341.cljs$core$IIndexed$_nth$arity$2(null,i__26343);
var map__26344__$1 = ((((!((map__26344 == null)))?((((map__26344.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26344.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26344):map__26344);
var effect = map__26344__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26344__$1,cljs.core.cst$kw$ms);
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26344__$1,cljs.core.cst$kw$dispatch);
if((cljs.core.empty_QMARK_(dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__26340,chunk__26341,count__26342,i__26343,map__26344,map__26344__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__26340,chunk__26341,count__26342,i__26343,map__26344,map__26344__$1,effect,ms,dispatch))
,ms);
}

var G__26348 = seq__26340;
var G__26349 = chunk__26341;
var G__26350 = count__26342;
var G__26351 = (i__26343 + (1));
seq__26340 = G__26348;
chunk__26341 = G__26349;
count__26342 = G__26350;
i__26343 = G__26351;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__26340);
if(temp__5457__auto__){
var seq__26340__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__26340__$1)){
var c__9739__auto__ = cljs.core.chunk_first(seq__26340__$1);
var G__26352 = cljs.core.chunk_rest(seq__26340__$1);
var G__26353 = c__9739__auto__;
var G__26354 = cljs.core.count(c__9739__auto__);
var G__26355 = (0);
seq__26340 = G__26352;
chunk__26341 = G__26353;
count__26342 = G__26354;
i__26343 = G__26355;
continue;
} else {
var map__26346 = cljs.core.first(seq__26340__$1);
var map__26346__$1 = ((((!((map__26346 == null)))?((((map__26346.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26346.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26346):map__26346);
var effect = map__26346__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26346__$1,cljs.core.cst$kw$ms);
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26346__$1,cljs.core.cst$kw$dispatch);
if((cljs.core.empty_QMARK_(dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__26340,chunk__26341,count__26342,i__26343,map__26346,map__26346__$1,effect,ms,dispatch,seq__26340__$1,temp__5457__auto__){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__26340,chunk__26341,count__26342,i__26343,map__26346,map__26346__$1,effect,ms,dispatch,seq__26340__$1,temp__5457__auto__))
,ms);
}

var G__26356 = cljs.core.next(seq__26340__$1);
var G__26357 = null;
var G__26358 = (0);
var G__26359 = (0);
seq__26340 = G__26356;
chunk__26341 = G__26357;
count__26342 = G__26358;
i__26343 = G__26359;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$dispatch,(function (value){
if(!(cljs.core.vector_QMARK_(value))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value], 0));
} else {
return re_frame.router.dispatch(value);
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$dispatch_DASH_n,(function (value){
if(!(cljs.core.sequential_QMARK_(value))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-n value. Expected a collection, got got:",value], 0));
} else {
var seq__26360 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__26361 = null;
var count__26362 = (0);
var i__26363 = (0);
while(true){
if((i__26363 < count__26362)){
var event = chunk__26361.cljs$core$IIndexed$_nth$arity$2(null,i__26363);
re_frame.router.dispatch(event);

var G__26364 = seq__26360;
var G__26365 = chunk__26361;
var G__26366 = count__26362;
var G__26367 = (i__26363 + (1));
seq__26360 = G__26364;
chunk__26361 = G__26365;
count__26362 = G__26366;
i__26363 = G__26367;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__26360);
if(temp__5457__auto__){
var seq__26360__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__26360__$1)){
var c__9739__auto__ = cljs.core.chunk_first(seq__26360__$1);
var G__26368 = cljs.core.chunk_rest(seq__26360__$1);
var G__26369 = c__9739__auto__;
var G__26370 = cljs.core.count(c__9739__auto__);
var G__26371 = (0);
seq__26360 = G__26368;
chunk__26361 = G__26369;
count__26362 = G__26370;
i__26363 = G__26371;
continue;
} else {
var event = cljs.core.first(seq__26360__$1);
re_frame.router.dispatch(event);

var G__26372 = cljs.core.next(seq__26360__$1);
var G__26373 = null;
var G__26374 = (0);
var G__26375 = (0);
seq__26360 = G__26372;
chunk__26361 = G__26373;
count__26362 = G__26374;
i__26363 = G__26375;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$deregister_DASH_event_DASH_handler,(function (value){
var clear_event = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_(value)){
var seq__26376 = cljs.core.seq(value);
var chunk__26377 = null;
var count__26378 = (0);
var i__26379 = (0);
while(true){
if((i__26379 < count__26378)){
var event = chunk__26377.cljs$core$IIndexed$_nth$arity$2(null,i__26379);
(clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(event) : clear_event.call(null,event));

var G__26380 = seq__26376;
var G__26381 = chunk__26377;
var G__26382 = count__26378;
var G__26383 = (i__26379 + (1));
seq__26376 = G__26380;
chunk__26377 = G__26381;
count__26378 = G__26382;
i__26379 = G__26383;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__26376);
if(temp__5457__auto__){
var seq__26376__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__26376__$1)){
var c__9739__auto__ = cljs.core.chunk_first(seq__26376__$1);
var G__26384 = cljs.core.chunk_rest(seq__26376__$1);
var G__26385 = c__9739__auto__;
var G__26386 = cljs.core.count(c__9739__auto__);
var G__26387 = (0);
seq__26376 = G__26384;
chunk__26377 = G__26385;
count__26378 = G__26386;
i__26379 = G__26387;
continue;
} else {
var event = cljs.core.first(seq__26376__$1);
(clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(event) : clear_event.call(null,event));

var G__26388 = cljs.core.next(seq__26376__$1);
var G__26389 = null;
var G__26390 = (0);
var G__26391 = (0);
seq__26376 = G__26388;
chunk__26377 = G__26389;
count__26378 = G__26390;
i__26379 = G__26391;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return (clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(value) : clear_event.call(null,value));
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$db,(function (value){
if(!((cljs.core.deref(re_frame.db.app_db) === value))){
return cljs.core.reset_BANG_(re_frame.db.app_db,value);
} else {
return null;
}
}));
