// Compiled by ClojureScript 1.9.946 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('cljs_ipfs_api.utils');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('camel_snake_kebab.core');
goog.require('camel_snake_kebab.extras');
goog.require('cljs.core.async');
goog.require('cljs_http.client');
goog.require('taoensso.timbre');
goog.require('clojure.string');
cljs_ipfs_api.utils.safe_case = (function cljs_ipfs_api$utils$safe_case(case_f){
return (function (x){
var G__25007 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.name(x),(1));
var G__25007__$1 = clojure.string.replace(G__25007,"_","*")
;
var G__25007__$2 = (case_f.cljs$core$IFn$_invoke$arity$1 ? case_f.cljs$core$IFn$_invoke$arity$1(G__25007__$1) : case_f.call(null,G__25007__$1))
;
var G__25007__$3 = clojure.string.replace(G__25007__$2,"*","_")
;
var G__25007__$4 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.name(x))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__25007__$3)].join('')
;
if((x instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(G__25007__$4);
} else {
return G__25007__$4;
}
});
});
cljs_ipfs_api.utils.camel_case = cljs_ipfs_api.utils.safe_case(camel_snake_kebab.core.__GT_camelCase);
cljs_ipfs_api.utils.kebab_case = cljs_ipfs_api.utils.safe_case(camel_snake_kebab.core.__GT_kebab_case);
cljs_ipfs_api.utils.js__GT_cljk = (function cljs_ipfs_api$utils$js__GT_cljk(p1__25008_SHARP_){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(p1__25008_SHARP_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
/**
 * From JavaScript to Clojure with kekab-cased keywords.
 */
cljs_ipfs_api.utils.js__GT_cljkk = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(camel_snake_kebab.extras.transform_keys,cljs_ipfs_api.utils.kebab_case),cljs_ipfs_api.utils.js__GT_cljk);
/**
 * From Clojure with kebab-cased keywords to JavaScript.
 */
cljs_ipfs_api.utils.cljkk__GT_js = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.clj__GT_js,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(camel_snake_kebab.extras.transform_keys,cljs_ipfs_api.utils.camel_case));
cljs_ipfs_api.utils.callback_js__GT_clj = (function cljs_ipfs_api$utils$callback_js__GT_clj(x){
if(cljs.core.fn_QMARK_(x)){
return (function (err,res){
if(cljs.core.truth_((function (){var and__8794__auto__ = res;
if(cljs.core.truth_(and__8794__auto__)){
return (res["v"]);
} else {
return and__8794__auto__;
}
})())){
(res["v"] = (res["v"]));
} else {
}

var G__25009 = err;
var G__25010 = (cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1 ? cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1(res) : cljs_ipfs_api.utils.js__GT_cljkk.call(null,res));
return (x.cljs$core$IFn$_invoke$arity$2 ? x.cljs$core$IFn$_invoke$arity$2(G__25009,G__25010) : x.call(null,G__25009,G__25010));
});
} else {
return x;
}
});
cljs_ipfs_api.utils.args_cljkk__GT_js = (function cljs_ipfs_api$utils$args_cljkk__GT_js(args){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs_ipfs_api.utils.cljkk__GT_js,cljs_ipfs_api.utils.callback_js__GT_clj),args);
});
cljs_ipfs_api.utils.js_apply = (function cljs_ipfs_api$utils$js_apply(var_args){
var G__25012 = arguments.length;
switch (G__25012) {
case 2:
return cljs_ipfs_api.utils.js_apply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs_ipfs_api.utils.js_apply.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs_ipfs_api.utils.js_apply.cljs$core$IFn$_invoke$arity$2 = (function (this$,method_name){
return cljs_ipfs_api.utils.js_apply.cljs$core$IFn$_invoke$arity$3(this$,method_name,null);
});

cljs_ipfs_api.utils.js_apply.cljs$core$IFn$_invoke$arity$3 = (function (this$,method_name,args){
if(cljs.core.truth_((this$[method_name]))){
var G__25013 = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.js_invoke,this$,method_name,cljs_ipfs_api.utils.args_cljkk__GT_js(args));
return (cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1 ? cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1(G__25013) : cljs_ipfs_api.utils.js__GT_cljkk.call(null,G__25013));
} else {
throw ["Method: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(method_name)," was not found in object."].join('');
}
});

cljs_ipfs_api.utils.js_apply.cljs$lang$maxFixedArity = 3;

cljs_ipfs_api.utils.js_prototype_apply = (function cljs_ipfs_api$utils$js_prototype_apply(js_obj,method_name,args){
return cljs_ipfs_api.utils.js_apply.cljs$core$IFn$_invoke$arity$3((js_obj["prototype"]),method_name,args);
});
cljs_ipfs_api.utils.wrap_callback = (function cljs_ipfs_api$utils$wrap_callback(f_n){
var callback = (function cljs_ipfs_api$utils$wrap_callback_$_callback(err,res){
if((f_n instanceof cljs.core.async.impl.channels.ManyToManyChannel)){
var c__16901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16901__auto__){
return (function (){
var f__16902__auto__ = (function (){var switch__16799__auto__ = ((function (c__16901__auto__){
return (function (state_25023){
var state_val_25024 = (state_25023[(1)]);
if((state_val_25024 === (1))){
var inst_25015 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25016 = (cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1 ? cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1(err) : cljs_ipfs_api.utils.js__GT_cljkk.call(null,err));
var inst_25017 = (cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1 ? cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1(res) : cljs_ipfs_api.utils.js__GT_cljkk.call(null,res));
var inst_25018 = [inst_25016,inst_25017];
var inst_25019 = (new cljs.core.PersistentVector(null,2,(5),inst_25015,inst_25018,null));
var state_25023__$1 = state_25023;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_25023__$1,(2),f_n,inst_25019);
} else {
if((state_val_25024 === (2))){
var inst_25021 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25023__$1,inst_25021);
} else {
return null;
}
}
});})(c__16901__auto__))
;
return ((function (switch__16799__auto__,c__16901__auto__){
return (function() {
var cljs_ipfs_api$utils$wrap_callback_$_callback_$_state_machine__16800__auto__ = null;
var cljs_ipfs_api$utils$wrap_callback_$_callback_$_state_machine__16800__auto____0 = (function (){
var statearr_25025 = [null,null,null,null,null,null,null];
(statearr_25025[(0)] = cljs_ipfs_api$utils$wrap_callback_$_callback_$_state_machine__16800__auto__);

(statearr_25025[(1)] = (1));

return statearr_25025;
});
var cljs_ipfs_api$utils$wrap_callback_$_callback_$_state_machine__16800__auto____1 = (function (state_25023){
while(true){
var ret_value__16801__auto__ = (function (){try{while(true){
var result__16802__auto__ = switch__16799__auto__(state_25023);
if(cljs.core.keyword_identical_QMARK_(result__16802__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16802__auto__;
}
break;
}
}catch (e25026){if((e25026 instanceof Object)){
var ex__16803__auto__ = e25026;
var statearr_25027_25031 = state_25023;
(statearr_25027_25031[(5)] = ex__16803__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_25023);

return cljs.core.cst$kw$recur;
} else {
throw e25026;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16801__auto__,cljs.core.cst$kw$recur)){
var G__25032 = state_25023;
state_25023 = G__25032;
continue;
} else {
return ret_value__16801__auto__;
}
break;
}
});
cljs_ipfs_api$utils$wrap_callback_$_callback_$_state_machine__16800__auto__ = function(state_25023){
switch(arguments.length){
case 0:
return cljs_ipfs_api$utils$wrap_callback_$_callback_$_state_machine__16800__auto____0.call(this);
case 1:
return cljs_ipfs_api$utils$wrap_callback_$_callback_$_state_machine__16800__auto____1.call(this,state_25023);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs_ipfs_api$utils$wrap_callback_$_callback_$_state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_ipfs_api$utils$wrap_callback_$_callback_$_state_machine__16800__auto____0;
cljs_ipfs_api$utils$wrap_callback_$_callback_$_state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_ipfs_api$utils$wrap_callback_$_callback_$_state_machine__16800__auto____1;
return cljs_ipfs_api$utils$wrap_callback_$_callback_$_state_machine__16800__auto__;
})()
;})(switch__16799__auto__,c__16901__auto__))
})();
var state__16903__auto__ = (function (){var statearr_25028 = (f__16902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16902__auto__.cljs$core$IFn$_invoke$arity$0() : f__16902__auto__.call(null));
(statearr_25028[(6)] = c__16901__auto__);

return statearr_25028;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16903__auto__);
});})(c__16901__auto__))
);

return c__16901__auto__;
} else {
if(cljs.core.fn_QMARK_(f_n)){
var G__25029 = (cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1 ? cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1(err) : cljs_ipfs_api.utils.js__GT_cljkk.call(null,err));
var G__25030 = (cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1 ? cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1(res) : cljs_ipfs_api.utils.js__GT_cljkk.call(null,res));
return (f_n.cljs$core$IFn$_invoke$arity$2 ? f_n.cljs$core$IFn$_invoke$arity$2(G__25029,G__25030) : f_n.call(null,G__25029,G__25030));
} else {
return f_n;
}
}
});
return callback;
});
cljs_ipfs_api.utils.is_blob_QMARK_ = (function cljs_ipfs_api$utils$is_blob_QMARK_(x){
return !(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(String,cljs.core.type(x)));
});
cljs_ipfs_api.utils.web_http_call = (function cljs_ipfs_api$utils$web_http_call(url,args,params){
var temp__5455__auto__ = cljs.core.cst$kw$callback.cljs$core$IFn$_invoke$arity$1(params);
if(cljs.core.truth_(temp__5455__auto__)){
var cb = temp__5455__auto__;
var c__16901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16901__auto__,cb,temp__5455__auto__){
return (function (){
var f__16902__auto__ = (function (){var switch__16799__auto__ = ((function (c__16901__auto__,cb,temp__5455__auto__){
return (function (state_25070){
var state_val_25071 = (state_25070[(1)]);
if((state_val_25071 === (1))){
var inst_25042 = (state_25070[(7)]);
var inst_25033 = [cljs.core.cst$kw$query_DASH_params,cljs.core.cst$kw$with_DASH_credentials_QMARK_];
var inst_25034 = ["arg"];
var inst_25035 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs_ipfs_api.utils.is_blob_QMARK_,args);
var inst_25036 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",inst_25035);
var inst_25037 = [inst_25036];
var inst_25038 = cljs.core.PersistentHashMap.fromArrays(inst_25034,inst_25037);
var inst_25039 = [inst_25038,false];
var inst_25040 = cljs.core.PersistentHashMap.fromArrays(inst_25033,inst_25039);
var inst_25041 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs_ipfs_api.utils.is_blob_QMARK_,args);
var inst_25042__$1 = cljs.core.first(inst_25041);
var state_25070__$1 = (function (){var statearr_25072 = state_25070;
(statearr_25072[(8)] = inst_25040);

(statearr_25072[(7)] = inst_25042__$1);

return statearr_25072;
})();
if(cljs.core.truth_(inst_25042__$1)){
var statearr_25073_25086 = state_25070__$1;
(statearr_25073_25086[(1)] = (3));

} else {
var statearr_25074_25087 = state_25070__$1;
(statearr_25074_25087[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25071 === (2))){
var inst_25059 = (state_25070[(9)]);
var inst_25059__$1 = (state_25070[(2)]);
var inst_25060 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_25059__$1);
var inst_25061 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_25060,(200));
var state_25070__$1 = (function (){var statearr_25075 = state_25070;
(statearr_25075[(9)] = inst_25059__$1);

return statearr_25075;
})();
if(inst_25061){
var statearr_25076_25088 = state_25070__$1;
(statearr_25076_25088[(1)] = (6));

} else {
var statearr_25077_25089 = state_25070__$1;
(statearr_25077_25089[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25071 === (3))){
var inst_25042 = (state_25070[(7)]);
var inst_25044 = [cljs.core.cst$kw$multipart_DASH_params];
var inst_25045 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25046 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25047 = ["file",inst_25042];
var inst_25048 = (new cljs.core.PersistentVector(null,2,(5),inst_25046,inst_25047,null));
var inst_25049 = [inst_25048];
var inst_25050 = (new cljs.core.PersistentVector(null,1,(5),inst_25045,inst_25049,null));
var inst_25051 = [inst_25050];
var inst_25052 = cljs.core.PersistentHashMap.fromArrays(inst_25044,inst_25051);
var state_25070__$1 = state_25070;
var statearr_25078_25090 = state_25070__$1;
(statearr_25078_25090[(2)] = inst_25052);

(statearr_25078_25090[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25071 === (4))){
var state_25070__$1 = state_25070;
var statearr_25079_25091 = state_25070__$1;
(statearr_25079_25091[(2)] = null);

(statearr_25079_25091[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25071 === (5))){
var inst_25040 = (state_25070[(8)]);
var inst_25055 = (state_25070[(2)]);
var inst_25056 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_25040,inst_25055], 0));
var inst_25057 = cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic(url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_25056], 0));
var state_25070__$1 = state_25070;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25070__$1,(2),inst_25057);
} else {
if((state_val_25071 === (6))){
var inst_25059 = (state_25070[(9)]);
var inst_25063 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_25059);
var inst_25064 = (cb.cljs$core$IFn$_invoke$arity$2 ? cb.cljs$core$IFn$_invoke$arity$2(null,inst_25063) : cb.call(null,null,inst_25063));
var state_25070__$1 = state_25070;
var statearr_25080_25092 = state_25070__$1;
(statearr_25080_25092[(2)] = inst_25064);

(statearr_25080_25092[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25071 === (7))){
var inst_25059 = (state_25070[(9)]);
var inst_25066 = (cb.cljs$core$IFn$_invoke$arity$2 ? cb.cljs$core$IFn$_invoke$arity$2(inst_25059,null) : cb.call(null,inst_25059,null));
var state_25070__$1 = state_25070;
var statearr_25081_25093 = state_25070__$1;
(statearr_25081_25093[(2)] = inst_25066);

(statearr_25081_25093[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25071 === (8))){
var inst_25068 = (state_25070[(2)]);
var state_25070__$1 = state_25070;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25070__$1,inst_25068);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__16901__auto__,cb,temp__5455__auto__))
;
return ((function (switch__16799__auto__,c__16901__auto__,cb,temp__5455__auto__){
return (function() {
var cljs_ipfs_api$utils$web_http_call_$_state_machine__16800__auto__ = null;
var cljs_ipfs_api$utils$web_http_call_$_state_machine__16800__auto____0 = (function (){
var statearr_25082 = [null,null,null,null,null,null,null,null,null,null];
(statearr_25082[(0)] = cljs_ipfs_api$utils$web_http_call_$_state_machine__16800__auto__);

(statearr_25082[(1)] = (1));

return statearr_25082;
});
var cljs_ipfs_api$utils$web_http_call_$_state_machine__16800__auto____1 = (function (state_25070){
while(true){
var ret_value__16801__auto__ = (function (){try{while(true){
var result__16802__auto__ = switch__16799__auto__(state_25070);
if(cljs.core.keyword_identical_QMARK_(result__16802__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16802__auto__;
}
break;
}
}catch (e25083){if((e25083 instanceof Object)){
var ex__16803__auto__ = e25083;
var statearr_25084_25094 = state_25070;
(statearr_25084_25094[(5)] = ex__16803__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_25070);

return cljs.core.cst$kw$recur;
} else {
throw e25083;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16801__auto__,cljs.core.cst$kw$recur)){
var G__25095 = state_25070;
state_25070 = G__25095;
continue;
} else {
return ret_value__16801__auto__;
}
break;
}
});
cljs_ipfs_api$utils$web_http_call_$_state_machine__16800__auto__ = function(state_25070){
switch(arguments.length){
case 0:
return cljs_ipfs_api$utils$web_http_call_$_state_machine__16800__auto____0.call(this);
case 1:
return cljs_ipfs_api$utils$web_http_call_$_state_machine__16800__auto____1.call(this,state_25070);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs_ipfs_api$utils$web_http_call_$_state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_ipfs_api$utils$web_http_call_$_state_machine__16800__auto____0;
cljs_ipfs_api$utils$web_http_call_$_state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_ipfs_api$utils$web_http_call_$_state_machine__16800__auto____1;
return cljs_ipfs_api$utils$web_http_call_$_state_machine__16800__auto__;
})()
;})(switch__16799__auto__,c__16901__auto__,cb,temp__5455__auto__))
})();
var state__16903__auto__ = (function (){var statearr_25085 = (f__16902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16902__auto__.cljs$core$IFn$_invoke$arity$0() : f__16902__auto__.call(null));
(statearr_25085[(6)] = c__16901__auto__);

return statearr_25085;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16903__auto__);
});})(c__16901__auto__,cb,temp__5455__auto__))
);

return c__16901__auto__;
} else {
return null;
}
});
cljs_ipfs_api.utils.node_http_call = (function cljs_ipfs_api$utils$node_http_call(url,args,params){
var temp__5455__auto__ = cljs.core.cst$kw$callback.cljs$core$IFn$_invoke$arity$1(params);
if(cljs.core.truth_(temp__5455__auto__)){
var cb = temp__5455__auto__;
var rm = require("request");
var fs = require("fs");
var on_done = ((function (rm,fs,cb,temp__5455__auto__){
return (function (err,oresp,obody){
var err__$1 = (cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1 ? cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1(err) : cljs_ipfs_api.utils.js__GT_cljkk.call(null,err));
var resp = (cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1 ? cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1(oresp) : cljs_ipfs_api.utils.js__GT_cljkk.call(null,oresp));
var body = (cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1 ? cljs_ipfs_api.utils.js__GT_cljkk.cljs$core$IFn$_invoke$arity$1(obody) : cljs_ipfs_api.utils.js__GT_cljkk.call(null,obody));
if(cljs.core.truth_(err__$1)){
return (cb.cljs$core$IFn$_invoke$arity$2 ? cb.cljs$core$IFn$_invoke$arity$2(err__$1,null) : cb.call(null,err__$1,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(resp.statusCode,(200))){
var G__25096 = null;
var G__25097 = (function (){try{return JSON.parse(body);
}catch (e25098){if((e25098 instanceof SyntaxError)){
var e = e25098;
return body;
} else {
throw e25098;

}
}})();
return (cb.cljs$core$IFn$_invoke$arity$2 ? cb.cljs$core$IFn$_invoke$arity$2(G__25096,G__25097) : cb.call(null,G__25096,G__25097));
} else {
var G__25099 = resp.statusMessage;
var G__25100 = null;
return (cb.cljs$core$IFn$_invoke$arity$2 ? cb.cljs$core$IFn$_invoke$arity$2(G__25099,G__25100) : cb.call(null,G__25099,G__25100));

}
}
});})(rm,fs,cb,temp__5455__auto__))
;
var form = (function (){var temp__5457__auto__ = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs_ipfs_api.utils.is_blob_QMARK_,args));
if(cljs.core.truth_(temp__5457__auto__)){
var b = temp__5457__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$formData,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$file,b], null)], null);
} else {
return null;
}
})();
var req = rm.post(cljs.core.clj__GT_js(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$qs,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arg,clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs_ipfs_api.utils.is_blob_QMARK_,args))], null),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$req_DASH_opts], null))], 0))], null),form], 0))),on_done);
var temp__5457__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$pipe_DASH_to], null));
if(cljs.core.truth_(temp__5457__auto__)){
var out = temp__5457__auto__;
return req.pipe(out);
} else {
return null;
}
} else {
return null;
}
});
cljs_ipfs_api.utils.http_call = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_target_STAR_,"nodejs"))?cljs_ipfs_api.utils.node_http_call:cljs_ipfs_api.utils.web_http_call);
cljs_ipfs_api.utils.api_call = (function cljs_ipfs_api$utils$api_call(inst,ac,args,params){
var G__25101 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$host.cljs$core$IFn$_invoke$arity$1(inst)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$endpoint.cljs$core$IFn$_invoke$arity$1(inst)),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ac)].join('');
var G__25102 = args;
var G__25103 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$opts,cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(params),cljs.core.cst$kw$callback,cljs.core.cst$kw$callback.cljs$core$IFn$_invoke$arity$1(params)], null)], 0));
return (cljs_ipfs_api.utils.http_call.cljs$core$IFn$_invoke$arity$3 ? cljs_ipfs_api.utils.http_call.cljs$core$IFn$_invoke$arity$3(G__25101,G__25102,G__25103) : cljs_ipfs_api.utils.http_call.call(null,G__25101,G__25102,G__25103));
});
