// Compiled by ClojureScript 1.9.946 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('cljs_http.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.net.EventType');
goog.require('goog.net.ErrorCode');
goog.require('goog.net.XhrIo');
goog.require('goog.net.Jsonp');
goog.require('cljs_http.util');
goog.require('cljs.core.async');
goog.require('clojure.string');
cljs_http.core.pending_requests = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
/**
 * Attempt to close the given channel and abort the pending HTTP request
 *   with which it is associated.
 */
cljs_http.core.abort_BANG_ = (function cljs_http$core$abort_BANG_(channel){
var temp__5457__auto__ = (function (){var fexpr__18828 = cljs.core.deref(cljs_http.core.pending_requests);
return (fexpr__18828.cljs$core$IFn$_invoke$arity$1 ? fexpr__18828.cljs$core$IFn$_invoke$arity$1(channel) : fexpr__18828.call(null,channel));
})();
if(cljs.core.truth_(temp__5457__auto__)){
var req = temp__5457__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

cljs.core.async.close_BANG_(channel);

if(cljs.core.truth_(req.hasOwnProperty("abort"))){
return req.abort();
} else {
return cljs.core.cst$kw$jsonp.cljs$core$IFn$_invoke$arity$1(req).cancel(cljs.core.cst$kw$request.cljs$core$IFn$_invoke$arity$1(req));
}
} else {
return null;
}
});
cljs_http.core.aborted_QMARK_ = (function cljs_http$core$aborted_QMARK_(xhr){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(xhr.getLastErrorCode(),goog.net.ErrorCode.ABORT);
});
/**
 * Takes an XhrIo object and applies the default-headers to it.
 */
cljs_http.core.apply_default_headers_BANG_ = (function cljs_http$core$apply_default_headers_BANG_(xhr,headers){
var formatted_h = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.util.camelize,cljs.core.keys(headers)),cljs.core.vals(headers));
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (formatted_h){
return (function (p__18829){
var vec__18830 = p__18829;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18830,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18830,(1),null);
return xhr.headers.set(k,v);
});})(formatted_h))
,formatted_h));
});
/**
 * Takes an XhrIo object and sets response-type if not nil.
 */
cljs_http.core.apply_response_type_BANG_ = (function cljs_http$core$apply_response_type_BANG_(xhr,response_type){
return xhr.setResponseType((function (){var G__18833 = response_type;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$array_DASH_buffer,G__18833)){
return goog.net.XhrIo.ResponseType.ARRAY_BUFFER;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$blob,G__18833)){
return goog.net.XhrIo.ResponseType.BLOB;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$document,G__18833)){
return goog.net.XhrIo.ResponseType.DOCUMENT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$text,G__18833)){
return goog.net.XhrIo.ResponseType.TEXT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$default,G__18833)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,G__18833)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__18833)].join('')));

}
}
}
}
}
}
})());
});
/**
 * Builds an XhrIo object from the request parameters.
 */
cljs_http.core.build_xhr = (function cljs_http$core$build_xhr(p__18834){
var map__18835 = p__18834;
var map__18835__$1 = ((((!((map__18835 == null)))?((((map__18835.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18835.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18835):map__18835);
var request = map__18835__$1;
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18835__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var default_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18835__$1,cljs.core.cst$kw$default_DASH_headers);
var response_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18835__$1,cljs.core.cst$kw$response_DASH_type);
var timeout = (function (){var or__8806__auto__ = cljs.core.cst$kw$timeout.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__8806__auto__)){
return or__8806__auto__;
} else {
return (0);
}
})();
var send_credentials = (((with_credentials_QMARK_ == null))?true:with_credentials_QMARK_);
var G__18837 = (new goog.net.XhrIo());
cljs_http.core.apply_default_headers_BANG_(G__18837,default_headers);

cljs_http.core.apply_response_type_BANG_(G__18837,response_type);

G__18837.setTimeoutInterval(timeout);

G__18837.setWithCredentials(send_credentials);

return G__18837;
});
cljs_http.core.error_kw = cljs.core.PersistentHashMap.fromArrays([(0),(7),(1),(4),(6),(3),(2),(9),(5),(8)],[cljs.core.cst$kw$no_DASH_error,cljs.core.cst$kw$abort,cljs.core.cst$kw$access_DASH_denied,cljs.core.cst$kw$custom_DASH_error,cljs.core.cst$kw$http_DASH_error,cljs.core.cst$kw$ff_DASH_silent_DASH_error,cljs.core.cst$kw$file_DASH_not_DASH_found,cljs.core.cst$kw$offline,cljs.core.cst$kw$exception,cljs.core.cst$kw$timeout]);
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.xhr = (function cljs_http$core$xhr(p__18838){
var map__18839 = p__18838;
var map__18839__$1 = ((((!((map__18839 == null)))?((((map__18839.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18839.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18839):map__18839);
var request = map__18839__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18839__$1,cljs.core.cst$kw$request_DASH_method);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18839__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18839__$1,cljs.core.cst$kw$body);
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18839__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18839__$1,cljs.core.cst$kw$cancel);
var progress = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18839__$1,cljs.core.cst$kw$progress);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var request_url = cljs_http.util.build_url(request);
var method = cljs.core.name((function (){var or__8806__auto__ = request_method;
if(cljs.core.truth_(or__8806__auto__)){
return or__8806__auto__;
} else {
return cljs.core.cst$kw$get;
}
})());
var headers__$1 = cljs_http.util.build_headers(headers);
var xhr = cljs_http.core.build_xhr(request);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,xhr);

xhr.listen(goog.net.EventType.COMPLETE,((function (channel,request_url,method,headers__$1,xhr,map__18839,map__18839__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (evt){
var target = evt.target;
var response = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$status,target.getStatus(),cljs.core.cst$kw$success,target.isSuccess(),cljs.core.cst$kw$body,target.getResponse(),cljs.core.cst$kw$headers,cljs_http.util.parse_headers(target.getAllResponseHeaders()),cljs.core.cst$kw$trace_DASH_redirects,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_url,target.getLastUri()], null),cljs.core.cst$kw$error_DASH_code,(function (){var G__18841 = target.getLastErrorCode();
return (cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1 ? cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1(G__18841) : cljs_http.core.error_kw.call(null,G__18841));
})(),cljs.core.cst$kw$error_DASH_text,target.getLastError()], null);
if(cljs.core.not(cljs_http.core.aborted_QMARK_(xhr))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,request_url,method,headers__$1,xhr,map__18839,map__18839__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
);

if(cljs.core.truth_(progress)){
var listener_18864 = ((function (channel,request_url,method,headers__$1,xhr,map__18839,map__18839__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (direction,evt){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(progress,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$direction,direction,cljs.core.cst$kw$loaded,evt.loaded], null),(cljs.core.truth_(evt.lengthComputable)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$total,evt.total], null):null)], 0)));
});})(channel,request_url,method,headers__$1,xhr,map__18839,map__18839__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
;
var G__18842_18865 = xhr;
G__18842_18865.setProgressEventsEnabled(true);

G__18842_18865.listen(goog.net.EventType.UPLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_18864,cljs.core.cst$kw$upload));

G__18842_18865.listen(goog.net.EventType.DOWNLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_18864,cljs.core.cst$kw$download));

} else {
}

xhr.send(request_url,method,body,headers__$1);

if(cljs.core.truth_(cancel)){
var c__16901__auto___18866 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16901__auto___18866,channel,request_url,method,headers__$1,xhr,map__18839,map__18839__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (){
var f__16902__auto__ = (function (){var switch__16799__auto__ = ((function (c__16901__auto___18866,channel,request_url,method,headers__$1,xhr,map__18839,map__18839__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (state_18853){
var state_val_18854 = (state_18853[(1)]);
if((state_val_18854 === (1))){
var state_18853__$1 = state_18853;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18853__$1,(2),cancel);
} else {
if((state_val_18854 === (2))){
var inst_18844 = (state_18853[(2)]);
var inst_18845 = xhr.isComplete();
var inst_18846 = cljs.core.not(inst_18845);
var state_18853__$1 = (function (){var statearr_18855 = state_18853;
(statearr_18855[(7)] = inst_18844);

return statearr_18855;
})();
if(inst_18846){
var statearr_18856_18867 = state_18853__$1;
(statearr_18856_18867[(1)] = (3));

} else {
var statearr_18857_18868 = state_18853__$1;
(statearr_18857_18868[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18854 === (3))){
var inst_18848 = xhr.abort();
var state_18853__$1 = state_18853;
var statearr_18858_18869 = state_18853__$1;
(statearr_18858_18869[(2)] = inst_18848);

(statearr_18858_18869[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18854 === (4))){
var state_18853__$1 = state_18853;
var statearr_18859_18870 = state_18853__$1;
(statearr_18859_18870[(2)] = null);

(statearr_18859_18870[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18854 === (5))){
var inst_18851 = (state_18853[(2)]);
var state_18853__$1 = state_18853;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18853__$1,inst_18851);
} else {
return null;
}
}
}
}
}
});})(c__16901__auto___18866,channel,request_url,method,headers__$1,xhr,map__18839,map__18839__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
;
return ((function (switch__16799__auto__,c__16901__auto___18866,channel,request_url,method,headers__$1,xhr,map__18839,map__18839__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function() {
var cljs_http$core$xhr_$_state_machine__16800__auto__ = null;
var cljs_http$core$xhr_$_state_machine__16800__auto____0 = (function (){
var statearr_18860 = [null,null,null,null,null,null,null,null];
(statearr_18860[(0)] = cljs_http$core$xhr_$_state_machine__16800__auto__);

(statearr_18860[(1)] = (1));

return statearr_18860;
});
var cljs_http$core$xhr_$_state_machine__16800__auto____1 = (function (state_18853){
while(true){
var ret_value__16801__auto__ = (function (){try{while(true){
var result__16802__auto__ = switch__16799__auto__(state_18853);
if(cljs.core.keyword_identical_QMARK_(result__16802__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16802__auto__;
}
break;
}
}catch (e18861){if((e18861 instanceof Object)){
var ex__16803__auto__ = e18861;
var statearr_18862_18871 = state_18853;
(statearr_18862_18871[(5)] = ex__16803__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18853);

return cljs.core.cst$kw$recur;
} else {
throw e18861;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16801__auto__,cljs.core.cst$kw$recur)){
var G__18872 = state_18853;
state_18853 = G__18872;
continue;
} else {
return ret_value__16801__auto__;
}
break;
}
});
cljs_http$core$xhr_$_state_machine__16800__auto__ = function(state_18853){
switch(arguments.length){
case 0:
return cljs_http$core$xhr_$_state_machine__16800__auto____0.call(this);
case 1:
return cljs_http$core$xhr_$_state_machine__16800__auto____1.call(this,state_18853);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs_http$core$xhr_$_state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$xhr_$_state_machine__16800__auto____0;
cljs_http$core$xhr_$_state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$xhr_$_state_machine__16800__auto____1;
return cljs_http$core$xhr_$_state_machine__16800__auto__;
})()
;})(switch__16799__auto__,c__16901__auto___18866,channel,request_url,method,headers__$1,xhr,map__18839,map__18839__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
})();
var state__16903__auto__ = (function (){var statearr_18863 = (f__16902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16902__auto__.cljs$core$IFn$_invoke$arity$0() : f__16902__auto__.call(null));
(statearr_18863[(6)] = c__16901__auto___18866);

return statearr_18863;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16903__auto__);
});})(c__16901__auto___18866,channel,request_url,method,headers__$1,xhr,map__18839,map__18839__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
);

} else {
}

return channel;
});
/**
 * Execute the JSONP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.jsonp = (function cljs_http$core$jsonp(p__18873){
var map__18874 = p__18873;
var map__18874__$1 = ((((!((map__18874 == null)))?((((map__18874.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18874.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18874):map__18874);
var request = map__18874__$1;
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18874__$1,cljs.core.cst$kw$timeout);
var callback_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18874__$1,cljs.core.cst$kw$callback_DASH_name);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18874__$1,cljs.core.cst$kw$cancel);
var keywordize_keys_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__18874__$1,cljs.core.cst$kw$keywordize_DASH_keys_QMARK_,true);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var jsonp = (new goog.net.Jsonp(cljs_http.util.build_url(request),callback_name));
jsonp.setRequestTimeout(timeout);

var req_18887 = jsonp.send(null,((function (channel,jsonp,map__18874,map__18874__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function cljs_http$core$jsonp_$_success_callback(data){
var response = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(200),cljs.core.cst$kw$success,true,cljs.core.cst$kw$body,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,keywordize_keys_QMARK_], 0))], null);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp,map__18874,map__18874__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
,((function (channel,jsonp,map__18874,map__18874__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function cljs_http$core$jsonp_$_error_callback(){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp,map__18874,map__18874__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$jsonp,jsonp,cljs.core.cst$kw$request,req_18887], null));

if(cljs.core.truth_(cancel)){
var c__16901__auto___18888 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16901__auto___18888,req_18887,channel,jsonp,map__18874,map__18874__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function (){
var f__16902__auto__ = (function (){var switch__16799__auto__ = ((function (c__16901__auto___18888,req_18887,channel,jsonp,map__18874,map__18874__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function (state_18880){
var state_val_18881 = (state_18880[(1)]);
if((state_val_18881 === (1))){
var state_18880__$1 = state_18880;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18880__$1,(2),cancel);
} else {
if((state_val_18881 === (2))){
var inst_18877 = (state_18880[(2)]);
var inst_18878 = jsonp.cancel(req_18887);
var state_18880__$1 = (function (){var statearr_18882 = state_18880;
(statearr_18882[(7)] = inst_18877);

return statearr_18882;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_18880__$1,inst_18878);
} else {
return null;
}
}
});})(c__16901__auto___18888,req_18887,channel,jsonp,map__18874,map__18874__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
;
return ((function (switch__16799__auto__,c__16901__auto___18888,req_18887,channel,jsonp,map__18874,map__18874__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function() {
var cljs_http$core$jsonp_$_state_machine__16800__auto__ = null;
var cljs_http$core$jsonp_$_state_machine__16800__auto____0 = (function (){
var statearr_18883 = [null,null,null,null,null,null,null,null];
(statearr_18883[(0)] = cljs_http$core$jsonp_$_state_machine__16800__auto__);

(statearr_18883[(1)] = (1));

return statearr_18883;
});
var cljs_http$core$jsonp_$_state_machine__16800__auto____1 = (function (state_18880){
while(true){
var ret_value__16801__auto__ = (function (){try{while(true){
var result__16802__auto__ = switch__16799__auto__(state_18880);
if(cljs.core.keyword_identical_QMARK_(result__16802__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16802__auto__;
}
break;
}
}catch (e18884){if((e18884 instanceof Object)){
var ex__16803__auto__ = e18884;
var statearr_18885_18889 = state_18880;
(statearr_18885_18889[(5)] = ex__16803__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18880);

return cljs.core.cst$kw$recur;
} else {
throw e18884;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16801__auto__,cljs.core.cst$kw$recur)){
var G__18890 = state_18880;
state_18880 = G__18890;
continue;
} else {
return ret_value__16801__auto__;
}
break;
}
});
cljs_http$core$jsonp_$_state_machine__16800__auto__ = function(state_18880){
switch(arguments.length){
case 0:
return cljs_http$core$jsonp_$_state_machine__16800__auto____0.call(this);
case 1:
return cljs_http$core$jsonp_$_state_machine__16800__auto____1.call(this,state_18880);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs_http$core$jsonp_$_state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$jsonp_$_state_machine__16800__auto____0;
cljs_http$core$jsonp_$_state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$jsonp_$_state_machine__16800__auto____1;
return cljs_http$core$jsonp_$_state_machine__16800__auto__;
})()
;})(switch__16799__auto__,c__16901__auto___18888,req_18887,channel,jsonp,map__18874,map__18874__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
})();
var state__16903__auto__ = (function (){var statearr_18886 = (f__16902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16902__auto__.cljs$core$IFn$_invoke$arity$0() : f__16902__auto__.call(null));
(statearr_18886[(6)] = c__16901__auto___18888);

return statearr_18886;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16903__auto__);
});})(c__16901__auto___18888,req_18887,channel,jsonp,map__18874,map__18874__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
);

} else {
}

return channel;
});
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.request = (function cljs_http$core$request(p__18891){
var map__18892 = p__18891;
var map__18892__$1 = ((((!((map__18892 == null)))?((((map__18892.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18892.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18892):map__18892);
var request = map__18892__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18892__$1,cljs.core.cst$kw$request_DASH_method);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(request_method,cljs.core.cst$kw$jsonp)){
return cljs_http.core.jsonp(request);
} else {
return cljs_http.core.xhr(request);
}
});
