// Compiled by ClojureScript 1.9.946 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__16961 = arguments.length;
switch (G__16961) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async16962 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16962 = (function (f,blockable,meta16963){
this.f = f;
this.blockable = blockable;
this.meta16963 = meta16963;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async16962.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16964,meta16963__$1){
var self__ = this;
var _16964__$1 = this;
return (new cljs.core.async.t_cljs$core$async16962(self__.f,self__.blockable,meta16963__$1));
});

cljs.core.async.t_cljs$core$async16962.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16964){
var self__ = this;
var _16964__$1 = this;
return self__.meta16963;
});

cljs.core.async.t_cljs$core$async16962.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16962.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async16962.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async16962.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async16962.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta16963], null);
});

cljs.core.async.t_cljs$core$async16962.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16962.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16962";

cljs.core.async.t_cljs$core$async16962.cljs$lang$ctorPrWriter = (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async16962");
});

cljs.core.async.__GT_t_cljs$core$async16962 = (function cljs$core$async$__GT_t_cljs$core$async16962(f__$1,blockable__$1,meta16963){
return (new cljs.core.async.t_cljs$core$async16962(f__$1,blockable__$1,meta16963));
});

}

return (new cljs.core.async.t_cljs$core$async16962(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__16968 = arguments.length;
switch (G__16968) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__16971 = arguments.length;
switch (G__16971) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__16974 = arguments.length;
switch (G__16974) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_16976 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_16976) : fn1.call(null,val_16976));
} else {
cljs.core.async.impl.dispatch.run(((function (val_16976,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_16976) : fn1.call(null,val_16976));
});})(val_16976,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__16978 = arguments.length;
switch (G__16978) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5455__auto__)){
var ret = temp__5455__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5455__auto__)){
var retb = temp__5455__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__5455__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__5455__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__9851__auto___16980 = n;
var x_16981 = (0);
while(true){
if((x_16981 < n__9851__auto___16980)){
(a[x_16981] = (0));

var G__16982 = (x_16981 + (1));
x_16981 = G__16982;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__16983 = (i + (1));
i = G__16983;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if(typeof cljs.core.async.t_cljs$core$async16984 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16984 = (function (flag,meta16985){
this.flag = flag;
this.meta16985 = meta16985;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async16984.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_16986,meta16985__$1){
var self__ = this;
var _16986__$1 = this;
return (new cljs.core.async.t_cljs$core$async16984(self__.flag,meta16985__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async16984.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_16986){
var self__ = this;
var _16986__$1 = this;
return self__.meta16985;
});})(flag))
;

cljs.core.async.t_cljs$core$async16984.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16984.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async16984.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async16984.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async16984.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta16985], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async16984.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16984.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16984";

cljs.core.async.t_cljs$core$async16984.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async16984");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async16984 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async16984(flag__$1,meta16985){
return (new cljs.core.async.t_cljs$core$async16984(flag__$1,meta16985));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async16984(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async16987 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16987 = (function (flag,cb,meta16988){
this.flag = flag;
this.cb = cb;
this.meta16988 = meta16988;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async16987.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16989,meta16988__$1){
var self__ = this;
var _16989__$1 = this;
return (new cljs.core.async.t_cljs$core$async16987(self__.flag,self__.cb,meta16988__$1));
});

cljs.core.async.t_cljs$core$async16987.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16989){
var self__ = this;
var _16989__$1 = this;
return self__.meta16988;
});

cljs.core.async.t_cljs$core$async16987.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16987.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async16987.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async16987.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async16987.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta16988], null);
});

cljs.core.async.t_cljs$core$async16987.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16987.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16987";

cljs.core.async.t_cljs$core$async16987.cljs$lang$ctorPrWriter = (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async16987");
});

cljs.core.async.__GT_t_cljs$core$async16987 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async16987(flag__$1,cb__$1,meta16988){
return (new cljs.core.async.t_cljs$core$async16987(flag__$1,cb__$1,meta16988));
});

}

return (new cljs.core.async.t_cljs$core$async16987(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__16990_SHARP_){
var G__16992 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16990_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__16992) : fret.call(null,G__16992));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__16991_SHARP_){
var G__16993 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16991_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__16993) : fret.call(null,G__16993));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__8806__auto__ = wport;
if(cljs.core.truth_(or__8806__auto__)){
return or__8806__auto__;
} else {
return port;
}
})()], null));
} else {
var G__16994 = (i + (1));
i = G__16994;
continue;
}
} else {
return null;
}
break;
}
})();
var or__8806__auto__ = ret;
if(cljs.core.truth_(or__8806__auto__)){
return or__8806__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__5457__auto__ = (function (){var and__8794__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__8794__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__8794__auto__;
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var got = temp__5457__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__10092__auto__ = [];
var len__10085__auto___17000 = arguments.length;
var i__10086__auto___17001 = (0);
while(true){
if((i__10086__auto___17001 < len__10085__auto___17000)){
args__10092__auto__.push((arguments[i__10086__auto___17001]));

var G__17002 = (i__10086__auto___17001 + (1));
i__10086__auto___17001 = G__17002;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((1) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10093__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__16997){
var map__16998 = p__16997;
var map__16998__$1 = ((((!((map__16998 == null)))?((((map__16998.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16998.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16998):map__16998);
var opts = map__16998__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq16995){
var G__16996 = cljs.core.first(seq16995);
var seq16995__$1 = cljs.core.next(seq16995);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__16996,seq16995__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__17004 = arguments.length;
switch (G__17004) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__16901__auto___17050 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16901__auto___17050){
return (function (){
var f__16902__auto__ = (function (){var switch__16799__auto__ = ((function (c__16901__auto___17050){
return (function (state_17028){
var state_val_17029 = (state_17028[(1)]);
if((state_val_17029 === (7))){
var inst_17024 = (state_17028[(2)]);
var state_17028__$1 = state_17028;
var statearr_17030_17051 = state_17028__$1;
(statearr_17030_17051[(2)] = inst_17024);

(statearr_17030_17051[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17029 === (1))){
var state_17028__$1 = state_17028;
var statearr_17031_17052 = state_17028__$1;
(statearr_17031_17052[(2)] = null);

(statearr_17031_17052[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17029 === (4))){
var inst_17007 = (state_17028[(7)]);
var inst_17007__$1 = (state_17028[(2)]);
var inst_17008 = (inst_17007__$1 == null);
var state_17028__$1 = (function (){var statearr_17032 = state_17028;
(statearr_17032[(7)] = inst_17007__$1);

return statearr_17032;
})();
if(cljs.core.truth_(inst_17008)){
var statearr_17033_17053 = state_17028__$1;
(statearr_17033_17053[(1)] = (5));

} else {
var statearr_17034_17054 = state_17028__$1;
(statearr_17034_17054[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17029 === (13))){
var state_17028__$1 = state_17028;
var statearr_17035_17055 = state_17028__$1;
(statearr_17035_17055[(2)] = null);

(statearr_17035_17055[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17029 === (6))){
var inst_17007 = (state_17028[(7)]);
var state_17028__$1 = state_17028;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17028__$1,(11),to,inst_17007);
} else {
if((state_val_17029 === (3))){
var inst_17026 = (state_17028[(2)]);
var state_17028__$1 = state_17028;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17028__$1,inst_17026);
} else {
if((state_val_17029 === (12))){
var state_17028__$1 = state_17028;
var statearr_17036_17056 = state_17028__$1;
(statearr_17036_17056[(2)] = null);

(statearr_17036_17056[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17029 === (2))){
var state_17028__$1 = state_17028;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17028__$1,(4),from);
} else {
if((state_val_17029 === (11))){
var inst_17017 = (state_17028[(2)]);
var state_17028__$1 = state_17028;
if(cljs.core.truth_(inst_17017)){
var statearr_17037_17057 = state_17028__$1;
(statearr_17037_17057[(1)] = (12));

} else {
var statearr_17038_17058 = state_17028__$1;
(statearr_17038_17058[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17029 === (9))){
var state_17028__$1 = state_17028;
var statearr_17039_17059 = state_17028__$1;
(statearr_17039_17059[(2)] = null);

(statearr_17039_17059[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17029 === (5))){
var state_17028__$1 = state_17028;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17040_17060 = state_17028__$1;
(statearr_17040_17060[(1)] = (8));

} else {
var statearr_17041_17061 = state_17028__$1;
(statearr_17041_17061[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17029 === (14))){
var inst_17022 = (state_17028[(2)]);
var state_17028__$1 = state_17028;
var statearr_17042_17062 = state_17028__$1;
(statearr_17042_17062[(2)] = inst_17022);

(statearr_17042_17062[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17029 === (10))){
var inst_17014 = (state_17028[(2)]);
var state_17028__$1 = state_17028;
var statearr_17043_17063 = state_17028__$1;
(statearr_17043_17063[(2)] = inst_17014);

(statearr_17043_17063[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17029 === (8))){
var inst_17011 = cljs.core.async.close_BANG_(to);
var state_17028__$1 = state_17028;
var statearr_17044_17064 = state_17028__$1;
(statearr_17044_17064[(2)] = inst_17011);

(statearr_17044_17064[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16901__auto___17050))
;
return ((function (switch__16799__auto__,c__16901__auto___17050){
return (function() {
var cljs$core$async$state_machine__16800__auto__ = null;
var cljs$core$async$state_machine__16800__auto____0 = (function (){
var statearr_17045 = [null,null,null,null,null,null,null,null];
(statearr_17045[(0)] = cljs$core$async$state_machine__16800__auto__);

(statearr_17045[(1)] = (1));

return statearr_17045;
});
var cljs$core$async$state_machine__16800__auto____1 = (function (state_17028){
while(true){
var ret_value__16801__auto__ = (function (){try{while(true){
var result__16802__auto__ = switch__16799__auto__(state_17028);
if(cljs.core.keyword_identical_QMARK_(result__16802__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16802__auto__;
}
break;
}
}catch (e17046){if((e17046 instanceof Object)){
var ex__16803__auto__ = e17046;
var statearr_17047_17065 = state_17028;
(statearr_17047_17065[(5)] = ex__16803__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17028);

return cljs.core.cst$kw$recur;
} else {
throw e17046;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16801__auto__,cljs.core.cst$kw$recur)){
var G__17066 = state_17028;
state_17028 = G__17066;
continue;
} else {
return ret_value__16801__auto__;
}
break;
}
});
cljs$core$async$state_machine__16800__auto__ = function(state_17028){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16800__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16800__auto____1.call(this,state_17028);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16800__auto____0;
cljs$core$async$state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16800__auto____1;
return cljs$core$async$state_machine__16800__auto__;
})()
;})(switch__16799__auto__,c__16901__auto___17050))
})();
var state__16903__auto__ = (function (){var statearr_17048 = (f__16902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16902__auto__.cljs$core$IFn$_invoke$arity$0() : f__16902__auto__.call(null));
(statearr_17048[(6)] = c__16901__auto___17050);

return statearr_17048;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16903__auto__);
});})(c__16901__auto___17050))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__17067){
var vec__17068 = p__17067;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17068,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17068,(1),null);
var job = vec__17068;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__16901__auto___17239 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16901__auto___17239,res,vec__17068,v,p,job,jobs,results){
return (function (){
var f__16902__auto__ = (function (){var switch__16799__auto__ = ((function (c__16901__auto___17239,res,vec__17068,v,p,job,jobs,results){
return (function (state_17075){
var state_val_17076 = (state_17075[(1)]);
if((state_val_17076 === (1))){
var state_17075__$1 = state_17075;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17075__$1,(2),res,v);
} else {
if((state_val_17076 === (2))){
var inst_17072 = (state_17075[(2)]);
var inst_17073 = cljs.core.async.close_BANG_(res);
var state_17075__$1 = (function (){var statearr_17077 = state_17075;
(statearr_17077[(7)] = inst_17072);

return statearr_17077;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_17075__$1,inst_17073);
} else {
return null;
}
}
});})(c__16901__auto___17239,res,vec__17068,v,p,job,jobs,results))
;
return ((function (switch__16799__auto__,c__16901__auto___17239,res,vec__17068,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16800__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16800__auto____0 = (function (){
var statearr_17078 = [null,null,null,null,null,null,null,null];
(statearr_17078[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16800__auto__);

(statearr_17078[(1)] = (1));

return statearr_17078;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16800__auto____1 = (function (state_17075){
while(true){
var ret_value__16801__auto__ = (function (){try{while(true){
var result__16802__auto__ = switch__16799__auto__(state_17075);
if(cljs.core.keyword_identical_QMARK_(result__16802__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16802__auto__;
}
break;
}
}catch (e17079){if((e17079 instanceof Object)){
var ex__16803__auto__ = e17079;
var statearr_17080_17240 = state_17075;
(statearr_17080_17240[(5)] = ex__16803__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17075);

return cljs.core.cst$kw$recur;
} else {
throw e17079;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16801__auto__,cljs.core.cst$kw$recur)){
var G__17241 = state_17075;
state_17075 = G__17241;
continue;
} else {
return ret_value__16801__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16800__auto__ = function(state_17075){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16800__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16800__auto____1.call(this,state_17075);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16800__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16800__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16800__auto__;
})()
;})(switch__16799__auto__,c__16901__auto___17239,res,vec__17068,v,p,job,jobs,results))
})();
var state__16903__auto__ = (function (){var statearr_17081 = (f__16902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16902__auto__.cljs$core$IFn$_invoke$arity$0() : f__16902__auto__.call(null));
(statearr_17081[(6)] = c__16901__auto___17239);

return statearr_17081;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16903__auto__);
});})(c__16901__auto___17239,res,vec__17068,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__17082){
var vec__17083 = p__17082;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17083,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17083,(1),null);
var job = vec__17083;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__9851__auto___17242 = n;
var __17243 = (0);
while(true){
if((__17243 < n__9851__auto___17242)){
var G__17086_17244 = type;
var G__17086_17245__$1 = (((G__17086_17244 instanceof cljs.core.Keyword))?G__17086_17244.fqn:null);
switch (G__17086_17245__$1) {
case "compute":
var c__16901__auto___17247 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__17243,c__16901__auto___17247,G__17086_17244,G__17086_17245__$1,n__9851__auto___17242,jobs,results,process,async){
return (function (){
var f__16902__auto__ = (function (){var switch__16799__auto__ = ((function (__17243,c__16901__auto___17247,G__17086_17244,G__17086_17245__$1,n__9851__auto___17242,jobs,results,process,async){
return (function (state_17099){
var state_val_17100 = (state_17099[(1)]);
if((state_val_17100 === (1))){
var state_17099__$1 = state_17099;
var statearr_17101_17248 = state_17099__$1;
(statearr_17101_17248[(2)] = null);

(statearr_17101_17248[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17100 === (2))){
var state_17099__$1 = state_17099;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17099__$1,(4),jobs);
} else {
if((state_val_17100 === (3))){
var inst_17097 = (state_17099[(2)]);
var state_17099__$1 = state_17099;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17099__$1,inst_17097);
} else {
if((state_val_17100 === (4))){
var inst_17089 = (state_17099[(2)]);
var inst_17090 = process(inst_17089);
var state_17099__$1 = state_17099;
if(cljs.core.truth_(inst_17090)){
var statearr_17102_17249 = state_17099__$1;
(statearr_17102_17249[(1)] = (5));

} else {
var statearr_17103_17250 = state_17099__$1;
(statearr_17103_17250[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17100 === (5))){
var state_17099__$1 = state_17099;
var statearr_17104_17251 = state_17099__$1;
(statearr_17104_17251[(2)] = null);

(statearr_17104_17251[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17100 === (6))){
var state_17099__$1 = state_17099;
var statearr_17105_17252 = state_17099__$1;
(statearr_17105_17252[(2)] = null);

(statearr_17105_17252[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17100 === (7))){
var inst_17095 = (state_17099[(2)]);
var state_17099__$1 = state_17099;
var statearr_17106_17253 = state_17099__$1;
(statearr_17106_17253[(2)] = inst_17095);

(statearr_17106_17253[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__17243,c__16901__auto___17247,G__17086_17244,G__17086_17245__$1,n__9851__auto___17242,jobs,results,process,async))
;
return ((function (__17243,switch__16799__auto__,c__16901__auto___17247,G__17086_17244,G__17086_17245__$1,n__9851__auto___17242,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16800__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16800__auto____0 = (function (){
var statearr_17107 = [null,null,null,null,null,null,null];
(statearr_17107[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16800__auto__);

(statearr_17107[(1)] = (1));

return statearr_17107;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16800__auto____1 = (function (state_17099){
while(true){
var ret_value__16801__auto__ = (function (){try{while(true){
var result__16802__auto__ = switch__16799__auto__(state_17099);
if(cljs.core.keyword_identical_QMARK_(result__16802__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16802__auto__;
}
break;
}
}catch (e17108){if((e17108 instanceof Object)){
var ex__16803__auto__ = e17108;
var statearr_17109_17254 = state_17099;
(statearr_17109_17254[(5)] = ex__16803__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17099);

return cljs.core.cst$kw$recur;
} else {
throw e17108;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16801__auto__,cljs.core.cst$kw$recur)){
var G__17255 = state_17099;
state_17099 = G__17255;
continue;
} else {
return ret_value__16801__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16800__auto__ = function(state_17099){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16800__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16800__auto____1.call(this,state_17099);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16800__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16800__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16800__auto__;
})()
;})(__17243,switch__16799__auto__,c__16901__auto___17247,G__17086_17244,G__17086_17245__$1,n__9851__auto___17242,jobs,results,process,async))
})();
var state__16903__auto__ = (function (){var statearr_17110 = (f__16902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16902__auto__.cljs$core$IFn$_invoke$arity$0() : f__16902__auto__.call(null));
(statearr_17110[(6)] = c__16901__auto___17247);

return statearr_17110;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16903__auto__);
});})(__17243,c__16901__auto___17247,G__17086_17244,G__17086_17245__$1,n__9851__auto___17242,jobs,results,process,async))
);


break;
case "async":
var c__16901__auto___17256 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__17243,c__16901__auto___17256,G__17086_17244,G__17086_17245__$1,n__9851__auto___17242,jobs,results,process,async){
return (function (){
var f__16902__auto__ = (function (){var switch__16799__auto__ = ((function (__17243,c__16901__auto___17256,G__17086_17244,G__17086_17245__$1,n__9851__auto___17242,jobs,results,process,async){
return (function (state_17123){
var state_val_17124 = (state_17123[(1)]);
if((state_val_17124 === (1))){
var state_17123__$1 = state_17123;
var statearr_17125_17257 = state_17123__$1;
(statearr_17125_17257[(2)] = null);

(statearr_17125_17257[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17124 === (2))){
var state_17123__$1 = state_17123;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17123__$1,(4),jobs);
} else {
if((state_val_17124 === (3))){
var inst_17121 = (state_17123[(2)]);
var state_17123__$1 = state_17123;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17123__$1,inst_17121);
} else {
if((state_val_17124 === (4))){
var inst_17113 = (state_17123[(2)]);
var inst_17114 = async(inst_17113);
var state_17123__$1 = state_17123;
if(cljs.core.truth_(inst_17114)){
var statearr_17126_17258 = state_17123__$1;
(statearr_17126_17258[(1)] = (5));

} else {
var statearr_17127_17259 = state_17123__$1;
(statearr_17127_17259[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17124 === (5))){
var state_17123__$1 = state_17123;
var statearr_17128_17260 = state_17123__$1;
(statearr_17128_17260[(2)] = null);

(statearr_17128_17260[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17124 === (6))){
var state_17123__$1 = state_17123;
var statearr_17129_17261 = state_17123__$1;
(statearr_17129_17261[(2)] = null);

(statearr_17129_17261[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17124 === (7))){
var inst_17119 = (state_17123[(2)]);
var state_17123__$1 = state_17123;
var statearr_17130_17262 = state_17123__$1;
(statearr_17130_17262[(2)] = inst_17119);

(statearr_17130_17262[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__17243,c__16901__auto___17256,G__17086_17244,G__17086_17245__$1,n__9851__auto___17242,jobs,results,process,async))
;
return ((function (__17243,switch__16799__auto__,c__16901__auto___17256,G__17086_17244,G__17086_17245__$1,n__9851__auto___17242,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16800__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16800__auto____0 = (function (){
var statearr_17131 = [null,null,null,null,null,null,null];
(statearr_17131[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16800__auto__);

(statearr_17131[(1)] = (1));

return statearr_17131;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16800__auto____1 = (function (state_17123){
while(true){
var ret_value__16801__auto__ = (function (){try{while(true){
var result__16802__auto__ = switch__16799__auto__(state_17123);
if(cljs.core.keyword_identical_QMARK_(result__16802__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16802__auto__;
}
break;
}
}catch (e17132){if((e17132 instanceof Object)){
var ex__16803__auto__ = e17132;
var statearr_17133_17263 = state_17123;
(statearr_17133_17263[(5)] = ex__16803__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17123);

return cljs.core.cst$kw$recur;
} else {
throw e17132;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16801__auto__,cljs.core.cst$kw$recur)){
var G__17264 = state_17123;
state_17123 = G__17264;
continue;
} else {
return ret_value__16801__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16800__auto__ = function(state_17123){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16800__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16800__auto____1.call(this,state_17123);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16800__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16800__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16800__auto__;
})()
;})(__17243,switch__16799__auto__,c__16901__auto___17256,G__17086_17244,G__17086_17245__$1,n__9851__auto___17242,jobs,results,process,async))
})();
var state__16903__auto__ = (function (){var statearr_17134 = (f__16902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16902__auto__.cljs$core$IFn$_invoke$arity$0() : f__16902__auto__.call(null));
(statearr_17134[(6)] = c__16901__auto___17256);

return statearr_17134;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16903__auto__);
});})(__17243,c__16901__auto___17256,G__17086_17244,G__17086_17245__$1,n__9851__auto___17242,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__17086_17245__$1)].join('')));

}

var G__17265 = (__17243 + (1));
__17243 = G__17265;
continue;
} else {
}
break;
}

var c__16901__auto___17266 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16901__auto___17266,jobs,results,process,async){
return (function (){
var f__16902__auto__ = (function (){var switch__16799__auto__ = ((function (c__16901__auto___17266,jobs,results,process,async){
return (function (state_17156){
var state_val_17157 = (state_17156[(1)]);
if((state_val_17157 === (1))){
var state_17156__$1 = state_17156;
var statearr_17158_17267 = state_17156__$1;
(statearr_17158_17267[(2)] = null);

(statearr_17158_17267[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17157 === (2))){
var state_17156__$1 = state_17156;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17156__$1,(4),from);
} else {
if((state_val_17157 === (3))){
var inst_17154 = (state_17156[(2)]);
var state_17156__$1 = state_17156;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17156__$1,inst_17154);
} else {
if((state_val_17157 === (4))){
var inst_17137 = (state_17156[(7)]);
var inst_17137__$1 = (state_17156[(2)]);
var inst_17138 = (inst_17137__$1 == null);
var state_17156__$1 = (function (){var statearr_17159 = state_17156;
(statearr_17159[(7)] = inst_17137__$1);

return statearr_17159;
})();
if(cljs.core.truth_(inst_17138)){
var statearr_17160_17268 = state_17156__$1;
(statearr_17160_17268[(1)] = (5));

} else {
var statearr_17161_17269 = state_17156__$1;
(statearr_17161_17269[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17157 === (5))){
var inst_17140 = cljs.core.async.close_BANG_(jobs);
var state_17156__$1 = state_17156;
var statearr_17162_17270 = state_17156__$1;
(statearr_17162_17270[(2)] = inst_17140);

(statearr_17162_17270[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17157 === (6))){
var inst_17142 = (state_17156[(8)]);
var inst_17137 = (state_17156[(7)]);
var inst_17142__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_17143 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17144 = [inst_17137,inst_17142__$1];
var inst_17145 = (new cljs.core.PersistentVector(null,2,(5),inst_17143,inst_17144,null));
var state_17156__$1 = (function (){var statearr_17163 = state_17156;
(statearr_17163[(8)] = inst_17142__$1);

return statearr_17163;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17156__$1,(8),jobs,inst_17145);
} else {
if((state_val_17157 === (7))){
var inst_17152 = (state_17156[(2)]);
var state_17156__$1 = state_17156;
var statearr_17164_17271 = state_17156__$1;
(statearr_17164_17271[(2)] = inst_17152);

(statearr_17164_17271[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17157 === (8))){
var inst_17142 = (state_17156[(8)]);
var inst_17147 = (state_17156[(2)]);
var state_17156__$1 = (function (){var statearr_17165 = state_17156;
(statearr_17165[(9)] = inst_17147);

return statearr_17165;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17156__$1,(9),results,inst_17142);
} else {
if((state_val_17157 === (9))){
var inst_17149 = (state_17156[(2)]);
var state_17156__$1 = (function (){var statearr_17166 = state_17156;
(statearr_17166[(10)] = inst_17149);

return statearr_17166;
})();
var statearr_17167_17272 = state_17156__$1;
(statearr_17167_17272[(2)] = null);

(statearr_17167_17272[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__16901__auto___17266,jobs,results,process,async))
;
return ((function (switch__16799__auto__,c__16901__auto___17266,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16800__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16800__auto____0 = (function (){
var statearr_17168 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17168[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16800__auto__);

(statearr_17168[(1)] = (1));

return statearr_17168;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16800__auto____1 = (function (state_17156){
while(true){
var ret_value__16801__auto__ = (function (){try{while(true){
var result__16802__auto__ = switch__16799__auto__(state_17156);
if(cljs.core.keyword_identical_QMARK_(result__16802__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16802__auto__;
}
break;
}
}catch (e17169){if((e17169 instanceof Object)){
var ex__16803__auto__ = e17169;
var statearr_17170_17273 = state_17156;
(statearr_17170_17273[(5)] = ex__16803__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17156);

return cljs.core.cst$kw$recur;
} else {
throw e17169;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16801__auto__,cljs.core.cst$kw$recur)){
var G__17274 = state_17156;
state_17156 = G__17274;
continue;
} else {
return ret_value__16801__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16800__auto__ = function(state_17156){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16800__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16800__auto____1.call(this,state_17156);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16800__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16800__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16800__auto__;
})()
;})(switch__16799__auto__,c__16901__auto___17266,jobs,results,process,async))
})();
var state__16903__auto__ = (function (){var statearr_17171 = (f__16902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16902__auto__.cljs$core$IFn$_invoke$arity$0() : f__16902__auto__.call(null));
(statearr_17171[(6)] = c__16901__auto___17266);

return statearr_17171;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16903__auto__);
});})(c__16901__auto___17266,jobs,results,process,async))
);


var c__16901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16901__auto__,jobs,results,process,async){
return (function (){
var f__16902__auto__ = (function (){var switch__16799__auto__ = ((function (c__16901__auto__,jobs,results,process,async){
return (function (state_17209){
var state_val_17210 = (state_17209[(1)]);
if((state_val_17210 === (7))){
var inst_17205 = (state_17209[(2)]);
var state_17209__$1 = state_17209;
var statearr_17211_17275 = state_17209__$1;
(statearr_17211_17275[(2)] = inst_17205);

(statearr_17211_17275[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17210 === (20))){
var state_17209__$1 = state_17209;
var statearr_17212_17276 = state_17209__$1;
(statearr_17212_17276[(2)] = null);

(statearr_17212_17276[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17210 === (1))){
var state_17209__$1 = state_17209;
var statearr_17213_17277 = state_17209__$1;
(statearr_17213_17277[(2)] = null);

(statearr_17213_17277[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17210 === (4))){
var inst_17174 = (state_17209[(7)]);
var inst_17174__$1 = (state_17209[(2)]);
var inst_17175 = (inst_17174__$1 == null);
var state_17209__$1 = (function (){var statearr_17214 = state_17209;
(statearr_17214[(7)] = inst_17174__$1);

return statearr_17214;
})();
if(cljs.core.truth_(inst_17175)){
var statearr_17215_17278 = state_17209__$1;
(statearr_17215_17278[(1)] = (5));

} else {
var statearr_17216_17279 = state_17209__$1;
(statearr_17216_17279[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17210 === (15))){
var inst_17187 = (state_17209[(8)]);
var state_17209__$1 = state_17209;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17209__$1,(18),to,inst_17187);
} else {
if((state_val_17210 === (21))){
var inst_17200 = (state_17209[(2)]);
var state_17209__$1 = state_17209;
var statearr_17217_17280 = state_17209__$1;
(statearr_17217_17280[(2)] = inst_17200);

(statearr_17217_17280[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17210 === (13))){
var inst_17202 = (state_17209[(2)]);
var state_17209__$1 = (function (){var statearr_17218 = state_17209;
(statearr_17218[(9)] = inst_17202);

return statearr_17218;
})();
var statearr_17219_17281 = state_17209__$1;
(statearr_17219_17281[(2)] = null);

(statearr_17219_17281[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17210 === (6))){
var inst_17174 = (state_17209[(7)]);
var state_17209__$1 = state_17209;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17209__$1,(11),inst_17174);
} else {
if((state_val_17210 === (17))){
var inst_17195 = (state_17209[(2)]);
var state_17209__$1 = state_17209;
if(cljs.core.truth_(inst_17195)){
var statearr_17220_17282 = state_17209__$1;
(statearr_17220_17282[(1)] = (19));

} else {
var statearr_17221_17283 = state_17209__$1;
(statearr_17221_17283[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17210 === (3))){
var inst_17207 = (state_17209[(2)]);
var state_17209__$1 = state_17209;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17209__$1,inst_17207);
} else {
if((state_val_17210 === (12))){
var inst_17184 = (state_17209[(10)]);
var state_17209__$1 = state_17209;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17209__$1,(14),inst_17184);
} else {
if((state_val_17210 === (2))){
var state_17209__$1 = state_17209;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17209__$1,(4),results);
} else {
if((state_val_17210 === (19))){
var state_17209__$1 = state_17209;
var statearr_17222_17284 = state_17209__$1;
(statearr_17222_17284[(2)] = null);

(statearr_17222_17284[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17210 === (11))){
var inst_17184 = (state_17209[(2)]);
var state_17209__$1 = (function (){var statearr_17223 = state_17209;
(statearr_17223[(10)] = inst_17184);

return statearr_17223;
})();
var statearr_17224_17285 = state_17209__$1;
(statearr_17224_17285[(2)] = null);

(statearr_17224_17285[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17210 === (9))){
var state_17209__$1 = state_17209;
var statearr_17225_17286 = state_17209__$1;
(statearr_17225_17286[(2)] = null);

(statearr_17225_17286[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17210 === (5))){
var state_17209__$1 = state_17209;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17226_17287 = state_17209__$1;
(statearr_17226_17287[(1)] = (8));

} else {
var statearr_17227_17288 = state_17209__$1;
(statearr_17227_17288[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17210 === (14))){
var inst_17187 = (state_17209[(8)]);
var inst_17189 = (state_17209[(11)]);
var inst_17187__$1 = (state_17209[(2)]);
var inst_17188 = (inst_17187__$1 == null);
var inst_17189__$1 = cljs.core.not(inst_17188);
var state_17209__$1 = (function (){var statearr_17228 = state_17209;
(statearr_17228[(8)] = inst_17187__$1);

(statearr_17228[(11)] = inst_17189__$1);

return statearr_17228;
})();
if(inst_17189__$1){
var statearr_17229_17289 = state_17209__$1;
(statearr_17229_17289[(1)] = (15));

} else {
var statearr_17230_17290 = state_17209__$1;
(statearr_17230_17290[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17210 === (16))){
var inst_17189 = (state_17209[(11)]);
var state_17209__$1 = state_17209;
var statearr_17231_17291 = state_17209__$1;
(statearr_17231_17291[(2)] = inst_17189);

(statearr_17231_17291[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17210 === (10))){
var inst_17181 = (state_17209[(2)]);
var state_17209__$1 = state_17209;
var statearr_17232_17292 = state_17209__$1;
(statearr_17232_17292[(2)] = inst_17181);

(statearr_17232_17292[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17210 === (18))){
var inst_17192 = (state_17209[(2)]);
var state_17209__$1 = state_17209;
var statearr_17233_17293 = state_17209__$1;
(statearr_17233_17293[(2)] = inst_17192);

(statearr_17233_17293[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17210 === (8))){
var inst_17178 = cljs.core.async.close_BANG_(to);
var state_17209__$1 = state_17209;
var statearr_17234_17294 = state_17209__$1;
(statearr_17234_17294[(2)] = inst_17178);

(statearr_17234_17294[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16901__auto__,jobs,results,process,async))
;
return ((function (switch__16799__auto__,c__16901__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16800__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16800__auto____0 = (function (){
var statearr_17235 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17235[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16800__auto__);

(statearr_17235[(1)] = (1));

return statearr_17235;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16800__auto____1 = (function (state_17209){
while(true){
var ret_value__16801__auto__ = (function (){try{while(true){
var result__16802__auto__ = switch__16799__auto__(state_17209);
if(cljs.core.keyword_identical_QMARK_(result__16802__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16802__auto__;
}
break;
}
}catch (e17236){if((e17236 instanceof Object)){
var ex__16803__auto__ = e17236;
var statearr_17237_17295 = state_17209;
(statearr_17237_17295[(5)] = ex__16803__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17209);

return cljs.core.cst$kw$recur;
} else {
throw e17236;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16801__auto__,cljs.core.cst$kw$recur)){
var G__17296 = state_17209;
state_17209 = G__17296;
continue;
} else {
return ret_value__16801__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16800__auto__ = function(state_17209){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16800__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16800__auto____1.call(this,state_17209);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16800__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16800__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16800__auto__;
})()
;})(switch__16799__auto__,c__16901__auto__,jobs,results,process,async))
})();
var state__16903__auto__ = (function (){var statearr_17238 = (f__16902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16902__auto__.cljs$core$IFn$_invoke$arity$0() : f__16902__auto__.call(null));
(statearr_17238[(6)] = c__16901__auto__);

return statearr_17238;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16903__auto__);
});})(c__16901__auto__,jobs,results,process,async))
);

return c__16901__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__17298 = arguments.length;
switch (G__17298) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__17301 = arguments.length;
switch (G__17301) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__17304 = arguments.length;
switch (G__17304) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__16901__auto___17353 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16901__auto___17353,tc,fc){
return (function (){
var f__16902__auto__ = (function (){var switch__16799__auto__ = ((function (c__16901__auto___17353,tc,fc){
return (function (state_17330){
var state_val_17331 = (state_17330[(1)]);
if((state_val_17331 === (7))){
var inst_17326 = (state_17330[(2)]);
var state_17330__$1 = state_17330;
var statearr_17332_17354 = state_17330__$1;
(statearr_17332_17354[(2)] = inst_17326);

(statearr_17332_17354[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17331 === (1))){
var state_17330__$1 = state_17330;
var statearr_17333_17355 = state_17330__$1;
(statearr_17333_17355[(2)] = null);

(statearr_17333_17355[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17331 === (4))){
var inst_17307 = (state_17330[(7)]);
var inst_17307__$1 = (state_17330[(2)]);
var inst_17308 = (inst_17307__$1 == null);
var state_17330__$1 = (function (){var statearr_17334 = state_17330;
(statearr_17334[(7)] = inst_17307__$1);

return statearr_17334;
})();
if(cljs.core.truth_(inst_17308)){
var statearr_17335_17356 = state_17330__$1;
(statearr_17335_17356[(1)] = (5));

} else {
var statearr_17336_17357 = state_17330__$1;
(statearr_17336_17357[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17331 === (13))){
var state_17330__$1 = state_17330;
var statearr_17337_17358 = state_17330__$1;
(statearr_17337_17358[(2)] = null);

(statearr_17337_17358[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17331 === (6))){
var inst_17307 = (state_17330[(7)]);
var inst_17313 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_17307) : p.call(null,inst_17307));
var state_17330__$1 = state_17330;
if(cljs.core.truth_(inst_17313)){
var statearr_17338_17359 = state_17330__$1;
(statearr_17338_17359[(1)] = (9));

} else {
var statearr_17339_17360 = state_17330__$1;
(statearr_17339_17360[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17331 === (3))){
var inst_17328 = (state_17330[(2)]);
var state_17330__$1 = state_17330;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17330__$1,inst_17328);
} else {
if((state_val_17331 === (12))){
var state_17330__$1 = state_17330;
var statearr_17340_17361 = state_17330__$1;
(statearr_17340_17361[(2)] = null);

(statearr_17340_17361[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17331 === (2))){
var state_17330__$1 = state_17330;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17330__$1,(4),ch);
} else {
if((state_val_17331 === (11))){
var inst_17307 = (state_17330[(7)]);
var inst_17317 = (state_17330[(2)]);
var state_17330__$1 = state_17330;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17330__$1,(8),inst_17317,inst_17307);
} else {
if((state_val_17331 === (9))){
var state_17330__$1 = state_17330;
var statearr_17341_17362 = state_17330__$1;
(statearr_17341_17362[(2)] = tc);

(statearr_17341_17362[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17331 === (5))){
var inst_17310 = cljs.core.async.close_BANG_(tc);
var inst_17311 = cljs.core.async.close_BANG_(fc);
var state_17330__$1 = (function (){var statearr_17342 = state_17330;
(statearr_17342[(8)] = inst_17310);

return statearr_17342;
})();
var statearr_17343_17363 = state_17330__$1;
(statearr_17343_17363[(2)] = inst_17311);

(statearr_17343_17363[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17331 === (14))){
var inst_17324 = (state_17330[(2)]);
var state_17330__$1 = state_17330;
var statearr_17344_17364 = state_17330__$1;
(statearr_17344_17364[(2)] = inst_17324);

(statearr_17344_17364[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17331 === (10))){
var state_17330__$1 = state_17330;
var statearr_17345_17365 = state_17330__$1;
(statearr_17345_17365[(2)] = fc);

(statearr_17345_17365[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17331 === (8))){
var inst_17319 = (state_17330[(2)]);
var state_17330__$1 = state_17330;
if(cljs.core.truth_(inst_17319)){
var statearr_17346_17366 = state_17330__$1;
(statearr_17346_17366[(1)] = (12));

} else {
var statearr_17347_17367 = state_17330__$1;
(statearr_17347_17367[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16901__auto___17353,tc,fc))
;
return ((function (switch__16799__auto__,c__16901__auto___17353,tc,fc){
return (function() {
var cljs$core$async$state_machine__16800__auto__ = null;
var cljs$core$async$state_machine__16800__auto____0 = (function (){
var statearr_17348 = [null,null,null,null,null,null,null,null,null];
(statearr_17348[(0)] = cljs$core$async$state_machine__16800__auto__);

(statearr_17348[(1)] = (1));

return statearr_17348;
});
var cljs$core$async$state_machine__16800__auto____1 = (function (state_17330){
while(true){
var ret_value__16801__auto__ = (function (){try{while(true){
var result__16802__auto__ = switch__16799__auto__(state_17330);
if(cljs.core.keyword_identical_QMARK_(result__16802__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16802__auto__;
}
break;
}
}catch (e17349){if((e17349 instanceof Object)){
var ex__16803__auto__ = e17349;
var statearr_17350_17368 = state_17330;
(statearr_17350_17368[(5)] = ex__16803__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17330);

return cljs.core.cst$kw$recur;
} else {
throw e17349;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16801__auto__,cljs.core.cst$kw$recur)){
var G__17369 = state_17330;
state_17330 = G__17369;
continue;
} else {
return ret_value__16801__auto__;
}
break;
}
});
cljs$core$async$state_machine__16800__auto__ = function(state_17330){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16800__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16800__auto____1.call(this,state_17330);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16800__auto____0;
cljs$core$async$state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16800__auto____1;
return cljs$core$async$state_machine__16800__auto__;
})()
;})(switch__16799__auto__,c__16901__auto___17353,tc,fc))
})();
var state__16903__auto__ = (function (){var statearr_17351 = (f__16902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16902__auto__.cljs$core$IFn$_invoke$arity$0() : f__16902__auto__.call(null));
(statearr_17351[(6)] = c__16901__auto___17353);

return statearr_17351;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16903__auto__);
});})(c__16901__auto___17353,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__16901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16901__auto__){
return (function (){
var f__16902__auto__ = (function (){var switch__16799__auto__ = ((function (c__16901__auto__){
return (function (state_17390){
var state_val_17391 = (state_17390[(1)]);
if((state_val_17391 === (7))){
var inst_17386 = (state_17390[(2)]);
var state_17390__$1 = state_17390;
var statearr_17392_17410 = state_17390__$1;
(statearr_17392_17410[(2)] = inst_17386);

(statearr_17392_17410[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17391 === (1))){
var inst_17370 = init;
var state_17390__$1 = (function (){var statearr_17393 = state_17390;
(statearr_17393[(7)] = inst_17370);

return statearr_17393;
})();
var statearr_17394_17411 = state_17390__$1;
(statearr_17394_17411[(2)] = null);

(statearr_17394_17411[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17391 === (4))){
var inst_17373 = (state_17390[(8)]);
var inst_17373__$1 = (state_17390[(2)]);
var inst_17374 = (inst_17373__$1 == null);
var state_17390__$1 = (function (){var statearr_17395 = state_17390;
(statearr_17395[(8)] = inst_17373__$1);

return statearr_17395;
})();
if(cljs.core.truth_(inst_17374)){
var statearr_17396_17412 = state_17390__$1;
(statearr_17396_17412[(1)] = (5));

} else {
var statearr_17397_17413 = state_17390__$1;
(statearr_17397_17413[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17391 === (6))){
var inst_17377 = (state_17390[(9)]);
var inst_17373 = (state_17390[(8)]);
var inst_17370 = (state_17390[(7)]);
var inst_17377__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_17370,inst_17373) : f.call(null,inst_17370,inst_17373));
var inst_17378 = cljs.core.reduced_QMARK_(inst_17377__$1);
var state_17390__$1 = (function (){var statearr_17398 = state_17390;
(statearr_17398[(9)] = inst_17377__$1);

return statearr_17398;
})();
if(inst_17378){
var statearr_17399_17414 = state_17390__$1;
(statearr_17399_17414[(1)] = (8));

} else {
var statearr_17400_17415 = state_17390__$1;
(statearr_17400_17415[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17391 === (3))){
var inst_17388 = (state_17390[(2)]);
var state_17390__$1 = state_17390;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17390__$1,inst_17388);
} else {
if((state_val_17391 === (2))){
var state_17390__$1 = state_17390;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17390__$1,(4),ch);
} else {
if((state_val_17391 === (9))){
var inst_17377 = (state_17390[(9)]);
var inst_17370 = inst_17377;
var state_17390__$1 = (function (){var statearr_17401 = state_17390;
(statearr_17401[(7)] = inst_17370);

return statearr_17401;
})();
var statearr_17402_17416 = state_17390__$1;
(statearr_17402_17416[(2)] = null);

(statearr_17402_17416[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17391 === (5))){
var inst_17370 = (state_17390[(7)]);
var state_17390__$1 = state_17390;
var statearr_17403_17417 = state_17390__$1;
(statearr_17403_17417[(2)] = inst_17370);

(statearr_17403_17417[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17391 === (10))){
var inst_17384 = (state_17390[(2)]);
var state_17390__$1 = state_17390;
var statearr_17404_17418 = state_17390__$1;
(statearr_17404_17418[(2)] = inst_17384);

(statearr_17404_17418[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17391 === (8))){
var inst_17377 = (state_17390[(9)]);
var inst_17380 = cljs.core.deref(inst_17377);
var state_17390__$1 = state_17390;
var statearr_17405_17419 = state_17390__$1;
(statearr_17405_17419[(2)] = inst_17380);

(statearr_17405_17419[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__16901__auto__))
;
return ((function (switch__16799__auto__,c__16901__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__16800__auto__ = null;
var cljs$core$async$reduce_$_state_machine__16800__auto____0 = (function (){
var statearr_17406 = [null,null,null,null,null,null,null,null,null,null];
(statearr_17406[(0)] = cljs$core$async$reduce_$_state_machine__16800__auto__);

(statearr_17406[(1)] = (1));

return statearr_17406;
});
var cljs$core$async$reduce_$_state_machine__16800__auto____1 = (function (state_17390){
while(true){
var ret_value__16801__auto__ = (function (){try{while(true){
var result__16802__auto__ = switch__16799__auto__(state_17390);
if(cljs.core.keyword_identical_QMARK_(result__16802__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16802__auto__;
}
break;
}
}catch (e17407){if((e17407 instanceof Object)){
var ex__16803__auto__ = e17407;
var statearr_17408_17420 = state_17390;
(statearr_17408_17420[(5)] = ex__16803__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17390);

return cljs.core.cst$kw$recur;
} else {
throw e17407;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16801__auto__,cljs.core.cst$kw$recur)){
var G__17421 = state_17390;
state_17390 = G__17421;
continue;
} else {
return ret_value__16801__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__16800__auto__ = function(state_17390){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__16800__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__16800__auto____1.call(this,state_17390);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__16800__auto____0;
cljs$core$async$reduce_$_state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__16800__auto____1;
return cljs$core$async$reduce_$_state_machine__16800__auto__;
})()
;})(switch__16799__auto__,c__16901__auto__))
})();
var state__16903__auto__ = (function (){var statearr_17409 = (f__16902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16902__auto__.cljs$core$IFn$_invoke$arity$0() : f__16902__auto__.call(null));
(statearr_17409[(6)] = c__16901__auto__);

return statearr_17409;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16903__auto__);
});})(c__16901__auto__))
);

return c__16901__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__16901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16901__auto__,f__$1){
return (function (){
var f__16902__auto__ = (function (){var switch__16799__auto__ = ((function (c__16901__auto__,f__$1){
return (function (state_17427){
var state_val_17428 = (state_17427[(1)]);
if((state_val_17428 === (1))){
var inst_17422 = cljs.core.async.reduce(f__$1,init,ch);
var state_17427__$1 = state_17427;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17427__$1,(2),inst_17422);
} else {
if((state_val_17428 === (2))){
var inst_17424 = (state_17427[(2)]);
var inst_17425 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_17424) : f__$1.call(null,inst_17424));
var state_17427__$1 = state_17427;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17427__$1,inst_17425);
} else {
return null;
}
}
});})(c__16901__auto__,f__$1))
;
return ((function (switch__16799__auto__,c__16901__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__16800__auto__ = null;
var cljs$core$async$transduce_$_state_machine__16800__auto____0 = (function (){
var statearr_17429 = [null,null,null,null,null,null,null];
(statearr_17429[(0)] = cljs$core$async$transduce_$_state_machine__16800__auto__);

(statearr_17429[(1)] = (1));

return statearr_17429;
});
var cljs$core$async$transduce_$_state_machine__16800__auto____1 = (function (state_17427){
while(true){
var ret_value__16801__auto__ = (function (){try{while(true){
var result__16802__auto__ = switch__16799__auto__(state_17427);
if(cljs.core.keyword_identical_QMARK_(result__16802__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16802__auto__;
}
break;
}
}catch (e17430){if((e17430 instanceof Object)){
var ex__16803__auto__ = e17430;
var statearr_17431_17433 = state_17427;
(statearr_17431_17433[(5)] = ex__16803__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17427);

return cljs.core.cst$kw$recur;
} else {
throw e17430;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16801__auto__,cljs.core.cst$kw$recur)){
var G__17434 = state_17427;
state_17427 = G__17434;
continue;
} else {
return ret_value__16801__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__16800__auto__ = function(state_17427){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__16800__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__16800__auto____1.call(this,state_17427);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__16800__auto____0;
cljs$core$async$transduce_$_state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__16800__auto____1;
return cljs$core$async$transduce_$_state_machine__16800__auto__;
})()
;})(switch__16799__auto__,c__16901__auto__,f__$1))
})();
var state__16903__auto__ = (function (){var statearr_17432 = (f__16902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16902__auto__.cljs$core$IFn$_invoke$arity$0() : f__16902__auto__.call(null));
(statearr_17432[(6)] = c__16901__auto__);

return statearr_17432;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16903__auto__);
});})(c__16901__auto__,f__$1))
);

return c__16901__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__17436 = arguments.length;
switch (G__17436) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__16901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16901__auto__){
return (function (){
var f__16902__auto__ = (function (){var switch__16799__auto__ = ((function (c__16901__auto__){
return (function (state_17461){
var state_val_17462 = (state_17461[(1)]);
if((state_val_17462 === (7))){
var inst_17443 = (state_17461[(2)]);
var state_17461__$1 = state_17461;
var statearr_17463_17484 = state_17461__$1;
(statearr_17463_17484[(2)] = inst_17443);

(statearr_17463_17484[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17462 === (1))){
var inst_17437 = cljs.core.seq(coll);
var inst_17438 = inst_17437;
var state_17461__$1 = (function (){var statearr_17464 = state_17461;
(statearr_17464[(7)] = inst_17438);

return statearr_17464;
})();
var statearr_17465_17485 = state_17461__$1;
(statearr_17465_17485[(2)] = null);

(statearr_17465_17485[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17462 === (4))){
var inst_17438 = (state_17461[(7)]);
var inst_17441 = cljs.core.first(inst_17438);
var state_17461__$1 = state_17461;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17461__$1,(7),ch,inst_17441);
} else {
if((state_val_17462 === (13))){
var inst_17455 = (state_17461[(2)]);
var state_17461__$1 = state_17461;
var statearr_17466_17486 = state_17461__$1;
(statearr_17466_17486[(2)] = inst_17455);

(statearr_17466_17486[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17462 === (6))){
var inst_17446 = (state_17461[(2)]);
var state_17461__$1 = state_17461;
if(cljs.core.truth_(inst_17446)){
var statearr_17467_17487 = state_17461__$1;
(statearr_17467_17487[(1)] = (8));

} else {
var statearr_17468_17488 = state_17461__$1;
(statearr_17468_17488[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17462 === (3))){
var inst_17459 = (state_17461[(2)]);
var state_17461__$1 = state_17461;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17461__$1,inst_17459);
} else {
if((state_val_17462 === (12))){
var state_17461__$1 = state_17461;
var statearr_17469_17489 = state_17461__$1;
(statearr_17469_17489[(2)] = null);

(statearr_17469_17489[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17462 === (2))){
var inst_17438 = (state_17461[(7)]);
var state_17461__$1 = state_17461;
if(cljs.core.truth_(inst_17438)){
var statearr_17470_17490 = state_17461__$1;
(statearr_17470_17490[(1)] = (4));

} else {
var statearr_17471_17491 = state_17461__$1;
(statearr_17471_17491[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17462 === (11))){
var inst_17452 = cljs.core.async.close_BANG_(ch);
var state_17461__$1 = state_17461;
var statearr_17472_17492 = state_17461__$1;
(statearr_17472_17492[(2)] = inst_17452);

(statearr_17472_17492[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17462 === (9))){
var state_17461__$1 = state_17461;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17473_17493 = state_17461__$1;
(statearr_17473_17493[(1)] = (11));

} else {
var statearr_17474_17494 = state_17461__$1;
(statearr_17474_17494[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17462 === (5))){
var inst_17438 = (state_17461[(7)]);
var state_17461__$1 = state_17461;
var statearr_17475_17495 = state_17461__$1;
(statearr_17475_17495[(2)] = inst_17438);

(statearr_17475_17495[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17462 === (10))){
var inst_17457 = (state_17461[(2)]);
var state_17461__$1 = state_17461;
var statearr_17476_17496 = state_17461__$1;
(statearr_17476_17496[(2)] = inst_17457);

(statearr_17476_17496[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17462 === (8))){
var inst_17438 = (state_17461[(7)]);
var inst_17448 = cljs.core.next(inst_17438);
var inst_17438__$1 = inst_17448;
var state_17461__$1 = (function (){var statearr_17477 = state_17461;
(statearr_17477[(7)] = inst_17438__$1);

return statearr_17477;
})();
var statearr_17478_17497 = state_17461__$1;
(statearr_17478_17497[(2)] = null);

(statearr_17478_17497[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16901__auto__))
;
return ((function (switch__16799__auto__,c__16901__auto__){
return (function() {
var cljs$core$async$state_machine__16800__auto__ = null;
var cljs$core$async$state_machine__16800__auto____0 = (function (){
var statearr_17479 = [null,null,null,null,null,null,null,null];
(statearr_17479[(0)] = cljs$core$async$state_machine__16800__auto__);

(statearr_17479[(1)] = (1));

return statearr_17479;
});
var cljs$core$async$state_machine__16800__auto____1 = (function (state_17461){
while(true){
var ret_value__16801__auto__ = (function (){try{while(true){
var result__16802__auto__ = switch__16799__auto__(state_17461);
if(cljs.core.keyword_identical_QMARK_(result__16802__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16802__auto__;
}
break;
}
}catch (e17480){if((e17480 instanceof Object)){
var ex__16803__auto__ = e17480;
var statearr_17481_17498 = state_17461;
(statearr_17481_17498[(5)] = ex__16803__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17461);

return cljs.core.cst$kw$recur;
} else {
throw e17480;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16801__auto__,cljs.core.cst$kw$recur)){
var G__17499 = state_17461;
state_17461 = G__17499;
continue;
} else {
return ret_value__16801__auto__;
}
break;
}
});
cljs$core$async$state_machine__16800__auto__ = function(state_17461){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16800__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16800__auto____1.call(this,state_17461);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16800__auto____0;
cljs$core$async$state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16800__auto____1;
return cljs$core$async$state_machine__16800__auto__;
})()
;})(switch__16799__auto__,c__16901__auto__))
})();
var state__16903__auto__ = (function (){var statearr_17482 = (f__16902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16902__auto__.cljs$core$IFn$_invoke$arity$0() : f__16902__auto__.call(null));
(statearr_17482[(6)] = c__16901__auto__);

return statearr_17482;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16903__auto__);
});})(c__16901__auto__))
);

return c__16901__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__9539__auto__ = (((_ == null))?null:_);
var m__9540__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__9540__auto__.call(null,_));
} else {
var m__9540__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__9540__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__9540__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__9540__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__9540__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9540__auto__.call(null,m,ch));
} else {
var m__9540__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9540__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__9540__auto__.call(null,m));
} else {
var m__9540__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__9540__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async17500 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17500 = (function (ch,cs,meta17501){
this.ch = ch;
this.cs = cs;
this.meta17501 = meta17501;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17500.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_17502,meta17501__$1){
var self__ = this;
var _17502__$1 = this;
return (new cljs.core.async.t_cljs$core$async17500(self__.ch,self__.cs,meta17501__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async17500.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_17502){
var self__ = this;
var _17502__$1 = this;
return self__.meta17501;
});})(cs))
;

cljs.core.async.t_cljs$core$async17500.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17500.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async17500.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17500.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async17500.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async17500.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async17500.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta17501], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async17500.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17500.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17500";

cljs.core.async.t_cljs$core$async17500.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async17500");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async17500 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async17500(ch__$1,cs__$1,meta17501){
return (new cljs.core.async.t_cljs$core$async17500(ch__$1,cs__$1,meta17501));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async17500(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__16901__auto___17722 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16901__auto___17722,cs,m,dchan,dctr,done){
return (function (){
var f__16902__auto__ = (function (){var switch__16799__auto__ = ((function (c__16901__auto___17722,cs,m,dchan,dctr,done){
return (function (state_17637){
var state_val_17638 = (state_17637[(1)]);
if((state_val_17638 === (7))){
var inst_17633 = (state_17637[(2)]);
var state_17637__$1 = state_17637;
var statearr_17639_17723 = state_17637__$1;
(statearr_17639_17723[(2)] = inst_17633);

(statearr_17639_17723[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (20))){
var inst_17536 = (state_17637[(7)]);
var inst_17548 = cljs.core.first(inst_17536);
var inst_17549 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17548,(0),null);
var inst_17550 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17548,(1),null);
var state_17637__$1 = (function (){var statearr_17640 = state_17637;
(statearr_17640[(8)] = inst_17549);

return statearr_17640;
})();
if(cljs.core.truth_(inst_17550)){
var statearr_17641_17724 = state_17637__$1;
(statearr_17641_17724[(1)] = (22));

} else {
var statearr_17642_17725 = state_17637__$1;
(statearr_17642_17725[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (27))){
var inst_17505 = (state_17637[(9)]);
var inst_17580 = (state_17637[(10)]);
var inst_17578 = (state_17637[(11)]);
var inst_17585 = (state_17637[(12)]);
var inst_17585__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_17578,inst_17580);
var inst_17586 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_17585__$1,inst_17505,done);
var state_17637__$1 = (function (){var statearr_17643 = state_17637;
(statearr_17643[(12)] = inst_17585__$1);

return statearr_17643;
})();
if(cljs.core.truth_(inst_17586)){
var statearr_17644_17726 = state_17637__$1;
(statearr_17644_17726[(1)] = (30));

} else {
var statearr_17645_17727 = state_17637__$1;
(statearr_17645_17727[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (1))){
var state_17637__$1 = state_17637;
var statearr_17646_17728 = state_17637__$1;
(statearr_17646_17728[(2)] = null);

(statearr_17646_17728[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (24))){
var inst_17536 = (state_17637[(7)]);
var inst_17555 = (state_17637[(2)]);
var inst_17556 = cljs.core.next(inst_17536);
var inst_17514 = inst_17556;
var inst_17515 = null;
var inst_17516 = (0);
var inst_17517 = (0);
var state_17637__$1 = (function (){var statearr_17647 = state_17637;
(statearr_17647[(13)] = inst_17514);

(statearr_17647[(14)] = inst_17516);

(statearr_17647[(15)] = inst_17517);

(statearr_17647[(16)] = inst_17555);

(statearr_17647[(17)] = inst_17515);

return statearr_17647;
})();
var statearr_17648_17729 = state_17637__$1;
(statearr_17648_17729[(2)] = null);

(statearr_17648_17729[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (39))){
var state_17637__$1 = state_17637;
var statearr_17652_17730 = state_17637__$1;
(statearr_17652_17730[(2)] = null);

(statearr_17652_17730[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (4))){
var inst_17505 = (state_17637[(9)]);
var inst_17505__$1 = (state_17637[(2)]);
var inst_17506 = (inst_17505__$1 == null);
var state_17637__$1 = (function (){var statearr_17653 = state_17637;
(statearr_17653[(9)] = inst_17505__$1);

return statearr_17653;
})();
if(cljs.core.truth_(inst_17506)){
var statearr_17654_17731 = state_17637__$1;
(statearr_17654_17731[(1)] = (5));

} else {
var statearr_17655_17732 = state_17637__$1;
(statearr_17655_17732[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (15))){
var inst_17514 = (state_17637[(13)]);
var inst_17516 = (state_17637[(14)]);
var inst_17517 = (state_17637[(15)]);
var inst_17515 = (state_17637[(17)]);
var inst_17532 = (state_17637[(2)]);
var inst_17533 = (inst_17517 + (1));
var tmp17649 = inst_17514;
var tmp17650 = inst_17516;
var tmp17651 = inst_17515;
var inst_17514__$1 = tmp17649;
var inst_17515__$1 = tmp17651;
var inst_17516__$1 = tmp17650;
var inst_17517__$1 = inst_17533;
var state_17637__$1 = (function (){var statearr_17656 = state_17637;
(statearr_17656[(13)] = inst_17514__$1);

(statearr_17656[(14)] = inst_17516__$1);

(statearr_17656[(15)] = inst_17517__$1);

(statearr_17656[(18)] = inst_17532);

(statearr_17656[(17)] = inst_17515__$1);

return statearr_17656;
})();
var statearr_17657_17733 = state_17637__$1;
(statearr_17657_17733[(2)] = null);

(statearr_17657_17733[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (21))){
var inst_17559 = (state_17637[(2)]);
var state_17637__$1 = state_17637;
var statearr_17661_17734 = state_17637__$1;
(statearr_17661_17734[(2)] = inst_17559);

(statearr_17661_17734[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (31))){
var inst_17585 = (state_17637[(12)]);
var inst_17589 = done(null);
var inst_17590 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_17585);
var state_17637__$1 = (function (){var statearr_17662 = state_17637;
(statearr_17662[(19)] = inst_17589);

return statearr_17662;
})();
var statearr_17663_17735 = state_17637__$1;
(statearr_17663_17735[(2)] = inst_17590);

(statearr_17663_17735[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (32))){
var inst_17577 = (state_17637[(20)]);
var inst_17580 = (state_17637[(10)]);
var inst_17578 = (state_17637[(11)]);
var inst_17579 = (state_17637[(21)]);
var inst_17592 = (state_17637[(2)]);
var inst_17593 = (inst_17580 + (1));
var tmp17658 = inst_17577;
var tmp17659 = inst_17578;
var tmp17660 = inst_17579;
var inst_17577__$1 = tmp17658;
var inst_17578__$1 = tmp17659;
var inst_17579__$1 = tmp17660;
var inst_17580__$1 = inst_17593;
var state_17637__$1 = (function (){var statearr_17664 = state_17637;
(statearr_17664[(22)] = inst_17592);

(statearr_17664[(20)] = inst_17577__$1);

(statearr_17664[(10)] = inst_17580__$1);

(statearr_17664[(11)] = inst_17578__$1);

(statearr_17664[(21)] = inst_17579__$1);

return statearr_17664;
})();
var statearr_17665_17736 = state_17637__$1;
(statearr_17665_17736[(2)] = null);

(statearr_17665_17736[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (40))){
var inst_17605 = (state_17637[(23)]);
var inst_17609 = done(null);
var inst_17610 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_17605);
var state_17637__$1 = (function (){var statearr_17666 = state_17637;
(statearr_17666[(24)] = inst_17609);

return statearr_17666;
})();
var statearr_17667_17737 = state_17637__$1;
(statearr_17667_17737[(2)] = inst_17610);

(statearr_17667_17737[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (33))){
var inst_17596 = (state_17637[(25)]);
var inst_17598 = cljs.core.chunked_seq_QMARK_(inst_17596);
var state_17637__$1 = state_17637;
if(inst_17598){
var statearr_17668_17738 = state_17637__$1;
(statearr_17668_17738[(1)] = (36));

} else {
var statearr_17669_17739 = state_17637__$1;
(statearr_17669_17739[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (13))){
var inst_17526 = (state_17637[(26)]);
var inst_17529 = cljs.core.async.close_BANG_(inst_17526);
var state_17637__$1 = state_17637;
var statearr_17670_17740 = state_17637__$1;
(statearr_17670_17740[(2)] = inst_17529);

(statearr_17670_17740[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (22))){
var inst_17549 = (state_17637[(8)]);
var inst_17552 = cljs.core.async.close_BANG_(inst_17549);
var state_17637__$1 = state_17637;
var statearr_17671_17741 = state_17637__$1;
(statearr_17671_17741[(2)] = inst_17552);

(statearr_17671_17741[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (36))){
var inst_17596 = (state_17637[(25)]);
var inst_17600 = cljs.core.chunk_first(inst_17596);
var inst_17601 = cljs.core.chunk_rest(inst_17596);
var inst_17602 = cljs.core.count(inst_17600);
var inst_17577 = inst_17601;
var inst_17578 = inst_17600;
var inst_17579 = inst_17602;
var inst_17580 = (0);
var state_17637__$1 = (function (){var statearr_17672 = state_17637;
(statearr_17672[(20)] = inst_17577);

(statearr_17672[(10)] = inst_17580);

(statearr_17672[(11)] = inst_17578);

(statearr_17672[(21)] = inst_17579);

return statearr_17672;
})();
var statearr_17673_17742 = state_17637__$1;
(statearr_17673_17742[(2)] = null);

(statearr_17673_17742[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (41))){
var inst_17596 = (state_17637[(25)]);
var inst_17612 = (state_17637[(2)]);
var inst_17613 = cljs.core.next(inst_17596);
var inst_17577 = inst_17613;
var inst_17578 = null;
var inst_17579 = (0);
var inst_17580 = (0);
var state_17637__$1 = (function (){var statearr_17674 = state_17637;
(statearr_17674[(27)] = inst_17612);

(statearr_17674[(20)] = inst_17577);

(statearr_17674[(10)] = inst_17580);

(statearr_17674[(11)] = inst_17578);

(statearr_17674[(21)] = inst_17579);

return statearr_17674;
})();
var statearr_17675_17743 = state_17637__$1;
(statearr_17675_17743[(2)] = null);

(statearr_17675_17743[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (43))){
var state_17637__$1 = state_17637;
var statearr_17676_17744 = state_17637__$1;
(statearr_17676_17744[(2)] = null);

(statearr_17676_17744[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (29))){
var inst_17621 = (state_17637[(2)]);
var state_17637__$1 = state_17637;
var statearr_17677_17745 = state_17637__$1;
(statearr_17677_17745[(2)] = inst_17621);

(statearr_17677_17745[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (44))){
var inst_17630 = (state_17637[(2)]);
var state_17637__$1 = (function (){var statearr_17678 = state_17637;
(statearr_17678[(28)] = inst_17630);

return statearr_17678;
})();
var statearr_17679_17746 = state_17637__$1;
(statearr_17679_17746[(2)] = null);

(statearr_17679_17746[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (6))){
var inst_17569 = (state_17637[(29)]);
var inst_17568 = cljs.core.deref(cs);
var inst_17569__$1 = cljs.core.keys(inst_17568);
var inst_17570 = cljs.core.count(inst_17569__$1);
var inst_17571 = cljs.core.reset_BANG_(dctr,inst_17570);
var inst_17576 = cljs.core.seq(inst_17569__$1);
var inst_17577 = inst_17576;
var inst_17578 = null;
var inst_17579 = (0);
var inst_17580 = (0);
var state_17637__$1 = (function (){var statearr_17680 = state_17637;
(statearr_17680[(30)] = inst_17571);

(statearr_17680[(29)] = inst_17569__$1);

(statearr_17680[(20)] = inst_17577);

(statearr_17680[(10)] = inst_17580);

(statearr_17680[(11)] = inst_17578);

(statearr_17680[(21)] = inst_17579);

return statearr_17680;
})();
var statearr_17681_17747 = state_17637__$1;
(statearr_17681_17747[(2)] = null);

(statearr_17681_17747[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (28))){
var inst_17596 = (state_17637[(25)]);
var inst_17577 = (state_17637[(20)]);
var inst_17596__$1 = cljs.core.seq(inst_17577);
var state_17637__$1 = (function (){var statearr_17682 = state_17637;
(statearr_17682[(25)] = inst_17596__$1);

return statearr_17682;
})();
if(inst_17596__$1){
var statearr_17683_17748 = state_17637__$1;
(statearr_17683_17748[(1)] = (33));

} else {
var statearr_17684_17749 = state_17637__$1;
(statearr_17684_17749[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (25))){
var inst_17580 = (state_17637[(10)]);
var inst_17579 = (state_17637[(21)]);
var inst_17582 = (inst_17580 < inst_17579);
var inst_17583 = inst_17582;
var state_17637__$1 = state_17637;
if(cljs.core.truth_(inst_17583)){
var statearr_17685_17750 = state_17637__$1;
(statearr_17685_17750[(1)] = (27));

} else {
var statearr_17686_17751 = state_17637__$1;
(statearr_17686_17751[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (34))){
var state_17637__$1 = state_17637;
var statearr_17687_17752 = state_17637__$1;
(statearr_17687_17752[(2)] = null);

(statearr_17687_17752[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (17))){
var state_17637__$1 = state_17637;
var statearr_17688_17753 = state_17637__$1;
(statearr_17688_17753[(2)] = null);

(statearr_17688_17753[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (3))){
var inst_17635 = (state_17637[(2)]);
var state_17637__$1 = state_17637;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17637__$1,inst_17635);
} else {
if((state_val_17638 === (12))){
var inst_17564 = (state_17637[(2)]);
var state_17637__$1 = state_17637;
var statearr_17689_17754 = state_17637__$1;
(statearr_17689_17754[(2)] = inst_17564);

(statearr_17689_17754[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (2))){
var state_17637__$1 = state_17637;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17637__$1,(4),ch);
} else {
if((state_val_17638 === (23))){
var state_17637__$1 = state_17637;
var statearr_17690_17755 = state_17637__$1;
(statearr_17690_17755[(2)] = null);

(statearr_17690_17755[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (35))){
var inst_17619 = (state_17637[(2)]);
var state_17637__$1 = state_17637;
var statearr_17691_17756 = state_17637__$1;
(statearr_17691_17756[(2)] = inst_17619);

(statearr_17691_17756[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (19))){
var inst_17536 = (state_17637[(7)]);
var inst_17540 = cljs.core.chunk_first(inst_17536);
var inst_17541 = cljs.core.chunk_rest(inst_17536);
var inst_17542 = cljs.core.count(inst_17540);
var inst_17514 = inst_17541;
var inst_17515 = inst_17540;
var inst_17516 = inst_17542;
var inst_17517 = (0);
var state_17637__$1 = (function (){var statearr_17692 = state_17637;
(statearr_17692[(13)] = inst_17514);

(statearr_17692[(14)] = inst_17516);

(statearr_17692[(15)] = inst_17517);

(statearr_17692[(17)] = inst_17515);

return statearr_17692;
})();
var statearr_17693_17757 = state_17637__$1;
(statearr_17693_17757[(2)] = null);

(statearr_17693_17757[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (11))){
var inst_17514 = (state_17637[(13)]);
var inst_17536 = (state_17637[(7)]);
var inst_17536__$1 = cljs.core.seq(inst_17514);
var state_17637__$1 = (function (){var statearr_17694 = state_17637;
(statearr_17694[(7)] = inst_17536__$1);

return statearr_17694;
})();
if(inst_17536__$1){
var statearr_17695_17758 = state_17637__$1;
(statearr_17695_17758[(1)] = (16));

} else {
var statearr_17696_17759 = state_17637__$1;
(statearr_17696_17759[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (9))){
var inst_17566 = (state_17637[(2)]);
var state_17637__$1 = state_17637;
var statearr_17697_17760 = state_17637__$1;
(statearr_17697_17760[(2)] = inst_17566);

(statearr_17697_17760[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (5))){
var inst_17512 = cljs.core.deref(cs);
var inst_17513 = cljs.core.seq(inst_17512);
var inst_17514 = inst_17513;
var inst_17515 = null;
var inst_17516 = (0);
var inst_17517 = (0);
var state_17637__$1 = (function (){var statearr_17698 = state_17637;
(statearr_17698[(13)] = inst_17514);

(statearr_17698[(14)] = inst_17516);

(statearr_17698[(15)] = inst_17517);

(statearr_17698[(17)] = inst_17515);

return statearr_17698;
})();
var statearr_17699_17761 = state_17637__$1;
(statearr_17699_17761[(2)] = null);

(statearr_17699_17761[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (14))){
var state_17637__$1 = state_17637;
var statearr_17700_17762 = state_17637__$1;
(statearr_17700_17762[(2)] = null);

(statearr_17700_17762[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (45))){
var inst_17627 = (state_17637[(2)]);
var state_17637__$1 = state_17637;
var statearr_17701_17763 = state_17637__$1;
(statearr_17701_17763[(2)] = inst_17627);

(statearr_17701_17763[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (26))){
var inst_17569 = (state_17637[(29)]);
var inst_17623 = (state_17637[(2)]);
var inst_17624 = cljs.core.seq(inst_17569);
var state_17637__$1 = (function (){var statearr_17702 = state_17637;
(statearr_17702[(31)] = inst_17623);

return statearr_17702;
})();
if(inst_17624){
var statearr_17703_17764 = state_17637__$1;
(statearr_17703_17764[(1)] = (42));

} else {
var statearr_17704_17765 = state_17637__$1;
(statearr_17704_17765[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (16))){
var inst_17536 = (state_17637[(7)]);
var inst_17538 = cljs.core.chunked_seq_QMARK_(inst_17536);
var state_17637__$1 = state_17637;
if(inst_17538){
var statearr_17705_17766 = state_17637__$1;
(statearr_17705_17766[(1)] = (19));

} else {
var statearr_17706_17767 = state_17637__$1;
(statearr_17706_17767[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (38))){
var inst_17616 = (state_17637[(2)]);
var state_17637__$1 = state_17637;
var statearr_17707_17768 = state_17637__$1;
(statearr_17707_17768[(2)] = inst_17616);

(statearr_17707_17768[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (30))){
var state_17637__$1 = state_17637;
var statearr_17708_17769 = state_17637__$1;
(statearr_17708_17769[(2)] = null);

(statearr_17708_17769[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (10))){
var inst_17517 = (state_17637[(15)]);
var inst_17515 = (state_17637[(17)]);
var inst_17525 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_17515,inst_17517);
var inst_17526 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17525,(0),null);
var inst_17527 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17525,(1),null);
var state_17637__$1 = (function (){var statearr_17709 = state_17637;
(statearr_17709[(26)] = inst_17526);

return statearr_17709;
})();
if(cljs.core.truth_(inst_17527)){
var statearr_17710_17770 = state_17637__$1;
(statearr_17710_17770[(1)] = (13));

} else {
var statearr_17711_17771 = state_17637__$1;
(statearr_17711_17771[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (18))){
var inst_17562 = (state_17637[(2)]);
var state_17637__$1 = state_17637;
var statearr_17712_17772 = state_17637__$1;
(statearr_17712_17772[(2)] = inst_17562);

(statearr_17712_17772[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (42))){
var state_17637__$1 = state_17637;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17637__$1,(45),dchan);
} else {
if((state_val_17638 === (37))){
var inst_17605 = (state_17637[(23)]);
var inst_17596 = (state_17637[(25)]);
var inst_17505 = (state_17637[(9)]);
var inst_17605__$1 = cljs.core.first(inst_17596);
var inst_17606 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_17605__$1,inst_17505,done);
var state_17637__$1 = (function (){var statearr_17713 = state_17637;
(statearr_17713[(23)] = inst_17605__$1);

return statearr_17713;
})();
if(cljs.core.truth_(inst_17606)){
var statearr_17714_17773 = state_17637__$1;
(statearr_17714_17773[(1)] = (39));

} else {
var statearr_17715_17774 = state_17637__$1;
(statearr_17715_17774[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17638 === (8))){
var inst_17516 = (state_17637[(14)]);
var inst_17517 = (state_17637[(15)]);
var inst_17519 = (inst_17517 < inst_17516);
var inst_17520 = inst_17519;
var state_17637__$1 = state_17637;
if(cljs.core.truth_(inst_17520)){
var statearr_17716_17775 = state_17637__$1;
(statearr_17716_17775[(1)] = (10));

} else {
var statearr_17717_17776 = state_17637__$1;
(statearr_17717_17776[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16901__auto___17722,cs,m,dchan,dctr,done))
;
return ((function (switch__16799__auto__,c__16901__auto___17722,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__16800__auto__ = null;
var cljs$core$async$mult_$_state_machine__16800__auto____0 = (function (){
var statearr_17718 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17718[(0)] = cljs$core$async$mult_$_state_machine__16800__auto__);

(statearr_17718[(1)] = (1));

return statearr_17718;
});
var cljs$core$async$mult_$_state_machine__16800__auto____1 = (function (state_17637){
while(true){
var ret_value__16801__auto__ = (function (){try{while(true){
var result__16802__auto__ = switch__16799__auto__(state_17637);
if(cljs.core.keyword_identical_QMARK_(result__16802__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16802__auto__;
}
break;
}
}catch (e17719){if((e17719 instanceof Object)){
var ex__16803__auto__ = e17719;
var statearr_17720_17777 = state_17637;
(statearr_17720_17777[(5)] = ex__16803__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17637);

return cljs.core.cst$kw$recur;
} else {
throw e17719;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16801__auto__,cljs.core.cst$kw$recur)){
var G__17778 = state_17637;
state_17637 = G__17778;
continue;
} else {
return ret_value__16801__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__16800__auto__ = function(state_17637){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__16800__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__16800__auto____1.call(this,state_17637);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__16800__auto____0;
cljs$core$async$mult_$_state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__16800__auto____1;
return cljs$core$async$mult_$_state_machine__16800__auto__;
})()
;})(switch__16799__auto__,c__16901__auto___17722,cs,m,dchan,dctr,done))
})();
var state__16903__auto__ = (function (){var statearr_17721 = (f__16902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16902__auto__.cljs$core$IFn$_invoke$arity$0() : f__16902__auto__.call(null));
(statearr_17721[(6)] = c__16901__auto___17722);

return statearr_17721;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16903__auto__);
});})(c__16901__auto___17722,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__17780 = arguments.length;
switch (G__17780) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9540__auto__.call(null,m,ch));
} else {
var m__9540__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9540__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9540__auto__.call(null,m,ch));
} else {
var m__9540__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9540__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__9540__auto__.call(null,m));
} else {
var m__9540__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__9540__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__9540__auto__.call(null,m,state_map));
} else {
var m__9540__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__9540__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__9540__auto__.call(null,m,mode));
} else {
var m__9540__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__9540__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__10092__auto__ = [];
var len__10085__auto___17792 = arguments.length;
var i__10086__auto___17793 = (0);
while(true){
if((i__10086__auto___17793 < len__10085__auto___17792)){
args__10092__auto__.push((arguments[i__10086__auto___17793]));

var G__17794 = (i__10086__auto___17793 + (1));
i__10086__auto___17793 = G__17794;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((3) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10093__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__17786){
var map__17787 = p__17786;
var map__17787__$1 = ((((!((map__17787 == null)))?((((map__17787.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17787.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17787):map__17787);
var opts = map__17787__$1;
var statearr_17789_17795 = state;
(statearr_17789_17795[(1)] = cont_block);


var temp__5457__auto__ = cljs.core.async.do_alts(((function (map__17787,map__17787__$1,opts){
return (function (val){
var statearr_17790_17796 = state;
(statearr_17790_17796[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__17787,map__17787__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5457__auto__)){
var cb = temp__5457__auto__;
var statearr_17791_17797 = state;
(statearr_17791_17797[(2)] = cljs.core.deref(cb));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq17782){
var G__17783 = cljs.core.first(seq17782);
var seq17782__$1 = cljs.core.next(seq17782);
var G__17784 = cljs.core.first(seq17782__$1);
var seq17782__$2 = cljs.core.next(seq17782__$1);
var G__17785 = cljs.core.first(seq17782__$2);
var seq17782__$3 = cljs.core.next(seq17782__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17783,G__17784,G__17785,seq17782__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute);
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async17798 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17798 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta17799){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta17799 = meta17799;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17798.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_17800,meta17799__$1){
var self__ = this;
var _17800__$1 = this;
return (new cljs.core.async.t_cljs$core$async17798(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta17799__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17798.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_17800){
var self__ = this;
var _17800__$1 = this;
return self__.meta17799;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17798.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17798.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17798.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17798.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17798.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17798.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17798.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17798.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17798.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out,cljs.core.cst$sym$cs,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$change,cljs.core.cst$sym$changed,cljs.core.cst$sym$pick,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$meta17799], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17798.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17798.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17798";

cljs.core.async.t_cljs$core$async17798.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async17798");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async17798 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async17798(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta17799){
return (new cljs.core.async.t_cljs$core$async17798(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta17799));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async17798(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__16901__auto___17962 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16901__auto___17962,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__16902__auto__ = (function (){var switch__16799__auto__ = ((function (c__16901__auto___17962,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_17902){
var state_val_17903 = (state_17902[(1)]);
if((state_val_17903 === (7))){
var inst_17817 = (state_17902[(2)]);
var state_17902__$1 = state_17902;
var statearr_17904_17963 = state_17902__$1;
(statearr_17904_17963[(2)] = inst_17817);

(statearr_17904_17963[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (20))){
var inst_17829 = (state_17902[(7)]);
var state_17902__$1 = state_17902;
var statearr_17905_17964 = state_17902__$1;
(statearr_17905_17964[(2)] = inst_17829);

(statearr_17905_17964[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (27))){
var state_17902__$1 = state_17902;
var statearr_17906_17965 = state_17902__$1;
(statearr_17906_17965[(2)] = null);

(statearr_17906_17965[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (1))){
var inst_17804 = (state_17902[(8)]);
var inst_17804__$1 = calc_state();
var inst_17806 = (inst_17804__$1 == null);
var inst_17807 = cljs.core.not(inst_17806);
var state_17902__$1 = (function (){var statearr_17907 = state_17902;
(statearr_17907[(8)] = inst_17804__$1);

return statearr_17907;
})();
if(inst_17807){
var statearr_17908_17966 = state_17902__$1;
(statearr_17908_17966[(1)] = (2));

} else {
var statearr_17909_17967 = state_17902__$1;
(statearr_17909_17967[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (24))){
var inst_17853 = (state_17902[(9)]);
var inst_17876 = (state_17902[(10)]);
var inst_17862 = (state_17902[(11)]);
var inst_17876__$1 = (inst_17853.cljs$core$IFn$_invoke$arity$1 ? inst_17853.cljs$core$IFn$_invoke$arity$1(inst_17862) : inst_17853.call(null,inst_17862));
var state_17902__$1 = (function (){var statearr_17910 = state_17902;
(statearr_17910[(10)] = inst_17876__$1);

return statearr_17910;
})();
if(cljs.core.truth_(inst_17876__$1)){
var statearr_17911_17968 = state_17902__$1;
(statearr_17911_17968[(1)] = (29));

} else {
var statearr_17912_17969 = state_17902__$1;
(statearr_17912_17969[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (4))){
var inst_17820 = (state_17902[(2)]);
var state_17902__$1 = state_17902;
if(cljs.core.truth_(inst_17820)){
var statearr_17913_17970 = state_17902__$1;
(statearr_17913_17970[(1)] = (8));

} else {
var statearr_17914_17971 = state_17902__$1;
(statearr_17914_17971[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (15))){
var inst_17847 = (state_17902[(2)]);
var state_17902__$1 = state_17902;
if(cljs.core.truth_(inst_17847)){
var statearr_17915_17972 = state_17902__$1;
(statearr_17915_17972[(1)] = (19));

} else {
var statearr_17916_17973 = state_17902__$1;
(statearr_17916_17973[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (21))){
var inst_17852 = (state_17902[(12)]);
var inst_17852__$1 = (state_17902[(2)]);
var inst_17853 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17852__$1,cljs.core.cst$kw$solos);
var inst_17854 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17852__$1,cljs.core.cst$kw$mutes);
var inst_17855 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17852__$1,cljs.core.cst$kw$reads);
var state_17902__$1 = (function (){var statearr_17917 = state_17902;
(statearr_17917[(9)] = inst_17853);

(statearr_17917[(12)] = inst_17852__$1);

(statearr_17917[(13)] = inst_17854);

return statearr_17917;
})();
return cljs.core.async.ioc_alts_BANG_(state_17902__$1,(22),inst_17855);
} else {
if((state_val_17903 === (31))){
var inst_17884 = (state_17902[(2)]);
var state_17902__$1 = state_17902;
if(cljs.core.truth_(inst_17884)){
var statearr_17918_17974 = state_17902__$1;
(statearr_17918_17974[(1)] = (32));

} else {
var statearr_17919_17975 = state_17902__$1;
(statearr_17919_17975[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (32))){
var inst_17861 = (state_17902[(14)]);
var state_17902__$1 = state_17902;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17902__$1,(35),out,inst_17861);
} else {
if((state_val_17903 === (33))){
var inst_17852 = (state_17902[(12)]);
var inst_17829 = inst_17852;
var state_17902__$1 = (function (){var statearr_17920 = state_17902;
(statearr_17920[(7)] = inst_17829);

return statearr_17920;
})();
var statearr_17921_17976 = state_17902__$1;
(statearr_17921_17976[(2)] = null);

(statearr_17921_17976[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (13))){
var inst_17829 = (state_17902[(7)]);
var inst_17836 = inst_17829.cljs$lang$protocol_mask$partition0$;
var inst_17837 = (inst_17836 & (64));
var inst_17838 = inst_17829.cljs$core$ISeq$;
var inst_17839 = (cljs.core.PROTOCOL_SENTINEL === inst_17838);
var inst_17840 = (inst_17837) || (inst_17839);
var state_17902__$1 = state_17902;
if(cljs.core.truth_(inst_17840)){
var statearr_17922_17977 = state_17902__$1;
(statearr_17922_17977[(1)] = (16));

} else {
var statearr_17923_17978 = state_17902__$1;
(statearr_17923_17978[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (22))){
var inst_17862 = (state_17902[(11)]);
var inst_17861 = (state_17902[(14)]);
var inst_17860 = (state_17902[(2)]);
var inst_17861__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17860,(0),null);
var inst_17862__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17860,(1),null);
var inst_17863 = (inst_17861__$1 == null);
var inst_17864 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17862__$1,change);
var inst_17865 = (inst_17863) || (inst_17864);
var state_17902__$1 = (function (){var statearr_17924 = state_17902;
(statearr_17924[(11)] = inst_17862__$1);

(statearr_17924[(14)] = inst_17861__$1);

return statearr_17924;
})();
if(cljs.core.truth_(inst_17865)){
var statearr_17925_17979 = state_17902__$1;
(statearr_17925_17979[(1)] = (23));

} else {
var statearr_17926_17980 = state_17902__$1;
(statearr_17926_17980[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (36))){
var inst_17852 = (state_17902[(12)]);
var inst_17829 = inst_17852;
var state_17902__$1 = (function (){var statearr_17927 = state_17902;
(statearr_17927[(7)] = inst_17829);

return statearr_17927;
})();
var statearr_17928_17981 = state_17902__$1;
(statearr_17928_17981[(2)] = null);

(statearr_17928_17981[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (29))){
var inst_17876 = (state_17902[(10)]);
var state_17902__$1 = state_17902;
var statearr_17929_17982 = state_17902__$1;
(statearr_17929_17982[(2)] = inst_17876);

(statearr_17929_17982[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (6))){
var state_17902__$1 = state_17902;
var statearr_17930_17983 = state_17902__$1;
(statearr_17930_17983[(2)] = false);

(statearr_17930_17983[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (28))){
var inst_17872 = (state_17902[(2)]);
var inst_17873 = calc_state();
var inst_17829 = inst_17873;
var state_17902__$1 = (function (){var statearr_17931 = state_17902;
(statearr_17931[(7)] = inst_17829);

(statearr_17931[(15)] = inst_17872);

return statearr_17931;
})();
var statearr_17932_17984 = state_17902__$1;
(statearr_17932_17984[(2)] = null);

(statearr_17932_17984[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (25))){
var inst_17898 = (state_17902[(2)]);
var state_17902__$1 = state_17902;
var statearr_17933_17985 = state_17902__$1;
(statearr_17933_17985[(2)] = inst_17898);

(statearr_17933_17985[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (34))){
var inst_17896 = (state_17902[(2)]);
var state_17902__$1 = state_17902;
var statearr_17934_17986 = state_17902__$1;
(statearr_17934_17986[(2)] = inst_17896);

(statearr_17934_17986[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (17))){
var state_17902__$1 = state_17902;
var statearr_17935_17987 = state_17902__$1;
(statearr_17935_17987[(2)] = false);

(statearr_17935_17987[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (3))){
var state_17902__$1 = state_17902;
var statearr_17936_17988 = state_17902__$1;
(statearr_17936_17988[(2)] = false);

(statearr_17936_17988[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (12))){
var inst_17900 = (state_17902[(2)]);
var state_17902__$1 = state_17902;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17902__$1,inst_17900);
} else {
if((state_val_17903 === (2))){
var inst_17804 = (state_17902[(8)]);
var inst_17809 = inst_17804.cljs$lang$protocol_mask$partition0$;
var inst_17810 = (inst_17809 & (64));
var inst_17811 = inst_17804.cljs$core$ISeq$;
var inst_17812 = (cljs.core.PROTOCOL_SENTINEL === inst_17811);
var inst_17813 = (inst_17810) || (inst_17812);
var state_17902__$1 = state_17902;
if(cljs.core.truth_(inst_17813)){
var statearr_17937_17989 = state_17902__$1;
(statearr_17937_17989[(1)] = (5));

} else {
var statearr_17938_17990 = state_17902__$1;
(statearr_17938_17990[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (23))){
var inst_17861 = (state_17902[(14)]);
var inst_17867 = (inst_17861 == null);
var state_17902__$1 = state_17902;
if(cljs.core.truth_(inst_17867)){
var statearr_17939_17991 = state_17902__$1;
(statearr_17939_17991[(1)] = (26));

} else {
var statearr_17940_17992 = state_17902__$1;
(statearr_17940_17992[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (35))){
var inst_17887 = (state_17902[(2)]);
var state_17902__$1 = state_17902;
if(cljs.core.truth_(inst_17887)){
var statearr_17941_17993 = state_17902__$1;
(statearr_17941_17993[(1)] = (36));

} else {
var statearr_17942_17994 = state_17902__$1;
(statearr_17942_17994[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (19))){
var inst_17829 = (state_17902[(7)]);
var inst_17849 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_17829);
var state_17902__$1 = state_17902;
var statearr_17943_17995 = state_17902__$1;
(statearr_17943_17995[(2)] = inst_17849);

(statearr_17943_17995[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (11))){
var inst_17829 = (state_17902[(7)]);
var inst_17833 = (inst_17829 == null);
var inst_17834 = cljs.core.not(inst_17833);
var state_17902__$1 = state_17902;
if(inst_17834){
var statearr_17944_17996 = state_17902__$1;
(statearr_17944_17996[(1)] = (13));

} else {
var statearr_17945_17997 = state_17902__$1;
(statearr_17945_17997[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (9))){
var inst_17804 = (state_17902[(8)]);
var state_17902__$1 = state_17902;
var statearr_17946_17998 = state_17902__$1;
(statearr_17946_17998[(2)] = inst_17804);

(statearr_17946_17998[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (5))){
var state_17902__$1 = state_17902;
var statearr_17947_17999 = state_17902__$1;
(statearr_17947_17999[(2)] = true);

(statearr_17947_17999[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (14))){
var state_17902__$1 = state_17902;
var statearr_17948_18000 = state_17902__$1;
(statearr_17948_18000[(2)] = false);

(statearr_17948_18000[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (26))){
var inst_17862 = (state_17902[(11)]);
var inst_17869 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_17862);
var state_17902__$1 = state_17902;
var statearr_17949_18001 = state_17902__$1;
(statearr_17949_18001[(2)] = inst_17869);

(statearr_17949_18001[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (16))){
var state_17902__$1 = state_17902;
var statearr_17950_18002 = state_17902__$1;
(statearr_17950_18002[(2)] = true);

(statearr_17950_18002[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (38))){
var inst_17892 = (state_17902[(2)]);
var state_17902__$1 = state_17902;
var statearr_17951_18003 = state_17902__$1;
(statearr_17951_18003[(2)] = inst_17892);

(statearr_17951_18003[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (30))){
var inst_17853 = (state_17902[(9)]);
var inst_17862 = (state_17902[(11)]);
var inst_17854 = (state_17902[(13)]);
var inst_17879 = cljs.core.empty_QMARK_(inst_17853);
var inst_17880 = (inst_17854.cljs$core$IFn$_invoke$arity$1 ? inst_17854.cljs$core$IFn$_invoke$arity$1(inst_17862) : inst_17854.call(null,inst_17862));
var inst_17881 = cljs.core.not(inst_17880);
var inst_17882 = (inst_17879) && (inst_17881);
var state_17902__$1 = state_17902;
var statearr_17952_18004 = state_17902__$1;
(statearr_17952_18004[(2)] = inst_17882);

(statearr_17952_18004[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (10))){
var inst_17804 = (state_17902[(8)]);
var inst_17825 = (state_17902[(2)]);
var inst_17826 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17825,cljs.core.cst$kw$solos);
var inst_17827 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17825,cljs.core.cst$kw$mutes);
var inst_17828 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17825,cljs.core.cst$kw$reads);
var inst_17829 = inst_17804;
var state_17902__$1 = (function (){var statearr_17953 = state_17902;
(statearr_17953[(7)] = inst_17829);

(statearr_17953[(16)] = inst_17828);

(statearr_17953[(17)] = inst_17826);

(statearr_17953[(18)] = inst_17827);

return statearr_17953;
})();
var statearr_17954_18005 = state_17902__$1;
(statearr_17954_18005[(2)] = null);

(statearr_17954_18005[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (18))){
var inst_17844 = (state_17902[(2)]);
var state_17902__$1 = state_17902;
var statearr_17955_18006 = state_17902__$1;
(statearr_17955_18006[(2)] = inst_17844);

(statearr_17955_18006[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (37))){
var state_17902__$1 = state_17902;
var statearr_17956_18007 = state_17902__$1;
(statearr_17956_18007[(2)] = null);

(statearr_17956_18007[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17903 === (8))){
var inst_17804 = (state_17902[(8)]);
var inst_17822 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_17804);
var state_17902__$1 = state_17902;
var statearr_17957_18008 = state_17902__$1;
(statearr_17957_18008[(2)] = inst_17822);

(statearr_17957_18008[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16901__auto___17962,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__16799__auto__,c__16901__auto___17962,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__16800__auto__ = null;
var cljs$core$async$mix_$_state_machine__16800__auto____0 = (function (){
var statearr_17958 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17958[(0)] = cljs$core$async$mix_$_state_machine__16800__auto__);

(statearr_17958[(1)] = (1));

return statearr_17958;
});
var cljs$core$async$mix_$_state_machine__16800__auto____1 = (function (state_17902){
while(true){
var ret_value__16801__auto__ = (function (){try{while(true){
var result__16802__auto__ = switch__16799__auto__(state_17902);
if(cljs.core.keyword_identical_QMARK_(result__16802__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16802__auto__;
}
break;
}
}catch (e17959){if((e17959 instanceof Object)){
var ex__16803__auto__ = e17959;
var statearr_17960_18009 = state_17902;
(statearr_17960_18009[(5)] = ex__16803__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17902);

return cljs.core.cst$kw$recur;
} else {
throw e17959;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16801__auto__,cljs.core.cst$kw$recur)){
var G__18010 = state_17902;
state_17902 = G__18010;
continue;
} else {
return ret_value__16801__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__16800__auto__ = function(state_17902){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__16800__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__16800__auto____1.call(this,state_17902);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__16800__auto____0;
cljs$core$async$mix_$_state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__16800__auto____1;
return cljs$core$async$mix_$_state_machine__16800__auto__;
})()
;})(switch__16799__auto__,c__16901__auto___17962,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__16903__auto__ = (function (){var statearr_17961 = (f__16902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16902__auto__.cljs$core$IFn$_invoke$arity$0() : f__16902__auto__.call(null));
(statearr_17961[(6)] = c__16901__auto___17962);

return statearr_17961;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16903__auto__);
});})(c__16901__auto___17962,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__9539__auto__ = (((p == null))?null:p);
var m__9540__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$4 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__9540__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__9540__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__9540__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__9539__auto__ = (((p == null))?null:p);
var m__9540__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__9540__auto__.call(null,p,v,ch));
} else {
var m__9540__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__9540__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__18012 = arguments.length;
switch (G__18012) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__9539__auto__ = (((p == null))?null:p);
var m__9540__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__9540__auto__.call(null,p));
} else {
var m__9540__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__9540__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__9539__auto__ = (((p == null))?null:p);
var m__9540__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__9540__auto__.call(null,p,v));
} else {
var m__9540__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__9540__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__18016 = arguments.length;
switch (G__18016) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__8806__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__8806__auto__)){
return or__8806__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__8806__auto__,mults){
return (function (p1__18014_SHARP_){
if(cljs.core.truth_((p1__18014_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__18014_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__18014_SHARP_.call(null,topic)))){
return p1__18014_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__18014_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__8806__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async18017 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18017 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta18018){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta18018 = meta18018;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18017.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_18019,meta18018__$1){
var self__ = this;
var _18019__$1 = this;
return (new cljs.core.async.t_cljs$core$async18017(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta18018__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18017.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_18019){
var self__ = this;
var _18019__$1 = this;
return self__.meta18018;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18017.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18017.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18017.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18017.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18017.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5457__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5457__auto__)){
var m = temp__5457__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18017.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18017.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18017.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta18018], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18017.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18017.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18017";

cljs.core.async.t_cljs$core$async18017.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async18017");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async18017 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async18017(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta18018){
return (new cljs.core.async.t_cljs$core$async18017(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta18018));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async18017(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__16901__auto___18137 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16901__auto___18137,mults,ensure_mult,p){
return (function (){
var f__16902__auto__ = (function (){var switch__16799__auto__ = ((function (c__16901__auto___18137,mults,ensure_mult,p){
return (function (state_18091){
var state_val_18092 = (state_18091[(1)]);
if((state_val_18092 === (7))){
var inst_18087 = (state_18091[(2)]);
var state_18091__$1 = state_18091;
var statearr_18093_18138 = state_18091__$1;
(statearr_18093_18138[(2)] = inst_18087);

(statearr_18093_18138[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18092 === (20))){
var state_18091__$1 = state_18091;
var statearr_18094_18139 = state_18091__$1;
(statearr_18094_18139[(2)] = null);

(statearr_18094_18139[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18092 === (1))){
var state_18091__$1 = state_18091;
var statearr_18095_18140 = state_18091__$1;
(statearr_18095_18140[(2)] = null);

(statearr_18095_18140[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18092 === (24))){
var inst_18070 = (state_18091[(7)]);
var inst_18079 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_18070);
var state_18091__$1 = state_18091;
var statearr_18096_18141 = state_18091__$1;
(statearr_18096_18141[(2)] = inst_18079);

(statearr_18096_18141[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18092 === (4))){
var inst_18022 = (state_18091[(8)]);
var inst_18022__$1 = (state_18091[(2)]);
var inst_18023 = (inst_18022__$1 == null);
var state_18091__$1 = (function (){var statearr_18097 = state_18091;
(statearr_18097[(8)] = inst_18022__$1);

return statearr_18097;
})();
if(cljs.core.truth_(inst_18023)){
var statearr_18098_18142 = state_18091__$1;
(statearr_18098_18142[(1)] = (5));

} else {
var statearr_18099_18143 = state_18091__$1;
(statearr_18099_18143[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18092 === (15))){
var inst_18064 = (state_18091[(2)]);
var state_18091__$1 = state_18091;
var statearr_18100_18144 = state_18091__$1;
(statearr_18100_18144[(2)] = inst_18064);

(statearr_18100_18144[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18092 === (21))){
var inst_18084 = (state_18091[(2)]);
var state_18091__$1 = (function (){var statearr_18101 = state_18091;
(statearr_18101[(9)] = inst_18084);

return statearr_18101;
})();
var statearr_18102_18145 = state_18091__$1;
(statearr_18102_18145[(2)] = null);

(statearr_18102_18145[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18092 === (13))){
var inst_18046 = (state_18091[(10)]);
var inst_18048 = cljs.core.chunked_seq_QMARK_(inst_18046);
var state_18091__$1 = state_18091;
if(inst_18048){
var statearr_18103_18146 = state_18091__$1;
(statearr_18103_18146[(1)] = (16));

} else {
var statearr_18104_18147 = state_18091__$1;
(statearr_18104_18147[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18092 === (22))){
var inst_18076 = (state_18091[(2)]);
var state_18091__$1 = state_18091;
if(cljs.core.truth_(inst_18076)){
var statearr_18105_18148 = state_18091__$1;
(statearr_18105_18148[(1)] = (23));

} else {
var statearr_18106_18149 = state_18091__$1;
(statearr_18106_18149[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18092 === (6))){
var inst_18072 = (state_18091[(11)]);
var inst_18022 = (state_18091[(8)]);
var inst_18070 = (state_18091[(7)]);
var inst_18070__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_18022) : topic_fn.call(null,inst_18022));
var inst_18071 = cljs.core.deref(mults);
var inst_18072__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18071,inst_18070__$1);
var state_18091__$1 = (function (){var statearr_18107 = state_18091;
(statearr_18107[(11)] = inst_18072__$1);

(statearr_18107[(7)] = inst_18070__$1);

return statearr_18107;
})();
if(cljs.core.truth_(inst_18072__$1)){
var statearr_18108_18150 = state_18091__$1;
(statearr_18108_18150[(1)] = (19));

} else {
var statearr_18109_18151 = state_18091__$1;
(statearr_18109_18151[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18092 === (25))){
var inst_18081 = (state_18091[(2)]);
var state_18091__$1 = state_18091;
var statearr_18110_18152 = state_18091__$1;
(statearr_18110_18152[(2)] = inst_18081);

(statearr_18110_18152[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18092 === (17))){
var inst_18046 = (state_18091[(10)]);
var inst_18055 = cljs.core.first(inst_18046);
var inst_18056 = cljs.core.async.muxch_STAR_(inst_18055);
var inst_18057 = cljs.core.async.close_BANG_(inst_18056);
var inst_18058 = cljs.core.next(inst_18046);
var inst_18032 = inst_18058;
var inst_18033 = null;
var inst_18034 = (0);
var inst_18035 = (0);
var state_18091__$1 = (function (){var statearr_18111 = state_18091;
(statearr_18111[(12)] = inst_18057);

(statearr_18111[(13)] = inst_18035);

(statearr_18111[(14)] = inst_18034);

(statearr_18111[(15)] = inst_18033);

(statearr_18111[(16)] = inst_18032);

return statearr_18111;
})();
var statearr_18112_18153 = state_18091__$1;
(statearr_18112_18153[(2)] = null);

(statearr_18112_18153[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18092 === (3))){
var inst_18089 = (state_18091[(2)]);
var state_18091__$1 = state_18091;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18091__$1,inst_18089);
} else {
if((state_val_18092 === (12))){
var inst_18066 = (state_18091[(2)]);
var state_18091__$1 = state_18091;
var statearr_18113_18154 = state_18091__$1;
(statearr_18113_18154[(2)] = inst_18066);

(statearr_18113_18154[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18092 === (2))){
var state_18091__$1 = state_18091;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18091__$1,(4),ch);
} else {
if((state_val_18092 === (23))){
var state_18091__$1 = state_18091;
var statearr_18114_18155 = state_18091__$1;
(statearr_18114_18155[(2)] = null);

(statearr_18114_18155[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18092 === (19))){
var inst_18072 = (state_18091[(11)]);
var inst_18022 = (state_18091[(8)]);
var inst_18074 = cljs.core.async.muxch_STAR_(inst_18072);
var state_18091__$1 = state_18091;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18091__$1,(22),inst_18074,inst_18022);
} else {
if((state_val_18092 === (11))){
var inst_18046 = (state_18091[(10)]);
var inst_18032 = (state_18091[(16)]);
var inst_18046__$1 = cljs.core.seq(inst_18032);
var state_18091__$1 = (function (){var statearr_18115 = state_18091;
(statearr_18115[(10)] = inst_18046__$1);

return statearr_18115;
})();
if(inst_18046__$1){
var statearr_18116_18156 = state_18091__$1;
(statearr_18116_18156[(1)] = (13));

} else {
var statearr_18117_18157 = state_18091__$1;
(statearr_18117_18157[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18092 === (9))){
var inst_18068 = (state_18091[(2)]);
var state_18091__$1 = state_18091;
var statearr_18118_18158 = state_18091__$1;
(statearr_18118_18158[(2)] = inst_18068);

(statearr_18118_18158[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18092 === (5))){
var inst_18029 = cljs.core.deref(mults);
var inst_18030 = cljs.core.vals(inst_18029);
var inst_18031 = cljs.core.seq(inst_18030);
var inst_18032 = inst_18031;
var inst_18033 = null;
var inst_18034 = (0);
var inst_18035 = (0);
var state_18091__$1 = (function (){var statearr_18119 = state_18091;
(statearr_18119[(13)] = inst_18035);

(statearr_18119[(14)] = inst_18034);

(statearr_18119[(15)] = inst_18033);

(statearr_18119[(16)] = inst_18032);

return statearr_18119;
})();
var statearr_18120_18159 = state_18091__$1;
(statearr_18120_18159[(2)] = null);

(statearr_18120_18159[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18092 === (14))){
var state_18091__$1 = state_18091;
var statearr_18124_18160 = state_18091__$1;
(statearr_18124_18160[(2)] = null);

(statearr_18124_18160[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18092 === (16))){
var inst_18046 = (state_18091[(10)]);
var inst_18050 = cljs.core.chunk_first(inst_18046);
var inst_18051 = cljs.core.chunk_rest(inst_18046);
var inst_18052 = cljs.core.count(inst_18050);
var inst_18032 = inst_18051;
var inst_18033 = inst_18050;
var inst_18034 = inst_18052;
var inst_18035 = (0);
var state_18091__$1 = (function (){var statearr_18125 = state_18091;
(statearr_18125[(13)] = inst_18035);

(statearr_18125[(14)] = inst_18034);

(statearr_18125[(15)] = inst_18033);

(statearr_18125[(16)] = inst_18032);

return statearr_18125;
})();
var statearr_18126_18161 = state_18091__$1;
(statearr_18126_18161[(2)] = null);

(statearr_18126_18161[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18092 === (10))){
var inst_18035 = (state_18091[(13)]);
var inst_18034 = (state_18091[(14)]);
var inst_18033 = (state_18091[(15)]);
var inst_18032 = (state_18091[(16)]);
var inst_18040 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_18033,inst_18035);
var inst_18041 = cljs.core.async.muxch_STAR_(inst_18040);
var inst_18042 = cljs.core.async.close_BANG_(inst_18041);
var inst_18043 = (inst_18035 + (1));
var tmp18121 = inst_18034;
var tmp18122 = inst_18033;
var tmp18123 = inst_18032;
var inst_18032__$1 = tmp18123;
var inst_18033__$1 = tmp18122;
var inst_18034__$1 = tmp18121;
var inst_18035__$1 = inst_18043;
var state_18091__$1 = (function (){var statearr_18127 = state_18091;
(statearr_18127[(17)] = inst_18042);

(statearr_18127[(13)] = inst_18035__$1);

(statearr_18127[(14)] = inst_18034__$1);

(statearr_18127[(15)] = inst_18033__$1);

(statearr_18127[(16)] = inst_18032__$1);

return statearr_18127;
})();
var statearr_18128_18162 = state_18091__$1;
(statearr_18128_18162[(2)] = null);

(statearr_18128_18162[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18092 === (18))){
var inst_18061 = (state_18091[(2)]);
var state_18091__$1 = state_18091;
var statearr_18129_18163 = state_18091__$1;
(statearr_18129_18163[(2)] = inst_18061);

(statearr_18129_18163[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18092 === (8))){
var inst_18035 = (state_18091[(13)]);
var inst_18034 = (state_18091[(14)]);
var inst_18037 = (inst_18035 < inst_18034);
var inst_18038 = inst_18037;
var state_18091__$1 = state_18091;
if(cljs.core.truth_(inst_18038)){
var statearr_18130_18164 = state_18091__$1;
(statearr_18130_18164[(1)] = (10));

} else {
var statearr_18131_18165 = state_18091__$1;
(statearr_18131_18165[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16901__auto___18137,mults,ensure_mult,p))
;
return ((function (switch__16799__auto__,c__16901__auto___18137,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__16800__auto__ = null;
var cljs$core$async$state_machine__16800__auto____0 = (function (){
var statearr_18132 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18132[(0)] = cljs$core$async$state_machine__16800__auto__);

(statearr_18132[(1)] = (1));

return statearr_18132;
});
var cljs$core$async$state_machine__16800__auto____1 = (function (state_18091){
while(true){
var ret_value__16801__auto__ = (function (){try{while(true){
var result__16802__auto__ = switch__16799__auto__(state_18091);
if(cljs.core.keyword_identical_QMARK_(result__16802__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16802__auto__;
}
break;
}
}catch (e18133){if((e18133 instanceof Object)){
var ex__16803__auto__ = e18133;
var statearr_18134_18166 = state_18091;
(statearr_18134_18166[(5)] = ex__16803__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18091);

return cljs.core.cst$kw$recur;
} else {
throw e18133;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16801__auto__,cljs.core.cst$kw$recur)){
var G__18167 = state_18091;
state_18091 = G__18167;
continue;
} else {
return ret_value__16801__auto__;
}
break;
}
});
cljs$core$async$state_machine__16800__auto__ = function(state_18091){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16800__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16800__auto____1.call(this,state_18091);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16800__auto____0;
cljs$core$async$state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16800__auto____1;
return cljs$core$async$state_machine__16800__auto__;
})()
;})(switch__16799__auto__,c__16901__auto___18137,mults,ensure_mult,p))
})();
var state__16903__auto__ = (function (){var statearr_18135 = (f__16902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16902__auto__.cljs$core$IFn$_invoke$arity$0() : f__16902__auto__.call(null));
(statearr_18135[(6)] = c__16901__auto___18137);

return statearr_18135;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16903__auto__);
});})(c__16901__auto___18137,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__18169 = arguments.length;
switch (G__18169) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__18172 = arguments.length;
switch (G__18172) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__18175 = arguments.length;
switch (G__18175) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__16901__auto___18242 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16901__auto___18242,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__16902__auto__ = (function (){var switch__16799__auto__ = ((function (c__16901__auto___18242,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_18214){
var state_val_18215 = (state_18214[(1)]);
if((state_val_18215 === (7))){
var state_18214__$1 = state_18214;
var statearr_18216_18243 = state_18214__$1;
(statearr_18216_18243[(2)] = null);

(statearr_18216_18243[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18215 === (1))){
var state_18214__$1 = state_18214;
var statearr_18217_18244 = state_18214__$1;
(statearr_18217_18244[(2)] = null);

(statearr_18217_18244[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18215 === (4))){
var inst_18178 = (state_18214[(7)]);
var inst_18180 = (inst_18178 < cnt);
var state_18214__$1 = state_18214;
if(cljs.core.truth_(inst_18180)){
var statearr_18218_18245 = state_18214__$1;
(statearr_18218_18245[(1)] = (6));

} else {
var statearr_18219_18246 = state_18214__$1;
(statearr_18219_18246[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18215 === (15))){
var inst_18210 = (state_18214[(2)]);
var state_18214__$1 = state_18214;
var statearr_18220_18247 = state_18214__$1;
(statearr_18220_18247[(2)] = inst_18210);

(statearr_18220_18247[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18215 === (13))){
var inst_18203 = cljs.core.async.close_BANG_(out);
var state_18214__$1 = state_18214;
var statearr_18221_18248 = state_18214__$1;
(statearr_18221_18248[(2)] = inst_18203);

(statearr_18221_18248[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18215 === (6))){
var state_18214__$1 = state_18214;
var statearr_18222_18249 = state_18214__$1;
(statearr_18222_18249[(2)] = null);

(statearr_18222_18249[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18215 === (3))){
var inst_18212 = (state_18214[(2)]);
var state_18214__$1 = state_18214;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18214__$1,inst_18212);
} else {
if((state_val_18215 === (12))){
var inst_18200 = (state_18214[(8)]);
var inst_18200__$1 = (state_18214[(2)]);
var inst_18201 = cljs.core.some(cljs.core.nil_QMARK_,inst_18200__$1);
var state_18214__$1 = (function (){var statearr_18223 = state_18214;
(statearr_18223[(8)] = inst_18200__$1);

return statearr_18223;
})();
if(cljs.core.truth_(inst_18201)){
var statearr_18224_18250 = state_18214__$1;
(statearr_18224_18250[(1)] = (13));

} else {
var statearr_18225_18251 = state_18214__$1;
(statearr_18225_18251[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18215 === (2))){
var inst_18177 = cljs.core.reset_BANG_(dctr,cnt);
var inst_18178 = (0);
var state_18214__$1 = (function (){var statearr_18226 = state_18214;
(statearr_18226[(7)] = inst_18178);

(statearr_18226[(9)] = inst_18177);

return statearr_18226;
})();
var statearr_18227_18252 = state_18214__$1;
(statearr_18227_18252[(2)] = null);

(statearr_18227_18252[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18215 === (11))){
var inst_18178 = (state_18214[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_18214,(10),Object,null,(9));
var inst_18187 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_18178) : chs__$1.call(null,inst_18178));
var inst_18188 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_18178) : done.call(null,inst_18178));
var inst_18189 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_18187,inst_18188);
var state_18214__$1 = state_18214;
var statearr_18228_18253 = state_18214__$1;
(statearr_18228_18253[(2)] = inst_18189);


cljs.core.async.impl.ioc_helpers.process_exception(state_18214__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_18215 === (9))){
var inst_18178 = (state_18214[(7)]);
var inst_18191 = (state_18214[(2)]);
var inst_18192 = (inst_18178 + (1));
var inst_18178__$1 = inst_18192;
var state_18214__$1 = (function (){var statearr_18229 = state_18214;
(statearr_18229[(7)] = inst_18178__$1);

(statearr_18229[(10)] = inst_18191);

return statearr_18229;
})();
var statearr_18230_18254 = state_18214__$1;
(statearr_18230_18254[(2)] = null);

(statearr_18230_18254[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18215 === (5))){
var inst_18198 = (state_18214[(2)]);
var state_18214__$1 = (function (){var statearr_18231 = state_18214;
(statearr_18231[(11)] = inst_18198);

return statearr_18231;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18214__$1,(12),dchan);
} else {
if((state_val_18215 === (14))){
var inst_18200 = (state_18214[(8)]);
var inst_18205 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_18200);
var state_18214__$1 = state_18214;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18214__$1,(16),out,inst_18205);
} else {
if((state_val_18215 === (16))){
var inst_18207 = (state_18214[(2)]);
var state_18214__$1 = (function (){var statearr_18232 = state_18214;
(statearr_18232[(12)] = inst_18207);

return statearr_18232;
})();
var statearr_18233_18255 = state_18214__$1;
(statearr_18233_18255[(2)] = null);

(statearr_18233_18255[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18215 === (10))){
var inst_18182 = (state_18214[(2)]);
var inst_18183 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_18214__$1 = (function (){var statearr_18234 = state_18214;
(statearr_18234[(13)] = inst_18182);

return statearr_18234;
})();
var statearr_18235_18256 = state_18214__$1;
(statearr_18235_18256[(2)] = inst_18183);


cljs.core.async.impl.ioc_helpers.process_exception(state_18214__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_18215 === (8))){
var inst_18196 = (state_18214[(2)]);
var state_18214__$1 = state_18214;
var statearr_18236_18257 = state_18214__$1;
(statearr_18236_18257[(2)] = inst_18196);

(statearr_18236_18257[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16901__auto___18242,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__16799__auto__,c__16901__auto___18242,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__16800__auto__ = null;
var cljs$core$async$state_machine__16800__auto____0 = (function (){
var statearr_18237 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18237[(0)] = cljs$core$async$state_machine__16800__auto__);

(statearr_18237[(1)] = (1));

return statearr_18237;
});
var cljs$core$async$state_machine__16800__auto____1 = (function (state_18214){
while(true){
var ret_value__16801__auto__ = (function (){try{while(true){
var result__16802__auto__ = switch__16799__auto__(state_18214);
if(cljs.core.keyword_identical_QMARK_(result__16802__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16802__auto__;
}
break;
}
}catch (e18238){if((e18238 instanceof Object)){
var ex__16803__auto__ = e18238;
var statearr_18239_18258 = state_18214;
(statearr_18239_18258[(5)] = ex__16803__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18214);

return cljs.core.cst$kw$recur;
} else {
throw e18238;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16801__auto__,cljs.core.cst$kw$recur)){
var G__18259 = state_18214;
state_18214 = G__18259;
continue;
} else {
return ret_value__16801__auto__;
}
break;
}
});
cljs$core$async$state_machine__16800__auto__ = function(state_18214){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16800__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16800__auto____1.call(this,state_18214);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16800__auto____0;
cljs$core$async$state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16800__auto____1;
return cljs$core$async$state_machine__16800__auto__;
})()
;})(switch__16799__auto__,c__16901__auto___18242,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__16903__auto__ = (function (){var statearr_18240 = (f__16902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16902__auto__.cljs$core$IFn$_invoke$arity$0() : f__16902__auto__.call(null));
(statearr_18240[(6)] = c__16901__auto___18242);

return statearr_18240;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16903__auto__);
});})(c__16901__auto___18242,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__18262 = arguments.length;
switch (G__18262) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16901__auto___18316 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16901__auto___18316,out){
return (function (){
var f__16902__auto__ = (function (){var switch__16799__auto__ = ((function (c__16901__auto___18316,out){
return (function (state_18294){
var state_val_18295 = (state_18294[(1)]);
if((state_val_18295 === (7))){
var inst_18273 = (state_18294[(7)]);
var inst_18274 = (state_18294[(8)]);
var inst_18273__$1 = (state_18294[(2)]);
var inst_18274__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18273__$1,(0),null);
var inst_18275 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18273__$1,(1),null);
var inst_18276 = (inst_18274__$1 == null);
var state_18294__$1 = (function (){var statearr_18296 = state_18294;
(statearr_18296[(7)] = inst_18273__$1);

(statearr_18296[(8)] = inst_18274__$1);

(statearr_18296[(9)] = inst_18275);

return statearr_18296;
})();
if(cljs.core.truth_(inst_18276)){
var statearr_18297_18317 = state_18294__$1;
(statearr_18297_18317[(1)] = (8));

} else {
var statearr_18298_18318 = state_18294__$1;
(statearr_18298_18318[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18295 === (1))){
var inst_18263 = cljs.core.vec(chs);
var inst_18264 = inst_18263;
var state_18294__$1 = (function (){var statearr_18299 = state_18294;
(statearr_18299[(10)] = inst_18264);

return statearr_18299;
})();
var statearr_18300_18319 = state_18294__$1;
(statearr_18300_18319[(2)] = null);

(statearr_18300_18319[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18295 === (4))){
var inst_18264 = (state_18294[(10)]);
var state_18294__$1 = state_18294;
return cljs.core.async.ioc_alts_BANG_(state_18294__$1,(7),inst_18264);
} else {
if((state_val_18295 === (6))){
var inst_18290 = (state_18294[(2)]);
var state_18294__$1 = state_18294;
var statearr_18301_18320 = state_18294__$1;
(statearr_18301_18320[(2)] = inst_18290);

(statearr_18301_18320[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18295 === (3))){
var inst_18292 = (state_18294[(2)]);
var state_18294__$1 = state_18294;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18294__$1,inst_18292);
} else {
if((state_val_18295 === (2))){
var inst_18264 = (state_18294[(10)]);
var inst_18266 = cljs.core.count(inst_18264);
var inst_18267 = (inst_18266 > (0));
var state_18294__$1 = state_18294;
if(cljs.core.truth_(inst_18267)){
var statearr_18303_18321 = state_18294__$1;
(statearr_18303_18321[(1)] = (4));

} else {
var statearr_18304_18322 = state_18294__$1;
(statearr_18304_18322[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18295 === (11))){
var inst_18264 = (state_18294[(10)]);
var inst_18283 = (state_18294[(2)]);
var tmp18302 = inst_18264;
var inst_18264__$1 = tmp18302;
var state_18294__$1 = (function (){var statearr_18305 = state_18294;
(statearr_18305[(10)] = inst_18264__$1);

(statearr_18305[(11)] = inst_18283);

return statearr_18305;
})();
var statearr_18306_18323 = state_18294__$1;
(statearr_18306_18323[(2)] = null);

(statearr_18306_18323[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18295 === (9))){
var inst_18274 = (state_18294[(8)]);
var state_18294__$1 = state_18294;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18294__$1,(11),out,inst_18274);
} else {
if((state_val_18295 === (5))){
var inst_18288 = cljs.core.async.close_BANG_(out);
var state_18294__$1 = state_18294;
var statearr_18307_18324 = state_18294__$1;
(statearr_18307_18324[(2)] = inst_18288);

(statearr_18307_18324[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18295 === (10))){
var inst_18286 = (state_18294[(2)]);
var state_18294__$1 = state_18294;
var statearr_18308_18325 = state_18294__$1;
(statearr_18308_18325[(2)] = inst_18286);

(statearr_18308_18325[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18295 === (8))){
var inst_18264 = (state_18294[(10)]);
var inst_18273 = (state_18294[(7)]);
var inst_18274 = (state_18294[(8)]);
var inst_18275 = (state_18294[(9)]);
var inst_18278 = (function (){var cs = inst_18264;
var vec__18269 = inst_18273;
var v = inst_18274;
var c = inst_18275;
return ((function (cs,vec__18269,v,c,inst_18264,inst_18273,inst_18274,inst_18275,state_val_18295,c__16901__auto___18316,out){
return (function (p1__18260_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__18260_SHARP_);
});
;})(cs,vec__18269,v,c,inst_18264,inst_18273,inst_18274,inst_18275,state_val_18295,c__16901__auto___18316,out))
})();
var inst_18279 = cljs.core.filterv(inst_18278,inst_18264);
var inst_18264__$1 = inst_18279;
var state_18294__$1 = (function (){var statearr_18309 = state_18294;
(statearr_18309[(10)] = inst_18264__$1);

return statearr_18309;
})();
var statearr_18310_18326 = state_18294__$1;
(statearr_18310_18326[(2)] = null);

(statearr_18310_18326[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16901__auto___18316,out))
;
return ((function (switch__16799__auto__,c__16901__auto___18316,out){
return (function() {
var cljs$core$async$state_machine__16800__auto__ = null;
var cljs$core$async$state_machine__16800__auto____0 = (function (){
var statearr_18311 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18311[(0)] = cljs$core$async$state_machine__16800__auto__);

(statearr_18311[(1)] = (1));

return statearr_18311;
});
var cljs$core$async$state_machine__16800__auto____1 = (function (state_18294){
while(true){
var ret_value__16801__auto__ = (function (){try{while(true){
var result__16802__auto__ = switch__16799__auto__(state_18294);
if(cljs.core.keyword_identical_QMARK_(result__16802__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16802__auto__;
}
break;
}
}catch (e18312){if((e18312 instanceof Object)){
var ex__16803__auto__ = e18312;
var statearr_18313_18327 = state_18294;
(statearr_18313_18327[(5)] = ex__16803__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18294);

return cljs.core.cst$kw$recur;
} else {
throw e18312;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16801__auto__,cljs.core.cst$kw$recur)){
var G__18328 = state_18294;
state_18294 = G__18328;
continue;
} else {
return ret_value__16801__auto__;
}
break;
}
});
cljs$core$async$state_machine__16800__auto__ = function(state_18294){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16800__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16800__auto____1.call(this,state_18294);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16800__auto____0;
cljs$core$async$state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16800__auto____1;
return cljs$core$async$state_machine__16800__auto__;
})()
;})(switch__16799__auto__,c__16901__auto___18316,out))
})();
var state__16903__auto__ = (function (){var statearr_18314 = (f__16902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16902__auto__.cljs$core$IFn$_invoke$arity$0() : f__16902__auto__.call(null));
(statearr_18314[(6)] = c__16901__auto___18316);

return statearr_18314;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16903__auto__);
});})(c__16901__auto___18316,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__18330 = arguments.length;
switch (G__18330) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16901__auto___18375 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16901__auto___18375,out){
return (function (){
var f__16902__auto__ = (function (){var switch__16799__auto__ = ((function (c__16901__auto___18375,out){
return (function (state_18354){
var state_val_18355 = (state_18354[(1)]);
if((state_val_18355 === (7))){
var inst_18336 = (state_18354[(7)]);
var inst_18336__$1 = (state_18354[(2)]);
var inst_18337 = (inst_18336__$1 == null);
var inst_18338 = cljs.core.not(inst_18337);
var state_18354__$1 = (function (){var statearr_18356 = state_18354;
(statearr_18356[(7)] = inst_18336__$1);

return statearr_18356;
})();
if(inst_18338){
var statearr_18357_18376 = state_18354__$1;
(statearr_18357_18376[(1)] = (8));

} else {
var statearr_18358_18377 = state_18354__$1;
(statearr_18358_18377[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18355 === (1))){
var inst_18331 = (0);
var state_18354__$1 = (function (){var statearr_18359 = state_18354;
(statearr_18359[(8)] = inst_18331);

return statearr_18359;
})();
var statearr_18360_18378 = state_18354__$1;
(statearr_18360_18378[(2)] = null);

(statearr_18360_18378[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18355 === (4))){
var state_18354__$1 = state_18354;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18354__$1,(7),ch);
} else {
if((state_val_18355 === (6))){
var inst_18349 = (state_18354[(2)]);
var state_18354__$1 = state_18354;
var statearr_18361_18379 = state_18354__$1;
(statearr_18361_18379[(2)] = inst_18349);

(statearr_18361_18379[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18355 === (3))){
var inst_18351 = (state_18354[(2)]);
var inst_18352 = cljs.core.async.close_BANG_(out);
var state_18354__$1 = (function (){var statearr_18362 = state_18354;
(statearr_18362[(9)] = inst_18351);

return statearr_18362;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_18354__$1,inst_18352);
} else {
if((state_val_18355 === (2))){
var inst_18331 = (state_18354[(8)]);
var inst_18333 = (inst_18331 < n);
var state_18354__$1 = state_18354;
if(cljs.core.truth_(inst_18333)){
var statearr_18363_18380 = state_18354__$1;
(statearr_18363_18380[(1)] = (4));

} else {
var statearr_18364_18381 = state_18354__$1;
(statearr_18364_18381[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18355 === (11))){
var inst_18331 = (state_18354[(8)]);
var inst_18341 = (state_18354[(2)]);
var inst_18342 = (inst_18331 + (1));
var inst_18331__$1 = inst_18342;
var state_18354__$1 = (function (){var statearr_18365 = state_18354;
(statearr_18365[(8)] = inst_18331__$1);

(statearr_18365[(10)] = inst_18341);

return statearr_18365;
})();
var statearr_18366_18382 = state_18354__$1;
(statearr_18366_18382[(2)] = null);

(statearr_18366_18382[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18355 === (9))){
var state_18354__$1 = state_18354;
var statearr_18367_18383 = state_18354__$1;
(statearr_18367_18383[(2)] = null);

(statearr_18367_18383[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18355 === (5))){
var state_18354__$1 = state_18354;
var statearr_18368_18384 = state_18354__$1;
(statearr_18368_18384[(2)] = null);

(statearr_18368_18384[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18355 === (10))){
var inst_18346 = (state_18354[(2)]);
var state_18354__$1 = state_18354;
var statearr_18369_18385 = state_18354__$1;
(statearr_18369_18385[(2)] = inst_18346);

(statearr_18369_18385[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18355 === (8))){
var inst_18336 = (state_18354[(7)]);
var state_18354__$1 = state_18354;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18354__$1,(11),out,inst_18336);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16901__auto___18375,out))
;
return ((function (switch__16799__auto__,c__16901__auto___18375,out){
return (function() {
var cljs$core$async$state_machine__16800__auto__ = null;
var cljs$core$async$state_machine__16800__auto____0 = (function (){
var statearr_18370 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18370[(0)] = cljs$core$async$state_machine__16800__auto__);

(statearr_18370[(1)] = (1));

return statearr_18370;
});
var cljs$core$async$state_machine__16800__auto____1 = (function (state_18354){
while(true){
var ret_value__16801__auto__ = (function (){try{while(true){
var result__16802__auto__ = switch__16799__auto__(state_18354);
if(cljs.core.keyword_identical_QMARK_(result__16802__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16802__auto__;
}
break;
}
}catch (e18371){if((e18371 instanceof Object)){
var ex__16803__auto__ = e18371;
var statearr_18372_18386 = state_18354;
(statearr_18372_18386[(5)] = ex__16803__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18354);

return cljs.core.cst$kw$recur;
} else {
throw e18371;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16801__auto__,cljs.core.cst$kw$recur)){
var G__18387 = state_18354;
state_18354 = G__18387;
continue;
} else {
return ret_value__16801__auto__;
}
break;
}
});
cljs$core$async$state_machine__16800__auto__ = function(state_18354){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16800__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16800__auto____1.call(this,state_18354);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16800__auto____0;
cljs$core$async$state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16800__auto____1;
return cljs$core$async$state_machine__16800__auto__;
})()
;})(switch__16799__auto__,c__16901__auto___18375,out))
})();
var state__16903__auto__ = (function (){var statearr_18373 = (f__16902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16902__auto__.cljs$core$IFn$_invoke$arity$0() : f__16902__auto__.call(null));
(statearr_18373[(6)] = c__16901__auto___18375);

return statearr_18373;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16903__auto__);
});})(c__16901__auto___18375,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async18389 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18389 = (function (f,ch,meta18390){
this.f = f;
this.ch = ch;
this.meta18390 = meta18390;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18389.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18391,meta18390__$1){
var self__ = this;
var _18391__$1 = this;
return (new cljs.core.async.t_cljs$core$async18389(self__.f,self__.ch,meta18390__$1));
});

cljs.core.async.t_cljs$core$async18389.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18391){
var self__ = this;
var _18391__$1 = this;
return self__.meta18390;
});

cljs.core.async.t_cljs$core$async18389.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18389.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async18389.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async18389.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18389.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async18392 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18392 = (function (f,ch,meta18390,_,fn1,meta18393){
this.f = f;
this.ch = ch;
this.meta18390 = meta18390;
this._ = _;
this.fn1 = fn1;
this.meta18393 = meta18393;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18392.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_18394,meta18393__$1){
var self__ = this;
var _18394__$1 = this;
return (new cljs.core.async.t_cljs$core$async18392(self__.f,self__.ch,self__.meta18390,self__._,self__.fn1,meta18393__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async18392.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_18394){
var self__ = this;
var _18394__$1 = this;
return self__.meta18393;
});})(___$1))
;

cljs.core.async.t_cljs$core$async18392.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18392.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async18392.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async18392.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__18388_SHARP_){
var G__18395 = (((p1__18388_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__18388_SHARP_) : self__.f.call(null,p1__18388_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__18395) : f1.call(null,G__18395));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async18392.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta18390,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async18389], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta18393], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async18392.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18392.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18392";

cljs.core.async.t_cljs$core$async18392.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async18392");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async18392 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async18392(f__$1,ch__$1,meta18390__$1,___$2,fn1__$1,meta18393){
return (new cljs.core.async.t_cljs$core$async18392(f__$1,ch__$1,meta18390__$1,___$2,fn1__$1,meta18393));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async18392(self__.f,self__.ch,self__.meta18390,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__8794__auto__ = ret;
if(cljs.core.truth_(and__8794__auto__)){
return !((cljs.core.deref(ret) == null));
} else {
return and__8794__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__18396 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__18396) : self__.f.call(null,G__18396));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async18389.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18389.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async18389.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta18390], null);
});

cljs.core.async.t_cljs$core$async18389.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18389.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18389";

cljs.core.async.t_cljs$core$async18389.cljs$lang$ctorPrWriter = (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async18389");
});

cljs.core.async.__GT_t_cljs$core$async18389 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async18389(f__$1,ch__$1,meta18390){
return (new cljs.core.async.t_cljs$core$async18389(f__$1,ch__$1,meta18390));
});

}

return (new cljs.core.async.t_cljs$core$async18389(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async18397 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18397 = (function (f,ch,meta18398){
this.f = f;
this.ch = ch;
this.meta18398 = meta18398;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18397.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18399,meta18398__$1){
var self__ = this;
var _18399__$1 = this;
return (new cljs.core.async.t_cljs$core$async18397(self__.f,self__.ch,meta18398__$1));
});

cljs.core.async.t_cljs$core$async18397.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18399){
var self__ = this;
var _18399__$1 = this;
return self__.meta18398;
});

cljs.core.async.t_cljs$core$async18397.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18397.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async18397.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18397.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async18397.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18397.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async18397.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta18398], null);
});

cljs.core.async.t_cljs$core$async18397.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18397.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18397";

cljs.core.async.t_cljs$core$async18397.cljs$lang$ctorPrWriter = (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async18397");
});

cljs.core.async.__GT_t_cljs$core$async18397 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async18397(f__$1,ch__$1,meta18398){
return (new cljs.core.async.t_cljs$core$async18397(f__$1,ch__$1,meta18398));
});

}

return (new cljs.core.async.t_cljs$core$async18397(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async18400 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18400 = (function (p,ch,meta18401){
this.p = p;
this.ch = ch;
this.meta18401 = meta18401;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18400.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18402,meta18401__$1){
var self__ = this;
var _18402__$1 = this;
return (new cljs.core.async.t_cljs$core$async18400(self__.p,self__.ch,meta18401__$1));
});

cljs.core.async.t_cljs$core$async18400.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18402){
var self__ = this;
var _18402__$1 = this;
return self__.meta18401;
});

cljs.core.async.t_cljs$core$async18400.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18400.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async18400.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async18400.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18400.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async18400.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18400.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async18400.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta18401], null);
});

cljs.core.async.t_cljs$core$async18400.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18400.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18400";

cljs.core.async.t_cljs$core$async18400.cljs$lang$ctorPrWriter = (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async18400");
});

cljs.core.async.__GT_t_cljs$core$async18400 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async18400(p__$1,ch__$1,meta18401){
return (new cljs.core.async.t_cljs$core$async18400(p__$1,ch__$1,meta18401));
});

}

return (new cljs.core.async.t_cljs$core$async18400(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__18404 = arguments.length;
switch (G__18404) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16901__auto___18444 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16901__auto___18444,out){
return (function (){
var f__16902__auto__ = (function (){var switch__16799__auto__ = ((function (c__16901__auto___18444,out){
return (function (state_18425){
var state_val_18426 = (state_18425[(1)]);
if((state_val_18426 === (7))){
var inst_18421 = (state_18425[(2)]);
var state_18425__$1 = state_18425;
var statearr_18427_18445 = state_18425__$1;
(statearr_18427_18445[(2)] = inst_18421);

(statearr_18427_18445[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18426 === (1))){
var state_18425__$1 = state_18425;
var statearr_18428_18446 = state_18425__$1;
(statearr_18428_18446[(2)] = null);

(statearr_18428_18446[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18426 === (4))){
var inst_18407 = (state_18425[(7)]);
var inst_18407__$1 = (state_18425[(2)]);
var inst_18408 = (inst_18407__$1 == null);
var state_18425__$1 = (function (){var statearr_18429 = state_18425;
(statearr_18429[(7)] = inst_18407__$1);

return statearr_18429;
})();
if(cljs.core.truth_(inst_18408)){
var statearr_18430_18447 = state_18425__$1;
(statearr_18430_18447[(1)] = (5));

} else {
var statearr_18431_18448 = state_18425__$1;
(statearr_18431_18448[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18426 === (6))){
var inst_18407 = (state_18425[(7)]);
var inst_18412 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_18407) : p.call(null,inst_18407));
var state_18425__$1 = state_18425;
if(cljs.core.truth_(inst_18412)){
var statearr_18432_18449 = state_18425__$1;
(statearr_18432_18449[(1)] = (8));

} else {
var statearr_18433_18450 = state_18425__$1;
(statearr_18433_18450[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18426 === (3))){
var inst_18423 = (state_18425[(2)]);
var state_18425__$1 = state_18425;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18425__$1,inst_18423);
} else {
if((state_val_18426 === (2))){
var state_18425__$1 = state_18425;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18425__$1,(4),ch);
} else {
if((state_val_18426 === (11))){
var inst_18415 = (state_18425[(2)]);
var state_18425__$1 = state_18425;
var statearr_18434_18451 = state_18425__$1;
(statearr_18434_18451[(2)] = inst_18415);

(statearr_18434_18451[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18426 === (9))){
var state_18425__$1 = state_18425;
var statearr_18435_18452 = state_18425__$1;
(statearr_18435_18452[(2)] = null);

(statearr_18435_18452[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18426 === (5))){
var inst_18410 = cljs.core.async.close_BANG_(out);
var state_18425__$1 = state_18425;
var statearr_18436_18453 = state_18425__$1;
(statearr_18436_18453[(2)] = inst_18410);

(statearr_18436_18453[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18426 === (10))){
var inst_18418 = (state_18425[(2)]);
var state_18425__$1 = (function (){var statearr_18437 = state_18425;
(statearr_18437[(8)] = inst_18418);

return statearr_18437;
})();
var statearr_18438_18454 = state_18425__$1;
(statearr_18438_18454[(2)] = null);

(statearr_18438_18454[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18426 === (8))){
var inst_18407 = (state_18425[(7)]);
var state_18425__$1 = state_18425;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18425__$1,(11),out,inst_18407);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16901__auto___18444,out))
;
return ((function (switch__16799__auto__,c__16901__auto___18444,out){
return (function() {
var cljs$core$async$state_machine__16800__auto__ = null;
var cljs$core$async$state_machine__16800__auto____0 = (function (){
var statearr_18439 = [null,null,null,null,null,null,null,null,null];
(statearr_18439[(0)] = cljs$core$async$state_machine__16800__auto__);

(statearr_18439[(1)] = (1));

return statearr_18439;
});
var cljs$core$async$state_machine__16800__auto____1 = (function (state_18425){
while(true){
var ret_value__16801__auto__ = (function (){try{while(true){
var result__16802__auto__ = switch__16799__auto__(state_18425);
if(cljs.core.keyword_identical_QMARK_(result__16802__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16802__auto__;
}
break;
}
}catch (e18440){if((e18440 instanceof Object)){
var ex__16803__auto__ = e18440;
var statearr_18441_18455 = state_18425;
(statearr_18441_18455[(5)] = ex__16803__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18425);

return cljs.core.cst$kw$recur;
} else {
throw e18440;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16801__auto__,cljs.core.cst$kw$recur)){
var G__18456 = state_18425;
state_18425 = G__18456;
continue;
} else {
return ret_value__16801__auto__;
}
break;
}
});
cljs$core$async$state_machine__16800__auto__ = function(state_18425){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16800__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16800__auto____1.call(this,state_18425);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16800__auto____0;
cljs$core$async$state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16800__auto____1;
return cljs$core$async$state_machine__16800__auto__;
})()
;})(switch__16799__auto__,c__16901__auto___18444,out))
})();
var state__16903__auto__ = (function (){var statearr_18442 = (f__16902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16902__auto__.cljs$core$IFn$_invoke$arity$0() : f__16902__auto__.call(null));
(statearr_18442[(6)] = c__16901__auto___18444);

return statearr_18442;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16903__auto__);
});})(c__16901__auto___18444,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__18458 = arguments.length;
switch (G__18458) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__16901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16901__auto__){
return (function (){
var f__16902__auto__ = (function (){var switch__16799__auto__ = ((function (c__16901__auto__){
return (function (state_18521){
var state_val_18522 = (state_18521[(1)]);
if((state_val_18522 === (7))){
var inst_18517 = (state_18521[(2)]);
var state_18521__$1 = state_18521;
var statearr_18523_18561 = state_18521__$1;
(statearr_18523_18561[(2)] = inst_18517);

(statearr_18523_18561[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18522 === (20))){
var inst_18487 = (state_18521[(7)]);
var inst_18498 = (state_18521[(2)]);
var inst_18499 = cljs.core.next(inst_18487);
var inst_18473 = inst_18499;
var inst_18474 = null;
var inst_18475 = (0);
var inst_18476 = (0);
var state_18521__$1 = (function (){var statearr_18524 = state_18521;
(statearr_18524[(8)] = inst_18473);

(statearr_18524[(9)] = inst_18474);

(statearr_18524[(10)] = inst_18498);

(statearr_18524[(11)] = inst_18476);

(statearr_18524[(12)] = inst_18475);

return statearr_18524;
})();
var statearr_18525_18562 = state_18521__$1;
(statearr_18525_18562[(2)] = null);

(statearr_18525_18562[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18522 === (1))){
var state_18521__$1 = state_18521;
var statearr_18526_18563 = state_18521__$1;
(statearr_18526_18563[(2)] = null);

(statearr_18526_18563[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18522 === (4))){
var inst_18462 = (state_18521[(13)]);
var inst_18462__$1 = (state_18521[(2)]);
var inst_18463 = (inst_18462__$1 == null);
var state_18521__$1 = (function (){var statearr_18527 = state_18521;
(statearr_18527[(13)] = inst_18462__$1);

return statearr_18527;
})();
if(cljs.core.truth_(inst_18463)){
var statearr_18528_18564 = state_18521__$1;
(statearr_18528_18564[(1)] = (5));

} else {
var statearr_18529_18565 = state_18521__$1;
(statearr_18529_18565[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18522 === (15))){
var state_18521__$1 = state_18521;
var statearr_18533_18566 = state_18521__$1;
(statearr_18533_18566[(2)] = null);

(statearr_18533_18566[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18522 === (21))){
var state_18521__$1 = state_18521;
var statearr_18534_18567 = state_18521__$1;
(statearr_18534_18567[(2)] = null);

(statearr_18534_18567[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18522 === (13))){
var inst_18473 = (state_18521[(8)]);
var inst_18474 = (state_18521[(9)]);
var inst_18476 = (state_18521[(11)]);
var inst_18475 = (state_18521[(12)]);
var inst_18483 = (state_18521[(2)]);
var inst_18484 = (inst_18476 + (1));
var tmp18530 = inst_18473;
var tmp18531 = inst_18474;
var tmp18532 = inst_18475;
var inst_18473__$1 = tmp18530;
var inst_18474__$1 = tmp18531;
var inst_18475__$1 = tmp18532;
var inst_18476__$1 = inst_18484;
var state_18521__$1 = (function (){var statearr_18535 = state_18521;
(statearr_18535[(8)] = inst_18473__$1);

(statearr_18535[(14)] = inst_18483);

(statearr_18535[(9)] = inst_18474__$1);

(statearr_18535[(11)] = inst_18476__$1);

(statearr_18535[(12)] = inst_18475__$1);

return statearr_18535;
})();
var statearr_18536_18568 = state_18521__$1;
(statearr_18536_18568[(2)] = null);

(statearr_18536_18568[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18522 === (22))){
var state_18521__$1 = state_18521;
var statearr_18537_18569 = state_18521__$1;
(statearr_18537_18569[(2)] = null);

(statearr_18537_18569[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18522 === (6))){
var inst_18462 = (state_18521[(13)]);
var inst_18471 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_18462) : f.call(null,inst_18462));
var inst_18472 = cljs.core.seq(inst_18471);
var inst_18473 = inst_18472;
var inst_18474 = null;
var inst_18475 = (0);
var inst_18476 = (0);
var state_18521__$1 = (function (){var statearr_18538 = state_18521;
(statearr_18538[(8)] = inst_18473);

(statearr_18538[(9)] = inst_18474);

(statearr_18538[(11)] = inst_18476);

(statearr_18538[(12)] = inst_18475);

return statearr_18538;
})();
var statearr_18539_18570 = state_18521__$1;
(statearr_18539_18570[(2)] = null);

(statearr_18539_18570[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18522 === (17))){
var inst_18487 = (state_18521[(7)]);
var inst_18491 = cljs.core.chunk_first(inst_18487);
var inst_18492 = cljs.core.chunk_rest(inst_18487);
var inst_18493 = cljs.core.count(inst_18491);
var inst_18473 = inst_18492;
var inst_18474 = inst_18491;
var inst_18475 = inst_18493;
var inst_18476 = (0);
var state_18521__$1 = (function (){var statearr_18540 = state_18521;
(statearr_18540[(8)] = inst_18473);

(statearr_18540[(9)] = inst_18474);

(statearr_18540[(11)] = inst_18476);

(statearr_18540[(12)] = inst_18475);

return statearr_18540;
})();
var statearr_18541_18571 = state_18521__$1;
(statearr_18541_18571[(2)] = null);

(statearr_18541_18571[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18522 === (3))){
var inst_18519 = (state_18521[(2)]);
var state_18521__$1 = state_18521;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18521__$1,inst_18519);
} else {
if((state_val_18522 === (12))){
var inst_18507 = (state_18521[(2)]);
var state_18521__$1 = state_18521;
var statearr_18542_18572 = state_18521__$1;
(statearr_18542_18572[(2)] = inst_18507);

(statearr_18542_18572[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18522 === (2))){
var state_18521__$1 = state_18521;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18521__$1,(4),in$);
} else {
if((state_val_18522 === (23))){
var inst_18515 = (state_18521[(2)]);
var state_18521__$1 = state_18521;
var statearr_18543_18573 = state_18521__$1;
(statearr_18543_18573[(2)] = inst_18515);

(statearr_18543_18573[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18522 === (19))){
var inst_18502 = (state_18521[(2)]);
var state_18521__$1 = state_18521;
var statearr_18544_18574 = state_18521__$1;
(statearr_18544_18574[(2)] = inst_18502);

(statearr_18544_18574[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18522 === (11))){
var inst_18487 = (state_18521[(7)]);
var inst_18473 = (state_18521[(8)]);
var inst_18487__$1 = cljs.core.seq(inst_18473);
var state_18521__$1 = (function (){var statearr_18545 = state_18521;
(statearr_18545[(7)] = inst_18487__$1);

return statearr_18545;
})();
if(inst_18487__$1){
var statearr_18546_18575 = state_18521__$1;
(statearr_18546_18575[(1)] = (14));

} else {
var statearr_18547_18576 = state_18521__$1;
(statearr_18547_18576[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18522 === (9))){
var inst_18509 = (state_18521[(2)]);
var inst_18510 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_18521__$1 = (function (){var statearr_18548 = state_18521;
(statearr_18548[(15)] = inst_18509);

return statearr_18548;
})();
if(cljs.core.truth_(inst_18510)){
var statearr_18549_18577 = state_18521__$1;
(statearr_18549_18577[(1)] = (21));

} else {
var statearr_18550_18578 = state_18521__$1;
(statearr_18550_18578[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18522 === (5))){
var inst_18465 = cljs.core.async.close_BANG_(out);
var state_18521__$1 = state_18521;
var statearr_18551_18579 = state_18521__$1;
(statearr_18551_18579[(2)] = inst_18465);

(statearr_18551_18579[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18522 === (14))){
var inst_18487 = (state_18521[(7)]);
var inst_18489 = cljs.core.chunked_seq_QMARK_(inst_18487);
var state_18521__$1 = state_18521;
if(inst_18489){
var statearr_18552_18580 = state_18521__$1;
(statearr_18552_18580[(1)] = (17));

} else {
var statearr_18553_18581 = state_18521__$1;
(statearr_18553_18581[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18522 === (16))){
var inst_18505 = (state_18521[(2)]);
var state_18521__$1 = state_18521;
var statearr_18554_18582 = state_18521__$1;
(statearr_18554_18582[(2)] = inst_18505);

(statearr_18554_18582[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18522 === (10))){
var inst_18474 = (state_18521[(9)]);
var inst_18476 = (state_18521[(11)]);
var inst_18481 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_18474,inst_18476);
var state_18521__$1 = state_18521;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18521__$1,(13),out,inst_18481);
} else {
if((state_val_18522 === (18))){
var inst_18487 = (state_18521[(7)]);
var inst_18496 = cljs.core.first(inst_18487);
var state_18521__$1 = state_18521;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18521__$1,(20),out,inst_18496);
} else {
if((state_val_18522 === (8))){
var inst_18476 = (state_18521[(11)]);
var inst_18475 = (state_18521[(12)]);
var inst_18478 = (inst_18476 < inst_18475);
var inst_18479 = inst_18478;
var state_18521__$1 = state_18521;
if(cljs.core.truth_(inst_18479)){
var statearr_18555_18583 = state_18521__$1;
(statearr_18555_18583[(1)] = (10));

} else {
var statearr_18556_18584 = state_18521__$1;
(statearr_18556_18584[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16901__auto__))
;
return ((function (switch__16799__auto__,c__16901__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__16800__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__16800__auto____0 = (function (){
var statearr_18557 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18557[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__16800__auto__);

(statearr_18557[(1)] = (1));

return statearr_18557;
});
var cljs$core$async$mapcat_STAR__$_state_machine__16800__auto____1 = (function (state_18521){
while(true){
var ret_value__16801__auto__ = (function (){try{while(true){
var result__16802__auto__ = switch__16799__auto__(state_18521);
if(cljs.core.keyword_identical_QMARK_(result__16802__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16802__auto__;
}
break;
}
}catch (e18558){if((e18558 instanceof Object)){
var ex__16803__auto__ = e18558;
var statearr_18559_18585 = state_18521;
(statearr_18559_18585[(5)] = ex__16803__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18521);

return cljs.core.cst$kw$recur;
} else {
throw e18558;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16801__auto__,cljs.core.cst$kw$recur)){
var G__18586 = state_18521;
state_18521 = G__18586;
continue;
} else {
return ret_value__16801__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__16800__auto__ = function(state_18521){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__16800__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__16800__auto____1.call(this,state_18521);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__16800__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__16800__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__16800__auto__;
})()
;})(switch__16799__auto__,c__16901__auto__))
})();
var state__16903__auto__ = (function (){var statearr_18560 = (f__16902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16902__auto__.cljs$core$IFn$_invoke$arity$0() : f__16902__auto__.call(null));
(statearr_18560[(6)] = c__16901__auto__);

return statearr_18560;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16903__auto__);
});})(c__16901__auto__))
);

return c__16901__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__18588 = arguments.length;
switch (G__18588) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__18591 = arguments.length;
switch (G__18591) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__18594 = arguments.length;
switch (G__18594) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16901__auto___18641 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16901__auto___18641,out){
return (function (){
var f__16902__auto__ = (function (){var switch__16799__auto__ = ((function (c__16901__auto___18641,out){
return (function (state_18618){
var state_val_18619 = (state_18618[(1)]);
if((state_val_18619 === (7))){
var inst_18613 = (state_18618[(2)]);
var state_18618__$1 = state_18618;
var statearr_18620_18642 = state_18618__$1;
(statearr_18620_18642[(2)] = inst_18613);

(statearr_18620_18642[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18619 === (1))){
var inst_18595 = null;
var state_18618__$1 = (function (){var statearr_18621 = state_18618;
(statearr_18621[(7)] = inst_18595);

return statearr_18621;
})();
var statearr_18622_18643 = state_18618__$1;
(statearr_18622_18643[(2)] = null);

(statearr_18622_18643[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18619 === (4))){
var inst_18598 = (state_18618[(8)]);
var inst_18598__$1 = (state_18618[(2)]);
var inst_18599 = (inst_18598__$1 == null);
var inst_18600 = cljs.core.not(inst_18599);
var state_18618__$1 = (function (){var statearr_18623 = state_18618;
(statearr_18623[(8)] = inst_18598__$1);

return statearr_18623;
})();
if(inst_18600){
var statearr_18624_18644 = state_18618__$1;
(statearr_18624_18644[(1)] = (5));

} else {
var statearr_18625_18645 = state_18618__$1;
(statearr_18625_18645[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18619 === (6))){
var state_18618__$1 = state_18618;
var statearr_18626_18646 = state_18618__$1;
(statearr_18626_18646[(2)] = null);

(statearr_18626_18646[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18619 === (3))){
var inst_18615 = (state_18618[(2)]);
var inst_18616 = cljs.core.async.close_BANG_(out);
var state_18618__$1 = (function (){var statearr_18627 = state_18618;
(statearr_18627[(9)] = inst_18615);

return statearr_18627;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_18618__$1,inst_18616);
} else {
if((state_val_18619 === (2))){
var state_18618__$1 = state_18618;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18618__$1,(4),ch);
} else {
if((state_val_18619 === (11))){
var inst_18598 = (state_18618[(8)]);
var inst_18607 = (state_18618[(2)]);
var inst_18595 = inst_18598;
var state_18618__$1 = (function (){var statearr_18628 = state_18618;
(statearr_18628[(10)] = inst_18607);

(statearr_18628[(7)] = inst_18595);

return statearr_18628;
})();
var statearr_18629_18647 = state_18618__$1;
(statearr_18629_18647[(2)] = null);

(statearr_18629_18647[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18619 === (9))){
var inst_18598 = (state_18618[(8)]);
var state_18618__$1 = state_18618;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18618__$1,(11),out,inst_18598);
} else {
if((state_val_18619 === (5))){
var inst_18598 = (state_18618[(8)]);
var inst_18595 = (state_18618[(7)]);
var inst_18602 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_18598,inst_18595);
var state_18618__$1 = state_18618;
if(inst_18602){
var statearr_18631_18648 = state_18618__$1;
(statearr_18631_18648[(1)] = (8));

} else {
var statearr_18632_18649 = state_18618__$1;
(statearr_18632_18649[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18619 === (10))){
var inst_18610 = (state_18618[(2)]);
var state_18618__$1 = state_18618;
var statearr_18633_18650 = state_18618__$1;
(statearr_18633_18650[(2)] = inst_18610);

(statearr_18633_18650[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18619 === (8))){
var inst_18595 = (state_18618[(7)]);
var tmp18630 = inst_18595;
var inst_18595__$1 = tmp18630;
var state_18618__$1 = (function (){var statearr_18634 = state_18618;
(statearr_18634[(7)] = inst_18595__$1);

return statearr_18634;
})();
var statearr_18635_18651 = state_18618__$1;
(statearr_18635_18651[(2)] = null);

(statearr_18635_18651[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16901__auto___18641,out))
;
return ((function (switch__16799__auto__,c__16901__auto___18641,out){
return (function() {
var cljs$core$async$state_machine__16800__auto__ = null;
var cljs$core$async$state_machine__16800__auto____0 = (function (){
var statearr_18636 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18636[(0)] = cljs$core$async$state_machine__16800__auto__);

(statearr_18636[(1)] = (1));

return statearr_18636;
});
var cljs$core$async$state_machine__16800__auto____1 = (function (state_18618){
while(true){
var ret_value__16801__auto__ = (function (){try{while(true){
var result__16802__auto__ = switch__16799__auto__(state_18618);
if(cljs.core.keyword_identical_QMARK_(result__16802__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16802__auto__;
}
break;
}
}catch (e18637){if((e18637 instanceof Object)){
var ex__16803__auto__ = e18637;
var statearr_18638_18652 = state_18618;
(statearr_18638_18652[(5)] = ex__16803__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18618);

return cljs.core.cst$kw$recur;
} else {
throw e18637;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16801__auto__,cljs.core.cst$kw$recur)){
var G__18653 = state_18618;
state_18618 = G__18653;
continue;
} else {
return ret_value__16801__auto__;
}
break;
}
});
cljs$core$async$state_machine__16800__auto__ = function(state_18618){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16800__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16800__auto____1.call(this,state_18618);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16800__auto____0;
cljs$core$async$state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16800__auto____1;
return cljs$core$async$state_machine__16800__auto__;
})()
;})(switch__16799__auto__,c__16901__auto___18641,out))
})();
var state__16903__auto__ = (function (){var statearr_18639 = (f__16902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16902__auto__.cljs$core$IFn$_invoke$arity$0() : f__16902__auto__.call(null));
(statearr_18639[(6)] = c__16901__auto___18641);

return statearr_18639;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16903__auto__);
});})(c__16901__auto___18641,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__18655 = arguments.length;
switch (G__18655) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16901__auto___18721 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16901__auto___18721,out){
return (function (){
var f__16902__auto__ = (function (){var switch__16799__auto__ = ((function (c__16901__auto___18721,out){
return (function (state_18693){
var state_val_18694 = (state_18693[(1)]);
if((state_val_18694 === (7))){
var inst_18689 = (state_18693[(2)]);
var state_18693__$1 = state_18693;
var statearr_18695_18722 = state_18693__$1;
(statearr_18695_18722[(2)] = inst_18689);

(statearr_18695_18722[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18694 === (1))){
var inst_18656 = (new Array(n));
var inst_18657 = inst_18656;
var inst_18658 = (0);
var state_18693__$1 = (function (){var statearr_18696 = state_18693;
(statearr_18696[(7)] = inst_18658);

(statearr_18696[(8)] = inst_18657);

return statearr_18696;
})();
var statearr_18697_18723 = state_18693__$1;
(statearr_18697_18723[(2)] = null);

(statearr_18697_18723[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18694 === (4))){
var inst_18661 = (state_18693[(9)]);
var inst_18661__$1 = (state_18693[(2)]);
var inst_18662 = (inst_18661__$1 == null);
var inst_18663 = cljs.core.not(inst_18662);
var state_18693__$1 = (function (){var statearr_18698 = state_18693;
(statearr_18698[(9)] = inst_18661__$1);

return statearr_18698;
})();
if(inst_18663){
var statearr_18699_18724 = state_18693__$1;
(statearr_18699_18724[(1)] = (5));

} else {
var statearr_18700_18725 = state_18693__$1;
(statearr_18700_18725[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18694 === (15))){
var inst_18683 = (state_18693[(2)]);
var state_18693__$1 = state_18693;
var statearr_18701_18726 = state_18693__$1;
(statearr_18701_18726[(2)] = inst_18683);

(statearr_18701_18726[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18694 === (13))){
var state_18693__$1 = state_18693;
var statearr_18702_18727 = state_18693__$1;
(statearr_18702_18727[(2)] = null);

(statearr_18702_18727[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18694 === (6))){
var inst_18658 = (state_18693[(7)]);
var inst_18679 = (inst_18658 > (0));
var state_18693__$1 = state_18693;
if(cljs.core.truth_(inst_18679)){
var statearr_18703_18728 = state_18693__$1;
(statearr_18703_18728[(1)] = (12));

} else {
var statearr_18704_18729 = state_18693__$1;
(statearr_18704_18729[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18694 === (3))){
var inst_18691 = (state_18693[(2)]);
var state_18693__$1 = state_18693;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18693__$1,inst_18691);
} else {
if((state_val_18694 === (12))){
var inst_18657 = (state_18693[(8)]);
var inst_18681 = cljs.core.vec(inst_18657);
var state_18693__$1 = state_18693;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18693__$1,(15),out,inst_18681);
} else {
if((state_val_18694 === (2))){
var state_18693__$1 = state_18693;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18693__$1,(4),ch);
} else {
if((state_val_18694 === (11))){
var inst_18673 = (state_18693[(2)]);
var inst_18674 = (new Array(n));
var inst_18657 = inst_18674;
var inst_18658 = (0);
var state_18693__$1 = (function (){var statearr_18705 = state_18693;
(statearr_18705[(7)] = inst_18658);

(statearr_18705[(8)] = inst_18657);

(statearr_18705[(10)] = inst_18673);

return statearr_18705;
})();
var statearr_18706_18730 = state_18693__$1;
(statearr_18706_18730[(2)] = null);

(statearr_18706_18730[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18694 === (9))){
var inst_18657 = (state_18693[(8)]);
var inst_18671 = cljs.core.vec(inst_18657);
var state_18693__$1 = state_18693;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18693__$1,(11),out,inst_18671);
} else {
if((state_val_18694 === (5))){
var inst_18666 = (state_18693[(11)]);
var inst_18658 = (state_18693[(7)]);
var inst_18657 = (state_18693[(8)]);
var inst_18661 = (state_18693[(9)]);
var inst_18665 = (inst_18657[inst_18658] = inst_18661);
var inst_18666__$1 = (inst_18658 + (1));
var inst_18667 = (inst_18666__$1 < n);
var state_18693__$1 = (function (){var statearr_18707 = state_18693;
(statearr_18707[(11)] = inst_18666__$1);

(statearr_18707[(12)] = inst_18665);

return statearr_18707;
})();
if(cljs.core.truth_(inst_18667)){
var statearr_18708_18731 = state_18693__$1;
(statearr_18708_18731[(1)] = (8));

} else {
var statearr_18709_18732 = state_18693__$1;
(statearr_18709_18732[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18694 === (14))){
var inst_18686 = (state_18693[(2)]);
var inst_18687 = cljs.core.async.close_BANG_(out);
var state_18693__$1 = (function (){var statearr_18711 = state_18693;
(statearr_18711[(13)] = inst_18686);

return statearr_18711;
})();
var statearr_18712_18733 = state_18693__$1;
(statearr_18712_18733[(2)] = inst_18687);

(statearr_18712_18733[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18694 === (10))){
var inst_18677 = (state_18693[(2)]);
var state_18693__$1 = state_18693;
var statearr_18713_18734 = state_18693__$1;
(statearr_18713_18734[(2)] = inst_18677);

(statearr_18713_18734[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18694 === (8))){
var inst_18666 = (state_18693[(11)]);
var inst_18657 = (state_18693[(8)]);
var tmp18710 = inst_18657;
var inst_18657__$1 = tmp18710;
var inst_18658 = inst_18666;
var state_18693__$1 = (function (){var statearr_18714 = state_18693;
(statearr_18714[(7)] = inst_18658);

(statearr_18714[(8)] = inst_18657__$1);

return statearr_18714;
})();
var statearr_18715_18735 = state_18693__$1;
(statearr_18715_18735[(2)] = null);

(statearr_18715_18735[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16901__auto___18721,out))
;
return ((function (switch__16799__auto__,c__16901__auto___18721,out){
return (function() {
var cljs$core$async$state_machine__16800__auto__ = null;
var cljs$core$async$state_machine__16800__auto____0 = (function (){
var statearr_18716 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18716[(0)] = cljs$core$async$state_machine__16800__auto__);

(statearr_18716[(1)] = (1));

return statearr_18716;
});
var cljs$core$async$state_machine__16800__auto____1 = (function (state_18693){
while(true){
var ret_value__16801__auto__ = (function (){try{while(true){
var result__16802__auto__ = switch__16799__auto__(state_18693);
if(cljs.core.keyword_identical_QMARK_(result__16802__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16802__auto__;
}
break;
}
}catch (e18717){if((e18717 instanceof Object)){
var ex__16803__auto__ = e18717;
var statearr_18718_18736 = state_18693;
(statearr_18718_18736[(5)] = ex__16803__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18693);

return cljs.core.cst$kw$recur;
} else {
throw e18717;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16801__auto__,cljs.core.cst$kw$recur)){
var G__18737 = state_18693;
state_18693 = G__18737;
continue;
} else {
return ret_value__16801__auto__;
}
break;
}
});
cljs$core$async$state_machine__16800__auto__ = function(state_18693){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16800__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16800__auto____1.call(this,state_18693);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16800__auto____0;
cljs$core$async$state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16800__auto____1;
return cljs$core$async$state_machine__16800__auto__;
})()
;})(switch__16799__auto__,c__16901__auto___18721,out))
})();
var state__16903__auto__ = (function (){var statearr_18719 = (f__16902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16902__auto__.cljs$core$IFn$_invoke$arity$0() : f__16902__auto__.call(null));
(statearr_18719[(6)] = c__16901__auto___18721);

return statearr_18719;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16903__auto__);
});})(c__16901__auto___18721,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__18739 = arguments.length;
switch (G__18739) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16901__auto___18809 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16901__auto___18809,out){
return (function (){
var f__16902__auto__ = (function (){var switch__16799__auto__ = ((function (c__16901__auto___18809,out){
return (function (state_18781){
var state_val_18782 = (state_18781[(1)]);
if((state_val_18782 === (7))){
var inst_18777 = (state_18781[(2)]);
var state_18781__$1 = state_18781;
var statearr_18783_18810 = state_18781__$1;
(statearr_18783_18810[(2)] = inst_18777);

(statearr_18783_18810[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (1))){
var inst_18740 = [];
var inst_18741 = inst_18740;
var inst_18742 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_18781__$1 = (function (){var statearr_18784 = state_18781;
(statearr_18784[(7)] = inst_18742);

(statearr_18784[(8)] = inst_18741);

return statearr_18784;
})();
var statearr_18785_18811 = state_18781__$1;
(statearr_18785_18811[(2)] = null);

(statearr_18785_18811[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (4))){
var inst_18745 = (state_18781[(9)]);
var inst_18745__$1 = (state_18781[(2)]);
var inst_18746 = (inst_18745__$1 == null);
var inst_18747 = cljs.core.not(inst_18746);
var state_18781__$1 = (function (){var statearr_18786 = state_18781;
(statearr_18786[(9)] = inst_18745__$1);

return statearr_18786;
})();
if(inst_18747){
var statearr_18787_18812 = state_18781__$1;
(statearr_18787_18812[(1)] = (5));

} else {
var statearr_18788_18813 = state_18781__$1;
(statearr_18788_18813[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (15))){
var inst_18771 = (state_18781[(2)]);
var state_18781__$1 = state_18781;
var statearr_18789_18814 = state_18781__$1;
(statearr_18789_18814[(2)] = inst_18771);

(statearr_18789_18814[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (13))){
var state_18781__$1 = state_18781;
var statearr_18790_18815 = state_18781__$1;
(statearr_18790_18815[(2)] = null);

(statearr_18790_18815[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (6))){
var inst_18741 = (state_18781[(8)]);
var inst_18766 = inst_18741.length;
var inst_18767 = (inst_18766 > (0));
var state_18781__$1 = state_18781;
if(cljs.core.truth_(inst_18767)){
var statearr_18791_18816 = state_18781__$1;
(statearr_18791_18816[(1)] = (12));

} else {
var statearr_18792_18817 = state_18781__$1;
(statearr_18792_18817[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (3))){
var inst_18779 = (state_18781[(2)]);
var state_18781__$1 = state_18781;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18781__$1,inst_18779);
} else {
if((state_val_18782 === (12))){
var inst_18741 = (state_18781[(8)]);
var inst_18769 = cljs.core.vec(inst_18741);
var state_18781__$1 = state_18781;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18781__$1,(15),out,inst_18769);
} else {
if((state_val_18782 === (2))){
var state_18781__$1 = state_18781;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18781__$1,(4),ch);
} else {
if((state_val_18782 === (11))){
var inst_18745 = (state_18781[(9)]);
var inst_18749 = (state_18781[(10)]);
var inst_18759 = (state_18781[(2)]);
var inst_18760 = [];
var inst_18761 = inst_18760.push(inst_18745);
var inst_18741 = inst_18760;
var inst_18742 = inst_18749;
var state_18781__$1 = (function (){var statearr_18793 = state_18781;
(statearr_18793[(7)] = inst_18742);

(statearr_18793[(11)] = inst_18761);

(statearr_18793[(12)] = inst_18759);

(statearr_18793[(8)] = inst_18741);

return statearr_18793;
})();
var statearr_18794_18818 = state_18781__$1;
(statearr_18794_18818[(2)] = null);

(statearr_18794_18818[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (9))){
var inst_18741 = (state_18781[(8)]);
var inst_18757 = cljs.core.vec(inst_18741);
var state_18781__$1 = state_18781;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18781__$1,(11),out,inst_18757);
} else {
if((state_val_18782 === (5))){
var inst_18742 = (state_18781[(7)]);
var inst_18745 = (state_18781[(9)]);
var inst_18749 = (state_18781[(10)]);
var inst_18749__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_18745) : f.call(null,inst_18745));
var inst_18750 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_18749__$1,inst_18742);
var inst_18751 = cljs.core.keyword_identical_QMARK_(inst_18742,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_18752 = (inst_18750) || (inst_18751);
var state_18781__$1 = (function (){var statearr_18795 = state_18781;
(statearr_18795[(10)] = inst_18749__$1);

return statearr_18795;
})();
if(cljs.core.truth_(inst_18752)){
var statearr_18796_18819 = state_18781__$1;
(statearr_18796_18819[(1)] = (8));

} else {
var statearr_18797_18820 = state_18781__$1;
(statearr_18797_18820[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (14))){
var inst_18774 = (state_18781[(2)]);
var inst_18775 = cljs.core.async.close_BANG_(out);
var state_18781__$1 = (function (){var statearr_18799 = state_18781;
(statearr_18799[(13)] = inst_18774);

return statearr_18799;
})();
var statearr_18800_18821 = state_18781__$1;
(statearr_18800_18821[(2)] = inst_18775);

(statearr_18800_18821[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (10))){
var inst_18764 = (state_18781[(2)]);
var state_18781__$1 = state_18781;
var statearr_18801_18822 = state_18781__$1;
(statearr_18801_18822[(2)] = inst_18764);

(statearr_18801_18822[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (8))){
var inst_18745 = (state_18781[(9)]);
var inst_18749 = (state_18781[(10)]);
var inst_18741 = (state_18781[(8)]);
var inst_18754 = inst_18741.push(inst_18745);
var tmp18798 = inst_18741;
var inst_18741__$1 = tmp18798;
var inst_18742 = inst_18749;
var state_18781__$1 = (function (){var statearr_18802 = state_18781;
(statearr_18802[(7)] = inst_18742);

(statearr_18802[(8)] = inst_18741__$1);

(statearr_18802[(14)] = inst_18754);

return statearr_18802;
})();
var statearr_18803_18823 = state_18781__$1;
(statearr_18803_18823[(2)] = null);

(statearr_18803_18823[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16901__auto___18809,out))
;
return ((function (switch__16799__auto__,c__16901__auto___18809,out){
return (function() {
var cljs$core$async$state_machine__16800__auto__ = null;
var cljs$core$async$state_machine__16800__auto____0 = (function (){
var statearr_18804 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18804[(0)] = cljs$core$async$state_machine__16800__auto__);

(statearr_18804[(1)] = (1));

return statearr_18804;
});
var cljs$core$async$state_machine__16800__auto____1 = (function (state_18781){
while(true){
var ret_value__16801__auto__ = (function (){try{while(true){
var result__16802__auto__ = switch__16799__auto__(state_18781);
if(cljs.core.keyword_identical_QMARK_(result__16802__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16802__auto__;
}
break;
}
}catch (e18805){if((e18805 instanceof Object)){
var ex__16803__auto__ = e18805;
var statearr_18806_18824 = state_18781;
(statearr_18806_18824[(5)] = ex__16803__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18781);

return cljs.core.cst$kw$recur;
} else {
throw e18805;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16801__auto__,cljs.core.cst$kw$recur)){
var G__18825 = state_18781;
state_18781 = G__18825;
continue;
} else {
return ret_value__16801__auto__;
}
break;
}
});
cljs$core$async$state_machine__16800__auto__ = function(state_18781){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16800__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16800__auto____1.call(this,state_18781);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16800__auto____0;
cljs$core$async$state_machine__16800__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16800__auto____1;
return cljs$core$async$state_machine__16800__auto__;
})()
;})(switch__16799__auto__,c__16901__auto___18809,out))
})();
var state__16903__auto__ = (function (){var statearr_18807 = (f__16902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16902__auto__.cljs$core$IFn$_invoke$arity$0() : f__16902__auto__.call(null));
(statearr_18807[(6)] = c__16901__auto___18809);

return statearr_18807;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16903__auto__);
});})(c__16901__auto___18809,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

