// Compiled by ClojureScript 1.9.946 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__16953 = arguments.length;
switch (G__16953) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async16954 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16954 = (function (f,blockable,meta16955){
this.f = f;
this.blockable = blockable;
this.meta16955 = meta16955;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async16954.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16956,meta16955__$1){
var self__ = this;
var _16956__$1 = this;
return (new cljs.core.async.t_cljs$core$async16954(self__.f,self__.blockable,meta16955__$1));
});

cljs.core.async.t_cljs$core$async16954.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16956){
var self__ = this;
var _16956__$1 = this;
return self__.meta16955;
});

cljs.core.async.t_cljs$core$async16954.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16954.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async16954.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async16954.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async16954.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta16955], null);
});

cljs.core.async.t_cljs$core$async16954.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16954.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16954";

cljs.core.async.t_cljs$core$async16954.cljs$lang$ctorPrWriter = (function (this__9479__auto__,writer__9480__auto__,opt__9481__auto__){
return cljs.core._write(writer__9480__auto__,"cljs.core.async/t_cljs$core$async16954");
});

cljs.core.async.__GT_t_cljs$core$async16954 = (function cljs$core$async$__GT_t_cljs$core$async16954(f__$1,blockable__$1,meta16955){
return (new cljs.core.async.t_cljs$core$async16954(f__$1,blockable__$1,meta16955));
});

}

return (new cljs.core.async.t_cljs$core$async16954(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__16960 = arguments.length;
switch (G__16960) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__16963 = arguments.length;
switch (G__16963) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__16966 = arguments.length;
switch (G__16966) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_16968 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_16968) : fn1.call(null,val_16968));
} else {
cljs.core.async.impl.dispatch.run(((function (val_16968,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_16968) : fn1.call(null,val_16968));
});})(val_16968,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__16970 = arguments.length;
switch (G__16970) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5455__auto__)){
var ret = temp__5455__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5455__auto__)){
var retb = temp__5455__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__5455__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__5455__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__9853__auto___16972 = n;
var x_16973 = (0);
while(true){
if((x_16973 < n__9853__auto___16972)){
(a[x_16973] = (0));

var G__16974 = (x_16973 + (1));
x_16973 = G__16974;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__16975 = (i + (1));
i = G__16975;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if(typeof cljs.core.async.t_cljs$core$async16976 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16976 = (function (flag,meta16977){
this.flag = flag;
this.meta16977 = meta16977;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async16976.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_16978,meta16977__$1){
var self__ = this;
var _16978__$1 = this;
return (new cljs.core.async.t_cljs$core$async16976(self__.flag,meta16977__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async16976.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_16978){
var self__ = this;
var _16978__$1 = this;
return self__.meta16977;
});})(flag))
;

cljs.core.async.t_cljs$core$async16976.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16976.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async16976.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async16976.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async16976.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta16977], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async16976.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16976.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16976";

cljs.core.async.t_cljs$core$async16976.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__9479__auto__,writer__9480__auto__,opt__9481__auto__){
return cljs.core._write(writer__9480__auto__,"cljs.core.async/t_cljs$core$async16976");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async16976 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async16976(flag__$1,meta16977){
return (new cljs.core.async.t_cljs$core$async16976(flag__$1,meta16977));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async16976(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async16979 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16979 = (function (flag,cb,meta16980){
this.flag = flag;
this.cb = cb;
this.meta16980 = meta16980;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async16979.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16981,meta16980__$1){
var self__ = this;
var _16981__$1 = this;
return (new cljs.core.async.t_cljs$core$async16979(self__.flag,self__.cb,meta16980__$1));
});

cljs.core.async.t_cljs$core$async16979.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16981){
var self__ = this;
var _16981__$1 = this;
return self__.meta16980;
});

cljs.core.async.t_cljs$core$async16979.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16979.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async16979.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async16979.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async16979.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta16980], null);
});

cljs.core.async.t_cljs$core$async16979.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16979.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16979";

cljs.core.async.t_cljs$core$async16979.cljs$lang$ctorPrWriter = (function (this__9479__auto__,writer__9480__auto__,opt__9481__auto__){
return cljs.core._write(writer__9480__auto__,"cljs.core.async/t_cljs$core$async16979");
});

cljs.core.async.__GT_t_cljs$core$async16979 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async16979(flag__$1,cb__$1,meta16980){
return (new cljs.core.async.t_cljs$core$async16979(flag__$1,cb__$1,meta16980));
});

}

return (new cljs.core.async.t_cljs$core$async16979(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__16982_SHARP_){
var G__16984 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16982_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__16984) : fret.call(null,G__16984));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__16983_SHARP_){
var G__16985 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16983_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__16985) : fret.call(null,G__16985));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__8808__auto__ = wport;
if(cljs.core.truth_(or__8808__auto__)){
return or__8808__auto__;
} else {
return port;
}
})()], null));
} else {
var G__16986 = (i + (1));
i = G__16986;
continue;
}
} else {
return null;
}
break;
}
})();
var or__8808__auto__ = ret;
if(cljs.core.truth_(or__8808__auto__)){
return or__8808__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__5457__auto__ = (function (){var and__8796__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__8796__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__8796__auto__;
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var got = temp__5457__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__10094__auto__ = [];
var len__10087__auto___16992 = arguments.length;
var i__10088__auto___16993 = (0);
while(true){
if((i__10088__auto___16993 < len__10087__auto___16992)){
args__10094__auto__.push((arguments[i__10088__auto___16993]));

var G__16994 = (i__10088__auto___16993 + (1));
i__10088__auto___16993 = G__16994;
continue;
} else {
}
break;
}

var argseq__10095__auto__ = ((((1) < args__10094__auto__.length))?(new cljs.core.IndexedSeq(args__10094__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10095__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__16989){
var map__16990 = p__16989;
var map__16990__$1 = ((((!((map__16990 == null)))?((((map__16990.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16990.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16990):map__16990);
var opts = map__16990__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq16987){
var G__16988 = cljs.core.first(seq16987);
var seq16987__$1 = cljs.core.next(seq16987);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__16988,seq16987__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__16996 = arguments.length;
switch (G__16996) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__16893__auto___17042 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16893__auto___17042){
return (function (){
var f__16894__auto__ = (function (){var switch__16791__auto__ = ((function (c__16893__auto___17042){
return (function (state_17020){
var state_val_17021 = (state_17020[(1)]);
if((state_val_17021 === (7))){
var inst_17016 = (state_17020[(2)]);
var state_17020__$1 = state_17020;
var statearr_17022_17043 = state_17020__$1;
(statearr_17022_17043[(2)] = inst_17016);

(statearr_17022_17043[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17021 === (1))){
var state_17020__$1 = state_17020;
var statearr_17023_17044 = state_17020__$1;
(statearr_17023_17044[(2)] = null);

(statearr_17023_17044[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17021 === (4))){
var inst_16999 = (state_17020[(7)]);
var inst_16999__$1 = (state_17020[(2)]);
var inst_17000 = (inst_16999__$1 == null);
var state_17020__$1 = (function (){var statearr_17024 = state_17020;
(statearr_17024[(7)] = inst_16999__$1);

return statearr_17024;
})();
if(cljs.core.truth_(inst_17000)){
var statearr_17025_17045 = state_17020__$1;
(statearr_17025_17045[(1)] = (5));

} else {
var statearr_17026_17046 = state_17020__$1;
(statearr_17026_17046[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17021 === (13))){
var state_17020__$1 = state_17020;
var statearr_17027_17047 = state_17020__$1;
(statearr_17027_17047[(2)] = null);

(statearr_17027_17047[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17021 === (6))){
var inst_16999 = (state_17020[(7)]);
var state_17020__$1 = state_17020;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17020__$1,(11),to,inst_16999);
} else {
if((state_val_17021 === (3))){
var inst_17018 = (state_17020[(2)]);
var state_17020__$1 = state_17020;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17020__$1,inst_17018);
} else {
if((state_val_17021 === (12))){
var state_17020__$1 = state_17020;
var statearr_17028_17048 = state_17020__$1;
(statearr_17028_17048[(2)] = null);

(statearr_17028_17048[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17021 === (2))){
var state_17020__$1 = state_17020;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17020__$1,(4),from);
} else {
if((state_val_17021 === (11))){
var inst_17009 = (state_17020[(2)]);
var state_17020__$1 = state_17020;
if(cljs.core.truth_(inst_17009)){
var statearr_17029_17049 = state_17020__$1;
(statearr_17029_17049[(1)] = (12));

} else {
var statearr_17030_17050 = state_17020__$1;
(statearr_17030_17050[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17021 === (9))){
var state_17020__$1 = state_17020;
var statearr_17031_17051 = state_17020__$1;
(statearr_17031_17051[(2)] = null);

(statearr_17031_17051[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17021 === (5))){
var state_17020__$1 = state_17020;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17032_17052 = state_17020__$1;
(statearr_17032_17052[(1)] = (8));

} else {
var statearr_17033_17053 = state_17020__$1;
(statearr_17033_17053[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17021 === (14))){
var inst_17014 = (state_17020[(2)]);
var state_17020__$1 = state_17020;
var statearr_17034_17054 = state_17020__$1;
(statearr_17034_17054[(2)] = inst_17014);

(statearr_17034_17054[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17021 === (10))){
var inst_17006 = (state_17020[(2)]);
var state_17020__$1 = state_17020;
var statearr_17035_17055 = state_17020__$1;
(statearr_17035_17055[(2)] = inst_17006);

(statearr_17035_17055[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17021 === (8))){
var inst_17003 = cljs.core.async.close_BANG_(to);
var state_17020__$1 = state_17020;
var statearr_17036_17056 = state_17020__$1;
(statearr_17036_17056[(2)] = inst_17003);

(statearr_17036_17056[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16893__auto___17042))
;
return ((function (switch__16791__auto__,c__16893__auto___17042){
return (function() {
var cljs$core$async$state_machine__16792__auto__ = null;
var cljs$core$async$state_machine__16792__auto____0 = (function (){
var statearr_17037 = [null,null,null,null,null,null,null,null];
(statearr_17037[(0)] = cljs$core$async$state_machine__16792__auto__);

(statearr_17037[(1)] = (1));

return statearr_17037;
});
var cljs$core$async$state_machine__16792__auto____1 = (function (state_17020){
while(true){
var ret_value__16793__auto__ = (function (){try{while(true){
var result__16794__auto__ = switch__16791__auto__(state_17020);
if(cljs.core.keyword_identical_QMARK_(result__16794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16794__auto__;
}
break;
}
}catch (e17038){if((e17038 instanceof Object)){
var ex__16795__auto__ = e17038;
var statearr_17039_17057 = state_17020;
(statearr_17039_17057[(5)] = ex__16795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17020);

return cljs.core.cst$kw$recur;
} else {
throw e17038;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16793__auto__,cljs.core.cst$kw$recur)){
var G__17058 = state_17020;
state_17020 = G__17058;
continue;
} else {
return ret_value__16793__auto__;
}
break;
}
});
cljs$core$async$state_machine__16792__auto__ = function(state_17020){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16792__auto____1.call(this,state_17020);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16792__auto____0;
cljs$core$async$state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16792__auto____1;
return cljs$core$async$state_machine__16792__auto__;
})()
;})(switch__16791__auto__,c__16893__auto___17042))
})();
var state__16895__auto__ = (function (){var statearr_17040 = (f__16894__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16894__auto__.cljs$core$IFn$_invoke$arity$0() : f__16894__auto__.call(null));
(statearr_17040[(6)] = c__16893__auto___17042);

return statearr_17040;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16895__auto__);
});})(c__16893__auto___17042))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__17059){
var vec__17060 = p__17059;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17060,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17060,(1),null);
var job = vec__17060;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__16893__auto___17231 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16893__auto___17231,res,vec__17060,v,p,job,jobs,results){
return (function (){
var f__16894__auto__ = (function (){var switch__16791__auto__ = ((function (c__16893__auto___17231,res,vec__17060,v,p,job,jobs,results){
return (function (state_17067){
var state_val_17068 = (state_17067[(1)]);
if((state_val_17068 === (1))){
var state_17067__$1 = state_17067;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17067__$1,(2),res,v);
} else {
if((state_val_17068 === (2))){
var inst_17064 = (state_17067[(2)]);
var inst_17065 = cljs.core.async.close_BANG_(res);
var state_17067__$1 = (function (){var statearr_17069 = state_17067;
(statearr_17069[(7)] = inst_17064);

return statearr_17069;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_17067__$1,inst_17065);
} else {
return null;
}
}
});})(c__16893__auto___17231,res,vec__17060,v,p,job,jobs,results))
;
return ((function (switch__16791__auto__,c__16893__auto___17231,res,vec__17060,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16792__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16792__auto____0 = (function (){
var statearr_17070 = [null,null,null,null,null,null,null,null];
(statearr_17070[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16792__auto__);

(statearr_17070[(1)] = (1));

return statearr_17070;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16792__auto____1 = (function (state_17067){
while(true){
var ret_value__16793__auto__ = (function (){try{while(true){
var result__16794__auto__ = switch__16791__auto__(state_17067);
if(cljs.core.keyword_identical_QMARK_(result__16794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16794__auto__;
}
break;
}
}catch (e17071){if((e17071 instanceof Object)){
var ex__16795__auto__ = e17071;
var statearr_17072_17232 = state_17067;
(statearr_17072_17232[(5)] = ex__16795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17067);

return cljs.core.cst$kw$recur;
} else {
throw e17071;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16793__auto__,cljs.core.cst$kw$recur)){
var G__17233 = state_17067;
state_17067 = G__17233;
continue;
} else {
return ret_value__16793__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16792__auto__ = function(state_17067){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16792__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16792__auto____1.call(this,state_17067);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16792__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16792__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16792__auto__;
})()
;})(switch__16791__auto__,c__16893__auto___17231,res,vec__17060,v,p,job,jobs,results))
})();
var state__16895__auto__ = (function (){var statearr_17073 = (f__16894__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16894__auto__.cljs$core$IFn$_invoke$arity$0() : f__16894__auto__.call(null));
(statearr_17073[(6)] = c__16893__auto___17231);

return statearr_17073;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16895__auto__);
});})(c__16893__auto___17231,res,vec__17060,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__17074){
var vec__17075 = p__17074;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17075,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17075,(1),null);
var job = vec__17075;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__9853__auto___17234 = n;
var __17235 = (0);
while(true){
if((__17235 < n__9853__auto___17234)){
var G__17078_17236 = type;
var G__17078_17237__$1 = (((G__17078_17236 instanceof cljs.core.Keyword))?G__17078_17236.fqn:null);
switch (G__17078_17237__$1) {
case "compute":
var c__16893__auto___17239 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__17235,c__16893__auto___17239,G__17078_17236,G__17078_17237__$1,n__9853__auto___17234,jobs,results,process,async){
return (function (){
var f__16894__auto__ = (function (){var switch__16791__auto__ = ((function (__17235,c__16893__auto___17239,G__17078_17236,G__17078_17237__$1,n__9853__auto___17234,jobs,results,process,async){
return (function (state_17091){
var state_val_17092 = (state_17091[(1)]);
if((state_val_17092 === (1))){
var state_17091__$1 = state_17091;
var statearr_17093_17240 = state_17091__$1;
(statearr_17093_17240[(2)] = null);

(statearr_17093_17240[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17092 === (2))){
var state_17091__$1 = state_17091;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17091__$1,(4),jobs);
} else {
if((state_val_17092 === (3))){
var inst_17089 = (state_17091[(2)]);
var state_17091__$1 = state_17091;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17091__$1,inst_17089);
} else {
if((state_val_17092 === (4))){
var inst_17081 = (state_17091[(2)]);
var inst_17082 = process(inst_17081);
var state_17091__$1 = state_17091;
if(cljs.core.truth_(inst_17082)){
var statearr_17094_17241 = state_17091__$1;
(statearr_17094_17241[(1)] = (5));

} else {
var statearr_17095_17242 = state_17091__$1;
(statearr_17095_17242[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17092 === (5))){
var state_17091__$1 = state_17091;
var statearr_17096_17243 = state_17091__$1;
(statearr_17096_17243[(2)] = null);

(statearr_17096_17243[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17092 === (6))){
var state_17091__$1 = state_17091;
var statearr_17097_17244 = state_17091__$1;
(statearr_17097_17244[(2)] = null);

(statearr_17097_17244[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17092 === (7))){
var inst_17087 = (state_17091[(2)]);
var state_17091__$1 = state_17091;
var statearr_17098_17245 = state_17091__$1;
(statearr_17098_17245[(2)] = inst_17087);

(statearr_17098_17245[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__17235,c__16893__auto___17239,G__17078_17236,G__17078_17237__$1,n__9853__auto___17234,jobs,results,process,async))
;
return ((function (__17235,switch__16791__auto__,c__16893__auto___17239,G__17078_17236,G__17078_17237__$1,n__9853__auto___17234,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16792__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16792__auto____0 = (function (){
var statearr_17099 = [null,null,null,null,null,null,null];
(statearr_17099[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16792__auto__);

(statearr_17099[(1)] = (1));

return statearr_17099;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16792__auto____1 = (function (state_17091){
while(true){
var ret_value__16793__auto__ = (function (){try{while(true){
var result__16794__auto__ = switch__16791__auto__(state_17091);
if(cljs.core.keyword_identical_QMARK_(result__16794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16794__auto__;
}
break;
}
}catch (e17100){if((e17100 instanceof Object)){
var ex__16795__auto__ = e17100;
var statearr_17101_17246 = state_17091;
(statearr_17101_17246[(5)] = ex__16795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17091);

return cljs.core.cst$kw$recur;
} else {
throw e17100;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16793__auto__,cljs.core.cst$kw$recur)){
var G__17247 = state_17091;
state_17091 = G__17247;
continue;
} else {
return ret_value__16793__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16792__auto__ = function(state_17091){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16792__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16792__auto____1.call(this,state_17091);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16792__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16792__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16792__auto__;
})()
;})(__17235,switch__16791__auto__,c__16893__auto___17239,G__17078_17236,G__17078_17237__$1,n__9853__auto___17234,jobs,results,process,async))
})();
var state__16895__auto__ = (function (){var statearr_17102 = (f__16894__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16894__auto__.cljs$core$IFn$_invoke$arity$0() : f__16894__auto__.call(null));
(statearr_17102[(6)] = c__16893__auto___17239);

return statearr_17102;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16895__auto__);
});})(__17235,c__16893__auto___17239,G__17078_17236,G__17078_17237__$1,n__9853__auto___17234,jobs,results,process,async))
);


break;
case "async":
var c__16893__auto___17248 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__17235,c__16893__auto___17248,G__17078_17236,G__17078_17237__$1,n__9853__auto___17234,jobs,results,process,async){
return (function (){
var f__16894__auto__ = (function (){var switch__16791__auto__ = ((function (__17235,c__16893__auto___17248,G__17078_17236,G__17078_17237__$1,n__9853__auto___17234,jobs,results,process,async){
return (function (state_17115){
var state_val_17116 = (state_17115[(1)]);
if((state_val_17116 === (1))){
var state_17115__$1 = state_17115;
var statearr_17117_17249 = state_17115__$1;
(statearr_17117_17249[(2)] = null);

(statearr_17117_17249[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17116 === (2))){
var state_17115__$1 = state_17115;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17115__$1,(4),jobs);
} else {
if((state_val_17116 === (3))){
var inst_17113 = (state_17115[(2)]);
var state_17115__$1 = state_17115;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17115__$1,inst_17113);
} else {
if((state_val_17116 === (4))){
var inst_17105 = (state_17115[(2)]);
var inst_17106 = async(inst_17105);
var state_17115__$1 = state_17115;
if(cljs.core.truth_(inst_17106)){
var statearr_17118_17250 = state_17115__$1;
(statearr_17118_17250[(1)] = (5));

} else {
var statearr_17119_17251 = state_17115__$1;
(statearr_17119_17251[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17116 === (5))){
var state_17115__$1 = state_17115;
var statearr_17120_17252 = state_17115__$1;
(statearr_17120_17252[(2)] = null);

(statearr_17120_17252[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17116 === (6))){
var state_17115__$1 = state_17115;
var statearr_17121_17253 = state_17115__$1;
(statearr_17121_17253[(2)] = null);

(statearr_17121_17253[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17116 === (7))){
var inst_17111 = (state_17115[(2)]);
var state_17115__$1 = state_17115;
var statearr_17122_17254 = state_17115__$1;
(statearr_17122_17254[(2)] = inst_17111);

(statearr_17122_17254[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__17235,c__16893__auto___17248,G__17078_17236,G__17078_17237__$1,n__9853__auto___17234,jobs,results,process,async))
;
return ((function (__17235,switch__16791__auto__,c__16893__auto___17248,G__17078_17236,G__17078_17237__$1,n__9853__auto___17234,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16792__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16792__auto____0 = (function (){
var statearr_17123 = [null,null,null,null,null,null,null];
(statearr_17123[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16792__auto__);

(statearr_17123[(1)] = (1));

return statearr_17123;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16792__auto____1 = (function (state_17115){
while(true){
var ret_value__16793__auto__ = (function (){try{while(true){
var result__16794__auto__ = switch__16791__auto__(state_17115);
if(cljs.core.keyword_identical_QMARK_(result__16794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16794__auto__;
}
break;
}
}catch (e17124){if((e17124 instanceof Object)){
var ex__16795__auto__ = e17124;
var statearr_17125_17255 = state_17115;
(statearr_17125_17255[(5)] = ex__16795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17115);

return cljs.core.cst$kw$recur;
} else {
throw e17124;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16793__auto__,cljs.core.cst$kw$recur)){
var G__17256 = state_17115;
state_17115 = G__17256;
continue;
} else {
return ret_value__16793__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16792__auto__ = function(state_17115){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16792__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16792__auto____1.call(this,state_17115);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16792__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16792__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16792__auto__;
})()
;})(__17235,switch__16791__auto__,c__16893__auto___17248,G__17078_17236,G__17078_17237__$1,n__9853__auto___17234,jobs,results,process,async))
})();
var state__16895__auto__ = (function (){var statearr_17126 = (f__16894__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16894__auto__.cljs$core$IFn$_invoke$arity$0() : f__16894__auto__.call(null));
(statearr_17126[(6)] = c__16893__auto___17248);

return statearr_17126;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16895__auto__);
});})(__17235,c__16893__auto___17248,G__17078_17236,G__17078_17237__$1,n__9853__auto___17234,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__17078_17237__$1)].join('')));

}

var G__17257 = (__17235 + (1));
__17235 = G__17257;
continue;
} else {
}
break;
}

var c__16893__auto___17258 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16893__auto___17258,jobs,results,process,async){
return (function (){
var f__16894__auto__ = (function (){var switch__16791__auto__ = ((function (c__16893__auto___17258,jobs,results,process,async){
return (function (state_17148){
var state_val_17149 = (state_17148[(1)]);
if((state_val_17149 === (1))){
var state_17148__$1 = state_17148;
var statearr_17150_17259 = state_17148__$1;
(statearr_17150_17259[(2)] = null);

(statearr_17150_17259[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17149 === (2))){
var state_17148__$1 = state_17148;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17148__$1,(4),from);
} else {
if((state_val_17149 === (3))){
var inst_17146 = (state_17148[(2)]);
var state_17148__$1 = state_17148;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17148__$1,inst_17146);
} else {
if((state_val_17149 === (4))){
var inst_17129 = (state_17148[(7)]);
var inst_17129__$1 = (state_17148[(2)]);
var inst_17130 = (inst_17129__$1 == null);
var state_17148__$1 = (function (){var statearr_17151 = state_17148;
(statearr_17151[(7)] = inst_17129__$1);

return statearr_17151;
})();
if(cljs.core.truth_(inst_17130)){
var statearr_17152_17260 = state_17148__$1;
(statearr_17152_17260[(1)] = (5));

} else {
var statearr_17153_17261 = state_17148__$1;
(statearr_17153_17261[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17149 === (5))){
var inst_17132 = cljs.core.async.close_BANG_(jobs);
var state_17148__$1 = state_17148;
var statearr_17154_17262 = state_17148__$1;
(statearr_17154_17262[(2)] = inst_17132);

(statearr_17154_17262[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17149 === (6))){
var inst_17129 = (state_17148[(7)]);
var inst_17134 = (state_17148[(8)]);
var inst_17134__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_17135 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17136 = [inst_17129,inst_17134__$1];
var inst_17137 = (new cljs.core.PersistentVector(null,2,(5),inst_17135,inst_17136,null));
var state_17148__$1 = (function (){var statearr_17155 = state_17148;
(statearr_17155[(8)] = inst_17134__$1);

return statearr_17155;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17148__$1,(8),jobs,inst_17137);
} else {
if((state_val_17149 === (7))){
var inst_17144 = (state_17148[(2)]);
var state_17148__$1 = state_17148;
var statearr_17156_17263 = state_17148__$1;
(statearr_17156_17263[(2)] = inst_17144);

(statearr_17156_17263[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17149 === (8))){
var inst_17134 = (state_17148[(8)]);
var inst_17139 = (state_17148[(2)]);
var state_17148__$1 = (function (){var statearr_17157 = state_17148;
(statearr_17157[(9)] = inst_17139);

return statearr_17157;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17148__$1,(9),results,inst_17134);
} else {
if((state_val_17149 === (9))){
var inst_17141 = (state_17148[(2)]);
var state_17148__$1 = (function (){var statearr_17158 = state_17148;
(statearr_17158[(10)] = inst_17141);

return statearr_17158;
})();
var statearr_17159_17264 = state_17148__$1;
(statearr_17159_17264[(2)] = null);

(statearr_17159_17264[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__16893__auto___17258,jobs,results,process,async))
;
return ((function (switch__16791__auto__,c__16893__auto___17258,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16792__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16792__auto____0 = (function (){
var statearr_17160 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17160[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16792__auto__);

(statearr_17160[(1)] = (1));

return statearr_17160;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16792__auto____1 = (function (state_17148){
while(true){
var ret_value__16793__auto__ = (function (){try{while(true){
var result__16794__auto__ = switch__16791__auto__(state_17148);
if(cljs.core.keyword_identical_QMARK_(result__16794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16794__auto__;
}
break;
}
}catch (e17161){if((e17161 instanceof Object)){
var ex__16795__auto__ = e17161;
var statearr_17162_17265 = state_17148;
(statearr_17162_17265[(5)] = ex__16795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17148);

return cljs.core.cst$kw$recur;
} else {
throw e17161;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16793__auto__,cljs.core.cst$kw$recur)){
var G__17266 = state_17148;
state_17148 = G__17266;
continue;
} else {
return ret_value__16793__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16792__auto__ = function(state_17148){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16792__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16792__auto____1.call(this,state_17148);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16792__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16792__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16792__auto__;
})()
;})(switch__16791__auto__,c__16893__auto___17258,jobs,results,process,async))
})();
var state__16895__auto__ = (function (){var statearr_17163 = (f__16894__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16894__auto__.cljs$core$IFn$_invoke$arity$0() : f__16894__auto__.call(null));
(statearr_17163[(6)] = c__16893__auto___17258);

return statearr_17163;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16895__auto__);
});})(c__16893__auto___17258,jobs,results,process,async))
);


var c__16893__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16893__auto__,jobs,results,process,async){
return (function (){
var f__16894__auto__ = (function (){var switch__16791__auto__ = ((function (c__16893__auto__,jobs,results,process,async){
return (function (state_17201){
var state_val_17202 = (state_17201[(1)]);
if((state_val_17202 === (7))){
var inst_17197 = (state_17201[(2)]);
var state_17201__$1 = state_17201;
var statearr_17203_17267 = state_17201__$1;
(statearr_17203_17267[(2)] = inst_17197);

(statearr_17203_17267[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17202 === (20))){
var state_17201__$1 = state_17201;
var statearr_17204_17268 = state_17201__$1;
(statearr_17204_17268[(2)] = null);

(statearr_17204_17268[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17202 === (1))){
var state_17201__$1 = state_17201;
var statearr_17205_17269 = state_17201__$1;
(statearr_17205_17269[(2)] = null);

(statearr_17205_17269[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17202 === (4))){
var inst_17166 = (state_17201[(7)]);
var inst_17166__$1 = (state_17201[(2)]);
var inst_17167 = (inst_17166__$1 == null);
var state_17201__$1 = (function (){var statearr_17206 = state_17201;
(statearr_17206[(7)] = inst_17166__$1);

return statearr_17206;
})();
if(cljs.core.truth_(inst_17167)){
var statearr_17207_17270 = state_17201__$1;
(statearr_17207_17270[(1)] = (5));

} else {
var statearr_17208_17271 = state_17201__$1;
(statearr_17208_17271[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17202 === (15))){
var inst_17179 = (state_17201[(8)]);
var state_17201__$1 = state_17201;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17201__$1,(18),to,inst_17179);
} else {
if((state_val_17202 === (21))){
var inst_17192 = (state_17201[(2)]);
var state_17201__$1 = state_17201;
var statearr_17209_17272 = state_17201__$1;
(statearr_17209_17272[(2)] = inst_17192);

(statearr_17209_17272[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17202 === (13))){
var inst_17194 = (state_17201[(2)]);
var state_17201__$1 = (function (){var statearr_17210 = state_17201;
(statearr_17210[(9)] = inst_17194);

return statearr_17210;
})();
var statearr_17211_17273 = state_17201__$1;
(statearr_17211_17273[(2)] = null);

(statearr_17211_17273[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17202 === (6))){
var inst_17166 = (state_17201[(7)]);
var state_17201__$1 = state_17201;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17201__$1,(11),inst_17166);
} else {
if((state_val_17202 === (17))){
var inst_17187 = (state_17201[(2)]);
var state_17201__$1 = state_17201;
if(cljs.core.truth_(inst_17187)){
var statearr_17212_17274 = state_17201__$1;
(statearr_17212_17274[(1)] = (19));

} else {
var statearr_17213_17275 = state_17201__$1;
(statearr_17213_17275[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17202 === (3))){
var inst_17199 = (state_17201[(2)]);
var state_17201__$1 = state_17201;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17201__$1,inst_17199);
} else {
if((state_val_17202 === (12))){
var inst_17176 = (state_17201[(10)]);
var state_17201__$1 = state_17201;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17201__$1,(14),inst_17176);
} else {
if((state_val_17202 === (2))){
var state_17201__$1 = state_17201;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17201__$1,(4),results);
} else {
if((state_val_17202 === (19))){
var state_17201__$1 = state_17201;
var statearr_17214_17276 = state_17201__$1;
(statearr_17214_17276[(2)] = null);

(statearr_17214_17276[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17202 === (11))){
var inst_17176 = (state_17201[(2)]);
var state_17201__$1 = (function (){var statearr_17215 = state_17201;
(statearr_17215[(10)] = inst_17176);

return statearr_17215;
})();
var statearr_17216_17277 = state_17201__$1;
(statearr_17216_17277[(2)] = null);

(statearr_17216_17277[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17202 === (9))){
var state_17201__$1 = state_17201;
var statearr_17217_17278 = state_17201__$1;
(statearr_17217_17278[(2)] = null);

(statearr_17217_17278[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17202 === (5))){
var state_17201__$1 = state_17201;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17218_17279 = state_17201__$1;
(statearr_17218_17279[(1)] = (8));

} else {
var statearr_17219_17280 = state_17201__$1;
(statearr_17219_17280[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17202 === (14))){
var inst_17181 = (state_17201[(11)]);
var inst_17179 = (state_17201[(8)]);
var inst_17179__$1 = (state_17201[(2)]);
var inst_17180 = (inst_17179__$1 == null);
var inst_17181__$1 = cljs.core.not(inst_17180);
var state_17201__$1 = (function (){var statearr_17220 = state_17201;
(statearr_17220[(11)] = inst_17181__$1);

(statearr_17220[(8)] = inst_17179__$1);

return statearr_17220;
})();
if(inst_17181__$1){
var statearr_17221_17281 = state_17201__$1;
(statearr_17221_17281[(1)] = (15));

} else {
var statearr_17222_17282 = state_17201__$1;
(statearr_17222_17282[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17202 === (16))){
var inst_17181 = (state_17201[(11)]);
var state_17201__$1 = state_17201;
var statearr_17223_17283 = state_17201__$1;
(statearr_17223_17283[(2)] = inst_17181);

(statearr_17223_17283[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17202 === (10))){
var inst_17173 = (state_17201[(2)]);
var state_17201__$1 = state_17201;
var statearr_17224_17284 = state_17201__$1;
(statearr_17224_17284[(2)] = inst_17173);

(statearr_17224_17284[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17202 === (18))){
var inst_17184 = (state_17201[(2)]);
var state_17201__$1 = state_17201;
var statearr_17225_17285 = state_17201__$1;
(statearr_17225_17285[(2)] = inst_17184);

(statearr_17225_17285[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17202 === (8))){
var inst_17170 = cljs.core.async.close_BANG_(to);
var state_17201__$1 = state_17201;
var statearr_17226_17286 = state_17201__$1;
(statearr_17226_17286[(2)] = inst_17170);

(statearr_17226_17286[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16893__auto__,jobs,results,process,async))
;
return ((function (switch__16791__auto__,c__16893__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16792__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16792__auto____0 = (function (){
var statearr_17227 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17227[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16792__auto__);

(statearr_17227[(1)] = (1));

return statearr_17227;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16792__auto____1 = (function (state_17201){
while(true){
var ret_value__16793__auto__ = (function (){try{while(true){
var result__16794__auto__ = switch__16791__auto__(state_17201);
if(cljs.core.keyword_identical_QMARK_(result__16794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16794__auto__;
}
break;
}
}catch (e17228){if((e17228 instanceof Object)){
var ex__16795__auto__ = e17228;
var statearr_17229_17287 = state_17201;
(statearr_17229_17287[(5)] = ex__16795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17201);

return cljs.core.cst$kw$recur;
} else {
throw e17228;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16793__auto__,cljs.core.cst$kw$recur)){
var G__17288 = state_17201;
state_17201 = G__17288;
continue;
} else {
return ret_value__16793__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16792__auto__ = function(state_17201){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16792__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16792__auto____1.call(this,state_17201);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16792__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16792__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16792__auto__;
})()
;})(switch__16791__auto__,c__16893__auto__,jobs,results,process,async))
})();
var state__16895__auto__ = (function (){var statearr_17230 = (f__16894__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16894__auto__.cljs$core$IFn$_invoke$arity$0() : f__16894__auto__.call(null));
(statearr_17230[(6)] = c__16893__auto__);

return statearr_17230;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16895__auto__);
});})(c__16893__auto__,jobs,results,process,async))
);

return c__16893__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__17290 = arguments.length;
switch (G__17290) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__17293 = arguments.length;
switch (G__17293) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__17296 = arguments.length;
switch (G__17296) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__16893__auto___17345 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16893__auto___17345,tc,fc){
return (function (){
var f__16894__auto__ = (function (){var switch__16791__auto__ = ((function (c__16893__auto___17345,tc,fc){
return (function (state_17322){
var state_val_17323 = (state_17322[(1)]);
if((state_val_17323 === (7))){
var inst_17318 = (state_17322[(2)]);
var state_17322__$1 = state_17322;
var statearr_17324_17346 = state_17322__$1;
(statearr_17324_17346[(2)] = inst_17318);

(statearr_17324_17346[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17323 === (1))){
var state_17322__$1 = state_17322;
var statearr_17325_17347 = state_17322__$1;
(statearr_17325_17347[(2)] = null);

(statearr_17325_17347[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17323 === (4))){
var inst_17299 = (state_17322[(7)]);
var inst_17299__$1 = (state_17322[(2)]);
var inst_17300 = (inst_17299__$1 == null);
var state_17322__$1 = (function (){var statearr_17326 = state_17322;
(statearr_17326[(7)] = inst_17299__$1);

return statearr_17326;
})();
if(cljs.core.truth_(inst_17300)){
var statearr_17327_17348 = state_17322__$1;
(statearr_17327_17348[(1)] = (5));

} else {
var statearr_17328_17349 = state_17322__$1;
(statearr_17328_17349[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17323 === (13))){
var state_17322__$1 = state_17322;
var statearr_17329_17350 = state_17322__$1;
(statearr_17329_17350[(2)] = null);

(statearr_17329_17350[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17323 === (6))){
var inst_17299 = (state_17322[(7)]);
var inst_17305 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_17299) : p.call(null,inst_17299));
var state_17322__$1 = state_17322;
if(cljs.core.truth_(inst_17305)){
var statearr_17330_17351 = state_17322__$1;
(statearr_17330_17351[(1)] = (9));

} else {
var statearr_17331_17352 = state_17322__$1;
(statearr_17331_17352[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17323 === (3))){
var inst_17320 = (state_17322[(2)]);
var state_17322__$1 = state_17322;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17322__$1,inst_17320);
} else {
if((state_val_17323 === (12))){
var state_17322__$1 = state_17322;
var statearr_17332_17353 = state_17322__$1;
(statearr_17332_17353[(2)] = null);

(statearr_17332_17353[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17323 === (2))){
var state_17322__$1 = state_17322;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17322__$1,(4),ch);
} else {
if((state_val_17323 === (11))){
var inst_17299 = (state_17322[(7)]);
var inst_17309 = (state_17322[(2)]);
var state_17322__$1 = state_17322;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17322__$1,(8),inst_17309,inst_17299);
} else {
if((state_val_17323 === (9))){
var state_17322__$1 = state_17322;
var statearr_17333_17354 = state_17322__$1;
(statearr_17333_17354[(2)] = tc);

(statearr_17333_17354[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17323 === (5))){
var inst_17302 = cljs.core.async.close_BANG_(tc);
var inst_17303 = cljs.core.async.close_BANG_(fc);
var state_17322__$1 = (function (){var statearr_17334 = state_17322;
(statearr_17334[(8)] = inst_17302);

return statearr_17334;
})();
var statearr_17335_17355 = state_17322__$1;
(statearr_17335_17355[(2)] = inst_17303);

(statearr_17335_17355[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17323 === (14))){
var inst_17316 = (state_17322[(2)]);
var state_17322__$1 = state_17322;
var statearr_17336_17356 = state_17322__$1;
(statearr_17336_17356[(2)] = inst_17316);

(statearr_17336_17356[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17323 === (10))){
var state_17322__$1 = state_17322;
var statearr_17337_17357 = state_17322__$1;
(statearr_17337_17357[(2)] = fc);

(statearr_17337_17357[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17323 === (8))){
var inst_17311 = (state_17322[(2)]);
var state_17322__$1 = state_17322;
if(cljs.core.truth_(inst_17311)){
var statearr_17338_17358 = state_17322__$1;
(statearr_17338_17358[(1)] = (12));

} else {
var statearr_17339_17359 = state_17322__$1;
(statearr_17339_17359[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16893__auto___17345,tc,fc))
;
return ((function (switch__16791__auto__,c__16893__auto___17345,tc,fc){
return (function() {
var cljs$core$async$state_machine__16792__auto__ = null;
var cljs$core$async$state_machine__16792__auto____0 = (function (){
var statearr_17340 = [null,null,null,null,null,null,null,null,null];
(statearr_17340[(0)] = cljs$core$async$state_machine__16792__auto__);

(statearr_17340[(1)] = (1));

return statearr_17340;
});
var cljs$core$async$state_machine__16792__auto____1 = (function (state_17322){
while(true){
var ret_value__16793__auto__ = (function (){try{while(true){
var result__16794__auto__ = switch__16791__auto__(state_17322);
if(cljs.core.keyword_identical_QMARK_(result__16794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16794__auto__;
}
break;
}
}catch (e17341){if((e17341 instanceof Object)){
var ex__16795__auto__ = e17341;
var statearr_17342_17360 = state_17322;
(statearr_17342_17360[(5)] = ex__16795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17322);

return cljs.core.cst$kw$recur;
} else {
throw e17341;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16793__auto__,cljs.core.cst$kw$recur)){
var G__17361 = state_17322;
state_17322 = G__17361;
continue;
} else {
return ret_value__16793__auto__;
}
break;
}
});
cljs$core$async$state_machine__16792__auto__ = function(state_17322){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16792__auto____1.call(this,state_17322);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16792__auto____0;
cljs$core$async$state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16792__auto____1;
return cljs$core$async$state_machine__16792__auto__;
})()
;})(switch__16791__auto__,c__16893__auto___17345,tc,fc))
})();
var state__16895__auto__ = (function (){var statearr_17343 = (f__16894__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16894__auto__.cljs$core$IFn$_invoke$arity$0() : f__16894__auto__.call(null));
(statearr_17343[(6)] = c__16893__auto___17345);

return statearr_17343;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16895__auto__);
});})(c__16893__auto___17345,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__16893__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16893__auto__){
return (function (){
var f__16894__auto__ = (function (){var switch__16791__auto__ = ((function (c__16893__auto__){
return (function (state_17382){
var state_val_17383 = (state_17382[(1)]);
if((state_val_17383 === (7))){
var inst_17378 = (state_17382[(2)]);
var state_17382__$1 = state_17382;
var statearr_17384_17402 = state_17382__$1;
(statearr_17384_17402[(2)] = inst_17378);

(statearr_17384_17402[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17383 === (1))){
var inst_17362 = init;
var state_17382__$1 = (function (){var statearr_17385 = state_17382;
(statearr_17385[(7)] = inst_17362);

return statearr_17385;
})();
var statearr_17386_17403 = state_17382__$1;
(statearr_17386_17403[(2)] = null);

(statearr_17386_17403[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17383 === (4))){
var inst_17365 = (state_17382[(8)]);
var inst_17365__$1 = (state_17382[(2)]);
var inst_17366 = (inst_17365__$1 == null);
var state_17382__$1 = (function (){var statearr_17387 = state_17382;
(statearr_17387[(8)] = inst_17365__$1);

return statearr_17387;
})();
if(cljs.core.truth_(inst_17366)){
var statearr_17388_17404 = state_17382__$1;
(statearr_17388_17404[(1)] = (5));

} else {
var statearr_17389_17405 = state_17382__$1;
(statearr_17389_17405[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17383 === (6))){
var inst_17369 = (state_17382[(9)]);
var inst_17362 = (state_17382[(7)]);
var inst_17365 = (state_17382[(8)]);
var inst_17369__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_17362,inst_17365) : f.call(null,inst_17362,inst_17365));
var inst_17370 = cljs.core.reduced_QMARK_(inst_17369__$1);
var state_17382__$1 = (function (){var statearr_17390 = state_17382;
(statearr_17390[(9)] = inst_17369__$1);

return statearr_17390;
})();
if(inst_17370){
var statearr_17391_17406 = state_17382__$1;
(statearr_17391_17406[(1)] = (8));

} else {
var statearr_17392_17407 = state_17382__$1;
(statearr_17392_17407[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17383 === (3))){
var inst_17380 = (state_17382[(2)]);
var state_17382__$1 = state_17382;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17382__$1,inst_17380);
} else {
if((state_val_17383 === (2))){
var state_17382__$1 = state_17382;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17382__$1,(4),ch);
} else {
if((state_val_17383 === (9))){
var inst_17369 = (state_17382[(9)]);
var inst_17362 = inst_17369;
var state_17382__$1 = (function (){var statearr_17393 = state_17382;
(statearr_17393[(7)] = inst_17362);

return statearr_17393;
})();
var statearr_17394_17408 = state_17382__$1;
(statearr_17394_17408[(2)] = null);

(statearr_17394_17408[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17383 === (5))){
var inst_17362 = (state_17382[(7)]);
var state_17382__$1 = state_17382;
var statearr_17395_17409 = state_17382__$1;
(statearr_17395_17409[(2)] = inst_17362);

(statearr_17395_17409[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17383 === (10))){
var inst_17376 = (state_17382[(2)]);
var state_17382__$1 = state_17382;
var statearr_17396_17410 = state_17382__$1;
(statearr_17396_17410[(2)] = inst_17376);

(statearr_17396_17410[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17383 === (8))){
var inst_17369 = (state_17382[(9)]);
var inst_17372 = cljs.core.deref(inst_17369);
var state_17382__$1 = state_17382;
var statearr_17397_17411 = state_17382__$1;
(statearr_17397_17411[(2)] = inst_17372);

(statearr_17397_17411[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__16893__auto__))
;
return ((function (switch__16791__auto__,c__16893__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__16792__auto__ = null;
var cljs$core$async$reduce_$_state_machine__16792__auto____0 = (function (){
var statearr_17398 = [null,null,null,null,null,null,null,null,null,null];
(statearr_17398[(0)] = cljs$core$async$reduce_$_state_machine__16792__auto__);

(statearr_17398[(1)] = (1));

return statearr_17398;
});
var cljs$core$async$reduce_$_state_machine__16792__auto____1 = (function (state_17382){
while(true){
var ret_value__16793__auto__ = (function (){try{while(true){
var result__16794__auto__ = switch__16791__auto__(state_17382);
if(cljs.core.keyword_identical_QMARK_(result__16794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16794__auto__;
}
break;
}
}catch (e17399){if((e17399 instanceof Object)){
var ex__16795__auto__ = e17399;
var statearr_17400_17412 = state_17382;
(statearr_17400_17412[(5)] = ex__16795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17382);

return cljs.core.cst$kw$recur;
} else {
throw e17399;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16793__auto__,cljs.core.cst$kw$recur)){
var G__17413 = state_17382;
state_17382 = G__17413;
continue;
} else {
return ret_value__16793__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__16792__auto__ = function(state_17382){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__16792__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__16792__auto____1.call(this,state_17382);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__16792__auto____0;
cljs$core$async$reduce_$_state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__16792__auto____1;
return cljs$core$async$reduce_$_state_machine__16792__auto__;
})()
;})(switch__16791__auto__,c__16893__auto__))
})();
var state__16895__auto__ = (function (){var statearr_17401 = (f__16894__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16894__auto__.cljs$core$IFn$_invoke$arity$0() : f__16894__auto__.call(null));
(statearr_17401[(6)] = c__16893__auto__);

return statearr_17401;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16895__auto__);
});})(c__16893__auto__))
);

return c__16893__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__16893__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16893__auto__,f__$1){
return (function (){
var f__16894__auto__ = (function (){var switch__16791__auto__ = ((function (c__16893__auto__,f__$1){
return (function (state_17419){
var state_val_17420 = (state_17419[(1)]);
if((state_val_17420 === (1))){
var inst_17414 = cljs.core.async.reduce(f__$1,init,ch);
var state_17419__$1 = state_17419;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17419__$1,(2),inst_17414);
} else {
if((state_val_17420 === (2))){
var inst_17416 = (state_17419[(2)]);
var inst_17417 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_17416) : f__$1.call(null,inst_17416));
var state_17419__$1 = state_17419;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17419__$1,inst_17417);
} else {
return null;
}
}
});})(c__16893__auto__,f__$1))
;
return ((function (switch__16791__auto__,c__16893__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__16792__auto__ = null;
var cljs$core$async$transduce_$_state_machine__16792__auto____0 = (function (){
var statearr_17421 = [null,null,null,null,null,null,null];
(statearr_17421[(0)] = cljs$core$async$transduce_$_state_machine__16792__auto__);

(statearr_17421[(1)] = (1));

return statearr_17421;
});
var cljs$core$async$transduce_$_state_machine__16792__auto____1 = (function (state_17419){
while(true){
var ret_value__16793__auto__ = (function (){try{while(true){
var result__16794__auto__ = switch__16791__auto__(state_17419);
if(cljs.core.keyword_identical_QMARK_(result__16794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16794__auto__;
}
break;
}
}catch (e17422){if((e17422 instanceof Object)){
var ex__16795__auto__ = e17422;
var statearr_17423_17425 = state_17419;
(statearr_17423_17425[(5)] = ex__16795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17419);

return cljs.core.cst$kw$recur;
} else {
throw e17422;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16793__auto__,cljs.core.cst$kw$recur)){
var G__17426 = state_17419;
state_17419 = G__17426;
continue;
} else {
return ret_value__16793__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__16792__auto__ = function(state_17419){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__16792__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__16792__auto____1.call(this,state_17419);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__16792__auto____0;
cljs$core$async$transduce_$_state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__16792__auto____1;
return cljs$core$async$transduce_$_state_machine__16792__auto__;
})()
;})(switch__16791__auto__,c__16893__auto__,f__$1))
})();
var state__16895__auto__ = (function (){var statearr_17424 = (f__16894__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16894__auto__.cljs$core$IFn$_invoke$arity$0() : f__16894__auto__.call(null));
(statearr_17424[(6)] = c__16893__auto__);

return statearr_17424;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16895__auto__);
});})(c__16893__auto__,f__$1))
);

return c__16893__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__17428 = arguments.length;
switch (G__17428) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__16893__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16893__auto__){
return (function (){
var f__16894__auto__ = (function (){var switch__16791__auto__ = ((function (c__16893__auto__){
return (function (state_17453){
var state_val_17454 = (state_17453[(1)]);
if((state_val_17454 === (7))){
var inst_17435 = (state_17453[(2)]);
var state_17453__$1 = state_17453;
var statearr_17455_17476 = state_17453__$1;
(statearr_17455_17476[(2)] = inst_17435);

(statearr_17455_17476[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17454 === (1))){
var inst_17429 = cljs.core.seq(coll);
var inst_17430 = inst_17429;
var state_17453__$1 = (function (){var statearr_17456 = state_17453;
(statearr_17456[(7)] = inst_17430);

return statearr_17456;
})();
var statearr_17457_17477 = state_17453__$1;
(statearr_17457_17477[(2)] = null);

(statearr_17457_17477[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17454 === (4))){
var inst_17430 = (state_17453[(7)]);
var inst_17433 = cljs.core.first(inst_17430);
var state_17453__$1 = state_17453;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17453__$1,(7),ch,inst_17433);
} else {
if((state_val_17454 === (13))){
var inst_17447 = (state_17453[(2)]);
var state_17453__$1 = state_17453;
var statearr_17458_17478 = state_17453__$1;
(statearr_17458_17478[(2)] = inst_17447);

(statearr_17458_17478[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17454 === (6))){
var inst_17438 = (state_17453[(2)]);
var state_17453__$1 = state_17453;
if(cljs.core.truth_(inst_17438)){
var statearr_17459_17479 = state_17453__$1;
(statearr_17459_17479[(1)] = (8));

} else {
var statearr_17460_17480 = state_17453__$1;
(statearr_17460_17480[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17454 === (3))){
var inst_17451 = (state_17453[(2)]);
var state_17453__$1 = state_17453;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17453__$1,inst_17451);
} else {
if((state_val_17454 === (12))){
var state_17453__$1 = state_17453;
var statearr_17461_17481 = state_17453__$1;
(statearr_17461_17481[(2)] = null);

(statearr_17461_17481[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17454 === (2))){
var inst_17430 = (state_17453[(7)]);
var state_17453__$1 = state_17453;
if(cljs.core.truth_(inst_17430)){
var statearr_17462_17482 = state_17453__$1;
(statearr_17462_17482[(1)] = (4));

} else {
var statearr_17463_17483 = state_17453__$1;
(statearr_17463_17483[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17454 === (11))){
var inst_17444 = cljs.core.async.close_BANG_(ch);
var state_17453__$1 = state_17453;
var statearr_17464_17484 = state_17453__$1;
(statearr_17464_17484[(2)] = inst_17444);

(statearr_17464_17484[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17454 === (9))){
var state_17453__$1 = state_17453;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17465_17485 = state_17453__$1;
(statearr_17465_17485[(1)] = (11));

} else {
var statearr_17466_17486 = state_17453__$1;
(statearr_17466_17486[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17454 === (5))){
var inst_17430 = (state_17453[(7)]);
var state_17453__$1 = state_17453;
var statearr_17467_17487 = state_17453__$1;
(statearr_17467_17487[(2)] = inst_17430);

(statearr_17467_17487[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17454 === (10))){
var inst_17449 = (state_17453[(2)]);
var state_17453__$1 = state_17453;
var statearr_17468_17488 = state_17453__$1;
(statearr_17468_17488[(2)] = inst_17449);

(statearr_17468_17488[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17454 === (8))){
var inst_17430 = (state_17453[(7)]);
var inst_17440 = cljs.core.next(inst_17430);
var inst_17430__$1 = inst_17440;
var state_17453__$1 = (function (){var statearr_17469 = state_17453;
(statearr_17469[(7)] = inst_17430__$1);

return statearr_17469;
})();
var statearr_17470_17489 = state_17453__$1;
(statearr_17470_17489[(2)] = null);

(statearr_17470_17489[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16893__auto__))
;
return ((function (switch__16791__auto__,c__16893__auto__){
return (function() {
var cljs$core$async$state_machine__16792__auto__ = null;
var cljs$core$async$state_machine__16792__auto____0 = (function (){
var statearr_17471 = [null,null,null,null,null,null,null,null];
(statearr_17471[(0)] = cljs$core$async$state_machine__16792__auto__);

(statearr_17471[(1)] = (1));

return statearr_17471;
});
var cljs$core$async$state_machine__16792__auto____1 = (function (state_17453){
while(true){
var ret_value__16793__auto__ = (function (){try{while(true){
var result__16794__auto__ = switch__16791__auto__(state_17453);
if(cljs.core.keyword_identical_QMARK_(result__16794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16794__auto__;
}
break;
}
}catch (e17472){if((e17472 instanceof Object)){
var ex__16795__auto__ = e17472;
var statearr_17473_17490 = state_17453;
(statearr_17473_17490[(5)] = ex__16795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17453);

return cljs.core.cst$kw$recur;
} else {
throw e17472;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16793__auto__,cljs.core.cst$kw$recur)){
var G__17491 = state_17453;
state_17453 = G__17491;
continue;
} else {
return ret_value__16793__auto__;
}
break;
}
});
cljs$core$async$state_machine__16792__auto__ = function(state_17453){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16792__auto____1.call(this,state_17453);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16792__auto____0;
cljs$core$async$state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16792__auto____1;
return cljs$core$async$state_machine__16792__auto__;
})()
;})(switch__16791__auto__,c__16893__auto__))
})();
var state__16895__auto__ = (function (){var statearr_17474 = (f__16894__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16894__auto__.cljs$core$IFn$_invoke$arity$0() : f__16894__auto__.call(null));
(statearr_17474[(6)] = c__16893__auto__);

return statearr_17474;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16895__auto__);
});})(c__16893__auto__))
);

return c__16893__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__9541__auto__ = (((_ == null))?null:_);
var m__9542__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__9542__auto__.call(null,_));
} else {
var m__9542__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__9542__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__9541__auto__ = (((m == null))?null:m);
var m__9542__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__9542__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__9542__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__9542__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__9541__auto__ = (((m == null))?null:m);
var m__9542__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9542__auto__.call(null,m,ch));
} else {
var m__9542__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9542__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__9541__auto__ = (((m == null))?null:m);
var m__9542__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__9542__auto__.call(null,m));
} else {
var m__9542__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__9542__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async17492 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17492 = (function (ch,cs,meta17493){
this.ch = ch;
this.cs = cs;
this.meta17493 = meta17493;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17492.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_17494,meta17493__$1){
var self__ = this;
var _17494__$1 = this;
return (new cljs.core.async.t_cljs$core$async17492(self__.ch,self__.cs,meta17493__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async17492.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_17494){
var self__ = this;
var _17494__$1 = this;
return self__.meta17493;
});})(cs))
;

cljs.core.async.t_cljs$core$async17492.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17492.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async17492.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17492.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async17492.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async17492.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async17492.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta17493], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async17492.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17492.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17492";

cljs.core.async.t_cljs$core$async17492.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__9479__auto__,writer__9480__auto__,opt__9481__auto__){
return cljs.core._write(writer__9480__auto__,"cljs.core.async/t_cljs$core$async17492");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async17492 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async17492(ch__$1,cs__$1,meta17493){
return (new cljs.core.async.t_cljs$core$async17492(ch__$1,cs__$1,meta17493));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async17492(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__16893__auto___17714 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16893__auto___17714,cs,m,dchan,dctr,done){
return (function (){
var f__16894__auto__ = (function (){var switch__16791__auto__ = ((function (c__16893__auto___17714,cs,m,dchan,dctr,done){
return (function (state_17629){
var state_val_17630 = (state_17629[(1)]);
if((state_val_17630 === (7))){
var inst_17625 = (state_17629[(2)]);
var state_17629__$1 = state_17629;
var statearr_17631_17715 = state_17629__$1;
(statearr_17631_17715[(2)] = inst_17625);

(statearr_17631_17715[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (20))){
var inst_17528 = (state_17629[(7)]);
var inst_17540 = cljs.core.first(inst_17528);
var inst_17541 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17540,(0),null);
var inst_17542 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17540,(1),null);
var state_17629__$1 = (function (){var statearr_17632 = state_17629;
(statearr_17632[(8)] = inst_17541);

return statearr_17632;
})();
if(cljs.core.truth_(inst_17542)){
var statearr_17633_17716 = state_17629__$1;
(statearr_17633_17716[(1)] = (22));

} else {
var statearr_17634_17717 = state_17629__$1;
(statearr_17634_17717[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (27))){
var inst_17570 = (state_17629[(9)]);
var inst_17572 = (state_17629[(10)]);
var inst_17497 = (state_17629[(11)]);
var inst_17577 = (state_17629[(12)]);
var inst_17577__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_17570,inst_17572);
var inst_17578 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_17577__$1,inst_17497,done);
var state_17629__$1 = (function (){var statearr_17635 = state_17629;
(statearr_17635[(12)] = inst_17577__$1);

return statearr_17635;
})();
if(cljs.core.truth_(inst_17578)){
var statearr_17636_17718 = state_17629__$1;
(statearr_17636_17718[(1)] = (30));

} else {
var statearr_17637_17719 = state_17629__$1;
(statearr_17637_17719[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (1))){
var state_17629__$1 = state_17629;
var statearr_17638_17720 = state_17629__$1;
(statearr_17638_17720[(2)] = null);

(statearr_17638_17720[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (24))){
var inst_17528 = (state_17629[(7)]);
var inst_17547 = (state_17629[(2)]);
var inst_17548 = cljs.core.next(inst_17528);
var inst_17506 = inst_17548;
var inst_17507 = null;
var inst_17508 = (0);
var inst_17509 = (0);
var state_17629__$1 = (function (){var statearr_17639 = state_17629;
(statearr_17639[(13)] = inst_17507);

(statearr_17639[(14)] = inst_17508);

(statearr_17639[(15)] = inst_17509);

(statearr_17639[(16)] = inst_17506);

(statearr_17639[(17)] = inst_17547);

return statearr_17639;
})();
var statearr_17640_17721 = state_17629__$1;
(statearr_17640_17721[(2)] = null);

(statearr_17640_17721[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (39))){
var state_17629__$1 = state_17629;
var statearr_17644_17722 = state_17629__$1;
(statearr_17644_17722[(2)] = null);

(statearr_17644_17722[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (4))){
var inst_17497 = (state_17629[(11)]);
var inst_17497__$1 = (state_17629[(2)]);
var inst_17498 = (inst_17497__$1 == null);
var state_17629__$1 = (function (){var statearr_17645 = state_17629;
(statearr_17645[(11)] = inst_17497__$1);

return statearr_17645;
})();
if(cljs.core.truth_(inst_17498)){
var statearr_17646_17723 = state_17629__$1;
(statearr_17646_17723[(1)] = (5));

} else {
var statearr_17647_17724 = state_17629__$1;
(statearr_17647_17724[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (15))){
var inst_17507 = (state_17629[(13)]);
var inst_17508 = (state_17629[(14)]);
var inst_17509 = (state_17629[(15)]);
var inst_17506 = (state_17629[(16)]);
var inst_17524 = (state_17629[(2)]);
var inst_17525 = (inst_17509 + (1));
var tmp17641 = inst_17507;
var tmp17642 = inst_17508;
var tmp17643 = inst_17506;
var inst_17506__$1 = tmp17643;
var inst_17507__$1 = tmp17641;
var inst_17508__$1 = tmp17642;
var inst_17509__$1 = inst_17525;
var state_17629__$1 = (function (){var statearr_17648 = state_17629;
(statearr_17648[(13)] = inst_17507__$1);

(statearr_17648[(18)] = inst_17524);

(statearr_17648[(14)] = inst_17508__$1);

(statearr_17648[(15)] = inst_17509__$1);

(statearr_17648[(16)] = inst_17506__$1);

return statearr_17648;
})();
var statearr_17649_17725 = state_17629__$1;
(statearr_17649_17725[(2)] = null);

(statearr_17649_17725[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (21))){
var inst_17551 = (state_17629[(2)]);
var state_17629__$1 = state_17629;
var statearr_17653_17726 = state_17629__$1;
(statearr_17653_17726[(2)] = inst_17551);

(statearr_17653_17726[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (31))){
var inst_17577 = (state_17629[(12)]);
var inst_17581 = done(null);
var inst_17582 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_17577);
var state_17629__$1 = (function (){var statearr_17654 = state_17629;
(statearr_17654[(19)] = inst_17581);

return statearr_17654;
})();
var statearr_17655_17727 = state_17629__$1;
(statearr_17655_17727[(2)] = inst_17582);

(statearr_17655_17727[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (32))){
var inst_17571 = (state_17629[(20)]);
var inst_17570 = (state_17629[(9)]);
var inst_17572 = (state_17629[(10)]);
var inst_17569 = (state_17629[(21)]);
var inst_17584 = (state_17629[(2)]);
var inst_17585 = (inst_17572 + (1));
var tmp17650 = inst_17571;
var tmp17651 = inst_17570;
var tmp17652 = inst_17569;
var inst_17569__$1 = tmp17652;
var inst_17570__$1 = tmp17651;
var inst_17571__$1 = tmp17650;
var inst_17572__$1 = inst_17585;
var state_17629__$1 = (function (){var statearr_17656 = state_17629;
(statearr_17656[(22)] = inst_17584);

(statearr_17656[(20)] = inst_17571__$1);

(statearr_17656[(9)] = inst_17570__$1);

(statearr_17656[(10)] = inst_17572__$1);

(statearr_17656[(21)] = inst_17569__$1);

return statearr_17656;
})();
var statearr_17657_17728 = state_17629__$1;
(statearr_17657_17728[(2)] = null);

(statearr_17657_17728[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (40))){
var inst_17597 = (state_17629[(23)]);
var inst_17601 = done(null);
var inst_17602 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_17597);
var state_17629__$1 = (function (){var statearr_17658 = state_17629;
(statearr_17658[(24)] = inst_17601);

return statearr_17658;
})();
var statearr_17659_17729 = state_17629__$1;
(statearr_17659_17729[(2)] = inst_17602);

(statearr_17659_17729[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (33))){
var inst_17588 = (state_17629[(25)]);
var inst_17590 = cljs.core.chunked_seq_QMARK_(inst_17588);
var state_17629__$1 = state_17629;
if(inst_17590){
var statearr_17660_17730 = state_17629__$1;
(statearr_17660_17730[(1)] = (36));

} else {
var statearr_17661_17731 = state_17629__$1;
(statearr_17661_17731[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (13))){
var inst_17518 = (state_17629[(26)]);
var inst_17521 = cljs.core.async.close_BANG_(inst_17518);
var state_17629__$1 = state_17629;
var statearr_17662_17732 = state_17629__$1;
(statearr_17662_17732[(2)] = inst_17521);

(statearr_17662_17732[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (22))){
var inst_17541 = (state_17629[(8)]);
var inst_17544 = cljs.core.async.close_BANG_(inst_17541);
var state_17629__$1 = state_17629;
var statearr_17663_17733 = state_17629__$1;
(statearr_17663_17733[(2)] = inst_17544);

(statearr_17663_17733[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (36))){
var inst_17588 = (state_17629[(25)]);
var inst_17592 = cljs.core.chunk_first(inst_17588);
var inst_17593 = cljs.core.chunk_rest(inst_17588);
var inst_17594 = cljs.core.count(inst_17592);
var inst_17569 = inst_17593;
var inst_17570 = inst_17592;
var inst_17571 = inst_17594;
var inst_17572 = (0);
var state_17629__$1 = (function (){var statearr_17664 = state_17629;
(statearr_17664[(20)] = inst_17571);

(statearr_17664[(9)] = inst_17570);

(statearr_17664[(10)] = inst_17572);

(statearr_17664[(21)] = inst_17569);

return statearr_17664;
})();
var statearr_17665_17734 = state_17629__$1;
(statearr_17665_17734[(2)] = null);

(statearr_17665_17734[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (41))){
var inst_17588 = (state_17629[(25)]);
var inst_17604 = (state_17629[(2)]);
var inst_17605 = cljs.core.next(inst_17588);
var inst_17569 = inst_17605;
var inst_17570 = null;
var inst_17571 = (0);
var inst_17572 = (0);
var state_17629__$1 = (function (){var statearr_17666 = state_17629;
(statearr_17666[(27)] = inst_17604);

(statearr_17666[(20)] = inst_17571);

(statearr_17666[(9)] = inst_17570);

(statearr_17666[(10)] = inst_17572);

(statearr_17666[(21)] = inst_17569);

return statearr_17666;
})();
var statearr_17667_17735 = state_17629__$1;
(statearr_17667_17735[(2)] = null);

(statearr_17667_17735[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (43))){
var state_17629__$1 = state_17629;
var statearr_17668_17736 = state_17629__$1;
(statearr_17668_17736[(2)] = null);

(statearr_17668_17736[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (29))){
var inst_17613 = (state_17629[(2)]);
var state_17629__$1 = state_17629;
var statearr_17669_17737 = state_17629__$1;
(statearr_17669_17737[(2)] = inst_17613);

(statearr_17669_17737[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (44))){
var inst_17622 = (state_17629[(2)]);
var state_17629__$1 = (function (){var statearr_17670 = state_17629;
(statearr_17670[(28)] = inst_17622);

return statearr_17670;
})();
var statearr_17671_17738 = state_17629__$1;
(statearr_17671_17738[(2)] = null);

(statearr_17671_17738[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (6))){
var inst_17561 = (state_17629[(29)]);
var inst_17560 = cljs.core.deref(cs);
var inst_17561__$1 = cljs.core.keys(inst_17560);
var inst_17562 = cljs.core.count(inst_17561__$1);
var inst_17563 = cljs.core.reset_BANG_(dctr,inst_17562);
var inst_17568 = cljs.core.seq(inst_17561__$1);
var inst_17569 = inst_17568;
var inst_17570 = null;
var inst_17571 = (0);
var inst_17572 = (0);
var state_17629__$1 = (function (){var statearr_17672 = state_17629;
(statearr_17672[(30)] = inst_17563);

(statearr_17672[(20)] = inst_17571);

(statearr_17672[(9)] = inst_17570);

(statearr_17672[(10)] = inst_17572);

(statearr_17672[(21)] = inst_17569);

(statearr_17672[(29)] = inst_17561__$1);

return statearr_17672;
})();
var statearr_17673_17739 = state_17629__$1;
(statearr_17673_17739[(2)] = null);

(statearr_17673_17739[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (28))){
var inst_17588 = (state_17629[(25)]);
var inst_17569 = (state_17629[(21)]);
var inst_17588__$1 = cljs.core.seq(inst_17569);
var state_17629__$1 = (function (){var statearr_17674 = state_17629;
(statearr_17674[(25)] = inst_17588__$1);

return statearr_17674;
})();
if(inst_17588__$1){
var statearr_17675_17740 = state_17629__$1;
(statearr_17675_17740[(1)] = (33));

} else {
var statearr_17676_17741 = state_17629__$1;
(statearr_17676_17741[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (25))){
var inst_17571 = (state_17629[(20)]);
var inst_17572 = (state_17629[(10)]);
var inst_17574 = (inst_17572 < inst_17571);
var inst_17575 = inst_17574;
var state_17629__$1 = state_17629;
if(cljs.core.truth_(inst_17575)){
var statearr_17677_17742 = state_17629__$1;
(statearr_17677_17742[(1)] = (27));

} else {
var statearr_17678_17743 = state_17629__$1;
(statearr_17678_17743[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (34))){
var state_17629__$1 = state_17629;
var statearr_17679_17744 = state_17629__$1;
(statearr_17679_17744[(2)] = null);

(statearr_17679_17744[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (17))){
var state_17629__$1 = state_17629;
var statearr_17680_17745 = state_17629__$1;
(statearr_17680_17745[(2)] = null);

(statearr_17680_17745[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (3))){
var inst_17627 = (state_17629[(2)]);
var state_17629__$1 = state_17629;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17629__$1,inst_17627);
} else {
if((state_val_17630 === (12))){
var inst_17556 = (state_17629[(2)]);
var state_17629__$1 = state_17629;
var statearr_17681_17746 = state_17629__$1;
(statearr_17681_17746[(2)] = inst_17556);

(statearr_17681_17746[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (2))){
var state_17629__$1 = state_17629;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17629__$1,(4),ch);
} else {
if((state_val_17630 === (23))){
var state_17629__$1 = state_17629;
var statearr_17682_17747 = state_17629__$1;
(statearr_17682_17747[(2)] = null);

(statearr_17682_17747[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (35))){
var inst_17611 = (state_17629[(2)]);
var state_17629__$1 = state_17629;
var statearr_17683_17748 = state_17629__$1;
(statearr_17683_17748[(2)] = inst_17611);

(statearr_17683_17748[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (19))){
var inst_17528 = (state_17629[(7)]);
var inst_17532 = cljs.core.chunk_first(inst_17528);
var inst_17533 = cljs.core.chunk_rest(inst_17528);
var inst_17534 = cljs.core.count(inst_17532);
var inst_17506 = inst_17533;
var inst_17507 = inst_17532;
var inst_17508 = inst_17534;
var inst_17509 = (0);
var state_17629__$1 = (function (){var statearr_17684 = state_17629;
(statearr_17684[(13)] = inst_17507);

(statearr_17684[(14)] = inst_17508);

(statearr_17684[(15)] = inst_17509);

(statearr_17684[(16)] = inst_17506);

return statearr_17684;
})();
var statearr_17685_17749 = state_17629__$1;
(statearr_17685_17749[(2)] = null);

(statearr_17685_17749[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (11))){
var inst_17528 = (state_17629[(7)]);
var inst_17506 = (state_17629[(16)]);
var inst_17528__$1 = cljs.core.seq(inst_17506);
var state_17629__$1 = (function (){var statearr_17686 = state_17629;
(statearr_17686[(7)] = inst_17528__$1);

return statearr_17686;
})();
if(inst_17528__$1){
var statearr_17687_17750 = state_17629__$1;
(statearr_17687_17750[(1)] = (16));

} else {
var statearr_17688_17751 = state_17629__$1;
(statearr_17688_17751[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (9))){
var inst_17558 = (state_17629[(2)]);
var state_17629__$1 = state_17629;
var statearr_17689_17752 = state_17629__$1;
(statearr_17689_17752[(2)] = inst_17558);

(statearr_17689_17752[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (5))){
var inst_17504 = cljs.core.deref(cs);
var inst_17505 = cljs.core.seq(inst_17504);
var inst_17506 = inst_17505;
var inst_17507 = null;
var inst_17508 = (0);
var inst_17509 = (0);
var state_17629__$1 = (function (){var statearr_17690 = state_17629;
(statearr_17690[(13)] = inst_17507);

(statearr_17690[(14)] = inst_17508);

(statearr_17690[(15)] = inst_17509);

(statearr_17690[(16)] = inst_17506);

return statearr_17690;
})();
var statearr_17691_17753 = state_17629__$1;
(statearr_17691_17753[(2)] = null);

(statearr_17691_17753[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (14))){
var state_17629__$1 = state_17629;
var statearr_17692_17754 = state_17629__$1;
(statearr_17692_17754[(2)] = null);

(statearr_17692_17754[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (45))){
var inst_17619 = (state_17629[(2)]);
var state_17629__$1 = state_17629;
var statearr_17693_17755 = state_17629__$1;
(statearr_17693_17755[(2)] = inst_17619);

(statearr_17693_17755[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (26))){
var inst_17561 = (state_17629[(29)]);
var inst_17615 = (state_17629[(2)]);
var inst_17616 = cljs.core.seq(inst_17561);
var state_17629__$1 = (function (){var statearr_17694 = state_17629;
(statearr_17694[(31)] = inst_17615);

return statearr_17694;
})();
if(inst_17616){
var statearr_17695_17756 = state_17629__$1;
(statearr_17695_17756[(1)] = (42));

} else {
var statearr_17696_17757 = state_17629__$1;
(statearr_17696_17757[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (16))){
var inst_17528 = (state_17629[(7)]);
var inst_17530 = cljs.core.chunked_seq_QMARK_(inst_17528);
var state_17629__$1 = state_17629;
if(inst_17530){
var statearr_17697_17758 = state_17629__$1;
(statearr_17697_17758[(1)] = (19));

} else {
var statearr_17698_17759 = state_17629__$1;
(statearr_17698_17759[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (38))){
var inst_17608 = (state_17629[(2)]);
var state_17629__$1 = state_17629;
var statearr_17699_17760 = state_17629__$1;
(statearr_17699_17760[(2)] = inst_17608);

(statearr_17699_17760[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (30))){
var state_17629__$1 = state_17629;
var statearr_17700_17761 = state_17629__$1;
(statearr_17700_17761[(2)] = null);

(statearr_17700_17761[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (10))){
var inst_17507 = (state_17629[(13)]);
var inst_17509 = (state_17629[(15)]);
var inst_17517 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_17507,inst_17509);
var inst_17518 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17517,(0),null);
var inst_17519 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17517,(1),null);
var state_17629__$1 = (function (){var statearr_17701 = state_17629;
(statearr_17701[(26)] = inst_17518);

return statearr_17701;
})();
if(cljs.core.truth_(inst_17519)){
var statearr_17702_17762 = state_17629__$1;
(statearr_17702_17762[(1)] = (13));

} else {
var statearr_17703_17763 = state_17629__$1;
(statearr_17703_17763[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (18))){
var inst_17554 = (state_17629[(2)]);
var state_17629__$1 = state_17629;
var statearr_17704_17764 = state_17629__$1;
(statearr_17704_17764[(2)] = inst_17554);

(statearr_17704_17764[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (42))){
var state_17629__$1 = state_17629;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17629__$1,(45),dchan);
} else {
if((state_val_17630 === (37))){
var inst_17588 = (state_17629[(25)]);
var inst_17497 = (state_17629[(11)]);
var inst_17597 = (state_17629[(23)]);
var inst_17597__$1 = cljs.core.first(inst_17588);
var inst_17598 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_17597__$1,inst_17497,done);
var state_17629__$1 = (function (){var statearr_17705 = state_17629;
(statearr_17705[(23)] = inst_17597__$1);

return statearr_17705;
})();
if(cljs.core.truth_(inst_17598)){
var statearr_17706_17765 = state_17629__$1;
(statearr_17706_17765[(1)] = (39));

} else {
var statearr_17707_17766 = state_17629__$1;
(statearr_17707_17766[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17630 === (8))){
var inst_17508 = (state_17629[(14)]);
var inst_17509 = (state_17629[(15)]);
var inst_17511 = (inst_17509 < inst_17508);
var inst_17512 = inst_17511;
var state_17629__$1 = state_17629;
if(cljs.core.truth_(inst_17512)){
var statearr_17708_17767 = state_17629__$1;
(statearr_17708_17767[(1)] = (10));

} else {
var statearr_17709_17768 = state_17629__$1;
(statearr_17709_17768[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16893__auto___17714,cs,m,dchan,dctr,done))
;
return ((function (switch__16791__auto__,c__16893__auto___17714,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__16792__auto__ = null;
var cljs$core$async$mult_$_state_machine__16792__auto____0 = (function (){
var statearr_17710 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17710[(0)] = cljs$core$async$mult_$_state_machine__16792__auto__);

(statearr_17710[(1)] = (1));

return statearr_17710;
});
var cljs$core$async$mult_$_state_machine__16792__auto____1 = (function (state_17629){
while(true){
var ret_value__16793__auto__ = (function (){try{while(true){
var result__16794__auto__ = switch__16791__auto__(state_17629);
if(cljs.core.keyword_identical_QMARK_(result__16794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16794__auto__;
}
break;
}
}catch (e17711){if((e17711 instanceof Object)){
var ex__16795__auto__ = e17711;
var statearr_17712_17769 = state_17629;
(statearr_17712_17769[(5)] = ex__16795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17629);

return cljs.core.cst$kw$recur;
} else {
throw e17711;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16793__auto__,cljs.core.cst$kw$recur)){
var G__17770 = state_17629;
state_17629 = G__17770;
continue;
} else {
return ret_value__16793__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__16792__auto__ = function(state_17629){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__16792__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__16792__auto____1.call(this,state_17629);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__16792__auto____0;
cljs$core$async$mult_$_state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__16792__auto____1;
return cljs$core$async$mult_$_state_machine__16792__auto__;
})()
;})(switch__16791__auto__,c__16893__auto___17714,cs,m,dchan,dctr,done))
})();
var state__16895__auto__ = (function (){var statearr_17713 = (f__16894__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16894__auto__.cljs$core$IFn$_invoke$arity$0() : f__16894__auto__.call(null));
(statearr_17713[(6)] = c__16893__auto___17714);

return statearr_17713;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16895__auto__);
});})(c__16893__auto___17714,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__17772 = arguments.length;
switch (G__17772) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__9541__auto__ = (((m == null))?null:m);
var m__9542__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9542__auto__.call(null,m,ch));
} else {
var m__9542__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9542__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__9541__auto__ = (((m == null))?null:m);
var m__9542__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9542__auto__.call(null,m,ch));
} else {
var m__9542__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9542__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__9541__auto__ = (((m == null))?null:m);
var m__9542__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__9542__auto__.call(null,m));
} else {
var m__9542__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__9542__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__9541__auto__ = (((m == null))?null:m);
var m__9542__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__9542__auto__.call(null,m,state_map));
} else {
var m__9542__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__9542__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__9541__auto__ = (((m == null))?null:m);
var m__9542__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__9542__auto__.call(null,m,mode));
} else {
var m__9542__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__9542__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__10094__auto__ = [];
var len__10087__auto___17784 = arguments.length;
var i__10088__auto___17785 = (0);
while(true){
if((i__10088__auto___17785 < len__10087__auto___17784)){
args__10094__auto__.push((arguments[i__10088__auto___17785]));

var G__17786 = (i__10088__auto___17785 + (1));
i__10088__auto___17785 = G__17786;
continue;
} else {
}
break;
}

var argseq__10095__auto__ = ((((3) < args__10094__auto__.length))?(new cljs.core.IndexedSeq(args__10094__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10095__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__17778){
var map__17779 = p__17778;
var map__17779__$1 = ((((!((map__17779 == null)))?((((map__17779.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17779.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17779):map__17779);
var opts = map__17779__$1;
var statearr_17781_17787 = state;
(statearr_17781_17787[(1)] = cont_block);


var temp__5457__auto__ = cljs.core.async.do_alts(((function (map__17779,map__17779__$1,opts){
return (function (val){
var statearr_17782_17788 = state;
(statearr_17782_17788[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__17779,map__17779__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5457__auto__)){
var cb = temp__5457__auto__;
var statearr_17783_17789 = state;
(statearr_17783_17789[(2)] = cljs.core.deref(cb));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq17774){
var G__17775 = cljs.core.first(seq17774);
var seq17774__$1 = cljs.core.next(seq17774);
var G__17776 = cljs.core.first(seq17774__$1);
var seq17774__$2 = cljs.core.next(seq17774__$1);
var G__17777 = cljs.core.first(seq17774__$2);
var seq17774__$3 = cljs.core.next(seq17774__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17775,G__17776,G__17777,seq17774__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute);
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async17790 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17790 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta17791){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta17791 = meta17791;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17790.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_17792,meta17791__$1){
var self__ = this;
var _17792__$1 = this;
return (new cljs.core.async.t_cljs$core$async17790(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta17791__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17790.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_17792){
var self__ = this;
var _17792__$1 = this;
return self__.meta17791;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17790.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17790.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17790.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17790.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17790.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17790.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17790.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17790.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17790.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out,cljs.core.cst$sym$cs,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$change,cljs.core.cst$sym$changed,cljs.core.cst$sym$pick,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$meta17791], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17790.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17790.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17790";

cljs.core.async.t_cljs$core$async17790.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__9479__auto__,writer__9480__auto__,opt__9481__auto__){
return cljs.core._write(writer__9480__auto__,"cljs.core.async/t_cljs$core$async17790");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async17790 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async17790(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta17791){
return (new cljs.core.async.t_cljs$core$async17790(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta17791));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async17790(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__16893__auto___17954 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16893__auto___17954,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__16894__auto__ = (function (){var switch__16791__auto__ = ((function (c__16893__auto___17954,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_17894){
var state_val_17895 = (state_17894[(1)]);
if((state_val_17895 === (7))){
var inst_17809 = (state_17894[(2)]);
var state_17894__$1 = state_17894;
var statearr_17896_17955 = state_17894__$1;
(statearr_17896_17955[(2)] = inst_17809);

(statearr_17896_17955[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (20))){
var inst_17821 = (state_17894[(7)]);
var state_17894__$1 = state_17894;
var statearr_17897_17956 = state_17894__$1;
(statearr_17897_17956[(2)] = inst_17821);

(statearr_17897_17956[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (27))){
var state_17894__$1 = state_17894;
var statearr_17898_17957 = state_17894__$1;
(statearr_17898_17957[(2)] = null);

(statearr_17898_17957[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (1))){
var inst_17796 = (state_17894[(8)]);
var inst_17796__$1 = calc_state();
var inst_17798 = (inst_17796__$1 == null);
var inst_17799 = cljs.core.not(inst_17798);
var state_17894__$1 = (function (){var statearr_17899 = state_17894;
(statearr_17899[(8)] = inst_17796__$1);

return statearr_17899;
})();
if(inst_17799){
var statearr_17900_17958 = state_17894__$1;
(statearr_17900_17958[(1)] = (2));

} else {
var statearr_17901_17959 = state_17894__$1;
(statearr_17901_17959[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (24))){
var inst_17868 = (state_17894[(9)]);
var inst_17854 = (state_17894[(10)]);
var inst_17845 = (state_17894[(11)]);
var inst_17868__$1 = (inst_17845.cljs$core$IFn$_invoke$arity$1 ? inst_17845.cljs$core$IFn$_invoke$arity$1(inst_17854) : inst_17845.call(null,inst_17854));
var state_17894__$1 = (function (){var statearr_17902 = state_17894;
(statearr_17902[(9)] = inst_17868__$1);

return statearr_17902;
})();
if(cljs.core.truth_(inst_17868__$1)){
var statearr_17903_17960 = state_17894__$1;
(statearr_17903_17960[(1)] = (29));

} else {
var statearr_17904_17961 = state_17894__$1;
(statearr_17904_17961[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (4))){
var inst_17812 = (state_17894[(2)]);
var state_17894__$1 = state_17894;
if(cljs.core.truth_(inst_17812)){
var statearr_17905_17962 = state_17894__$1;
(statearr_17905_17962[(1)] = (8));

} else {
var statearr_17906_17963 = state_17894__$1;
(statearr_17906_17963[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (15))){
var inst_17839 = (state_17894[(2)]);
var state_17894__$1 = state_17894;
if(cljs.core.truth_(inst_17839)){
var statearr_17907_17964 = state_17894__$1;
(statearr_17907_17964[(1)] = (19));

} else {
var statearr_17908_17965 = state_17894__$1;
(statearr_17908_17965[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (21))){
var inst_17844 = (state_17894[(12)]);
var inst_17844__$1 = (state_17894[(2)]);
var inst_17845 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17844__$1,cljs.core.cst$kw$solos);
var inst_17846 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17844__$1,cljs.core.cst$kw$mutes);
var inst_17847 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17844__$1,cljs.core.cst$kw$reads);
var state_17894__$1 = (function (){var statearr_17909 = state_17894;
(statearr_17909[(13)] = inst_17846);

(statearr_17909[(12)] = inst_17844__$1);

(statearr_17909[(11)] = inst_17845);

return statearr_17909;
})();
return cljs.core.async.ioc_alts_BANG_(state_17894__$1,(22),inst_17847);
} else {
if((state_val_17895 === (31))){
var inst_17876 = (state_17894[(2)]);
var state_17894__$1 = state_17894;
if(cljs.core.truth_(inst_17876)){
var statearr_17910_17966 = state_17894__$1;
(statearr_17910_17966[(1)] = (32));

} else {
var statearr_17911_17967 = state_17894__$1;
(statearr_17911_17967[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (32))){
var inst_17853 = (state_17894[(14)]);
var state_17894__$1 = state_17894;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17894__$1,(35),out,inst_17853);
} else {
if((state_val_17895 === (33))){
var inst_17844 = (state_17894[(12)]);
var inst_17821 = inst_17844;
var state_17894__$1 = (function (){var statearr_17912 = state_17894;
(statearr_17912[(7)] = inst_17821);

return statearr_17912;
})();
var statearr_17913_17968 = state_17894__$1;
(statearr_17913_17968[(2)] = null);

(statearr_17913_17968[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (13))){
var inst_17821 = (state_17894[(7)]);
var inst_17828 = inst_17821.cljs$lang$protocol_mask$partition0$;
var inst_17829 = (inst_17828 & (64));
var inst_17830 = inst_17821.cljs$core$ISeq$;
var inst_17831 = (cljs.core.PROTOCOL_SENTINEL === inst_17830);
var inst_17832 = (inst_17829) || (inst_17831);
var state_17894__$1 = state_17894;
if(cljs.core.truth_(inst_17832)){
var statearr_17914_17969 = state_17894__$1;
(statearr_17914_17969[(1)] = (16));

} else {
var statearr_17915_17970 = state_17894__$1;
(statearr_17915_17970[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (22))){
var inst_17853 = (state_17894[(14)]);
var inst_17854 = (state_17894[(10)]);
var inst_17852 = (state_17894[(2)]);
var inst_17853__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17852,(0),null);
var inst_17854__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17852,(1),null);
var inst_17855 = (inst_17853__$1 == null);
var inst_17856 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17854__$1,change);
var inst_17857 = (inst_17855) || (inst_17856);
var state_17894__$1 = (function (){var statearr_17916 = state_17894;
(statearr_17916[(14)] = inst_17853__$1);

(statearr_17916[(10)] = inst_17854__$1);

return statearr_17916;
})();
if(cljs.core.truth_(inst_17857)){
var statearr_17917_17971 = state_17894__$1;
(statearr_17917_17971[(1)] = (23));

} else {
var statearr_17918_17972 = state_17894__$1;
(statearr_17918_17972[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (36))){
var inst_17844 = (state_17894[(12)]);
var inst_17821 = inst_17844;
var state_17894__$1 = (function (){var statearr_17919 = state_17894;
(statearr_17919[(7)] = inst_17821);

return statearr_17919;
})();
var statearr_17920_17973 = state_17894__$1;
(statearr_17920_17973[(2)] = null);

(statearr_17920_17973[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (29))){
var inst_17868 = (state_17894[(9)]);
var state_17894__$1 = state_17894;
var statearr_17921_17974 = state_17894__$1;
(statearr_17921_17974[(2)] = inst_17868);

(statearr_17921_17974[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (6))){
var state_17894__$1 = state_17894;
var statearr_17922_17975 = state_17894__$1;
(statearr_17922_17975[(2)] = false);

(statearr_17922_17975[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (28))){
var inst_17864 = (state_17894[(2)]);
var inst_17865 = calc_state();
var inst_17821 = inst_17865;
var state_17894__$1 = (function (){var statearr_17923 = state_17894;
(statearr_17923[(7)] = inst_17821);

(statearr_17923[(15)] = inst_17864);

return statearr_17923;
})();
var statearr_17924_17976 = state_17894__$1;
(statearr_17924_17976[(2)] = null);

(statearr_17924_17976[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (25))){
var inst_17890 = (state_17894[(2)]);
var state_17894__$1 = state_17894;
var statearr_17925_17977 = state_17894__$1;
(statearr_17925_17977[(2)] = inst_17890);

(statearr_17925_17977[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (34))){
var inst_17888 = (state_17894[(2)]);
var state_17894__$1 = state_17894;
var statearr_17926_17978 = state_17894__$1;
(statearr_17926_17978[(2)] = inst_17888);

(statearr_17926_17978[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (17))){
var state_17894__$1 = state_17894;
var statearr_17927_17979 = state_17894__$1;
(statearr_17927_17979[(2)] = false);

(statearr_17927_17979[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (3))){
var state_17894__$1 = state_17894;
var statearr_17928_17980 = state_17894__$1;
(statearr_17928_17980[(2)] = false);

(statearr_17928_17980[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (12))){
var inst_17892 = (state_17894[(2)]);
var state_17894__$1 = state_17894;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17894__$1,inst_17892);
} else {
if((state_val_17895 === (2))){
var inst_17796 = (state_17894[(8)]);
var inst_17801 = inst_17796.cljs$lang$protocol_mask$partition0$;
var inst_17802 = (inst_17801 & (64));
var inst_17803 = inst_17796.cljs$core$ISeq$;
var inst_17804 = (cljs.core.PROTOCOL_SENTINEL === inst_17803);
var inst_17805 = (inst_17802) || (inst_17804);
var state_17894__$1 = state_17894;
if(cljs.core.truth_(inst_17805)){
var statearr_17929_17981 = state_17894__$1;
(statearr_17929_17981[(1)] = (5));

} else {
var statearr_17930_17982 = state_17894__$1;
(statearr_17930_17982[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (23))){
var inst_17853 = (state_17894[(14)]);
var inst_17859 = (inst_17853 == null);
var state_17894__$1 = state_17894;
if(cljs.core.truth_(inst_17859)){
var statearr_17931_17983 = state_17894__$1;
(statearr_17931_17983[(1)] = (26));

} else {
var statearr_17932_17984 = state_17894__$1;
(statearr_17932_17984[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (35))){
var inst_17879 = (state_17894[(2)]);
var state_17894__$1 = state_17894;
if(cljs.core.truth_(inst_17879)){
var statearr_17933_17985 = state_17894__$1;
(statearr_17933_17985[(1)] = (36));

} else {
var statearr_17934_17986 = state_17894__$1;
(statearr_17934_17986[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (19))){
var inst_17821 = (state_17894[(7)]);
var inst_17841 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_17821);
var state_17894__$1 = state_17894;
var statearr_17935_17987 = state_17894__$1;
(statearr_17935_17987[(2)] = inst_17841);

(statearr_17935_17987[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (11))){
var inst_17821 = (state_17894[(7)]);
var inst_17825 = (inst_17821 == null);
var inst_17826 = cljs.core.not(inst_17825);
var state_17894__$1 = state_17894;
if(inst_17826){
var statearr_17936_17988 = state_17894__$1;
(statearr_17936_17988[(1)] = (13));

} else {
var statearr_17937_17989 = state_17894__$1;
(statearr_17937_17989[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (9))){
var inst_17796 = (state_17894[(8)]);
var state_17894__$1 = state_17894;
var statearr_17938_17990 = state_17894__$1;
(statearr_17938_17990[(2)] = inst_17796);

(statearr_17938_17990[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (5))){
var state_17894__$1 = state_17894;
var statearr_17939_17991 = state_17894__$1;
(statearr_17939_17991[(2)] = true);

(statearr_17939_17991[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (14))){
var state_17894__$1 = state_17894;
var statearr_17940_17992 = state_17894__$1;
(statearr_17940_17992[(2)] = false);

(statearr_17940_17992[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (26))){
var inst_17854 = (state_17894[(10)]);
var inst_17861 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_17854);
var state_17894__$1 = state_17894;
var statearr_17941_17993 = state_17894__$1;
(statearr_17941_17993[(2)] = inst_17861);

(statearr_17941_17993[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (16))){
var state_17894__$1 = state_17894;
var statearr_17942_17994 = state_17894__$1;
(statearr_17942_17994[(2)] = true);

(statearr_17942_17994[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (38))){
var inst_17884 = (state_17894[(2)]);
var state_17894__$1 = state_17894;
var statearr_17943_17995 = state_17894__$1;
(statearr_17943_17995[(2)] = inst_17884);

(statearr_17943_17995[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (30))){
var inst_17846 = (state_17894[(13)]);
var inst_17854 = (state_17894[(10)]);
var inst_17845 = (state_17894[(11)]);
var inst_17871 = cljs.core.empty_QMARK_(inst_17845);
var inst_17872 = (inst_17846.cljs$core$IFn$_invoke$arity$1 ? inst_17846.cljs$core$IFn$_invoke$arity$1(inst_17854) : inst_17846.call(null,inst_17854));
var inst_17873 = cljs.core.not(inst_17872);
var inst_17874 = (inst_17871) && (inst_17873);
var state_17894__$1 = state_17894;
var statearr_17944_17996 = state_17894__$1;
(statearr_17944_17996[(2)] = inst_17874);

(statearr_17944_17996[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (10))){
var inst_17796 = (state_17894[(8)]);
var inst_17817 = (state_17894[(2)]);
var inst_17818 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17817,cljs.core.cst$kw$solos);
var inst_17819 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17817,cljs.core.cst$kw$mutes);
var inst_17820 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17817,cljs.core.cst$kw$reads);
var inst_17821 = inst_17796;
var state_17894__$1 = (function (){var statearr_17945 = state_17894;
(statearr_17945[(7)] = inst_17821);

(statearr_17945[(16)] = inst_17819);

(statearr_17945[(17)] = inst_17820);

(statearr_17945[(18)] = inst_17818);

return statearr_17945;
})();
var statearr_17946_17997 = state_17894__$1;
(statearr_17946_17997[(2)] = null);

(statearr_17946_17997[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (18))){
var inst_17836 = (state_17894[(2)]);
var state_17894__$1 = state_17894;
var statearr_17947_17998 = state_17894__$1;
(statearr_17947_17998[(2)] = inst_17836);

(statearr_17947_17998[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (37))){
var state_17894__$1 = state_17894;
var statearr_17948_17999 = state_17894__$1;
(statearr_17948_17999[(2)] = null);

(statearr_17948_17999[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17895 === (8))){
var inst_17796 = (state_17894[(8)]);
var inst_17814 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_17796);
var state_17894__$1 = state_17894;
var statearr_17949_18000 = state_17894__$1;
(statearr_17949_18000[(2)] = inst_17814);

(statearr_17949_18000[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16893__auto___17954,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__16791__auto__,c__16893__auto___17954,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__16792__auto__ = null;
var cljs$core$async$mix_$_state_machine__16792__auto____0 = (function (){
var statearr_17950 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17950[(0)] = cljs$core$async$mix_$_state_machine__16792__auto__);

(statearr_17950[(1)] = (1));

return statearr_17950;
});
var cljs$core$async$mix_$_state_machine__16792__auto____1 = (function (state_17894){
while(true){
var ret_value__16793__auto__ = (function (){try{while(true){
var result__16794__auto__ = switch__16791__auto__(state_17894);
if(cljs.core.keyword_identical_QMARK_(result__16794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16794__auto__;
}
break;
}
}catch (e17951){if((e17951 instanceof Object)){
var ex__16795__auto__ = e17951;
var statearr_17952_18001 = state_17894;
(statearr_17952_18001[(5)] = ex__16795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17894);

return cljs.core.cst$kw$recur;
} else {
throw e17951;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16793__auto__,cljs.core.cst$kw$recur)){
var G__18002 = state_17894;
state_17894 = G__18002;
continue;
} else {
return ret_value__16793__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__16792__auto__ = function(state_17894){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__16792__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__16792__auto____1.call(this,state_17894);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__16792__auto____0;
cljs$core$async$mix_$_state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__16792__auto____1;
return cljs$core$async$mix_$_state_machine__16792__auto__;
})()
;})(switch__16791__auto__,c__16893__auto___17954,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__16895__auto__ = (function (){var statearr_17953 = (f__16894__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16894__auto__.cljs$core$IFn$_invoke$arity$0() : f__16894__auto__.call(null));
(statearr_17953[(6)] = c__16893__auto___17954);

return statearr_17953;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16895__auto__);
});})(c__16893__auto___17954,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__9541__auto__ = (((p == null))?null:p);
var m__9542__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$4 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__9542__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__9542__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__9542__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__9541__auto__ = (((p == null))?null:p);
var m__9542__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__9542__auto__.call(null,p,v,ch));
} else {
var m__9542__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__9542__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__18004 = arguments.length;
switch (G__18004) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__9541__auto__ = (((p == null))?null:p);
var m__9542__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__9542__auto__.call(null,p));
} else {
var m__9542__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__9542__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__9541__auto__ = (((p == null))?null:p);
var m__9542__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__9542__auto__.call(null,p,v));
} else {
var m__9542__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__9542__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__18008 = arguments.length;
switch (G__18008) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__8808__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__8808__auto__)){
return or__8808__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__8808__auto__,mults){
return (function (p1__18006_SHARP_){
if(cljs.core.truth_((p1__18006_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__18006_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__18006_SHARP_.call(null,topic)))){
return p1__18006_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__18006_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__8808__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async18009 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18009 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta18010){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta18010 = meta18010;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18009.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_18011,meta18010__$1){
var self__ = this;
var _18011__$1 = this;
return (new cljs.core.async.t_cljs$core$async18009(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta18010__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18009.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_18011){
var self__ = this;
var _18011__$1 = this;
return self__.meta18010;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18009.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18009.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18009.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18009.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18009.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5457__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5457__auto__)){
var m = temp__5457__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18009.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18009.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18009.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta18010], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18009.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18009.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18009";

cljs.core.async.t_cljs$core$async18009.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__9479__auto__,writer__9480__auto__,opt__9481__auto__){
return cljs.core._write(writer__9480__auto__,"cljs.core.async/t_cljs$core$async18009");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async18009 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async18009(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta18010){
return (new cljs.core.async.t_cljs$core$async18009(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta18010));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async18009(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__16893__auto___18129 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16893__auto___18129,mults,ensure_mult,p){
return (function (){
var f__16894__auto__ = (function (){var switch__16791__auto__ = ((function (c__16893__auto___18129,mults,ensure_mult,p){
return (function (state_18083){
var state_val_18084 = (state_18083[(1)]);
if((state_val_18084 === (7))){
var inst_18079 = (state_18083[(2)]);
var state_18083__$1 = state_18083;
var statearr_18085_18130 = state_18083__$1;
(statearr_18085_18130[(2)] = inst_18079);

(statearr_18085_18130[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18084 === (20))){
var state_18083__$1 = state_18083;
var statearr_18086_18131 = state_18083__$1;
(statearr_18086_18131[(2)] = null);

(statearr_18086_18131[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18084 === (1))){
var state_18083__$1 = state_18083;
var statearr_18087_18132 = state_18083__$1;
(statearr_18087_18132[(2)] = null);

(statearr_18087_18132[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18084 === (24))){
var inst_18062 = (state_18083[(7)]);
var inst_18071 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_18062);
var state_18083__$1 = state_18083;
var statearr_18088_18133 = state_18083__$1;
(statearr_18088_18133[(2)] = inst_18071);

(statearr_18088_18133[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18084 === (4))){
var inst_18014 = (state_18083[(8)]);
var inst_18014__$1 = (state_18083[(2)]);
var inst_18015 = (inst_18014__$1 == null);
var state_18083__$1 = (function (){var statearr_18089 = state_18083;
(statearr_18089[(8)] = inst_18014__$1);

return statearr_18089;
})();
if(cljs.core.truth_(inst_18015)){
var statearr_18090_18134 = state_18083__$1;
(statearr_18090_18134[(1)] = (5));

} else {
var statearr_18091_18135 = state_18083__$1;
(statearr_18091_18135[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18084 === (15))){
var inst_18056 = (state_18083[(2)]);
var state_18083__$1 = state_18083;
var statearr_18092_18136 = state_18083__$1;
(statearr_18092_18136[(2)] = inst_18056);

(statearr_18092_18136[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18084 === (21))){
var inst_18076 = (state_18083[(2)]);
var state_18083__$1 = (function (){var statearr_18093 = state_18083;
(statearr_18093[(9)] = inst_18076);

return statearr_18093;
})();
var statearr_18094_18137 = state_18083__$1;
(statearr_18094_18137[(2)] = null);

(statearr_18094_18137[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18084 === (13))){
var inst_18038 = (state_18083[(10)]);
var inst_18040 = cljs.core.chunked_seq_QMARK_(inst_18038);
var state_18083__$1 = state_18083;
if(inst_18040){
var statearr_18095_18138 = state_18083__$1;
(statearr_18095_18138[(1)] = (16));

} else {
var statearr_18096_18139 = state_18083__$1;
(statearr_18096_18139[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18084 === (22))){
var inst_18068 = (state_18083[(2)]);
var state_18083__$1 = state_18083;
if(cljs.core.truth_(inst_18068)){
var statearr_18097_18140 = state_18083__$1;
(statearr_18097_18140[(1)] = (23));

} else {
var statearr_18098_18141 = state_18083__$1;
(statearr_18098_18141[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18084 === (6))){
var inst_18014 = (state_18083[(8)]);
var inst_18062 = (state_18083[(7)]);
var inst_18064 = (state_18083[(11)]);
var inst_18062__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_18014) : topic_fn.call(null,inst_18014));
var inst_18063 = cljs.core.deref(mults);
var inst_18064__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18063,inst_18062__$1);
var state_18083__$1 = (function (){var statearr_18099 = state_18083;
(statearr_18099[(7)] = inst_18062__$1);

(statearr_18099[(11)] = inst_18064__$1);

return statearr_18099;
})();
if(cljs.core.truth_(inst_18064__$1)){
var statearr_18100_18142 = state_18083__$1;
(statearr_18100_18142[(1)] = (19));

} else {
var statearr_18101_18143 = state_18083__$1;
(statearr_18101_18143[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18084 === (25))){
var inst_18073 = (state_18083[(2)]);
var state_18083__$1 = state_18083;
var statearr_18102_18144 = state_18083__$1;
(statearr_18102_18144[(2)] = inst_18073);

(statearr_18102_18144[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18084 === (17))){
var inst_18038 = (state_18083[(10)]);
var inst_18047 = cljs.core.first(inst_18038);
var inst_18048 = cljs.core.async.muxch_STAR_(inst_18047);
var inst_18049 = cljs.core.async.close_BANG_(inst_18048);
var inst_18050 = cljs.core.next(inst_18038);
var inst_18024 = inst_18050;
var inst_18025 = null;
var inst_18026 = (0);
var inst_18027 = (0);
var state_18083__$1 = (function (){var statearr_18103 = state_18083;
(statearr_18103[(12)] = inst_18026);

(statearr_18103[(13)] = inst_18027);

(statearr_18103[(14)] = inst_18024);

(statearr_18103[(15)] = inst_18025);

(statearr_18103[(16)] = inst_18049);

return statearr_18103;
})();
var statearr_18104_18145 = state_18083__$1;
(statearr_18104_18145[(2)] = null);

(statearr_18104_18145[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18084 === (3))){
var inst_18081 = (state_18083[(2)]);
var state_18083__$1 = state_18083;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18083__$1,inst_18081);
} else {
if((state_val_18084 === (12))){
var inst_18058 = (state_18083[(2)]);
var state_18083__$1 = state_18083;
var statearr_18105_18146 = state_18083__$1;
(statearr_18105_18146[(2)] = inst_18058);

(statearr_18105_18146[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18084 === (2))){
var state_18083__$1 = state_18083;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18083__$1,(4),ch);
} else {
if((state_val_18084 === (23))){
var state_18083__$1 = state_18083;
var statearr_18106_18147 = state_18083__$1;
(statearr_18106_18147[(2)] = null);

(statearr_18106_18147[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18084 === (19))){
var inst_18014 = (state_18083[(8)]);
var inst_18064 = (state_18083[(11)]);
var inst_18066 = cljs.core.async.muxch_STAR_(inst_18064);
var state_18083__$1 = state_18083;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18083__$1,(22),inst_18066,inst_18014);
} else {
if((state_val_18084 === (11))){
var inst_18024 = (state_18083[(14)]);
var inst_18038 = (state_18083[(10)]);
var inst_18038__$1 = cljs.core.seq(inst_18024);
var state_18083__$1 = (function (){var statearr_18107 = state_18083;
(statearr_18107[(10)] = inst_18038__$1);

return statearr_18107;
})();
if(inst_18038__$1){
var statearr_18108_18148 = state_18083__$1;
(statearr_18108_18148[(1)] = (13));

} else {
var statearr_18109_18149 = state_18083__$1;
(statearr_18109_18149[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18084 === (9))){
var inst_18060 = (state_18083[(2)]);
var state_18083__$1 = state_18083;
var statearr_18110_18150 = state_18083__$1;
(statearr_18110_18150[(2)] = inst_18060);

(statearr_18110_18150[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18084 === (5))){
var inst_18021 = cljs.core.deref(mults);
var inst_18022 = cljs.core.vals(inst_18021);
var inst_18023 = cljs.core.seq(inst_18022);
var inst_18024 = inst_18023;
var inst_18025 = null;
var inst_18026 = (0);
var inst_18027 = (0);
var state_18083__$1 = (function (){var statearr_18111 = state_18083;
(statearr_18111[(12)] = inst_18026);

(statearr_18111[(13)] = inst_18027);

(statearr_18111[(14)] = inst_18024);

(statearr_18111[(15)] = inst_18025);

return statearr_18111;
})();
var statearr_18112_18151 = state_18083__$1;
(statearr_18112_18151[(2)] = null);

(statearr_18112_18151[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18084 === (14))){
var state_18083__$1 = state_18083;
var statearr_18116_18152 = state_18083__$1;
(statearr_18116_18152[(2)] = null);

(statearr_18116_18152[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18084 === (16))){
var inst_18038 = (state_18083[(10)]);
var inst_18042 = cljs.core.chunk_first(inst_18038);
var inst_18043 = cljs.core.chunk_rest(inst_18038);
var inst_18044 = cljs.core.count(inst_18042);
var inst_18024 = inst_18043;
var inst_18025 = inst_18042;
var inst_18026 = inst_18044;
var inst_18027 = (0);
var state_18083__$1 = (function (){var statearr_18117 = state_18083;
(statearr_18117[(12)] = inst_18026);

(statearr_18117[(13)] = inst_18027);

(statearr_18117[(14)] = inst_18024);

(statearr_18117[(15)] = inst_18025);

return statearr_18117;
})();
var statearr_18118_18153 = state_18083__$1;
(statearr_18118_18153[(2)] = null);

(statearr_18118_18153[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18084 === (10))){
var inst_18026 = (state_18083[(12)]);
var inst_18027 = (state_18083[(13)]);
var inst_18024 = (state_18083[(14)]);
var inst_18025 = (state_18083[(15)]);
var inst_18032 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_18025,inst_18027);
var inst_18033 = cljs.core.async.muxch_STAR_(inst_18032);
var inst_18034 = cljs.core.async.close_BANG_(inst_18033);
var inst_18035 = (inst_18027 + (1));
var tmp18113 = inst_18026;
var tmp18114 = inst_18024;
var tmp18115 = inst_18025;
var inst_18024__$1 = tmp18114;
var inst_18025__$1 = tmp18115;
var inst_18026__$1 = tmp18113;
var inst_18027__$1 = inst_18035;
var state_18083__$1 = (function (){var statearr_18119 = state_18083;
(statearr_18119[(12)] = inst_18026__$1);

(statearr_18119[(13)] = inst_18027__$1);

(statearr_18119[(14)] = inst_18024__$1);

(statearr_18119[(17)] = inst_18034);

(statearr_18119[(15)] = inst_18025__$1);

return statearr_18119;
})();
var statearr_18120_18154 = state_18083__$1;
(statearr_18120_18154[(2)] = null);

(statearr_18120_18154[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18084 === (18))){
var inst_18053 = (state_18083[(2)]);
var state_18083__$1 = state_18083;
var statearr_18121_18155 = state_18083__$1;
(statearr_18121_18155[(2)] = inst_18053);

(statearr_18121_18155[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18084 === (8))){
var inst_18026 = (state_18083[(12)]);
var inst_18027 = (state_18083[(13)]);
var inst_18029 = (inst_18027 < inst_18026);
var inst_18030 = inst_18029;
var state_18083__$1 = state_18083;
if(cljs.core.truth_(inst_18030)){
var statearr_18122_18156 = state_18083__$1;
(statearr_18122_18156[(1)] = (10));

} else {
var statearr_18123_18157 = state_18083__$1;
(statearr_18123_18157[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16893__auto___18129,mults,ensure_mult,p))
;
return ((function (switch__16791__auto__,c__16893__auto___18129,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__16792__auto__ = null;
var cljs$core$async$state_machine__16792__auto____0 = (function (){
var statearr_18124 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18124[(0)] = cljs$core$async$state_machine__16792__auto__);

(statearr_18124[(1)] = (1));

return statearr_18124;
});
var cljs$core$async$state_machine__16792__auto____1 = (function (state_18083){
while(true){
var ret_value__16793__auto__ = (function (){try{while(true){
var result__16794__auto__ = switch__16791__auto__(state_18083);
if(cljs.core.keyword_identical_QMARK_(result__16794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16794__auto__;
}
break;
}
}catch (e18125){if((e18125 instanceof Object)){
var ex__16795__auto__ = e18125;
var statearr_18126_18158 = state_18083;
(statearr_18126_18158[(5)] = ex__16795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18083);

return cljs.core.cst$kw$recur;
} else {
throw e18125;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16793__auto__,cljs.core.cst$kw$recur)){
var G__18159 = state_18083;
state_18083 = G__18159;
continue;
} else {
return ret_value__16793__auto__;
}
break;
}
});
cljs$core$async$state_machine__16792__auto__ = function(state_18083){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16792__auto____1.call(this,state_18083);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16792__auto____0;
cljs$core$async$state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16792__auto____1;
return cljs$core$async$state_machine__16792__auto__;
})()
;})(switch__16791__auto__,c__16893__auto___18129,mults,ensure_mult,p))
})();
var state__16895__auto__ = (function (){var statearr_18127 = (f__16894__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16894__auto__.cljs$core$IFn$_invoke$arity$0() : f__16894__auto__.call(null));
(statearr_18127[(6)] = c__16893__auto___18129);

return statearr_18127;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16895__auto__);
});})(c__16893__auto___18129,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__18161 = arguments.length;
switch (G__18161) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__18164 = arguments.length;
switch (G__18164) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__18167 = arguments.length;
switch (G__18167) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__16893__auto___18234 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16893__auto___18234,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__16894__auto__ = (function (){var switch__16791__auto__ = ((function (c__16893__auto___18234,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_18206){
var state_val_18207 = (state_18206[(1)]);
if((state_val_18207 === (7))){
var state_18206__$1 = state_18206;
var statearr_18208_18235 = state_18206__$1;
(statearr_18208_18235[(2)] = null);

(statearr_18208_18235[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18207 === (1))){
var state_18206__$1 = state_18206;
var statearr_18209_18236 = state_18206__$1;
(statearr_18209_18236[(2)] = null);

(statearr_18209_18236[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18207 === (4))){
var inst_18170 = (state_18206[(7)]);
var inst_18172 = (inst_18170 < cnt);
var state_18206__$1 = state_18206;
if(cljs.core.truth_(inst_18172)){
var statearr_18210_18237 = state_18206__$1;
(statearr_18210_18237[(1)] = (6));

} else {
var statearr_18211_18238 = state_18206__$1;
(statearr_18211_18238[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18207 === (15))){
var inst_18202 = (state_18206[(2)]);
var state_18206__$1 = state_18206;
var statearr_18212_18239 = state_18206__$1;
(statearr_18212_18239[(2)] = inst_18202);

(statearr_18212_18239[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18207 === (13))){
var inst_18195 = cljs.core.async.close_BANG_(out);
var state_18206__$1 = state_18206;
var statearr_18213_18240 = state_18206__$1;
(statearr_18213_18240[(2)] = inst_18195);

(statearr_18213_18240[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18207 === (6))){
var state_18206__$1 = state_18206;
var statearr_18214_18241 = state_18206__$1;
(statearr_18214_18241[(2)] = null);

(statearr_18214_18241[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18207 === (3))){
var inst_18204 = (state_18206[(2)]);
var state_18206__$1 = state_18206;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18206__$1,inst_18204);
} else {
if((state_val_18207 === (12))){
var inst_18192 = (state_18206[(8)]);
var inst_18192__$1 = (state_18206[(2)]);
var inst_18193 = cljs.core.some(cljs.core.nil_QMARK_,inst_18192__$1);
var state_18206__$1 = (function (){var statearr_18215 = state_18206;
(statearr_18215[(8)] = inst_18192__$1);

return statearr_18215;
})();
if(cljs.core.truth_(inst_18193)){
var statearr_18216_18242 = state_18206__$1;
(statearr_18216_18242[(1)] = (13));

} else {
var statearr_18217_18243 = state_18206__$1;
(statearr_18217_18243[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18207 === (2))){
var inst_18169 = cljs.core.reset_BANG_(dctr,cnt);
var inst_18170 = (0);
var state_18206__$1 = (function (){var statearr_18218 = state_18206;
(statearr_18218[(9)] = inst_18169);

(statearr_18218[(7)] = inst_18170);

return statearr_18218;
})();
var statearr_18219_18244 = state_18206__$1;
(statearr_18219_18244[(2)] = null);

(statearr_18219_18244[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18207 === (11))){
var inst_18170 = (state_18206[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_18206,(10),Object,null,(9));
var inst_18179 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_18170) : chs__$1.call(null,inst_18170));
var inst_18180 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_18170) : done.call(null,inst_18170));
var inst_18181 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_18179,inst_18180);
var state_18206__$1 = state_18206;
var statearr_18220_18245 = state_18206__$1;
(statearr_18220_18245[(2)] = inst_18181);


cljs.core.async.impl.ioc_helpers.process_exception(state_18206__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_18207 === (9))){
var inst_18170 = (state_18206[(7)]);
var inst_18183 = (state_18206[(2)]);
var inst_18184 = (inst_18170 + (1));
var inst_18170__$1 = inst_18184;
var state_18206__$1 = (function (){var statearr_18221 = state_18206;
(statearr_18221[(10)] = inst_18183);

(statearr_18221[(7)] = inst_18170__$1);

return statearr_18221;
})();
var statearr_18222_18246 = state_18206__$1;
(statearr_18222_18246[(2)] = null);

(statearr_18222_18246[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18207 === (5))){
var inst_18190 = (state_18206[(2)]);
var state_18206__$1 = (function (){var statearr_18223 = state_18206;
(statearr_18223[(11)] = inst_18190);

return statearr_18223;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18206__$1,(12),dchan);
} else {
if((state_val_18207 === (14))){
var inst_18192 = (state_18206[(8)]);
var inst_18197 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_18192);
var state_18206__$1 = state_18206;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18206__$1,(16),out,inst_18197);
} else {
if((state_val_18207 === (16))){
var inst_18199 = (state_18206[(2)]);
var state_18206__$1 = (function (){var statearr_18224 = state_18206;
(statearr_18224[(12)] = inst_18199);

return statearr_18224;
})();
var statearr_18225_18247 = state_18206__$1;
(statearr_18225_18247[(2)] = null);

(statearr_18225_18247[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18207 === (10))){
var inst_18174 = (state_18206[(2)]);
var inst_18175 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_18206__$1 = (function (){var statearr_18226 = state_18206;
(statearr_18226[(13)] = inst_18174);

return statearr_18226;
})();
var statearr_18227_18248 = state_18206__$1;
(statearr_18227_18248[(2)] = inst_18175);


cljs.core.async.impl.ioc_helpers.process_exception(state_18206__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_18207 === (8))){
var inst_18188 = (state_18206[(2)]);
var state_18206__$1 = state_18206;
var statearr_18228_18249 = state_18206__$1;
(statearr_18228_18249[(2)] = inst_18188);

(statearr_18228_18249[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16893__auto___18234,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__16791__auto__,c__16893__auto___18234,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__16792__auto__ = null;
var cljs$core$async$state_machine__16792__auto____0 = (function (){
var statearr_18229 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18229[(0)] = cljs$core$async$state_machine__16792__auto__);

(statearr_18229[(1)] = (1));

return statearr_18229;
});
var cljs$core$async$state_machine__16792__auto____1 = (function (state_18206){
while(true){
var ret_value__16793__auto__ = (function (){try{while(true){
var result__16794__auto__ = switch__16791__auto__(state_18206);
if(cljs.core.keyword_identical_QMARK_(result__16794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16794__auto__;
}
break;
}
}catch (e18230){if((e18230 instanceof Object)){
var ex__16795__auto__ = e18230;
var statearr_18231_18250 = state_18206;
(statearr_18231_18250[(5)] = ex__16795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18206);

return cljs.core.cst$kw$recur;
} else {
throw e18230;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16793__auto__,cljs.core.cst$kw$recur)){
var G__18251 = state_18206;
state_18206 = G__18251;
continue;
} else {
return ret_value__16793__auto__;
}
break;
}
});
cljs$core$async$state_machine__16792__auto__ = function(state_18206){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16792__auto____1.call(this,state_18206);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16792__auto____0;
cljs$core$async$state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16792__auto____1;
return cljs$core$async$state_machine__16792__auto__;
})()
;})(switch__16791__auto__,c__16893__auto___18234,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__16895__auto__ = (function (){var statearr_18232 = (f__16894__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16894__auto__.cljs$core$IFn$_invoke$arity$0() : f__16894__auto__.call(null));
(statearr_18232[(6)] = c__16893__auto___18234);

return statearr_18232;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16895__auto__);
});})(c__16893__auto___18234,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__18254 = arguments.length;
switch (G__18254) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16893__auto___18308 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16893__auto___18308,out){
return (function (){
var f__16894__auto__ = (function (){var switch__16791__auto__ = ((function (c__16893__auto___18308,out){
return (function (state_18286){
var state_val_18287 = (state_18286[(1)]);
if((state_val_18287 === (7))){
var inst_18266 = (state_18286[(7)]);
var inst_18265 = (state_18286[(8)]);
var inst_18265__$1 = (state_18286[(2)]);
var inst_18266__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18265__$1,(0),null);
var inst_18267 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18265__$1,(1),null);
var inst_18268 = (inst_18266__$1 == null);
var state_18286__$1 = (function (){var statearr_18288 = state_18286;
(statearr_18288[(7)] = inst_18266__$1);

(statearr_18288[(8)] = inst_18265__$1);

(statearr_18288[(9)] = inst_18267);

return statearr_18288;
})();
if(cljs.core.truth_(inst_18268)){
var statearr_18289_18309 = state_18286__$1;
(statearr_18289_18309[(1)] = (8));

} else {
var statearr_18290_18310 = state_18286__$1;
(statearr_18290_18310[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18287 === (1))){
var inst_18255 = cljs.core.vec(chs);
var inst_18256 = inst_18255;
var state_18286__$1 = (function (){var statearr_18291 = state_18286;
(statearr_18291[(10)] = inst_18256);

return statearr_18291;
})();
var statearr_18292_18311 = state_18286__$1;
(statearr_18292_18311[(2)] = null);

(statearr_18292_18311[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18287 === (4))){
var inst_18256 = (state_18286[(10)]);
var state_18286__$1 = state_18286;
return cljs.core.async.ioc_alts_BANG_(state_18286__$1,(7),inst_18256);
} else {
if((state_val_18287 === (6))){
var inst_18282 = (state_18286[(2)]);
var state_18286__$1 = state_18286;
var statearr_18293_18312 = state_18286__$1;
(statearr_18293_18312[(2)] = inst_18282);

(statearr_18293_18312[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18287 === (3))){
var inst_18284 = (state_18286[(2)]);
var state_18286__$1 = state_18286;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18286__$1,inst_18284);
} else {
if((state_val_18287 === (2))){
var inst_18256 = (state_18286[(10)]);
var inst_18258 = cljs.core.count(inst_18256);
var inst_18259 = (inst_18258 > (0));
var state_18286__$1 = state_18286;
if(cljs.core.truth_(inst_18259)){
var statearr_18295_18313 = state_18286__$1;
(statearr_18295_18313[(1)] = (4));

} else {
var statearr_18296_18314 = state_18286__$1;
(statearr_18296_18314[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18287 === (11))){
var inst_18256 = (state_18286[(10)]);
var inst_18275 = (state_18286[(2)]);
var tmp18294 = inst_18256;
var inst_18256__$1 = tmp18294;
var state_18286__$1 = (function (){var statearr_18297 = state_18286;
(statearr_18297[(11)] = inst_18275);

(statearr_18297[(10)] = inst_18256__$1);

return statearr_18297;
})();
var statearr_18298_18315 = state_18286__$1;
(statearr_18298_18315[(2)] = null);

(statearr_18298_18315[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18287 === (9))){
var inst_18266 = (state_18286[(7)]);
var state_18286__$1 = state_18286;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18286__$1,(11),out,inst_18266);
} else {
if((state_val_18287 === (5))){
var inst_18280 = cljs.core.async.close_BANG_(out);
var state_18286__$1 = state_18286;
var statearr_18299_18316 = state_18286__$1;
(statearr_18299_18316[(2)] = inst_18280);

(statearr_18299_18316[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18287 === (10))){
var inst_18278 = (state_18286[(2)]);
var state_18286__$1 = state_18286;
var statearr_18300_18317 = state_18286__$1;
(statearr_18300_18317[(2)] = inst_18278);

(statearr_18300_18317[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18287 === (8))){
var inst_18266 = (state_18286[(7)]);
var inst_18265 = (state_18286[(8)]);
var inst_18256 = (state_18286[(10)]);
var inst_18267 = (state_18286[(9)]);
var inst_18270 = (function (){var cs = inst_18256;
var vec__18261 = inst_18265;
var v = inst_18266;
var c = inst_18267;
return ((function (cs,vec__18261,v,c,inst_18266,inst_18265,inst_18256,inst_18267,state_val_18287,c__16893__auto___18308,out){
return (function (p1__18252_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__18252_SHARP_);
});
;})(cs,vec__18261,v,c,inst_18266,inst_18265,inst_18256,inst_18267,state_val_18287,c__16893__auto___18308,out))
})();
var inst_18271 = cljs.core.filterv(inst_18270,inst_18256);
var inst_18256__$1 = inst_18271;
var state_18286__$1 = (function (){var statearr_18301 = state_18286;
(statearr_18301[(10)] = inst_18256__$1);

return statearr_18301;
})();
var statearr_18302_18318 = state_18286__$1;
(statearr_18302_18318[(2)] = null);

(statearr_18302_18318[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16893__auto___18308,out))
;
return ((function (switch__16791__auto__,c__16893__auto___18308,out){
return (function() {
var cljs$core$async$state_machine__16792__auto__ = null;
var cljs$core$async$state_machine__16792__auto____0 = (function (){
var statearr_18303 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18303[(0)] = cljs$core$async$state_machine__16792__auto__);

(statearr_18303[(1)] = (1));

return statearr_18303;
});
var cljs$core$async$state_machine__16792__auto____1 = (function (state_18286){
while(true){
var ret_value__16793__auto__ = (function (){try{while(true){
var result__16794__auto__ = switch__16791__auto__(state_18286);
if(cljs.core.keyword_identical_QMARK_(result__16794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16794__auto__;
}
break;
}
}catch (e18304){if((e18304 instanceof Object)){
var ex__16795__auto__ = e18304;
var statearr_18305_18319 = state_18286;
(statearr_18305_18319[(5)] = ex__16795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18286);

return cljs.core.cst$kw$recur;
} else {
throw e18304;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16793__auto__,cljs.core.cst$kw$recur)){
var G__18320 = state_18286;
state_18286 = G__18320;
continue;
} else {
return ret_value__16793__auto__;
}
break;
}
});
cljs$core$async$state_machine__16792__auto__ = function(state_18286){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16792__auto____1.call(this,state_18286);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16792__auto____0;
cljs$core$async$state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16792__auto____1;
return cljs$core$async$state_machine__16792__auto__;
})()
;})(switch__16791__auto__,c__16893__auto___18308,out))
})();
var state__16895__auto__ = (function (){var statearr_18306 = (f__16894__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16894__auto__.cljs$core$IFn$_invoke$arity$0() : f__16894__auto__.call(null));
(statearr_18306[(6)] = c__16893__auto___18308);

return statearr_18306;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16895__auto__);
});})(c__16893__auto___18308,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__18322 = arguments.length;
switch (G__18322) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16893__auto___18367 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16893__auto___18367,out){
return (function (){
var f__16894__auto__ = (function (){var switch__16791__auto__ = ((function (c__16893__auto___18367,out){
return (function (state_18346){
var state_val_18347 = (state_18346[(1)]);
if((state_val_18347 === (7))){
var inst_18328 = (state_18346[(7)]);
var inst_18328__$1 = (state_18346[(2)]);
var inst_18329 = (inst_18328__$1 == null);
var inst_18330 = cljs.core.not(inst_18329);
var state_18346__$1 = (function (){var statearr_18348 = state_18346;
(statearr_18348[(7)] = inst_18328__$1);

return statearr_18348;
})();
if(inst_18330){
var statearr_18349_18368 = state_18346__$1;
(statearr_18349_18368[(1)] = (8));

} else {
var statearr_18350_18369 = state_18346__$1;
(statearr_18350_18369[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18347 === (1))){
var inst_18323 = (0);
var state_18346__$1 = (function (){var statearr_18351 = state_18346;
(statearr_18351[(8)] = inst_18323);

return statearr_18351;
})();
var statearr_18352_18370 = state_18346__$1;
(statearr_18352_18370[(2)] = null);

(statearr_18352_18370[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18347 === (4))){
var state_18346__$1 = state_18346;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18346__$1,(7),ch);
} else {
if((state_val_18347 === (6))){
var inst_18341 = (state_18346[(2)]);
var state_18346__$1 = state_18346;
var statearr_18353_18371 = state_18346__$1;
(statearr_18353_18371[(2)] = inst_18341);

(statearr_18353_18371[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18347 === (3))){
var inst_18343 = (state_18346[(2)]);
var inst_18344 = cljs.core.async.close_BANG_(out);
var state_18346__$1 = (function (){var statearr_18354 = state_18346;
(statearr_18354[(9)] = inst_18343);

return statearr_18354;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_18346__$1,inst_18344);
} else {
if((state_val_18347 === (2))){
var inst_18323 = (state_18346[(8)]);
var inst_18325 = (inst_18323 < n);
var state_18346__$1 = state_18346;
if(cljs.core.truth_(inst_18325)){
var statearr_18355_18372 = state_18346__$1;
(statearr_18355_18372[(1)] = (4));

} else {
var statearr_18356_18373 = state_18346__$1;
(statearr_18356_18373[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18347 === (11))){
var inst_18323 = (state_18346[(8)]);
var inst_18333 = (state_18346[(2)]);
var inst_18334 = (inst_18323 + (1));
var inst_18323__$1 = inst_18334;
var state_18346__$1 = (function (){var statearr_18357 = state_18346;
(statearr_18357[(8)] = inst_18323__$1);

(statearr_18357[(10)] = inst_18333);

return statearr_18357;
})();
var statearr_18358_18374 = state_18346__$1;
(statearr_18358_18374[(2)] = null);

(statearr_18358_18374[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18347 === (9))){
var state_18346__$1 = state_18346;
var statearr_18359_18375 = state_18346__$1;
(statearr_18359_18375[(2)] = null);

(statearr_18359_18375[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18347 === (5))){
var state_18346__$1 = state_18346;
var statearr_18360_18376 = state_18346__$1;
(statearr_18360_18376[(2)] = null);

(statearr_18360_18376[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18347 === (10))){
var inst_18338 = (state_18346[(2)]);
var state_18346__$1 = state_18346;
var statearr_18361_18377 = state_18346__$1;
(statearr_18361_18377[(2)] = inst_18338);

(statearr_18361_18377[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18347 === (8))){
var inst_18328 = (state_18346[(7)]);
var state_18346__$1 = state_18346;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18346__$1,(11),out,inst_18328);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16893__auto___18367,out))
;
return ((function (switch__16791__auto__,c__16893__auto___18367,out){
return (function() {
var cljs$core$async$state_machine__16792__auto__ = null;
var cljs$core$async$state_machine__16792__auto____0 = (function (){
var statearr_18362 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18362[(0)] = cljs$core$async$state_machine__16792__auto__);

(statearr_18362[(1)] = (1));

return statearr_18362;
});
var cljs$core$async$state_machine__16792__auto____1 = (function (state_18346){
while(true){
var ret_value__16793__auto__ = (function (){try{while(true){
var result__16794__auto__ = switch__16791__auto__(state_18346);
if(cljs.core.keyword_identical_QMARK_(result__16794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16794__auto__;
}
break;
}
}catch (e18363){if((e18363 instanceof Object)){
var ex__16795__auto__ = e18363;
var statearr_18364_18378 = state_18346;
(statearr_18364_18378[(5)] = ex__16795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18346);

return cljs.core.cst$kw$recur;
} else {
throw e18363;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16793__auto__,cljs.core.cst$kw$recur)){
var G__18379 = state_18346;
state_18346 = G__18379;
continue;
} else {
return ret_value__16793__auto__;
}
break;
}
});
cljs$core$async$state_machine__16792__auto__ = function(state_18346){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16792__auto____1.call(this,state_18346);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16792__auto____0;
cljs$core$async$state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16792__auto____1;
return cljs$core$async$state_machine__16792__auto__;
})()
;})(switch__16791__auto__,c__16893__auto___18367,out))
})();
var state__16895__auto__ = (function (){var statearr_18365 = (f__16894__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16894__auto__.cljs$core$IFn$_invoke$arity$0() : f__16894__auto__.call(null));
(statearr_18365[(6)] = c__16893__auto___18367);

return statearr_18365;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16895__auto__);
});})(c__16893__auto___18367,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async18381 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18381 = (function (f,ch,meta18382){
this.f = f;
this.ch = ch;
this.meta18382 = meta18382;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18381.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18383,meta18382__$1){
var self__ = this;
var _18383__$1 = this;
return (new cljs.core.async.t_cljs$core$async18381(self__.f,self__.ch,meta18382__$1));
});

cljs.core.async.t_cljs$core$async18381.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18383){
var self__ = this;
var _18383__$1 = this;
return self__.meta18382;
});

cljs.core.async.t_cljs$core$async18381.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18381.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async18381.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async18381.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18381.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async18384 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18384 = (function (f,ch,meta18382,_,fn1,meta18385){
this.f = f;
this.ch = ch;
this.meta18382 = meta18382;
this._ = _;
this.fn1 = fn1;
this.meta18385 = meta18385;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18384.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_18386,meta18385__$1){
var self__ = this;
var _18386__$1 = this;
return (new cljs.core.async.t_cljs$core$async18384(self__.f,self__.ch,self__.meta18382,self__._,self__.fn1,meta18385__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async18384.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_18386){
var self__ = this;
var _18386__$1 = this;
return self__.meta18385;
});})(___$1))
;

cljs.core.async.t_cljs$core$async18384.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18384.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async18384.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async18384.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__18380_SHARP_){
var G__18387 = (((p1__18380_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__18380_SHARP_) : self__.f.call(null,p1__18380_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__18387) : f1.call(null,G__18387));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async18384.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta18382,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async18381], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta18385], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async18384.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18384.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18384";

cljs.core.async.t_cljs$core$async18384.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__9479__auto__,writer__9480__auto__,opt__9481__auto__){
return cljs.core._write(writer__9480__auto__,"cljs.core.async/t_cljs$core$async18384");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async18384 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async18384(f__$1,ch__$1,meta18382__$1,___$2,fn1__$1,meta18385){
return (new cljs.core.async.t_cljs$core$async18384(f__$1,ch__$1,meta18382__$1,___$2,fn1__$1,meta18385));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async18384(self__.f,self__.ch,self__.meta18382,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__8796__auto__ = ret;
if(cljs.core.truth_(and__8796__auto__)){
return !((cljs.core.deref(ret) == null));
} else {
return and__8796__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__18388 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__18388) : self__.f.call(null,G__18388));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async18381.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18381.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async18381.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta18382], null);
});

cljs.core.async.t_cljs$core$async18381.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18381.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18381";

cljs.core.async.t_cljs$core$async18381.cljs$lang$ctorPrWriter = (function (this__9479__auto__,writer__9480__auto__,opt__9481__auto__){
return cljs.core._write(writer__9480__auto__,"cljs.core.async/t_cljs$core$async18381");
});

cljs.core.async.__GT_t_cljs$core$async18381 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async18381(f__$1,ch__$1,meta18382){
return (new cljs.core.async.t_cljs$core$async18381(f__$1,ch__$1,meta18382));
});

}

return (new cljs.core.async.t_cljs$core$async18381(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async18389 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18389 = (function (f,ch,meta18390){
this.f = f;
this.ch = ch;
this.meta18390 = meta18390;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18389.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18391,meta18390__$1){
var self__ = this;
var _18391__$1 = this;
return (new cljs.core.async.t_cljs$core$async18389(self__.f,self__.ch,meta18390__$1));
});

cljs.core.async.t_cljs$core$async18389.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18391){
var self__ = this;
var _18391__$1 = this;
return self__.meta18390;
});

cljs.core.async.t_cljs$core$async18389.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18389.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async18389.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18389.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async18389.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18389.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async18389.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta18390], null);
});

cljs.core.async.t_cljs$core$async18389.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18389.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18389";

cljs.core.async.t_cljs$core$async18389.cljs$lang$ctorPrWriter = (function (this__9479__auto__,writer__9480__auto__,opt__9481__auto__){
return cljs.core._write(writer__9480__auto__,"cljs.core.async/t_cljs$core$async18389");
});

cljs.core.async.__GT_t_cljs$core$async18389 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async18389(f__$1,ch__$1,meta18390){
return (new cljs.core.async.t_cljs$core$async18389(f__$1,ch__$1,meta18390));
});

}

return (new cljs.core.async.t_cljs$core$async18389(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async18392 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18392 = (function (p,ch,meta18393){
this.p = p;
this.ch = ch;
this.meta18393 = meta18393;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18392.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18394,meta18393__$1){
var self__ = this;
var _18394__$1 = this;
return (new cljs.core.async.t_cljs$core$async18392(self__.p,self__.ch,meta18393__$1));
});

cljs.core.async.t_cljs$core$async18392.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18394){
var self__ = this;
var _18394__$1 = this;
return self__.meta18393;
});

cljs.core.async.t_cljs$core$async18392.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18392.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async18392.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async18392.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18392.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async18392.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18392.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async18392.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta18393], null);
});

cljs.core.async.t_cljs$core$async18392.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18392.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18392";

cljs.core.async.t_cljs$core$async18392.cljs$lang$ctorPrWriter = (function (this__9479__auto__,writer__9480__auto__,opt__9481__auto__){
return cljs.core._write(writer__9480__auto__,"cljs.core.async/t_cljs$core$async18392");
});

cljs.core.async.__GT_t_cljs$core$async18392 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async18392(p__$1,ch__$1,meta18393){
return (new cljs.core.async.t_cljs$core$async18392(p__$1,ch__$1,meta18393));
});

}

return (new cljs.core.async.t_cljs$core$async18392(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__18396 = arguments.length;
switch (G__18396) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16893__auto___18436 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16893__auto___18436,out){
return (function (){
var f__16894__auto__ = (function (){var switch__16791__auto__ = ((function (c__16893__auto___18436,out){
return (function (state_18417){
var state_val_18418 = (state_18417[(1)]);
if((state_val_18418 === (7))){
var inst_18413 = (state_18417[(2)]);
var state_18417__$1 = state_18417;
var statearr_18419_18437 = state_18417__$1;
(statearr_18419_18437[(2)] = inst_18413);

(statearr_18419_18437[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18418 === (1))){
var state_18417__$1 = state_18417;
var statearr_18420_18438 = state_18417__$1;
(statearr_18420_18438[(2)] = null);

(statearr_18420_18438[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18418 === (4))){
var inst_18399 = (state_18417[(7)]);
var inst_18399__$1 = (state_18417[(2)]);
var inst_18400 = (inst_18399__$1 == null);
var state_18417__$1 = (function (){var statearr_18421 = state_18417;
(statearr_18421[(7)] = inst_18399__$1);

return statearr_18421;
})();
if(cljs.core.truth_(inst_18400)){
var statearr_18422_18439 = state_18417__$1;
(statearr_18422_18439[(1)] = (5));

} else {
var statearr_18423_18440 = state_18417__$1;
(statearr_18423_18440[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18418 === (6))){
var inst_18399 = (state_18417[(7)]);
var inst_18404 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_18399) : p.call(null,inst_18399));
var state_18417__$1 = state_18417;
if(cljs.core.truth_(inst_18404)){
var statearr_18424_18441 = state_18417__$1;
(statearr_18424_18441[(1)] = (8));

} else {
var statearr_18425_18442 = state_18417__$1;
(statearr_18425_18442[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18418 === (3))){
var inst_18415 = (state_18417[(2)]);
var state_18417__$1 = state_18417;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18417__$1,inst_18415);
} else {
if((state_val_18418 === (2))){
var state_18417__$1 = state_18417;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18417__$1,(4),ch);
} else {
if((state_val_18418 === (11))){
var inst_18407 = (state_18417[(2)]);
var state_18417__$1 = state_18417;
var statearr_18426_18443 = state_18417__$1;
(statearr_18426_18443[(2)] = inst_18407);

(statearr_18426_18443[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18418 === (9))){
var state_18417__$1 = state_18417;
var statearr_18427_18444 = state_18417__$1;
(statearr_18427_18444[(2)] = null);

(statearr_18427_18444[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18418 === (5))){
var inst_18402 = cljs.core.async.close_BANG_(out);
var state_18417__$1 = state_18417;
var statearr_18428_18445 = state_18417__$1;
(statearr_18428_18445[(2)] = inst_18402);

(statearr_18428_18445[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18418 === (10))){
var inst_18410 = (state_18417[(2)]);
var state_18417__$1 = (function (){var statearr_18429 = state_18417;
(statearr_18429[(8)] = inst_18410);

return statearr_18429;
})();
var statearr_18430_18446 = state_18417__$1;
(statearr_18430_18446[(2)] = null);

(statearr_18430_18446[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18418 === (8))){
var inst_18399 = (state_18417[(7)]);
var state_18417__$1 = state_18417;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18417__$1,(11),out,inst_18399);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16893__auto___18436,out))
;
return ((function (switch__16791__auto__,c__16893__auto___18436,out){
return (function() {
var cljs$core$async$state_machine__16792__auto__ = null;
var cljs$core$async$state_machine__16792__auto____0 = (function (){
var statearr_18431 = [null,null,null,null,null,null,null,null,null];
(statearr_18431[(0)] = cljs$core$async$state_machine__16792__auto__);

(statearr_18431[(1)] = (1));

return statearr_18431;
});
var cljs$core$async$state_machine__16792__auto____1 = (function (state_18417){
while(true){
var ret_value__16793__auto__ = (function (){try{while(true){
var result__16794__auto__ = switch__16791__auto__(state_18417);
if(cljs.core.keyword_identical_QMARK_(result__16794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16794__auto__;
}
break;
}
}catch (e18432){if((e18432 instanceof Object)){
var ex__16795__auto__ = e18432;
var statearr_18433_18447 = state_18417;
(statearr_18433_18447[(5)] = ex__16795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18417);

return cljs.core.cst$kw$recur;
} else {
throw e18432;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16793__auto__,cljs.core.cst$kw$recur)){
var G__18448 = state_18417;
state_18417 = G__18448;
continue;
} else {
return ret_value__16793__auto__;
}
break;
}
});
cljs$core$async$state_machine__16792__auto__ = function(state_18417){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16792__auto____1.call(this,state_18417);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16792__auto____0;
cljs$core$async$state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16792__auto____1;
return cljs$core$async$state_machine__16792__auto__;
})()
;})(switch__16791__auto__,c__16893__auto___18436,out))
})();
var state__16895__auto__ = (function (){var statearr_18434 = (f__16894__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16894__auto__.cljs$core$IFn$_invoke$arity$0() : f__16894__auto__.call(null));
(statearr_18434[(6)] = c__16893__auto___18436);

return statearr_18434;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16895__auto__);
});})(c__16893__auto___18436,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__18450 = arguments.length;
switch (G__18450) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__16893__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16893__auto__){
return (function (){
var f__16894__auto__ = (function (){var switch__16791__auto__ = ((function (c__16893__auto__){
return (function (state_18513){
var state_val_18514 = (state_18513[(1)]);
if((state_val_18514 === (7))){
var inst_18509 = (state_18513[(2)]);
var state_18513__$1 = state_18513;
var statearr_18515_18553 = state_18513__$1;
(statearr_18515_18553[(2)] = inst_18509);

(statearr_18515_18553[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18514 === (20))){
var inst_18479 = (state_18513[(7)]);
var inst_18490 = (state_18513[(2)]);
var inst_18491 = cljs.core.next(inst_18479);
var inst_18465 = inst_18491;
var inst_18466 = null;
var inst_18467 = (0);
var inst_18468 = (0);
var state_18513__$1 = (function (){var statearr_18516 = state_18513;
(statearr_18516[(8)] = inst_18490);

(statearr_18516[(9)] = inst_18465);

(statearr_18516[(10)] = inst_18468);

(statearr_18516[(11)] = inst_18467);

(statearr_18516[(12)] = inst_18466);

return statearr_18516;
})();
var statearr_18517_18554 = state_18513__$1;
(statearr_18517_18554[(2)] = null);

(statearr_18517_18554[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18514 === (1))){
var state_18513__$1 = state_18513;
var statearr_18518_18555 = state_18513__$1;
(statearr_18518_18555[(2)] = null);

(statearr_18518_18555[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18514 === (4))){
var inst_18454 = (state_18513[(13)]);
var inst_18454__$1 = (state_18513[(2)]);
var inst_18455 = (inst_18454__$1 == null);
var state_18513__$1 = (function (){var statearr_18519 = state_18513;
(statearr_18519[(13)] = inst_18454__$1);

return statearr_18519;
})();
if(cljs.core.truth_(inst_18455)){
var statearr_18520_18556 = state_18513__$1;
(statearr_18520_18556[(1)] = (5));

} else {
var statearr_18521_18557 = state_18513__$1;
(statearr_18521_18557[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18514 === (15))){
var state_18513__$1 = state_18513;
var statearr_18525_18558 = state_18513__$1;
(statearr_18525_18558[(2)] = null);

(statearr_18525_18558[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18514 === (21))){
var state_18513__$1 = state_18513;
var statearr_18526_18559 = state_18513__$1;
(statearr_18526_18559[(2)] = null);

(statearr_18526_18559[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18514 === (13))){
var inst_18465 = (state_18513[(9)]);
var inst_18468 = (state_18513[(10)]);
var inst_18467 = (state_18513[(11)]);
var inst_18466 = (state_18513[(12)]);
var inst_18475 = (state_18513[(2)]);
var inst_18476 = (inst_18468 + (1));
var tmp18522 = inst_18465;
var tmp18523 = inst_18467;
var tmp18524 = inst_18466;
var inst_18465__$1 = tmp18522;
var inst_18466__$1 = tmp18524;
var inst_18467__$1 = tmp18523;
var inst_18468__$1 = inst_18476;
var state_18513__$1 = (function (){var statearr_18527 = state_18513;
(statearr_18527[(9)] = inst_18465__$1);

(statearr_18527[(14)] = inst_18475);

(statearr_18527[(10)] = inst_18468__$1);

(statearr_18527[(11)] = inst_18467__$1);

(statearr_18527[(12)] = inst_18466__$1);

return statearr_18527;
})();
var statearr_18528_18560 = state_18513__$1;
(statearr_18528_18560[(2)] = null);

(statearr_18528_18560[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18514 === (22))){
var state_18513__$1 = state_18513;
var statearr_18529_18561 = state_18513__$1;
(statearr_18529_18561[(2)] = null);

(statearr_18529_18561[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18514 === (6))){
var inst_18454 = (state_18513[(13)]);
var inst_18463 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_18454) : f.call(null,inst_18454));
var inst_18464 = cljs.core.seq(inst_18463);
var inst_18465 = inst_18464;
var inst_18466 = null;
var inst_18467 = (0);
var inst_18468 = (0);
var state_18513__$1 = (function (){var statearr_18530 = state_18513;
(statearr_18530[(9)] = inst_18465);

(statearr_18530[(10)] = inst_18468);

(statearr_18530[(11)] = inst_18467);

(statearr_18530[(12)] = inst_18466);

return statearr_18530;
})();
var statearr_18531_18562 = state_18513__$1;
(statearr_18531_18562[(2)] = null);

(statearr_18531_18562[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18514 === (17))){
var inst_18479 = (state_18513[(7)]);
var inst_18483 = cljs.core.chunk_first(inst_18479);
var inst_18484 = cljs.core.chunk_rest(inst_18479);
var inst_18485 = cljs.core.count(inst_18483);
var inst_18465 = inst_18484;
var inst_18466 = inst_18483;
var inst_18467 = inst_18485;
var inst_18468 = (0);
var state_18513__$1 = (function (){var statearr_18532 = state_18513;
(statearr_18532[(9)] = inst_18465);

(statearr_18532[(10)] = inst_18468);

(statearr_18532[(11)] = inst_18467);

(statearr_18532[(12)] = inst_18466);

return statearr_18532;
})();
var statearr_18533_18563 = state_18513__$1;
(statearr_18533_18563[(2)] = null);

(statearr_18533_18563[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18514 === (3))){
var inst_18511 = (state_18513[(2)]);
var state_18513__$1 = state_18513;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18513__$1,inst_18511);
} else {
if((state_val_18514 === (12))){
var inst_18499 = (state_18513[(2)]);
var state_18513__$1 = state_18513;
var statearr_18534_18564 = state_18513__$1;
(statearr_18534_18564[(2)] = inst_18499);

(statearr_18534_18564[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18514 === (2))){
var state_18513__$1 = state_18513;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18513__$1,(4),in$);
} else {
if((state_val_18514 === (23))){
var inst_18507 = (state_18513[(2)]);
var state_18513__$1 = state_18513;
var statearr_18535_18565 = state_18513__$1;
(statearr_18535_18565[(2)] = inst_18507);

(statearr_18535_18565[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18514 === (19))){
var inst_18494 = (state_18513[(2)]);
var state_18513__$1 = state_18513;
var statearr_18536_18566 = state_18513__$1;
(statearr_18536_18566[(2)] = inst_18494);

(statearr_18536_18566[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18514 === (11))){
var inst_18465 = (state_18513[(9)]);
var inst_18479 = (state_18513[(7)]);
var inst_18479__$1 = cljs.core.seq(inst_18465);
var state_18513__$1 = (function (){var statearr_18537 = state_18513;
(statearr_18537[(7)] = inst_18479__$1);

return statearr_18537;
})();
if(inst_18479__$1){
var statearr_18538_18567 = state_18513__$1;
(statearr_18538_18567[(1)] = (14));

} else {
var statearr_18539_18568 = state_18513__$1;
(statearr_18539_18568[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18514 === (9))){
var inst_18501 = (state_18513[(2)]);
var inst_18502 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_18513__$1 = (function (){var statearr_18540 = state_18513;
(statearr_18540[(15)] = inst_18501);

return statearr_18540;
})();
if(cljs.core.truth_(inst_18502)){
var statearr_18541_18569 = state_18513__$1;
(statearr_18541_18569[(1)] = (21));

} else {
var statearr_18542_18570 = state_18513__$1;
(statearr_18542_18570[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18514 === (5))){
var inst_18457 = cljs.core.async.close_BANG_(out);
var state_18513__$1 = state_18513;
var statearr_18543_18571 = state_18513__$1;
(statearr_18543_18571[(2)] = inst_18457);

(statearr_18543_18571[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18514 === (14))){
var inst_18479 = (state_18513[(7)]);
var inst_18481 = cljs.core.chunked_seq_QMARK_(inst_18479);
var state_18513__$1 = state_18513;
if(inst_18481){
var statearr_18544_18572 = state_18513__$1;
(statearr_18544_18572[(1)] = (17));

} else {
var statearr_18545_18573 = state_18513__$1;
(statearr_18545_18573[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18514 === (16))){
var inst_18497 = (state_18513[(2)]);
var state_18513__$1 = state_18513;
var statearr_18546_18574 = state_18513__$1;
(statearr_18546_18574[(2)] = inst_18497);

(statearr_18546_18574[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18514 === (10))){
var inst_18468 = (state_18513[(10)]);
var inst_18466 = (state_18513[(12)]);
var inst_18473 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_18466,inst_18468);
var state_18513__$1 = state_18513;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18513__$1,(13),out,inst_18473);
} else {
if((state_val_18514 === (18))){
var inst_18479 = (state_18513[(7)]);
var inst_18488 = cljs.core.first(inst_18479);
var state_18513__$1 = state_18513;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18513__$1,(20),out,inst_18488);
} else {
if((state_val_18514 === (8))){
var inst_18468 = (state_18513[(10)]);
var inst_18467 = (state_18513[(11)]);
var inst_18470 = (inst_18468 < inst_18467);
var inst_18471 = inst_18470;
var state_18513__$1 = state_18513;
if(cljs.core.truth_(inst_18471)){
var statearr_18547_18575 = state_18513__$1;
(statearr_18547_18575[(1)] = (10));

} else {
var statearr_18548_18576 = state_18513__$1;
(statearr_18548_18576[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16893__auto__))
;
return ((function (switch__16791__auto__,c__16893__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__16792__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__16792__auto____0 = (function (){
var statearr_18549 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18549[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__16792__auto__);

(statearr_18549[(1)] = (1));

return statearr_18549;
});
var cljs$core$async$mapcat_STAR__$_state_machine__16792__auto____1 = (function (state_18513){
while(true){
var ret_value__16793__auto__ = (function (){try{while(true){
var result__16794__auto__ = switch__16791__auto__(state_18513);
if(cljs.core.keyword_identical_QMARK_(result__16794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16794__auto__;
}
break;
}
}catch (e18550){if((e18550 instanceof Object)){
var ex__16795__auto__ = e18550;
var statearr_18551_18577 = state_18513;
(statearr_18551_18577[(5)] = ex__16795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18513);

return cljs.core.cst$kw$recur;
} else {
throw e18550;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16793__auto__,cljs.core.cst$kw$recur)){
var G__18578 = state_18513;
state_18513 = G__18578;
continue;
} else {
return ret_value__16793__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__16792__auto__ = function(state_18513){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__16792__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__16792__auto____1.call(this,state_18513);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__16792__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__16792__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__16792__auto__;
})()
;})(switch__16791__auto__,c__16893__auto__))
})();
var state__16895__auto__ = (function (){var statearr_18552 = (f__16894__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16894__auto__.cljs$core$IFn$_invoke$arity$0() : f__16894__auto__.call(null));
(statearr_18552[(6)] = c__16893__auto__);

return statearr_18552;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16895__auto__);
});})(c__16893__auto__))
);

return c__16893__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__18580 = arguments.length;
switch (G__18580) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__18583 = arguments.length;
switch (G__18583) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__18586 = arguments.length;
switch (G__18586) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16893__auto___18633 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16893__auto___18633,out){
return (function (){
var f__16894__auto__ = (function (){var switch__16791__auto__ = ((function (c__16893__auto___18633,out){
return (function (state_18610){
var state_val_18611 = (state_18610[(1)]);
if((state_val_18611 === (7))){
var inst_18605 = (state_18610[(2)]);
var state_18610__$1 = state_18610;
var statearr_18612_18634 = state_18610__$1;
(statearr_18612_18634[(2)] = inst_18605);

(statearr_18612_18634[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18611 === (1))){
var inst_18587 = null;
var state_18610__$1 = (function (){var statearr_18613 = state_18610;
(statearr_18613[(7)] = inst_18587);

return statearr_18613;
})();
var statearr_18614_18635 = state_18610__$1;
(statearr_18614_18635[(2)] = null);

(statearr_18614_18635[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18611 === (4))){
var inst_18590 = (state_18610[(8)]);
var inst_18590__$1 = (state_18610[(2)]);
var inst_18591 = (inst_18590__$1 == null);
var inst_18592 = cljs.core.not(inst_18591);
var state_18610__$1 = (function (){var statearr_18615 = state_18610;
(statearr_18615[(8)] = inst_18590__$1);

return statearr_18615;
})();
if(inst_18592){
var statearr_18616_18636 = state_18610__$1;
(statearr_18616_18636[(1)] = (5));

} else {
var statearr_18617_18637 = state_18610__$1;
(statearr_18617_18637[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18611 === (6))){
var state_18610__$1 = state_18610;
var statearr_18618_18638 = state_18610__$1;
(statearr_18618_18638[(2)] = null);

(statearr_18618_18638[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18611 === (3))){
var inst_18607 = (state_18610[(2)]);
var inst_18608 = cljs.core.async.close_BANG_(out);
var state_18610__$1 = (function (){var statearr_18619 = state_18610;
(statearr_18619[(9)] = inst_18607);

return statearr_18619;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_18610__$1,inst_18608);
} else {
if((state_val_18611 === (2))){
var state_18610__$1 = state_18610;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18610__$1,(4),ch);
} else {
if((state_val_18611 === (11))){
var inst_18590 = (state_18610[(8)]);
var inst_18599 = (state_18610[(2)]);
var inst_18587 = inst_18590;
var state_18610__$1 = (function (){var statearr_18620 = state_18610;
(statearr_18620[(10)] = inst_18599);

(statearr_18620[(7)] = inst_18587);

return statearr_18620;
})();
var statearr_18621_18639 = state_18610__$1;
(statearr_18621_18639[(2)] = null);

(statearr_18621_18639[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18611 === (9))){
var inst_18590 = (state_18610[(8)]);
var state_18610__$1 = state_18610;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18610__$1,(11),out,inst_18590);
} else {
if((state_val_18611 === (5))){
var inst_18587 = (state_18610[(7)]);
var inst_18590 = (state_18610[(8)]);
var inst_18594 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_18590,inst_18587);
var state_18610__$1 = state_18610;
if(inst_18594){
var statearr_18623_18640 = state_18610__$1;
(statearr_18623_18640[(1)] = (8));

} else {
var statearr_18624_18641 = state_18610__$1;
(statearr_18624_18641[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18611 === (10))){
var inst_18602 = (state_18610[(2)]);
var state_18610__$1 = state_18610;
var statearr_18625_18642 = state_18610__$1;
(statearr_18625_18642[(2)] = inst_18602);

(statearr_18625_18642[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18611 === (8))){
var inst_18587 = (state_18610[(7)]);
var tmp18622 = inst_18587;
var inst_18587__$1 = tmp18622;
var state_18610__$1 = (function (){var statearr_18626 = state_18610;
(statearr_18626[(7)] = inst_18587__$1);

return statearr_18626;
})();
var statearr_18627_18643 = state_18610__$1;
(statearr_18627_18643[(2)] = null);

(statearr_18627_18643[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16893__auto___18633,out))
;
return ((function (switch__16791__auto__,c__16893__auto___18633,out){
return (function() {
var cljs$core$async$state_machine__16792__auto__ = null;
var cljs$core$async$state_machine__16792__auto____0 = (function (){
var statearr_18628 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18628[(0)] = cljs$core$async$state_machine__16792__auto__);

(statearr_18628[(1)] = (1));

return statearr_18628;
});
var cljs$core$async$state_machine__16792__auto____1 = (function (state_18610){
while(true){
var ret_value__16793__auto__ = (function (){try{while(true){
var result__16794__auto__ = switch__16791__auto__(state_18610);
if(cljs.core.keyword_identical_QMARK_(result__16794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16794__auto__;
}
break;
}
}catch (e18629){if((e18629 instanceof Object)){
var ex__16795__auto__ = e18629;
var statearr_18630_18644 = state_18610;
(statearr_18630_18644[(5)] = ex__16795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18610);

return cljs.core.cst$kw$recur;
} else {
throw e18629;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16793__auto__,cljs.core.cst$kw$recur)){
var G__18645 = state_18610;
state_18610 = G__18645;
continue;
} else {
return ret_value__16793__auto__;
}
break;
}
});
cljs$core$async$state_machine__16792__auto__ = function(state_18610){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16792__auto____1.call(this,state_18610);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16792__auto____0;
cljs$core$async$state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16792__auto____1;
return cljs$core$async$state_machine__16792__auto__;
})()
;})(switch__16791__auto__,c__16893__auto___18633,out))
})();
var state__16895__auto__ = (function (){var statearr_18631 = (f__16894__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16894__auto__.cljs$core$IFn$_invoke$arity$0() : f__16894__auto__.call(null));
(statearr_18631[(6)] = c__16893__auto___18633);

return statearr_18631;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16895__auto__);
});})(c__16893__auto___18633,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__18647 = arguments.length;
switch (G__18647) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16893__auto___18713 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16893__auto___18713,out){
return (function (){
var f__16894__auto__ = (function (){var switch__16791__auto__ = ((function (c__16893__auto___18713,out){
return (function (state_18685){
var state_val_18686 = (state_18685[(1)]);
if((state_val_18686 === (7))){
var inst_18681 = (state_18685[(2)]);
var state_18685__$1 = state_18685;
var statearr_18687_18714 = state_18685__$1;
(statearr_18687_18714[(2)] = inst_18681);

(statearr_18687_18714[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18686 === (1))){
var inst_18648 = (new Array(n));
var inst_18649 = inst_18648;
var inst_18650 = (0);
var state_18685__$1 = (function (){var statearr_18688 = state_18685;
(statearr_18688[(7)] = inst_18649);

(statearr_18688[(8)] = inst_18650);

return statearr_18688;
})();
var statearr_18689_18715 = state_18685__$1;
(statearr_18689_18715[(2)] = null);

(statearr_18689_18715[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18686 === (4))){
var inst_18653 = (state_18685[(9)]);
var inst_18653__$1 = (state_18685[(2)]);
var inst_18654 = (inst_18653__$1 == null);
var inst_18655 = cljs.core.not(inst_18654);
var state_18685__$1 = (function (){var statearr_18690 = state_18685;
(statearr_18690[(9)] = inst_18653__$1);

return statearr_18690;
})();
if(inst_18655){
var statearr_18691_18716 = state_18685__$1;
(statearr_18691_18716[(1)] = (5));

} else {
var statearr_18692_18717 = state_18685__$1;
(statearr_18692_18717[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18686 === (15))){
var inst_18675 = (state_18685[(2)]);
var state_18685__$1 = state_18685;
var statearr_18693_18718 = state_18685__$1;
(statearr_18693_18718[(2)] = inst_18675);

(statearr_18693_18718[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18686 === (13))){
var state_18685__$1 = state_18685;
var statearr_18694_18719 = state_18685__$1;
(statearr_18694_18719[(2)] = null);

(statearr_18694_18719[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18686 === (6))){
var inst_18650 = (state_18685[(8)]);
var inst_18671 = (inst_18650 > (0));
var state_18685__$1 = state_18685;
if(cljs.core.truth_(inst_18671)){
var statearr_18695_18720 = state_18685__$1;
(statearr_18695_18720[(1)] = (12));

} else {
var statearr_18696_18721 = state_18685__$1;
(statearr_18696_18721[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18686 === (3))){
var inst_18683 = (state_18685[(2)]);
var state_18685__$1 = state_18685;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18685__$1,inst_18683);
} else {
if((state_val_18686 === (12))){
var inst_18649 = (state_18685[(7)]);
var inst_18673 = cljs.core.vec(inst_18649);
var state_18685__$1 = state_18685;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18685__$1,(15),out,inst_18673);
} else {
if((state_val_18686 === (2))){
var state_18685__$1 = state_18685;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18685__$1,(4),ch);
} else {
if((state_val_18686 === (11))){
var inst_18665 = (state_18685[(2)]);
var inst_18666 = (new Array(n));
var inst_18649 = inst_18666;
var inst_18650 = (0);
var state_18685__$1 = (function (){var statearr_18697 = state_18685;
(statearr_18697[(7)] = inst_18649);

(statearr_18697[(10)] = inst_18665);

(statearr_18697[(8)] = inst_18650);

return statearr_18697;
})();
var statearr_18698_18722 = state_18685__$1;
(statearr_18698_18722[(2)] = null);

(statearr_18698_18722[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18686 === (9))){
var inst_18649 = (state_18685[(7)]);
var inst_18663 = cljs.core.vec(inst_18649);
var state_18685__$1 = state_18685;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18685__$1,(11),out,inst_18663);
} else {
if((state_val_18686 === (5))){
var inst_18649 = (state_18685[(7)]);
var inst_18658 = (state_18685[(11)]);
var inst_18653 = (state_18685[(9)]);
var inst_18650 = (state_18685[(8)]);
var inst_18657 = (inst_18649[inst_18650] = inst_18653);
var inst_18658__$1 = (inst_18650 + (1));
var inst_18659 = (inst_18658__$1 < n);
var state_18685__$1 = (function (){var statearr_18699 = state_18685;
(statearr_18699[(11)] = inst_18658__$1);

(statearr_18699[(12)] = inst_18657);

return statearr_18699;
})();
if(cljs.core.truth_(inst_18659)){
var statearr_18700_18723 = state_18685__$1;
(statearr_18700_18723[(1)] = (8));

} else {
var statearr_18701_18724 = state_18685__$1;
(statearr_18701_18724[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18686 === (14))){
var inst_18678 = (state_18685[(2)]);
var inst_18679 = cljs.core.async.close_BANG_(out);
var state_18685__$1 = (function (){var statearr_18703 = state_18685;
(statearr_18703[(13)] = inst_18678);

return statearr_18703;
})();
var statearr_18704_18725 = state_18685__$1;
(statearr_18704_18725[(2)] = inst_18679);

(statearr_18704_18725[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18686 === (10))){
var inst_18669 = (state_18685[(2)]);
var state_18685__$1 = state_18685;
var statearr_18705_18726 = state_18685__$1;
(statearr_18705_18726[(2)] = inst_18669);

(statearr_18705_18726[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18686 === (8))){
var inst_18649 = (state_18685[(7)]);
var inst_18658 = (state_18685[(11)]);
var tmp18702 = inst_18649;
var inst_18649__$1 = tmp18702;
var inst_18650 = inst_18658;
var state_18685__$1 = (function (){var statearr_18706 = state_18685;
(statearr_18706[(7)] = inst_18649__$1);

(statearr_18706[(8)] = inst_18650);

return statearr_18706;
})();
var statearr_18707_18727 = state_18685__$1;
(statearr_18707_18727[(2)] = null);

(statearr_18707_18727[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16893__auto___18713,out))
;
return ((function (switch__16791__auto__,c__16893__auto___18713,out){
return (function() {
var cljs$core$async$state_machine__16792__auto__ = null;
var cljs$core$async$state_machine__16792__auto____0 = (function (){
var statearr_18708 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18708[(0)] = cljs$core$async$state_machine__16792__auto__);

(statearr_18708[(1)] = (1));

return statearr_18708;
});
var cljs$core$async$state_machine__16792__auto____1 = (function (state_18685){
while(true){
var ret_value__16793__auto__ = (function (){try{while(true){
var result__16794__auto__ = switch__16791__auto__(state_18685);
if(cljs.core.keyword_identical_QMARK_(result__16794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16794__auto__;
}
break;
}
}catch (e18709){if((e18709 instanceof Object)){
var ex__16795__auto__ = e18709;
var statearr_18710_18728 = state_18685;
(statearr_18710_18728[(5)] = ex__16795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18685);

return cljs.core.cst$kw$recur;
} else {
throw e18709;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16793__auto__,cljs.core.cst$kw$recur)){
var G__18729 = state_18685;
state_18685 = G__18729;
continue;
} else {
return ret_value__16793__auto__;
}
break;
}
});
cljs$core$async$state_machine__16792__auto__ = function(state_18685){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16792__auto____1.call(this,state_18685);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16792__auto____0;
cljs$core$async$state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16792__auto____1;
return cljs$core$async$state_machine__16792__auto__;
})()
;})(switch__16791__auto__,c__16893__auto___18713,out))
})();
var state__16895__auto__ = (function (){var statearr_18711 = (f__16894__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16894__auto__.cljs$core$IFn$_invoke$arity$0() : f__16894__auto__.call(null));
(statearr_18711[(6)] = c__16893__auto___18713);

return statearr_18711;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16895__auto__);
});})(c__16893__auto___18713,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__18731 = arguments.length;
switch (G__18731) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16893__auto___18801 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16893__auto___18801,out){
return (function (){
var f__16894__auto__ = (function (){var switch__16791__auto__ = ((function (c__16893__auto___18801,out){
return (function (state_18773){
var state_val_18774 = (state_18773[(1)]);
if((state_val_18774 === (7))){
var inst_18769 = (state_18773[(2)]);
var state_18773__$1 = state_18773;
var statearr_18775_18802 = state_18773__$1;
(statearr_18775_18802[(2)] = inst_18769);

(statearr_18775_18802[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18774 === (1))){
var inst_18732 = [];
var inst_18733 = inst_18732;
var inst_18734 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_18773__$1 = (function (){var statearr_18776 = state_18773;
(statearr_18776[(7)] = inst_18733);

(statearr_18776[(8)] = inst_18734);

return statearr_18776;
})();
var statearr_18777_18803 = state_18773__$1;
(statearr_18777_18803[(2)] = null);

(statearr_18777_18803[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18774 === (4))){
var inst_18737 = (state_18773[(9)]);
var inst_18737__$1 = (state_18773[(2)]);
var inst_18738 = (inst_18737__$1 == null);
var inst_18739 = cljs.core.not(inst_18738);
var state_18773__$1 = (function (){var statearr_18778 = state_18773;
(statearr_18778[(9)] = inst_18737__$1);

return statearr_18778;
})();
if(inst_18739){
var statearr_18779_18804 = state_18773__$1;
(statearr_18779_18804[(1)] = (5));

} else {
var statearr_18780_18805 = state_18773__$1;
(statearr_18780_18805[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18774 === (15))){
var inst_18763 = (state_18773[(2)]);
var state_18773__$1 = state_18773;
var statearr_18781_18806 = state_18773__$1;
(statearr_18781_18806[(2)] = inst_18763);

(statearr_18781_18806[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18774 === (13))){
var state_18773__$1 = state_18773;
var statearr_18782_18807 = state_18773__$1;
(statearr_18782_18807[(2)] = null);

(statearr_18782_18807[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18774 === (6))){
var inst_18733 = (state_18773[(7)]);
var inst_18758 = inst_18733.length;
var inst_18759 = (inst_18758 > (0));
var state_18773__$1 = state_18773;
if(cljs.core.truth_(inst_18759)){
var statearr_18783_18808 = state_18773__$1;
(statearr_18783_18808[(1)] = (12));

} else {
var statearr_18784_18809 = state_18773__$1;
(statearr_18784_18809[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18774 === (3))){
var inst_18771 = (state_18773[(2)]);
var state_18773__$1 = state_18773;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18773__$1,inst_18771);
} else {
if((state_val_18774 === (12))){
var inst_18733 = (state_18773[(7)]);
var inst_18761 = cljs.core.vec(inst_18733);
var state_18773__$1 = state_18773;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18773__$1,(15),out,inst_18761);
} else {
if((state_val_18774 === (2))){
var state_18773__$1 = state_18773;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18773__$1,(4),ch);
} else {
if((state_val_18774 === (11))){
var inst_18741 = (state_18773[(10)]);
var inst_18737 = (state_18773[(9)]);
var inst_18751 = (state_18773[(2)]);
var inst_18752 = [];
var inst_18753 = inst_18752.push(inst_18737);
var inst_18733 = inst_18752;
var inst_18734 = inst_18741;
var state_18773__$1 = (function (){var statearr_18785 = state_18773;
(statearr_18785[(7)] = inst_18733);

(statearr_18785[(11)] = inst_18751);

(statearr_18785[(8)] = inst_18734);

(statearr_18785[(12)] = inst_18753);

return statearr_18785;
})();
var statearr_18786_18810 = state_18773__$1;
(statearr_18786_18810[(2)] = null);

(statearr_18786_18810[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18774 === (9))){
var inst_18733 = (state_18773[(7)]);
var inst_18749 = cljs.core.vec(inst_18733);
var state_18773__$1 = state_18773;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18773__$1,(11),out,inst_18749);
} else {
if((state_val_18774 === (5))){
var inst_18741 = (state_18773[(10)]);
var inst_18734 = (state_18773[(8)]);
var inst_18737 = (state_18773[(9)]);
var inst_18741__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_18737) : f.call(null,inst_18737));
var inst_18742 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_18741__$1,inst_18734);
var inst_18743 = cljs.core.keyword_identical_QMARK_(inst_18734,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_18744 = (inst_18742) || (inst_18743);
var state_18773__$1 = (function (){var statearr_18787 = state_18773;
(statearr_18787[(10)] = inst_18741__$1);

return statearr_18787;
})();
if(cljs.core.truth_(inst_18744)){
var statearr_18788_18811 = state_18773__$1;
(statearr_18788_18811[(1)] = (8));

} else {
var statearr_18789_18812 = state_18773__$1;
(statearr_18789_18812[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18774 === (14))){
var inst_18766 = (state_18773[(2)]);
var inst_18767 = cljs.core.async.close_BANG_(out);
var state_18773__$1 = (function (){var statearr_18791 = state_18773;
(statearr_18791[(13)] = inst_18766);

return statearr_18791;
})();
var statearr_18792_18813 = state_18773__$1;
(statearr_18792_18813[(2)] = inst_18767);

(statearr_18792_18813[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18774 === (10))){
var inst_18756 = (state_18773[(2)]);
var state_18773__$1 = state_18773;
var statearr_18793_18814 = state_18773__$1;
(statearr_18793_18814[(2)] = inst_18756);

(statearr_18793_18814[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18774 === (8))){
var inst_18733 = (state_18773[(7)]);
var inst_18741 = (state_18773[(10)]);
var inst_18737 = (state_18773[(9)]);
var inst_18746 = inst_18733.push(inst_18737);
var tmp18790 = inst_18733;
var inst_18733__$1 = tmp18790;
var inst_18734 = inst_18741;
var state_18773__$1 = (function (){var statearr_18794 = state_18773;
(statearr_18794[(7)] = inst_18733__$1);

(statearr_18794[(14)] = inst_18746);

(statearr_18794[(8)] = inst_18734);

return statearr_18794;
})();
var statearr_18795_18815 = state_18773__$1;
(statearr_18795_18815[(2)] = null);

(statearr_18795_18815[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16893__auto___18801,out))
;
return ((function (switch__16791__auto__,c__16893__auto___18801,out){
return (function() {
var cljs$core$async$state_machine__16792__auto__ = null;
var cljs$core$async$state_machine__16792__auto____0 = (function (){
var statearr_18796 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18796[(0)] = cljs$core$async$state_machine__16792__auto__);

(statearr_18796[(1)] = (1));

return statearr_18796;
});
var cljs$core$async$state_machine__16792__auto____1 = (function (state_18773){
while(true){
var ret_value__16793__auto__ = (function (){try{while(true){
var result__16794__auto__ = switch__16791__auto__(state_18773);
if(cljs.core.keyword_identical_QMARK_(result__16794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16794__auto__;
}
break;
}
}catch (e18797){if((e18797 instanceof Object)){
var ex__16795__auto__ = e18797;
var statearr_18798_18816 = state_18773;
(statearr_18798_18816[(5)] = ex__16795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18773);

return cljs.core.cst$kw$recur;
} else {
throw e18797;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16793__auto__,cljs.core.cst$kw$recur)){
var G__18817 = state_18773;
state_18773 = G__18817;
continue;
} else {
return ret_value__16793__auto__;
}
break;
}
});
cljs$core$async$state_machine__16792__auto__ = function(state_18773){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16792__auto____1.call(this,state_18773);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16792__auto____0;
cljs$core$async$state_machine__16792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16792__auto____1;
return cljs$core$async$state_machine__16792__auto__;
})()
;})(switch__16791__auto__,c__16893__auto___18801,out))
})();
var state__16895__auto__ = (function (){var statearr_18799 = (f__16894__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16894__auto__.cljs$core$IFn$_invoke$arity$0() : f__16894__auto__.call(null));
(statearr_18799[(6)] = c__16893__auto___18801);

return statearr_18799;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16895__auto__);
});})(c__16893__auto___18801,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

