// Compiled by ClojureScript 1.9.946 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('cljs_http.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.net.EventType');
goog.require('goog.net.ErrorCode');
goog.require('goog.net.XhrIo');
goog.require('goog.net.Jsonp');
goog.require('cljs_http.util');
goog.require('cljs.core.async');
goog.require('clojure.string');
cljs_http.core.pending_requests = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
/**
 * Attempt to close the given channel and abort the pending HTTP request
 *   with which it is associated.
 */
cljs_http.core.abort_BANG_ = (function cljs_http$core$abort_BANG_(channel){
var temp__5457__auto__ = (function (){var fexpr__24263 = cljs.core.deref(cljs_http.core.pending_requests);
return (fexpr__24263.cljs$core$IFn$_invoke$arity$1 ? fexpr__24263.cljs$core$IFn$_invoke$arity$1(channel) : fexpr__24263.call(null,channel));
})();
if(cljs.core.truth_(temp__5457__auto__)){
var req = temp__5457__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

cljs.core.async.close_BANG_(channel);

if(cljs.core.truth_(req.hasOwnProperty("abort"))){
return req.abort();
} else {
return cljs.core.cst$kw$jsonp.cljs$core$IFn$_invoke$arity$1(req).cancel(cljs.core.cst$kw$request.cljs$core$IFn$_invoke$arity$1(req));
}
} else {
return null;
}
});
cljs_http.core.aborted_QMARK_ = (function cljs_http$core$aborted_QMARK_(xhr){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(xhr.getLastErrorCode(),goog.net.ErrorCode.ABORT);
});
/**
 * Takes an XhrIo object and applies the default-headers to it.
 */
cljs_http.core.apply_default_headers_BANG_ = (function cljs_http$core$apply_default_headers_BANG_(xhr,headers){
var formatted_h = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.util.camelize,cljs.core.keys(headers)),cljs.core.vals(headers));
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (formatted_h){
return (function (p__24264){
var vec__24265 = p__24264;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24265,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24265,(1),null);
return xhr.headers.set(k,v);
});})(formatted_h))
,formatted_h));
});
/**
 * Takes an XhrIo object and sets response-type if not nil.
 */
cljs_http.core.apply_response_type_BANG_ = (function cljs_http$core$apply_response_type_BANG_(xhr,response_type){
return xhr.setResponseType((function (){var G__24268 = response_type;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$array_DASH_buffer,G__24268)){
return goog.net.XhrIo.ResponseType.ARRAY_BUFFER;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$blob,G__24268)){
return goog.net.XhrIo.ResponseType.BLOB;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$document,G__24268)){
return goog.net.XhrIo.ResponseType.DOCUMENT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$text,G__24268)){
return goog.net.XhrIo.ResponseType.TEXT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$default,G__24268)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,G__24268)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__24268)].join('')));

}
}
}
}
}
}
})());
});
/**
 * Builds an XhrIo object from the request parameters.
 */
cljs_http.core.build_xhr = (function cljs_http$core$build_xhr(p__24269){
var map__24270 = p__24269;
var map__24270__$1 = ((((!((map__24270 == null)))?((((map__24270.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24270.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24270):map__24270);
var request = map__24270__$1;
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24270__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var default_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24270__$1,cljs.core.cst$kw$default_DASH_headers);
var response_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24270__$1,cljs.core.cst$kw$response_DASH_type);
var timeout = (function (){var or__8808__auto__ = cljs.core.cst$kw$timeout.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__8808__auto__)){
return or__8808__auto__;
} else {
return (0);
}
})();
var send_credentials = (((with_credentials_QMARK_ == null))?true:with_credentials_QMARK_);
var G__24272 = (new goog.net.XhrIo());
cljs_http.core.apply_default_headers_BANG_(G__24272,default_headers);

cljs_http.core.apply_response_type_BANG_(G__24272,response_type);

G__24272.setTimeoutInterval(timeout);

G__24272.setWithCredentials(send_credentials);

return G__24272;
});
cljs_http.core.error_kw = cljs.core.PersistentHashMap.fromArrays([(0),(7),(1),(4),(6),(3),(2),(9),(5),(8)],[cljs.core.cst$kw$no_DASH_error,cljs.core.cst$kw$abort,cljs.core.cst$kw$access_DASH_denied,cljs.core.cst$kw$custom_DASH_error,cljs.core.cst$kw$http_DASH_error,cljs.core.cst$kw$ff_DASH_silent_DASH_error,cljs.core.cst$kw$file_DASH_not_DASH_found,cljs.core.cst$kw$offline,cljs.core.cst$kw$exception,cljs.core.cst$kw$timeout]);
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.xhr = (function cljs_http$core$xhr(p__24273){
var map__24274 = p__24273;
var map__24274__$1 = ((((!((map__24274 == null)))?((((map__24274.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24274.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24274):map__24274);
var request = map__24274__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24274__$1,cljs.core.cst$kw$request_DASH_method);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24274__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24274__$1,cljs.core.cst$kw$body);
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24274__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24274__$1,cljs.core.cst$kw$cancel);
var progress = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24274__$1,cljs.core.cst$kw$progress);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var request_url = cljs_http.util.build_url(request);
var method = cljs.core.name((function (){var or__8808__auto__ = request_method;
if(cljs.core.truth_(or__8808__auto__)){
return or__8808__auto__;
} else {
return cljs.core.cst$kw$get;
}
})());
var headers__$1 = cljs_http.util.build_headers(headers);
var xhr = cljs_http.core.build_xhr(request);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,xhr);

xhr.listen(goog.net.EventType.COMPLETE,((function (channel,request_url,method,headers__$1,xhr,map__24274,map__24274__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (evt){
var target = evt.target;
var response = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$status,target.getStatus(),cljs.core.cst$kw$success,target.isSuccess(),cljs.core.cst$kw$body,target.getResponse(),cljs.core.cst$kw$headers,cljs_http.util.parse_headers(target.getAllResponseHeaders()),cljs.core.cst$kw$trace_DASH_redirects,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_url,target.getLastUri()], null),cljs.core.cst$kw$error_DASH_code,(function (){var G__24276 = target.getLastErrorCode();
return (cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1 ? cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1(G__24276) : cljs_http.core.error_kw.call(null,G__24276));
})(),cljs.core.cst$kw$error_DASH_text,target.getLastError()], null);
if(cljs.core.not(cljs_http.core.aborted_QMARK_(xhr))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,request_url,method,headers__$1,xhr,map__24274,map__24274__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
);

if(cljs.core.truth_(progress)){
var listener_24299 = ((function (channel,request_url,method,headers__$1,xhr,map__24274,map__24274__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (direction,evt){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(progress,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$direction,direction,cljs.core.cst$kw$loaded,evt.loaded], null),(cljs.core.truth_(evt.lengthComputable)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$total,evt.total], null):null)], 0)));
});})(channel,request_url,method,headers__$1,xhr,map__24274,map__24274__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
;
var G__24277_24300 = xhr;
G__24277_24300.setProgressEventsEnabled(true);

G__24277_24300.listen(goog.net.EventType.UPLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_24299,cljs.core.cst$kw$upload));

G__24277_24300.listen(goog.net.EventType.DOWNLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_24299,cljs.core.cst$kw$download));

} else {
}

xhr.send(request_url,method,body,headers__$1);

if(cljs.core.truth_(cancel)){
var c__22336__auto___24301 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__22336__auto___24301,channel,request_url,method,headers__$1,xhr,map__24274,map__24274__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (){
var f__22337__auto__ = (function (){var switch__22234__auto__ = ((function (c__22336__auto___24301,channel,request_url,method,headers__$1,xhr,map__24274,map__24274__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (state_24288){
var state_val_24289 = (state_24288[(1)]);
if((state_val_24289 === (1))){
var state_24288__$1 = state_24288;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24288__$1,(2),cancel);
} else {
if((state_val_24289 === (2))){
var inst_24279 = (state_24288[(2)]);
var inst_24280 = xhr.isComplete();
var inst_24281 = cljs.core.not(inst_24280);
var state_24288__$1 = (function (){var statearr_24290 = state_24288;
(statearr_24290[(7)] = inst_24279);

return statearr_24290;
})();
if(inst_24281){
var statearr_24291_24302 = state_24288__$1;
(statearr_24291_24302[(1)] = (3));

} else {
var statearr_24292_24303 = state_24288__$1;
(statearr_24292_24303[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24289 === (3))){
var inst_24283 = xhr.abort();
var state_24288__$1 = state_24288;
var statearr_24293_24304 = state_24288__$1;
(statearr_24293_24304[(2)] = inst_24283);

(statearr_24293_24304[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24289 === (4))){
var state_24288__$1 = state_24288;
var statearr_24294_24305 = state_24288__$1;
(statearr_24294_24305[(2)] = null);

(statearr_24294_24305[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24289 === (5))){
var inst_24286 = (state_24288[(2)]);
var state_24288__$1 = state_24288;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24288__$1,inst_24286);
} else {
return null;
}
}
}
}
}
});})(c__22336__auto___24301,channel,request_url,method,headers__$1,xhr,map__24274,map__24274__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
;
return ((function (switch__22234__auto__,c__22336__auto___24301,channel,request_url,method,headers__$1,xhr,map__24274,map__24274__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function() {
var cljs_http$core$xhr_$_state_machine__22235__auto__ = null;
var cljs_http$core$xhr_$_state_machine__22235__auto____0 = (function (){
var statearr_24295 = [null,null,null,null,null,null,null,null];
(statearr_24295[(0)] = cljs_http$core$xhr_$_state_machine__22235__auto__);

(statearr_24295[(1)] = (1));

return statearr_24295;
});
var cljs_http$core$xhr_$_state_machine__22235__auto____1 = (function (state_24288){
while(true){
var ret_value__22236__auto__ = (function (){try{while(true){
var result__22237__auto__ = switch__22234__auto__(state_24288);
if(cljs.core.keyword_identical_QMARK_(result__22237__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__22237__auto__;
}
break;
}
}catch (e24296){if((e24296 instanceof Object)){
var ex__22238__auto__ = e24296;
var statearr_24297_24306 = state_24288;
(statearr_24297_24306[(5)] = ex__22238__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_24288);

return cljs.core.cst$kw$recur;
} else {
throw e24296;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__22236__auto__,cljs.core.cst$kw$recur)){
var G__24307 = state_24288;
state_24288 = G__24307;
continue;
} else {
return ret_value__22236__auto__;
}
break;
}
});
cljs_http$core$xhr_$_state_machine__22235__auto__ = function(state_24288){
switch(arguments.length){
case 0:
return cljs_http$core$xhr_$_state_machine__22235__auto____0.call(this);
case 1:
return cljs_http$core$xhr_$_state_machine__22235__auto____1.call(this,state_24288);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs_http$core$xhr_$_state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$xhr_$_state_machine__22235__auto____0;
cljs_http$core$xhr_$_state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$xhr_$_state_machine__22235__auto____1;
return cljs_http$core$xhr_$_state_machine__22235__auto__;
})()
;})(switch__22234__auto__,c__22336__auto___24301,channel,request_url,method,headers__$1,xhr,map__24274,map__24274__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
})();
var state__22338__auto__ = (function (){var statearr_24298 = (f__22337__auto__.cljs$core$IFn$_invoke$arity$0 ? f__22337__auto__.cljs$core$IFn$_invoke$arity$0() : f__22337__auto__.call(null));
(statearr_24298[(6)] = c__22336__auto___24301);

return statearr_24298;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__22338__auto__);
});})(c__22336__auto___24301,channel,request_url,method,headers__$1,xhr,map__24274,map__24274__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
);

} else {
}

return channel;
});
/**
 * Execute the JSONP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.jsonp = (function cljs_http$core$jsonp(p__24308){
var map__24309 = p__24308;
var map__24309__$1 = ((((!((map__24309 == null)))?((((map__24309.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24309.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24309):map__24309);
var request = map__24309__$1;
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24309__$1,cljs.core.cst$kw$timeout);
var callback_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24309__$1,cljs.core.cst$kw$callback_DASH_name);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24309__$1,cljs.core.cst$kw$cancel);
var keywordize_keys_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__24309__$1,cljs.core.cst$kw$keywordize_DASH_keys_QMARK_,true);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var jsonp = (new goog.net.Jsonp(cljs_http.util.build_url(request),callback_name));
jsonp.setRequestTimeout(timeout);

var req_24322 = jsonp.send(null,((function (channel,jsonp,map__24309,map__24309__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function cljs_http$core$jsonp_$_success_callback(data){
var response = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(200),cljs.core.cst$kw$success,true,cljs.core.cst$kw$body,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,keywordize_keys_QMARK_], 0))], null);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp,map__24309,map__24309__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
,((function (channel,jsonp,map__24309,map__24309__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function cljs_http$core$jsonp_$_error_callback(){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp,map__24309,map__24309__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$jsonp,jsonp,cljs.core.cst$kw$request,req_24322], null));

if(cljs.core.truth_(cancel)){
var c__22336__auto___24323 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__22336__auto___24323,req_24322,channel,jsonp,map__24309,map__24309__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function (){
var f__22337__auto__ = (function (){var switch__22234__auto__ = ((function (c__22336__auto___24323,req_24322,channel,jsonp,map__24309,map__24309__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function (state_24315){
var state_val_24316 = (state_24315[(1)]);
if((state_val_24316 === (1))){
var state_24315__$1 = state_24315;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24315__$1,(2),cancel);
} else {
if((state_val_24316 === (2))){
var inst_24312 = (state_24315[(2)]);
var inst_24313 = jsonp.cancel(req_24322);
var state_24315__$1 = (function (){var statearr_24317 = state_24315;
(statearr_24317[(7)] = inst_24312);

return statearr_24317;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_24315__$1,inst_24313);
} else {
return null;
}
}
});})(c__22336__auto___24323,req_24322,channel,jsonp,map__24309,map__24309__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
;
return ((function (switch__22234__auto__,c__22336__auto___24323,req_24322,channel,jsonp,map__24309,map__24309__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function() {
var cljs_http$core$jsonp_$_state_machine__22235__auto__ = null;
var cljs_http$core$jsonp_$_state_machine__22235__auto____0 = (function (){
var statearr_24318 = [null,null,null,null,null,null,null,null];
(statearr_24318[(0)] = cljs_http$core$jsonp_$_state_machine__22235__auto__);

(statearr_24318[(1)] = (1));

return statearr_24318;
});
var cljs_http$core$jsonp_$_state_machine__22235__auto____1 = (function (state_24315){
while(true){
var ret_value__22236__auto__ = (function (){try{while(true){
var result__22237__auto__ = switch__22234__auto__(state_24315);
if(cljs.core.keyword_identical_QMARK_(result__22237__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__22237__auto__;
}
break;
}
}catch (e24319){if((e24319 instanceof Object)){
var ex__22238__auto__ = e24319;
var statearr_24320_24324 = state_24315;
(statearr_24320_24324[(5)] = ex__22238__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_24315);

return cljs.core.cst$kw$recur;
} else {
throw e24319;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__22236__auto__,cljs.core.cst$kw$recur)){
var G__24325 = state_24315;
state_24315 = G__24325;
continue;
} else {
return ret_value__22236__auto__;
}
break;
}
});
cljs_http$core$jsonp_$_state_machine__22235__auto__ = function(state_24315){
switch(arguments.length){
case 0:
return cljs_http$core$jsonp_$_state_machine__22235__auto____0.call(this);
case 1:
return cljs_http$core$jsonp_$_state_machine__22235__auto____1.call(this,state_24315);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs_http$core$jsonp_$_state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$jsonp_$_state_machine__22235__auto____0;
cljs_http$core$jsonp_$_state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$jsonp_$_state_machine__22235__auto____1;
return cljs_http$core$jsonp_$_state_machine__22235__auto__;
})()
;})(switch__22234__auto__,c__22336__auto___24323,req_24322,channel,jsonp,map__24309,map__24309__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
})();
var state__22338__auto__ = (function (){var statearr_24321 = (f__22337__auto__.cljs$core$IFn$_invoke$arity$0 ? f__22337__auto__.cljs$core$IFn$_invoke$arity$0() : f__22337__auto__.call(null));
(statearr_24321[(6)] = c__22336__auto___24323);

return statearr_24321;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__22338__auto__);
});})(c__22336__auto___24323,req_24322,channel,jsonp,map__24309,map__24309__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
);

} else {
}

return channel;
});
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.request = (function cljs_http$core$request(p__24326){
var map__24327 = p__24326;
var map__24327__$1 = ((((!((map__24327 == null)))?((((map__24327.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24327.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24327):map__24327);
var request = map__24327__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24327__$1,cljs.core.cst$kw$request_DASH_method);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(request_method,cljs.core.cst$kw$jsonp)){
return cljs_http.core.jsonp(request);
} else {
return cljs_http.core.xhr(request);
}
});
